! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(AbstractDictionary
	_newKernelSubclass:'Dictionary'
	instVarNames: #(count tableSize emptySlotHint numEmptySlots unused)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 101377
)
		category: nil;
		comment: 'Dictionary is a concrete subclass of AbstractDictionary.  In each Dictionary,
 all keys should be of the same class.

 A Dictionary stores key-value pairs as instances of class Association, and is
 therefore a collection of Associations.  As a result, a Dictionary has two
 kinds of instance protocols:

 * Methods that view the Dictionary as key/value pairs.
 * Methods that involve the Association objects themselves.

 A Dictionary is also an equality-based collection.  That is, two keys or two
 values are considered to be the same if they are equivalent; they need not be
 identical to be the same.  Thus, if you add two key-value pairs to a Dictionary
 but the keys are equivalent, even if they are not identical, then the result is
 that the second pair overwrites the first one, because the keys are the same.

 Some other kinds of dictionaries do not store key-value pairs as Associations.
 Still other kinds are identity-based rather than equality-based.  These other
 kinds of dictionaries exhibit better performance than Dictionary and are to be
 preferred where they are appropriate.

 WARNING: do not implement subclasses of Dictionary that use the implementation
 of Dictionary and compare keys by Identity.  All identity based dictionary
 classes must be a subclass of IdentityKeyValueDictionary or IdentityDictionary
 in order for GemStone''s Symbol canonicalization to work properly.

Constraints:
	count: SmallInteger
	tableSize: SmallInteger
	emptySlotHint: SmallInteger
	numEmptySlots: SmallInteger
	unused: Object

--- instVar count
A SmallInteger, the number of Associations in the instance.

--- instVar emptySlotHint
A SmallInteger, for GemStone internal use.

--- instVar numEmptySlots
A SmallInteger, for GemStone internal use.

--- instVar tableSize
A SmallInteger, the size of an internal table for storing elements.
';
		immediateInvariant.
true.
%

removeallmethods Dictionary
removeallclassmethods Dictionary

doit
(AbstractDictionary
	_newKernelSubclass:'RcKeyValueDictionary'
	instVarNames: #(_indexedPaths collisionLimitPerBucket)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 87297
)
		category: nil;
		comment: 'RcKeyValueDictionary is an AbstractDictionary that shares many of the protocols
 and characteristics of KeyValueDictionary.  Like all dictionaries, it stores
 key/value pairs.  In an RcKeyValueDictionary, keys may be of mixed classes.

 Like KeyValueDictionary, RcKeyValueDictionary stores key/value pairs under an
 index that is generated by applying a hash function to the key; it does not use
 Associations.  The hashing improves retrieval speed.  However, you must observe
 an important restriction: after a key/value pair has been added to an
 RcKeyValueDictionary, you must not modify the key.  Doing so renders the value
 inaccessible.

 An RcKeyValueDictionary is also an equality-based collection.  That is, two
 keys or two values are considered to be the same if they are equivalent; they
 need not be identical to be the same.  Thus, if you add two key-value pairs to
 an RcKeyValueDictionary but the keys are equivalent, even if they are not
 identical, then the result is that the second pair overwrites the first one,
 because the keys are the same.

 However, unlike KeyValueDictionary, RcKeyValueDictionary provides for
 concurrent handling of an individual instance by multiple sessions.  Any or all
 of those sessions can modify the single instance.  When that happens,
 RcKeyValueDictionary also reduces (but does not eliminate) the transaction
 conflicts that can arise among those sessions when they attempt to commit the
 instance to GemStone.

 Commit Conflicts.

 In general, RcKeyValueDictionaries do not cause concurrency conflicts for write
 operations that are commutative (operations that can be performed in any order
 without affecting the final GemStone state).  However, under some circumstances
 a user may experience conflict for commutative operations when the basicSize of
 the dictionary is too small (relative to the number of write operations
 performed in a transaction).  This can be avoided by creating a larger
 dictionary with the new: method, or increasing an existing dictionary''s size
 with the rebuildTable: method.

 If multiple users change values for different keys in a single
 RcKeyValueDictionary, the changes do not usually cause conflicts at commit
 time.  However, there is a (narrow and uncommon) window of time over which
 users have no control during which such a set of changes could result in
 conflicts.

Constraints:
	_indexedPaths: Object
	collisionLimitPerBucket: SmallInteger
	[elements]: RcCollisionBucket

instVar collisionLimitPerBucket -- A SmallInteger that represents the number 
 of collisions allowed in a bucket before rebuilding the hash table.';
		immediateInvariant.
true.
%

removeallmethods RcKeyValueDictionary
removeallclassmethods RcKeyValueDictionary

doit
(RcKeyValueDictionary
	_newKernelSubclass:'RcIndexDictionary'
	instVarNames: #(okToUpdate entryHolders workingSetInterval)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 87809
)
		category: nil;
		comment: 'RcIndexDictionary implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.

Constraints:
	_indexedPaths: Object
	collisionLimitPerBucket: SmallInteger
	okToUpdate: Object
	entryHolders: Object
	workingSetInterval: Object
	[elements]: RcIndexBucketWithCache';
		immediateInvariant.
true.
%

removeallmethods RcIndexDictionary
removeallclassmethods RcIndexDictionary

doit
(Array
	_newKernelSubclass:'BtreeNode'
	instVarNames: #(numElements)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 86017
)
		category: nil;
		comment: 'The class BtreeNode implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended 
for customer use, by creating instances or by subclassing.

BtreeNode is the most general class for representing an node within a B-tree.

instVar numElements is the number of elements contained in the node.
';
		immediateInvariant.
true.
%

removeallmethods BtreeNode
removeallclassmethods BtreeNode

doit
(BtreeNode
	_newKernelSubclass:'BtreeInteriorNode'
	instVarNames: #(lastValue)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 86273
)
		category: nil;
		comment: 'A BtreeInteriorNode represents an interior node within a B-tree.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger
	lastValue: Object

instvar lastValue -- The value of the last element contained in the node.
';
		immediateInvariant.
true.
%

removeallmethods BtreeInteriorNode
removeallclassmethods BtreeInteriorNode

doit
(BtreeInteriorNode
	_newKernelSubclass:'BtreeBasicInteriorNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 86785
)
		category: nil;
		comment: 'The class BtreeInteriorNode implements only GemStone internals.  That is, it 
 provides only functionality required by GemStone itself.  It is not intended 
 for customer use, by creating instances or by subclassing.

 A BtreeBasicInteriorNode represents an interior node of a B-tree for which a
 binary search can be done for a key.

Constraints:
	numElements: SmallInteger
	lastValue: Object';
		immediateInvariant.
true.
%

removeallmethods BtreeBasicInteriorNode
removeallclassmethods BtreeBasicInteriorNode

doit
(BtreeBasicInteriorNode
	_newKernelSubclass:'RcBtreeBasicInteriorNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 124929
)
		category: nil;
		comment: 'A RcBtreeBasicInteriorNode represents an interior node of a B-tree for which a
binary search can be done for a key. Updates to instances of this class are 
logged and can  be replayed in the case of commit conflicts.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger
	lastValue: Object';
		immediateInvariant.
true.
%

removeallmethods RcBtreeBasicInteriorNode
removeallclassmethods RcBtreeBasicInteriorNode

doit
(BtreeInteriorNode
	_newKernelSubclass:'RcBtreeInteriorNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 125697
)
		category: nil;
		comment: 'A RcBtreeInteriorNode represents an interior node of a B-tree for which a
binary search can be done for a key. Updates to instances of this class are 
logged and can  be replayed in the case of commit conflicts.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger
	lastValue: Object';
		immediateInvariant.
true.
%

removeallmethods RcBtreeInteriorNode
removeallclassmethods RcBtreeInteriorNode

doit
(BtreeNode
	_newKernelSubclass:'BtreeLeafNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 86529
)
		category: nil;
		comment: 'The class BtreeLeafNode implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended 
for customer use, by creating instances or by subclassing.

A BtreeLeafNode represents an exterior node of a B-tree.
';
		immediateInvariant.
true.
%

removeallmethods BtreeLeafNode
removeallclassmethods BtreeLeafNode

doit
(BtreeLeafNode
	_newKernelSubclass:'BtreeBasicLeafNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 87041
)
		category: nil;
		comment: 'The class BtreeBasicLeafNode implements only GemStone internals.  That is, it 
 provides only functionality required by GemStone itself.  It is not intended for 
 customer use, by creating instances or by subclassing.

 A BtreeBasicLeafNode represents an exterior node of a B-tree for which a binary
 search can be done for a key.

Constraints:
	numElements: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods BtreeBasicLeafNode
removeallclassmethods BtreeBasicLeafNode

doit
(BtreeBasicLeafNode
	_newKernelSubclass:'RcBtreeBasicLeafNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 125185
)
		category: nil;
		comment: 'A RcBtreeBasicLeafNode represents an exterior node of a B-tree for which a binary
search can be done for a key. Updates to instances of this class are logged and 
can  be replayed in the case of commit conflicts.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods RcBtreeBasicLeafNode
removeallclassmethods RcBtreeBasicLeafNode

doit
(BtreeLeafNode
	_newKernelSubclass:'IdentityBtreeNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 111873
)
		category: nil;
		comment: 'The class IdentityBtreeNode implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing..

ObsoleteIDX.

An IdentityBtreeNode is a BtreeLeafNode that supports identity comparisons on
its keys.

Constraints:
	numElements: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods IdentityBtreeNode
removeallclassmethods IdentityBtreeNode

doit
(BtreeLeafNode
	_newKernelSubclass:'RcBtreeLeafNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 125953
)
		category: nil;
		comment: 'A RcBtreeLeafNode represents an exterior node of a B-tree for which a binary
search can be done for a key. Updates to instances of this class are logged and 
can  be replayed in the case of commit conflicts.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods RcBtreeLeafNode
removeallclassmethods RcBtreeLeafNode

doit
(BtreeLeafNode
	_newKernelSubclass:'SortNode'
	instVarNames: #(pathSorter sortLevel totalElements)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 95745
)
		category: nil;
		comment: 'A SortNode is a BtreeBasicLeafNode that can sort node entries by index path.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger
	pathSorter: Object
	sortLevel: Object
	totalElements: Object';
		immediateInvariant.
true.
%

removeallmethods SortNode
removeallclassmethods SortNode

doit
(SortNode
	_newKernelSubclass:'BasicSortNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 96001
)
		category: nil;
		comment: 'The class BasicSortNode implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended 
for customer use, by creating instances or by subclassing.

BasicSortNode is a class for leaf nodes that implements a binary insertion
sort and utilizes an encryption for fast comparisons.
';
		immediateInvariant.
true.
%

removeallmethods BasicSortNode
removeallclassmethods BasicSortNode

doit
(Array
	_newKernelSubclass:'DependencyList'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 89601
)
		category: nil;
		comment: 'The class DependencyList implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended 
for customer use, by creating instances or by subclassing.
';
		immediateInvariant.
true.
%

removeallmethods DependencyList
removeallclassmethods DependencyList

doit
(Array
	_newKernelSubclass:'DepListBucket'
	instVarNames: #(numElements)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 107009
)
		category: nil;
		comment: 'The class DependencyListBucket implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended for 
customer use, by creating instances or by subclassing.

A DepListBucket is a collision bucket for a DepListTable.';
		immediateInvariant.
true.
%

removeallmethods DepListBucket
removeallclassmethods DepListBucket

doit
(Array
	_newKernelSubclass:'IdentityIndex'
	instVarNames: #(indexDictionary nscRoot rcRangeBucket isComplete progress)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 88577
)
		category: nil;
		comment: 'IdentityIndex implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.

Constraints:
	indexDictionary: RcIndexDictionary
	nscRoot: UnorderedCollection
	rcRangeBucket: Object
	isComplete: Object
	progress: Object
	[elements]: PathTerm
';
		immediateInvariant.
true.
%

removeallmethods IdentityIndex
removeallclassmethods IdentityIndex

doit
(IdentityIndex
	_newKernelSubclass:'RangeEqualityIndex'
	instVarNames: #(btreeRoot lastElementClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 88833
)
		category: nil;
		comment: 'The class RangeEqualityIndex implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended for 
customer use, by creating instances or by subclassing.
 
Constraints:
	indexDictionary: RcIndexDictionary
	nscRoot: UnorderedCollection
	rcRangeBucket: Object
	isComplete: Object
	progress: Object
	btreeRoot: Object
	lastElementClass: Object
	[elements]: PathTerm
';
		immediateInvariant.
true.
%

removeallmethods RangeEqualityIndex
removeallclassmethods RangeEqualityIndex

doit
(RangeEqualityIndex
	_newKernelSubclass:'RcRangeEqualityIndex'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 125441
)
		category: nil;
		comment: 'RcRangeEqualityIndex implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.

Constraints:
	indexDictionary: RcIndexDictionary
	nscRoot: UnorderedCollection
	rcRangeBucket: Object
	isComplete: Object
	progress: Object
	btreeRoot: Object
	lastElementClass: Object
	[elements]: PathTerm';
		immediateInvariant.
true.
%

removeallmethods RcRangeEqualityIndex
removeallclassmethods RcRangeEqualityIndex

doit
(RcRangeEqualityIndex
	subclass: 'RcUnicodeRangeEqualityIndex'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'RcUnicodeRangeEqualityIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods RcUnicodeRangeEqualityIndex
removeallclassmethods RcUnicodeRangeEqualityIndex

doit
(RangeEqualityIndex
	subclass: 'UnicodeRangeEqualityIndex'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'UnicodeRangeEqualityIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods UnicodeRangeEqualityIndex
removeallclassmethods UnicodeRangeEqualityIndex

doit
(Array
	_newKernelSubclass:'IndexDictionaryEntryHolder'
	instVarNames: #(indexDictionary link offset count)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 104449
)
		category: nil;
		comment: 'IndexDictionaryEntryHolder implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.
';
		immediateInvariant.
true.
%

removeallmethods IndexDictionaryEntryHolder
removeallclassmethods IndexDictionaryEntryHolder

doit
(Array
	_newKernelSubclass:'IndexList'
	instVarNames: #(isConstrained rootTerms securityPolicies)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 89345
)
		category: nil;
		comment: 'The class IndexList implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.

Constraints:
	isConstrained: Boolean
	rootTerms: Object
	securityPolicies: Object';
		immediateInvariant.
true.
%

removeallmethods IndexList
removeallclassmethods IndexList

doit
(Array
	subclass: 'PathEvaluator'
	instVarNames: #(nsc ivOffsets collator doBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'The class PathEvaluator implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended 
for customer use, by creating instances or by subclassing.
 
Constraints:
	nsc: Collection
	ivOffsets: Array
	constraintClasses: (obsolete) Array
';
		immediateInvariant.
true.
%

removeallmethods PathEvaluator
removeallclassmethods PathEvaluator

doit
(PathEvaluator
	subclass: 'CollectionBasedPathEvaluator'
	instVarNames: #(pathTermsRequired)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Index-Evaluators';
		comment: 'CollectionBasedPathEvaluator is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods CollectionBasedPathEvaluator
removeallclassmethods CollectionBasedPathEvaluator

doit
(CollectionBasedPathEvaluator
	subclass: 'SetValuedPathEvaluator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'SetValuedPathEvaluator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods SetValuedPathEvaluator
removeallclassmethods SetValuedPathEvaluator

doit
(Array
	subclass: 'PathSorter'
	instVarNames: #(sortNodes directions incompletes lastNodeOffset collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'PathSorter implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.

Constraints:
	sortNodes: Array
	directions: Object
	incompletes: Object
	lastNodeOffset: Object';
		immediateInvariant.
true.
%

removeallmethods PathSorter
removeallclassmethods PathSorter

doit
(Array
	_newKernelSubclass:'PathTerm'
	instVarNames: #(name offset securityPolicies children updateBtree updateDict needsDepList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 89089
)
		category: nil;
		comment: '
PathTerm represents a single term/instance variable within an index or query
path. PathTerm provides a simple case; subclasses of PathTerm are used for 
specialized features, such as set-valued paths. 

PathTerm implements only GemStone internals, and is not intended for direct use
by customers. 

Constraints:
	name: CharacterCollection
	offset: SmallInteger
	securityPolicies: Object
	children: Object
	updateBtree: Object
	updateDict: Object
	needsDepList: Boolean';
		immediateInvariant.
true.
%

removeallmethods PathTerm
removeallclassmethods PathTerm

doit
(PathTerm
	subclass: 'CollectionBasedPathTerm'
	instVarNames: #(requirePathTerms)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
CollectionBasedPathTerm is an abstract superclass for classes that represents a term within an index or query path that
is a collection. 

CollectionBasedPathTerm implements only GemStone internals, and is not intended for direct use
by customers.
';
		immediateInvariant.
true.
%

removeallmethods CollectionBasedPathTerm
removeallclassmethods CollectionBasedPathTerm

doit
(CollectionBasedPathTerm
	subclass: 'EnumeratedPathTerm'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
EnumeratedPathTerm represents a single term within an index or query path.  It represents a term in which multiple 
instance variables are included, as specified by var1|var2 in the index or query path. 

EnumeratedPathTerm implements only GemStone internals, and is not intended for direct use
by customers.
';
		immediateInvariant.
true.
%

removeallmethods EnumeratedPathTerm
removeallclassmethods EnumeratedPathTerm

doit
(CollectionBasedPathTerm
	subclass: 'SetValuedPathTerm'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
SetValuedPathTerm is a subclass of PathTerm that implements set-valued path terms, represented
by a * in the path.

SetValuedPathTerm implements only GemStone internals, and is not intended for direct use
by customers.';
		immediateInvariant.
true.
%

removeallmethods SetValuedPathTerm
removeallclassmethods SetValuedPathTerm

doit
(PathTerm
	subclass: 'OptionalPathTerm'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
OptionalPathTerm represents a single term/instance variable within an index or query
path, in which is it not required that the instance variable be present on the instances of
the referencing class.  This supports the optionPathTerms query and index features.

OptionalPathTerm implements only GemStone internals, and is not intended for direct use
by customers.
';
		immediateInvariant.
true.
%

removeallmethods OptionalPathTerm
removeallclassmethods OptionalPathTerm

doit
(PathTerm
	subclass: 'SelectorPathTerm'
	instVarNames: #(requirePathTerms)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
SelectorPathTerm represents a single term within an index or query path.  It represents a term that is a selector rather
than an instance variable, as specified by # before the selector name within the index or query path.

SelectorPathTerm implements only GemStone internals, and is not intended for direct use by customers.
';
		immediateInvariant.
true.
%

removeallmethods SelectorPathTerm
removeallclassmethods SelectorPathTerm

doit
(Array
	_newKernelSubclass:'QueryExecuter'
	instVarNames: #(nsc selectBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 90625
)
		category: nil;
		comment: 'QueryExecutor implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.

Constraints:
	nsc: UnorderedCollection
	selectBlock: Object';
		immediateInvariant.
true.
%

removeallmethods QueryExecuter
removeallclassmethods QueryExecuter

doit
(Array
	_newKernelSubclass:'SortNodeArray'
	instVarNames: #(progress)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 107521
)
		category: nil;
		comment: 'SortNodeArray implements GemStone internals. It is not intended 
for customer use, by creating instances or by subclassing.
';
		immediateInvariant.
true.
%

removeallmethods SortNodeArray
removeallclassmethods SortNodeArray

doit
(Collection
	_newKernelSubclass:'DepListTable'
	instVarNames: #(obsoletePathTerms)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 107265
)
		category: nil;
		comment: 'The class DependencyListTable implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended 
for customer use, by creating instances or by subclassing.

A DepListTable is used to hold a global collection of DependencyLists that
are shared by multiple objects.

Constraints:
	obsoletePathTerms: Object
	[elements]: DepListBucket';
		immediateInvariant.
true.
%

removeallmethods DepListTable
removeallclassmethods DepListTable

doit
(Collection
	_newKernelSubclass:'RcQueue'
	instVarNames: #(removalSeqNumbers)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 82945
)
		category: nil;
		comment: 'An RcQueue (reduced-conflict queue) is an implementation of a FIFO queue that
 provides significantly reduced concurrency conflicts when used in an
 environment with multiple producers (users that add elements to the queue) and
 a single consumer (a user that removes items from the queue).  Producers are
 guaranteed not to conflict with each other, nor with a single consumer.  An
 RcQueue is implemented as a collection of RcQueueSessionComponents, each of
 which contains the queue elements submitted by a particular session.

Constraints:
	removalSeqNumbers: RcQueueRemovalSeqNumbers
	[elements]: RcQueueSessionComponent

instvar removalSeqNumbers -- An instance of the class RcQueueRemovalSeqNumbers 
  (essentially an Array of SmallIntegers) representing the order in which elements 
  are to be removed from the queue.

 Searching methods should be used with care because they tend to iterate 
 over the whole collection and nullify the concurrency conflict mechanisms
 built into RC classes.';
		immediateInvariant.
true.
%

removeallmethods RcQueue
removeallclassmethods RcQueue

doit
(CollisionBucket
	_newKernelSubclass:'RcCollisionBucket'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 114689
)
		category: nil;
		comment: 'The class RcCollisionBucket implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended for 
customer use, by creating instances or by subclassing.

 An RcCollisionBucket is a CollisionBucket that is used in an
 RcKeyValueDictionary to store a collection of key/value pairs for which the
 keys hash to the same value.  It provides support for the reduced-conflict
 properties of RcKeyValueDictionaries.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object
';
		immediateInvariant.
true.
%

removeallmethods RcCollisionBucket
removeallclassmethods RcCollisionBucket

doit
(RcCollisionBucket
	_newKernelSubclass:'RcIndexBucket'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 88065
)
		category: nil;
		comment: 'An RcIndexBucket is an RcCollisionBucket that is used by the indexing
subsystem to store a collection of key/value/pathTerm triples.  It provides
reduced-conflict support for indexes.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object';
		immediateInvariant.
true.
%

removeallmethods RcIndexBucket
removeallclassmethods RcIndexBucket

doit
(RcIndexBucket
	_newKernelSubclass:'RcIndexBucketWithCache'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 98561
)
		category: nil;
		comment: 'An RcIndexBucketWithCache is an RcIndexBucket that is used by the indexing
subsystem to improve indexing performance.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object';
		immediateInvariant.
true.
%

removeallmethods RcIndexBucketWithCache
removeallclassmethods RcIndexBucketWithCache

doit
(IdentityBag
	_newKernelSubclass:'BucketValueBag'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 88321
)
		category: nil;
		comment: 'The class BucketValueBag implements only GemStone internals.  That is, it 
provides only functionality required by GemStone itself.  It is not intended 
for customer use, by creating instances or by subclassing.
';
		immediateInvariant.
true.
%

removeallmethods BucketValueBag
removeallclassmethods BucketValueBag

doit
(IdentityBag
	_newKernelSubclass:'RcIdentityBag'
	instVarNames: #(components)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'traverseByCallback'  #logCreation )
	reservedOop: 105473
)
		category: nil;
		comment: 'RcIdentityBag is a special kind of IdentityBag that provides much of the same 
functionality, but with no conflict for multiple sessions that add objects to the 
bag, and a single session that removes objects. 

Internally, RcIdentityBag is internally implemented using an Array of 
IdentityBags. Each session number corresponds to two IdentityBags, one for 
additions to the RcIdentityBag, and one for removed elements. Each logged-in 
session only modifies the IdentityBags corresponding to its own session number. 
Computing the current contents of an RcIdentityBag means combining the add 
bags, and removing all the remove bags.  While some cleanup of removed 
elements is automatic, an RcIdentityBag may require periodic manual cleanup. 

instance variable (not intended for public use):
    components: Array
';
		immediateInvariant.
true.
%

removeallmethods RcIdentityBag
removeallclassmethods RcIdentityBag

doit
(IdentitySet
	_newKernelSubclass:'GsObjectSecurityPolicySet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 97025
)
		category: nil;
		comment: 'The class GsObjectSecurityPolicySet implements only GemStone internals.  That 
is, it provides only functionality required by GemStone itself.  It is not 
intended for customer use, by creating instances or by subclassing.
Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	[elements]: GsObjectSecurityPolicy';
		immediateInvariant.
true.
%

removeallmethods GsObjectSecurityPolicySet
removeallclassmethods GsObjectSecurityPolicySet

doit
(Magnitude
	subclass: 'Duration'
	instVarNames: #(seconds)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '  A Duration represents a length of time, in integer days, hours, minutes, 
  with seconds that can be integer or fractional of artibrary presicion. 

  (from ANSI).';
		immediateInvariant.
true.
%

removeallmethods Duration
removeallclassmethods Duration

doit
(Object
	subclass: 'AbstractBagEnumerator'
	instVarNames: #(bag evaluator ivOffsetCache1 ivOffsetCache2 selector doBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Index-Enumerators';
		comment: 'AbstractBagEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods AbstractBagEnumerator
removeallclassmethods AbstractBagEnumerator

doit
(AbstractBagEnumerator
	subclass: 'BagEnumerator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Index-Enumerators';
		comment: 'BagEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BagEnumerator
removeallclassmethods BagEnumerator

doit
(BagEnumerator
	subclass: 'BagUnicodeEnumerator'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Index-Enumerators';
		comment: 'BagUnicodeEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BagUnicodeEnumerator
removeallclassmethods BagUnicodeEnumerator

doit
(AbstractBagEnumerator
	subclass: 'BagRangeEnumerator'
	instVarNames: #(selector2)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Index-Enumerators';
		comment: 'BagRangeEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BagRangeEnumerator
removeallclassmethods BagRangeEnumerator

doit
(BagRangeEnumerator
	subclass: 'BagUnicodeRangeEnumerator'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Index-Enumerators';
		comment: 'BagUnicodeRangeEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BagUnicodeRangeEnumerator
removeallclassmethods BagUnicodeRangeEnumerator

doit
(AbstractBagEnumerator
	subclass: 'PathPathBagEnumerator'
	instVarNames: #(evaluator2 ivOffsetCache3 ivOffsetCache4)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Index-Enumerators';
		comment: 'PathPathBagEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods PathPathBagEnumerator
removeallclassmethods PathPathBagEnumerator

doit
(PathPathBagEnumerator
	subclass: 'PathPathBagUnicodeEnumerator'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Index-Enumerators';
		comment: 'PathPathBagUnicodeEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods PathPathBagUnicodeEnumerator
removeallclassmethods PathPathBagUnicodeEnumerator

doit
(Object
	subclass: 'AbstractIndexSpecification'
	instVarNames: #(path lastElementClass requirePathTerms)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AbstractIndexSpecification is an abstract superclass for classes that are used to specify 
the details for creating indexes. Concrete classes are used to create Equality Indexes, 
Identity Indexes, and other refinements of these indexes.

Instance variables:
path -- String describing the path of the index
lastElementClass -- Class of the last element on the path, only used for Equality indexes
requirePathTerms -- Boolean, if it is allowed for elements in the indexed collection to 
  not have an instance variable matching a term on the path.

';
		immediateInvariant.
true.
%

removeallmethods AbstractIndexSpecification
removeallclassmethods AbstractIndexSpecification

doit
(AbstractIndexSpecification
	subclass: 'EqualityIndexSpecification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'The class EqualityIndexSpecification provides details for specifying an equality index.';
		immediateInvariant.
true.
%

removeallmethods EqualityIndexSpecification
removeallclassmethods EqualityIndexSpecification

doit
(EqualityIndexSpecification
	subclass: 'RcEqualityIndexSpecification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'The class RcEqualityIndexSpecification provides details for specifying an equality index that is 
reduced conflict.';
		immediateInvariant.
true.
%

removeallmethods RcEqualityIndexSpecification
removeallclassmethods RcEqualityIndexSpecification

doit
(AbstractIndexSpecification
	subclass: 'IdentityIndexSpecification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'The class IdentityIndexSpecification provides details for specifying an identity index.';
		immediateInvariant.
true.
%

removeallmethods IdentityIndexSpecification
removeallclassmethods IdentityIndexSpecification

doit
(Object
	_newKernelSubclass:'BtreeComparisonForCompare'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 122881
)
		category: nil;
		comment: 'During btree sort and compare operations (for BtreeNode and subclasses) the exact method
 send for doing comparison operations varies depending upon whether the comparison is for 
 a sort or a query (compare). The class translates the message into a variant for comparing.';
		immediateInvariant.
true.
%

removeallmethods BtreeComparisonForCompare
removeallclassmethods BtreeComparisonForCompare

doit
(BtreeComparisonForCompare
	_newKernelSubclass:'BtreeComparisonForSort'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 122625
)
		category: nil;
		comment: 'During btree sort and compare operations (for BtreeNode and subclasses) the exact method
 send for doing comparison operations varies depending upon whether the comparison is for 
 a sort or a query (compare). The class translates the message into a variant for sorting.';
		immediateInvariant.
true.
%

removeallmethods BtreeComparisonForSort
removeallclassmethods BtreeComparisonForSort

doit
(BtreeComparisonForSort
	subclass: 'BtreeComparisonForUnicodeSort'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'BtreeComparisonForUnicodeSort is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BtreeComparisonForUnicodeSort
removeallclassmethods BtreeComparisonForUnicodeSort

doit
(BtreeComparisonForCompare
	subclass: 'BtreeComparisonForUnicodeCompare'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'BtreeComparisonForUnicodeCompare is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BtreeComparisonForUnicodeCompare
removeallclassmethods BtreeComparisonForUnicodeCompare

doit
(Object
	_newKernelSubclass:'BtreeQuerySpec'
	instVarNames: #(rangeIndex offset pathTerm)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 123393
)
		category: nil;
		comment: 'BtreeQuerySpec is an abstract class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreeNode that satisfy a particular query.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.';
		immediateInvariant.
true.
%

removeallmethods BtreeQuerySpec
removeallclassmethods BtreeQuerySpec

doit
(BtreeQuerySpec
	_newKernelSubclass:'BtreeComparisonQuerySpec'
	instVarNames: #(key opCode)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 123649
)
		category: nil;
		comment: 'BtreeComparisonQuerySpec is an concrete class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreeNode that satisfy a particular query
 based on a comparison of a single set of values.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.';
		immediateInvariant.
true.
%

removeallmethods BtreeComparisonQuerySpec
removeallclassmethods BtreeComparisonQuerySpec

doit
(BtreeComparisonQuerySpec
	_newKernelSubclass:'BtreeRangeComparisonQuerySpec'
	instVarNames: #(key2 opCode2)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 123905
)
		category: nil;
		comment: 'BtreeRangeComparisonQuerySpec is an concrete class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreeNode that satisfy a particular query
 based on comparisons between two values.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.';
		immediateInvariant.
true.
%

removeallmethods BtreeRangeComparisonQuerySpec
removeallclassmethods BtreeRangeComparisonQuerySpec

doit
(BtreeRangeComparisonQuerySpec
	_newKernelSubclass:'BtreeUnicodeRangeComparisonQuerySpec'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 155649
)
		category: nil;
		comment: 'BtreeUnicodeRangeComparisonQuerySpec is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BtreeUnicodeRangeComparisonQuerySpec
removeallclassmethods BtreeUnicodeRangeComparisonQuerySpec

doit
(BtreeComparisonQuerySpec
	_newKernelSubclass:'BtreeUnicodeComparisonQuerySpec'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 155393
)
		category: nil;
		comment: 'BtreeUnicodeComparisonQuerySpec is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BtreeUnicodeComparisonQuerySpec
removeallclassmethods BtreeUnicodeComparisonQuerySpec

doit
(Object
	subclass: 'GsPackagePolicy'
	instVarNames: #(enabled homeSymbolDict externalSymbolList authorInitials)
	classVars: #()
	classInstVars: #(restrictedClasses)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		immediateInvariant.
true.
%

removeallmethods GsPackagePolicy
removeallclassmethods GsPackagePolicy

doit
(Object
	subclass: 'IndexedQueryEvaluator'
	instVarNames: #(index doBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'IndexedQueryEvaluator is an abstract class that implements the behavior used to 
 evaluate queries against UnordedCollections that have been indexed. This class is
 used in the internal implementation of indexing and should not be modified.';
		immediateInvariant.
true.
%

removeallmethods IndexedQueryEvaluator
removeallclassmethods IndexedQueryEvaluator

doit
(IndexedQueryEvaluator
	subclass: 'EqualityIndexQueryEvaluator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'EqualityIndexQueryEvaluator is a concrete class that implements the behavior used to 
 evaluate queries against UnordedCollections that have equality indexes. This class is
 used in the internal implementation of indexing and should not be modified.';
		immediateInvariant.
true.
%

removeallmethods EqualityIndexQueryEvaluator
removeallclassmethods EqualityIndexQueryEvaluator

doit
(IndexedQueryEvaluator
	subclass: 'IdentityIndexQueryEvaluator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'IdentityIndexQueryEvaluator is a concrete class that implements the behavior used to 
 evaluate queries against UnordedCollections that have identity indexes. This class is
 used in the internal implementation of indexing and should not be modified.';
		immediateInvariant.
true.
%

removeallmethods IdentityIndexQueryEvaluator
removeallclassmethods IdentityIndexQueryEvaluator

doit
(Object
	_newKernelSubclass:'IndexManager'
	instVarNames: #(allIndexes autoCommit dirtyObjectCommitThreshold percentTempObjSpaceCommitThreshold useKeyEncryption)
	classVars: #()
	classInstVars: #(Current)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 121601
)
		category: nil;
		comment: 'IndexManager is provides protocol for managing and maintaining indexed collections.
 The single instance of IndexManager should be accessed via the class message #current.
 In normal use, you will use IndexManager to turn autoCommit for index maintenance
 operations off and on and to define the dirtyObjectCommitThreshold and 
 percentTempObjSpaceCommitThreshold, which are control parameters for autoCommit.

 Note that autoCommit will also make the system respond to TransactionBacklog 
 notifications by commiting.

 IndexManager current tracks all instances of UnorderedCollection that have had indexes
 created for them. You may use IndexManager current to #removeAllIndexes, which removes
 indexes from all indexed collections in the system or you may use IndexManager 
 current to #removeAllIncompleteIndexes, which removes partial indexes from collections
 when index creation failed without completing.

 Automatic garbage collection of unreferenced UnorderedCollections is _not_ preformed, so
 one must explicitly remove all indexes from an UnorderedCollection that is no longer used.

 IndexManager may be subclassed.';
		immediateInvariant.
true.
%

removeallmethods IndexManager
removeallclassmethods IndexManager

doit
(Object
	_newKernelSubclass:'IndexManagerAutoCommitPolicy'
	instVarNames: #(dirtyObjectCommitThreshold percentTempObjSpaceCommitThreshold)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 123137
)
		category: nil;
		comment: 'IndexManagerAutoCommitPolicy implements the behavior for determining when commits should be
 performed when the IndexManager autoCommit feature is enabled. Commits will be performed 
 whenever the number of persistent objects modified exceeds the dirtyObjectCommitThreshold or
 when the tempObjSpacePercentUsed crosses the percentTempObjSpaceCommitThreshold.

 When autoCommit is enabled, the system will also commit on TransactionBacklog notification.
';
		immediateInvariant.
true.
%

removeallmethods IndexManagerAutoCommitPolicy
removeallclassmethods IndexManagerAutoCommitPolicy

doit
(Object
	subclass: 'Message'
	instVarNames: #(selector args)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'An instance of Message represents a message, consisting of a selector and zero or more arguments.

For efficiency reasons, the system does not use instances of Message to send messages. 
However, when a message is not understood by its receiver, the system will create an instance 
of me in order to capture the information involved in an actual message transmission. 
This instance is sent it as an argument with the message doesNotUnderstand: to the receiver 
of the original message.';
		immediateInvariant.
true.
%

removeallmethods Message
removeallclassmethods Message

doit
(Object
	_newKernelIndexableSubclass:'RcCounter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 109313
)
		category: nil;
		comment: 'Like any counter, an RcCounter maintains an integral value that can be
 incremented or decremented.

 A single instance of RcCounter can be shared among multiple concurrent sessions
 without conflict.  The initial value of the RcCounter at the start of a
 transaction in any session is the last value that has been committed.  During
 their transactions, any or all sessions that share the RcCounter can modify it.
 Each session then sees a value for the RcCounter that reflects only the initial
 value from the start of its own transaction and the changes made in that
 transaction.

 When a session commits the RcCounter, the cumulative changes of other
 transactions committed since the start of the current session''s transaction
 are merged with those of the committing transaction.  No commit conflicts
 occur between the sessions.  But the count that a session sees immediately
 before its transaction is committed may not be the same as the count it sees
 immediately after.

Constraints:
	[elements]: RcCounterElement';
		immediateInvariant.
true.
%

removeallmethods RcCounter
removeallclassmethods RcCounter

doit
(Object
	subclass: 'TimeZoneInfo'
	instVarNames: #(transitions leapSeconds stream types charcnt)
	classVars: #()
	classInstVars: #(default cache)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This is the abstract superclass that contains a dialect-independent
implementation of the TimeZone behavior. It reads a binary file
generated by the Olsen ZoneInfo database.';
		immediateInvariant.
true.
%

removeallmethods TimeZoneInfo
removeallclassmethods TimeZoneInfo

doit
(TimeZoneInfo
	subclass: 'TimeZone'
	instVarNames: #(standardPrintString dstPrintString dstStartTimeList dstEndTimeList secondsForDst secondsFromGmt yearStartDst)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This provides GemStone/S overrides and extensions to the
ANSI TimeZone behavior.';
		immediateInvariant.
true.
%

removeallmethods TimeZone
removeallclassmethods TimeZone

doit
(Object
	subclass: 'TimeZoneTransition'
	instVarNames: #(transitionTime offsetFromUTC isDST abbreviation)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'Instances of this class represent records in a ZoneInfo database.
It describes characteristics of a transition to/from DST.';
		immediateInvariant.
true.
%

removeallmethods TimeZoneTransition
removeallclassmethods TimeZoneTransition

doit
(Stream
	subclass: 'BtreeReadStream'
	instVarNames: #(endNode endIndex currentStack streamQuerySpec)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'BtreeReadStream supports the composition of query results by providing access
 to a B-tree structure.

 A BtreeReadStream can read all the entries of the B-tree one at a time.  Supply
 the root node when you create the stream, and send the ''next'' message to
 read the first node.  Send the ''next'' message repeatedly to iterate over
 the B-tree''s contents, and send the ''atEnd'' message to check if there are
 any more nodes.

--- instVar currentStack
An Array of B-tree node / offset pairs.  The successive elements of the
 Array indicate the path through the B-tree to the current entry.

--- instVar endIndex
The SmallInteger index of the leaf node that is the last entry in the B-tree.

--- instVar endNode
The BtreeLeafNode that is the last entry in the B-tree.
';
		immediateInvariant.
true.
%

removeallmethods BtreeReadStream
removeallclassmethods BtreeReadStream

doit
(BtreeReadStream
	subclass: 'RangeIndexReadStream'
	instVarNames: #(rangeIndex setIterationIndexes)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'RangeIndexReadStream, like its superclass BtreeReadStream, supports the
 composition of query results by providing access to a B-tree structure.  Its
 ''next'' and ''atEnd'' methods are used the same way as those of
 BtreeReadStream in iterating through the B-tree.

 RangeIndexReadStream differs from BtreeReadStream in that it uses the reverse
 mappings to B-tree nodes that are found in a RangeEqualityIndex to obtain the
 next entry.  You can supply that index when you create the stream, and the
 index identifies the ordering used to return the entries.

Constraints:
	endNode: BtreeLeafNode
	endIndex: SmallInteger
	currentStack: Array
	rangeIndex: RangeEqualityIndex
	setIterationIndexes: Object

instvar rangeIndex - The RangeEqualityIndex for an instance of this class.

instvar setIterationIndexes -- An Array of Integers that indicates the 
  offset into BucketValueBags along the path.
';
		immediateInvariant.
true.
%

removeallmethods RangeIndexReadStream
removeallclassmethods RangeIndexReadStream

doit
(RangeIndexReadStream
	subclass: 'ReversedRangeIndexReadStream'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'ReversedRangeIndexReadStream, like its superclasses BtreeReadStream and 
 RangeIndexStream, supports the composition of query results by providing 
 access to a B-tree structure.  Its ''next'' and ''atEnd'' methods are used 
 to iterate through the B-tree. The primary difference is that the traversal
 takes place from the end of the stream to the beginning, giving one access
 to the results of a query in reverse order.';
		immediateInvariant.
true.
%

removeallmethods ReversedRangeIndexReadStream
removeallclassmethods ReversedRangeIndexReadStream

! Class implementation for 'Dictionary'

!		Class methods for 'Dictionary'

category: 'Accessing'
classmethod: Dictionary
associationClass

"Returns the class Associations for this class are constrained to be."

^ Association
%

category: 'Instance Creation'
classmethod: Dictionary
new

"Returns a new instance of Dictionary."

^ self new: 5.
%

category: 'Instance Creation'
classmethod: Dictionary
new: count

"Returns a new instance of Dictionary.  The argument count provides a hint of
 the number of elements the instance should be designed to hold.

 count should be a SmallInteger."

| dict size |

"The dictionary should have a certain minimum size and the size should
 preferably be a prime number."
size := (count <= 7) ifTrue:[ 7 ]
                     ifFalse:[ self _tableSizeFor: count ].

dict := self basicNew: (size * 3).
dict count: 0.
dict tableSize: size.
dict emptySlotHint: (size + 1).
dict numEmptySlots: size.

^ dict.
%

!		Instance methods for 'Dictionary'

category: 'Enumerating'
method: Dictionary
accompaniedBy: anObj keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 2nd and 3rd arguments.
 aBlock must be a 3 argument block, with arguments anObj, key value ."

"First iterate through the first section of the Dictionary where Associations
 are directly hashed."
1 to: tableSize do: [ :i|
  "anAssoc could be nil, a SmallInteger, or an Association"
  (self _at: i) ifNotNil:[:anAssoc |
     anAssoc _isSmallInteger ifFalse:[ 
          aBlock value: anObj value: anAssoc key value: anAssoc value]]].

"Now iterate through the collision section of the Dictionary"
(tableSize + 1) to: (self _basicSize) by: 2 do: [ :i|
   "anAssoc can only be nil or a valid Association in this section."
  (self _at: i) ifNotNil:[:anAssoc |
     aBlock value: anObj value: anAssoc key value: anAssoc value ]].
%

category: 'Adding'
method: Dictionary
add: anAssociation

"Adds the Association or to the receiver.  If the receiver already includes an
 Association/key-value pair whose key is equal to that of anAssociation, then
 this method redefines the value portion of that Association/key-value pair.
 Returns anAssociation."

| aKey hashVal anAssoc |

aKey := anAssociation key.
hashVal := self hashFunction: aKey.

anAssoc := self associationAtOrNil: aKey hash: hashVal.
(anAssoc == nil)
  ifTrue: [
    anAssociation objectSecurityPolicy: self objectSecurityPolicy .
    self addNewAssociation: anAssociation hash: hashVal.
    ^ anAssociation.
    ].

anAssoc value: (anAssociation value).
^ anAssociation.
%

category: 'Private'
method: Dictionary
addNewAssociation: anAssociation hash: aHashVal

"Adds a new Association to the Dictionary.  The hash value of the key is given
 by aHashVal.  Returns the receiver."

| anElement emptySlot emptySlot2 |

anAssociation isAssociation ifFalse:[
    ^ self _error: #objErrDictConstraintViolation
                  args: { anAssociation . Association .  anAssociation class }
    ].

anElement := self _at: aHashVal.

anElement == nil
  ifTrue: [
    self basicAt: aHashVal put: anAssociation.
    count := count + 1.
    ((numEmptySlots < (tableSize // 3)) and: [numEmptySlots < 200])
      ifTrue: [self rebuild].
    ^ self
    ].

(anElement _isSmallInteger)
  ifTrue: [
    emptySlot := self findEmptySlot.
    self basicAt: emptySlot put: anAssociation.
    self basicAt: (emptySlot + 1) put: anElement.
    self basicAt: aHashVal put: emptySlot.
    count := count + 1.
    ((numEmptySlots < (tableSize // 3)) and: [numEmptySlots < 200])
      ifTrue: [self rebuild].
    ^ self.
    ].

emptySlot := self findEmptySlot.
self basicAt: emptySlot put: anElement.
self basicAt: (emptySlot + 1) put: nil.

emptySlot2 := self findEmptySlot.
self basicAt: emptySlot2 put: anAssociation.
self basicAt: (emptySlot2 + 1) put: (emptySlot).
count := count + 1.

self basicAt: aHashVal put: emptySlot2.

((numEmptySlots < (tableSize // 3)) and: [numEmptySlots < 200])
  ifTrue: [self rebuild].
^ self.
%

category: 'Accessing'
method: Dictionary
associationAt: aKey

"Returns the Association with key aKey.  Generates an error if no such
 Association exists."

| assoc |

assoc := self associationAt: aKey otherwise: nil .
assoc == nil ifTrue:[ ^ self _errorKeyNotFound: aKey ].
^ assoc
%

category: 'Accessing'
method: Dictionary
associationAt: aKey ifAbsent: aBlock

"Returns the Association with key aKey.  If no such Association exists, returns
 the result of evaluating the zero-argument block aBlock."

| assoc |
assoc := self associationAt: aKey otherwise: nil .
assoc == nil ifTrue:[
  aBlock == nil ifTrue:[^ nil ].
  ^aBlock value
  ].
^ assoc
%

category: 'Accessing'
method: Dictionary
associationAt: aKey otherwise: defaultValue

"Returns the Association with key aKey.  If no such Association
 exists, returns the given default value."

| index anAssoc |

aKey == nil ifTrue:[ ^ defaultValue ] .

index := self hashFunction: aKey.
anAssoc := self _at: index.

(anAssoc == nil) ifTrue:[^ defaultValue ].

(anAssoc _isSmallInteger)
  "There is a collision. Follow the chain."
  ifTrue: [
    index := anAssoc.
    [index ~~ nil]
    whileTrue: [
      anAssoc := self _at: index.
      (anAssoc key = aKey)
        ifTrue: [^ anAssoc]
        ifFalse: [index := self _at: (index + 1)].
      ].
    ^ defaultValue
    ].

(anAssoc key = aKey)
  ifTrue: [ ^ anAssoc ].

^ defaultValue
%

category: 'Private'
method: Dictionary
associationAtOrNil: aKey hash: aHashVal

"Returns the Association with key aKey.  If no such Association exists, returns
 nil.  The search is only done in the hash chain that corresponds to aHashVal."

| index anAssoc |

anAssoc := self _at: aHashVal.

(anAssoc == nil) ifTrue: [ ^ nil ].

(anAssoc _isSmallInteger)
  "There is a collision. Follow the chain."
  ifTrue: [
    index := anAssoc.
    [nil ~~ index]
    whileTrue: [
      anAssoc := self _at: index.
      (anAssoc key = aKey)
        ifTrue: [^ anAssoc]
        ifFalse: [index := self _at: (index + 1)].
      ].
    ^ nil.
    ].

(anAssoc key = aKey)
  ifTrue: [ ^ anAssoc ].

^ nil.
%

category: 'Enumerating'
method: Dictionary
associationsDo: aBlock

"Iteratively evaluates the one argument block, aBlock, using each
 Association in the receiver as the argument to the block.  Returns the
 receiver."

"First iterate through the first section of the Dictionary where Associations
 are directly hashed."
1 to: tableSize do: [ :i|
  "anAssoc could be nil, a SmallInteger, or an Association"
  (self _at: i) ifNotNil:[:anAssoc |
     anAssoc _isSmallInteger ifFalse:[ aBlock value: anAssoc ]]].

"Now iterate through the collision section of the Dictionary"
(tableSize + 1) to: (self _basicSize) by: 2 do: [ :i|
  "anAssoc can only be nil or a valid Association in this section."
  (self _at: i) ifNotNil:[:anAssoc | aBlock value: anAssoc ]].

^ self.
%

category: 'Accessing'
method: Dictionary
at: aKey

"Returns the value of the Association with key aKey.  Reports an error if no
 such key exists."

| anAssoc |
anAssoc := self associationAt: aKey otherwise: nil .
anAssoc == nil ifTrue:[ ^ self _errorKeyNotFound: aKey ].
^ anAssoc value.
%

category: 'Accessing'
method: Dictionary
at: aKey ifAbsent: aBlock

"Returns the value of the Association with key aKey.  If no such Association
 exists, returns the result of evaluating the zero-argument block aBlock."

| anAssoc |
anAssoc := self associationAt: aKey otherwise: nil .
anAssoc == nil ifTrue:[
  aBlock == nil ifTrue:[^ nil ].
  ^aBlock value
  ].
^ anAssoc value.
%

category: 'Accessing'
method: Dictionary
at: aKey otherwise: defaultValue

"Returns the value of the Association with key aKey.  If no such Association
 exists, returns defaultValue."

| anAssoc |

anAssoc := self associationAt: aKey otherwise: nil .
anAssoc == nil ifTrue:[ ^ defaultValue ].
^ anAssoc value.
%

category: 'Updating'
method: Dictionary
at: aKey put: aValue

"Creates a new Association with the given key and value and adds it to the
 receiver.  If the receiver already contains an Association with the given key,
 this makes aValue the value of that Association.  Returns aValue."

| hashVal anAssoc |

(aKey == nil) ifTrue: [ self errorNilKey ].
hashVal := self hashFunction: aKey.

anAssoc := self associationAtOrNil: aKey hash: hashVal.
(anAssoc == nil)
  ifTrue: [
    anAssoc := self class associationClass newWithKey: aKey value: aValue.
    anAssoc objectSecurityPolicy: self objectSecurityPolicy .
    self addNewAssociation: anAssoc hash: hashVal.
    ^ aValue
    ].

unused := unused.	"make sure Dictionary is dirty, not just Association (#42383)"
anAssoc value: aValue.
^ aValue
%

category: 'Storing and Loading'
method: Dictionary
basicWriteTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

| s cls c |
  cls := self class.
  passiveObj writeClass: cls.

  passiveObj writeSize: (s := self size) .

  passiveObj writeNamedIvsFrom: self class: cls .
  passiveObj endNamedInstVars .

  c := 0.
  self associationsDo:[ :anAssoc |
    passiveObj writeObject: anAssoc .
    c := c + 1.
    c > 99 ifTrue: [
      passiveObj lf.
      c := 0.
      ].
    ].

  passiveObj cr
%

category: 'Private'
method: Dictionary
count

"Return the value of the instance variable 'count'."

^ count
%

category: 'Private'
method: Dictionary
count: newValue

"Modify the value of the instance variable 'count'."

count := newValue
%

category: 'Enumerating'
method: Dictionary
do: aBlock

"Iteratively evaluates the one argument block, aBlock, using the value part
 of each Association as the argument of the block. Returns the receiver."

"First iterate through the first section of the Dictionary where Associations
 are directly hashed."
1 to: tableSize do: [ :i|
  "anAssoc could be nil, a SmallInteger, or an Association"
  (self _at: i) ifNotNil:[:anAssoc |
     anAssoc _isSmallInteger ifFalse:[ 
        aBlock value: (anAssoc value) ]]].

"Now iterate through the collision section of the Dictionary"
(tableSize + 1) to: (self _basicSize) by: 2 do: [ :i|
  "anAssoc can only be nil or a valid Association in this section."
  (self _at: i) ifNotNil:[:anAssoc |
     aBlock value: (anAssoc value) ]].

^ self.
%

category: 'Private'
method: Dictionary
emptySlotHint

"Return the value of the instance variable 'emptySlotHint'."

^emptySlotHint
%

category: 'Private'
method: Dictionary
emptySlotHint: newValue

"Modify the value of the instance variable 'emptySlotHint'."

emptySlotHint := newValue
%

category: 'Private'
method: Dictionary
errorKeyNotFound: aKey

"No Association or key/value pair with the given key, aKey was found."

^ self _error: #rtErrKeyNotFound args: { aKey }
%

category: 'Private'
method: Dictionary
findEmptySlot

"Returns an empty slot from the collision part of the Dictionary structure."

| index |

"It is assumed that at this point at least one slot is empty.  Hence this
 cannot loop infinitely"
index := emptySlotHint.
[(self _at: index) ~~ nil]
  whileTrue: [
    index := index + 2.
    (index > (self _basicSize)) ifTrue: [index := tableSize + 1]
    ].

emptySlotHint := index + 2.
(emptySlotHint > (self _basicSize)) ifTrue: [emptySlotHint := tableSize + 1].

numEmptySlots := numEmptySlots - 1.

^ index.
%

category: 'Accessing'
method: Dictionary
keyAtValue: anObject ifAbsent: aBlock

"Returns the key of the first value equal to the given object, anObject.
 If no match is found, evaluates and returns the result of the block aBlock."

self keysAndValuesDo: [
  :key :value | (anObject = value) ifTrue: [^ key]
  ].

aBlock == nil ifTrue:[ ^ nil ].
^aBlock value
%

category: 'Enumerating'
method: Dictionary
keysAndValuesDo: aBlock

"Iteratively evaluates the two argument block, aBlock, using each key and
 value of the receiver as the argument to the block. Returns the receiver."

"First iterate through the first section of the Dictionary where Associations
 are directly hashed."
1 to: tableSize do: [ :i|
  (self _at: i) ifNotNil:[:anAssoc |
     anAssoc _isSmallInteger ifFalse:[ 
        aBlock value: anAssoc key value: anAssoc value ]]].

"Now iterate through the collision section of the Dictionary"
(tableSize + 1) to: (self _basicSize) by: 2 do: [ :i|
  (self _at: i) ifNotNil:[:anAssoc |
    "anAssoc can only be nil or a valid Association in this section."
     aBlock value: (anAssoc key) value: (anAssoc value) ]].

^ self.
%

category: 'Enumerating'
method: Dictionary
keysDo: aBlock

"Iteratively evaluates the two argument block, aBlock, using each key
 of the receiver as the argument to the block.  Returns the receiver."

"First iterate through the first section of the Dictionary where Associations
 are directly hashed."
1 to: tableSize do: [ :i|
  "anAssoc could be nil, a SmallInteger, or an Association"
  (self _at: i) ifNotNil:[:anAssoc |
     anAssoc _isSmallInteger 
        ifFalse:[ aBlock value: anAssoc key ].  ].  ].

"Now iterate through the collision section of the Dictionary"
(tableSize + 1) to: (self _basicSize) by: 2 do: [ :i|
  (self _at: i) ifNotNil:[:anAssoc |
    "anAssoc can only be nil or a valid Association in this section."
    aBlock value: anAssoc key .  ].  ].

^ self.
%

category: 'Storing and Loading'
method: Dictionary
loadVaryingFrom: passiveObj size: varyingSize

"Reads the varying part of the receiver from the given passive object.
 Does not record the receiver as having been read.  Does not read the
 receiver's named instance variables, if any."

1 to: varyingSize do: [:i |
  self add: passiveObj readObject"anAssociation"
].
%

category: 'Private'
method: Dictionary
numEmptySlots

"Return the value of the instance variable 'numEmptySlots'."

^numEmptySlots
%

category: 'Private'
method: Dictionary
numEmptySlots: newValue

"Modify the value of the instance variable 'numEmptySlots'."

numEmptySlots := newValue
%

category: 'Copying'
method: Dictionary
postCopy
	"Cleanup of new copy after shallowCopy."

	super postCopy.
	self postCopyAssociations
%

category: 'Copying'
method: Dictionary
postCopyAssociations
	"Cleanup of new copy after shallowCopy.
	 Dictionaries which actually store the associations need to copy
	 the associations to prevent contention with the original."

	| anAssoc |
	"First iterate through the first section of the Dictionary where Associations are directly hashed
	 (anAssoc could be nil, a SmallInteger, or an Association in this section)."
	1 to: tableSize
		do:
			[:i |
			anAssoc := self _at: i.
			anAssoc isAssociation ifTrue: [self _at: i put: anAssoc copy]].

	"Now iterate through the collision section of the Dictionary
	 (anAssoc can only be nil or a valid Association in this section)."
	tableSize + 1 to: self _basicSize
		by: 2
		do:
			[:i |
			anAssoc := self _at: i.
			anAssoc ~~ nil ifTrue: [self _at: i put: anAssoc copy]].
	^self
%

category: 'Private'
method: Dictionary
rebuild
"Rebuilds the hash dictionary so that it can accommodate more elements."
| newSize tempTable i |

"If it is a small dictionary, just double the overflow area every alternate
 time. Otherwise clear out the receiver, increase it in size, etc."
(tableSize < 650) ifTrue: [ | bsz |
  (bsz := self _basicSize) <= (tableSize * 3) ifTrue: [ | newSz |
    newSz := bsz + tableSize + tableSize .
    (newSz > 2000 and:[ bsz < 1600]) ifTrue:[ newSz := 2034 - self namedSize ].
    self _basicSize: newSz .
    numEmptySlots := numEmptySlots + ((newSz - bsz) // 2) .
    "GsFile gciLogServer: self asOop asString,' grow to basicSize ', self basicSize asString ,
      ' size ', self size asString . "
    ^ self.
    ].
  ].
"Until a table size of 650, double the size every time the dictionary
 needs to grow. After that, grow 650 entries each time. A tableSize of
 650 should occupy almost a whole page."
(tableSize < 650)
  ifTrue: [newSize := self class _tableSizeFor: (tableSize + tableSize)]
  ifFalse: [newSize := self class _tableSizeFor: (tableSize + 650)].
tempTable := Array new: count.
i := 1.
self associationsDo: [ :anAssn |
  tempTable at: i put: anAssn.
  i := i + 1
  ].
self _basicSize: 0.   "grow and initialize to nils"
self _basicSize: newSize * 3 .
tableSize := newSize.
numEmptySlots := newSize .
emptySlotHint := newSize + 1.
count := 0.
1 to: (tempTable size) do: [:j | self add: (tempTable at: j)].
"GsFile gciLogServer: self asOop asString,' rebuild to tableSize ', tableSize asString ,
       ' basicSize ', self basicSize asString ,
       ' _basicSize ', self _basicSize asString ,
       ' size ', self size asString .  "
^ self.
%

category: 'Hashing'
method: Dictionary
rehash
	"Re-establish any hash invariants of the receiver."

	| tempTable i |
	tempTable := Array new: count.
	i := 1.
	self associationsDo:
			[:anAssn |
			tempTable at: i put: anAssn.
			i := i + 1].
	self _basicSize: 0.
	self _basicSize: tableSize * 3.
	"This grows the object and initializes the whole object with nils."
	count := 0.
	1 to: tempTable size do: [:j | self add: (tempTable at: j)].
	^self
%

category: 'Removing'
method: Dictionary
removeAssociation: anAssociation

"Removes an element from the receiver equal to anAssociation and returns
 anAssociation. If no such element is present, this method generates an error."

| assoc |
assoc := self removeKey: anAssociation key otherwise: nil .
assoc == nil ifTrue:[ ^ self _errorNotFound: anAssociation ].
^ assoc
%

category: 'Removing'
method: Dictionary
removeAssociation: anAssociation otherwise: defaultValue

"Removes an element from the receiver equal to anAssociation and returns
 anAssociation.  If an element equal to anAssociation is not present,
 returns defaultValue."

| prevIndex index anElement |

index := self hashFunction: (anAssociation key).
anElement := self _at: index.

(anElement == nil) ifTrue: [^ defaultValue ].

(anElement _isSmallInteger)
  ifTrue: [
    "Need to follow the collision chains."
    prevIndex := index.
    index := anElement.
    [index ~~ nil]
    whileTrue: [
      anElement := self _at: index.
      (anElement = anAssociation)
        ifTrue: [
           self basicAt: prevIndex put: (self _at: (index + 1)).
           self basicAt: index put: nil.
           self basicAt: (index + 1) put: nil.
           count := count - 1.
           ^ anAssociation.
           ]
        ifFalse: [
          "Go to the next one."
          prevIndex := index + 1.
          index := self _at: (index + 1)
          ].
      ].
    ^ defaultValue
    ].

(anElement = anAssociation)
  ifTrue: [
    self basicAt: index put: nil.
    count := count - 1.
    ^ anAssociation.
    ].

^ defaultValue
%

category: 'Removing'
method: Dictionary
removeKey: aKey ifAbsent: aBlock

"Removes the Association with key equal to aKey from the receiver and
 returns the value of that Association.  If no Association is present with key
 equal to aKey, evaluates the zero-argument block aBlock and returns the result
 of that evaluation."

| anAssoc |
anAssoc:= self removeKey: aKey otherwise: nil .
anAssoc == nil ifTrue:[
  aBlock == nil ifTrue:[^ nil ].
  ^aBlock value
  ].
^ anAssoc value
%

category: 'Removing'
method: Dictionary
removeKey: aKey otherwise: defaultValue

"Removes an element from the receiver with key aKey and returns an Association.
 If an element with key aKey is not present, returns defaultValue."

| prevIndex index anAssociation |

aKey ifNil:[ self _error: #rtErrNilKey ].
index := self hashFunction: aKey .
anAssociation := self _at: index.

(anAssociation == nil) ifTrue: [^ defaultValue ].

(anAssociation _isSmallInteger)
  ifTrue: [
    "Need to follow the collision chains."
    prevIndex := index.
    index := anAssociation.
    [index ~~ nil]
    whileTrue: [
      anAssociation := self _at: index.
      (anAssociation key = aKey)
        ifTrue: [
           self basicAt: prevIndex put: (self _at: (index + 1)).
           self basicAt: index put: nil.
           self basicAt: (index + 1) put: nil.
           count := count - 1.
           ^ anAssociation.
           ]
        ifFalse: [
          "Go to the next one."
          prevIndex := index + 1.
          index := self _at: (index + 1)
          ].
      ].
    ^ defaultValue
    ].

(anAssociation key = aKey) ifTrue:[
  self basicAt: index put: nil.
  count := count - 1.
  ^ anAssociation.
  ].
^ defaultValue
%

category: 'Accessing'
method: Dictionary
size

"Returns the number of Associations in the receiver."

^ count
%

category: 'Private'
method: Dictionary
tableSize

"Return the value of the instance variable 'tableSize'."

^tableSize
%

category: 'Private'
method: Dictionary
tableSize: newValue

"Modify the value of the instance variable 'tableSize'."

tableSize := newValue
%

category: 'Enumerating'
method: Dictionary
valuesDo: aBlock

"Iteratively evaluates the two argument block, aBlock, using each
 value of the receiver as the argument to the block.  Returns the receiver."

"First iterate through the first section of the Dictionary where Associations
 are directly hashed."
1 to: tableSize do: [ :i|
  "anAssoc could be nil, a SmallInteger, or an Association"
  (self _at: i) ifNotNil:[:anAssoc |
     anAssoc _isSmallInteger ifFalse:[ aBlock value: (anAssoc value) ]]].

"Now iterate through the collision section of the Dictionary"
(tableSize + 1) to: (self _basicSize) by: 2 do: [ :i|
  (self _at: i) ifNotNil:[:anAssoc |
    "anAssoc can only be nil or a valid Association in this section."
    aBlock value: (anAssoc value) ]].

^ self.
%

category: 'Private'
method: Dictionary
_deferredGciUpdateWith: valueArray

"Private."

1 to: valueArray size do:[:j |
  self add: (valueArray at: j)
  ].
%

category: 'Instance Initialization'
method: Dictionary
_gciInitialize

"Private."

| size |

"The dictionary should have a certain minimum size and the size should
 preferably be a prime number."
size := 7.
self _basicSize: 0.
self _basicSize: (size * 3).
count := 0.
tableSize := size.
emptySlotHint := size + 1.
numEmptySlots := size.
^ true
%

category: 'Searching'
method: Dictionary
_idxOccurrencesOf: aValue

"Dictionaries can contain only Associations."

^ 0
%

category: 'Obsolete'
method: Dictionary
_indexOf: aKey

"This method used to return the numerical index (as found by _#at:) of the
 Association in the receiver with the given key.  With the new implementation of
 Dictionaries, this method does not make sense."

^ self shouldNotImplement: #_indexOf:
%

category: 'Searching'
method: Dictionary
_keysWithValue: aValue

"Returns a (possibly empty) set of keys associated with the value, aValue."

| result |

result:= IdentityBag new.
self associationsDo: [ :anAssoc |
  (aValue = anAssoc value) ifTrue: [ result add: anAssoc key ].
  ].
^ result
%

category: 'Private'
method: Dictionary
_nodesObjectSecurityPolicy: anObjectSecurityPolicy
  self associationsDo: [:anAssoc | anAssoc objectSecurityPolicy: anObjectSecurityPolicy].
%

category: 'Updating'
method: Dictionary
_privAt: aKey put: aValue

"Creates a new Association with the given key and value and adds it to the
 receiver.  No checks are made to see if an Association with the given key
 exists or not.  Improper use could result in duplicate keys."

| hashVal anAssoc |

hashVal := self hashFunction: aKey.
anAssoc := self class associationClass newWithKey: aKey value: aValue.
self addNewAssociation: anAssoc hash: hashVal.
^ aValue
%

! Class implementation for 'PathTerm'

!		Instance methods for 'PathTerm'

category: 'Private'
method: PathTerm
_findAllValuesForIdenticalRootObject: rootObject
	" if index directly on NSC elements or anObject is nil "

	| key tmpList |
	(self indicatesIndexOnNscElements or: [ nil == rootObject ])
		ifTrue: [ key := rootObject ]
		ifFalse: [ key := self _nextObjectFor: rootObject ].
	tmpList := IdentityBag new.
	self updateBtree btreeRoot _findAllValuesForIdenticalKey: key into: tmpList.
	^ (tmpList occurrencesOf: rootObject) <= 1
%

! Class implementation for 'Duration'

!		Class methods for 'Duration'

category: 'Instance Creation'
classmethod: Duration
days: days hours: hours minutes: minutes seconds: seconds
"  Answer a <Duration> of the number of days, hours, minutes, and seconds. If any of the operands
   are negative, the result is smaller by that number of days, hours, minutes, or seconds as
   appropriate.
   Parameters
      days <integer> unspecified
      hours <integer> unspecified
      minutes <integer> unspecified
      seconds <number> unspecified"

	^self seconds: days * 24 + hours * 60 + minutes * 60 + seconds.
%

category: 'Instance Creation'
classmethod: Duration
new
	^self seconds: 0.
%

category: 'other'
classmethod: Duration
seconds: seconds
" Answer a <Duration> which is <seconds> in length. If seconds is negative,
  answer a <Duration> that is abs (seconds) less than Duration zero."

  | res |
  (res := self basicNew) _seconds: seconds.
  ^ res
%

category: 'Instance Creation'
classmethod: Duration
zero
" Answer a <Duration> representing a length of no time."

	^self seconds: 0.
%

!		Instance methods for 'Duration'

category: 'Arithmetic'
method: Duration
* operand
"  Answer a <Duration> that is the result of multiplying the receiver by operand.
   Parameters
      operand <number> unspecified"

	^self class seconds: seconds * operand.
%

category: 'Arithmetic'
method: Duration
+ operand
"  Answer a <Duration> whose value is the result of adding the receiver and operand.
   Parameters
     operand <Duration> unspecified"

	^self class seconds: seconds + operand asSeconds.
%

category: 'Arithmetic'
method: Duration
- operand
"  Answer a <Duration> whose value is the result of subtracting operand from the receiver.
   Parameters
     operand <Duration> unspecified"

	^self class seconds: seconds - operand asSeconds.
%

category: 'Arithmetic'
method: Duration
/ operand
"  If operand is a <number> answer a new <Duration> whose value is the result of dividing the
   receiver by operand. If operand equals zero the ZeroDivide exception is signaled.
   If operand is a <Duration> answer a <number> whose value is the result of dividing the receiver
   by operand. If operand is <Duration factory> #zero the ZeroDivide exception is signaled.
   Parameters
     operand<number> | <Duration> unspecified
   Return Values
     <Duration> unspecified | <number> unspecified"

	^(operand isKindOf: Duration)
		ifTrue: [seconds / operand asSeconds]
		ifFalse: [Duration seconds: seconds / operand].
%

category: 'Comparing'
method: Duration
< operand
"  Answer true if operand represents a <Duration> that is larger than the receiver. Answer false
   otherwise.
   Parameters
     operand <Duration> unspecified"

	^seconds < operand asSeconds.
%

category: 'Comparing'
method: Duration
= comparand
"  Answer true if the comparand is a <Duration> representing the same length of time as the
   receiver. Answer false otherwise.
   Parameters
     comparand <Object> uncaptured"

	^(comparand isKindOf: Duration) and: [seconds = comparand asSeconds].
%

category: 'Arithmetic'
method: Duration
abs
"  If the receiver is greater than or equal to Duration zero answer a <Duration> which is
   equal to the receiver. Otherwise answer a <Duration> which has the same magnitude as the
   receiver but the opposite sign."

	^0 <= seconds
		ifTrue: [self]
		ifFalse: [self class seconds: seconds negated].
%

category: 'Converting'
method: Duration
asMilliseconds
  "Return the number of milliseconds in the length of time represented by the receiver"
  ^ seconds * 1000 
%

category: 'Converting'
method: Duration
asSeconds
"  Answer the total number of seconds in the length of time represented by the receiver including any
   fractional part of a second. If the receiver is less than <Duration factory> #zero then the result will
   be less than 0."

	^seconds.
%

category: 'Formatting'
method: Duration
asString
  ^ self printString
%

category: 'Accessing'
method: Duration
days
"  Answer the number of complete days in the receiver. If the receiver is less than Duration zero 
   then the result will be less than or equal to 0."

	^ (seconds abs // 60) // 60 // 24 * seconds sign.
%

category: 'Comparing'
method: Duration
hash

	^seconds hash.
%

category: 'Accessing'
method: Duration
hours
"  Answer an <integer> between -23 and 23 inclusive that represents the number of complete hours
   in the1G receiver, after the number of complete days has been removed. If the receiver is less than
   Duration zero then the result will be less than or equal to 0."

	^ (seconds abs // 60) // 60 \\ 24 * seconds sign.
%

category: 'Accessing'
method: Duration
minutes
"  Answer an <integer> between -59 and 59 inclusive that represents the number of complete
   minutes in the receiver, after the number of complete days and hours have been removed. If the
   receiver is less than <Duration factory> #zero then the result will be less than or equal to 0."

	^ ( seconds abs // 60) \\ 60 * seconds sign.
%

category: 'Arithmetic'
method: Duration
negated
"  Answer a <Duration> which is of the same magnitude but opposite sign as the receiver."

	^self class seconds: seconds negated.
%

category: 'Testing'
method: Duration
negative
"  Answer true if the receiver is less than <Duration factory> #zero, false otherwise."

	^seconds < 0.
%

category: 'Testing'
method: Duration
positive
"  Answer true if the receiver is greater than or equal to the <Duration factory> #zero, false
   otherwise."

	^0 <= seconds.
%

category: 'Formatting'
method: Duration
printOn: aStream
"  Write a description of the receiver on aStream that is formatted as
     [-]D:HH:MM:SS[.SSS] 
   where
     -   is a minus sign if the receiver represents a length of time going from the future into
         the past,
     D   is the number of complete days with leading zeros to fill one place,
     HH  is the number of complete hours with leading zeros to fill two places,
     MM  is the number of complete minutes with leading zeros to fill two places,
     SS  is the number of complete seconds with leading zeros to fill two places, and
    .SSS is the fractional part of the number of seconds, if any, rounded and 0-padded to three places.
"

  | secs mins hours absSecs |

  seconds < 0 ifTrue: [aStream nextPut: $-].
  self days abs printOn: aStream.
  aStream nextPut: $:.
  (hours := self hours abs) < 10 ifTrue: [aStream nextPut: $0].
  hours printOn: aStream.
  aStream nextPut: $:.
  (mins := self minutes abs) < 10 ifTrue: [aStream nextPut: $0].
  mins printOn: aStream.
  aStream nextPut: $:.
  (absSecs := (secs := self seconds) asInteger abs) < 10 ifTrue: [aStream nextPut: $0].
  absSecs printOn: aStream.
  (secs _isInteger) ifFalse: [
    | float |
    0 < (float := (secs abs - absSecs) asFloat) ifTrue: [ | string |
      aStream nextPut: $. .
      string := ((float roundTo: 0.001) min: 0.999) asStringUsingFormat: self _fractionFormat.
      aStream nextPutAll: (string copyFrom: 3 to: string size).
    ].
  ].
%

category: 'Formatting'
method: Duration
printOnHoursMinutes: aStream

	aStream nextPut: (seconds negative ifTrue: [$-] ifFalse: [$+]).
	self hours abs < 10 ifTrue: [aStream nextPut: $0].
	self hours abs printOn: aStream.
	aStream nextPut: $:.
	self minutes abs < 10 ifTrue: [aStream nextPut: $0].
	self minutes abs printOn: aStream.
%

category: 'Accessing'
method: Duration
seconds
"  Answer a <number> strictly greater than -60 and strictly less than 60
   that represents the number of seconds in the receiver, after the complete days,
   hours, and minutes have been removed.
   If the receiver is less than Duration zero then the result
   will be less than or equal to 0."

  | s |
  ^(s := seconds) abs \\ 60 * s sign.
%

category: 'Private'
method: Duration
_fractionFormat

^ #( 5 3 false )
%

category: 'Private'
method: Duration
_seconds: aNumber

	seconds := aNumber.
%

! Class implementation for 'Message'

!		Class methods for 'Message'

category: 'instance creation'
classmethod: Message
selector: aSymbol
	"Answer an instance of me with unary selector, aSymbol."

	^self new setSelector: aSymbol arguments: { }
%

category: 'instance creation'
classmethod: Message
selector: aSymbol argument: anObject
	"Answer an instance of me whose selector is aSymbol and single
	argument is anObject."

	^self new setSelector: aSymbol arguments: { anObject }
%

category: 'instance creation'
classmethod: Message
selector: aSymbol arguments: anArray
	"Answer an instance of me with selector, aSymbol, and arguments,
	anArray."

	^self new setSelector: aSymbol arguments: anArray
%

!		Instance methods for 'Message'

category: 'accessing'
method: Message
argument
	"Answer the first (presumably sole) argument"

	^args at: 1
%

category: 'accessing'
method: Message
argument: newValue
	"Change the first argument to newValue and answer self"

	args at: 1 put: newValue
%

category: 'accessing'
method: Message
arguments
	"Answer the arguments of the receiver."

	^args
%

category: 'compatibility'
method: Message
asArray
	"Versions of GemStone/S prior to 64-bit version 3.4, the argument to #doesNotUnderstand:
	was a two-element Array, rather than a Message.
	The methods in the compatibility protocol allow old code that expects an Array to continue to work."

	^
	{selector.
	args}
%

category: 'compatibility'
method: Message
at: anIndex
	"Versions of GemStone/S prior to 64-bit version 3.4, the argument to #doesNotUnderstand:
	was a two-element Array, rather than a Message.
	The methods in the compatibility protocol allow old code that expects an Array to continue to work."

	anIndex = 1 ifTrue: [^selector].
	anIndex = 2 ifTrue: [^args].
	anIndex _isInteger
		ifTrue: [^self _errorIndexOutOfRange: anIndex]
		ifFalse: [^self _errorNonIntegerIndex: anIndex]
%

category: 'testing'
method: Message
hasArguments
	^args size > 0
%

category: 'accessing'
method: Message
numArgs
	"Answer the number of arguments in this message"

	^args size
%

category: 'printing'
method: Message
printOn: stream
	|  argsSize count |
	args isEmpty ifTrue: [^ stream nextPutAll: selector].
	count := argsSize := args size.
	args with: selector keywords do: [:arg :word |
		stream nextPutAll: word.
		stream space.
		arg printOn: stream.
		count := count - 1.
		count > 0 ifTrue: [ stream space ].
	].
%

category: 'accessing'
method: Message
selector
	"Answer the selector of the receiver."

	^selector
%

category: 'accessing'
method: Message
sends: aSelector
	"answer whether this message's selector is aSelector"

	^selector == aSelector
%

category: 'sending'
method: Message
sendTo: receiver
	"answer the result of sending this message to receiver"

	^ receiver perform: selector withArguments: args
%

category: 'private'
method: Message
setSelector: aSymbol

	selector := aSymbol.
%

category: 'private'
method: Message
setSelector: aSymbol arguments: anArray

	selector := aSymbol.
	args := anArray
%

category: 'compatibility'
method: Message
size
	"Versions of GemStone/S prior to 64-bit version 3.4, the argument to #doesNotUnderstand:
	was a two-element Array, rather than a Message.
	The methods in the compatibility protocol allow old code that expects an Array to continue to work."

	^2
%

! Class implementation for 'TimeZoneInfo'

!		Class methods for 'TimeZoneInfo'

category: 'samples'
classmethod: TimeZoneInfo
buildSample
"
	See #sampleLosAngelesDataB for an example of what this gives.
	(TimeZoneInfo buildSample).
"

	| file data stream i |
	file := GsFile
		openOnServer: '/usr/share/lib/zoneinfo/America/Los_Angeles'
		mode: 'rb'.
	[
		data := file contents.
	] ensure: [
		file close.
	].
	stream := AppendStream on: String new.
	stream nextPutAll: '#('.
	i := 1.
	data do: [:each |
		stream space.
		each codePoint printOn: stream.
		(i := i + 1) \\ 20 == 0 ifTrue: [stream cr].
	].
	stream nextPutAll: ' ).'.
	^stream contents.
%

category: 'cache'
classmethod: TimeZoneInfo
cache

	^cache.
%

category: 'cache'
classmethod: TimeZoneInfo
cacheAt: aString
	| c |
	c := cache ifNil: [cache := SymbolDictionary new].
	^ c at: aString otherwise: nil .
%

category: 'cache'
classmethod: TimeZoneInfo
cacheAt: aString put: aTimeZoneInfo
	| c |
	c := cache ifNil: [cache := SymbolDictionary new].
	^c at: aString put: aTimeZoneInfo.
%

category: 'singleton'
classmethod: TimeZoneInfo
default

	default == nil ifTrue: [
		default := self sampleLosAngelesB.
	].
	^default.
%

category: 'singleton'
classmethod: TimeZoneInfo
default: aTimeZoneInfo

	default := aTimeZoneInfo.
%

category: 'instance creation'
classmethod: TimeZoneInfo
fromStream: aStream
  | res |
  (res := super new) initialize: aStream.
  ^ res
%

category: 'instance creation'
classmethod: TimeZoneInfo
new

"Disallowed.  To create a new TimeZone, use another instance creation method."

self shouldNotImplement: #new
%

category: 'instance creation'
classmethod: TimeZoneInfo
new: anInteger

"Disallowed.  To create a new TimeZone, use another instance creation method."

self shouldNotImplement: #new:
%

category: 'other'
classmethod: TimeZoneInfo
sampleLosAngelesA

	^self fromStream: (ReadStreamPortable on: self sampleLosAngelesDataA).
%

category: 'other'
classmethod: TimeZoneInfo
sampleLosAngelesB

	^self fromStream: (ReadStreamPortable on: self sampleLosAngelesDataB).
%

category: 'other'
classmethod: TimeZoneInfo
sampleLosAngelesDataA
	"without leap seconds and without 2007 fix"

^#( 84 90 105 102 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
 0 0 0 0 4 0 0 0 4 0 0 0 0 0 0 0 185 0 0 0
 4 0 0 0 16 158 166 72 160 159 187 21 144 160 134 42 160 161 154 247
 144 203 137 26 160 210 35 244 112 210 97 38 16 214 254 116 32 216 128 173
 144 218 254 209 160 219 192 144 16 220 222 179 160 221 169 172 144 222 190 149
 160 223 137 142 144 224 158 119 160 225 105 112 144 226 126 89 160 227 73 82
 144 228 94 59 160 229 41 52 144 230 71 88 32 231 18 81 16 232 39 58
 32 232 242 51 16 234 7 28 32 234 210 21 16 235 230 254 32 236 177 247
 16 237 198 224 32 238 145 217 16 239 175 252 160 240 113 187 16 241 143 222
 160 242 127 193 144 243 111 192 160 244 95 163 144 245 79 162 160 246 63 133
 144 247 47 132 160 248 40 162 16 249 15 102 160 250 8 132 16 250 248 131
 32 251 232 102 16 252 216 101 32 253 200 72 16 254 184 71 32 255 168 42
 16 0 152 41 32 1 136 12 16 2 120 11 32 3 113 40 144 4 97 39
 160 5 81 10 144 6 65 9 160 7 48 236 144 7 141 67 160 9 16 206
 144 9 173 191 32 10 240 176 144 11 224 175 160 12 217 205 16 13 192 145
 160 14 185 175 16 15 169 174 32 16 153 145 16 17 137 144 32 18 121 115
 16 19 105 114 32 20 89 85 16 21 73 84 32 22 57 55 16 23 41 54
 32 24 34 83 144 25 9 24 32 26 2 53 144 26 242 52 160 27 226 23
 144 28 210 22 160 29 193 249 144 30 177 248 160 31 161 219 144 32 118 43
 32 33 129 189 144 34 86 13 32 35 106 218 16 36 53 239 32 37 74 188
 16 38 21 209 32 39 42 158 16 39 254 237 160 41 10 128 16 41 222 207
 160 42 234 98 16 43 190 177 160 44 211 126 144 45 158 147 160 46 179 96
 144 47 126 117 160 48 147 66 144 49 103 146 32 50 115 36 144 51 71 116
 32 52 83 6 144 53 39 86 32 54 50 232 144 55 7 56 32 56 28 5
 16 56 231 26 32 57 251 231 16 58 198 252 32 59 219 201 16 60 176 24
 160 61 187 171 16 62 143 250 160 63 155 141 16 64 111 220 160 65 132 169
 144 66 79 190 160 67 100 139 144 68 47 160 160 69 68 109 144 70 15 130
 160 71 36 79 144 71 248 159 32 73 4 49 144 73 216 129 32 74 228 19
 144 75 184 99 32 76 205 48 16 77 152 69 32 78 173 18 16 79 120 39
 32 80 140 244 16 81 97 67 160 82 108 214 16 83 65 37 160 84 76 184
 16 85 33 7 160 86 44 154 16 87 0 233 160 88 21 182 144 88 224 203
 160 89 245 152 144 90 192 173 160 91 213 122 144 92 169 202 32 93 181 92
 144 94 137 172 32 95 149 62 144 96 105 142 32 97 126 91 16 98 73 112
 32 99 94 61 16 100 41 82 32 101 62 31 16 102 18 110 160 103 30 1
 16 103 242 80 160 104 253 227 16 105 210 50 160 106 221 197 16 107 178 20
 160 108 198 225 144 109 145 246 160 110 166 195 144 111 113 216 160 112 134 165
 144 113 90 245 32 114 102 135 144 115 58 215 32 116 70 105 144 117 26 185
 32 118 47 134 16 118 250 155 32 120 15 104 16 120 218 125 32 121 239 74
 16 122 186 95 32 123 207 44 16 124 163 123 160 125 175 14 16 126 131 93
 160 127 142 240 16 0 1 0 1 2 3 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 255 255 157 144 1 0 255 255 143 128
 0 4 255 255 157 144 1 8 255 255 157 144 1 12 80 68 84 0 80 83
 84 0 80 87 84 0 80 80 84 0 0 0 0 1 0 0 0 1 ).
%

category: 'other'
classmethod: TimeZoneInfo
sampleLosAngelesDataB
	"without leap seconds and with 2007 fix"

^#( 84 90 105 102 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
 0 0 0 0 4 0 0 0 4 0 0 0 0 0 0 0 185 0 0 0
 4 0 0 0 16 158 166 72 160 159 187 21 144 160 134 42 160 161 154 247
 144 203 137 26 160 210 35 244 112 210 97 38 16 214 254 116 32 216 128 173
 144 218 254 209 160 219 192 144 16 220 222 179 160 221 169 172 144 222 190 149
 160 223 137 142 144 224 158 119 160 225 105 112 144 226 126 89 160 227 73 82
 144 228 94 59 160 229 41 52 144 230 71 88 32 231 18 81 16 232 39 58
 32 232 242 51 16 234 7 28 32 234 210 21 16 235 230 254 32 236 177 247
 16 237 198 224 32 238 145 217 16 239 175 252 160 240 113 187 16 241 143 222
 160 242 127 193 144 243 111 192 160 244 95 163 144 245 79 162 160 246 63 133
 144 247 47 132 160 248 40 162 16 249 15 102 160 250 8 132 16 250 248 131
 32 251 232 102 16 252 216 101 32 253 200 72 16 254 184 71 32 255 168 42
 16 0 152 41 32 1 136 12 16 2 120 11 32 3 113 40 144 4 97 39
 160 5 81 10 144 6 65 9 160 7 48 236 144 7 141 67 160 9 16 206
 144 9 173 191 32 10 240 176 144 11 224 175 160 12 217 205 16 13 192 145
 160 14 185 175 16 15 169 174 32 16 153 145 16 17 137 144 32 18 121 115
 16 19 105 114 32 20 89 85 16 21 73 84 32 22 57 55 16 23 41 54
 32 24 34 83 144 25 9 24 32 26 2 53 144 26 242 52 160 27 226 23
 144 28 210 22 160 29 193 249 144 30 177 248 160 31 161 219 144 32 118 43
 32 33 129 189 144 34 86 13 32 35 106 218 16 36 53 239 32 37 74 188
 16 38 21 209 32 39 42 158 16 39 254 237 160 41 10 128 16 41 222 207
 160 42 234 98 16 43 190 177 160 44 211 126 144 45 158 147 160 46 179 96
 144 47 126 117 160 48 147 66 144 49 103 146 32 50 115 36 144 51 71 116
 32 52 83 6 144 53 39 86 32 54 50 232 144 55 7 56 32 56 28 5
 16 56 231 26 32 57 251 231 16 58 198 252 32 59 219 201 16 60 176 24
 160 61 187 171 16 62 143 250 160 63 155 141 16 64 111 220 160 65 132 169
 144 66 79 190 160 67 100 139 144 68 47 160 160 69 68 109 144 69 243 211
 32 71 45 138 16 71 211 181 32 73 13 108 16 73 179 151 32 74 237 78
 16 75 156 179 160 76 214 106 144 77 124 149 160 78 182 76 144 79 92 119
 160 80 150 46 144 81 60 89 160 82 118 16 144 83 28 59 160 84 85 242
 144 84 252 29 160 86 53 212 144 86 229 58 32 88 30 241 16 88 197 28
 32 89 254 211 16 90 164 254 32 91 222 181 16 92 132 224 32 93 190 151
 16 94 100 194 32 95 158 121 16 96 77 222 160 97 135 149 144 98 45 192
 160 99 103 119 144 100 13 162 160 101 71 89 144 101 237 132 160 103 39 59
 144 103 205 102 160 105 7 29 144 105 173 72 160 106 230 255 144 107 150 101
 32 108 208 28 16 109 118 71 32 110 175 254 16 111 86 41 32 112 143 224
 16 113 54 11 32 114 111 194 16 115 21 237 32 116 79 164 16 116 255 9
 160 118 56 192 144 118 222 235 160 120 24 162 144 120 190 205 160 121 248 132
 144 122 158 175 160 123 216 102 144 124 126 145 160 125 184 72 144 126 94 115
 160 127 152 42 144 0 1 0 1 2 3 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
 0 1 0 1 0 1 0 1 0 1 255 255 157 144 1 0 255 255 143 128
 0 4 255 255 157 144 1 8 255 255 157 144 1 12 80 68 84 0 80 83
 84 0 80 87 84 0 80 80 84 0 0 0 0 1 0 0 0 1 ).
%

category: 'other'
classmethod: TimeZoneInfo
sampleTokyo

	^self fromStream: (ReadStreamPortable on: self sampleTokyoData).
%

category: 'other'
classmethod: TimeZoneInfo
sampleTokyoData
	"without leap seconds and without 2007 fix"

^#( 84 90 105 102 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
 0 0 0 0 2 0 0 0 2 0 0 0 0 0 0 0 1 0 0 0
 2 0 0 0 8 195 206 133 112 1 0 0 126 144 0 0 0 0 126 144
 0 4 67 74 84 0 74 83 84 0 0 0 0 0 )
%

!		Instance methods for 'TimeZoneInfo'

category: 'public'
method: TimeZoneInfo
detectLastTransition: aBlock
		"#'to:by:do: is slightly faster than #'reverseDo:' (#40674)"
	transitions size to: 1 by: -1 do: [:i |
		| each |
		each := transitions at: i.
		(aBlock value: each) ifTrue: [^each].
	].
	^nil.
%

category: 'instance creation'
method: TimeZoneInfo
initialize: aStream

	stream := aStream.
	self
		readHeader;
		readTransitions;
		readTypes;
		readAbbreviations;
		updateTransitions;
		readLeapSeconds .
	stream  := nil.
	types   := nil.
	charcnt := nil.
%

category: 'instance creation'
method: TimeZoneInfo
nextByte

	| object |
	object := stream next.
	(object _isInteger) ifTrue: [^object].
	(object isKindOf: Character) ifTrue: [^object codePoint].
	self error: 'invalid file format'.
%

category: 'instance creation'
method: TimeZoneInfo
nextSignedInt

	| b0 b1 b2 w h |
	b0 := self nextByte.
	b1 := self nextByte.
	b2 := self nextByte.
	w :=  self nextByte.

	"Minimize LargeInteger arithmetic"
	h := ((b0 bitAnd: 16r7F) - (b0 bitAnd: 16r80) bitShift: 8) + b1.
	b2 == 0 ifFalse: [w := (b2 bitShift: 8) + w].
	h == 0 ifFalse: [w := (h bitShift: 16) + w].
	^w
%

category: 'instance creation'
method: TimeZoneInfo
nextUnsignedInt

	^(self nextByte * 16r1000000) +
		(self nextByte * 16r10000) +
		(self nextByte *   16r100) +
		self nextByte.
%

category: 'public'
method: TimeZoneInfo
offsetAtLocal: aDateAndTime

	| transition |
	transition := self transitionAtLocal: aDateAndTime.
	transition == nil ifTrue: [
		transition := transitions
			detect: [:each | each isDST not]
			ifNone: [^0].
	].
	^transition offsetFromUTC.
%

category: 'public'
method: TimeZoneInfo
offsetAtUTC:   aDateAndTime
	| transition |
	transition := self transitionAtUTC: aDateAndTime.
	transition == nil ifTrue: [
		transition := transitions
			detect: [:each | each isDST not]
			ifNone: [^0].
	].
	^transition offsetFromUTC.
%

category: 'instance creation'
method: TimeZoneInfo
readAbbreviations

	| list index dict |
  list := String new .
	(stream next: charcnt) do: [:each |
		list add: ((each _isInteger) ifTrue:[ Character codePoint: each]
			                           ifFalse: [each]).
	].
	list := list subStrings: (Character codePoint: 0).
	dict := Dictionary new.
	index := 1.
	list do: [:each |
		dict
			at: index
			put: each.
		index := index + each size + 1.
	].
	1 to: types size do: [:i |
		| array offset |
		array := types at: i.
		offset := array at: 3.
		array at: 3 put: (dict at: offset otherwise: '' ).
	].
%

category: 'instance creation'
method: TimeZoneInfo
readHeader

	| version unused ttisgmtcnt ttisstdcnt |
	'TZif' do: [:each |
		self nextByte == each codePoint ifFalse: [self error: 'Invalid file format'].
	].
	version := stream next: 1.			"either an ASCII NUL ('\0') or a '2'"
	unused := stream next: 15.		"fifteen bytes containing zeros reserved for future use"
	ttisgmtcnt := self nextUnsignedInt.	"the number of UTC/local indicators stored in the file"
	ttisstdcnt := self nextUnsignedInt. 	"the number of standard/wall indicators stored in the file"
	leapSeconds := Array new: self nextUnsignedInt.	"size is the number of leap seconds for which data is stored in the file"
	transitions := (Array new: self nextUnsignedInt) 	"size is the number of 'transition times' for which data is stored in the file"
		collect: [:ignore | TimeZoneTransition new].
	types      := Array new: self nextUnsignedInt.		"size is the number of 'local time types' for which data is stored in the file (must not be zero)"
	charcnt    := self nextUnsignedInt.						"The number of characters of 'timezone abbreviation strings' stored in the file"
%

category: 'instance creation'
method: TimeZoneInfo
readLeapSeconds

	leapSeconds := leapSeconds collect: [:each |
                { self nextSignedInt . self nextSignedInt }
	].
%

category: 'instance creation'
method: TimeZoneInfo
readTransitions

        | tsize |
	1 to: (tsize := transitions size) do: [:j |
		(transitions at: j) transitionTime: self nextSignedInt.
	].
	1 to: tsize do: [:j |
		(transitions at: j) localTimeTypeID: self nextByte + 1.
	].
	tsize == 0 ifTrue: [ | tt |
                (tt := TimeZoneTransition new )
			transitionTime: 0;
			localTimeTypeID: 1.
		transitions add: tt .
	].
%

category: 'instance creation'
method: TimeZoneInfo
readTypes

	types := types collect: [:ignore |
	         { self nextSignedInt	"UTC offset" .
		    self nextByte == 1		"is DST" .
		    self nextByte + 1	"abbreviation" }
	].
%

category: 'public'
method: TimeZoneInfo
transitionAtLocal: aDateAndTime

	| seconds |
	seconds := aDateAndTime asPosixSeconds.
	^self detectLastTransition: [:each | each transitionTimeLocal <= seconds].
%

category: 'public'
method: TimeZoneInfo
transitionAtUTC:   aDateAndTime
	| seconds |
	seconds := aDateAndTime asPosixSeconds asFloat"optimization, fix 49425".
	^self detectLastTransition: [:each | each transitionTimeUTC   <= seconds].
%

category: 'instance creation'
method: TimeZoneInfo
tzfile_h
	"from tzfile.h in ftp://elsie.nci.nih.gov/pub/tzcode2006n.tar.gz on 2006-10-30"

^'
#define	TZ_MAGIC	"TZif"

struct tzhead {
	char	tzh_magic[4];			/* TZ_MAGIC */
	char	tzh_version[1];		/* ''\0'' or ''2'' as of 2005 */
	char	tzh_reserved[15];		/* reserved--must be zero */
	char	tzh_ttisgmtcnt[4];	/* coded number of trans. time flags */
	char	tzh_ttisstdcnt[4];	/* coded number of trans. time flags */
	char	tzh_leapcnt[4];		/* coded number of leap seconds */
	char	tzh_timecnt[4];		/* coded number of transition times */
	char	tzh_typecnt[4];		/* coded number of local time types */
	char	tzh_charcnt[4];		/* coded number of abbr. chars */
};

/*
** . . .followed by. . .
**
**	tzh_timecnt (char [4])s		coded transition times a la time(2)
**	tzh_timecnt (unsigned char)s	types of local time starting at above
**	tzh_typecnt repetitions of
**		one (char [4])		coded UTC offset in seconds
**		one (unsigned char)	used to set tm_isdst
**		one (unsigned char)	that''s an abbreviation list index
**	tzh_charcnt (char)s		''\0''-terminated zone abbreviations
**	tzh_leapcnt repetitions of
**		one (char [4])		coded leap second transition times
**		one (char [4])		total correction after above
**	tzh_ttisstdcnt (char)s		indexed by type; if TRUE, transition
**					time is standard time, if FALSE,
**					transition time is wall clock time
**					if absent, transition times are
**					assumed to be wall clock time
**	tzh_ttisgmtcnt (char)s		indexed by type; if TRUE, transition
**					time is UTC, if FALSE,
**					transition time is local time
**					if absent, transition times are
**					assumed to be local time
*/'
%

category: 'instance creation'
method: TimeZoneInfo
updateTransitions

   1 to: transitions size do: [:j |
      (transitions at:j) typeList: types
   ].
%

category: 'public'
method: TimeZoneInfo
_offsetAtPosix: posixSeconds
	| transition |
	transition := self _transitionAtPosix: posixSeconds.
	transition == nil ifTrue: [
		transition := transitions
			detect: [:each | each isDST not]
			ifNone: [^0].
	].
	^transition offsetFromUTC.
%

category: 'public'
method: TimeZoneInfo
_transitionAtPosix: posixSeconds
  transitions size to: 1 by: -1 do: [:i |
    | each |
    each := transitions at: i .
    each transitionTimeUTC <= posixSeconds ifTrue:[ ^ each ].
  ].
  ^ nil.
%

! Class implementation for 'TimeZone'

!		Class methods for 'TimeZone'

category: 'querying'
classmethod: TimeZone
availableZones
 "Returns a sorted Array of Strings which are time zones supported by
  the Olson database shipped in $GEMSTONE/pub/timezone/usr/share/zoneinfo/.
  These Strings may be used as arguments to TimeZone(C)>>named: "
  | res dirs ofs basePath basePathSize |
  res := { } .
  dirs := { (basePath := self _olsonPath , $/)  } .
  basePathSize := basePath size .
  ofs := 1 .
  [ ofs <= dirs size ] whileTrue:[ | list aDir |
    aDir := dirs at: ofs .
    list := GsFile contentsAndTypesOfDirectory: aDir onClient: false .
    1 to: list size by: 2 do:[:n | | elem isFile elemSiz |
      elem := list at: n .  elemSiz := elem size .
      isFile := list at: n + 1 .
      ((elem at: elemSiz) == $. or:[ elem at: elemSiz - 3 equals: '.tab']) ifFalse:[
        isFile ifTrue:[
          (self _isTimeZoneFile: elem) ifTrue:[ | relPath |
            relPath := elem copyFrom: basePathSize + 1 to: elemSiz .
            res add:  relPath
          ].
        ] ifFalse:[ dirs add: elem , $/ ].
      ].
    ].
    ofs := ofs + 1.
  ].
  ^ Array withAll: (SortedCollection withAll: res)
%

category: 'singleton'
classmethod: TimeZone
current

"Returns the current session's current TimeZoneInfo. E.g. TimeZoneInfo current."

^ System __sessionStateAt: 17.
%

category: 'singleton'
classmethod: TimeZone
default

	^default.
%

category: 'singleton'
classmethod: TimeZone
default: aTimeZone

"Makes the specified time zone the default time zone. Returns aTimeZone.
 Must be SystemUser to do so."

aTimeZone _validateClass: TimeZone.
System myUserProfile userId = 'SystemUser' ifFalse:[
  self error:'instance only modifiable by SystemUser'.
  self _uncontinuableError .
].
super default: aTimeZone.
(ObsoleteClasses at:#ObsoleteTimeZone) default: aTimeZone.  "work-around for #36178"
^aTimeZone.
%

category: 'cache'
classmethod: TimeZone
for: aPlace

"Returns a TimeZone object for the specified place if it has been defined
 and stored in the receiver's cache . Returns nil if it is not cached.

 E.g. TimeZone for: #'America/Los_Angeles'.

 Example to create a TimeZone for one of the availableZones  
     TimeZone named: 'Etc/UTC' 

 Example To create aned cache a TimeZone for one of the availableZones  use   
    | name | 
    name := 'Etc/UTC' .
    TimeZone for: name put:( TimeZone named: name) . 
    System commit .
"

^self cacheAt: aPlace.
%

category: 'cache'
classmethod: TimeZone
for: aPlace put: aTimeZone

"Stores aTimeZone as the TimeZoneInfo object identified with a particular
 place. A single TimeZoneInfo can be associated with any number of places.
 E.g. TimeZoneInfo for: #'America/Los_Angeles' put: aTimeZone;
 TimeZoneInfo for: #'Europe/Berlin' put: aTimeZone.
 Returns aTimeZone."

self cacheAt: aPlace put: aTimeZone.
^aTimeZone.
%

category: 'instance creation'
classmethod: TimeZone
fromGciPath: pathString
  ^ self _fromPath: pathString onClient: true
%

category: 'instance creation'
classmethod: TimeZone
fromGemPath: pathString
  ^ self _fromPath: pathString onClient: false
%

category: 'instance creation'
classmethod: TimeZone
fromGsFile: aGsFile

	| instance |
	[
		instance := self fromStream: aGsFile.
	] ensure: [
		aGsFile close.
	].
	^instance.
%

category: 'instance creation'
classmethod: TimeZone
fromLinux

	^TimeZone fromOS
%

category: 'instance creation'
classmethod: TimeZone
fromObsolete: anObsoleteTimeZone
"
TimeZone fromObsolete: ObsoleteTimeZone default.
"
  | res |
  (res := self basicNew) initializeFromObsolete: anObsoleteTimeZone.
  ^ res
%

category: 'instance creation'
classmethod: TimeZone
fromOS
  "This is suitable for Linux and Mac"

  ^TimeZone fromGemPath: '/etc/localtime'
%

category: 'instance creation'
classmethod: TimeZone
fromPath: aString

	| block |
	block := [:prefix |
		| path |
		path := prefix , aString.
		(GsFile existsOnServer: path) == true ifTrue: [
			^self fromGemPath: path.
		].
	].
	block
		value: '';	"full path"
		value: '/usr/share/lib/zoneinfo/';	"AIX and Solaris"
		value: '/usr/share/zoneinfo/';		"Linux"
		value: '$GEMSTONE/pub/timezone/usr/share/zoneinfo/'. "GemStone distribution"
	^nil.
%

category: 'Initialization'
classmethod: TimeZone
installNamedZone: zonenameString
  "Install the named timezone, from the GemStone distribution Olson zoneinfo 
  database in $GEMSTONE/pub/timezone. The new TimeZone is made the default/current.
  The existing default TimeZone is sent become: with the new TimeZone, so existing 
  references to the old TimeZone automatically now refer to the new TimeZone."

  | zone path |
  path := '$GEMSTONE/pub/timezone/usr/share/zoneinfo/'.
  zone := TimeZone fromGemPath: path , zonenameString.
  self _installDefaultZone: zone
%

category: 'Initialization'
classmethod: TimeZone
installOsTimeZone
  "Install a TimeZone based on the OS time zone settings for the host on which
  the Gem executing this command is running. This uses /etc/localtime which is 
  correct for Linux and Mac. The new TimeZone is made the default/current.  
  The existing default TimeZone is sent become: with the new TimeZone, so existing
  references to the old TimeZone automatically now refer to the new TimeZone."

  | zone |
  zone := TimeZone fromOS.
  self _installDefaultZone: zone
%

category: 'other'
classmethod: TimeZone
migrateNew

"Override default migrateNew behavior with #_basicNew because
we disallow #new (which is called by Behavior>>migrateNew)."

^ self _basicNew
%

category: 'instance creation'
classmethod: TimeZone
named: aString
  "Return an instance of TimeZone using the specified zone
   from the Olson database shipped in $GEMSTONE/pub/timezone/usr/share/zoneinfo/.
  See TimeZone(C)>>availableZones for legal arguments .
  Does not store the result in the receiver's cache .
  "

  | f path |
  path := self _olsonPath , $/ , aString .
  f := GsFile openReadOnServer: path .
  f ifNil:[
    Error signal: aString asString,' ' , 'does not specify a TimeZone; ' ,
      GsFile lastErrorString
  ].
  ^ self fromGsFile: f .
%

category: 'instance creation'
classmethod: TimeZone
timeDifferenceHrs: hours dstHrs: dstHrs atTimeHrs: startTimeHrs
fromDayNum: startDay toDayNum: endDay on: nameOfDay beginning: startYear
stdPrintString: stdString dstPrintString: dstString

| oldTZ |
oldTZ := (ObsoleteClasses at:#ObsoleteTimeZone)
	timeDifferenceHrs: hours
	dstHrs: dstHrs
	atTimeHrs: startTimeHrs
	fromDayNum: startDay
	toDayNum: endDay
	on: nameOfDay
	beginning: startYear
	stdPrintString: stdString
	dstPrintString: dstString.
^self fromObsolete: oldTZ.
%

category: 'instance creation'
classmethod: TimeZone
timeDifferenceMin: minutes dstMin: dstMins atTimeMin: startTimeMins
fromDayNum: startDay toDayNum: endDay on: nameOfDay beginning: startYear
stdPrintString: stdString dstPrintString: dstString

| oldTZ |
oldTZ := (ObsoleteClasses at:#ObsoleteTimeZone)
	timeDifferenceMin: minutes
	dstMin: dstMins
	atTimeMin: startTimeMins
	fromDayNum: startDay
	toDayNum: endDay
	on: nameOfDay
	beginning: startYear
	stdPrintString: stdString
	dstPrintString: dstString.
^self fromObsolete: oldTZ.
%

category: 'instance creation'
classmethod: TimeZone
_fromPath: aString onClient: onClient
  | f |
  f := GsFile open: aString mode: 'rb' onClient: onClient .
  f ifNil:[
     | errStr |
     errStr := aString asString,' ' , 'does not specify a TimeZone file; '.
     errStr add: (onClient 
        ifTrue: [GsFile lastErrorString] 
        ifFalse: [GsFile serverErrorString]).
     Error signal: errStr
     ].
  ^self fromGsFile: f .
%

category: 'Initialization'
classmethod: TimeZone
_initialize3
  | hist |
  default ifNil:[ |zone osZone |
    "executed during slowfilein only"
    osZone := self fromOS .
    zone := self fromGemPath: '$GEMSTONE/pub/timezone/usr/share/zoneinfo/America/Los_Angeles' .
    osZone ifNotNil:[ 
      zone asString = osZone asString ifFalse:[  "bad timezone on build host"
        Error signal:'inconsistent timezones zone ', zone asString ,' osZone ', osZone asString
      ].
    ] ifNil:[  "AIX slowfilein takes this path"].
    "init classVars in superclass"
    default := zone  .
    cache ifNil:[ cache := SymbolDictionary new ].
    self cacheAt: #'America/Los_Angeles' put: zone.
    GsFile gciLogServer:'Set TimeZone default to ', zone asString .
  ] ifNotNil:[:z |
    GsFile gciLogServer:'TimeZone default is already ', z asString .
  ].
  (Globals at: #TimeZone) == self ifFalse:[ Error signal:'bad TimeZone binding'].
  hist := (ObsoleteClasses at: #ObsoleteTimeZone) classHistory.
  (hist size == 1 and:[ self classHistory size == 1]) ifTrue:[
    hist add: (ObsoleteClasses at: #ObsoleteTimeZone2) .
    hist add: self .
    (ObsoleteClasses at: #ObsoleteTimeZone2) classHistory: hist .
    self classHistory: hist .
  ].
%

category: 'private'
classmethod: TimeZone
_installDefaultZone: zone
  | def |
  zone = (def := TimeZone default) ifFalse:[
    def ifNotNil:[ def become: zone ]
        ifNil:[ TimeZone default: zone ]. 
    TimeZone default installAsCurrentTimeZone.
    System commit.
  ].
%

category: 'private'
classmethod: TimeZone
_isTimeZoneFile: aPath

(GsFile openReadOnServer: aPath) ifNotNil:[:f | | str |
  str := String new .
  f read: 4 into: str .
  f close .
  str = 'TZif' ifTrue:[ ^ true ].
].
^ false
%

category: 'private'
classmethod: TimeZone
_olsonPath
  | path list suffix sufSize |
  path := (GsFile _expandEnvVariable:'GEMSTONE' isClient: false) , '/pub/timezone/usr/share'.
  " use contentsAndTypesOfDirectory on parent of target directory so as to expand symlinks"
  list := GsFile contentsAndTypesOfDirectory: path onClient: false .
  suffix := '/zoneinfo' .
  sufSize := suffix size .
  1 to: list size by: 2 do:[:n | | kind |
    kind := list at: n + 1 .
    kind ifFalse:[ "a directory" | elem |
       elem := list at: n .
       (elem at:(elem size - sufSize + 1) equals: suffix) ifTrue:[ ^ elem].
    ]
  ].
  Error signal:'could not find zoneinfo subdirectory'
%

!		Instance methods for 'TimeZone'

category: 'accessors'
method: TimeZone
= aTimeZone

	^(aTimeZone isKindOf: TimeZone)
		and: [self transitions = aTimeZone transitions
		and: [self leapSeconds = aTimeZone leapSeconds
		and: [self standardPrintString = aTimeZone standardPrintString
		and: [self dstPrintString = aTimeZone dstPrintString]]]].
%

category: 'Printing'
method: TimeZone
asString
  | str |
  str := self standardPrintString .
  (str size == 0 and:[ self secondsFromGmt == 0]) ifTrue:[ str := 'UTC'] .
  ^ str
%

category: 'Updating'
method: TimeZone
become: anObject

	super become: anObject.
	self initializeCache.
	anObject initializeCache.
%

category: 'legacy protocol'
method: TimeZone
dateTimeClass

"Returns the class of DateTime objects that are to be created by the
 various methods in this class."

^ DateTime
%

category: 'Legacy Accessors'
method: TimeZone
dayEndDst

	| transition dt |
	transition := self detectLastTransition: [:each | each isDST not].
	dt := transition asDateAndTimeUTC asLocal.
	^dt dayOfYear.
%

category: 'Legacy Accessors'
method: TimeZone
dayStartDst

	| transition dt |
	transition := self detectLastTransition: [:each | each isDST].
	dt := transition asDateAndTimeUTC asLocal.
	dt := dt + (Duration seconds: self secondsForDst negated).
	^dt dayOfYear.
%

category: 'Legacy Accessors'
method: TimeZone
dstEndTimeList

"Returns the dstEndTimeList instance variable."

^ dstEndTimeList
%

category: 'legacy protocol'
method: TimeZone
dstPrintString

	^dstPrintString.
%

category: 'legacy protocol'
method: TimeZone
dstPrintString: aString

"Sets the dstPrintString instance variable. Returns the receiver."

dstPrintString := aString.
^ self
%

category: 'Legacy Accessors'
method: TimeZone
dstStartTimeList

"Returns the dstStartTimeList instance variable."

^ dstStartTimeList
%

category: 'queries'
method: TimeZone
endOfDstFor: aYear

	^ (dstEndTimeList at: aYear otherwise: nil)
		ifNil:[ self endOfDstForA: aYear].
%

category: 'internal'
method: TimeZone
endOfDstForA: aYear

	| dt transition next |
	dt := DateAndTime year: aYear + 1 day: 1 hour: 0 minute: 0 second: 0.
	[
		(next := self transitionAtUTC: dt) == nil ifTrue: [^nil].
		next = transition ifTrue: [^nil].
		transition := next.
		dt := transition asDateAndTimeUTC.
		dt year ~~ aYear ifTrue: [^nil].
		dt := dt - (Duration seconds: 1).
		transition isDST.
	] whileTrue: [].
	dt := DateTime
		newGmtWithYear: dt year
		month: dt month
		day: dt dayOfMonth
		hours: dt hour
		minutes: dt minute
		seconds: dt second asInteger
		timeZone: self.
	^dt addSeconds: 1.
%

category: 'accessors'
method: TimeZone
hash

	^transitions first hash + standardPrintString hash.
%

category: 'internal'
method: TimeZone
initialize: aStream

	| transition |
	super initialize: aStream.
	transition := self detectLastTransition: [:each | each isDST].
	dstPrintString := transition == nil
		ifTrue:  ['']
		ifFalse: [transition abbreviation].
	transition := self detectLastTransition: [:each | each isDST not].
	standardPrintString := transition == nil
		ifTrue:  ['']
		ifFalse: [transition abbreviation].
	self initializeCache.
%

category: 'internal'
method: TimeZone
initializeCache

	dstStartTimeList := IntegerKeyValueDictionary new.
	dstEndTimeList := IntegerKeyValueDictionary new.
	self
		populateCacheFor: (1950 to: 2050);
		_yearStartDst;
		_secondsForDst;
		_secondsFromGmt;
		yourself.
%

category: 'internal'
method: TimeZone
initializeFromObsolete: anObsoleteTimeZone
	| base startArray endArray old new currentZ |
  currentZ := TimeZone current .
  base :=	DateTime newWithYear: 1970 dayOfYear: 1 seconds: 0 .
	transitions := OrderedCollection new.
	standardPrintString := anObsoleteTimeZone standardPrintString.
	dstPrintString := anObsoleteTimeZone dstPrintString.
	startArray := { {
		anObsoleteTimeZone secondsFromGmt + anObsoleteTimeZone secondsForDst .
		true .
		dstPrintString } } .
	endArray := { {
		anObsoleteTimeZone secondsFromGmt .
		false .
		standardPrintString } } .
	currentZ ifNotNil:[
		anObsoleteTimeZone secondsForDst = 0 ifTrue: [
			| year trTim transition |
			year := (anObsoleteTimeZone yearStartDst max: 1900) printString.
			trTim := (DateTime fromStringGmt: '01/01/' ,  year , ' 00:00:00' ) asSecondsGmt - base asSeconds.
			(transition := TimeZoneTransition new)
				localTimeTypeID: 1;
				transitionTime: trTim ;
				typeList: endArray.
			transitions add: transition.
			self initializeCache.
			^self.
		].
		anObsoleteTimeZone yearStartDst to: 2030 do: [:year |
			| endDateTime startSec endSec start end |
			startSec := (anObsoleteTimeZone startOfDstFor: year) asSecondsGmt - base asSeconds.
			(start := TimeZoneTransition new)
				localTimeTypeID: 1;
				transitionTime: startSec;
				typeList: startArray.
			(endDateTime := anObsoleteTimeZone endOfDstFor: year) ifNil: [
				transitions add: start.
			] ifNotNil: [
				endSec := endDateTime asSecondsGmt - base asSeconds.
				(end := TimeZoneTransition new)
					localTimeTypeID: 1;
					transitionTime: endSec;
					typeList: endArray.
				start transitionTimeUTC < end transitionTimeUTC ifTrue: [
					transitions add: start; add: end.
				] ifFalse: [
					transitions add: end; add: start.
				].
			].
		].
	].
	transitions := transitions asArray.
	self initializeCache.
	old := anObsoleteTimeZone.
	new := self.
  false ifTrue:[
    "Gs64 v3.6, disable this check. seeing failures in testBug43664, but not worth
     fixing ObsoleteTimeZone issues."
	  anObsoleteTimeZone yearStartDst to: 2030 do: [:year |
		  | oldStart oldEnd newStart newEnd |
		  oldStart := old startOfDstFor: year.
		  newStart := new startOfDstFor: year.
		  oldEnd   := old endOfDstFor:   year.
		  newEnd   := new endOfDstFor:   year.
		  oldStart = newStart ifFalse: [Warning signal: 'start date calculation error',
           oldStart asString , ', ' , newStart asString ].
		  oldEnd   = newEnd   ifFalse: [Warning signal: 'end date calculation error ',
		     oldEnd asString , ', ' , newEnd asString ].
	  ].
  ].
%

category: 'singleton'
method: TimeZone
installAsCurrentTimeZone

"Sets the receiver as the current session's current Timezone. Returns the
 receiver."

System __sessionStateAt: 17 put: self.
^ self.
%

category: 'accessors'
method: TimeZone
leapSeconds

	^leapSeconds.
%

category: 'Instance Migration'
method: TimeZone
migrateFrom: anotherObject instVarMap: otherivi

	super migrateFrom: anotherObject instVarMap: otherivi.
	self
		_yearStartDst;
		_secondsForDst;
		_secondsFromGmt;
		yourself.
%

category: 'internal'
method: TimeZone
populateCacheFor: anInterval

	anInterval do: [:year |
		dstStartTimeList
			at: year
			put: (self startOfDstForA: year).
		dstEndTimeList
			at: year
			put: (self endOfDstForA: year).
	].
%

category: 'Legacy Accessors'
method: TimeZone
secondsForDst

	^secondsForDst
%

category: 'Legacy Accessors'
method: TimeZone
secondsFromGmt

	^secondsFromGmt
%

category: 'legacy protocol'
method: TimeZone
shouldWriteInstVar: instVarName

"Returns whether the given instance variable should be written out."

"exclude the ditionaries"

instVarName == #dstStartTimeList ifTrue:[ ^ false ].
instVarName == #dstEndTimeList ifTrue:[ ^ false ].
^ true
%

category: 'legacy protocol'
method: TimeZone
standardPrintString

	standardPrintString == nil ifTrue: [
		standardPrintString := (self detectLastTransition: [:each | each isDST not]) abbreviation.
	].
	^standardPrintString.
%

category: 'legacy protocol'
method: TimeZone
standardPrintString: aString

"Sets the standardPrintString instance variable. Returns the receiver."

standardPrintString := aString.
^ self
%

category: 'queries'
method: TimeZone
startOfDstFor: aYear

	^ ( dstStartTimeList at: aYear otherwise: nil)
		ifNil:[ self startOfDstForA: aYear ].
%

category: 'internal'
method: TimeZone
startOfDstForA: aYear

	| dt transition next |
	dt := DateAndTime year: aYear + 1 day: 1 hour: 0 minute: 0 second: 0.
	[
		(next := self transitionAtUTC: dt) == nil ifTrue: [^nil].
		next = transition ifTrue: [^nil].
		transition := next.
		dt := transition asDateAndTimeUTC.
		dt year ~~ aYear ifTrue: [^nil].
		dt := dt - (Duration seconds: 1).
		transition isDST not.
	] whileTrue: [
	].
	dt := DateTime
		newGmtWithYear: dt year
		month: dt month
		day: dt dayOfMonth
		hours: dt hour
		minutes: dt minute
		seconds: dt second asInteger
		timeZone: self.
	^dt addSeconds: 1.
%

category: 'Legacy Accessors'
method: TimeZone
timeStartDst

	| transition dt |
	transition := self detectLastTransition: [:each | each isDST].
	dt := transition asDateAndTimeUTC - (Duration seconds: 1).
	dt := DateAndTime
		secondsUTC: dt asSeconds
		offset: (Duration seconds: (self offsetAtUTC: dt)).
	^dt hour * 60 + dt minute * 60 + dt second + 1.
%

category: 'accessors'
method: TimeZone
transitions

	^transitions.
%

category: 'Legacy Accessors'
method: TimeZone
weekDayStartDst

	| transition year dateTime date |
	transition := self detectLastTransition: [:each | each isDST].
	year := transition asDateAndTimeUTC year.
	dateTime := self startOfDstFor: year.
	dateTime := dateTime addSeconds: self secondsForDst negated.
	date := dateTime asDateIn: self.
	^date weekDayName asSymbol.
%

category: 'Legacy Accessors'
method: TimeZone
yearStartDst
	^yearStartDst
%

category: 'Legacy Accessors'
method: TimeZone
_secondsForDst
	"calculate and save in cache"

	| isDST isNotDST |
	isDST := self detectLastTransition: [:each | each isDST].
	isDST == nil ifTrue: [^secondsForDst := 0].
	isNotDST := self detectLastTransition: [:each | each isDST not].
	isNotDST == nil ifTrue: [^secondsForDst := 0].
	^secondsForDst := isDST offsetFromUTC - isNotDST offsetFromUTC.
%

category: 'Legacy Accessors'
method: TimeZone
_secondsFromGmt
	"calculate and save in cache"

	| transition |
	transition := self detectLastTransition: [:each | each isDST not].
	^secondsFromGmt := transition == nil
		ifTrue: [0]
		ifFalse: [transition offsetFromUTC].
%

category: 'Legacy Accessors'
method: TimeZone
_yearStartDst
	"calculate and save in cache"

	| transition |
	transition := transitions
		detect: [:each | each isDST]
		ifNone: [nil].
	^yearStartDst := transition
		ifNil: [SmallInteger maximumValue]
		ifNotNil: [transition asDateAndTimeUTC year].
%

! Class implementation for 'TimeZoneTransition'

!		Instance methods for 'TimeZoneTransition'

category: 'other'
method: TimeZoneTransition
= aTimeZoneTransition

	^(aTimeZoneTransition isKindOf: TimeZoneTransition)
		and: [self transitionTimeUTC	= aTimeZoneTransition transitionTimeUTC
		and: [self offsetFromUTC 		= aTimeZoneTransition offsetFromUTC
		and: [self isDST 					= aTimeZoneTransition isDST
		and: [self abbreviation 		= aTimeZoneTransition abbreviation]]]].
%

category: 'other'
method: TimeZoneTransition
abbreviation

	^abbreviation.
%

category: 'other'
method: TimeZoneTransition
asDateAndTimeUTC

	^DateAndTime
		posixSeconds: transitionTime
		offset: Duration zero.
%

category: 'other'
method: TimeZoneTransition
hash

	^transitionTime hash.
%

category: 'other'
method: TimeZoneTransition
isDST

	^isDST.
%

category: 'other'
method: TimeZoneTransition
localTimeTypeID: anInteger
	"Borrow the offsetFromUTC instance variable for a moment"

	offsetFromUTC := anInteger.
%

category: 'other'
method: TimeZoneTransition
offsetFromUTC

	^offsetFromUTC.
%

category: 'other'
method: TimeZoneTransition
printOn: aStream

	| dt duration |
	duration := Duration seconds: offsetFromUTC.
	dt := DateAndTime
		posixSeconds: transitionTime
		offset: duration.
	dt printOn: aStream.
	aStream space.
	duration printOnHoursMinutes: aStream.
	aStream space.
	abbreviation printOn: aStream.
%

category: 'other'
method: TimeZoneTransition
transitionTime: anInteger

	transitionTime := anInteger.
%

category: 'other'
method: TimeZoneTransition
transitionTimeLocal

	^transitionTime + offsetFromUTC.
%

category: 'other'
method: TimeZoneTransition
transitionTimeUTC

	^transitionTime.
%

category: 'other'
method: TimeZoneTransition
typeList: anArray

	| data |
	data := anArray at: offsetFromUTC.	"temporary use as localTimeTypeID"
	offsetFromUTC := data at: 1.				"now used for its named purpose"
	isDST := data at: 2.
	abbreviation := data at: 3.
%

! Class extensions for 'Behavior'

!		Instance methods for 'Behavior'

category: 'Category'
method: Behavior
category

"Returns the classCategory instance variable of the receiver.  If the receiver's
 category is nil, returns its superclass's category."

| categ supercls |
categ := self _classCategory .
supercls := self superClass .
categ ifNil: [
  supercls == Object ifTrue:[
    self objectSecurityPolicy == SystemObjectSecurityPolicy
      ifTrue:[  ^ 'Kernel' ]
      ifFalse:[ ^ 'User Classes' ].
  ].
  supercls == nil ifTrue: [ ^'Kernel' ].
  ^ supercls category
].
^ categ
%

category: 'Browser Methods'
method: Behavior
compiledMethodAt: aSelector environmentId: envId otherwise: notFoundVal
  ^ self compiledMethodAt: aSelector environmentId: envId otherwise: notFoundVal
         usePackages: false
%

category: 'Browser Methods'
method: Behavior
compiledMethodAt: aSelector environmentId: envId otherwise: notFoundVal usePackages: usePkg

"Returns the compiled method associated with the argument aSelector (a String).
 The argument must be a selector in the receiver's method dictionary; if it is
 not, this method returns notFoundVal.
 If usePkg is true, looks in GsPackagePolicy, then in persistent method dicts;
 else looks in session method dicts then in persistent method dicts"

  <primitive: 2001>  "enter protected mode"
  | prot |
  prot := System _protectedMode .
  ^ [ | aSym meth md |
      (aSym := Symbol _existingWithAll: aSelector) ifNotNil:[
	(envId == 0 and:[ usePkg]) ifTrue:[
	  meth := GsPackagePolicy currentOrNil ifNotNil:[:pp | pp compiledMethodAt: aSym for: self ].
	] ifFalse:[
	  (md := self transientMethodDictForEnv: envId) ifNotNil:[
	    meth := md at: aSym otherwise: notFoundVal .
	  ]
	].
	meth ifNil:[
	  (md := self persistentMethodDictForEnv: envId ) ifNotNil:[
	    meth := md at: aSym otherwise: notFoundVal .
	  ].
	].
      ].
      meth ifNil:[ notFoundVal]
    ] ensure:[
      prot _leaveProtectedMode
    ].
%

category: 'Browser Methods'
method: Behavior
compiledMethodAt: aSelector environmentId: envId usePackages: usePkg
| aMeth |
aMeth := self compiledMethodAt: aSelector environmentId: envId otherwise: nil
		usePackages: usePkg .
aMeth == nil ifTrue:[ self _error: #rtErrKeyNotFound args: { aSelector } ].
^ aMeth
%

category: 'Enumerating'
method: Behavior
env: envId categorysDo: aBlock
  "evaluates aBlock for each method category of receiver
   in specified environment. Returns the receiver.

   aBlock should be a two argument block
   expecting the args  categoryNameSymbol ,   selectorsSet.
   If the package manager is active in the current session,
   aBlock may be invoked more than once for each category name.
   The iteration is done directly over the receiver's categories."

  envId == 0 ifTrue:[
    GsPackagePolicy currentOrNil ifNotNil:[:pp| pp categorysDo: aBlock for: self ].
  ].
  self env: envId baseCategorysDo: aBlock
%

category: 'Browser Methods'
method: Behavior
includesSelector: aString environmentId: envId

^ (self compiledMethodAt: aString environmentId: envId otherwise: nil
	usePackages: false) ~~ nil
%

category: 'Accessing the Method Dictionary'
method: Behavior
methodDictForEnv: envId
  ^ self methodDictForEnv: envId usePackages: false
%

category: 'Accessing the Method Dictionary'
method: Behavior
methodDictForEnv: envId usePackages: usePkg
 | dict |
 (self persistentMethodDictForEnv: envId ) ifNotNil:[:md |
   dict := self _copyDictForQuery: md .
 ].
 dict ifNil:[ dict := self _newMethodDictForQuery ].
 (envId == 0 and:[ usePkg]) ifTrue:[
   GsPackagePolicy currentOrNil ifNotNil:[:pp| pp copyMethodDictFor: self into: dict]
 ] ifFalse:[
   (self transientMethodDictForEnv: envId ) ifNotNil:[:md |
     dict addAll: md
   ].
 ].
 ^ dict
%

category: 'Accessing the Method Dictionary'
method: Behavior
selectorsForEnvironment: envId
  ^ self selectorsForEnvironment: envId usePackages: false
%

category: 'Accessing the Method Dictionary'
method: Behavior
selectorsForEnvironment: envId usePackages: usePkg

"Returns an Array of Symbols, consisting of all of the message selectors
 defined by the receiver.  (Selectors inherited from superclasses are not
 included.)  For keyword messages, the Symbol includes each of the keywords,
 concatenated together.
 If usePkg is true, result consists of persistent methods
 plus GsPackagePolicy methods ; if false  persistent methods plus
 session methods."

 <primitive: 2001>  "enter protected mode"
 | set prot |
 prot := System _protectedMode .
 [ | aDict |
   set := IdentitySet new.
   (aDict := self persistentMethodDictForEnv: envId ) ifNotNil:[
     set addAll: aDict keys.
   ].
   (envId == 0 and:[ usePkg]) ifTrue:[
     GsPackagePolicy currentOrNil ifNotNil:[:pp| pp  selectorsFor: self into: set].
   ] ifFalse:[
     (aDict := self transientMethodDictForEnv: envId) ifNotNil:[
       set addAll: aDict keys.
     ].
   ].
 ] ensure:[
   prot _leaveProtectedMode
 ].
 ^ set asArray .
%

category: 'Accessing the Method Dictionary'
method: Behavior
whichClassIncludesSelector: aString environmentId: envId
  ^ self whichClassIncludesSelector: aString environmentId: envId usePackages: false
%

category: 'Accessing the Method Dictionary'
method: Behavior
whichClassIncludesSelector: aString environmentId: envId usePackages: usePkg

"If the selector aString is in the receiver's method dictionary,
 returns the receiver.  Otherwise, returns the most immediate superclass
 of the receiver where aString is found as a message selector.  Returns
 nil if the selector is not in the method dictionary of the receiver or
 any of its superclasses.
 If usePkg is true, result consists of persistent methods
 plus GsPackagePolicy methods ; if false  persistent methods plus
 session methods."

  | currClass aSymbol |
  aSymbol := Symbol _existingWithAll: aString .
  aSymbol ifNil:[ ^ nil ].

  currClass := self.
  envId ~~ 0 ifTrue:[
    [ currClass == nil ] whileFalse:[
      (currClass compiledMethodAt: aSymbol environmentId: envId otherwise: nil
                  usePackages: usePkg) ifNotNil:[
         ^currClass
      ].
      currClass := currClass superclassForEnv: envId
    ].
  ] ifFalse:[
    [ currClass == nil ] whileFalse:[
      (currClass compiledMethodAt: aSymbol environmentId: envId otherwise: nil
              usePackages: usePkg) ifNotNil:[ ^ currClass ].
      currClass := currClass superClass
    ].
  ].
  ^ nil
%

category: 'Private'
method: Behavior
_copyDictForQuery: aDictionary
  | res |
  (System myUserProfile _hasPrivilegeBit: 12"CodeModification" ) ifTrue:[ 
     ^ aDictionary copy 
  ].
  res := IdentityKeyValueDictionary new.
  aDictionary keysAndValuesDo:[:k :v| res at: k put: v ].
  ^ res
%

category: 'Accessing the Method Dictionary'
method: Behavior
_fullMethodDictEnv0

^ self _fullMethodDictEnv: 0
%

category: 'Accessing the Method Dictionary'
method: Behavior
_fullMethodDictEnv: envId

"Returns a dictionary of combined base and override methods.
 Does not include the transient method dictionary.
 For envId==0 only,  includes the GsPackagePolicy contents.
 Used by ClassOrganizer."
 | res |
 res := SymbolKeyValueDictionary new .
 (self persistentMethodDictForEnv: envId) ifNotNil:[ :aDict |
    aDict keysAndValuesDo:[:k :v | res at: k put: v ].
 ].
 envId == 0 ifTrue:[
   GsPackagePolicy currentOrNil ifNotNil:[:pp| pp copyMethodDictFor: self into: res ].
 ].
^ res
%

category: 'Private'
method: Behavior
_newMethodDictForQuery
  "fix 50620"
  ^ ((System myUserProfile _hasPrivilegeBit: 12"CodeModification" ) 
      ifTrue:[ GsMethodDictionary] ifFalse:[ IdentityKeyValueDictionary ]) new
%

category: 'Browser Methods'
method: Behavior
_selectorWithSource: aString

"Returns the selector for the environment 0 method
 whose source string is identical to aString."

self _fullMethodDictEnv0 keysAndValuesDo:[:aSelector :aMethod |
  (aMethod _sourceString == aString) ifTrue: [^ aSelector ]
].
^nil
%

category: 'Accessing the Method Dictionary'
method: Behavior
_topazMethodLookup: aString env: envId usePackages: usePkgBool
  "Returns an Array   { actualSelector , class } "
  | sel |
  sel := aString .
  ^ { sel .
      self whichClassIncludesSelector: sel environmentId: envId
        usePackages: usePkgBool
    }
%

category: 'Enumerating'
method: Behavior
_unifiedCategorys: envId
  | cats |
  cats := self _baseCategorys: envId .
  cats ifNil:[ cats := self _newMethodDictForQuery ] ifNotNil:[ self _copyDictForQuery: cats ].
  envId == 0 ifTrue:[
    cats := cats ifNil:[ self _newMethodDictForQuery ] ifNotNil:[ cats copy ].
    GsPackagePolicy currentOrNil ifNotNil:[:pp| pp copyCategoryDictFor: self into: cats ].
  ].
  ^ cats
%

! Class extensions for 'DateAndTime'

!		Class methods for 'DateAndTime'

removeallmethods DateAndTime
removeallclassmethods DateAndTime

category: 'other'
classmethod: DateAndTime
clockPrecision
"  Answer a <Duration> such that after that period of time passes,
   #now is guaranteed to give a different result.
"
	^ Duration seconds: 1.0e-6  
%

category: 'Migration'
classmethod: DateAndTime
migrateNew
  "Use instance creation protocol so SmallDateAndTime creation works"
  self shouldNotImplement: #migrateNew
%

category: 'Instance Creation'
classmethod: DateAndTime
now 
  " Answer a SmallDateAndTime if possible, or a DateAndTime, representing the current 
   date and time in the local time specified by the implementation."
  | posixMicrosec us res ofs |
  posixMicrosec := System _timeGmtMicroSeconds .
  us := posixMicrosec - 978307200000000 . "microsecs from 2001"
	res := self _smallFromMicrosecs: us offset: 0 .
	res ifNil:[  | sd |
    sd := ScaledDecimal numerator: us denominator: 1000000 scale: 6 .
    ^ self basicNew _secondsUTC: sd offsetSeconds: nil 
  ].
	ofs := self _zoneOffsetAtPosix: posixMicrosec // 1000000 .
	res := self _smallFromMicrosecs: us offset: ofs . 
	res ifNotNil:[ ^ res ] .
  (res := self basicNew) _secondsUTC: us asFloat / 1000000.0 offsetSeconds: nil .
  ^ res.
%

category: 'Instance Creation'
classmethod: DateAndTime
nowWithScale: subsecondResolution
   self deprecated: 'DateAndTime class>>nowWithScale: deprecated v3.6. use #now '.
   ^ self now
%

category: 'Instance Creation'
classmethod: DateAndTime
posixSeconds: aNumber offset: aDuration
  "Return a SmallDateAndTime if possible without loosing precision.
   aNumber is UTC time in seconds since 1970, 
   aDuration is offset in seconds from UTC specifying a timezone. "
  (self _scaledDecimal6mantissa: aNumber) ifNotNil:[:m | | res us ofs |
    us := m - 978307200000000 .
    ofs := aDuration ifNotNil:[ aDuration asSeconds ]
          ifNil:[ res := self _smallFromMicrosecs: us offset: 0 .
                  res ifNil:[ ^ self basicNew _posixSeconds: aNumber offset: nil ].
                  self _zoneOffsetAtUTC: res ].
    res := self _smallFromMicrosecs: us offset: ofs .
    res ifNil:[ ^ self basicNew _posixSeconds: aNumber offset: aDuration].
    ^ res
  ].
  ^ self basicNew _posixSeconds: aNumber offset: aDuration 
%

category: 'Instance Creation'
classmethod: DateAndTime
secondsLocal: aNumber offset: aDuration
  "Return a SmallDateAndTime if possible without loosing precision.
   aNumber is local time in seconds since 2001, 
   aDuration is offset in seconds from UTC specifying a timezone. "
  (self _scaledDecimal6mantissa: aNumber) ifNotNil:[:us | | res ofs |
    ofs := aDuration ifNotNil:[ aDuration asSeconds ]
            ifNil:[ res := self _smallFromMicrosecs: us offset: 0 .
                    res ifNil:[ ^ self basicNew _secondsLocal: aNumber offset: nil ].
                    self _zoneOffsetAtLocal: res ].
    res := self _smallFromMicrosecs: us - (ofs * 1000000) offset: ofs .
    res ifNil:[ ^ self basicNew _secondsLocal: aNumber offset: aDuration ].
    ^ res
  ].
  ^ self basicNew _secondsLocal: aNumber offset: aDuration 
%

category: 'other'
classmethod: DateAndTime
secondsSince2001

	"^DateTime now asSecondsGmt - 3155760000."
	^System _timeGmtFloat - 978307200.0  .
%

category: 'Instance Creation'
classmethod: DateAndTime
secondsUTC: aNumber offsetSeconds: anOffset
  "Return a SmallDateAndTime if possible without loosing precision.
   aNumber is UTC time in seconds since 2001, 
   aDuration is offset in seconds from UTC specifying a timezone. "
  (self _scaledDecimal6mantissa: aNumber) ifNotNil:[:us | | res ofs |
    ofs := anOffset ifNil:[
              res := self _smallFromMicrosecs: us offset: 0 .
              res ifNil:[ ^ self basicNew _secondsUTC: aNumber offsetSeconds: nil ].
              self _zoneOffsetAtUTC: res .
    ].
    res := self _smallFromMicrosecs: us offset: ofs .
    res ifNil:[ ^ self basicNew _secondsUTC: aNumber offsetSeconds: anOffset ].
    ^ res
  ].
  ^ self basicNew _secondsUTC: aNumber offsetSeconds: anOffset 
%

category: 'Deprecated'
classmethod: DateAndTime
setDefaultScale: anIntOrNil
   "anIntOrNil should be nil or a SmallInteger in the range 0 .. 10 .
    It specifies the scale of a ScaledDecimal. "

   self deprecated: 'DateAndTime class>>setDefaultScale: deprecated v3.6. All DateAndTimes/SmallDateAndTimes have 6 digits of scale; this method has no effect'.
   DefaultScale := anIntOrNil ifNotNil: [anIntOrNil asInteger].
%

category: 'Private'
classmethod: DateAndTime
_scaledDecimal6mantissa: aNumber
  "Return a mantissa of a ScaledDecimal with scale 6 and equal to aNumber 
   if aNumber has precision no greater than 0.000001, otherwise return nil"
  | f |
  aNumber _isSmallInteger ifTrue:[ ^ aNumber * 1000000 ].
  aNumber _isScaledDecimal ifTrue:[ | sc |
     (sc := aNumber scale) == 6 ifTrue:[ ^ aNumber mantissa ].
     sc < 6 ifTrue:[ ^ (aNumber asScaledDecimal: 6) mantissa  ]
            ifFalse:[ ^ nil ]
  ].
  f := aNumber asFloat .
  ((f truncateTo: 0.000001) - f) abs < 0.000001 ifTrue:[
     ^ (aNumber asScaledDecimal: 6) mantissa 
  ].
  ^ nil
%

category: 'Private'
classmethod: DateAndTime
_smallFromMicrosecs: aSmallInteger offset: offsetSmallInt
  "If receiver is DateAndTime or SmallDateAndTime ,
   returns a SmallDateAndTime if args within range. 
   Otherwise returns nil.
   aSmallInteger is positive offset from 2001 in microseconds.
   offsetSmallInt is in seconds ."
  <primitive: 1112>
   ^ self _primitiveFailed: #_smallFromMicrosecs:offset:
%

!		Instance methods for 'DateAndTime'

category: 'Converting'
method: DateAndTime
asCanonicalForm
	"Answer self, or, if I am a DateAndTime with an equivalent
	SmallDateAndTime, answer that SmallDateAndTime."

	| cls res |
	(cls := self class) ~~ SmallDateAndTime
		ifTrue: [ 
			cls == DateAndTime
				ifTrue: [ 
					res := cls secondsLocal: self asSeconds offset: self offset.
					res class == SmallDateAndTime
						ifTrue: [ ^ res ] ] ].
	^ self
%

category: 'private'
method: DateAndTime
asStringMs
  "prints with millisecond resolution"
| strm |
strm := AppendStream on: String new .
self printLocalWithSubsecondDigits: 3 on: strm .
^ strm contents
%

category: 'private'
method: DateAndTime
asStringUs
  "prints with microsecond resolution"
| strm |
strm := AppendStream on: String new .
self printLocalWithSubsecondDigits: 6 on: strm .
^ strm contents
%

category: 'initialize-release'
method: DateAndTime
currentTimeZone

	^TimeZone current.
%

category: 'private'
method: DateAndTime
printLocalMsOn: aStream
    "print the receiver on aStream, omitting the timezone offset and using space instead of T.
     printed time is rounded to 0.001 second."
  self printLocalWithSubsecondDigits: 3 on: aStream.
%

category: 'private'
method: DateAndTime
printLocalOn: aStream
  "print the receiver on aStream, omitting the timezone offset and using space instead of T"
  | anArray |
  anArray := self asFloatParts.
  self printDateFrom: anArray on: aStream.
  aStream nextPut: $ .
  self printTimeFrom: anArray on: aStream.
%

category: 'private'
method: DateAndTime
printLocalWithSubsecondDigits: anInteger on: aStream
    "print the receiver on aStream, omitting the timezone offset and using space instead of T.
     Print the given number of subsecond digits, rounding or printing additional trailing 0s."
 | arr |
  anInteger == 0 ifTrue:[ arr := self asIntegerParts ] 
    ifFalse:[ arr := self asFloatParts .
      anInteger = 6 ifFalse:[
      arr at: 7 put:(ScaledDecimal for: (arr at: 7) scale: anInteger)] ].
  self printDateFrom: arr on: aStream.
  aStream nextPut: $ .
  self printTimeFrom: arr on: aStream.
%

category: 'New Indexing Comparison'
method: DateAndTime
_classSortOrdinal

^ 70
%

category: 'private'
method: DateAndTime
_topazAsString
 ^ self asStringMs
%

! Class extensions for 'DateAndTimeANSI'

!		Class methods for 'DateAndTimeANSI'

removeallmethods DateAndTimeANSI
removeallclassmethods DateAndTimeANSI

category: 'other'
classmethod: DateAndTimeANSI
clockPrecision
	"Answer a <Duration> such that after that period of time passes,
	#now is guaranteed to give a different result.
	Ideally implementations should answer the least such duration."

	^Duration seconds: 1.
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
fromString: aString
	"YYYY-MM-DDTHH:MM:SS+HH:MM"

  	| offsetDivider offset secondsEnd | 
	offsetDivider := aString findString: ':' startingAt: 19.
	offset := offsetDivider > 0 
		ifTrue: [secondsEnd := offsetDivider - 4.
		    Duration
			days:    0
			hours:   (aString copyFrom: offsetDivider - 2 to: offsetDivider - 1 ) asNumber *
								  ((aString at: offsetDivider - 3) == $+ ifTrue: [1] ifFalse: [-1])
			minutes: (aString copyFrom: offsetDivider + 1 to: aString size) asNumber
			seconds: 0]
		ifFalse: [secondsEnd := aString size.
		    nil].

	^self
		year:   (aString copyFrom:  1 to:  4) asNumber
		month:  (aString copyFrom:  6 to:  7) asNumber
		day:    (aString copyFrom:  9 to: 10) asNumber
		hour:   (aString copyFrom: 12 to: 13) asNumber
		minute: (aString copyFrom: 15 to: 16) asNumber
		second: (aString copyFrom: 18 to: secondsEnd) asNumber
		offset: offset
%

category: 'Migration'
classmethod: DateAndTimeANSI
migrateNew

	^self basicNew.
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
new

"Disallowed"

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
now
"  Answer a <DateAndTime> representing the current date and time in the local time specified by the
   implementation."

  | res |
  (res := super new) initializeAsNow.
  ^ res.
%

category: 'private'
classmethod: DateAndTimeANSI
partsFrom: secondsFromBase
	"#(year dayOfYear monthIndex dayOfMonth hour minute second)"
	| x y array year isLeapYear numDaysArr |
	array := Array new: 7.
      Float noInexactResultDo:[
	x := secondsFromBase .	"secondsFromBase is possibly a Float"
	array at: 7 put: x \\ 60 .
	x := x // 60 .	"minutes from base, an Integer"
      ].
	array at: 6 put: x \\ 60 .
	x := x // 60.	"hours from base"
	array at: 5 put: x \\ 24.
	x := x // 24.	"days from base"
	year := 2001.
	y := x // 146097.
	year := y * 400 + year.
	x := x - (y * 146097).		"days since beginning of 400-year cycle"

	y := x // 36524 min: 3.
	year := y * 100 + year.
	x := x - (y * 36524).		"days since beginning of 100-year cycle"

	y := x // 1461 min: 96.
	year := y * 4 + year.
	x := x - (y * 1461).			"days since beginning of 4-year cycle"

	y := x // 365 min: 3.
	year := y + year.
	x := x - (y * 365) + 1.		"days since beginning of year"
	array at: 1 put: year;
	      at: 2 put: x .
	x <= 31 ifTrue: [
		 array at: 3 put: 1;
			at: 4 put: x .
	         ^ array
	].
	x <= 59 ifTrue: [
		 array at: 3 put: 2;
			at: 4 put: x - 31 .
		^ array .
	].
	isLeapYear := year \\ 4 == 0 _and: [year \\ 100 ~~ 0 _or: [year \\ 400 == 0]].
	isLeapYear ifTrue: [
		x == 60 ifTrue: [
			array at: 3 put: 2;
				at: 4 put: 29 .
			^ array .
		].
		x := x - 1.
	].
	array at: 3 put: 3.
	x := x - 59.
	numDaysArr := #(31 30 31 30 31 31 30 31 30 31)  .
	1 to: numDaysArr size do:[:j | | each |
		each := numDaysArr at: j .
		x <= each ifTrue: [
			array at: 4 put: x .
			^ array .
		].
		array at: 3 put: (array at: 3) + 1.
		x := x - each.
	].
	self error: 'invalid date'.
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
posixSeconds: aNumber offset: aDuration
	"Unix time, or POSIX time, is a system for describing instances in time,
	defined as the number of seconds that have elapsed since 00:00:00 Coordinated
	Universal Time (UTC), 1 January 1970, not counting leap seconds."

	| res |
	(res := super new) _posixSeconds: aNumber offset: aDuration.
	 ^ res.
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
secondsLocal: aNumber offset: aDuration
  | res |
  (res := super new)
     _secondsLocal: aNumber offset: aDuration.
  ^ res
%

category: 'other'
classmethod: DateAndTimeANSI
secondsSince2001

	self subclassResponsibility: #secondsSince2001
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
secondsUTC: aNumber offset: aDuration
  ^ self secondsUTC: aNumber offsetSeconds: (aDuration ifNotNil:[ aDuration asSeconds])
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
secondsUTC: aNumber offsetSeconds: anOffset
  | res |
  (res := super new) _secondsUTC: aNumber offsetSeconds: anOffset.
  ^ res
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
year: year day: dayOfYear hour: hour minute: minute second: second
"  Answer the least <DateAndTime> which is the second <second> of the minute <minute> of the hour
   <hour> of the day <dayOfYear> of the year <year> in the local time specified by the implementation. 
   The second must be a <number> greater than or equal to 0 and strictly less than 60.  floats are 
      allowed and implement subsecond times.
   The minute must be an <integer> between 0 and 59 inclusive. 
   The hour must be an <integer> between 0 and 23 inclusive. 
   The day must be an <integer> between 1 and 366 inclusive. 
   An implementation may not impose any limits on the year other than those imposed on <integer> constants.
   It is possible that the time specified does not exist in the local time specified by the implementation.
   If there is a time change such that the local time is set forward and the time specified is in the
   interregnum, then that time does not exist in the local time. If there is a time change that sets the 
   local time back there are times which are ambiguous. 
   Years are in the astronomical Gregorian calendar, in which the year 1 A.D. is year 1. The year 1 B.C. is 
   year 0, and the year 2 B.C. is year -1 in the astronomical Gregorian calendar and so on. 
     Parameters
        year <integer> unspecified
        dayOfYear <integer> unspecified
        hour <integer> unspecified
        minute <integer> unspecified
        second <number> unspecified
     Errors
        month is not between 1 and 12 inclusive.
        dayOfYear greater than the number of days in the year year of the astronomical Gregorian
        calendar.
        hour is not between 0 and 23 inclusive.
        minute is not between 0 and 59 inclusive.
        second is not greater than or equal to 0 and strictly less than 60.
        the time specified does not exist."

	^self
		year: year
		day: dayOfYear
		hour: hour
		minute: minute
		second: second
		offset: nil.
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
year: year day: dayOfYear hour: hour minute: minute second: second offset: offset
"  Answer the least <DateAndTime> which is the second <second> of the minute <minute> of the hour
   <hour> of the day <dayOfYear> of the year <year>, offset from UTC by <offset>.
   The second must be a <number> greater than or equal to 0 and strictly less than 60.  floats are 
      allowed and implement subsecond times.
   The minute must be an <integer> between 0 and 59 inclusive. 
   The hour must be an <integer> between 0 and 23 inclusive. 
   The day must be an <integer> between 1 and 366 inclusive. 
   An implementation may not impose any limits on the year other than those imposed on <integer> constants.
   It is possible that the time specified does not exist in the local time specified by the implementation.
   If there is a time change such that the local time is set forward and the time specified is in the
   interregnum, then that time does not exist in the local time. If there is a time change that sets the 
   local time back there are times which are ambiguous. 
   The result is the least <DateAndTime> that conforms to the given parameters.
   Years are in the astronomical Gregorian calendar, in which the year 1 A.D. is year 1. The year 1 B.C. is 
   year 0, and the year 2 B.C. is year -1 in the astronomical Gregorian calendar and so on. 
     Parameters
        year <integer> unspecified
        dayOfYear <integer> unspecified
        hour <integer> unspecified
        minute <integer> unspecified
        second <number> unspecified
        offset <Duration> unspecified
     Errors
        month is not between 1 and 12 inclusive.
        dayOfYear greater than the number of days in the year year of the astronomical Gregorian
        calendar.
        hour is not between 0 and 23 inclusive.
        minute is not between 0 and 59 inclusive.
        second is not greater than or equal to 0 and strictly less than 60."

	| isLeapYear daysInYear x days secs |
	isLeapYear := year \\ 4 == 0 and: [year \\ 100 ~~ 0 or: [year \\ 400 == 0]].
	daysInYear := isLeapYear ifTrue: [366] ifFalse: [365].
	(1 <= dayOfYear and: [dayOfYear <= daysInYear]) 
		ifFalse: [(OutOfRange new name: 'dayOfYear' min: 1 max: daysInYear actual: dayOfYear) signal].
	(0 <= second and: [second < 60]) ifFalse: [(OutOfRange new name: 'second' min: 0 max: 60 actual: second) signal].
	(0 <= minute and: [minute < 60]) ifFalse: [(OutOfRange new name: 'minute' min: 0 max: 59 actual: minute) signal].
	(0 <= hour and: [hour < 24]) ifFalse: [(OutOfRange new name: 'hour' min: 1 max: 24 actual: hour) signal].
	x := year - 1901.
	days := x * 365
		+ (x // 4)
		- (x // 100)
		+ (x + 300 "1901 - 1601" // 400)
		+ dayOfYear
		- 36526.		"set base to 2001-01-01"
	secs := days * 24 + hour * 60 + minute * 60 + second.
	 ^self
	 	secondsLocal: secs
	 	offset: offset.
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
year: year month: month day: dayOfMonth hour: hour minute: minute second: second
"  Answer the least <DateAndTime> which is the second <second> of the minute <minute> of the hour
   <hour> of the day <dayOfMonth> of the month <month> of the year <year> in the local time 
   specified by the implementation. 
   The second must be a <number> greater than or equal to 0 and strictly less than 60.  floats are 
      allowed and implement subsecond times.
   The minute must be an <integer> between 0 and 59 inclusive. 
   The hour must be an <integer> between 0 and 23 inclusive. 
   The day must be an <integer> between 1 and 366 inclusive. 
    An implementation may not impose any limits on the year other than those imposed on <integer> constants.
   If there is a time change such that the local time is set forward and the time specified is in the
   interregnum, then that time does not exist in the local time. If there is a time change that sets the 
   local time back there are times which are ambiguous. 
   Years are in the astronomical Gregorian calendar, in which the year 1 A.D. is year 1. The year 1 B.C. is 
   year 0, and the year 2 B.C. is year -1 in the astronomical Gregorian calendar and so on. 
     Parameters
        year <integer> 
        month <integer>
        dayOfMonth <integer> 
        hour <integer> 
        minute <integer> 
        second <number> 
     Errors
        month is not between 1 and 12 inclusive.
        dayOfYear greater than the number of days in the year year of the astronomical Gregorian
        calendar.
        hour is not between 0 and 23 inclusive.
        minute is not between 0 and 59 inclusive.
        second is not greater than or equal to 0 and strictly less than 60.
        the time specified does not exist."

	^self
		year: year
		month: month
		day: dayOfMonth
		hour: hour
		minute: minute
		second: second
		offset: nil.
%

category: 'Instance Creation'
classmethod: DateAndTimeANSI
year: year month: month day: dayOfMonth hour: hour minute: minute second: second offset: offset
"  Answer the least <DateAndTime> which is the second <second> of the minute <minute> of the hour
   <hour> of the day <dayOfMonth> of the month <month> of the year <year> offset from UTC by <offset>. 
   The minute must be an <integer> between 0 and 59 inclusive. 
   The hour must be an <integer> between 0 and 23 inclusive. 
   The day must be an <integer> between 1 and 366 inclusive. 
   An implementation may not impose any limits on the year other than those imposed on <integer> constants.
   It is possible that the time specified does not exist in the local time specified by the implementation.
   If there is a time change such that the local time is set forward and the time specified is in the
   interregnum, then that time does not exist in the local time. If there is a time change that sets the 
   local time back there are times which are ambiguous. 
   The result is the least <DateAndTime> that conforms to the given parameters.
     Parameters
        year <integer> 
        month <integer> 
        dayOfMonth <integer> 
        hour <integer> 
        minute <integer> 
        second <number> 
        offset <Duration> 
     Errors
        month is not between 1 and 12 inclusive.
        dayOfMonth greater than the number of days in the month month of year year of the
        astronomical Gregorian calendar.
        hour is not between 0 and 23 inclusive.
        minute is not between 0 and 59 inclusive.
        second is not greater than or equal to 0 and strictly less than 60."

	| isLeapYear dayOfYear daysPerMonth daysInMonth |
	(1 <= month and: [month <= 12]) ifFalse: [(OutOfRange new name: 'month' min: 1 max: 12 actual: month) signal].
	isLeapYear := year \\ 4 == 0 and: [year \\ 100 ~~ 0 or: [year \\ 400 == 0]].
	daysPerMonth := isLeapYear
		ifTrue: [#(31 29 31 30 31 30 31 31 30 31 30 31)]
		ifFalse: [#(31 28 31 30 31 30 31 31 30 31 30 31)].
	daysInMonth := daysPerMonth at: month.
	(1 <= dayOfMonth and: [dayOfMonth <= daysInMonth]) 
		ifFalse: [ (OutOfRange new name: 'dayOfMonth' min: 1 max: daysInMonth actual: dayOfMonth) signal].
	dayOfYear := (#(0 31 59 90 120 151 181 212 243 273 304 334) at: month) + dayOfMonth.
	(month > 2 and: [isLeapYear]) ifTrue: [dayOfYear := dayOfYear + 1].
	^self
		year: year
		day: dayOfYear
		hour: hour
		minute: minute
		second: second
		offset: offset.
%

category: 'private'
classmethod: DateAndTimeANSI
_zoneOffsetAtLocal: aDateAndTime
  ^ (TimeZone current ifNil:[ TimeZoneInfo default]) offsetAtLocal: aDateAndTime
%

category: 'private'
classmethod: DateAndTimeANSI
_zoneOffsetAtPosix: posixSeconds
  ^ (TimeZone current ifNil:[ TimeZoneInfo default]) _offsetAtPosix: posixSeconds
%

category: 'private'
classmethod: DateAndTimeANSI
_zoneOffsetAtUTC: aDateAndTime
  ^ (TimeZone current ifNil:[ TimeZoneInfo default]) offsetAtUTC: aDateAndTime
%

!		Instance methods for 'DateAndTimeANSI'

category: 'Arithmetic'
method: DateAndTimeANSI
+ operand
	"Answer a <DateAndTime> that represents the UTC time that is operand after the receiver and
	whose local time is the same as the receiver's. If operand is less than <Duration factory> #zero,
	the result is the <DateAndTime> that is that is the absolute value of operand before the receiver."

	^self class
		secondsUTC: (self _addSeconds: operand asSeconds )
		offsetSeconds: self _offsetSeconds .
%

category: 'Arithmetic'
method: DateAndTimeANSI
- operand
	"If operand is a <DateAndTime>, answer a <Duration> whose value is the period of time between
	the operand and the receiver. If operand is a <DateAndTime> prior to the receiver then the result
	is a <Duration> less than <Duration factory> #zero.
	If operand is a <Duration>, answer a new <DateAndTime> which represents the UTC time that is
	operand before the receiver and whose local time is the same as the receiver's. If operand is a
	duration less than <Duration factory> #zero then the result is a <DateAndTime> that is the
	absolute value of operand after the receiver."

	^(operand isKindOf: Duration) ifTrue: [
		self class
			secondsUTC: (self _addSeconds: operand asSeconds negated)
			offsetSeconds: self _offsetSeconds .
	] ifFalse: [
		Duration seconds: self asSeconds - operand asSeconds.
	].
%

category: 'Comparing'
method: DateAndTimeANSI
< aDateAndTime
"  Answer true if the UTC time represented by operand follows the UTC time represented by the
   receiver. Answer false otherwise.
   If the offsets of the receiver and operand are the same then their order is determined by their
   lexical order in the sequence #year, #month, #day, #hour24, #minute, #second. If their
   offsets differ then result is the same as if receiver asUTC < operand asUTC were evaluated."

	^self asSeconds < aDateAndTime asSeconds.
%

category: 'Comparing'
method: DateAndTimeANSI
= aMagnitude
"  Answer true if the comparand conforms to <DateAndTime> and if it represents the
   same UTC time as the receiver. Answer false otherwise. The local times of the receiver and
   operand are ignored."

	^(aMagnitude isKindOf: DateAndTimeANSI) _and: [self asSeconds = aMagnitude asSeconds].
%

category: 'Converting'
method: DateAndTimeANSI
asDays

	| x |
	x := self asSeconds .	"seconds from base"
	x := x // 60.	"minutes from base"
	x := x // 60.	"hours from base"
	x := x // 24.	"days from base"
	^x.
%

category: 'private'
method: DateAndTimeANSI
asFloatParts
	"#(year dayOfYear monthIndex dayOfMonth hour minute second)"
	^ self class partsFrom: (ScaledDecimal for: self asSeconds + self _offsetSeconds scale: 6) 	
           "seconds from base"
%

category: 'private'
method: DateAndTimeANSI
asIntegerParts
	"#(year dayOfYear monthIndex dayOfMonth hour minute second)"

	^ self class partsFrom: (self asSeconds + self _offsetSeconds ) roundedNoFpe "seconds from base"
%

category: 'Converting'
method: DateAndTimeANSI
asLocal
"  Answer a <DateAndTime> that represents the same UTC time as the receiver but in the local time
  specified by the implementation."

	^self class
		secondsUTC: self asSeconds
		offsetSeconds: nil.
%

category: 'private'
method: DateAndTimeANSI
asParts
	"#(year dayOfYear monthIndex dayOfMonth hour minute second)"

	^self asFloatParts.
%

category: 'Converting'
method: DateAndTimeANSI
asPosixSeconds
	"The number of seconds that have elapsed since 00:00:00 Coordinated
	Universal Time (UTC), 1 January 1970, not counting leap seconds. "

	^ self asSeconds + 978307200.
%

category: 'Converting'
method: DateAndTimeANSI
asSeconds
	"The number of seconds that have elapsed since 00:00:00 Coordinated
	Universal Time (UTC), 1 January 2001, not counting leap seconds."

	^ seconds
%

category: 'Formatting'
method: DateAndTimeANSI
asString
^ self printStringWithRoundedSeconds
%

category: 'Converting'
method: DateAndTimeANSI
asUTC
"  Answer a <DateAndTime> that represents the same absolute time as the receiver but in the local
   time UTC.
   The UTC local time must use the Gregorian calendar. <DateAndTimes> representing UTC times 
   prior to the	adoption of the Gregorian calendar must use the retrospective astronomical 
   Gregorian calendar. It is an invariant that
	<DateAndTime> asUTC offset = Duration zero."

	^self class
		secondsLocal: self asSeconds
		offset: Duration zero.

%

category: 'Converting'
method: DateAndTimeANSI
beRounded
  seconds := seconds roundedNoFpe
%

category: 'initialize-release'
method: DateAndTimeANSI
currentTimeZone

	^ TimeZone default.
%

category: 'Accessing'
method: DateAndTimeANSI
dayOfMonth
"  Answer an <integer> between 1 and 31 inclusive representing the number of the day in the month,
   in the local time of the receiver."

	^self asParts at: 4.
%

category: 'Accessing'
method: DateAndTimeANSI
dayOfWeek
"  Answer an <integer> between 1 and 7 inclusive representing the number of the day in the week, in
   the local time of the receiver. Sunday is 1, Monday is 2, and so on."

	^ ((self asSeconds + self _offsetSeconds) // 60) // 60 // 24 + 1 \\ 7 + 1  "1 January 2001 was a Monday"
%

category: 'Accessing'
method: DateAndTimeANSI
dayOfWeekAbbreviation
"  Answer an <readableString> which is the abbreviation of the name, in the local time of the
   receiver, of the day of the week which includes the receiver."

	^self dayOfWeekName copyFrom: 1 to: 3.
%

category: 'Accessing'
method: DateAndTimeANSI
dayOfWeekName
"  Answer an <readableString> which is the name, in the local time of the receiver, of the day of the
   week which includes the receiver."

	^#('Sunday' 'Monday' 'Tuesday' 'Wednesday' 'Thursday' 'Friday' 'Saturday') at: self dayOfWeek.
%

category: 'Accessing'
method: DateAndTimeANSI
dayOfYear
"  Answer an <integer> between 1 and 366 inclusive representing the number of the day in the year,
   in the local time of the receiver, which includes the receiver."

	^self asParts at: 2.
%

category: 'Comparing'
method: DateAndTimeANSI
hash

	^ seconds hash.
%

category: 'Accessing'
method: DateAndTimeANSI
hour
"  Answer an <integer> between 0 and 23 inclusive representing the number of the hour in the day, in
   the local time of the receiver, which includes the receiver. It is implementation defined whether a
   given local time uses the 12-hour clock or the 24-hour clock, except that the UTC local time must
   use the 24-hour clock."

	^ ((self asSeconds + self _offsetSeconds) // 60) // 60 \\ 24.
%

category: 'Accessing'
method: DateAndTimeANSI
hour12
"  Answer an <integer> between 1 and 12 inclusive representing the hour in the day in the 12-hour
   clock of the local time of the receiver."

	^self hour - 1 \\ 12 + 1.
%

category: 'Accessing'
method: DateAndTimeANSI
hour24
"  Answer an <integer> between 0 and 23 inclusive representing the hour in the day in the 24-hour
   clock of the local time of the receiver."

	^self hour.
%

category: 'private'
method: DateAndTimeANSI
immediateInvariant
 "Instances of SmallDateAndTime and DateAndTime are created as invariant,
  instances of other classes are variant, for compatibility with previous releases."
 self class == DateAndTime ifTrue:[ super immediateInvariant]
%

category: 'initialize-release'
method: DateAndTimeANSI
initializeAsNow
  self isInvariant ifTrue:[ ^ ArgumentTypeError signal:'Attempt to modify invariant object'].
	self _seconds: self class secondsSince2001.
	offset := (self currentTimeZone transitionAtUTC: self) offsetFromUTC.
  self immediateInvariant .
%

category: 'Testing'
method: DateAndTimeANSI
isLeapYear
"  Answer true if the year, which includes the receiver, in the local time of the receiver is a leap year,
   false otherwise.
   Two <DateAndTime> objects that are equal can give different results for #isLeapYear. Equality
   depends on their UTC time whereas #isLeapYear depends on their local time."

	| year |
	year := self year.
	^year \\ 4 == 0 _and: [year \\ 100 ~~ 0 _or: [year \\ 400 == 0]].
%

category: 'Accessing'
method: DateAndTimeANSI
meridianAbbreviation
"  Answer a <readableString> that is the abbreviation, in the local time of the receiver, of the name of
   the half of the day, which includes the receiver."

	^self hour < 12
		ifTrue: ['AM']
		ifFalse: ['PM'].
%

category: 'Accessing'
method: DateAndTimeANSI
minute
"  Answer an <integer> between 0 and 59 inclusive representing the minute of hour in the local time
   of the receiver."

	^ ((self asSeconds + self _offsetSeconds) // 60) \\ 60.
%

category: 'Accessing'
method: DateAndTimeANSI
month
"  Answer an <integer> between 1 and 12 inclusive representing the number of the month in the year,
   in the local time of the receiver, which includes the receiver."

	^self asParts at: 3.
%

category: 'Accessing'
method: DateAndTimeANSI
monthAbbreviation
"  Answer a <readableString> that is the abbreviation of the name of the month, in the local time of
   the receiver, which includes the receiver."

	^self monthName copyFrom: 1 to: 3.
%

category: 'Accessing'
method: DateAndTimeANSI
monthName
"  Answer a <readableString> that is the name of the month, in the local time of the receiver, which
   includes the receiver."

	^#(
		'January' 'February' 'March'
		'April' 'May' 'June'
		'July' 'August' 'September'
		'October' 'November' 'December'
	) at: self month.
%

category: 'Accessing'
method: DateAndTimeANSI
offset
"  Answer a <Duration> representing the difference between the local time of the receiver and UTC at
  the time of the receiver."

	^Duration seconds: self _offsetSeconds .
%

category: 'Updating'
method: DateAndTimeANSI
offset: aDuration
"  Answer a <DateAndTime> equivalent to the receiver but with its local time being offset from UTC
   by offset. The impact of this on any other local time property is unspecified.
   Implementations may define a limit to the range of offset, but it must be at least
     -12:00:00 to 12:00:00 inclusive.
   It is an invariant that if x is a <Duration> in range then
     (<DateAndTime> offset: x) offset = x
   Parameters
     offset <Duration> unspecified"

  ^ self class secondsUTC: self asSeconds  offsetSeconds: aDuration asSeconds .
%

category: 'private'
method: DateAndTimeANSI
partsFrom: secondsFromBase
  ^self class partsFrom: secondsFromBase
%

category: 'Updating'
method: DateAndTimeANSI
posixSeconds: anInteger
	"Returns a new instance with specified time since UTC 1 January 1970 .

  Unix time, or POSIX time, is a system for describing instances in time,
	defined as the number of seconds that have elapsed since 00:00:00 Coordinated
	Universal Time (UTC), 1 January 1970, not counting leap seconds." 

  ^ self class secondsUTC: anInteger - 978307200 offsetSeconds: self _offsetSeconds
%

category: 'private'
method: DateAndTimeANSI
print: anArray on: aStream

	self printDateFrom: anArray on: aStream.
	aStream nextPut: $T.
	self printTimeFrom: anArray on: aStream.
	self offset printOnHoursMinutes: aStream.
%

category: 'private'
method: DateAndTimeANSI
printAnsiOn: aStream

	self
		print: self asFloatParts
		on: aStream.
%

category: 'private'
method: DateAndTimeANSI
printDateFrom: anArray on: aStream
	| x |
	x := anArray at: 1.
	x < 0 ifTrue: [aStream nextPut: $-].
	(x := x abs) < 1000 ifTrue: [aStream nextPut: $0].
	x < 100 ifTrue: [aStream nextPut: $0].
	x < 10 ifTrue: [aStream nextPut: $0].
	x printOn: aStream.
	aStream nextPut: $-.
	(x := anArray at: 3) < 10 ifTrue: [aStream nextPut: $0].
	x printOn: aStream.
	aStream nextPut: $-.
	(x := anArray at: 4) < 10 ifTrue: [aStream nextPut: $0].
	x printOn: aStream.
%

category: 'Formatting'
method: DateAndTimeANSI
printJsonOn: aStream
  self printStringWithRoundedSeconds printJsonOn: aStream  "fix 50391"
%

category: 'Formatting'
method: DateAndTimeANSI
printOn: aStream

	self printAnsiOn: aStream.
%

category: 'private'
method: DateAndTimeANSI
printRoundedOn: aStream

	self
		print: self asIntegerParts
		on: aStream.
%

category: 'Formatting'
method: DateAndTimeANSI
printString
 "Return a String with the UTC time of the receiver offset from UTC by the offset of the receiver. 
   The result is formatted as
         -YYYY-MM-DDThh:mm:ss.s+ZZ:zz:z 
    where
        - is the <Character> $- if the year is less than 0, otherwise omitted
        YYYY is the year left zero filled to four places
        - is the <Character> $-
        MM is the month of the year left zero filled to two places
        - is the <Character> $-
        DD is the day of the month left zero filled to two places
        T is the <Character> $T
        hh is the hour in the 24-hour clock left zero filled to two places
        : is the <Character> $:
        mm is the minute left zero filled to two places
        : is the <Character> $:
        ss is the second left zero filled to two places
        . is the <Character> $. and is present only if the fraction of a second is non-zero
        s is the fraction of a second and is present only if non-zero
        + is the <Character> $+ if the offset is greater than or equal to Duration zero
        and the <Character> $- if it is less
        ZZ is the hours of the offset left zero filled to two places
        : is the <Character> $:,
        zz is the minutes of the offset left zero filled to two places,
        : is the <Character> $: and is present only if the seconds of the offset is non-zero,
        z is the seconds of the offset including any fractional part and is present only if nonzero."

	^super printString.
%

category: 'private'
method: DateAndTimeANSI
printStringWithRoundedSeconds

	| stream |
	stream := AppendStream on: String new .
	self printRoundedOn: stream.
	^stream contents.
%

category: 'private'
method: DateAndTimeANSI
printTimeFrom: anArray on: aStream
	| x |
	(x := anArray at: 5) < 10 ifTrue: [aStream nextPut: $0].
	x printOn: aStream.
	aStream nextPut: $:.
	(x := anArray at: 6) < 10 ifTrue: [aStream nextPut: $0].
	x printOn: aStream.
	aStream nextPut: $:.
	x := anArray at: 7.
	"See bugs 36718, 40624, 40643, and 40883, 48822"
  x _isInteger ifTrue:[
	  x < 10 ifTrue:[ aStream nextPut: $0 ].
    x printOn: aStream.
  ] ifFalse:[
	 (x _isFloat or:[ x _isScaledDecimal]) ifFalse:[ x := x asFloat "handle fraction"].
	  x asInteger < 10 ifTrue:[ aStream nextPut: $0 ].
	  aStream nextPutAll: x asStringLocaleC
  ]
%

category: 'Converting'
method: DateAndTimeANSI
rounded
  | rnd secs |
	rnd := (secs := self asSeconds) roundedNoFpe .
  rnd = secs ifTrue:[ ^ self ].
  ^ self class secondsUTC: rnd offsetSeconds: self _offsetSeconds .
%

category: 'Accessing'
method: DateAndTimeANSI
second
"  Answer a <number> greater than or equal to 0 and strictly less than 60 representing the second of
   the minute of the local time of the receiver."

	^ self asSeconds + self _offsetSeconds \\ 60.
%

category: 'Accessing'
method: DateAndTimeANSI
timeZoneAbbreviation
"  Answer a <readableString> that is the abbreviation of the name, in the local time of the receiver, of
   the time zone of the receiver.

   Not implemented (bug #43388); the offset is returned.  Most offsets cannot be easily disambiguated 
   between the thousands of distint timezones. "

	^self timeZoneName
%

category: 'Accessing'
method: DateAndTimeANSI
timeZoneName
"  Answer a <readableString> that is the name in the local time of the receiver of the time zone of the
   receiver.
 
   Not implemented (bug #43388); the offset is returned.  Most offsets cannot be easily disambiguated 
   between the thousands of distint timezones. "

	| stream |
	stream := AppendStream on: String new.
	self offset printOnHoursMinutes: stream.
	^stream contents.
%

category: 'Accessing'
method: DateAndTimeANSI
year
"  Answer an <integer> the number of the year which includes the receiver."

	^self asParts at: 1.
%

category: 'private'
method: DateAndTimeANSI
_addSeconds: argSeconds
  ^ self asSeconds + argSeconds
%

category: 'Accessing'
method: DateAndTimeANSI
_offsetSeconds
  ^ offset
%

category: 'private'
method: DateAndTimeANSI
_posixSeconds: aNumber offset: aDuration
  self isInvariant ifTrue:[ ArgumentTypeError signal:'Attempt to modify invariant object'].
  self _seconds: aNumber - 978307200 .
  aDuration ifNil: [
    offset := self class _zoneOffsetAtUTC: self.
  ] ifNotNil: [
    offset  := aDuration asSeconds.
  ].
  self immediateInvariant .
%

category: 'private'
method: DateAndTimeANSI
_seconds: aNumber
  "All instances of kinds of DateAndTimeANSI are created with seconds being 
   a ScaledDecimal with scale 6 "

  self isInvariant ifTrue:[ ArgumentTypeError signal:'Attempt to modify invariant object'].
  aNumber _isInteger ifTrue:[
    seconds := aNumber
  ] ifFalse:[
    aNumber _isScaledDecimal ifTrue:[
      aNumber scale == 6  ifTrue:[
        seconds := aNumber
      ] ifFalse:[
        seconds := aNumber withScale: 6 
      ]
    ] ifFalse:[
      seconds := ScaledDecimal for: aNumber scale: 6 
    ]
  ]
%

category: 'private'
method: DateAndTimeANSI
_secondsLocal: aNumber offset: anObject
  self isInvariant ifTrue:[ ArgumentTypeError signal:'Attempt to modify invariant object'].
	self _seconds: aNumber .
	anObject ifNil:[
		offset := self class _zoneOffsetAtLocal: self.
	] ifNotNil: [
		offset  := anObject asSeconds.
	].
	self _seconds: aNumber - offset.
  self immediateInvariant .
%

category: 'private'
method: DateAndTimeANSI
_secondsUTC: aNumber offsetSeconds: anOffset
  self isInvariant ifTrue:[ ArgumentTypeError signal:'Attempt to modify invariant object'].
	self _seconds: aNumber.
	anOffset ifNil: [
		offset := self class _zoneOffsetAtUTC: self.
	] ifNotNil: [
		offset  := anOffset
	].
  self immediateInvariant .
%

! Class extensions for 'Float'

!		Class methods for 'Float'

removeallmethods Float
removeallclassmethods Float

category: 'Constants'
classmethod: Float
denormalized
  "The floating point representation does allow denormalized numbers"
  ^ true
%

category: 'Constants'
classmethod: Float
e
  "The mathematical constant  e  as representable in an 8 byte IEEE Float"
  ^  2.718281828459045
%

category: 'Constants'
classmethod: Float
emax
  "The largest base 2 exponent supported by Float, as defined by IEC/ISO 10967.
  Note that floating-point exponents as defined by IEC/ISO 10967 and the ANSI
  Smalltalk standards are one greater than the exponents defined by IEEE 754
  standard. This is because IEEE is modeled on a *significand*,
  1 <= significand < 2,
  and IEC/ISO/ 10967 and ANSI Smalltalk are modeled on a *fraction*,
  0 <= fraction < 1. The two models are equivalent in representable values,
  but the exponents differ by one"

  ^1024
%

category: 'Constants'
classmethod: Float
emin
  "The smallest base 2 exponent supported by Float, as defined by IEC/ISO 10967.
  Note that floating-point exponents as defined by IEC/ISO 10967 and the ANSI
  Smalltalk standards are one greater than the exponents defined by IEEE 754
  standard. This is because IEEE is modeled on a *significand*,
  1 <= significand < 2,
  and IEC/ISO/ 10967 and ANSI Smalltalk are modeled on a *fraction*,
  0 <= fraction < 1. The two models are equivalent in representable values,
  but the exponents differ by one"

  ^ -1021
%

category: 'Constants'
classmethod: Float
epsilon
  "Smallest Float such that    (1.0 + EPSLON) = 1.0) == false "
  ^ 2.2204460492503131E-16
%

category: 'Constants'
classmethod: Float
fmax
  "The largest Float smaller than PlusInfinity"
  ^ 1.7976931348623157E308
%

category: 'Constants'
classmethod: Float
fmin
  "The smallest Float greater than 0.0"
  ^ self fminDenormalized
%

category: 'Constants'
classmethod: Float
fminDenormalized
  "Smallest postive Float greater than 0.0"
  ^ 4.9406564584124654E-324
%

category: 'Constants'
classmethod: Float
fminNormalized
  "Smallest positive Float that is not a subnormal Float"
  ^ 2.2250738585072014E-308
%

category: 'Instance Creation'
classmethod: Float
fromString: aString

"Returns a SmallDouble or Float, constructed from aString.  The String
 must contain only Characters representing the object to be created, although
 leading and trailing blanks are permitted.

 If the string represents an exceptional float, it must contain one of the
 following strings, with leading and trailing blanks permitted:
    'PlusInfinity', 'MinusInfinity', 'PlusQuietNaN',
    'MinusQuietNaN', 'PlusSignalingNaN', or 'MinusSignalingNaN'.

 If the string does not conform to the above rules, an error may be generated,
 or a signaling NaN may be returned.

 If the string is larger than 16271 bytes, an error is generated."

<primitive: 120>
FloatingPointError _checkFpStatus .
aString _validateClass: String .
^ self _primitiveFailed: #fromString: args: { aString }
%

category: 'Instance Creation'
classmethod: Float
fromStringLocaleC: aString

"Same as fromString:  except that decimal point in aString must use  $.  "

^ self _mathPrim: aString opcode:3
%

category: 'Storing and Loading'
classmethod: Float
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst |

inst := (self fromStringLocaleC:  passiveObj upToSeparator) _asFloat .
passiveObj hasRead: inst.
^inst
%

category: 'Instance Creation'
classmethod: Float
new

"Returns a PlusSignalingNaN.  You can use this method to
 define a Float without specifying its value."

<primitive: 139>
^ self _primitiveFailed: #new
%

category: 'Exceptions'
classmethod: Float
noInexactResultDo: aBlock
 "Return value of executing aBlock, suppressing any
  FloatingPointError for inexactResult that might occur."
 | prev |
 ^ [ | fpe |
     prev := (fpe := FloatingPointError) _enableExceptions: 0 .
     fpe _enableExceptions: (prev bitAnd: 16rF"no inexactResult").
     aBlock value
   ] ensure: [ | fpe |
     fpe := FloatingPointError .
     prev ~~ 0 ifTrue:[ fpe _getExceptions: true ]. "clear any pending inexact result"
     fpe _enableExceptions: prev
   ]
%

category: 'Constants'
classmethod: Float
pi
  "The mathematical constant  pi  as representable in an 8 byte IEEE Float"
  ^ 3.141592653589793
%

category: 'Constants'
classmethod: Float
precision
  "The number of radix digits in the floating point representation.
   This is the number of bits in the mantissa of a Float plus one."
  ^ 53
%

category: 'Constants'
classmethod: Float
radix
  "The base of the floating point representation"
  ^ 2
%

category: 'Private'
classmethod: Float
_mathPrim: anArg opcode: opcode

"Mathematics primitive:
 opcode   function
    0     fromReadStreamInts: anArray
    3     fromStringLocaleC: aString"

<primitive: 179>
FloatingPointError _checkFpStatus .
opcode == 3 ifTrue:[ anArg _validateClass: String ].
opcode == 0 ifTrue:[ anArg _validateClass: Array  ].
^ self _primitiveFailed: #_mathPrim:opcode: args: { anArg . opcode }
%

!		Instance methods for 'Float'

category: 'Arithmetic'
method: Float
* aNumber

"Multiply the receiver by aNumber and returns the result."

<primitive: 102>
FloatingPointError _checkFpStatus .
^ self _retry: #* coercing: aNumber
%

category: 'Arithmetic'
method: Float
+ aNumber

"Returns the sum of the receiver and aNumber."

<primitive: 106>
FloatingPointError _checkFpStatus .
^ self _retry: #+ coercing: aNumber
%

category: 'Arithmetic'
method: Float
- aNumber

"Returns the difference between the receiver and aNumber."

<primitive: 107>
FloatingPointError _checkFpStatus .
^ self _retry: #- coercing: aNumber
%

category: 'Arithmetic'
method: Float
/ aNumber

"Divide the receiver by aNumber and returns the result."

<primitive: 108>
FloatingPointError _checkFpStatus .
^ self _retry: #/ coercing: aNumber
%

category: 'Comparing'
method: Float
< aNumber

"Returns true if the receiver is less than aNumber; returns false otherwise."

	<primitive: 118>

	| sk ak |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ ArgumentTypeError signal: 'Expected a Number' ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ false ].
	sk == 3
		ifTrue: [ ^ self _compareInfinityFor: #'<' with: aNumber ].
	ak := aNumber _getKind.
	ak > 4
		ifTrue: [ ^ false ].
	ak == 3
		ifTrue: [ ^ aNumber sign == 1 ].	
	"If we get here, self and arg are both finite."
	^ (AbstractFraction _coerce: self) < aNumber
%

category: 'Comparing'
method: Float
<= aNumber
	"Returns true if the receiver is less than aNumber; returns false otherwise."

	<primitive: 121>
	| sk ak |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ ArgumentTypeError signal: 'Expected a Number' ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ false ].  "NaN"
	sk == 3
		ifTrue: [ ^ self _compareInfinityFor: #'<=' with: aNumber ].
	ak := aNumber _getKind.
	ak > 4
		ifTrue: [ ^ false ].
	ak == 3
		ifTrue: [ ^ aNumber sign == 1 ].	  "Inf"
	"If we get here, self and arg are both finite."
	^ (AbstractFraction _coerce: self) <= aNumber
%

category: 'Comparing'
method: Float
= aNumber
	"Returns true if the receiver is equal to aNumber; returns false otherwise."

	<primitive: 119>
	| sk ak |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ false ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ false ].
	sk == 3
		ifTrue: [ ^ self _compareInfinityFor: #'=' with: aNumber ].
	ak := aNumber _getKind.
	ak > 4
		ifTrue: [ ^ false ].
	ak == 3
		ifTrue: [ ^ false ].	
	"If we get here, self and arg are both finite."
	^ (AbstractFraction _coerce: self) = aNumber
%

category: 'Arithmetic'
method: Float
arcCos

"Returns the arc-cosine of the receiver in radians."

^ self _mathPrim: 6
%

category: 'Arithmetic'
method: Float
arcCosh

"Returns inverse hyperbolic cosine of the receiver using acosh() in math.h"

^ self _mathPrim: 17
%

category: 'Arithmetic'
method: Float
arcSin

"Returns the arc-sine of the receiver in radians."

^ self _mathPrim: 5
%

category: 'Arithmetic'
method: Float
arcSinh

"Returns inverse hyperbolic sine of the receiver using asinh() in math.h"

^ self _mathPrim: 18
%

category: 'Arithmetic'
method: Float
arcTan

"Returns the arc-tangent of the receiver in radians."

^ self _mathPrim: 4
%

category: 'Arithmetic'
method: Float
arcTan2: anArg
  "Returns arg tangent of receiver and anArg using atan2() in math.h .
   Similar to arcTan except sign of both receiver and anArg
   contribute to the quadrant of the result. "

  ^ self _mathPrim: anArg opcode: 5
%

category: 'Arithmetic'
method: Float
arcTanh

"Returns inverse hyperbolic tangent of the receiver using tanh() in math.h"

^ self _mathPrim: 19
%

category: 'Converting'
method: Float
asCanonicalForm
	"Answer self, or, if I am a Float with an equivalent
	SmallDouble, answer that SmallDouble."

	| res |
	self class ~~ SmallDouble
		ifTrue: [ 
			(self = 0.0 and: [ self _sign == -1 ])
				ifTrue: [ ^ -0.0 ].
			res := self + 0.0.
			res class == SmallDouble
				ifTrue: [ ^ res ] ].
	^ self
%

category: 'Converting'
method: Float
asDecimalFloat
	"Returns a DecimalFloat representing the receiver."

	| kind aString |
	kind := self _getKind.
	kind > 2
		ifTrue: [ 
			kind == 4
				ifTrue: [ 
					self _sign < 0
						ifTrue: [ ^ -0.0f0 ]
						ifFalse: [ ^ 0.0f0 ] ].
			kind == 3
				ifTrue: [ 
					self sign < 0
						ifTrue: [ ^ DecimalMinusInfinity ]
						ifFalse: [ ^ DecimalPlusInfinity ] ].
			kind == 5
				ifTrue: [ 
					self sign < 0
						ifTrue: [ ^ DecimalMinusQuietNaN ]
						ifFalse: [ ^ DecimalPlusQuietNaN ] ].
			self sign < 0
				ifTrue: [ ^ DecimalMinusSignalingNaN ]
				ifFalse: [ ^ DecimalPlusSignalingNaN ] ].

	"Print self rounded to 20 significant digits to correspond
	to the 20-digit mantissa of a DecimalFloat."
	aString := self asStringUsingFormat: #(0 19 true).
	^ DecimalFloat fromString: aString
%

category: 'Converting'
method: Float
asFloat

"Returns the receiver."

^ self
%

category: 'Deprecated'
method: Float
asSmallFloat

"The class SmallFloat is deprecated.
 Returns an instance of SmallFloat, which will be a NaN if the receiver
 exceeds the exponent range of a 4 byte IEEE float .  This conversion will
 lose precision."

<primitive: 132>
FloatingPointError _checkFpStatus .
^ self _primitiveFailed: #asSmallFloat
%

category: 'Formatting'
method: Float
asString

"Returns a String corresponding to the value of the receiver.  Where applicable,
 returns one of the following Strings: 'PlusInfinity', 'MinusInfinity',
 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or 'MinusSignalingNaN'.

 The receiver is printed with the fewest significant digits needed to uniquely
 identify it. It is printed in exponential format unless the exponent would be
 between -4 and 15, in which case it is printed in decimal (nnn.nnnnn) format."

<primitive: 131>
^ self _primitiveFailed: #asString
%

category: 'Formatting'
method: Float
asStringLegacy

"Returns a String corresponding to the value of the receiver.  Where applicable,
 returns one of the following Strings: 'PlusInfinity', 'MinusInfinity',
 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or 'MinusSignalingNaN'.

 The receiver is printed using the C printf format string '%.16E'  .
"

<primitive: 1017>
^ self _primitiveFailed: #asStringLegacy
%

category: 'Formatting'
method: Float
asStringLocaleC

"Result is same as for asString, except that decimal point is always
 using  $.   For use in passivation/activation "

^ self _mathPrim: 13
%

category: 'Formatting'
method: Float
asStringLocaleCLegacy

"Result is same as for asStringLegacy, except that decimal point is always
 using  $. "

^ self _mathPrim: 30
%

category: 'Formatting'
method: Float
asStringUsingFormat: anArray

"Returns a String corresponding to the receiver, using the format specified by
 anArray.  The Array contains three elements: two Integers and a Boolean.
 Generates an error if any element of the Array is missing or is of the wrong
 class.

 The first element of the Array (an Integer between -1000 and 1000)
 specifies a minimum number of Characters in the result String (that is,
 the 'width' of the string).  If this element is positive, the resulting
 String is padded with blanks to the right of the receiver.  If this element
 is negative, the blanks are added to the left of the receiver.  If the
 value of this element is not large enough to completely represent the Float,
 a longer String will be generated.

 The second element of the Array (a positive Integer less than or equal to
 1000) specifies the number of digits to display to the right of the decimal
 point.  If the value of this element exceeds the number of digits required to
 specify the Float, the result is right-padded with 0 to the required width.
 If the value of this element is insufficient to completely specify the Float,
 the value of the Float is rounded (see #rounded).

 The third element of the Array (a Boolean) indicates whether or not to display
 the magnitude using exponential notation.  (The value true indicates
 exponential notation and false indicates decimal notation.)

 For example, the number 12.3456 displayed with two different format Arrays
 would appear as follows:

 Format          Output
 #(10 5 true)    '1.23456e01'
 #(10 2 false)   '12.35     '        "

^ self _mathPrim: anArray opcode: 1
%

category: 'Formatting'
method: Float
asStringUsingFormatLegacy: anArray

"Same as asStringUsingFormat: except the exponent letter is E instead of e .'
 Examples:

 Format          Output
 #(10 5 true)    '1.23456E01'
 #(10 2 false)   '12.35     '        "

^ self _mathPrim: anArray opcode: 8
%

category: 'Truncation and Rounding'
method: Float
ceiling

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as positive infinity.
 If receiver is a signaling NaN, raise a floating point exception"

<primitive: 658>
| kind |
FloatingPointError _checkFpStatus .
kind := self _getKind .
kind >= 5 ifTrue:[
  (kind == 6 "signaling NaN") ifTrue: [ Float _raiseInvalidOperationException ].
  "If a NaN, returns correct sign of self"
  ^self _makeQuietNaN
].
^ self _primitiveFailed: #ceiling
%

category: 'Copying'
method: Float
copy
  "If the receiver is a NaN or infinity, and FloatingPointError
   is configured to signal invalid operation errors, signals a FloatingPointError."
  | kind bits flag |
  kind := self _getKind .
  ( kind == 3"infinity" or:[ kind >= 5 "Nan"]) ifTrue:[
    bits := FloatingPointError _enableExceptions: -1 .
    (flag := bits bitAnd:  8) ~~ 0 ifTrue:[ "invalid operation enabled"
       ^ FloatingPointError new actual: flag ; signal
    ].
  ].
  ^ super copy
%

category: 'Arithmetic'
method: Float
cos

"Returns the cosine of the receiver which is treated as an
 angle expressed in radians."

^ self _mathPrim: 1
%

category: 'Arithmetic'
method: Float
cosh

"Returns the hyperbolic cosine of the receiver using cosh() from math.h"

^ self _mathPrim: 20
%

category: 'Accessing'
method: Float
denominator

"Returns the denominator of a Fraction representing the receiver."

   "If an infinite or quiet NaN, returns self"
| kind |
kind := self _getKind .
(kind >= 3) ifTrue:[ "exceptional"
  (kind == 3 "infinity" or:[ kind == 5 "quiet NaN"]) ifTrue: [ ^self ].

   "If a signaling NaN, raise a floating point exception & returns self"
  (kind == 6 "signaling NaN") ifTrue:[
      Float _raiseInvalidOperationException.
      ^self _makeQuietNaN
  ].
].
^ (self asFraction) denominator
%

category: 'Arithmetic'
method: Float
erf

"Returns the error function of receiver using erf() from math.h"

^ self _mathPrim: 21
%

category: 'Arithmetic'
method: Float
erfc

"Returns complementary error function of receiver using erfc() from math.h"

^ self _mathPrim: 22
%

category: 'Arithmetic'
method: Float
exp

"Returns e raised to the power of the receiver."

^ self _mathPrim: 0
%

category: 'Accessing'
method: Float
exponent
  "Returns the unbiased exponent of the receiver"

  ^ self _mathPrim: 28
%

category: 'Truncation and Rounding'
method: Float
floor

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as negative infinity."

<primitive: 657>
| kind |
FloatingPointError _checkFpStatus .
kind := self _getKind .
kind >= 5 ifTrue:[
  (kind == 6 "signaling NaN" ) ifTrue: [ Float _raiseInvalidOperationException ].
  "If a NaN, returns correct sign of self"
  ^self _makeQuietNaN
].
^ self _primitiveFailed: #floor
%

category: 'Arithmetic'
method: Float
frexp

"Returns an Array { fractionalPart . powerOf2Exponent }
 for the receiver , per frexp() in math.h "

^ self _mathPrim: 16
%

category: 'Comparing'
method: Float
hash

"Returns a numerical hash code for the receiver."

"Two Numbers for which = is true, must have the same hash value."

^ self _mathPrim: 8
%

category: 'Arithmetic'
method: Float
hypot: anArg

"Returns      ((self*self) + (anArg*anArg)) sqrt
 using hypot() from math.h"

  ^ self _mathPrim: anArg opcode: 6
%

category: 'Truncation and Rounding'
method: Float
integerPart

"Returns an integer representing the receiver truncated toward zero."

^ self truncated asFloat
%

category: 'Arithmetic'
method: Float
ldexp: anArg

"Returns   self * (2 raisedToInteger: anArg)
                using ldexp() from math.h"

  ^ self _mathPrim: anArg opcode: 7
%

category: 'Arithmetic'
method: Float
ln

"Returns the natural logarithm of the receiver."

^ self _mathPrim: 7
%

category: 'Arithmetic'
method: Float
log10

"Returns the base 10 logarithm of the receiver."

^ self _mathPrim: 9
%

category: 'Arithmetic'
method: Float
log2

"Returns base 2 logarithm of receiver using  log2() from math.h"

^ self _mathPrim: 23
%

category: 'Accessing'
method: Float
mantissa
  "Returns the mantissa of the receiver, including the
   implied most-significant 1 bit if receiver is neither zero nor subnormal"

  ^ self _mathPrim: 29
%

category: 'Arithmetic'
method: Float
modf

"Returns an Array of 2 Floats,  { fractional_part . integral_part }
 using  modf() from math.h "

^ self _mathPrim: 24
%

category: 'Arithmetic'
method: Float
modulo: aNumber
	"Divide the receiver by aNumber and returns the remainder,
 i.e. the result of the C expression    self % aNumber .
 Returns PlusQuietNaN if aNumber == 0.0   . "

	<primitive: 800>
	FloatingPointError _checkFpStatus.
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ aNumber _validateClass: Number ].
	^ self modulo: aNumber asFloat
%

category: 'Repository Conversion'
method: Float
needsFixingAfterConversion
  ^true
%

category: 'Accessing'
method: Float
numerator

"Returns the numerator of a Fraction representing the receiver."

   "If an infinite or quiet NaN, returns self"
| kind |
kind := self _getKind .

kind >= 3 ifTrue:[ "exceptional"
  (kind == 3 "infinity" or:[ kind == 5 "quiet NaN"]) ifTrue: [ ^self ].

   "If a signaling NaN, raise a floating point exception & returns self"
  (kind == 6 "signaling NaN") ifTrue: [
      Float _raiseInvalidOperationException.
      ^self _makeQuietNaN
   ].
].
^ (self asFraction) numerator
%

category: 'Copying'
method: Float
postCopy
  ^ self immediateInvariant
%

category: 'Arithmetic'
method: Float
raisedTo: aNumber

"Returns the receiver raised to the power of the argument."

aNumber _isNumber ifFalse:[ aNumber _validateClass: Number ].
^ self _mathPrim: aNumber asFloat opcode: 4
%

category: 'Arithmetic'
method: Float
raisedToInteger: aNumber

"Returns the receiver raised to the power of the argument."

^ self _mathPrim: aNumber opcode: 2
%

category: 'Truncation and Rounding'
method: Float
roundAndCoerceTo: aNumber
"Returns the multiple of aNumber that is nearest in value to the receiver.

 If aNumber is a kind of Integer, ScaledDecimal, or AbstractFraction,
 the result will be an instance of the class of aNumber .

 If a signaling NaN, raise a floating point exception"
  ^ self _roundTo: aNumber coerce: true
%

category: 'Truncation and Rounding'
method: Float
rounded

"Returns the Integer nearest in value to the receiver.
 If a signaling NaN, raise a floating point exception"

^ self _rounded: true
%

category: 'Truncation and Rounding'
method: Float
roundedNoFpe

"Returns the Integer nearest in value to the receiver,
 ignoring any #inexactResult that might be enabled in FloatingPointError"

^ self _rounded: false
%

category: 'Truncation and Rounding'
method: Float
roundTo: aNumber
"Returns the multiple of aNumber that is nearest in value to the receiver.
 If a signaling NaN, raise a floating point exception"

  ^ self _roundTo: aNumber coerce: false
%

category: 'Accessing'
method: Float
sign

"Returns 1 if the receiver is greater than zero, -1 if the receiver is
 less than zero, and zero if the receiver is zero."

<primitive: 130>
^ self _primitiveFailed: #sign
%

category: 'Accessing'
method: Float
signBit

  "Returns  1 for a negative receiver and 0 for a positive receiver"

 ^ self _mathPrim: 27
%

category: 'Arithmetic'
method: Float
sin

"Returns the sine of the receiver which is treated as an
 angle expressed in radians."

^ self _mathPrim: 2
%

category: 'Arithmetic'
method: Float
sinh

"Returns the hyperbolic sine of the receiver using sinh() from math.h"

^ self _mathPrim: 25
%

category: 'Arithmetic'
method: Float
sqrt

"Returns the square root of the receiver."
"Reimplemented from Number"

<primitive: 104>
FloatingPointError _checkFpStatus .
^ self _primitiveFailed: #sqrt
%

category: 'Arithmetic'
method: Float
tan

"Returns the tangent of the receiver which is treated as an
 angle expressed in radians."

^ self _mathPrim: 3
%

category: 'Arithmetic'
method: Float
tanh

"Returns the hyperbolic tangent of the receiver using tanh() from math.h"

^ self _mathPrim: 26
%

category: 'Truncation and Rounding'
method: Float
truncateAndCoerceTo: aNumber

"Returns the multiple of aNumber that is closest to the receiver, on the
 same side of the receiver as zero is located.  In particular, returns
 the receiver if the receiver is a multiple of aNumber.

 If aNumber is a kind of Integer, ScaledDecimal, or AbstractFraction,
 the result will be an instance of the class of aNumber .

 If a signaling NaN, raise a floating point exception"

^ self _truncateTo: aNumber coerce: true
%

category: 'Truncation and Rounding'
method: Float
truncated
"Returns the integer that is closest to the receiver, on the same side
 of the receiver as zero is located.

 If the receiver is an exceptional float (NaN or Infinity) , returns
 the receiver."

^ self _truncated: true
%

category: 'Truncation and Rounding'
method: Float
truncatedNoFpe
"Returns the integer that is closest to the receiver, on the same side
 of the receiver as zero is located.
 ignoring any #inexactResult that might be enabled in FloatingPointError"

^ self _truncated: false
%

category: 'Truncation and Rounding'
method: Float
truncateTo: aNumber
"Returns the multiple of aNumber that is closest to the receiver, on the
 same side of the receiver as zero is located.  In particular, returns
 the receiver if the receiver is a multiple of aNumber.
 If a signaling NaN, raise a floating point exception"

^ self _truncateTo: aNumber coerce: false
%

category: 'Private'
method: Float
_asFloat

"Returns the receiver."

^ self
%

category: 'Private'
method: Float
_asSmallFloat

^ self asSmallFloat
%

category: 'Converting'
method: Float
_coerce: aNumber
	"Returns an instance of Float with the same value as 'aNumber'."

	"This method must be defined by all subclasses of Number."

	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ 
			"avoid sending asFloat to a CharacterCollection"
			aNumber _validateClass: Number ].
	^ aNumber asFloat
%

category: 'Accessing'
method: Float
_exponentBits
  "Return exponent bits of receiver as a SmallInteger"
  ^ self _mathPrim: 15
%

category: 'Converting'
method: Float
_generality

"Returns the integer that represents the ordering of the receiver in the
 generality hierarchy."

"Reimplemented from Number"

^ 90
%

category: 'Accessing'
method: Float
_getKind

"Returns an integer, 1...6, for the kind of the receiver, per Number>>kind."

<primitive: 110>

^ self _primitiveFailed: #_getKind
%

category: 'Accessing'
method: Float
_isNaN

"Returns whether the receiver is quiet NaN or signaling NaN."

^ self _getKind > 4
%

category: 'Converting'
method: Float
_makeQuietNaN

"This method returns a quiet NaN with the same sign as the input NaN.  If the
 input is not a NaN, this method returns the receiver."

   "Is the receiver a NaN?"
| kind |
kind := self _getKind .
(kind == 6 "quiet NaN" or:[ kind == 5 "signaling NaN"])
  ifFalse: [ ^self ]
  ifTrue: [ (self sign < 0)
                ifFalse: [ ^PlusQuietNaN ]
                ifTrue: [ ^MinusQuietNaN ] ]
%

category: 'Accessing'
method: Float
_mantissaBits
  "Return mantissa bits of receiver as a SmallInteger"
  ^ self _mathPrim: 14
%

category: 'Private'
method: Float
_mathPrim: opcode

"Trigonometric and other primitive functions:

 opcode   function
    0     exp
    1     cos
    2     sin
    3     tan
    4     arcTan
    5     arcSin
    6     arcCos
    7     ln
    8     hash
    9     log  base 10
   10     SmallDouble>>_asFloat
   11     _sign
   12     _asFraction
   13     asStringLocaleC
   14     _mantissaBits
   15     _exponentBits
   16     frexp
   17     arcCosh
   18     arcSinh
   19     arcTanh
   20     cosh
   21     erf
   22     erfc
   23     log2
   24     modf
   25     sinh
   26     tanh
   27     signBit
   28     exponent
   29     mantissa
   30     asStringLocaleCLegacy
   31     _smallFloatAsStringLocaleC
   "

<primitive: 136>
FloatingPointError _checkFpStatus .
^ self _primitiveFailed: #_mathPrim: args: { opcode }
%

category: 'Private'
method: Float
_mathPrim: anArg opcode: opcode

"Mathematics primitive:

 opcode   function
    0     fromReadStreamInts: anArray
    1     asStringUsingFormat: anArg
            argument must be a format descriptor Array
    2     raisedToInteger: anArg
    3     fromStringLocaleC: anArg
    4     raisedTo: anArg
    5     atan2(receiver, anArg) per math.h
    6     hypot(receiver, anArg) per math.h
    7     ldexp(receiver, anArg) per math.h
    8     asStringUsingFormatLegacy: anArg
"

<primitive: 179>
FloatingPointError _checkFpStatus .
opcode <= 3 ifTrue:[
  opcode == 2 ifTrue:[ anArg _validateClass: Integer ].
  (opcode == 1 or:[ opcode == 8 ]) ifTrue:[ | v |
    anArg _validateClass: Array .
    anArg size == 3 ifFalse:[ anArg _error: #rtErrArgOutOfRange args:{ 3 . 3 } ] .
    (anArg at:1 ) _validateClass: SmallInteger .
    (anArg at:2 ) _validateClass: SmallInteger .
    (anArg at:3 ) _validateClass: Boolean .
    ((v := anArg at:1) < -1000 or:[ v > 1000 ])
        ifTrue:[ v _error: #rtErrArgOutOfRange args:{ -1000 . 1000 } ] .
    ((v := anArg at:2) < 0 or:[ v  > 1000 ])
        ifTrue:[ v _error: #rtErrArgOutOfRange args:{ -1000 . 1000 } ] .
   ] .
  ^ self _primitiveFailed: #_mathPrim:opcode: args: { anArg . opcode }
].
opcode == 7 ifTrue:[
  anArg _validateClass: SmallInteger
] ifFalse:[
  anArg _validateClass: Float .
].
^ self _primitiveFailed: #_mathPrim:opcode: args: { anArg . opcode }
%

category: 'Accessing'
method: Float
_partsAsString
  "Return a string describing the sign, mantissa and exponent of the receiver.
   There are 1 sign bit, 52 mantissa bits, and 11 exponent bits. "
| str |
str := 'sign ' copy .
str add: (self _sign < 0 ifTrue:[ '1'] ifFalse:['0']);
   add: ', mantissa 16r' ; add: self _mantissaBits asHexString ;
   add: ', exp 16r' ; add: self _exponentBits asHexString .
^ str
%

category: 'Truncation and Rounding'
method: Float
_rounded: withFpeBoolean
"Returns the Integer nearest in value to the receiver.
 If withFpeBoolean == true may raises FloatingPointError for inexact results"

<primitive: 656>
| kind |
withFpeBoolean ifTrue:[ FloatingPointError _checkFpStatus ].
kind := self _getKind .
kind >= 5 ifTrue:[
  (kind == 6 "signaling NaN" ) ifTrue: [ Float _raiseInvalidOperationException ].
  "If a NaN, returns correct sign of self"
  ^self _makeQuietNaN
].
^ self _primitiveFailed: #_rounded:
%

category: 'Private'
method: Float
_roundTo: aNumber coerce: aBoolean
	| kind rnd |
	aBoolean class == Boolean
		ifFalse: [ aBoolean _validateClass: Boolean ].
	FloatingPointError _checkFpStatus.
	kind := self _getKind.
	kind >= 5
		ifTrue: [ 
			kind == 5
				ifTrue: [ Float _raiseInvalidOperationException ].	"signaling NaN"
			^ self _makeQuietNaN ].
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ aNumber _validateClass: Number ].
	aNumber = 0
		ifTrue: [ 
			"should have been handled in primitive"
			self
				_primitiveFailed: #'_roundTo:coerce:'
				args:
					{aNumber.
					aBoolean} ].	"Handle infinity receivers and exceptional args here"
	rnd := (self / aNumber) rounded.

	aBoolean
		ifTrue: [ 
			"roundAndCoerceTo:  semantics"
			aNumber _isInteger
				ifTrue: [ ^ rnd * aNumber ].
			aNumber _isScaledDecimal
				ifTrue: [ ^ rnd * aNumber ].
			(aNumber isKindOf: AbstractFraction)
				ifTrue: [ ^ rnd * aNumber ] ].
	^ rnd asFloat * aNumber
%

category: 'Private'
method: Float
_sign

"Returns 1 if the receiver is greater than zero, -1 if the receiver is
 less than zero, 1 if the receiver is 0.0 and -1 if the receiver is -0.0 ."

^ self _mathPrim: 11
%

category: 'Private'
method: Float
_smallFloatAsStringLocaleC

^ self _mathPrim: 31
%

category: 'Truncation and Rounding'
method: Float
_truncated: withFpeBoolean

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as zero is located.

 If the receiver is an exceptional float (NaN or Infinity) , returns
 the receiver.
 If withFpeBoolean == true may raises FloatingPointError for inexact results.
"

<primitive: 109>
withFpeBoolean ifTrue:[ FloatingPointError _checkFpStatus ].
^ self _primitiveFailed: #truncated
%

category: 'Truncation and Rounding'
method: Float
_truncateTo: aNumber coerce: aBoolean
	<primitive: 660>
	| kind argFlt q |
	aBoolean class == Boolean
		ifFalse: [ aBoolean _validateClass: Boolean ].
	FloatingPointError _checkFpStatus.
	kind := self _getKind.
	kind >= 5
		ifTrue: [ 
			kind == 6
				ifTrue: [ Float _raiseInvalidOperationException ].	"signaling NaN"
			^ self _makeQuietNaN ].
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ aNumber _validateClass: Number ].
	aNumber = 0
		ifTrue: [ 
			"should have been handled in primitive"
			self
				_primitiveFailed: #'_truncateTo:coerce:'
				args:
					{aNumber.
					aBoolean} ].	"Handle infinity receivers and exceptional args here"
	q := self quo: (argFlt := aNumber asFloat).
	aBoolean
		ifTrue: [ 
			"truncateAndCoerceTo: semantics"
			aNumber _isInteger
				ifTrue: [ ^ q * aNumber ].
			aNumber _isScaledDecimal
				ifTrue: [ ^ q * aNumber ].
			(aNumber isKindOf: AbstractFraction)
				ifTrue: [ ^ q * aNumber ] ].
	^ q * argFlt
%

category: 'Comparing'
method: Float
~= aNumber
	"Returns true if the receiver is not equal to aNumber; returns false
 otherwise."

	<primitive: 177>
										
	| sk ak |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ true ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ true ].
	sk == 3
		ifTrue: [ ^ self _compareInfinityFor: #'~=' with: aNumber ].
	ak := aNumber _getKind.
	ak > 4
		ifTrue: [ ^ true ].
	ak == 3
		ifTrue: [ ^ true ].	
	"If we get here, self and arg are both finite."
	^ (AbstractFraction _coerce: self) ~= aNumber
%

! Class extensions for 'Interval'

!		Class methods for 'Interval'

removeallmethods Interval
removeallclassmethods Interval

category: 'Instance Creation'
classmethod: Interval
from: start to: stop

"Returns an Interval that represents an arithmetic progression from start to
 stop in increments of one."

| anInterval |

anInterval := self basicNew.
anInterval from: start to: stop by: 1.

^ anInterval.
%

category: 'Instance Creation'
classmethod: Interval
from: start to: stop by: step

"Returns an Interval that represents an arithmetic progression from start to
 stop in increments of step."

| anInterval |

anInterval := self basicNew.
anInterval from: start to: stop by: step.

^ anInterval.
%

category: 'Instance Creation'
classmethod: Interval
migrateNew

"Override default migrateNew behavior with #_basicNew."

^ self _basicNew
%

category: 'Instance Creation'
classmethod: Interval
new

"Disallowed. Intervals cannot be created by the method #new."

^ self shouldNotImplement: #new.
%

category: 'Instance Creation'
classmethod: Interval
new: anInteger

"Disallowed. Intervals cannot be created by the method #new:."

^ self shouldNotImplement: #new:.
%

category: 'Indexing Support'
classmethod: Interval
_canCreateQueryOnInstances
  "Cannot create a GsQuery on the receiver"

  ^ false
%

!		Instance methods for 'Interval'

category: 'Concatenating'
method: Interval
, aCollection

"Returns an Array that contains the elements of the receiver followed by the
 elements of aCollection.  The receiver's standard enumeration order is used.

 Notice that the result of this method is an Array."

| anArray i |

anArray := Array new: (self size + aCollection size).

i := 1.
self do: [ :each |
  anArray at: i put: each.
  i := i + 1.
  ].

aCollection do: [ :each |
  anArray at: i put: each.
  i := i + 1.
  ].

^ anArray
%

category: 'Comparing'
method: Interval
= anInterval

"Returns true if the receiver is equal to the argument, false otherwise."

self == anInterval ifTrue:[ ^ true ].

(anInterval isKindOf: Interval) ifFalse:[ ^ false ].
^ (anInterval _from = from and:[ anInterval _to = to ])
   and:[ anInterval increment = by ]
%

category: 'Adding'
method: Interval
add: newObject

"Disallowed. Intervals cannot be updated."

^  self shouldNotImplement: #add:
%

category: 'Adding'
method: Interval
addLast: newObject

"Disallowed. Intervals cannot be updated."

^  self shouldNotImplement: #addLast:
%

category: 'Converting'
method: Interval
asArray

"Returns an Array with the contents of the receiver."

| anArray i |

anArray := Array new: self size.
i := 1.
self do: [ :each |
  anArray at: i put: each.
  i := i + 1.
  ].

^ anArray.
%

category: 'Accessing'
method: Interval
at: anIndex

"Returns the value of an indexed variable in the receiver.
 The argument anIndex must not be larger than the size of the
 receiver or less than 1."

anIndex _validateClass: Integer.
((anIndex < 1) or: [ anIndex > self size ])
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].

^ from + ((anIndex - 1) * by).
%

category: 'Updating'
method: Interval
at: anIndex put: aValue

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #at:put: .
%

category: 'Updating'
method: Interval
atAllPut: anObject

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #atAllPut:
%

category: 'Accessing'
method: Interval
begin
  ^ from
%

category: 'Eumerating'
method: Interval
collect: aBlock

"Evaluates aBlock with each of the receiver's elements as the argument.
 Collects the resulting values into a collection of class specified by
 sending #speciesForCollect message to the receiver. Returns the new
 collection. The argument aBlock must be a one-argument block.

 The result preserves the ordering of the receiver.  That is, if element a
 comes before element b in the receiver, then element a is guaranteed to come
 before b in the result."

|result|

result := self speciesForCollect new .
self do: [ :each | result add: (aBlock value: each) ].
^ result
%

category: 'Copying'
method: Interval
copyFrom: startIndex to: stopIndex

"Returns an Array containing the elements of the receiver between start and
 stop."

^ (self asArray) copyFrom: startIndex to: stopIndex
%

category: 'Copying'
method: Interval
copyReplaceAll: oldSubCollection with: newSubCollection

"Returns an Array in which all sequences of oldSubCollection
 contained within the receiver have been replaced by elements of
 newSubCollection."

^ (self asArray) copyReplaceAll: oldSubCollection with: newSubCollection.
%

category: 'Copying'
method: Interval
copyReplaceFrom: startIndex to: stopIndex with: replacementElements
	"Returns an Array in which all elements in the receiver between indexes
	 startIndex and stopIndex inclusive have been replaced by those contained in
	 replacementElements."

	^self asArray
		copyReplaceFrom: startIndex
		to: stopIndex
		with: replacementElements.
%

category: 'Copying'
method: Interval
copyReplacing: oldObject withObject: newObject
	"Returns a copy of the receiver in which all occurrences of objects equal to
	 oldObject have been replaced by newObject."

	^self asArray copyReplacing: oldObject withObject: newObject
%

category: 'Copying'
method: Interval
copyWith: anObject

"Returns an Array containing the elements of the receiver with anObject appended
 at the end."

^ (self asArray) copyWith: anObject.
%

category: 'Copying'
method: Interval
copyWithout: anObject

"Returns an Array that contains all the elements of the receiver except
 anObject."

^ (self asArray) copyWithout: anObject.
%

category: 'Eumerating'
method: Interval
do: aBlock

"Evaluates the one-argument block aBlock using each element of the receiver in
 order.  Returns the receiver."

from to: to by: by do: aBlock.
^ self.
%

category: 'Accessing'
method: Interval
end
  ^ to
%

category: 'Updating'
method: Interval
first: anObject

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #first:
%

category: 'Private'
method: Interval
from: start to: stop by: step

"This method initializes the instance variables at instance creation
 time, and does explicit constraint enforcement."

| badVal aName |
(start _isNumber) ifTrue:[
  (stop _isNumber) ifTrue:[
    (step _isNumber) ifTrue:[
      from := start.
      to := stop .
      by := step .
      ^ self
    ] ifFalse:[ badVal := step . aName := 'Interval.by' ].
  ] ifFalse:[ badVal := stop . aName := 'Interval.to' ] .
] ifFalse:[ badVal := start . aName := 'Interval.from' ] .

ArgumentTypeError new
   constrainedIv: aName expectedClass: Number actualArg: badVal ;
   signal .
self _uncontinuableError .
%

category: 'Comparing'
method: Interval
hash

"Returns some Integer related to the contents of the receiver.  If two objects
 compare equal (=) to each other, the results of sending hash to each of those
 objects must also be equal."

^ (from + to + by) hash
%

category: 'Accessing'
method: Interval
increment

"Returns a Number which represents the step size in the arithmetic progression
 represented by the receiver."

^ by.
%

category: 'Adding'
method: Interval
insertAll: aCollection at: anIndex

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #insertAll:at:
%

category: 'Updating'
method: Interval
last: anObject

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #last:
%

category: 'Accessing'
method: Interval
limit

 "Return the limit for an iteration of the C style
    for (int j = begin ; j < limit; j += by) "

  ^ to + by
%

category: 'Formatting'
method: Interval
printOn: aStream

"Puts a displayable representation of the receiver on the given stream.
 Override inherited collection behavior since start/stop/interval more informative"

aStream nextPutAll: self class name describeClassName.
aStream nextPutAll: ' of size '.
self size printOn: aStream.
aStream nextPutAll: ' ('.
from printOn: aStream.
aStream nextPutAll: ' to: '.
to printOn: aStream.
by ~= 1 ifTrue:
  [aStream nextPutAll: ' by: '.
  by printOn: aStream.
  ].
aStream nextPut: $).
%

category: 'Formatting'
method: Interval
printOn: aStream recursionSet: anIdentitySet
	"Put a displayable representation of the receiver on the given stream
	 since Intervals should not have recursive references."

	self printOn: aStream
%

category: 'Eumerating'
method: Interval
reject: aBlock

"Evaluates aBlock with each of the receiver's elements as the argument.
 Stores the values for which aBlock is false into an Array and returns the
 Array.  The argument aBlock must be a one-argument block.

 The result preserves the ordering of the receiver.  That is, if element a
 comes before element b in the receiver, then element a is guaranteed to come
 before b in the result."

^ (self asArray) reject: aBlock.
%

category: 'Removing'
method: Interval
remove: oldObject ifAbsent: anExceptionBlock

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #remove:ifAbsent:
%

category: 'Removing'
method: Interval
removeAll: aCollection ifAbsent: errorBlock

"Disallowed. Intervals cannot be updated."
^ self shouldNotImplement: #removeAll:ifAbsent:
%

category: 'Removing'
method: Interval
removeAllSuchThat: aBlock

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #removeAllSuchThat:
%

category: 'Removing'
method: Interval
removeFrom: startIndex to: stopIndex

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #removeLast
%

category: 'Removing'
method: Interval
removeIdentical: oldObject ifAbsent: anExceptionBlock

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #removeIdentical:ifAbsent:
%

category: 'Removing'
method: Interval
removeLast

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #removeLast
%

category: 'Updating'
method: Interval
replaceFrom: startIndex to: stopIndex with: aCollection

"Disallowed. Intervals cannot be updated."

^  self shouldNotImplement: #replaceFrom:to:with:
%

category: 'Updating'
method: Interval
replaceFrom: startIndex to: stopIndex with: aSeqCollection startingAt: repIndex

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #replaceFrom:to:with:startingAt:
%

category: 'Updating'
method: Interval
replaceFrom: startIndex to: stopIndex withObject: anObject

"Disallowed. Intervals cannot be updated."

^ self shouldNotImplement: #replaceFrom:to:withObject:
%

category: 'Copying'
method: Interval
reverse

"Returns an Array containing containing the elements of the receiver in the
 reverse order."

^ (self asArray) reverse.
%

category: 'Eumerating'
method: Interval
select: aBlock

"Evaluates aBlock with each of the receiver's elements as the argument.
 Stores the values for which aBlock is true into an Array and returns the
 Array.  The argument aBlock must be a one-argument block.

 The result preserves the ordering of the receiver.  That is, if element a
 comes before element b in the receiver, then element a is guaranteed to come
 before b in the result."

^ (self asArray) select: aBlock.
%

category: 'Accessing'
method: Interval
size

"Returns a count of the number of elements in the arithmetic progression
 represented by the receiver."

^ ((self limit - from) // by) max: 0 .
%

category: 'Private'
method: Interval
species

"Returns a class, an instance of which should be used as the result
 of collect: or other projections applied to the receiver."

^ Array
%

category: 'Private'
method: Interval
_from

"Returns the value of the instance variable from."

^ from
%

category: 'Private'
method: Interval
_to

"Returns the value of the instance variable to."

^ to
%

! Class extensions for 'IO'

!		Class methods for 'IO'

removeallmethods IO
removeallclassmethods IO

category: 'Instance Creation'
classmethod: IO
new
"disallowed"

self shouldNotImplement: #new
%

!		Instance methods for 'IO'

category: 'Accessing'
method: IO
fileDescriptor

"Returns the SmallInteger file descriptor, or -1 not available"
^  fileDescriptor
%

! Class extensions for 'SmallDate'

!		Instance methods for 'SmallDate'

removeallmethods SmallDate
removeallclassmethods SmallDate

category: 'Storing and Loading'
method: SmallDate
containsIdentity
  ^ true
%

category: 'Accessing'
method: SmallDate
dayOfYear
"Returns a SmallInteger that gives the day of the year described by the
 receiver."
  <primitive: 1111 >
  ^ self _primitiveFailed: #asMilliseconds  
%

category: 'Testing'
method: SmallDate
isSpecial
  ^ true
%

category: 'Accessing'
method: SmallDate
year
"Returns a SmallInteger that gives the year described by the receiver."
  <primitive: 1121 >
  ^ self _primitiveFailed: #asMilliseconds  
%

! Class extensions for 'SmallDateAndTime'

!		Class methods for 'SmallDateAndTime'

removeallmethods SmallDateAndTime
removeallclassmethods SmallDateAndTime

category: 'Private'
classmethod: SmallDateAndTime
basicNew
  ^ DateAndTime _basicNew
%

category: 'Storing and Loading'
classmethod: SmallDateAndTime
loadFrom: passiveObj
  | inst secs ofs |
  passiveObj readNamedIV.
  secs := passiveObj ivValue.
  secs  isSpecial ifFalse:[  | cls |     "fix 50172"
    (cls := secs class) == ScaledDecimal ifFalse:[ Error signal:'unexpected class ', cls name].
  ].
  passiveObj readNamedIV.
  ofs := passiveObj ivValue.
  ofs  _isSmallInteger ifFalse:[ Error signal:'unexpected ', ofs class name ].
  passiveObj skipNamedInstVars.
  inst := self secondsUTC: secs offsetSeconds: ofs .
  inst isSpecial ifFalse:[ Error signal:'a SmallDateAndTime should be special' ].
  ^ inst
%

!		Instance methods for 'SmallDateAndTime'

category: 'Accessing'
method: SmallDateAndTime
asSeconds
  "Returns a ScaledDecimal (or Integer if fractional part is zero)"
  <primitive: 1113>
   ^ self _primitiveFailed: #asSeconds 
%

category: 'Truncation and Rounding'
method: SmallDateAndTime
beRounded
  "Instances of SmallDateAndTime are invariant, use DateAndTimeANSI >> rounded."
  self shouldNotImplement: #beRounded 
%

category: 'Storing and Loading'
method: SmallDateAndTime
containsIdentity
  ^ true
%

category: 'comparing'
method: SmallDateAndTime
hash
  ^ self asSeconds hash
%

category: 'Testing'
method: SmallDateAndTime
isSpecial
  ^ true
%

category: 'public'
method: SmallDateAndTime
posixSeconds: anInteger
  "Disallowed because it would change the identity of SmallDateAndTime instances.
   You need to create a new instance instead."

  self shouldNotImplement: #posixSeconds:
%

category: 'Storing and Loading'
method: SmallDateAndTime
writeTo: passiveObj
   passiveObj writeClass: self class ;
     writeObject: self asSeconds named: #seconds ;
     writeObject: self _offsetSeconds named: #offset ;
     endNamedInstVars ; cr 
%

category: 'private'
method: SmallDateAndTime
_addSeconds: argSeconds
  "Return a result of the addition with resolution 0.000001 seconds"
  ^ (self asSeconds + argSeconds) asScaledDecimal: 6 
%

category: 'Accessing'
method: SmallDateAndTime
_offsetSeconds
  "Returns aSmallInteger "
  <primitive: 1114>
   ^ self _primitiveFailed: #_offsetSeconds 
%

! Class extensions for 'SmallScaledDecimal'

!		Class methods for 'SmallScaledDecimal'

removeallmethods SmallScaledDecimal
removeallclassmethods SmallScaledDecimal

category: 'Private'
classmethod: SmallScaledDecimal
basicNew
  ^ ScaledDecimal _basicNew 
%

category: 'Storing and Loading'
classmethod: SmallScaledDecimal
loadFrom: passiveObj
  | inst |
  inst := self fromStringLocaleC:  passiveObj upToSeparator .
  "no hasRead: here, since SmallScaledDecimal is a special"
  ^inst
%

!		Instance methods for 'SmallScaledDecimal'

category: 'Storing and Loading'
method: SmallScaledDecimal
containsIdentity
  ^ true
%

category: 'Testing'
method: SmallScaledDecimal
isSpecial
  ^ true
%

category: 'Accessing'
method: SmallScaledDecimal
mantissa
  <primitive: 1117>
  ^ self _primitiveFailed: #mantissa
%

category: 'Accessing'
method: SmallScaledDecimal
scale
  <primitive: 1118>
  ^ self _primitiveFailed: #scale
%

category: 'Storing and Loading'
method: SmallScaledDecimal
writeTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

passiveObj writeClass: self class;
  nextPutAll: self asStringLocaleC;
  nextPut: $s ; nextPutAll: self scale asString ; space .
%

category: 'Private'
method: SmallScaledDecimal
_mantissa: m scale: s
  "Disallowed"
   self shouldNotImplement: #_mantissa:scale: 
%

! Class extensions for 'SmallTime'

!		Class methods for 'SmallTime'

removeallmethods SmallTime
removeallclassmethods SmallTime

category: 'Instance Creation'
classmethod: SmallTime
fromMicroseconds: anInteger
 "Creates and returns an instance of the receiver from the specified value,
  which expresses local time."      "fix 48708"
  <primitive: 1120>
  anInteger _isSmallInteger ifFalse:[ 
     ^ self fromMicroseconds: anInteger asInteger \\ 86400000000 .
  ] ifTrue:[
    anInteger < 0 ifTrue:[
      ^ self fromMicroseconds: anInteger \\ 86400000000 .
    ]
  ].
  ^ Time basicNew _setMilliseconds: (anInteger / 1000.0)
%

category: 'Instance Creation'
classmethod: SmallTime
fromMilliseconds: anInteger
  ^ self fromMicroseconds: 1000 * anInteger . 
%

category: 'Instance Creation'
classmethod: SmallTime
_now
  ^ self __now
%

!		Instance methods for 'SmallTime'

category: 'Converting'
method: SmallTime
asMicroseconds
  "Returns a SmallInteger that represents the receiver in units of microseconds since
  midnight, local time"
  <primitive: 1119 >
  ^ self _primitiveFailed: #asMicroseconds  
%

category: 'Converting'
method: SmallTime
asMilliseconds
  "Returns a SmallInteger that represents the receiver in units of milliseconds since
  midnight, local time"
  ^ self asMicroseconds // 1000 
%

category: 'Storing and Loading'
method: SmallTime
containsIdentity
  ^ true
%

category: 'Testing'
method: SmallTime
isSpecial
  ^ true
%

