! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(Delay
	subclass: 'SUnitDelay'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'noInheritOptions'  #logCreation )
)
		category: 'SUnit-Preload';
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SUnitDelay
removeallclassmethods SUnitDelay

doit
(Exception
	_newKernelSubclass:'TestFailure'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 152577
)
		category: 'SUnit-Kernel';
		comment: 'Signaled in case of a failed test (failure). The test framework distinguishes 
between failures and errors. A failure is anticipated and checked for with 
assertions. Errors are unanticipated problems like a division by 0 or an 
index out of bounds.

This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

doit
(TestFailure
	subclass: 'ResumableTestFailure'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods ResumableTestFailure
removeallclassmethods ResumableTestFailure

doit
(Object
	subclass: 'AbstractExternalSession'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AbstractExternalSession is the superclass of a number of implementations
of external sessions.
An external session provides a means of running Smalltalk expressions in a different Gem,
possibly on another server or against a different Stone. The expression to execute can
be provided as a String (via #executeString: and #forkString:) or as a Block (via #executeBlock:
and #forkBlock:).

The #executeBlock: protocol allows the use of all the usual Smalltalk tools for working
with Smalltalk code, but does not support arguments to the Block and also requires that
the code compiles in the local image.

The #executeString: protocol supports the use of any String, but being a String, it is
opaque to the operation of most Smalltalk tools.

The methods #fork* and #nbSend* are asynchronous and require checking for results via
#nbResult and  #wait*  methods .

The Gem processes created by external session logins are not managed by the system, 
so ensure sessions are logged out to prevent lingering sessions consuming system 
resources unnecessarily.';
		immediateInvariant.
true.
%

removeallmethods AbstractExternalSession
removeallclassmethods AbstractExternalSession

doit
(Object
	subclass: 'Random'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'Random is an abstract superclass of generators of random numbers, that is, 
a sequence of numbers that passes statistical tests of randomness. 

See the comment of each subclass for its properties and recommendations for its use. 
For short non-repeatable sequences with high-quality randomness, use HostRandom.
For repeatable (seeded) sequences where randomness requirements are not stringent, 
use Lag1MwcRandom. For long sequences of random numbers (repeatable or not), 
or when you need repeatable random n-tuples, use Lag25000CmwcRandom. 

For convenience, Random class accepts these messages to create instances of subclases:

    new
        Answers the singleton HostRandom. 

    seed: aSmallInteger
       Answers a Lag1MwcRandom with an initial seed generated from the 
       given SmallInteger


Once you have an instance of any subclass of Random, you can generate random numbers 
with these messages:

    float
        Answers a random Float in the range [0,1)

    floats: n
        Answers a collection of n random floats in the range [0,1)

    integer
        Answers a random non-negative 32-bit integer

    integers: n
        Answers a collection of n random non-negative 32-bit integers

    integerBetween: l and: h
        Answers a random integer in the given range

    integers: n between: l and: h
        Answers a collection of n random integers in the given range

    smallInteger
        Answer a random integer in the full SmallInteger range, [-2**60..2**60)

In most cases, you will want to create an instance of a Random subclass and use that 
instance to generate many random numbers. Creating multiple instances of Random 
subclasses and using each one only a few times is much more expensive. Care is needed 
when storing persistent instances of Random subclasses; see the documentation of each 
subclass for details.';
		immediateInvariant.
true.
%

removeallmethods Random
removeallclassmethods Random

doit
(Random
	subclass: 'HostRandom'
	instVarNames: #()
	classVars: #()
	classInstVars: #(singleton)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'HostRandom allows access to the host operating system''s /dev/urandom random number 
generator.

See also the class comment of Random.

HostRandom is fairly fast to initialize, but after initialization is considerably slower 
than the other subclasses of Random. However, /dev/urandom 
on some platforms may be intended to be a cryptographically secure random number 
generator, which none of the other subclasses are. It also has the advantage of 
not needing an initial seed, and so is good for generating random seeds for the 
faster Random subclasses.

HostRandom uses a shared singleton instance, which is accessed by sending #new to 
the class HostRandom. Sending #new has the side effect of opening the underlying file 
/dev/urandom. This file normally remains open for the life of the session, but if 
you wish to close it you can send #close to the instance, and later send #open to 
reopen it. If you store a persistent reference to the singleton instance the underlying
file will not be open in a new session and you must send #open to the instance before 
asking for a random number. Since the singleton HostRandom instance has no state, 
it may be shared by multiple sessions without conflict.

Since HostRandom is a service from the operating system, it cannot be seeded, and 
should not be used when a repeatable random sequence of numbers is needed.';
		immediateInvariant.
true.
%

removeallmethods HostRandom
removeallclassmethods HostRandom

doit
(Random
	subclass: 'SeededRandom'
	instVarNames: #(multiplier lag carry seeds index)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'SeededRandom is an abstract superclass of classes of generators of sequences of 
random numbers, with the property that a sequence of random numbers may be generated 
repeatedly by giving the same initial seed to the generator.

See also the class comments of Random and of my subclasses.

Instance creation methods to be sent to subclasses:

    new
        Answers a new generator which will by default be seeded from the host OS /dev/urandom

    seed: aSmallInteger
        Answers a new generator seeded with the given seed, which can be any SmallInteger. 
        Another generator of the same class created with the same seed will produce the 
        same sequence of random numbers.

Instance methods:

    seed: aSmallInteger
        Seeds the receiver from the given seed, which can be any SmallInteger.
        The subsequent random number sequence generated will be the same as if this 
        generator had been created with this seed.

    fullState
    fullState:
        The internal state of a generator is more than can be represented by a single SmallInteger. 
        These messages allow you to retrieve the full state of a generator at any time, and 
        to restore that state later.
        The random number sequence generated after the restoration of the state will be the same 
        as that generated after the retrieval of the state. You might, for instance, allow a 
        generator to get its initial state from /dev/urandom, then save this state so the 
        random sequence can be repeated later.';
		immediateInvariant.
true.
%

removeallmethods SeededRandom
removeallclassmethods SeededRandom

doit
(SeededRandom
	subclass: 'Lag1MwcRandom'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'Lag1MwcRandom is a seedable random number generator with a period of about 10**18.

See also the class comments of Random and SeededRandom.

Lag1MwcRandom is a lag-1 generator using the multiply-with-carry algorithm to generate random 
numbers. Compared to Lag25000CmwcRandom, its period is much shorter, it is of limited 
use in generating random n-tuples, and it has been shown that the random bits of the MWC algorithm 
are not quite perfectly fair, so for some uses Lag25000CmwcRandom is superior to this class. 
The primary advantage of Lag1MwcRandom is that it can be seeded by a single 61-bit SmallInteger, 
and initialized quickly, whereas Lag25000CmwcRandom requires a seed of more than 800000 bits, 
and therefore takes considerably longer to initialize, though it''s faster once initialized.

Lag25000CmwcRandom>>seed: uses a Lag1MwcRandom to generate all the seed bits from the 
given SmallInteger seed. ';
		immediateInvariant.
true.
%

removeallmethods Lag1MwcRandom
removeallclassmethods Lag1MwcRandom

doit
(SeededRandom
	subclass: 'Lag25000CmwcRandom'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'Lag25000CmwcRandom is a seedable random generator with a period of over 10**240833. 

See also the class comments of Random and SeededRandom.

Lag25000CmwcRandom is a lag-25000 generator using the complementary multiply-with-carry algorithm 
to generate random numbers. It is slow to initialize, but once initialized it is the fastest 
subclass of Random.  Its period is so long that every possible sequence of 24994 successive 
32-bit integers appears somewhere in its output, making it suitable for generating random 
n-tuples where n<24994. Its output is fair in that the number of 0 bits and 1 bits in the 
full sequence are equal.

This generator is recommended for most uses where its initialization time can be tolerated, 
but it is *not* a cryptographically secure generator, so for applications like key generation 
you should consider using HostRandom, once you satisfy yourself that HostRandom is secure 
enough on your operating system.

When you do not need a repeatable sequence of random numbers, an instance of Lag25000CmwcRandom 
can be created with

    Lag25000CmwcRandom new

which will obtain the needed seed bits from the HostRandom.

When you need a repeatable sequence of random numbers, an instance of Lag25000CmwcRandom can 
be created with

    Lag25000CmwcRandom seed: aSmallInteger

which will use the given SmallInteger to seed a Lag1MwcRandom, which will then provide the seeds 
for the Lag25000CmwcRandom.

You can also allow the seed bits to be initialized from the HostRandom, then retrive that state 
by sending #fullState. That state can later be restored by sending the retrieved state as 
an argument to #fullState:.';
		immediateInvariant.
true.
%

removeallmethods Lag25000CmwcRandom
removeallclassmethods Lag25000CmwcRandom

doit
(Object
	subclass: 'SUnitNameResolver'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SUnitNameResolver
removeallclassmethods SUnitNameResolver

doit
(Object
	subclass: 'TestAsserter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'SUnit-Kernel';
		comment: 'TestAsserter supports instance methods beginning with assert:... and deny:... and the 
class method #assert:description:.  It is the superclass of TestCase and TestResource 
and may be subclassed to implement other test helper classes.

This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods TestAsserter
removeallclassmethods TestAsserter

doit
(TestAsserter
	subclass: 'TestCase'
	instVarNames: #(testSelector)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'SUnit-Kernel';
		comment: 'TestCase is an abstract superclass for classes that implement specific tests. 

Each method of a TestCase subclass with a selector name that starts with ''test'' acts an 
executable test, and will be run. When you create a subclass of TestCase, the framework 
automatically builds a test suite from the test methods of your subclass.

The set of tests that is run will include tests on this class and tests inherited from 
superclasses. To control which tests are run in a hierarchy under TestCase, implement the 
class method isAbstract and/or #shouldInheritSelectors on the superclasses. 

The methods setUp and tearDown are always executed before and after the execution of 
a test method. You can use them to set a specific context in which your test methods are 
executed; e.g., add instance variables to your subclass, and implement setUp and tearDown 
for your subclass to initialize and release values. 

For example, create a subclass of TestCase (for example MyTestCaseSubclass), and implement 
a test method:
test_mytest
   self assert: ( true ).
   self assert:  1 + 1 equals: 2.
   self deny: ( nil notNil ).
   self should: [ 1 / 0 ] raise: 2026.

To run all or a single test and report tests failed, errored, and passed, execute:  
  MyTestCaseSubclass run  
  MyTestCaseSubclass run: #test_mytest

Failures are test assertions that were not met, while errors are code failures such as 
message not understood. 

To run all or a single test, and stop on the first error or failure:
  MyTestCaseSubclass debug
  MyTestCaseSubclass debug: #test_mytest

Example test cases in the image are ExampleSetTest, SUnitTest, SimpleTestResourceTestCase 
and its subclasses and ResumableTestFailureTestCase.

This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods TestCase
removeallclassmethods TestCase

doit
(TestCase
	subclass: 'ExampleSetTest'
	instVarNames: #(full empty)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods ExampleSetTest
removeallclassmethods ExampleSetTest

doit
(TestCase
	subclass: 'ResumableTestFailureTestCase'
	instVarNames: #(duplicateFailureLog)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods ResumableTestFailureTestCase
removeallclassmethods ResumableTestFailureTestCase

doit
(TestCase
	subclass: 'SimpleTestResourceTestCase'
	instVarNames: #(resource)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SimpleTestResourceTestCase
removeallclassmethods SimpleTestResourceTestCase

doit
(SimpleTestResourceTestCase
	subclass: 'FailingTestResourceTestCase'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods FailingTestResourceTestCase
removeallclassmethods FailingTestResourceTestCase

doit
(SimpleTestResourceTestCase
	subclass: 'ManyTestResourceTestCase'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods ManyTestResourceTestCase
removeallclassmethods ManyTestResourceTestCase

doit
(ManyTestResourceTestCase
	subclass: 'CircularTestResourceTestCase'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods CircularTestResourceTestCase
removeallclassmethods CircularTestResourceTestCase

doit
(TestCase
	subclass: 'SUnitTest'
	instVarNames: #(hasRun hasSetup hasRanOnce)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'SUnitTest is an SUnit TestCase concrete subclass that provides an 
example for writing tests, and test coverage for basic SUnit. 

This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SUnitTest
removeallclassmethods SUnitTest

doit
(TestAsserter
	subclass: 'TestResource'
	instVarNames: #(name description)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'SUnit-Kernel';
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods TestResource
removeallclassmethods TestResource

doit
(TestResource
	subclass: 'SimpleTestResource'
	instVarNames: #(runningState hasRun hasSetup)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SimpleTestResource
removeallclassmethods SimpleTestResource

doit
(SimpleTestResource
	subclass: 'SimpleTestResourceA'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SimpleTestResourceA
removeallclassmethods SimpleTestResourceA

doit
(SimpleTestResource
	subclass: 'SimpleTestResourceA1'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SimpleTestResourceA1
removeallclassmethods SimpleTestResourceA1

doit
(SimpleTestResource
	subclass: 'SimpleTestResourceA2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SimpleTestResourceA2
removeallclassmethods SimpleTestResourceA2

doit
(SimpleTestResource
	subclass: 'SimpleTestResourceB'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SimpleTestResourceB
removeallclassmethods SimpleTestResourceB

doit
(SimpleTestResource
	subclass: 'SimpleTestResourceB1'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SimpleTestResourceB1
removeallclassmethods SimpleTestResourceB1

doit
(SimpleTestResource
	subclass: 'SimpleTestResourceCircular'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SimpleTestResourceCircular
removeallclassmethods SimpleTestResourceCircular

doit
(SimpleTestResource
	subclass: 'SimpleTestResourceCircular1'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods SimpleTestResourceCircular1
removeallclassmethods SimpleTestResourceCircular1

doit
(Object
	subclass: 'TestResult'
	instVarNames: #(failures errors passed)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'SUnit-Kernel';
		comment: 'TestResult supports running multiple tests and summarizing results; it holds tests that 
have run, sorted into the result categories of passed, failures and errors.
Failed tests are tests in which test assertions were not met; errors are unexpected errors 
in executing code, such as a message not understood encounted while running the test method. 

This class is part of the community-maintained SUnit framework 
documented at http://sunit.sourceforge.net. The current version is 
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods TestResult
removeallclassmethods TestResult

doit
(Object
	subclass: 'TestSuite'
	instVarNames: #(tests resources name)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'SUnit-Kernel';
		comment: 'A TestSuite is a composite of tests, either TestCases or other TestSuites. The top-level 
protocol is #run or #debug, which run all tests in the receiver. 
A TestSuite is created using TestCase methods run or debug, which builds the TestSuite; 
this will include tests on the receiver TestCase including inherited selectors, and run 
tests on subclasses of the receiver TestCase.   

This class is part of the community-maintained SUnit framework  
documented at http://sunit.sourceforge.net. The current version is  
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz';
		immediateInvariant.
true.
%

removeallmethods TestSuite
removeallclassmethods TestSuite

doit
(PrivateObject
	subclass: 'Upgrade2C'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'Upgrade2C is a class used during image upgrade.  
Methods should only be executed via the image upgrade scripts.';
		immediateInvariant.
true.
%

removeallmethods Upgrade2C
removeallclassmethods Upgrade2C

doit
(Stream
	subclass: 'AppendStream'
	instVarNames: #(collection)
	classVars: #(CrLf CrTab)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AppendStream is a replacement for WriteStream, for streams that are are 
created empty,  appended to , and then the contents are retrieved.
There is no stream-specific support for reading, write limit, nor 
position logic.  Because position and write limit are not
supported the nextPut methods are faster than in WriteStream.';
		immediateInvariant.
true.
%

removeallmethods AppendStream
removeallclassmethods AppendStream

doit
(Stream
	subclass: 'PositionableStreamLegacy'
	instVarNames: #(itsCollection position)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'PositionableStreamLegacy is an abstract superclass 
 that provides additional protocol appropriate to Streams whose objects 
 are externally named by indices.

--- instVar itsCollection
A SequenceableCollection; the sequence of objects that the receiver may
 access.
--- instVar position
A SmallInteger; the current position reference for accessing the collection.
';
		immediateInvariant.
true.
%

removeallmethods PositionableStreamLegacy
removeallclassmethods PositionableStreamLegacy

doit
(PositionableStreamLegacy
	subclass: 'ReadStreamLegacy'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'ReadStream / ReadStreamLegacy is a PositionableStream that allows its objects to 
 be read but not written.';
		immediateInvariant.
true.
%

removeallmethods ReadStreamLegacy
removeallclassmethods ReadStreamLegacy

doit
(ReadStreamLegacy
	subclass: 'ReadByteStreamLegacy'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'ReadByteStreamLegacy is an optimized subclass of ReadStreamLegacy.
It operates on collections that are kinds of String, MultiByteString, or ByteArray.';
		immediateInvariant.
true.
%

removeallmethods ReadByteStreamLegacy
removeallclassmethods ReadByteStreamLegacy

doit
(PositionableStreamLegacy
	subclass: 'WriteStreamLegacy'
	instVarNames: #()
	classVars: #(Cr CrLf CrTab)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'WriteStreamLegacy is a PositionableStream that allows its 
 objects to be written, but not read.';
		immediateInvariant.
true.
%

removeallmethods WriteStreamLegacy
removeallclassmethods WriteStreamLegacy

doit
(Stream
	subclass: 'PositionableStreamPortable'
	instVarNames: #(collection position readLimit)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'PositionableStream / PositionableStreamPortable is the ANSI compliant 
 implementation of PositionableStream, an abstract superclass that provides 
 additional protocol appropriate to Streams whose objects are externally 
 named by indices. Concrete subclasses are ReadStream and WriteStream.

--- instVar collection
A SequenceableCollection; the sequence of objects that the receiver may access.
--- instVar position
A SmallInteger; the current position reference for accessing the collection.
--- instVar readLimit
A SmallInteger; the position in the collection of the last readable character.
';
		immediateInvariant.
true.
%

removeallmethods PositionableStreamPortable
removeallclassmethods PositionableStreamPortable

doit
(PositionableStreamPortable
	subclass: 'ReadStreamPortable'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'ReadStreamPortable is an ANSI compliant implementation of 
 ReadStream, a PositionableStream that allows its objects to be read but 
 not written.';
		immediateInvariant.
true.
%

removeallmethods ReadStreamPortable
removeallclassmethods ReadStreamPortable

doit
(ReadStreamPortable
	subclass: 'ReadByteStreamPortable'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'ReadByteStreamPortable is an optimized subclass of ReadStreamPortable.
It operates on collections that are kinds of String, MultiByteString, or ByteArray.
The  readLimit  instVar is not used; it is always nil .';
		immediateInvariant.
true.
%

removeallmethods ReadByteStreamPortable
removeallclassmethods ReadByteStreamPortable

doit
(PositionableStreamPortable
	subclass: 'WriteStreamPortable'
	instVarNames: #(writeLimit)
	classVars: #(Cr CrLf CrTab)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'WriteStream / WriteStreamPortable is an ANSI compliant implementation of
 WriteStream, a PositionableStream that allows its objects to be written,
 but not read.

--- instVar writeLimit
A SmallInteger; the last position in the collection available for writing.';
		immediateInvariant.
true.
%

removeallmethods WriteStreamPortable
removeallclassmethods WriteStreamPortable

doit
(WriteStreamPortable
	subclass: 'ReadWriteStreamPortable'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'ANSI compliant implementation of ReadWriteStream is a PositionableStream that allows 
its objects to be read and written. 

See ANSI 5.9.7';
		immediateInvariant.
true.
%

removeallmethods ReadWriteStreamPortable
removeallclassmethods ReadWriteStreamPortable

doit
(ReadWriteStreamPortable
	subclass: 'FileStreamPortable'
	instVarNames: #(gsfile streamType)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
FileStream / FileStreamPortable is an ANSI-stream compliant stream that is specifically on a file. 

Instance variables:
gsfile - an instance of GsFile
streamType - a Symbol, one of: #binary, #text, #serverBinary, #serverText, #clientBinary, #clientText
';
		immediateInvariant.
true.
%

removeallmethods FileStreamPortable
removeallclassmethods FileStreamPortable

doit
(Stream
	subclass: 'TranscriptStreamPortable'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
 ANSI compliant implementation of Transcript.

 Sending stream protocol such as nextPut: or nextPutAll: causes the characters 
 to be cached in a session-specific WriteStream, avoiding conflicts.

 On flush or show:, the contents of the WriteStream are written to the sessions
 log on the server via GsFile class>>gciLogServer:
';
		immediateInvariant.
true.
%

removeallmethods TranscriptStreamPortable
removeallclassmethods TranscriptStreamPortable

! Class implementation for 'AbstractExternalSession'

!		Class methods for 'AbstractExternalSession'

category: 'Instance Creation'
classmethod: AbstractExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: aUsername password: aPassword
  ^ self subclassResponsibility: #gemNRS:stoneNRS:username:password:
%

category: 'Instance Creation'
classmethod: AbstractExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: gsUsername password: gsPassword hostUsername: hostUsername hostPassword: hostPassword

  ^ self subclassResponsibility: #gemNRS:stoneNRS:username:password:hostUsername:hostPassword:
%

category: 'Instance Creation'
classmethod: AbstractExternalSession
new
  "disallowed"
  self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: AbstractExternalSession
newDefault
  ^ self subclassResponsibility: #newDefault 
%

category: 'Private'
classmethod: AbstractExternalSession
_stackReport: contextOop
 "contextOop is from   aGciErrSType context"
 | aGsProcess |
 aGsProcess := (Object _objectForOop: contextOop) ifNil:[ ^ ' < NO PROCESS FOUND > '].
 ^ [ aGsProcess stackReportToLevel: 300 withArgsAndTemps: true andMethods: false
   ] on: Error do:[:ex | 'ERROR during stack report ', ex asString ].
%

!		Instance methods for 'AbstractExternalSession'

category: 'Public'
method: AbstractExternalSession
abort
    ^ self subclassResponsibility: #abort
%

category: 'Public'
method: AbstractExternalSession
begin
    ^ self subclassResponsibility: #begin
%

category: 'Error handling'
method: AbstractExternalSession
clearStackFor: aGciError
    ^ self subclassResponsibility: #clearStackFor:
%

category: 'Public'
method: AbstractExternalSession
commit
    ^ self subclassResponsibility: #commit
%

category: 'Public'
method: AbstractExternalSession
commitOrError
    ^ self subclassResponsibility: #commitOrError
%

category: 'Error handling'
method: AbstractExternalSession
continue: contextOop
  ^ self continue: contextOop replacingTopOfStackWithOop: 1"OOP_ILLEGAL"
%

category: 'Error handling'
method: AbstractExternalSession
continue: contextOop replacingTopOfStackWithOop: anOop
    ^ self subclassResponsibility: #continue:replacingTopOfStackWithOop:
%

category: 'Error handling'
method: AbstractExternalSession
continue: contextOop with: anObject
  ^ self continue: contextOop replacingTopOfStackWithOop: anObject asOop
%

category: 'Calls'
method: AbstractExternalSession
executeBlock: aBlock
  "Execute the code in the Block argument in the external Gem
   and answer the result. The best values to return are specials.
   Strings and other byte objects are copied to the local Gem.
   All other responses are returned as a Array of one or more OOPs, 
   see resolveResult:."

   ^self executeString: (self _stringForBlock: aBlock)
%

category: 'Calls'
method: AbstractExternalSession
executeBlock: aBlock with: aValue
  "Execute the code in the Block argument in the external Gem, passing
   in the specified value, and answer the result. The value passed to the
   Block must be one whose printString allows the correct object state to
   be recreated (such as numbers and strings, for example).
   The best values to return are specials.
   Strings and other byte objects are copied to the local Gem.
   All other responses are returned as a Array of one or more OOPs, 
   see resolveResult:."

^ self executeBlock: aBlock withArguments: {aValue}.
%

category: 'Calls'
method: AbstractExternalSession
executeBlock: aBlock with: vOne with: vTwo
  ^ self executeBlock: aBlock withArguments:{ vOne . vTwo }
%

category: 'Calls'
method: AbstractExternalSession
executeBlock: aBlock withArguments: someValues
  "Execute the code in the Block argument in the external Gem, passing
   in the specified values, and answer the result. The values passed to the
   Block must be ones whose printString allows the correct object state to
   be recreated (such as numbers and strings, for example).
   The best values to return are specials.
   Strings and other byte objects are copied to the local Gem.
   All other responses are returned as a Array of one or more OOPs, 
   see resolveResult:."

  ^self executeString: (self _stringForBlock: aBlock withArguments: someValues)
%

category: 'Public'
method: AbstractExternalSession
executeString: aString
    ^ self subclassResponsibility: #executeString:
%

category: 'Public'
method: AbstractExternalSession
forceLogout
    ^ self subclassResponsibility: #forceLogout
%

category: 'Calls'
method: AbstractExternalSession
forkBlock: aBlock

^ self forkString:(self _stringForBlock: aBlock )
%

category: 'Calls'
method: AbstractExternalSession
forkBlock: aBlock with: aValue

^   self forkBlock: aBlock withArguments: {aValue }
%

category: 'Calls'
method: AbstractExternalSession
forkBlock: aBlock with: aValue with: anotherValue

^   self forkBlock: aBlock withArguments: {aValue. anotherValue}.
%

category: 'Calls'
method: AbstractExternalSession
forkBlock: aBlock withArguments: someValues
  "Execute the code in the Block argument in the external Gem, passing
   in the specified values, and do not wait for a result. The values passed
   to the Block must be ones whose printString allows the correct object
   state to be recreated (such as numbers and strings, for example).
   At some later point, you would check for a result. Otherwise you cannot
   issue another call, as the current call would remain in progress.
   Refer to #executeString: for an example of the complete send, wait, response sequence."

  self forkString: (self _stringForBlock: aBlock withArguments: someValues)
%

category: 'Public'
method: AbstractExternalSession
forkString: aString
    ^ self subclassResponsibility: #forkString:
%

category: 'Public'
method: AbstractExternalSession
gemProcessId
    ^ self subclassResponsibility: #gemProcessId
%

category: 'Public'
method: AbstractExternalSession
hardBreak
    ^ self subclassResponsibility: #hardBreak
%

category: 'Public'
method: AbstractExternalSession
isCallInProgress
    ^ self subclassResponsibility: #isCallInProgress
%

category: 'Public'
method: AbstractExternalSession
isLoggedIn
    ^ self subclassResponsibility: #isLoggedIn
%

category: 'Public'
method: AbstractExternalSession
isRemoteServerBigEndian
    ^ self subclassResponsibility: #isRemoteServerBigEndian
%

category: 'Public'
method: AbstractExternalSession
isResultAvailable
    ^ self subclassResponsibility: #isResultAvailable
%

category: 'Public'
method: AbstractExternalSession
lastResult
    ^ self subclassResponsibility: #lastResult
%

category: 'Public'
method: AbstractExternalSession
login
    ^ self subclassResponsibility: #login
%

category: 'Public'
method: AbstractExternalSession
loginSolo
    ^ self subclassResponsibility: #loginSolo
%

category: 'Public'
method: AbstractExternalSession
logout
    ^ self subclassResponsibility: #logout
%

category: 'Public'
method: AbstractExternalSession
nbLogout
    ^ self subclassResponsibility: #nbLogout
%

category: 'Public'
method: AbstractExternalSession
nbResult
    ^ self subclassResponsibility: #nbResult
%

category: 'Public'
method: AbstractExternalSession
parameters
    ^ self subclassResponsibility: #parameters
%

category: 'Public'
method: AbstractExternalSession
resolveResult: anOop
    ^ self subclassResponsibility: #resolveResult:
%

category: 'Public'
method: AbstractExternalSession
resolveResult: anOop toLevel: anInteger
    ^ self subclassResponsibility: #resolveResult:toLevel:
%

category: 'Public'
method: AbstractExternalSession
send: selector to: anOop
  "Answer the result of having the specified remote object
   sent the message with the specified selector.
   The best values to return are specials.
   Strings and other byte objects are copied to the local Gem.
   All other responses are returned as a Array of one or more OOPs, 
   see resolveResult:."

  ^self send: selector to: anOop withArguments: nil
%

category: 'Public'
method: AbstractExternalSession
send: aSelector to: anObject withArguments: anArray
    ^ self subclassResponsibility: #send:to:withArguments:
%

category: 'Public'
method: AbstractExternalSession
softBreak
    ^ self subclassResponsibility: #softBreak
%

category: 'Public'
method: AbstractExternalSession
stoneSessionId
    ^ self subclassResponsibility: #stoneSessionId
%

category: 'Public'
method: AbstractExternalSession
waitForReadReady
    ^ self subclassResponsibility: #waitForReadReady
%

category: 'Public'
method: AbstractExternalSession
waitForResult
    ^ self subclassResponsibility: #waitForResult
%

category: 'Private'
method: AbstractExternalSession
_stringForBlock: aBlock
  | string |
  string := aBlock method _sourceStringForBlock .
  (string at: 1) == $[  ifFalse:[ Error signal:'malformed source'].
  "replace [ ]  with spaces"
  string at: 1 put: $  ; at: string size put: $  .
  ^ string
%

category: 'Private'
method: AbstractExternalSession
_stringForBlock: aBlock withArguments: someValues
  | str nArgs |
  aBlock numArgs == (nArgs := someValues size) ifFalse: [self error: 'Wrong number of arguments'].
  str := aBlock method _sourceStringForBlock .
  nArgs == 0 ifTrue:[
    str addAll: ' value '.
  ] ifFalse:[ | sep stream |
    stream := AppendStream on: String new .
    sep := '' .
    stream nextPutAll: str ; nextPutAll: ' valueWithArguments: {'.
    1 to: nArgs do: [:index | | each |
      each := someValues at: index .
      stream nextPutAll: sep .
      each printOn: stream.
      sep := ' . '.
    ].
    stream nextPut: $}  .
    str := stream contents.
  ].
  (str at: 1) == $[  ifFalse:[ Error signal:'malformed source'].
  ^ str
%

! Class implementation for 'Upgrade2C'

!		Class methods for 'Upgrade2C'

category: 'Image Upgrade'
classmethod: Upgrade2C
initialize
  GsSocket _initSocketErrorSymbols .
  AppendStream initialize .
  self
    _removePrivateClassesFromGlobals ;
    _removeGsTestResult362;
    _checkMaxSecurityPolicyId ;
    _initSecurityPolicies ;
    _createSegmentAliases ;
    _installSecurityPolicyNames ;
    _patchSecurityPolicy15 ;
    _setMiscSecurityPolicies ;
    _initGsPackagePolicy ;
    _initNumericConstants ;
    _initTraceIr .
  System commit.
  self
    _initIcuCollator ;
    _initDeletedUsers ;
    _initCharacter ;
    _initDeprecated .
  GsBitmap _initializeSystemHiddenSetIds .
  System commit.
  ^ true
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_checkMaxSecurityPolicyId
 "Check number of old objectSecurityPolicies needing conversion"
 | oldRep |
 oldRep := Globals at:#SystemRepository .
 oldRep class superClass == Array ifTrue:[ | oldSize maxSegId |
   oldSize := oldRep size .
   maxSegId := 16rFFFE .
   oldSize <= maxSegId ifTrue:[
      ^ oldSize
   ] ifFalse:[
     Error signal: 'old SystemRepository too big, only the first ' , maxSegId asString ,
	' out of ' , oldSize asString , ' will be converted.'
   ]
 ] ifFalse:[
   ^ 0 "no conversion needed"
 ]
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_createSegmentAliases
  "Create aliases for changed names in Globals"
| report list |
report := String new .
list := #(
  #(#'Segment'				#'GsObjectSecurityPolicy')
  #(#'DataCuratorSegment'		#'DataCuratorObjectSecurityPolicy')
  #(#'SystemSegment'			#'SystemObjectSecurityPolicy')
  #(#'SecurityDataSegment'	#'SecurityDataObjectSecurityPolicy')
  #(#'GsIndexingSegment'		#'GsIndexingObjectSecurityPolicy')
  #(#'PublishedSegment'		#'PublishedObjectSecurityPolicy')
   ).
list do: [:pair |
  | oldName newName oldValue newValue |
  oldName := pair at: 1.
  newName := pair at: 2.
  oldValue := Globals at: oldName otherwise: nil.
  newValue := Globals at: newName otherwise: nil.
  (oldValue == nil and:[ newValue ~~ nil]) ifTrue: [
    Globals at: oldName put: newValue.
    report add: 'added '; add: oldName ; lf .
  ].
  (newValue == nil and:[ oldValue ~~ nil]) ifTrue: [
     Globals at: newName put: oldValue.
     report add: 'added '; add: newName ; lf .
  ].
].
list do:[:pair | pair do:[:key | (Globals associationAt: key) immediateInvariant ]].
GsFile gciLogServer: report .
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_initCharacter
(Character classVarAt: 'Backspace' otherwise: nil) ifNil:[ | arr |
  arr := {
    #Backspace . Character codePoint: 8  .
    #Lf . Character codePoint: 10 .
    #Cr . Character codePoint: 13 .
    #Esc . Character codePoint: 27 .
    #NewPage . Character codePoint: 12 .
    #Tab . Character codePoint: 9 . }.
  1 to: arr size by: 2 do:[:j |
    Character _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
  ].
  GsFile gciLogServer:'Character added classVars'.
  ^ 'added'
].
^ 'no change'
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_initDeletedUsers
| deletedUserSet |
deletedUserSet := Globals at: #AllDeletedUsers otherwise: nil .
deletedUserSet ifNotNil:[
  GsFile gciLogServer:'AllDeletedUsers already exists' .
  ^ self
].

deletedUserSet := IdentitySet new.
deletedUserSet assignToObjectSecurityPolicyId: AllUsers objectSecurityPolicyId .
Globals at: #AllDeletedUsers put: deletedUserSet .
GsFile gciLogServer: 'Successfully created AllDeletedUsers' .
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_initDeprecated
  | assoc |
  Globals at:#DeprecationEnabled put: nil .
  assoc := Globals associationAt: #DeprecationEnabled.
  assoc  objectSecurityPolicy == SystemObjectSecurityPolicy ifTrue:[
     assoc objectSecurityPolicy: DataCuratorObjectSecurityPolicy .
  ].
  ^ true
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_initGsPackagePolicy
GsPackagePolicy current.    "create fresh instance in slowfilein"
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_initIcuCollator
  IcuCollator _initializeConstants
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_initNumericConstants
  | blk |
  "initialize various Maximum... numeric value classvars"
  LargeInteger _initializeMaximumValues .
  blk := [:k :v | | oldVal |  "fix 44807"
    oldVal := Globals at: k otherwise: nil .
    (oldVal class == v class and:[ oldVal asString = v asString ]) ifFalse:[
      Globals at: k put: v
    ] ifTrue:[
      oldVal isInvariant ifFalse:[ oldVal immediateInvariant].
    ]
  ].
  { #PlusInfinity . #MinusInfinity . #PlusQuietNaN .
     #MinusQuietNaN . #PlusSignalingNaN . #MinusSignalingNaN }
   do: [ :aSymbol | | f decf decKey |
      f := Float fromString: aSymbol .
      decf := DecimalFloat fromString: aSymbol .
      decKey := Symbol withAll: 'Decimal' , aSymbol .
      blk value: aSymbol value: f .    "fix 43772, regenerate always"
      blk value: decKey value: decf .
      Float _addInvariantClassVar: aSymbol value: f .
      (Float _classVars at: aSymbol) asString = f asString ifFalse:[
        Error signal: 'bad ', aSymbol .
      ].
      DecimalFloat _addInvariantClassVar: decKey value: decf .
      (DecimalFloat _classVars at: decKey) asString = decf asString ifFalse:[
        Error signal: 'bad ', aSymbol .
      ].
  ].
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_initSecurityPolicies
" fix 41803 merged from 2.4.5 ; fix 47441"
 "Now convert or initialize the objectSecurityPolicies in the repository."
|  oldRep inConversion
   rep count report seg sysUser installSegBlock segsCreated |
report := String new .
oldRep := Globals at:#SystemRepository .
oldRep class superClass == Array ifTrue:[ | newSize newRep |
   inConversion := true .
   newSize := oldRep size min: 16rFFFE .  "note message above"
   newSize < 2 ifTrue:[ | dcSeg |
     dcSeg := Globals at:#DataCuratorObjectSecurityPolicy otherwise: nil  .
     dcSeg ~~ nil ifTrue:[
       "looks like a 2.0 or 2.1 repository, need to fixup DataCuratorObjectSecurityPolicy"
       newSize := 2.
       oldRep at:2 put: DataCuratorObjectSecurityPolicy .
       { #GsIndexingObjectSecurityPolicy . #PublishedObjectSecurityPolicy .
	 #GsTimeZoneObjectSecurityPolicy . #SecurityDataObjectSecurityPolicy }
		do:[ :aKey | | aSeg |
          aSeg := Globals at: aKey otherwise: nil .
          aSeg == (oldRep at: 1) ifTrue:[
            "delete this ref to SystemObjectSecurityPolicy"
            Globals removeKey: aKey .
          ].
        ]
     ].
   ].
   newRep := Repository new: newSize .   "new: not yet disallowed"
   newRep instVarAt:1 put: (oldRep instVarAt:1) "name"  .
   newRep instVarAt:2 put: (oldRep instVarAt:2) "dataDictionary" .
   newRep _unsafeSetOop: 240641 .

   GsObjectSecurityPolicy _clearConstraints .

   1 to: newSize do:[:segId| | anObjectSecurityPolicy |
     anObjectSecurityPolicy := oldRep at: segId .
     anObjectSecurityPolicy _unsafeAt: 1 put: newRep .
     anObjectSecurityPolicy _unsafeAt: 7 put: segId  "objectSecurityPolicyId" .
   ].
   1 to: newSize do:[:segId| | anObjectSecurityPolicy |
     anObjectSecurityPolicy := oldRep at: segId .
     newRep _basicAt:segId put: anObjectSecurityPolicy .
     anObjectSecurityPolicy objectSecurityPolicy: DataCuratorObjectSecurityPolicy .
   ].
   newRep objectSecurityPolicy:  DataCuratorObjectSecurityPolicy .
   Globals at:#SystemRepository put: newRep .
   Globals at:#OldSystemRepository put: oldRep .
   report addAll: 'converted ' ; addAll: newSize asString ;
     addAll: ' objectSecurityPolicies. '
] ifFalse:[
   inConversion := false .
   report addAll: 'conversion of SystemRepository not needed. '
].

"Ensure all ObjectSecurityPolicies from a virgin 2.2 exist .
 Gs64 v2.2 bom.c only creates the first 2 . "

rep := Globals at:#SystemRepository .
count := 0 .
segsCreated := { false . false . false . false .  false . false . false . false } .
rep size < 8 ifTrue:[
  [ rep size < 8 ] whileTrue:[
    count := count + 1 .
    GsObjectSecurityPolicy newInRepository: rep .
    segsCreated at: rep size put: true .
  ].
  report addAll:'created '; addAll: count asString ; addAll: ' objectSecurityPolicies. '
].
sysUser := AllUsers userWithId:'SystemUser' .
rep := Globals at:#SystemRepository .

installSegBlock := [ :aKey :aSeg | | oldSeg |
  oldSeg := Globals at: aKey otherwise: nil .
  oldSeg == nil ifTrue:[
    Globals at: aKey put: aSeg
  ] ifFalse:[
    oldSeg == aSeg ifFalse:[
      nil error:'invalid GsObjectSecurityPolicy reference in Globals'
    ]
  ]
].

seg := rep at: 1 .		"repeats bom work, needed for conversion"
installSegBlock value:#SystemObjectSecurityPolicy value: seg .
((segsCreated at: 1) or:[ inConversion]) ifTrue:[
  seg  owner: sysUser ; ownerAuthorization: #write  ;
    worldAuthorization: #read  .
].

seg := rep at: 2 .		"repeats bom work, needed for conversion"
installSegBlock value:#DataCuratorObjectSecurityPolicy value: seg .
((segsCreated at: 2) or:[ inConversion]) ifTrue:[
  seg owner: (AllUsers userWithId:'DataCurator') ;
    ownerAuthorization: #write  ;
    worldAuthorization: #read  .
].

				"remaining not done in bom"
seg := rep at: 3 .	"GsTimeZoneObjectSecurityPolicy no longer used"

seg := rep at: 4 .
installSegBlock value:#GsIndexingObjectSecurityPolicy value: seg .
((segsCreated at: 4) or:[ inConversion]) ifTrue:[
  seg isInvariant ifFalse:[
    seg name: #GsIndexingObjectSecurityPolicy ;
      owner: sysUser ; ownerAuthorization: #write  ;
      worldAuthorization: #write  ; immediateInvariant .
].
].

seg := rep at: 5 .
installSegBlock value:#SecurityDataObjectSecurityPolicy value: seg .
seg isInvariant ifFalse:[
  seg name: #SecurityDataObjectSecurityPolicy ;
    owner: sysUser ; ownerAuthorization: #write  ;
    worldAuthorization: #none  ;  immediateInvariant; _unsafeSetOop: 235777 .
].

seg := rep at: 6 .
installSegBlock value:#PublishedObjectSecurityPolicy value: seg .
((segsCreated at: 6) or:[ inConversion]) ifTrue:[
  seg isInvariant ifFalse:[
    seg owner: sysUser ;   "group authorizations done later in bomlast"
      ownerAuthorization: #write ;
    worldAuthorization: #none .
  ].
].

"GsObjectSecurityPolicy 7 , owned by GcUser , fixed up later"
"GsObjectSecurityPolicy 8, owned by Nameless, fixed up later"

inConversion ifTrue:[
  "converting from a pre-Gs64 v2.2 repository.
   Fix 35966 , repositories from Gs64 v2.0.x and v2.1.x  may
   have objectSecurityPolicyId == OOP_NIL (10r20) in disk object headers ,
   so preallocate a GsObjectSecurityPolicy for objectSecurityPolicyId 20 that is world read-write "
   rep size < 20 ifTrue:[ | newSeg |
     "Possibly a Gs64 v2.0.x or v2.1.x  repository "
     newSeg := GsObjectSecurityPolicy newInRepository: rep .
     newSeg owner: sysUser; ownerAuthorization: #write;
            worldAuthorization:#write ; immediateInvariant  .
     newSeg objectSecurityPolicyId >= 20 ifTrue:[
        nil error:'invalid objectSecurityPolicyId'
     ].
     newSeg _unsafeAt: 7 put: 20 . "_setObjectSecurityPolicyId:  fix 38084"
     rep size: 20 .
     rep at: 20 put: newSeg .
     report addAll: ' created GsObjectSecurityPolicy 20 .'.
   ]
].
GsFile gciLogServer: report
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_initTraceIr
 (GsNMethod _classVars associationAt:#TraceIR)
    objectSecurityPolicy: DataCuratorObjectSecurityPolicy  .
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_installSecurityPolicyNames
 "install the name for each ObjectSecurityPolicy as a dynamic instVar"
GsFile gciLogServer:'starting _installSecurityPolicyNames'.
SystemObjectSecurityPolicy _name ifNil:[
  | nameBlk upBlk |
  #( #DataCuratorObjectSecurityPolicy
     #GsIndexingObjectSecurityPolicy
     #PublishedObjectSecurityPolicy
     #SecurityDataObjectSecurityPolicy
     #SystemObjectSecurityPolicy
     ) do:[ :aSym |
       (Globals at: aSym otherwise: nil) ifNotNil:[:policy |
          (policy _name == nil and:[ policy isInvariant not]) ifTrue:[
              policy name: aSym asString .
              GsFile gciLogServer: 'named ' , aSym
           ].
       ] ifNil:[ GsFile gciLogServer: ' not found: ' , aSym ].
  ].
  nameBlk := [:id :sym |
   SystemRepository size >= id ifTrue:[
     (SystemRepository at: id) ifNotNil:[:pol |
       (pol _name == nil and:[ pol isInvariant not]) ifTrue:[
          pol name: sym .  GsFile gciLogServer:'named ' , id asString, ' as ', sym].
      ].
    ].
  ].
  upBlk := [:id :uid :sym | |up |
    up := AllUsers userWithId: uid ifAbsent:[nil] .
    up ifNotNil:[ (SystemRepository at: id) == up defaultObjectSecurityPolicy
                       ifTrue:[ nameBlk value: id value: sym ]].
  ].
  nameBlk value: 3 value: #GsTimeZoneObjectSecurityPolicy . "policy no longer used"

  upBlk value: 7 value: 'GcUser' value: #GcUserObjectSecurityPolicy .
  upBlk value: 8 value: 'Nameless' value: #NamelessObjectSecurityPolicy .
  GsFile gciLogServer:'added names'.
  ^ self
].
GsFile gciLogServer:'no change'
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_patchSecurityPolicy15
"Patch SystemRepository for mismatched policyId seen in some 3.3.x repositories, fix 48089"
| newPol oldPol newPolId |
SystemRepository size >= 15 ifTrue:[
  (oldPol := SystemRepository at: 15) objectSecurityPolicyId == 20 ifTrue:[
    newPol := GsObjectSecurityPolicy new .
    newPolId := newPol objectSecurityPolicyId .
    1 to: GsObjectSecurityPolicy instSize do:[:n|
      newPol _unsafeAt: n put:(oldPol instVarAt: n) "copy state of policy 15"
    ].
    newPol _unsafeAt: 7 put: 15 . "set itsId instVar"
    SystemRepository _at: 15 put: newPol .
    SystemRepository _at: newPolId put: nil .
    GsFile gciLogServer: 'Recreated GsObjectSecurityPolicy 15'.
    ^ self
  ].
  GsFile gciLogServer: 'No changes to GsObjectSecurityPolicy 15'.
]
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_removeGsTestResult362
	"If the version of GsTestResult from 3.6.2 is present, remove
	it to avoid creating a new class version during upgrade."

	| verDict release |
	verDict := Globals at: #'ImageVersion' ifAbsent: [ ^ self ].
	verDict ifNil: [ ^ self ].
	release := verDict at: #'gsRelease' ifAbsent: [ ^ self ].
	(release findString: '3.6.2' startingAt: 1) = 1
		ifFalse: [ ^ self ].
	Globals removeKey: #'GsTestResult' ifAbsent: [ ^ self ].
	GsFile gciLogServer: 'removed GsTestResult'
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_removePrivateClassesFromGlobals
| str aClass |
str := String new .
{ 211969  "NscNode".
  212225  "NscInteriorNode".
  212481  "NscSetLeaf".
  212737  "NscBagLeaf".
  209409  "LargeObjectNode".
  245761  "Large2ByteLeaf".
  246017  "Large4ByteLeaf".
  246273  "Large8ByteLeaf" } do:[:anOop | | cls key |
    cls := Object _objectForOop: anOop .
    cls removeAllMethods .
    cls class removeAllMethods .
    (Globals includesKey: (key := cls name)) ifTrue:[
      " remove Associations of private classes from Globals"
      Globals removeKey: key .
      str add: 'removed ' , key ; lf .
    ]
].
GsFile gciLogServer: str .
aClass := Object _objectForOop: 211969  "NscNode" .
aClass compileMethod:'size  ^ _varyingSize . "for better output from topaz DUMPOBJ" '.
%

category: 'Image Upgrade'
classmethod: Upgrade2C
_setMiscSecurityPolicies

(SystemLoginNotification _classVars associationAt: #Subscriptions) objectSecurityPolicy: nil.
(TransactionBoundaryDefaultPolicy _classVars associationAt: #Current) objectSecurityPolicy: nil.
%

! Class implementation for 'AppendStream'

!		Class methods for 'AppendStream'

category: 'Image Upgrade'
classmethod: AppendStream
initialize
(AppendStream classVarAt: #CrLf otherwise: nil) ifNil:[ | arr |
  arr := {
    #CrLf .  (String new add:(Character codePoint: 13);
                 add: (Character codePoint: 10); immediateInvariant
                ; yourself ) .
    #CrTab .  (String new add:(Character codePoint: 13);
                 add: (Character codePoint: 9); immediateInvariant
                ; yourself )
  }.
  1 to: arr size by: 2 do:[:j |
    AppendStream _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
  ].
  GsFile gciLogServer:'AppendStream added classVars' .
  ^ 'added'
].
^ 'no change'
%

! Class extensions for 'GsNMethod'

!		Instance methods for 'GsNMethod'

category: 'Repository Conversion'
method: GsNMethod
_literalValToAssocations: aValue
  "Returns a SymbolAssocation or an Array of SymbolAssocations
   thus returning all associations from the current symbolList whose value is
   identical to aValue.  If there are multiple qualifying associations
   with identical keys, the first association found with a given key is included
   in the result."
  | reverseDict tmps |
  reverseDict := (tmps := SessionTemps current) at: #GsRecompileValuesToKeys ifAbsent:[
    tmps at: #GsRecompileValuesToKeys put: IdentityDictionary new
  ].
  ^ reverseDict at: aValue ifAbsent:[ | keys values |
     keys := IdentitySet new .  values := { } .
     GsSession currentSession symbolList do:[ :symd |
       symd associationsDo:[ :assoc |
         (assoc value == aValue and:[ (keys includes: assoc key) == false]) ifTrue:[
           keys add: assoc key .
           values add: assoc.
         ]
       ].
     ].
     values size == 0 ifTrue:[ |vCls |
       ((vCls := aValue class) == ByteArray
           or:[ (vCls == Array and:[ aValue isInvariant])
           or:[ (aValue isKindOf: String) and:[ aValue isInvariant]]]) ifFalse:[
         Warning signal: 'cannot find key for optimized literal value oop ' ,
            aValue asOop asString , ' (a ' , aValue class name, ')' .
       ]
     ].
     ^ reverseDict at: aValue put: (values size == 1 ifTrue:[ values at: 1] ifFalse:[ values]).
  ]
%

category: 'Private'
method: GsNMethod
_recursiveSize: arr
 | terminationSet |
  ((terminationSet := arr at: 1) includes: self) ifTrue:[ ^ self ].
  terminationSet add: self .
 arr at: 2 put:(arr at:2) + self physicalSizeOnDisk .
%

category: 'Private'
method: GsNMethod
_recursiveSizeInMemory: arr
 | terminationSet |
  self isCommitted ifTrue:[ ^ self ] .
  ((terminationSet := arr at: 1) includes: self) ifTrue:[ ^ self ].
  terminationSet add: self .
 arr at: 2 put:(arr at:2) + self physicalSizeOnDisk .
%

category: 'Debugging Support'
method: GsNMethod
_setBreakAtIp: ipOffset operation: opcFlags frame: fpOffset process: aGsProcess breakpointLevel: brkLevel

"Set breakpoint at specified ipOffset.  ipOffset is an instruction offset,
 which is a absolute byte offset within the receiver.

 Checks that the receiver is not part of the implementation of the scheduler.

 opcFlags is a SmallInteger , fields have these masks
    opcode 		   16rFF
    includeMethodStartBcs 16r100 , a Boolean , only affects opcode==1
        when ipOffset == -1 .

 opcode  action
   0	 set or reenable method breakpoint
   1     set single step breakpoint (takes precedence over method break)
   2     delete method breakpoint or disabled method breakpoint
   3     delete single step breakpoint
   4     disable method breakpoint, no action if breakpoint not set
   5     set step-into breakpoint on a send bytecode .

  If ipOffset == -1, then apply the action to all step points within the
  method.

  To restrict breakpoint to a specific GsProcess, aGsProcess must be non-nil.

  For opcodes 1,5  to restrict breakpoint to a specific frame
  and/or GsProcess , fpOffset and/or aGsProcess must be non-nil. 

  If brkLevel must be a SmallInteger ,
  0 = signal to GCI , >= 1 signal to Smalltalk .
"

(ProcessorScheduler scheduler _criticalMethods includes: self) ifTrue:[
  ^ Error signal:'cannot set breakpoints within the ProcessorScheduler'
].
^ self __setBreakAtIp: ipOffset operation: opcFlags frame: fpOffset process: aGsProcess
       breakpointLevel: brkLevel
%

! Class Initialization Excluded by export visitor
!  AppendStream initialize.
!  Upgrade2C initialize.
