! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(AbstractCollisionBucket
	_newKernelSubclass:'CanonStringBucket'
	instVarNames: #(keyValueDictionary)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 119041
)
		category: nil;
		comment: 'A CanonStringBucket is an Array that is used in a 
 CanonSymbolsDictionary .  It contains keys which have the same String
 hash value , and is sorted by value comparision of the keys.
 The comparision is done using binary comparison of the bytes of the keys.
 The hash value must be computed by using CanonStringDict >> hashFunction:
';
		immediateInvariant.
true.
%

removeallmethods CanonStringBucket
removeallclassmethods CanonStringBucket

doit
(AbstractDictionary
	_newKernelSubclass:'CanonStringDict'
	instVarNames: #(numElements tableSize)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 119297
)
		category: nil;
		comment: 'A CanonStringDict is a dictionary that provides
 protocol that is similar to Set in addition to its dictionary protocol.
 It uses sorted collision buckets, and stores only keys. Each slot in
 the dictionary object contains a references to a bucket, or nil  

Constraints:
	numElements: SmallInteger
	tableSize: SmallInteger
	[elements]: CanonStringBucket';
		immediateInvariant.
true.
%

removeallmethods CanonStringDict
removeallclassmethods CanonStringDict

doit
(CanonStringDict
	_newKernelSubclass:'CanonSymbolDict'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 119553
)
		category: nil;
		comment: 'CanonicalSymbolDict is the class of AllSymbols. Instances may
 only be modified by SystemUser, or the SymbolCreation session.

Constraints:
	numElements: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods CanonSymbolDict
removeallclassmethods CanonSymbolDict

doit
(AbstractDictionary
	subclass: 'TreeDictionary'
	instVarNames: #(rootNode tally walker heap scratchLeaf)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'HashTree-Core';
		comment: 'TreeDictionary is a dictionary that has good performance in GemStone at a wide variety of sizes, 
and grows gracefully without long pauses.

It is structured as a a tree which is sorted based on a permutation of the #hash of the dictionary''s keys. 
Nodes of the tree are sized to match the GemStone page size. 
Leaf nodes are page-sized hash tables, and internal nodes are a B+tree variant that allows duplicate keys.


Instance variables:

tally     How many key-value pairs I contain
rootNode  Either a HtDictionaryLeafNode (if my size is small) 
           or a HtDictionaryInternalNode (if my contents will not fit in one leaf node)
walker    A cached instance of HtDictionaryTreeWalker that helps with operations on the tree
scratchLeaf   A cached instance of HtDictionaryScratchLeafNode that is used for temporary storage 
              during the splitting of a leaf node when it becomes full
heap    A cached instance of HtHeap, used to heap-sort a leaf node being split. 
        This is necessary only in uncommon situations where the normal heuristic for splitting a 
        leaf node results in a very uneven split.

The cached instances are all dbTransient, so modifications to them will not need to be written to 
tranlogs or extents upon commit.
They are cached, rather than created at each operation, to avoid creating unnecessary garbage during 
normal operations on the dictionary.';
		immediateInvariant.
true.
%

removeallmethods TreeDictionary
removeallclassmethods TreeDictionary

doit
(AbstractExternalSession
	subclass: 'GsExternalSession'
	instVarNames: #(parameters gciSessionId stoneSessionId stoneSessionSerial gemProcessId gciErrSType nbResult logger)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'External Sessions';
		comment: 'GsExternalSession is a legacy implementation of AbstractExternalSession
that loads $GEMSTONE/lib/librpc*.so  and uses FFI to call Gci functions in
that libgcirpc library.

New code should use GsTsExternalSession.

GsExternalSession is not green-thread-safe, so use of more than one instance 
of GsExternalSession in a session with multiple GsProcesses active can be 
unreliable.

GsExternalSession is not supported on AIX; on AIX, use GsLegacyExternalSession.

Example:

| sess |
sess := GsExternalSession
	gemNRS: GsNetworkResourceString defaultGemNRSFromCurrent
	stoneNRS: GsNetworkResourceString defaultStoneNRSFromCurrent
	username: ''DataCurator''
	password: ''swordfish''.
sess login.
sess executeString: ''System stoneName''.
sess executeBlock: [2 + 5].
sess logout.';
		immediateInvariant.
true.
%

removeallmethods GsExternalSession
removeallclassmethods GsExternalSession

doit
(GsExternalSession
	subclass: 'GsLegacyExternalSession'
	instVarNames: #(gciInterface traversalBuffer)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'External Sessions';
		comment: 'GsLegacyExternalSession is a variant of GsExternalSession which is used in
environments where the FFI GciLibrary cannot be used. It uses the GCI Interface
which is based on system primitives rather than FFI calls.

At this time, AIX is the only known environment where this class must be used.
';
		immediateInvariant.
true.
%

removeallmethods GsLegacyExternalSession
removeallclassmethods GsLegacyExternalSession

doit
(GsExternalSession
	subclass: 'GsX509ExternalSession'
	instVarNames: #(username)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509';
		comment: 'GsX509ExternalSession is a variant of GsExternalSession which uses an X509 certificate as
login credentials rather than a user id and password.

Example:

| p s |
p := GemStoneX509Parameters
      newFromPemFilesWithNetldiPort: ''54321''
      netldiHost: ''localhost''
      certificate: ''DataCurator.chain.pem''
      caCertificate: ''stoneCA-gs64stone.cert.pem''
      privateKey: ''DataCurator.privkey.pem'' .
s := GsX509ExternalSession newWithX509Parameters: p.
s login .

';
		immediateInvariant.
true.
%

removeallmethods GsX509ExternalSession
removeallclassmethods GsX509ExternalSession

doit
(Array
	_newKernelSubclass:'ErrorDescription'
	instVarNames: #(categoryOop number contextOop message fatal gciInterface)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 117761
)
		category: nil;
		comment: 'ErrorDescription is used by the class GciInterface. 
Instances describe errors returned from a remote VM.

Constraints:
	categoryOop: Integer
	number: Integer
	contextOop: Object
	message: String
	fatal: Boolean
	gciInterface: Object';
		immediateInvariant.
true.
%

removeallmethods ErrorDescription
removeallclassmethods ErrorDescription

doit
(Array
	subclass: 'GsX509CertificateChain'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509';
		comment: 'GsX509CertificateChain encapsulates a TLS/SSL certificate chain. ';
		immediateInvariant.
true.
%

removeallmethods GsX509CertificateChain
removeallclassmethods GsX509CertificateChain

doit
(Array
	subclass: 'HtInternalNode'
	instVarNames: #(multiplier preShift postShift tally lowestHash highestHash collection)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'HashTree-Core';
		comment: 'A hash tree internal node is an internal node of a B+tree-like structure used as 
part of the implementation of collections like TreeDictionary and TreeSet.

Unlike conventional B+trees, allows duplicate keys.
Keys here are known as "hashes" because they''re derived from a permutation of 
what is returned by the #hash of a key object for the collection.

The permutation typically produces hashes that are close to evenly distributed
in the range [0..2^60). The even distribution makes it efficient to search the node 
by making a "good guess" as to where a given hash will be, and do a linear search 
from there. It is typical for the "good guess" to be optimal in over 90% of searches, 
and for most of the remaining few percent to find the hash within one cache line
of the initial probe. The shortness of the search and the small number of cache line
reads make this search strategy considerably faster than the binary search that 
sorted trees need to use when keys are not uniformly distributed.

In the atypical case where there are a large number of hash collisions (identical 
hashes) searches get slower, degrading in the worst case to overall linear search,
which is also the case in any collection containing many elements with identical
lookup keys.

Internal Representation and Key Implementation Points.
  Instance Variables
  multiplier:  <SmallInteger> A cache of a scaled approximation of 
                  tally / (highestHash - lowestHash)
               Used in computing the "good guess" of initial search index
  					
  preShift:  <SmallInteger> If (targetHash - lowestHash) has more than 30 significant bits 
         (which is typical) this shift is used to discard the low-order bits, 
          to prevent overflow out of the SmallInteger range when multiplied by multiplier.
         Always non-positive.  Used in computing the "good guess" of initial search index

  postShift:  <SmallInteger> Since multiplier is scaled by a power of two to become
         an integer with a reasonable number of significant bits (typically 29 or 30), 
         this shift is used to undo that shift when computing the "good guess" index.

  tally:   <SmallInteger> How many child pointers I currently contain.
  
  lowestHash:  <SmallInteger> A cache of (self at: 1), the lowest hash value that any
  	      of my children can contain.

  Note that multiplier, preShift, postShift, and lowestHash are the most frequently 
  accessed named instvars, used for every search. Therefore, they, along with tally, which
  is accessed every time my size changes, are placed first in the object, so that
  they will be in the same cache line as the object header and not incur the cost of
  another cache line read on these operations.

  highestHash: 	<SmallInteger> A cache of    (self at: (tally * 2 + 1)) , 
               the highest hash value that any of my children can contain.

  collection	<TreeDictionary | TreeSet> The collection that I am part of.

  My size is the maximal odd number to fit in a GemStone 16KB page.
  Indexed instvars are alternating hash SmallIntegers and child pointers. 
  If tally is 5 (indicating there are five children) it will look like

    1    2    3    4   5   6    7    8   9   10  11  12...
  | H | C | H | C | H | C | H | C | H | C | H | nils...
  
  The lowestHash (@1) and highestHash (@11) values are redundant; they
  duplicate the hash values to the left and right of the child pointer 
  in the parent. Duplicating them here simplifies the search loop logic.
  
Implementation Points

  The main invariant is that all entries in the subtree of a child pointer
  will have a hash >= to the hash to the left of the child pointer, and a hash <= 
  the hash to the right of the child pointer. 
  Note that since there''s an equal on both sides, the left and right hashes 
  may be the same. Hash tree collections support unlimited hash collisions, so this
  is necessary. If there are enough keys with identical hashes, the lowestHash 
  and highestHash of an internal node may be equal.';
		immediateInvariant.
true.
%

removeallmethods HtInternalNode
removeallclassmethods HtInternalNode

doit
(HtInternalNode
	subclass: 'HtDictionaryInternalNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'HashTree-Core';
		comment: 'A hash tree dictionary internal node is an HtInternalNode specialized for use as part of a TreeDictionary.
See HtInternalNode''s class comment for further information.';
		immediateInvariant.
true.
%

removeallmethods HtDictionaryInternalNode
removeallclassmethods HtDictionaryInternalNode

doit
(HtInternalNode
	subclass: 'HtSetInternalNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'HashTree-Core';
		comment: 'A hash tree set internal node is an HtInternalNode specialized for use as part of a TreeSet.
See HtInternalNode''s class comments for further information.';
		immediateInvariant.
true.
%

removeallmethods HtSetInternalNode
removeallclassmethods HtSetInternalNode

doit
(Array
	subclass: 'HtLeafNode'
	instVarNames: #(tableSize arraySize tally collection fillLine lowestHash highestHash)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'HashTree-Core';
		comment: 'HtLeafNode (hash tree leaf node) is an abstract superclass for a 
page-sized hash table that uses open-addressing with linear probing. 
This gives good performance in modern memory hierarchies by 
needing to read fewer cache lines than alternative hash table 
architectures such as those that use buckets.

Instance variables:

tally		    The number of entries I contain
collection	The collection that I am part of

lowestHash	I am guaranteed to contain no keys whose permuted hash is less than this integer.
     A copy of the hash value to the left of the pointer to me in my parent node (if any).
					
highestHash		I am guaranteed to contain no keys whose permuted hash is greater than this integer.
     A copy of the hash value to the right of the pointer to me in my parent node (if any).

Cached constants -- these vary by subclass, but are the same for all instances of each subclass, and 
             are cached to avoid re-computing them all the time:
arraySize	   The number of indexed instance variables I contain
tableSize		 The number of entry slots I have in my table. Should be prime for good performance.
fillLine		 The number of entries which I can contain before being considered "full" and splitting.';
		immediateInvariant.
true.
%

removeallmethods HtLeafNode
removeallclassmethods HtLeafNode

doit
(HtLeafNode
	subclass: 'HtDictionaryLeafNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'HashTree-Core';
		comment: 'A hash tree dictionary leaf node is an HtLeafNode specialized for use as part of a TreeDictionary.
See HtLeafNode''s class comment for further information.';
		immediateInvariant.
true.
%

removeallmethods HtDictionaryLeafNode
removeallclassmethods HtDictionaryLeafNode

doit
(HtDictionaryLeafNode
	subclass: 'HtDictionaryScratchLeafNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'dbTransient'  #logCreation )
)
		category: 'HashTree-Core';
		comment: 'A dbTransient HtDictionaryLeafNode, specialized for temporary scratch use while splitting leaf nodes';
		immediateInvariant.
true.
%

removeallmethods HtDictionaryScratchLeafNode
removeallclassmethods HtDictionaryScratchLeafNode

doit
(HtLeafNode
	subclass: 'HtSetLeafNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'HashTree-Core';
		comment: 'A hash tree set leaf node is an HtLeafNode specialized for use as part of a TreeSet.
See HtLeafNode''s class comment for further information.';
		immediateInvariant.
true.
%

removeallmethods HtSetLeafNode
removeallclassmethods HtSetLeafNode

doit
(HtSetLeafNode
	subclass: 'HtSetScratchLeafNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'dbTransient'  #logCreation )
)
		category: 'HashTree-Core';
		comment: 'A dbTransient HtSetLeafNode, specialized for temporary scratch use while splitting leaf nodes';
		immediateInvariant.
true.
%

removeallmethods HtSetScratchLeafNode
removeallclassmethods HtSetScratchLeafNode

doit
(Array
	_newKernelSubclass:'MappingInfo'
	instVarNames: #(object pathTerm dependencyList ivOffset)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 90113
)
		category: nil;
		comment: 'The class MappingInfo implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.

Constraints:
	object: Object
	pathTerm: PathTerm
	dependencyList: DependencyList
	ivOffset: Integer';
		immediateInvariant.
true.
%

removeallmethods MappingInfo
removeallclassmethods MappingInfo

doit
(Array
	subclass: 'NonPersistentArray'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: nil;
		comment: 'NonPersistentArray is a kind of Array with the instancesNonPersistent option. ';
		immediateInvariant.
true.
%

removeallmethods NonPersistentArray
removeallclassmethods NonPersistentArray

doit
(BtreeLeafNode
	subclass: 'SortBlockNode'
	instVarNames: #(blockSorter totalElements)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'SortBlockNode is a concrete class that along with the class BlockSorter implements the 
 behavior used to sort collections efficiently. It is an interface to an algorithm based 
 on an efficient merge-sort.

Constraints:
	numElements: SmallInteger
	blockSorter: Object
	totalElements: Object';
		immediateInvariant.
true.
%

removeallmethods SortBlockNode
removeallclassmethods SortBlockNode

doit
(SortBlockNode
	subclass: 'SortBlockUnicodeNode'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'SortBlockUnicodeNode is a concrete class that along with the class BlockSorter implements the 
 behavior used to sort collections efficiently. It is an interface to an algorithm based 
 on an efficient merge-sort.

Constraints:
	numElements: SmallInteger
	blockSorter: Object
	totalElements: Object';
		immediateInvariant.
true.
%

removeallmethods SortBlockUnicodeNode
removeallclassmethods SortBlockUnicodeNode

doit
(CollisionBucket
	_newKernelSubclass:'SoftCollisionBucket'
	instVarNames: #(lastCleanupCount)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'instancesNonPersistent'  #logCreation )
	reservedOop: 120833
)
		category: nil;
		comment: 'A SoftCollisionBucket is a CollisionBucket intended to
 store key/SoftReference pairs .
 key/SoftReference pairs whose SoftReferences have been cleared by 
 the in-memory garbage collector will be removed from a SoftCollisionBucket 
 during the next at:put: operation following a garbage collection which cleared
 the references.  
 
 Cleared SoftReferences will also be removed when their key matches
 the argument key for a lookup operation .  The lookup code will
 not remove cleared SoftReferences for non-matching keys.

 Instances of SoftCollisionBucket are non-persistent and may
 not be committed to the repository.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object
	lastCleanupCount: SmallInteger

lastCleanupCount is private to the implementation of SoftCollisionBucket, 
 used to manage removal of SoftReferences.';
		immediateInvariant.
true.
%

removeallmethods SoftCollisionBucket
removeallclassmethods SoftCollisionBucket

doit
(Error
	subclass: 'GciLegacyError'
	instVarNames: #(errorDescription externalSession originalNumber)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'External Sessions';
		comment: 'This class is part of the External Sessions implementation and represents
an execution Error from the GCI interface to the legacy external session.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	errorDescription: Object
	externalSession: Object
	originalNumber: Object
';
		immediateInvariant.
true.
%

removeallmethods GciLegacyError
removeallclassmethods GciLegacyError

doit
(ExternalError
	subclass: 'AwsError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AwsError is an error returned when performing authentication with Amazon Web Services.';
		immediateInvariant.
true.
%

removeallmethods AwsError
removeallclassmethods AwsError

doit
(ExternalError
	subclass: 'AzureError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AzureError is an error returned when performing authentication with Microsoft Azure Web Services.';
		immediateInvariant.
true.
%

removeallmethods AzureError
removeallclassmethods AzureError

doit
(GsSignalingSocket
	_newKernelSubclass:'GsSecureSocket'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 248833
)
		category: nil;
		comment: 'GsSecureSocket provides the means for creating and binding TLS TCP sockets
 through the operating system of the machine that is running the session''s Gem process, and
 for communicating across those sockets.  Methods that block GemStone Smalltalk
 until the socket operation completes are interruptable by a hard break.  (You
 can get a hard break in Topaz by pressing the control-C key twice.  You can get
 a hard break in GemBuilder for C by calling the GciHardBreak function, and in
 GemBuilder for Smalltalk by calling the corresponding hard break method.)

 Like instances of GsSocket, instances of GsSecureSocket automatically have
 their C state closed when the instance is garbage collected or 
 when a persistent instance drops out of memory.

 SSLv2 and SSLv3 connections are not supported because such connections are known to 
 be insecure. Only and TLSv1.x connections are currently supported.

 To create a secure connection, a regular socket connection must first be established.
 Use the methods inherited from GsSocket to establish a socket connection.

                              Warning:
    Do not retain an instance of GsSecureSocket from one session to another.
    Instances of GsSecureSocket are intended to exist only within a given GemStone
    session.  GsSecureSockets that are used across sessions always generate an error.

 All instVars of GsSecureSocket are private, for use by the implementation
 of socket methods, and for use by the ProcessorScheduler only.

Constraints:
	fileDescriptor: SmallInteger
	lineNumber: SmallInteger
	readWaiters: Object
	writeWaiters: Object
	readyEvents: SmallInteger
	pollArrayOfs: SmallInteger
	interrupting: Object';
		immediateInvariant.
true.
%

removeallmethods GsSecureSocket
removeallclassmethods GsSecureSocket

doit
(GsSignalingSocket
	subclass: 'GsSshSocket'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'noInheritOptions'  #logCreation )
)
		category: nil;
		comment: 'A GsSshSocket represents a SSH socket connection, allowing you to connect to another host using 
SSH and perform commands. 

To create a SSH connection, create a client socket using methods inherited from GsSocket, and 
connect using sshConnect. 

The default userId is the userId of the current session. If passwordless login is setup to the 
remote host, you do not need to specify the password or private key.  

  sshSock := GsSshSocket newClient.
  sshSock connectToHost: <aHostnameOrIP> timeoutMs: 2000.
  "depending on configuration"  sshSock userId: <userName>.
  "depending on configuration"  sshSock privateKey: <aTlsPrivateKey>. 
  "depending on configuration"  sshSock privateKey: <aGsSshPrivateKey>. 
  "depending on configuration"  sshSock password: <passwordString>. 
  "depending on configuration"  sshSock disableHostAuthentication .
  sshSock sshConnect.

You can then execute command using executeRemoteCommand:, or other methods to perform non-blocking 
query. Close the socket when you no longer need the connection. 

   result := sshSock executeRemoteCommand: ''ulimit -a''.
   sshSock close.';
		immediateInvariant.
true.
%

removeallmethods GsSshSocket
removeallclassmethods GsSshSocket

doit
(GsSshSocket
	subclass: 'GsSftpSocket'
	instVarNames: #(openFiles)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'A GsSftpSocket represents a sftp socket connection, allowing you to perform SFTP operations to a
remote node.

To create a GsSfptSocket connection, create a client socket using methods inherited from GsSocket, and 
connect using sshConnect. 

GsSftpSocket provides some file and directory operations. To read and write remote files, create an 
instance of GsSftpRemoteFile.  

instance variables:
  openFiles -- instance of GsSftpRemoteFile that are open on this instance.

For example, the following connects to the host hostnameOrIP and fetches directory contents:
  sshFtpSock := GsSftpSocket newClient.
  sshFtpSock connectToHost: <aHostnameOrIP> timeoutMs: 2000.
  sshFtpSock userId: <userName>.
  sshFtpSock password: <passwordString>. 
  sshFtpSock sshConnect.
  result := sftpSock contentsOfRemoteDirectory: ''.''.
  sshFtpSock close';
		immediateInvariant.
true.
%

removeallmethods GsSftpSocket
removeallclassmethods GsSftpSocket

doit
(IdentityCollisionBucket
	_newKernelSubclass:'IdentitySoftCollisionBucket'
	instVarNames: #(lastCleanupCount)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'instancesNonPersistent'  #logCreation )
	reservedOop: 121089
)
		category: nil;
		comment: 'A IdentitySoftCollisionBucket is an IdentityCollisionBucket intended to
 store key/SoftReference pairs .
 key/SoftReference pairs whose SoftReferences have been cleared by 
 the in-memory garbage collector will be removed from a 
 IdentitySoftCollisionBucket during the next at:put: operation 
 following a garbage collection which cleared the references.  
 
 Cleared SoftReferences will also be removed when their key matches
 the argument key for a lookup operation .  The lookup code will
 not remove cleared SoftReferences for non-matching keys.

 Instances of IdentitySoftCollisionBucket are non-persistent and may
 not be committed to the repository.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object
	lastCleanupCount: SmallInteger

instVar lastCleanupCount -- Private to the implementation of IdentitySoftCollisionBucket, used to manage
 removal of SoftReferences.';
		immediateInvariant.
true.
%

removeallmethods IdentitySoftCollisionBucket
removeallclassmethods IdentitySoftCollisionBucket

doit
(IdentitySet
	_newKernelSubclass:'UserProfileGroup'
	instVarNames: #(groupName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 157441
)
		category: nil;
		comment: 'This class is the logical representation of a group of UserProfiles.
 It contains the following instance variable:
   groupName         - A symbol representing the name of the group.
';
		immediateInvariant.
true.
%

removeallmethods UserProfileGroup
removeallclassmethods UserProfileGroup

doit
(KeyValueDictionary
	_newKernelSubclass:'KeySoftValueDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
	reservedOop: 120321
)
		category: nil;
		comment: 'KeySoftValueDictionary is a subclass of KeyValueDictionary.
 Instances of KeySoftValueDictionary are non-persistent and may not be
 committed ot the repository.

 All values in KeySoftValueDictionary are instances of SoftReference .

 Various instance methods in KeySoftValueDictionary will automatically
 remove from a KeySoftValueDictionary any SoftReferences whose value
 instVar has been cleared by the in-memory garbage collector.

 See comments on GC behavior in $GEMSTONE/bin/initial.config under
 GEM_SOFTREF_CLEANUP_PERCENT_MEM and GEM_KEEP_MIN_SOFTREFS. 

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods KeySoftValueDictionary
removeallclassmethods KeySoftValueDictionary

doit
(KeySoftValueDictionary
	_newKernelSubclass:'IdentityKeySoftValueDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 120577
)
		category: nil;
		comment: 'IdentityKeySoftValueDictionary is a subclass of KeySoftValueDictionary
 which uses identity comparision on keys.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods IdentityKeySoftValueDictionary
removeallclassmethods IdentityKeySoftValueDictionary

doit
(Magnitude
	subclass: 'DateAndTimeANSI'
	instVarNames: #(seconds offset)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
)
		category: nil;
		comment: 'This protocol describes the behavior that is common to date
time objects. Date time objects represent individual points
in Coordinated Universal Time (UTC) as represented in an
implementation defined local time, with a default resolution
of seconds.

The exact properties of local times are unspecified. Local
times may differ in their offset from UTC. A given local time
may have different offsets from UTC at different points in time.

All dates and times in the UTC local time are in the Gregorian
calendar. Date times prior to the adoption of the Gregorian
calendar are given in the retrospective astronomical Gregorian
calendar. The year 1 B.C. is astronomical Gregorian year 0.
The year 2 B.C. is astronomical Gregorian year-1. The year 1 A.D.
is astronomical Gregorian year 1. The offset of the UTC local
time is zero.';
		immediateInvariant.
true.
%

doit
(DateAndTimeANSI
	subclass: 'DateAndTime'
	instVarNames: #()
	classVars: #(DefaultScale)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
)
		category: nil;
		comment: 'DateAndTime is a GemStone specific implementation of the
DateAndTimeANSI standard. 

DateAndTime objects represent individual points in Coordinated 
Universal Time (UTC) as represented in local time with an offset. 
The offset of the UTC local time is zero.  

The default resolution for DateAndTime instances is microseconds. 
The class variable DefaultScale is no longer used.

DateAndTimes are in the Gregorian calendar. (the common calendar
adpoted in Europe in 1582). Date times prior to the adoption of this 
calendar are given in the retrospective astronomical Gregorian
calendar. The year 1 B.C. is astronomical Gregorian year 0.
The year 2 B.C. is astronomical Gregorian year -1. The year 1 A.D.
is astronomical Gregorian year 1.';
		immediateInvariant.
true.
%

doit
(Object
	subclass: 'AbstractCloudCredentials'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AbstractCloudCredentials is an abstract superclass to support credentails 
required for authentication with services in the cloud.';
		immediateInvariant.
true.
%

removeallmethods AbstractCloudCredentials
removeallclassmethods AbstractCloudCredentials

doit
(AbstractCloudCredentials
	subclass: 'AwsCredentials'
	instVarNames: #(accessKeyId secretKeyId sessionId)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AwsCredentials is designed to hold credentials for accessing Amazon
Web Services (AWS). All instance variables are Strings. sessionId 
optional and may be set to an empty string if not needed.

AwsCredentials are used to unlock AwsDataKey objects. See the
comments in the AwsDataKey class for more information.';
		immediateInvariant.
true.
%

removeallmethods AwsCredentials
removeallclassmethods AwsCredentials

doit
(AbstractCloudCredentials
	subclass: 'AzureCredentials'
	instVarNames: #(clientId clientSecret tenantId)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AzureCredentials is designed to hold credentials for accessing Azure.
All instance variables are Strings.

AzureCredentials are used to unlock AzureDataKey objects. See the
comments in the AzureDataKey class for more information.';
		immediateInvariant.
true.
%

removeallmethods AzureCredentials
removeallclassmethods AzureCredentials

doit
(Object
	subclass: 'AbstractCloudKey'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AbstractCloudKey is an abstract superclass to support keys 
required for authentication with services in the cloud.';
		immediateInvariant.
true.
%

removeallmethods AbstractCloudKey
removeallclassmethods AbstractCloudKey

doit
(AbstractCloudKey
	_newKernelSubclass:'AwsDataKey'
	instVarNames: #(cmsKeyId encryptedDataKey keySizeBytes)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 250881
)
		category: nil;
		comment: 'AwsDataKey is a class that holds a local encryption key. In order
to use the key, it must be decrypted by accessing a Customer Master Key
(CMK) stored in the Amazon cloud.

Instance variables:

cmsKeyId (String) the Amazon Resource Name (ARN) of the CMK.
encryptedDataKey -(String)  the local data key in encrypted form, stored
                   as base 64 text.
keySizeBytes (SmallInteger) - the size of the key in bytes (either 16 or 32).

AwsDataKeys may be in a locked or unlocked state. Locked means the
key has not yet been decrypted by the current session. Unlocked means the
data key has been decrypted and is stored in session memory. AwsDataKeys
may only be used to encrypt or decrypt data in the unlocked state.

If an AwsDataKey is committed to GemStone, it is always stored on disk 
in its locked state. Once an AwsDataKey is unlocked, it remains unlocked
until it is sent the #lock message or the session logs out.

AWS support is only available on platforms that support both the 
AWS software developer toolkit for C++ and GemStone server VMs. 
Currently those platforms include MacOS and Linux. See 
https://github.com/aws/aws-sdk-cpp#aws-sdk-cpp for more information
on the AWS SDK for C++.

AWS request signing uses the system clock to include a timestamp in the
signature. For this reason, AWS methods may fail if the system clock time is
incorrect.';
		immediateInvariant.
true.
%

removeallmethods AwsDataKey
removeallclassmethods AwsDataKey

doit
(AbstractCloudKey
	_newKernelSubclass:'AzureDataKey'
	instVarNames: #(keyVaultUrl keyName encryptedDataKey)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 251137
)
		category: nil;
		comment: 'AzureDataKey is a class that holds a local encryption key. In order
to use the key, it must be decrypted by accessing a key in the key vault
stored in the Azure cloud.

Instance variables:

keyVaultUrl (String) the URL of the key vault that contains the key.
keyName (String) - the name of the key to use for encryption/decryption.
encryptedDataKey -(String)  the local data key in encrypted form, stored
                   as base 64 text.

AzureDataKeys may be in a locked or unlocked state. Locked means the
key has not yet been decrypted by the current session. Unlocked means the
data key has been decrypted and is stored in session memory. AzureDataKeys
may only be used to encrypt or decrypt data in the unlocked state.

If an AzureDataKey is committed to GemStone, it is always stored on disk 
in its locked state. Once an AzureDataKey is unlocked, it remains unlocked
until it is sent the #lock message or the session logs out.

Azure support is only available on Linux.';
		immediateInvariant.
true.
%

removeallmethods AzureDataKey
removeallclassmethods AzureDataKey

doit
(Object
	_newKernelSubclass:'CBuffer'
	instVarNames: #(offset)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 118017
)
		category: nil;
		comment: 'CBuffer represents a an instance of some C or C++ type allocated in C heap
 memory.

Constraints:
	offset: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods CBuffer
removeallclassmethods CBuffer

doit
(CBuffer
	subclass: 'TraversalBuffer'
	instVarNames: #(travResultOop resultIsSpecial clampOop retrievalFlags level)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'noInheritOptions'  #logCreation )
)
		category: nil;
		comment: 'TraversalBuffer represents an instance of the C type GciTravBufType, which is
 defined in $GEMSTONE/include/gcicmn.ht .  Various traversal functions defined
 in $GEMSTONE/include/gci.hf  take a pointer to a GciTravBufType as an argument.

Constraints:
	offset: SmallInteger
	travResultOop: Object
	resultIsSpecial: Object
	clampOop: Object
	retrievalFlags: Object
	level: Object';
		immediateInvariant.
true.
%

removeallmethods TraversalBuffer
removeallclassmethods TraversalBuffer

doit
(Object
	subclass: 'CDeclaration'
	instVarNames: #(name type pointer fields parameters source storage file line count isVaryingArgCount enumTag isConstant includesCode bitCount header linkageSpec)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FFI';
		comment: 'This class is internal to the FFI implementation and 
represents a declaration from a C header file.
  instVars
     count -- nil or an Array of elements(or sizes?) used to define a constant size array .
  order of instVars chosen so instVars most needed for debugging are at the front.

    bitCount non-zero for field of a struct like     unsigned int c : 7; ';
		immediateInvariant.
true.
%

removeallmethods CDeclaration
removeallclassmethods CDeclaration

doit
(Object
	subclass: 'CHeader'
	instVarNames: #(stream types structs unions functions enums enumTags storage declarations preprocessor source)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FFI';
		comment: 'This class is part of the FFI implementation and represents a C header file. 
It is typically used to generate a Smalltalk class that wraps a function or structure.
Usage examples can be found in the following instance methods:
	#wrapperForLibraryAt:
	#wrapperNamed:forLibraryAt:select:
	#wrapperForTypeNamed:
	#wrapperNamed:forStruct:
';
		immediateInvariant.
true.
%

removeallmethods CHeader
removeallclassmethods CHeader

doit
(Object
	_newKernelSubclass:'ClampSpecification'
	instVarNames: #(idClamps classClamps instVarLevels addSubleafHeaders instVarLevelsSelector traversalCallBackSelector valueClamps environmentId)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 135681
)
		category: nil;
		comment: 'A ClampSpecification represents a set of clamps to be applied to operations
 that traverse object structures.  ClampSpecification objects are required
 during clamped object traversal.

Constraints:
	idClamps: IdentitySet
	classClamps: ClassSet
	instVarLevels: FastIdentityKeyValueDictionary
	addSubleafHeaders: Boolean
	instVarLevelsSelector: Symbol 
	traversalCallBackSelector: Symbol
	valueClamps: IdentitySet
	environmentId: SmallInteger

--- instVar addSubleafHeaders
A Boolean that denotes whether or not subleaf headers should be collected
 in the traversal.  If true, then the object report header of objects that
 are one level below the cut off line will be put in the traversal buffer.

--- instVar classClamps
A ClassSet of class objects whose instances are to be clamped during object
 traversal.  Such instances will have header-only reports in the traversal
result. 

--- instVar environmentId
environmentId specifies the environment for message sends of the
traversalCallBackSelector and instVarLevelsSelector.  Default environment
is zero .  If non-nil this environmentId must be a SmallInteger.

--- instVar idClamps
An IdentitySet of objects to be clamped by identity (OOP).

--- instVar instVarLevels
A FastIdentityKeyValueDictionary whose keys are Classes. The value for a
 given key may be an Array of SmallInteger, false, or nil.  
 A value of nil is equivalent to the key not being present. (new
 semantics in Gs64 v3.2.2).
 A value of false is equivalent to the key being in the classClamps set (new
 semantics in Gs64 v3.2.2).
 The Array value for a given key has an element
 for every named instance variable of that class and has one additional element
 for any unnamed instance variables.  The value of each Array element is nil if
 the variable for that element does not have an instance variable level.  
 Otherwise, it is a SmallInteger or false.  If it is a SmallInteger, then its 
 absolute value is the number of instance variable levels.  If the SmallInteger
 is negative, it represents a min operation; if it is positive, it represents a
 max operation.  The SmallInteger zero represents a max operation; there is no
 representation for a min operation of zero.  If it is false then this is like
 max 0 with the exception that a subleaf header will not be included.

--- instVar instVarLevelsSelector
A Symbol or nil.  If non-nil, a zero argument selector that is sent to the object
 if the class of the object is not found in the instVarLevels dictionary.
 Result of that message send must conform to the values expected to be
 in the instVarLevels dictionary.  (New semantics as of Gs64 v3.2.1).

--- instVar traversalCallBackSelector
A Symbol or nil.  If non-nil, a zero argument selector that is used to place 
alternative value buffer contents
for objects whose format indicates that they should use the callback.
This selector is used in conjunction with environmentId.

--- instVar valueClamps
An IdentitySet that contains objects that have been value-clamped during
traversal calls.
';
		immediateInvariant.
true.
%

removeallmethods ClampSpecification
removeallclassmethods ClampSpecification

doit
(Object
	subclass: 'CPreprocessor'
	instVarNames: #(definitions header line path readStream searchPaths tokens tmpFnames cppArchMType systemSearchPaths)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FFI';
		comment: 'This class is internal to the FFI implementation and 
implements a preprocessor for a C header file.';
		immediateInvariant.
true.
%

removeallmethods CPreprocessor
removeallclassmethods CPreprocessor

doit
(Object
	subclass: 'CPreprocessorToken'
	instVarNames: #(file line source type value peek cppMType startCommentOffset startOffset endOffset debugBytes stream)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FFI';
		comment: 'This class is internal to the FFI implementation and 
represents a preprocessor token from a C header file.
The instVars startCommentOffset,startOffset,endOffset,stream
are for debugging the CPreprocessor .
Note also CPreprocessorToken >> _filePosition .';
		immediateInvariant.
true.
%

removeallmethods CPreprocessorToken
removeallclassmethods CPreprocessorToken

doit
(Object
	_newKernelSubclass:'CriticalSection'
	instVarNames: #(owner semaphore)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 117249
)
		category: nil;
		comment: 'CriticalSection is a class from the Blue Book API that
provides one way of using semaphores.

Constraints:
	owner: GsProcess
	semaphore: Semaphore';
		immediateInvariant.
true.
%

removeallmethods CriticalSection
removeallclassmethods CriticalSection

doit
(Object
	subclass: 'DeletedUserProfile'
	instVarNames: #(userId symbolList whenDeleted)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'DeletedUserProfile holds the key information about a UserProfile that was deleted from AllUsers.  
An instance is created and added to AllDeletedUsers when methods such as UserProfileSet>>removeAndCleanup:, 
removeAndCleanupUserWithId:ifAbsent:, etc., are executed.

A DeletedUserProfile refers to the SymbolList of the deleted user, since that is needed to reach data that 
was referred to by the deleted user.  After a UserProfile is removed, the DeletedUserProfile should be examined
for references to data that may need to be cleaned up so they can be garbage collected.';
		immediateInvariant.
true.
%

removeallmethods DeletedUserProfile
removeallclassmethods DeletedUserProfile

doit
(Object
	_newKernelSubclass:'GciInterface'
	instVarNames: #(sessionId lastResult resultIsSpecial lastError trace log errorClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
	reservedOop: 118273
)
		category: nil;
		comment: 'GciInterface is obsolete. 
New code should use GsExternalSession or GciTsExternalSession .

GciInterface is a Smalltalk representation for the functions defined
in $GEMSTONE/include/gci.hf .  Using GciInteface a session may
execute GCI functions in another session. 

The other session may be on the same repository or a 
different repository.  The other session is only valid
within the session which created the instance of GciInterface,
and while that instance remains in memory.

Beginning with Gs64 v3.0, instances of GciInterface automatically have
their other session closed when the instance is garbage collected or
when a persistent instance drops out of memory.

The lastResult instVar contains the result of the most recent 
message send or execution, and is set by a various primitives
and is cleared (i.e. set to _remoteNil) by logout and by errors.
The resultIsSpecial instVars is set by the same code which 
sets lastResult .

Operations other than message send or execute return the
receiver if successful, or nil if there was an error.

Constraints:
	sessionId: SmallInteger
	lastResult: Object
	resultIsSpecial: Boolean
	lastError: ErrorDescription
	trace: Boolean
	log: GsFile
	errorClass: Behavior
';
		immediateInvariant.
true.
%

removeallmethods GciInterface
removeallclassmethods GciInterface

doit
(Object
	_newKernelSubclass:'GemStoneX509Parameters'
	instVarNames: #(netldiPort netldiHost certificate caCertificate privateKey loginFlags extraGemArgs dirArg logArg)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
	reservedOop: 250113
)
		category: 'X509';
		comment: 'GemStoneX509Parameters is used by the class GsX509ExternalSession.
Instances are used as arguments to the login methods in class
GsX509ExternalSession. Instances of this class contain transient
state and may not be committed to the database.

Instance variables:

netldiPort    - SmallInteger or String - listening port of the netldi
netldiHost    - String - hostname or IP address of the netldi
certificate   - GsX509Certificate or GsX509CertificateChain - certificate or
                chain of certificates to be used for login.
caCertificate - GsX509Certificate or GsX509CertificateChain - trust anchor
                certificate(s) used to verify certificates presented by the
		netldi.
privateKey    - GsTlsPrivateKey - private key which matches certificate.
loginFlags    - SmallInteger - bit flags for login. See gci.ht for latest
                bit field definitions.
extraGemArgs  - String - extra arguments to be passed to gem executable.
dirArg        - String - working directory for the gem
logArg        - String - name of the log file for the gem.

';
		immediateInvariant.
true.
%

removeallmethods GemStoneX509Parameters
removeallclassmethods GemStoneX509Parameters

doit
(Object
	_newKernelSubclass:'GsDigitalEnvelope'
	instVarNames: #(publicEncryptionKey encryptedKey cipherText initVector cipherId tag messageClassName digitalSignature)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 250369
)
		category: nil;
		comment: 'A GsDigitalEnvelope is a class used to encrypt data with one or more public 
 encryption keys such that the data may only be decrypted with one of the 
 matching private keys. Only RSA encryption key pairs are supported. 

 GsDigitalEnvelopes are also protected by a cryptographic signature which
 is generated using the sender''s signing key. The signature allows the
 receiver to guarantee the envelope was created by someone with access to
 the sender''s private signing key. For signing algorithms that require
 a message digest algorithm, the SHA2-256 message digest is used.
 Signatures generated with RSA keys are padded using the
 RSA_PKCS1_PSS_PADDING scheme. The following signing key types are supported:

 -DSA
 -ECDSA
 -RSA
 -EC
 -Ed25519
 -Ed448

 Using different key pairs for signing and encrypting is strongly recommended.
 
 A GsDigitalEnvelope has the following security features:
 
  -Confidentiality - the message is encrypted using a randomly generated
                     AES encryption session key and initialization vector.
		     The session key is then encrypted with the provided
		     public encryption key.
		     
  -Integrity -       authenticated encryption guarantees the cipher text
                     has not been alter. The digital signature
                     guarantees the encrypted key, initialization vector
		     and tag have not been altered.
	       
  -Authentication -  the receiver of the envelope is assured the sender
                     signed the envelope with the private key matching
		     the public key used to successfully verify the
		     signature.
		    
 IMPORTANT - in order to guarantee authentication, the receiver must confirm
             the public verification key actually belongs to the sender.
	     Normally confirmation is done by verifying an X509 certificate
	     containing the sender''s public key has been signed by a
	     reputable certificate authority. GsDigitalEnvelope does NOT
	     do this public key/certificate signature verification. It is
	     up to the envelope recipient to ensure the public key or
	     X509 certificate used to verify the signature is trustworthy.

 The message to be encrypted and must be a byte collection. Byte 
 collections with a character size greater than one are accepted and will
 be converted to big endian format if necessary before encryption.

 If the message is intended for more than one recipient, multiple instances
 of GsDigitalEnvelope may be created by a single encryption operation by
 supplying multiple public encryption keys, one for each recipient. A maximum
 of 16 GsDigitalEnvelopes may be created by a single encryption operation.
  
 cipherId determines which AEAD (Authenticated Encryption with Additional
 Data) cipher to use from the following list:
 
 ================================
                        Key Size    
 opCode Cipher   Mode  bits/Bytes
 ================================
   4     AES     OCB     128/16  
   5     AES     OCB     192/24  
   6     AES     OCB     256/32  
   7     AES     GCM     128/16  
   8     AES     GCM     192/24  
   9     AES     GCM     256/32  
  10   CHACHA20 Poly1305 256/32  
 ================================

 AEAD guarantees the cipher text has not been altered. Modes 6 and 10 are
 thought to be the most secure and are recommended for most applications. 

 Constraints:
	publicEncryptionKey:	  GsTlsPublicKey or GsX509Certificate
	encryptedKey:   	  ByteArray
	cipherText:	  	  ByteArray
	initVector:	  	  ByteArray
	cipherId:	  	  SmallInteger
	tag:		  	  ByteArray
	messageClassName: 	  String
	digitalSignature:	  ByteArray or nil
';
		immediateInvariant.
true.
%

removeallmethods GsDigitalEnvelope
removeallclassmethods GsDigitalEnvelope

doit
(Object
	subclass: 'GsFileIn'
	instVarNames: #(session stream line lineNum path currentClassName currentClassObj currentTraitName currentTraitObj remoteGsFileInClassOop category compileEnvironment clearTopazSessionState fileFormat sourceStringClass removeAll clientFiles)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Kernel';
		comment: 'GsFileIn supports filing in from topaz-format GemStone source files into the image, without the use of topaz.
	
	To use, send one of the from* methods.  This also performs the file in.
	  for example,
	     GsFileIn fromServerPath: ''mySourceCode.gs''
	
	Only a subset of topaz commands is supported:
	   doit , printit , run , nbrun, send
	   input
	   category:
	   classmethod , classmethod:
	   method , method:
	   removeallmethods , removeallclassmethods
	   trclassmethod , trclassmethod:
	   trmethod , trmethod:
	   trremoveallmethods , trremoveallclassmethods
	   commit, abort
	   env N
	   fileformat
	   set compile_env N , set class , set category, set trait
 	   set enableremoveall, set package , set project 
     	   set sourcestring class
	     (other set commands are ignored)

Following can be read but are ignored:
	   expectvalue, expecterror, iferr, iferr_clear, iferr_list, errorcount
	   fileout, output
	   display, omit, level, limit, list
	   time, remark, status
	   login, logout

Other topaz commands will error.';
		immediateInvariant.
true.
%

removeallmethods GsFileIn
removeallclassmethods GsFileIn

doit
(Object
	_newKernelSubclass:'GsObjectInventory'
	instVarNames: #(entriesByCount entriesByBytes includeHiddenClasses)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 145409
)
		category: nil;
		comment: 'GsObjectInventory provides methods for counting instances of
classes in a repository.';
		immediateInvariant.
true.
%

removeallmethods GsObjectInventory
removeallclassmethods GsObjectInventory

doit
(Object
	_newKernelSubclass:'GsObjectInventoryEntry'
	instVarNames: #(theClass instanceCount byteCount)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 145665
)
		category: nil;
		comment: 'A GsObjectInventoryEntry represents statistics for one Class,
generated by a GsObjectInventory.';
		immediateInvariant.
true.
%

removeallmethods GsObjectInventoryEntry
removeallclassmethods GsObjectInventoryEntry

doit
(Object
	subclass: 'GsPackageLibrary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		immediateInvariant.
true.
%

removeallmethods GsPackageLibrary
removeallclassmethods GsPackageLibrary

doit
(Object
	subclass: 'GsReferencePath'
	instVarNames: #(target inSearchOops status numParents moreParents path)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'GsReferencePath holds the result returned from Repository>>#_refPathForObject:limits:.

Instance Variables
   target        <Object>  The object whose path being sought.
   inSearchOops  <Boolean> true if the target was in the searchOops for the last scan.
   status        <Symbol>  Returns #complete if the path starts with an object in the limit set.
                           Returns #cycle if an object occurs more than once in the path.
                           Returns #notConnected if the head of the path has no parents.
                           Returns #noInfo if the RefPathState is not available or a
                             complete path cannot be found.
   moreParents   <Boolean> true if it is known that there are more objects returned than the 
                           numParents value.  This should always be false for objects in the searchOops.
                           If it is true, the other parents can be found by performing another scan
                           with the target in the searchOops.
   numParents    <Integer> The number of parents found for the target.   If the target was NOT
                           in the searchOops for the scan then this value is 0 or 1 (only one
                           parent can be returned for an object not in the searchOops).
   path          <Array>   The objects in the path, starting with an object in the limits,
                           ending with the target object.  An empty array if no path was found.
                           The maximum path returned is 10000.
';
		immediateInvariant.
true.
%

removeallmethods GsReferencePath
removeallclassmethods GsReferencePath

doit
(Object
	subclass: 'GsReferencePathParentsInfo'
	instVarNames: #(target targetFoundInSearch additionalParentsAvailable parentOops parentClassOops parentClassCounts parentSizesInBytes)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'GsReferencePathParentsInfo holds the result returned from 
    GsReferencePathParentsInfo class>>#refPathParentsOf:.

Instance Variables
   target                  <Object>  The object whose parent references are being sought.
   targetFoundInSearch     <Boolean> Indicates whether the target is found in the search objects passed
                                     to GsSingleRefPathFinder>>
                                       #_refPathDoScanForParents:excludeParentRefs:onlySearchObjs:.
   additionalParentsAvailable  <Boolean> If the target object was in the search set for the last
                                     scanForParentsOf: operation, then this should always be false 
                                     and the parentOops returned contains all of the parents.
                                     If the target object was not in the search set, then it indicates
                                     whether there are more parentReferences than the one returned.
                                     Add the object to the search set for another scan to get all
                                     of the parents.
   parentOops              <GsBitmap>           The oops of each referencing (parent) object. If the target 
                                                is not found in the searchArray, only a single parent 
                                                reference can be returned.
   parentClassOops         <Array of: Integer>	An empty array if the target object was not in the 
                                                searchArray.  Otherwise, it contains the oops of the 
                                                parent objects classes.
   parentClassCounts       <Array of: Integer>  An empty array if the target object was not in the 
                                                searchArray.  Otherwise, each entry in the array is a 
                                                count of the number of parent instances of the class 
                                                with the corresponding index in the parentClassOops array.
   parentSizesInBytes	   <Array of: Integer>	An empty array if the target object was not in the 
                                                searchArray.  Otherwise, each entry is the sum of the parent 
                                                objects size in bytes for the parent instances of the class 
                                                with the corresponding index in the parentClassOops array.
';
		immediateInvariant.
true.
%

removeallmethods GsReferencePathParentsInfo
removeallclassmethods GsReferencePathParentsInfo

doit
(Object
	_newKernelSubclass:'GsSftpRemoteFile'
	instVarNames: #(sftpSocket remoteFileName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 250625
)
		category: nil;
		comment: 'GsSftpRemoteFile supports creating, reading and writing remote files via an instance of GsSftpSocket. 
You must have an established connection on the GsSftpSocket before creating the instance of 
GsSftpRemoteFile. Instances are created usng the GsSftpSocket as an argument.  

instance variables
  sftpSocket -- the instance of GsSftpSocket through which the file is accessed.
  removeFileName -- the name of the remote file

For example, to download a remote file to a local file using SFTP:

sshFtpSock := GsSftpSocket newClient.
sshFtpSock connectToHost: hostnameOrIP timeoutMs: 2000.
sshFtpSock userId: userName; password: userPassword.
sshFtpSock disableHostAuthentication.
sshFtpSock sshConnect.
remoteSftpFile := GsSftpRemoteFile 
    openRemoteFileReadOnly: remoteFileName 
    withSftpSocket: sftpSock.
localFile := GsFile openWriteOnServer: localFileName.
bytes := remoteSftpFile readAllInto: localFile.
localFile close.
sftpFile close.';
		immediateInvariant.
true.
%

removeallmethods GsSftpRemoteFile
removeallclassmethods GsSftpRemoteFile

doit
(Object
	subclass: 'GsSysLog'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'GsSysLog is a class used to write entries to the system log via syslogd.
 It has class-side behavior only.';
		immediateInvariant.
true.
%

removeallmethods GsSysLog
removeallclassmethods GsSysLog

doit
(Object
	_newKernelSubclass:'GsTlsCredential'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
	reservedOop: 249857
)
		category: 'X509';
		comment: 'GsTlsCredential is a class that encapsulates TLS private keys, public keys,
  and X509 certificates. Instances contain a hidden reference to C pointer
  to the OpenSSL representation of the TLS object.';
		immediateInvariant.
true.
%

removeallmethods GsTlsCredential
removeallclassmethods GsTlsCredential

doit
(GsTlsCredential
	subclass: 'GsTlsPrivateKey'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509';
		comment: 'GsTlsPrivateKey encapsulates a TLS/SSL private key.';
		immediateInvariant.
true.
%

removeallmethods GsTlsPrivateKey
removeallclassmethods GsTlsPrivateKey

doit
(GsTlsPrivateKey
	subclass: 'GsSshPrivateKey'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509';
		comment: 'GsSshPrivateKey encapsulates an OpenSSH private key.';
		immediateInvariant.
true.
%

removeallmethods GsSshPrivateKey
removeallclassmethods GsSshPrivateKey

doit
(GsTlsCredential
	subclass: 'GsTlsPublicKey'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509';
		comment: 'GsTlsPublicKey encapsulates a TLS/SSL public key.';
		immediateInvariant.
true.
%

removeallmethods GsTlsPublicKey
removeallclassmethods GsTlsPublicKey

doit
(GsTlsPublicKey
	subclass: 'GsSshPublicKey'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509';
		comment: 'GsSshPublicKey encapsulates an OpenSSH public key.';
		immediateInvariant.
true.
%

removeallmethods GsSshPublicKey
removeallclassmethods GsSshPublicKey

doit
(GsTlsCredential
	subclass: 'GsX509Certificate'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509';
		comment: 'GsX509Certificate encapsulates a TLS/SSL CA certificate per X.509.';
		immediateInvariant.
true.
%

removeallmethods GsX509Certificate
removeallclassmethods GsX509Certificate

doit
(Object
	byteSubclass: 'GsUuidV4'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant'  #logCreation )
)
		category: nil;
		comment: 'GsUuidV4 is an implementation of a version 4 UUID as specified in RFC 4122,
 A Universally Unique IDentifier (UUID) URN Namespace. UUIDs are generated
 randomly using the secure OpenSSL random number generator.

 Instances of GsUuidV4 are invariant and therefore cannot be modified.';
		immediateInvariant.
true.
%

removeallmethods GsUuidV4
removeallclassmethods GsUuidV4

doit
(Object
	indexableSubclass: 'HtHeap'
	instVarNames: #(tally)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'dbTransient'  #logCreation )
)
		category: 'HashTree-Core';
		comment: 'Hash tree heap is dbTransient, so contents are not committed.

It''s a min-heap sorted by hash value and also keeping an 
index for each hash value.
See e.g. https://en.wikipedia.org/wiki/Heap_(data_structure) 
for explanation of structure and algorithm.

tally is always even, and twice the number of elements in the heap.

HtHeap is used to heap-sort an HtLeafNode being split. This is necessary only in uncommon 
situations where the normal heuristic for splitting a leaf node results in a very uneven split.';
		immediateInvariant.
true.
%

removeallmethods HtHeap
removeallclassmethods HtHeap

doit
(Object
	subclass: 'HtTreeWalker'
	instVarNames: #(collection found value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'HashTree-Core';
		comment: 'Abstract. Part of the internal implemention of hash tree collections.
Helps the collection in walking through nodes to find, add, or remove elements.';
		immediateInvariant.
true.
%

removeallmethods HtTreeWalker
removeallclassmethods HtTreeWalker

doit
(HtTreeWalker
	subclass: 'HtDictionaryTreeWalker'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'dbTransient'  #logCreation )
)
		category: 'HashTree-Core';
		comment: 'A hash tree dictionary tree walker is dbTransient and specialized for use
as part of a TreeDictionary.';
		immediateInvariant.
true.
%

removeallmethods HtDictionaryTreeWalker
removeallclassmethods HtDictionaryTreeWalker

doit
(HtTreeWalker
	subclass: 'HtSetTreeWalker'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'dbTransient'  #logCreation )
)
		category: 'HashTree-Core';
		comment: 'A hash tree set tree walker is dbTransient and specialized for use
as part of a TreeSet.';
		immediateInvariant.
true.
%

removeallmethods HtSetTreeWalker
removeallclassmethods HtSetTreeWalker

doit
(Object
	subclass: 'JsonParser'
	instVarNames: #(stream linePosition lineNumber)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Kernel';
		comment: 'JsonParser is a recursive decent parser that parses JSON formatted strings.  
In versions 3.5-3.6.4, the JsonParser was a PetitParser class; this JsonParser is a 
smaller, faster implementation not related to PetitParser.

The older implementation is now named JsonPetitParser. If you have subclasses of 
JsonParser in earlier releases that depend on PetitParser behavior or variables, 
modify these to be subclasses of JsonPetitParser.

The following is a Json BNF from  https://www.json.org/

json
    element

value
    object
    array
    string
    number
    "true"
    "false"
    "null"

object
    ''{'' ws ''}''
    ''{'' members ''}''

members
    member
    member '','' members

member
    ws string ws '':'' element

array
    ''['' ws '']''
    ''['' elements '']''

elements
    element
    element '','' elements

element
    ws value ws

string
    ''"'' characters ''"''

characters
    ""
    character characters

character
    ''0020'' . ''10ffff'' - ''"'' - ''\''
    ''\'' escape

escape
    ''"''
    ''\''
    ''/''
    ''b''
    ''n''
    ''r''
    ''t''
    ''u'' hex hex hex hex

hex
    digit
    ''A'' . ''F''
    ''a'' . ''f''

number
    int frac exp

int
    digit
    onenine digits
    ''-'' digit
    ''-'' onenine digits

digits
    digit
    digit digits

digit
    ''0''
    onenine

onenine
    ''1'' . ''9''

frac
    ""
    ''.'' digits

exp
    ""
    ''E'' sign digits
    ''e'' sign digits

sign
    ""
    ''+''
    ''-''

ws
    ""
    ''0009'' ws
    ''000a'' ws
    ''000d'' ws
    ''0020'' ws';
		immediateInvariant.
true.
%

removeallmethods JsonParser
removeallclassmethods JsonParser

doit
(Object
	_newKernelSubclass:'KerberosPrincipal'
	instVarNames: #(name loginUserProfile loginUserProfileGroups loginAsAnyoneEnabled)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 157697
)
		category: nil;
		comment: 'This class is the logical representation of a Kerberos principal.
 It contains the following instance variables:
   name - A symbol representing the Kerberos name of the principal, including the realm.
          Example: #''alice@GEMTALKSYSTEMS.COM''
			    
   loginUserProfile - a UserProfile that corresponds to the Kerberos principal, 
             or nil if the principal does not map to a single UserProfile.  
             The named Kerberos user principal may login to this UserProfile without 
             specifying a password.
			    
   loginUserProfileGroups - anIdentitySet of UserProfileGroups.  The named Kerberos user 
             principal may login as any UserProfile in any of these groups without 
             specifying a password.

   loginAsAnyoneEnabled - a Boolean indicating if the named Kerberos principal has 
             permission to login as any UserProfile except for SystemUser.
';
		immediateInvariant.
true.
%

removeallmethods KerberosPrincipal
removeallclassmethods KerberosPrincipal

doit
(Object
	_newKernelSubclass:'LdapDirectoryServer'
	instVarNames: #(uri bindDN bindPW baseDN tlsCaCert tlsCaCertDir tlsCert tlsKey tlsReqCert)
	classVars: #(AllLdapDirectoryServers)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 156673
)
		category: nil;
		comment: 'This class is the logical representation of an LDAP Directory Server to
 GemStone.  It contains the following instance variables which must be Strings
 unless otherwise noted:
   uri               - A Uniform Resource Identifier for LDAP conforming to
                       RFC 4516.
 Optional Arguments (may be nil):		       
   bindDN            - A string which is the distinguished name (DN) used to
                       bind to the server to perform lookups, or nil if anonymous
		       binds are to be used (no bindDN required).
   bindPW            - a ByteArray, which is the encrypted password for bindDN,
                       or nil if anonymous binds are to be used.
   baseDN            - Specifies the default base DN to use when performing ldap
                       operations.  The baseDN must be specified as a Distinguished
		       Name in LDAP format.
   tlsCaCert         - Specifies the file that contains certificates for all of
                       the Certificate Authorities the client will recognize.
   tlsCaCertDir      - Specifies the path of a directory that contains Certificate
                       Authority certificates in separate individual files. tlsCaCert is
		       always used before tlsCaCertDir.
   tlsCert           - Specifies the file that contains the client certificate.
   tlsKey            - Specifies the file that contains the private key
                       that matches the certificate stored in the tlsCert
		       instance variable. The private key must not have a passphrase.
   tlsReqCert        - A symbol which specifies what checks to perform on server certificates
                       in a TLS session, if any. The following symbols are recognized:
                         #never -   The client will not request or check any server certificate.
                         #allow -   The  server certificate is requested. If no certificate is provided,
			            the session proceeds normally. If a bad certificate is provided,
				    it will be ignored and the session proceeds normally.
                         #try -     The server certificate is requested. If no certificate is provided,
			            the session proceeds normally. If a bad certificate is provided,
				    the session is immediately terminated.
                         #demand -  The server certificate is requested. If no certificate is provided,
			            or a bad certificate is provided, the session is immediately
                                    terminated. This is the default setting.
				    
setuid WARNING: OpenLDAP does not read most environment variables nor home directory files
(such as $HOME/ldaprc) if the process is running in setuid mode. A process runs in setuid mode
if the real UNIX user id and the effective UNIX user id are not the same. If running in setuid
mode, the tls* inst vars should be set so that LDAP can locate the correct TLS credentials.';
		immediateInvariant.
true.
%

removeallmethods LdapDirectoryServer
removeallclassmethods LdapDirectoryServer

doit
(Object
	_newKernelSubclass:'PassiveObject'
	instVarNames: #(contents str classes objects ivStrings nextClassNo nextObjectNo exitBlock nextIVNo ivName ivVal file epos ivNames version oldClassMap mapCache)
	classVars: #(ClassNames41dict)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 113153
)
		category: nil;
		comment: 'PassiveObject provides a means for transferring data from one GemStone
 repository to another that is similar to VisualWorks'' Binary Object Streaming
 Service (BOSS). The repositories are expected to be running on the same version
 of GemStone.

 An instance of PassiveObject converts the form of a given GemStone object from
 active to passive or from passive to active.  A GemStone object is called
 active because it can respond to messages.  The object''s passive form cannot
 respond to messages, but it can be written to a text file in a standard file
 system outside of GemStone.  A text file is the normal intermediary storage for
 objects that are being transferred between GemStone repositories.
 PassiveObjects themselves need never be transferred or committed, and are
 intended to exist only within a given GemStone session.

                              Note:
    This class provides useful protocols, but it does not represent a full 
    or complete inter-repository data transfer facility.  Not all GemStone
    objects can be converted into passive form.  Please see the GemStone
    Programming Guide for more background information.

			      Note:
    Objects referenced by the user defined tags (tagAt:1, tagAt:2) of
    an object are not included in the default passivation of an object.

 Data transfers are ordinarily accomplished by gathering all objects to be
 transferred into one collection, which is then passivated and reactivated.
 If data is transferred piecemeal, the new repository may lose information about
 the connectivity of objects and produce multiple copies of an object where the
 original repository had only one.

 Finally, class Object includes two methods, writeTo: and loadFrom:, that
 convert an object to and from its passive form.  These methods can be
 reimplemented to tailor the form for any given class.  The first thing any
 writeTo: method must do is to identify the class of the passivated object.  It
 does so by sending the writeClass: message to the passive object that stores
 it.  The loadFrom: method must send the hasRead: message to the passive object
 that loads it.  It then must create a new instance of the class it finds and
 must read all information that was written by the writeTo: method.

 The following discussion describes some limitations of PassiveObject in
 detail.

 Although certain atomic objects have the same OOP in any GemStone repository,
 most objects do not.  The special case that relates some atomic objects to
 their OOPs will be ignored hereafter.

 Now, the identity of a GemStone object depends upon its OOP.  However, when you
 transfer an object from one GemStone repository to another, it is not possible
 to guarantee that it will have the same OOP; its OOP in the original repository
 may already be used by another object in the new repository.  In general, an
 object''s OOP is lost during transfer.

 But the interconnectivity of objects in GemStone depends upon their OOPs.
 Objects identify their relationships to each other by their OOP.  To preserve
 interconnectivity, when aPassiveObject passivates a GemStone object, it also
 passivates all the other objects to which it refers, and the ones to which they
 refer, and so on (the transitive closure of the object).  It also encodes the
 relationships among the objects in the transitive closure so that those
 relationships can be restored when the object is activated in the new
 repository.

 However, each PassiveObject can passivate (the transitive closure of) only one
 object at a time.  If two objects are passivated, and some objects in the
 transitive closure of one refer to objects in the transitive closure of the
 other, PassiveObject has no way to capture or encode those relationships.  Upon
 activation, the lost interrelations between the two objects may not be
 evident at first because duplicate objects are created in the new repository
 and the same values are present.  Only subsequent updates in the duplicated
 objects will reveal their new independence of each other.  Such independence
 may well be unintended, a semantic anomaly in the data.

 To avoid difficulties, gather all data to be transferred into one collection.
 Passivate the collection from the original repository, then activate it in the
 new repository.  Connect the data to the new repository as appropriate, then
 remove the collection used for passivation and commit.  If you must passivate
 two or more objects, passivate only one object in any file; two objects in a
 file virtually guarantee data transfer errors.

 The following Characters are reserved for special use within passive objects.
 The special meanings do not apply within the byte contents of Strings, 
 ByteArrays or DoubleByteStrings within a passive object:

    $*   denotes true
    $~   denotes false
    $$   next byte is an instance of Character with value 0..255
    $!   next two bytes are instance of Character with value 0..65535,
            most significant byte is first.
    $.   denotes  nil
    $#   denotes _remoteNil
    $/   end of named instance variables within a Bag 
    $"   prefix/suffix Character used to identify instance variable names
    $?   class prefix
    $:   object identifier prefix
    $@   global reference prefix
    $%   denotes metaclass reference
    $    terminates a global name or string representation of an integer
    $(   terminates a class name
    $^   begins/ends the GemStone version header
    $&   next 4 bytes are a 32bit Character value, most significant byte first.
    $)   reserved for future use by GemTalk Systems
    $=   reserved for future use by GemTalk Systems
    $_   reserved for customer use

Expected classes of instance variables:
	contents: Object
	str: Object
	classes: Object
	objects: Object
	ivStrings: Object
	nextClassNo: SmallInteger
	nextObjectNo: SmallInteger
	exitBlock: Object
	nextIVNo: SmallInteger
	ivName: CharacterCollection
	ivVal: Object
	file: Object
	epos: Object
	ivNames: Object
	version: SmallInteger
	oldClassMap: SymbolDictionary
	mapCache: SmallInteger  (serial number of a passive object map)
';
		immediateInvariant.
true.
%

removeallmethods PassiveObject
removeallclassmethods PassiveObject

doit
(Object
	subclass: 'Pragma'
	instVarNames: #(method keyword arguments)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'A Pragma represents an occurrence of a pragma in a compiled method.  
A pragma is a literal message pattern that occurs between angle brackets at the 
start of a method after any temporaries.  An example:
	<foo: 123 >

In GemStone, the <primitive: nnn> directive looks like a pragma, but is not a pragma,
primitive: inside the first pragma is a reserved word.

Pragmas show up in the Symbol literals for a method; however they are not
message sends.   ClassOrganizer>>literalsReport:  and
ClassOrganizer>>referencesToLiteral: can be used to search for pragmas.
One can query a method for its pragmas by sendng it the pragmas message, 
which answers an Array of instances of me, one for each pragma in the method.

A Pragma can provide information about the defining class, method, its selector, 
as well as the information about the pragma keyword and its arguments. 
See the two ''accessing'' protocols for details. 
''accessing-method'' provides information about the method the pragma is found in, 
while ''accessing-pragma'' is about the pragma itself.

Instances are retrieved using one of the pragma search methods of 
the ''finding'' protocol on the class side.';
		immediateInvariant.
true.
%

removeallmethods Pragma
removeallclassmethods Pragma

doit
(Object
	_newKernelSubclass:'Processor'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 116225
)
		category: nil;
		comment: '
 Processor provides the Smalltalk Blue Book API for the processor scheduler.
 See also class ProcessorScheduler .';
		immediateInvariant.
true.
%

removeallmethods Processor
removeallclassmethods Processor

doit
(Object
	_newKernelSubclass:'ProfMonitor'
	instVarNames: #(file interval results sampleDepth startTime endTime traceObjCreation numSamples)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 93441
)
		category: nil;
		comment: 'ProfMonitor is a tool for taking snapshots of the execution stack
 at designated moments.  When done monitoring, the results are collected
 and formed into a report showing classes, method selectors, and hit rates.
 Execution stack snapshots can be gathered at either regular time intervals
 or programmatically by using System profMonSample.  Snapshots can also
 be taken during object creation by setting traceObjectCreation to true.
 If traceObjectCreation is true, the number of samples may be dominated
 by object creation samples rather interval based samples.
 
 The interval is the number of nanoseconds between sample points, which 
 must be either zero (for programmatic tracking) or >= 1000 nanoseconds. 
 Methods are provided to specify interval in milliseconds 
 (interval: variants) or in nanoseconds (intervalNs: variants) .

 See the classmethod  computeInterval:  for determining the argument 
 to pass to the intervalNs: keyword.

 Intervals less than 10 milliseconds use high resolution sampling
 and are implemented by reading a high resolution clock at each
 point where interrupts would be checked, (entries to non-trivial 
 non-primitive method, backward branches, and each CALL_PRIMITIVE bytecode).
 For the CALL_PRIMITIVE bytecodes , each CALL_PRIMITIVE in a loaded
 method is transformed to a PROFILING_CALL_PRIMITIVE (or to equivalent
 native code) at start of profiling and the transformation reversed 
 at end of profiling.  Methods loaded during profiling will have the
 transformation done at method load time.
 When using high resolution sampling, code executes at about 10%
 of normal execution speed.

 Intervals >= 10 milliseconds use the legacy timer interrupt implementation
 which has much less effect on execution performance.

 When the interval is zero, samples are not gathered based on clock time,
 but whenever System profMonSample is called.  Developers can use this
 to generate profiling information on specific methods of interest by
 adding calls to System profMonSample to these methods.
 
 The sampleDepth is the number of levels from the top of the stack to
 sample. This controls the depth of the stack for both method calls and
 object creation; it should be at least 20.
 
 The results are recorded in an instance of GsFile for the gem session,
 in binary machine dependent form.  The file is created with a name of 
 gem<processId>.log in one of the following locations:
   1.  The directory referenced by the environment variable $GEMSTONE_CHILD_LOG.
   2.  The current directory.
   3.  /tmp

 For 100000 samples, GEM_TEMPOBJ_CACHE_SIZE should be set to at least 300MB 
 to avoid AlmostOutOfMemory errors during the analysis phase.

 Instances of ProfMonitor can be committed to save the result of runBlock:
 for later analysis. An instance of ProfMonitor embeds a GsFile reference
 to the file of profiling data which can be reopened later for analysis.

 An instances of ProfMonitor which has been sent gatherResults 
 can occupy many MB or GB of memory and committing lots of them could
 cause significant repository growth.  Send removeResults to an instance
 before committing and then reexecute gatherResults to avoid that growth.


Instance Variables
------------------

file
  An instance of GsFile used to record sampling information while profiling
  is active.  The file contains binary data in machine dependent form.

interval
  The interval between sample points, in nanoseconds of CPU time.
  Must be either zero for programmatic sample gathering or >= 1000.

traceObjCreation 
  A SmallInteger with the following bits that control the profiling
    16r1  1=trace object creation enabled
    16r2  1=elapsed time sampling , 0= cpu time sampling(the default)
    16r4  for elapsed time sampling, tally object faults
    16r8  for elapsed time sampling, tally page faults
    16r10  for elapsed time sampling, tally eden bytes used
    16r20  for elapsed time sampling, tally temp obj memory gc time
    16r40  for elapsed time sampling, tally user defined stat 1 (not implemented)
    16r80  for elapsed time sampling, tally user defined stat 2 (not implemented)

numSamples 
  The total number of samples taken

results
  Holds collected, processed snapshot information in instances of a
  class that is private to ProfMonitor.

sampleDepth 
  The number of levels from top of stack to sample.

startTime 
  Starting Real or CPU time in milliseconds.

endTime
  Ending Real or CPU time in milliseconds.
';
		immediateInvariant.
true.
%

removeallmethods ProfMonitor
removeallclassmethods ProfMonitor

doit
(ProfMonitor
	subclass: 'ProfMonitorTree'
	instVarNames: #(rawArray rootPME objRootPMEDict)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'ProfMonitorTree is an enhancement of ProfMonitor, adding a tree based
display of the profiling results.';
		immediateInvariant.
true.
%

removeallmethods ProfMonitorTree
removeallclassmethods ProfMonitorTree

doit
(Object
	subclass: 'ProfMonitorEntry'
	instVarNames: #(cmethod cclass tally parents children total rcvrClass recursed root childTallies parentTallies)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
 A ProfMonitorEntry represents a stack frame from one or more samples
 taken by a ProfMonitor instance.';
		immediateInvariant.
true.
%

removeallmethods ProfMonitorEntry
removeallclassmethods ProfMonitorEntry

doit
(Object
	_newKernelSubclass:'SharedQueue'
	instVarNames: #(valueAvailable contents)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 116993
)
		category: nil;
		comment: 'A SharedQueue is a thread-safe queue.  An instance may have 
one or more GsProcesses as producers and one or more GsProcesses
as consumers.

Constraints:
	valueAvailable: Semaphore
	contents: Array';
		immediateInvariant.
true.
%

removeallmethods SharedQueue
removeallclassmethods SharedQueue

doit
(PPCompositeParser
	subclass: 'JsonPetitParser'
	instVarNames: #(array character element elements escape exp frac int json member members number object sign string value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Kernel';
		comment: 'JsonPetitParser is the class named JsonParser in earlier versions, using PetitParser. 
This has been replaced by a smaller, faster recursive decent parser implementation 
that now uses the name JsonParser. 
Subclasses of JsonParser from previous releases may need to be modified to be subclasses 
of JsonPetitParser.

JsonPetitParser is deprecated.


https://www.json.org/

json
    element

value
    object
    array
    string
    number
    "true"
    "false"
    "null"

object
    ''{'' ws ''}''
    ''{'' members ''}''

members
    member
    member '','' members

member
    ws string ws '':'' element

array
    ''['' ws '']''
    ''['' elements '']''

elements
    element
    element '','' elements

element
    ws value ws

string
    ''"'' characters ''"''

characters
    ""
    character characters

character
    ''0020'' . ''10ffff'' - ''"'' - ''\''
    ''\'' escape

escape
    ''"''
    ''\''
    ''/''
    ''b''
    ''n''
    ''r''
    ''t''
    ''u'' hex hex hex hex

hex
    digit
    ''A'' . ''F''
    ''a'' . ''f''

number
    int frac exp

int
    digit
    onenine digits
    ''-'' digit
    ''-'' onenine digits

digits
    digit
    digit digits

digit
    ''0''
    onenine

onenine
    ''1'' . ''9''

frac
    ""
    ''.'' digits

exp
    ""
    ''E'' sign digits
    ''e'' sign digits

sign
    ""
    ''+''
    ''-''

ws
    ""
    ''0009'' ws
    ''000a'' ws
    ''000d'' ws
    ''0020'' ws';
		immediateInvariant.
true.
%

removeallmethods JsonPetitParser
removeallclassmethods JsonPetitParser

doit
(RcKeyValueDictionary
	subclass: 'RcKeyValueNoRebuildDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'RcKeyValueNoRebuildDictionary is a subclass of RcKeyValueDictionary.
  Instances do not automatically execute rebuildTable: when adding key/value pairs.
  This allows more concurrency in Rc replay of additions.';
		immediateInvariant.
true.
%

removeallmethods RcKeyValueNoRebuildDictionary
removeallclassmethods RcKeyValueNoRebuildDictionary

doit
(ReadStreamPortable
	subclass: 'CPreprocessorStream'
	instVarNames: #(file line cppArchMType debug)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FFI';
		comment: 'This class is internal to the FFI implementation and 
implements a stream that can track file names and line numbers from 
debug info emitted by /usr/bin/cpp, and parsed by a CPreprocessor.
Instance variables
  file  a String,  path to a file.
  line  a SmallInteger , a line number .
  cppArchMType  nil or a SmallInteger .
  debug  used to enable debugging info in CPreprocessorToken .';
		immediateInvariant.
true.
%

removeallmethods CPreprocessorStream
removeallclassmethods CPreprocessorStream

doit
(ReadStreamPortable
	subclass: 'PPStream'
	instVarNames: #(newlines)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Core';
		comment: 'A positional stream implementation used for parsing. It overrides some methods for optimization reasons.';
		immediateInvariant.
true.
%

removeallmethods PPStream
removeallclassmethods PPStream

doit
(String
	subclass: 'AppendableString'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AppendableString is intended for streams that are are created empty,  
appended to , and then the contents are retrieved for writing to a socket.
There is no stream-specific support for reading, write limit, nor 
position logic.
Takes advantage of the fact that Strings in GemStone are variable size. 

Instance creation is inherited from   String class >> new .

The contents of a AppendableString are 
Characters with codePoints in range 0 to 255, or UTF8 encoded data .
Attempts to append codePoints above 255 with nextPut methods 
will signal an error.';
		immediateInvariant.
true.
%

removeallmethods AppendableString
removeallclassmethods AppendableString

doit
(String
	_newKernelSubclass:'ISOLatin'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 96769
)
		category: nil;
		comment: 'ISOLatin is a subclass of String which provides means for GemStone Smalltalk
 applications to extend the behavior of String with native-language-specific
 sorting or other behavior.

 ISOLatin inherits all of its behavior from String, and thus inherits the
 the English ASCII defaults for character set interpretation, as provided
 by the C runtime library and by Unix.

 It is the user''s responsibility to create a subclass of ISOLatin and
 implement appropriate comparison methods in the subclass if an application
 requires language-specific sorting or comparison semantics.';
		immediateInvariant.
true.
%

removeallmethods ISOLatin
removeallclassmethods ISOLatin

doit
(TestCase
	subclass: 'GsTestCase'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'GsTestCase is the GemStone-specific refinement of the SUnit TestCase class.';
		immediateInvariant.
true.
%

removeallmethods GsTestCase
removeallclassmethods GsTestCase

doit
(TestResult
	subclass: 'GsTestResult'
	instVarNames: #(defects)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: 'Kernel';
		comment: 'GsTestResult is the GemStone-specific refinement of the SUnit TestResult class.';
		immediateInvariant.
true.
%

removeallmethods GsTestResult
removeallclassmethods GsTestResult

doit
(TestSuite
	subclass: 'GsTestSuite'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'GsTestSuite is the GemStone-specific refinement of the SUnit TestSuite class.';
		immediateInvariant.
true.
%

removeallmethods GsTestSuite
removeallclassmethods GsTestSuite

doit
(UnorderedCollection
	subclass: 'TreeSet'
	instVarNames: #(rootNode tally walker heap scratchLeaf)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'HashTree-Core';
		comment: 'TreeSet is a set that has good performance in GemStone at a wide variety of sizes, and grows gracefully without long pauses.

It is structured as a a tree which is sorted based on a permutation of the #hash of the elements. Nodes of the tree are sized to match the GemStone page size. Leaf nodes are page-sized hash tables, and internal nodes are a B+tree variant that allows duplicate keys.


Instance variables:

tally				How many key-value pairs I contain
rootNode		Either a HtSetLeafNode (if my size is small) or a HtSetInternalNode (if my contents will not fit in one leaf node)
walker			A cached instance of HtSetTreeWalker that helps with operations on the tree
scratchLeaf	A cached instance of HtSetScratchLeafNode that is used for temporary storage during the splitting of a leaf node when it becomes full
heap				A cached instance of HtHeap, used to heap-sort a leaf node being split. This is necessary only in uncommon 
						situations where the normal heuristic for splitting a leaf node results in a very uneven split.

The cached instances are all dbTransient, so modifications to them will not need to be written to tranlogs or extents upon commit.
They are cached, rather than created at each operation, to avoid creating unnecessary garbage during normal operations on the dictionary.';
		immediateInvariant.
true.
%

removeallmethods TreeSet
removeallclassmethods TreeSet

doit
(Warning
	subclass: 'CompileWarning'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'CompileWarning is a Warning (Notification) signaled when a warning
is found during the compiling of a method or expression. Developer
tools might handle this Exception and report the warning to the user.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object';
		immediateInvariant.
true.
%

! Class implementation for 'CanonStringBucket'

!		Instance methods for 'CanonStringBucket'

category: 'Enumerating'
method: CanonStringBucket
accompaniedBy: anObj keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 2nd and 3rd arguments.
 aBlock must be a 3 argument block, with arguments anObj, key value ."

1 to: numElements do:[:idx | | aSym |
   aSym := self _at: idx  .
   aBlock value: anObj value: aSym value: aSym
].
%

category: 'Adding'
method: CanonStringBucket
add: anAssociation

"Disallowed, CanonStringBucket does not contain associations"

self shouldNotImplement: #add:
%

category: 'Updating'
method: CanonStringBucket
addKey: aKey

"All additions should be done via methods in the parent dictionary."

^ self shouldNotImplement: #addKey:
%

category: 'Updating'
method: CanonStringBucket
at: aKey put: aValue keyValDict_coll: aKeyValDict

"key-value pairs are not supported"

^ self shouldNotImplement: #at:put:keyValDict_coll:
%

category: 'Updating'
method: CanonStringBucket
at: anIndex putKey: aKey

"Disallowed, must use addKey:  or removeKey:"

self shouldNotImplement: #at:putKey: .
%

category: 'Updating'
method: CanonStringBucket
at: anIndex putValue: aValue

"Disallowed, must use addKey:  or removeKey:"

self shouldNotImplement: #at:putValue: .
%

category: 'Accessing'
method: CanonStringBucket
keyAt: index

"Returns the key at the specified index."

^ self _at: index
%

category: 'Enumerating'
method: CanonStringBucket
keysAndValuesDo: aBlock

"For each key/value pair in the receiver, evaluates the two-argument block
 aBlock with the arguments key, value.  Returns the receiver."

1 to: numElements do:[:idx | | aSym |
   aSym := self _at: idx  .
   aBlock value: aSym value: aSym
].
%

category: 'Enumerating'
method: CanonStringBucket
keysDo: aBlock

"For each key/value pair in the receiver, evaluates the one-argument block
 aBlock with the key as the argument.  Returns the receiver."

1 to: numElements do:[:idx | aBlock value: ( self _at: idx )  ] .
%

category: 'Accessing'
method: CanonStringBucket
keyValueDictionary

"Returns the value of the instance variable."

^keyValueDictionary
%

category: 'Updating'
method: CanonStringBucket
keyValueDictionary: aDict

"Updates the value of the keyValueDictionary instance variable."

keyValueDictionary := aDict
%

category: 'Private'
method: CanonStringBucket
objectSecurityPolicy: anObjectSecurityPolicy
"Assigns the receiver and all its components to the given security policy.
 Returns the receiver."

self validateSystemUser .
^ super objectSecurityPolicy: anObjectSecurityPolicy
%

category: 'Private'
method: CanonStringBucket
removeKey: aKey ifAbsent: aBlock

"Removes the specified key and returns aKey . If aKey is not found,
 returns the result of evaluating the zero-argument block aBlock."

 | keyIndex |
 keyIndex := self searchForKey: aKey.
 keyIndex == nil
 ifFalse: [
    numElements := numElements - 1.
    self _deleteNoShrinkFrom: keyIndex to: keyIndex .
    ^ aKey
    ]
 ifTrue: [ ^ self _reportKeyNotFound: aKey with: aBlock ]
%

category: 'Searching'
method: CanonStringBucket
searchForKey: aKey

"Returns the index of aKey, or if not found, nil."

<primitive: 471>
aKey _validateClass: String  .
self _primitiveFailed: #searchForKey: args: { aKey }.
self _uncontinuableError
%

category: 'Accessing'
method: CanonStringBucket
tableSize

"Returns the number of keys in the capacity of the receiver."

^self _basicSize
%

category: 'Accessing'
method: CanonStringBucket
valueAt: index

"not supported, instances hold only keys"

self shouldNotImplement: #valueAt:
%

category: 'Enumerating'
method: CanonStringBucket
valuesDo: aBlock

"For each key/value pair in the receiver, evaluates the one-argument block
 aBlock with the value as the argument.  Returns the receiver."

 self keysDo: aBlock
%

category: 'Private'
method: CanonStringBucket
_audit
| bsz extra nSize |
extra := (bsz := self basicSize) - (nSize := self class instSize) - numElements .
extra < 0 ifTrue:[ Error signal:'bad size'].
0 to: extra - 1 do:[:n |
  (self basicAt:(bsz - n - nSize)) ifNotNil:[ Error signal:'bad element'].
].
%

category: 'Audit'
method: CanonStringBucket
_audit: parentDict offset: parentOffset
  "Returns a SmallInteger, the number of errors found"
  | firstH sz prevSym sym errCount |
  errCount := 0 .
  GsFile gciLogServer: 'bucket ', parentOffset asString, ' oop ', self asOop asString ,
       ' numElements ', numElements asString, ' _basicSize ', (sz := self _basicSize) asString .
  keyValueDictionary == parentDict ifFalse:[
    GsFile gciLogServer:'ERROR bucket ', self asOop asString,
           ' instVar keyValueDictionary inconsistent value oop ', keyValueDictionary asOop asString .
    errCount := errCount + 1.
  ].
  1 to: numElements do:[:n | | h cmp |
    sym := self _at: n .
    sym ifNil:[ GsFile gciLogServer:'ERROR bucket ', self asOop asString,' nil _at: ', n asString
    ] ifNotNil:[
      firstH ifNil:[
        firstH := parentDict hashFunction: sym .
        GsFile gciLogServer:'bucket ', self asOop asString, ' hash is ', firstH asString .
        firstH == parentOffset ifFalse:[
          GsFile gciLogServer:'ERROR bucket ', self asOop asString, ' inconsistent first hash '.
          errCount := errCount + 1.
        ].
      ] ifNotNil:[
        h := parentDict hashFunction: sym  .
        h == firstH ifFalse:[
          GsFile gciLogServer:'ERROR bucket ', self asOop asString, ' _at: ', n asString ,' sym oop ',
            sym asOop asString, ' ', sym printString,' hash ', h asString .
          errCount := errCount + 1.
        ].
        cmp := prevSym codePointCompareTo: sym .
        cmp == -1 ifFalse:[
          GsFile gciLogServer:'ERROR bucket ', self asOop asString, ' _at: ', n asString ,' sym oop ',
            sym asOop asString, ' ', sym printString,' not > than previousSym oop ',
            prevSym asOop asString,' ', prevSym printString .
          errCount := errCount + 1.
        ].
      ].
      prevSym := sym .
    ].
  ].
  numElements + 1 to: sz do:[:j |
    sym := self _at: j .
    sym ifNotNil:[
      GsFile gciLogServer:'ERROR bucket ', self asOop asString, ' _at: ', j asString, ' non-nil oop ',
        sym asOop asString,'  ', sym printString .
      errCount := errCount + 1.
    ]
  ].
  ^ errCount
%

category: 'Private'
method: CanonStringBucket
_removeAll

"Dereferences the receiver from its parent and shrinks the receiver.
 Used while rebuilding a dictionary."

keyValueDictionary := nil.
numElements := 0.
"gs64 v3.0 don't send  size: 0"
%

! Class implementation for 'CanonStringDict'

!		Class methods for 'CanonStringDict'

category: 'Instance Creation'
classmethod: CanonStringDict
new

"Creates an instance of CanonStringDict with a default table size."

^ self new: 20
%

category: 'Instance Creation'
classmethod: CanonStringDict
new: tableSize

"Creates an instance of CanonStringDict with the specified table size."

| aPrime |
aPrime := self _tableSizeFor: tableSize.
^ self _new: aPrime
%

category: 'Instance Creation'
classmethod: CanonStringDict
_new: aPrime

"Private"

| newDict |
newDict := super _basicNew: aPrime .
newDict _initializeWithoutClear: aPrime .
^ newDict .
%

!		Instance methods for 'CanonStringDict'

category: 'Comparing'
method: CanonStringDict
= anCanonStringDict

"Returns true if all of the following conditions are true:

 1.  The receiver and anCanonStringDict are of the same class.
 2.  The two dictionaries are of the same size.
 3.  The corresponding keys and values of the receiver and anCanonStringDict
     are equal."

(self == anCanonStringDict)
  ifTrue: [ ^ true ].

(self class == anCanonStringDict class)
  ifFalse: [ ^ false ].

(self size == anCanonStringDict size)
  ifFalse: [ ^ false ].

self keysDo: [ :aKey |
  (aKey = (anCanonStringDict at: aKey otherwise: nil))
    ifFalse: [ ^ false ]
  ].

^ true.
%

category: 'Enumerating'
method: CanonStringDict
accompaniedBy: anObj keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 2nd and 3rd arguments.
 aBlock must be a 3 argument block, with arguments anObj, key value ."

1 to: tableSize do:[ :tableIndex | | collisionBkt |
  collisionBkt := self _at: tableIndex .
  collisionBkt ~~ nil ifTrue:[
      collisionBkt accompaniedBy: anObj keysAndValuesDo: aBlock
  ].
].
%

category: 'Adding'
method: CanonStringDict
add: aString

"Adds aString if it is not already present in the receiver, and returns
 either aString or the canonical string already present."

<primitive: 478>
aString _validateClass: String .
self _primitiveFailed: #add: args: { aString }.
self _uncontinuableError
%

category: 'Adding'
method: CanonStringDict
addAll: aCollection

"Adds elements of aCollection to the receiver. If aCollection is
 a Dictionary, adds only the keys to the receiver .
 Returns aCollection."

aCollection == self ifTrue:[ ^ aCollection ].
(aCollection isKindOf: AbstractDictionary)
  ifTrue:[ ^ aCollection keysDo:[:aKey | self add: aKey ] ].
aCollection accompaniedBy: self do:[ :me :aString | me add: aString ].
^ aCollection
%

category: 'Adding'
method: CanonStringDict
addKey: aString

"Adds aString if it is not already present in the receiver, and returns
 either aString or the canonical string already present."

^ self add: aString
%

category: 'Printing'
method: CanonStringDict
asReportString

"Returns a String that lists the keys, one on each line."

| result |
result := String new.
self keysDo: [ :key |
  result add: key printString;
    add: Character lf
  ].
^ result
%

category: 'Enumerating'
method: CanonStringDict
associationsDetect: aBlock ifNone: exceptionBlock

"CanonStringDict's do not hold assocations"

^ self shouldNotImplement: #associationsDetect:ifNone:
%

category: 'Enumerating'
method: CanonStringDict
associationsDo: aBlock
  ^ self shouldNotImplement: #associationsDo: 
%

category: 'Accessing'
method: CanonStringDict
at: aKey ifAbsent: aBlock

"Returns the value that corresponds to aKey.  If no such key
 exists, returns the result of evaluating the zero-argument block aBlock."

<primitive: 481>
aBlock _isExecBlock ifFalse:[ aBlock _validateClass: ExecBlock] .
^ aBlock value
%

category: 'Accessing'
method: CanonStringDict
at: aKey ifAbsentPut: aBlock

"not implemented, key-value pairs not supported "

^ self shouldNotImplement: #at:ifAbsentPut:
%

category: 'Accessing'
method: CanonStringDict
at: aString otherwise: value

"Returns the key that corresponds to aString.  If no such key
 exists, returns the given alternate value."

<primitive: 481>
aString _validateClass: String .
^ value
%

category: 'Updating'
method: CanonStringDict
at: aKey put: aValue

"CanonStringDict's do not hold key-value pairs, use add: or addKey: "

^ self shouldNotImplement: #at:put:
%

category: 'Enumerating'
method: CanonStringDict
collectAssociations: aBlock

"CanonStringDict's do not hold key-value pairs."

^ self shouldNotImplement: #collectAssociations:
%

category: 'Enumerating'
method: CanonStringDict
do: aBlock
"Iteratively evaluates the one argument block, aBlock, using each key of
 the receiver as the argument to the block. Returns the receiver."

^ self keysDo: aBlock
%

category: 'Hashing'
method: CanonStringDict
hashFunction: aString

^ ((self _basicHash: aString) \\ self tableSize) + 1

%

category: 'Searching'
method: CanonStringDict
includes: aString

"Returns true if the receiver contains aString as a key, false otherwise."

| aValue |
aValue := self at: aString otherwise: nil .
^ aValue ~~ nil
%

category: 'Searching'
method: CanonStringDict
includesAssociation: anAssociation

"CanonStringDict's do not hold assocations"

^ self shouldNotImplement: #includesAssociation:
%

category: 'Searching'
method: CanonStringDict
includesIdentical: aString

"Returns true if the receiver contains an a String identical to the
 argument, false otherwise."

| elem |
elem := self at: aString otherwise: nil .
elem == nil ifFalse:[ ^ aString == elem ].
^ false .
%

category: 'Searching'
method: CanonStringDict
includesIdenticalAssociation: anAssociation

"CanonStringDict's do not hold assocations"

^ self shouldNotImplement: #includesIdenticalAssociation:
%

category: 'Searching'
method: CanonStringDict
includesKey: aKey

"Returns true if the receiver contains an Association or a key-value pair whose
 key is equal to aKey.  Returns false otherwise."

^ self includes: aKey
%

category: 'Initializing'
method: CanonStringDict
initialize: itsSize

"Initializes the instance variables of the receiver to be an empty
 dictionary of the specified size."

| newSize |

newSize := itsSize .

(newSize <= 0)
  ifTrue: [
    newSize _error: #rtErrArgNotPositive.
    newSize := 3
    ].

self _basicSize: 0.  "Set size to 0 and restore to nil any entries"
self _basicSize: newSize .
self _initializeWithoutClear: newSize.
^self
%

category: 'Accessing'
method: CanonStringDict
keyAtValue: anObject ifAbsent: aBlock

"not implemented, CanonStringDict's do not hold key-value pairs."

^ self shouldNotImplement: #keyAtValue:ifAbsent:
%

category: 'Accessing'
method: CanonStringDict
keys

"Returns a Set containing the receiver's keys."

| aSet |

aSet := IdentitySet new.
self keysDo: [ :key | aSet add: key ].
^ aSet
%

category: 'Enumerating'
method: CanonStringDict
keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 arguments.  The argument aBlock must be a two-argument block.  The
 first argument is the key and the second argument is the value of
 each key/value pair."

1 to: tableSize do:[ :tableIndex | | collisionBkt |
  collisionBkt := self _at: tableIndex .
  collisionBkt ~~ nil ifTrue:[ collisionBkt keysAndValuesDo: aBlock ].
  ]
%

category: 'Enumerating'
method: CanonStringDict
keysDo: aBlock

"Iteratively evaluates the one argument block, aBlock, using each key of
 the receiver as the argument to the block. Returns the receiver."

| aBucket |
1 to: tableSize do:[:k |
  aBucket := self _at: k .
  aBucket ~~ nil ifTrue:[ aBucket keysDo: aBlock ].
  ].
%

category: 'Searching'
method: CanonStringDict
occurrencesOf: aValue

"key value pairs are not supported"

^ self shouldNotImplement: #occurrencesOf:
%

category: 'Searching'
method: CanonStringDict
occurrencesOfIdentical: aValue

"key value pairs are not supported"

^ self shouldNotImplement: #occurrencesOfIdentical:
%

category: 'Formatting'
method: CanonStringDict
printOn: aStream

"Puts a displayable representation of the receiver on the given stream."

| count sz myCls |

myCls := self class .
aStream nextPutAll: myCls name describeClassName .
aStream nextPutAll: '( ' .
count := 1 .
sz := self size .
self keysDo:[:aKey |
  aStream position > 700 ifTrue:[
    "prevent infinite recursion when printing cyclic structures, and
     limit the size of result when printing large collections."
    aStream nextPutAll: '...)' .
    ^ self
    ] .
  aKey printOn: aStream .
  count < sz ifTrue:[ aStream nextPutAll: ', ' ].
  count := count + 1 .
  ].
aStream nextPut: $) .
%

category: 'Hashing'
method: CanonStringDict
rehash
	"Re-establish any hash invariants of the receiver.
	 Rebuilds the hash table by saving the current state, initializing and
	 changing the size of the table, and adding the key values saved
	 back to the hash dictionary."

	| saveTable |
	saveTable := Array new.
	self keysDo: [:aKey | saveTable add: aKey].
	self initialize: self size.
	self addAll: saveTable.
%

category: 'Removing'
method: CanonStringDict
remove: aString

"Removes aString if present in the receiver and returns the removed value.  If
 aString is not present, generates an error."

^ self removeKey: aString
%

category: 'Removing'
method: CanonStringDict
remove: aString ifAbsent: aBlock

"Removes aString if present in the receiver and returns the removed value.  If
 aString is not present, returns the result of evaluating the zero
 argument Block aBlock."

^ self removeKey: aString ifAbsent: aBlock
%

category: 'Removing'
method: CanonStringDict
removeKey: aKey ifAbsent: aBlock

| elem hash aBucket |
elem := self at: aKey otherwise: nil .
elem ifNotNil:[
  hash := self hashFunction: aKey .
  aBucket := self _at:  hash .
  aBucket removeKey: aKey ifAbsent: [ self _error:'inconsistent bucket'].
  numElements := numElements - 1 .
  ^ elem
] .
^ aBlock value
%

category: 'Accessing'
method: CanonStringDict
size

"Returns the number of elements contained in the receiver."

^ numElements
%

category: 'Class Membership'
method: CanonStringDict
species

"Returns a class, an instance of which should be used as the result of
 select: or other projections applied to the receiver."

^ StringKeyValueDictionary
%

category: 'Private'
method: CanonStringDict
tableSize

"Returns the size of hash table used for storing the entries."

^ tableSize
%

category: 'Enumerating'
method: CanonStringDict
valuesDo: aBlock
  ^ self shouldNotImplement: #valuesDo: 
%

category: 'Private'
method: CanonStringDict
_audit
| cnt |
cnt := 0 .
1 to: tableSize do:[:n |  | bkt |
  bkt := self basicAt: n .
  bkt _audit .
  cnt := cnt + bkt numElements .
].
cnt == numElements ifFalse:[ Error signal: 'bad size']
%

category: 'Hashing'
method: CanonStringDict
_basicHash: aString

"Private. The hash value is a case-sensitive hash value of the bytes of a
 string without regard to whether the string contains single or
 double byte characters.  The strings are canonicalized so that
 a DoubleByteString with all-ascii characters is converted to
 a String before computing the hash."
<primitive: 519>
aString _validateClass: String .
self _primitiveFailed: #_basicHash: args: { aString }.
self _uncontinuableError
%

category: 'Private'
method: CanonStringDict
_collisionBucketsDo: aBlock
"Private.  Executes the given one-argument block for each collision bucket
 in the receiver."

| aBucket |
1 to: tableSize do:[:k |
  aBucket := self _at: k .
  aBucket ifNotNil:[ aBlock value: aBucket ].
  ].
%

category: 'Private'
method: CanonStringDict
_initializeWithoutClear: newSize

"Private. Initializes the instance variables of the receiver to be an empty
 KeyValueDictionary of the specified size. Does not clear the contents
 of the receiver - assumes they are all nil."

tableSize := newSize.
numElements := 0.

^self
%

category: 'Private'
method: CanonStringDict
_nodesObjectSecurityPolicy: anObjectSecurityPolicy
  "Assigns receiver's components to the given security policy."

self _collisionBucketsDo:[ :aBucket |
   aBucket objectSecurityPolicy: anObjectSecurityPolicy
].
%

category: 'Private'
method: CanonStringDict
_resetParentRef

"Private. After a become:, the parent refs of the collisionBuckets must
 be reset to point to the correct parent."

self _collisionBucketsDo: [:collisionBkt |
  collisionBkt keyValueDictionary: self].
%

! Class implementation for 'CanonSymbolDict'

!		Instance methods for 'CanonSymbolDict'

category: 'Adding'
method: CanonSymbolDict
add: aString

"Disallowed, only the Virtual machine's creation of a Symbol
 should add elements to AllSymbols."

^ self shouldNotImplement: #add:

%

category: 'Adding'
method: CanonSymbolDict
addAll: aCollection

"Disallowed, only the Virtual machine's creation of a Symbol
 should add elements to AllSymbols."

^ self shouldNotImplement: #addAll:
%

category: 'Adding'
method: CanonSymbolDict
addKey: aSymbol

"Only used during repository conversion."

self validateSystemUser .
"We expect that AllSymbols is not yet an instance of this class."
(Globals at:#AllSymbols) class == CanonSymbolDict ifTrue:[
  ^ self error:'Illegal use for other than repository conversion' .
].
aSymbol class == Symbol ifFalse:[
  aSymbol class == DoubleByteSymbol ifFalse:[
    ^ self error:'bad argument class ' , aSymbol class name
  ].
].
^ super add: aSymbol .
%

category: 'Updating'
method: CanonSymbolDict
become: aCanonSymbolDict

^ self shouldNotImplement: #become:
%

category: 'Initializing'
method: CanonSymbolDict
initialize: itsSize

"Initializes the instance variables of the receiver to be an empty
 dictionary of the specified size."

self validateSystemUser .
super initialize: itsSize
%

category: 'Private'
method: CanonSymbolDict
objectSecurityPolicy: anObjectSecurityPolicy

"Assigns the receiver and all its components to the given security policy.
 Returns the receiver."

self validateSystemUser .
^ super objectSecurityPolicy: anObjectSecurityPolicy
%

category: 'Copying'
method: CanonSymbolDict
postCopy
  1 to: self _basicSize do:[:n | | bkt newBkt |
    bkt := self _basicAt: n .
    (newBkt := bkt copy) keyValueDictionary: self .
    self _basicAt: n put: newBkt
  ].
%

category: 'Removing'
method: CanonSymbolDict
remove: aString

^ self shouldNotImplement: #remove:
%

category: 'Removing'
method: CanonSymbolDict
remove: aString ifAbsent: aBlock

^ self shouldNotImplement: #remove:ifAbsent:
%

category: 'Removing'
method: CanonSymbolDict
removeKey: aKey ifAbsent: aBlock

"Removing Symbols from AllSymbols is not supported.
 If you want to remove Symbols from AllSymbols anyway:
   1. You must logged in as SystemUser, and edit this method to remove
      the line with
         shouldNotImplement
      and uncomment the line with
         removeKey:
      And commit these changes.
   2. Stop the Symbol Creation Session, and all other user sessions
        System stopSymbolCreationSession.
        System stopUserSessions.
   3. The Symbols to be removed from AllSymbols must be referenced ONLY
      from AllSymbols, as confirmed by SystemRepository listReferences:.
      OTHERWISE message sends may fail to lookup the proper method
      and you may get other INCORRECT EXECUTION.
   4. execute removals from AllSymbols using this method, and commit.
   5. Start Symbol Creation session using
        System startSymbolCreationSession.

 Use this process at your own risk.
"

self validateSystemUser .
self shouldNotImplement: #removeKey:ifAbsent: .
"^ super removeKey: aKey ifAbsent: aBlock"
%

category: 'Private'
method: CanonSymbolDict
validateSystemUser

"validate that the current session is SystemUser."

System myUserProfile userId = 'SystemUser' ifFalse:[
  self error:'instance only modifiable by SystemUser'.
  self _uncontinuableError .
  ^ nil
  ].
^ self
%

category: 'Audit'
method: CanonSymbolDict
_audit
  "Returns a SmallInteger, the number of errors found."
  | errCount |
  GsFile gciLogServer: '---- CanonSymbolDict oop ', self asOop asString, ' size ', self size asString,
     ' tableSize ', self tableSize asString .
  errCount := 0 .
  1 to: self _basicSize do:[:n | | bkt |
    bkt := self _at: n .
    bkt ifNotNil:[
      errCount := errCount + ( bkt _audit: self offset: n) .
    ].
  ].   
  GsFile gciLogServer: '---- CanonSymbolDict oop ', self asOop asString,' error count ', errCount asString .
  ^ errCount .
%

category: 'Private'
method: CanonSymbolDict
_initializeWithoutClear: newSize

"Private. Initializes the instance variables of the receiver to be an empty
 KeyValueDictionary of the specified size. Does not clear the contents
 of the receiver - assumes they are all nil."

self validateSystemUser .
super _initializeWithoutClear: newSize .
^self
%

category: 'Private'
method: CanonSymbolDict
_resetParentRef

"Private. After a become:, the parent refs of the collisionBuckets must
 be reset to point to the correct parent."

self validateSystemUser .
^ super _resetParentRef
%

! Class implementation for 'TreeDictionary'

!		Class methods for 'TreeDictionary'

category: 'instance creation'
classmethod: TreeDictionary
new
	^ self basicNew initialize
%

category: 'instance creation'
classmethod: TreeDictionary
new: someSize
	self error: 'TreeDictionaries are not pre-sizeable. Send #new instead.'
%

!		Instance methods for 'TreeDictionary'

category: 'enumerating'
method: TreeDictionary
accompaniedBy: anObj keysAndValuesDo: aBlock
	"Iteratively evaluates the threee argument block, aBlock,
	using anObj, each key and each value
	of the receiver as the arguments to the block.  Returns the receiver."

	self keysAndValuesDo: [ :k :v | aBlock value: anObj value: k value: v ]
%

category: 'enumerating'
method: TreeDictionary
associationsDo: aBlock
	"Evaluates aBlock with each of the receiver's key/value pairs as the
	argument by creating an Association for each key/value pair.  The
	argument aBlock must be a one-argument block.

	Note that creating a large number of Associations will hurt performance;
	it's better to send keysAndValuesDo: instead of associationsDo: 
	when possible. "

	self
		keysAndValuesDo: [ :aKey :aValue | aBlock value: (Association newWithKey: aKey value: aValue) ].
	^ self
%

category: 'accessing'
method: TreeDictionary
at: key
	"Don't use at:ifAbsent: to avoid creating an unnecessary complex block."

	| theWalker found |
	key ifNil: [ ^ self _errorKeyNotFound: key ].
	theWalker := walker.	"Ensure walker stays in memory until this method returns."
	theWalker collection: self.	"Might have dropped from memory since last use."
	found := theWalker
		searchTree: rootNode
		forValueAt: key
		withHash: (self permutedHashOf: key).
	^ found
		ifTrue: [ 
			| value |
			value := theWalker value.
			theWalker reset.
			value ]
		ifFalse: [ 
			theWalker reset.
			self _errorKeyNotFound: key ]
%

category: 'accessing'
method: TreeDictionary
at: key ifAbsent: absentBlock
	| theWalker found |
	key ifNil: [ ^ self _reportKeyNotFound: key with: absentBlock ].
	theWalker := walker.	"Ensure walker stays in memory until this method returns."
	theWalker collection: self.	"Might have dropped from memory since last use."
	found := theWalker
		searchTree: rootNode
		forValueAt: key
		withHash: (self permutedHashOf: key).
	^ found ifTrue:[ 
			| value |
			value := theWalker value.
			theWalker reset  .
      value 
    ] ifFalse: [ 
			theWalker reset.
			absentBlock value 
    ]
%

category: 'accessing'
method: TreeDictionary
at: key put: value
	| hash newNode theWalker |
	key ifNil: [ ^ self _error: #'rtErrNilKey' ].
	tally := tally. 	"Put myself in the write set, for the case where the key is already present."
	hash := self permutedHashOf: key.
	theWalker := walker.	"Ensure walker stays in memory until this method returns."
	theWalker collection: self.	"Might have dropped from memory since last use."
	newNode := theWalker
		searchTree: rootNode
		at: key
		withHash: hash
		put: value.
	newNode ifNotNil: [ self splitRootWith: newNode ].
  ^ value 
%

category: 'auditing'
method: TreeDictionary
audit
	"Check myself for consistency; answer 
		true if audit passed, a string report on problems."

	| stream elementCount passingPosition |
	stream := WriteStream on: String new.
	stream nextPutAll: 'Audit report for ' , self class name , ' '.
	self asOop printOn: stream.
	stream lf.
	passingPosition := stream position.
	heap auditEmptyOnto: stream.
	scratchLeaf auditEmptyOnto: stream for: self.
	walker auditOnto: stream for: self.
	elementCount := rootNode
		auditOnto: stream
		for: self
		lowestHash: 0
		highestHash: SmallInteger maximumValue.
	elementCount = tally
		ifFalse: [ 
			stream
				nextPutAll:
						'Root tally mis-match: tally is ' , tally printString
								, ' but counting nodes gives ' , elementCount printString;
				lf ].
	^ stream position = passingPosition
		ifTrue: [ true ]
		ifFalse: [ stream contents ]
%

category: 'node access'
method: TreeDictionary
decrementTally
	"Should only be sent from TdLeafNode"

	tally := tally - 1.
	tally negative ifTrue: [
		self error: 'decrementTally when already empty' ]
%

category: 'enumerating'
method: TreeDictionary
do: unaryBlock
	"Evaluate the given one-argument block once for each key/value
	pair I contain, in no particular order, with the value of the pair
	as the argument to the block. 
	Answers the receiver."

	self keysAndValuesDo: [ :k :v | unaryBlock value: v ]
%

category: 'private'
method: TreeDictionary
errorNotFound: anObject
	"Sends an error message indicating that the expected object was not found."

	^ self _error: #'objErrNotInColl' args: {anObject}
%

category: 'node access'
method: TreeDictionary
heap

	^ heap
%

category: 'private'
method: TreeDictionary
heapSize
	^ 800
%

category: 'private'
method: TreeDictionary
highestHash
	"2 ** 60 - 1"

	^ 16rFFFFFFFFFFFFFFF
%

category: 'node access'
method: TreeDictionary
incrementTally
	"Should only be sent from TdLeafNode"

	tally := tally + 1
%

category: 'initialization'
method: TreeDictionary
initialize
	"In a sufficiently small collection, the root node is a leaf."

	super initialize.
	self initializeDbTransients.
	tally := 0.
	rootNode := self leafNodeClass
		forCollection: self
		lowestHash: 0
		highestHash: SmallInteger maximumValue
%

category: 'private'
method: TreeDictionary
initializeDbTransients
	walker := self walkerClass forCollection: self.	"Cache a walker to avoid creating garbage walkers."
	heap := HtHeap new: self heapSize.	"Size must be greater than fillLine of a leaf."
	scratchLeaf := self scratchLeafNodeClass
		forCollection: self
		lowestHash: 0
		highestHash: SmallInteger maximumValue	"In leaf splitting, used as a temporary
	leaf, to avoid creating garbage."
%

category: 'private'
method: TreeDictionary
internalNodeClass

	^ HtDictionaryInternalNode
%

category: 'accessing'
method: TreeDictionary
keyAtValue: anObject ifAbsent: aBlock
	self
		keysAndValuesDo: [ :k :v | 
			v = anObject
				ifTrue: [ ^ k ] ].
	^ aBlock value
%

category: 'enumerating'
method: TreeDictionary
keysAndValuesDo: binaryBlock
	"Evaluate the given two-argument block once for each key/value
	pair I contain, in no particular order, with the key of the pair as
	the first argument, and the value as the second argument.
	Answers the receiver."

	rootNode keysAndValuesDo: binaryBlock
%

category: 'enumerating'
method: TreeDictionary
keysDo: unaryBlock
	"Evaluate the given one-argument block once for each key/value
	pair I contain, in no particular order, with the key of the pair
	as the argument to the block. 
	Answers the receiver."

	self keysAndValuesDo: [ :k :v | unaryBlock value: k ]
%

category: 'private'
method: TreeDictionary
leafNodeClass

	^ HtDictionaryLeafNode
%

category: 'accessing'
method: TreeDictionary
permutedHashOf: anObject
	"This method is central to getting good performance from TreeDictionary.
	Internal algorithms such as searching internal nodes and splitting leaf nodes
	require making 'good guesses' about where in a node to find a hash value. 
	In order for these guesses to be close to the real value most of the time, the 
	hash values must be roughly evenly distributed through the entire non-negative 
	SmallInteger range,	[0..2^60).
	But the answers to #hash are generally not distributed this way. For instance,
	String hashes are only 24 bits, the hashes of numbers are limited to about 
	30 bits and may be negative.

	This method takes the integer answered by sending #hash to the object and
	runs that integer through a permutation of the [0..2^60) space of numbers.
	The permutation takes any integer in that range and produces a different
	number in that range. It's a full permutation with no loss of uniqueness;
	each of the 2^60 possible inputs produces a unique output. 2^60 possible
	inputs, 2^60 possible outputs, just scrambled in a way that makes it *much*
	more likely that the resulting set of permuted hashes used internally by 
	TreeDictionary is roughly evenly distributed across the entire 2^60 range.

	Permutation is 
	
	f(x) = dx^2 + ax + c (mod 2^60)
	
	Where
	a=10699279521569479
	c=7836386368351
	d=7952157022
	
	equivalent to the Smalltalk
	
	(x * d + a * x + c) bitAnd: 16rFFFFFFFFFFFFFFF
	
	Equivalent to

	^ rawHash * 7952157022 + 10699279521569479 * rawHash + 7836386368351
		  bitAnd: 16rFFFFFFFFFFFFFFF"

	| rawHash |
	rawHash := anObject hash abs.
	^ rawHash permutedHashA: 10699279521569479 c: 7836386368351 d: 7952157022
%

category: 'copying'
method: TreeDictionary
postCopy
	self initializeDbTransients.
	rootNode := rootNode copyForCollection: self
%

category: 'removing'
method: TreeDictionary
removeKey: key
	| hash newRoot theWalker |
	key ifNil: [ ^ self errorNotFound: key ].
	hash := self permutedHashOf: key.
	theWalker := walker.	"Ensure walker stays in memory until this method returns."
	theWalker collection: self.	"Might have dropped from memory since last use."
	newRoot := theWalker searchTree: rootNode removeKey: key withHash: hash.
	newRoot ifNotNil: [ rootNode := newRoot ].
	^ theWalker found
		ifTrue: [ 
			| value |
			value := walker value.
			walker reset.
			value ]
		ifFalse: [ 
			theWalker reset.
			self errorNotFound: key ]
%

category: 'removing'
method: TreeDictionary
removeKey: key ifAbsent: absentBlock
	| hash newRoot theWalker |
	key ifNil: [ ^ self errorNotFound: key ].
	hash := self permutedHashOf: key.
	theWalker := walker.	"Ensure walker stays in memory until this method returns."
	theWalker collection: self.	"Might have dropped from memory since last use."
	newRoot := theWalker searchTree: rootNode removeKey: key withHash: hash.
	newRoot ifNotNil: [ rootNode := newRoot ].
	^ theWalker found
		ifTrue: [ 
			| value |
			value := walker value.
			walker reset.
			value ]
		ifFalse: [ 
			walker reset.
			absentBlock value ]
%

category: 'test access'
method: TreeDictionary
rootNode
	^ rootNode
%

category: 'node access'
method: TreeDictionary
scratchLeaf

	^ scratchLeaf
%

category: 'private'
method: TreeDictionary
scratchLeafNodeClass
	^ HtDictionaryScratchLeafNode
%

category: 'accessing'
method: TreeDictionary
size

	^ tally
%

category: 'private'
method: TreeDictionary
splitRootWith: newNode
	"The tree is getting one level deeper."

	| newRoot highestHash |
	highestHash := self highestHash.
	newRoot := self internalNodeClass forCollection: self.
	newRoot
		appendSortedChild: rootNode;
		appendSortedChild: newNode;
		appendHash: highestHash;
		highestHash: highestHash.
	newRoot computeConstants.
	rootNode := newRoot
%

category: 'enumerating'
method: TreeDictionary
valuesDo: aBlock
	"For each key/value pair in the receiver, evaluates the one-argument block
	aBlock with the value as the argument."

	self keysAndValuesDo: [ :aKey :aValue | aBlock value: aValue ]
%

category: 'private'
method: TreeDictionary
walkerClass
	^ HtDictionaryTreeWalker
%

category: 'private'
method: TreeDictionary
_deferredGciUpdateWith: valueArray
	" semantics of the GCI update not defined"

	self _error: #'errNoStructuralUpdate'
%

category: 'private'
method: TreeDictionary
_nodesObjectSecurityPolicy: anObjectSecurityPolicy
	"Assigns receiver's components to the given security policy. "

	heap objectSecurityPolicy: anObjectSecurityPolicy.
	rootNode objectSecurityPolicy: anObjectSecurityPolicy.
	scratchLeaf objectSecurityPolicy: anObjectSecurityPolicy.
	walker objectSecurityPolicy: anObjectSecurityPolicy
%

! Class implementation for 'GsExternalSession'

!		Class methods for 'GsExternalSession'

category: 'GciLibrary'
classmethod: GsExternalSession
gciErrSTypeClass

	^GciErrSType.
%

category: 'GciLibrary'
classmethod: GsExternalSession
gciLibrary

	^SessionTemps current at: #GsExternalSession_gciLibrary
		ifAbsentPut: [
			GciLibrary new
				GciInit;
				yourself.
		].
%

category: 'Instance Creation'
classmethod: GsExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: aUsername password: aPassword
  | res |
	(res := self new)
		gemNRS: gemNRS;
		stoneNRS: stoneNRS;
		username: aUsername;
		password: aPassword.
  res class gciLibrary .
  ^ res .
%

category: 'Instance Creation'
classmethod: GsExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: gsUsername password: gsPassword hostUsername: hostUsername hostPassword: hostPassword
  | res |
	(res := self new)
		gemNRS: gemNRS;
		stoneNRS: stoneNRS;
		username: gsUsername;
		password: gsPassword;
		hostUsername: hostUsername;
		hostPassword: hostPassword .
  res class gciLibrary .
  ^ res
%

category: 'Instance Creation'
classmethod: GsExternalSession
new
  | res |
  (res := self sessionClass basicNew)
      initialize .
  res class gciLibrary .
  ^ res
%

category: 'Instance Creation'
classmethod: GsExternalSession
newDefault
  "This creates an external session that is set to the user, host, and 
  stone of the current gem with the password 'swordfish'. You may update 
  any of these parameters before login for more complex environments."

	 | res |
	 (res := self new)
		  initializeDefaultResources .
   res class gciLibrary .
   ^ res
%

category: 'Private'
classmethod: GsExternalSession
sessionClass
	^(System gemVersionAt: 'osName') = 'AIX'
		ifTrue: [GsLegacyExternalSession]
		ifFalse: [ self "change to GsLegacyExternalSession to not use FFI"]
%

!		Instance methods for 'GsExternalSession'

category: 'Public'
method: GsExternalSession
abort
  "Abort the current transaction in the external Gem."

  | lib |
  lib := self _gciLibrary .
	self _errorIfCallInProgress: lib .
	lib GciNbAbort.
	self waitForResult .
	nbResult ~~ 0 ifTrue: [self error: 'Unexpected result!'].
%

category: 'Public'
method: GsExternalSession
begin 
  "Abort current transaction and begin a transaction"
	self _errorIfCallInProgress.
	self _gciLibrary GciNbBegin .
	self waitForResult.
	nbResult ~~ 0 ifTrue: [self error: 'Unexpected result!'].
%

category: 'Error handling'
method: GsExternalSession
clearStackFor: anError

	| contextOop lib |
	(contextOop := anError context) == 20"nil asOop" ifTrue: [^self].
  lib := self _gciLibrary .
	self _errorIfCallInProgress: lib .
	lib GciClearStack_: contextOop.
	self _signalIfError: lib .
%

category: 'Public'
method: GsExternalSession
commit
  "Commit the current transaction in the external Gem."

  | result lib |
  lib := self _gciLibrary .
  self _errorIfCallInProgress: lib .
  result := lib GciCommit.
  result == 1 ifFalse:[
      self _signalIfError: lib .
  ].
  ^ result == 1.
%

category: 'Public'
method: GsExternalSession
commitOrError
   "Commit the current transaction in the external Gem and return true 
   if success or signal an error."

  | result |
  self _errorIfCallInProgress.
  result := self _gciLibrary GciCommit.
  self _signalIfError.
  result == 1 ifFalse:[ 
    TransactionError new reason: 'commitConflicts' ; signal:'commit conflicts'
    ].
 ^ result == 1
%

category: 'Error handling'
method: GsExternalSession
continue: contextOop replacingTopOfStackWithOop: valueOop
	"Continue execution in the external Gem following an exception,
	 replacing the top of the stack with the specified object.
	 It is an error to specify an oop not visible to the remote Gem."
  | lib |
	lib := self _gciLibrary .
	self _errorIfCallInProgress: lib .
	lib GciNbContinueWith_: contextOop
		_: valueOop
		_: 16r10"GCI_PERFORM_noClientUseraction"  
		_: nil.
	^self
		waitForResult;
		_lastResult: lib .
%

category: 'Public'
method: GsExternalSession
executeString: aString
	"Execute the string expression in the external Gem and answer the result.
	 The best values to return are specials.
	 Strings and other byte objects are copied to the local Gem.
	 All other responses are returned as a Array containing a single OOP."

  | lib |
  aString _isOneByteString ifFalse:[ ArgumentError signal:'arg is not a String' ].
  lib := self _gciLibrary .
	self _errorIfCallInProgress: lib .
	lib GciNbExecuteStr_: aString _: 20"nil asOop". 
  self waitForResult .
  ^ self _lastResult: lib
%

category: 'Public'
method: GsExternalSession
forceLogout

	stoneSessionId ifNil: [^self].
	[self hardBreak] onException: Error do: [:ex | ].
	self _logout.
%

category: 'Public'
method: GsExternalSession
forkString: aString
	"Execute the string expression in the external Gem and do not wait for
	 a result.  At some later point, you would check for a result. Otherwise you cannot
	 issue another call, as the current call would remain in progress.
	 Refer to #executeString: for an example of the complete send, wait, response sequence."
  | lib |
  aString _isOneByteString ifFalse:[ ArgumentError signal:'arg is not a String' ].
  lib := self _gciLibrary .
	self _errorIfCallInProgress: lib .
	lib GciNbExecuteStr_: aString _: 20"nil asOop".  
%

category: 'Private'
method: GsExternalSession
gciErrorClass
  ^ GciError 
%

category: 'Parameters'
method: GsExternalSession
gemNRS
   ^ parameters ifNotNil:[:p | p gemService ].
%

category: 'Parameters'
method: GsExternalSession
gemNRS: anNRS
	"Set the GemService parameters for the logon to the value
	 of anNRS, which may be a String or a GsNetworkResourceString instance."

	parameters gemService: anNRS asString .
  (anNRS isKindOf: GsNetworkResourceString) ifTrue:[
    self dynamicInstVarAt: #gemHost put: anNRS node .
  ].
%

category: 'Accessors'
method: GsExternalSession
gemProcessId

  ^gemProcessId.
%

category: 'Public'
method: GsExternalSession
hardBreak
	"Interrupt the external Gem and abort the current transaction."
  | lib |
  lib := self _gciLibrary .
	self _setSessionId: lib .
	lib GciHardBreak.
	self _signalIfError: lib .
%

category: 'Parameters'
method: GsExternalSession
hostPassword: aString

	parameters hostPassword: aString copy.
%

category: 'Parameters'
method: GsExternalSession
hostUsername: aString

	parameters hostUsername: aString copy.
%

category: 'Private'
method: GsExternalSession
initialize

	gciErrSType := self class gciErrSTypeClass new.
	parameters := GemStoneParameters new.
	self loggingToServer.
%

category: 'Private'
method: GsExternalSession
initializeDefaultResources
  parameters ifNil:[ parameters := GemStoneParameters new].
	self
		gemNRS: GsNetworkResourceString defaultGemNRSFromCurrent;
		stoneNRS: GsNetworkResourceString defaultStoneNRSFromCurrent;
		username: System myUserProfile userId;
		password: 'swordfish' .
%

category: 'Public'
method: GsExternalSession
isCallInProgress
	"Answer whether there is currently a call in progress to
	 the external Gem.

	 The following calls are OK during a nonblocking call:
		GciCallInProgress
		GciErr
		GciGetSessionId
		GciHardBreak
		GciNbEnd
		GciSetSessionId
		GciShutdown
		GciSoftBreak"

	self isLoggedIn ifFalse:[ ^ false "not logged in"].
  ^ self _isCallInProgress: self _gciLibrary .
%

category: 'Accessors'
method: GsExternalSession
isLoggedIn
 ^ gciSessionId ~~ nil and:[ gciSessionId > 0].
%

category: 'Public'
method: GsExternalSession
isRemoteServerBigEndian

	^self _gciLibrary GciServerIsBigEndian ~~ 0
%

category: 'Public'
method: GsExternalSession
isResultAvailable

	"Check whether the current call in progress has finished
	 and save the result if it has. Most operations cannot be
	 started while another is in progress. You must call this
	 method and receive a true result before starting another
	 remote operation."

  ^ self _isResultAvailable: (CByteArray gcMalloc: 8)
%

category: 'Public'
method: GsExternalSession
lastResult
  ^ nbResult ifNotNil:[:r |
     "r is an Integer, the value of a remote OopType"
     self resolveResult: r
  ]
%

category: 'Logging'
method: GsExternalSession
log: aString

	logger value: aString
%

category: 'Logging'
method: GsExternalSession
logger: aOneArgBlock
	"Use the specified one-argument Block for logging messages.
	 The argument to the Block is the message to log."

	logger := aOneArgBlock
%

category: 'Logging'
method: GsExternalSession
loggingToClient

	self logger: [:message | GsFile gciLogClient: message]
%

category: 'Logging'
method: GsExternalSession
loggingToServer

	self logger: [:message | GsFile gciLogServer: message]
%

category: 'Public'
method: GsExternalSession
login
	| result lib sid |
	stoneSessionId ifNotNil: [
		ImproperOperation signal: 'Stone session ' , stoneSessionId printString ,
			' already associated with this GsExternalSession!'.
	].
  lib := self _gciLibrary .
	result := lib
    GciSetNetEx_: parameters gemStoneName
		_: parameters hostUsername
		_: parameters hostPassword
		_: parameters gemService
		_: parameters passwordIsEncryptedAsIntegerBoolean.	"1 or 0: GCI_LOGIN_PW_ENCRYPTED"
        result == 0 ifTrue:[ self error:'GciSetNetEx_ failed'].
	result := lib
		GciLoginEx_: parameters username
		_: parameters password
		_: parameters loginFlags
		_: -1 . "haltOnErrNum default (use config file)"
  sid := lib GciGetSessionId.
  sid > 0 ifTrue:[ gciSessionId := sid ].
	0 == result ifTrue: [
	  self _signalIfError: lib arg: 'Using ', parameters printString .
	  self error: 'Login failed for unknown reason!'.
	].
  self _postLogin: lib  .
	((self dynamicInstVarAt: #quiet) ifNil:[ 0 ]) < 2 ifTrue:[
	  self log: 'GsExternalSession login: ' , self _describe.
  ].
%

category: 'Public'
method: GsExternalSession
loginSolo
  "login as a Solo session using  GCI_LOGIN_SOLO flag.
   Requires an appropriate GEM_SOLO_EXTENT value in the config file
   used by the gem process for the new session.
   See GsSession(C)>>isSolo for details of a Solo session."

	stoneSessionId ifNotNil: [
		ImproperOperation signal: 'Stone session ' , stoneSessionId printString ,
			' already associated with this GsExternalSession!'.
	].
  parameters loginFlags: (parameters loginFlags bitOr: parameters soloLoginFlag).
  ^ self login
%

category: 'Public'
method: GsExternalSession
logout
	stoneSessionId ifNil: [^self].
	self isCallInProgress ifTrue: [
		[
			self waitForResult.
		] onException: Error do: [:ex |
			ex return.
		].
	].
	self _logout.
%

category: 'Private'
method: GsExternalSession
nbLogout
  "Private.
   Should be followed by a send of _waitForLogout ."

	stoneSessionId ifNil: [^self].
	self isCallInProgress ifTrue: [
		[
			self waitForResultForSeconds: 20 .
		] onException: Error do: [:ex |
			ex return.
		].
	].
	self _nbLogout .
%

category: 'Public'
method: GsExternalSession
nbResult
  | result lib cByteArray |
  nbResult := nil.
  lib := self _gciLibrary .
  (self _isCallInProgress: lib) ifFalse: [self error: 'no call in progress'].
  cByteArray := CByteArray gcMalloc: 8 .
  result := lib GciNbEnd_: cByteArray .
  result < 2 ifTrue: [ self error:'result not ready'].
  self _signalIfError: lib .
  nbResult := (cByteArray pointerAt: 0 resultClass: CByteArray) uint64At: 0.
  ^ nbResult ifNotNil:[:r |
    "r is an Integer, the value of a remote OopType"
    self resolveResult: r
  ]
%

category: 'Parameters'
method: GsExternalSession
onetimePassword: aString

   parameters onetimePassword: aString copy
%

category: 'Public'
method: GsExternalSession
parameters
  "Return the instance of GemStoneParameters"

  ^ parameters
%

category: 'Parameters'
method: GsExternalSession
password: aString

	parameters password: aString copy.
%

category: 'Public'
method: GsExternalSession
printOn: aStream

	aStream
		nextPutAll: 'a';
		nextPutAll: self class name;
		nextPutAll: '(';
		nextPutAll: stoneSessionId printString;
		nextPutAll: '/';
		nextPutAll: stoneSessionSerial printString;
		nextPutAll: ')' .
%

category: 'Logging'
method: GsExternalSession
quiet
  "By default login and logout are logged using GsFile >> gciLogServer: .
   This disables logging of login and logout."
   self dynamicInstVarAt: #quiet put: 2 .
%

category: 'Logging'
method: GsExternalSession
quietLogout
  "By default login and logout are logged using GsFile >> gciLogServer:.
   This disables logging of logout."
   self dynamicInstVarAt: #quiet put: 1 .
%

category: 'Public'
method: GsExternalSession
resolveResult: anOop
	"Answer the object, or Array containing the OOP, of the result
	received when the last #isResultAvailable answered true.
	Specials can be fully resolved in the current session, and are the
	preferred return type.
	Results that are byte objects will be copied into a String or ByteArray
	and that will be returned, but the OOP of the byte object will remain
	in the remote Gem's export set.
	For objects of all other types, return a result as an Array containing
	the object's OOP in the remote gem, which is also recorded in the remote
	Gem's export set."

  ^ self _resolveResult: anOop lib: self _gciLibrary .
%

category: 'Public'
method: GsExternalSession
resolveResult: anOop toLevel: anInteger
	"Similar to resolveResult:, but this recognizes more classes.
	If the class is not recognized, then return a CByteArray
	with the OOP"

	| lib object oop cByteArray |
	lib := self _gciLibrary.
	object := self _resolveResult: anOop lib: lib .
	(object _isArray) ifFalse: [^object].	"a special or a byte object"
	oop := lib GciFetchClass_: anOop.
	(oop == 66817"Array asOop" and: [0 < anInteger]) ifTrue: [
		| size array |
		size := lib GciFetchSize__: anOop.
		array := Array new.
		1 to: size do: [:i |
			oop := lib GciFetchOop_: anOop _: i.
			array add: (self resolveResult: oop toLevel: anInteger - 1).
		].
		^array.
	].
	"Not a recognized object"
	cByteArray := CByteArray gcMalloc: 8.
	cByteArray uint64At: 0 put: anOop.
	^cByteArray.
%

category: 'Public'
method: GsExternalSession
send: selector to: anOop withArguments: someValues
	"Answer the result of having the specified remote object
	 sent the message with the specified selector and arguments.
	 Argument values are passed by OOP; beware of inconsistent views
	 between the local Gem and the external Gem.
	 The best values to return are specials.
	 Strings and other byte objects are copied to the local Gem.
	 All other responses are returned as a Array containing a single OOP."

	| nArgs args lib |
	lib := self _gciLibrary .
	self _errorIfCallInProgress: lib .
	(someValues == nil or: [ (nArgs := someValues size) == 0])
		ifFalse: [ | ofs |
        ofs := 0 .
			  args := CByteArray gcMalloc: 8 * nArgs .
			  1 to: nArgs do: [:index | | each |
          each := someValues at: index .
					args uint64At: ofs put: each asOop.
          ofs := ofs + 8 .
        ]
     ].
	lib
		GciNbPerform_: anOop  
		_: selector
		_: args
		_: someValues size.
	^self
		waitForResult;
		_lastResult: lib
%

category: 'Accessors'
method: GsExternalSession
sessionId
	"0 => not logged in"

	^gciSessionId.
%

category: 'Public'
method: GsExternalSession
softBreak
	"Interrupt the external Gem, but permit it to be restarted."
  | lib |
  lib := self _gciLibrary .
	self _setSessionId: lib .
	lib GciSoftBreak.
	self _signalIfError: lib .
%

category: 'Parameters'
method: GsExternalSession
stoneNRS: anNRS
	"Set the Stone parameters for the logon to the value
	 of anNRS, which may be a String or a GsNetworkResourceString instance."

	parameters gemStoneName: anNRS asString
%

category: 'Accessors'
method: GsExternalSession
stoneSessionId

	^stoneSessionId.
%

category: 'Accessors'
method: GsExternalSession
stoneSessionSerial

	^stoneSessionSerial.
%

category: 'Logging'
method: GsExternalSession
suppressLogging

	self logger: [:message | ]
%

category: 'Parameters'
method: GsExternalSession
username
  ^ parameters username
%

category: 'Parameters'
method: GsExternalSession
username: aString

	parameters username: aString.
%

category: 'Public'
method: GsExternalSession
waitForReadReady
  "Use the ProcessorScheduler to wait for this session's socket to
   be ready to read, allowing other GsProcess to run while we are waiting."
  (self dynamicInstVarAt: #_socket) _waitForReadReady
%

category: 'Public'
method: GsExternalSession
waitForResult
	"Wait as long as it takes for the external Gem to complete
	 the current operation.
   Does not allow other GsProcess to run. "

	self waitForResultForSeconds: 1000000000000
%

category: 'Public'
method: GsExternalSession
waitForResultForSeconds: aNumber
	"Wait as long as the specified seconds for the external Gem
	 to complete the current operation.
   Does not allow other GsProcess to run. "

	self
		waitForResultForSeconds: aNumber
		otherwise: [self error:
			'Wait time of ' , aNumber printString ,
			' exceeded for session ' , stoneSessionId printString , '/' , stoneSessionSerial printString ,
			' (PID ' , gemProcessId printString , ')']
%

category: 'Public'
method: GsExternalSession
waitForResultForSeconds: aNumber otherwise: aBlock
	"Wait as long as the specified seconds for the external Gem
	 to complete the current operation. If the operation does not
	 complete within that time, answer the result of evaluating aBlock.
   Does not allow other GsProcess to run. "

	| cByteArray lib res msLeft |
  lib := self _gciLibrary .
  cByteArray := CByteArray gcMalloc: 8 .
  msLeft := aNumber asInteger * 1000 .
  [ msLeft > 0 ] whileTrue:[ | tMs |
    tMs := msLeft min: 2000000000 .
    self _setSessionId: lib .
    res := lib GciNbEndPoll_: cByteArray _: tMs .
    res >= 2 ifTrue:[
      self _signalIfError: lib .
      nbResult := cByteArray uint64At: 0 .
      ^ self
    ].
    msLeft := msLeft - tMs .
  ].
  ^ aBlock value
%

category: 'Private'
method: GsExternalSession
_describe
  | str |
	(str := 'stone session ID ' copy )
     add: stoneSessionId asString ;
     add: ' gem processId '; add: gemProcessId asString .
  self _gemHost ifNotNil:[ :host |
     str add: ' on host ' , host asString.
  ].
  str add: ' stone serialNumber ' ; add: stoneSessionSerial asString.
  ^ str
%

category: 'Private'
method: GsExternalSession
_errorIfCallInProgress

	self isCallInProgress ifTrue: [self error: 'call in progress'].
%

category: 'Private'
method: GsExternalSession
_errorIfCallInProgress: lib

	(self _isCallInProgress: lib) ifTrue: [self error: 'call in progress'].
%

category: 'Private'
method: GsExternalSession
_gciLibrary
  "This entry in SessionTemps initialized by instance creation paths."
	^ SessionTemps current at: #GsExternalSession_gciLibrary
%

category: 'Private'
method: GsExternalSession
_gemHost
  ^ self dynamicInstVarAt: #gemHost
%

category: 'Private'
method: GsExternalSession
_getBytes: anOop

	| size bytes fetchedSize classOop |
	classOop := self _gciLibrary GciFetchClass_: anOop.
	self _signalIfError.
	size := self _gciLibrary GciFetchSize__: anOop.
	self _signalIfError.
	bytes := CByteArray gcMalloc: size.
	fetchedSize := self _gciLibrary
		GciFetchBytes__: anOop
		_: 1
		_: bytes
		_: bytes size.
	self _signalIfError.
	fetchedSize ~~ size ifTrue: [self error: 'Unexpected size!'].
	classOop == String asOop ifTrue: [
    size == 0 ifTrue:[ ^ String new ].
		^bytes stringFrom: 0 to: size - 1.
	].
	classOop == Symbol asOop ifTrue: [
    size == 0 ifTrue:[ ^ #'' ].
		^ Symbol withAll: (bytes stringFrom: 0 to: size - 1).
	].
  size == 0 ifTrue:[ ^ ByteArray new ].
	^bytes byteArrayFrom: 0 to: size - 1.
%

category: 'Private'
method: GsExternalSession
_getBytes: anOop lib: lib
	| size bytes numRet classOop |
	classOop := lib GciFetchClass_: anOop.
  classOop == 20"nil asOop" ifTrue:[
	  self _signalIfError: lib .
  ].
	size := lib GciFetchSize__: anOop.
  size == 0 ifTrue:[
    self _signalIfError: lib
  ].
	bytes := CByteArray gcMalloc: size.
	numRet := lib GciFetchBytes__: anOop _: 1 _: bytes _: bytes size.
  numRet == 0 ifTrue:[
	  self _signalIfError: lib .
  ].
	numRet ~~ size ifTrue: [self error: 'Unexpected size!'].
	classOop == 74753"String asOop" ifTrue: [
    size == 0 ifTrue:[ ^ String new ].
		^ bytes stringFrom: 0 to: size - 1.
	].
  classOop == 154369"Unicode7 asOop" ifTrue:[  "fix 51160"
    size == 0 ifTrue:[ ^ Unicode7 new ]. 
    ^ bytes _copyFrom: 0 to: size - 1 resKind: Unicode7 .
  ].
  classOop == 154113"Utf8 asOop" ifTrue:[ | unicodeMode |
    unicodeMode := Unicode16 usingUnicodeCompares .
    size == 0 ifTrue:[ ^ unicodeMode ifTrue:[ Unicode7 new] ifFalse:[String new]]. "fix 49669"
    ^ bytes decodeUTF8from: 0 to: size - 1 unicode: unicodeMode .
  ].
	classOop == 110849"Symbol asOop" ifTrue: [
    size == 0 ifTrue:[ ^ #'' ].
		^ Symbol withAll: (bytes stringFrom: 0 to: size - 1).
	].
  size == 0 ifTrue:[ ^ ByteArray new ].
	^bytes byteArrayFrom: 0 to: size - 1.
%

category: 'Private'
method: GsExternalSession
_getStackForOop: gcierrContextOop
  | str start cByteArray |
  nbResult := nil .
  str := 'AbstractExternalSession _stackReport: ' , gcierrContextOop asString .
  self forkString: str .
  start := System timeGmt .
  cByteArray := CByteArray gcMalloc: 8 .
  [ | result lib |
    lib := self _gciLibrary .
    (self _isCallInProgress: lib) ifFalse:[ ^ 'NO STACK, ERROR no call in progress'].
    result := lib GciNbEnd_: cByteArray.
    result >= 2 ifTrue:[
      (self _gciLibrary GciErr_: gciErrSType) == 1 ifTrue:[
        (gciErrSType number  between: 4000 and: 4999) ifTrue: [gciSessionId := 0].
        ^ self gciErrorClass new _error: gciErrSType in: self .
      ].
      nbResult := (cByteArray pointerAt: 0 resultClass: CByteArray) uint64At: 0.
      ^ self _lastResult: lib .
    ].
    Delay waitForMilliseconds: 20 .
    (System timeGmt - start) > 20 ifTrue:[ ^ 'NO STACK, getStack timedout'].
  ] repeat
%

category: 'Private'
method: GsExternalSession
_isCallInProgress: lib
  | result |
	self _setSessionId: lib .
	result := lib GciCallInProgress. "no Gci error possible"
	^ result == 1
%

category: 'Private'
method: GsExternalSession
_isOnMyHost
  (self dynamicInstVarAt: #_isOnMyHost) ifNotNil:[ :x | ^ x ].
  ^ false
%

category: 'Private'
method: GsExternalSession
_isOnMyStone
  | val |
  (val := self dynamicInstVarAt: #_isOnMyStone) ifNil:[
    (GsSession currentSession isSolo) ifTrue:[
      val := false .
      self dynamicInstVarAt: #_isOnMyStone put: val .
    ].
  ].
  ^ val
%

category: 'Private'
method: GsExternalSession
_isResultAvailable: cByteArray
  "cByteArray is allocated by the caller to avoid a gcMalloc: in each
   invocation of this method."
	| result lib |
	nbResult := nil.
  lib := self _gciLibrary .
	(self _isCallInProgress: lib) ifFalse: [self error: 'no call in progress'].
	result := lib GciNbEnd_: cByteArray.
	result < 2 ifTrue: [ ^ false].
	self _signalIfError: lib .
	nbResult := (cByteArray pointerAt: 0 resultClass: CByteArray) uint64At: 0.
	^ true.
%

category: 'Private'
method: GsExternalSession
_lastResult: lib
  ^ nbResult ifNotNil:[:r |
     "r is an Integer, the value of a remote OopType"
     self _resolveResult: r lib: lib
  ]
%

category: 'Private'
method: GsExternalSession
_logout
	| descr |
	descr := self _describe.
	self isLoggedIn ifTrue:[
		self _nbLogout: descr .
		self _waitForLogout.
		gciSessionId := 0.
	].
	stoneSessionId := nil.
	stoneSessionSerial := nil.
	((self dynamicInstVarAt: #quiet) ifNil:[ 0 ]) < 1 ifTrue:[
		self log: 'GsExternalSession logout: ' , descr.
	].
%

category: 'Private'
method: GsExternalSession
_nbLogout
  | descr |
  descr := self _describe.
	((self dynamicInstVarAt: #quiet) ifNil:[ 0 ]) < 1 ifTrue:[
	  self log: 'GsExternalSession nbLogout: ' , descr.
  ].
  ^ self _nbLogout: descr
%

category: 'Private'
method: GsExternalSession
_nbLogout: descr
  self isLoggedIn ifTrue:[ | lib |
    lib := self _gciLibrary .
		self _setSessionId: lib .
		lib GciLogout__: 0 .
		[ [ self _signalIfError: lib
			] onException: self gciErrorClass do:[:ex |
				 ex originalNumber == 4100
					 ifTrue:[ "ignore invalid session error from GciError"]
					ifFalse:[ ex pass ].
			].
		] onException: Error do: [:ex | | msg |
			(msg := '---(During GsExternalSession logout:') , descr lf .
			msg := msg , '    ', ex description , ')---'.
			self log: msg lf .
		].
  ].
%

category: 'Private'
method: GsExternalSession
_postLogin: lib
	| onMyStn onMyHost gemHostIdStr oopSystem fd sock |
  oopSystem := 76033 "System asOop".
	stoneSessionId := Object _objectForOop: (lib GciPerform_: oopSystem _: 'session' _: nil _: 0).
	self _signalIfError: lib .
  gemProcessId := Object _objectForOop: (lib GciPerform_: oopSystem _: 'gemProcessId' _: nil _: 0).
	self _signalIfError: lib .

  gemHostIdStr := self executeString:'System hostId asString' .
  onMyHost :=   gemHostIdStr = System hostId asString .

  GsSession isSolo ifTrue:[
    onMyStn := false .
  ] ifFalse:[ | stoneStartupStr |
    stoneStartupStr := self executeString:'System stoneStartupId asString'.
    onMyStn :=  stoneStartupStr = System stoneStartupId asString .
	  stoneSessionSerial := onMyStn ifTrue:[ GsSession serialOfSession: stoneSessionId ]
                              ifFalse:[ self executeString: 'GsSession currentSession serialNumber'].
  ].
  self dynamicInstVarAt: #_isOnMyStone put: onMyStn .
  self dynamicInstVarAt: #_isOnMyHost put:  onMyHost .
  fd := lib GciNbGetNotifyHandle .
  sock := GsSocket fromFileHandle: fd .
  self dynamicInstVarAt: #_socket put: sock
%

category: 'Private'
method: GsExternalSession
_resolveResult: anOop lib: lib
	| type |
	self _setSessionId: lib .
	type := lib GciFetchObjImpl_: anOop.
	type == 3 ifTrue: [^Object _objectForOop: anOop]. "result is a special"
	type == 1 ifTrue: [^self _getBytes: anOop lib: lib ].	  "result is a byte object"
  type < 0 ifTrue:[
	  self _signalIfError: lib .
  ].
	^ { anOop } .
%

category: 'Private'
method: GsExternalSession
_setSessionId

  self isLoggedIn ifFalse:[
     ^ Error signal:'invalid sessionId (session not logged in)'
  ].
  self _gciLibrary GciSetSessionId_: gciSessionId .
  self _signalIfError.
%

category: 'Private'
method: GsExternalSession
_setSessionId: lib

  self isLoggedIn ifFalse:[
     ^ Error signal:'invalid sessionId (session not logged in)'
  ].
  lib GciSetSessionId_: gciSessionId .
  self _signalIfError: lib .
%

category: 'Private'
method: GsExternalSession
_signalIfError
	(self _gciLibrary GciErr_: gciErrSType) == 1 ifFalse: [^self].
	(gciErrSType number  between: 4000 and: 4999) ifTrue: [gciSessionId := 0].
	self gciErrorClass 
		signal: gciErrSType
		in: self
%

category: 'Private'
method: GsExternalSession
_signalIfError: lib
	(lib GciErr_: gciErrSType) == 1 ifFalse: [^self].
	(gciErrSType number  between: 4000 and: 4999) ifTrue: [gciSessionId := 0].
	self gciErrorClass 
		signal: gciErrSType
		in: self
%

category: 'Private'
method: GsExternalSession
_signalIfError: lib arg: detailString
	(lib GciErr_: gciErrSType) == 1 ifFalse: [^self].
	(gciErrSType number  between: 4000 and: 4999) ifTrue: [gciSessionId := 0].
	self gciErrorClass 
		signal: gciErrSType
		in: self details: detailString
%

category: 'Private'
method: GsExternalSession
_waitForLogout
  | onMyStn onMyHost |
	stoneSessionId ifNil:[ ^ self].
  onMyStn := self _isOnMyStone .
  onMyHost := self _isOnMyHost .
  (onMyStn or:[ onMyHost]) ifFalse:[  ^ self "no way to wait reliably"].
	1 to: 2000 do:[ :j |
		onMyStn ifTrue: [
			(GsSession serialOfSession: stoneSessionId) = stoneSessionSerial ifFalse:[
         ^self
      ].
		].
    onMyHost ifTrue:[
      (System _hostProcessExists: gemProcessId) ifFalse:[
        ^ self
      ].
    ].
		(Delay forMilliseconds: 10) wait.
	].
  self error: 'session with stone session ID of ' , stoneSessionId printString ,
              ' gemProcessId = ' , gemProcessId printString,
              ' still present 20 seconds after logout'.
%

! Class implementation for 'GsLegacyExternalSession'

!		Class methods for 'GsLegacyExternalSession'

category: 'Instance Creation'
classmethod: GsLegacyExternalSession
gciErrSTypeClass
  ^ GciLegacyError
%

category: 'Instance Creation'
classmethod: GsLegacyExternalSession
gciLibrary
  "No shared library loaded with GsLegacyExternalSession"
  ^ self
%

category: 'Instance Creation'
classmethod: GsLegacyExternalSession
newDefault
  ^ self basicNew initialize ; initializeDefaultResources 
%

!		Instance methods for 'GsLegacyExternalSession'

category: 'Public'
method: GsLegacyExternalSession
abort

	self _errorIfCallInProgress.
	gciInterface nbAbort.
	self waitForResult.
%

category: 'Error handling'
method: GsLegacyExternalSession
clearStackFor: anError

	| contextOop |
	gciInterface sessionId == 0 ifTrue: [^self].
	(contextOop := anError context) == nil asOop ifTrue: [^self].
	self _errorIfCallInProgress.
	gciInterface clearStack: contextOop.
	self _signalIfError.
%

category: 'Public'
method: GsLegacyExternalSession
commit

	self _errorIfCallInProgress.
	^ gciInterface commit.
%

category: 'Public'
method: GsLegacyExternalSession
commitOrError
  | res |
  res := self commit .
  res ~~ true ifTrue:[
    TransactionError new signal: 'GciInterface>>commit failed'
  ].
  ^ res .
%

category: 'Error handling'
method: GsLegacyExternalSession
continue: contextOop replacingTopOfStackWithOop: valueOop
	"Continue execution in the external Gem following an exception,
	 replacing the top of the stack with the specified object.
	 It is an error to specify an oop not visible to the remote Gem."

	self _errorIfCallInProgress.
	^ gciInterface
		continueWith: contextOop
		replaceTopOfStackWith: valueOop
		isSpecial: false
		flags: 0.
%

category: 'Public'
method: GsLegacyExternalSession
executeString: aString
        "Execute the string expression in the external Gem and answer the result.
         The best values to return are specials.
         Strings and other byte objects are copied to the local Gem.
         All other responses are returned as a Array containing a single OOP."

        ^self
                forkString: aString;
                waitForResult;
                lastResult.
%

category: 'Public'
method: GsLegacyExternalSession
forceLogout

	self hardBreak.
	self _logout.
%

category: 'Public'
method: GsLegacyExternalSession
forkString: aString

	self _errorIfCallInProgress.
 gciInterface nbRemoteExecute: aString.
%

category: 'Private'
method: GsLegacyExternalSession
gciErrorClass
  ^ GciLegacyError
%

category: 'Private'
method: GsLegacyExternalSession
getAndClearLastError

	^ gciInterface getAndClearLastError.
%

category: 'Public'
method: GsLegacyExternalSession
hardBreak

	gciInterface hardBreak.
%

category: 'Private'
method: GsLegacyExternalSession
initialize

	super initialize.
	gciInterface := GciInterface new.
%

category: 'Public'
method: GsLegacyExternalSession
isCallInProgress
	"The following calls are OK during a nonblocking call:
	GciCallInProgress
	GciErr
	GciGetSessionId
	GciHardBreak
	GciNbEnd
	GciSetSessionId
	GciShutdown
	GciSoftBreak"

	self lastError notNil ifTrue: [self error: self lastError].
	gciInterface sessionId == 0 ifTrue: [^false].
	gciInterface callInProgress == true ifTrue: [^true].
	self getAndClearLastError.
	^false.
%

category: 'Public'
method: GsLegacyExternalSession
isLoggedIn
  | sid |
  gciInterface ifNil:[ ^ false ].
  sid := gciInterface sessionId  .
  ^ sid ~~ nil and:[ sid > 0 ].
%

category: 'Public'
method: GsLegacyExternalSession
isResultAvailable

	| status |
	self isCallInProgress ifFalse: [self error: 'no call in progress'].
	status := gciInterface nbEndOop.
	status ifNil: [self _signalIfError].
	^ status == 1.
%

category: 'Private'
method: GsLegacyExternalSession
lastError

	^ gciInterface lastError.
%

category: 'Public'
method: GsLegacyExternalSession
lastResult

	| result error1 error2 |
	gciInterface resultIsSpecial ifTrue: [^ gciInterface lastResult].
	error1 := gciInterface getAndClearLastError.
	self traversalBuffer initTraversalBuffer.
	result := gciInterface
		traverseObjects:  { gciInterface lastResult }
		buffer: traversalBuffer.
	(error2 := gciInterface getAndClearLastError) notNil ifTrue: [ | txt |
		txt := error2 message.
		(txt == nil or: [txt trimBlanks isEmpty])
			ifTrue: [(Exception _new: error2 number args:  {} ) signal]
			ifFalse:[self error: txt]
	].
	traversalBuffer currentObjectIsSpecial ifTrue: [^traversalBuffer objId].
	traversalBuffer currentObjectIsByte ifTrue: [^traversalBuffer getByteObject].
	^ { traversalBuffer objId }
%

category: 'Public'
method: GsLegacyExternalSession
login

	| result onMyStn onMyHost gemHostIdStr |
	stoneSessionId ifNotNil: [
		ImproperOperation signal: 'Stone session ' , stoneSessionId printString ,
			' already associated with this GsExternalSession!'.
	].
	self _errorIfCallInProgress.
	result := gciInterface login: parameters execute: 'System session'.
	self _signalIfError.
	stoneSessionId := result.

  "inline _postLogin"
  result := gciInterface remotePerform: System asOop selector: 'gemProcessId' args: #()  .
  self _signalIfError.
  gemProcessId := result .
  gemHostIdStr := self executeString:'System hostId asString'.
  self _signalIfError.
  onMyHost :=   gemHostIdStr = System hostId asString .

  GsSession isSolo ifTrue:[
    onMyStn := false .
  ] ifFalse:[ | stoneStartupStr |
    stoneStartupStr := self executeString:'System stoneStartupId asString'.
    self _signalIfError.
    onMyStn :=  stoneStartupStr = System stoneStartupId asString .
    stoneSessionSerial := onMyStn ifTrue:[ GsSession serialOfSession: stoneSessionId ]
                 ifFalse:[ self executeString: 'GsSession currentSession serialNumber'].
  ].
  gciSessionId := gciInterface sessionId.

  self dynamicInstVarAt: #_isOnMyStone put: onMyStn .
  self dynamicInstVarAt: #_isOnMyHost put:  onMyHost .

	self log: 'GsLegacyExternalSession login: ', self _describe .
%

category: 'Public'
method: GsLegacyExternalSession
logout

	self isCallInProgress ifTrue: [
		[
			self waitForResult.
		] on: Error do: [:ex |
			ex return.
		].
	].
	self _logout.
%

category: 'Private'
method: GsLegacyExternalSession
nbLogout

  ^ self forceLogout
%

category: 'Public'
method: GsLegacyExternalSession
nbResult
  | status |
  status := gciInterface nbEndOop .
  status == 1 ifFalse:[ Error signal:' result not ready'].
  ^ self lastResult 
%

category: 'Public'
method: GsLegacyExternalSession
send: selector to: remoteOop withArguments: someValues

  | args |
  (someValues == nil or: [someValues isEmpty]) ifTrue: [
     args := #( )
  ] ifFalse: [
    args := { } .
    someValues do: [:each | args add: each asOop ; add: each isSpecial ].
  ].
  gciInterface remotePerform: remoteOop selector: selector args: args.
  self _signalIfError.
  gciInterface resultIsSpecial ifTrue: [^ gciInterface lastResult].
  ^ { gciInterface lastResult }
%

category: 'Accessors'
method: GsLegacyExternalSession
sessionId

	^ gciInterface sessionId.
%

category: 'Public'
method: GsLegacyExternalSession
softBreak

	gciInterface softBreak.
%

category: 'Public'
method: GsLegacyExternalSession
traversalBuffer

	traversalBuffer ifNil: [
		(traversalBuffer := TraversalBuffer new: 8000)
			level: 1;
			initTraversalBuffer.
	].
	^traversalBuffer.
%

category: 'Public'
method: GsLegacyExternalSession
waitForResultForSeconds: aNumber otherwise: aBlock
  "Wait as long as the specified seconds for the external Gem
  to complete the current operation. If the operation does not
  complete within that time, answer the result of evaluating aBlock."

  | start |
  start := System timeGmt.
  [ self isResultAvailable ] whileFalse:
    [ Delay waitForMilliseconds: 20.
      aNumber < (System timeGmt - start) ifTrue:[ ^aBlock value]]
%

category: 'Private'
method: GsLegacyExternalSession
_errorIfCallInProgress

  self isCallInProgress ifTrue: [self error: 'call in progress'].
%

category: 'Private'
method: GsLegacyExternalSession
_freeTraversalBuffer

	traversalBuffer ifNil: [^self].
	traversalBuffer free.
	traversalBuffer := nil.
%

category: 'Private'
method: GsLegacyExternalSession
_gciInterface

	^gciInterface
%

category: 'Private'
method: GsLegacyExternalSession
_gciLibrary
   "Not usable in GsLegacyExternalSession"
   self shouldNotImplement: #_gciLibrary
%

category: 'Private'
method: GsLegacyExternalSession
_getStackForOop: gcierrContextOop
  | str |
  self isCallInProgress ifTrue:[ ^ 'call in progress, stack not available' ]. 
  str := 'AbstractExternalSession _stackReport: ' , gcierrContextOop asString .
  self forkString: str .
  self waitForResultForSeconds: 120 .
  ^ self nbResult .
%

category: 'Private'
method: GsLegacyExternalSession
_isOnMyStone
  "value is an approximation, not guaranteed to be accurate"
  | val |
  (val := self dynamicInstVarAt: #_isOnMyStone) ifNil:[
    (GsSession currentSession isSolo) ifTrue:[
      val := false
    ] ifFalse:[
      val := parameters gemStoneName = System stoneName.
    ].
    self dynamicInstVarAt: #_isOnMyStone put: val .
  ].
  ^ val
%

category: 'Private'
method: GsLegacyExternalSession
_logout

	| descr |
	descr := self _describe.
	self _freeTraversalBuffer.
	gciInterface logout.
	self _waitForLogout.
	self getAndClearLastError.
	stoneSessionId := nil.
	stoneSessionSerial := nil.
	self log: 'GsLegacyExternalSession logout: ' , descr.
%

category: 'Private'
method: GsLegacyExternalSession
_signalIfError

	| error |
	(error :=  gciInterface getAndClearLastError) ifNil: [^self].
	GciLegacyError
		signal: error
		in: self.
%

! Class implementation for 'GsX509ExternalSession'

!		Class methods for 'GsX509ExternalSession'

category: 'Instance Creation'
classmethod: GsX509ExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: aUsername password: aPassword

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:
%

category: 'Instance Creation'
classmethod: GsX509ExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: gsUsername password: gsPassword hostUsername: hostUsername hostPassword: hostPassword

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:hostUsername:hostPassword:
%

category: 'Instance Creation'
classmethod: GsX509ExternalSession
newDefault

self shouldNotImplement: #newDefault
%

category: 'Instance Creation'
classmethod: GsX509ExternalSession
newWithX509Parameters: aGemStoneX509Parameters

self gciLibrary .
^ self new initializeWithX509Parameters: aGemStoneX509Parameters
%

!		Instance methods for 'GsX509ExternalSession'

category: 'Parameters'
method: GsX509ExternalSession
gemNRS: anNRS

  self shouldNotImplement: #gemNRS:
%

category: 'Parameters'
method: GsX509ExternalSession
hostPassword: aString

  self shouldNotImplement: #hostPassword:
%

category: 'Parameters'
method: GsX509ExternalSession
hostUsername: aString

  self shouldNotImplement: #hostUsername:
%

category: 'Private'
method: GsX509ExternalSession
initialize

^ self initializeWithX509Parameters: GemStoneX509Parameters new
%

category: 'Private'
method: GsX509ExternalSession
initializeDefaultResources

self shouldNotImplement: #initializeDefaultResources
%

category: 'Private'
method: GsX509ExternalSession
initializeWithX509Parameters: aGemStoneX509Parameters

	gciErrSType := self class gciErrSTypeClass new.
	parameters := aGemStoneX509Parameters .
	self loggingToServer.
%

category: 'Public'
method: GsX509ExternalSession
login

	| result lib |
	stoneSessionId ifNotNil: [
		ImproperOperation signal: 'Stone session ' , stoneSessionId printString ,
			' already associated with this GsX509ExternalSession!'.
	].

  lib := self _gciLibrary .
       result := lib GciX509Login_: parameters asGciX509LoginArg .
	0 == result ifTrue: [
    self _signalIfError: lib .
		self error: 'Login failed for unknown reason!'.
	].
	gciSessionId := self _gciLibrary GciGetSessionId.
  self _postLogin: lib  .
  username := self executeString:'System myUserProfile userId' .
	self log: 'GsX509ExternalSession login: ' , self _describe.
%

category: 'Parameters'
method: GsX509ExternalSession
password: aString
  self shouldNotImplement: #password:
%

category: 'Parameters'
method: GsX509ExternalSession
stoneNRS: anNRS

  self shouldNotImplement: #stoneNRS:
%

category: 'Parameters'
method: GsX509ExternalSession
username
  ^ username
%

category: 'Parameters'
method: GsX509ExternalSession
username: aString

 self shouldNotImplement: #username:
%

category: 'Private'
method: GsX509ExternalSession
_gemHost

^ parameters netldiHost
%

! Class implementation for 'ErrorDescription'

!		Instance methods for 'ErrorDescription'

category: 'Accessing'
method: ErrorDescription
asString
  ^ self printString
%

category: 'Accessing'
method: ErrorDescription
category

   "To match GciErrSType."
   ^categoryOop
%

category: 'Accessing'
method: ErrorDescription
categoryOop

   "Return the value of the instance variable 'categoryOop'."
   ^categoryOop
%

category: 'Accessing'
method: ErrorDescription
context

   "To match GciErrSType."
   ^contextOop
%

category: 'Accessing'
method: ErrorDescription
contextOop

   "Return the value of the instance variable 'contextOop'."
   ^contextOop
%

category: 'Accessing'
method: ErrorDescription
fatal

   "Return the value of the instance variable 'fatal'."
   ^fatal
%

category: 'Testing'
method: ErrorDescription
isBreakPoint

"Return whether the error is due to a breakpoint."

categoryOop ifNil: [^false].
GemStoneError asOop == categoryOop
  ifFalse: [^false].
^ #( 6005 6006 6002 6023 6024 6025) includesIdentical: number 
%

category: 'Testing'
method: ErrorDescription
isPause

"Return whether the error is due to a soft break."

categoryOop == nil
  ifTrue: [^false].
GemStoneError asOop == categoryOop
  ifFalse: [^false].
^ number == (ErrorSymbols at: #rtErrPause)
%

category: 'Testing'
method: ErrorDescription
isSoftBreak

"Return whether the error is due to a soft break."

categoryOop == nil
  ifTrue: [^false].
GemStoneError asOop == categoryOop
  ifFalse: [^false].
^ number == (ErrorSymbols at: #rtErrSoftBreak)
%

category: 'Accessing'
method: ErrorDescription
message

   "Return the value of the instance variable 'message'."
   ^message
%

category: 'Accessing'
method: ErrorDescription
number

   "Return the value of the instance variable 'number'."
   ^number
%

category: 'Accessing'
method: ErrorDescription
printString
  "Display the receiver"

| s |

s := String new.
s add: self class name.
s add: '('.

s add: 'category=' ; add: categoryOop printString ; add: ', '.
s add: 'number=' ; add: number printString ; add: ', '.
s add: 'context=' ; add: contextOop printString ; add: ', '.

message == nil ifTrue:[s add: 'message=none' ]
	ifFalse: [s add: 'message="' ; add: message printString ; add: '", '].
s add: 'fatal=' ; add: fatal printString.

s add: ')'.
^s
%

! Class implementation for 'GsX509CertificateChain'

!		Class methods for 'GsX509CertificateChain'

category: 'Class Membership'
classmethod: GsX509CertificateChain
certificateSpecies

^ GsX509Certificate
%

category: 'Instance Creation'
classmethod: GsX509CertificateChain
newFromPemFile: fileNameString
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. All certificates in the given file are loaded in same order
 as they appear in the PEM file.

 Raises an exception if the file is not in PEM format."

^ self tls3ArgPrim: 2 with: fileNameString with: self certificateSpecies with: 3
%

category: 'Instance Creation'
classmethod: GsX509CertificateChain
newFromPemString: aPemString
"Creates a new instance of the receiver based on the PEM string.
 All certificates in the given file are loaded in same order
 as they appear in the PEM string.

 Raises an exception if the string is not in PEM format."

^ self tls3ArgPrim: 3 with: aPemString with:  self certificateSpecies with: 3
%

category: 'Private'
classmethod: GsX509CertificateChain
tls3ArgPrim: opCode with: aString with: pfArg with: type

"
  OpCode   Function
=========================================================================
     0      New GsTlsCredential from PEM file, pfArg is the passphrase
     1      New GsTlsCredential from PEM string, pfArg is the passphrase
     2      New GsX509CertificateChain from PEM file
     3      New GsX509CertificateChain from PEM file
     4      New GsTlsPublicKey from a GsX509Certificate
     5      New GsTlsCredential from PEM file, pfArg is a file name
     6      New GsTlsCredential from PEM string, pfArg is a file name
=========================================================================

  Type      Kind
============================
    1       Private Key
    2       Public Key
    3       X509 Certificate
============================
"

<primitive: 1056>
^ self _primitiveFailed: #tls3ArgPrim:with:with:with: args: { opCode . aString . pfArg . type }
%

!		Instance methods for 'GsX509CertificateChain'

category: 'Converting'
method: GsX509CertificateChain
asPemString

|sz result|
sz := self size.
(sz == 1)
  ifTrue:[ ^ (self at: 1) asPemString] .

result := String new.
1 to: sz do:[:n| result addAll: (self at: n) asPemString ].
^ result
%

! Class implementation for 'HtInternalNode'

!		Class methods for 'HtInternalNode'

category: 'instance creation'
classmethod: HtInternalNode
forCollection: aCollection

	^ (self new: self nodeBasicSize)
		  initialize;
		  collection: aCollection;
		  yourself
%

category: 'instance creation'
classmethod: HtInternalNode
nodeBasicSize
	"Since named instvar structure is 
	| hash | child | hash | ... | hash | child | hash |
	we want an odd basicSize.
	Max size to fit in a page is 2034, including named instvers.
	I have seven named instvars, so max size is 2027"

	^ 2027
%

!		Instance methods for 'HtInternalNode'

category: 'walker access'
method: HtInternalNode
absorbLeftSibling: otherInternalNode
	"Copy all elements in otherInternalNode to myself.
	otherInternalNode must be the sibling adjacent to my left
	(lower hash values).
	Sender is responsible for assuring that I have sufficient room.
	otherInternalNode is about to be discarded, don't bother to 
	remove elements from it."

	| otherTally roomNeeded |
	otherTally := otherInternalNode tally.
	roomNeeded := otherTally * 2.
"
	self maxHashIndex to: 1 by: -1 do: [ :i | 
		self at: i + roomNeeded put: (self at: i) ].
	self replaceFrom: 1 to: roomNeeded with: otherInternalNode startingAt: 1.
"
  self _insertAt: 1 from: otherInternalNode fromStart: 1 fromEnd: roomNeeded 
       numToMoveDown: self maxHashIndex .
	tally := tally + otherTally.
	lowestHash := otherInternalNode lowestHash.
	self computeConstants
%

category: 'walker access'
method: HtInternalNode
absorbRightSibling: otherInternalNode
	"Copy all elements in otherInternalNode to myself.
	otherInternalNode must be the sibling adjacent to my right
	(higher hash values).
	Sender is responsible for assuring that I have sufficient room.
	otherInternalNode is about to be discarded, don't bother to 
	remove elements from it."

	| otherTally newTally |
	otherTally := otherInternalNode tally.
	newTally := tally + otherTally.
	self
		replaceFrom: (tally + 1) * 2
		to: newTally * 2 + 1
		with: otherInternalNode
		startingAt: 2.
	highestHash := otherInternalNode highestHash.
	tally := newTally.
	self computeConstants
%

category: 'accessing'
method: HtInternalNode
appendHash: hash
	"Add the given hash value after my last entry,
	making it the highest hash for this node.
	Used in initializing new root nodes."

	self at: self highestHashIndex put: hash
%

category: 'accessing'
method: HtInternalNode
appendSortedChild: childNode
	"Add childNode and its lower hash as my new last entry.
	The sender is responsible for sending this message in sorted order.
	Used for initializing a new root node."

	| hashIndex |
	tally = 0 ifTrue: [ lowestHash := childNode lowestHash ].
	hashIndex := self highestHashIndex.
	self
		at: hashIndex put: childNode lowestHash;
		at: hashIndex + 1 put: childNode.
	tally := tally + 1
%

category: 'auditing'
method: HtInternalNode
auditOnto: stream for: aCollection lowestHash: parentLow highestHash: parentHigh
	"Report any problems onto stream.
	Answer the total number of key/value pairs found in my subtree."

	| identifier pairCount previousHash nextHash |
	identifier := 'InternalNode ' , self asOop printString , ' '.

	self _isLarge
		ifTrue: [ 
			stream
				nextPutAll: identifier , 'is a large object, should fit in one page.';
				lf ].

	highestHash = parentHigh
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'highestHash should be equal to parent hash of '
								, parentHigh printString , ' but is ' , highestHash printString;
				lf ].

	lowestHash = parentLow
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'lowestHash should be equal to parent hash of '
								, parentLow printString , ' but is ' , lowestHash printString;
				lf ].

	highestHash < lowestHash
		ifTrue: [ 
			stream
				nextPutAll:
						identifier , 'lowestHash ' , lowestHash printString
								, ' is greater than highestHash ' , highestHash printString;
				lf ].

	(multiplier class ~~ SmallInteger or: [ multiplier < 0 ])
		ifTrue: [ 
			stream
				nextPutAll:
						identifier , 'multiplier should be a non-negative SmallInteger, but is '
								, multiplier printString;
				lf ]
		ifFalse: [ 
			multiplier = 0
				ifFalse: [ 
					(multiplier highBit between: 29 and: 30)
						ifFalse: [ 
							stream
								nextPutAll:
										identifier , 'multiplier out of expected range, is ' , multiplier printString;
								lf ] ] ].

	postShift class ~~ SmallInteger
		ifTrue: [ 
			stream
				nextPutAll:
						identifier , 'postShift should be a SmallInteger, but is '
								, postShift printString;
				lf ]
		ifFalse: [ 
			postShift = 0
				ifFalse: [ 
					(postShift between: -58 and: -20)
						ifFalse: [ 
							stream
								nextPutAll:
										identifier , 'postShift should be between -58 and -20, but is '
												, postShift printString;
								lf ] ] ].

	preShift class ~~ SmallInteger
		ifTrue: [ 
			stream
				nextPutAll:
						identifier , 'preShift should be a SmallInteger, but is ' , preShift printString;
				lf ]
		ifFalse: [ 
			(preShift between: -30 and: 0)
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'preShift should be between -30 and 0, but is '
										, preShift printString;
						lf ] ].

	tally class ~~ SmallInteger
		ifTrue: [ 
			stream
				nextPutAll:
						identifier , 'tally should be a SmallInteger, but is ' , tally printString;
				lf ]
		ifFalse: [ 
			(tally between: 2 and: 1013)
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'tally should be between 2 and 1013, but is ' , tally printString;
						lf ] ].

	collection == aCollection
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'collection is ' , collection printString , ' with oop '
								, collection asOop printString
								, ' should be the Collection I belong to';
				lf ].

	lowestHash = (self at: 1)
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'lowestHash is ' , lowestHash printString
								, ', should be equal to first indexed instvar, which is '
								, (self at: 1) printString;
				lf ].

	pairCount := 0.
	previousHash := lowestHash.
	1 to: tally * 2 - 1 by: 2 do: [ :hashIndex | 
		| currentHash child |
		currentHash := self at: hashIndex.
		nextHash := self at: hashIndex + 2.
		currentHash >= previousHash
			ifFalse: [ 
				stream
					nextPutAll:
							identifier , 'Hash at ' , hashIndex printString , ' with value '
									, currentHash printString
									, ' is out of order, should be >= previous hash with value '
									, previousHash printString;
					lf ].
		nextHash >= currentHash
			ifFalse: [ 
				"This check is really only necessary for the highest hash."
				stream
					nextPutAll:
							identifier , 'Hash at ' , (hashIndex + 2) printString , ' with value '
									, nextHash printString
									, ' is out of order, should be >= previous hash with value '
									, currentHash printString;
					lf ].
		child := self at: hashIndex + 1.
		pairCount := pairCount
			+
				(child
					auditOnto: stream
					for: aCollection
					lowestHash: currentHash
					highestHash: nextHash).
		previousHash := currentHash ].

	highestHash = nextHash
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'highestHash is ' , highestHash printString
								, ', should be equal to indexed instvar at tally * 2 + 1, which is '
								, nextHash printString;
				lf ].

	(tally + 1) * 2 to: self size do: [ :i | 
		| found |
		found := self at: i.
		found
			ifNotNil: [ 
				stream
					nextPutAll:
							identifier , 'indexed instvar at free index ' , i printString
									, ' should be nil, but is ' , found printString;
					lf ] ].

	^ pairCount
%

category: 'walker access'
method: HtInternalNode
bulkCopyFrom: otherNode startIndex: startIndex endIndex: endIndex
	"Should be able to use primitive for the actual copy."

	| myIndex |
	myIndex := 1.
	startIndex to: endIndex do: [ :theirIndex | 
		self at: myIndex put: (otherNode at: theirIndex).
		myIndex := myIndex + 1 ].
	lowestHash := self at: 1.
	highestHash := self at: myIndex - 1.
	tally := (myIndex - 1) // 2.
	self computeConstants
%

category: 'private'
method: HtInternalNode
clearFrom: startIndex to: endIndex

	startIndex to: endIndex do: [ :i | self at: i put: nil ]
%

category: 'accessing'
method: HtInternalNode
collection: aCollection
	collection := aCollection
%

category: 'initializing'
method: HtInternalNode
computeConstants
	"Set multiplier, preShift, and postShift, based on lowestHash, 
    highestHash, and tally, so that the expression in 
    lowestChildIndexForHash:

    ((hash - lowestHash bitShift: preShift) * multiplier bitShift: postShift)
		bitOr: 1
		
    closely approximates the ideal expression
    
    tally * (hash - lowestHash) // (highestHash - lowestHash) * 2 + 1
    
    but using only SmallInteger intermediate results, and avoiding
    division since it is expensive at the machine-instruction level."

	| range rangeShift shiftedRange rangeBits tallyBits tallyShift shiftedTally |
	range := highestHash - lowestHash.
	range = 0
		ifTrue: [ 
			multiplier := preShift := postShift := 0.	"All hashes in the node are the same, set up for linear search"
			^ self ].
	rangeShift := 30 - range highBit min: 0.	"-30 to 0, commonly -30 to ~ -20"
	shiftedRange := (range bitShift: rangeShift) + 1.	"+ 1 to make sure we round multiplier in the lower direction"
	rangeBits := shiftedRange highBit.	"2 to 31, 31 for root nodes, 30 for most others"
	tallyBits := tally highBit.	"2 to 10"
	tallyShift := rangeBits + 29 - tallyBits.	"21 to 58, commonly 49 to 58"
	shiftedTally := tally bitShift: tallyShift.	"highBit is 31 to 60, commonly 59 or 60"
	multiplier := shiftedTally // shiftedRange.	"highBit 29 or 30"
	preShift := 60 - multiplier highBit - range highBit min: 0.	"-30 to 0. Commonly -30 to ~ -20"
	postShift := rangeShift - preShift - tallyShift + 1. "either -tallyShift or -tallyShift + 1"
%

category: 'copying'
method: HtInternalNode
copyForCollection: coll
	| copy |
	copy := self shallowCopy.
	copy
		collection: coll;
		postCopyForCollection: coll.
	^ copy
%

category: 'accessing'
method: HtInternalNode
highestHash
	^highestHash
%

category: 'accessing'
method: HtInternalNode
highestHash: aSmallInteger
	highestHash := aSmallInteger
%

category: 'private'
method: HtInternalNode
highestHashIndex

	^ tally * 2 + 1
%

category: 'initializing'
method: HtInternalNode
initialize

	super initialize.
	tally := 0
%

category: 'initializing'
method: HtInternalNode
initializeFromHashLimits

	| highest range highBit ddivisor sshift |
	highest := self at: self highestHashIndex.
	range := highest - lowestHash.
	range = 0 ifTrue: [ "All hash values in node will be identical due to large
		numbers of collisions. Just set up for linear search."
		sshift := -60.
		ddivisor := 1.
		^ self ].
	highBit := range highBit. "range < 2 ** highBit"
	sshift := 60 - highBit min: 5.
	ddivisor := range bitShift: sshift - 5
%

category: 'walker access'
method: HtInternalNode
insertChildNode: node atIndex: childIndex

	| hashIndex nMove |
	hashIndex := childIndex - 1.
  nMove := self maxHashIndex - hashIndex + 1 .
  self _insertAt: hashIndex value: node lowestHash value: node numToMoveDown: nMove . 
	tally := tally + 1.
	self computeConstants
%

category: 'testing'
method: HtInternalNode
isDegenerate
	"An internal node, even if it's the root, must have at least two children."

	^ tally = 1
%

category: 'testing'
method: HtInternalNode
isFull

	"self basicSize // 2"

	^ tally >= 1013
%

category: 'testing'
method: HtInternalNode
isLeaf

	^ false
%

category: 'walker access'
method: HtInternalNode
lowestChildIndexForHash: targetHash
	"Where is the child pointer for my first child that could 
	have entries for the given hash?"

	| searchIndex foundHash |
	searchIndex := ((targetHash - lowestHash bitShift: preShift) * multiplier
		bitShift: postShift) bitOr: 1.
	foundHash := self at: searchIndex.
	foundHash < targetHash
		ifTrue: [ 
			| limit |
			"Search right"
			limit := self maxHashIndex.
			[ 
			searchIndex < limit
				and: [ 
					searchIndex := searchIndex + 2.
					foundHash := self at: searchIndex.
					foundHash < targetHash ] ] whileTrue: [  ].
			foundHash >= targetHash
				ifTrue: [ ^ searchIndex - 1 ].
			self error: 'Searching internal node for hash it cannot contain' ]
		ifFalse: [ 
			"Search left"
			[ 
			searchIndex > 1
				and: [ 
					searchIndex := searchIndex - 2.
					foundHash := self at: searchIndex.
					foundHash >= targetHash ] ] whileTrue: [  ].
			foundHash <= targetHash
				ifTrue: [ ^ searchIndex + 1 ].
			self error: 'Searching internal node for hash it cannot contain' ]
%

category: 'accessing'
method: HtInternalNode
lowestHash

	^ lowestHash
%

category: 'private-indexing'
method: HtInternalNode
maxChildIndex
	"Index for at: of the last child pointer I currently contain"

	^ tally * 2
%

category: 'private-indexing'
method: HtInternalNode
maxHashIndex
	"Index for at: of the last child pointer I currently contain"

	^ tally * 2 + 1
%

category: 'accessing'
method: HtInternalNode
objectSecurityPolicy: anObjectSecurityPolicy
	super objectSecurityPolicy: anObjectSecurityPolicy.
	2 to: tally * 2 do: [ :i | (self at: i) objectSecurityPolicy: anObjectSecurityPolicy ]
%

category: 'accessing'
method: HtInternalNode
percentFull

	^ tally * 100 // 1013
%

category: 'copying'
method: HtInternalNode
postCopyForCollection: coll
	2 to: tally * 2 by: 2 do: [ :i | self at: i put: ((self at: i) copyForCollection: coll) ]
%

category: 'walker access'
method: HtInternalNode
removeLeftwardChildAtIndex: childIndex
	"Remove the child at childIndex, and the key to its 'left' (lower index).
	Sender is responsible for ensuring that childIndex is valid and does not
	refer to the leftmost child (childIndex 2)."

	| lastIndex |
	tally := tally - 1.
	lastIndex := tally * 2 + 1.
	self
		replaceFrom: childIndex - 1
		to: lastIndex
		with: self
		startingAt: childIndex + 1.
	self
		at: lastIndex + 1 put: nil;
		at: lastIndex + 2 put: nil.
	self computeConstants
%

category: 'walker access'
method: HtInternalNode
removeRightwardChildAtIndex: childIndex
	"Remove the child at childIndex, and the key to its 'right' (higher index).
	Sender is responsible for ensuring that childIndex is valid and does not
	refer to the rightmost child (childIndex tally * 2)."

	| lastIndex |
	tally := tally - 1.
	lastIndex := tally * 2 + 1.
	self
		replaceFrom: childIndex
		to: lastIndex
		with: self
		startingAt: childIndex + 2.
	self
		at: lastIndex + 1 put: nil;
		at: lastIndex + 2 put: nil.
	self computeConstants
%

category: 'accessing'
method: HtInternalNode
soleChild
	^ self isDegenerate
		ifFalse: [ self error: 'I do not have a sole child.' ]
		ifTrue: [ self at: 2 ]
%

category: 'walker access'
method: HtInternalNode
split
	"Split into two equal-size nodes. The left-hand (lower hash) node will be me,
	and the right-hand node will be new. Answer the new node."

	| newNode firstHalfCount sharedHashIndex endIndex |
	newNode := self class forCollection: collection.
	firstHalfCount := tally bitShift: -1.

	sharedHashIndex := firstHalfCount * 2 + 1.
	endIndex := self maxHashIndex.

	newNode bulkCopyFrom: self startIndex: sharedHashIndex endIndex: endIndex.

	self clearFrom: sharedHashIndex + 1 to: endIndex.
	highestHash := self at: sharedHashIndex.
	tally := firstHalfCount.
	self computeConstants.
	^ newNode
%

category: 'accessing'
method: HtInternalNode
tally
	^tally
%

! Class implementation for 'HtDictionaryInternalNode'

!		Instance methods for 'HtDictionaryInternalNode'

category: 'enumerating'
method: HtDictionaryInternalNode
keysAndValuesDo: binaryBlock
	2 to: tally * 2 by: 2 do: [ :i | 
		| child |
		child := self at: i.
		child keysAndValuesDo: binaryBlock ]
%

! Class implementation for 'HtSetInternalNode'

!		Instance methods for 'HtSetInternalNode'

category: 'enumerating'
method: HtSetInternalNode
do: unaryBlock
	2 to: tally * 2 by: 2 do: [ :i | 
		| child |
		child := self at: i.
		child do: unaryBlock ]
%

! Class implementation for 'HtLeafNode'

!		Class methods for 'HtLeafNode'

category: 'instance creation'
classmethod: HtLeafNode
forCollection: coll lowestHash: lowestHash highestHash: highestHash
	^ (self new: self nodeBasicSize)
		initialize;
		collection: coll;
		lowestHash: lowestHash;
		highestHash: highestHash;
		yourself
%

category: 'instance creation'
classmethod: HtLeafNode
nodeBasicSize
	"To keep it in a page, limit is 2034 - self instSize
	For us, with seven named instvars, that is 2027."

	self subclassResponsibility
%

!		Instance methods for 'HtLeafNode'

category: 'walker access'
method: HtLeafNode
absorbLeftSibling: otherLeaf
	"Copy all elements in otherLeaf to myself.
	otherLeaf must be the sibling adjacent to my left
	(lower hash values).
	Sender is responsible for assuring that I have sufficient room.
	otherLeaf is about to be discarded, don't bother to remove
	elements from it."

	self copyElementsFrom: otherLeaf.
	lowestHash := otherLeaf lowestHash
%

category: 'walker access'
method: HtLeafNode
absorbRightSibling: otherLeaf
	"Copy all elements in otherLeaf to myself.
	otherLeaf must be the sibling adjacent to my right
	(higher hash values).
	Sender is responsible for assuring that I have sufficient room.
	otherLeaf is about to be discarded, don't bother to remove
	elements from it."

	self copyElementsFrom: otherLeaf.
	highestHash := otherLeaf highestHash
%

category: 'auditing'
method: HtLeafNode
auditOnto: stream for: aCollection lowestHash: parentLow highestHash: parentHigh
	" Things to check:
	Are the constant instvars holding the correct constants?
		arraySize
		fillLine
		tableSize
	collection identical to aCollection?
	highestHash and lowestHash equal to parent ones passed in?
	Scan indexed instvars
		Is each key where it should be?
		Is each nil key accompanied by a nil value?
		Is the total number of non-nil key slots equal to tally?
"

	| identifier pairCount |
	identifier := 'LeafNode ' , self asOop printString , ' '.

	self _isLarge
		ifTrue: [ 
			stream
				nextPutAll: identifier , 'is a large object, should fit in one page.';
				lf ].

	arraySize = 2026 & (tableSize = 1013) & (fillLine = 759)
		ifFalse: [ 
			stream
				nextPutAll:
						identifier
								,
									'one or more constants are incorrect. Expected: arraySize = 2026, tableSize = 1013, fillLine = 759. Actual: arraySize =  '
								, arraySize printString , ' tableSize = ' , tableSize printString
								, ' fillLine = ' , fillLine printString;
				lf ].

	collection == aCollection
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'collection is ' , collection printString , ' with oop '
								, collection asOop printString
								, ' should be the collection I belong to';
				lf ].

	highestHash = parentHigh
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'highestHash should be equal to parent hash of '
								, parentHigh printString , ' but is ' , highestHash printString;
				lf ].

	lowestHash = parentLow
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'lowestHash should be equal to parent hash of '
								, parentLow printString , ' but is ' , lowestHash printString;
				lf ].

	highestHash < lowestHash
		ifTrue: [ 
			stream
				nextPutAll:
						identifier , 'lowestHash ' , lowestHash printString
								, ' is greater than highestHash ' , highestHash printString;
				lf ].

	pairCount := 0.

	1 to: arraySize by: 2 do: [ :i | 
		| key value |
		key := self at: i.
		value := self at: i + 1.
		key
			ifNil: [ 
				value
					ifNotNil: [ 
						stream
							nextPutAll:
									identifier , 'nil key at index ' , i printString , ' has non-nil value '
											, value printString;
							lf ] ]
			ifNotNil: [ 
				| expectedIndex |
				pairCount := pairCount + 1.
				expectedIndex := self
					indexForKey: key
					withHash: (collection permutedHashOf: key).
				i = expectedIndex
					ifFalse: [ 
						stream
							nextPutAll:
									identifier , 'key at index ' , i printString , ' was expected to be at index '
											, expectedIndex printString;
							lf ] ] ].

	tally = pairCount
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'tally is ' , tally printString
								, ' but the number of keys found was ' , pairCount printString;
				lf ].

	^ pairCount
%

category: 'accessing'
method: HtLeafNode
collection: aCollection
	collection := aCollection
%

category: 'copying'
method: HtLeafNode
copyForCollection: aCollection
	| copy |
	copy := self shallowCopy.
	copy collection: aCollection.
	^ copy
%

category: 'accessing'
method: HtLeafNode
highestHash
	^highestHash
%

category: 'accessing'
method: HtLeafNode
highestHash: object
	highestHash := object
%

category: 'testing'
method: HtLeafNode
isDegenerate
	"A leaf node, if it is the root, is allowed to be completely empty."

	^ false
%

category: 'testing'
method: HtLeafNode
isFull

	^ tally >= fillLine
%

category: 'testing'
method: HtLeafNode
isLeaf

	^ true
%

category: 'accessing'
method: HtLeafNode
lowestHash

	^ lowestHash
%

category: 'accessing'
method: HtLeafNode
lowestHash: anObject

	lowestHash := anObject
%

category: 'accessing'
method: HtLeafNode
percentFull

	^ tally * 100 // fillLine
%

category: 'private'
method: HtLeafNode
replaceAllWith: aLeafNode
	"Destroy any contents I may have, and replace them with those of aLeafNode.
	This does not touch any of my named instvars except tally."

	tally := aLeafNode tally.
	self
		replaceFrom: 1
		to: arraySize
		with: aLeafNode
		startingAt: 1
%

category: 'accessing'
method: HtLeafNode
tally

	^ tally
%

! Class implementation for 'HtDictionaryLeafNode'

!		Class methods for 'HtDictionaryLeafNode'

category: 'instance creation'
classmethod: HtDictionaryLeafNode
nodeBasicSize
	"To keep it in a page, limit is 2034 - self instSize
	For us, with seven named instvars, that is 2027.
	And we have two slots per entry, so choose prime 1013
	entries.
	"

	^ 2026
%

!		Instance methods for 'HtDictionaryLeafNode'

category: 'walker access'
method: HtDictionaryLeafNode
addKey: key value: value atKeyIndex: index

	self at: index put: key;
		   at: index + 1 put: value.

	tally := tally + 1.
	collection incrementTally
%

category: 'private'
method: HtDictionaryLeafNode
atNewKey: newKey put: value
	"Key is never already present.
	Used during node split or join."

	| hash |
	hash := collection permutedHashOf: newKey.
	self atNewKey: newKey withHash: hash put: value
%

category: 'other leaf access'
method: HtDictionaryLeafNode
atNewKey: newKey withHash: hash put: value
	"Key is never already present.
	Used during node split or join.
	Sender is responsible for ensuring that 
	the key is not one I already contain,
	and that I have room for the new key."

	| keyIndex |
	keyIndex := self indexForKey: newKey withHash: hash.
	(self at: keyIndex) ifNotNil: [ self error: 'Unexpected duplicate key' ].
	self
		at: keyIndex put: newKey;
		at: keyIndex + 1 put: value.
	tally := tally + 1.
	tally > fillLine
		ifTrue: [ self error: 'Leaf node is too full.' ]
%

category: 'auditing'
method: HtDictionaryLeafNode
auditOnto: stream for: aCollection lowestHash: parentLow highestHash: parentHigh
	" Things to check:
	Are the constant instvars holding the correct constants?
		arraySize
		fillLine
		tableSize
	collection identical to aCollection?
	highestHash and lowestHash equal to parent ones passed in?
	Scan indexed instvars
		Is each key where it should be?
		Is each nil key accompanied by a nil value?
		Is the total number of non-nil key slots equal to tally?
"

	| identifier pairCount |
	identifier := 'LeafNode ' , self asOop printString , ' '.

	self _isLarge
		ifTrue: [ 
			stream
				nextPutAll: identifier , 'is a large object, should fit in one page.';
				lf ].

	arraySize = 2026 & (tableSize = 1013) & (fillLine = 759)
		ifFalse: [ 
			stream
				nextPutAll:
						identifier
								,
									'one or more constants are incorrect. Expected: arraySize = 2026, tableSize = 1013, fillLine = 759. Actual: arraySize =  '
								, arraySize printString , ' tableSize = ' , tableSize printString
								, ' fillLine = ' , fillLine printString;
				lf ].

	collection == aCollection
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'collection is ' , collection printString , ' with oop '
								, collection asOop printString
								, ' should be the collection I belong to';
				lf ].

	highestHash = parentHigh
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'highestHash should be equal to parent hash of '
								, parentHigh printString , ' but is ' , highestHash printString;
				lf ].

	lowestHash = parentLow
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'lowestHash should be equal to parent hash of '
								, parentLow printString , ' but is ' , lowestHash printString;
				lf ].

	highestHash < lowestHash
		ifTrue: [ 
			stream
				nextPutAll:
						identifier , 'lowestHash ' , lowestHash printString
								, ' is greater than highestHash ' , highestHash printString;
				lf ].

	pairCount := 0.

	1 to: arraySize by: 2 do: [ :i | 
		| key value |
		key := self at: i.
		value := self at: i + 1.
		key
			ifNil: [ 
				value
					ifNotNil: [ 
						stream
							nextPutAll:
									identifier , 'nil key at index ' , i printString , ' has non-nil value '
											, value printString;
							lf ] ]
			ifNotNil: [ 
				| expectedIndex |
				pairCount := pairCount + 1.
				expectedIndex := self
					indexForKey: key
					withHash: (collection permutedHashOf: key).
				i = expectedIndex
					ifFalse: [ 
						stream
							nextPutAll:
									identifier , 'key at index ' , i printString , ' was expected to be at index '
											, expectedIndex printString;
							lf ] ] ].

	tally = pairCount
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'tally is ' , tally printString
								, ' but the number of keys found was ' , pairCount printString;
				lf ].

	^ pairCount
%

category: 'walker access'
method: HtDictionaryLeafNode
copyElementsFrom: otherLeaf
	"Copy all elements in otherLeaf to myself.
	Sender is responsible for assuring that I have sufficient room.
	otherLeaf is about to be discarded, don't bother to remove
	elements from it."

	1 to: otherLeaf _basicSize by: 2 do: [ :i | 
		| key value |
		key := otherLeaf at: i.
		key
			ifNotNil: [ 
				value := otherLeaf at: i + 1.
				self atNewKey: key put: value ] ]
%

category: 'walker access'
method: HtDictionaryLeafNode
indexForKey: key withHash: hash
	"Answer basic index of either where the key is if present, or where it would be inserted if not."

	| currentIndex currentKey |
	currentIndex := hash \\ tableSize * 2 + 1.

	[ 
	currentKey := self at: currentIndex.
	currentKey == nil or: [ currentKey = key ] ]
		whileFalse: [ 
			currentIndex := currentIndex + 2.
			currentIndex > arraySize
				ifTrue: [ currentIndex := 1 ] ].
	^ currentIndex
%

category: 'initialization'
method: HtDictionaryLeafNode
initialize

	super initialize.
	tableSize := 1013.
	arraySize := tableSize * 2.
	fillLine := tableSize * 3 // 4.
	tally := 0
%

category: 'enumerating'
method: HtDictionaryLeafNode
keysAndValuesDo: binaryBlock
	1 to: arraySize by: 2 do: [ :i | 
		| key value |
		key := self at: i.
		key
			ifNotNil: [ 
				value := self at: i + 1.
				binaryBlock value: key value: value ] ]
%

category: 'private'
method: HtDictionaryLeafNode
loadHeap: heap
	heap assertEmpty.
	1 to: arraySize by: 2 do: [ :i | 
		| key |
		key := self at: i.
		key ~~ nil
			ifTrue: [ heap bulkAddHash: (collection permutedHashOf: key) index: i ] ].
	heap buildMinHeap
%

category: 'walker access'
method: HtDictionaryLeafNode
removeKeyAt: index
	| nilIndex currentIndex currentKey |
	self
		at: index put: nil;
		at: index + 1 put: nil.

	tally := tally - 1.
	collection decrementTally.
	nilIndex := currentIndex := index.
	[ 
	currentIndex := currentIndex + 2.
	currentIndex > arraySize
		ifTrue: [ currentIndex := 1 ].
	currentKey := self at: currentIndex.
	currentKey ~~ nil ]
		whileTrue: [ 
			| correctIndex |
			correctIndex := self
				indexForKey: currentKey
				withHash: (collection permutedHashOf: currentKey).
			correctIndex = currentIndex
				ifFalse: [ 
					self
						at: nilIndex put: (self at: currentIndex);
						at: nilIndex + 1 put: (self at: currentIndex + 1);
						at: currentIndex put: nil;
						at: currentIndex + 1 put: nil.
					nilIndex := currentIndex ] ]
%

category: 'walker access'
method: HtDictionaryLeafNode
split
	"Split into two nodes. The left-hand (lower hash) node will be me,
	and the right-hand node will be new. Answer the new node.
	This split is approximate, based on the assumption that the permuted hash
	values of my keys are approximately evenly distributed across the 
	non-negative SmallInteger range. This assumption usually holds,
	but can fail, especially if there are a large number of keys with
	the same hash value. If the split using this method is worse than
	3/4 to 1/4, fall back to the slower split that uses heap sort to 
	achieve a precise split."

	| scratchLeaf newLeaf scratchLeafCount medianHash minAcceptableCount maxAcceptableCount |
	scratchLeaf := collection scratchLeaf.
	scratchLeaf
		initialize;
		collection: collection.	"Might have dropped from memory since last use."

	medianHash := (lowestHash bitShift: -1) + (highestHash bitShift: -1).	"Assumes even distribution. Avoid creating large integers."
	newLeaf := self class
		forCollection: collection
		lowestHash: medianHash
		highestHash: highestHash.
	scratchLeafCount := 0.

	1 to: self size by: 2 do: [ :i | 
		| key value hash |
		key := self at: i.
		key ~~ nil
			ifTrue: [ 
				value := self at: i + 1.
				hash := collection permutedHashOf: key.
				hash <= medianHash
					ifTrue: [ 
						scratchLeafCount := scratchLeafCount + 1.
						scratchLeaf atNewKey: key withHash: hash put: value ]
					ifFalse: [ newLeaf atNewKey: key withHash: hash put: value ] ] ].
	minAcceptableCount := tally bitShift: -2.	"3/4-1/4 split is the most uneven acceptable."
	maxAcceptableCount := minAcceptableCount * 3.
	^ (scratchLeafCount < minAcceptableCount
		or: [ scratchLeafCount > maxAcceptableCount ])
		ifTrue: [ 
			scratchLeaf removeAll.
			self splitUsingHeap ]
		ifFalse: [ 
			self replaceAllWith: scratchLeaf.
			highestHash := medianHash.
			scratchLeaf removeAll.
			newLeaf ]
%

category: 'private'
method: HtDictionaryLeafNode
splitUsingHeap
	"Split into two equal-size nodes. The left-hand (lower hash) node will be me,
	and the right-hand node will be new. Answer the new node.
	This method uses a heap sort to be precise about splitting the node, so is
	slower than the approximate split that is usually used."

	| heap scratchLeaf newLeaf firstHalfCount secondHalfCount currentKey currentHash medianHash |
	heap := collection heap.
	heap initialize.	"Might have dropped from memory since last use."
	scratchLeaf := collection scratchLeaf.
	self loadHeap: heap.
	scratchLeaf
		initialize;
		collection: collection.	"Might have dropped from memory since last use."
	firstHalfCount := tally bitShift: -1.	"First half of my contents go to scratchLeaf"
	secondHalfCount := tally - firstHalfCount.
	firstHalfCount
		timesRepeat: [ 
			| keyIndex currentValue |
			currentHash := heap minKey.
			keyIndex := heap removeValueWithMinKey.
			currentKey := self at: keyIndex.
			currentValue := self at: keyIndex + 1.
			scratchLeaf atNewKey: currentKey withHash: currentHash put: currentValue ].
	medianHash := currentHash.
	newLeaf := self class
		forCollection: collection
		lowestHash: medianHash
		highestHash: highestHash.
	secondHalfCount
		timesRepeat: [ 
			| keyIndex currentValue |
			currentHash := heap minKey.
			keyIndex := heap removeValueWithMinKey.
			currentKey := self at: keyIndex.
			currentValue := self at: keyIndex + 1.
			newLeaf atNewKey: currentKey withHash: currentHash put: currentValue ].
	self replaceAllWith: scratchLeaf.
	highestHash := medianHash.
	scratchLeaf removeAll.
	^ newLeaf
%

! Class implementation for 'HtDictionaryScratchLeafNode'

!		Instance methods for 'HtDictionaryScratchLeafNode'

category: 'auditing'
method: HtDictionaryScratchLeafNode
auditEmptyOnto: stream for: aTreeDictionary
	"I'm dbTransient, so it is legit for all of my contents to be nil.
	But if non-nil, should be correct for having been sent #removeAll."

	| identifier |
	identifier := 'ScratchDictionaryLeafNode ' , self asOop printString , ' '.
	arraySize
		ifNotNil: [ 
			arraySize = 2026
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'arraySize is ' , arraySize printString , ', should be 2026';
						lf ] ].
	fillLine
		ifNotNil: [ 
			fillLine = 759
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'fillLine is ' , fillLine printString , ', should be 759';
						lf ] ].
	highestHash
		ifNotNil: [ 
			highestHash class == SmallInteger
				ifTrue: [ 
					highestHash negative
						ifTrue: [ 
							stream
								nextPutAll:
									identifier , 'highestHash should be non-negative, but is '
										, highestHash printString ] ]
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'highestHash should be a SmallInteger, but is of class '
										, highestHash class name;
						lf ] ].
	lowestHash
		ifNotNil: [ 
			lowestHash class == SmallInteger
				ifTrue: [ 
					lowestHash negative
						ifTrue: [ 
							stream
								nextPutAll:
									identifier , 'lowestHash should be non-negative, but is '
										, lowestHash printString ] ]
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'lowestHash should be a SmallInteger, but is of class '
										, lowestHash class name;
						lf ] ].
	tableSize
		ifNotNil: [ 
			tableSize = 1013
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'tableSize is ' , tableSize printString , ', should be 1013';
						lf ] ].

	tally
		ifNotNil: [ 
			tally = 0
				ifFalse: [ 
					stream
						nextPutAll: identifier , 'tally is ' , tally printString , ', should be 0';
						lf ] ].
	collection
		ifNotNil: [ 
			collection == aTreeDictionary
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'collection is ' , collection printString , ' with oop '
										, collection asOop printString
										, ' should be the TreeDictionary I belong to';
						lf ] ]
%

category: 'removing'
method: HtDictionaryScratchLeafNode
removeAll
	"Completely clear my contents so I'm ready to safely reuse."

  self fillFrom: 1 to: self size with: nil .
	tally := 0
%

! Class implementation for 'HtSetLeafNode'

!		Class methods for 'HtSetLeafNode'

category: 'instance creation'
classmethod: HtSetLeafNode
nodeBasicSize
	"To keep it in a page, limit is 2034 - self instSize
	For us, with seven named instvars, that is 2027.
	2027 is prime, so we'll use that as a table size.
	"

	^ 2027
%

!		Instance methods for 'HtSetLeafNode'

category: 'other leaf access'
method: HtSetLeafNode
add: newKey withHash: hash
	"Key is never already present.
	Used during node split or join.
	Sender is responsible for ensuring that 
	the key is not one I already contain,
	and that I have room for the new key."

	| keyIndex |
	keyIndex := self indexForKey: newKey withHash: hash.
	(self at: keyIndex) ifNotNil: [ self error: 'Unexpected duplicate key' ].
	self at: keyIndex put: newKey.
	tally := tally + 1.
	tally > fillLine
		ifTrue: [ self error: 'Leaf node is too full.' ]
%

category: 'walker access'
method: HtSetLeafNode
addKey: key atKeyIndex: index
	index > arraySize ifTrue: [self halt].
	self at: index put: key.
	tally := tally + 1.
	collection incrementTally
%

category: 'auditing'
method: HtSetLeafNode
auditOnto: stream for: aCollection lowestHash: parentLow highestHash: parentHigh
	" Things to check:
	Are the constant instvars holding the correct constants?
		arraySize
		fillLine
		tableSize
	collection identical to aCollection?
	highestHash and lowestHash equal to parent ones passed in?
	Scan indexed instvars
		Is each key where it should be?
		Is the total number of non-nil key slots equal to tally?
"

	| identifier keyCount |
	identifier := 'LeafNode ' , self asOop printString , ' '.

	self _isLarge
		ifTrue: [ 
			stream
				nextPutAll: identifier , 'is a large object, should fit in one page.';
				lf ].

	arraySize = 2027 & (tableSize = 2027) & (fillLine = 1520)
		ifFalse: [ 
			stream
				nextPutAll:
						identifier
								,
									'one or more constants are incorrect. Expected: arraySize = 2027, tableSize = 2027, fillLine = 1520. Actual: arraySize =  '
								, arraySize printString , ' tableSize = ' , tableSize printString
								, ' fillLine = ' , fillLine printString;
				lf ].

	collection == aCollection
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'collection is ' , collection printString , ' with oop '
								, collection asOop printString , ' should be the collection I belong to';
				lf ].

	highestHash = parentHigh
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'highestHash should be equal to parent hash of '
								, parentHigh printString , ' but is ' , highestHash printString;
				lf ].

	lowestHash = parentLow
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'lowestHash should be equal to parent hash of '
								, parentLow printString , ' but is ' , lowestHash printString;
				lf ].

	highestHash < lowestHash
		ifTrue: [ 
			stream
				nextPutAll:
						identifier , 'lowestHash ' , lowestHash printString
								, ' is greater than highestHash ' , highestHash printString;
				lf ].

	keyCount := 0.

	1 to: arraySize do: [ :i | 
		| key |
		key := self at: i.
		key
			ifNotNil: [ 
				| expectedIndex |
				keyCount := keyCount + 1.
				expectedIndex := self
					indexForKey: key
					withHash: (collection permutedHashOf: key).
				i = expectedIndex
					ifFalse: [ 
						stream
							nextPutAll:
									identifier , 'key at index ' , i printString , ' was expected to be at index '
											, expectedIndex printString;
							lf ] ] ].

	tally = keyCount
		ifFalse: [ 
			stream
				nextPutAll:
						identifier , 'tally is ' , tally printString
								, ' but the number of keys found was ' , keyCount printString;
				lf ].

	^ keyCount
%

category: 'walker access'
method: HtSetLeafNode
copyElementsFrom: otherLeaf
	"Copy all elements in otherLeaf to myself.
	Sender is responsible for assuring that I have sufficient room.
	otherLeaf is about to be discarded, don't bother to remove
	elements from it."

	1 to: otherLeaf _basicSize do: [ :i | 
		| key |
		key := otherLeaf at: i.
		key ifNotNil: [ self add: key withHash: (collection permutedHashOf: key) ] ]
%

category: 'enumerating'
method: HtSetLeafNode
do: unaryBlock
	1 to: arraySize do: [ :i | 
		| key |
		key := self at: i.
		key ifNotNil: [ unaryBlock value: key ] ]
%

category: 'walker access'
method: HtSetLeafNode
indexForKey: key withHash: hash
	"Answer basic index of either where the key is if present, or where it would be inserted if not."

	| currentIndex currentKey |
	currentIndex := hash \\ tableSize + 1.
	[ 
	currentKey := self at: currentIndex.
	currentKey == nil or: [ currentKey = key ] ]
		whileFalse: [ 
			currentIndex := currentIndex + 1.
			currentIndex > arraySize
				ifTrue: [ currentIndex := 1 ] ].
	^ currentIndex
%

category: 'initialization'
method: HtSetLeafNode
initialize

	super initialize.
	tableSize := arraySize := 2027.
	fillLine := tableSize * 3 // 4.
	tally := 0
%

category: 'private'
method: HtSetLeafNode
loadHeap: heap
	heap assertEmpty.
	1 to: arraySize do: [ :i | 
		| key |
		key := self at: i.
		key ~~ nil
			ifTrue: [ heap bulkAddHash: (collection permutedHashOf: key) index: i ] ].
	heap buildMinHeap
%

category: 'walker access'
method: HtSetLeafNode
removeKeyAt: index
	| nilIndex currentIndex currentKey |
	self at: index put: nil.
	tally := tally - 1.
	collection decrementTally.
	nilIndex := currentIndex := index.
	[ 
	currentIndex := currentIndex + 1.
	currentIndex > arraySize
		ifTrue: [ currentIndex := 1 ].
	currentKey := self at: currentIndex.
	currentKey ~~ nil ]
		whileTrue: [ 
			| correctIndex |
			correctIndex := self
				indexForKey: currentKey
				withHash: (collection permutedHashOf: currentKey).
			correctIndex = currentIndex
				ifFalse: [ 
					self
						at: nilIndex put: (self at: currentIndex);
						at: currentIndex put: nil.
					nilIndex := currentIndex ] ]
%

category: 'walker access'
method: HtSetLeafNode
split
	"Split into two nodes. The left-hand (lower hash) node will be me,
	and the right-hand node will be new. Answer the new node.
	This split is approximate, based on the assumption that the permuted hash
	values of my keys are approximately evenly distributed across the 
	non-negative SmallInteger range. This assumption usually holds,
	but can fail, especially if there are a large number of keys with
	the same hash value. If the split using this method is worse than
	3/4 to 1/4, fall back to the slower split that uses heap sort to 
	achieve a precise split."

	| scratchLeaf newLeaf scratchLeafCount medianHash minAcceptableCount maxAcceptableCount |
	scratchLeaf := collection scratchLeaf.
	scratchLeaf
		initialize;
		collection: collection.	"Might have dropped from memory since last use."

	medianHash := (lowestHash bitShift: -1) + (highestHash bitShift: -1).	"Assumes even distribution. Avoid creating large integers."
	newLeaf := self class
		forCollection: collection
		lowestHash: medianHash
		highestHash: highestHash.
	scratchLeafCount := 0.

	1 to: self size do: [ :i | 
		| key hash |
		key := self at: i.
		key ~~ nil
			ifTrue: [ 
				hash := collection permutedHashOf: key.
				hash <= medianHash
					ifTrue: [ 
						scratchLeafCount := scratchLeafCount + 1.
						scratchLeaf add: key withHash: hash ]
					ifFalse: [ newLeaf add: key withHash: hash ] ] ].
	minAcceptableCount := tally bitShift: -2.	"3/4-1/4 split is the most uneven acceptable."
	maxAcceptableCount := minAcceptableCount * 3.
	^ (scratchLeafCount < minAcceptableCount
		or: [ scratchLeafCount > maxAcceptableCount ])
		ifTrue: [ 
			scratchLeaf removeAll.
			self splitUsingHeap ]
		ifFalse: [ 
			self replaceAllWith: scratchLeaf.
			highestHash := medianHash.
			scratchLeaf removeAll.
			newLeaf ]
%

category: 'private'
method: HtSetLeafNode
splitUsingHeap
	"Split into two equal-size nodes. The left-hand (lower hash) node will be me,
	and the right-hand node will be new. Answer the new node.
	This method uses a heap sort to be precise about splitting the node, so is
	slower than the approximate split that is usually used."

	| heap scratchLeaf newLeaf firstHalfCount secondHalfCount currentKey currentHash medianHash |
	heap := collection heap.
	heap initialize.	"Might have dropped from memory since last use."
	scratchLeaf := collection scratchLeaf.
	self loadHeap: heap.
	scratchLeaf
		initialize;
		collection: collection.	"Might have dropped from memory since last use."
	firstHalfCount := tally bitShift: -1.	"First half of my contents go to scratchLeaf"
	secondHalfCount := tally - firstHalfCount.
	firstHalfCount
		timesRepeat: [ 
			| keyIndex |
			currentHash := heap minKey.
			keyIndex := heap removeValueWithMinKey.
			currentKey := self at: keyIndex.
			scratchLeaf add: currentKey withHash: currentHash ].
	medianHash := currentHash.
	newLeaf := self class
		forCollection: collection
		lowestHash: medianHash
		highestHash: highestHash.
	secondHalfCount
		timesRepeat: [ 
			| keyIndex |
			currentHash := heap minKey.
			keyIndex := heap removeValueWithMinKey.
			currentKey := self at: keyIndex.
			newLeaf add: currentKey withHash: currentHash ].
	self replaceAllWith: scratchLeaf.
	highestHash := medianHash.
	scratchLeaf removeAll.
	^ newLeaf
%

! Class implementation for 'HtSetScratchLeafNode'

!		Instance methods for 'HtSetScratchLeafNode'

category: 'auditing'
method: HtSetScratchLeafNode
auditEmptyOnto: stream for: aSetDictionary
	"I'm dbTransient, so it is legit for all of my contents to be nil.
	But if non-nil, should be correct for having been sent #removeAll."

	| identifier |
	identifier := 'ScratchSetLeafNode ' , self asOop printString , ' '.
	arraySize
		ifNotNil: [ 
			arraySize = 2027
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'arraySize is ' , arraySize printString , ', should be 2027';
						lf ] ].
	fillLine
		ifNotNil: [ 
			fillLine = 1520
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'fillLine is ' , fillLine printString , ', should be 1520';
						lf ] ].
	highestHash
		ifNotNil: [ 
			highestHash class == SmallInteger
				ifTrue: [ 
					highestHash negative
						ifTrue: [ 
							stream
								nextPutAll:
									identifier , 'highestHash should be non-negative, but is '
										, highestHash printString ] ]
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'highestHash should be a SmallInteger, but is of class '
										, highestHash class name;
						lf ] ].
	lowestHash
		ifNotNil: [ 
			lowestHash class == SmallInteger
				ifTrue: [ 
					lowestHash negative
						ifTrue: [ 
							stream
								nextPutAll:
									identifier , 'lowestHash should be non-negative, but is '
										, lowestHash printString ] ]
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'lowestHash should be a SmallInteger, but is of class '
										, lowestHash class name;
						lf ] ].
	tableSize
		ifNotNil: [ 
			tableSize = 2027
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'tableSize is ' , tableSize printString , ', should be 2027';
						lf ] ].

	tally
		ifNotNil: [ 
			tally = 0
				ifFalse: [ 
					stream
						nextPutAll: identifier , 'tally is ' , tally printString , ', should be 0';
						lf ] ].
	collection
		ifNotNil: [ 
			collection == aSetDictionary
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'collection is ' , collection printString , ' with oop '
										, collection asOop printString
										, ' should be the TreeSet I belong to';
						lf ] ]
%

category: 'removing'
method: HtSetScratchLeafNode
removeAll
	"Completely clear my contents so I'm ready to safely reuse."

  self fillFrom: 1 to: self size with: nil .
	tally := 0
%

! Class implementation for 'MappingInfo'

!		Instance methods for 'MappingInfo'

category: 'Accessing'
method: MappingInfo
dependencyList

"Returns the value of the instance variable 'dependencyList'."

^dependencyList
%

category: 'Updating'
method: MappingInfo
dependencyList: newValue

"Modify the value of the instance variable 'dependencyList'."

dependencyList := newValue
%

category: 'Accessing'
method: MappingInfo
ivOffset

"Returns the value of the instance variable 'ivOffset'."

^ivOffset
%

category: 'Updating'
method: MappingInfo
ivOffset: newValue

"Modify the value of the instance variable 'ivOffset'."

ivOffset := newValue
%

category: 'Accessing'
method: MappingInfo
object

"Returns the value of the instance variable 'object'."

^object
%

category: 'Updating'
method: MappingInfo
object: newValue

"Modify the value of the instance variable 'object'."

object := newValue
%

category: 'Accessing'
method: MappingInfo
pathTerm

"Returns the value of the instance variable 'pathTerm'."

^pathTerm
%

category: 'Updating'
method: MappingInfo
pathTerm: newValue

"Modify the value of the instance variable 'pathTerm'."

pathTerm := newValue
%

! Class implementation for 'SortBlockNode'

!		Class methods for 'SortBlockNode'

category: 'Constants'
classmethod: SortBlockNode
initialNumberOfElements

"Returns the number of entries that are allocated when a node is created."
^ 100
%

category: 'Instance Creation'
classmethod: SortBlockNode
new

"Returns a new initialized instance with the correct size."

| newOne |
newOne := self basicNew: (self entrySize * self initialNumberOfElements).
newOne numElements: 0.
newOne totalElements: 0.
^ newOne

%

category: 'Instance Creation'
classmethod: SortBlockNode
new: size

"Returns a new initialized instance with the correct size."

| newOne |
newOne := self basicNew: self entrySize * (size min: self maxNumberOfElements).
newOne numElements: 0.
newOne totalElements: 0.
^ newOne
%

category: 'Sorting Support'
classmethod: SortBlockNode
recalculateSelectionTree: sortNodeArray for: node offsets: offsets

"Recalculate the selection tree based on a change of the minimum entry
 in the given node."

| parent lChild rChild offset1 offset2 newOffset i j currNode |
currNode := node.

[ true ] whileTrue: [
    " get the parent of the node that has changed "
    parent := currNode at: 2.

    lChild := parent at: 3.
    rChild := parent at: 4.
    " get the offset in the receiver of the corresponding run "
    offset1 := lChild at: 1.
    offset2 := rChild at: 1.

    " check if either of the runs are now empty "
    i := offsets at: offset1.
    j := offsets at: offset2.
    i == nil
        ifTrue: [ newOffset := offset2 ]
        ifFalse: [
             j == nil
                 ifTrue: [ newOffset := offset1 ]
                 ifFalse: [
                     ( (sortNodeArray at: offset1)
                         _compareEntryAt: i
                         lessThanNode: (sortNodeArray at: offset2)
                         entryAt: j
                         useValue: true)
                         ifTrue: [ newOffset := offset1 ]
                         ifFalse: [ newOffset := offset2 ]
                 ]
        ].
    parent at: 1 put: newOffset.

    " if no parent, then this is the root "
    (parent at: 2) == nil
        ifTrue: [ ^ self ].

    currNode := parent
]
%

!		Instance methods for 'SortBlockNode'

category: 'Updating'
method: SortBlockNode
at: aKey put: aValue

"Adds the key/value pair to the node.  Sender must verify that the node is not
 full."

| index |
numElements == 0
  ifTrue: [ index := 1 ]
  ifFalse: [ index := self _binarySearchCoveringKey: aKey totalOrder: false ].

self _insertKey: aKey
  value: aValue
  atIndex: index.

totalElements := totalElements + 1
%

category: 'Accessing'
method: SortBlockNode
blockSorter

"Returns the value of the instance variable 'pathSorter'."

^blockSorter
%

category: 'Updating'
method: SortBlockNode
blockSorter: aBlockSorter

blockSorter := aBlockSorter
%

category: 'Constants'
method: SortBlockNode
entrySize

"Returns the size of an entry with no encryption."

^ 2
%

category: 'Testing'
method: SortBlockNode
isFull

"Returns if the node is full."

^ numElements == self class maxNumberOfElements
%

category: 'Sorting'
method: SortBlockNode
sortInto: anArray startingAt: index

"Insert the values of the receiver into the given Array starting at the
 given index in sorted order.  Returns the number inserted. "

| j obj snarray |
snarray := SortNodeArray.
        j := index.
        " for each value in the receiver ... "
        1 to: (numElements * self entrySize) by: self entrySize do: [ :i |
            " if it is an Array of nodes, then a merge sort is needed "
            (obj := self _at: i) class == snarray
                ifTrue: [
                    obj sortInto: anArray startingAt: j.
                    j := j + obj totalElements
                ]
                ifFalse: [
                    anArray at: j put: obj.
                    j := j + 1
                ].
        ].
        ^ j - index

%

category: 'Accessing'
method: SortBlockNode
totalElements

"Returns the value of the instance variable 'totalElements'."

^totalElements
%

category: 'Updating'
method: SortBlockNode
totalElements: anInteger

totalElements := anInteger
%

category: 'Updating'
method: SortBlockNode
_at: aKey put: aValue forBtree: aBool

"Adds the key/value pair to the node.  Sender must verify that the node is not
 full.  aBool should always be false."

^ self at: aKey put: aValue
%

category: 'Searching'
method: SortBlockNode
_binarySearchCoveringKey: aKey totalOrder: aBoolean

"Returns the index for the first entry in which aKey is found utilizing a
 binary search.  This is the first entry whose key >= aKey."

| lowPt midPt highPt entrySize index |

entrySize := self entrySize.
lowPt := 1.
highPt := numElements.
[ lowPt <= highPt ] whileTrue: [
    midPt := (lowPt + highPt) quo: 2.
    index := midPt - 1 * entrySize + 2.

    (self _compareKey: aKey lessThanEntryAt: index)
        ifTrue: [ highPt := midPt - 1 ]
        ifFalse: [ lowPt := midPt + 1 ]
].

(self _compareKey: aKey lessThanEntryAt: index)
    ifFalse: [ ^ index + entrySize - 1 ].

^ index - 1
%

category: 'Comparison Operators'
method: SortBlockNode
_compareEntryAt: index1
lessThanNode: aNode
entryAt: index2
useValue: aBoolean

"Perform a < comparison between the entries at the given indexes.
 The default implementation uses no encryption."

| o1 o2 blk |
" first compare the keys "
((blk := blockSorter sortBlock) value: (o1 := self _at: index1)
                               value: (o2 := aNode _at: index2))
   ifTrue: [ ^ true ]
   ifFalse: [
      " if using the values and keys are equal, use the OOP of the value "
      (blk value: o2  value: o1)
         ifFalse:[ ^ (self _at: index1 - 1) identityHash < (aNode _at: index2 - 1) identityHash ]
         ifTrue: [ ^ false ]
    ]
%

category: 'Comparison Operators'
method: SortBlockNode
_compareKey: aKey equalToEntryAt: index

^ ((self _compareKey: aKey lessThanEntryAt: index) == false )
    and:[ (self _compareKey: aKey greaterThanEntryAt: index) == false ]
%

category: 'Comparison Operators'
method: SortBlockNode
_compareKey: aKey greaterThanEntryAt: index

  ^ blockSorter sortBlock value: (self _at: index) value: aKey
%

category: 'Comparison Operators'
method: SortBlockNode
_compareKey: aKey lessThanEntryAt: index

  ^ blockSorter sortBlock value: aKey value: (self _at: index)
%

category: 'Updating'
method: SortBlockNode
_insertDuplicateKey: aKey value: aValue atIndex: insertionIndex
  "The given key is already present in the receiver, so insert the entry
 in a secondary sort node (creating it if necessary)."

  | val newNode sortArray |
  " get the existing value "
  val := self _at: insertionIndex.
  val class == SortNodeArray
    ifTrue: [
      " value is already sort nodes on the secondary sort path "
      blockSorter _addObject: aValue inNodes: val ]
    ifFalse: [
      " create sort node for the secondary sort path and put it in a sort Array "
      newNode := blockSorter sortNodeClassForSort
        new: self sizeForSecondarySorts.
      newNode blockSorter: blockSorter.
      sortArray := SortNodeArray with: newNode.
      self _basicAt: insertionIndex put: sortArray.
      blockSorter _addObject: aValue inNodes: sortArray.
      blockSorter _addObject: val inNodes: sortArray ]
%

category: 'Updating'
method: SortBlockNode
_insertKey: aKey
value: aValue
atIndex: insertionIndex

"Insert the key/value pair in the receiver.  The sender of this
 message must verify that the entry will fit in the receiver and
 provide the insertion index."

| lastIndex eSize |
lastIndex := self _lastIndex.
" see if there is more than one sort path remaining and if the given key
is already present in the receiver."
( insertionIndex < lastIndex and:
[ self _compareKey: aKey equalToEntryAt: insertionIndex + 1 ])
    ifTrue: [ " duplicate keys "
        ^ self _insertDuplicateKey: aKey value: aValue atIndex: insertionIndex
    ].

eSize := self entrySize .

"move entries down to make room for a new entry, or add room at the end"
self _insertAt: insertionIndex
     from: nil "insert nils" fromStart: 1 fromEnd: eSize
     numToMoveDown: (numElements * eSize) - insertionIndex + 1 .

" add the new entry "
super _basicAt: insertionIndex put: aValue.
super _basicAt: (insertionIndex + 1) put: aKey.

self _insertEncryptionFor: aKey value: aValue startingAt: (insertionIndex + 2).

numElements := numElements + 1
%

! Class implementation for 'SortBlockUnicodeNode'

!		Instance methods for 'SortBlockUnicodeNode'

category: 'Updating'
method: SortBlockUnicodeNode
blockSorter: aBlockSorter collator: anIcuCollator

blockSorter := aBlockSorter .
collator := anIcuCollator
%

category: 'Comparison Operators'
method: SortBlockUnicodeNode
_compareEntryAt: index1
lessThanNode: aNode
entryAt: index2
useValue: aBoolean

"Perform a < comparison between the entries at the given indexes.
 The default implementation uses no encryption."

| o1 o2 blk |
" first compare the keys "
((blk := blockSorter sortBlock) value: (o1 := self _at: index1)
                               value: (o2 := aNode _at: index2) value: collator)
   ifTrue: [ ^ true ]
   ifFalse: [
      " if using the values and keys are equal, use the OOP of the value "
      (blk value: o2  value: o1 value: collator )
        ifFalse: [ ^ (self _at: index1 - 1) identityHash < (aNode _at: index2 - 1) identityHash ]
        ifTrue: [ ^ false ]
     ]
%

category: 'Comparison Operators'
method: SortBlockUnicodeNode
_compareKey: aKey greaterThanEntryAt: index

  ^ blockSorter sortBlock value: (self _at: index) value: aKey value: collator
%

category: 'Comparison Operators'
method: SortBlockUnicodeNode
_compareKey: aKey lessThanEntryAt: index

  ^ blockSorter sortBlock value: aKey value: (self _at: index) value: collator
%

category: 'Updating'
method: SortBlockUnicodeNode
_insertDuplicateKey: aKey value: aValue atIndex: insertionIndex
  "The given key is already present in the receiver, so insert the entry
 in a secondary sort node (creating it if necessary)."

  | val newNode sortArray |
  " get the existing value "
  val := self _at: insertionIndex.
  val class == SortNodeArray
    ifTrue: [
      " value is already sort nodes on the secondary sort path "
      blockSorter _addObject: aValue inNodes: val ]
    ifFalse: [
      " create sort node for the secondary sort path and put it in a sort Array "
      newNode := blockSorter sortNodeClassForSort new: self sizeForSecondarySorts.
      newNode blockSorter: blockSorter collator: collator .
      sortArray := SortNodeArray with: newNode .
      self _basicAt: insertionIndex put: sortArray.
      blockSorter _addObject: aValue inNodes: sortArray.
      blockSorter _addObject: val inNodes: sortArray ]
%

! Class implementation for 'SoftCollisionBucket'

!		Class methods for 'SoftCollisionBucket'

category: 'Instance creation'
classmethod: SoftCollisionBucket
new

^ super new _initializeCleanup
%

!		Instance methods for 'SoftCollisionBucket'

category: 'Updating'
method: SoftCollisionBucket
at: aKey put: aValue

"disallowed, should use  at:put:keyValDict_coll:  "

self shouldNotImplement: #at:put:
%

category: 'Updating'
method: SoftCollisionBucket
at: aKey put: aValue keyValDict_coll: aKeyValDict

"Stores the aKey/aValue pair in the receiver.
 Returns self size if this at:put: added a new key, 0 if this at:put:
 replaced a SoftReference for an existing  key .

 aValue is expected to be a SoftReference.

 Also removes key/SoftReference pairs whose SoftReference has been
 cleared by the garbage collector."

| startElem nElem |
self _cleanupReferences: false .
startElem := numElements .
super at: aKey put: aValue keyValDict_coll: aKeyValDict .
startElem < (nElem := numElements) ifTrue:[ ^ nElem ] ifFalse:[ ^ 0 ].
%

category: 'Cleanup'
method: SoftCollisionBucket
cleanupReferences
  ^ self _cleanupReferences: true
%

category: 'Accessing'
method: SoftCollisionBucket
referenceAt: aKey ifAbsent: aBlock

"Returns the non-cleared SoftReference that corresponds to aKey.
 If no such key/SoftRef pair exists,
 returns the result of evaluating the zero-argument block aBlock."

  | keyIndex index aSoftRef |
  keyIndex := self searchForKey: aKey.
  keyIndex ifNotNil: [
    index := (keyIndex + keyIndex) - 1 .
    aSoftRef:=  self _referenceAt: index .
    aSoftRef ifNil:[ ^ self _reportKeyNotFound: aKey with: aBlock ] .
    ^ aSoftRef
  ].
  ^ self _reportKeyNotFound: aKey with: aBlock
%

category: 'Accessing'
method: SoftCollisionBucket
referenceAt: aKey otherwise: aValue

"Returns the non-cleared SoftReference that corresponds to aKey.
 If no such key/SoftRef pair exists, returns aValue ."

  | index keyIndex aSoftRef |
  keyIndex := self searchForKey: aKey.
  keyIndex ifNotNil:[
    index := (keyIndex + keyIndex) - 1 .
    aSoftRef :=  self _referenceAt: index .
    aSoftRef ifNil:[ ^ aValue ].
    ^ aSoftRef
  ].
  ^ aValue
%

category: 'Removing'
method: SoftCollisionBucket
removeKey: aKey ifAbsent: aBlock

"Removes the key/value pair having the key aKey.  If aKey is not found,
 returns the result of evaluating the zero-argument block aBlock.

 Also removes key/SoftReference pairs whose SoftReference has been
 cleared by the garbage collector."

| res |
res := super removeKey: aKey ifAbsent: aBlock .
self _cleanupReferences: true .
^ res
%

category: 'Removing'
method: SoftCollisionBucket
removeKey: aKey otherwise: notFoundValue

"Removes the key/value pair having the key aKey.  If aKey is not found,
 returns the notFoundValue .

 Also removes key/SoftReference pairs whose SoftReference has been
 cleared by the garbage collector."

| res |
res := super removeKey: aKey otherwise: notFoundValue  .
self _cleanupReferences: true .
^ res
%

category: 'Cleanup'
method: SoftCollisionBucket
_cleanupReferences: okToRemoveBucket

"remove key/SoftReference pairs whose SoftReferences have
 been cleared by the garbage collector."
| currCount |
currCount := self _markSweepsThatClearedSoftRefsCount .
currCount == lastCleanupCount ifFalse:[ | nElem firstKey startNumElem |
  startNumElem := (nElem := numElements) .
  1 to: self tableSize do: [:keyIdx | | aRef idx aKey |
    idx := (keyIdx + keyIdx) - 1 .
    aKey := self _at: idx .
    aKey ifNotNil:[
      aRef := self _at: idx + 1 .
      aRef _value ifNil:[
        firstKey ifNil:[ firstKey := aKey ].
        self _at: idx     put: nil . "remove key"
        self _at: idx + 1 put: nil . "remove SoftRef"
        nElem := nElem - 1 .
        nElem < 0 ifTrue:[ nil error:'underflow1' ].
        numElements := nElem .
      ].
    ].
  ].
  lastCleanupCount := currCount .
  nElem == startNumElem ifFalse:[
    firstKey ifNil:[ self error:'nil firstKey in cleanupReferences' ].
    keyValueDictionary _bucketSizeChangeFrom: startNumElem to: nElem
			key: firstKey bucket: self remove: okToRemoveBucket
  ].
].
%

category: 'Private'
method: SoftCollisionBucket
_initializeCleanup

  lastCleanupCount := 0
%

category: 'Private'
method: SoftCollisionBucket
_markSweepsThatClearedSoftRefsCount

"Returns OM.markSweepsThatClearedSoftRefsCount as a positive SmallInteger"

<primitive: 553>

self _primitiveFailed: #_markSweepsThatClearedSoftRefsCount
%

category: 'Private'
method: SoftCollisionBucket
_referenceAt: idx

" for the key stored at offset idx ,
  return the SofReference if softRef.value non-nil, otherwise
  remove the soft reference and associated key .
"
| aSoftRef val |
aSoftRef := self _at: idx + 1 .
aSoftRef ifNotNil:[
  val := aSoftRef _value .
  val ifNil:[ | oldN n aKey |
    aKey := self _at: idx .
    self _at: idx     put: nil . "remove key"
    self _at: idx + 1 put: nil . "remove SoftRef"
    oldN := numElements.
    n := oldN - 1 .
    n < 0 ifTrue:[ nil error:'numElements underflow in a SoftCollisionBucket'].
    numElements := n .
    keyValueDictionary _bucketSizeChangeFrom: oldN to: n key: aKey
		bucket: self remove: false .
    ^ nil .
  ].
  ^ aSoftRef
].
^ nil
%

! Class implementation for 'GciLegacyError'

!		Class methods for 'GciLegacyError'

category: 'signalling'
classmethod: GciLegacyError
signal: anErrorDescription in: aLegacyExternalSession

	self new
		signal: anErrorDescription
		in: aLegacyExternalSession.
%

!		Instance methods for 'GciLegacyError'

category: 'accessing'
method: GciLegacyError
actualExceptionClassOr: aBlock
	"Answer the class of the actual exception if there is one,
	 or the result of evaluating aBlock if not."

	| actualCls |
	actualCls := (LegacyErrNumMap atOrNil: self number ) ifNotNil: [ :a | a atOrNil: 1].
	^actualCls ifNil: aBlock
%

category: 'accessing'
method: GciLegacyError
category

	^errorDescription category.
%

category: 'other'
method: GciLegacyError
clearStack

	externalSession clearStackFor: errorDescription.
%

category: 'accessing'
method: GciLegacyError
context

	^errorDescription context.
%

category: 'other'
method: GciLegacyError
continue
	"Continue code execution in GemStone after an error.
	See GciContinue() in the GemBuilder for C manual for details."

	^externalSession
		continue: errorDescription context
		replacingTopOfStackWithOop: nil.
%

category: 'other'
method: GciLegacyError
continueWith: anObject
	"This function is a variant of the continue method, except
	that it allows you to modify the call stack before attempting
	to continue the suspended Smalltalk execution.
	See GciContinueWith() in the GemBuilder for C manual for details."

	^externalSession
		continue: errorDescription context
		replacingTopOfStackWithOop: anObject asOop.
%

category: 'accessing'
method: GciLegacyError
externalErrorNumber

	^errorDescription number.
%

category: 'accessing'
method: GciLegacyError
externalSession

	^externalSession.
%

category: 'testing'
method: GciLegacyError
matchesClasses: expClass
	"expClass is either a Class or an Array of Classes"

	| actualCls |
	actualCls := self actualExceptionClassOr: [^false].
	expClass _isArray
		ifTrue: [^expClass anySatisfy: [:aCls | actualCls isSubclassOf: aCls]]
		ifFalse: [^actualCls isSubclassOf: expClass]
%

category: 'accessing'
method: GciLegacyError
originalNumber
  ^ originalNumber
%

category: 'signalling'
method: GciLegacyError
signal: anErrorDescription in: aLegacyExternalSession

	errorDescription := anErrorDescription.
	externalSession := aLegacyExternalSession.
	(originalNumber := errorDescription number) == 1001 ifTrue: [^self signalCompileError].
	messageText := errorDescription message.
	"avoid killing current session with fatal errors"
	(originalNumber between: 4000 and: 4999) ifTrue: [
		messageText add: ' original number: ' , originalNumber asString.
		"and self number is inherited value 2710"
	] ifFalse: [
		self _number: originalNumber.
	].
	"self stack ifNotNil: [:stack | messageText lf ; add: stack]."
	self details: messageText.
	self signal.
%

category: 'signalling'
method: GciLegacyError
signalCompileError

	gsArgs := errorDescription asArray.
	"gsArgs size: gciErrSType argCount.
	gsArgs := gsArgs collect: [:each |
		externalSession valueOfOop: each toLevel: 4.
	]."
	messageText := errorDescription message.
	self details: messageText.
	self signal.
%

category: 'accessing'
method: GciLegacyError
stack
  errorDescription ifNil:[ ^ nil ].
  errorDescription contextOop == nil asOop ifTrue: [^nil].
  originalNumber >= 4000 ifTrue:[ ^ nil ].
  ^ [ externalSession _getStackForOop: errorDescription contextOop 
    ] on: Error do:[ 'stack not available' ].
%

! Class implementation for 'GsSecureSocket'

!		Class methods for 'GsSecureSocket'

category: 'Examples'
classmethod: GsSecureSocket
anonymousTlsClientExample: logToGciClient usingPort: portNum on: host

| sslClient data dataBuffer |

"Anonymous TLS means encrypting data over the socket connection without verifying
 the client or the server's identity. Because identities are not verified, certificates 
 are not required to establish a connection.

 WARNING: anonymous TLS connections are exposed to man-in-the-middle attacks and 
 are therefore NOT recommended for most applications."

"Setup a normal socket connection first."

"Create a new SSL client socket"
sslClient:= self newClient.

[ | failBlock bytesRead dataLength gotEof |

  failBlock := [:sock :shouldLog| | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do:[:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Now connect to the server to get a normal socket connection.
   On error, close the socket and pass to the next exception handler."
  (sslClient connectTo: portNum on: host timeoutMs: 3000)
    ifTrue:[ GsFile gciLog: 'regular socket connect completed OK.'
                    onClient: logToGciClient ] .

  "uncomment next line to put the socket in blocking mode."
  "sslClient makeBlocking."

  "Enable all ciphers that do not require authentication. 
	-ALL - remove all ciphers from the list but allow adding back later.
	aNULL - all ciphers that do not require authentication.
	@STRENGTH - sort ciphers by strength.
	@SECLEVEL=0 - enable low security ciphers. Required to use ciphers that do not authenticate."
  (sslClient setCipherListFromString: '-ALL:aNULL:@STRENGTH:@SECLEVEL=0')
    ifFalse:[ GsFile gciLog: 'setCipherListFromString: failed'
                    onClient: logToGciClient
    ].

  "Attempt to establish a secure connection to the SSL server..."
  ([sslClient secureConnect]
    on: SocketError
    do:[:ex| |sslError|
      GsFile gciLog: 'secureConnect failed' onClient: logToGciClient.
      sslError := sslClient fetchLastIoErrorString .
      sslError ifNil: [
         GsFile gciLog: 'nil result from fetchLastIoErrorString'
                onClient: logToGciClient
          ] ifNotNil: [
          GsFile gciLog: ('SSL error: =>' , sslError) onClient: logToGciClient].
	  ex pass.
    ])
    ifTrue:[ GsFile gciLog: 'Secure connection established'
                    onClient: logToGciClient].


  "We have a secure connection to the server if we get here."
  GsFile gciLog: ('Current cipher in use is: ', sslClient fetchCipherDescription)
         onClient: logToGciClient.

  "Read length from the client"
  GsFile gciLog: 'Starting read' onClient: logToGciClient.

  dataLength := sslClient read: 8.
  (dataLength == nil or: [dataLength size < 8])
       ifTrue: [GsFile gciLog: 'read of 8 bytes of length failed'
  				onClient: logToGciClient .
  	     		failBlock value: sslClient value: logToGciClient]
       ifFalse: [GsFile gciLog: 'read 8 bytes of length, encoded ', dataLength
  				onClient: logToGciClient].
  dataLength := Integer fromHexString: dataLength.
  GsFile gciLog: 'Data length should be ', dataLength asString
  	onClient: logToGciClient.

  dataBuffer := String new.
  gotEof := false .
  [(dataBuffer size < (dataLength + 10)) and:[ gotEof not]] whileTrue: [
     bytesRead := sslClient read: 16272 into: dataBuffer startingAt: dataBuffer size + 1.
     bytesRead ifNil:[
       GsFile gciLog: 'read failed' onClient: logToGciClient .
              failBlock value: sslClient  value: logToGciClient
     ] ifNotNil:[
        bytesRead == 0 ifTrue:[ gotEof := true ]
          ifFalse:[ GsFile gciLog: 'Read ', bytesRead asString, ' bytes from peer.'
                    onClient: logToGciClient ].
     ].
  ].
  gotEof ifFalse:[
    GsFile gciLog: 'did not get EOF' onClient: logToGciClient.
    failBlock value: sslClient value: logToGciClient.
  ].
  dataBuffer size ~= dataLength ifTrue: [
    GsFile gciLog: 'Read failed ' onClient: logToGciClient.
    failBlock value: sslClient value: logToGciClient.
  ].
  GsFile gciLog: 'Finished reading, read ', dataBuffer size asString, ' bytes from peer'
  	onClient: logToGciClient .

] on: SocketError do:[:ex| sslClient close. ex pass ].

sslClient close.

data := (PassiveObject newWithContents: dataBuffer) activate.
GsFile gciLog: 'Result is ', data class asString, ' of size ', data size asString
     onClient: logToGciClient.
^true
%

category: 'Examples'
classmethod: GsSecureSocket
anonymousTlsServerExample: logToGciClient usingPort: portNum on: host


"Anonymous TLS means encrypting data over the socket connection without verifying
 the client or the server's identity. Because identities are not verified, certificates 
 are not required to establish a connection.

 WARNING: anonymous TLS connections are exposed to man-in-the-middle attacks and 
 are therefore NOT recommended for most applications."

| listener sslServer |

[
  | failBlock bigStr result data dataSizeString |

  failBlock := [:sock :shouldLog | | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do: [:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Create a new SSL server socket."
  listener := self newServer.

  "Make it listen for the client."
  (listener makeServerAtPort: portNum) ifNil: [ | err |
  	err := listener lastErrorString.
  	listener close.
  	SocketError signal: 'makeServerAtPort failed, ', err asString.
   ].

  listener port == portNum ifFalse:[ SocketError signal: 'bad port number ', listener port asString ] .

  GsFile gciLog: 'Waiting for GsSecureSocket clientExample to connect...'
  	onClient: logToGciClient .
  [listener readWillNotBlockWithin: 5000] whileFalse: [
  	GsFile gciLog: 'waiting...' onClient: logToGciClient
    	].

  GsFile gciLog: 'Client connected.' onClient: logToGciClient .

  "Do the normal accept to establish a standard socket connection."
  "sslServer is our connection to the client."
  sslServer := listener accept .

  GsFile gciLog: 'Normal accept completed OK.' onClient: logToGciClient .

  "uncomment next to put the socket in blocking mode."
  "sslServer makeBlocking."

  "sslServer has only a normal connection to the peer.  If will have a secure
   connection if secureAccept succeeds."


  "Enable all ciphers that do not require authentication. 
	-ALL - remove all ciphers from the list but allow adding back later.
	aNULL - all ciphers that do not require authentication.
	@STRENGTH - sort ciphers by strength.
	@SECLEVEL=0 - enable low security ciphers. Required to use ciphers that do not authenticate."

  (sslServer setCipherListFromString: '-ALL:aNULL:@STRENGTH:@SECLEVEL=0')
    ifFalse:[ GsFile gciLog: 'setCipherListFromString: failed'  onClient: logToGciClient  ].

  ([sslServer secureAccept] on: SocketError do:[:ex| | sslError |
    GsFile gciLog: 'secureAccept failed.'  onClient: logToGciClient.
    sslError := sslServer fetchLastIoErrorString .
    sslError ifNil: [
        GsFile gciLog: 'nil result from fetchLastIoErrorString'  onClient: logToGciClient
    ] ifNotNil:[
        GsFile gciLog: ('SSL error: =>' , sslError)
           onClient: logToGciClient.].
	ex pass
    ])
      ifTrue:[ GsFile gciLog: 'Secure connection established.'
                      onClient: logToGciClient ].

  "If we get here, we have a secure connection to the client."

  GsFile gciLog: ('Current cipher in use is: ', sslServer fetchCipherDescription)
         onClient: logToGciClient.

  "Build data to send"
  data := Array new.
  4096 timesRepeat: [ data add: (String withAll: '0123456789ABCDEF') ].
  bigStr := String new .
  PassiveObject passivate: data toStream: (WriteStream on: bigStr).
  dataSizeString := bigStr size asHexStringWithLength: 8.
  dataSizeString size > 8 ifTrue:
      [UserDefinedError signal: 'Protocol Error, attempt to send more than 4294967295 bytes'].

  GsFile gciLog: 'Sending data length to client: ', bigStr size asString,
      ' bytes, encoded as ', dataSizeString onClient: logToGciClient.

  result := sslServer write: dataSizeString.
  result == dataSizeString size
    ifTrue: [ GsFile gciLog: 'Finished sending length to peer'
  		onClient: logToGciClient ]
    ifFalse: [ GsFile gciLog: 'write of length bytes failed, result was ', result asString
                  onClient: logToGciClient .
              failBlock value: sslServer value: logToGciClient.
  		].

  GsFile gciLog: 'Sending ', bigStr size asString, ' bytes to client'
         onClient: logToGciClient.
  result := sslServer write: bigStr .
  result == bigStr size
    ifTrue:[ GsFile gciLog: ('Finished sending ', bigStr size asString, ' bytes to peer')
                     onClient: logToGciClient ]
    ifFalse:[ GsFile gciLog: ('write failed, result was ', result asString)
                     onClient: logToGciClient .
              failBlock value: sslServer value: logToGciClient.
              ].
] on: SocketError do:[:ex|
        sslServer ifNotNil:[ sslServer close ].
        listener ifNotNil:[ listener close ].
        ex pass
].

"close method will close the SSL connection and underlying socket."
sslServer close.
listener close .
^ true
%

category: 'Instance Creation'
classmethod: GsSecureSocket
basicNew

"disallowed"

self shouldNotImplement: #basicNew
%

category: 'Querying'
classmethod: GsSecureSocket
certificateVerificationEnabledOnClient

"Answer true if certificate verification is enabled for client sockets.
 Otherwise answer false."

^ self _zeroArgSslPrim: 22
%

category: 'Querying'
classmethod: GsSecureSocket
certificateVerificationEnabledOnServer

"Answer true if certificate verification is enabled for server sockets.
 Otherwise answer false."

^ self _zeroArgSslPrim: 23
%

category: 'Error Handling'
classmethod: GsSecureSocket
clearErrorQueue

"Clears all errors from the error queue for all GsSecureSocket instances.
 Returns the receiver."

^ self _zeroArgSslPrim: 7
%

category: 'Examples'
classmethod: GsSecureSocket
clientExample

"Setup socket using class methods"
^ self clientExample: true usingPort: 57785 on: 'localhost'
%

category: 'Examples'
classmethod: GsSecureSocket
clientExample2

"Setup socket using instances methods"
^ self clientExample2: true usingPort: 57785 on: 'localhost'
%

category: 'Examples'
classmethod: GsSecureSocket
clientExample2: logToGciClient usingPort: portNum on: host

"This version uses GsSecureSocket instance methods for setup rather
 than class methods."

| sslClient data dataBuffer |


"Create an new SSL client socket"
sslClient:= self newClient.

[ | failBlock bytesRead dataLength gotEof |

  failBlock := [:sock :shouldLog| | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do:[:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Specify the file which contains a list of trusted CA certificates.
   These will be used to validate the certificate presented by the peer
   during the SSL handshake.  The file must be in PEM format.
   Currently, there is no easy way to specify the CA list from a String.
   This must be done before creating the instance of GsSecureSocket! "
  GsSecureSocket useCACertificateFileForClients:
        '$GEMSTONE/examples/openssl/certs/cacert.pem'.

  "Connect to the server to get a normal socket connection.
   On error, close the socket and pass to the next exception handler."
  (sslClient connectTo: portNum on: host timeoutMs: 3000)
    ifTrue:[ GsFile gciLog: 'regular socket connect completed OK.'
                    onClient: logToGciClient ] .

  "uncomment next line to put the socket in blocking mode."
  "sslClient makeBlocking."

  "Tell SSL that this SSL client is to drop the connection unless
   the certificate presented by the server is authenticated."
  sslClient enableCertificateVerification .

  "Set the cipher list for this SSL socket only.
   Use all ciphers except NULL ciphers and anonymous Diffie-Hellman
   and sort by strength."
  sslClient setCipherListFromString: 'ALL:!ADH:@STRENGTH'.

  "Attempt to establish a secure connection to the SSL server..."
  ([sslClient secureConnect]
    on: SocketError
    do:[:ex| |certError|
      GsFile gciLog: 'secureConnect failed' onClient: logToGciClient.
      certError := GsSecureSocket fetchLastCertificateVerificationErrorForClient .
      certError ifNil: [
         GsFile gciLog: 'nil result from fetchLastCertificateVerificationErrorForClient'
                onClient: logToGciClient
          ] ifNotNil: [
          GsFile gciLog: ('Cert error: =>' , certError) onClient: logToGciClient].
      ex pass.
    ])
    ifTrue:[ GsFile gciLog: 'Secure connection established'
                    onClient: logToGciClient].

  "We have a secure connection to the server if we get here."
  GsFile gciLog: ('Current cipher in use is: ', sslClient fetchCipherDescription)
         onClient: logToGciClient.

  "Read length from the client"
  GsFile gciLog: 'Starting read' onClient: logToGciClient.

  dataLength := sslClient read: 8.
  (dataLength == nil or: [dataLength size < 8])
       ifTrue: [GsFile gciLog: 'read of 8 bytes of length failed'
  				onClient: logToGciClient .
  	     		failBlock value: sslClient value: logToGciClient]
       ifFalse: [GsFile gciLog: 'read 8 bytes of length, encoded ', dataLength
  				onClient: logToGciClient].
  dataLength := Integer fromHexString: dataLength.
  GsFile gciLog: 'Data length should be ', dataLength asString
  	onClient: logToGciClient.

  dataBuffer := String new.
  gotEof := false .
  [(dataBuffer size < (dataLength + 10)) and:[ gotEof not]] whileTrue: [
     bytesRead := sslClient read: 16272 into: dataBuffer startingAt: dataBuffer size + 1.
     bytesRead ifNil:[
       GsFile gciLog: 'read failed' onClient: logToGciClient .
              failBlock value: sslClient  value: logToGciClient
     ] ifNotNil:[
        bytesRead == 0 ifTrue:[ gotEof := true ]
          ifFalse:[ GsFile gciLog: 'Read ', bytesRead asString, ' bytes from peer.'
                    onClient: logToGciClient ].
     ].
  ].
  gotEof ifFalse:[
    GsFile gciLog: 'did not get EOF' onClient: logToGciClient.
    failBlock value: sslClient value: logToGciClient.
  ].
  dataBuffer size ~= dataLength ifTrue: [
    GsFile gciLog: 'Read failed ' onClient: logToGciClient.
    failBlock value: sslClient value: logToGciClient.
  ].
  GsFile gciLog: 'Finished reading, read ', dataBuffer size asString, ' bytes from peer'
  	onClient: logToGciClient .

] on: SocketError do:[:ex| sslClient close. ex pass ].

sslClient close.

data := (PassiveObject newWithContents: dataBuffer) activate.
GsFile gciLog: 'Result is ', data class asString, ' of size ', data size asString
     onClient: logToGciClient.
^true
%

category: 'Examples'
classmethod: GsSecureSocket
clientExample: logToGciClient usingPort: portNum on: host

| sslClient data dataBuffer |

"Setup a normal socket connection first."

"Create an new SSL client socket"
sslClient:= self newClient.

[ | failBlock bytesRead dataLength gotEof |

  failBlock := [:sock :shouldLog| | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do:[:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Now connect to the server to get a normal socket connection.
   On error, close the socket and pass to the next exception handler."
  (sslClient connectTo: portNum on: host timeoutMs: 3000)
    ifTrue:[ GsFile gciLog: 'regular socket connect completed OK.'
                    onClient: logToGciClient ] .

  "uncomment next line to put the socket in blocking mode."
  "sslClient makeBlocking."

  "Specify the file which contains a list of trusted CA certificates.
   These will be used to validate the certificate presented by the peer
   during the SSL handshake.  The file must be in PEM format."
  GsSecureSocket useCACertificateFileForClients:
        '$GEMSTONE/examples/openssl/certs/cacert.pem'.

  "Tell SSL that all clients are to drop the connection unless
   the certificate presented by the server is authenticated."
  GsSecureSocket enableCertificateVerificationOnClient .

  "Set the cipher list for client SSL sockets.
   Use all ciphers except NULL ciphers and anonymous Diffie-Hellman
   and sort by strength."
  (GsSecureSocket setClientCipherListFromString: 'ALL:!ADH:@STRENGTH')
    ifFalse:[ GsFile gciLog: 'setClientCipherListFromString: failed'
                    onClient: logToGciClient
    ].

  "Attempt to establish a secure connection to the SSL server..."
  ([sslClient secureConnect]
    on: SocketError
    do:[:ex| |certError|
      GsFile gciLog: 'secureConnect failed' onClient: logToGciClient.
      certError := GsSecureSocket fetchLastCertificateVerificationErrorForClient .
      certError ifNil: [
         GsFile gciLog: 'nil result from fetchLastCertificateVerificationErrorForClient'
                onClient: logToGciClient
          ] ifNotNil: [
          GsFile gciLog: ('Cert error: =>' , certError) onClient: logToGciClient].
	  ex pass.
    ])
    ifTrue:[ GsFile gciLog: 'Secure connection established'
                    onClient: logToGciClient].


  "We have a secure connection to the server if we get here."
  GsFile gciLog: ('Current cipher in use is: ', sslClient fetchCipherDescription)
         onClient: logToGciClient.

  "Read length from the client"
  GsFile gciLog: 'Starting read' onClient: logToGciClient.

  dataLength := sslClient read: 8.
  (dataLength == nil or: [dataLength size < 8])
       ifTrue: [GsFile gciLog: 'read of 8 bytes of length failed'
  				onClient: logToGciClient .
  	     		failBlock value: sslClient value: logToGciClient]
       ifFalse: [GsFile gciLog: 'read 8 bytes of length, encoded ', dataLength
  				onClient: logToGciClient].
  dataLength := Integer fromHexString: dataLength.
  GsFile gciLog: 'Data length should be ', dataLength asString
  	onClient: logToGciClient.

  dataBuffer := String new.
  gotEof := false .
  [(dataBuffer size < (dataLength + 10)) and:[ gotEof not]] whileTrue: [
     bytesRead := sslClient read: 16272 into: dataBuffer startingAt: dataBuffer size + 1.
     bytesRead ifNil:[
       GsFile gciLog: 'read failed' onClient: logToGciClient .
              failBlock value: sslClient  value: logToGciClient
     ] ifNotNil:[
        bytesRead == 0 ifTrue:[ gotEof := true ]
          ifFalse:[ GsFile gciLog: 'Read ', bytesRead asString, ' bytes from peer.'
                    onClient: logToGciClient ].
     ].
  ].
  gotEof ifFalse:[
    GsFile gciLog: 'did not get EOF' onClient: logToGciClient.
    failBlock value: sslClient value: logToGciClient.
  ].
  dataBuffer size ~= dataLength ifTrue: [
    GsFile gciLog: 'Read failed ' onClient: logToGciClient.
    failBlock value: sslClient value: logToGciClient.
  ].
  GsFile gciLog: 'Finished reading, read ', dataBuffer size asString, ' bytes from peer'
  	onClient: logToGciClient .

] on: SocketError do:[:ex| sslClient close. ex pass ].

sslClient close.

data := (PassiveObject newWithContents: dataBuffer) activate.
GsFile gciLog: 'Result is ', data class asString, ' of size ', data size asString
     onClient: logToGciClient.
^true
%

category: 'Peer Authentication'
classmethod: GsSecureSocket
disableCertificateVerificationOnClient
"Directs new client sockets ignore invalid server certificates.  The connection
 will not fail if the server certificate is found to be invalid.

 The client always requests a certificate from the server.  By default,
 the connection will fail if the certificate from the server is invalid.

 The effect is valid for the current session only;
 the affected SSL state is not committed to the repository.

 Has no effect on instances created before the method was called.

 Returns the receiver."

^ self _zeroArgSslPrim: 8
%

category: 'Peer Authentication'
classmethod: GsSecureSocket
disableCertificateVerificationOnServer
"Directs server sockets to not request a certificate from the client.
 This is the default mode for server sockets.

 The effect is valid for the current session only;
 the affected SSL state is not committed to the repository.

 Has no effect on instances created before the method was called.

 Returns the receiver."

^ self _zeroArgSslPrim: 10
%

category: 'Peer Authentication'
classmethod: GsSecureSocket
enableCertificateVerificationOnClient
"Directs client sockets to verify the certificate from the server.
 The connection will fail if the server does not provide a valid
 certificate to the client.

 The client always requests a certificate from the server.

 This is the default mode for client sockets.

 The effect is valid for the current session only;
 the affected SSL state is not committed to the repository.

 Has no effect on instances created before the method was called.

 Returns the receiver."

^ self _zeroArgSslPrim: 9
%

category: 'Peer Authentication'
classmethod: GsSecureSocket
enableCertificateVerificationOnServer
"Directs server sockets to request and verify a certificate from the client.
 The connection will fail if the client does not provide a certificate or
 the certificate is found to be invalid.

 The effect is valid for the current session only;
 the affected SSL state is not committed to the repository.

 Has no effect on instances created before the method was called.

 By default, servers do not request certificates from clients.

 Returns the receiver."

^ self _zeroArgSslPrim: 11
%

category: 'Querying'
classmethod: GsSecureSocket
fetchCertificateVerificationOptionsForServer

"Answers an Array of Symbols which represent the certificate verification
 options used by server sockets.

 The supported server options are:

 #SSL_VERIFY_FAIL_IF_NO_PEER_CERT
    if the client did not return a certificate, the TLS/SSL handshake is
    immediately terminated with a 'handshake failure' alert.

 #SSL_VERIFY_CLIENT_ONCE
    only request a client certificate on the initial TLS/SSL handshake.
    Do not ask for a client certificate again in case of a renegotiation.

 Refer to the OpenSSL documentation for more information about these options."

^ self _zeroArgSslPrim: 25
%

category: 'Error Handling'
classmethod: GsSecureSocket
fetchErrorStringArray

"Returns an Array of error strings generated by the OpenSSL package.
 The errors returned are cleared from the SSL error queue.  The array
 is ordered from oldest to newest error."

^ self _zeroArgSslPrim: 6
%

category: 'Error Handling'
classmethod: GsSecureSocket
fetchLastCertificateVerificationErrorForClient

"Fetches and clears a string representing the last certificate verification
 error logged by a client SSL socket.  Returns nil if no such error has
 occurred."

^ self _zeroArgSslPrim: 15
%

category: 'Error Handling'
classmethod: GsSecureSocket
fetchLastCertificateVerificationErrorForServer

"Fetches and clears a string representing the last certificate verification
 error logged by a server SSL socket.  Returns nil if no such error has
 occurred."

^ self _zeroArgSslPrim: 14
%

category: 'Examples'
classmethod: GsSecureSocket
getPasswordFromFile: aString
| gsf result |

gsf := GsFile openReadOnServer: aString .
gsf ifNil:[ SocketError signal: ('Could not open password file ', aString) ] .
result := gsf nextLine trimWhiteSpace .
gsf close.
 ^ result
%

category: 'Examples'
classmethod: GsSecureSocket
httpsClientExample

"Connect to the google https web server on port 443 in blocking mode and
 perform a simple GET request.  Full verification of the server certificate
 is performed.  Returns true on success"

^ self httpsClientExampleForHost: 'www.google.com'
       withSniName: 'google.com'
       blocking: true
%

category: 'Examples'
classmethod: GsSecureSocket
httpsClientExampleForHost: hostName withSniName: sniName

  ^ self  httpsClientExampleForHost: hostName withSniName: sniName blocking: true
%

category: 'Examples'
classmethod: GsSecureSocket
httpsClientExampleForHost: hostName withSniName: sniName blocking: bool

"Connect to an https web server on port 443 at the given host and
 perform a simple GET request.  Full verification of the server certificate
 is performed.  Self-signed certificates will fail verification."

| sslClient sni |

[
  | failBlock portNum logToGciClient request bytesSent responseString caCert |
  
  portNum := 443. "https port"
  logToGciClient := true.
  failBlock := [:sock :shouldLog| | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do:[:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].
  
  "Specify the file or directory which contains a list of trusted CA certificates.
   These will be used to validate the certificate presented by the peer
   during the SSL handshake.  The files in the directory must be in PEM
   format and the file names must be the hash value of the CA subject name.
   See https://www.openssl.org/docs/man1.0.2/ssl/SSL_CTX_load_verify_locations.html
   for more information.
  
   The file or directory must be specified before creating the instance of GsSecureSocket."
  
  caCert := GsSecureSocket setCaCertLocation .
  caCert ifNil:[  GsFile gciLog:
                     'Warning: Unable to find CA cert file on this host. Disabling cert verification'
		     onClient: false ]
       ifNotNil:[ GsFile gciLog: ('Using CA cert file ', caCert) onClient: false ].
       
  
  "Create an new SSL client socket"
  sslClient:= self newClient.
  
  "Now connect to the server to get a normal socket connection."
  sslClient connectTo: portNum on: hostName timeoutMs: 3000 .

  "Put the socket in the requested blocking mode."
  bool ifTrue:[  sslClient makeBlocking ] ifFalse:[ sslClient makeNonBlocking ].
  
  "Tell SSL that this SSL client is to drop the connection unless
   the certificate presented by the server is authenticated."
  sslClient enableCertificateVerification .
  
  "Set the cipher list for this SSL socket only.
   Use all ciphers except NULL ciphers and anonymous Diffie-Hellman
   and sort by strength."
  sslClient setCipherListFromString: 'ALL:!ADH:@STRENGTH' .
  
  "If we have an SNI hostname, set it now"
  sniName ifNotNil:[ (sslClient setServerNameIndication: sniName)
                        ifFalse:[sslClient signalError: 'Error setting SNI hostname']
  	] .
  sni := sslClient getServerNameIndication .
  GsFile gciLog: ('sni name returned by getServerNameIndication is ', sni asString)
         onClient: false .
  
  "Attempt to establish a secure connection to the SSL server..."
  ([sslClient secureConnect]
    on: SocketError
    do:[:ex| |certError|
      GsFile gciLog: 'secureConnect failed' onClient: logToGciClient.
      certError := GsSecureSocket fetchLastCertificateVerificationErrorForClient .
      certError ifNil: [  
         GsFile gciLog: 'nil result from fetchLastCertificateVerificationErrorForClient' 
                onClient: logToGciClient
          ] ifNotNil: [
          GsFile gciLog: ('Cert error: =>' , certError) onClient: logToGciClient].
	  ex pass.
    ])
    ifTrue:[ GsFile gciLog: 'Secure connection established'
                    onClient: logToGciClient].

  "We have a secure connection to the server if we get here."
  
  "Get the cipher used and print it"
  GsFile gciLog: ('Current cipher in use is: ', sslClient fetchCipherDescription)
         onClient: logToGciClient.
  
  "Build a simple http 1.1 GET request string.  Terminate with a blank line"
  request := String withAll: 'GET / HTTP/1.1'.
  request add: Character cr ;
          add: Character lf ;
  	addAll: 'Host: ';
  	addAll: hostName ;
          add: Character cr ;
          add: Character lf ;
          add: Character cr ;
  	add: Character lf.
  
  GsFile gciLog: 'Sending a ', request size asString, ' byte request to client: '
       onClient: logToGciClient.
  GsFile gciLog: request onClient: logToGciClient.
  
  "Send the GET request to the web server"
  bytesSent := sslClient write: request.
  bytesSent == request size
    ifTrue: [ GsFile gciLog: 'Finished sending request to peer' 
  		onClient: logToGciClient ]
    ifFalse: [ GsFile gciLog: 'write of request failed, result was ', bytesSent asString,
    ' expected ', request size asString
                  onClient: logToGciClient .
              failBlock value: sslClient value: logToGciClient.
  ].
  
  "Get the response from the web server and print it"
  GsFile gciLog: 'Waiting for response from server...' onClient: logToGciClient.
  responseString := sslClient read: 2048 .
  GsFile gciLog: 'Finished reading ', responseString size asString, ' bytes from server.'
  		onClient: logToGciClient.
  GsFile gciLog: responseString onClient: logToGciClient.

] on: SocketError do:[:ex|
   sslClient ifNotNil:[ sslClient close ].
   ex pass
].   
"All done! Close the connection and return"
sslClient close.
^true
%

category: 'Examples'
classmethod: GsSecureSocket
httpsClientExampleNB

"Connect to the google https web server on port 443 in nonblocking mode and
 perform a simple GET request.  Full verification of the server certificate
 is performed.  Returns true on success"

^ self httpsClientExampleForHost: 'www.google.com'
       withSniName: 'google.com'
       blocking: false
%

category: 'Examples'
classmethod: GsSecureSocket
httpsSniClientExample

"Example to connect to a webserver that requires SNI in blocking mode.
 Not using SNI (server name == nil) will fail to connect.

 Returns true on success"

^ self httpsClientExampleForHost: 'chrismeller.com'
       withSniName: 'chrismeller.com'
       blocking: true
%

category: 'Examples'
classmethod: GsSecureSocket
httpsSniClientExampleNB

"Example to connect to a webserver that requires SNI in nonblocking mode. 
 Not using SNI (server name == nil) will fail to connect.

 Returns true on success"

^ self httpsClientExampleForHost: 'chrismeller.com'
       withSniName: 'chrismeller.com'
       blocking: false
%

category: 'Error Handling'
classmethod: GsSecureSocket
lastErrorString

  "Provided for compatibility with GsSocket.
   Returns a string describing the elements in the SSL error queue,
   and clears that queue.  Returns nil if no error is available"

| arr str |
arr := self fetchErrorStringArray .
arr size > 0 ifTrue:[
  str := String new .
  1 to: arr size do:[:j | str add: (arr at: j); add: '; ' ].
] ifFalse:[
  str := super lastErrorString .
].
^ str
%

category: 'Instance Creation'
classmethod: GsSecureSocket
new
  self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: GsSecureSocket
new: aSize
  self shouldNotImplement: #new:
%

category: 'Instance Creation'
classmethod: GsSecureSocket
newClient

"Creates a new instance and initializes it to act as a AF_INET client socket.
 No connection is made."

^ super new initializeAsClient
%

category: 'Instance Creation'
classmethod: GsSecureSocket
newClientFromGsSocket: aGsSocket

"Creates a new instance and initializes it to act as an SSL client socket.
 Any existing (non-SSL) connection owned by aGsSocket is transferred to the
 new instance and aGsSocket is effectively closed. No SSL connection is made."

^ super new initializeAsClientFromGsSocket: aGsSocket
%

category: 'Instance Creation'
classmethod: GsSecureSocket
newClientIpv6

"Creates a new instance and initializes it to act as a AF_INET6 client socket.
 No connection is made."

^ super newIpv6 initializeAsClient
%

category: 'Instance Creation'
classmethod: GsSecureSocket
newClientIpv6FromGsSocket: aGsSocket

"Creates a new IPv6 instance and initializes it to act as an SSL client socket.
 Any existing (non-SSL) connection owned by a GsSocket is transferred to the
 new instance and aGsSocket is effectively closed. No SSL connection is made."

^ super newIpv6 initializeAsClientFromGsSocket: aGsSocket
%

category: 'Instance Creation'
classmethod: GsSecureSocket
newServer

"Creates a new instance and initializes it to act as a AF_INET server socket.
 No connection is made."

^ super new initializeAsServer
%

category: 'Instance Creation'
classmethod: GsSecureSocket
newServerFromGsSocket: aGsSocket

"Creates a new instance and initializes it to act as an SSL server socket.
 Any existing (non-SSL) connection owned by aGsSocket is transferred to the
 new instance and aGsSocket is effectively closed. No SSL connection is made."

^ super new initializeAsServerFromGsSocket: aGsSocket
%

category: 'Instance Creation'
classmethod: GsSecureSocket
newServerIpv6

"Creates a new instance and initializes it to act as a AF_INET6 server socket.
 No connection is made."

^ super newIpv6 initializeAsServer
%

category: 'Instance Creation'
classmethod: GsSecureSocket
newServerIpv6FromGsSocket: aGsSocket

"Creates a new IPv6 instance and initializes it to act as an SSL server socket.
 Any existing (non-SSL) connection owned by a GsSocket is transferred to the
 new instance and aGsSocket is effectively closed. No SSL connection is made."

^ super newIpv6 initializeAsServerFromGsSocket: aGsSocket
%

category: 'Examples'
classmethod: GsSecureSocket
preSharedKeyTlsClientExample: logToGciClient usingPort: portNum on: host

| sslClient data dataBuffer psk |

"Pre-shared key transport layer security (PSK-TLS) requires the client and server
to both know a pre-shared secret key before the connection is initiated. The key
must be at least 8 bytes in size (16 hex digits) and be stored in a ByteArray. 
logToGciClient true: trace output goes to client (topaz console), false: output goes to 
server (linked topaz console or gem log file).
"

"Setup a normal socket connection first."

"Create a new SSL client socket"
sslClient:= self newClient.

[ | failBlock bytesRead dataLength gotEof |

  failBlock := [:sock :shouldLog| | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do:[:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Now connect to the server to get a normal socket connection.
   On error, close the socket and pass to the next exception handler."
  (sslClient connectTo: portNum on: host timeoutMs: 3000)
    ifTrue:[ GsFile gciLog: 'regular socket connect completed OK.'
                    onClient: logToGciClient ] .

  "uncomment next line to put the socket in blocking mode."
  "sslClient makeBlocking."

  "Enable all PSK ciphers.
	-ALL - remove all ciphers from the list but allow adding back later.
	PSK - all PSK ciphers.
	@STRENGTH - sort ciphers by strength."
  (sslClient setCipherListFromString: '-ALL:PSK:@STRENGTH')
    ifFalse:[ GsFile gciLog: 'setCipherListFromString: failed'
                    onClient: logToGciClient
    ].

  "Psk must be a ByteArray containing at least 8 bytes and with size a multiple of 8"
  "PSK used by client/server must exactly match."
  psk := ByteArray fromHexString: 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'.
  "Set the PSK for this connection."
  sslClient setPreSharedKey: psk.

  "Attempt to establish a secure connection to the SSL server..."
  ([sslClient secureConnect]
    on: SocketError
    do:[:ex| |sslError|
      GsFile gciLog: 'secureConnect failed' onClient: logToGciClient.
      sslError := sslClient fetchLastIoErrorString .
      sslError ifNil: [
         GsFile gciLog: 'nil result from fetchLastIoErrorString'
                onClient: logToGciClient
          ] ifNotNil: [
          GsFile gciLog: ('SSL error: =>' , sslError) onClient: logToGciClient].
	  ex pass.
    ])
    ifTrue:[ GsFile gciLog: 'Secure connection established'
                    onClient: logToGciClient].

  "We have a secure connection to the server if we get here."

  "Clear PSK from memory"
  sslClient setPreSharedKey: nil.
  
  GsFile gciLog: ('Current cipher in use is: ', sslClient fetchCipherDescription)
         onClient: logToGciClient.

  "Read length from the client"
  GsFile gciLog: 'Starting read' onClient: logToGciClient.

  dataLength := sslClient read: 8.
  (dataLength == nil or: [dataLength size < 8])
       ifTrue: [GsFile gciLog: 'read of 8 bytes of length failed'
  				onClient: logToGciClient .
  	     		failBlock value: sslClient value: logToGciClient]
       ifFalse: [GsFile gciLog: 'read 8 bytes of length, encoded ', dataLength
  				onClient: logToGciClient].
  dataLength := Integer fromHexString: dataLength.
  GsFile gciLog: 'Data length should be ', dataLength asString
  	onClient: logToGciClient.

  dataBuffer := String new.
  gotEof := false .
  [(dataBuffer size < (dataLength + 10)) and:[ gotEof not]] whileTrue: [
     bytesRead := sslClient read: 16272 into: dataBuffer startingAt: dataBuffer size + 1.
     bytesRead ifNil:[
       GsFile gciLog: 'read failed' onClient: logToGciClient .
              failBlock value: sslClient  value: logToGciClient
     ] ifNotNil:[
        bytesRead == 0 ifTrue:[ gotEof := true ]
          ifFalse:[ GsFile gciLog: 'Read ', bytesRead asString, ' bytes from peer.'
                    onClient: logToGciClient ].
     ].
  ].
  gotEof ifFalse:[
    GsFile gciLog: 'did not get EOF' onClient: logToGciClient.
    failBlock value: sslClient value: logToGciClient.
  ].
  dataBuffer size ~= dataLength ifTrue: [
    GsFile gciLog: 'Read failed ' onClient: logToGciClient.
    failBlock value: sslClient value: logToGciClient.
  ].
  GsFile gciLog: 'Finished reading, read ', dataBuffer size asString, ' bytes from peer'
  	onClient: logToGciClient .

] on: SocketError do:[:ex| sslClient close. ex pass ].

sslClient close.

data := (PassiveObject newWithContents: dataBuffer) activate.
GsFile gciLog: 'Result is ', data class asString, ' of size ', data size asString
     onClient: logToGciClient.
^true
%

category: 'Examples'
classmethod: GsSecureSocket
preSharedKeyTlsServerExample: logToGciClient usingPort: portNum on: host

"Pre-shared key transport layer security (PSK-TLS) requires the client and server
to both know a pre-shared secret key before the connection is initiated. The key
must be at least 8 bytes in size (16 hex digits) and be stored in a ByteArray. 
logToGciClient true: trace output goes to client (topaz console), false: output goes to 
server (linked topaz console or gem log file).
"

| listener sslServer psk |

[
  | failBlock bigStr result data dataSizeString |

  failBlock := [:sock :shouldLog | | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do: [:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Create a new SSL server socket."
  listener := self newServer.

  "Make it listen for the client."
  (listener makeServerAtPort: portNum) ifNil: [ | err |
  	err := listener lastErrorString.
  	listener close.
  	SocketError signal: 'makeServerAtPort failed, ', err asString.
   ].

  listener port == portNum ifFalse:[ SocketError signal: 'bad port number ', listener port asString ] .

  GsFile gciLog: 'Waiting for GsSecureSocket pskClientExample to connect...'
  	onClient: logToGciClient .
  [listener readWillNotBlockWithin: 5000] whileFalse: [
  	GsFile gciLog: 'waiting...' onClient: logToGciClient
    	].

  GsFile gciLog: 'Client connected.' onClient: logToGciClient .

  "Do the normal accept to establish a standard socket connection."
  sslServer := listener accept .

  GsFile gciLog: 'Normal accept completed OK.' onClient: logToGciClient .

  "uncomment next to put the socket in blocking mode."
  "sslServer makeBlocking."

  "Don't request a certificate from the client."
  sslServer disableCertificateVerification.

  "sslServer has only a normal connection to the peer.  If will have a secure
   connection if secureAccept succeeds."

  "Enable all PSK ciphers.
	-ALL - remove all ciphers from the list but allow adding back later.
	PSK - all PSK ciphers.
	@STRENGTH - sort ciphers by strength."
  (sslServer setCipherListFromString: '-ALL:PSK:@STRENGTH')
    ifFalse:[ GsFile gciLog: 'setCipherListFromString: failed'
                    onClient: logToGciClient
    ].

  "PSK must be a ByteArray containing at least 8 bytes and with size a multiple of 8"
  psk := ByteArray fromHexString: 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa'.
  "Set the PSK for this connection."
  sslServer setPreSharedKey: psk.

  ([sslServer secureAccept] on: SocketError do:[:ex| | certError |
    GsFile gciLog: 'secureAccept failed.'  onClient: logToGciClient.
    certError := sslServer class fetchLastCertificateVerificationErrorForServer .
    certError ifNil: [
        GsFile gciLog: 'nil result from fetchLastCertificateVerificationErrorForServer'
           onClient: logToGciClient
    ] ifNotNil:[
        GsFile gciLog: ('Cert error: =>' , certError)
           onClient: logToGciClient.].
	ex pass
    ])
      ifTrue:[ GsFile gciLog: 'Secure connection established.'
                      onClient: logToGciClient ].

  "If we get here, we have a secure connection to the client."

  "Clear PSK from memory"
  sslServer setPreSharedKey: nil.
  
  GsFile gciLog: ('Current cipher in use is: ', sslServer fetchCipherDescription)
         onClient: logToGciClient.

  "Build data to send"
  data := Array new.
  4096 timesRepeat: [ data add: (String withAll: '0123456789ABCDEF') ].
  bigStr := String new .
  PassiveObject passivate: data toStream: (WriteStream on: bigStr).
  dataSizeString := bigStr size asHexStringWithLength: 8.
  dataSizeString size > 8 ifTrue:
      [UserDefinedError signal: 'Protocol Error, attempt to send more than 4294967295 bytes'].

  GsFile gciLog: 'Sending data length to client: ', bigStr size asString,
      ' bytes, encoded as ', dataSizeString onClient: logToGciClient.

  result := sslServer write: dataSizeString.
  result == dataSizeString size
    ifTrue: [ GsFile gciLog: 'Finished sending length to peer'
  		onClient: logToGciClient ]
    ifFalse: [ GsFile gciLog: 'write of length bytes failed, result was ', result asString
                  onClient: logToGciClient .
              failBlock value: sslServer value: logToGciClient.
  		].

  GsFile gciLog: 'Sending ', bigStr size asString, ' bytes to client'
         onClient: logToGciClient.
  result := sslServer write: bigStr .
  result == bigStr size
    ifTrue:[ GsFile gciLog: ('Finished sending ', bigStr size asString, ' bytes to peer')
                     onClient: logToGciClient ]
    ifFalse:[ GsFile gciLog: ('write failed, result was ', result asString)
                     onClient: logToGciClient .
              failBlock value: sslServer value: logToGciClient.
              ].
] on: SocketError do:[:ex|
        sslServer ifNotNil:[ sslServer close ].
        listener ifNotNil:[ listener close ].
        ex pass
].

"close method will close the SSL connection and underlying socket."
sslServer close.
listener close .
^ true
%

category: 'Examples'
classmethod: GsSecureSocket
serverExample

^ self serverExample: true usingPort: 57785 on: 'localhost'
%

category: 'Examples'
classmethod: GsSecureSocket
serverExample2

^ self serverExample2: true usingPort: 57785 on: 'localhost'
%

category: 'Examples'
classmethod: GsSecureSocket
serverExample2: logToGciClient usingPort: portNum on: host

"This version uses GsSecureSocket instance methods for setup rather
 than class methods."

| listener sslServer pw |

[
  | failBlock bigStr result data dataSizeString |

  failBlock := [:sock :shouldLog | | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do: [:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Create a new SSL server socket."
  listener := self newServer.

  "Make it listen for the client."
  (listener makeServerAtPort: portNum) ifNil: [ | err |
  	err := listener lastErrorString.
  	listener close.
  	SocketError signal: 'makeServerAtPort failed, ', err asString.
   ].

  listener port == portNum ifFalse:[ SocketError signal: 'bad port number ', listener port asString ] .

  GsFile gciLog: 'Waiting for GsSecureSocket clientExample to connect...'
  	onClient: logToGciClient .
  [listener readWillNotBlockWithin: 5000] whileFalse: [
  	GsFile gciLog: 'waiting...' onClient: logToGciClient
    	].

  GsFile gciLog: 'Client connected.' onClient: logToGciClient .

  "Do the normal accept to establish a standard socket connection."
  "sslServer is our connection to the client."
  sslServer := listener accept .

  GsFile gciLog: 'Normal accept completed OK.' onClient: logToGciClient .

  "uncomment next to put the socket in blocking mode."
  "sslServer makeBlocking."

  "Don't request a certificate from the client.  This is typical."
  sslServer disableCertificateVerification.

  "sslServer has only a normal connection to the peer.  If will have a secure
   connection if secureAccept succeeds."

  "Example of using an encrypted private key that requires a passphrase."
   pw := self getPasswordFromFile: '$GEMSTONE/examples/openssl/private/server_1_server_passwd.txt' .
   sslServer useCertificateFile: '$GEMSTONE/examples/openssl/certs/server_1_servercert.pem'
    withPrivateKeyFile: '$GEMSTONE/examples/openssl/private/server_1_serverkey.pem'
    privateKeyPassphrase: pw.

  "Use all ciphers except NULL ciphers and anonymous Diffie-Hellman
   and sort by strength."
  sslServer setCipherListFromString: 'ALL:!ADH:@STRENGTH' .

  ([sslServer secureAccept] on: SocketError do:[:ex| | certError |
    GsFile gciLog: 'secureAccept failed.'  onClient: logToGciClient.
    certError := sslServer class fetchLastCertificateVerificationErrorForServer .
    certError ifNil: [
        GsFile gciLog: 'nil result from fetchLastCertificateVerificationErrorForServer'
           onClient: logToGciClient
    ] ifNotNil:[
        GsFile gciLog: ('Cert error: =>' , certError)
           onClient: logToGciClient.].
	ex pass
    ])
      ifTrue:[ GsFile gciLog: 'Secure connection established.'
                      onClient: logToGciClient ].

  "If we get here, we have a secure connection to the client."

  GsFile gciLog: ('Current cipher in use is: ', sslServer fetchCipherDescription)
         onClient: logToGciClient.

  "Build data to send"
  data := Array new.
  4096 timesRepeat: [ data add: (String withAll: '0123456789ABCDEF') ].
  bigStr := String new .
  PassiveObject passivate: data toStream: (WriteStream on: bigStr).
  dataSizeString := bigStr size asHexStringWithLength: 8.
  dataSizeString size > 8 ifTrue:
      [UserDefinedError signal: 'Protocol Error, attempt to send more than 4294967295 bytes'].

  GsFile gciLog: 'Sending data length to client: ', bigStr size asString,
      ' bytes, encoded as ', dataSizeString onClient: logToGciClient.

  result := sslServer write: dataSizeString.
  result == dataSizeString size
    ifTrue: [ GsFile gciLog: 'Finished sending length to peer'
  		onClient: logToGciClient ]
    ifFalse: [ GsFile gciLog: 'write of length bytes failed, result was ', result asString
                  onClient: logToGciClient .
              failBlock value: sslServer value: logToGciClient.
  		].

  GsFile gciLog: 'Sending ', bigStr size asString, ' bytes to client'
         onClient: logToGciClient.
  result := sslServer write: bigStr .
  result == bigStr size
    ifTrue:[ GsFile gciLog: ('Finished sending ', bigStr size asString, ' bytes to peer')
                     onClient: logToGciClient ]
    ifFalse:[ GsFile gciLog: ('write failed, result was ', result asString)
                     onClient: logToGciClient .
              failBlock value: sslServer value: logToGciClient.
              ].
] on: SocketError do:[:ex|
        sslServer ifNotNil:[ sslServer close ].
        listener ifNotNil:[ listener close ].
        ex pass
].

"close method will close the SSL connection and underlying socket."
sslServer close.
listener close .
^ true
%

category: 'Examples'
classmethod: GsSecureSocket
serverExample: logToGciClient usingPort: portNum on: host

| listener sslServer pw |

[ | failBlock bigStr result data dataSizeString |
  failBlock := [:sock :shouldLog | | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do: [:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Specify the certificate and private key to use for all server connections in
   this gem.  Both must be in PEM format.  Private key and certificate may be
   contained in the same PEM file or in different files as we show here."

   pw := self getPasswordFromFile: '$GEMSTONE/examples/openssl/private/server_1_server_passwd.txt' .

   GsSecureSocket useServerCertificateFile: '$GEMSTONE/examples/openssl/certs/server_1_servercert.pem'
    withPrivateKeyFile: '$GEMSTONE/examples/openssl/private/server_1_serverkey.pem'
    privateKeyPassphrase: pw .

  "Don't request a certificate from the client.  This is typical."
  GsSecureSocket disableCertificateVerificationOnServer .

  "Use all ciphers except NULL ciphers and anonymous Diffie-Hellman
   and sort by strength."
  GsSecureSocket setServerCipherListFromString: 'ALL:!ADH:@STRENGTH' .

  "All class methods have been executed, so now we can create the instance.
   Class methods executed AFTER the instance is created will NOT APPLY to
   the instance!"

  "Create a new SSL server socket."
  listener := self newServer.

  "Make it listen for the client."
  (listener makeServerAtPort: portNum) ifNil: [ | err |
  	err := listener lastErrorString.
  	listener close.
  	SocketError signal: 'makeServerAtPort failed, ', err asString.
          ].

  listener port == portNum ifFalse:[ Error signal: 'bad port number' ] .

  GsFile gciLog: 'Waiting for GsSecureSocket clientExample to connect...'
  	onClient: logToGciClient .
  [listener readWillNotBlockWithin: 5000] whileFalse: [
  	GsFile gciLog: 'waiting...' onClient: logToGciClient
    	].

  GsFile gciLog: 'Client connected.' onClient: logToGciClient .

  "Do the normal accept to establish a standard socket connection."
  "sslServer is our connection to the client."
  sslServer := listener accept .
  sslServer ifNil: [| err |
          err := listener lastErrorString.
          listener close.
  	SocketError signal: 'accept failed, ', err asString.
  	].

  GsFile gciLog: 'Normal accept completed OK.' onClient: logToGciClient .

  "uncomment next to put the socket in blocking mode."
  "sslServer makeBlocking."

  "sslServer has only a normal connection to the peer.  If will have a secure
    connection if secureAccept succeeds."

  ([sslServer secureAccept] on: SocketError do:[:ex| | certError |
    GsFile gciLog: 'secureAccept failed.'  onClient: logToGciClient.
    certError := sslServer class fetchLastCertificateVerificationErrorForServer .
    certError ifNil: [
        GsFile gciLog: 'nil result from fetchLastCertificateVerificationErrorForServer'
           onClient: logToGciClient
    ] ifNotNil:[
        GsFile gciLog: ('Cert error: =>' , certError)
           onClient: logToGciClient.].
	ex pass
    ])
      ifTrue:[ GsFile gciLog: 'Secure connection established.'
                      onClient: logToGciClient ].

  "If we get here, we have a secure connection to the client."

  GsFile gciLog: ('Current cipher in use is: ', sslServer fetchCipherDescription)
         onClient: logToGciClient.

  "Build data to send"
  data := Array new.
  4096 timesRepeat: [ data add: (String withAll: '0123456789ABCDEF') ].
  bigStr := String new .
  PassiveObject passivate: data toStream: (WriteStream on: bigStr).
  dataSizeString := bigStr size asHexStringWithLength: 8.
  dataSizeString size > 8 ifTrue:
      [UserDefinedError signal: 'Protocol Error, attempt to send more than 4294967295 bytes'].

  GsFile gciLog: 'Sending data length to client: ', bigStr size asString,
      ' bytes, encoded as ', dataSizeString onClient: logToGciClient.

  result := sslServer write: dataSizeString.
  result == dataSizeString size
    ifTrue: [ GsFile gciLog: 'Finished sending length to peer'
  		onClient: logToGciClient ]
    ifFalse: [ GsFile gciLog: 'write of length bytes failed, result was ', result asString
                  onClient: logToGciClient .
              failBlock value: sslServer value: logToGciClient.
  		].

  GsFile gciLog: 'Sending ', bigStr size asString, ' bytes to client'
         onClient: logToGciClient.
  result := sslServer write: bigStr .
  result == bigStr size
    ifTrue:[ GsFile gciLog: ('Finished sending ', bigStr size asString, ' bytes to peer')
                     onClient: logToGciClient ]
    ifFalse:[ GsFile gciLog: ('write failed, result was ', result asString)
                     onClient: logToGciClient .
              failBlock value: sslServer value: logToGciClient.
              ].
  "close method will close the SSL connection and underlying socket."
] on: SocketError do:[:ex|
        sslServer ifNotNil:[ sslServer close ].
        listener ifNotNil:[ listener close ].
        ex pass
].

sslServer close.
listener close .
^ true
%

category: 'Examples'
classmethod: GsSecureSocket
setCaCertLocation

"Assume we are running on Linux or Darwin. Try to find the trusted CA cert file
 on this host. If we find it, use it. If we do not, disable cert
 verification so the examples work correctly.

 Ubuntu:         /etc/ssl/certs/ca-certificates.crt
 Centos|Red Hat: /etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem
 Darwin:         /etc/ssl/cert.pem
 
 Returns the CA cert file used or nil if no file was found and 
 certificate verification has been disabled.
"
 
 | files certFile |
 files := { '/etc/ssl/certs/ca-certificates.crt' .
            '/etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem' .
	    '/etc/ssl/cert.pem' } .
	    
  certFile := files detect:[:e| GsFile existsOnServer: e] ifNone:[ nil ].
  certFile ifNil:[ GsSecureSocket disableCertificateVerificationOnClient ]
        ifNotNil:[ GsSecureSocket useCACertificateFileForClients: certFile ].
  ^ certFile	
	   
%

category: 'Peer Authentication'
classmethod: GsSecureSocket
setCertificateVerificationOptionsForServer: anArray

"Sets the certificate verification options for server sockets using an Array of
 Symbols.  The supported server options are:

 #SSL_VERIFY_FAIL_IF_NO_PEER_CERT
    if the client did not return a certificate, the TLS/SSL handshake is
    immediately terminated with a 'handshake failure' alert.

 #SSL_VERIFY_CLIENT_ONCE
    only request a client certificate on the initial TLS/SSL handshake.
    Do not ask for a client certificate again in case of a renegotiation.

 Refer to the OpenSSL documentation for more information about these options.

 If anArray is empty then any previously set options are cleared.

 Has no effect on instances created before the method was called.

 Raises an error if the array contains any elements besides the above symbols.

 Certificate verification for server sockets must be enabled before executing this
 method, otherwise an error is raised.  Use the #enableCertificateVerificationOnServer
 method to enable certification verification.

 Returns true of success or raises an exception on error."

^ (self _oneArgSslPrim: 6 with: anArray)
    ifTrue:[ true ]
    ifFalse:[ self signalError ]
%

category: 'Ciphers'
classmethod: GsSecureSocket
setClientCipherListFromString: aString

"Specify the cipher list to be used by all client connections.  aString must be an
 instance of String in the format described in the man page for ciphers(1). See
   http://www.openssl.org/docs/apps/ciphers.html

 The ciphers loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 Returns true if one or more of the specified ciphers are usable or raises
 an exception if an error occurs."

^ (self _oneArgSslPrim: 3 with: aString)
     ifTrue:[ true ]
     ifFalse:[ self signalError ]
%

category: 'Ciphers'
classmethod: GsSecureSocket
setServerCipherListFromString: aString

"Specify the cipher list to be used by all server connections.  aString must be an
 instance of String in the format described in the man page for ciphers(1).  See
   http://www.openssl.org/docs/apps/ciphers.html

 The ciphers loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 Returns true if one or more of the specified ciphers are usable or raises an error
 if an error occurs."

^ (self _oneArgSslPrim: 4 with: aString)
     ifTrue:[ true ]
     ifFalse:[ self signalError ]
%

category: 'Error Reporting'
classmethod: GsSecureSocket
signalError
  ^ SecureSocketError signal: (self lastErrorString ifNil:[ 'no details' ]).
%

category: 'Error Reporting'
classmethod: GsSecureSocket
signalError: aString
  ^ SecureSocketError signal:
      (self lastErrorString ifNotNil:[:s | aString , ', ' , s]  ifNil:[ aString ]).
%

category: 'Querying'
classmethod: GsSecureSocket
sslLibraryVersionString

"Answer an instance of String which describes the version of OpenSSL library loaded by this session."

^ self _zeroArgSslPrim: 19
%

category: 'Examples'
classmethod: GsSecureSocket
startTlsClientExample: logToGciClient usingPort: portNum address: serverAddress

"logToGciClient is a Boolean, true if GsFile-based logging is to be done to
 the RPC Gci client, false if to the server process's log file. Use false if
 executing via topaz 'nbrun'  .

 This client will connect to a server created with serverStartTlsExample.
 Then it will send 4 strings to the server and string 'OK' back to indicate
 the data was received.  Then the client will send the string 'STARTTLS' to
 tell the server to switch to encrypted communication. Once it receives back
 the 'OK' string, it will create a GsSecureSocket from the GsSocket and call
 secureConnect to establish a TLS connection. It will then print the cipher
 being used and close the connection.

 All strings sent and received are expected to be NULL-terminated.

 The server should already be listening for connections when this method is
 invoked. Start the server before starting the client."

| sslClient |

[
  | socket dataString chunk sleepCount outString failBlock |

  socket := GsSocket new.
  (socket connectTo: portNum on: serverAddress) ifFalse:[
    socket close .
    Error signal: 'Unable to connect to port ' , portNum asString ,
      '. Wait 30 seconds or so, then ensure startTlsServerExample is started first.'
    ].
  dataString := String new .
  outString := String new.

  "Exchange some unencrypted data messages"
  1 to: 5 do:[:n| | numWritten|
    sleepCount := 0.
    [ socket writeWillNotBlockWithin: 5000] whileFalse: [
      GsFile gciLog: 'Waiting to write to server...' onClient: logToGciClient .
      sleepCount := sleepCount + 1.
      sleepCount > 200 ifTrue:[
        GsFile gciLog: 'Not ready to write after 20 sec' onClient: logToGciClient.
        Error signal: 'Not ready to read after 20 sec' .
      ].
      System _sleepMs: 100 . "sleep 100 ms then retry"
    ].

    outString size: 0.
    n == 5
      ifTrue:[ outString addAll: 'STARTTLS']
      ifFalse:[ outString addAll: DateTime now asString] .
    outString add: (Character withValue: 0).

    numWritten := socket write: outString.
    GsFile gciLog: 'wrote ', numWritten asString, ' bytes'  onClient: logToGciClient .
    numWritten == outString size ifFalse:[ Error signal: 'error writing to socket'].
    [ socket readWillNotBlockWithin: 10000] whileFalse: [
        GsFile gciLog: 'Waiting for server to write...' onClient: logToGciClient .
    ].

    GsFile gciLog: 'Got something from the server to read.' onClient: logToGciClient .
    dataString size: 0.
    [
      chunk := socket readString: 4000.
      chunk ifNil:[ Error signal: 'Error in reading from socket' ].
      dataString addAll: chunk .
      (chunk at: chunk size) == (Character withValue: 0)  "read until null terminator"
    ] untilTrue .
    n == 5 ifFalse:[ System _sleepMs: 250 ].
  ].

  failBlock := [:sock :shouldLog| | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do:[:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Specify the file which contains a list of trusted CA certificates.
   These will be used to validate the certificate presented by the peer
   during the SSL handshake.  The file must be in PEM format.
   Currently, there is no easy way to specify the CA list from a String.
   This must be done before creating the instance of GsSecureSocket! "
  GsSecureSocket useCACertificateFileForClients:
        '$GEMSTONE/examples/openssl/certs/cacert.pem'.


  "Transfer connection from socket to a new SSL socket."
  sslClient:= GsSecureSocket newClientFromGsSocket: socket .
  sslClient ifNil:[ Error signal: 'Error: newClientFromGsSocket: method failed'].
  "close the old one. This will NOT close the file descriptor."
  socket close.

  "Request a cert from the server"
  sslClient enableCertificateVerification .

  "Set the cipher list for this SSL socket only.
   Use all ciphers except NULL ciphers and anonymous Diffie-Hellman
   and sort by strength."
  (sslClient setCipherListFromString: 'ALL:!ADH:@STRENGTH')
    ifFalse:[ GsFile gciLog: 'setCipherListFromString: failed'
                    onClient: logToGciClient
    ].

  "Attempt to establish a secure connection to the SSL server..."
  ([sslClient secureConnect]
    on: SocketError
    do:[:ex| |certError|
      GsFile gciLog: 'secureConnect failed' onClient: logToGciClient.
      certError := GsSecureSocket fetchLastCertificateVerificationErrorForClient .
      certError ifNil: [
         GsFile gciLog: 'nil result from fetchLastCertificateVerificationErrorForClient'
                onClient: logToGciClient
          ] ifNotNil: [
          GsFile gciLog: ('Cert error: =>' , certError) onClient: logToGciClient].
      ex pass.
    ])
    ifTrue:[ GsFile gciLog: 'Secure connection established'
                    onClient: logToGciClient].

  "We have a secure connection to the server if we get here."
  GsFile gciLog: ('Current cipher in use is: ', sslClient fetchCipherDescription)
         onClient: logToGciClient.
] on: SocketError do:[:ex| sslClient close. ex pass ].
sslClient close.
^ true.
%

category: 'Examples'
classmethod: GsSecureSocket
startTlsServerExample: logToGciClient usingPort: portNum address: listeningAddress

"logToGciClient is a Boolean, true if GsFile-based logging is to be done to
 the RPC Gci client, false if to the server process's log file.  Use false if
 executing via topaz 'nbrun'.

 Creates a GsSocket, binds it to port portNum, and waits for a connection.
 When a connection is established, waits for unencrypted data from the client.
 Sends OK back to the client to indicate unencrypted data was received.
 If the unencrypted data contains the string STARTTLS, then a GsSecureSocket
 is created from the GsSocket and secureAccept: is called to negotiate an
 encrypted connection. Once the encrypted connection is established, the
 cipher in use is printed and the connection is closed.

 All strings sent and received are expected to be NULL-terminated.

 You will need two GemStone sessions running from two independent
 interface processes to run both this and the startTlsClientExample.

 Warning: This method will cause your current session to hang until a
 connection is established."

| server client sslServer |
[
  | numWritten errStr sleepTime starttls resultString
    chunk failBlock dataString pw |

  server := GsSocket new.
  (server makeServer: 5 atPort: portNum atAddress: listeningAddress) ifNil: [
    errStr := server lastErrorString.
    server close.
    server := nil.
    Error signal: errStr.
    ].

  server port == portNum ifFalse:[ Error signal: 'bad port number' ] .
  GsFile gciLog: 'Waiting for GsSecureSocket startTlsClientExample to connect...'
  	onClient: logToGciClient .
  [server readWillNotBlockWithin: 10000] whileFalse: [
    GsFile gciLog: 'waiting...' onClient: logToGciClient
  ].

  GsFile gciLog: 'Client connected, starting accept.' onClient: logToGciClient .
  client := server accept .
  GsFile gciLog: 'accept finished. client = ', client asString  onClient: logToGciClient .
  client ifNil: [
    errStr := server lastErrorString.
    server close.
    server := nil .
    GsFile gciLog: 'error from accept, ', errStr onClient: logToGciClient .
    Error signal: errStr.
  ].
  server close.
  server := nil.
  client linger: true length: 10.  "wait after closing until data is processed"
  dataString := String new.
  resultString := String withAll: 'OK'.
  resultString add: (Character withValue: 0).
  starttls := false.

  "Keep receiving normal data and sending OK back until we see STARTTLS"
  [starttls] whileFalse:[
    [ client readWillNotBlockWithin: 10000] whileFalse: [
      GsFile gciLog: 'Waiting for client to write...' onClient: logToGciClient .
    ].
    dataString size: 0.
    GsFile gciLog: 'Got something from the client to read.' onClient: logToGciClient .
    [
      chunk := client readString: 4000 "max bytes".
      chunk ifNil:[ Error signal: 'Error in reading from socket' ].
      dataString addAll: chunk .
      (chunk at: chunk size) == (Character withValue: 0)  "until null terminator"
    ] untilTrue .

    sleepTime := 0 .
    [ client writeWillNotBlock ] whileFalse:[
      sleepTime == 0 ifTrue:[
         GsFile gciLog: 'waiting because write to client would block' onClient: logToGciClient.
      ].
      sleepTime > 5000 ifTrue:[
        GsFile gciLog: 'ERROR, client would block' onClient: logToGciClient .
        Error signal: 'socket write will block'
      ].
      System _sleepMs: 20 .
      sleepTime := sleepTime + 20 .
    ].
    "Got all the data, send back OK"
    numWritten := client write: resultString .
    GsFile gciLog: 'wrote ', numWritten asString, ' bytes'  onClient: logToGciClient .
    numWritten == resultString size ifFalse:[ Error signal: 'error writing to socket'].
    starttls := (dataString findString: 'STARTTLS' startingAt: 1) ~~ 0 .
  ].

  "Client has sent STARTTLS. Create new SSL server socket using existing client
   connection.  Socket file descriptor is transferred to sslServer."
  sslServer := GsSecureSocket newServerFromGsSocket: client .
  sslServer ifNil:[ Error signal: 'Failed to create GsSecureSocket from GsSocket'].
  client close. "will not close the underlyding file descriptor"
  client := nil .
  "do not request a certificate from the client"
  sslServer disableCertificateVerification.

  failBlock := [:sock :shouldLog| | err arr |
    err := sock fetchLastIoErrorString .
    err ifNotNil: [GsFile gciLog: err onClient: shouldLog].
    arr := sock class fetchErrorStringArray .
    1 to: arr size do:[:n| GsFile gciLog: (arr at: n) onClient: shouldLog ].
    sock close.
    SocketError signal: err asString.
  ].

  "Example of using an encrypted private key that requires a passphrase."
   pw := self getPasswordFromFile: '$GEMSTONE/examples/openssl/private/server_1_server_passwd.txt' .
   sslServer useCertificateFile: '$GEMSTONE/examples/openssl/certs/server_1_servercert.pem'
             withPrivateKeyFile: '$GEMSTONE/examples/openssl/private/server_1_serverkey.pem'
             privateKeyPassphrase: pw .

  "Use all ciphers except NULL ciphers and anonymous Diffie-Hellman and sort by strength."
  sslServer setCipherListFromString: 'ALL:!ADH:@STRENGTH' .

  GsFile gciLog: 'Waiting for client to secureConnect: ...' onClient: logToGciClient .

  ([sslServer secureAccept] on: SocketError do:[:ex| | certError |
    GsFile gciLog: 'secureAccept failed.'  onClient: logToGciClient.
    certError := sslServer class fetchLastCertificateVerificationErrorForServer .
    certError ifNil: [
        GsFile gciLog: 'nil result from fetchLastCertificateVerificationErrorForServer'
           onClient: logToGciClient
    ] ifNotNil:[
        GsFile gciLog: ('Cert error: =>' , certError) onClient: logToGciClient.].
  	ex pass
      ])
      ifTrue:[ GsFile gciLog: 'Secure connection established.'
                      onClient: logToGciClient ].

  "If we get here, we have a secure connection to the client."

  GsFile gciLog: ('Current cipher in use is: ', sslServer fetchCipherDescription)
         onClient: logToGciClient.
] on: SocketError do:[:ex|
        sslServer ifNotNil:[ sslServer close ].
        server ifNotNil:[ server close ].
	client ifNotNil:[ client close ].
        ex pass
].

sslServer close .
^ true
%

category: 'TLS Protocol Version'
classmethod: GsSecureSocket
tlsClientMaxVersion

"Gets the maximum TLS protocol version for client sockets created
 by the receiver.

 Possible results are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 A return value of #TLS_VERSION_DEFAULT means any supported 
 TLS protocol may be used, which is the default behavior."

^ self _zeroArgSslPrim: 33
%

category: 'TLS Protocol Version'
classmethod: GsSecureSocket
tlsClientMaxVersion: aStringOrSymbol

"Sets the maximum TLS protocol version for client sockets created by the receiver.
 aStringOrSymbol must be an instance of String or Symbol.

 Valid options are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 Passing an argument of #TLS_VERSION_DEFAULT means use any supported 
 TLS protocol, which restores the default behavior.

 Returns true on success or raises an exception if the argument is invalid.
 Raises an exception if the argument would set the maximum TLS protocol version
 to be less than a previously set minimum TLS protocol version."

^ self _oneArgSslPrim: 20 with: aStringOrSymbol
%

category: 'TLS Protocol Version'
classmethod: GsSecureSocket
tlsClientMinVersion

"Gets the minimum TLS protocol version for client sockets created
 by the receiver.

 Possible results are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 A return value of #TLS_VERSION_DEFAULT means any supported 
 TLS protocol may be used, which is the default behavior."

^ self _zeroArgSslPrim: 32
%

category: 'TLS Protocol Version'
classmethod: GsSecureSocket
tlsClientMinVersion: aStringOrSymbol

"Sets the minimum TLS protocol version for client sockets created by the receiver.
 aStringOrSymbol must be an instance of String or Symbol.

 Valid options are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 Passing an argument of #TLS_VERSION_DEFAULT means use any supported 
 TLS protocol, which restores the default behavior.

 Returns true on success or raises an exception if the argument is invalid.
 Raises an exception if the argument would set the minimum TLS protocol version
 to be greater than a previously set maximum TLS protocol version."

^ self _oneArgSslPrim: 19 with: aStringOrSymbol
%

category: 'TLS Protocol Version'
classmethod: GsSecureSocket
tlsServerMaxVersion

"Gets the maximum TLS protocol version for server sockets created
 by the receiver.

 Possible results are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 A return value of #TLS_VERSION_DEFAULT means any supported 
 TLS protocol may be used, which is the default behavior."

^ self _zeroArgSslPrim: 31
%

category: 'TLS Protocol Version'
classmethod: GsSecureSocket
tlsServerMaxVersion: aStringOrSymbol

"Sets the maximum TLS protocol version for server sockets created by the receiver.
 aStringOrSymbol must be an instance of String or Symbol.

 Valid options are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 Passing an argument of #TLS_VERSION_DEFAULT means use any supported 
 TLS protocol, which restores the default behavior.

 Returns true on success or raises an exception if the argument is invalid.
 Raises an exception if the argument would set the maximum TLS protocol version
 to be less than a previously set minimum TLS protocol version."

^ self _oneArgSslPrim: 18 with: aStringOrSymbol
%

category: 'TLS Protocol Version'
classmethod: GsSecureSocket
tlsServerMinVersion

"Gets the minimum TLS protocol version for server sockets created
 by the receiver.

 Possible results are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 A return value of #TLS_VERSION_DEFAULT means any supported 
 TLS protocol may be used, which is the default behavior."

^ self _zeroArgSslPrim: 30
%

category: 'TLS Protocol Version'
classmethod: GsSecureSocket
tlsServerMinVersion: aStringOrSymbol

"Sets the minimum TLS protocol version for server sockets created by the receiver.
 aStringOrSymbol must be an instance of String or Symbol.

 Valid options are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 Passing an argument of #TLS_VERSION_DEFAULT means use any supported 
 TLS protocol, which restores the default behavior.

 Returns true on success or raises an exception if the argument is invalid.
 Raises an exception if the argument would set the minimum TLS protocol version
 to be greater than a previously set maximum TLS protocol version."

^ self _oneArgSslPrim: 17 with: aStringOrSymbol
%

category: 'Certificate Authorities'
classmethod: GsSecureSocket
useCACertificateDirectoryForClients: aDirectoryString

"Specifies a directory where trusted certificate authority (CA) certificates in
 PEM format are located. The certificates in this directory will be used to
 authenticate certificates provided by servers during the SSL handshake. The
 directory may contain more than one certificate.

 Certificates are loaded into the internal SSL state which is valid for the
 current session only; the SSL state is not committed to the repository.

 Has no effect on instances created before the method was called or server
 instances of GsSecureSocket.

 If successful, this method also enables certificate verification for client
 sockets as if the #enableCertificateVerificationOnClient method had been called
 immediately following this method.

 Returns true on success or false if an error occurs.  Raises an
 exception if the directory does not exist."

^ (self _oneArgSslPrim: 8 with: aDirectoryString)
    ifTrue:[ true ]
    ifFalse:[ self signalError ]
%

category: 'Certificate Authorities'
classmethod: GsSecureSocket
useCACertificateDirectoryForServers: aDirectoryString

"Specifies a directory where trusted certificate authority (CA) certificates in
 PEM format are located. The certificates in this directory will be used to
 authenticate certificates provided by client during the SSL handshake. The
 directory may contain more than one certificate.

 Certificates are loaded into the internal SSL state which is valid for the
 current session only; the SSL state is not committed to the repository.

 Has no effect on instances created before the method was called or client
 instances of GsSecureSocket.

 If successful, this method also enables certificate verification for server
 sockets as if the #enableCertificateVerificationOnServer method had been called
 immediately following this method.

 Returns true on success or false if an error occurs.  Raises an
 exception if the directory does not exist."

^ (self _oneArgSslPrim: 9 with: aDirectoryString)
    ifTrue:[ true ]
    ifFalse:[ self signalError ]
%

category: 'Certificate Authorities'
classmethod: GsSecureSocket
useCACertificateFileForClients: aFileNameString

"Attempt to load given CA Certificate file which must be in PEM format.
 The file may contain more than one certificate.  If the file is loaded
 successfully, it will be used by SSL clients to validate all certificates
 presented by SSL servers during the SSL handshake.

 The certificates loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 Has no effect on instances created before the method was called.

 Also enables certificate verification for client sockets as if
 the #enableCertificateVerificationOnClient method had been called
 immediately following this method.

 Returns true on success raises an exception if an error occurs or the
 file does not exist."

 ^ (self _oneArgSslPrim: 1 with: aFileNameString)
     ifTrue:[ true ]
     ifFalse:[ self signalError: 'useCACertificateFileForClients: failed' ]
%

category: 'Certificate Authorities'
classmethod: GsSecureSocket
useCACertificateFileForServers: aFileNameString

"Attempt to load given CA Certificate file which must be in PEM format.
 The file may contain more than one certificate.  The certificates
 are considered to be trusted and will be used to validate certificates
 presented by SSL clients.  Note that authentication of clients is disabled
 by default and must be enabled in order for this method to have any effect.

 The certificates loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 Has no effect on instances created before the method was called.

 Also enables certificate verification for server sockets as if
 the #enableCertificateVerificationOnServer method had been called
 immediately following this method.

 Returns true on success or raises an exception if an error occurs or
 the file does not exist."

 ^ (self _oneArgSslPrim: 2 with: aFileNameString)
     ifTrue:[ true ]
     ifFalse:[ self signalError: 'useCACertificateFileForServers: failed' ]
%

category: 'Certificates and Keys'
classmethod: GsSecureSocket
useClientCertificate: aString withPrivateKey: anotherString privateKeyPassphrase: passPhrase

"Specifies the certificate string and private key string to be used by all
 client connections.  The private key must match the certificate.

 The certificates loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 Both strings must be in PEM format.  If the private key requires a passphrase,
 it is specified in the passPhrase argument as a String.  If no passphrase is
 required, then the passPhrase argument is expected to be nil.

 Both strings must exactly match the contents of the corresponding certificate files
 (including white-space characters) or the strings will not be accepted.

 Returns true on success or raises an exception if an error occurs."

^ (self _threeArgSslPrim: 4 with: aString with: anotherString with: passPhrase)
     ifTrue:[ true ]
     ifFalse:[ self signalError ]
%

category: 'Certificates and Keys'
classmethod: GsSecureSocket
useClientCertificateFile: certFile withPrivateKeyFile: keyFile privateKeyPassphrase: pass

"Specifies the certificate file and private key file to be used by all
 client connections.  The private key must match the certificate.

 The certificates loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 Both files must be in PEM format.

 The certificate file may contain a certificate chain or a single certificate.

 If the private key requires a passphrase, it is to be specified as String
 passed in using the pass argument.  If the private key does not require a
 passphrase, then the pass argument is expected to be nil.

 Both file arguments must be instances of String.

 Returns true on success or raises an exception if an error occurs or
 the file does not exist."

^ (self _threeArgSslPrim: 7 with: certFile with: keyFile with: pass)
     ifTrue:[ true ]
     ifFalse:[ self signalError ]
%

category: 'Certificates and Keys'
classmethod: GsSecureSocket
useServerCertificate: aString withPrivateKey: anotherString privateKeyPassphrase: passPhrase

"Specifies the certificate string and private key string to be used by all
 server connections.  The private key must match the certificate.

 The certificates loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 Both strings must be in PEM format.  If the private key requires a passphrase,
 it is specified in the passPhrase argument as a String.  If no passphrase is
 required, then the passPhrase argument is expected to be nil.

 Both strings must exactly match the contents of the corresponding certificate files
 (including white-space characters) or the strings will not be accepted.

 Returns true on success or raises an exception if an error occurs."

^ (self _threeArgSslPrim: 3 with: aString with: anotherString with: passPhrase)
     ifTrue:[ true ]
     ifFalse:[ self signalError ]
%

category: 'Certificates and Keys'
classmethod: GsSecureSocket
useServerCertificateFile: certFile withPrivateKeyFile: keyFile privateKeyPassphrase: pass

"Specifies the certificate file and private key file to be used by all
 server connections.  The private key must match the certificate.

 Both files must be in PEM format.

 The certificate file may contain a certificate chain or a single certificate.

 If the private key requires a passphrase, it is to be specified as String
 passed in using the pass argument.  If the private key does not require a
 passphrase, then the pass argument is expected to be nil.

 Both file arguments must be instances of String.

 The certificates loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 Returns true on success or raises an exception if an error occurs or
 the file does not exist."

^ (self _threeArgSslPrim: 6 with: certFile with: keyFile with: pass)
     ifTrue:[ true ]
     ifFalse:[ self signalError ]
%

category: 'Private'
classmethod: GsSecureSocket
_newClientNoSslState

"Used in hostagent code.
 Creates a new instance with no connection and no ssl state and a AF_INET client socket."

^ super new 
%

category: 'Private'
classmethod: GsSecureSocket
_oneArgSslPrim: opcode with: arg

"opcode  function
   1        class method: useCACertificateFileForClients:
   2        class method: useCACertificateFileForServers:
   3        class method: setClientCipherListFromString:
   4        class method: setServerCipherListFromString:
   5     instance method: setCipherListFromString:
   6        class method: setCertificateVerificationOptionsForServer:
   7     instance method: setCertificateVerificationOptions:
   8        class method: useCACertificateDirectoryForClients:
   9        class method: useCACertificateDirectoryForServers:
  10     instance method: initializeAsServerFromGsSocket:
  11     instance method: initializeAsClientFromGsSocket:
  12     instance method: _installSsl:
  13     instance method: setServerNameIndication:
  14     instance method: setPreSharedKey:
  15     instance method: tlsMinVersion:
  16     instance method: tlsMaxVersion:
  17:       class method: tlsServerMinVersion:
  18:       class method: tlsServerMaxVersion:
  19:       class method: tlsClientMinVersion:
  20:       class method: tlsClientMaxVersion:
  21     instance method: setExpectedHost:
  22     instance method: addExpectedHost:
  23     instance method: setExpectedHostFlags:
"

<primitive: 910>
^ self _primitiveFailed: #_oneArgSslPrim:with: args: { opcode . arg }
%

category: 'Private'
classmethod: GsSecureSocket
_threeArgSslPrim: opcode with: arg1 with: arg2 with: arg3

"opcode  function
   1     instance method: _write:startingAt:ofSize:
   2     instance method: _readInto:startingAt:maxBytes:
   3        class method: useServerCertificate: withPrivateKey: privateKeyPassphrase:
   4        class method: useClientCertificate: withPrivateKey: privateKeyPassphrase:
   5     instance method: useCertificate: withPrivateKey: privateKeyPassphrase:
   6:       class method: useServerCertificateFile:withPrivateKeyFile:privateKeyPassphrase:
   7:       class method: useClientCertificateFile:withPrivateKeyFile:privateKeyPassphrase:
   8:    instance method: useCertificateFile:withPrivateKeyFile::privateKeyPassphrase:
"
<primitive: 909>
^ self _primitiveFailed: #_threeArgSslPrim:with:with:with:
  args: { opcode . arg1 . arg2 . arg3 }
%

category: 'Private'
classmethod: GsSecureSocket
_zeroArgSslPrim: opcode

"opcode  function
   1     instance method: secureConnect
   2     instance method: secureAccept
   3     instance method: hasSecureConnection
   4     instance method: secureClose
   5     instance method: fetchLastIoErrorString
   6        class method: fetchErrorStringArray
   7        class method: clearErrorQueue
   8        class method: disableCertificateVerificationOnClient
   9        class method: enableCertificateVerificationOnClient
  10        class method: disableCertificateVerificationOnServer
  11        class method: enableCertificateVerificationOnServer
  12     instance method: initializeAsClient
  13     instance method: initializeAsServer
  14        class method: fetchLastCertificateVerificationErrorForServer
  15        class method: fetchLastCertificateVerificationErrorForClient
  16     instance method: fetchCipherDescription
  17     instance method: disableCertificateVerification
  18     instance method: enableCertificateVerification
  19        class method: sslLibraryVersionString
  20     instance method: _peek
  21     instance method: certificateVerificationEnabled
  22        class method: certificateVerificationEnabledOnClient
  23        class method: certificateVerificationEnabledOnServer
  24     instance method: fetchCertificateVerificationOptions
  25        class method: fetchCertificateVerificationOptionsForServer
  26     instance method:  _noFreeSslOnGc
  27     instance method: getServerNameIndication
  28     instance method: tlsMinVersion
  29     instance method: tlsMaxVersion
  30        class method: tlsServerMinVersion
  31        class method: tlsServerMaxVersion
  32        class method: tlsClientMinVersion
  33        class method: tlsClientMaxVersion
  34     instance method: tlsActualVersion
  35     instance method: peerCertificate
  36     instance method: peerCertificateChain
  37     instance method: matchedPeerName
"

<primitive: 908>
^ self _primitiveFailed: #_zeroArgSslPrim: args: { opcode }
%

!		Instance methods for 'GsSecureSocket'

category: 'Server Operations'
method: GsSecureSocket
accept

"Causes the receiver to perform a normal socket accept operation (see the
 accept method in GsSocket for more information).  If the accept is
 successful, then it also initializes the newly created socket as an SSL
 server socket.

 Returns the new socket or raises an exception if an error occurs."

| newServer |
newServer := super accept .
newServer ifNil:[ ^ super signalError: 'accept failed' ]. "Normal accept failed"
newServer initializeAsServer . "SSL init as a server socket"
^ newServer
%

category: 'Server Operations'
method: GsSecureSocket
acceptTimeoutMs: timeoutMs

  | newServer |
  newServer := super acceptTimeoutMs: timeoutMs .
  newServer ifNil:[ ^ super signalError: 'acceptTimeoutMs: failed' ]. "Normal accept failed"
  newServer initializeAsServer . "SSL init as a server socket"
  ^ newServer
%

category: 'Client Operations'
method: GsSecureSocket
addExpectedHost: aString

"Adds aString to the list of expected host names the receiver will 
 connect to. 

 This method must be executed before the #secureConnect method and only with
 client sockets. Raises an exception if the receiver is not a client
 socket, #secureConnect has already been executed, or if aString is not
 a non-empty instance of String.

 Returns the receiver."

^ self _oneArgSslPrim: 22 with: aString
%

category: 'Querying'
method: GsSecureSocket
certificateVerificationEnabled

"Answer true if certificate verification is enabled on the receiver.
 Otherwise answer false."

^ self _zeroArgSslPrim: 21
%

category: 'Socket Operations'
method: GsSecureSocket
close

"Closes the secure connection and releases memory used by the receiver's
 SSL connection if it exists.  Then closes the underlying socket connection.

 Returns self if the socket was closed successfully or nil if an error occurs."

self hasSecureConnection
  ifTrue: [ self secureClose ].
^ super close
%

category: 'Peer Authentication'
method: GsSecureSocket
disableCertificateVerification
"Directs the receiver to not request a certificate from its peer.
 This is the default mode for server sockets.

 Returns true on success or raises an exception on error."

^ self _zeroArgSslPrim: 17
%

category: 'Peer Authentication'
method: GsSecureSocket
enableCertificateVerification
"Directs the receiver to request and verify a certificate from its peer.
 This is the default mode for client sockets.

 Returns true on success or raises an exception on error."

^ self _zeroArgSslPrim: 18
%

category: 'Querying'
method: GsSecureSocket
fetchCertificateVerificationOptions

"Answers an Array of Symbols which represent the certificate verification
 options used by the receiver.  Certificate verification options are only
 supported by server sockets.  Client sockets always return an empty Array.

 The supported server options are:

 #SSL_VERIFY_FAIL_IF_NO_PEER_CERT
    if the client did not return a certificate, the TLS/SSL handshake is
    immediately terminated with a 'handshake failure' alert.

 #SSL_VERIFY_CLIENT_ONCE
    only request a client certificate on the initial TLS/SSL handshake.
    Do not ask for a client certificate again in case of a renegotiation.

 Refer to the OpenSSL documentation for more information about these options."

^ self _zeroArgSslPrim: 24
%

category: 'Querying'
method: GsSecureSocket
fetchCipherDescription

"If the receiver has a secure connection with its peer, this method answers a string which
 describes the cipher currently in use.  Otherwise returns nil to indicate
 the receiver does not have a secure connection with its peer."

^ self _zeroArgSslPrim: 16
%

category: 'Error Handling'
method: GsSecureSocket
fetchLastIoErrorString

"Fetches a string describing the last I/O error encountered by a call to any
 of the following SSL functions:

   SSL_connect
   SSL_accept
   SSL_do_handshake
   SSL_read
   SSL_peek
   SSL_write

 Note that a result containing the substring
   SSL_write:uninitialized
 means that SSL_write was attempted before completing all of the
 handshakes of the sslConnect / sslAccept pair .

 The error is also cleared.  Returns nil if no I/O error has occurred
 on the receiver."

^ self _zeroArgSslPrim: 5
%

category: 'Querying'
method: GsSecureSocket
getServerNameIndication

"Answer a string indicating the server name indication (SNI) name 
 assigned to the receiver, or nil if no SNI name has been assigned."

^ self _zeroArgSslPrim: 27
%

category: 'Querying'
method: GsSecureSocket
hasSecureConnection

"Answer true if the receiver has established a secure connection
 with its peer.  Otherwise answer false."

^ self _zeroArgSslPrim: 3
%

category: 'Initialization'
method: GsSecureSocket
initializeAsClient

"Returns the receiver"
^ self _zeroArgSslPrim: 12
%

category: 'Initialization'
method: GsSecureSocket
initializeAsClientFromGsSocket: aGsSocket

"Returns the receiver on success"
^ self _oneArgSslPrim: 11 with: aGsSocket
%

category: 'Initialization'
method: GsSecureSocket
initializeAsServer

"Returns the receiver"
^ self _zeroArgSslPrim: 13
%

category: 'Initialization'
method: GsSecureSocket
initializeAsServerFromGsSocket: aGsSocket

"Returns the receiver on success"
^ self _oneArgSslPrim: 10 with: aGsSocket
%

category: 'Error Handling'
method: GsSecureSocket
lastErrorString
  "Provided for compatibility with GsSocket.
   See comments in fetchLastIoErrorString"

  ^ self fetchLastIoErrorString ifNil:[ super lastErrorString]
%

category: 'Client Operations'
method: GsSecureSocket
matchedPeerName

"Returns a String representing the DNS hostname or subject
 CommonName from the peer certificate that matched one of the
 hosts set by the #setExpectedHost: or #addExpectedHost:  
 methods.

 Returns nil if no host matching was performed.
 Raises an exception if the receiver is not a client socket
 or if the secure connection has not been established."


^ self _zeroArgSslPrim: 37
%

category: 'Peer Certificates'
method: GsSecureSocket
peerCertificate

"Answer an instance of GsX509Certificate representing the peer's certificate.
 Raises an exception if the receiver has not completed the TLS handshake
 with its peer. Returns nil if no certificate was sent by the peer.
 This will always happen if anonymous TLS is used and can happen when
 certificate verification is disabled."

^ self _zeroArgSslPrim: 35
%

category: 'Peer Certificates'
method: GsSecureSocket
peerCertificateChain

"Answer an instance of GsX509CertificateChain containing the peer's certificate
 chain. Raises an exception if the receiver has not completed the TLS handshake
 with its peer. Returns nil if no certificate was sent by the peer.
 This will always happen if anonymous TLS is used and may happen when
 certificate verification is disabled."

^ self _zeroArgSslPrim: 36
%

category: 'Testing'
method: GsSecureSocket
readWillNotBlock

"Returns true if the socket is currently ready to receive input without
 blocking.  Returns false if it is not currently ready.  Returns nil if an error
 occurs.

 The receiver must already be connected for this method to work properly.  If it
 is not connected, then the value that this method returns is indeterminate.
 Use the peerName method to determine if the receiver is connected.

 Call this method to prevent subsequent read or accept operations from hanging.
 If it returns true for a connected socket, then the input operation will not
 hang.  However, a return value of true is no guarantee that the operation
 itself will succeed."

 self _peek ifNotNil:[ ^ true ].
 ^ super readWillNotBlock
%

category: 'Testing'
method: GsSecureSocket
readWillNotBlockWithin: msToWait

"Returns true if the socket is ready to receive input without blocking within
 msToWait milliseconds from the time that this method is called.  Returns false
 if it is not ready after msToWait milliseconds.  Returns nil if an error
 occurs.

 If msToWait is 0, then this method reports the current readiness of the
 receiver.  If msToWait is -1, then this method never returns false, but waits
 until the receiver is ready to receive input without blocking, and then returns
 true.

 The receiver must already be connected for this method to work properly.  If it
 is not connected, then the value that this method returns is indeterminate.
 Use the peerName method to determine if the receiver is connected.

 Call this method to prevent subsequent read or accept operations from hanging.
 If it returns true for a connected socket, then the input operation will not
 hang.  However, a return value of true is no guarantee that the operation
 itself will succeed."

 self _peek ifNotNil:[ ^ true ].
 ^ super readWillNotBlockWithin: msToWait
%

category: 'Server Operations'
method: GsSecureSocket
secureAccept

"Establishes a secure connection using the receiver as the server  The receiver
 must have already established a regular (non-secure) connection with its
 client.  No certificate management is performed by this method.  A certificate
 and private key must be installed before calling this method.

 This method makes the following OpenSSL calls:

   SSL_new
   SSL_set_fd
   SSL_accept

 Waits up to 30 seconds for completion.

 Returns true to indicate the operation was successful.  Raises an exception
 if an error or timeout occurred."

^ self secureAcceptTimeoutMs: 30000"milliseconds"
%

category: 'Server Operations'
method: GsSecureSocket
secureAcceptTimeoutMs: timeoutMs

"Establishes a secure connection using the receiver as the server  The receiver
 must have already established a regular (non-secure) connection with its
 client.  No certificate management is performed by this method.  A certificate
 and private key must be installed before calling this method.

 This method makes the following OpenSSL calls:
   SSL_new (if not already done on the receiver).
   SSL_set_fd (if not already done on the receiver).
   SSL_accept
 Waits up to the specified time for completion.
 The timeoutMs arugment must be a SmallInteger.

 Returns true to indicate the operation was successful.  Raises an exception
 if an error or timeout occurred."

 ^ self secureAcceptTimeoutMs: timeoutMs errorOnTimeout: true
%

category: 'Server Operations'
method: GsSecureSocket
secureAcceptTimeoutMs: timeoutMs errorOnTimeout: aBoolean

"Establishes a secure connection using the receiver as the server  The receiver
 must have already established a regular (non-secure) connection with its
 client.  No certificate management is performed by this method.  A certificate
 and private key must be installed before calling this method.

 This method makes the following OpenSSL calls:
   SSL_new (if not already done on the receiver).
   SSL_set_fd (if not already done on the receiver).
   SSL_accept
 Waits up to the specified time for completion.
 The timeoutMs arugment must be a SmallInteger.

 Returns true to indicate the operation was successful.
 Raises an exception if an error occurred.
 On timeout, if aBoolean == true, raises an exception otherwise returns false."

 | res |
 res := self _secureAcceptTimeoutMs: timeoutMs  .
 res == true ifTrue:[ ^ true "success" ].
 res == false ifTrue:[
   aBoolean ifFalse:[ ^ false ].
   self signalError: 'secure accept timed out'.
 ].
 self signalError: res asString .
%

category: 'Private'
method: GsSecureSocket
secureClose

"Closes the secure connection and releases memory used by the receiver's
 SSL connection.  Does not close the underlying socket connection.  Customers
 should use the #close method instead of this one unless the underlying
 (insecure) socket connection is to be retained.

 Returns the receiver."

^ self _zeroArgSslPrim: 4
%

category: 'Client Operations'
method: GsSecureSocket
secureConnect

"Establishes a secure connection using the receiver as the client  The receiver
 must have already established a regular (non-secure) connection with its
 server.  No certificate management is performed by this method.

 This method makes the following OpenSSL calls:

   SSL_new
   SSL_set_fd
   SSL_connect

 Waits up to 30 seconds for completion.

 Returns true to indicate the operation was successful.  Raises an exception if
 an error or timeout occurred.
"

^ self secureConnectTimeoutMs: 30000"milliseconds"
%

category: 'Client Operations'
method: GsSecureSocket
secureConnectTimeoutMs: timeoutMs

"Establishes a secure connection using the receiver as the client  The receiver
 must have already established a regular (non-secure) connection with its
 server.  No certificate management is performed by this method.

 This method makes the following OpenSSL calls:

   SSL_new
   SSL_set_fd
   SSL_connect

 Waits up to the specified time for completion.
 The timeoutMs arugment must be a SmallInteger.

 Returns true to indicate the operation was successful.  Raises an exception if
 an error or timeout occurred.  "

| waitedMs |
waitedMs := 0 .
timeoutMs _isSmallInteger
   ifFalse:[ timeoutMs _validateClass: SmallInteger ].
[
  | res |
  "Note: args must be the same each time if -1 is returned"
  res := self _zeroArgSslPrim: 1 .
  ((res == nil) or:[res == false]) ifTrue:[ ^ self signalError: 'secureConnect failed'] .
  res == -1 ifTrue:[ Delay waitForMilliseconds: 20 . waitedMs := waitedMs + 20 ]
           ifFalse:[ res == true ifTrue:[^ res "done" ] .
                     self signalError: 'secureConnect failed with ' , res asString
                  ].
  waitedMs < timeoutMs
] whileTrue .
self signalError: 'secureConnect timed out' .
%

category: 'Peer Authentication'
method: GsSecureSocket
setCertificateVerificationOptions: anArray

"Sets the certificate verification options for the receiver using an Array of
 Symbols.

 The supported server socket options are:

 #SSL_VERIFY_FAIL_IF_NO_PEER_CERT
    if the client did not return a certificate, the TLS/SSL handshake is
    immediately terminated with a 'handshake failure' alert.

 #SSL_VERIFY_CLIENT_ONCE
    only request a client certificate on the initial TLS/SSL handshake.
    Do not ask for a client certificate again in case of a renegotiation.

 Refer to the OpenSSL documentation for more information about these options.

 Raises an error if the array contains any elements besides the above symbols.

 Currently there are no supported options for client sockets. Using this method
 with a client socket raises an error.

 If anArray is empty then any previously set options are cleared.

 The receiver must enable certificate verification before this method is
 executed, otherwise an error is raised.  Use the #enableCertificateVerification
 method to enable certificate verification.

 This method must be used before the receiver attempts a connection with its peer.
 Using this method with a connected socket raises an error.

 Returns true on success or raises an exception on error."

^ (self _oneArgSslPrim: 7 with: anArray)
    ifTrue:[ true ]
    ifFalse:[ self signalError ]
%

category: 'Ciphers'
method: GsSecureSocket
setCipherListFromString: aString

"Specify the cipher list to be used by the receiver only.  aString must be an
 instance of String in the format described in the man page for ciphers(1).  See
   http://www.openssl.org/docs/apps/ciphers.html

 Must be executed before the receiver is in a connected state (i.e., before
 the #secureConnect or #secureAccept method has been executed).

 Returns true if one or more of the specified ciphers are usable, raises an
 exception if no specified ciphers are usable.  Raises an exception if the operation would
 have no effect because the receiver is already in a connected state."

^ (self _oneArgSslPrim: 5 with: aString)
    ifTrue:[ true ]
    ifFalse:[ self signalError ]
%

category: 'Client Operations'
method: GsSecureSocket
setExpectedHost: aString

"Sets the expected host name that the receiver will connect to.
 Any previously set host names are cleared. If aString is nil, all
 previously set host names will be cleared and no host name matching
 will be performed. 

 This method must be executed before the #secureConnect method and only with
 client sockets. Raises an exception if the receiver is not a client
 socket, #secureConnect has already been executed, or if aString is not
 a non-empty instance of String or nil.

 Returns the receiver."

^ self _oneArgSslPrim: 21 with: aString
%

category: 'Client Operations'
method: GsSecureSocket
setExpectedHostFlags: anArray

"Sets the flags which control host name matching during TLS session 
 negotiation. By default no flags are set.  

 anArray must contain zero or more symbols of the following symbols:

  #X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT
  #X509_CHECK_FLAG_NO_WILDCARDS
  #X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS
  #X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS
  #X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS
  #X509_CHECK_FLAG_NEVER_CHECK_SUBJECT

 An empty array causes all previously set flags to be cleared.

 A detailed description of these flags may be found in the OpenSSL documentation
 at: https://www.openssl.org/docs/man3.0/man3/X509_check_host.html

 Raises an exception if the argument is not an Array or any element is not
 one of the above symbols. Returns the receiver."

^ self _oneArgSslPrim: 23 with: anArray
%

category: 'Peer Authentication'
method: GsSecureSocket
setPreSharedKey: aByteArray

"Sets the Pre-Shared Key (psk) for the connection to be the bytes contained in aByteArray.
Raises an exception if the receiver is already connected or listening for a connection.
aByteArray must have a size of at least 8 bytes, not more than 64 bytes and be a multiple 
of 8 (16, 24, 32 etc). A key size of at least 16 bytes is recommended.

Invoking this method multiple times overwrites any previously stored PSK.
To clear a the previously set PSK, invoke this method with an argument of nil.

Returns true on success."

^ self _oneArgSslPrim: 14 with: aByteArray
%

category: 'Client Operations'
method: GsSecureSocket
setServerNameIndication: aString

"Sets the server name indication (SNI) name for the receiver to be
 aString.

 This method is only valid for client sockets which have not yet
 securly connected to a peer.

 Raises an exception if the receiver is not a client socket or if 
 the receiver is already securly connected to its peer.

 Returns true on success, false if an error occurred setting the SNI
 name."

^ self _oneArgSslPrim: 13 with: aString
%

category: 'Error Reporting'
method: GsSecureSocket
signalError
  ^ SecureSocketError signal: (self lastErrorString ifNil:[ 'no details' ]).
%

category: 'Error Reporting'
method: GsSecureSocket
signalError: aString
  ^ SecureSocketError signal:
     (self lastErrorString ifNotNil:[:s | aString , ', ' , s]  ifNil:[ aString ]).
%

category: 'TLS Protocol Version'
method: GsSecureSocket
tlsActualVersion

"Answers a Symbol indicating the actual TLS protocol version used by the 
 receiver. The TLS protocol version for the connection is negotiated by 
 the receiver and its peer during the TLS handshake.

 Possible results are:
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 Raises an exception if the receiver has not completed the TLS handshake
 with its peer. For server sockets, the TLS handshake is complete after the 
 #secureAccept succeeds. For client sockets, the TLS handshake is complete
 after the #secureConnect method succeeds."

^ self _zeroArgSslPrim: 34
%

category: 'TLS Protocol Version'
method: GsSecureSocket
tlsMaxVersion

"Gets the maximum TLS protocol version for the receiver.

 Possible results are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 A return value of #TLS_VERSION_DEFAULT means any supported 
 TLS protocol may be used, which is the default behavior."

^ self _zeroArgSslPrim: 29
%

category: 'TLS Protocol Version'
method: GsSecureSocket
tlsMaxVersion: aStringOrSymbol

"Sets the maximum TLS protocol version for the receiver.
 aStringOrSymbol must be an instance of String or Symbol.

 Valid options are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 Passing an argument of #TLS_VERSION_DEFAULT means use any supported 
 TLS protocol, which restores the default behavior.

 Returns true on success or raises an exception if the argument is invalid.
 Raises an exception if the argument would set the maximum TLS protocol version
 to be less than a previously set minimum TLS protocol version."

^ self _oneArgSslPrim: 16 with: aStringOrSymbol
%

category: 'TLS Protocol Version'
method: GsSecureSocket
tlsMinVersion

"Gets the minimum TLS protocol version for the receiver.

 Possible results are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 A return value of #TLS_VERSION_DEFAULT means any supported 
 TLS protocol may be used, which is the default behavior."

^ self _zeroArgSslPrim: 28
%

category: 'TLS Protocol Version'
method: GsSecureSocket
tlsMinVersion: aStringOrSymbol

"Sets the minimum TLS protocol version for the receiver.
 aStringOrSymbol must be an instance of String or Symbol.

 Valid options are:
   #TLS_VERSION_DEFAULT = default behavior (see below)
   #TLS1_VERSION        = TLS version 1.0
   #TLS1_1_VERSION      = TLS version 1.1
   #TLS1_2_VERSION      = TLS version 1.2
   #TLS1_3_VERSION      = TLS version 1.3

 Passing an argument of #TLS_VERSION_DEFAULT means use any supported 
 TLS protocol, which restores the default behavior.

 Returns true on success or raises an exception if the argument is invalid.
 Raises an exception if the argument would set the minimum TLS protocol version
 to be greater than a previously set maximum TLS protocol version."

^ self _oneArgSslPrim: 15 with: aStringOrSymbol
%

category: 'Certificates and Keys'
method: GsSecureSocket
useCertificate: aString withPrivateKey: anotherString privateKeyPassphrase: passPhrase

"Specifies the certificate and private key to be used by
 the receiver only.  The private key must match the certificate.

 The certificates loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 Both strings must be in PEM format.  If the private key requires a passphrase,
 it is specified in the passPhrase argument as a String.  If no passphrase is
 required, then the passPhrase argument is expected to be nil.

 Both strings must exactly match the contents of the corresponding certificate files
 (including white-space characters) or the strings will not be accepted.

 Returns true on success or raises an exception if an error occurs."

^ (self _threeArgSslPrim: 5 with: aString with: anotherString with: passPhrase)
     ifTrue:[ true ]
     ifFalse:[ self signalError ]
%

category: 'Certificates and Keys'
method: GsSecureSocket
useCertificateFile: certFile withPrivateKeyFile: keyFile privateKeyPassphrase: pass

"Specifies the certificate file and private key file to be used by
 the receiver only.  The private key must match the certificate.

 This method must be run before the #secureAccept (server case)
 or the #secureConnect (client case) methods.
 The certificates loaded into the internal SSL state are valid for the
 current session only; that SSL state is not committed to the repository.

 If the private key requires a passphrase, it is to be specified as String
 passed in using the pass argument.  If the private key does not require a
 passphrase, then the pass argument is expected to be nil.

 Both files must be in PEM format.

 Both arguments must be instances of String.

 Returns true on success or raises an exception if an error occurs or
 the file does not exist."

^ (self _threeArgSslPrim: 8 with: certFile with: keyFile with: pass)
     ifTrue:[ true ]
     ifFalse:[ self signalError ]
%

category: 'Private'
method: GsSecureSocket
_installSsl: aCpointer

"Used in hostagent.  aCpointer must encapsulate a SSL* .
 After this method executes,
  the SSL* will be auto-freed on GC of the receiver."

^ self _oneArgSslPrim: 12 with: aCpointer
%

category: 'Private'
method: GsSecureSocket
_maxReadWaits
  "The wait loop in GsSocket>>read:into:startingAt can
   get repeated read-ready of the underlying socket
   followed by SSL read apparently peeking
   on the socket and returning EWOULDBLOCK because there is not
   yet enough data to do a decryption cycle."
  ^ SmallInteger maximumValue
%

category: 'Private'
method: GsSecureSocket
_noFreeSslOnGc
"Used in hostagent code after sslState and fileDescriptor have
 become owned by a pgsvr thread .
 Cancels the effect of _installSsl:   .
 All subsequent ssl read/write operations must be done from the C code
 that now owns the socket.
 Sets C state in the receiver so that GC of the instance
 will neither free the SSL state, nor close the file descriptor.
"

^ self _zeroArgSslPrim: 26
%

category: 'Private'
method: GsSecureSocket
_nonSslWrite: aByteObject startingAt: anOffset ofSize: numBytes

"GsSocket >> _write:startingAt:ofSize  semantics.
 Returns nil if an error occurred,
   false if non-blocking receiver would block,
   true if EINTR occurred,
   a SmallInteger number of bytes written.
 Generates an error if aByteObject is not a String or ByteArray.
 Clears bits 16r4 from self.readyEvents if no error generated."

<primitive: 882>
self _primitiveFailed: #_write:startingAt:ofSize:
     args: { aByteObject . anOffset . numBytes }
%

category: 'Private'
method: GsSecureSocket
_oneArgSslPrim: opcode with: arg

"opcode  function
   1        class method: useCACertificateFileForClients:
   2        class method: useCACertificateFileForServers:
   3        class method: setClientCipherListFromString:
   4        class method: setServerCipherListFromString:
   5     instance method: setCipherListFromString:
   6        class method: setCertificateVerificationOptionsForServer:
   7     instance method: setCertificateVerificationOptions:
   8        class method: useCACertificateDirectoryForClients:
   9        class method: useCACertificateDirectoryForServers:
  10     instance method: initializeAsServerFromGsSocket:
  11     instance method: initializeAsClientFromGsSocket:
  12     instance method: _installSsl:
  13     instance method: setServerNameIndication:
  14     instance method: setPreSharedKey:
  15     instance method: tlsMinVersion:
  16     instance method: tlsMaxVersion:
  17:       class method: tlsServerMinVersion:
  18:       class method: tlsServerMaxVersion:
  19:       class method: tlsClientMinVersion:
  20:       class method: tlsClientMaxVersion:
  21     instance method: setExpectedHost:
  22     instance method: addExpectedHost:
  23     instance method: setExpectedHostFlags:
"

<primitive: 910>
^ self _primitiveFailed: #_oneArgSslPrim:with: args: { opcode . arg }
%

category: 'Private'
method: GsSecureSocket
_peek
  "Returns a SmallInteger in the range 0..255 if there is a byte available
   from the underlying SSL buffer for the socket, otherwise returns nil."

  ^ self _zeroArgSslPrim: 20
%

category: 'Private'
method: GsSecureSocket
_primBlockingReadInto: aByteObject startingAt: anOffset maxBytes: numBytes

"Returns a SmallInteger indicating how many bytes were read or
 nil if an error occurs.
 Returns 0 if EOF occurs on the socket.
 numBytes must be a SmallInteger > 0 .

 Automatically handles conditions which require waiting for a read-ready
 or write-ready condition."

[ true ] whileTrue:[
  | res |
  "Note: args must be the same each time if -1 or -2 is returned"
  res := self _threeArgSslPrim: 2 with: aByteObject with: anOffset with: numBytes .
  res == -1 ifTrue:[self _waitForReadReady ] "Normal case"
            ifFalse:[ res == -2
                      ifTrue:[ self _waitForWriteReady ] "can happen due to SSL renegotiation"
                      ifFalse:[ ^ res ]. "done or error"
            ].
].
%

category: 'Private'
method: GsSecureSocket
_primNonBlockingReadInto: aByteObject startingAt: anOffset maxBytes: numBytes

"Returns a SmallInteger indicating how many bytes were read or
 nil if an error occurs.
 Returns 0 if EOF occurs on the socket.
 numBytes must be a SmallInteger > 0 .

 Automatically handles conditions which require waiting for a read-ready
 or write-ready condition."

[ true ] whileTrue:[
  | res |
  "Note: args must be the same each time if -1 or -2 is returned"
  res := self _threeArgSslPrim: 2 with: aByteObject with: anOffset with: numBytes .
  res == -1 ifTrue:[^ false "would block" ]
            ifFalse:[ res == -2
                      ifTrue:[ self _waitForWriteReady ] "can happen due to SSL renegotiation"
                      ifFalse:[ ^ res ]. "done or error"
            ].
].
%

category: 'Private'
method: GsSecureSocket
_rawNbWrite: numBytes from: aByteObject startingAt: anOffset
 "Does a non-SSL write to the underlying socket .
  Returns false if non-blocking receiver would block,
  or a SmallInteger number of bytes written.
  Retrys if EINTR occurs. "
 | res |
 [ res := self _nonSslWrite: aByteObject startingAt: anOffset ofSize: numBytes  .
   res == true "EINTR ocurred"
 ] whileTrue .
 res ifNil:[ self signalError ].
 ^ res
%

category: 'Private'
method: GsSecureSocket
_rawRead: maxBytes into: byteObj startingAt: index

"Reads up to the given number of bytes into the given byte object (for
 example, a String).  The first byte read will go into the position
 indicated by index.
 Returns the number of bytes read, or nil if an error,
 or 0 if EOF on the receiver.

 maxBytes must be a SmallInteger > 0 and <= 500000000 .

 An error will be raised if index is greater than the size of byteObj.
 Note that index can be equal to the size of byteObj plus 1 in which
 case any bytes read will be appended to byteObj.

 If no data is available for reading, this returns false .
 This method retrys for EINTR .
 The readWillNotBlock or readWillNotBlockWithin: methods may be used to
 determine whether or not data is ready for reading before calling this method.
 Used in hostagent. "

| status |
[
  "primitive will wait until data available if C socket is blocking."
  status := super _readInto: byteObj startingAt: index maxBytes: maxBytes.
  "status==true from _readInto means got EINTR and must retry"
  (status == false) ifTrue: [
    ^ false
  ] .
  status == true
] whileTrue .
^ status
%

category: 'Private'
method: GsSecureSocket
_rawReadWillNotBlockWithin: msToWait

^ super readWillNotBlockWithin: msToWait
%

category: 'Private'
method: GsSecureSocket
_readInto: aByteObject startingAt: anOffset maxBytes: numBytes

"Read up to numBytes of data from the receiver into aByteObject starting at anOffset.
 numBytes must be a SmallInteger > 0 .
 Returns a SmallInteger indicating how many bytes were read,
 or returns 0 if EOF occurs on the socket,
 or signals an error."

| res |
res := self isNonBlocking
   ifTrue:[ self _primNonBlockingReadInto: aByteObject startingAt: anOffset maxBytes: numBytes ]
  ifFalse:[ self _primBlockingReadInto: aByteObject startingAt: anOffset maxBytes: numBytes ].
res ifNil:[
  SocketError signal: self fetchLastIoErrorString
].
^ res
%

category: 'Private'
method: GsSecureSocket
_readLine: maxSize maxWaitMs: waitLimitMs

"Returns nil or a String .
 Waits up to waitLimitMs milliseconds to receive up to
 maxSize bytes.
 Returns when a linefeed is found at end of data or if max size is reached.
 Used in hostagent.
"
| status waitedMs sz aString |
aString := String new .
waitedMs := 0 .
sz := 0 .
[
  "primitive will wait until data available if C socket is blocking."
  status := self _readInto: aString startingAt: sz + 1 maxBytes: maxSize - sz.
  "status==true from _readInto means got EINTR and must retry"
  status == false ifTrue: [
    "socket is non-blocking and would have blocked"
  ] ifFalse:[
    status == 0 ifTrue:[ ^ nil "EOF"].
    sz := sz + status"num bytes read".
    (aString codePointAt: sz) == 10 ifTrue:[ ^ aString ].
    sz >= maxSize ifTrue:[ ^ aString ].
  ].
  waitedMs < waitLimitMs ifTrue:[
    waitedMs := waitedMs + 1 .
    Delay waitForMilliseconds: 1.
  ] ifFalse:[
    ^ nil "waited too long"
  ].
  true
] whileTrue .
%

category: 'Server Operations'
method: GsSecureSocket
_secureAcceptTimeoutMs: timeoutMs

"Establishes a secure connection using the receiver as the server  The receiver
 must have already established a regular (non-secure) connection with its
 client.  No certificate management is performed by this method.  A certificate
 and private key must be installed before calling this method.

 This method makes the following OpenSSL calls:
   SSL_new (if not already done on the receiver).
   SSL_set_fd (if not already done on the receiver).
   SSL_accept

 Waits up to the specified time for completion.
 The timeoutMs arugment must be a SmallInteger.

 Returns true to indicate the operation was successful,
 false to indicate timeout, or a String describing an error."

| waitedMs |
waitedMs := 0 .
timeoutMs _isSmallInteger ifFalse:[ timeoutMs _validateClass: SmallInteger ].
[
  | res |
  "Note: args must be the same each time if -1 is returned"
  res := self _zeroArgSslPrim: 2 .
  ((res == nil) or:[res == false]) ifTrue:[ ^ 'secureAccept failed'] .
  res == -1 ifTrue:[ Delay waitForMilliseconds: 2 . waitedMs := waitedMs + 2 ]
           ifFalse:[ res == true ifTrue:[ ^ res "done" ] .
                     ^ 'secureAccept failed with ' , res asString
                   ].
  waitedMs < timeoutMs
] whileTrue .
^ false "timeout"
%

category: 'Server Operations'
method: GsSecureSocket
_secureConnectTimeoutMs: timeoutMs

"Establishes a secure connection using the receiver as the server  The receiver
 must have already established a regular (non-secure) connection with its
 client.  No certificate management is performed by this method.  A certificate
 and private key must be installed before calling this method.

 This method makes the following OpenSSL calls:
   SSL_new (if not already done on the receiver).
   SSL_set_fd (if not already done on the receiver).
   SSL_connect

 Waits up to the specified time for completion.
 The timeoutMs arugment must be a SmallInteger.

 Returns true to indicate the operation was successful,
 false to indicate timeout, or a String describing an error."

| waitedMs |
waitedMs := 0 .
timeoutMs _isSmallInteger ifFalse:[ timeoutMs _validateClass: SmallInteger ].
[
  | res |
  "Note: args must be the same each time if -1 is returned"
  res := self _zeroArgSslPrim: 1 .
  ((res == nil) or:[res == false]) ifTrue:[ ^ 'secureConnect failed'] .
  res == -1 ifTrue:[ Delay waitForMilliseconds: 1 . waitedMs := waitedMs + 1 ]
           ifFalse:[ res == true ifTrue:[ ^ res "done" ] .
                     ^ 'secureConnect failed with ' , res asString
                   ].
  waitedMs < timeoutMs
] whileTrue .
^ false "timeout"
%

category: 'Private'
method: GsSecureSocket
_threeArgSslPrim: opcode with: arg1 with: arg2 with: arg3

"opcode  function
   1     instance method: _write:startingAt:ofSize:
   2     instance method: _readInto:startingAt:maxBytes:
   3        class method: useServerCertificate: withPrivateKey: privateKeyPassphrase:
   4        class method: useClientCertificate: withPrivateKey: privateKeyPassphrase:
   5     instance method: useCertificate: withPrivateKey: privateKeyPassphrase:
   6:       class method: useServerCertificateFile:withPrivateKeyFile:privateKeyPassphrase:
   7:       class method: useClientCertificateFile:withPrivateKeyFile:privateKeyPassphrase:
   8:    instance method: useCertificateFile:withPrivateKeyFile::privateKeyPassphrase:
"
<primitive: 909>
^ self _primitiveFailed: #_threeArgSslPrim:with:with:with:
  args: { opcode . arg1 . arg2 . arg3 }
%

category: 'Private'
method: GsSecureSocket
_write: aByteObject startingAt: anOffset ofSize: numBytes

"Does not conform exactly to GsSocket >> _write:startingAt:ofSize:
 due to semantics of SSL renegotiation and socket buffering.

 Returns nil if a socket error occurred ,
 or a SmallInteger the number of bytes written which will
 normally be equal to numBytes."

[ true ] whileTrue:[
  | res |
  "Note: args must be the same each time if -1 or -2 is returned"
  res := self _threeArgSslPrim: 1 with: aByteObject with: anOffset with: numBytes .
  res == -2 ifTrue:[
    ^ false
  ] ifFalse:[
    res == -1 ifTrue:[ self _waitForReadReady ] "can happen due to SSL renegotiation"
              ifFalse:[ ^ res ].
  ].
].
%

category: 'Private'
method: GsSecureSocket
_zeroArgSslPrim: opcode

"opcode  function
   1     instance method: secureConnect
   2     instance method: secureAccept
   3     instance method: hasSecureConnection
   4     instance method: secureClose
   5     instance method: fetchLastIoErrorString
   6        class method: fetchErrorStringArray
   7        class method: clearErrorQueue
   8        class method: disableCertificateVerificationOnClient
   9        class method: enableCertificateVerificationOnClient
  10        class method: disableCertificateVerificationOnServer
  11        class method: enableCertificateVerificationOnServer
  12     instance method: initializeAsClient
  13     instance method: initializeAsServer
  14        class method: fetchLastCertificateVerificationErrorForServer
  15        class method: fetchLastCertificateVerificationErrorForClient
  16     instance method: fetchCipherDescription
  17     instance method: disableCertificateVerification
  18     instance method: enableCertificateVerification
  19        class method: sslLibraryVersionString
  20     instance method: _peek
  21     instance method: certificateVerificationEnabled
  22        class method: certificateVerificationEnabledOnClient
  23        class method: certificateVerificationEnabledOnServer
  24     instance method: fetchCertificateVerificationOptions
  25        class method: fetchCertificateVerificationOptionsForServer
  26     instance method:  _noFreeSslOnGc
  27     instance method: getServerNameIndication
  28     instance method: tlsMinVersion
  29     instance method: tlsMaxVersion
  30        class method: tlsServerMinVersion
  31        class method: tlsServerMaxVersion
  32        class method: tlsClientMinVersion
  33        class method: tlsClientMaxVersion
  34     instance method: tlsActualVersion
  35     instance method: peerCertificate
  36     instance method: peerCertificateChain
  37     instance method: peerName
"
<primitive: 908>
^ self _primitiveFailed: #_zeroArgSslPrim: args: { opcode }
%

! Class implementation for 'GsSshSocket'

!		Class methods for 'GsSshSocket'

category: 'Instance Creation'
classmethod: GsSshSocket
basicNew

"disallowed"

self shouldNotImplement: #basicNew
%

category: 'Defaults'
classmethod: GsSshSocket
defaultPortNumber
"Default ssh port number is 22"
	^22
%

category: 'Debugging'
classmethod: GsSshSocket
disableTraceFile

"Disables tracing previosly enabled by the enableTraceFileInDirectory: method.
Returns true."

^ self _zeroArgSshPrim: 100
%

category: 'Debugging'
classmethod: GsSshSocket
enableTraceFileInDirectory: aDirectory

"Creates a text file in aDirectory and writes logging information to that file.
The logging level may be set by setLogLevel: class method.
Returns true on success or raises an error if the diretory does not exist"

^ self _oneArgSshPrim: 100 with: aDirectory
%

category: 'Examples'
classmethod: GsSshSocket
exampleHost
"Answer a string containing the host domain name of the test ssh server maintained by GemTalk."
^ 'ssh-test.gemtalksystems.com'
%

category: 'Examples'
classmethod: GsSshSocket
exampleOpenSshPrivateKey
"Return aGsSshPrivateKey that may be used to access the ssh test server at ssh-test.gemtalksystems.com"

^GsSshPrivateKey newFromOpenSshString: self examplePrivateKeyAsOpenSshString
%

category: 'Examples'
classmethod: GsSshSocket
examplePassword
"Answer a string containing the host password of the test ssh server maintained by GemTalk."

^ 'ymPEU9Kxajkbvzx'
%

category: 'Examples'
classmethod: GsSshSocket
examplePrivateKey
"Return aGsTlsPrivateKey that may be used to access the ssh test server at ssh-test.gemtalksystems.com"

^GsTlsPrivateKey newFromPemString: self examplePrivateKeyAsPem
%

category: 'Examples'
classmethod: GsSshSocket
examplePrivateKeyAsOpenSshString

"Private key for the ssh test server at ssh-test.gemtalksystems.com in OpenSSH format"
^ 
'-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAABFwAAAAdzc2gtcn
NhAAAAAwEAAQAAAQEBVeSnL412Ivvpl9LLjmDHXW6SCyxcET4HdF3gomjgCiuWGMOYcYtH
dQeJJ2MuPp8VqvTr6MQ7jpN/SGYrwEaXjdM82wZE4qjq/saGEHZstsi8Hs1cBZWhIaSHc7
JLUiWQNX3jEAX5otxVO3eN2NfHjJkdx6sVH4gHMAfhtLajo+DGdWalx148tTD4rWotVWLH
2s3PDs8s/ewC6idBzV9E+2qUpbshKkBPTYFEUkHK/s+1KpCOAynBOWTNt3MVp4KNhWI43/
68B5JEJA8Bh15WsPr7EOJhgaUsBE6UI9rFyAHhWnlpc1cF9Pl5YI5MZe8DmTwo2GyYliCO
/eBWJvny6wAAA8DnxJPA58STwAAAAAdzc2gtcnNhAAABAQFV5KcvjXYi++mX0suOYMddbp
ILLFwRPgd0XeCiaOAKK5YYw5hxi0d1B4knYy4+nxWq9OvoxDuOk39IZivARpeN0zzbBkTi
qOr+xoYQdmy2yLwezVwFlaEhpIdzsktSJZA1feMQBfmi3FU7d43Y18eMmR3HqxUfiAcwB+
G0tqOj4MZ1ZqXHXjy1MPitai1VYsfazc8Ozyz97ALqJ0HNX0T7apSluyEqQE9NgURSQcr+
z7UqkI4DKcE5ZM23cxWngo2FYjjf/rwHkkQkDwGHXlaw+vsQ4mGBpSwETpQj2sXIAeFaeW
lzVwX0+Xlgjkxl7wOZPCjYbJiWII794FYm+fLrAAAAAwEAAQAAAQEAizMkarUC422DhwAZ
RqfapAzPw2LVPWPu7w8F1bozdZCXdQ+18ozNlDV0PygffPmSfd9oaYXz5bHiAd0vdQKI1A
KsZVShGVPDEeZMUUmWK7mA9l2QWOm6CBOP3qg6CIEovM67cxurrwZcYXDkvOPl6DWzLUdX
u1XL719WIxi1eZOV6iFvM9e+e4pvAQSksMoWUY611oq1+ilU76NPjvB3E3Qvy3CD0I9K1X
mmVZb4gd/tOH6ZchWmQFb6qO6oMvQ+ySEhWlWRgJ09ZdZ7YeHDSf2KTqISJeLf22kwzxCD
Ggt3v3RiHMyaJD2P61sIOff614OeUBT4AAiLTR6qHYOBmQAAAIAztqwB1/s118RwMfWYE3
ohshPApJDmwvu729bNm3VD15ZrrPpZELmNN1hUM5mfSY/VgIEst3ER4IF89Ue/GlQCnZH8
19Dd8q/av6lRuyHwcow5A6iwj8tSHa1iUmETBSgT8lczBChGZZtXXUpswTdKKZMYZMEm+P
65hJaVa6qIJwAAAIEBv/PhCa2EwYreNg2GmCFK2+8ypOS4+MV3Os5QOyBim+K+XKtoUlrQ
GntrOiyc1KOCMgW52KTcJ2iwQlEDwy1tybDSZJ6sQ9+MDRGBUQ343aE+/lZZITMHvwPCVJ
5fo27z2JRE0tBKg52gl+rZc/zulmpWpg9mcaThIblgq4yUz/cAAACBAMNjX7M/ukckrFNl
Qz+mBppnCMOhLF77lo1TapTx0KIJL29jMaEB2rniP195kiNCNcGd5ipJD5JU+itJfIDUby
63AM4Nix1YoW3CG59pkI73m1NywkVr0bnPWUW+3ED+6Z3xxWWNNyLraBOF0L/DSjxkb9mn
QAD/YmAAizme+Z+tAAAAAAECAwQFBgcICQo=
-----END OPENSSH PRIVATE KEY-----'
%

category: 'Examples'
classmethod: GsSshSocket
examplePrivateKeyAsPem

"Private key for the ssh test server at ssh-test.gemtalksystems.com"
^
'-----BEGIN RSA PRIVATE KEY-----
MIIEpAIBAAKCAQEBVeSnL412Ivvpl9LLjmDHXW6SCyxcET4HdF3gomjgCiuWGMOY
cYtHdQeJJ2MuPp8VqvTr6MQ7jpN/SGYrwEaXjdM82wZE4qjq/saGEHZstsi8Hs1c
BZWhIaSHc7JLUiWQNX3jEAX5otxVO3eN2NfHjJkdx6sVH4gHMAfhtLajo+DGdWal
x148tTD4rWotVWLH2s3PDs8s/ewC6idBzV9E+2qUpbshKkBPTYFEUkHK/s+1KpCO
AynBOWTNt3MVp4KNhWI43/68B5JEJA8Bh15WsPr7EOJhgaUsBE6UI9rFyAHhWnlp
c1cF9Pl5YI5MZe8DmTwo2GyYliCO/eBWJvny6wIDAQABAoIBAQCLMyRqtQLjbYOH
ABlGp9qkDM/DYtU9Y+7vDwXVujN1kJd1D7XyjM2UNXQ/KB98+ZJ932hphfPlseIB
3S91AojUAqxlVKEZU8MR5kxRSZYruYD2XZBY6boIE4/eqDoIgSi8zrtzG6uvBlxh
cOS84+XoNbMtR1e7VcvvX1YjGLV5k5XqIW8z1757im8BBKSwyhZRjrXWirX6KVTv
o0+O8HcTdC/LcIPQj0rVeaZVlviB3+04fplyFaZAVvqo7qgy9D7JISFaVZGAnT1l
1nth4cNJ/YpOohIl4t/baTDPEIMaC3e/dGIczJokPY/rWwg59/rXg55QFPgACItN
Hqodg4GZAoGBAb/z4QmthMGK3jYNhpghStvvMqTkuPjFdzrOUDsgYpvivlyraFJa
0Bp7azosnNSjgjIFudik3CdosEJRA8Mtbcmw0mSerEPfjA0RgVEN+N2hPv5WWSEz
B78DwlSeX6Nu89iURNLQSoOdoJfq2XP87pZqVqYPZnGk4SG5YKuMlM/3AoGBAMNj
X7M/ukckrFNlQz+mBppnCMOhLF77lo1TapTx0KIJL29jMaEB2rniP195kiNCNcGd
5ipJD5JU+itJfIDUby63AM4Nix1YoW3CG59pkI73m1NywkVr0bnPWUW+3ED+6Z3x
xWWNNyLraBOF0L/DSjxkb9mnQAD/YmAAizme+Z+tAoGBAb88Jroa3CjAFQuyhWbu
Fmdvcgjfsy3tORUlV0UxGEK7J4QuPoG62XsXLf9u+0Xx2dNHlD2Qm51dEF2ltTPw
72QnfmenZCZ/0rxZddsPMCFXFCWq4GIdKOa1Qhhp5uKtrBfYML6p5ztw7R3ABEuh
hDP5B3nUdluQWpXpF3MvcIQRAoGAckTT20kR8DmKbttyEO9QPUy023SPNp181vpK
AwHJOnqUu1gP1lH3UW74ESZQST6Xobxut5wy9ymrhVVc8xtKSs/MMLXK/kavYjl7
Xiem23YD6THcXC1KYpjZZOjSd1Cd4DldcJ69+DYkkAZap0vXRqqWn3wo+mxhZDPt
OK2436ECgYAztqwB1/s118RwMfWYE3ohshPApJDmwvu729bNm3VD15ZrrPpZELmN
N1hUM5mfSY/VgIEst3ER4IF89Ue/GlQCnZH819Dd8q/av6lRuyHwcow5A6iwj8tS
Ha1iUmETBSgT8lczBChGZZtXXUpswTdKKZMYZMEm+P65hJaVa6qIJw==
-----END RSA PRIVATE KEY-----'
%

category: 'Examples'
classmethod: GsSshSocket
exampleUserId
"Answer a string containing the user ID for the test ssh server maintained by GemTalk."

^ 'sshtest'
%

category: 'Debugging'
classmethod: GsSshSocket
getSshLogLevel

"Returns a symbol representing the global logging level.  Valid levels are:
     #SSH_LOG_NOLOG -no logging
     #SSH_LOG_WARNING -only warnings
     #SSH_LOG_PROTOCOL -high level protocol information
     #SSH_LOG_PACKET -lower level protocol infomations, packet level
     #SSH_LOG_FUNCTIONS -every function path"

^ self _zeroArgSshPrim: 101
%

category: 'Connection Testing'
classmethod: GsSshSocket
hostIsAvailableForSsh: aHostOrIp
"Answer a boolean indicating if host aHostOrIp is accepting connections on the default ssh port (22).
The connection attempt will block for a 1 second."

^self hostIsAvailableForSsh: aHostOrIp atPort: self defaultPortNumber withTimeout: 1000
%

category: 'Connection Testing'
classmethod: GsSshSocket
hostIsAvailableForSsh: aHostOrIp atPort: portNum withTimeout: timeoutMs

"Answer a boolean indicating if host aHostOrIp is accepting connections on port portNum.
The connection attempt will block for a maximum of timeoutMs."

|sshSock |
sshSock := self newClient.
^ [
 [ sshSock connectTo: portNum on: aHostOrIp timeoutMs: timeoutMs ] on: SocketError do:[:ex|  false ]
] ensure:[ sshSock close ]
%

category: 'Connection Testing'
classmethod: GsSshSocket
hostIsAvailableForSsh: aHostOrIp withTimeout: timeoutMs

"Answer a boolean indicating if host aHostOrIp is accepting connections on the default ssh port (22).
The connection attempt will block for a maximum of timeoutMs."

^self hostIsAvailableForSsh: aHostOrIp atPort: self defaultPortNumber withTimeout: timeoutMs
%

category: 'Version'
classmethod: GsSshSocket
libSshVersion
"Answer a string representing the version of the libssh library"

^ self _zeroArgSshPrim: 102
%

category: 'Examples'
classmethod: GsSshSocket
nbSshClientExample1

"Example of remote ssh command using non-blocking protocol with userId / password authentication.

GsSshSocket nbSshClientExample1"

^ self nbSshClientExampleToHost: self exampleHost userId: self exampleUserId password: self examplePassword
%

category: 'Examples'
classmethod: GsSshSocket
nbSshClientExample2

"Example of remote ssh command using non-blocking protocol with PKI authentication.

GsSshSocket nbSshClientExample2"

^ self nbSshClientExampleToHost: self exampleHost withUserId: self exampleUserId privateKey: self examplePrivateKey
%

category: 'Examples'
classmethod: GsSshSocket
nbSshClientExample3

"Example of remote ssh command using non-blocking protocol with PKI authentication.

GsSshSocket nbSshClientExample3"

^ self nbSshClientExampleToHost: self exampleHost withUserId: self exampleUserId privateKey: self exampleOpenSshPrivateKey
%

category: 'Examples'
classmethod: GsSshSocket
nbSshClientExampleToHost: aHostOrIp userId: id password: pw
"Non-blocking ssh example. All ssh methods that start with 'nb' are non-blocking"

|sshSock result timeoutMs |
"Uncomment to generate trace file in /tmp"
"GsSshSocket enableTraceFileInDirectory: '/tmp' ."

"Create a new instance and do a normal socket connect"
sshSock := GsSshSocket newClient.
[sshSock connectTo: 22 on: aHostOrIp] onException: (SocketError, SshSocketError) do:[:ex|
	sshSock close.
	ex pass
].

"Set credentials. This step is not needed if doing passwordless ssh login with a public key in ~/.ssh directory"
sshSock userId: id ; password: pw .

"Disable authenticating the remote host"
sshSock disableHostAuthentication .

"ssh connect and wait for connection to finish for up to 10 seconds"
timeoutMs := 10000 .
sshSock nbSshConnectTimeout: timeoutMs .

"Start a remote command"
sshSock  nbExecuteRemoteCommand: 'ulimit -a'.
"Wait for remote command to finish"
sshSock nbRemoteCommandResultReadyWithin: timeoutMs .
result := sshSock nbRemoteCommandResult .
sshSock close.
^ result
%

category: 'Examples'
classmethod: GsSshSocket
nbSshClientExampleToHost: aHostOrIp withUserId: aUserId privateKey: aTlsPrivateKey
"Non-blocking ssh example. All ssh methods that start with 'nb' are non-blocking"

|sshSock result timeoutMs |
"Uncomment to generate trace file in /tmp"
"GsSshSocket enableTraceFileInDirectory: '/tmp' ."

"Create a new instance and do a normal socket connect"
sshSock := GsSshSocket newClient.
[sshSock connectTo: 22 on: aHostOrIp] onException: (SocketError, SshSocketError) do:[:ex|
	sshSock close.
	ex pass
].

"Set credentials. This step is not needed if doing passwordless ssh login with a public key in ~/.ssh directory"
sshSock userId: aUserId ; privateKey: aTlsPrivateKey .

"Disable authenticating the remote host"
sshSock disableHostAuthentication .

timeoutMs := 10000 .
"ssh connect and wait for connection to finish"
sshSock nbSshConnectTimeout: timeoutMs .

"Start a remote command"
sshSock  nbExecuteRemoteCommand: 'ulimit -a'.
"Wait for remote command to finish"
sshSock nbRemoteCommandResultReadyWithin: timeoutMs .
result := sshSock nbRemoteCommandResult .
sshSock close.
^ result
%

category: 'Instance Creation'
classmethod: GsSshSocket
new
  self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: GsSshSocket
new: aSize
  self shouldNotImplement: #new:
%

category: 'Instance Creation'
classmethod: GsSshSocket
newClient

"Creates a new instance and initializes it to act as a AF_INET client socket.
 No connection is made."

^ super new initializeAsClient
%

category: 'Instance Creation'
classmethod: GsSshSocket
newClientFromGsSocket: aGsSocket

	self shouldNotImplement: #newClientFromGsSocket:
%

category: 'Instance Creation'
classmethod: GsSshSocket
newClientIpv6

"Creates a new instance and initializes it to act as a AF_INET6 client socket.
 No connection is made."

^ super newIpv6 initializeAsClient
%

category: 'Instance Creation'
classmethod: GsSshSocket
newClientIpv6FromGsSocket: aGsSocket

self shouldNotImplement: #newClientIpv6FromGsSocket:
%

category: 'Debugging'
classmethod: GsSshSocket
setTraceFileLevel: aSymbol

"Sets the global ssh logging level.  Valid levels are:
     #SSH_LOG_NOLOG -no logging
     #SSH_LOG_WARNING -only warnings
     #SSH_LOG_PROTOCOL -high level protocol information
     #SSH_LOG_PACKET -lower level protocol infomations, packet level
     #SSH_LOG_FUNCTIONS -every function path

Log data are written to the trace file if a trace file is active (see the #enableTraceFileInDirectory: method).
If a trace file is not active, log data are written to stdout.
Returns true on success or raises an exception if aSymbol is not a valid ssh logging level"

^ self _oneArgSshPrim: 101 with: aSymbol
%

category: 'Examples'
classmethod: GsSshSocket
sshClientExample1

"Example of an remote ssh command using blocking protocol with userId / password authentication.

GsSshSocket sshClientExample1"

^ self sshClientExampleToHost: self exampleHost userId: self exampleUserId password: self examplePassword
%

category: 'Examples'
classmethod: GsSshSocket
sshClientExample2

"Example of an remote ssh command using blocking protocol with PKI authentication.

GsSshSocket sshClientExample2"

^ self sshClientExampleToHost: self exampleHost userId: self exampleUserId privateKey: self examplePrivateKey
%

category: 'Examples'
classmethod: GsSshSocket
sshClientExample3

"Example of an remote ssh command using blocking protocol with PKI authentication.

GsSshSocket sshClientExample3"

^ self sshClientExampleToHost: self exampleHost userId: self exampleUserId privateKey: self exampleOpenSshPrivateKey
%

category: 'Examples'
classmethod: GsSshSocket
sshClientExampleToHost: aHostOrIp userId: id password: pw

"Blocking ssh example. All ssh methods below block until completion"

|sshSock result |
"Uncomment to generate trace file in /tmp"
"GsSshSocket enableTraceFileInDirectory: '/tmp' ."
sshSock := GsSshSocket newClient.
[sshSock connectTo: 22 on: aHostOrIp] onException: (SocketError, SshSocketError) do:[:ex|
	sshSock close.
	ex pass
].

"Set userId / password for test server"
sshSock userId: id ; password: pw .

"Disable authenticating the remote host"
sshSock disableHostAuthentication .

sshSock sshConnect .
result := sshSock  executeRemoteCommand: 'ulimit -a'.
sshSock close.
^ result
%

category: 'Examples'
classmethod: GsSshSocket
sshClientExampleToHost: aHostOrIp userId: id privateKey: aGsTlsPrivatreKey

"Blocking ssh example. All ssh methods below block until completion"

|sshSock result |
"Uncomment to generate trace file in /tmp"
"GsSshSocket enableTraceFileInDirectory: '/tmp' ."
sshSock := GsSshSocket newClient.
[sshSock connectTo: 22 on: aHostOrIp] onException: (SocketError, SshSocketError) do:[:ex|
	sshSock close.
	ex pass
].
"Set userId / password for test server"
sshSock userId: id ; privateKey: aGsTlsPrivatreKey .

"Disable authenticating the remote host"
sshSock disableHostAuthentication .

sshSock sshConnect .
result := sshSock  executeRemoteCommand: 'ulimit -a'.
sshSock close.
^ result
%

category: 'Debugging'
classmethod: GsSshSocket
traceFileName
"Return a string representing the file name of the trace file or nil if the trace file is not active."

^ self _zeroArgSshPrim: 103
%

category: 'Private'
classmethod: GsSshSocket
_oneArgSshPrim: opcode with: arg1
"GsSshSocket opCodes
opcode	method
1		instance method: hostAuthenticationEnabled:
2		instance method: password:
3		instance method: privateKey:
4		instance method: executeRemoteCommand:
5		instance method: makeBlocking / makeNonBlocking
6		instance method: nbExecuteRemoteCommand:
100		class method enableTraceFileInDirectory:
101		class method setSshTraceLevel:

GsSftpSocket opCodes
50		instance method: contentsOfRemoteDirectory
51		instance method: removeRemoteDirectory:
52		instance method: contentsAndStatDetailsOfRemoteDirectory:
53		instance method: removeRemoteFile:
54		instance method: stat:
55		instance method: lstat:
"
<primitive: 903>
^ self _primitiveFailed: #_oneArgSshPrim:with: args: { opcode }
%

category: 'Private'
classmethod: GsSshSocket
_zeroArgSshPrim: opcode

"GsSshSocket opCodes
opcode  method
1		instance method: initializeAsClient
2		instance method: initializeAfterConnect
3		instance method _sshConnect
4		instance method hasSshConnectInProgress
5		instance method _sshClose
6		instance method nbRemoteCommandResult
7		instance method: hasCommandInProgress
8		instance method isBlocking
9		instance method nbRemoteCommandResultReady
100		class method disableTraceFile
101 	class method getSshLogLevel
102		class method libSshVersion
103		class method traceFileName

GsSftpSocket opCodes
opcode  method
50		instance method: currentRemoteDirectory

GsSftpRemoteFile opCodes
opcode  method
70		instance method: close
"
<primitive: 902>
^ self _primitiveFailed: #_zeroArgSshPrim: args: { opcode }
%

!		Instance methods for 'GsSshSocket'

category: 'Unsupported Operations'
method: GsSshSocket
accept

"Server operations are not supported"
^self shouldNotImplement: #accept
%

category: 'Unsupported Operations'
method: GsSshSocket
acceptTimeoutMs: timeoutMs

"Server operations are not supported"
^self shouldNotImplement: #acceptTimeoutMs:
%

category: 'Socket Operations'
method: GsSshSocket
close
"Closes the ssh connection and the underlying GsSocket socket and frees the associated data structures.
Returns the receiver.
Closing a GsSshSocket more than once has no effect and does not raise an exception."

super close.
^ self _sshClose
%

category: 'Client Operations'
method: GsSshSocket
connectTo: portNumber on: aHost timeoutMs: timeoutMs

"Connect the receiver to the server socket identified by portNumber and aHost.
aHost may be the name of the host or its numeric address,
or aHost == -1 for <broadcase> , or aHost == nil for IN6ADDR_ANY_INIT .
portNumber maybe either a SmallInteger, or the String name of a service.
timeoutMs is a SmallInteger specifying maximum time to wait for the
connection to complete, or -1 to wait indefinitely.
If aHost is the name of a host, connect is attempted on IPv4 first
if getaddrinfo returns any IPv4 addresses for aHost, then attempted
on IPv6.
Returns true if the connection succeeded otherwise signals an Error.

Note: This method initiates the socket-level TCP/IP connection only, not the ssh connection.
To initiate the ssh connection, use the #sshConnect method.
 "

(super connectTo: portNumber on: aHost timeoutMs: timeoutMs)
  ifTrue:[ self initializeAfterConnect: aHost  ] .
^ true
%

category: 'Client Operations'
method: GsSshSocket
connectToHost: aHost timeoutMs: timeoutMs

"Connect the receiver to the default server ssh port (22) on the server aHost.
See the method connectTo:on:timeoutMs: for more details. "

(super connectTo: self class defaultPortNumber on: aHost timeoutMs: timeoutMs)
  ifTrue:[ self initializeAfterConnect: aHost ] .
^ true
%

category: 'Updating'
method: GsSshSocket
disableHostAuthentication
"Disables authentication of the host server's public key.
Host authentication is enabled by default, meaning the host's public key must appear in known_hosts file.
Returns the receiver or raises an exception on error.

*** WARNING ***
Disabling host authentication exposes the connection to man in the middle attacks.
Do not disable host authentication unless you are certain the server host can be trusted."

^ self _hostAuthenticationEnabled: false
%

category: 'Debugging'
method: GsSshSocket
disableTracing
"Disables tracing on the receiver"
^ self sshOptionAt: #SSH_OPTIONS_LOG_VERBOSITY put: #SSH_LOG_NOLOG
%

category: 'Updating'
method: GsSshSocket
enableHostAuthentication
"Enables authentication of the host server's public key.
Host authentication is enabled by default, meaning the host's public key must appear in known_hosts file.
Returns the receiver or raises an exception on error."

^ self _hostAuthenticationEnabled: true
%

category: 'Debugging'
method: GsSshSocket
enableTracing

"Enables tracing on the receiver at the ssh protocol level"

^ self sshOptionAt: #SSH_OPTIONS_LOG_VERBOSITY put:  #SSH_LOG_PROTOCOL
%

category: 'Client Operations'
method: GsSshSocket
executeRemoteCommand: aString
"Places the receiver in blocking mode and tells ssh to execute aString on the server.
Blocks the main thread until the command is complete.
Returns a String representing is the result of the remote command. If the remote command succeeds but returns no output, an empty string is returned.
Raises an exception if the remote command is interrupted by a signal or if the remote command returns a non-zero exit status.
Also raises an exception if an error occurs.
"

^ self makeBlocking ; _oneArgSshPrim: 4 with: aString
%

category: 'Testing'
method: GsSshSocket
hasNbCommandInProgress

"Returns a boolean indicating if there is a non-blocking command in progress."

^self _zeroArgSshPrim: 7
%

category: 'Testing'
method: GsSshSocket
hasNbSshConnectInProgress
"Returns a Boolean which indicates if the receiver has a non-blocking sshConnect operation in progress."

^ self _zeroArgSshPrim: 4
%

category: 'Client Operations'
method: GsSshSocket
hostAuthenticationEnabled: aBoolean
"Enables or disables authentication of the server's public key.
Host authentication is enabled by default, meaning the host's public key must appear in known_hosts file.

Returns the receiver or raises an exception on error.
Warning: disabling host authentication exposes the session to man in the middle attacks."

^ self _oneArgSshPrim: 1 with: aBoolean
%

category: 'Private'
method: GsSshSocket
initializeAfterConnect: host

"Performs ssh initialization after the underlying socket has been connected.
Returns the receiver"

self sshOptionAt: #SSH_OPTIONS_HOST put: host .
^ self _zeroArgSshPrim: 2
%

category: 'Private'
method: GsSshSocket
initializeAsClient

"Returns the receiver"
^ self _zeroArgSshPrim: 1
%

category: 'Testing'
method: GsSshSocket
isBlocking
"Returns a Boolean indicating if the receiver is in blocking mode."

^ self _zeroArgSshPrim: 8
%

category: 'Testing'
method: GsSshSocket
isHostAuthenticationEnabled
"Answers a Boolean indicating if authentication of the server host's public key is performed as part of the sshConnect process."

^ self _hostAuthenticationEnabled: nil
%

category: 'Testing'
method: GsSshSocket
isNonBlocking
"Returns a Boolean indicating if the receiver is in non-blocking mode."

^ self isBlocking not
%

category: 'Updating'
method: GsSshSocket
makeBlocking

"Puts the receiver in blocking mode if it is not.
The blocking mode of a GsSshSocket may not be modified
if a non-blocking remote command or sshConnect operation is in progress.
An exception will be raised in this case."

self isBlocking ifFalse:[ self _oneArgSshPrim: 5 with: true ] .
^ self
%

category: 'Unsupported Operations'
method: GsSshSocket
makeListener: queueLength

"Server operations are not supported"
^self shouldNotImplement: #makeListener:
%

category: 'Updating'
method: GsSshSocket
makeNonBlocking
"Puts the receiver in non-blocking mode if it is not.
The blocking mode of a GsSshSocket may not be modified
if a non-blocking remote command or sshConnect operation is in progress.
An exception will be raised in this case."

self isNonBlocking ifFalse:[ self _oneArgSshPrim: 5 with: false ] .
^ self
%

category: 'Unsupported Operations'
method: GsSshSocket
makeServer

"Server operations are not supported"
^self shouldNotImplement: #makeServer
%

category: 'Unsupported Operations'
method: GsSshSocket
makeServer: queueLength

"Server operations are not supported"
^self shouldNotImplement: #makeServer:
%

category: 'Unsupported Operations'
method: GsSshSocket
makeServer: queueLength atPort: portNum atAddress: address

"Server operations are not supported"
^self shouldNotImplement: #makeServer:atPort:atAddress:
%

category: 'Client Operations (Non-blocking)'
method: GsSshSocket
nbExecuteRemoteCommand: aString
"Places the receiver in blocking mode and tells ssh to execute aString on the server.

Only one remote command may be in progress at any time. Attempting to start
a second remote command before the first has completed raises an error.

Use the nbRemoteCommandStatus to query the progress of the remote command
and the nbRemoteCommandResult to complete the remote command and return
the result as a String object.

Returns false to indicate the remote command was started but has not yet finished executing.
The #nbRemoteCommandResult method should be used to obtain the result.
Raises an exception if an error occurs."

^ self makeNonBlocking ; _oneArgSshPrim: 6 with: aString
%

category: 'Client Operations (Non-blocking)'
method: GsSshSocket
nbRemoteCommandResult

"Attempts to completes a remote command in progress. If the command has completed,
return a String representing the result of the command. Remote commands that complete successfully
but generate no output will result in an empty string.
Returns false if the remote command has not yet completed.
Raises an exception if no remote command is in progress. Also raises an
exception if the remote command fails (exit status is not zero) or if the remote command
was interrupted by a signal.

The readWillNotBlockWithin: method may be used to determine when the remote command has
made progress and this method should be run again. Note that this method may need to be repeated several times
after readWillNotBlockWithin: returns true because performing the remote command may
involve several steps internally."

^self _zeroArgSshPrim: 6
%

category: 'Client Operations (Non-blocking)'
method: GsSshSocket
nbRemoteCommandResultReady
"Attempts to advance the progress of a remote command in progress.
Returns true if the remote command has completed. Use the nbRemoteCommandResult method to obtain the result.
Returns false if the remote command has not yet completed
Raises an exception if no remote command is in progress. Also raises an
exception if the remote command fails (exit status is not zero) or if the remote command
was interrupted by a signal.

The readWillNotBlockWithin: method may be used to determine when the remote command has
made progress and this method should be run again. Note that this method may need to be repeated several times
after readWillNotBlockWithin: returns true because performing the remote command may
involve several steps internally."

^self _zeroArgSshPrim: 9
%

category: 'Client Operations (Non-blocking)'
method: GsSshSocket
nbRemoteCommandResultReadyWithin: timeoutMs

"Attempts to advance the progress of a remote command in progress.
Returns true if the remote command has completed. Use the nbRemoteCommandResult method to obtain the result.
Raises an exception if the remote command has not completed within timeoutMs. Also
raises an exception if no remote command is in progress or if the remote command fails
(exit status is not zero) or if the remote command was interrupted by a signal."

| endTime failed sys |
sys := System .
endTime := sys _timeMs + timeoutMs .
failed := false .
[ failed ] whileFalse: [ 	| timeLeftMs |
	self nbRemoteCommandResultReady ifTrue:[ ^ true ].
	timeLeftMs := endTime  - sys _timeMs .
	timeLeftMs > 0
		ifTrue:[ failed := true ~~ (self readWillNotBlockWithin: timeLeftMs) ]
		ifFalse:[ failed := true ].
].

^ SshSocketError signal: ('nbRemoteCommandResultReadyWithin: timed out after ', timeoutMs asString, ' ms ')
%

category: 'Client Operations (Non-blocking)'
method: GsSshSocket
nbSshConnect

"Places the receiver in non-blocking mode and connects to the ssh server.
Returns true on success and false if the operation is in progress and must be retried.
Raises an exception on error."

self makeNonBlocking .
^ self _sshConnect .
%

category: 'Client Operations (Non-blocking)'
method: GsSshSocket
nbSshConnectTimeout: timeoutMs

"Places the receiver in non-blocking mode and connects to the ssh server.
Returns true on success and false if the operation is in progress and must be retried.
Raises an exception on error."

|  endTime failed sys |
self makeNonBlocking .
sys := System .
endTime := sys _timeMs + timeoutMs .
failed := false .
[ failed ] whileFalse: [ 	| timeLeftMs |
	self nbSshConnect ifTrue:[ ^ true ].
	timeLeftMs := endTime  - sys _timeMs .
	timeLeftMs > 0
		ifTrue:[ failed := true ~~ (self readWillNotBlockWithin: timeLeftMs) ]
		ifFalse:[ failed := true ].
].

^ SshSocketError signal: ('nbSshConnectTimeout timed out after ', timeoutMs asString, ' ms ')
%

category: 'Client Operations'
method: GsSshSocket
password: aString

"Forces authentication by user ID / password and sets the password to use for authentication.
Returns the receiver or raises an error if aString is not an instance of String or if aString is empty"

^ self _oneArgSshPrim: 2 with: aString
%

category: 'Client Operations'
method: GsSshSocket
privateKey: aPrivateKey
"Tells ssh to use the specified private key to authenticate the user.
 aPrivate key must be an instance of either GsTlsPrivateKey or GsSshPrivateKey."

^ self _oneArgSshPrim: 3 with: aPrivateKey
%

category: 'Unsupported Operations'
method: GsSshSocket
recvfrom: maxBytes

"UDP operations are not supported"
^self shouldNotImplement: #recvfrom:
%

category: 'Accessing'
method: GsSshSocket
remoteHost

^ self sshOptionAt:  #SSH_OPTIONS_HOST
%

category: 'Unsupported Operations'
method: GsSshSocket
sendUdp: aString flags: flagsInt toHost: hostName port: aPort

"UDP operations are not supported"
^self shouldNotImplement: #sendUdp:flags:toHost:port:
%

category: 'Unsupported Operations'
method: GsSshSocket
shutdownReading

^ self shouldNotImplement: #shutdownReading
%

category: 'Unsupported Operations'
method: GsSshSocket
shutdownReadingAndWriting

^ self shouldNotImplement: #shutdownReadingAndWriting
%

category: 'Unsupported Operations'
method: GsSshSocket
shutdownWriting

^ self shouldNotImplement: #shutdownWriting
%

category: 'Error Reporting'
method: GsSshSocket
signalError
  ^ SshSocketError signal: 'no details'
%

category: 'Error Reporting'
method: GsSshSocket
signalError: aString
  ^ SshSocketError signal: aString
%

category: 'Unsupported Operations'
method: GsSshSocket
speciesForAccept

"Server operations are not supported"
^self shouldNotImplement: #speciesForAccept
%

category: 'Client Operations'
method: GsSshSocket
sshConnect

"Places the receiver in blocking mode and connects the receiver to the ssh server.
 Returns true on success or raises an exception on error."

^ self makeBlocking ; _sshConnect
%

category: 'Configuration'
method: GsSshSocket
sshOptionAt: optionName
"Gets the value of the specified option.
 Not all setable options are accessible by this method. This is a limitation of the underlying libssh package.
 Returns string showing the value of the specified option or an empty string if the option has not yet been set,
 except for #SSH_OPTIONS_PORT, which returns a SmallInteger.

 Raises an exception if an error occurred.

 optionName may be any of the following symbols:

 #SSH_OPTIONS_FD - The file descriptor of the ssh socket or -1 if it has not been set yet.
 #SSH_OPTIONS_HOST - The hostname or ip address of the peer.
 #SSH_OPTIONS_PORT - The port to connect to.
 #SSH_OPTIONS_USER - The username for authentication.
 #SSH_OPTIONS_KNOWNHOSTS - The known hosts file name.
 #SSH_OPTIONS_GLOBAL_KNOWNHOSTS - The global known hosts file name.
 #SSH_OPTIONS_PROXYCOMMAND - Get the command to be executed in order to connect to the server.
"

^ self _twoArgSshPrim: 1 with: optionName with: nil
%

category: 'Configuration'
method: GsSshSocket
sshOptionAt: optionName put: value

"Sets the value of the specified option.
 Returns the receiver or an exception if an error occurred.
 optionName can be any of the following symbols:

 #SSH_OPTIONS_HOST - The hostname or ip address to connect to
  Kind: String, Default: none (must be specified)

 #SSH_OPTIONS_PORT - The port to connect to.
  Kind: SmallInteger, Default: 22, Min: 1, Max: 65535

 #SSH_OPTIONS_FD - The file descriptor to use.
  Kind: SmallInteger, Default: assigned at instance creation.

 #SSH_OPTIONS_BINDADDR - The address to bind the client to.
  Kind: String, Default: none (assigned by operating system).

 #SSH_OPTIONS_USER - The username for authentication.
  Kind: String, Default: UNIX user id.

 #SSH_OPTIONS_SSH_DIR - Set the ssh directory.
  The ssh directory is used for files like known_hosts and identity (private and
  public key). It may include '%s' which will be replaced by the user home
  directory.
  Kind: String, Default: ~/.ssh

 #SSH_OPTIONS_KNOWNHOSTS - Set the known hosts file name.
  The known hosts file is used to certify remote hosts are genuine. It may
  include '%d' which will be replaced by the user home directory.
  Kind: String, Default: ~/.ssh/known_hosts.

 #SSH_OPTIONS_GLOBAL_KNOWNHOSTS - Set the global known hosts file name.
  The known hosts file is used to certify remote hosts are genuine.
  Kind: String, Default: /etc/ssh/ssh_known_hosts

 #SSH_OPTIONS_ADD_IDENTITY - Add a new identity file name to the identity list.
  The identity used to authenticate with public key will be prepended to the
  list. It may include '%s' which will be replaced by the user home directory.
  Kind: String, Defaults: ~/.ssh/id_rsa  ~/.ssh/id_dsa

 #SSH_OPTIONS_TIMEOUT - Set a timeout for the connection in seconds.
  -1 means wait forever.
  Kind: SmallInteger, Default: 10, Min: -1, Max: 4294967294

 #SSH_OPTIONS_TIMEOUT_USEC - Set a timeout for the connection in microseconds.
  -1 means wait forever.
  Kind: SmallInteger, Default: 10000000, Min: -1, Max: 4294967294

 #SSH_OPTIONS_LOG_VERBOSITY - Set the session logging verbosity.
  The verbosity of the log messages. Every log smaller or equal to verbosity will
  be shown. Log data are written to the trace file if a trace file is active
  (see GsSshSocket (c) enableTraceFileInDirectory: method). If the trace
  file is not active, log data are written to stdout.

  Possible values:
     #SSH_LOG_NOLOG -no logging
     #SSH_LOG_WARNING -only warnings
     #SSH_LOG_PROTOCOL -high level protocol information
     #SSH_LOG_PACKET -lower level protocol infomations, packet level
     #SSH_LOG_FUNCTIONS -every function path
  Kind: Symbol, Default: #SSH_LOG_NOLOG

 #SSH_OPTIONS_COMPRESSION_C_S - Enable/disable the zlib compression for sending
  from client to server.
  Kind: Boolean, Default: false (compression disabled)

 #SSH_OPTIONS_COMPRESSION_S_C - Enable/disable the zlib compression for sending
  from server to client.
  Kind: Boolean, Default: false (compression disabled)

 #SSH_OPTIONS_COMPRESSION - Enable/disable compression to use for both directions
  communication (client->server and server->client).
  Kind: Boolean, Default: false

 #SSH_OPTIONS_COMPRESSION_LEVEL - Set the zlib compression level to use for
  zlib functions. 1 means fastest and lowest compression. 9 means slowest and
  highest compression. Compression must also be enabled via one of the
  SSH_OPTIONS_COMPRESSSION* options otherwise this option has no effect.
  Kind: SmallInteger, Default: 7

 #SSH_OPTIONS_STRICTHOSTKEYCHECK - If this option is set to true, ssh will never
  automatically add host keys to the ~/.ssh/known_hosts file, and refuses to
  connect to hosts whose host key has changed. This provides maximum  protection
  against trojan horse attacks, though it can be annoying when the
  /etc/ssh/ssh_known_hosts file	is poorly maintained or	when connections to new
  hosts are frequently made. This option forces the user to manually add all new
  hosts. If this option is set to false, ssh will automatically add new host keys
  to the user known hosts files.
  Kind: Boolean, Default: true

 #SSH_OPTIONS_PROXYCOMMAND - Set the command to be executed in order to connect to
  server.
  Kind: String, Default: none

 #SSH_OPTIONS_PUBKEY_AUTH
  Set it if pubkey authentication should be used.
  Kind: Boolean, Default: true

 #SSH_OPTIONS_NODELAY
  Set it to disable Nagle's Algorithm (TCP_NODELAY) on the session socket.
  Kind: Boolean, Default: true

 #SSH_OPTIONS_PROCESS_CONFIG
  Set it to false to disable automatic processing of per-user
  and system-wide OpenSSH configuration files. LibSSH
  automatically uses these configuration files unless
  you provide it with this option or with different file.
  Kind: Boolean, Default: false

 #SSH_OPTIONS_REKEY_DATA
  Set the data limit that can be transferred with a single
  key in bytes. RFC 4253 Section 9 recommends 1GB of data, while
  RFC 4344 provides more specific restrictions, that are applied
  automatically. When specified, the lower value will be used.
  Kind: SmallInteger, Default: 1073741824

 #SSH_OPTIONS_REKEY_TIME
  Set the time limit for a session before intializing a rekey
  in seconds. RFC 4253 Section 9 recommends one hour.
  Kind: SmallInteger, Default: 3600"

^ self _twoArgSshPrim: 1 with: optionName with: value
%

category: 'Client Operations'
method: GsSshSocket
userId: aString

"Sets the user ID to use for authentication.
For password authentication, the #password: method must also be called.
For public key authentication, credentials are obtained from the home directory of the specified user ID.
By default, the user ID running the gem process is used."

^ self sshOptionAt: #SSH_OPTIONS_USER put: aString
%

category: 'Private'
method: GsSshSocket
_hostAuthenticationEnabled: aBooleanOrNil
"Enables or disables or queries the state of host authentication (authentication of the server's public key).
Arguments true or false enable or disable host authentication respecitvely and return the receiver.
An argument of nil returns a Boolean indicating the current state of host authentication.

Host authentication is enabled by default, meaning the host's public key must appear in known_hosts file.
Host authentication is performed as part of the sshConnect process.

Returns the receiver or raises an exception on error.
Warning: disabling host authentication exposes the session to man in the middle attacks."

	^self _oneArgSshPrim: 1 with: aBooleanOrNil
%

category: 'Private'
method: GsSshSocket
_oneArgSshPrim: opcode with: arg1

"GsSshSocket opCodes
opcode	method
1		instance method: hostAuthenticationEnabled:
2		instance method: password:
3		instance method: privateKey:
4		instance method: executeRemoteCommand:
5		instance method: makeBlocking / makeNonBlocking
6		instance method: nbExecuteRemoteCommand:
100		class method enableTraceFileInDirectory:
101		class method setSshTraceLevel:

GsSftpSocket opCodes
51		instance method: removeRemoteDirectory:
53		instance method: removeRemoteFile:
54		instance method: stat:
55		instance method: lstat:

GsSftpRemoteFile opCodes:
70		instance method: position:
"
<primitive: 903>
^ self _primitiveFailed: #_oneArgSshPrim:with: args: { opcode }
%

category: 'Unsupported Operations'
method: GsSshSocket
_readInto: aString startingAt: anOffset maxBytes: numBytes

^ self shouldNotImplement: #_readInto:startingAt:maxBytes:
%

category: 'Unsupported Operations'
method: GsSshSocket
_recvfrom: maxBytes

^ self shouldNotImplement: #_recvfrom:
%

category: 'Unsupported Operations'
method: GsSshSocket
_sendUdp: aString startingAt: anOffset to: hostName port: portNum

^ self shouldNotImplement: #_sendUdp:startingAt:to:port:
%

category: 'Private'
method: GsSshSocket
_sshClose

"Private.
Close the socket and free the internal ssh structures but not the GsSocket structures.
Call close instead of this method. Returns the receiver."

^ self _zeroArgSshPrim: 5
%

category: 'Private'
method: GsSshSocket
_sshConnect

"Connects the receiver to the ssh server.
 Returns true on success, false if the connection is in progress on a nonblocking socket, or raises an exception on error.
If the method returns false, the application should wait for the socket to become read-ready and then send
the message again."

^self _zeroArgSshPrim: 3
%

category: 'Private'
method: GsSshSocket
_twoArgSshPrim: opcode with: arg1 with: arg2
"
GsSshSocket opCodes
opcode  function
1	instance methods: sshOptionAt: / sshOptionAt:put:

GsSftpSocket opCodes
50	instance method: createRemoteDirectory:mode:
51	instance method: renameRemoteFile: to:
52	instance method: contentsAndStatDetailsOfRemoteDirectory:withPattern:
53	instance method: contentsOfRemoteDirectorywithPattern:

GsSftpRemoteFile opCodes
70	instance method: read:into:
71	instance method: write:from:
"

<primitive: 904>
^ self _primitiveFailed: #_twoArgSshPrim:with:with: args: {opcode}
%

category: 'Unsupported Operations'
method: GsSshSocket
_write: aByteObject startingAt: anOffset ofSize: numBytes

^ self shouldNotImplement: #_write:startingAt:ofSize:
%

category: 'Unsupported Operations'
method: GsSshSocket
_writev: numBuffers specs: specArray byteOffset: startOffset

^ self shouldNotImplement: #_writev:specs:byteOffset:
%

category: 'Private'
method: GsSshSocket
_zeroArgSshPrim: opcode

"GsSshSocket opCodes
opcode  method
1		instance method: initializeAsClient
2		instance method: initializeAfterConnect
3		instance method _sshConnect
4		instance method hasSshConnectInProgress
5		instance method _sshClose
6		instance method nbRemoteCommandResult
7		instance method: hasCommandInProgress
8		instance method isBlocking
9		instance method nbRemoteCommandResultReady
100		class method disableTraceFile
101 	class method getSshLogLevel
102		class method libSshVersion
103		class method traceFileName

GsSftpSocket opCodes
opcode  method
50		instance method: currentRemoteDirectory

GsSftpRemoteFile opCodes
opcode  method
70		instance method: close
71		instance method: isOpen
72		instance method: fstat
73		instance method: isReadable
74		instance method: isWriteable
75		instance method: isAppendable
76		instance method: position
"
<primitive: 902>
^ self _primitiveFailed: #_zeroArgSshPrim: args: { opcode }
%

! Class implementation for 'GsSftpSocket'

!		Class methods for 'GsSftpSocket'

category: 'Examples'
classmethod: GsSftpSocket
remoteDirectoryExample1

"This example returns an Array of strings which represent the files in the default directory of the sftp server excluding files that have names that start with a dot (.)."

"GsSftpSocket remoteDirectoryExample1"

| sftpSock result  |
sftpSock := GsSftpRemoteFile getSftpSocketExample.
result := sftpSock contentsOfRemoteDirectoryNoDotFiles: '.' .
sftpSock close.
^result
%

category: 'Examples'
classmethod: GsSftpSocket
remoteDirectoryExample2

"This example returns an Array of strings which represent the files in the default directory of the sftp server."

"GsSftpSocket remoteDirectoryExample2"

| sftpSock result  |
sftpSock := GsSftpRemoteFile getSftpSocketExample.
result := sftpSock contentsOfRemoteDirectory: '.' .
sftpSock close.
^result
%

category: 'Examples'
classmethod: GsSftpSocket
remoteDirectoryExample3

"This example returns an Array pairs where the odd elements are strings which represent the files names and the even elements are instances of GsFileStat."

"GsSftpSocket remoteDirectoryExample3"

| sftpSock result  |
sftpSock := GsSftpRemoteFile getSftpSocketExample.
result := sftpSock contentsAndStatDetailsOfRemoteDirectory: '.' .
sftpSock close.
^result
%

category: 'Examples'
classmethod: GsSftpSocket
remoteDirectoryExample4

"This example returns a StringKeyValueDictionary where the keys are strings which represent the files names and the values instances of GsFileStat."

"GsSftpSocket remoteDirectoryExample4"

| sftpSock result  |
sftpSock := GsSftpRemoteFile getSftpSocketExample.
result := sftpSock contentsOfRemoteDirectoryAsDictionary: '.' .
sftpSock close.
^result
%

category: 'Examples'
classmethod: GsSftpSocket
remoteDirectoryExample5

"This example creates a remote directory, retrieves its stat info, then removes the remote directory and returns the stat info."

"GsSftpSocket remoteDirectoryExample5"

| sftpSock result dirName |
sftpSock := GsSftpRemoteFile getSftpSocketExample.
dirName := GsUuidV4 new asString.
sftpSock createRemoteDirectory: dirName.
result := sftpSock stat: dirName .
sftpSock removeRemoteDirectory: dirName ; close .
^result
%

category: 'Examples'
classmethod: GsSftpSocket
remoteDirectoryExample6

"This example creates empty files and searches the remote directory using file name patterns."

"GsSftpSocket remoteDirectoryExample6"

| sftpSock files allFoo allBar myDir myFiles |
sftpSock := GsSftpRemoteFile getSftpSocketExample.
files := { 'foo.bar' . 'bar.foo' . 'a.bar' . 'b.bar' . 'c.bar' }.
"Create zero-size remote files"
myDir := './', GsUuidV4 new asString.
sftpSock createRemoteDirectory: myDir.
myFiles := files collect:[:e| myDir, '/', e].
myFiles do:[:fn| (GsSftpRemoteFile createOrOverwriteRemoteFile: fn withSftpSocket: sftpSock) close ].
allFoo := sftpSock contentsOfRemoteDirectory: myDir matchPattern: '*.foo' .
allBar := sftpSock contentsOfRemoteDirectory: myDir matchPattern: '*.bar' .
myFiles do:[:fn| sftpSock removeRemoteFile: fn  ].
sftpSock removeRemoteDirectory: myDir.
sftpSock close.
^Array with: allFoo with: allBar
%

category: 'Examples'
classmethod: GsSftpSocket
remoteDirectoryExample7

"This example returns a list of subdirectories in the default directory of the sftp server."

"GsSftpSocket remoteDirectoryExample7"

| sftpSock result  |
sftpSock := GsSftpRemoteFile getSftpSocketExample.
result := sftpSock contentsAndStatDetailsOfRemoteDirectory: '.' .
sftpSock close.
^ result select:[:assoc| assoc value isDirectory]
%

category: 'Examples'
classmethod: GsSftpSocket
remoteDirectoryExample8

"This example returns a list of regular files in the default directory of the sftp server."

"GsSftpSocket remoteDirectoryExample8"

| sftpSock result  |
sftpSock := GsSftpRemoteFile getSftpSocketExample.
result := sftpSock contentsAndStatDetailsOfRemoteDirectory: '.' .
sftpSock close.
^ result select:[:assoc| assoc value isDirectory not]
%

!		Instance methods for 'GsSftpSocket'

category: 'Directory Operations'
method: GsSftpSocket
contentsAndStatDetailsOfRemoteDirectory: dirname

"Returns an Array of Associations describing the contents of the given remote directory.
The association keys are the names of files and directories contained in dirname, and the
association values are instances of GsFileStat, which contain details regarding the file named
in the key."

^ self contentsAndStatDetailsOfRemoteDirectory: dirname matchPattern: nil
%

category: 'Directory Operations'
method: GsSftpSocket
contentsAndStatDetailsOfRemoteDirectory: dirname matchPattern: aString

"Returns an Array of Associations describing the contents of the given remote directory.
The association keys are the names of files and directories contained in dirname which match the pattern
in aString, and the association values are instances of GsFileStat, which contain details regarding the file named
in the key.
File name pattern matching is done using the fnmatch() function. Refer to the man page for fnmatch for further details.
If aString is nil, no matching is done and all file names are returned except for directories '.' and '..' ."

^ self _twoArgSshPrim: 52 with: dirname with: aString
%

category: 'Directory Operations'
method: GsSftpSocket
contentsOfRemoteDirectory: dirname

"Returns an Array of file names describing the contents of the given directory."

^ self contentsOfRemoteDirectory: dirname matchPattern: nil
%

category: 'Directory Operations'
method: GsSftpSocket
contentsOfRemoteDirectory: dirname matchPattern: aString

"Returns an Array of file names describing the contents of the given directory which match the search pattern in aString.
 File name matching is done using the fnmatch() function. Refer to the man page for fnmatch for further details.
If aString is nil, no matching is done and all file names are returned except for directories '.' and '..' ."

^ self _twoArgSshPrim: 53 with: dirname with: aString
%

category: 'Directory Operations'
method: GsSftpSocket
contentsOfRemoteDirectoryAsDictionary: dirname
"Returns StringKeyValueDictionary describing the contents of the given remote directory.
The keys are the names of all files and directories contained in dirname and the values
are instances of GsFileStat, which contains details regarding the file named by the key."

^ self contentsOfRemoteDirectoryAsDictionary: dirname matchPattern: nil
%

category: 'Directory Operations'
method: GsSftpSocket
contentsOfRemoteDirectoryAsDictionary: dirname matchPattern: aString
"Returns StringKeyValueDictionary describing the contents of the given remote directory which match the pattern in aString.
File name matching is done using the fnmatch() function. Refer to the man page for fnmatch for further details.
If aString is nil, no matching is done and all file names are returned except for directories '.' and '..' .
The keys are the names of all files and directories contained in dirname and the values
are instances of GsFileStat, which contains details regarding the file named by the key."

| result array |
array := self contentsAndStatDetailsOfRemoteDirectory: dirname matchPattern: aString.
result := StringKeyValueDictionary new: array size.
array do:[:assoc| result at: assoc key put: assoc value ].
^ result

%

category: 'Directory Operations'
method: GsSftpSocket
contentsOfRemoteDirectoryNoDotFiles: dirname

"Same as the contentsOfRemoteDirectory: method except files and directorys which start with a period character (.) are excluded from the result."

^ (self contentsOfRemoteDirectory: dirname) reject:[:each| each first == $. ]
%

category: 'Directory Operations'
method: GsSftpSocket
createRemoteDirectory: dirname

"Creates the named directory on the server host. Returns the receiver on success or raises an exception on error.
The new directory will have the default permissions of 8r770"

^ self createRemoteDirectory: dirname mode: nil
%

category: 'Directory Operations'
method: GsSftpSocket
createRemoteDirectory: dirname mode: modeInt

"Creates the named directory on the server host.
The mode modeInt must be a SmallInteger which is a valid directory mode.
 If modeInt == nil, a value of 8r770 will be used.
Returns the receiver on success or raises an exception on error. "

^ self _twoArgSshPrim: 50 with: dirname with: modeInt
%

category: 'Directory Operations'
method: GsSftpSocket
currentRemoteDirectory

"Returns a string which describes the current remote directory. Raises an exception on error. "

^ self _zeroArgSshPrim: 50
%

category: 'Private'
method: GsSftpSocket
initializeAfterConnect

openFiles := IdentitySet new.
^super initializeAfterConnect
%

category: 'Private'
method: GsSftpSocket
initializeAfterConnect: host

openFiles := IdentitySet new.
^super initializeAfterConnect: host
%

category: 'File Operations'
method: GsSftpSocket
lstat: aFileName

"Functions the same as the stat: method except when the remote file is a symbolic link.
In that case, return an instance of GsFileStat describing the symbolic link rather than the
file referenced by the link."

^ self _oneArgSshPrim: 55 with: aFileName
%

category: 'Client Operations (Non-blocking)'
method: GsSftpSocket
makeNonBlocking
  "libssh does not support sftp operations on a non-blocking ssh connection, 
   see  https://gitlab.com/libssh/libssh-mirror/-/issues/58"

  ^ ImproperOperation signal: 'non blocking operations on a GsSftpSocket are not supported'.
%

category: 'Client Operations (Non-blocking)'
method: GsSftpSocket
nbSshConnect
  "libssh does not support sftp operations on a non-blocking ssh connection, 
   see  https://gitlab.com/libssh/libssh-mirror/-/issues/58"

  ^ ImproperOperation signal: 'nbSshConnect not supported on a GsSftpSocket'.
%

category: 'Client Operations (Non-blocking)'
method: GsSftpSocket
nbSshConnectTimeout: timeoutMs
  "libssh does not support sftp operations on a non-blocking ssh connection, 
   see  https://gitlab.com/libssh/libssh-mirror/-/issues/58"

  ^ ImproperOperation signal: 'nbSshConnectTimeout: not supported on a GsSftpSocket'.
%

category: 'File Operations'
method: GsSftpSocket
remoteFileExists: aFileOrDirectory

"Answer a Boolean indicating if the remote file or directory exists. Raises an exception on error."

^ [(self stat: aFileOrDirectory) class == GsFileStat ]
	on: SshSocketError
	do:[:ex| (ex reason findPattern: { 'No such file' } startingAt: 1) ~~ 0
		ifTrue:[ false ]  "file does not exist"
		ifFalse:[ ex signal ] "some other error"
]
%

category: 'Directory Operations'
method: GsSftpSocket
removeRemoteDirectory: dirname

"Removes the named directory from the server host. Returns the receiver on success or raises an exception on error. "

^ self _oneArgSshPrim: 51 with: dirname
%

category: 'File Operations'
method: GsSftpSocket
removeRemoteFile: filename

"Removes the named file from the server host. Returns the receiver on success or raises an exception on error. "

^ self _oneArgSshPrim: 53 with: filename
%

category: 'File Operations'
method: GsSftpSocket
renameRemoteFile: oldName to: newName

"Changes the name of a remote file or directory from oldName to newName.
Raises an exception if the remote file or directory does not exist or if the
rename action is not permitted."

^ self _twoArgSshPrim: 51 with: oldName with: newName
%

category: 'File Operations'
method: GsSftpSocket
stat: aFileName

"Return an instance of GsFileStat describing the remote file.
Raise an exception if the file does not exist or cannot be accessed."

^ self _oneArgSshPrim: 54 with: aFileName
%

category: 'Private'
method: GsSftpSocket
_addReference: aGsSftpRemoteFile

openFiles add: aGsSftpRemoteFile .
^self
%

category: 'Private'
method: GsSftpSocket
_removeReference: aGsSftpRemoteFile

openFiles remove: aGsSftpRemoteFile otherwise: nil .
^self
%

category: 'Private'
method: GsSftpSocket
_sshConnect

"Connects the receiver to the ssh server.
 Returns true on success, false if the connection is in progress on a nonblocking socket, or raises an exception on error.
If the method returns false, the application should wait for the socket to become read-ready and then send
the message again."

| ret |
(ret := self _zeroArgSshPrim: 3)
	 ifTrue:[ self makeBlocking ]. "Workaround for libssh issue #58"
^ ret
%

! Class implementation for 'IdentitySoftCollisionBucket'

!		Class methods for 'IdentitySoftCollisionBucket'

category: 'Instance creation'
classmethod: IdentitySoftCollisionBucket
new

^ super new _initializeCleanup
%

!		Instance methods for 'IdentitySoftCollisionBucket'

category: 'Updating'
method: IdentitySoftCollisionBucket
at: aKey put: aValue

"disallowed, should use  at:put:keyValDict_coll:  "

self shouldNotImplement: #at:put:
%

category: 'Updating'
method: IdentitySoftCollisionBucket
at: aKey put: aValue keyValDict_coll: aKeyValDict

"Stores the aKey/aValue pair in the receiver.
 Returns self size if this at:put: added a new key, 0 if this at:put:
 replaced a SoftReference for an existing  key .

 aValue is expected to be a SoftReference.

 Also removes key/SoftReference pairs whose SoftReference has been
 cleared by the garbage collector."

self _cleanupReferences: false .
^ super at: aKey put: aValue keyValDict_coll: aKeyValDict
%

category: 'Cleanup'
method: IdentitySoftCollisionBucket
cleanupReferences
  ^ self _cleanupReferences: true
%

category: 'Accessing'
method: IdentitySoftCollisionBucket
referenceAt: aKey ifAbsent: aBlock

"Returns the non-cleared SoftReference that corresponds to aKey.
 If no such key/SoftRef pair exists,
 returns the result of evaluating the zero-argument block aBlock."

  | index keyIndex aSoftRef |
  keyIndex := self searchForKey: aKey.
  keyIndex ~~ nil ifTrue: [
    index := (keyIndex + keyIndex) - 1 .
    aSoftRef:=  self _referenceAt: index .
    aSoftRef == nil ifTrue:[ ^ self _reportKeyNotFound: aKey with: aBlock ] .
    ^ aSoftRef
  ].
  ^ self _reportKeyNotFound: aKey with: aBlock
%

category: 'Accessing'
method: IdentitySoftCollisionBucket
referenceAt: aKey otherwise: aValue

"Returns the non-cleared SoftReference that corresponds to aKey.
 If no such key/SoftRef pair exists, returns aValue ."

  | keyIndex index aSoftRef |
  keyIndex := self searchForKey: aKey.
  keyIndex ~~ nil ifTrue:[
    index := (keyIndex + keyIndex) - 1 .
    aSoftRef :=  self _referenceAt: index .
    aSoftRef == nil ifTrue:[ ^ aValue ].
    ^ aSoftRef
  ].
  ^ aValue
%

category: 'Removing'
method: IdentitySoftCollisionBucket
removeKey: aKey ifAbsent: aBlock

"Removes the key/value pair having the key aKey.  If aKey is not found,
 returns the result of evaluating the zero-argument block aBlock.

 Also removes key/SoftReference pairs whose SoftReference has been
 cleared by the garbage collector."

| res |
res := super removeKey: aKey ifAbsent: aBlock  .
self _cleanupReferences: true .
^ res
%

category: 'Removing'
method: IdentitySoftCollisionBucket
removeKey: aKey otherwise: notFoundValue

"Removes the key/value pair having the key aKey.  If aKey is not found,
 returns the notFoundValue .

 Also removes key/SoftReference pairs whose SoftReference has been
 cleared by the garbage collector."

| res |
res := super removeKey: aKey otherwise: notFoundValue .
self _cleanupReferences: true .
^ res
%

category: 'Cleanup'
method: IdentitySoftCollisionBucket
_cleanupReferences: okToRemoveBucket
| currCount |
currCount := self _markSweepsThatClearedSoftRefsCount .
currCount = lastCleanupCount ifFalse:[ | lastKeyIdx startNumElem aKey |
  startNumElem := numElements .
  lastKeyIdx := (startNumElem + startNumElem) - 1 .
  lastKeyIdx _downTo: 1 by: 2 do:[ :idx | | aRef aVal |
    aRef := self _at: idx + 1.
    aVal := aRef _value  .
    aVal ifNil:[
      aKey ifNil:[ aKey := self _at: idx ].
      self removeFrom: idx  to: idx+ 1 . "remove key/softRef pair"
      numElements := numElements - 1 .
    ].
  ].
  lastCleanupCount := currCount .
  numElements == startNumElem ifFalse:[
    keyValueDictionary _bucketSizeChangeFrom: startNumElem to: numElements
		key: aKey bucket: self remove: okToRemoveBucket
  ].
].
%

category: 'Private'
method: IdentitySoftCollisionBucket
_initializeCleanup

  lastCleanupCount := 0
%

category: 'Private'
method: IdentitySoftCollisionBucket
_markSweepsThatClearedSoftRefsCount

"Returns OM.markSweepsThatClearedSoftRefsCount as a positive SmallInteger"

<primitive: 553>

self _primitiveFailed: #_markSweepsThatClearedSoftRefsCount
%

category: 'Private'
method: IdentitySoftCollisionBucket
_referenceAt: idx

" for the key stored at offset idx ,
  return the SofReference if softRef.value non-nil, otherwise
  remove the soft reference and associated key .
  Does not increment the use count of softRef .
"
| aSoftRef val |
aSoftRef := self _at: idx + 1 .
aSoftRef ~~ nil ifTrue:[
  val := aSoftRef _value .
  val == nil ifTrue:[ | oldN n aKey |
    aKey := self _at: idx .
    self removeFrom: idx to: idx + 1 . "remove key and SoftRef"
    oldN := numElements .
    n := oldN - 1 .
    n < 0 ifTrue:[ nil error:'numElements underflow in a SoftCollisionBucket'].
    numElements := n .
    keyValueDictionary _bucketSizeChangeFrom: oldN to: n key: aKey
                bucket: self remove: false .
    ^ nil .
  ] .
  ^ aSoftRef
].
^ nil
%

! Class implementation for 'UserProfileGroup'

!		Class methods for 'UserProfileGroup'

category: 'Accessing'
classmethod: UserProfileGroup
allGroups
  ^ AllGroups
%

category: 'Audit'
classmethod: UserProfileGroup
auditGroups
  self allGroups do: [:aGroup |
     (aGroup auditGroup) ifFalse: [^false]].
  ^true
%

category: 'Private'
classmethod: UserProfileGroup
basicNewWithName: aStringOrSymbol
"Creates a new instance of the receiver, but does not add the new instance
 to the list to AllGroups.  It is an error if a group with the same name
 already exists."

((self groupWithName: aStringOrSymbol otherwise: nil) notNil)
  ifTrue:[ ^ self _error: #rtErrGroupAlreadyExists args: { aStringOrSymbol } ] .

^ self _primNewWithName: aStringOrSymbol
%

category: 'Deleting'
classmethod: UserProfileGroup
deleteGroup: aGroup
"Remove the group from the following places:
  -The groups instance variable of any UserProfile.
  -The loginUserProfileGroups instance variable of any KerberosPrincipal.
  -The global collection AllGroups.

aGroup must be in AllGroups. Returns the receiver."

| gName |
gName := aGroup groupName .
self allGroups at: gName .  "ensure group exists."
SystemRepository do:[:securityPolicy | securityPolicy group: aGroup authorization: #none].
AllUsers removeGroup: gName . "AllUsers needs the group name"
KerberosPrincipal removeGroup: aGroup  . "KerberosPrincipal needs the group object."
self allGroups removeKey: gName .
^ self
%

category: 'Deleting'
classmethod: UserProfileGroup
deleteGroupWithName: aStringOrSymbol
"Remove the group with name aStringOrSymbol from the following places:
  -The groups instance variable of any UserProfile.
  -The loginUserProfileGroups instance variable of any KerberosPrincipal.
  -The global collection AllGroups.

It is an error if the group named aStringOrSymbol does not exists.  It is not an error
if the group is not present in one or more UserProfiles or KeberosPrincipals.
Returns the receiver."

^ self deleteGroup: (self groupWithName: aStringOrSymbol)
%

category: 'Deleting'
classmethod: UserProfileGroup
deleteGroupWithName: aStringOrSymbol ifAbsent: aBlock
"Remove the group with name aStringOrSymbol from the following places:
  -The groups instance variable of any UserProfile.
  -The loginUserProfileGroups instance variable of any KerberosPrincipal.
  -The global collection AllGroups.

Execute aBlock if the group does not exist.  It is not an error
if the group is not present in one or more UserProfiles or KeberosPrincipals.
Returns the receiver."

| nam |
nam := self groupWithName: aStringOrSymbol otherwise: nil .
nam ifNotNil:[ self deleteGroup: nam ]
    ifNil:[ aBlock value ]
%

category: 'Accessing'
classmethod: UserProfileGroup
groupWithName: aStringOrSymbol
"Answer the UserProfileGroup that has the given name.  Raises an exception if no
 such UserProfileGroup exists."

  ^ self allGroups at: aStringOrSymbol ifAbsent:[ aStringOrSymbol  _error: #segErrBadGroup. ^ nil ]
%

category: 'Accessing'
classmethod: UserProfileGroup
groupWithName: aStringOrSymbol ifAbsent: aBlock
"Answer the UserProfileGroup that has the given name or evaluate aBlock if it does
 not exist."

  ^ self allGroups at: aStringOrSymbol ifAbsent: aBlock
%

category: 'Accessing'
classmethod: UserProfileGroup
groupWithName: aStringOrSymbol otherwise: aValue
"Answer the UserProfileGroup that has the given name or answer aValue if it does
 not exist."

  ^ self allGroups at: aStringOrSymbol otherwise: aValue
%

category: 'Illegal Operations'
classmethod: UserProfileGroup
new

"Disallowed.  To create a new UserProfileGroup, use newWithName: instead "

self shouldNotImplement: #new
%

category: 'Illegal Operations'
classmethod: UserProfileGroup
new: anInt

"Disallowed.  To create a new UserProfileGroup, use newWithName: instead."
self shouldNotImplement: #new:
%

category: 'Updating'
classmethod: UserProfileGroup
newGroupWithName: aStringOrSymbol
"Creates a new instance of UserProfileGroup and adds it to the AllGroups collection.
 It is an error if a group with the same name already exits.

 Requires write access to the GsObjectSecurityPolicy for DataCurator."

| result |
result := self basicNewWithName: aStringOrSymbol .
self allGroups at: result groupName put: result .  "fix 48234"
^ result
%

category: 'Private'
classmethod: UserProfileGroup
_primNewWithName: aStringOrSymbol
"Creates a new instance of the receiver, but does not add the new instance
 to the list to AllGroups and does not check for duplicate names."

| result |
result := super new .
result _groupName: aStringOrSymbol .
^ result
%

category: 'Private'
classmethod: UserProfileGroup
_validateGroupString: aString

"Look up the group with name aString and raise an exception if it does not
 exist."
^ self groupWithName: aString
%

!		Instance methods for 'UserProfileGroup'

category: 'Comparison'
method: UserProfileGroup
<= aUserProfileGroup
  ^ groupName <= aUserProfileGroup groupName
%

category: 'Managing'
method: UserProfileGroup
addUser: aUserProfile
"Add the given UserProfile to the receiver.
 It is an error if the current user does not have the appropriate privilege.
 If <aUserProfile> is already in this group, there is no change.
 return the receiver."

aUserProfile addToUserProfileGroup: self.
^self
%

category: 'Accessing'
method: UserProfileGroup
asString
  ^ groupName asString
%

category: 'Audit'
method: UserProfileGroup
auditGroup
  self users do: [:aUser |
    (aUser groups includes: self)
	ifFalse: [self error: 'mismatch in group membership'.  ^false].
    ].
  ^true
%

category: 'Accessing'
method: UserProfileGroup
groupName
  ^ groupName
%

category: 'Formatting'
method: UserProfileGroup
printOn: aStream

aStream nextPutAll: self printString
%

category: 'Formatting'
method: UserProfileGroup
printString
|s|
s := String withAll: 'a'  .
s addAll: self class name asString ;
  addAll: ' (' ;
  addAll: groupName asString;
  add: $).
^ s
%

category: 'Managing'
method: UserProfileGroup
removeUser: aUserProfile
"Remove the given UserProfile from the receiver.
 It is an error if the current user does not have the appropriate privilege.
 If <aUserProfile> is not in this group, there is no change.
 return the receiver."
aUserProfile removeFromUserProfileGroup: self.
^self
%

category: 'Audit'
method: UserProfileGroup
species
  ^ IdentitySet
%

category: 'Audit'
method: UserProfileGroup
speciesForCollect
 ^ Array
%

category: 'Accessing'
method: UserProfileGroup
userIds
"Answer an IdentitySet of User Ids which are all members of the receiver."
| result |
result := IdentitySet new .
self do:[:e| result add: e userId ] .
^ result
%

category: 'Accessing'
method: UserProfileGroup
users
"Answer an IdentitySet of UserProfiles which are all members of the receiver."

  ^ IdentitySet withAll: self
%

category: 'Private'
method: UserProfileGroup
_groupName: aStringOrSymbol
"Private.  Sets the name of the receiver. Used only at instance creation time."

groupName := aStringOrSymbol asSymbol .
^ self
%

! Class implementation for 'KeySoftValueDictionary'

!		Instance methods for 'KeySoftValueDictionary'

category: 'Enumerating'
method: KeySoftValueDictionary
accompaniedBy: anObj keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 2nd and 3rd arguments.
 aBlock must be a 3 argument block, with arguments anObj, key value .

 SoftReferences which have been cleared by the garbage collector
 are removed from the dictionary during enumeration of the dictionary.
 The useCount of each non-cleared SoftReference will be incremented.
"

| tableLimit |
tableLimit := tableSize * 2 .
1 to: tableLimit by: 2 do: [ :tableIndex | | aKey |
  aKey := self _at: tableIndex .
  aKey ifNil: [ | collisionBkt |
    collisionBkt := self _at: (tableIndex + 1).
    collisionBkt ifNotNil:[  | bktSize bktIdx |
      bktIdx := 1 .
      bktSize := collisionBkt _basicSize .
      [ bktIdx <= bktSize] whileTrue:[  | bKey |
        bKey := collisionBkt _at: bktIdx .
        bKey ifNotNil:[  | oldSize bRef |
          oldSize := bktSize .
          bRef := collisionBkt _referenceAt: bktIdx . "possible removal"
          bRef ifNotNil:[ | val |
            val := bRef value .
            val ifNotNil:[
              aBlock value: anObj value: bKey value: val
            ].
          ] .
          "advance bktIdx only if no removal done "
          bktSize := collisionBkt _basicSize .
          bktSize = oldSize ifTrue:[ bktIdx := bktIdx + 2 ].
        ] ifNil:[
          bktIdx := bktIdx + 2.
        ]
      ]
    ].
  ] ifNotNil: [ | aRef |
    aRef := self _referenceAt: tableIndex .
    aRef ifNotNil:[ | val |
      val := aRef value .
      val ifNotNil:[
        aBlock value: anObj value: aKey value: val
      ].
    ].
  ].
].

%

category: 'Accessing'
method: KeySoftValueDictionary
at: aKey ifAbsent: aBlock

"Returns the value of the SoftReference that corresponds to aKey.
 If no such key/SoftRef pair exists, returns the result of
 evaluating the zero-argument block aBlock.

 Does not send setInUse to matching SoftReference.
 The useCount of the matching SoftReference is incremented, if the
 returned value is not special ."

| ref |

ref := self referenceAt: aKey otherwise: nil .
ref ifNil:[
  ^self _reportKeyNotFound: aKey with: aBlock
].
^ ref value
%

category: 'Accessing'
method: KeySoftValueDictionary
at: aKey ifAbsentPut: aBlock

"disallowed"
^ self shouldNotImplement: #at:ifAbsentPut:
%

category: 'Accessing'
method: KeySoftValueDictionary
at: aKey otherwise: aValue

"Returns the value of the SoftReference that corresponds to aKey.
 If no such key/softRef pair exists, returns the given alternate value.
 Does not send setInUse to the matching SoftReference.
 The useCount of the matching SoftReference is incremented, if the
 returned value is not special ."

| ref |
ref := self referenceAt: aKey otherwise: nil .
ref ifNotNil:[ ^ ref value ].
^ aValue
%

category: 'Updating'
method: KeySoftValueDictionary
at: aKey put: aValue

"Creates a SoftReference referencing aValue and
 inserts the key/softRef pair into the receiver .

 Rebuilds the hash table
 if the addition caused the number of collisions to exceed the limit allowed.

 Returns aValue.
"
| ref validRef |
ref := SoftReference new .
ref setValue: aValue .
validRef := self at: aKey putReference: ref .
" should always get the ref back because we have a strong ref to value
  on the stack"
validRef == ref ifFalse:[ self error:'inconsistent softref state' ].
^ aValue
%

category: 'Updating'
method: KeySoftValueDictionary
at: aKey putReference: aSoftReference

"Stores the aKey/SoftRef pair in the hash dictionary.  Rebuilds the hash table
 if the addition caused the number of collisions to exceed the limit allowed.

 aSoftReference must be a instance of SoftReference , else an error is
 generated .
 The useCount of aSoftReference is incremented.

 Returns aSoftReference, or nil if the addition could not be completed.
 Returns nil if aSoftReference was cleared by the garbage collector
 before the addition could be completed."

| val |
aSoftReference class == SoftReference ifFalse:[
  aSoftReference _validateInstanceOf: SoftReference .
].
val := aSoftReference value  .  "increment useCount and keep val alive on stack"
val ifNil:[ ^ nil ].

super at: aKey put: aSoftReference .
^ aSoftReference
%

category: 'Clustering'
method: KeySoftValueDictionary
clusterDepthFirst

"Instances are non-persistent so this has no effect"

^ true
%

category: 'Private'
method: KeySoftValueDictionary
collisionBucketClass

"Returns the class of object to create when keys collide."

^ SoftCollisionBucket
%

category: 'Accessing'
method: KeySoftValueDictionary
keyAtValue: anObject ifAbsent: aBlock

"Returns the key of the first SoftRef equal to the given object, anObject.
 If no match is found, evaluates and returns the result of the block aBlock."

| tableLimit |
tableLimit := tableSize * 2 .
1 to: tableLimit by: 2 do: [ :tableIndex | | aKey |
  aKey := self _at: tableIndex .
  aKey ifNil: [ | collisionBkt |
    collisionBkt := self _at: tableIndex + 1.
    collisionBkt ifNotNil:[  | bktSize bktIdx |
      bktIdx := 1 .
      bktSize := collisionBkt _basicSize .
      [ bktIdx <= bktSize] whileTrue:[  | bKey |
        bKey := collisionBkt _at: bktIdx .
        bKey ifNotNil:[ | oldSize bRef |
          oldSize := bktSize .
          bRef := collisionBkt _referenceAt: bktIdx .  "possible removal"
          bRef ifNotNil:[
            anObject = bRef _value ifTrue: [
              ^bKey
            ].
          ].
          "advance bktIdx only if no removal done "
          bktSize := collisionBkt _basicSize .
          bktSize = oldSize ifTrue:[ bktIdx := bktIdx + 2 ].
        ] ifNil:[
          bktIdx := bktIdx + 2.
        ].
      ].
    ].
  ] ifNotNil: [ | aSoftRef |
    aSoftRef := self _referenceAt: tableIndex .
    aSoftRef ifNotNil:[
      anObject = aSoftRef _value ifTrue:[
        ^aKey
      ].
    ].
  ].
].
^aBlock value.
%

category: 'Enumerating'
method: KeySoftValueDictionary
keysAndReferencesDo: aBlock

"Evaluates aBlock with each of the receiver's key/softRef pairs as the
 arguments.  The argument aBlock must be a two-argument block,
 first argument is the key and the second argument is
 the SoftReference for each non-cleared key/softRef pair in the dictionary.

 SoftReferences which have been cleared by the garbage collector
 are removed from the dictionary during enumeration of the dictionary.
 The useCount of each non-cleared SoftReference will NOT be incremented.
"

| tableLimit |
tableLimit := tableSize * 2 .
1 to: tableLimit by: 2 do: [ :tableIndex | | aKey |
  aKey := self _at: tableIndex .
  aKey ifNil:[ | collisionBkt |
    collisionBkt := self _at: (tableIndex + 1) .
    collisionBkt ifNotNil:[  | bktSize bktIdx |
      bktIdx := 1 .
      bktSize := collisionBkt _basicSize .
      [ bktIdx <= bktSize] whileTrue:[  | bKey |
        bKey := collisionBkt _at: bktIdx .
        bKey ifNotNil:[  | oldSize bRef |
          oldSize := bktSize .
          bRef := collisionBkt _referenceAt: bktIdx  . "possible removal"
          bRef ifNotNil:[
            aBlock value: bKey value: bRef
	  ].
          "advance bktIdx only if no removal done "
          bktSize := collisionBkt _basicSize .
          bktSize = oldSize ifTrue:[ bktIdx := bktIdx + 2 ].
        ] ifNil:[
          bktIdx := bktIdx + 2.
        ]
      ].
    ].
  ] ifNotNil: [ | aRef |
    aRef := self _referenceAt: tableIndex .
    aRef ifNotNil:[
      aBlock value: aKey value: aRef
    ].
  ].
].
%

category: 'Enumerating'
method: KeySoftValueDictionary
keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 arguments.  The argument aBlock must be a two-argument block,
 first argument is the key and the second argument is the value of
 the SoftReference for each non-cleared key/softRef pair in the dictionary.

 SoftReferences which have been cleared by the garbage collector
 are removed from the dictionary during enumeration of the dictionary.
 The useCount of each non-cleared SoftReference will be incremented.
"

| tableLimit |
tableLimit := tableSize * 2 .
1 to: tableLimit by: 2 do: [ :tableIndex | | aKey |
  aKey := self _at: tableIndex .
  aKey ifNil:[ | collisionBkt |
    collisionBkt := self _at: (tableIndex + 1).
    collisionBkt ifNotNil:[  | bktSize bktIdx |
      bktIdx := 1 .
      bktSize := collisionBkt _basicSize .
      [ bktIdx <= bktSize] whileTrue:[  | bKey |
        bKey := collisionBkt _at: bktIdx .
        bKey ifNotNil:[  | oldSize bRef |
          oldSize := bktSize .
          bRef := collisionBkt _referenceAt: bktIdx . "possible removal"
          bRef ifNotNil:[ | val |
            val := bRef value .
            val ifNotNil:[
              aBlock value: bKey value: val
            ].
          ] .
          "advance bktIdx only if no removal done "
          bktSize := collisionBkt _basicSize .
          bktSize = oldSize ifTrue:[ bktIdx := bktIdx + 2 ].
        ] ifNil:[
          bktIdx := bktIdx + 2.
        ]
      ]
    ].
  ] ifNotNil: [ | aRef |
    aRef := self _referenceAt: tableIndex .
    aRef ifNotNil:[ | val |
      val := aRef value .
      val ifNotNil:[
        aBlock value: aKey value: val
      ].
    ].
  ].
].
%

category: 'Enumerating'
method: KeySoftValueDictionary
keysDo: aBlock

"Evaluates aBlock with each of the receiver's keys as the
 argument.  The argument aBlock must be a one-argument block .

 SoftReferences which have been cleared by the garbage collector
 are removed from the dictionary during enumeration of the dictionary,
 and their keys will not be passed to aBlock .

 The useCount of each non-cleared SoftReference is NOT incremented.
"

| tableLimit |
tableLimit := tableSize * 2 .
1 to: tableLimit by: 2 do: [ :tableIndex | | aKey |
  aKey := self _at: tableIndex .
  aKey ifNil:[ | collisionBkt |
    collisionBkt := self _at: (tableIndex + 1).
    collisionBkt ifNotNil:[  | bktSize bktIdx |
      bktIdx := 1 .
      bktSize := collisionBkt _basicSize .
      [ bktIdx <= bktSize] whileTrue:[  | bKey |
        bKey := collisionBkt _at: bktIdx .
        bKey ifNotNil:[  | oldSize bRef |
          oldSize := bktSize .
          bRef := collisionBkt _referenceAt: bktIdx . "possible removal"
          bRef ifNotNil:[ | val |
            val := bRef _value .
            val ifNotNil:[
              aBlock value: bKey .
            ].
          ] .
          "advance bktIdx only if no removal done "
          bktSize := collisionBkt _basicSize .
          bktSize = oldSize ifTrue:[ bktIdx := bktIdx + 2 ].
        ] ifNil:[
          bktIdx := bktIdx + 2.
        ]
      ]
    ].
  ] ifNotNil: [ | aRef |
    aRef := self _referenceAt: tableIndex .
    aRef ifNotNil:[ | val |
      val := aRef _value .
      val ifNotNil:[
        aBlock value: aKey
      ].
    ].
  ].
].
%

category: 'Hashing'
method: KeySoftValueDictionary
rebuildTable: newSize

"Rebuilds the hash table by saving the current state, initializing and
 changing the size of the table, and adding the key value pairs saved
 back to the hash dictionary.

 During the 'saving the current state' phase, cleared SoftReferences
 will be removed from the dictionary.  After 'saving the current state',
 if numCollisions is below the collisionLimit, the rebuild will be skipped.

 If explicit rebuildTable is desired, you need to set the collisionLimit
 lower than the number of collisions before sending rebuildTable: .
 rebuildTable: will then install a new collision limit based on the
 newSize .  "

| startNc nc saveTable saveIdx saveCollLimit |

collisionLimit == 536870911 ifTrue:[
  ^ self  "prevent recursive rebuild"
  ].
saveTable := Array new: (self size * 3).
saveIdx := 0.
startNc := numCollisions .
self keysAndReferencesDo: [ :aKey :aSoftRef |
  saveTable at: saveIdx + 1 put: aKey.
  saveTable at: saveIdx + 2 put: aSoftRef.

  "keep values mostly alive"
  saveTable at: (saveIdx := saveIdx + 3) put: (aSoftRef _value)   "avoid incrementing useCount"
  ].
"enumeration of soft dictionaries may return less than total size"
saveTable size: saveIdx  .
((nc := numCollisions) < collisionLimit and:[ nc >= startNc]) ifTrue:[
  "rebuild not needed after removals from soft dictionary during enumeration"
  "GsFile gciLogServer:'--- rebuild not needed for newSize ' , newSize asString
		, '--------------- ' . ===debugging code not used"
  ^ self
  ].
self tableSize: newSize.  "installs new collision limit"
saveCollLimit := collisionLimit .
collisionLimit := 536870911 . "prevent recursive rebuild"
1 to: saveIdx by: 3 do: [ :j | | aSoftRef |
  aSoftRef := saveTable at: j + 1 "value" .
  aSoftRef _value ifNotNil:[     "avoid incrementing useCount"
    super at: (saveTable at: j "key") put: aSoftRef
    ].
  ].
collisionLimit := saveCollLimit .
"GsFile gciLogServer:'--- rebuild for newSize ' , newSize asString
                , '--------------- ' .   ===debugging code not used"
^self
%

category: 'Accessing'
method: KeySoftValueDictionary
referenceAt: aKey

"Returns the SoftReference corresponding to aKey.
 Generates an error if no such key exists."

| ref |
ref := self referenceAt: aKey otherwise: nil .
ref ifNotNil:[ ^ ref ].
^ self _errorKeyNotFound: aKey
%

category: 'Accessing'
method: KeySoftValueDictionary
referenceAt: aKey otherwise: aValue

" Return the SoftReference corresponding to aKey ,
  or return aValue if aKey not found."

| hash hashKey collisionBkt ref |

aKey ifNil:[ ^ aValue ].
hash := self hashFunction: aKey.
hashKey := self keyAt: hash.
hashKey ifNil: [
  (collisionBkt := self valueAt: hash) ifNotNil: [
    ref := collisionBkt referenceAt: aKey  otherwise: nil .
  ]
] ifNotNil: [
  (self compareKey: aKey with: hashKey) ifTrue: [
     ref := self _referenceAt: ( hash + hash - 1) .
   ]
].
ref ifNotNil:[ ^ ref ].
^ aValue
%

category: 'Private'
method: KeySoftValueDictionary
_bucketSizeChangeFrom: oldNumElem to: newNum key: aKey bucket: aBucket
    remove: okToRemoveBucket

  "a bucket has removed some key/softRef pairs , now update
   dictionary size information."

| elemDelta collDelta |
elemDelta := oldNumElem - newNum .
elemDelta < 1 ifTrue:[ self error:'elemDelta underflow in a KeySoftValueDictionary' ].
collDelta := elemDelta .
newNum <= 0 ifTrue:[
  newNum < 0 ifTrue:[ self error:'numElem underflow in a KeySoftValueDictionary' ].
  collDelta := elemDelta - 1 .
  collDelta < 0 ifTrue:[ self error:'collDelta underflow in a KeySoftValueDictionary' ].
].
numElements := numElements - elemDelta .
numCollisions := numCollisions - collDelta .
(okToRemoveBucket and:[ newNum <= 1 ]) ifTrue:[ | hash |
  "remove the bucket."
  aKey ifNil:[ self error:'nil key in _bucketSizeChangeFrom:'].
  hash := self hashFunction: aKey.
  (self valueAtHash: hash ) ~~ aBucket ifTrue:[
    self error:'inconsistent bucket in a KeySoftValueDictionary'
  ].
  newNum == 1 ifTrue:[ | pair pkey |
    pair := aBucket firstPair .
    (self hashFunction: (pkey := pair at:1)) == hash ifFalse:[
      self error:'inconsistent hash in _bucketSizeChangeFrom:'
    ].
    self atHash: hash putKey: pkey value: (pair at: 2) .
  ] ifFalse:[
    self atHash: hash putKey: nil value: nil
  ].
]
%

category: 'Private'
method: KeySoftValueDictionary
_numValues
  "Return the number of SoftReferences in receiver which have non-nil values,
   without removing any SoftReferences  from the receiver."
  | count |
  count := 0 .
  self keysAndReferencesDo:[:k :ref |
    ref _value ifNotNil:[ count := count + 1 ].
  ].
  ^ count
%

category: 'Private'
method: KeySoftValueDictionary
_referenceAt: tableIdx

" for the key stored in the hash table at tableIdx ,
  return the softRef if softRef.value non-nil, otherwise
  remove the soft reference and associated key .
"
| aSoftRef val |
aSoftRef := self _at: tableIdx + 1 .
aSoftRef ifNotNil:[
  val := aSoftRef _value .
  val ifNil:[
    self _basicAt: tableIdx     put: nil . "remove key"
    self _basicAt: tableIdx + 1 put: nil . "remove SoftRef"
    numElements := numElements - 1 .
    ^ nil .
  ].
  ^ aSoftRef
].
^ nil
%

! Class implementation for 'IdentityKeySoftValueDictionary'

!		Instance methods for 'IdentityKeySoftValueDictionary'

category: 'Private'
method: IdentityKeySoftValueDictionary
collisionBucketClass

"Returns the class of object to create when keys collide."

^ IdentitySoftCollisionBucket
%

category: 'Updating'
method: IdentityKeySoftValueDictionary
collisionLimit: aLimit
| limit tlim |
(limit := aLimit ) _isSmallInteger ifFalse:[  "gemstone64 explicit constraint check"
  ^ limit _error: #rtErrBadArgKind args: { SmallInteger }
].
(limit ~~ 536870911 and:[ limit > (tlim := tableSize * 500)]) ifTrue:[
  limit := tlim "prevent infinite recursion on bucket overflows, fix  "
] .
^ super collisionLimit: limit
%

category: 'Private'
method: IdentityKeySoftValueDictionary
compareKey: key1 with: key2

"Returns true if key1 is identical to key2; returns false otherwise."

^ key1 == key2
%

category: 'Comparing'
method: IdentityKeySoftValueDictionary
hash

"Returns a numeric hash key for the receiver."

| hashValue |

hashValue := 97633 bitXor: (self size).
"For large dictionaries, the hash value is just a function of its size"
(self size > 64) ifTrue: [ ^ hashValue abs ].
self keysDo: [ :aKey |
   "Skip if the key is a dictionary."
   (aKey isKindOf: AbstractDictionary)
     ifFalse: [
       hashValue := hashValue bitXor: aKey identityHash
       ]
     ].
^ hashValue abs
%

category: 'Hashing'
method: IdentityKeySoftValueDictionary
hashFunction: aKey

"The hash function should perform some operation on the value of the key aKey
 which returns a value in the range 1..tableSize."

^(aKey identityHash \\ tableSize) + 1
%

category: 'Accessing'
method: IdentityKeySoftValueDictionary
keys
  | result |
  result := IdentitySet new . 
  self keysDo:[ :aKey | result add: aKey ].
  ^ result
%

category: 'Hashing'
method: IdentityKeySoftValueDictionary
rebuildTable: newSize

| oldTs newTs |
oldTs := tableSize .
super rebuildTable: newSize .
(newTs := tableSize) > oldTs ifTrue:[
  self collisionLimit: newTs * 500 . "differs from KeySoftValueDictionary"
].
%

category: 'Hashing'
method: IdentityKeySoftValueDictionary
rehash
	"Re-establish any hash invariants of the receiver.
	 Identity hashes cannot change."
%

category: 'Private'
method: IdentityKeySoftValueDictionary
_initializeWithoutClear: newSize

"Private. Initializes the instance variables of the receiver to be an empty
 KeyValueDictionary of the specified size. Does not clear the contents
 of the receiver - assumes they are all nil."

tableSize := newSize.
numElements := 0.
numCollisions := 0.
collisionLimit := newSize * 500 . "differs from KeySoftValueDictionary"
^self
%

! Class implementation for 'AwsCredentials'

!		Class methods for 'AwsCredentials'

category: 'Instance Creation'
classmethod: AwsCredentials
newWithAccessKeyId: keyId secretKeyId: secretId
^ self newWithAccessKeyId: keyId secretKeyId: secretId sessionId: ''
%

category: 'Instance Creation'
classmethod: AwsCredentials
newWithAccessKeyId: keyId secretKeyId: secretId sessionId: sessId

^self new
	accessKeyId: keyId ;
	secretKeyId: secretId ;
	sessionId: sessId;
	yourself
%

!		Instance methods for 'AwsCredentials'

category: 'Accessing'
method: AwsCredentials
accessKeyId
	^accessKeyId
%

category: 'Updating'
method: AwsCredentials
accessKeyId: newValue
	accessKeyId := newValue
%

category: 'Accessing'
method: AwsCredentials
secretKeyId
	^secretKeyId
%

category: 'Updating'
method: AwsCredentials
secretKeyId: newValue
	secretKeyId := newValue
%

category: 'Accessing'
method: AwsCredentials
sessionId
	^sessionId
%

category: 'Updating'
method: AwsCredentials
sessionId: newValue
	sessionId := newValue
%

! Class implementation for 'AzureCredentials'

!		Class methods for 'AzureCredentials'

category: 'Instance Creation'
classmethod: AzureCredentials
newWithClientId: clId clientSecret: clSecret tenantId: tenId

^self new
	clientId: clId ;
	clientSecret: clSecret ;
	tenantId: tenId;
	yourself
%

!		Instance methods for 'AzureCredentials'

category: 'Accessing'
method: AzureCredentials
clientId
	^clientId
%

category: 'Updating'
method: AzureCredentials
clientId: newValue
	clientId := newValue
%

category: 'Accessing'
method: AzureCredentials
clientSecret
	^clientSecret
%

category: 'Updating'
method: AzureCredentials
clientSecret: newValue
	clientSecret := newValue
%

category: 'Accessing'
method: AzureCredentials
tenantId
	^tenantId
%

category: 'Updating'
method: AzureCredentials
tenantId: newValue
	tenantId := newValue
%

! Class implementation for 'AbstractCloudKey'

!		Class methods for 'AbstractCloudKey'

category: 'Exceptions'
classmethod: AbstractCloudKey
errorClass
  ^ self subclassResponsibility
%

!		Instance methods for 'AbstractCloudKey'

category: 'Exceptions'
method: AbstractCloudKey
assertNotSolo

GsSession isSolo ifTrue:[
  self errorClass signal: 'An operation was attempted which is not allowed in solo mode.' ].
%

category: 'Exceptions'
method: AbstractCloudKey
assertNoUncommittedChanges

System needsCommit ifTrue:[ self _error: #rtErrAbortWouldLoseData ]
%

category: 'Exceptions'
method: AbstractCloudKey
assertUnlocked

self isUnlocked
	ifFalse:[ self errorClass signal: 'An operation was attempted which requires the key to be unlocked, however the key is locked'].
%

category: 'Exceptions'
method: AbstractCloudKey
errorClass
  ^ self class errorClass
%

! Class implementation for 'AwsDataKey'

!		Class methods for 'AwsDataKey'

category: 'Instance Creation'
classmethod: AwsDataKey
createKeyUsingAwsCredentials: awsCreds cmsKeyId: keyId keySizeBytes: keySize

"Creates a new instance of the receiver using awsCreds and keyId.
 The new instance is unlocked.  awsCreds must be valid for keyId 
 and keyId must be the ARN of an AWS Customer Master Key (CMK) or a 
 CMK alias. keySize is the size of the new key in bytes and must 
 be either 16 or 32.

 Raises an exception on error."

^ self _threeArgClassPrim: 0 with: awsCreds with: keyId with: keySize
%

category: 'Exceptions'
classmethod: AwsDataKey
errorClass
  ^ AwsError
%

category: 'Private'
classmethod: AwsDataKey
_threeArgClassPrim: opCode with: obj1 with: obj2 with: obj3

"
opCode		class method
0			AwsDataKey createKeyUsingAwsCredentials:cmsKeyId:keySizeBytes:
1			AzureDataKey createKeyUsingAzureCredentials:keyVaultUrl:keyName: 
2                       AzureDataKey _changeKeyNameTo:inKeyVault:usingNewCredentials:
"

<primitive: 1128>
^ self _primitiveFailed: #_threeArgClassPrim:with:with: args: { opCode . obj1 . obj2 . obj3 }
%

!		Instance methods for 'AwsDataKey'

category: 'Comparing'
method: AwsDataKey
= anotherKey

(self == anotherKey) ifTrue:[ ^ true ].
(self class == anotherKey class) ifFalse:[ ^ false ].
(self cmsKeyId = anotherKey cmsKeyId) ifFalse: [^ false].
(self encryptedDataKey = anotherKey encryptedDataKey) ifFalse: [^false].
^ true
%

category: 'Key Rotation'
method: AwsDataKey
changeCmsKeyIdTo: newCmsKeyId usingNewCredentials: newCreds

"Atomically updates the receiver to use newCmsKeyId which is accessed with newCreds in a single operation.
The receiver must first be unlocked using the #unlockWithAwsCredentials: method before this method
can be successfully invoked.
Fails with an exception if the session has uncommitted changes or if the receiver is locked.
Fails with an exception if the session cannot obtain a write lock on the receiver.
Returns true on success and leaves the receiver in an unlocked state."

| sys |
self assertNotSolo; assertUnlocked ; assertNoUncommittedChanges .
sys := System .
sys beginTransaction.
^ [ sys writeLock: self ;
	addToCommitOrAbortReleaseLocksSet: self .
self _changeCmsKeyIdTo: newCmsKeyId usingNewCredentials: newCreds .
sys commit
] on: Exception do:[:ex| sys abortTransaction. ex pass ]
%

category: 'Accessing'
method: AwsDataKey
cmsKeyId
	^cmsKeyId
%

category: 'Updating'
method: AwsDataKey
cmsKeyId: newValue
	cmsKeyId := newValue
%

category: 'Copying'
method: AwsDataKey
copy

"Answer a new object which is a deep copy of the receiver. The lock state of the receiver is preserved
when copied, i.e.: if the receiver is unlocked the resulting copy will also
be unlocked."

| result |
result := self class basicNew.
result cmsKeyId: self cmsKeyId copy ;
	encryptedDataKey: self encryptedDataKey copy ;
	keySizeBytes: self keySizeBytes.
^self _copyKeyTo: result
%

category: 'Encrypting'
method: AwsDataKey
decrypt: srcByteObj into: destByteObj

"Uses the receiver to decrypt srcByteObj and stores the resulting decrypted bytes into destByteObj.
The receiver must be unlocked. srcByteObj must be a non-empty byte object containg Base64 text
obtained by calling one of the encrypt methods in this class.
destByteObj must be a mutable byte object. The contents of destByteObj, if any, are
overwritten by this method.

Encryption is performed using the AES-OCB authenticated encryption, which ensures data that has been 
successfully decrypted has not been modified in any way.

Returns the destByteObj on success or raises an exception on error.
"

^self _twoArgInstPrim: 2 with: srcByteObj with: destByteObj
%

category: 'Encrypting'
method: AwsDataKey
encrypt: srcByteObj into: destByteObj

"Uses the receiver to encrypt srcByteArg and stores the resulting encrypted bytes into destByteObj 
as a Base64 string. The receiver must be unlocked. srcByteArg must be a non-empty byte object.
destByteArg must be a mutable byte object. Any data present in destByteArg will be overwritten.

Encryption is performed using the AES-OCB authenticated encryption, which ensures data that has been 
successfully decrypted has not been modified in any way.

Returns destByteObj on success and raises an exception on error.
"

| result |
result := self _twoArgInstPrim: 1 with: srcByteObj with: destByteObj .
^ result
%

category: 'Encrypting'
method: AwsDataKey
encryptAndErase: srcByteArg into: destByteObj

"Uses the receiver to encrypt and erase srcByteArg and store the resulting encrypted bytes into 
destByteObj as a Base64 string. The receiver must be unlocked. srcByteArg must be a non-empty byte 
object. destByteArg must be a mutable byte object. Any data present in destByteArg will be overwritten.

Encryption is performed using the AES-OCB authenticated encryption, which ensures data that has been 
successfully decrypted has not been modified in any way.

Returns destByteObj and sets srcByteArg to empty (zero size) upon success.
Raises an exception on error.
"

| result |
result := self _twoArgInstPrim: 1 with: srcByteArg with: destByteObj .
srcByteArg size: 0 .
^ result
%

category: 'Accessing'
method: AwsDataKey
encryptedDataKey
	^encryptedDataKey
%

category: 'Updating'
method: AwsDataKey
encryptedDataKey: newValue
	encryptedDataKey := newValue
%

category: 'Hashing'
method: AwsDataKey
hash

"Returns an Integer hash code for the receiver."

^ self cmsKeyId hash bitXor: self encryptedDataKey hash
%

category: 'Testing'
method: AwsDataKey
isLocked

"Returns a boolean indicating if the receiver is locked.
Unlocked keys may be used to encrypt and decrypt data.
Locked keys must be unlocked using the #unlockWithAwsCredentials: method
before usage."

^ self _zeroArgInstPrim: 0
%

category: 'Testing'
method: AwsDataKey
isUnlocked

"Returns a boolean indicating if the receiver is unlocked."

^ self isLocked not
%

category: 'Accessing'
method: AwsDataKey
keySizeBits
	^keySizeBytes * 8
%

category: 'Accessing'
method: AwsDataKey
keySizeBytes
	^keySizeBytes
%

category: 'Updating'
method: AwsDataKey
keySizeBytes: newValue
	keySizeBytes := newValue
%

category: 'Locking'
method: AwsDataKey
lock

"Locks the receiver and securly removes the encryption key from memory.
Returns the receiver."
^ self _zeroArgInstPrim: 1
%

category: 'Locking'
method: AwsDataKey
unlockWithAwsCredentials: awsCreds

"Attempts to unlock the receiver using awsCreds.
Returns the receiver on success or if the receiver is already unlocked.
Raises an exception on error."

^self _oneArgInstPrim: 0 with: awsCreds
%

category: 'Private'
method: AwsDataKey
_changeCmsKeyIdTo: newCmsKeyId usingNewCredentials: newCreds

"Updates the receiver to use newCmsKeyId which is accessed with newCreds.
The receiver must first be unlocked using the #unlockWithAwsCredentials: method before this method
can be successfully invoked.

Private. Do not call this method directly. Use the public method #changeCmsKeyIdTo:usingNewCredentials:
to change the data key."

^self _twoArgInstPrim: 0 with: newCmsKeyId with: newCreds
%

category: 'Private'
method: AwsDataKey
_copyKeyTo: newAwsDataKey

"Private. Do not call this method directly unless you know what you are doing.
If the receiver is unlocked, copy the decrypted data key to newObject.
Copies nothing if the receiver is locked. It is an error if newAwsDataKey
already has data key and and is unlocked. 

Returns newAwsDataKey."

^ self _oneArgInstPrim: 1 with: newAwsDataKey
%

category: 'Private'
method: AwsDataKey
_oneArgInstPrim: opCode with: obj

"
OpCode		Method
-------------------------
0			AwsDataKey unlockWithAwsCredentials:
1			AwsDataKey _copyKeyTo:
"

<primitive: 1126>
^ self _primitiveFailed: #_oneArgInstPrim: args: { opCode . obj }
%

category: 'Private'
method: AwsDataKey
_twoArgInstPrim: opCode with: obj1 with: obj2

"
OpCode		Method
-------------------------
0			AwsDataKey _changeCmsKeyIdTo:usingNewCredentials:
1			AwsDataKey encrypt:into:
2			AwsDataKey decrypt:into:

"

<primitive: 1127>
^ self _primitiveFailed: #_twoArgInstPrim: args: { opCode . obj1 . obj2 }
%

category: 'Private'
method: AwsDataKey
_zeroArgInstPrim: opCode

"
OpCode		Method
-------------------------
0			isLocked
1			lock
"

<primitive: 1125>
^ self _primitiveFailed: #_zeroArgInstPrim: args: { opCode }
%

! Class implementation for 'AzureDataKey'

!		Class methods for 'AzureDataKey'

category: 'Instance Creation'
classmethod: AzureDataKey
createKeyUsingAzureCredentials: azureCreds keyVaultUrl: keyVaultUrl keyName: keyName

"Creates a new instance of the receiver using azureCreds, keyVaultUrl and keyName.
 The new instance is unlocked.  azureCreds must be valid for keyVaultUrl and keyName. 
 The keyVault and keyName must already exist in Azure and the permissions must be set
 to allow azureCreds to encrypt and decrypt keys.

 Raises an exception on error."

^ self _threeArgClassPrim: 1 with: azureCreds with: keyVaultUrl with: keyName
%

category: 'Exceptions'
classmethod: AzureDataKey
errorClass
  ^ AzureError
%

category: 'Private'
classmethod: AzureDataKey
_threeArgClassPrim: opCode with: obj1 with: obj2 with: obj3

"
opCode		class method
0		AwsDataKey createKeyUsingAwsCredentials:cmsKeyId:keySizeBytes:
1		AzureDataKey createKeyUsingAzureCredentials:keyVaultUrl:keyName: 

opCode		instance method
2		AzureDataKey _changeKeyNameTo:inKeyVault:usingCredentials:
"

<primitive: 1128>
^ self _primitiveFailed: #_threeArgClassPrim:with:with: args: { opCode . obj1 . obj2 . obj3 }
%

!		Instance methods for 'AzureDataKey'

category: 'Comparing'
method: AzureDataKey
= anotherKey

(self == anotherKey) ifTrue:[ ^ true ].
(self class == anotherKey class) ifFalse:[ ^ false ].
(self keyVaultUrl = anotherKey keyVaultUrl) ifFalse: [^ false].
(self keyName = anotherKey keyName) ifFalse: [^ false].
(self encryptedDataKey = anotherKey encryptedDataKey) ifFalse: [^false].
^ true
%

category: 'Key Rotation'
method: AzureDataKey
changeKeyNameTo: newName inKeyVault: newVault usingCredentials: newCreds

"Atomically updates the receiver to use newName in newVault  which is accessed with newCreds in a single operation.
The receiver must first be unlocked using the #unlockWithAzureCredentials: method before this method
can be successfully invoked.
Fails with an exception if the session has uncommitted changes or if the receiver is locked.
Fails with an exception if the session cannot obtain a write lock on the receiver.
Returns true on success and leaves the receiver in an unlocked state."

| sys |
self assertNotSolo; assertUnlocked ; assertNoUncommittedChanges .
sys := System .
sys beginTransaction.
^ [ sys writeLock: self ;
	addToCommitOrAbortReleaseLocksSet: self .
self _changeKeyNameTo: newName inKeyVault: newVault usingCredentials: newCreds .
sys commit
] on: Exception do:[:ex| sys abortTransaction. ex pass ]

 
%

category: 'Copying'
method: AzureDataKey
copy

"Answer a new object which is a deep copy of the receiver. The lock state of the receiver is preserved
when copied, i.e.: if the receiver is unlocked the resulting copy will also
be unlocked."

| result |
result := self class basicNew.
result keyVaultUrl: self keyVaultUrl copy ;
       keyName: self keyName copy ;
       encryptedDataKey: self encryptedDataKey copy .

^self _copyKeyTo: result
%

category: 'Encrypting'
method: AzureDataKey
decrypt: srcByteObj into: destByteObj

"Uses the receiver to decrypt srcByteObj and stores the resulting decrypted bytes into destByteObj.
The receiver must be unlocked. srcByteObj must be a non-empty byte object containg Base64 text
obtained by calling one of the encrypt methods in this class.
destByteObj must be a mutable byte object. The contents of destByteObj, if any, are
overwritten by this method.

Encryption is performed using the AES-OCB authenticated encryption, which ensures data that has been 
successfully decrypted has not been modified in any way.

Returns the destByteObj on success or raises an exception on error.
"

^self _twoArgInstPrim: 4 with: srcByteObj with: destByteObj
%

category: 'Encrypting'
method: AzureDataKey
encrypt: srcByteObj into: destByteObj

"Uses the receiver to encrypt srcByteArg and stores the resulting encrypted bytes into destByteObj 
as a Base64 string. The receiver must be unlocked. srcByteArg must be a non-empty byte object.
destByteArg must be a mutable byte object. Any data present in destByteArg will be overwritten.

Encryption is performed using the AES-OCB authenticated encryption, which ensures data that has been 
successfully decrypted has not been modified in any way.

Returns destByteObj on success and raises an exception on error.
"

| result |
result := self _twoArgInstPrim: 3 with: srcByteObj with: destByteObj .
^ result
%

category: 'Encrypting'
method: AzureDataKey
encryptAndErase: srcByteArg into: destByteObj

"Uses the receiver to encrypt and erase srcByteArg and store the resulting encrypted bytes into 
destByteObj as a Base64 string. The receiver must be unlocked. srcByteArg must be a non-empty byte 
object. destByteArg must be a mutable byte object. Any data present in destByteArg will be overwritten.

Encryption is performed using the AES-OCB authenticated encryption, which ensures data that has been 
successfully decrypted has not been modified in any way.

Returns destByteObj and sets srcByteArg to empty (zero size) upon success.
Raises an exception on error.
"

| result |
result := self _twoArgInstPrim: 3 with: srcByteArg with: destByteObj .
srcByteArg size: 0 .
^ result
%

category: 'Accessing'
method: AzureDataKey
encryptedDataKey
	^encryptedDataKey
%

category: 'Updating'
method: AzureDataKey
encryptedDataKey: newValue
	encryptedDataKey := newValue
%

category: 'Hashing'
method: AzureDataKey
hash

"Returns an Integer hash code for the receiver."

^ self keyVaultUrl hash bitXor: self encryptedDataKey hash
%

category: 'Testing'
method: AzureDataKey
isLocked

"Returns a boolean indicating if the receiver is locked.
Unlocked keys may be used to encrypt and decrypt data.
Locked keys must be unlocked using the #unlockWithAzureCredentials: method
before usage."

^ self _zeroArgInstPrim: 2
%

category: 'Testing'
method: AzureDataKey
isUnlocked

"Returns a boolean indicating if the receiver is unlocked."

^ self isLocked not
%

category: 'Accessing'
method: AzureDataKey
keyName
	^keyName
%

category: 'Updating'
method: AzureDataKey
keyName: newValue
	keyName := newValue
%

category: 'Accessing'
method: AzureDataKey
keyVaultUrl
	^keyVaultUrl
%

category: 'Updating'
method: AzureDataKey
keyVaultUrl: newValue
	keyVaultUrl := newValue
%

category: 'Locking'
method: AzureDataKey
lock

"Locks the receiver and securly removes the encryption key from memory.
Returns the receiver."
^ self _zeroArgInstPrim: 3
%

category: 'Locking'
method: AzureDataKey
unlockWithAzureCredentials: awsCreds

"Attempts to unlock the receiver using awsCreds.
Returns the receiver on success or if the receiver is already unlocked.
Raises an exception on error."

^self _oneArgInstPrim: 2 with: awsCreds
%

category: 'Private'
method: AzureDataKey
_changeKeyNameTo: newKeyName inKeyVault: newKeyVaultUrl usingCredentials: newCreds

"Updates the receiver to use newKeyName in newKeyVaultUrl which is accessed with newCreds.
The receiver must first be unlocked using the #unlockWithAzureCredentials: method before this method
can be successfully invoked.

Private. Do not call this method directly. Use the public method #changeKeyIdTo:inKeyVault:usingCredentials:
to change the data key."

^self _threeArgInstPrim: 2 with: newKeyName with: newKeyVaultUrl with: newCreds
%

category: 'Private'
method: AzureDataKey
_copyKeyTo: newAzureDataKey

"Private. Do not call this method directly unless you know what you are doing.
If the receiver is unlocked, copy the decrypted data key to newObject.
Copies nothing if the receiver is locked. It is an error if newAzureDataKey
already has data key and and is unlocked. 

Returns newAzureDataKey."

^ self _oneArgInstPrim: 3 with: newAzureDataKey
%

category: 'Private'
method: AzureDataKey
_oneArgInstPrim: opCode with: obj

"
OpCode		Method
-------------------------
0			AwsDataKey unlockWithAwsCredentials:
1			AwsDataKey _copyKeyTo:
2			AzureDataKey unlockWithAzureCredentials:
3			AzureDataKey _copyKeyTo:
"

<primitive: 1126>
^ self _primitiveFailed: #_oneArgInstPrim: args: { opCode . obj }
%

category: 'Private'
method: AzureDataKey
_threeArgInstPrim: opCode with: obj1 with: obj2 with: obj3

"
opCode		class method
0		AwsDataKey createKeyUsingAwsCredentials:cmsKeyId:keySizeBytes:
1		AzureDataKey createKeyUsingAzureCredentials:keyVaultUrl:keyName: 

opCode		instance method
2		AzureDataKey _changeKeyNameTo:inKeyVault:usingCredentials:
"

<primitive: 1128>
^ self _primitiveFailed: #_threeArgInstPrim:with:with: args: { opCode . obj1 . obj2 . obj3 }
%

category: 'Private'
method: AzureDataKey
_twoArgInstPrim: opCode with: obj1 with: obj2

"
OpCode		Method
-------------------------
0			AwsDataKey _changeCmsKeyIdTo:usingCredentials:
1			AwsDataKey encrypt:into:
2			AwsDataKey decrypt:into:
3			AzureDataKey encrypt:into:
4			AzureDataKey decrypt:into:

"

<primitive: 1127>
^ self _primitiveFailed: #_twoArgInstPrim: args: { opCode . obj1 . obj2 }
%

category: 'Private'
method: AzureDataKey
_zeroArgInstPrim: opCode

"
OpCode		Method
-------------------------
0		AwsDataKey	isLocked
1		AwsDataKey	lock
2		AzureDataKey	isLocked
3		AzureDataKey	lock
"

<primitive: 1125>
^ self _primitiveFailed: #_zeroArgInstPrim: args: { opCode }
%

! Class implementation for 'CBuffer'

!		Class methods for 'CBuffer'

category: 'Instance Creation'
classmethod: CBuffer
new
"create an instance registered with VM for finalization of cData"

<primitive: 674>
self _primitiveFailed: #new
%

category: 'Instance Creation'
classmethod: CBuffer
new: size

"Create a new instance and allocate the given number of bytes in the heap."

| newOne status |
newOne := self new initialize.
status := newOne allocate: size.

status == 1 ifTrue: [^newOne].
status == 0 ifTrue: [ self _errorMallocFailed ].

^ self _halt: 'Unknown error when allocating CBuffer:' , status asString
%

category: 'Error Handling'
classmethod: CBuffer
_errorMallocFailed

"Raise an error because a call to malloc failed in the user action library."

self _error: #hostErrMemoryAlloc args: #()
%

category: 'Testing'
classmethod: CBuffer
_isBufferAvailable

"Return whether there is a buffer available that can be allocated."

^ true
%

category: 'Constants'
classmethod: CBuffer
_numAvailableBuffers

"Return the number of available buffers that can allocated on the heap."

^ 1
%

!		Instance methods for 'CBuffer'

category: 'Allocation'
method: CBuffer
allocate: size

"
 Frees receiver's previous C memory if any.
 Allocate C heap memory and set the receiver to point to it.
 Return a SmallInteger which indicates the status of the allocation:

-1 = not enought C buffers
0 = malloc failed
1 = allocation succeeded
"

^ self _oneArgPrim: 0 arg: size.
%

category: 'Allocation'
method: CBuffer
allocatedSize

"Return the amount of heap memory allocated, in bytes."

^ self _zeroArgPrim: 0.
%

category: 'Allocation'
method: CBuffer
free

"Free previously allocated C heap memory.
 The memory will also be freed automatically if the
 instance is garbage collected by in-memory GC, or
 is committed and faults out of temporary object memory."

^ self _zeroArgPrim: 1.
%

category: 'Initialization'
method: CBuffer
initialize

"Initialize a new instance."

%

category: 'Primitives'
method: CBuffer
_oneArgPrim: opcode arg: arg

"Execute the one arg primitive according to the given opcodes.
	0 = allocate:
	1 = setObjId:
	2 = setOclass:
	3 = setObjectSecurityPolicyId:
	4 = setIsInvariant:
	5 = setNamedSize:
	6 = setObjSize:
	7 = setIdxSize:
	8 = setValueBuffSize:
	9 = setFirstOffset:
	10 = setFormat:
	11 = incrementActualBufferSize:
	12 = getByteObjectInto:
	13 = copyObjectReportInto:
	14 = valueBufferPutOverlayAt:
	15 = setComplete:
        26 = setByteSwizzle:
"

<primitive: 198>
self _primitiveFailed: #_oneArgPrim:arg: args: { opcode . arg }.
self _uncontinuableError
%

category: 'Primitives'
method: CBuffer
_twoArgPrim: opcode arg: arg1 arg: arg2

"Execute the two arg primitive according to the given opcodes.
	0 = setBytes:startingAt:
	1 = valueBufferAt:put:
"

<primitive: 199>
self _primitiveFailed: #_twoArgPrim:arg:arg: args: { opcode . arg1 . arg2 }.
self _uncontinuableError
%

category: 'Primitives'
method: CBuffer
_zeroArgPrim: opcode

"Execute the zero arg primitive according to the given opcodes.

	0 = allocatedSize
	1 = free
	2 = complete
	3 = objId
	4 = oclass
	5 = objectSecurityPolicy (obsolete)
	6 = currentObjectIsInvariant
	7 = namedSize
	8 = objSize
	9 = idxSize
	10 = valueBuffSize
	11 = firstOffset
	12 = currentObjectIsSpecial
	13 = currentObjectIsOop
	14 = currentObjectIsByte
	15 = currentObjectIsNsc
	16 = actualBufferSize
	17 = nextObjectReport
	18 = setNextObjectReport
	19 = setFirstObjectReport
	20 = nextValueBufferOop
	21 = getByteObject
	22 = initTraversalBuffer
	23 = objectReportHeaderSize
	24 = bytesToEnd
	26 = isPartial
	27 = setNextObjectReport
	29 = advanceValueBufferOop
	30 = currentValueBufferOopIsSpecial
	31 = valueBufferSpecialOop
"

<primitive: 197>
self _primitiveFailed: #_zeroArgPrim: args: { opcode }.
self _uncontinuableError
%

! Class implementation for 'TraversalBuffer'

!		Instance methods for 'TraversalBuffer'

category: 'Accessing - Traversal'
method: TraversalBuffer
actualBufferSize

"Return the actual size of the traversal buffer.
 The result is value of the field GciTravBufType.usedBytes in receiver.
 Deprecated"

self deprecated: 'TraversalBuffer>>actualBufferSize deprecated in v3.2. Use usedBytes instead'.
^ self _zeroArgPrim: 16.
%

category: 'Updating - Traversal'
method: TraversalBuffer
advanceValueBufferOop

"Advance to the next oop in the value buffer, if that advance
 would not go beyond the end of the value buffer.
 Returns true if the internal pointer was advanced.
 Returns false if the internal pointer is already pointing to
 the last oop in the value buffer, in which case the pointer
 is unchanged."

^ self _zeroArgPrim: 29.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
bytesToEnd

"Return the number of bytes from the current pointer to the end of the buffer."

^ self _zeroArgPrim: 24.
%

category: 'Accessing'
method: TraversalBuffer
clampOop

   "Return the value of the instance variable 'clampOop'."
   ^clampOop
%

category: 'Updating'
method: TraversalBuffer
clampOop: newValue

   "Modify the value of the instance variable 'clampOop'."
   clampOop := newValue
%

category: 'Testing - Traversal'
method: TraversalBuffer
complete

"Return buffHdr.complete"

^ self _zeroArgPrim: 2.
%

category: 'Copying'
method: TraversalBuffer
copyObjectReportInto: aTBuffer

"Copy the current object report into the given TraversalBuffer.
Return whether the copy was successful."

^ self _oneArgPrim: 13 arg: aTBuffer.
%

category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsByte

"Return ((GciObjRepHdrSType *)buffHdr.current)->objImpl == GC_FORMAT_BYTE"

^ self _zeroArgPrim: 14.
%

category: 'Testing'
method: TraversalBuffer
currentObjectIsClampedFromCallback

"Return whether the current object report is clamped by having the
traversal callback place a _remoteNil in the value buffer."

^ self objSize == 1 and:
[ self currentValueBufferOopIsSpecial and:
[ self valueBufferSpecialOop == _remoteNil ] ]
%

category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsInvariant

"Return ((GciObjRepHdrSType *)buffHdr.current)->isInvariant"

^ self _zeroArgPrim: 6.
%

category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsNsc

"Return ((GciObjRepHdrSType *)buffHdr.current)->objImpl == GC_FORMAT_NSC"

^ self _zeroArgPrim: 15.
%

category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsOop

"Return ((GciObjRepHdrSType *)buffHdr.current)->objImpl == GC_FORMAT_OOP"

^ self _zeroArgPrim: 13.
%

category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsSpecial

"Return ((GciObjRepHdrSType *)buffHdr.current)->objImpl == GC_FORMAT_SPECIAL"

^ self _zeroArgPrim: 12.
%

category: 'Testing - Traversal'
method: TraversalBuffer
currentValueBufferOopIsSpecial

"Return whether the current oop in the value buffer stream is special format."

^ self _zeroArgPrim: 30.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
firstOffset

"Return ((GciObjRepHdrSType *)buffHdr.current)->firstOffset"

^ self _zeroArgPrim: 11.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
getByteObject

"The current report must be for a class with byte indexed instance variables.
 Answer a new object of the report's class, containing only the bytes that are in
 the current report. Note that if the firstOffset is not 1, the indices of bytes
 in the resulting object will not be the same as in the object partially described
 by the report."

^ self _zeroArgPrim: 21.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
getByteObjectInto: byteObj

"If necessary, resize the given byteObj to the size of the object described by
 the current object report (which should be for an object of a byte class).
 Put the bytes contained in the current object report into the given byteObj.
 If this is a subset of all of the bytes in the object described by the report,
 those bytes will be put at their proper indices, and bytes at other indices
 will remain unchanged (contrast with the behavior of #getByteObject)."

^ self _oneArgPrim: 12 arg: byteObj.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
idxSize

"Return ((GciObjRepHdrSType *)buffHdr.current)->idxSize"

^ self _zeroArgPrim: 9.
%

category: 'Updating - Traversal'
method: TraversalBuffer
incrementActualSize: value

"Increment GciTravBufType.usedBytes of the receiver. Deprecated"

self deprecated: 'TraversalBuffer>>incrementActualSize: deprecated in v3.2. Use incrementUsedBytes: instead.'.
^ self _oneArgPrim: 11 arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
incrementUsedBytes: value

"Increment GciTravBufType.usedBytes of the receiver.
 The new value of GciTravBufType.usedBytes is limited to
 a maximum of GciTravBufType.allocatedBytes ."

^ self _oneArgPrim: 11 arg: value.
%

category: 'Initialization'
method: TraversalBuffer
initialize

"Initialize a new instance."

travResultOop := nil.
resultIsSpecial := true.
clampOop := nil.
level := 0.
retrievalFlags := 0.
%

category: 'Updating - Traversal'
method: TraversalBuffer
initTraversalBuffer

"Initialize the receiver to look like an empty traversal buffer.
 The first object report header is memset to zero ."

^ self _zeroArgPrim: 22.
%

category: 'Testing'
method: TraversalBuffer
isCompleteObjectReport

"Return whether the current object report contains the last byte or oop of the object.
 If this method answers true, and #firstOffset answers 1, the object report
 contains all bytes or oops of the object."

^ self currentObjectIsByte
  ifTrue: [ (self firstOffset + self valueBuffSize) > self objSize ]
  ifFalse: [ (self firstOffset + self numberOfValueBuffOops) > self objSize ]
%

category: 'Testing'
method: TraversalBuffer
isEmptyObjectReport

"Return whether the current object report is empty."

^ ( self valueBuffSize == 0 and: [ self objSize > 0 ] )
%

category: 'Testing'
method: TraversalBuffer
isLastObjectInBuffer

"Return whether the current object report is for the last object in the logical buffer
(which includes buffers returned from moreTraversal).
For use when reading a buffer."

^ self complete and: [ self isLastObjectReport ]
%

category: 'Testing - Traversal'
method: TraversalBuffer
isLastObjectReport

"Return whether the current object report is the last report in the buffer
  for reading the buffer."

^ self _zeroArgPrim: 18.
%

category: 'Testing - Traversal'
method: TraversalBuffer
isPartial

"Return whether the current object report is a partial report."

^ self _zeroArgPrim: 26.
%

category: 'Accessing'
method: TraversalBuffer
level

   "Return the value of the instance variable 'level'."
   ^level
%

category: 'Updating'
method: TraversalBuffer
level: newValue

   "Modify the value of the instance variable 'level'."
   level := newValue
%

category: 'Updating - Traversal'
method: TraversalBuffer
makeObjectReportOverlayed

"Return ((GciObjRepHdrSType *)buffHdr.current)->isOverlayed = TRUE"
^ self _zeroArgPrim: 25.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
namedSize

"Return ((GciObjRepHdrSType *)buffHdr.current)->namedSize"

^ self _zeroArgPrim: 7.
%

category: 'Updating - Traversal'
method: TraversalBuffer
nextObjectReport

"Advance to the next object report for reading from the buffer.
 Return whether there is another."

^ self _zeroArgPrim: 17.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
numberOfValueBuffOops

"Return number of oops contained in the value buffer."

^ self valueBuffSize // 4
%

category: 'Accessing - Traversal'
method: TraversalBuffer
objectReportHeaderSize

"Return sizeof(GciObjRepHdrSType)."

^ self _zeroArgPrim: 23.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
objectSecurityPolicy

"Return ((GciObjRepHdrSType *)buffHdr.current)->objectSecurityPolicy"

^ self _zeroArgPrim: 5.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
objId

"Return ((GciObjRepHdrSType *)buffHdr.current)->objId"

^ self _zeroArgPrim: 3.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
objSize

"Return ((GciObjRepHdrSType *)buffHdr.current)->objSize"

^ self _zeroArgPrim: 8.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
oclass

"Return ((GciObjRepHdrSType *)buffHdr.current)->oclass"

^ self _zeroArgPrim: 4.
%

category: 'Accessing'
method: TraversalBuffer
resultIsSpecial

   "Return the value of the instance variable 'resultIsSpecial'."
   ^resultIsSpecial
%

category: 'Updating'
method: TraversalBuffer
resultIsSpecial: newValue

   "Modify the value of the instance variable 'resultIsSpecial'."
   resultIsSpecial := newValue
%

category: 'Accessing'
method: TraversalBuffer
retrievalFlags

   "Return the value of the instance variable 'retrievalFlags'."
   ^retrievalFlags
%

category: 'Updating'
method: TraversalBuffer
retrievalFlags: newValue

   "Modify the value of the instance variable 'retrievalFlags'."
   retrievalFlags := newValue
%

category: 'Deprecated'
method: TraversalBuffer
segment
	self deprecated: 'TraversalBuffer>>segment deprecated in v3.0 and above; use objectSecurityPolicy'.
	^self objectSecurityPolicy.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setBytes: byteObj startingAt: index

"Populate the current object report ((GciObjRepSType *)buffHdr.current)
 from the given byte object. u.bytes is populated with bytes from byteObj
 starting at the given index and ending with the last byte of byteObj. If
 that many bytes will not fit in the receiver, as many bytes as will fit are
 populated and false is answered. If all fit, true is answered.
 In any case, the report's firstOffset is set to index, and the
 valueBuffSize is set to the number of bytes in the report.
 If false is answered, you may send #valueBuffSize to help determine
 the start offset to use in the next buffer."

^ self _twoArgPrim: 0 arg: byteObj arg: index.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setByteSwizzle: value
 "value is a SmallInteger, 0..3 per GciByteSwizEType in gci.ht,
    gci_byte_swiz_none = 0,
    gci_byte_swiz_2_bytes = 1,
    gci_byte_swiz_4_bytes = 2,
    gci_byte_swiz_8_bytes = 3

  On a fetch traversal, the server fills in the bits specified by
   swiz_kind_mask in GciObjRepHdrSType (in gci.ht), and the
  transport layer swizzles accordingly.

  On a store traveral the client is responsible for filling in the
  swiz_kind_mask  bits as follows, for each object report whose
  object's class is a subclass of one of the following classes .
     server class    swizzle bits
     -------------   -----------
     LargeInteger    gci_byte_swiz_4_bytes
     SmallFloat      gci_byte_swiz_4_bytes
     Float           gci_byte_swiz_8_bytes
     DoubleByteString  gci_byte_swiz_2_bytes
     QuadByteString  gci_byte_swiz_4_bytes
     BitSet          gci_byte_swiz_4_bytes
  All other reports should have the swiz_kind_mask  bits == 0.
"
^  self _oneArgPrim: 26 arg: value
%

category: 'Updating - Traversal'
method: TraversalBuffer
setComplete: value

"Set buffHdr->complete."

^ self _oneArgPrim: 15 arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setFirstObjectReport

"Set the pointer to the first object report."

^ self _zeroArgPrim: 19.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setFirstOffset: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->firstOffset"

^ self _oneArgPrim: 9 arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setFormat: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->objImpl where

-1 indicates GC_FORMAT_SPECIAL
0 indicates GC_FORMAT_OOP
1 indicates GC_FORMAT_BYTE
2 indicates GC_FORMAT_NSC
"

^ self _oneArgPrim: 10 arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setIdxSize: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->idxSize"

^ self _oneArgPrim: 7 arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setIsInvariant: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->isInvariant."

^ self _oneArgPrim: 4 arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setNamedSize: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->namedSize"

^ self _oneArgPrim: 5 arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setNextObjectReport

"Advance to the next object report for writing to the buffer.
The next object report header is memset to zero .
 You must send this message after you complete writing
 each object to the buffer, including the last object.
 Answers false if there is not enough room in the buffer
 for another object header, true otherwise."

^ self _zeroArgPrim: 27.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setObjectSecurityPolicyId: value

"value must be a legal objectSecurityPolicyId, a SmallInt in range 0..16rFFFF"

^ self _oneArgPrim: 3 arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setObjId: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->objId"

^ self _oneArgPrim: 1 arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
setOclass: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->oclass"

^ self _oneArgPrim: 2 arg: value.
%

category: 'Deprecated'
method: TraversalBuffer
setSegmentId: value
self deprecated: 'TraversalBuffer>>setSegmentId: deprecated v3.0, use setObjectSecurityPolicyId:'.
^ self setObjectSecurityPolicyId: value
%

category: 'Updating - Traversal'
method: TraversalBuffer
setValueBuffSize: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->valueBuffSize.
 Not needed after setBytes:startingAt: ."

^ self _oneArgPrim: 8 arg: value.
%

category: 'Accessing'
method: TraversalBuffer
travResultOop

   "Return the value of the instance variable 'travResultOop'."
   ^travResultOop
%

category: 'Updating'
method: TraversalBuffer
travResultOop: newValue

   "Modify the value of the instance variable 'travResultOop'."
   travResultOop := newValue
%

category: 'Accessing - Traversal'
method: TraversalBuffer
usedBytes
"Return the actual size of the traversal buffer.
 The result is value of the field GciTravBufType.usedBytes in receiver."

^ self _zeroArgPrim: 16.
%

category: 'Updating - Traversal'
method: TraversalBuffer
valueBufferAt: i putRemoteOop: value

"Set ((GciObjRepSType *)buffHdr.current)->u.oops[offset] = value.  Return whether
the insertion was allowed."

^ self _twoArgPrim: 2 arg: i arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
valueBufferAt: i putSpecial: value

"Set ((GciObjRepSType *)buffHdr.current)->u.oops[offset] = value.  Return whether
the insertion was allowed."

^ self _twoArgPrim: 1 arg: i arg: value.
%

category: 'Updating - Traversal'
method: TraversalBuffer
valueBufferPutOverlayAt: i

"Set ((GciObjRepSType *)buffHdr.current)->u.oops[offset] = OOP_OVERLAY.
Return whether the insertion was allowed."

self makeObjectReportOverlayed.
^ self _oneArgPrim: 14 arg: i.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
valueBufferRemoteOop

"Return the next remote oop in the value buffer, which is non-special."

^ self _zeroArgPrim: 20.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
valueBufferSpecialOop

"Return the next oop, which is special format, in the value buffer."

^ self _zeroArgPrim: 31.
%

category: 'Accessing - Traversal'
method: TraversalBuffer
valueBuffSize

"Return ((GciObjRepHdrSType *)buffHdr.current)->valueBuffSize"

^ self _zeroArgPrim: 10.
%

category: 'Accessing'
method: TraversalBuffer
varyingEndOffset

"Return the end point for updating the varying portion of the receiver."

^ self numberOfValueBuffOops - self namedSize + self firstOffset - 1
%

category: 'Accessing'
method: TraversalBuffer
varyingStartOffset

"Return the starting point for updating the varying portion of the receiver."

| start firstOffset namedSize |

firstOffset := self firstOffset.
namedSize := self namedSize.

start := 1.
( firstOffset > 1 and: [ firstOffset > namedSize ] )
  ifTrue: [ start := firstOffset - namedSize ].
^ start
%

! Class implementation for 'CDeclaration'

!		Class methods for 'CDeclaration'

category: 'other'
classmethod: CDeclaration
header: aHeader
	"Return a CDeclaration (might not be self)"

	^(self readTypeFrom: aHeader) readDeclaration
%

category: 'other'
classmethod: CDeclaration
readInitializer
	"Since we don't have a real expression parser, we will go till we reach
	a comma, semicolon, or close parenthesis not in a nesting"

	| token parenthesisCount curlyBracketCount |
	(token := self peek) ifNil: [^self].
	token value = '__attribute__' ifTrue: [
		self next.
		self readAttributes.
		^self readInitializer
	].
	token isEqualsToken ifFalse: [^self].
	self next.
	parenthesisCount := 0.
	curlyBracketCount := 0.
	[true] whileTrue: [ | pkk |
		(pkk := self peek) ifNil: [ token error:'next token is empty' ].
    token := pkk .
		(parenthesisCount == 0 and: [curlyBracketCount == 0]) ifTrue: [
			token isCommaToken ifTrue: [^self].
			token isSemicolonToken ifTrue: [^self].
			token isCloseParenthesisToken ifTrue: [^self].
		].
		token isOpenParenthesisToken ifTrue: [parenthesisCount := parenthesisCount + 1] ifFalse: [
		token isCloseParenthesisToken ifTrue: [parenthesisCount := parenthesisCount - 1] ifFalse: [
		token isOpenCurlyBracketToken ifTrue: [curlyBracketCount := curlyBracketCount + 1] ifFalse: [
		token isCloseCurlyBracketToken ifTrue: [curlyBracketCount := curlyBracketCount - 1]]]].
		self next.
	].
%

category: 'other'
classmethod: CDeclaration
readTypeFrom: aHeader
	"Return a CDeclaration (might not be self)"

	^self basicNew readTypeFrom: aHeader
%

!		Instance methods for 'CDeclaration'

category: 'CByteArray get'
method: CDeclaration
accessorForOffset: anInteger
  | typ |
	1 < count size ifTrue: [ self error: 'Multi-dimensional arrays not supported']. 
	0 == pointer ifTrue: [
    (typ := type) _isSymbol ifFalse:[ typ := type argumentType "handle typedef"].
		(typ == #class or:[ typ == #struct ]) ifTrue:[ ^ self structAccessorForOffset: anInteger ].
		count == nil ifTrue: [^self simpleAccessorForOffset: anInteger].
    1 < count size ifTrue:[ self error: 'Multi-dimensional arrays not supported!'].
		type == #'uint8' ifTrue: [^self stringAccessorForOffset: anInteger].
		^self arrayAccessorForOffset: anInteger.
	].
	1 < pointer ifTrue: [self error: 'Multi-level pointers not supported'].
	count == nil ifTrue: [^self singlePointerAccessorForOffset: anInteger].
	type == #'uint8' ifTrue: [^self stringPointerAccessorForOffset: anInteger].
	^self arrayPointersAccessorForOffset: anInteger.
%

category: 'CCallout'
method: CDeclaration
addSourceTo: aStream
  | fn |
  file ifNil:[ 
    fn := 'test'
  ] ifNotNil:[ 
    fn := file .
    fn size > 0 ifTrue:[ | gsIncl exp |
      gsIncl := GsFile _expandEnvVariable:'GEMSTONE' isClient: false .
      gsIncl := GsFile _expandFilename: gsIncl isClient: false . "follow symlinks"
      (gsIncl at: 1 equals: (exp := '/export')) ifTrue:[
         gsIncl := gsIncl copyFrom: exp size + 1  to: gsIncl size .
      ].
      gsIncl ifNotNil:[  | ofs |
        ofs := 1 .
        gsIncl last == $/ ifFalse:[ gsIncl add: $/ ].
        gsIncl add: 'include' .
        (fn at: 1 equals: exp) ifTrue:[ ofs := ofs + exp size ].
        (fn at: ofs  equals: gsIncl) ifTrue:[ 
          fn := '$GEMSTONE/include' , (fn copyFrom: gsIncl size + ofs  to: fn size)
        ].
        (System gemVersionReport at: 'gsBuildArchitecture') = 'Darwin (macOS)' ifTrue:[
          (fn at: 1 equals: '/Volumes') ifTrue:[ "Darwin"
            fn := fn copyFrom: '/Volumes' size + 1 to: fn size .
            (fn at: 1 equals: gsIncl) ifTrue:[ 
              fn := '$GEMSTONE/include' , (fn copyFrom: gsIncl size + 1 to: fn size)
            ].
          ].
        ]
      ].
    ].
  ].
	aStream 
		lf; tab; nextPut: $";
		nextPutAll: fn ;
		nextPutAll: ' line ';
		nextPutAll: line printString; lf .
  source ifNotNil:[:src | 
    src trimSeparators do: [:char | 
    aStream nextPut: char. char == $" ifTrue: [aStream nextPut: char]].
  ].
	aStream nextPut: $"; lf.
%

category: 'CCallout'
method: CDeclaration
argumentType
	(self isSimple and: [self knownArgumentTypes includesIdentical: type]) ifTrue: [^type].
	type == #'enum' ifTrue: [^#'int32'].
	(type == #'uint8' and: [isConstant]) ifTrue: [
		(count size == 1 and: [pointer == 0]) ifTrue: [^#'const char*'].		"const char foo[]"
		(count == nil and: [pointer == 1]) ifTrue: [^#'const char*'].			"const char * foo"
	].
  self isStruct ifTrue:[ ^ #struct ].
  (pointer > 0 or:[ count ~~ nil]) ifTrue:[ ^ #ptr ].
  type _isSymbol ifFalse:[ ^ type argumentType ] . "a typedef or similar"
	^ #ptr .
%

category: 'CByteArray get'
method: CDeclaration
arrayAccessorForOffset: anInteger

	^(AppendStream on: String new)
		nextPutAll: name; lf; tab;
		nextPutAll: '| array offset | "generated by CDeclaration>>arrayAccessorForOffset:"'; 
        lf; tab;
		nextPutAll: 'array := Array new: ';
		nextPutAll: count first printString;
		nextPut: $.; lf; tab;
		nextPutAll: 'offset := ';
		nextPutAll: anInteger printString;
		nextPut: $.; lf; tab;
		nextPutAll: '1 to: array size do: [:i | '; lf; tab; tab;
		nextPutAll: 'array at: i put: (self ';
		nextPutAll: self getSelector;
		nextPutAll: ' offset).'; lf; tab; tab;
		nextPutAll: 'offset := offset + ';
		nextPutAll: self baseByteSize printString;
		nextPut: $.; lf; tab;
		nextPutAll: '].'; lf; tab;
		nextPutAll: '^array.'; lf;
		contents.
%

category: 'CByteArray get'
method: CDeclaration
arrayPointersAccessorForOffset: anInteger

	^(AppendStream on: String new)
		nextPutAll: name; lf; tab;
		nextPutAll: '| array offset | "generated by CDeclaration>>arrayPointersAccessorForOffset:"'; 
        lf; tab;
		nextPutAll: 'array := Array new: ';
		nextPutAll: count first printString;
		nextPut: $.; lf; tab;
		nextPutAll: 'offset := ';
		nextPutAll: anInteger printString;
		nextPut: $.; lf; tab;
		nextPutAll: '1 to: array size do: [:i | '; lf; tab; tab;
		nextPutAll: 'array at: i put: (self pointerAt: offset resultClass: ';
		nextPutAll: header cByteArraySpecies name asString;
		nextPutAll: ').'; lf; tab; tab;
		nextPutAll: 'offset := offset + 8.'; lf; tab;
		nextPutAll: '].'; lf; tab;
		nextPutAll: '^array.'; lf;
		contents.
%

category: 'CByteArray put'
method: CDeclaration
arrayPointersUpdatorForOffset: anInteger

	^(AppendStream on: String new)
		nextPutAll: name;
		nextPutAll: ': anArrayOfCByteArrayInstances'; lf; tab;
		nextPutAll: '| offset | "generated by CDeclaration>>arrayPointersUpdatorForOffset:"'; 
      lf; tab;
		nextPutAll: 'offset := ';
		nextPutAll: anInteger printString;
		nextPut: $.; lf; tab;
		nextPutAll: '1 to: anArrayOfCByteArrayInstances size do: [:i | '; lf; tab; tab;
		nextPutAll: 'self'; lf; tab; tab; tab;
		nextPutAll: 'pointerAt: offset'; lf; tab; tab; tab; 
		nextPutAll: 'put: (anArrayOfCByteArrayInstances at: i).'; lf; tab; tab;
		nextPutAll: 'offset := offset + 8.'; lf; tab;
		nextPutAll: '].'; lf;
		contents.
%

category: 'CByteArray put'
method: CDeclaration
arrayUpdatorForOffset: anInteger

	^(AppendStream on: String new)
		nextPutAll: name;
		nextPutAll: ': aSequenceableCollection'; lf; tab;
		nextPutAll: '| offset | "generated by CDeclaration>>arrayUpdatorForOffset:"'; lf; tab;
		nextPutAll: 'offset := ';
		nextPutAll: anInteger printString;
		nextPut: $.; lf; tab;
		nextPutAll: '1 to: aSequenceableCollection size do: [:i | '; lf; tab; tab;
		nextPutAll: 'self '; lf; tab; tab; tab;
		nextPutAll: self getSelector; space;
		nextPutAll: 'offset'; lf; tab; tab; tab;
		nextPutAll: 'put: (aSequenceableCollection at: i).'; lf; tab; tab;
		nextPutAll: 'offset := offset + ';
		nextPutAll: self baseByteSize printString;
		nextPut: $.; lf; tab;
		nextPutAll: '].'; lf;
		contents.
%

category: 'CCallout'
method: CDeclaration
asClassVarName

	^'Function_' , name.
%

category: 'other'
method: CDeclaration
atEnd

	^header atEnd.
%

category: 'size'
method: CDeclaration
baseByteSize
  ^ self _baseByteSize at: 1 
%

category: 'other'
method: CDeclaration
beExternStorage

	storage := #'extern'.
%

category: 'accessors'
method: CDeclaration
bitCount

	^bitCount.
%

category: 'size'
method: CDeclaration
byteSize
  ^ self _byteSize at: 1 .
%

category: 'size'
method: CDeclaration
byteSizeForMalloc
  "Return a size rounded up to 8 bytes, which may be a more strict
   rounding than a struct would have within another struct."
  | arr sz rem |
  arr := self _byteSize .
  sz := arr at: 1 .
  (rem := sz \\ 8) ~~ 0 ifTrue:[
     sz := sz + (8 - rem)
  ].
  ^ sz 
%

category: 'querying'
method: CDeclaration
canStorageBeMadeExternal

	^(#(#auto #inline #static) includesIdentical: storage)
		or: [storage = #extern and: [linkageSpec == nil ]]
%

category: 'CCallout'
method: CDeclaration
cCalloutForLibrary: aCLibrary
  self usesStructs ifTrue:[ Error signal:'Not supported for a callout with structs'].
	^ CCallout
		library: aCLibrary 
		name: name 
		result: self resultType 
		args: (parameters collect: [:each | each argumentType])
		varArgsAfter: (isVaryingArgCount ifTrue: [parameters size] ifFalse: [-1]).
%

category: 'Class Membership'
method: CDeclaration
cCalloutSpecies
"Answer the class to be used for CCallout objects. Subclasses may
 overload this method as needed."
^ CCallout
%

category: 'Class Membership'
method: CDeclaration
cDeclarationSpecies
"Answer the class to be used for CDeclaration objects. Subclasses may
 overload this method as needed."
^ CDeclaration
%

category: 'size'
method: CDeclaration
containsFloat  
  type _isSymbol ifFalse:[ ^ type containsFloat ].
  (type == #double or:[ type == #float]) ifTrue:[ ^ true ].
  ^ false
%

category: 'accessors'
method: CDeclaration
count

	^count.
%

category: 'Class Membership'
method: CDeclaration
cPreprocessorSpecies
"Answer the class to be used for CPreprocessor objects. Subclasses may
 overload this method as needed."
^ CPreprocessor
%

category: 'CCallout'
method: CDeclaration
createFunctionInitializerCode
	| stream |
  self usesStructs ifTrue:[  ^ self _createFunctionInitializerCodeStructs ].
	stream := AppendStream on: String new.
	stream
		nextPut: self initializerFunctionName;
		nextPut: ' cLibrary'; lf; lf; tab;
		nextPut: self asClassVarName , ' := CCallout ' ; lf; tab; tab;
		nextPut: 'library: cLibrary'; lf; tab; tab;
		nextPut: 'name: ''' , name , $' ; lf; tab; tab;
		nextPut: 'result: #''' , self resultType , $' ; lf ; tab; tab;
		nextPut: 'args: #(' .
	parameters do: [:each | stream nextPut: ' ', each argumentType printString ].
	stream nextPut: ')' .
  isVaryingArgCount 
    ifFalse:[ stream nextPut: $. ; lf . ]
    ifTrue:[
       stream lf ; tab ; tab ;
         nextPut: 'varArgsAfter: ', self varArgsAfter asString , $. ; lf . 
    ].
  ^ stream contents.
%

category: 'querying'
method: CDeclaration
derivedType

	storage == #typedef ifFalse:[ ^self ].
	type == #class ifTrue: [^self].
	self isFunction ifTrue: [^self].
  type _isSymbol ifTrue:[ ^ self ].
  (type type == #struct and:[pointer == 0]) ifTrue:[ 
    "For typedef struct x_a { } x ;     return CDeclaration with name x "
    ^ self  
  ].
	^type
%

category: 'accessors'
method: CDeclaration
enumList

	^type == #'enum'
		ifTrue: [fields]
		ifFalse: [nil].
%

category: 'accessors'
method: CDeclaration
enumTag

	^enumTag.
%

category: 'Errors'
method: CDeclaration
error: aString

  Error signal: aString , ' near line ' , line asString , ' in file ' , file asString
%

category: 'other'
method: CDeclaration
expectCloseParenthesisCount: anInteger

	anInteger timesRepeat: [
		| token |
		(token := self next) isCloseParenthesisToken ifFalse: [token error: 'Expected '')'' '].
	].
%

category: 'accessors'
method: CDeclaration
fields

	^type == #struct
		ifTrue: [fields]
		ifFalse: [nil].
%

category: 'accessors'
method: CDeclaration
file

	^file.
%

category: 'CByteArray get'
method: CDeclaration
getSelector
  | sel |
  sel := self _getFieldSelector .
  sel _isOneByteString ifFalse:[ self error:'struct or large union not supported'].
  ^ sel
%

category: 'accessors'
method: CDeclaration
header

	^header.
%

category: 'accessors'
method: CDeclaration
includesCode

	^includesCode.
%

category: 'type'
method: CDeclaration
initializeAsStructOrUnion

	| token |
	storage := #auto .
	(token := self peek) isOpenCurlyBracketToken ifFalse: [^self].
	self next.
	fields ifNotNil: [self error: 'Fields already defined!'].
	fields := { }.
	[
		(token := self peek) isCloseCurlyBracketToken .
	] whileFalse: [
		| field |
		field := self class header: header.
		field storage == #auto ifFalse: [ token error: 'storage is not #auto'].
		[
			fields add: field.
			(token := self next) isCommaToken.
		] whileTrue: [
			field := field copy.
			field readDeclaration.
      field trapName .
		].
		token isSemicolonToken ifFalse: [ token error: 'expected '';'' '].
	].
	self next.
%

category: 'CCallout'
method: CDeclaration
initializerFunctionName
	^'initializeFunction_', name, '_inLibrary:'
%

category: 'type'
method: CDeclaration
interpretTypeSpecifier

	type class == Array ifFalse: [^self].
	(type size == 1 and:[
   #(#class #'enum' #'float' #'float128' #void) includesIdentical: type first]) 
     ifTrue: [type := type first. ^self].

	"https://en.cppreference.com/w/c/language/arithmetic_types#Complex_floating_types
	https://gcc.gnu.org/onlinedocs/gcc-4.8.0/gcc/Complex.html"
	(type includesIdentical: #'complex') ifTrue: [
		| string |
		type removeIdentical: #'complex'.
		self interpretTypeSpecifier.
		(type isKindOf: Symbol) ifFalse: [self error: 'Expected to be simplified to a single type'].
		string := String withAll: type.
		string at: 1 put: string first asUppercase.
		type := ('complex' , string) asSymbol.
		^self
	].

	(type includesIdentical: #'char') ifTrue: [
		type removeIdentical: #'char'.
		type = #(#'signed') ifTrue: [type := #'int8'. ^self].
		(type isEmpty or: [type = #(#'unsigned')]) ifTrue: [type := #'uint8'. ^self].
    self error:'for a char type , unknown type ', type printString	.
	].
	(type includesIdentical: #'bool') ifTrue: [
		type removeIdentical: #'bool'.
		type isEmpty ifTrue:[ type := #'uint8'. ^self ].
    self error:'for a bool type , unknown type ', type printString	.
	].
	(type includesIdentical: #double) ifTrue: [
		type removeIdentical: #double.
		type isEmpty ifTrue: [type := #double. ^self].
		type = #(#'long') ifTrue: [type := #'longDouble'. ^self].
    self error:'for a double type, unknown type ', type printString	.
	].
	(type isEmpty or: [#(#'int' #'unsigned' #'long' #'signed' #'short') 
                     anySatisfy: [:each | type includesIdentical: each]]) ifTrue: [
		| isUnsigned |
		(type includesIdentical: #'int') ifTrue: [type removeIdentical: #'int'].
		(isUnsigned := type includesIdentical: #'unsigned') ifTrue: [type removeIdentical: #'unsigned'].
		(type includesIdentical: #'signed') ifTrue: [type removeIdentical: #'signed'].
		type = #(#'long') ifTrue: [
			type := isUnsigned ifTrue: [#'uint64'] ifFalse: [#'int64'].
			^self.
		].
		type = #(#'long' #'long') ifTrue: [
			type := isUnsigned ifTrue: [#'uint64'] ifFalse: [#'int64'].
			^self.
		].
		type = #(#'short') ifTrue: [
			type := isUnsigned ifTrue: [#'uint16'] ifFalse: [#'int16'].
			^self.
		].
		type isEmpty ifTrue: [
			type := isUnsigned ifTrue: [#'uint32'] ifFalse: [#'int32'].
			^self.
		].
		self error:'unrecognized integer type: ', type printString .
	].
	(type size == 1 and:[
     #(#'uint64' #'int64' #'uint32' #'int32' #'uint16' #'int16' #'uint8' #'int8') 
         includesIdentical: type first]) ifTrue: [
		type := type first.
		^self.
	].
	(type size == 1 and: [type first isKindOf: CDeclaration]) ifTrue: [type := type first. ^self].
	self error:'unrecognized type: ', type printString .
%

category: 'CCallout'
method: CDeclaration
invokeFunctionCode
	| args stream |
  self usesStructs ifTrue:[  ^ self _invokeFunctionCodeStructs ].
	args := { } .
  1 to: parameters size do: [:j | | each | 
    each := parameters at: j .
    args add:  (each _argName: j) .
  ].
	(stream := AppendStream on: String new)
		nextPutAll: name .
	args do: [:each | stream nextPut: '_: ', each, ' '].
  isVaryingArgCount ifTrue:[ 
   stream lf ; tab ; nextPut:'    varArgs: vaArray"pairs of type, arg" ' ].

	self addSourceTo: stream.
	stream
		tab; 
		nextPutAll: '"Interpreted as #';
		nextPutAll: self resultType;
		nextPutAll: ' from #(' .
	parameters do: [:each | stream space. each argumentType printOn: stream].
	stream 
		nextPutAll: ' )';
		nextPut: $"; lf; tab .
  isVaryingArgCount ifFalse:[
		stream nextPut: '^ ', self asClassVarName , ' callWith: { ' .
	  args do: [:each | stream nextPut: each , '. ' ].
    self _removeLastDot: stream collection .
    stream nextPut: ' } errno: nil ' ; lf .
	] ifTrue:[
    stream nextPut: ' | args | '; lf ; tab ;
      nextPut: ' args := { ' .
	  args do: [:each | stream nextPut: each , '. ' ].
    self _removeLastDot: stream collection .
    stream nextPut: ' }. ' ; lf ; tab;
      nextPut: ' vaArray ifNotNil:[ args addAll: vaArray ].'; lf; tab ;
      nextPut: ' ^ ', self asClassVarName , ' callWith: args errno: nil .'; lf .
  ].  
	^ stream contents .
%

category: 'accessors'
method: CDeclaration
isConstant

	^isConstant.
%

category: 'querying'
method: CDeclaration
isEmptyExternalLinkage
	"Answer whether the receiver is the introduction of:
		extern ''C'' { ... }
	 Note that we also end up with this after reading the entire { ... } block."

	^self storage = #extern
		and: [linkageSpec ~~ nil 
		and: [self name == nil 
		and: [self type == nil ]]]
%

category: 'querying'
method: CDeclaration
isEmptyVoid

	^name == nil and: [
		storage == #auto and: [
		type == #void and: [
		count == nil and: [
		pointer == 0 and: [
		fields == nil and: [
		isConstant == false and: [
		self isFunction == false and: [
		bitCount == nil  ]]]]]]]].
%

category: 'querying'
method: CDeclaration
isFunction

	^parameters ~~ nil .
%

category: 'CCallout'
method: CDeclaration
isSimple

	^count == nil  and: [pointer = 0].
%

category: 'other'
method: CDeclaration
isStruct
  (type == #class or:[ type == #struct]) ifTrue:[ 
    pointer == 0 ifFalse:[ self error:'inconsistent pointer value'].
    ^ true 
  ].
  pointer > 0 ifTrue:[ ^ false ].
  (type isKindOf: CDeclaration) ifTrue:[ ^ type isStruct ].
  ^ false .
%

category: 'accessors'
method: CDeclaration
isVaryingArgCount

	^isVaryingArgCount.
%

category: 'CCallout'
method: CDeclaration
knownArgumentTypes

	^#( #int64 #uint64 #int32 #uint32 #int16 #uint16 #int8 #uint8 #bool #double #float #ptr #'char*' "#'&ptr'" #'const char*' ).
%

category: 'CCallout'
method: CDeclaration
knownResultTypes

	^#( #int64 #uint64 #int32 #uint32 #int16 #uint16 #int8 #uint8 #bool #double #float #ptr #'char*' #void ).
%

category: 'accessors'
method: CDeclaration
line

	^line.
%

category: 'accessors'
method: CDeclaration
linkageSpec

	^linkageSpec.
%

category: 'declarator'
method: CDeclaration
mayHaveCode

	storage == #'static' 	ifTrue: [^true].
	storage == #'inline' 	ifTrue: [^true].
	type == #class		ifTrue: [^true].
	((type isKindOf: CDeclaration) and: [type type == #class ]) ifTrue: [^true].
	^false
%

category: 'accessors'
method: CDeclaration
members

	^type == #union
		ifTrue: [fields]
		ifFalse: [nil].
%

category: 'accessors'
method: CDeclaration
name

	^name.
%

category: 'other'
method: CDeclaration
next
  | res |
	res := self peek ; _next .
  ^ res
%

category: 'accessors'
method: CDeclaration
parameters

	^parameters.
%

category: 'other'
method: CDeclaration
peek

	| next wasIdentifierInSystemNamespace |
	wasIdentifierInSystemNamespace := false.
	[
		| wasEmpty |
		next := header peek.
		next ifNil:[ ^ nil ].
		wasEmpty := next isEmptyToken.
		wasEmpty ifFalse: [
			| value |
			(wasIdentifierInSystemNamespace and: [next isOpenParenthesisToken]) ifTrue: [
				self skipFunction.
				^self peek.
			] ifFalse: [
				wasIdentifierInSystemNamespace := next isIdentifierToken and: [2 < (value := next value) size and: 
					[(value at: 1) == $_ and: [(value at: 2) == $~]]].
			].
		].
		wasEmpty or: [wasIdentifierInSystemNamespace].
	] whileTrue: [
		self _next.
	].
	^ next
%

category: 'accessors'
method: CDeclaration
pointer

	^pointer.
%

category: 'other'
method: CDeclaration
printFunctionParametersOn: aStream

	| comma |
	(name == nil  or: [name last ~~ $(]) ifTrue: [
		aStream nextPut: $(.
	].
	(parameters == nil  or: [parameters isEmpty]) ifTrue: [aStream nextPutAll: 'void)'. ^self].
	comma := ''.
	parameters do: [:each | 
		aStream nextPutAll: comma.
		each printOn: aStream.
		comma := ', '.
	].
	aStream nextPut: $).
%

category: 'other'
method: CDeclaration
printOn: aStream

	storage ifNotNil: [
		(storage == #auto or: [storage == #typedef and: [type == #class ]]) ifFalse: [aStream nextPutAll: storage; space].
		linkageSpec ifNotNil:[ aStream nextPut: $"; nextPutAll: linkageSpec; nextPut: $"; space].
	].
	isConstant ifTrue: [aStream nextPutAll: 'const '].
	((type isKindOf: CDeclaration) and: [type isFunction]) ifTrue: [
		type printOn: aStream from: self.
		^self.
	].
	type ~= #() ifTrue: [
		(type isKindOf: Symbol)
			ifTrue: [aStream nextPutAll: type]
			ifFalse: [type printOn: aStream]. 
		aStream space.
	].
	pointer timesRepeat: [aStream nextPut: $*].
	enumTag ifNotNil: [aStream nextPutAll: enumTag; space].
	(storage == #typedef and: [self isFunction and: [0 < pointer]]) ifTrue: [aStream nextPut: $(].
	name ifNotNil: [aStream nextPutAll: name].
	count ifNotNil: [
		count do: [:each | 
			aStream nextPut: $[.
			0 < each ifTrue: [each printOn: aStream].
			aStream nextPut: $].
		].
	].
	(storage == #typedef and: [self isFunction and: [0 < pointer]]) ifTrue: [aStream nextPut: $)].
	self isFunction ifTrue: [self printFunctionParametersOn: aStream].
%

category: 'other'
method: CDeclaration
printOn: aStream from: aCDeclaration

	| open close |
	(type isKindOf: Symbol) ifTrue: [
		aStream nextPutAll: type.
	] ifFalse: [
		aStream nextPutAll: '<???>'.
	].
	aStream space.
	0 == aCDeclaration pointer ifTrue: [
		open := ''.
		close := ''.
	] ifFalse: [
		open := '('. 
		close := ')'.
	].
	pointer timesRepeat: [aStream nextPut: $*].
	aStream nextPutAll: open.
	aCDeclaration pointer timesRepeat: [aStream nextPut: $*].
	(name ~~ nil  and: [storage ~~ #typedef ]) ifTrue: [aStream nextPutAll: name].
	aStream nextPutAll: close.
	self printFunctionParametersOn: aStream.
%

category: 'accessors'
method: CDeclaration
properties

	^type == #class
		ifTrue: [fields]
		ifFalse: [nil].
%

category: 'attributes'
method: CDeclaration
readAttributes
"
	http://tigcc.ticalc.org/doc/gnuexts.html
"
	| parenthesisCount token |
	(token := self next) isOpenParenthesisToken ifFalse: [token error: 'Expected ''('' '].
	(token := self next) isOpenParenthesisToken ifFalse: [token error: 'Expected ''('' '].
	parenthesisCount := 2.
	[
		0 < parenthesisCount.
	] whileTrue: [
		token := self next.
		token isOpenParenthesisToken ifTrue: [
			parenthesisCount := parenthesisCount + 1.
		] ifFalse: [
			token isCloseParenthesisToken ifTrue: [
				parenthesisCount := parenthesisCount - 1.
			] ifFalse: [
				(token isIdentifierToken and: [token value = '__mode__']) ifTrue: [^self readModeAttributes].
			].
		].
	].
%

category: 'other'
method: CDeclaration
readBitFields
	"We parse bit fields, but we don't handle them properly!"

	bitCount := self cPreprocessorSpecies evaluateHeader: header.
	(bitCount isKindOf: SmallInteger) ifFalse: [ self error: 'Expected a SmallInteger in readBitFields'].
%

category: 'type'
method: CDeclaration
readComplexType
"
>>--+--struct--+--+-----identifier---------------------------+--><
      |              |   |                        .----------------.     |
      '--union----'    |                       V                   |     |
                          '--+----------+--{----member--;--+--}-'
                             '-identifier-'
"
	self peek isIdentifierToken ifTrue: [
		| dictionary |
		name := self next value.
    self trapName .
		dictionary := type == #struct
			ifTrue: [header structs]
			ifFalse: [header unions].
		type := dictionary
			at: name
			ifAbsentPut:[ | x | x := self copy . x trapName . x].
	] ifFalse: [
		type := self copy.
    type trapName .
	].
	type fields ifNil: [type initializeAsStructOrUnion].
  self trapName .
	name := nil.
%

category: 'declarator'
method: CDeclaration
readConstantExpression

	| token x |
	[
		(x := self peek) ~~ nil and: [x isOpenSquareBracketToken].
	] whileTrue: [
		| value tok |
		self next.
		count ifNil: [count := { } ].
		value := (tok := self peek) isCloseSquareBracketToken 
			ifTrue: [0]
			ifFalse: [self cPreprocessorSpecies evaluateHeader: header].
		value _isSmallInteger  ifFalse: [ tok error: 'Expected a SmallInteger'].
		count add: value.  
		(token := self next) isCloseSquareBracketToken ifFalse:[ token error:'expected '']'' '].
	].
%

category: 'declarator'
method: CDeclaration
readDeclaration
	"Return a CDeclaration (might not be self)
	   .-,------------------------------.
	  V                                      |
	----declarator--+-------------+-+--;--><
						  '--initializer--'

	We handle only one declarator; the caller (in CHeader>>#'readOne') handles the comma.
"
	| declaration token1 token2 trace |
	trace ifNotNil:[ token1 := self peek].	"for debugging"
	(declaration := self readDeclarator) ifNil: [
		^self.
	].
	declaration includesCode ifTrue: [^declaration].
	trace ifNotNil:[ token2 := self peek].	"for debugging"
	^declaration 
		readInitializer;
		readPostlude;
		yourself
%

category: 'declarator'
method: CDeclaration
readDeclarator
	"Return a CDeclaration (might not be self)
	>>--+-------------------------+--directDeclarator--><
	      |  .---------------------.  |
	      |  V                        |  |
	      '----pointerOperator--+-'
"
	| declaration token1 token2 trace |
	trace ifNotNil:[ token1 := self peek].	"for debugging"
	(declaration := self readPointerOperator) ifNotNil: [
		trace ifNotNil:[ token2 := self peek ].	"for debugging"
		^declaration readDeclarator.
	].
	^self readDirectDeclarator.
%

category: 'declarator'
method: CDeclaration
readDirectDeclarator
"Return a CDeclaration (might not be self)
	>>--+------------------------------------------------------------------------------------------------------+-><
	    +--declaratorName----------------------------------------------------------------------------------------+
	      +--directDeclarator--(--parameterDeclarationList--)--+----------------+---+----------------------------+--+
	      |          '--cvQualifiers--'     '--exceptionSpecification--'    |
	      +--directDeclarator--[--+-----------------------+--]------------------------------------------------+
	      |     '-constantExpression-'                                                                           |
	      '--(--declarator--)----------------------------------------------------------------------------------'
        + ----  : ---  superclassName ----
"
	| token declarator superName |
	(token := self peek) ifNil: [^self].
	token isIdentifierToken ifTrue: [
    name := token value.
    self trapName .
		(token := self next; peek) ifNil: [^self].
	] ifFalse: [ 
		(((type isKindOf: CDeclaration) and: [type type == #class ]) == false  
          and: [token isOpenParenthesisToken]) ifTrue: [ 
			self next.	"skip the open parenthesis token"
			declarator := self cDeclarationSpecies header: header.
			(token := self next) isUpArrowToken ifTrue: [	"Block argument, not pointer to function"
				storage := #'block'. 
				(token := self next) isIdentifierToken ifTrue: [token := self next].
			].
			token isCloseParenthesisToken ifFalse: [self error: 'expected '')'''].
			(token := self peek) ifNil: [self error: 'next token is empty'].
		].
	].
  ((type == #class or:[ type == #struct]) and:[ token isColonToken ]) ifTrue:[ | nxt|
    self next .
    nxt := self peek . 
    nxt isPublicIdentifierToken ifTrue:[ self next ].   "TODO  accumulate nested fields to fix bug 51114 "
    superName := self next .
    token := self peek 
  ].
	token isOpenParenthesisToken ifTrue: [
		self readParameterDeclarationList.
		declarator ifNil: [^self].
		declarator 
			setStorage: storage
			type: self.
		storage := #auto .
		^declarator
	].
	token isOpenSquareBracketToken ifTrue: [
		declarator ifNotNil: [ token error:'unexpected declarator after ''['' ' ].
		self readConstantExpression.
		^self
	].
	declarator ifNil: [^self].
	"this is a specialized check for a function argument of the form ' struct dirent *(*[]) '."
	(declarator storage == #auto and: [
		declarator type == #'int32' and: [
		declarator name == nil  and: [
		declarator count = #(0)]]]) ifTrue: [
			pointer := pointer + declarator pointer + 1.
		].
	^self
%

category: 'type'
method: CDeclaration
readEnumeration
  "
  'enum' [ identifier ] '{' enumerator-list '}' [ variable-list ]
  or
  'enum' identifier variable-list 
  or
  'enum' identifier function-definition // #48859
  "

  | token integralConstant |
  token := self peek.
  token isColonToken ifTrue:[ self next . token := self peek ]. "seen on Darwin 23.2"
  token isIdentifierToken ifTrue: [
    enumTag := self next value.
    token := self peek.
	].
  token isOpenCurlyBracketToken ifTrue: [
    fields := Dictionary new.       "this allows us to tell if the enum included an enumerator-list"
    self next.
    integralConstant := -1.
    [
      (token := self next) isCloseCurlyBracketToken.
    ] whileFalse: [
      | identifier |
      token isIdentifierToken ifFalse: [token error: 'expected an identifier' ].
        identifier := token value.
        integralConstant := self peek isEqualsToken ifTrue: [ | tok |
          tok := self next.
          integralConstant := self cPreprocessorSpecies evaluateHeader: header.
          (integralConstant _isSmallInteger) ifFalse: [ tok error: 'Expected a SmallInteger'].
          integralConstant.
        ] ifFalse: [
          integralConstant + 1.
        ].
        (header enums includesKey: identifier) ifTrue: [ token error: 'Duplicate enum definition!'].
        header enums at: identifier put: integralConstant.
        fields at: identifier put: integralConstant.
        self peek isCommaToken ifTrue: [self next].
        ].
  	].
%

category: 'declarator'
method: CDeclaration
readInitializer
	"Since we don't have a real expression parser, we will go till we reach
	a comma, semicolon, or close parenthesis not in a nesting"

	| token parenthesisCount curlyBracketCount |
	(token := self peek) ifNil: [^self].
	token value = '__attribute__' ifTrue: [
		self next.
		self readAttributes.
		^self readInitializer
	].
	token isEqualsToken ifFalse: [^self].
	self next.
	parenthesisCount := 0.
	curlyBracketCount := 0.
	[true] whileTrue: [ | pkk |
		(pkk := self peek) ifNil: [ token error:'next token is empty' ].
    token := pkk .
		(parenthesisCount == 0 and: [curlyBracketCount == 0]) ifTrue: [
			token isCommaToken ifTrue: [^self].
			token isSemicolonToken ifTrue: [^self].
			token isCloseParenthesisToken ifTrue: [^self].
		].
		token isOpenParenthesisToken ifTrue: [parenthesisCount := parenthesisCount + 1] ifFalse: [
		token isCloseParenthesisToken ifTrue: [parenthesisCount := parenthesisCount - 1] ifFalse: [
		token isOpenCurlyBracketToken ifTrue: [curlyBracketCount := curlyBracketCount + 1] ifFalse: [
		token isCloseCurlyBracketToken ifTrue: [curlyBracketCount := curlyBracketCount - 1]]]].
		self next.
	].
%

category: 'attributes'
method: CDeclaration
readModeAttributes
"
	http://tigcc.ticalc.org/doc/gnuexts.html#SEC91_mode
	http://www.linuxtopia.org/online_books/programming_tool_guides/linux_using_gnu_compiler_collection/vector-extensions.html
		QI = 8-bit integer, HI = 16-bit integer, SI = 32-bit integer, DI = 64-bit integer, SF = 32-bit float, DF = 64-bit float, TC = 128-bit complex
		byte = 8-bit integer, word = 64-bit integer, pointer = 64-bit integer

	typedef int int8_t __attribute__ ( ( __mode__ ( __QI__ ) ) ) ;
"
	| token mode |
	(token := self peek) isOpenParenthesisToken ifFalse: [ token error: 'expected ''('' '].
	self next.
	(token := self next) key == #'identifier' ifFalse: [token error: 'Expected an identifier'].
	mode := token value.
	type := 
		mode = '__QI__' ifTrue: [type first == $u ifTrue: [#'uint8'] ifFalse: [#'int8']] ifFalse: [
		mode = '__HI__' ifTrue: [type first == $u ifTrue: [#'uint16'] ifFalse: [#'int16']] ifFalse: [
		mode = '__SI__' ifTrue: [type first == $u ifTrue: [#'uint32'] ifFalse: [#'int32']] ifFalse: [
		mode = '__DI__' ifTrue: [type first == $u ifTrue: [#'uint64'] ifFalse: [#'int64']] ifFalse: [
		mode = '__byte__' ifTrue: [type first == $u ifTrue: [#'uint8'] ifFalse: [#'int8']] ifFalse: [
		mode = '__word__' ifTrue: [type first == $u ifTrue: [#'uint64'] ifFalse: [#'int64']] ifFalse: [
		mode = '__pointer__' ifTrue: [type first == $u ifTrue: [#'uint64'] ifFalse: [#'int64']] 
      ifFalse: [
		mode = '__TC__' ifTrue: [#'complexDouble'] ifFalse: [
		self error: 'unrecognized __mode__: ' , mode printString .
  ]]]]]]]].
	self expectCloseParenthesisCount: 3.
%

category: 'declarator'
method: CDeclaration
readParameterDeclarationList
  | token |
  self next.  "open parenthesis token"
  parameters := { } .
  self trapName .
  [
    (token := self peek ) isCloseParenthesisToken 
  ] whileFalse: [
    self peek isDotToken ifTrue: [
      self next.
      2 timesRepeat: [(token := self next) isDotToken ifFalse: [ token error:'expected ''.'' ']].
      isVaryingArgCount := true.
      (token := self peek) isCloseParenthesisToken ifFalse: [ token error:'expected '')'' '].
    ] ifFalse: [
      parameters add: (self cDeclarationSpecies header: header).
      (token := self peek) isCommaToken ifTrue: [self next].
    ].
  ].
  self next.  "close parenthesis token"
  (parameters size = 1 and: [parameters first isEmptyVoid]) ifTrue: [
    parameters := #().
  ].
  self mayHaveCode ifFalse:[ ^self].
  [
    (token := self peek) ifNil: [^self].
    token isSemicolonToken ifTrue: [^self].
    token isOpenCurlyBracketToken
  ] whileFalse: [
    self next.
  ].
  self next.
  self skipToEndOfCodeBlock.
%

category: 'declarator'
method: CDeclaration
readPointerOperator
	"Return a CDeclaration (might not be self)
	>>--*--+----------------+--><
	          '-typeQualifiers-' 
"
	| token |
	(token := self peek) ifNil: [^nil].
	token isStarToken ifFalse: [^nil].
	pointer := pointer + 1.
	(token := self next; peek) ifNil: [^self].
	token isIdentifierToken ifFalse: [^self].
	(#('const' 'volatile') includes: token value) ifFalse: [^self].
	self next.
	"we don't keep track of const pointers, only the data"
%

category: 'declarator'
method: CDeclaration
readPostlude

	| token1 token2 |
	token1 := self peek.
  token1 ifNil: [^self].
	token1 isIdentifierToken ifTrue: [
		(2 < token1 value size and: [(token1 value at: 1) == $_ and: [(token1 value at: 2) == $_]]) ifTrue: [
			(token2 := self next; peek) ifNil: [self next. ^self].	"Ignore trailing tokens beginning with double-underscore"
			token2 isOpenParenthesisToken ifTrue: [
				token1 value = '__attribute__' ifTrue: [
					self readAttributes.
				] ifFalse: [
					self skipFunction.
				].
			].
			^self readPostlude.
		].
		self error: 'unexpected token: ', token1 printString.
	].
	token1 isColonToken ifTrue: [
		self next. 
		self readBitFields. 
		^self readPostlude.
	].
	token1 isOpenCurlyBracketToken ifTrue: [
		((type isKindOf: CDeclaration) and: [type type == #class ]) ifTrue: [
			self skipToEndOfCodeBlock.
			^self.
		].
		self isFunction ifTrue: [		"Functions might have code (bugs #43426 & 43782)"
			self next.
			self skipToEndOfCodeBlock.
			^self
		].
	].
	token1 isEqualsToken ifTrue: [	"Check for an initialization"
		[
			(token2 := self next; peek) ~~ nil  and: [token2 isSemicolonToken].
		] whileFalse.
		^self
	].
%

category: 'type'
method: CDeclaration
readStorageClassSpecifier
	"Return a CDeclaration (might not be self)
	( 'auto' | 'extern' | 'register' | 'static' | 'typedef' | 'inline' )
"
	| token value |
	(token := self peek) ifNil: [^nil].
	token isTildeToken ifTrue: [token := self next; peek].	"indicates a class destructor function, which we can ignore"
	[token isExtensionIdentifierToken] whileTrue: [token := self next; peek].	"safe to ignore"
	token  isIdentifierToken ifFalse: [^nil].
	token value = 'inline' ifTrue: [
		self next.
		storage := #'inline'.
		^self.
	].
	(#('auto' 'extern' 'register' 'static' 'typedef') includes: token value) ifTrue: [
		(storage ~~ nil  and: [storage ~= token value asSymbol])
			ifTrue: [ token error: 'We support only one storage specifier'].
		storage := self next value asSymbol.
		(token := self peek) ifNil: [^nil].
		value := token value.
		(storage = #'extern' and: [token type = #'string']) ifTrue: [
			linkageSpec := value.
			(token := self next; peek) isOpenCurlyBracketToken
				ifTrue: [type := nil].
		].
		^self.
	].
	^nil.
%

category: 'type'
method: CDeclaration
readType
	"Return a CDeclaration (might not be self)
"
	| declaration |
	declaration := self readTypeA.
	storage ifNil: [storage := #auto ].
	self interpretTypeSpecifier.
	^self.
%

category: 'type'
method: CDeclaration
readTypeA
	"Return a CDeclaration (might not be self)
	        .-----------------------------.  
	        V                                 |
	>>---+----------------------------+--><
           +--storageClassSpecifier--+			( 'auto' | 'extern' | 'register' | 'static' | 'typedef' | 'inline' )
           +--typeSpecifier-----------+			( 'void' | 'char' | 'short' | 'int' | 'long' | 'float' | 'double' | ... )
           '--typeQualifier-------------'				( 'const' | 'volatile' )
"
	| declaration token |
	(token := self peek) isAttributeIdentifierToken ifTrue: [self next; readAttributes. ^self readTypeA].
	(declaration := self readStorageClassSpecifier) ifNotNil: [^declaration readTypeA].
	(declaration := self readTypeSpecifier) ifNotNil: [^declaration readTypeA].
	(declaration := self readTypeQualifier) ifNotNil: [^declaration readTypeA].
	^self.
%

category: 'type'
method: CDeclaration
readTypeFrom: aHeader
	"Return a CDeclaration (might not be self)"

	header := aHeader.
	[self peek isEmptyToken] whileTrue: [self next].
	type := { } .
	pointer := 0.
	isConstant := false.
	includesCode := false.
	isVaryingArgCount := false.
	^self readType.
%

category: 'type'
method: CDeclaration
readTypeQualifier
 	"Return a CDeclaration (might not be self)
	( 'const' | 'volatile' )
"
	| token value |
	(token := self peek) 	ifNil: [^nil].
	token isIdentifierToken 	ifFalse: [^nil].
	value := token value.
	value = 'const' 	ifTrue: [self next. isConstant := true. ^self].
	value = 'volatile' 	ifTrue: [self next. ^self].
	^nil.
%

category: 'type'
method: CDeclaration
readTypeSpecifier
 	"Return a CDeclaration (might not be self)
		( 'void' | 'char' | 'bool' | 'short' | 'int' | 'long' | 'float' | 'double' | 'signed' | 'unsigned' 
       | '_Complex' | struct_or_union_spec | enum_spec | typedef_name )
	"
	| token value declaration |
	(token := self peek) ifNil: [^nil].
	token isIdentifierToken ifFalse: [^nil].
	value := token value.
	( #('void' 'char' 'bool' 'short' 'int' 'long' 'float' 'double' 'signed' 'unsigned') 
        includes: value) ifTrue: [
		type add: value asSymbol.
		self next.
		^ self.
	].
	value = '__float128'	ifTrue: [type := #'float128'.		self next. ^self].
	value = '_Complex'	ifTrue: [type add: #'complex'.	self next. ^self].		"this means that there are two of something else (e.g., double)"
	value = 'ptr'			ifTrue: [type := #ptr.				self next. ^self].
	value = 'enum'			ifTrue: [type := #'enum'.			self next. self readEnumeration. 	^self].
	value = 'struct'		ifTrue: [type := #struct .			self next. self readComplexType. ^self].
	value = 'union' 		ifTrue: [type := #union .			self next. self readComplexType. ^self].
	value = 'class' 		ifTrue: [type := #class .			self next. storage := #typedef .	^self].
	type = #() ifTrue: [
		declaration :=
			header types at: value ifAbsent: [
			header structs at: value ifAbsent: [
			header unions at: value ifAbsent: [
			header enums at: value ifAbsent: [nil]]]].
		declaration ifNotNil:[ 
      type := declaration derivedType. 
      type == declaration ifFalse:[ pointer := declaration pointer ].  "fix 48748"
      self next. 
      ^self
    ].
	].
	"These are a bit troubling. Sometimes the are expected to be built-in, and other times they are typedefs!"
	(value = '__builtin_va_list' 	and: [type = #()])	ifTrue: [type := #ptr . 		self next. ^self].
	(value = '__gnuc_va_list' 	and: [type = #()])	ifTrue: [type := #ptr . 		self next. ^self].
	^nil.
%

category: 'CCallout'
method: CDeclaration
resultType
	self isFunction ifFalse: [ self error: 'Not a function!'].
  ^ self _resultType .
%

category: 'other'
method: CDeclaration
setClassProperties: anArray

	fields := anArray.
%

category: 'Updating'
method: CDeclaration
setStorage: aSymbol type: aCDeclaration

	storage := aSymbol.
	type := aCDeclaration.
%

category: 'CByteArray get'
method: CDeclaration
simpleAccessorForOffset: anInteger
  | str x ofsStr |
  ofsStr := anInteger asString .
  (str := String new)
		add: name; lf; tab;
    add: '   "generated by CDeclaration>>simpleAccessorForOffset: ', ofsStr , ' "';
      lf;tab.
  x  := self _getFieldSelector .
  x _isOneByteString ifTrue:[ 
		str add: '^ self ', x ,' ', ofsStr , ' . '; lf .
  ] ifFalse:[ | typ siz |
    "A field that is a struct, or a large union"
    typ := x at: 1 .  
    typ == #ptr ifTrue:[ 
       self _arrayInfoForSelector ifNotNil:[:ax | typ := ax ].
    ].
    siz := x at: 2 .
    str add: '" type  ', typ printString ,' ,  size ', siz asString, ' "'; lf; tab ;
       add: '^ CByteArray fromRegionOf: self offset: ', ofsStr ,
          ' numBytes: ', siz asString ,' . ' ; lf . 
  ].
  ^ str 
%

category: 'CByteArray put'
method: CDeclaration
simpleUpdatorForOffset: anInteger
 | str x ofsStr |
 ofsStr := anInteger asString .
  (str := String new)
    add: name , ': anObject'; lf; tab;
    add: '   "generated by CDeclaration>>simpleUpdatorForOffset: ', ofsStr , ' "'; 
      lf;tab.
  x  := self _getFieldSelector .
  x _isOneByteString ifTrue:[  
		str add:' self ',  x, ' ', ofsStr , ' put: anObject .'; lf  .
  ] ifFalse:[ | typ siz |
    "A field that is a struct, or a large union"
    typ := x at: 1 .
    siz := x at: 2 .
    str add: '" type  ', typ printString ,' size ', siz asString, ' "'; lf; tab ;
     add:' self copyBytesFrom: anObject"aCByteArray" from: 1 to: ', siz asString,
        '  into: ', ofsStr , ' allowCodePointZero: true .' ; lf .
  ].
  ^ str
%

category: 'CByteArray get'
method: CDeclaration
singlePointerAccessorForOffset: anInteger

	^(AppendStream on: String new)
		nextPutAll: name; lf; tab;
    nextPutAll: '   "generated by CDeclaration>>singlePointerAccessorForOffset:"'; lf;tab; 
		nextPutAll: '^self'; lf; tab; tab;
		nextPutAll: 'pointerAt: ';
		nextPutAll: anInteger printString; lf; tab; tab;
		nextPutAll: 'resultClass: ';
		nextPutAll: header cByteArraySpecies name asString;
		nextPut: $. ; lf;
		contents.
%

category: 'CByteArray put'
method: CDeclaration
singlePointerUpdatorForOffset: anInteger
  
	^(AppendStream on: String new)
		nextPut: name; 
		nextPut: ': aCByteArray'; lf; tab;
    nextPut: '   "generated by CDeclaration>>singlePointerUpdatorForOffset:"'; lf;tab; 
		nextPut: 'self'; lf; tab; tab;
		nextPut: 'pointerAt: ';
		nextPut: anInteger printString; lf; tab; tab;
		nextPut: 'put: aCByteArray.'; lf; tab; tab ;
		nextPut: 'self derivedFrom: aCByteArray.'; lf;
		contents.
%

category: 'other'
method: CDeclaration
skipFunction

	| parenthesisCount |
	parenthesisCount := 1.
	self next.
	[
		0 < parenthesisCount.
	] whileTrue: [
		| token |
		token := self next.
		token isCloseParenthesisToken ifTrue: [parenthesisCount := parenthesisCount - 1] ifFalse: [
		(token isIdentifierToken and: [token value last == $(]) ifTrue: [parenthesisCount := parenthesisCount + 1] ifFalse: [
		token isOpenParenthesisToken ifTrue: [parenthesisCount := parenthesisCount + 1]]].
	].
%

category: 'declarator'
method: CDeclaration
skipToEndOfCodeBlock

	| depth |
	includesCode := true.
	depth := 1.
	[
		0 < depth.
	] whileTrue: [
		| token |
		token := self next.
		token isOpenCurlyBracketToken ifTrue: [depth := depth + 1].
		token isCloseCurlyBracketToken ifTrue: [depth := depth - 1].
	].
%

category: 'accessors'
method: CDeclaration
source
	^ source
%

category: 'Updating'
method: CDeclaration
source: aString

	source ifNotNil: [^self].
	source := aString.
	(type isKindOf: CDeclaration) ifTrue: [type source: aString].
	fields ifNotNil: [
		type ~~ #'enum' ifTrue: [
			fields do: [:each | 
				each source ifNil: [
					each source: aString.
				].
			].
		].
	].
	parameters ifNotNil: [
		parameters do: [:each | 
			each source ifNil: [
				each source: aString.
			].
		].
	].
%

category: 'CByteArray get'
method: CDeclaration
sourceStringsForAccessors

	| list |
	list := { } .
  "cannot simply sum the sizes of the fields due to padding"
  (self _baseByteSize atOrNil: 3) ifNotNil:[ :offsets | 
    1 to: fields size do:[:j | | each |
      each := fields at: j .
		  list add: (each accessorForOffset: (offsets at: j)) .
	  ].
  ].
	^list.
%

category: 'CByteArray put'
method: CDeclaration
sourceStringsForUpdators
	| list |
	list := { } .
  "cannot simply sum the sizes of the fields due to padding"
  (self _baseByteSize atOrNil: 3) ifNotNil:[ :offsets | 
    1 to: fields size do:[:j | | each |
      each := fields at: j .
		  list add: (each updatorForOffset: (offsets at: j)) .
    ].
	].
	^list.
%

category: 'accessors'
method: CDeclaration
storage

	^storage.
%

category: 'Updating'
method: CDeclaration
storage: aSymbol linkageSpec: optionalString

	storage := aSymbol.
	linkageSpec := optionalString.
%

category: 'other'
method: CDeclaration
stream

	^header stream.
%

category: 'CByteArray get'
method: CDeclaration
stringAccessorForOffset: anInteger

	^(AppendStream on: String new)
		nextPutAll: name; lf; tab;
    nextPutAll: '   "generated by CDeclaration>>stringAccessorForOffset:"'; lf;tab; 
		nextPutAll: '^self _stringFromBytes: (self '; lf; tab; tab;
		nextPutAll: 'byteArrayFrom: ';
		nextPutAll: anInteger printString; lf; tab; tab;
		nextPutAll: 'to: ';
		nextPutAll: (anInteger + count first - 1) printString;
		nextPutAll: ').'; lf;
		contents.
%

category: 'CByteArray get'
method: CDeclaration
stringPointerAccessorForOffset: anInteger

	1 == count ifTrue: [
		^(AppendStream on: String new)
			nextPutAll: name; lf; tab;
      nextPutAll: '   "generated by CDeclaration>>stringPointerAccessorForOffset:"'; lf;tab; 
			nextPutAll: '^self stringFromCharStarAt: ';
			nextPutAll: anInteger printString; 
			nextPut: $.; lf; tab;
			nextPutAll: '"^self'; lf; tab; tab;
			nextPutAll: 'pointerAt: ';
			nextPutAll: anInteger printString; lf; tab; tab;
			nextPutAll: 'resultClass: ';
			nextPutAll: header cByteArraySpecies name asString;
			nextPutAll: '."'; lf;
			contents.
	] ifFalse: [
		^(AppendStream on: String new)
			nextPutAll: name; lf; tab;
			nextPutAll: '| array offset | "generated by CDeclaration>>stringPointerAccessorForOffset:"'; lf;tab; 
			nextPutAll: 'array := Array new: ';
			nextPutAll: count first printString;
			nextPut: $.; lf; tab;
			nextPutAll: 'offset := ';
			nextPutAll: anInteger printString;
			nextPut: $.; lf; tab;
			nextPutAll: '1 to: array size do: [:i | '; lf; tab; tab;
			nextPutAll: 'array at: i put: (self stringFromCharStarAt: offset).'; lf; tab; tab;
			nextPutAll: '"array at: i put: (self pointerAt: offset resultClass: ';
			nextPutAll: header cByteArraySpecies name asString;
			nextPutAll: ')."'; lf; tab; tab;
			nextPutAll: 'offset := offset + 8.'; lf; tab;
			nextPutAll: '].'; lf; tab;
			nextPutAll: '^array.'; lf;
			contents.
	].
%

category: 'CByteArray put'
method: CDeclaration
stringPointerUpdatorForOffset: anInteger

	1 == count ifTrue: [
		^(AppendStream on: String new)
			nextPut: name;
			nextPut: ': aCByteArray'; lf; tab;
      nextPutAll: '   "generated by CDeclaration>>stringPointerUpdatorForOffset:"'; lf;tab; 
			nextPut: '"self'; lf; tab; tab;
			nextPut: 'pointerAt: ';
			nextPut: anInteger printString; lf; tab; tab;
			nextPut: 'put: aCByteArray."'; lf; tab ; tab ;
		  nextPut: 'self derivedFrom: aCByteArray.'; lf;
			contents.
	] ifFalse: [
		^self arrayPointersUpdatorForOffset: anInteger.
	].
%

category: 'CByteArray put'
method: CDeclaration
stringUpdatorForOffset: anInteger
  | str |
  str := String new .
	str add: name, ': aCByteArray '; lf; tab;
    add: '   "generated by CDeclaration>>stringUpdatorForOffset:"'; lf; tab; 
		add: 'self copyBytesFrom: aCByteArray from: 1'; lf; tab;  
    add:'   to: (aCByteArray size min: ', count first asString,')'; lf; tab;
    add: '  into: ', anInteger asString, ' allowCodePointZero: true '; lf . 
  ^ str
%

category: 'CByteArray get'
method: CDeclaration
structAccessorForOffset: anInteger
	^(AppendStream on: String new)
		nextPutAll: name; lf; tab;
    nextPutAll: '   "generated by CDeclaration>>structAccessorForOffset:"'; lf;tab; 
		nextPutAll: '^self'; lf; tab; tab;
		nextPutAll: 'newFrom: ';
		nextPutAll: anInteger printString; lf; tab; tab;
		nextPutAll: 'numBytes: ';
		nextPutAll: self baseByteSize printString;
		nextPut: $.; lf;
		contents.
%

category: 'CByteArray put'
method: CDeclaration
structUpdatorForOffset: anInteger
  | str |
  str := String new .
  str add: name, ': aCByteArray'; lf ; tab ;
    add: '   "generated by CDeclaration>>structUpdatorForOffset:"'; lf;tab; 
		add: 'self copyBytesFrom: aCByteArray from: 1 '; lf ; tab;
    add:'   to: (aCByteArray size min: ', self baseByteSize asString,')' ; lf; tab;
    add: '  into: ', anInteger asString, ' allowCodePointZero: true '; lf . 
  ^ str
%

category: 'Debugging'
method: CDeclaration
trapFile
  "uncomment this and senders for debugging
    file ifNotNil:[:f |
      (f includesString:'t.hf') ifTrue:[ self  pause ].
    ].
  "
%

category: 'Debugging'
method: CDeclaration
trapLine
  "uncomment and edit here 
   and uncomment  refs to #TraceCpp in CHeader and CPreprocessorToken to enable tracing .
   Tracing works in conjunction with   CHeader >> addToSource: ,  CPreprocessorToken >> addToSource:
   TraceCpp values:  2 = pause at each addToSource:,  1 = just gciLogServer: of each addToSource:
   "
" file ifNotNil:[:f | | aLine |
    aLine := line .
    (f includesString:'gcits.hf') ifTrue:[ 
       line = 31 ifTrue:[ 
         SessionTemps current at: #TraceCpp put: 2 .
         self  pause .
       ].
    ]. 
  ]
 "
%

category: 'Debugging'
method: CDeclaration
trapName
  "uncomment this and senders for debugging  , example:
  name ifNotNil:[  
    (name at: 1 equals: 'GciErr') ifTrue:[ 
      GsFile gciLogServer: 'oop ', self asOop asString, ' name ' , name asString .
      self  pause 
    ]
  ].
 "
%

category: 'accessors'
method: CDeclaration
type
	"For many types, the value is a Symbol (e.g., #'uint64' or #struct).
	For other types, the value is a CDeclaration for a function or a class"

	^type.
%

category: 'CByteArray put'
method: CDeclaration
updatorForOffset: anInteger

	0 == pointer ifTrue: [ | typ |
    (typ := type) _isSymbol ifFalse:[ typ := type argumentType ].
		(typ == #class or:[ typ == #struct]) ifTrue:[ ^ self structUpdatorForOffset: anInteger].
		count == nil ifTrue:[ ^ self simpleUpdatorForOffset: anInteger].
		1 < count size ifTrue:[ self error: 'Multi-dimensional arrays not supported!'].
		type == #'uint8' ifTrue:[ ^self stringUpdatorForOffset: anInteger].
		^self arrayUpdatorForOffset: anInteger.
	].
	1 < pointer ifTrue: [self error: 'Multi-level pointers not supported!'].
	count == nil ifTrue: [^self singlePointerUpdatorForOffset: anInteger].
	type == #'uint8' ifTrue: [^self stringPointerUpdatorForOffset: anInteger].
	^self arrayPointersUpdatorForOffset: anInteger.
%

category: 'Private'
method: CDeclaration
usesStructs
  self isFunction ifFalse:[ Error signal:'not a function' ].
  parameters do:[:x | x argumentType == #struct ifTrue:[ ^ true]].
  self resultType == #struct ifTrue:[ ^ true ] .
  ^ false
%

category: 'CCallout'
method: CDeclaration
varArgsAfter
	^ isVaryingArgCount ifTrue: [parameters size] ifFalse: [-1].
%

category: 'Reporting'
method: CDeclaration
_addToReport: rpt
  | brace |
  (name ~~ nil ) ifTrue:[ rpt add: (brace := '{') ].
  name ifNotNil:[:n | rpt add: n ; add: ' ' ; add: self byteSize asString ; add: ' '].
  fields ifNotNil:[:f | f do:[ :aField | aField _addToReport: rpt ]].
  (pointer = 0 and:[ type isKindOf: CDeclaration]) ifTrue:[ type _addToReport: rpt ].
  brace ifNotNil:[ rpt add:'}' . ]
%

category: 'Private'
method: CDeclaration
_argName: idx
  | n | 
  n :=  name ifNil:[ 'arg' , idx asString].
  n = 'self' ifTrue:[ n := 'selfArg' ].
  ^ n
%

category: 'Private'
method: CDeclaration
_arrayInfoForSelector
  type isSymbol ifFalse:[ ^ type __arrayInfoForSelector ].
  ^ self __arrayInfoForSelector
%

category: 'size'
method: CDeclaration
_baseByteSize
  "Returns an Array { size . alignment } or
                    { size . alignment . fieldOffsets } "
	0 < pointer ifTrue: [^ #( 8 8 ) ].
	bitCount ifNotNil: [  | nBytes align |
    "Only  bit fields of base type  int   are supported."
	  (type == #'int32' or: [type == #'uint32']) ifTrue:[ nBytes := 4].
	  "(type == #'int8' or: [type == #'uint8']) ifTrue:[ nBytes := 1 ].
	   (type == #'int16' or: [type == #'uint16']) ifTrue:[ nBytes := 2].
	   (type == #'int64' or: [type == #'uint64']) ifTrue:[ nBytes := 8 ].
    "
    nBytes ifNil:[self error:'Invalid type for a bit field' ].
    bitCount > (align := nBytes*8) ifTrue:[self error:'bit field too big'].
    ^ { bitCount / 8 . nBytes }.
  ].
	(type == #'int8' or: [type == #'uint8']) ifTrue:[ ^ #( 1 1 )].
	(type == #'int16' or: [type == #'uint16']) ifTrue:[^ #( 2 2 )].
	(type == #'int32' or: [type == #'uint32']) ifTrue:[^ #( 4 4 )].
	(type == #'int64' or: [type == #'uint64']) ifTrue:[^ #( 8 8 )].
	(type == #void and: [0 < pointer]) ifTrue:[^ #( 8 8 )].
	type == #class ifTrue:[ ^self _baseStructByteSize].
	type == #struct ifTrue:[ ^self _baseStructByteSize].

	type == #union ifTrue:[ ^self _baseUnionByteSize].
	type == #'enum' ifTrue:[ ^ #( 4 4 )].
	type == #'function' ifTrue:[ ^ #( 8 8 )].
	type == #double ifTrue:[ ^ #( 8 8 )].
	(type isKindOf: CDeclaration) ifTrue:[ ^ type _baseByteSize].

  self error:'in _baseByteSize, unknown type ', type printString	.
  ^ nil .
%

category: 'size'
method: CDeclaration
_baseStructByteSize
  "Returns an Array { size . alignment . { fieldOffset ... fieldOffset} } 
   With alignment of fields and pads like a C compiler would.  "
	| total align rem offsets totalBits theFields bitsAlign |
  (storage == #typedef and:[ fields == nil and:[ self isStruct]]) ifTrue:[
    ^ type _baseStructByteSize .
  ].
  (type == #struct and:[ fields == nil  and:[ pointer == 0]]) ifTrue:[
     self error:'Incomplete struct definition (typedef with no fields defined)'.
  ].
	total := 0.
  align := 1 .
  offsets := { } .
  bitsAlign := 0 .
  totalBits := 0 .
  (theFields := fields copy ) add: nil .
	theFields do: [:each | | arr fieldSize fieldAlign pad fRem aSize aAlign |
     each ifNotNil:[
       arr := each _byteSize . 
       aSize := arr at: 1 .
       aAlign := arr at: 2 .
     ] ifNil:[
       aSize := 0 .
       aAlign := 1 .
     ].
     aSize < aAlign ifTrue:[  "a bitfield, or close out last bitfield"
       aSize > 0 ifTrue:[  "a bitfield" | nBits |
         each bitCount ifNil:[ self error:'Inconsistent bitfield'].
         nBits := aSize * 8  .
         totalBits == 0 ifTrue:[ "first bitfield after non-bitfield"
           bitsAlign := aAlign .
           totalBits := nBits.
           fieldSize := 0 .
         ] ifFalse:[    "accumulate another bitfield"
           (totalBits + nBits) <= (bitsAlign*8) ifTrue:[ "more bits in the word"
             totalBits := totalBits + nBits .
             fieldSize := 0 .
           ] ifFalse:[
             fieldSize := totalBits // 8 .  "word of bitfield is full"
             (totalBits \\ 8) ~~ 0 ifTrue:[ fieldSize := fieldSize + 1 ].
             fieldSize <= 0 ifTrue:[ self error:'inconsistent bitifield'].
             fieldAlign := bitsAlign .
             totalBits := nBits . "start accumulating next word of bits"
             bitsAlign := fieldAlign .
           ]
         ].
       ] ifFalse:[ "close out last bitfield if any"
         fieldSize := 0 .
         totalBits > 0 ifTrue:[
           fieldSize := totalBits // 8 . 
           (totalBits \\ 8) ~~ 0 ifTrue:[ fieldSize := fieldSize + 1 ].
           fieldAlign := bitsAlign .
         ].
       ]
     ] ifFalse:[
       fieldSize := aSize . "normal field"
       fieldAlign := aAlign .
     ] .
     fieldSize > 0 ifTrue:[ 
       pad := 0 .
       (fRem := total \\ fieldAlign) ~~ 0 ifTrue:[ 
          pad := fieldAlign - fRem . "pad in front of this element per its required alignment"
       ].
       total := total + pad .
       offsets add: total .
       total := total + fieldSize .
       fieldAlign > align ifTrue:[ 
         fieldAlign > 8 ifTrue:[ self error:'alignment exceeds 8'].
         align := fieldAlign .
       ].
     ].
	].
  (rem := total \\ align) ~~ 0 ifTrue:[ 
     total := total + (align - rem "pad at end, per largest align of any element").
  ].
	^ { total . align . offsets }
%

category: 'size'
method: CDeclaration
_baseUnionByteSize
  "Returns an Array { size . alignment } 
   With alignment of fields and end pad like a C compiler would.  "
  | total align |
  total := 0 . 
  align := 1 .
	fields do:[ : each | | arr |
    arr := each _baseByteSize .
    total := total max: (arr at: 1"size") .
    align := align max: (arr at: 2"alignment").
  ].
  align > 8 ifTrue:[ self error:'alignment exceeds 8'].
  ^ { total . align }
%

category: 'size'
method: CDeclaration
_byteSize
  "returns an Array { size . alignment } or
                    { size . alignment . fieldOffsets}   "
	| arr sz |
	arr := self _baseByteSize .
	count ifNil:[ ^ arr ].
  sz := arr at: 1 .
	count do: [:y | sz := sz * y].
  arr isInvariant ifTrue:[ arr := arr copy ].
	arr at: 1 put: sz .
  ^ arr .
%

category: 'Private'
method: CDeclaration
_cpuKind
  | cpu |
  cpu := System gemVersionAt: #cpuArchitecture .
  cpu = 'x86-64' ifTrue:[ ^ #'x86-64' ].
  cpu = 'aarch64' ifTrue:[ ^ #arm64 ] . "Linux Arm"
  cpu = 'arm64' ifTrue:[ ^ #arm64 ] . "Darwin Arm"
  Error signal:'Unsupported CPU kind ', cpu asString .
%

category: 'CCallout'
method: CDeclaration
_createFunctionInitializerCodeStructs
  ^ self _functionSourcesStructs at: 2 .
%

category: 'accessors'
method: CDeclaration
_fields

	^fields.
%

category: 'Private'
method: CDeclaration
_functionSourcesStructs
  "returns an Array  {  ffiCallMethodSource  . calloutInitializerSource . resultStructSize }"
  | cpu strm resStructSize initSrc resTyp structSizes |
  cpu := self _cpuKind .
  (cpu == #'x86-64' or:[ cpu == #arm64]) ifFalse:[
     Error signal:'CCallout with structs not supported on CPU kind ', cpu asString.
  ].
  resStructSize := 0 .  
  structSizes := { nil } .
  (resTyp := self resultType) == #struct ifTrue:[
     resStructSize := type byteSize .
     resStructSize <= 0 ifTrue:[ self error:'inconsistent result struct size'].
     resStructSize > 8192"Capi_MAX_STRUCT_RESULT" ifTrue:[ 
       self error:'result struct size ', resStructSize asString,' exceeds max of 8192'.
     ].
     resStructSize := resStructSize max: 8 . "minimum C memory size of a result struct is 8"
     structSizes at: 1 put: resStructSize .
  ].
	(resTyp == #double or:[ resTyp == #float]) ifTrue:[
     self error:'structs not supported in combination with floats'.
  ].
	(strm := AppendStream on: String new)
		nextPut: name .  "start of selector for the method"
  resStructSize > 0 ifTrue:[
    strm nextPut: '_: result"struct',resStructSize asString, 'bytes" '.
  ].
	1 to: parameters size do: [:j| | each |  
    each := parameters at: j.
		strm nextPut: '_: ', (each _argName: j) .
    each isStruct ifTrue:[  | sz |
      sz := each byteSize .
      (sz <= 16 and:[ each containsFloat]) ifTrue:[
        self error:'float or double not supported within small struct argument'.
      ].
      strm nextPut:'"struct', sz asString, 'bytes"'  .
      structSizes add: (sz max: 8)  .
    ] ifFalse:[ 
      each containsFloat ifTrue:[ self error:'structs not supported in combination with floats'].
      structSizes add: nil.
    ].
	  strm nextPut:' ' .
	].                   
  isVaryingArgCount ifTrue:[ strm lf ; tab ; nextPut:' varArgs: vaArray "pairs of type, arg"'].
  strm lf .
  "end of selector"
	self addSourceTo: strm.  "add comments - the C function prototype"
	strm tab; 
		nextPut: '"Interpreted as #', self resultType, ' from #(' .
	parameters do: [:each | strm space. each argumentType printOn: strm ].
  isVaryingArgCount ifTrue:[ strm nextPut:'  ...varArgs '].
	strm nextPut: ' )" '; lf ; tab ;  "end of Interpretd as comment"
       nextPut: '| res args | '; lf ; tab .

  (initSrc := String new) 
    add: self initializerFunctionName , ' cLibrary' ; lf ;
    add: '  ', self asClassVarName, ' := CCalloutStructs library: cLibrary name: ''', name ,$'; lf;
    add: '  result: ' ;
    add:(resStructSize > 0 ifTrue:[ ' #struct ' ] ifFalse:[ self resultType printString]) ; lf .
  
  resStructSize > 0 ifTrue:[ strm nextPut:' res := result"resultStruct".' ; lf ].
  strm nextPut:'  args := { ' .         "begin building array of args"
  initSrc add:'  args: #( ' .

  parameters size > 0 ifTrue:[
	  1 to: parameters size do:[:j| | parm nam | 
      parm := parameters at: j .
      nam := parm _argName: j .
      strm nextPut: ' ', nam, ' .' .
      initSrc add: ' ', parm argumentType printString,'"',nam,'" ' .
	  ].
    self _removeLastDot: strm collection  .
  ].
	strm nextPut: ' } .'; lf;tab .  
  initSrc add: '   )' ; lf;tab .  "end args array"
	isVaryingArgCount ifTrue:[
    strm nextPut: 'vaArray ifNotNil:[ args addAll: vaArray ].'; lf; tab .
    initSrc add: ' varArgsAfter: ', parameters size asString ; lf; tab .
  ] ifFalse:[
    initSrc add: ' varArgsAfter: -1 ' ; lf ; tab.
  ].
  initSrc add:' structSizes: #( ' .
  structSizes do:[:x | initSrc add: x asString ,' ' ].
  initSrc add:' ). '; lf . 
  resStructSize == 0 ifTrue:[
    strm nextPut:'res := ' .  "nil is passed to structResult: keyword"
  ].
  strm nextPut: self asClassVarName, ' callWith: args structResult: res errno: nil.'; lf;tab;
    nextPut:' ^ res . ' ; lf .
  ^ { strm  contents . initSrc }
%

category: 'CByteArray get'
method: CDeclaration
_getFieldSelector
  "Returns a String if self is a scalar field of size <= 8, 
  otherwise returns an Array of the form  {  typeSymbol .  fieldSize }"
  | arr typ |
  arr := self _typeForSelector .
  typ := arr at: 1 .
	(#(
		#int8 #int16 #int32 #int64
		#uint8 #uint16 #uint32 #uint64
	) includesIdentical: typ) ifTrue:[ ^ typ , 'At:'].
	typ == #'enum' ifTrue: [ ^ #int32At: ].
	typ == #'function' ifTrue: [ ^ #uint64At: ].
  typ == #union ifTrue:[ | sz |
    sz := arr at: 2 .
    sz <= 8 ifTrue:[
      sz == 8 ifTrue:[ ^ #uint64At: ].
      ^ #uint32At: .
    ].
    ^ arr "a large union"
  ].
  (typ == #struct or:[ typ == #ptr ])
     ifFalse:[ self error:'in getSelector, unknown type ', type printString].

  ^ arr 
%

category: 'CCallout'
method: CDeclaration
_invokeFunctionCodeStructs
  ^ self _functionSourcesStructs at: 1 .
%

category: 'other'
method: CDeclaration
_next
	| next |
	(next := header next) ifNil: [^nil].
	file ifNil: [
		file := next file.
		line := next line. 
    self trapLine .
	].
	^next.
%

category: 'Private'
method: CDeclaration
_removeLastDot: aString
  | idx |
  idx := aString indexOfLastByte: $. codePoint startingAt: aString size .
  idx ~~ 0 ifTrue:[ 
    aString removeFrom: idx to: idx  .
  ].
%

category: 'Private'
method: CDeclaration
_resultType
	(self isSimple and: [self knownResultTypes includesIdentical: type]) ifTrue: [^type].
	type == #'enum' ifTrue: [^#'int32'].
	type == #'uint8' ifTrue: [
		(count size == 1 and: [pointer == 0]) ifTrue: [^#'char*'].		"const char foo[]"
		(count == nil and: [pointer == 1]) ifTrue: [^#'char*'].			"const char * foo"
	].
  self isStruct ifTrue:[ ^ #struct ].
  (pointer > 0 or:[ count ~~ nil]) ifTrue:[ ^ #ptr ].
  type _isSymbol ifFalse:[ ^ type _resultType ] . "a typedef or similar"
  ^ #ptr .
%

category: 'Private'
method: CDeclaration
_typeForSelector
  "Returns an Array of the form  {  typeSymbol .  fieldSize }"
  type _isSymbol ifFalse:[ ^ type _typeForSelector ].
  type == #union ifTrue:[ ^ { type . self _byteSize at: 1 } ].
  ^ { self argumentType . self _byteSize at: 1 }
%

category: 'Private'
method: CDeclaration
__arrayInfoForSelector
  | numElem siz baseSiz |
  (type isSymbol and:[ pointer == 0 and:[ count ~~ nil]]) ifTrue:[
    siz := self _byteSize . 
    baseSiz := self _baseByteSize .
    numElem := (siz at: 1) // (baseSiz at: 1) .
    ^ '/*Array*/ ', type asString,' x[', numElem asString,']  ' .
  ] .
  ^ nil 
%

! Class implementation for 'CHeader'

!		Class methods for 'CHeader'

category: 'Class Membership'
classmethod: CHeader
cPreprocessorSpecies
"Answer the class to be used for CPreprocessor objects. Subclasses may
 overload this method as needed."
^ CPreprocessor
%

category: 'other'
classmethod: CHeader
fetchGciLinkedLibraryName

"Answer a String containing a path to the linked GCI shared library
 in a GemStone product tree, relative to the value of the GEMSTONE
 environment variable."

| result |
result := String withAll: '$GEMSTONE/lib/' .
result addAll: System fetchLinkedGciLibraryName .
^ result
%

category: 'other'
classmethod: CHeader
fetchGciRpcLibraryName

"Answer a String containing a path to the 64-bit RPC GCI shared library
 in a GemStone product tree, relative to the value of the GEMSTONE
 environment variable."

| result |
result := String withAll: '$GEMSTONE/lib/' .
result addAll: System fetchRpcGciLibraryName .
^ result
%

category: 'other'
classmethod: CHeader
path: aString
  ^ self path: aString searchPaths: { }
%

category: 'other'
classmethod: CHeader
path: aString searchPath: searchPath
	"Parse the given file path aString, searching the absolute path searchPath before the system include directories.
	Example:
	CHeader path: 'openssl/ssl.h' searchPath: '/home/me/where/i/put/private/builds/include/'.
	This will find /home/me/where/i/put/private/builds/include/openssl/ssl.h, and includes within
	that file of the form
	#include <openssl/someFile.h>
	will be found in /home/me/where/i/put/private/builds/include/openssl."

	^self path: aString searchPaths: {searchPath}
%

category: 'other'
classmethod: CHeader
path: aString searchPaths: anArray
	"Parse the given file path aString, searching the absolute paths in anArray before the system include directories.
	Example:
	CHeader path: 'openssl/ssl.h' searchPaths: #('/home/me/where/i/put/private/builds/include/').
	This will find /home/me/where/i/put/private/builds/include/openssl/ssl.h, and includes within
	that file of the form
	#include <openssl/someFile.h>
	will be found in /home/me/where/i/put/private/builds/include/openssl."

	| preprocessor fullPath |
	preprocessor := self cPreprocessorSpecies new.
	anArray reverseDo: [:path | preprocessor insertSearchPath: path].
	fullPath := preprocessor searchForInclude: aString excluding: nil.
	fullPath
		ifNil: [^UserDefinedError signal: 'Include file ' , aString , ' not found!'].
	preprocessor includePath: fullPath.
	^self preprocessor: preprocessor
%

category: 'other'
classmethod: CHeader
preprocessor: aCPreprocessor

	^self new
		initialize: aCPreprocessor;
		yourself.
%

category: 'other'
classmethod: CHeader
string: aString
	^ self preprocessor: (self cPreprocessorSpecies parseString: aString).
%

category: 'other'
classmethod: CHeader
string: aString ignoreWarnings: aBoolean
	^ self preprocessor: (self cPreprocessorSpecies parseString: aString ignoreWarnings: aBoolean).
%

category: 'Reporting'
classmethod: CHeader
_gciStructReport
^ self _gciStructsReport: '$GEMSTONE/include/gci.hf' for:
  {  "gcilegacy.ht" 'GciObjInfoSType' . 'GciFetchObjInfoArgsSType' . 'GciJmpBufSType' .
     "gci.ht" 'GciErrSType' .  'GciObjRepHdrSType' .  'GciObjRepSType' . 'GciX509LoginArg' .
     "gci.hf" 'GciCTimeStringType' .
     "gcicmn.ht" 'GciTravBufType' .  'GciTravBufHolder' .  'GciClampedTravArgsSType' .
         'GciStoreTravDoArgsSType' .  'GciDateTimeSType' }
%

category: 'Reporting'
classmethod: CHeader
_gciStructsReport: headerPath for: typeNames
  | h rpt |
  h := CHeader path: headerPath .
  rpt := String new .
  typeNames do:[ :tName | (h _typeAt: tName ) _addToReport: rpt .  rpt lf ].
  ^ rpt
%

category: 'Reporting'
classmethod: CHeader
_gciTsStructReport
 ^ self _gciStructsReport: '$GEMSTONE/include/gcits.hf' for:
   { "gci.ht" 'GciErrSType' .  'GciObjRepHdrSType' .  'GciObjRepSType' . "Add with TS x509 support is done: 'GciX509LoginArg' . "
     "gcicmn.ht" 'GciTravBufType' .  'GciTravBufHolder' .  'GciClampedTravArgsSType' .
         'GciStoreTravDoArgsSType' .  'GciDateTimeSType' .
     "gcits.hf"  'GciTsObjInfo' }
%

!		Instance methods for 'CHeader'

category: 'CLibrary'
method: CHeader
add: aCDeclaration to: aClass
  | cvn symList |
	aClass addClassVarName: (cvn := aCDeclaration asClassVarName) .
	aClass class
		compileMethod: aCDeclaration createFunctionInitializerCode
		dictionaries: (symList := GsCurrentSession currentSession symbolList )
		category: 'Initializing - private' environmentId: 0 .
	aClass
		compileMethod: aCDeclaration invokeFunctionCode
		dictionaries: symList 
		category: 'Functions' environmentId: 0.
%

category: 'private'
method: CHeader
addToSource: aString
 "(SessionTemps current at: #TraceCpp otherwise: nil) ifNotNil:[:t|
    GsFile gciLogServer:'cpp add: ', aString printString .
    t == 2 ifTrue:[ self pause ].
  ].
 "
  source add: aString .
  ^ aString .
%

category: 'Accessing'
method: CHeader
atEnd

	^preprocessor atEnd.
%

category: 'Class Membership'
method: CHeader
cByteArraySpecies
"Answer the class to be used for CByteArray objects. Subclasses may
 overload this method as needed."
^ CByteArray
%

category: 'Class Membership'
method: CHeader
cDeclarationSpecies
"Answer the class to be used for C Declarations. Subclasses may
 overload this method as needed."
^ CDeclaration
%

category: 'CLibrary'
method: CHeader
createDefinesInClass: aClass
	"preprocessor createDefinesInClass: aClass"
%

category: 'CLibrary'
method: CHeader
createFunctionsInClass: aClass libraryPathExpressionString: aString select: aBlock

	| localFunctions |
	localFunctions := aBlock
		ifNil: [functions]
		ifNotNil: [functions select: aBlock].
	localFunctions do: [:each |
		self
			add: each
			to: aClass .
	].
	self
		createInitializerInClass: aClass
		forFunctions: localFunctions
		libraryPathExpressionString: aString.
%

category: 'CLibrary'
method: CHeader
createFunctionsInClass: aClass select: aBlock

	| localFunctions |
	localFunctions := aBlock
		ifNil: [functions]
		ifNotNil: [functions select: aBlock].
	localFunctions do: [:each |
		self
			add: each
			to: aClass .
	].
	self
		createInitializerInClass: aClass
		forFunctions: localFunctions
%

category: 'CLibrary'
method: CHeader
createInitializerInClass: aClass forFunctions: someFunctions
  "Creates a method     aClass class >> initializeFunctions: aCLibrary  "
  | str symList |
  str := self initializeFunctionsCodeForFunctions: someFunctions .
  symList := GsCurrentSession currentSession symbolList .
  aClass class compileMethod: str dictionaries: symList category: 'Initializing - private' environmentId: 0.
%

category: 'CLibrary'
method: CHeader
createInitializerInClass: aClass forFunctions: someFunctions libraryPathExpressionString: aString
  "Creates a method     aClass class >> initializeFunctions "
	| str symList |
	(str := String new ) add:
'initializeFunctions
	 | library |
	 library := CLibrary named: ' , aString , ' .
   self initializeFunctions: library . '; lf .

  symList := GsCurrentSession currentSession symbolList .
  aClass class compileMethod: str dictionaries: symList category: 'Initializing - private' environmentId: 0.

  self createInitializerInClass: aClass forFunctions: someFunctions .
%

category: 'Accessing'
method: CHeader
declarations

   ^declarations
%

category: 'Accessing'
method: CHeader
definitions

	^preprocessor definitions.
%

category: 'Accessing'
method: CHeader
enums

   ^enums
%

category: 'Accessing'
method: CHeader
enumTags

   ^enumTags
%

category: 'Accessing'
method: CHeader
fieldsForStruct: aString

   ^(structs at: aString) fields.
%

category: 'Accessing'
method: CHeader
fullPath
  "If not at completion of parsing, the filename may be a nested include file."
  ^ preprocessor path
%

category: 'Accessing'
method: CHeader
functions

   ^functions
%

category: 'other'
method: CHeader
initialize: aCPreprocessor

	preprocessor := aCPreprocessor.
	types := KeyValueDictionary new.
	structs := KeyValueDictionary new.
	unions := KeyValueDictionary new.
	functions := KeyValueDictionary new.
	enums := KeyValueDictionary new.
	enumTags := KeyValueDictionary new.
	storage := KeyValueDictionary new.
	declarations := { } .

	[ source := String new.
	  [
		  self skipEmpty.
		  self atEnd .
	  ] whileFalse: [
		  self readOne.
		  source := String new.
	  ].
  ] ensure:[
	  preprocessor clearTokens. "fix 50182"
  ]
%

category: 'CLibrary'
method: CHeader
initializeFunctionsCodeForFunctions: someFunctions
	| str |
	str := String new .
	str add: 'initializeFunctions: aCLibrary ' ; lf;tab;
		  add: 'self '; lf; tab .
	(someFunctions asSortedCollection: [:a :b | a name <= b name]) do: [:aFunction |
		str add: aFunction initializerFunctionName,  ' aCLibrary ;' ; lf; tab . 
	].
	str add: 'yourself.'; lf .
  ^ str
%

category: 'CLibrary'
method: CHeader
newClassNamed: aString

	^self
		newClassNamed: aString
		instVarNames: #().
%

category: 'CLibrary'
method: CHeader
newClassNamed: aString instVarNames: anArray

	^Object
		subclass: aString
		instVarNames: anArray
		classVars: #()
		classInstVars: #()
		poolDictionaries: #()
		inDictionary: nil
		options: #().
%

category: 'Accessing'
method: CHeader
next
	| token src |
	preprocessor atEnd ifTrue:[ ^ nil].
	token := preprocessor next.
	source ifNotNil:[ | tkSrc |
     src := source .
     tkSrc := token source .
     (source size > 0 and:[ source last isAlphaNumeric ]) ifTrue:[
       tkSrc size > 0 ifTrue:[ | tC |
         tC := tkSrc at: 1.
         tC isAlphaNumeric ifTrue:[ source add: $  ]
       ]
     ].
     self addToSource: token source
  ].
	^ token.
%

category: 'Accessing'
method: CHeader
peek

	^preprocessor peek.
%

category: 'other'
method: CHeader
readClass
"                                    .----------------.
                                    V                   |
>>--+--class--identifier--{----member--;--+--}---><
"

	| token classDeclaration oldTypes oldStructs oldUnions oldFunctions oldEnums oldStorage newStorage aName |
	classDeclaration := declarations last.
	(token := self next) isSemicolonToken ifTrue: [
		classDeclaration addToSource: source.
		source := nil.
		^self.
	].
	token isOpenCurlyBracketToken ifFalse: [token error: 'syntax error, expected ''{'' '].
  aName := classDeclaration name .
  CPreprocessor _trapDefinition: aName value: classDeclaration .
	types at: aName put: classDeclaration.
	oldTypes := types copy.
	oldStructs := structs copy.
	oldUnions := unions copy.
	oldFunctions := functions copy.
	oldEnums := enums copy.
	oldStorage := storage copy.
	[
		self skipEmpty.
		(token := self peek) isCloseCurlyBracketToken 
	] whileFalse: [
		(token type == #'identifier' and: [token value = 'public' or: [token value = 'private']]) ifTrue: [
			(token := self next; next) isColonToken ifFalse: [token error: 'Unexpected token'].
		].
		self readOne.
	].
	self next.
	types := oldTypes.
	structs := oldStructs.
	unions := oldUnions.
	functions := oldFunctions.
	enums := oldEnums.
	newStorage := storage.
	storage := oldStorage.
	storage keys do: [:each | newStorage removeKey: each].
	newStorage := newStorage asArray collect: [:each |
		(declarations indexOf: each) -> each.
	].
	newStorage := newStorage asSortedCollection asArray collect: [:each | each value].
	classDeclaration setClassProperties: newStorage.
	self atEnd ifFalse: [
		(token := self next) isSemicolonToken ifFalse: [token error: 'expected '';'' '].
	].
	classDeclaration source: source.
%

category: 'other'
method: CHeader
readExternLinkageDeclarationsUnderStorageRegimeFrom: aCDeclaration
	"Process declarations of the form:
		extern <linkage_specification> { ... }
	Typically:
		extern 'C' { }
	"

	| priorDeclaration priorSource token |
	(token := self next) isOpenCurlyBracketToken ifFalse: [ token error: 'expected ''{'' '].
	source := String new.
	[
		self skipEmpty.
		self atEnd .
	] whileFalse: [
		self peek isCloseCurlyBracketToken ifTrue: [
			self next.
			^self
		].
		self readOneUnderStorageHandler: [:declaration |
			priorDeclaration := declaration.	"to help with debugging"
			(declaration isEmptyExternalLinkage and: [self peek isOpenCurlyBracketToken]) ifTrue: [
				self readExternLinkageDeclarationsUnderStorageRegimeFrom: declaration.
			] ifFalse: [
				declaration canStorageBeMadeExternal ifTrue: [
					declaration
						storage: aCDeclaration storage
						linkageSpec: aCDeclaration linkageSpec.
				].
			].
		].
		priorSource := source.	"to help with debugging"
		source := String new.
	].
	token error: 'could not find end of ''extern <linkage_specification> {'' '
%

category: 'other'
method: CHeader
readOne

	self readOneUnderStorageHandler:
			[:declaration |
			(declaration isEmptyExternalLinkage and: [self peek isOpenCurlyBracketToken])
				ifTrue:
					[^self readExternLinkageDeclarationsUnderStorageRegimeFrom: declaration]]
%

category: 'other'
method: CHeader
readOneUnderStorageHandler: aMonadicBlock
	"Read a declaration and process its storage specification using the
	 specified monadic Block. The Block takes the new declaration as
	 an argument."

	| type declaration token "src" |
	type := self cDeclarationSpecies readTypeFrom: self.
	type source: source.
  "uncomment for tracing"
  "src := source size > 30 ifTrue:[ source copyFrom: 1 to: 30 ] ifFalse:[ source ]. "
  "GsFile gciLogServer:'--x ' , src . "
	declaration := type copy readDeclaration.

	aMonadicBlock value: declaration.

	declaration isEmptyExternalLinkage
		ifFalse:
			[declarations add: declaration.
			declaration includesCode ifTrue: [^self].
			(declaration storage == #typedef and: [declaration type == #class]) ifTrue:[
        ^self readClass
      ].

			[self saveDeclaration: declaration.
			self atEnd ifTrue: [^self].
			(token := self next) isSemicolonToken ifTrue: [^self].
			token isCommaToken ifFalse: [token error: 'Expected comma or semicolon'].
			true]
					whileTrue:
						[declaration := type copy readDeclaration.
						declarations add: declaration]]
%

category: 'other'
method: CHeader
saveDeclaration: aDeclaration

	| dictionary aName |
	aDeclaration type == #'enum' ifTrue: [
		 aDeclaration enumTag ifNotNil: [
			 aDeclaration enumList ifNil: [
         (enumTags includesKey: aDeclaration enumTag) ifFalse: [
            self error: 'Missing definition of enum ' , aDeclaration enumTag.
         ].
         aDeclaration name ifNil: [
           self error: 'enum type should declare a variable or function'.
         ].
       ] ifNotNil: [
         aDeclaration enumList isEmpty ifTrue: [
           self error: 'enum should define some values'.
         ].
         (enumTags includesKey: aDeclaration enumTag) ifTrue: [
           self error: 'Duplicate definition of enum ' , aDeclaration enumTag.
         ].
         enumTags at: aDeclaration enumTag put: aDeclaration.
       ].
    ].
	].
	(aName := aDeclaration name) ifNil: [^self].
	dictionary := aDeclaration storage == #'typedef' 
                ifTrue:[ types ] 
                ifFalse:[ aDeclaration isFunction ifTrue: [	functions] ifFalse: [ storage]].
  dictionary == types ifTrue:[ CPreprocessor _trapDefinition: aName value: aDeclaration ].
	dictionary at: aName put: aDeclaration.
%

category: 'other'
method: CHeader
skipEmpty
	[
		self atEnd == false and: [self peek isEmptyToken].
	] whileTrue: [
		| token |
		token := self next.
	].
%

category: 'Accessing'
method: CHeader
storage

   ^storage
%

category: 'Accessing'
method: CHeader
structs

   ^structs
%

category: 'Accessing'
method: CHeader
types

   ^types
%

category: 'Accessing'
method: CHeader
unions
   ^unions
%

category: 'CLibrary'
method: CHeader
wrapperForLibraryAt: aString
"
| header class |
header := CHeader path: '$GEMSTONE/include/gci.hf'.
class := header wrapperForLibraryAt: CHeader fetchGciRpcLibraryName .
UserGlobals at: class name put: class.
"
	| name |
	name := (((aString subStrings: $/) last subStrings: $.) first subStrings: $-) first.
	(3 < name size and: [(name copyFrom: 1 to: 3) = 'lib']) ifTrue: [name := name copyFrom: 4 to: name size].
	name first isLowercase ifTrue: [name at: 1 put: name first asUppercase].
	^self
		wrapperNamed: name
		libraryPathExpressionString: aString printString
		select: nil.
%

category: 'CByteArray'
method: CHeader
wrapperForType: aCDeclaration

	^self
		wrapperNamed: aCDeclaration name
		forType: aCDeclaration.
%

category: 'CByteArray'
method: CHeader
wrapperForTypeNamed: aString
"
| header class |
UserGlobals removeKey: #'GciErrSType' ifAbsent: [].
header := CHeader path: '$GEMSTONE/include/gci.hf'.
class := header wrapperForTypeNamed: 'GciErrSType'.
UserGlobals at: class name put: class.
"
	^self
		wrapperNamed: aString
		forType: (types at: aString).
%

category: 'CLibrary'
method: CHeader
wrapperNamed: nameString forLibraryAt: pathString select: aBlock
"
| header class |
UserGlobals removeKey: #'GciLibrary' ifAbsent: [].
header := CHeader path: '$GEMSTONE/include/gci.hf'.
class := header
	wrapperNamed: 'GciLibrary'
	forLibraryAt: self class fetchGciRpcLibraryName
	select: [:each | each name first == $G ].
UserGlobals at: class name put: class.
"
	^self
		wrapperNamed: nameString
		libraryPathExpressionString: pathString printString
		select: aBlock
%

category: 'CByteArray'
method: CHeader
wrapperNamed: nameString forStruct: aCDeclaration
"  Example""
   | header class |
   UserGlobals removeKey: #'GciErrSType' ifAbsent: [].
   header := CHeader path: '$GEMSTONE/include/gci.hf'.
   class := header
	   wrapperNamed: 'GciErrSType'
	   forType: (header _typeAt:'GciErrSType').
   UserGlobals at: class name put: class.
"
	| class symbolList string writeStream typ cbaSizeString |
  ((typ := aCDeclaration type) == #class or:[ typ == #struct]) ifFalse:[
    Error signal:'expected a class or struct , declaration is a ', typ asString .
  ].
  cbaSizeString := aCDeclaration byteSizeForMalloc asString .
	symbolList := GsCurrentSession currentSession symbolList.
	class := (self cByteArraySpecies)
		subclass: nameString
		instVarNames: #()
		classVars: #()
		classInstVars: #()
		poolDictionaries: #()
		inDictionary: nil
		options: #().
	aCDeclaration addSourceTo: (writeStream := AppendStream on: String new).
	class comment: writeStream contents.
	string := 
'on: aCByteArray
  | res |
	res := self fromRegionOf: aCByteArray offset: 0 numBytes: ', cbaSizeString,' .
  res derivedFrom: aCByteArray .
  ^ res
'.
	class class
		compileMethod: string  "may signal CompileError or CompileWarning"
		dictionaries: symbolList
		category: 'Instance Creation'
		environmentId: 0.
	string := 
'new
	^self gcMalloc: ' , cbaSizeString ,' 
'.
	class class
		compileMethod: string  "may signal CompileError or CompileWarning"
		dictionaries: symbolList
		category: 'Instance Creation'
		environmentId: 0.
	string := 'initialize
'.
	class
		compileMethod: string  "may signal CompileError or CompileWarning"
		dictionaries: symbolList
		category: 'Initialization'
		environmentId: 0.
	string := 'initialize: aCByteArray
  | sz | 
  sz := self size min: aCByteArray size .
  self copyBytesFrom: aCByteArray from: 1 to: sz into: 0 allowCodePointZero: true .
'.
	class
		compileMethod: string  "may signal CompileError or CompileWarning"
		dictionaries: symbolList
		category: 'Initialization'
		environmentId: 0.

  "CByteArray>>_stringFromBytes:  is inherited and in base image"

	aCDeclaration sourceStringsForAccessors do: [:each |
		class
			compileMethod: each  "may signal CompileError or CompileWarning"
			dictionaries: symbolList
			category: 'Accessing' environmentId: 0 .
	].
	aCDeclaration sourceStringsForUpdators do: [:each |
		class
			compileMethod: each  "may signal CompileError or CompileWarning"
			dictionaries: symbolList
			category: 'Updating'
			environmentId: 0.
	].
	^class.
%

category: 'CByteArray'
method: CHeader
wrapperNamed: nameString forType: aCDeclaration
	| struct typ nam |
	((typ := aCDeclaration type) == #'class' or:[ typ == #struct]) ifTrue: [
		^self
			wrapperNamed: nameString
			forStruct: aCDeclaration.
	].
  nam := aCDeclaration name .
  typ _isSymbol ifFalse:[ 
    struct := aCDeclaration type . 
    typ := struct type .
  ].
	(typ == #struct or:[ typ == #class]) ifFalse:[
		Error signal: nam , ' is an ', typ asString , ' , wrapper creation not supported'.
	].
  struct ifNil:[ Error signal:'logic error in wrapperNamed:forType:' ].
  struct fields ifNil:[ Error signal: struct name , ' is an incomplete type (fields not defined)'].
	^self
		wrapperNamed: nameString
		forStruct: struct.
%

category: 'CLibrary'
method: CHeader
wrapperNamed: nameString libraryPathExpressionString: aString select: aBlock

	| newClass |
	newClass := self newClassNamed: nameString.
	self
		createFunctionsInClass: newClass libraryPathExpressionString: aString select: aBlock;
		createDefinesInClass: newClass.
	newClass initializeFunctions.
	^newClass.
%

category: 'Reporting'
method: CHeader
_typeAt: aName

^ (types at: aName otherwise: nil) ifNil:[
     (structs at: aName otherwise: nil) ifNil:[
       (unions at: aName otherwise: nil) ifNil:[ Error signal: aName , '  not found' ]]].
%

! Class implementation for 'ClampSpecification'

!		Class methods for 'ClampSpecification'

category: 'Examples'
classmethod: ClampSpecification
example1

"Creates and returns a ClampSpecification object with identity clamps for
 Globals and AllUsers, class clamps for GsObjectSecurityPolicy, Repository and UserProfile, and
 instance variable levels on the value parts of Associations and
 SymbolAssociations."

^ClampSpecification newWithIdClamps: { Globals . AllUsers }
  classClamps: { GsObjectSecurityPolicy . Repository . UserProfile }
  instVarLevels: {
      { Association . #( #value 0 ) } .
      { SymbolAssociation . #( #value 0 ) }
      }
%

category: 'Examples'
classmethod: ClampSpecification
example2

"Same as example1, but the clamps are added piecemeal."

| inst |
inst := ClampSpecification new.
inst addAllIdClamps: { Globals . AllUsers }.
inst addAllClassClamps: { GsObjectSecurityPolicy . Repository . UserProfile }.
inst addAllInstVarLevels: {
    { Association . #( #value 0 ) } .
    { SymbolAssociation . #( #value 0 ) }
    }.
^inst
%

category: 'Instance Creation'
classmethod: ClampSpecification
new

"Returns a new instance of ClampSpecification.  Note that you may also use
 structural access calls through GemBuilder for either C or Smalltalk
 (for example, GciNewOop()) to create new instances of ClampSpecification."

^super new
%

category: 'Instance Creation'
classmethod: ClampSpecification
new: anInteger

"Disallowed.  You may not use this method to create new instances of
 ClampSpecification."

^self shouldNotImplement: #new:
%

category: 'Instance Creation'
classmethod: ClampSpecification
newWithIdClamps: idClamps
classClamps: classClamps
instVarLevels: instVarLevels

"Creates and returns a new instance of ClampSpecification with the given clamps.
 If a creation error is encountered, generates an error but does not return the
 new ClampSpecification."

| inst |

inst := self new.
inst environmentId: 0 ;
    addAllIdClamps: idClamps;
     addAllClassClamps: classClamps;
     addAllInstVarLevels: instVarLevels.
^inst
%

category: 'Instance Creation'
classmethod: ClampSpecification
newWithIdClamps: idClamps
classClamps: classClamps
instVarLevels: instVarLevels
subleafHeaders: subleafHeadersBool

"Creates and returns a new instance of ClampSpecification with the given clamps.
 If subleafHeadersBool is true, a traversal using this clamp supplies object
 headers for objects that are children of the leaf nodes of the traversal.
 If a creation error is encountered, generates an error but does not return the
 new ClampSpecification."

| inst |

inst := self
   newWithIdClamps: idClamps
   classClamps: classClamps
   instVarLevels: instVarLevels.
inst addSubleafHeaders: subleafHeadersBool.

^inst
%

category: 'Instance Creation'
classmethod: ClampSpecification
newWithIdClampsHolder: idClamps
classClamps: classClamps
instVarLevels: instVarLevels
subleafHeaders: subleafHeadersBool
traversalCallbackSelector: callbackSelector

"Creates and returns a new instance of ClampSpecification with the given clamps.
 The argument idClamps is the actual IdentitySet used to hold the identity
 clamps, so it must be an instance of IdentitySet.  If subleafHeadersBool
 is true, a traversal using this clamp supplies object headers for objects that
 are children of the leaf nodes of the traversal.  The callbackSelector is
 either nil or a unary selector symbol that is used by the traversal mechanism
 to send to instances of classes that require a traversal callback."

| inst |

inst := self basicNew
   _initIdClampsHolder: idClamps
   classClamps: classClamps
   instVarLevels: instVarLevels
   addSubleafHeaders: subleafHeadersBool
   traversalCallbackSelector: callbackSelector.

^inst
%

!		Instance methods for 'ClampSpecification'

category: 'Class Clamps'
method: ClampSpecification
addAllClassClamps: aCollection

"Adds a class clamp to the receiver for each class object in aCollection.
 The instances of each class in aCollection will be clamped during
 object traversal."

aCollection _validateClass: Collection .
classClamps == nil ifTrue: [self _initializeClassClamps].
(aCollection class isBytes) ifTrue:[
  aCollection _error: #clampErrBadArg args:  #()  .
  ^ self
].
classClamps addAll: aCollection.
%

category: 'Identity Clamps'
method: ClampSpecification
addAllIdClamps: aCollection

"Adds an identity clamp to the receiver for each object in aCollection.
 Returns the receiver."

aCollection _validateClass: Collection .
idClamps == nil ifTrue: [self _initializeIdClamps].
idClamps addAll: aCollection.
%

category: 'Instance Variable Levels'
method: ClampSpecification
addAllInstVarLevels: aCollection

"Adds the given instance variable levels to the receiver.  The argument
 aCollection may be either (1) an Array of two-element Arrays, in which the
 first element of each Array is a Class object and the second element is
 a collection of instance variable levels in the format expected by
 addInstVarLevels:forClass:,
 or (2) a Dictionary whose keys are Class objects and whose values are
 collections of instance variable levels in the format expected by
 addInstVarLevels:forClass:.  Returns the receiver."

aCollection _validateClass: Collection .
(aCollection isKindOf: Dictionary)
  ifTrue: [
    aCollection associationsDo: [:each |
      self addInstVarLevels: (each value) forClass: (each key)
    ]
  ]
  ifFalse: [
    aCollection do: [:each |
      (each size == 2) ifFalse:[
        each _error: #clampErrBadArg args:  #()  .  ^ self
      ].
      ((each at:2) class isBytes) ifTrue:[
         (each at:2) _error: #clampErrBadArg args:  #()  .  ^ self
      ].
      self addInstVarLevels: (each at: 2) forClass: (each at: 1)
    ]
  ].
%

category: 'Class Clamps'
method: ClampSpecification
addClassClampFor: aClass

"Adds a class clamp to the receiver for aClass.  Returns the receiver."

classClamps == nil ifTrue: [self _initializeClassClamps].
classClamps add: aClass.
%

category: 'Identity Clamps'
method: ClampSpecification
addIdClampFor: anObject

"Adds an identity clamp to the receiver for anObject.  Returns the receiver."

anObject isSpecial ifTrue: [ ^ anObject _error: #clampErrBadArg args: #() ].
idClamps == nil ifTrue: [self _initializeIdClamps].
idClamps add: anObject.
%

category: 'Instance Variable Levels'
method: ClampSpecification
addInstVarLevels: aCollectionOfIVarLevels forClass: aClass

"Adds an instance variable level on each of the instance variable names
 contained in aCollectionIVarLevels for the specified class aClass.  The levels
 must be an OrderedCollection in the following format:

 1. A Symbol specifying the named instance variable to level or nil to level all
    unnamed instance variables.
 2. A SmallInteger that specifies the level, or false.  If false, then treat it
    as a max 0 but never include a subleaf header.  If this value is less than
    zero then it is a min operation.  Otherwise it is a max operation."

| allivs   "the list of all the instance variable for aClass"
  ivlArray "the instance variable level Array"
|

aCollectionOfIVarLevels _validateClass: Collection .
(aCollectionOfIVarLevels class isBytes) ifTrue:[
  aCollectionOfIVarLevels _error: #clampErrBadArg args:  #()  .
  ^ self
].

aClass class isMeta ifFalse: [
    aClass _error: #clampErrNotAClass args:  #().
    ^ self
].

instVarLevels == nil ifTrue: [self _initializeInstVarLevels].

allivs := aClass _instVarNames.

ivlArray := { } .
ivlArray size: (allivs size) + 1.

1 to: (aCollectionOfIVarLevels size) by: 2 do: [ :i | | varname level idx |
  varname := aCollectionOfIVarLevels at: i.
  level := aCollectionOfIVarLevels at: i+1.
  varname == nil ifTrue: [idx := allivs size + 1]
                ifFalse: [
    idx := allivs indexOf: varname.
    idx == 0 ifTrue: [
      ^aClass _error: #clampErrNoSuchInstvar args: { varname }.
    ].
  ].
  ivlArray at: idx put: level.
].
instVarLevels at: aClass put: ivlArray.
%

category: 'Testing'
method: ClampSpecification
addSubleafHeaders

"Returns true if the receiver will add subleaf headers to the traversal buffer.
 Returns false otherwise."

addSubleafHeaders == nil ifTrue:  [^false]
                        ifFalse: [^addSubleafHeaders]
%

category: 'Configuration'
method: ClampSpecification
addSubleafHeaders: aBoolean

"Sets the addSubleafHeaders instance variable to aBoolean.  Returns the
 receiver."

aBoolean  _validateClass: Boolean .
addSubleafHeaders := aBoolean.

^self
%

category: 'Configuration'
method: ClampSpecification
environmentId: envId

"Sets the enviroment used for method lookup by sends of the
 traversalCallBackSelector.
 envId must be a SmallInteger >= 0 and <= 255  "

envId _isSmallInteger ifFalse:[ envId _validateClass: SmallInteger ].
(envId < 0 or:[ envId > 255]) ifTrue:[
   envId _error: #rtErrArgOutOfRange args:{ 0 . 255 } .
].
environmentId := envId .
%

category: 'Class Clamps'
method: ClampSpecification
includesClassClampFor: aClass

"Returns true if the receiver has a class clamp on aClass.  Returns false
 otherwise."

classClamps == nil ifTrue:  [^false]
                  ifFalse: [^classClamps includesIdentical: aClass]
%

category: 'Identity Clamps'
method: ClampSpecification
includesIdClampFor: anObject

"Returns true if the receiver has an identity clamp on anObject.
 Returns false otherwise."

idClamps == nil ifTrue:  [^false]
               ifFalse: [^idClamps includesIdentical: anObject]
%

category: 'Instance Variable Levels'
method: ClampSpecification
includesInstVarLevelsFor: aClass

"Returns true if the receiver has an instance variable level on aClass.
 Returns false otherwise."

instVarLevels == nil ifTrue:  [^false]
                    ifFalse: [^instVarLevels includesKey: aClass]
%

category: 'Value Clamps'
method: ClampSpecification
includesValueClampFor: anObject

"Returns true if the receiver has value-clamped the given object.
 Returns false otherwise."

valueClamps == nil
  ifTrue:  [ ^ false ]
  ifFalse: [ ^ valueClamps includesIdentical: anObject ]
%

category: 'Initialization'
method: ClampSpecification
initialize

"Reset the state of the ClampSpecification to its initial state.
 Returns the receiver."

self nilFields ;
  environmentId: 0 .
^self
%

category: 'Accessing'
method: ClampSpecification
instVarLevelsSelector

 ^ instVarLevelsSelector
%

category: 'Configuration'
method: ClampSpecification
instVarLevelsSelector: aSelector
 "Sets the instVarLevelsSelector instance variable to aSelector.
  aSelector must be a Symbol, DoubleByteSymbol, or QuadByteSymbol.  Returns the receiver."

 instVarLevelsSelector := aSelector
%

category: 'Identity Clamps'
method: ClampSpecification
removeAllIdClamps: aCollection

"Removes an identity clamp from the receiver for each object in aCollection.
 Does not generate an error if there is no identity clamp for any of the objects
 in aCollection."

idClamps ~~ nil
  ifTrue: [ idClamps _removeAll: aCollection errIfAbsent: false ]
%

category: 'Class Clamps'
method: ClampSpecification
removeClassClampFor: aClass

"Removes the class clamp from the receiver for aClass.  Generates an error if
 there is no class clamp on aClass."

classClamps == nil ifTrue:  [self _errorNotFound: aClass. ^self]
                  ifFalse: [^classClamps remove: aClass]
%

category: 'Identity Clamps'
method: ClampSpecification
removeIdClampFor: anObject

"Removes an identity clamp from the receiver for anObject.  Generates an error
 if there is no identity clamp on anObject."

idClamps == nil ifTrue: [self _errorNotFound: anObject. ^self]
               ifFalse: [^idClamps remove: anObject]
%

category: 'Instance Variable Levels'
method: ClampSpecification
removeInstVarLevelsFor: aClass

"Removes any existing instance variable levels for aClass.  Generates an error
 if there is no instance variable level on aClass."

instVarLevels == nil ifTrue:  [self _errorKeyNotFound: aClass. ^self]
                    ifFalse: [^instVarLevels removeKey: aClass]
%

category: 'Accessing'
method: ClampSpecification
traversalCallBackSelector

"Returns the value of the instance variable traversalCallBackSelector."

^ traversalCallBackSelector
%

category: 'Configuration'
method: ClampSpecification
traversalCallBackSelector: aSelector

"Sets the traversalCallBackSelector instance variable to aSelector.
 aSelector must be a Symbol, DoubleByteSymbol, or QuadByteSymbol.  Returns the receiver."

aSelector _isSymbol ifFalse:[
  ArgumentError signal:'arg to traversalCallBackSelector:  must be a Symbol'.
].
traversalCallBackSelector := aSelector
%

category: 'Private'
method: ClampSpecification
_initializeClassClamps

"Initializes the class clamps variable.  Returns the receiver."

classClamps := ClassSet new.
%

category: 'Private'
method: ClampSpecification
_initializeIdClamps

"Initializes the identity clamps variable.  Returns the receiver."

idClamps := IdentitySet new.
%

category: 'Private'
method: ClampSpecification
_initializeInstVarLevels

"Initializes the instance variable levels variable.  Returns the receiver."

instVarLevels := FastIdentityKeyValueDictionary new.
instVarLevels keyConstraint: Class.
instVarLevels valueConstraint: Array.
%

category: 'Initialization'
method: ClampSpecification
_initializeValueClamps

"Create a new value clamps set."

valueClamps := IdentitySet new.
%

category: 'Private'
method: ClampSpecification
_initIdClampsHolder: idc
classClamps: cc
instVarLevels: ivl
addSubleafHeaders: ash
traversalCallbackSelector: tcb

"Private."

idc _validateClass: IdentitySet .
idClamps := idc.
self
  addAllClassClamps: cc;
  addAllInstVarLevels: ivl;
  addSubleafHeaders: ash;
  traversalCallBackSelector: tcb ;
  environmentId: 0 .
%

! Class implementation for 'CPreprocessor'

!		Class methods for 'CPreprocessor'

category: 'other'
classmethod: CPreprocessor
evaluateHeader: aCHeader

	^self basicNew evaluateHeader: aCHeader.
%

category: 'other'
classmethod: CPreprocessor
new

	^self basicNew
		initialize;
		yourself.
%

category: 'other'
classmethod: CPreprocessor
parseFileAt: aString

	^self new
		includePath: aString;
		yourself.
%

category: 'other'
classmethod: CPreprocessor
parseString: aString
	^ self new
	  	parseString: aString ignoreWarnings: false ;
	  	yourself.
%

category: 'other'
classmethod: CPreprocessor
parseString: aString ignoreWarnings: aBoolean
	^ self new
	  	parseString: aString ignoreWarnings: aBoolean ;
	  	yourself.
%

category: 'other'
classmethod: CPreprocessor
references

^'
	http://www.acm.uiuc.edu/webmonkeys/book/c_guide/index.html
	http://gcc.gnu.org/onlinedocs/gcc-3.0.1/cpp_1.html#SEC1
'.
%

category: 'private'
classmethod: CPreprocessor
_trapDefinition: aName
  false ifTrue:[ | targetName |   "edit for debugging"
    targetName := 'uint32_t' .
    aName = targetName ifTrue:[ self pause ]. 
  ].
%

category: 'private'
classmethod: CPreprocessor
_trapDefinition: aName value: aValue
  false ifTrue:[ "edit for debugging"
    | a b |
    a := 'uint32_t' .  "examples only"
    b := '__uint32_t' .
    (aName = a or:[ aName = b]) ifTrue:[ | oldVal key |
      oldVal := SessionTemps current at: (key := #CpreTrapDef) otherwise: nil .
      aValue ~~ oldVal ifTrue:[
        self pause  .
        SessionTemps current at: key put: aValue .
      ].
    ].
  ].
%

!		Instance methods for 'CPreprocessor'

category: 'directives'
method: CPreprocessor
addRestOfLineTo: aCollection
  | lf |
  lf := Character lf.
	[
		readStream atEnd or: [readStream peek == lf].
	] whileFalse: [
		aCollection add: self nextToken.
	].
%

category: 'accessors'
method: CPreprocessor
allSearchPaths
  "Return the list of directories used to search for a file that
   is the argument of a #include directive."
  | res |
  (res := searchPaths copy) addAll: systemSearchPaths .
  ^ res
%

category: 'other'
method: CPreprocessor
applyConcatenationToken: aToken

	| left right list |
	left := tokens last.
	right := self nextToken.
	list := { left . aToken . right }.
	self applyToken: right.
	left
		collectOriginalFrom: list;
		concatenate: tokens last.
	tokens size: tokens size - 1.
%

category: 'directives'
method: CPreprocessor
applyDirectiveToken: aToken

	| directive |
	directive := aToken value.
	directive = 'define' 			ifTrue: [^self define: 	aToken].
	directive = 'undef' 			ifTrue: [^self undef: 	aToken].
	directive = 'ifdef' 				ifTrue: [^self ifdef: 		aToken defined: true].
	directive = 'ifndef' 			ifTrue: [^self ifdef: 		aToken defined: false].
	directive = 'if'					ifTrue: [^self if:			aToken].
	directive = 'include'			ifTrue: [^self include: 	aToken afterMe: false].
	directive = 'include_next'	ifTrue: [^self include: 	aToken afterMe: true].
	directive = 'pragma'			ifTrue: [^self ignoreRestOfLine].
	directive = 'warning'			ifTrue: [^self ignoreRestOfLine].
	self error: 'Unrecognized directive token: ' , aToken printString.
%

category: 'other'
method: CPreprocessor
applyFunctionMacroToken: aToken

	| char name arguments1 arguments2 definition oldLine oldStream string oldSize |
	"http://gcc.gnu.org/onlinedocs/cpp/Function_002dlike-Macros.html specifies to ignore if no parenthesis"
	(char := readStream peek) == $(
		ifFalse:
			[tokens add: aToken.
			^self].
	name := aToken value.
	arguments1 := self macroFunctionArgumentsFor: aToken.
	arguments2 := self expandMacroFunctionArguments: arguments1.
	definition := definitions at: name.
	string := definition expandArguments: arguments2.
	string isEmpty ifTrue: [^self].

	oldLine := line.
	oldSize := tokens size.
	oldStream := readStream.
	readStream := CPreprocessorStream on: string.
	self readTillEnd.
	readStream := oldStream.
	oldSize == tokens size ifTrue: [tokens add: self cPreprocessorTokenSpecies empty].
	(tokens at: oldSize + 1) replaceFirst: aToken.
	oldSize + 2 to: tokens size do: [:i | (tokens at: i) replaceOther: aToken].
	line := oldLine	"Multi-line definitions would confuse the subsequent line numbers"
%

category: 'other'
method: CPreprocessor
applyIdentifierToken: aToken

	| name definition oldTokens list |
	(1 <= tokens size and: [
		tokens last isDefinedIdentifierToken]) ifTrue: [tokens add: aToken. ^self].
	(2 <= tokens size and: [
		tokens last isOpenParenthesisToken and: [
		(tokens at: tokens size - 1) isDefinedIdentifierToken]]) ifTrue: [tokens add: aToken. ^self].
	name := aToken value.
	definition := definitions
		at: name
		ifAbsent: [tokens add: aToken. ^self].
	oldTokens := tokens.
	tokens := list := Array new.
	definition isFunctionLikeMacroDefinition ifTrue: [
		self applyFunctionMacroToken: aToken.
	] ifFalse: [
		self applySimpleMacroToken: aToken.
	].
	tokens := oldTokens.
  self _removeDefinition: name .
	list do: [:each | self applyToken: each].
	self definitionsAt: name put: definition.
%

category: 'other'
method: CPreprocessor
applySimpleMacroToken: aToken

	| definition oldLine oldSize oldStream |
	definition := self _removeDefinition: aToken value.
	oldLine := line.
	oldSize := tokens size.
	oldStream := readStream.
	readStream := CPreprocessorStream on: definition value.
	self readTillEnd.
	readStream := oldStream.
	oldSize == tokens size ifTrue: [tokens add: self cPreprocessorTokenSpecies empty].
	(tokens at: oldSize + 1) replaceFirst: aToken.
	oldSize + 2 to: tokens size do: [:i | (tokens at: i) replaceOther: aToken].
	line := oldLine.		"Multi-line definitions would confuse the subsequent line numbers"
	self definitionsAt: aToken value put: definition.
%

category: 'other'
method: CPreprocessor
applyToken: aToken
  "GsFile gciLogServer:'applyToken  ' , aToken printString ." "uncomment to debug"
	aToken isDirectiveToken ifTrue: [^self applyDirectiveToken: aToken].
	aToken isConcatenationToken ifTrue: [^self applyConcatenationToken: aToken].
	aToken isIdentifierToken ifTrue: [^self applyIdentifierToken: aToken].
	tokens add: aToken.
%

category: 'other'
method: CPreprocessor
atEnd

	^tokens isEmpty.
%

category: 'Class Membership'
method: CPreprocessor
cDeclarationSpecies
"Answer the class to be used for CDeclaration objects. Subclasses may
 overload this method as needed."
^ CDeclaration
%

category: 'other'
method: CPreprocessor
clearTokens
  tokens := nil.
  tmpFnames ifNotNil:[:fNames |
    fNames do:[:fn | fn ifNotNil:[ GsFile removeServerFile: fn]].
    tmpFnames := nil .
  ].
%

category: 'Class Membership'
method: CPreprocessor
cPreprocessorTokenSpecies
"Answer the class to be used for CPreprocessorToken objects. Subclasses may
 overload this method as needed."
^ CPreprocessorToken
%

category: 'Default Definitions'
method: CPreprocessor
defaultAix71Definitions
  self nativeCppCmd ifNotNil:[ ^ self defaultNativeCppDefinitions ].
  ^ self _defaultAix71DefinitionsOld
%

category: 'Default Definitions'
method: CPreprocessor
defaultAix72Definitions
  self nativeCppCmd ifNotNil:[ ^ self defaultNativeCppDefinitions ].
  ^ self _defaultAix72DefinitionsOld
%

category: 'Default Definitions'
method: CPreprocessor
defaultDarwinDefinitions
self nativeCppCmd ifNotNil:[
  "We are running the OS's preprocessor first"
  ^ self defaultNativeCppDefinitions ,
'#define __compar
#define _close
#define _read
#define _seek
#define _write
#define availability(x)
#define _Nonnull
'
].
^ self _defaultDarwinDefinitionsOld
%

category: 'Default Definitions'
method: CPreprocessor
defaultLinuxDefinitions

self nativeCppCmd ifNotNil:[
  "We are running the OS's preprocessor first"
  ^ self defaultNativeCppDefinitions
].
^ System performOnServer: 'cpp -dM /dev/null'
%

category: 'Default Definitions'
method: CPreprocessor
defaultNativeCppDefinitions
^
'#define __inline inline
#define __inline__ inline
#define __restrict_arr
#define __restrict
#define restrict
#define __const const
#define __signed signed
#define __extension__
#define __volatile
#define __signed__ signed
#define __uint128_t unsigned long long
#define throw()
'

"  __signed__, __uint128_t added for Linux on ARM 64bit"
%

category: 'directives'
method: CPreprocessor
define: defineToken

	| expansionTokens nameToken name parameters list string token |
	readStream peek == Character lf ifTrue: [ defineToken error: 'unexpected end of line' ].
	(nameToken := self nextToken) isIdentifierToken ifFalse: [ nameToken error: 'expected an identifier'].
	name := nameToken value.
	self definitionsAt: name put: defineToken.
	list := { defineToken . nameToken }.	"collect the tokens so we can extract the source"
	nameToken peek == $( ifTrue: [			"capture parameters"
		list add: self nextToken.
		parameters := Array new.
		token := list add: self nextToken.
		[
			token isCloseParenthesisToken.
		] whileFalse: [
			token isIdentifierToken ifTrue: [
				parameters add: token value.
				(token := list add: self nextToken) isCommaToken ifTrue: [
					token := list add: self nextToken.
				].
			] ifFalse: [
				3 timesRepeat: [
					token isDotToken ifFalse: [self error: 'Expected identifier or dots'].
					token := list add: self nextToken.
				].
			].
		].
	].
	string := String new.
	expansionTokens := {}.
	[
		(token := self nextTokenOnLine) ~~ nil.
	] whileTrue: [
		expansionTokens add: token.
		string add: token source.
	].
	defineToken collectOriginalFrom: list.
	defineToken addToSource: string.
	defineToken
		defineParameters: parameters
		expansionTokens: expansionTokens.
%

category: 'accessors'
method: CPreprocessor
definitions

	^definitions.
%

category: 'other'
method: CPreprocessor
definitionsAt: name put: definition
  "in a seperate method for easier set breakpoint."
  self class _trapDefinition: name value: definition .
  ^ definitions at: name put: definition
%

category: 'other'
method: CPreprocessor
directory

	path ifNil: [^''].
	path size to: 1 by: -1 do: [:i |
		(path at: i) == $/ ifTrue: [
			^path copyFrom: 1 to: i.
		].
	].
	^''.
%

category: 'directives'
method: CPreprocessor
doIf: aBoolean

	| inTrueBlock anyWereTrue token ifDepth lf |
	inTrueBlock := aBoolean.
	anyWereTrue := false.
  lf := Character lf .
	[true] whileTrue: [
		inTrueBlock ifTrue: [
			anyWereTrue := true.
			[
				(token := self nextToken) isConditionalEndDirective.
			] whileFalse: [
				self applyToken: token.
			].
			(readStream atEnd or: [readStream peek == lf or: [token value = 'elif']]) ifFalse: [
         token error:'expected ''elif'' or end of line '
      ].
			token value = 'endif' ifTrue: [
				self ignoreRestOfLine.
				^self.
			].
			token value = 'else' ifTrue: [
				self ignoreRestOfLine.
				inTrueBlock := false.
			] ifFalse: [
				self ignoreRestOfLine.
				(anyWereTrue and: [token value = 'elif']) ifTrue: [
					inTrueBlock := false.
				] ifFalse: [
					token error:'Expected ''else'' or ''endif''  '.
				].
			].
		] ifFalse: [		"not inTrueBlock"
			ifDepth := 0.
			token := self skipWhile: [:each |
				each isConditionalBeginDirective ifTrue: [ifDepth := ifDepth + 1].
				0 < ifDepth ifTrue: [
					each isEndifDirective ifTrue: [ifDepth := ifDepth - 1].
					true.
				] ifFalse: [
					each isConditionalEndDirective not.
				].
			].
			(readStream atEnd or: [readStream peek == lf or: [token value = 'if' or: [token value = 'elif']]]) ifFalse: [ token error:'expected ''if'' or ''elif'' or end of line' ].
			token value = 'endif' ifTrue: [^self].
			token value = 'else' ifTrue: [
				inTrueBlock := anyWereTrue not.
			] ifFalse: [
				token value = 'if' ifTrue: [
					self skipWhile: [:each | each isEndifDirective not].
					readStream peek == lf ifFalse: [token error: 'missing end of line' ].
				] ifFalse: [
					token value = 'elif' ifTrue: [
						inTrueBlock := self evaluateIfOrElif: token.
					] ifFalse: [
						token error:'Expected ''if'' or ''elif'' '
					].
				].
			].
		].
	].
%

category: 'expression evaluation'
method: CPreprocessor
evaluate: aStream
	"Returns an Integer from a stream of tokens"

	| expr value |
	expr := self parse: aStream.
	value := self valueOf: expr.
	^value.
%

category: 'expression evaluation'
method: CPreprocessor
evaluateHeader: aCHeader

	header := aCHeader.
	definitions := aCHeader types.
	^self evaluate: header.
%

category: 'directives'
method: CPreprocessor
evaluateIfOrElif: aToken

	| oldTokens stream expression value lf |
	oldTokens := tokens.
	tokens := { aToken } .
  lf := Character lf .
	[
		readStream atEnd or: [readStream peek == lf ].
	] whileFalse: [
		self applyToken: self nextToken.
	].
	stream := CPreprocessorStream on: tokens.
	tokens := oldTokens.
	stream next.
	expression := self parse: stream.
	value := self valueOf: expression.
	^value ~= 0.
%

category: 'other'
method: CPreprocessor
expandMacroFunctionArguments: aList

	| list |
	list := aList collect: [:eachArray |
		| string |
		string := String new.
		eachArray do: [:each | string add: each source].
		string.
	].
	^list select: [:each | each notEmpty].
%

category: 'directives'
method: CPreprocessor
if: aToken

	self doIf: (self evaluateIfOrElif: aToken).
%

category: 'directives'
method: CPreprocessor
ifdef: aToken defined: aBoolean

	| nameToken name lf |
	readStream peek == (lf := Character lf) ifTrue: [ aToken error:'unexpected end of line' ].
	(nameToken := self nextToken) isIdentifierToken ifFalse: [ nameToken error:'expected an identifier'].
	name := nameToken value.
	readStream peek == lf ifFalse: [ nameToken error:'missing end of line' ].
	self doIf: (definitions includesKey: name) == aBoolean.
%

category: 'directives'
method: CPreprocessor
ignoreRestOfLine

	self addRestOfLineTo: { }
%

category: 'directives'
method: CPreprocessor
include: aToken afterMe: aBoolean
	| token string existingPath fullPath |
	aBoolean ifTrue: [| index |
			index := path indexOfLastByte: $/ codePoint startingAt: path size.
			existingPath := path copyFrom: 1 to: index].
	token := self nextToken.
	aToken addToSource: token source.
	token isStringToken ifTrue: [
     "If including a name in double quotes, first try getting the file from the same
      directory as the file containing the include."
			string := self directory , token value.
			(GsFile existsOnServer: string) ifTrue: [^self includePath: string].
			string := token value
  ] ifFalse: [
    token isOpenAngleBracketToken ifFalse: [token error: 'expected ''<'' '].
		string := String new.
		[(token := self nextToken) isCloseAngleBracketToken] whileFalse:[
      "we want the source rather than the valueString since 'gnu/stubs-64.h'
          ends up with an integer token of '64.h'!"
			string add: token source.
			aToken addToSource: token source]
  ].
	fullPath := self searchForInclude: string excluding: existingPath.
	fullPath ifNotNil: [^self includePath: fullPath]
		ifNil: [
      string = 'stdarg.h' ifTrue: [^self].	"This appears to be missing from some systems and can be ignored without problem!"
		  UserDefinedError signal: 'Include file ' , string , ' not found!']
%

category: 'directives'
method: CPreprocessor
includePath: aString
  "Start a CPreprocessor using file specified by aString
    or recurse to process argument of an #include  "
	| oldPath oldLine oldStream fName f tmpsOfs |
	oldPath := path.
	oldLine := line.
	oldStream := readStream.
	path := aString.
	line := 1.
  fName := GsFile _expandFilename: aString isClient: false .
    (f := GsFile openReadOnServer: fName) ifNil: [
 	    Error signal: 'cannot open file ', fName , '; ', GsFile serverErrorString.
  ].
  [ self nativeCppCmd ifNotNil:[:cmd|  | cppOut |
      f close .
      cppOut := GsHostProcess execute: ( cmd  , fName) encodeAsUTF8 .
		  (cppOut at: 1 equals:'WARNING') ifTrue:[
         Error signal: 'non-empty stderr from ', cmd, ', ' , cppOut
      ].
      readStream := self _streamOnCppOutput: cppOut .
      tmpsOfs := tmpFnames size .
      false ifTrue:[ "uncomment (change false to true) to facilitate debugging CPreprocessor"
        (GsFile openWriteOnServer: 'cppOut.txt') nextPutAll: cppOut ; close  .
        readStream debug: true . 
      ]. 
      path := aString "file name to associate with error numbers"
    ] ifNil:[
      readStream := CPreprocessorStream on: f contents .
      f close .
      readStream file: path ; line: 1 .
    ] .
		self readTillEnd.
	] ensure: [
		readStream ifNotNil:[:s | s close ].
    tmpsOfs ifNotNil:[
      [ (tmpFnames atOrNil: tmpsOfs) ifNotNil:[:fn | 
          GsFile removeServerFile: fn .
          tmpFnames at: tmpsOfs put: nil .
        ]
      ] on: Error do:[:ex | "ignore"].
    ].
		readStream := oldStream.
		line := oldLine.
    oldPath ifNotNil:[ path := oldPath ].
	].
%

category: 'other'
method: CPreprocessor
initialize
	tokens := { } .
	self _initializePaths .
	self initializeDefinitions .
%

category: 'Default Definitions'
method: CPreprocessor
initializeDefinitions
	| defs tmpsKey |
  "Do not cache definitions in the repository ; sessions could be executing on
   hosts from a mix of architectures."
  defs := SessionTemps current at: (tmpsKey := #GemStone_CPreprocessorInitialDefinitions)
                               otherwise: nil.
  defs ifNil:[ | arch string |
	  arch := System gemVersionReport at: 'gsBuildArchitecture'.
    string :=
      arch = 'x86-64 (Linux)' ifTrue: [self defaultLinuxDefinitions] ifFalse: [
      arch = 'arm64 (Linux)' ifTrue: [self defaultLinuxDefinitions] ifFalse: [
		  arch = 'Darwin (macOS)' ifTrue: [self defaultDarwinDefinitions] ifFalse: [
		  arch = 'RISC 6000 (AIX 7.2)' ifTrue: [self defaultAix72Definitions] ifFalse: [
		  arch = 'RISC 6000 (AIX 7.1)' ifTrue: [self defaultAix71Definitions] ifFalse: [
		    Error signal: arch asString , ' build type is not (yet?) supported']]]]
      ].
    definitions := KeyValueDictionary new .
    self _parseStringNoCpp: string. "fill in definitions"
    defs := definitions .
    SessionTemps current at: tmpsKey put: defs .
  ].
  definitions := defs copy.
%

category: 'other'
method: CPreprocessor
insertSearchPath: aString
  "Install the given path at the front of the list of search paths."
  | aPath |
  aPath := GsFile _expandFilename: aString isClient: false .
  aPath ifNil:[ Error signal:'Error expanding environment variables in ', aString asString].
  searchPaths insertObject: aPath at: 1 .
%

category: 'expression evaluation'
method: CPreprocessor
integerFromBoolean: aBoolean

	^aBoolean
		ifTrue: [1]
		ifFalse: [0].
%

category: 'other'
method: CPreprocessor
macroFunctionArgumentsFor: aToken

	| arguments index parenthesisCount list token |
	(token := self nextToken) isOpenParenthesisToken ifFalse: [ token error: 'expected ''('' ' ].
	list := { aToken . token }.
	arguments := { } .
	parenthesisCount := 1.
	index := 3.
	[
		token := self nextToken.
		(parenthesisCount == 1 and: [token isCommaToken]) ifTrue: [
			arguments add: (list copyFrom: index to: list size).
			index := list size + 2.
		] ifFalse: [
			token isOpenParenthesisToken ifTrue: [
				parenthesisCount := parenthesisCount + 1.
			] ifFalse: [
				token isCloseParenthesisToken ifTrue: [parenthesisCount := parenthesisCount - 1].
			].
		].
		list add: token.
		0 < parenthesisCount.
	] whileTrue: [].
	arguments add: (list copyFrom: index to: list size - 1).
	aToken collectOriginalFrom: list.
	^arguments.
%

category: 'expression evaluation'
method: CPreprocessor
mergeLastTwoElementsIn: stack

	| x y token |
	y := stack removeLast.
	x := stack last.
	token := (y at: 2) ->  {  (x at: 3) . (y at: 3)} .
	x at: 3 put: token.
%

category: 'directives'
method: CPreprocessor
nativeCppCmd
  | arch cmd archInt verRpt |
  "Returns a String, the native C preprocessor command ,
   or nil if the native C preprocessor is not used on the platform running the session."

  "false ifTrue:[ ^ nil ]." "uncomment to not use native cpp ."

  archInt := 0 .
  arch := (verRpt := System gemVersionReport) at: 'gsBuildArchitecture' .
  arch = 'x86-64 (Linux)' ifTrue:[
    cmd := '/usr/bin/cpp' .
    (GsFile existsOnServer: cmd ) ifFalse:[
       Error signal: cmd , ' not found,  package cpp must be installed on host running the gem or topaz -l process'.
    ].
    cmd := cmd , ' ' .
    archInt := 50.
  ] ifFalse:[
  arch = 'arm64 (Linux)' ifTrue:[
    cmd := '/usr/bin/cpp' .
    (GsFile existsOnServer: cmd ) ifFalse:[
       Error signal: cmd , ' not found,  package cpp must be installed on host running the gem or topaz -l process'.
    ].
    cmd := cmd , ' ' .
    archInt := 52.
  ] ifFalse:[
  arch = 'Darwin (macOS)' ifTrue:[
    cmd := '/usr/bin/clang'.
    (GsFile existsOnServer: cmd ) ifFalse:[
       Error signal: cmd , ' not found,  clang must be installed on host running the gem or topaz -l process'.
    ].
    "Need to define _ANSI_SOURCE so we don't get enumerator_attributes feature that causes
     trouble for us in /usr/include/time.h on __CLOCK_AVAILABILITY on Darwin 17."
    cmd := cmd , ' -D_ANSI_SOURCE=1 -E -x c -Wno-#warnings ' .
    archInt := 42 .
  ] ifFalse:[
  (arch at: 1 equals: 'RISC 6000 (AIX' ) ifTrue:[
    "NOTE:  AIX cpp does not allow C++ style comments beginning with //  .
      /usr/bin/cpp is not the preprocessor built into xlc . 
     Also note: installing gcc on AIX hijacks /usr/bin/cpp and points it to
     /opt/freeware/bin/cpp, which does not work. I've fixed the symlink on rain
     for this but we really need to call /usr/ccs/lib/cpp directly to avoid this
     headache. -- Norm G, 12/24/2020"
    cmd := '/usr/ccs/lib/cpp' .
    (GsFile existsOnServer: cmd ) ifFalse:[
       Error signal: cmd , ' not found,  /usr/ccs/lib/cpp must be installed on host running the gem or topaz -l process'.
    ].
    archInt := 9 .
    cmd := cmd , ' -DAIX=1 '. "amazingly cpp does not predefine 'AIX' "
    (verRpt at: 'osVersion') = '6' ifTrue:[ cmd addAll: ' -DFLG_AIX_VERSION=61 -D__STDC__=1 ']
                  ifFalse:[ cmd addAll: ' -DFLG_AIX_VERSION=71 ' ].
  ]]]].
  cmd ifNotNil:[
    tmpFnames := { } .
    cppArchMType := archInt .
    searchPaths ifNotNil:[:paths | paths do:[:str |
       cmd addAll: ' -I';
           addAll: (str size == 0 ifTrue:[ '.' ] ifFalse:[str]);
            add: $  ""]].
  ].
  ^ cmd
%

category: 'other'
method: CPreprocessor
next

	tokens isEmpty ifTrue: [^nil].
	^tokens removeFirst.
%

category: 'other'
method: CPreprocessor
nextToken
		"This can return nil if there are no more tokens.
		The stream might not be atEnd because of trailing comments."

	| token |
	token := self cPreprocessorTokenSpecies
		nextFrom: readStream
		filename: path
		line: line.
	token ifNotNil: [line := token line].
	^token.
%

category: 'other'
method: CPreprocessor
nextTokenOnLine
		"This can return nil if there are no more tokens.
		The stream might not be atEnd because of trailing comments."

	| token |
	token := self cPreprocessorTokenSpecies
		nextOnCurrentLineFrom: readStream
		filename: path
		line: line.
	token ifNotNil: [line := token line].
	^token.
%

category: 'expression evaluation'
method: CPreprocessor
numberFrom: aString
	"Returns an number literal token"

	| string value isLong isUnsigned |
	isLong := false.
	isUnsigned := false.
	(2 < aString size and: [(aString at: 1) == $0 and: [(aString at: 2) = $x]]) ifTrue: [
		string := '16r' , (aString copyFrom: 3 to: aString size).
	] ifFalse: [
		aString first == $0 ifTrue: [
			string := '8r' , aString.
		] ifFalse: [
			string := aString.
		].
	].
	('lL' includes: string last) ifTrue: [
		isLong := true.
		string := string copyFrom: 1 to: string size - 1.
	].
	('uU' includes: string last) ifTrue: [
		isUnsigned := true.
		string := string copyFrom: 1 to: string size - 1.
		('lL' includes: string last) ifTrue: [
			isLong := true.
			string := string copyFrom: 1 to: string size - 1.
		].
	].
	value := Integer fromString: string.
	(value class ~~ SmallInteger and: [16rFFFFFFFFFFFFFFFF < value]) ifTrue: [
    self error:'problem parsing an Integer near line ', line asString .
  ].
	(isLong or: [16rFFFFFFFF < value]) ifTrue: [
		(isUnsigned or: [16r7FFFFFFFFFFFFFFF < value])
			ifTrue: [^self cPreprocessorTokenSpecies uint64: value]
			ifFalse: [^self cPreprocessorTokenSpecies int64: value].
	].
	16rFFFF < value ifTrue: [
		(isUnsigned or: [16r7FFFFFFF < value])
			ifTrue: [^self cPreprocessorTokenSpecies uint32: value]
			ifFalse: [^self cPreprocessorTokenSpecies int32: value].
	].
	^(isUnsigned or: [16r7FFF < value])
		ifTrue: [self cPreprocessorTokenSpecies uint16: value]
		ifFalse: [self cPreprocessorTokenSpecies int16: value].
%

category: 'expression evaluation'
method: CPreprocessor
numberLiteralKeys

	^#(
		#'int8' #'uint8' #'int16' #'uint16' #'int32' #'uint32' #'int64' #'uint64'
	).
%

category: 'expression evaluation'
method: CPreprocessor
operandFrom: aStream
	"Returns a token"

	| token |
	token := aStream next.
	token key = #'integer' ifTrue: [^token].
	token key = #'number' ifTrue: [^self numberFrom: token value].
	token key = #'defined' ifTrue: [^#'integer' -> (self integerFromBoolean: (definitions includesKey: token value))].
	token key = #'punctuator' ifTrue: [
		token value = '!' ifTrue: [
			token := self operandFrom: aStream.
			token value: (token value == 1 ifTrue: [0] ifFalse: [1]).
			^token.
		].
		token value = '(' ifTrue: [
			| value |
			value := self evaluate: aStream.
			token := aStream next.
			(token key = #'punctuator' and: [token value = ')']) ifTrue:[ ^ #'integer' -> value].
		].
    token error:'Invalid punctuator'.
	].
	token key == #'identifier' ifTrue: [
		| definition |
		definition := definitions
			at: token value
			ifAbsent: [^#'integer' -> 0].
		definition key ifNil: [
			^#'integer' -> (self evaluate: (CPreprocessorStream on: definition value)).
		] ifNotNil: [
			token error:'Invalid identifier'.
		].
	].
	token error:'expected an indentifier'.
%

category: 'expression evaluation'
method: CPreprocessor
parse: aStream
	"Returns a token from a stream of tokens"

	| list stack |
	list := self parseA: aStream.		"Each element is a three-element array: { precedence. operator. operand }"
	stack := { list removeFirst } .
	1 to: list size do: [:i |
		| each |
		each := list at: i.
		[
			stack last first >= each first.
		] whileTrue: [
			self mergeLastTwoElementsIn: stack.
		].
		stack add: each.
	].
	[
		1 < stack size.
	] whileTrue: [
		self mergeLastTwoElementsIn: stack.
	].
	^stack first last.
%

category: 'expression evaluation'
method: CPreprocessor
parseA: aStream
	"Returns a list of the following: { precedence. operator. operand }"

	| list |
	list := { { -999 . '' .  (self parseForOperandFrom: aStream) } }.
	[true] whileTrue: [
		| operator precedence |
		(operator := aStream peek) ifNil: [^list].
		operator key == #'punctuator' ifFalse: [^list].
		(precedence := self precedenceOf: operator value) ifNil: [^list].
		aStream next.
		list add: { precedence .  operator value asSymbol .  (self parseForOperandFrom: aStream) }.
	].
%

category: 'expression evaluation'
method: CPreprocessor
parseForDefinedFrom: aStream

	| token isFunction key found |
	(isFunction := (token := aStream next) isOpenParenthesisToken) ifTrue: [
		token := aStream next.
	].
	token isIdentifierToken ifFalse: [token error:'expected an identifier'].
	key := token value.
	isFunction ifTrue: [(token := aStream next) isCloseParenthesisToken ifFalse: [ token error:'expected '')'' ']].
	found := definitions includesKey: key.
	^found
		ifTrue: [#'int16' -> 1]
		ifFalse: [#'int16' -> 0].
%

category: 'expression evaluation'
method: CPreprocessor
parseForFunction: aString from: aStream

	| token |
	(token := aStream next) isOpenParenthesisToken ifFalse: [ token error:'expected ''('' '].
	aString = 'sizeof' ifTrue: [^self parseForSizeofFrom: aStream].
	self error:'Failed in parseForFunction near line ', line asString .
%

category: 'expression evaluation'
method: CPreprocessor
parseForOperandFrom: aStream
	"Returns an expression token (which is different from a preprocessor token?)"

	| token |
	token := aStream next.
	(self numberLiteralKeys includes: token key) ifTrue: [^token].
	token key == #'integer' 		ifTrue: [^token].
	token key == #'identifier' 		ifTrue: [
		aStream atEnd ifTrue: [^token].
		token isDefinedIdentifierToken ifTrue: [^self parseForDefinedFrom: aStream].
		aStream peek isOpenParenthesisToken ifTrue: [
			^self parseForFunction: token value from: aStream.
		].
		^token.
	].
	token key == #'number' 		ifTrue: [^self numberFrom: token value].
	token key == #'defined' 		ifTrue: [^token].
	token isEmptyToken 			ifTrue: [^token].
	token key == #'character'		ifTrue: [^token].
	token key == #'punctuator' 	ifTrue: [
		token value = '!' 				ifTrue: [
			token := self parseForOperandFrom: aStream.
			^#'not' -> token.
		].
		token value = '-' 				ifTrue: [
			token := self parseForOperandFrom: aStream.
			^#'negate' -> token.
		].
		token value = '(' 				ifTrue: [
			| typeCast endToken |
			(typeCast := self readTypeSpecifierFrom: aStream) ifNil: [
				token := self parse: aStream.
			].
			(endToken := aStream next) isCloseParenthesisToken ifFalse: [endToken error: 'Expected '')'' '].
			typeCast ifNotNil: [
				token := self parseForOperandFrom: aStream.
				token key == typeCast ifTrue: [^token].
				"self halt."
			].
			^token.
		].
	].
	token error: 'unhandled expression token!'.
%

category: 'expression evaluation'
method: CPreprocessor
parseForSizeofFrom: aStream

	| class declaration token |
	class := self cDeclarationSpecies .
	declaration := class header: header.
	(token := aStream next) isCloseParenthesisToken ifFalse: [ token error:'expected '')'' '].
	^#'int32' -> declaration byteSize.
%

category: 'expression evaluation'
method: CPreprocessor
parseForSizeofStructFrom: aList

	| token size aStruct |
	aList size = 2 ifFalse: [ Error signal: 'invalid arg size in parseForSizeofStructFrom'].
	(token := aList at: 2) key == #'identifier' ifFalse: [ token error: 'Expected an identifier'].
	aStruct := header structs at: token value.
  size := aStruct byteSize .
	^self cPreprocessorTokenSpecies int32: size.
%

category: 'other'
method: CPreprocessor
parseString: aString
 ^ self parseString: aString ignoreWarnings: false
%

category: 'directives'
method: CPreprocessor
parseString: aString ignoreWarnings: aBoolean
  | tmpsOfsA tmpsOfsB | 
  [ | cmd |
		(cmd := self nativeCppCmd) ifNotNil:[
			| cppOut cppRes cppErr cppInStr |
			cppInStr := aString .
			(cmd includesString: 'clang') ifTrue:[
				"Darwin clang will not read from stdin"
				| tmpIn |
				tmpIn := '/tmp/cppIn', Random new integer asString , '.s' .
				(GsFile openWriteOnServer: tmpIn ) nextPutAll: aString ; flush ; close.
				cmd := cmd , ' ' , tmpIn .
				cppInStr := nil .
				tmpFnames add: tmpIn  . "for later deletion"
        tmpsOfsA := tmpFnames size .
			].
			cppRes := GsHostProcess _execute: cmd  input: aString .
			cppOut := cppRes at: 1 .
			cppErr := cppRes at: 2 .
			readStream := self _streamOnCppOutput: cppOut .
      tmpsOfsB := tmpFnames size .
			aBoolean ifFalse:[ cppErr size > 0 ifTrue:[
				Error signal: 'non-empty stderr from ',cmd, ', ', cppErr
			]].
		] ifNil: [
			readStream := CPreprocessorStream on: aString.
		].
		line := 1.
		self readTillEnd.
 ] ensure:[
   { tmpsOfsA . tmpsOfsB } do:[:ofs |
     ofs  ifNotNil:[
       [ (tmpFnames atOrNil: ofs) ifNotNil:[:fn | 
           GsFile removeServerFile: fn .
           tmpFnames at: ofs put: nil .
         ]
       ] on: Error do:[:ex | "ignore"].
     ].
   ]
 ]
%

category: 'accessors'
method: CPreprocessor
path
	^ path
%

category: 'other'
method: CPreprocessor
peek

	tokens isEmpty ifTrue: [^nil].
	^tokens first.
%

category: 'expression evaluation'
method: CPreprocessor
precedenceOf: aString
	"Answer a negative number so that * (-3) is GREATER than + (-4) "

	(#('*' '/' '%') includes: aString) 			ifTrue: [^-3].
	(#('+' '-') includes: aString) 				ifTrue: [^-4].
	(#('<<' '>>') includes: aString)			ifTrue: [^-5].
	(#('<' '<=' '>' '>=') includes: aString) 	ifTrue: [^-6].
	(#('==' '!=') includes: aString) 			ifTrue: [^-7].
	'&' = aString									ifTrue: [^-8].
	'^' = aString									ifTrue: [^-9].
	'|' = aString									ifTrue: [^-10].
	'&&' = aString									ifTrue: [^-11].
	'||' = aString									ifTrue: [^-12].
	(#('?' ':') includes: aString) 				ifTrue: [^-13].
	^nil.
%

category: 'other'
method: CPreprocessor
readTillEnd

	| token |
	[
		(token := self nextToken) ~~ nil .
	] whileTrue: [
		self applyToken: token.
	].
%

category: 'expression evaluation'
method: CPreprocessor
readTypeSpecifierFrom: aStream

	| token value signed size |
	(token := aStream peek) key == #'identifier' ifFalse: [^nil].
	value := token value.
	(definitions includesKey: value) ifTrue: [aStream next. ^(definitions at: value) type].
	value = 'struct'		ifTrue: [^nil].
	value = 'void' 			ifTrue: [aStream next. ^aStream peek isStarToken ifTrue: [aStream next. #'ptr'] ifFalse: [#'void']].
	value = 'float' 			ifTrue: [aStream next. ^#'float'		].
	value = '__float128'	ifTrue: [aStream next. ^#'float128'	].
	value = 'double' 		ifTrue: [aStream next. ^#'double'	].
	value = '_Complex' 	ifTrue: [aStream next. ^#'complex'	].		"this essentially means that there are two of something else (https://gcc.gnu.org/onlinedocs/gcc-4.8.0/gcc/Complex.html)"
	(#('signed' 'unsigned') includes: value) ifTrue: [
		signed := value = 'signed'.
		(token := aStream next; peek) key == #'identifier' ifFalse: [token error: 'Expected an identifier'].
		value := token value.
	].
	value = 'char' ifTrue: [
		aStream next.
		^signed == true
		ifTrue: [#'int8']
		ifFalse: [#'uint8'].
	].
	(#('long' 'short') includes: value) ifTrue: [
		size := value.
		(token := aStream next; peek) key == #'identifier' ifFalse: [token error: 'Expected an identifier'].
		value := token value.
	].
	value = 'double' ifTrue: [
		aStream next.
		size = 'long' ifFalse: [token error: 'Unexpected type'].
		^#'longDouble'.
	].
	value = 'int' ifTrue: [
		aStream next.
		^self typeForIntSigned: signed size: size.
	].
	size ifNotNil: [
		^self typeForIntSigned: signed size: size.
	].
	signed ifNotNil: [token error: 'Unexpected type (expected signed == nil) '].
	(signed == nil and: [size == nil ]) ifTrue: [^nil].
	^self
		typeForIntSigned: signed
		size: size.
%

category: 'directives'
method: CPreprocessor
removeCommentsFrom: aString for: aToken

	| string i j |
	string := aString.
	[
		0 < (i := string indexOfSubCollection: '/*' startingAt: 1).
	] whileTrue: [
		j := string indexOfSubCollection: '*/' startingAt: i.
		0 == j ifTrue: [ aToken error: 'Expected end of comment'].
		string := (string copyFrom: 1 to: i - 1) , (string copyFrom: j + 2 to: string size).
	].
	^string.
%

category: 'other'
method: CPreprocessor
searchForInclude: includePath excluding: skipPath
	"Search our searchPaths for file with the given includePath.
   If includePath begins with $/ , our searchPaths is ignored .
	If skipPath is not nil and matches an entry in our searchPaths,
	only search entries after that one.
	If found, answer the full path, if not answer nil."
  | iArg |
  iArg := includePath .
  (iArg includesIdentical: $$ ) ifTrue:[
    iArg := GsFile _expandFilename: iArg isClient: false .
    iArg ifNil:[ Error signal:'invalid environment variable in ''', includePath asString, ''''].
  ].
  (iArg size > 0 and:[ (iArg at: 1) == $/]) ifTrue:[
		(GsFile existsOnServer: iArg) ifTrue:[ ^ iArg ].
  ] ifFalse:[
	  | skipIndex paths blk |
	  skipIndex := skipPath ifNil:[ 0 ] ifNotNil:[ searchPaths indexOf: skipPath ].
    paths := { } .
	  skipIndex + 1 to: searchPaths size do: [:idx | paths add: (searchPaths at: idx)].
    blk := [:str | | aPath fullPath |
      aPath := str .
      aPath size == 0 ifTrue:[ aPath := GsFile serverCurrentDirectory ].
      aPath last == $/ ifFalse:[ aPath := aPath , $/ ].
			fullPath := aPath , iArg.
      (fullPath includesIdentical: $$ ) ifTrue:[
        fullPath := GsFile _expandFilename: fullPath isClient: false .
      ].
			(GsFile existsOnServer: fullPath) ifTrue:[ ^fullPath ] .
    ].
    paths do: blk .
    systemSearchPaths do: blk .
  ].
	^nil
%

category: 'accessors'
method: CPreprocessor
searchPaths
  "Return the list of directories used to search for a file that is the
   argument to includePath: .
   If using the native cpp , does not include the system search paths
   which are also used to search for file specified by #include directives.
   See also  CPreprocessor >> allSearchPaths "

  ^ searchPaths
%

category: 'directives'
method: CPreprocessor
skipWhile: aBlock

	| token |
	[
		token := self nextToken.
		aBlock value: token.
	] whileTrue: [].
	^token.
%

category: 'accessors'
method: CPreprocessor
tokens

	^tokens.
%

category: 'expression evaluation'
method: CPreprocessor
typeForIntSigned: aBooleanOrNil size: aStringOrNil
"
// From Linux, we have the following:
#define __SIZEOF_SHORT__ 2
#define __SIZEOF_INT__ 4
#define __SIZEOF_LONG__ 8
#define __SIZEOF_LONG_LONG__ 8
"
	aStringOrNil = 'long' ifTrue: [
		^aBooleanOrNil == false
			ifTrue: [#'uint64']
			ifFalse: [#'int64'].
	].
	aStringOrNil = 'short' ifTrue: [
		^aBooleanOrNil == false
			ifTrue: [#'uint16']
			ifFalse: [#'int16'].
	].
	^aBooleanOrNil == false
		ifTrue: [#'uint32']
		ifFalse: [#'int32'].
%

category: 'directives'
method: CPreprocessor
undef: defineToken

	| nameToken name lf |
	readStream peek == (lf := Character lf) ifTrue: [ defineToken error: 'unexpected end of line'].
	(nameToken := self nextToken) isIdentifierToken ifFalse: [ nameToken error: 'expected an identifier'].
	readStream peek == lf ifFalse: [ nameToken error:'missing end of line' ].
	name := nameToken value.
  self class _trapDefinition: name  .
	definitions removeKey: name ifAbsent: [].
%

category: 'expression evaluation'
method: CPreprocessor
valueOf: aToken
	"Returns an Integer from a token."
	| x y key val |
	key := aToken key.
	(self numberLiteralKeys includes: key)		ifTrue: [^aToken value].
	key == #'character'	ifTrue: [^aToken value codePoint].
	key == #'empty'		ifTrue: [^0].
	key == #'identifier' 	ifTrue: [ | tokVal defs |
    defs := definitions .
		val := definitions at: (tokVal := aToken value) ifAbsent: [nil].
		val ifNil: [
			header ifNil: [^0].
			^header enums at: aToken value ifAbsent: [0].
		].
		^self evaluate:(CPreprocessorStream on: val)
  ].
	key == #'defined' ifTrue: [^self integerFromBoolean: (definitions includesKey: aToken value)].
	key == #'not'		ifTrue: [^self integerFromBoolean: (self valueOf: aToken value) == 0].
	key == #'negate'	ifTrue: [^(self valueOf: aToken value) negated].
	key == #'&&' 		ifTrue: [
		(self valueOf: (aToken value at: 1)) == 0 ifTrue: [^0].
		^self valueOf: (aToken value at: 2).
	].
	key == #'||' 			ifTrue: [
		(self valueOf: (aToken value at: 1)) == 1 ifTrue: [^1].
		^self valueOf: (aToken value at: 2).
	].
	x := self valueOf: (aToken value at: 1).
	y := self valueOf: (aToken value at: 2).
	key == #'=='	ifTrue: [^self integerFromBoolean: x = y].
	key == #'!='	ifTrue: [^self integerFromBoolean: x ~= y].
	key == #'>='	ifTrue: [^self integerFromBoolean: x >= y].
	key == #'>'		ifTrue: [^self integerFromBoolean: x > y].
	key == #'<'		ifTrue: [^self integerFromBoolean: x < y].
	key == #'<='	ifTrue: [^self integerFromBoolean: x <= y].
	key == #'*'		ifTrue: [^x * y].
	key == #'+'		ifTrue: [^x + y].
	key == #'/'		ifTrue: [^x // y].
	key == #'-'		ifTrue: [^x - y].
	key == #'%'	ifTrue: [^x \\ y].
	key == #'<<'	ifTrue: [^x bitShift: y].
	key == #'>>'	ifTrue: [^x bitShift: y negated].
	key == #'?'		ifTrue: [^x == 1 ifTrue: [y] ifFalse: [nil]].
	key == #':'		ifTrue: [^x ~~ nil ifTrue: [x] ifFalse: [y]].
	key == #'|'		ifTrue: [^x bitOr: y].
	key == #'&'		ifTrue: [^x bitAnd: y].

	aToken error: 'Failed in valueOf:'.
%

category: 'Default Definitions'
method: CPreprocessor
_defaultAix71DefinitionsOld
	"The usual ... echo '' | cpp -dM ... doesn't work on AIX.
	 The AIX equivalent is:
		echo 'int main() { return 0; }' > x.C; /usr/vacpp/bin/xlC_r -qshowmacros -q64 -E x.C
"
	^'
#define _POWER 1
#define _IBMR2 1
#define _AIX71 1
#define _AIX61 1
#define _AIX53 1
#define _AIX52 1
#define _AIX51 1
#define _AIX50 1
#define _AIX43 1
#define _AIX41 1
#define _AIX32 1
#define _AIX 1
#define __VACPP_MULTI__ 1
#define _THREAD_SAFE 1
#define __IBM_INCLUDE_NEXT 1
#define __IBM_MACRO_WITH_VA_ARGS 1
#define __C99_MACRO_WITH_VA_ARGS 1
#define __C99__FUNC__ 1
#define __EXCEPTIONS 1
#define _CPPUNWIND 1
#define __DIGRAPHS__ 1
#define __LONGDOUBLE64 1
#define __IBM__ALIGN 1
#define __ALIGN 1
#define __C99_HEX_FLOAT_CONST 1
#define __IBM_CHAR32_T__ 1
#define __IBM_CHAR16_T__ 1
#define __IBM_ATTRIBUTES 1
#define __IBM_EXTENSION_KEYWORD 1
#define __IBM__TYPEOF__ 1
#define __IBM__ALIGNOF__ 1
#define __C99_PRAGMA_OPERATOR 1
#define __IBM__RESTRICT__ 1
#define __C99_RESTRICT 1
#define __BOOL__ 1
#define __OBJECT_MODEL_CLASSIC__ 1
#define __OBJECT_MODEL_COMPAT__ 1
#define __NO_RTTI__ 1
', "#define defined defined" 	"This seems to break the parser, allowing it to think 'defined' is a type declaration"
'#define __CHAR_UNSIGNED__ 1
#define __IBMCPP_EXTERN_TEMPLATE 1
#define __XPLINK_CALLBACK__ 1
#define __IBM_UTF_LITERAL 1
#define __IBM_LOCAL_LABEL 1
#define __IBM_LABEL_VALUE 1
#define __IBM_COMPUTED_GOTO 1
#define __C99_VARIABLE_LENGTH_ARRAY 1
#define __C99_COMPOUND_LITERAL 1
#define _CHAR_UNSIGNED 1
#define _LONG_LONG 1
#define _ARCH_PPC64 1
#define _ARCH_PPC 1
#define _ARCH_COM 1
#define __IBM_GCC_ASM 1
#define _EXT 1
#define _MI_BUILTIN 1
#define __BASE_FILE__ "x.C"
#define __V6ALIGN__ 1
#define __XLC13__ 1
#define __XLC121__ 1
#define __MATH__ 1
#define __STR__ 1
#define _WCHAR_T 1
#define __TOS_AIX__ 1
#define __THW_RS6000__ 1
#define _LP64 1
#define __64BIT__ 1
#define __ppc__ 1
#define __PPC__ 1
#define __PPC 1
#define __powerpc__ 1
#define __powerpc 1
#define __BIG_ENDIAN__ 1
#define _BIG_ENDIAN 1
#define __THW_PPC__ 1
#define __THW_BIG_ENDIAN__ 1
#define __unix__ 1
#define __unix 1
#define __FUNCTION__ __FUNCTION__
#define __STDC__ 0
#define __xlC_ver__ 0x0000000a
#define __xlC__ 0x0b01
#define __HOS_AIX__ 1
#define __HHW_RS6000__ 1
#define __HHW_BIG_ENDIAN__ 1
#define __IBMCPP__ 1110
#define __cplusplus 199711L
' ,
	"additional defs (some of this looks like rubbish!)"
'
#define FLG_AIX_VERSION 71

#define ptrdiff_t long
#define wchar_t int
#define throw()
#define restrict
#define __restrict
#define __const const
#define __inline inline
#define __inline__ inline
#define __signed signed
#define __volatile
'.
%

category: 'Default Definitions'
method: CPreprocessor
_defaultAix72DefinitionsOld
	"The usual ... echo '' | cpp -dM ... doesn't work on AIX.
	 The AIX equivalent is:
		echo 'int main() { return 0; }' > x.C; /usr/vacpp/bin/xlC_r -qshowmacros -q64 -E x.C
"
	^'
#define _POWER 1
#define _IBMR2 1
#define _AIX72 1
#define _AIX71 1
#define _AIX61 1
#define _AIX53 1
#define _AIX52 1
#define _AIX51 1
#define _AIX50 1
#define _AIX43 1
#define _AIX41 1
#define _AIX32 1
#define _AIX 1
#define __VACPP_MULTI__ 1
#define _THREAD_SAFE 1
#define __IBM_INCLUDE_NEXT 1
#define __IBM_MACRO_WITH_VA_ARGS 1
#define __C99_MACRO_WITH_VA_ARGS 1
#define __C99__FUNC__ 1
#define __EXCEPTIONS 1
#define _CPPUNWIND 1
#define __DIGRAPHS__ 1
#define __LONGDOUBLE64 1
#define __IBM__ALIGN 1
#define __ALIGN 1
#define __C99_HEX_FLOAT_CONST 1
#define __IBM_CHAR32_T__ 1
#define __IBM_CHAR16_T__ 1
#define __IBM_ATTRIBUTES 1
#define __IBM_EXTENSION_KEYWORD 1
#define __IBM__TYPEOF__ 1
#define __IBM__ALIGNOF__ 1
#define __C99_PRAGMA_OPERATOR 1
#define __IBM__RESTRICT__ 1
#define __C99_RESTRICT 1
#define __BOOL__ 1
#define __OBJECT_MODEL_CLASSIC__ 1
#define __OBJECT_MODEL_COMPAT__ 1
#define __NO_RTTI__ 1
', "#define defined defined"    "This seems to break the parser, allowing it to think 'defined' is a type declaration"
'#define __CHAR_UNSIGNED__ 1
#define __IBMCPP_EXTERN_TEMPLATE 1
#define __XPLINK_CALLBACK__ 1
#define __IBM_UTF_LITERAL 1
#define __IBM_LOCAL_LABEL 1
#define __IBM_LABEL_VALUE 1
#define __IBM_COMPUTED_GOTO 1
#define __C99_VARIABLE_LENGTH_ARRAY 1
#define __C99_COMPOUND_LITERAL 1
#define _CHAR_UNSIGNED 1
#define _LONG_LONG 1
#define _ARCH_PPC64 1
#define _ARCH_PPC 1
#define _ARCH_COM 1
#define __IBM_GCC_ASM 1
#define _EXT 1
#define _MI_BUILTIN 1
#define __BASE_FILE__ "x.C"
#define __V6ALIGN__ 1
#define __XLC13__ 1
#define __XLC121__ 1
#define __MATH__ 1
#define __STR__ 1
#define _WCHAR_T 1
#define __TOS_AIX__ 1
#define __THW_RS6000__ 1
#define _LP64 1
#define __64BIT__ 1
#define __ppc__ 1
#define __PPC__ 1
#define __PPC 1
#define __powerpc__ 1
#define __powerpc 1
#define __BIG_ENDIAN__ 1
#define _BIG_ENDIAN 1
#define __THW_PPC__ 1
#define __THW_BIG_ENDIAN__ 1
#define __unix__ 1
#define __unix 1
#define __FUNCTION__ __FUNCTION__
#define __STDC__ 0
#define __xlC_ver__ 0x00000017
#define __xlC__ 0x0b01
#define __HOS_AIX__ 1
#define __HHW_RS6000__ 1
#define __HHW_BIG_ENDIAN__ 1
#define __IBMCPP__ 1110
#define __cplusplus 199711L
' ,
	"additional defs (some of this looks like rubbish!)"
'
#define FLG_AIX_VERSION 72

#define ptrdiff_t long
#define wchar_t int
#define throw()
#define restrict
#define __restrict
#define __const const
#define __inline inline
#define __inline__ inline
#define __signed signed
#define __volatile
'.
%

category: 'Default Definitions'
method: CPreprocessor
_defaultDarwinDefinitionsOld
	"echo '' | cpp -dM
"
	^'
#define OBJC_NEW_PROPERTIES 1
#define _LP64 1
#define __APPLE_CC__ 6000
#define __APPLE__ 1
#define __ATOMIC_ACQUIRE 2
#define __ATOMIC_ACQ_REL 4
#define __ATOMIC_CONSUME 1
#define __ATOMIC_RELAXED 0
#define __ATOMIC_RELEASE 3
#define __ATOMIC_SEQ_CST 5
#define __BLOCKS__ 1
#define __BYTE_ORDER__ __ORDER_LITTLE_ENDIAN__
#define __CHAR16_TYPE__ unsigned short
#define __CHAR32_TYPE__ unsigned int
#define __CHAR_BIT__ 8
#define __CONSTANT_CFSTRINGS__ 1
#define __DBL_DENORM_MIN__ 4.9406564584124654e-324
#define __DBL_DIG__ 15
#define __DBL_EPSILON__ 2.2204460492503131e-16
#define __DBL_HAS_DENORM__ 1
#define __DBL_HAS_INFINITY__ 1
#define __DBL_HAS_QUIET_NAN__ 1
#define __DBL_MANT_DIG__ 53
#define __DBL_MAX_10_EXP__ 308
#define __DBL_MAX_EXP__ 1024
#define __DBL_MAX__ 1.7976931348623157e+308
#define __DBL_MIN_10_EXP__ (-307)
#define __DBL_MIN_EXP__ (-1021)
#define __DBL_MIN__ 2.2250738585072014e-308
#define __DECIMAL_DIG__ 21
#define __DYNAMIC__ 1
#define __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ 1090
#define __FINITE_MATH_ONLY__ 0
#define __FLT_DENORM_MIN__ 1.40129846e-45F
#define __FLT_DIG__ 6
#define __FLT_EPSILON__ 1.19209290e-7F
#define __FLT_EVAL_METHOD__ 0
#define __FLT_HAS_DENORM__ 1
#define __FLT_HAS_INFINITY__ 1
#define __FLT_HAS_QUIET_NAN__ 1
#define __FLT_MANT_DIG__ 24
#define __FLT_MAX_10_EXP__ 38
#define __FLT_MAX_EXP__ 128
#define __FLT_MAX__ 3.40282347e+38F
#define __FLT_MIN_10_EXP__ (-37)
#define __FLT_MIN_EXP__ (-125)
#define __FLT_MIN__ 1.17549435e-38F
#define __FLT_RADIX__ 2
#define __GCC_ATOMIC_BOOL_LOCK_FREE 2
#define __GCC_ATOMIC_CHAR16_T_LOCK_FREE 2
#define __GCC_ATOMIC_CHAR32_T_LOCK_FREE 2
#define __GCC_ATOMIC_CHAR_LOCK_FREE 2
#define __GCC_ATOMIC_INT_LOCK_FREE 2
#define __GCC_ATOMIC_LLONG_LOCK_FREE 2
#define __GCC_ATOMIC_LONG_LOCK_FREE 2
#define __GCC_ATOMIC_POINTER_LOCK_FREE 2
#define __GCC_ATOMIC_SHORT_LOCK_FREE 2
#define __GCC_ATOMIC_TEST_AND_SET_TRUEVAL 1
#define __GCC_ATOMIC_WCHAR_T_LOCK_FREE 2
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_1 1
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_16 1
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_2 1
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_4 1
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_8 1
#define __GNUC_MINOR__ 2
#define __GNUC_PATCHLEVEL__ 1
#define __GNUC_STDC_INLINE__ 1
#define __GNUC__ 4
#define __GXX_ABI_VERSION 1002
#define __GXX_RTTI 1
#define __INT16_TYPE__ short
#define __INT32_TYPE__ int
#define __INT64_C_SUFFIX__ LL
#define __INT64_TYPE__ long long int
#define __INT8_TYPE__ char
#define __INTMAX_MAX__ 9223372036854775807L
#define __INTMAX_TYPE__ long int
#define __INTMAX_WIDTH__ 64
#define __INTPTR_TYPE__ long int
#define __INTPTR_WIDTH__ 64
#define __INT_MAX__ 2147483647
#define __LDBL_DENORM_MIN__ 3.64519953188247460253e-4951L
#define __LDBL_DIG__ 18
#define __LDBL_EPSILON__ 1.08420217248550443401e-19L
#define __LDBL_HAS_DENORM__ 1
#define __LDBL_HAS_INFINITY__ 1
#define __LDBL_HAS_QUIET_NAN__ 1
#define __LDBL_MANT_DIG__ 64
#define __LDBL_MAX_10_EXP__ 4932
#define __LDBL_MAX_EXP__ 16384
#define __LDBL_MAX__ 1.18973149535723176502e+4932L
#define __LDBL_MIN_10_EXP__ (-4931)
#define __LDBL_MIN_EXP__ (-16381)
#define __LDBL_MIN__ 3.36210314311209350626e-4932L
#define __LITTLE_ENDIAN__ 1
#define __LONG_LONG_MAX__ 9223372036854775807LL
#define __LONG_MAX__ 9223372036854775807L
#define __LP64__ 1
#define __MACH__ 1
#define __MMX__ 1
#define __NO_INLINE__ 1
#define __NO_MATH_INLINES 1
#define __ORDER_BIG_ENDIAN__ 4321
#define __ORDER_LITTLE_ENDIAN__ 1234
#define __ORDER_PDP_ENDIAN__ 3412
#define __PIC__ 2
#define __POINTER_WIDTH__ 64
#define __PRAGMA_REDEFINE_EXTNAME 1
#define __PTRDIFF_TYPE__ long int
#define __PTRDIFF_WIDTH__ 64
#define __REGISTER_PREFIX__
#define __SCHAR_MAX__ 127
#define __SHRT_MAX__ 32767
#define __SIG_ATOMIC_WIDTH__ 32
#define __SIZEOF_DOUBLE__ 8
#define __SIZEOF_FLOAT__ 4
#define __SIZEOF_INT128__ 16
#define __SIZEOF_INT__ 4
#define __SIZEOF_LONG_DOUBLE__ 16
#define __SIZEOF_LONG_LONG__ 8
#define __SIZEOF_LONG__ 8
#define __SIZEOF_POINTER__ 8
#define __SIZEOF_PTRDIFF_T__ 8
#define __SIZEOF_SHORT__ 2
#define __SIZEOF_SIZE_T__ 8
#define __SIZEOF_WCHAR_T__ 4
#define __SIZEOF_WINT_T__ 4
#define __SIZE_MAX__ 18446744073709551615UL
#define __SIZE_TYPE__ long unsigned int
#define __SIZE_WIDTH__ 64
#define __SSE2_MATH__ 1
#define __SSE2__ 1
#define __SSE3__ 1
#define __SSE_MATH__ 1
#define __SSE__ 1
#define __SSP__ 1
#define __SSSE3__ 1
#define __STDC_HOSTED__ 1
#define __STDC_UTF_16__ 1
#define __STDC_UTF_32__ 1
#define __STDC_VERSION__ 199901L
#define __UINTMAX_TYPE__ long unsigned int
#define __USER_LABEL_PREFIX__ _
#define __VERSION__ "4.2.1 Compatible Apple LLVM 6.0 (clang-600.0.56)"
#define __WCHAR_MAX__ 2147483647
#define __WCHAR_TYPE__ int
#define __WCHAR_WIDTH__ 32
#define __WINT_TYPE__ int
#define __WINT_WIDTH__ 32
#define __amd64 1
#define __amd64__ 1
#define __apple_build_version__ 6000056
#define __block __attribute__((__blocks__(byref)))
#define __clang__ 1
#define __clang_major__ 6
#define __clang_minor__ 0
#define __clang_patchlevel__ 0
#define __clang_version__ "6.0 (clang-600.0.56)"
#define __core2 1
#define __core2__ 1
#define __llvm__ 1
#define __pic__ 2
#define __strong
#define __tune_core2__ 1
#define __unsafe_unretained
#define __weak __attribute__((objc_gc(weak)))
#define __x86_64 1
#define __x86_64__ 1
' ,
	"additional defs"
'
#define NO_ANSI_KEYWORDS
#define restrict
#define throw()
#define __const const
#define __inline inline
#define __inline__ inline
#define __restrict
#define __signed signed
#define __STDC__
#define __volatile
'
%

category: 'Default Definitions'
method: CPreprocessor
_defaultLinuxDefinitionsOld
"from 3.5 trunk r45820 "
	^'
#define __DBL_MIN_EXP__ (-1021)
#define __FLT_MIN__ 1.17549435e-38F
#define __CHAR_BIT__ 8
#define __WCHAR_MAX__ 2147483647
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_1 1
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_2 1
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_4 1
#define __DBL_DENORM_MIN__ 4.9406564584124654e-324
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_8 1
#define __FLT_EVAL_METHOD__ 0
#define __unix__ 1
#define __x86_64 1
#define __DBL_MIN_10_EXP__ (-307)
#define __FINITE_MATH_ONLY__ 0
#define __GNUC_PATCHLEVEL__ 3
#define __DEC64_MAX_EXP__ 385
#define __SHRT_MAX__ 32767
#define __LDBL_MAX__ 1.18973149535723176502e+4932L
#define __UINTMAX_TYPE__ long unsigned int
#define __linux 1
#define __DEC32_EPSILON__ 1E-6DF
#define __unix 1
#define __LDBL_MAX_EXP__ 16384
#define __linux__ 1
#define __SCHAR_MAX__ 127
#define __DBL_DIG__ 15
#define _FORTIFY_SOURCE 2
#define __SIZEOF_INT__ 4
#define __SIZEOF_POINTER__ 8
#define __USER_LABEL_PREFIX__
#define __STDC_HOSTED__ 1
#define __LDBL_HAS_INFINITY__ 1
#define __FLT_EPSILON__ 1.19209290e-7F
#define __LDBL_MIN__ 3.36210314311209350626e-4932L
#define __DEC32_MAX__ 9.999999E96DF
#define __SIZEOF_LONG__ 8
#define __DECIMAL_DIG__ 21
#define __gnu_linux__ 1
#define __LDBL_HAS_QUIET_NAN__ 1
#define __GNUC__ 4
#define __MMX__ 1
#define __FLT_HAS_DENORM__ 1
#define __SIZEOF_LONG_DOUBLE__ 16
#define __BIGGEST_ALIGNMENT__ 16
#define __DBL_MAX__ 1.7976931348623157e+308
#define __DBL_HAS_INFINITY__ 1
#define __DEC32_MIN_EXP__ (-94)
#define __LDBL_HAS_DENORM__ 1
#define __DEC128_MAX__ 9.999999999999999999999999999999999E6144DL
#define __DEC32_MIN__ 1E-95DF
#define __DBL_MAX_EXP__ 1024
#define __DEC128_EPSILON__ 1E-33DL
#define __SSE2_MATH__ 1
#define __amd64 1
#define __LONG_LONG_MAX__ 9223372036854775807LL
#define __SIZEOF_SIZE_T__ 8
#define __SIZEOF_WINT_T__ 4
#define __GCC_HAVE_DWARF2_CFI_ASM 1
#define __GXX_ABI_VERSION 1002
#define __FLT_MIN_EXP__ (-125)
#define __DBL_MIN__ 2.2250738585072014e-308
#define __LP64__ 1
#define __DECIMAL_BID_FORMAT__ 1
#define __DEC128_MIN__ 1E-6143DL
#define __REGISTER_PREFIX__
#define __DBL_HAS_DENORM__ 1
#define __NO_INLINE__ 1
#define __FLT_MANT_DIG__ 24
#define __VERSION__ "4.4.3"
#define __DEC64_EPSILON__ 1E-15DD
#define __DEC128_MIN_EXP__ (-6142)
#define unix 1
#define __SIZE_TYPE__ long unsigned int
#define __ELF__ 1
#define __FLT_RADIX__ 2
#define __LDBL_EPSILON__ 1.08420217248550443401e-19L
#define __SSE_MATH__ 1
#define __k8 1
#define __SIZEOF_PTRDIFF_T__ 8
#define __x86_64__ 1
#define __DEC32_SUBNORMAL_MIN__ 0.000001E-95DF
#define __FLT_HAS_QUIET_NAN__ 1
#define __FLT_MAX_10_EXP__ 38
#define __LONG_MAX__ 9223372036854775807L
#define __DEC128_SUBNORMAL_MIN__ 0.000000000000000000000000000000001E-6143DL
#define __FLT_HAS_INFINITY__ 1
#define __DEC64_MAX__ 9.999999999999999E384DD
#define __CHAR16_TYPE__ short unsigned int
#define __DEC64_MANT_DIG__ 16
#define __DEC32_MAX_EXP__ 97
#define linux 1
#define __SSE2__ 1
#define __LDBL_MANT_DIG__ 64
#define __DBL_HAS_QUIET_NAN__ 1
#define __k8__ 1
#define __WCHAR_TYPE__ int
#define __SIZEOF_FLOAT__ 4
#define __DEC64_MIN_EXP__ (-382)
#define __FLT_DIG__ 6
#define __INT_MAX__ 2147483647
#define __amd64__ 1
#define __FLT_MAX_EXP__ 128
#define __DBL_MANT_DIG__ 53
#define __DEC64_MIN__ 1E-383DD
#define __WINT_TYPE__ unsigned int
#define __SIZEOF_SHORT__ 2
#define __SSE__ 1
#define __LDBL_MIN_EXP__ (-16381)
#define __SSP__ 1
#define __LDBL_MAX_10_EXP__ 4932
#define __DBL_EPSILON__ 2.2204460492503131e-16
#define _LP64 1
#define __SIZEOF_WCHAR_T__ 4
#define __DEC_EVAL_METHOD__ 2
#define __INTMAX_MAX__ 9223372036854775807L
#define __FLT_DENORM_MIN__ 1.40129846e-45F
#define __CHAR32_TYPE__ unsigned int
#define __FLT_MAX__ 3.40282347e+38F
#define __SIZEOF_DOUBLE__ 8
#define __FLT_MIN_10_EXP__ (-37)
#define __INTMAX_TYPE__ long int
#define __DEC128_MAX_EXP__ 6145
#define __GNUC_MINOR__ 4
#define __DEC32_MANT_DIG__ 7
#define __DBL_MAX_10_EXP__ 308
#define __LDBL_DENORM_MIN__ 3.64519953188247460253e-4951L
#define __STDC__ 1
#define __PTRDIFF_TYPE__ long int
#define __DEC64_SUBNORMAL_MIN__ 0.000000000000001E-383DD
#define __DEC128_MANT_DIG__ 34
#define __LDBL_MIN_10_EXP__ (-4931)
#define __SIZEOF_LONG_LONG__ 8
#define __LDBL_DIG__ 18
#define __GNUC_GNU_INLINE__ 1
' ,
	"additional defs"
'
#define ptrdiff_t long
#define restrict
#define size_t unsigned long
#define wchar_t int
#define throw()
#define _XOPEN_SOURCE 1
#define __const const
#define __cplusplus
#define __inline inline
#define __inline__ inline
#define __restrict
#define __signed signed
#define __volatile
#define _BSD_SOURCE 1
#define _SIZE_T
#define __GNUG__
'
%

category: 'other'
method: CPreprocessor
_init
| str |
str := self defaultLinuxDefinitions .
definitions := KeyValueDictionary new .
tokens := { } .
self _parseStringNoCpp: str .
^ self
%

category: 'Private'
method: CPreprocessor
_initializePaths
	| list |
  self nativeCppCmd .
	list := { '' }.
	(path ~~ nil and: [path first == $$ ]) ifTrue: [list add: self directory].
  cppArchMType ifNil:[  "not using native cpp"
	  list add: '/usr/include/'; add: '/usr/local/include/' .
    systemSearchPaths := { } .
  ] ifNotNil:[
    systemSearchPaths := { '/usr/include/' . '/usr/local/include/' }.
    (cppArchMType == 50 or:[ cppArchMType == 52]) 
     ifTrue:[ systemSearchPaths add: '/usr/include/linux' ].
  ].
  searchPaths := list .
%

category: 'Private'
method: CPreprocessor
_parseStringNoCpp: aString
  readStream := CPreprocessorStream on: aString.
  line := 1.
  self readTillEnd.
%

category: 'Private'
method: CPreprocessor
_removeDefinition: aName
  self class _trapDefinition: aName  .
	^ definitions removeKey: aName.
%

category: 'Private'
method: CPreprocessor
_streamOnCppOutput: aString
  | strm tmpOut |
  "write stdout of cpp to a file for use in debugging the preprocessor."
  tmpOut := '/tmp/cppOut', Random new integer asString , '.s' .
  (GsFile openWriteOnServer: tmpOut ) nextPutAll: aString ; flush ; close.
  tmpFnames add: tmpOut  . "for later deletion"

  (strm := CPreprocessorStream on: aString )
    cppArchMType:  cppArchMType; file: path ; line: 1 .
  ^ strm .
%

! Class implementation for 'CPreprocessorToken'

!		Class methods for 'CPreprocessorToken'

category: 'other'
classmethod: CPreprocessorToken
args: anArray
	| res |
	(res := self basicNew) initializeArgs: anArray .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
concatenation
	| res |
	(res := self basicNew) initializeConcatenation .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
define: aString
	| res |
	(res := self basicNew) initializeDefine: aString .
    ^ res
%

category: 'other'
classmethod: CPreprocessorToken
directive: aString
	| res |
	(res := self basicNew) initializeDirective: aString .
    ^ res
%

category: 'other'
classmethod: CPreprocessorToken
empty
	| res |
	(res := self basicNew) initializeEmpty .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
identifier: aString
	| res |
	(res := self basicNew) initializeIdentifier: aString .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
int16: anInteger
	| res |
	(res := self basicNew ) initializeInt16: anInteger .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
int32: anInteger
	| res |
	(res := self basicNew) initializeInt32: anInteger .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
int64: anInteger
	| res |
	(res := self basicNew) initializeInt64: anInteger .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
nextFrom: aStream filename: aString line: anInteger
	"Note that this might return nil if no more tokens!"

	^self
		nextFrom: aStream
		filename: aString
		line: anInteger
		onOneLogicalLine: false
%

category: 'other'
classmethod: CPreprocessorToken
nextFrom: aStream filename: aString line: anInteger onOneLogicalLine: aBoolean
	"Note that this might return nil if no more tokens!"

	^self basicNew
		initializeStream: aStream
		filename: aString
		line: anInteger
		singleLogicalLine: aBoolean
%

category: 'other'
classmethod: CPreprocessorToken
nextOnCurrentLineFrom: aStream filename: aString line: anInteger
	"Note that this might return nil if no more tokens!"

	^self
		nextFrom: aStream
		filename: aString
		line: anInteger
		onOneLogicalLine: true
%

category: 'other'
classmethod: CPreprocessorToken
number: aNumber
	| res |
	(res := self basicNew) initializeNumber: aNumber .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
punctuator: aString
	| res |
	(res := self basicNew) initializePunctuator: aString .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
string: aString
	| res |
	(res := self basicNew) initializeString: aString .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
uint16: anInteger
	| res |
	(res := self basicNew) initializeUInt16: anInteger .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
uint32: anInteger
	| res |
	(res := self basicNew) initializeUInt32: anInteger .
	^ res
%

category: 'other'
classmethod: CPreprocessorToken
uint64: anInteger
	| res |
	(res := self basicNew) initializeUInt64: anInteger.
	^ res
%

!		Instance methods for 'CPreprocessorToken'

category: 'private'
method: CPreprocessorToken
addToSource: aString
 "(SessionTemps current at: #TraceCpp otherwise: nil) ifNotNil:[ :t |
    GsFile gciLogServer:'cpp add: ', aString printString .
    t == 2 ifTrue:[ self pause ].
  ]. "
  source add: aString .
  ^ aString .
%

category: 'other'
method: CPreprocessorToken
asAssociation
	"To facilitate automated tests"
	^type -> value.
%

category: 'other'
method: CPreprocessorToken
collectOriginalFrom: aList

	| string |
	string := String new.
	aList do: [:each | string add: each source].
	source := string.
%

category: 'other'
method: CPreprocessorToken
concatenate: aToken

	value add: aToken source trimSeparators.
%

category: 'Initializing'
method: CPreprocessorToken
defineParameters: parametersArray expansionTokens: expansionTokens

	| expansionArray i j string |
	type := #'define'.
	parametersArray ifNil: [
		value := expansionTokens
			inject: String new
			into: [:priorString :token | priorString add: token source; yourself].
		^self.
	].
	expansionArray := {}.
	string := String new.
	expansionTokens do: [:each |
		(each isIdentifierToken and: [0 < (i := parametersArray indexOf: each value)]) ifTrue: [
			j := each source indexOfSubCollection: each value startingAt: 1.
			1 < j ifTrue: [string add: (each source copyFrom: 1 to: j - 1)].
			expansionArray add: string; add: i.
			string := String new.
			j + each value size - 1 < each source size ifTrue: [string add: (each source copyFrom: j + each value size to: each source size)].
		] ifFalse: [
			string add: each source.
		].
	].
	expansionArray add: string.
	value := expansionArray.
%

category: 'Errors'
method: CPreprocessorToken
error: aString

  "aString is typically of the form 'Expected semicolon ...' "

  Error signal: (aString , ', found ''' , self printString , '''', self positionString)
%

category: 'other'
method: CPreprocessorToken
expandArguments: arguments

	| string |
	string := String new.
	value do: [:each1 |
		(each1 isKindOf: Integer) ifTrue: [	"substitution"
			| flag |
			flag := string isEmpty or: [
				(string notEmpty and: [string last ~~ $#]) or: [
				2 < string size and: [(string copyFrom: string size - 1 to: string size) = '##']]].
			flag  ifTrue: [	"simple case"
				string add: (arguments at: each1).
			] ifFalse: [		"# macro preprocessing operator creates a string"
				string at: string size put: $".		"replace the # token with the start of a string"
				(arguments at: each1) trimSeparators do: [:each2 |
					('\"' includes: each2) ifTrue: [string add: $\].
					string add: each2.
				].
				string add: $".
			].
		] ifFalse: [
			string add: each1.
		].
	].
	^string
%

category: 'Accessing'
method: CPreprocessorToken
file

	^file.
%

category: 'Reading'
method: CPreprocessorToken
hexCharacterFrom: aStream
	"Enter with pointing to 'x' of '\0xhh'"

	| string |
	string := String withAll: '16r0'.
	[true] whileTrue: [
		| char |
		char := self peekFrom: aStream.
		(string size < 6 and: [char isAlphaNumeric]) ifFalse: [
			value add: (Character codePoint: (Integer fromString: string)).
			^self.
		].
		string add: char.
		self addToSource: aStream next.
	].
%

category: 'Initializing'
method: CPreprocessorToken
initializeArgs: anArray

	type := #'args'.
	value := anArray.
%

category: 'Initializing'
method: CPreprocessorToken
initializeConcatenation

	type := #'concatenation'.
%

category: 'Initializing'
method: CPreprocessorToken
initializeDefine: aString

	type := #'define'.
	value := aString.
%

category: 'Initializing'
method: CPreprocessorToken
initializeDirective: aString

	type := #'directive'.
	value := aString.
%

category: 'Initializing'
method: CPreprocessorToken
initializeEmpty

	type := #'empty'.
%

category: 'Initializing'
method: CPreprocessorToken
initializeIdentifier: aString

	type := #'identifier'.
	value := aString.
%

category: 'Initializing'
method: CPreprocessorToken
initializeInt16: anInteger

	type := #'int16'.
	value := anInteger.
%

category: 'Initializing'
method: CPreprocessorToken
initializeInt32: anInteger

	type := #'int32'.
	value := anInteger.
%

category: 'Initializing'
method: CPreprocessorToken
initializeInt64: anInteger

	type := #'int64'.
	value := anInteger.
%

category: 'Initializing'
method: CPreprocessorToken
initializeNumber: aNumber

	type := #'number'.
	value := aNumber.
%

category: 'Initializing'
method: CPreprocessorToken
initializePunctuator: aString

	type := #'punctuator'.
	value := aString.
%

category: 'Initializing'
method: CPreprocessorToken
initializeStream: aStream filename: aString line: anInteger singleLogicalLine: aBoolean
		"The return value from the class-side method will be what this method returns, not always a new object"
	| isBeginningOfLine char1 char2 |
	file := aStream file ifNil:[ aString ].
  stream := aStream . "save for debugging"
	line := anInteger.
  cppMType := aStream cppArchMType ifNil:[ 0 ] .
	source := String new.
  startCommentOffset := aStream position max: 1 .
  cppMType ~~ 0 ifTrue:[ (self skipCppDebugInfo: aStream ) ifNil:[ ^ nil ]].
	isBeginningOfLine := self isBeginningOfLineFor: aStream.
	aBoolean
		ifTrue: [self skipSingleLogicalLineCommentsInStream: aStream ifNothingFound: [^nil]]
		ifFalse:[ self skipMultipleBlankLinesAndCommentsInStream: aStream].
  startOffset := aStream position .
  (char1 := self peekFrom: aStream) == nil  ifTrue: [^nil].
	char2 := aStream peek2.

	(char1 == $L and: [char2 == $']) ifTrue: [self readWideCharacterFrom: aStream] ifFalse: [
	(char1 == $L and: [char2 == $"]) ifTrue: [self readWideStringFrom: aStream] ifFalse: [
	char1 isLetter	ifTrue: [	self readIdentifierFrom: aStream] ifFalse: [
	char1 == $_	ifTrue: [	self readIdentifierFrom: aStream] ifFalse: [
	char1 == $" 	ifTrue: [	self readStringFrom: aStream] ifFalse: [
	char1 == $' 	ifTrue: [	self readCharacterFrom: aStream] ifFalse: [
  char1 == $#   ifTrue: [ self readHashFrom: aStream isBeginningOfLine: isBeginningOfLine]
               ifFalse: [
  char1 isDigit   ifTrue: [ self readNumberFrom: aStream] ifFalse: [
                  self readPunctuatorFrom: aStream]]]]]]]].
	"Include trailing comments starting on this line with the source for this token"
	self skipCommentsIn: aStream.
  endOffset := aStream position .
  aStream debug ifNotNil:[
    debugBytes := aStream collection copyFrom: startCommentOffset to: endOffset - 1 .
  ].
%

category: 'Initializing'
method: CPreprocessorToken
initializeString: aString

	type := #'string'.
	value := aString.
%

category: 'Initializing'
method: CPreprocessorToken
initializeUInt16: anInteger

	type := #'uint16'.
	value := anInteger.
%

category: 'Initializing'
method: CPreprocessorToken
initializeUInt32: anInteger

	type := #'uint32'.
	value := anInteger.
%

category: 'Initializing'
method: CPreprocessorToken
initializeUInt64: anInteger

	type := #'uint64'.
	value := anInteger.
%

category: 'Testing'
method: CPreprocessorToken
isAttributeIdentifierToken

	^type == #'identifier' and: [value = '__attribute__'].
%

category: 'other'
method: CPreprocessorToken
isBeginningOfLineFor: aStream

	aStream atBeginning ifTrue: [^true].
	^aStream peek == Character lf.
%

category: 'Testing'
method: CPreprocessorToken
isCloseAngleBracketToken

	^type == #'punctuator' and: [value = '>'].
%

category: 'Testing'
method: CPreprocessorToken
isCloseCurlyBracketToken

	^type == #'punctuator' and: [value = '}'].
%

category: 'Testing'
method: CPreprocessorToken
isCloseParenthesisToken

	^type == #'punctuator' and: [value = ')'].
%

category: 'Testing'
method: CPreprocessorToken
isCloseSquareBracketToken

	^type == #'punctuator' and: [value = ']'].
%

category: 'Testing'
method: CPreprocessorToken
isColonToken
  | res |
	 res := type == #'punctuator' and: [value = ':'].
  ^ res
%

category: 'Testing'
method: CPreprocessorToken
isCommaToken

	^type == #'punctuator' and: [value = ','].
%

category: 'Testing'
method: CPreprocessorToken
isConcatenationToken

	^type == #'concatenation'.
%

category: 'Testing'
method: CPreprocessorToken
isConditionalBeginDirective

	| list |
	list := #('if' 'ifdef' 'ifndef').
	^type == #'directive' and: [list includes: value].
%

category: 'Testing'
method: CPreprocessorToken
isConditionalDirective

	| list |
	list := #('if' 'else' 'endif' 'ifdef' 'ifndef' 'elif').
	^type == #'directive' and: [list includes: value].
%

category: 'Testing'
method: CPreprocessorToken
isConditionalEndDirective

	| list |
	list := #('else' 'endif' 'elif').
	^type == #'directive' and: [list includes: value].
%

category: 'Testing'
method: CPreprocessorToken
isDefinedIdentifierToken

	^type == #'identifier' and: [value = 'defined'].
%

category: 'Testing'
method: CPreprocessorToken
isDirectiveToken

	^type == #'directive'.
%

category: 'Testing'
method: CPreprocessorToken
isDotToken

	^type == #'punctuator' and: [value = '.'].
%

category: 'Testing'
method: CPreprocessorToken
isEmptyToken

	^type == #'empty'.
%

category: 'Testing'
method: CPreprocessorToken
isEndifDirective

	^type == #'directive' and: [value = 'endif'].
%

category: 'Testing'
method: CPreprocessorToken
isEqualsToken

	^type == #'punctuator' and: [value = '='].
%

category: 'Testing'
method: CPreprocessorToken
isExtensionIdentifierToken

	^type == #'identifier' and: [value = '__extension__'].
%

category: 'Testing'
method: CPreprocessorToken
isFunctionLikeMacroDefinition

	^type == #'define' and: [value isKindOf: Array].
%

category: 'Testing'
method: CPreprocessorToken
isHashToken

	^type == #'punctuator' and: [value = '#'].
%

category: 'Testing'
method: CPreprocessorToken
isIdentifierToken

	^type == #'identifier'.
%

category: 'Testing'
method: CPreprocessorToken
isIntegerToken

	^#(#int16 #int32) includes: type
%

category: 'Testing'
method: CPreprocessorToken
isOpenAngleBracketToken

	^type == #'punctuator' and: [value = '<'].
%

category: 'Testing'
method: CPreprocessorToken
isOpenCurlyBracketToken

	^type == #'punctuator' and: [value = '{'].
%

category: 'Testing'
method: CPreprocessorToken
isOpenParenthesisToken

	^type == #'punctuator' and: [value = '('].
%

category: 'Testing'
method: CPreprocessorToken
isOpenSquareBracketToken

	^type == #'punctuator' and: [value = '['].
%

category: 'Testing'
method: CPreprocessorToken
isPublicIdentifierToken

	^type == #'identifier' and: [value = 'public'].
%

category: 'Testing'
method: CPreprocessorToken
isPunctuatorToken

	^type == #'punctuator'.
%

category: 'Testing'
method: CPreprocessorToken
isReservedWord

	^#(
		'__float128'
		'_Complex'
		'auto'
		'break'
		'case'
		'char'
		'const'
		'continue'
		'default'
		'do'
		'double'
		'else'
		'entry'
		'extern'
		'float'
		'for'
		'goto'
		'if'
		'int'
		'enum'
		'long'
		'register'
		'return'
		'short'
		'signed'
		"'sizeof'"		"this should be followed by a parenthesis"
		'static'
		'struct'
		'switch'
		'typedef'
		'union'
		'unsigned'
		'void'
		'volatile'
		'while'
	) includes: value.
%

category: 'Testing'
method: CPreprocessorToken
isSemicolonToken

	^type == #'punctuator' and: [value = ';'].
%

category: 'Testing'
method: CPreprocessorToken
isStarToken

	^type == #'punctuator' and: [value = '*'].
%

category: 'Testing'
method: CPreprocessorToken
isStringToken

	^type == #'string'.
%

category: 'Testing'
method: CPreprocessorToken
isStructIdentifierToken

	^type == #'identifier' and: [value = 'struct'].
%

category: 'Testing'
method: CPreprocessorToken
isTildeToken

	^type == #'punctuator' and: [value = '~'].
%

category: 'Testing'
method: CPreprocessorToken
isUpArrowToken

	^type == #'punctuator' and: [value = '^'].
%

category: 'other'
method: CPreprocessorToken
key

	^type.
%

category: 'Accessing'
method: CPreprocessorToken
line

	^ line
%

category: 'Reading'
method: CPreprocessorToken
octalCharacterFrom: aStream
	"Enter with pointing to '0' of '\0ooo'"

	| string |
	string := String withAll: '8r0'.
	[true] whileTrue: [
		| char |
		char := self peekFrom: aStream.
		(string size < 6 and: [char isDigit]) ifFalse: [
			value add: (Character codePoint: (Integer fromString: string)).
			^self.
		].
		string add: char.
		self addToSource: aStream next.
	].
%

category: 'Accessing'
method: CPreprocessorToken
peek
	"In order to distinguish a function-like macro definition from
	an object-like macro definition that begins with an open parenthesis,
	we need to know if there was any whitespace after the identifier.

	# define foo(bar)		/* a function-like macro */
	# define foo (bar)	/* an object-like macro */
"
	^peek
%

category: 'other'
method: CPreprocessorToken
peekFrom: aStream
	"Give back the next non-mergeLine token; does not skip whitespace, does not skip comments"

	| char1 char2 char3 lf cr |
	(char1 := aStream peek) == nil  ifTrue:[ ^ nil ].
	char1 == $\ ifFalse: [^char1].
	(char2 := aStream peek2) == nil  ifTrue:[ ^ $\  ].
	lf := Character lf .
	cr := Character cr .
	(char2 == cr or: [char2 == lf]) ifFalse:[ ^ $\ ].
	"$\ was followed by CR or LF"
	source
		add: aStream next;
		add: aStream next.
	(char3 := aStream peek) == nil  ifTrue: [^nil].
	(char2 ~~ char3 and: [char3 == cr or: [char3 == lf]]) ifFalse: [^char3].
	^self peekFrom: aStream.
%

category: 'Printing'
method: CPreprocessorToken
positionString
  | str |
  (str := ' at line ' copy)
    add: line asString ;
    add: ' in file ' ; add: file asString .
  ^ str
%

category: 'other'
method: CPreprocessorToken
printOn: aStream

	(source == nil  or: [source isEmpty]) ifTrue: [
		type printOn: aStream.
		aStream nextPutAll: ' -> '.
		value printOn: aStream.
	] ifFalse: [
		aStream nextPutAll: source.
	].
%

category: 'Reading'
method: CPreprocessorToken
readCharacterFrom: aStream

	type := #'uint8'.
	self
		readLiteralUpTo: $'
		from: aStream.
	255 < (value := value first codePoint) ifTrue: [self error: 'Should be wide character!'].
%

category: 'other'
method: CPreprocessorToken
readDebugFileNameFrom: aStream
  | ch fn lf |
  fn := String new .
  lf := Character lf .
  [ ch := aStream peek .
    ch == $" or:[ch == lf]
  ] whileFalse:[
    aStream next
  ].
  ch == lf ifTrue:[ ^ fn ].
  aStream next . "consume double quote char"
  [ | endOfFn |
    ch := aStream next .
    (endOfFn := ch == $" or:[ ch == lf]) ifFalse:[ fn add: ch ].
    endOfFn
  ] whileFalse .
  aStream file: fn .
  ^ fn
%

category: 'other'
method: CPreprocessorToken
readDebugLineNumberFrom: aStream
  | ch n zeroCp |
  n := 0 .
  zeroCp := $0 codePoint .
  [ ch := aStream peek .
    (ch >= $0 and:[ ch <= $9 ])
  ] whileTrue:[
    n := (n * 10) + (ch codePoint - zeroCp) .
    aStream next
  ].
  aStream line: n .
  ^ n
%

category: 'Reading'
method: CPreprocessorToken
readHashFrom: aStream isBeginningOfLine: aBoolean
	| char |
	self addToSource: aStream next.	"$#"
	(char := self peekFrom: aStream) == $# ifTrue: [	"## means to merge adjacent tokens"
		self addToSource: aStream next.
		type := #'concatenation'.
		^self.
	].
	aBoolean ifFalse: [
		type := #'punctuator'.
		value := '#'.
		^self.
	].
	self
		skipCommentsIn: aStream;
		readIdentifierFrom: aStream .
	type := #'directive'.
	value isEmpty ifTrue: [self error: 'Missing preprocessor directive'].
%

category: 'Reading'
method: CPreprocessorToken
readIdentifierFrom: aStream

	|  char |
	type := #'identifier'.
	value := String new.
	[
		char := self peekFrom: aStream.
		char ~~ nil  and: [char isAlphaNumeric or: [char == $_ or: [char == $: and: [aStream peek2 == $: or: [value last == $:]]]]].
	] whileTrue: [
		value add: aStream next.
	].
	peek := aStream peek.		"Curious to know if it is an open parenthesis"
	self addToSource: value.
%

category: 'Reading'
method: CPreprocessorToken
readLiteralUpTo: aCharacter from: aStream

	| char lf |
	self addToSource: aStream next.	"The open quote character"
	value := String new.
  lf := Character lf .
	[
		(char := aStream next) == lf ifTrue: [self error: 'End of literal not found on current line!'].
		self addToSource: char.
		char = aCharacter.
	] whileFalse: [
		char == $\ ifTrue: [
			self addToSource: (char := aStream next).
			char == $a 	ifTrue: [value add: (Character codePoint: 7	)	] ifFalse: [		"\a 	= alert, <Ctrl>+<G>"
			char == $b 	ifTrue: [value add: (Character codePoint: 8	)	] ifFalse: [		"\b 	= backspace, <Ctrl>+<H>"
			char == $f	ifTrue: [value add: (Character codePoint: 12	)	] ifFalse: [		"\f 	= form feed, <Ctrl>+<L>"
			char == $n	ifTrue: [value add: (Character codePoint: 13	)	] ifFalse: [		"\n 	= new line, <Ctrl>+<M>"
			char == $r	ifTrue: [value add: (Character codePoint: 10	)	] ifFalse: [		"\r 	= carriage return, <Ctrl>+<J>"
			char == $t	ifTrue: [value add: (Character codePoint: 9	)	] ifFalse: [		"\t 	= horizontal tab, <Ctrl>+<I>"
			char == $v	ifTrue: [value add: (Character codePoint: 11	)	] ifFalse: [		"\v 	= vertical tab, <Ctrl>+<K>"
			char == $x	ifTrue: [self hexCharacterFrom: aStream			] ifFalse: [		"\xdd = hex number"
			char == $0	ifTrue: [self octalCharacterFrom: aStream		] ifFalse: [		"\0ddd	= octal number"
			char == $'	ifTrue: [value add: char									] ifFalse: [		"\'		= single quote"
			char == $"	ifTrue: [value add: char									] ifFalse: [		"""		= double quote"
			char == $?	ifTrue: [value add: char									] ifFalse: [		"?		= question mark"
			char == $\	ifTrue: [value add: char									] ifFalse: [		"\\		= single backslash"
			]]]]]]]]]]]]].
		] ifFalse: [
			value add: char.
		].
	].
%

category: 'Reading'
method: CPreprocessorToken
readNumberFrom: aStream
"A preprocessing number has a rather bizarre definition. The category includes all the
normal integer and floating point constants one expects of C, but also a number of other
things one might not initially recognize as a number. Formally, preprocessing numbers begin
with an optional period, a required decimal digit, and then continue with any sequence of
letters, digits, underscores, periods, and exponents.
Exponents are the two-character sequences `e+', `e-', `E+', `E-', `p+', `p-', `P+', and `P-'.
(The exponents that begin with `p' or `P' are new to C99.
They are used for hexadecimal floating-point constants.)"

	| char string isLong isUnsigned |
	type := #'number'.
	value := String with: (self addToSource: aStream next).
	[
		aStream atEnd not and: [
			char := self peekFrom: aStream.
			char isAlphaNumeric or: [char == $. or: [char == $_ or: [(char == $+ or: [char == $-]) and: ['eEpP' includes: value last]]]].
		].
	] whileTrue: [
		value add: (self addToSource: aStream next).
	].
	isLong := false.
	isUnsigned := false.
	(2 < value size and: [(value at: 1) == $0 and: [(value at: 2) == $x ]]) ifTrue: [
		string := '16r' , (value copyFrom: 3 to: value size).
	] ifFalse: [
		value first == $0 ifTrue: [
			string := '8r' , value.
		] ifFalse: [
			string := value.
		].
	].
	('lL' includes: string last) ifTrue: [
		isLong := true.
		string := string copyFrom: 1 to: string size - 1.
	].
	('uU' includes: string last) ifTrue: [
		isUnsigned := true.
		string := string copyFrom: 1 to: string size - 1.
		('lL' includes: string last) ifTrue: [
			isLong := true.
			string := string copyFrom: 1 to: string size - 1.
		].
	].
	value := Integer fromString: string.
	(value class ~~ SmallInteger and: [16rFFFFFFFFFFFFFFFF < value]) ifTrue:[
     self error:'constant exceeds 64 bit unsigned integer'.
  ].
	type := (isLong or: [16rFFFFFFFF < value]) ifTrue: [
		(isUnsigned or: [16r7FFFFFFFFFFFFFFF < value])
			ifTrue: [#'uint64']
			ifFalse: [#'int64'].
	] ifFalse: [
		16rFFFF < value ifTrue: [
			(isUnsigned or: [16r7FFFFFFF < value])
				ifTrue: [#'uint32']
				ifFalse: [#'int32'].
		] ifFalse: [
			(isUnsigned or: [16r7FFF < value])
				ifTrue: [#'uint16']
				ifFalse: [#'int16'].
		].
	].
%

category: 'Reading'
method: CPreprocessorToken
readPunctuatorFrom: aStream

	| char1 char2 char3 twoChars threeChars |
	type := #'punctuator'.
	self addToSource: (char1 := aStream next).
	value := String with: char1.
	(char2 := aStream peek) == nil  ifTrue: [^self].
	(char3 := aStream peek2) == nil  ifTrue: [
		(twoChars := value copy) add: char2 .
	] ifFalse: [
		(twoChars := value copy) add: char2 .
		(threeChars := twoChars copy) add: char3 .
	].
	(#('<<=' '>>=' '->*') includes: threeChars) ifTrue: [
		value := threeChars.
		self addToSource: char2; add: char3.
		aStream next; next.
		^self.
	].
	(#('++' '--' '==' '!=' '<=' '>=' '&&' '||' '<<' '>>' '+=' '-=' '*=' '/=' '%=' '&=' '|=' '^=' '->' '.*' '::') includes: twoChars) ifTrue: [
		value := twoChars.
		self addToSource: char2.
		aStream next.
	].
%

category: 'Reading'
method: CPreprocessorToken
readStringFrom: aStream

	type := #'string'.
	self
		readLiteralUpTo: $"
		from: aStream.
%

category: 'Reading'
method: CPreprocessorToken
readWideCharacterFrom: aStream
		"#define __WCHAR_MAX__ 2147483647"

	(self addToSource: aStream next) == $L ifFalse: [self error: 'How did we get here!?'].
	type := #'int32'.
	self
		readLiteralUpTo: $'
		from: aStream.
	16r7FFFFFFF < (value := value first codePoint) ifTrue: [self error: 'Should be wide character!'].
%

category: 'Reading'
method: CPreprocessorToken
readWideStringFrom: aStream

	(self addToSource: aStream next) == $L ifFalse: [self error: 'How did we get here!?'].
	type := #'string'.
	self
		readLiteralUpTo: $"
		from: aStream.
%

category: 'other'
method: CPreprocessorToken
replaceFirst: aToken
	file := aToken file.
  stream := aToken stream .
	line := aToken line.
	source := aToken source.
%

category: 'other'
method: CPreprocessorToken
replaceOther: aToken
	file := aToken file.
  stream := aToken stream .
	line := aToken line.
	source := ''.
%

category: 'other'
method: CPreprocessorToken
setValueToArrayWithEmptyToken

	value := { self class empty }.
%

category: 'other'
method: CPreprocessorToken
skipBlockCommentsIn: aStream
	| char lf |
	self addToSource: aStream next.	"This should be the $* following the $/"
  lf := Character lf .
	[
		self addToSource: (char := aStream next).
		char == lf ifTrue:[ line := line + 1  ].
		char == $* and: [(self peekFrom: aStream) == $/ ].
	] whileFalse: [].
	self addToSource: aStream next.	"This should be the $/ following the $*"
	^self skipCommentsIn: aStream.
%

category: 'other'
method: CPreprocessorToken
skipCommentsIn: aStream
		"answer true if came to end-of-line, otherwise false"
	| char position lf |
  lf := Character lf .
	[
		(char := aStream peek) ~~ nil  and: [char isSeparator].
	] whileTrue: [
		char == lf ifTrue:[
      ^true
    ].
		self addToSource: aStream next.
	].
	char == $/ ifFalse: [^false].
	position := aStream position.
	self addToSource: aStream next.
	char := self peekFrom: aStream.
	char == $* ifTrue: [^self skipBlockCommentsIn: aStream].
	char == $/ ifTrue: [^self skipLineCommentsIn: aStream].
	source size: source size - 1.
	aStream position: position.
	^false.
%

category: 'other'
method: CPreprocessorToken
skipCppDebugInfo: aStream
  "Skip consecutive # <integer> <fileName> debuginfo lines from /usr/bin/cpp output .
   (AIX skip #line integer fileName)
   Skip #pragma lines from clang output .
   Returns nil if EOF, true if one or more lines skipped, false otherwise ."
  | char1 char2 px cx lf skipped |
  skipped := false .
  lf := Character lf .
 	[ | isDebug |
    [ char1 := self peekFrom: aStream .
      char1 == lf
    ] whileTrue:[
      aStream next.  "skip empty line"
      skipped := true .
      line := line + 1 .
    ].
    char1 ifNil:[ ^ nil ].
	  char2 := aStream peek2.
    (char1 == lf and:[ char2 == nil]) ifTrue:[ ^ nil ].
    isDebug := false .
    char1 == $# ifTrue:[
	    (char2 == $   ""
      and:[ (px := aStream position + 3) < (cx := aStream collection) size
      and:[  (cx at: px) isDigit ]]) ifTrue:[
         isDebug := true  " a # <int> <filename> line " .
         aStream next ; next. "consume char1, char2"
      ].
      (cppMType == 9 and:[ (aStream peekN: 6) = '#line ']) ifTrue:[ "#line from AIX cpp only"
         6 timesRepeat:[ aStream next ]. "consume '#line ' "
         isDebug := true  " a # <int> <filename> line " .
      ].
      isDebug ifTrue:[
        line := self readDebugLineNumberFrom: aStream .
        file := self readDebugFileNameFrom: aStream .
        cppMType == 9 ifTrue:[ | key |
          key := #GemStone_CPreprocessor_lastFile .  "in SessionTemps"
          file size == 0 ifTrue:[ "#line <int>  with no file name  , use last file name seen"
            file := (SessionTemps current at: key otherwise: '') copy
          ] ifFalse: [
            SessionTemps current at: key put: file copy .
          ].
        ].
      ] ifFalse:[
        "clang preprocessor produces #pragma lines on Darwin"
        char2 == $p ifTrue:[ | pStr |
          pStr := '#pragma' .
          (aStream peekN: pStr size ) = pStr ifTrue:[
            isDebug := true .
            [
              (self peekFrom: aStream ) == lf
            ] whileFalse:[
              aStream next.  "skip #pragma line"
              line := line + 1 .
            ].
          ].
        ].
      ].
    ].
    isDebug
  ] whileTrue:[
    skipped := true .  "skip to end of a debug info line"
    [aStream next == lf ] whileFalse .
    "line := line + 1 " "don't count debuginfo line"
  ].
  ^ skipped
%

category: 'other'
method: CPreprocessorToken
skipLineCommentsIn: aStream
  | lf |
	self addToSource: aStream next.	"This should be the $/ following the $/"
  lf := Character lf .
	[
		aStream peek == lf
	] whileFalse: [
		self addToSource: aStream next.
	].
	^true.
%

category: 'other'
method: CPreprocessorToken
skipMultipleBlankLinesAndCommentsInStream: aStream
cppMType ~~ 0 ifTrue:[
  [ | skipped |
    skipped := false .
	  [
		  [
			  self skipCommentsIn: aStream.
		  ] whileTrue: [
			  self addToSource: aStream next.
        skipped := true .
		  ].
		  aStream peek == $\ .
	  ] whileTrue: [
		  self addToSource: aStream next.  "line concatenation"
      skipped := true .
	  ].
    skipped ifTrue:[ skipped := self skipCppDebugInfo: aStream ].
    skipped == true
  ] whileTrue.
] ifFalse:[
  [
    [
      self skipCommentsIn: aStream.
    ] whileTrue: [
      line := line + 1.
      self addToSource: aStream next.
    ].
    aStream peek == $\.
  ] whileTrue: [
    self addToSource: aStream next.
  ].
]
%

category: 'other'
method: CPreprocessorToken
skipSingleLogicalLineCommentsInStream: aStream ifNothingFound: aBlock
	"Skip white space and comments on the current line, extending the
	 definition of current for lines ending with a backslash+newline."
  | lf |
	[ (self skipCommentsIn: aStream) == true ifTrue:[ ^ aBlock value ].
	  (self peekFrom: aStream) == $\
       and:[ aStream peek2 == (lf ifNil:[lf :=Character lf]) ]
  ] whileTrue:[
    cppMType ~~ 0 ifFalse:[ line := line + 1 ].
		self addToSource: aStream next.
		self addToSource: aStream next
  ]
%

category: 'Accessing'
method: CPreprocessorToken
source

	source == nil  ifTrue: [^''].
	^source.
%

category: 'Accessing'
method: CPreprocessorToken
stream
  ^ stream
%

category: 'Accessing'
method: CPreprocessorToken
type

	^type.
%

category: 'Accessing'
method: CPreprocessorToken
value

	^value.
%

category: 'other'
method: CPreprocessorToken
value: anObject

	value := anObject.
%

category: 'other'
method: CPreprocessorToken
valueString

	type == #'empty' ifTrue: [^''].
	type == #'identifier' ifTrue: [^value].
	type == #'int16' ifTrue: [^value printString].
	type == #'int32' ifTrue: [^value printString].
	type == #'int64' ifTrue: [^value printString].
	type == #'punctuator' ifTrue: [^value].
	type == #'string' ifTrue: [^'"' , value , '"'].
	type == #'uint16' ifTrue: [^value printString].
	type == #'uint32' ifTrue: [^value printString].
	type == #'uint64' ifTrue: [^value printString].
	self error: 'unrecognized type: ' , type printString.
%

category: 'debug'
method: CPreprocessorToken
_filePosition
  "Returns an Array  { lineNumber . positionInLine } describing the position of
   the receiver in the CPreprocessorStream's input file, 
   based on value of startOffset instVar ."
  | str ofs lNum lf |
  str := stream collection . 
  ofs := 1 .  lf := Character lf .  lNum := 1 .
  1 to: startOffset do:[ :n |
    (str at: n) == lf ifTrue:[ lNum := lNum + 1 . ofs := 1 ]
                     ifFalse:[ ofs := ofs + 1 ].
  ].
  ^ { lNum . ofs }
%

category: 'private'
method: CPreprocessorToken
_topazAsString
  ^ 'type ' , type printString,'  value ', value printString 
%

! Class implementation for 'CriticalSection'

!		Class methods for 'CriticalSection'

category: 'Instance Creation'
classmethod: CriticalSection
new
  "Answer a new CriticalSection"
  ^self basicNew _initialize
%

!		Instance methods for 'CriticalSection'

category: 'Blue Book Protocol'
method: CriticalSection
critical: aBlock
  "Wait until no other processes are sending critical to the receiver
   and then execute aBlock and return its value."

  | value activeProcess |
  activeProcess := self _scheduler activeProcess"a primitive".
  (owner == activeProcess) ifFalse: [
    semaphore wait.
    owner := activeProcess.
    value := aBlock ensure: [
      owner := nil.
      semaphore signal.
    ].
  ] ifTrue: [
    value := aBlock value.
  ].
  ^value
%

category: 'Private'
method: CriticalSection
_initialize

  owner := nil.
  semaphore := Semaphore forMutualExclusion.
%

category: 'Private'
method: CriticalSection
_scheduler

"Returns   ProcessorScheduler scheduler "
<primitive: 457>

self _primitiveFailed: #_scheduler
%

! Class implementation for 'DeletedUserProfile'

!		Class methods for 'DeletedUserProfile'

category: 'Instance Creation'
classmethod: DeletedUserProfile
createFrom: aUserProfile

| result |
result := self new .
result userId: aUserProfile userId copy.
result symbolList: aUserProfile symbolList .
result whenDeleted: DateTime now .
^ result
%

!		Instance methods for 'DeletedUserProfile'

category: 'Accessing'
method: DeletedUserProfile
symbolList

   "Return the value of the instance variable 'symbolList'."
   ^symbolList
%

category: 'Updating'
method: DeletedUserProfile
symbolList: newValue

   "Modify the value of the instance variable 'symbolList'."
   symbolList := newValue
%

category: 'Accessing'
method: DeletedUserProfile
userId

   "Return the value of the instance variable 'userId'."
   ^userId
%

category: 'Updating'
method: DeletedUserProfile
userId: newValue

   "Modify the value of the instance variable 'userId'."
   userId := newValue
%

category: 'Accessing'
method: DeletedUserProfile
whenDeleted

   "Return the value of the instance variable 'whenDeleted'."
   ^whenDeleted
%

category: 'Updating'
method: DeletedUserProfile
whenDeleted: newValue

   "Modify the value of the instance variable 'whenDeleted'."
   whenDeleted := newValue
%

! Class implementation for 'GciInterface'

!		Class methods for 'GciInterface'

category: 'Instance Creation'
classmethod: GciInterface
basicNew
"disallowed"

self shouldNotImplement: #basicNew
%

category: 'Instance Creation'
classmethod: GciInterface
new

"Create a new initialized instance."

^ self _basicNew initialize.
%

category: 'Instance Creation'
classmethod: GciInterface
newFromId: id

| result |

"Create a new initialized instance."

result := self _basicNew initialize.
result _sessionId: id.
^result
%

category: 'Prims'
classmethod: GciInterface
sessions

"Return an Array listing all of the active session ids"

^self _zeroArgPrim: 42
%

category: 'Instance Creation'
classmethod: GciInterface
_basicNew

"creates an instance registered with VM for finalization of cData"

<primitive: 674>
^ self _primitiveFailed: #_basicNew
%

category: 'Prims'
classmethod: GciInterface
_objectForOop: oop

"Return the object with the given oop.  If no object exists with this oop,
 return nil."

<primitive: 38>
self _primitiveFailed: #_objectForOop: args: { oop }
%

category: 'Prims'
classmethod: GciInterface
_oopForObject: anObject

"Return the oop for the given object."
^ anObject asOop
%

category: 'Prims'
classmethod: GciInterface
_zeroArgPrim: opcode

"Primitive dispatch.  Legal values are:
    42: GciInterface (C) | sessions
"

<primitive: 197>

^self _primitiveFailed: #_zeroArgPrim: args: { opcode }
%

!		Instance methods for 'GciInterface'

category: 'Public'
method: GciInterface
abort

"Abort the transaction in the remote repository."

trace
  ifTrue: [ self record: 'abort' ].

^ self _zeroArgPrim: 36
%

category: 'Primitives'
method: GciInterface
alteredObjects: alteredObjArray

"Invoke the GciAlteredObjs function.

 The function result of GciAlteredObjs is the method result
 and is saved in lastResult. (changed  in v3.0.1) "

| str result trc |

(trc := trace)
  ifTrue: [ str := String new add: 'alteredObjs: '; yourself ].

result :=  self _twoArgPrim: 4 with: alteredObjArray with: nil.
trc ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].

^ result
%

category: 'Primitives'
method: GciInterface
callInProgress

"Return whether there is a call in progress in the execution thread in the
remote repository."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' callInProgress'; yourself)
  ].

^ self _zeroArgPrim: 39
%

category: 'Primitives'
method: GciInterface
clearStack: processOop

"Clear the stack of Smalltalk execution in the remote repository."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' clearStack'; yourself)
  ].
^ self _oneArgPrim: 21 with: processOop
%

category: 'Public'
method: GciInterface
commit

"Commit the transaction in the remote repository."

trace
  ifTrue: [ self record: 'commit' ].

^ self _zeroArgPrim: 34
%

category: 'Primitives'
method: GciInterface
continueWith: processOop
replaceTopOfStackWith: replaceOop
isSpecial: isSpecial
flags: flags

"Invoke the GciContinueWith function.
If replaceOop == nil and isSpecial is false, then use OOP_ILLEGAL as the
replaceOop (which means the evaluation stack is not changed) .

Returns nil if an error occurs, or the execution result if execution
completes. (change in v3.0.1)"

| str result trc |
(trc := trace) ifTrue: [
    str := String new
	add: 'continueWith ['; add: replaceOop asString; add: '] '; yourself
  ].
result := self _fourArgPrim: 1
    with: processOop
    with: replaceOop
    with: isSpecial
    with: flags.
trc ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].
^ result
%

category: 'Primitives'
method: GciInterface
dirtyObjsInit

"Execute GciDirtyObjsInit."

trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' dirtyObjsInit'; yourself)
  ].

^ self _zeroArgPrim: 32
%

category: 'Tracing'
method: GciInterface
disableTracing

"Enable tracing of commands issued to the subordinate gem to be logged to
a file."

trace
  ifFalse: [ ^ false ].

trace := false.
log close.
^ false
%

category: 'Tracing'
method: GciInterface
enableFileTracing: filename

"Enable tracing of commands issued to the subordinate gem to be logged to
a file."

trace
  ifTrue: [ ^ true ].

trace := true.

log := GsFile open: filename mode: 'a'.

log addAll: 'Tracing enabled at ';
  addAll: DateTime now asString; lf; flush.
^ true
%

category: 'Accessing'
method: GciInterface
errorClass

   "Return the value of the instance variable 'errorClass'."
   ^errorClass
%

category: 'Updating'
method: GciInterface
errorClass: newValue

   "Modify the value of the instance variable 'errorClass'."
  (newValue isSubclassOf: ErrorDescription)
    ifFalse: [
      self _error: #objErrConstraintViolation
        args: { newValue . ErrorDescription class . newValue class }
    ].
   errorClass := newValue
%

category: 'Accessing'
method: GciInterface
getAndClearLastError

"Return the value of lastError and clear it."

| result |
result := lastError.
lastError := nil.
^ result
%

category: 'Primitives'
method: GciInterface
getFreeOops: num

"Return an array of free remote oops from the subordinate gem.
This method will return a maximum of 2000 free oops.  You must
make multiple calls to receive more."

trace ifTrue: [ | str |
    str := String new.
    str add: 'getFreeOops: '; add: num asString.
    self record: str
  ].

^ self _oneArgPrim: 19 with: num
%

category: 'Primitives'
method: GciInterface
hardBreak

"Send a hard break to interrupt execution in the remote repository."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' hardBreak'; yourself)
  ].

^ self _zeroArgPrim: 43
%

category: 'Initialization'
method: GciInterface
initialize

"Initialize the instance variables of the receiver."

trace := false.
sessionId := 0. "GCI_INVALID_SESSION_ID"
errorClass := ErrorDescription.
lastResult := _remoteNil.
^ self
%

category: 'Accessing'
method: GciInterface
lastError

   "If the most recent remote operation did not succeed due to an error,
    answer an ErrorDescription. Otherwise answer nil."
   ^lastError
%

category: 'Accessing'
method: GciInterface
lastErrorString
 
   "If the most recent remote operation did not succeed due to an error,
    answer an ErrorDescription. Otherwise answer nil."
   ^ lastError printString
%

category: 'Accessing'
method: GciInterface
lastResult

   "Answer the result of the most recent remote operation.
    This will be a remote oop unless #resultIsSpecial answers true."
   ^lastResult
%

category: 'Accessing'
method: GciInterface
lastResultAsOop
  "return an Integer , the oop of the last result.
  If last result is undefined,  276 (oop of _remoteNil) is returned"
  | rs |
  (rs := resultIsSpecial) ifNil:[ ^ lastResult asOop ].
  rs == true ifTrue:[ ^ lastResult asOop ].
  ^ lastResult
%

category: 'Accessing'
method: GciInterface
log

   "Return the value of the instance variable 'log'."
   ^log
%

category: 'Public'
method: GciInterface
login: aGemStoneParameters andExecute: aString ifFailure: aBlock

"Login to the remote repository using the given parameters.  If login is
successful, return the remote oop of the result of execution of the given
string.  If the login fails or the executed block generates an error (which
in turn will cause the session to be logged out), execute the zero argument
block (if the block is nil, raise an error)."

| str gsName result trc |

aGemStoneParameters remoteRepository == nil
  ifFalse: [ gsName := aGemStoneParameters remoteRepository gemStoneName]
  ifTrue:  [ gsName := aGemStoneParameters gemStoneName].

(trc := trace) ifTrue: [
    str := String new add: 'Logging in to '; add: gsName;
      add: ' as '; add: aGemStoneParameters username; yourself.
    self record: str
  ].

" login and execute some code "
result := self login: aGemStoneParameters execute: aString.

" when successful, result is a remote oop (an Integer) "
result == _remoteNil ifTrue: [
    aBlock == nil
      ifTrue: [ self _errorLoginFailed ]
      ifFalse: [
        ^ aBlock value
      ]
  ].
(trc and: [ aString ~~ nil ])
  ifTrue: [ self record: 'Login successful.'; record: aString ].

^ result
%

category: 'Primitives'
method: GciInterface
login: aGemStoneParameters
execute: aString

"Login to a GemStone server with the given parameters, and execute
the given string.  The execution string may be nil.  If the result of execution
is _remoteNil, this will immediately logout.  If any error occurs during login
or remote string execution, this will return _remoteNil; otherwise it returns
the remote oop of the result of execution."

^ self _threeArgPrim: 4
    with: aGemStoneParameters
    with: aString
    with: aGemStoneParameters loginFlags
%

category: 'Primitives'
method: GciInterface
login: aGemStoneParameters flags: flagsInt

"Login to a GemStone server with the given parameters.
  flagsInt should be result of GemStoneParameters >> loginFlags . 
 If successful, returns true ."


^ self _twoArgPrim: 10
    with: aGemStoneParameters
    with: flagsInt
%

category: 'Public'
method: GciInterface
logout

"Terminate the communication with a subordinate gem."

trace ifTrue: [
    self record: 'Logging out'.
    self disableTracing.
  ].
^ self _zeroArgPrim: 33
%

category: 'Primitives - Trav'
method: GciInterface
moreTraversal: cBuff

"Continue a traversal from a previous operation.  The returned value will
be a TraversalBuffer.  The argument cBuff should be an instance of
TraversalBuffer"

| result |
trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' moreTraversal'; yourself)
  ].
result :=  self _oneArgPrim: 18 with: cBuff.
^ result
%

category: 'Primitives - NB'
method: GciInterface
nbAbort

"Non-blocking abort of the transaction in the remote repository."

trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' nbAbort'; yourself)
  ].

^ self _zeroArgPrim: 37
%

category: 'Primitives - NB'
method: GciInterface
nbCommit

"Non-blocking commit of the transaction in the remote repository."

trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' nbCommit'; yourself)
  ].

^ self _zeroArgPrim: 35
%

category: 'Primitives - NB'
method: GciInterface
nbEnd: returnType

"Test the status of a non-blocking call in progress.
The return type indicates if the non-blocking call will return
an OopType (1) or a BoolType (2).

Returns
  -1 if GCI_RESULT_NOT_READY
  0 if GCI_RESULT_PROGRESSED
  1 if GCI_RESULT_READY
  nil if an error occurred

After obtaining GCI_RESULT_READY, send lastResult or lastResultAsOop
to obtain the result.
"

| result str |
result := self _oneArgPrim: 20 with: returnType.
trace ifTrue: [
    str := String new.
    str add: sessionId asString; add: ' NB end - '.

    result == -1
      ifTrue: [ " self record: str , 'GCI_RESULT_NOT_READY' " ]
      ifFalse: [
        result == 0
          ifTrue: [ str add: 'GCI_RESULT_PROGRESSED' ]
          ifFalse: [
            result == 1
              ifTrue: [ str add: 'GCI_RESULT_READY : returned '; add: result asString ]
              ifFalse: [ str add: 'unknown NbEnd result: '; add: result asString ]
          ].
        self record: str
      ]
  ].

^ result
%

category: 'Primitives - NB'
method: GciInterface
nbEndBoolean

"cover for nbEnd:"

^self nbEnd: 2
%

category: 'Primitives - NB'
method: GciInterface
nbEndOop

"cover for nbEnd:"

^self nbEnd: 1
%

category: 'Primitives - NB'
method: GciInterface
nbEndTraversal

"cover for nbEnd:"

^self nbEnd: 2
%

category: 'Primitives'
method: GciInterface
nbLogin: aGemStoneParameters
  ^ self nbLogin: aGemStoneParameters flags: 0
%

category: 'Primitives'
method: GciInterface
nbLogin: aGemStoneParameters flags: flagsInt

"Invoke the GciNbLoginEx function.  flagsInt is per GCI_LOGIN_* bits defined
 in gci.ht. GCI_LOGIN_PW_ENCRYPTED and GCI_LOGIN_IS_SUBORDINATE
 are always ORed with the user provided flags before calling GciNbLoginEx."

^ self _twoArgPrim: 9 with: aGemStoneParameters with: flagsInt
%

category: 'Primitives - NB'
method: GciInterface
nbMoreTraversal: cBuff

"Non-blocking more traversal.
 The argument cBuff should be an instance of TraversalBuffer."

trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' nbMoreTraversal'; yourself)
  ].

^ self _oneArgPrim: 23 with: cBuff
%

category: 'Primitives - NB'
method: GciInterface
nbRemoteExecute: aString

"Execute the given string and return the result of execution.
Returns nil if there was an error, else returns receiver.
Use nbEnd* and lastResult methods to obtain the remote result."


trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' nbRemoteExecute:';
        add: aString; yourself)
  ].

^ self _oneArgPrim: 22 with: aString
%

category: 'Primitives - NB'
method: GciInterface
nbRemotePerform: remoteOop selector: selector args: args

"Sends the given selector to the object in a remote repository with the given
remote oop.  The arg array is an array of pairs: either a remote oop or special,
and a boolean indicating whether the arg is special or not, TRUE if the arg
is a remote oop, FALSE if it is special.
Returns nil if there was an error, else returns receiver.
Use nbEnd* and lastResult methods to obtain the remote result."

trace
  ifTrue: [
    self record: (String new add: sessionId asString;
      add: ' nbRemotePerform ['; add: remoteOop asString;
      add: '] '; add: selector; yourself)
  ].

^ self _threeArgPrim: 3
    with: remoteOop
    with: selector
    with: args
%

category: 'Primitives'
method: GciInterface
notifyHandle

"Return an OS handle that can be used in GsSocket to test if this interface
has read activity."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' notifyHandle'; yourself)
  ].

^ self _zeroArgPrim: 41
%

category: 'Primitives - Trav'
method: GciInterface
performTraverse: remoteOop
selector: selector
args: argsArr
buffer: cBuff

"Sends the given selector to the object in a remote repository with the given
remote oop.  argsArr  is an Array of pairs: either a remote oop or special,
and a boolean indicating whether the arg is special or not.

The argument cBuff should be an instance of TraversalBuffer."

trace ifTrue: [ | str sz |
    str := String new add: 'Sending ['; add: remoteOop asString;
      add: '] '; add: selector; add: ' '; yourself.
    sz := argsArr size.
    1 to: sz by: 2 do: [ :i |
      (argsArr at: i + 1) ifTrue: [ str add: $~ ].
      str add: (argsArr at: i) asString.
      (i + 1) == sz ifFalse: [ str add: ', ' ]
    ].
    self record: str.
  ].
^ self _fourArgPrim: 2
    with: remoteOop
    with: selector
    with: argsArr
    with: cBuff
%

category: 'Tracing'
method: GciInterface
record: aString

"Record the given string to the trace log."

log addAll: aString; add: Character lf; flush
%

category: 'Tracing'
method: GciInterface
recordNoLf: aString

"Record the given string to the trace log with no linefeed at the end."

log addAll: aString; flush
%

category: 'Primitives'
method: GciInterface
remoteExecute: aString

"Execute the given string and return the result of execution.
The returned value will be a remote oop or a special. Send
#resultIsSpecial to determine which.
If the execution resulted in an error, _remoteNil is returned
and error information can be retrieved via #lastError."

| str result trc |

(trc := trace)
  ifTrue: [ str := String new add: 'Execute: '; add: aString; yourself ].

result :=  self _oneArgPrim: 16 with: aString.
trc ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].
^ result
%

category: 'Primitives - Trav'
method: GciInterface
remoteExecuteTrav: aString buffer: cBuff

"Execute the given string and return the result of execution in the given buffer.
 The argument cBuff should be an instance of TraversalBuffer.
 The result of the execution is saved in the instVar lastResult  .
 The method result is cBuff, i.e. the result of doing a traversal on
 the result of the execution. "

trace ifTrue: [ self record: aString ].

^ self _twoArgPrim: 7
    with: aString
    with: cBuff
%

category: 'Primitives'
method: GciInterface
remotePerform: remoteOop selector: selector args: args

"Sends the given selector to the object in a remote repository with the given
remote oop.  The arg array is an array of pairs: either a remote oop or special,
and a boolean indicating whether the arg is special or not.  The result is a
remoteOop or a special. Send #resultIsSpecial to determine which."

| str result trc |
(trc := trace)
  ifTrue: [
    str := String new add: 'Sending ['; add: remoteOop asString;
      add: '] '; add: selector; yourself
  ].
result := self _threeArgPrim: 2
    with: remoteOop
    with: selector
    with: args.
trc ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].
^ result
%

category: 'Primitives'
method: GciInterface
resolveSymbol: aSymbol

"Resolve the given symbol and return the remote oop."

trace ifTrue: [ self record: 'Resolve symbol' , aSymbol ].

^ self _oneArgPrim: 17 with: aSymbol
%

category: 'Accessing'
method: GciInterface
resultIsSpecial

   "Answer true if the most recent result is a special (immediate) object:
    a SmallInteger, SmallDouble, Boolean, Character, or nil.
    Answer false if the most recent result is a remote oop."
   ^resultIsSpecial
%

category: 'Accessing'
method: GciInterface
sessionId

   "Return the value of the instance variable 'sessionId'."
   ^sessionId
%

category: 'Primitives'
method: GciInterface
softBreak

"Send a soft break to interrupt execution in the remote repository."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' softBreak'; yourself)
  ].

^ self _zeroArgPrim: 38
%

category: 'Primitives'
method: GciInterface
step: processOop level: level

"Invoke the GciStep function.

 Returns nil if an error occurs, or the execution result if
 execution completes.  If execution completes, saves the
 execution result in lastResult instVar (change in v3.0.1)."

| str result |
trace ifTrue: [
    str := String new add: 'GciStep ';
      add: processOop asString;
      add: ' : ';
      add: level asString;
      yourself
  ].
result :=  self _twoArgPrim: 5 with: processOop with: level.
trace ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].
^ result
%

category: 'Primitives - Trav'
method: GciInterface
storeTrav: travBuff flags: flags

"Invoke the store traversal function."

trace
  ifTrue: [ self record: 'GciStoreTrav: ' , flags asString ].

^ self _twoArgPrim: 3 with: travBuff with: flags
%

category: 'Primitives - Trav'
method: GciInterface
storeTravCreate: travBuff

"Invoke the store traversal function."

^ self storeTrav: travBuff flags: 2
%

category: 'Primitives - Trav'
method: GciInterface
storeTravCreateAndFinishUpdates: travBuff

"Invoke the store traversal function."

^ self storeTrav: travBuff flags: 10
%

category: 'Primitives - Trav'
method: GciInterface
storeTravExecute: travBuff
flags: flags
environmentId: anEnvironmentId
execute: aString
alteredObjects: alteredObjArray

"Invoke the store traversal function.

 anEnvironmentId must be a SmallInteger >= 0 and <= 255,
 specifying a compilation environment.

 If execution completes without error, this method
 answers the alteredCompleted boolean, and
 the result of the message send is saved in lastResult instVar.
 If there is an error, this method answers nil and you may send
 #lastError for error information."

| str result trc |
(trc := trace)
  ifTrue: [
    str := String new add: 'GciStoreTravExecute: '; add: aString; yourself
  ].

result := self _storeTravPrim: 1
    with: travBuff
    with: flags
    with: aString
    with: alteredObjArray
    with: anEnvironmentId
    with: nil with: nil .
trc ifTrue: [
    str add: ' lastResult '; add: lastResult asString ;
        add: ' returned '; add: result asString .
    self record: str
  ].
^ result
%

category: 'Primitives - Trav'
method: GciInterface
storeTravExecute: travBuff
flags: flags
environmentId: anEnvironmentId
execute: aString
alteredObjects: alteredObjArray
traverseInto: resBuff

"Invoke the store traversal function.

 anEnvironmentId must be a SmallInteger >= 0 and <= 255,
 specifying a compilation environment.

 If execution completes without error, this method
 answers the alteredCompleted boolean,
 the result of the message send is saved in lastResult instVar,
 and the result of the message send is traversed into the
 argument resBuff.   resBuff must be instance of TraversalBuffer.

 If there is an error, this method answers nil and you may send
 #lastError for error information."

| str result trc |
(trc := trace)
  ifTrue: [
    str := String new add: 'GciStoreTravExecute: '; add: aString; yourself
  ].

result := self _storeTravPrim: 1
    with: travBuff
    with: flags
    with: aString
    with: alteredObjArray
    with: anEnvironmentId
    with: resBuff with: nil .
trc ifTrue: [
    str add: ' lastResult '; add: lastResult asString ;
        add: ' returned '; add: result asString .
    self record: str
  ].
^ result
%

category: 'Primitives - Trav'
method: GciInterface
storeTravPerform: travBuff
flags: flags
perform: remoteOop
selector: selector
args: args
alteredObjects: alteredObjArray

"Invoke the GciStoreTravDo() function, sending
 the objects in the given travBuff to the remote
 gem, then sending the message described by
 the given selector and args to the object with
 the given remoteOop.

 The given args must be an Array whose size is
 twice the number of args. At each even index
 must be a Boolean, true if the value at index-1
 is a special, false if the value is a remote oop.

 If execution completes without error, this method
 answers the alteredCompleted boolean, and
 the result of the message send is saved in lastResult instVar.
 If there is an error, this method answers nil and you may send
 #lastError for error information."

| str result trc |

(trc := trace)
  ifTrue: [
    str := String new add: 'GciStoreTravPerform ['; add: remoteOop asString;
      add: '] '; add: selector; yourself
  ].

result := self _storeTravPrim: 0
    with: travBuff
    with: flags
    with: remoteOop
    with: selector
    with: args
    with: alteredObjArray
    with: nil  .
trc ifTrue: [
    str add: ' lastResult '; add: lastResult asString ;
        add: ' returned '; add: result asString .
    self record: str
  ].
^ result
%

category: 'Primitives - Trav'
method: GciInterface
storeTravPerform: travBuff
flags: flags
perform: remoteOop
selector: selector
args: argsArray
alteredObjects: alteredObjArray
traverseInto: resBuff

"Invoke the GciStoreTravDo() function, sending the objects in
 the given travBuff to the remote gem, then sending the message
 described by the given selector and args to the object with
 the given remoteOop.
 If execution completes without error, this method
 answers the alteredCompleted boolean, and
 the result of the message send is saved in lastResult instVar.
 and the result of the message send is traversed into the
 argument resBuff.   resBuff must be instance of TraversalBuffer.

 The argsArray must be an Array whose size is
 twice the number of args to the selector being performed.
 At each even index must be a Boolean, true if the value at index-1
 is a special, false if the value is a remote oop.

 If there is an error, this method answers nil and you may send
 #lastError for error information."

| str result trc |

(trc := trace)
  ifTrue: [
    str := String new add: 'GciStoreTravPerform ['; add: remoteOop asString;
      add: '] '; add: selector; yourself
  ].

result := self _storeTravPrim: 2
    with: travBuff
    with: flags
    with: remoteOop
    with: selector
    with: argsArray
    with: alteredObjArray
    with: resBuff .
trc ifTrue: [
    str add: ' lastResult '; add: lastResult asString ;
        add: ' returned '; add: result asString .
    self record: str
  ].
^ result
%

category: 'Primitives - Trav'
method: GciInterface
traverseObjects: arrayOfOops buffer: cBuff

"Return a buffer resulting from traversing the given array of remote oops
using GciClampedTrav().  If there were too many oops, return nil.
The argument cBuff should be an instance of TraversalBuffer."

trace ifTrue: [ | str |
    str := String new.
    str add: 'Traversing '; add: arrayOfOops size asString; add: ' oops'.
    self record: str
  ].

^ self _twoArgPrim: 6 with: arrayOfOops with: cBuff
%

category: 'Error Handling'
method: GciInterface
_errorLoginFailed

"Raise an error because an attempt to login failed."

Error signal: 'login failed, ' , lastError message .
%

category: 'Private'
method: GciInterface
_fourArgPrim: opcode with: arg1 with: arg2 with: arg3 with: arg4

"Primitive dispatch.  Legal values:
    1: GciInterface | continueWith:replaceTopOfStackWith:isSpecial:flags:
		(sets lastResult instVar)
    2: GciInterface | performTraverse:selector:args:buffer:  (sets lastResult instVar)
"

<primitive: 503>

^self _primitiveFailed: #_fourArgPrim:
      args: { opcode . arg1 . arg2 . arg3 . arg4 }
%

category: 'Private'
method: GciInterface
_oneArgPrim: opcode with: arg

"Primitive dispatch.  Legal values are:
    16: GciInterface | remoteExecute:   (sets lastResult instVar)
    17: GciInterface | resolveSymbol:
    18: GciInterface | moreTraversal:
    19: GciInterface | getFreeOops:
    20: GciInterface | nbEnd:          (sets lastResult instVar)
    21: GciInterface | clearStack:
    22: GciInterface | nbRemoteExecute:
    23: GciInterface | nbMoreTraversal:
    24: reserved
"

<primitive: 198>

"Error diagnostics"
opcode == 20
  ifTrue: [ "errors in nbEnd:"
    (arg _isInteger)
	ifFalse: [ arg _errorExpectedClass: Integer].
    (arg ~~ 1 and: [arg ~~ 2])
	ifTrue:[arg _error: #rtErrArgOutOfRange args: #(1 2)].
    ].

^self _primitiveFailed: #_oneArgPrim: args: { opcode . arg }
%

category: 'Private'
method: GciInterface
_sessionId: id

"Set the session id"

sessionId := id
%

category: 'Private'
method: GciInterface
_storeTravPrim: opcode with: arg1 with: arg2 with: arg3 with: arg4 with: arg5
with: arg6 with: arg7

"Primitive dispatch.  all set lastResult instVar .
  opcode values:
    0: storeTravPerform:flags:perform:selector:args:alteredObjects:
    1: storeTravExecute:flags:environmentId:execute:alteredObjects:
    2: storeTravPerform:flags:perform:selector:args:alteredObjects:traverseInto:
    3: storeTravExecute:flags:environmentId:execute:alteredObjects:traverseInto:
"

<primitive: 506>

^self _primitiveFailed: #_storeTravPrim:
      args: { opcode . arg1 . arg2 . arg3 . arg4 . arg5 . arg6 . arg7  }
%

category: 'Private'
method: GciInterface
_threeArgPrim: opcode with: arg1 with: arg2 with: arg3

"Primitive dispatch.  Legal values:
    2: GciInterface | remotePerform:selector:args:
    3: GciInterface | nbRemotePerform:selector:args:
    4: GciInterface | login:execute:
"

<primitive: 505>

opcode == 3
    ifTrue: [ "diagnostics for nbRemotePerform"
  arg3 size > 20 ifTrue: [arg3 _error: #gciErrArgNotPairs args: #()].
  arg3 size \\ 2 ~~ 0 ifTrue: [arg3 _error: #gciErrArgNotPairs args: #()].
  1 to: arg3 size by: 2 do: [:i |
	(arg3 at: i + 1) class == Boolean ifFalse: [
	    (arg3 at: i + 1) _errorExpectedClass: Boolean].
	(arg3 at: i + 1) ifTrue: [
	  ((arg3 at: i) _isInteger ) ifFalse: [
	    (arg3 at: i) _errorExpectedClass: Integer].
	  ].
	].
  ].
opcode == 4
  ifTrue: [ "errors in login"
    (arg1 isKindOf: GemStoneParameters)
	ifFalse: [ arg1 _errorExpectedClass: GemStoneParameters].
    (arg2 class isBytes)
	ifFalse: [ arg2 _error: #objErrNotByteKind].
    arg3 _validateClass: SmallInteger .
    { arg2 .
      arg1 hostUsername .
      arg1 gemService .
      arg1 gemStoneName .
      arg1 username .
      arg1 password .
      arg1 hostPassword
	 } do: [:each |
      each size > 1024
	ifTrue: [ each _error: #rtErrBadSize args: { 1024 . each size }]].
    ].
^self _primitiveFailed: #_threeArgPrim: args: { opcode . arg1 . arg2 . arg3 }
%

category: 'Private'
method: GciInterface
_twoArgPrim: opcode with: arg1 with: arg2

"Primitive dispatch.  Legal values:
    3: GciInterface | storeTrav:flags:  (sets lastResult instVar)
    4: GciInterface | alteredObjects:   (sets lastResult instVar)
    5: GciInterface | step:level:
    6: GciInterface | traverseObjects:buffer:
    7: GciInterface | remoteExecuteTrav:buffer:
    8: unused (formerly GciInterface | login:execute:)
    9: GciInterface | nbLogin:flags:
"

<primitive: 199>

"Error diagnostics"

opcode == 9
  ifTrue: [ "errors in login"
    (arg1 isKindOf: GemStoneParameters)
	ifFalse: [ arg1 _errorExpectedClass: GemStoneParameters].

    { arg1 hostUsername .
      arg1 gemService .
      arg1 gemStoneName .
      arg1 username .
      arg1 password .
      arg1 hostPassword } do: [:each |
        each size > 1024
	ifTrue: [ each _error: #rtErrBadSize args: { 1024 . each size }]
      ].
     arg2 _isSmallInteger ifFalse:[ arg2 _errorExpectedClass: SmallInteger ]
    ].

^self _primitiveFailed: #_twoArgPrim: args: { opcode . arg1 . arg2 }
%

category: 'Private'
method: GciInterface
_zeroArgPrim: opcode

"Primitive dispatch.  Legal values are:
    32: GciInterface | dirtyObjsInit
    33: GciInterface | logout    (sets lastResult instVar to _remoteNil)
    34: GciInterface | commit
    35: GciInterface | nbCommit
    36: GciInterface | abort
    37: GciInterface | nbAbort
    38: GciInterface | softBreak
    39: GciInterface | callInProgress
    41: GciInterface | notifyHandle
    42: reserved
    43: GciInterface | hardBreak
    44:  _setDynamicClamp (receiver must be a ClampSpecification)

 A clamp installed with  _setDynamicClamp 
"

<primitive: 197>

^self _primitiveFailed: #_zeroArgPrim: args: { opcode }
%

! Class implementation for 'GemStoneX509Parameters'

!		Class methods for 'GemStoneX509Parameters'

category: 'Instance Creation'
classmethod: GemStoneX509Parameters
newFromPemFilesWithNetldiPort: aPort netldiHost: aHostOrIp certificate: aCertFn caCertificate: aCaCertFn privateKey: aKeyFn
| result |
result := self new initialize.
result netldiPort: aPort;
       netldiHost: aHostOrIp;
       certificate: (GsX509CertificateChain newFromPemFile: aCertFn);
       caCertificate: (GsX509CertificateChain newFromPemFile: aCaCertFn);
       privateKey: (GsTlsPrivateKey newFromPemFile: aKeyFn) .
^ result
%

category: 'Instance Creation'
classmethod: GemStoneX509Parameters
newFromPemStringsWithNetldiPort: aPort netldiHost: aHostOrIp certificate: aCertString caCertificate: aCaCertString privateKey: aKeyString
| result |
result := self new initialize.
result netldiPort: aPort;
       netldiHost: aHostOrIp;
       certificate: (GsX509CertificateChain newFromPemString: aCertString);
       caCertificate: (GsX509CertificateChain newFromPemString: aCaCertString);
       privateKey: (GsTlsPrivateKey newFromPemString: aKeyString) .
^ result
%

category: 'Instance Creation'
classmethod: GemStoneX509Parameters
newWithNetldiPort: aPort netldiHost: aHostOrIp certificate: aCert caCertificate: aCaCert privateKey: aKey
| result |
result := self new initialize.
result netldiPort: aPort;
       netldiHost: aHostOrIp;
       certificate: aCert;
       caCertificate: aCaCert;
       privateKey: aKey .
^ result
%

!		Instance methods for 'GemStoneX509Parameters'

category: 'Updating'
method: GemStoneX509Parameters
addGemArg: aString
  extraGemArgs ifNil:[ 
    extraGemArgs := aString 
  ] ifNotNil:[ 
    extraGemArgs := extraGemArgs , ' ', aString .
  ]
%

category: 'Converting'
method: GemStoneX509Parameters
asGciX509LoginArg

"Answer an instance of CPointer which represents a GciX509LoginArg derived
 from the receiver."

| cBytes |
cBytes := CByteArray gcMalloc: 80 .
cBytes
  pointerAt:  0 put: (CByteArray withAll: netldiHost asString) ;
  pointerAt:  8 put: (CByteArray withAll: netldiPort asString) ;
  pointerAt: 16 put: (CByteArray withAll: privateKey asPemString) ;
  pointerAt: 24 put: (CByteArray withAll: certificate asPemString) ;
  pointerAt: 32 put: (CByteArray withAll: caCertificate asPemString) ;
  pointerAt: 40 put: (self createCargFromInstVar: extraGemArgs) ;
  pointerAt: 48 put: (self createCargFromInstVar: dirArg) ;
  pointerAt: 56 put: (self createCargFromInstVar: logArg) ;
    int32At: 64 put: loginFlags ;
    int32At: 68 put: 1 "argsArePemStrings" ;
    int32At: 72 put: 0 "executedSessionInit" .

^ CPointer newFrom: cBytes
%

category: 'Accessing'
method: GemStoneX509Parameters
caCertificate
^ caCertificate
%

category: 'Updating'
method: GemStoneX509Parameters
caCertificate: aCaCert
caCertificate := aCaCert
%

category: 'Accessing'
method: GemStoneX509Parameters
certificate
^ certificate
%

category: 'Updating'
method: GemStoneX509Parameters
certificate: aCert
certificate := aCert
%

category: 'Converting'
method: GemStoneX509Parameters
createCargFromInstVar: anObj
^ (anObj isNil or:[anObj size == 0])
    ifTrue:[ CPointer newNull ]
   ifFalse:[ CByteArray withAll: anObj ]
%

category: 'Accessing'
method: GemStoneX509Parameters
dirArg
^ dirArg
%

category: 'Updating'
method: GemStoneX509Parameters
dirArg: aString
dirArg := aString
%

category: 'Accessing'
method: GemStoneX509Parameters
extraGemArgs
^ extraGemArgs
%

category: 'Updating'
method: GemStoneX509Parameters
extraGemArgs: aString
  extraGemArgs := aString
%

category: 'Initialization'
method: GemStoneX509Parameters
initialize
 loginFlags := 0 .
 ^ self
%

category: 'Accessing'
method: GemStoneX509Parameters
logArg
^ logArg
%

category: 'Updating'
method: GemStoneX509Parameters
logArg: aString
logArg := aString
%

category: 'Accessing'
method: GemStoneX509Parameters
loginFlags
^ loginFlags
%

category: 'Updating'
method: GemStoneX509Parameters
loginFlags: anInt
loginFlags := anInt
%

category: 'Accessing'
method: GemStoneX509Parameters
netldiHost
^ netldiHost
%

category: 'Updating'
method: GemStoneX509Parameters
netldiHost: aHostOrIp
netldiHost := aHostOrIp .
%

category: 'Accessing'
method: GemStoneX509Parameters
netldiPort
^ netldiPort
%

category: 'Updating'
method: GemStoneX509Parameters
netldiPort: anInt
netldiPort := anInt .
%

category: 'Accessing'
method: GemStoneX509Parameters
privateKey
^ privateKey
%

category: 'Updating'
method: GemStoneX509Parameters
privateKey: aPrivateKey
privateKey := aPrivateKey
%

! Class implementation for 'GsDigitalEnvelope'

!		Class methods for 'GsDigitalEnvelope'

category: 'Examples'
classmethod: GsDigitalEnvelope
decryptExampleFromString: aPassiveObjString

"Takes a String produced by the encryptExample method and decodes the message."
| envelope privateKey msg verifyKey |

privateKey := GsTlsPrivateKey newFromPemString:
'-----BEGIN PRIVATE KEY-----
MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMBXQWaLW7QhuWvO
17X5c8LYDbw65if4QR2ATaNZ0Cq3Q6Q+aCsnmT1Q3AvKwUx0Y3PnASLLl0zNQN94
nbNP81vT/0D4J0Ch1HwGUErZReLDN2DSoUELdnmbrgR10Glriy3HD6wb0q+h/N45
8JpR6sTYhVlLtvnGYAJL2OW5kVRVAgMBAAECgYEAl6My+Hld7wG3gXstLVZhIXfc
PE3jLhfWnj+M9f/U0hhxx4c78OnjMigRk2piQrhvv+ybRKdlvTMEtioNilS58ogV
/I5dRoHsRd2opsUeDMloRdOMcL6HhinjGtPFqY/QXdeKKLLAfR2Mw1GKaro55hQv
DRqRk01Gd/KvWij5roECQQDz+9VW54+qolrDH2iw0BBeeYBog/ELA8vNw7te4OWH
0TrPHUDyvHkJCQ/GSWHLVQ2Rw/WoyKMTn7u/LF8pspp9AkEAydBN8IPdID8m5rk8
JYr1iPceAyoI5ZeUA1cqrFjx4HdtyVAuLGQAvVSY7fJaSzlrBeH8HVa3GlDJ3Qr1
Tt1wuQJAJnbhX14KTEBkRrbA7n8e1YYaNF/4tF/Y1YuyEncqOItH1jcqcho8iqwf
DIetHz09cmmOZRmcfA+GrdD0/8HkkQJANUUxvYHhFYj16MMOWE6Uv0GTf3xR+uCG
5lbU4cdcmUaNCS2L8pW3CELTV0O4h9CxKk1bchcYn+6hSiKBW/7hqQJBAKcucW2t
HDhYqOhZi+Eq+z7mnua7x867COGlijb3yE80rvmqBOOZc3PtJNr2SKQoBjD++B4w
HSedUWX12Gyb0SE=
-----END PRIVATE KEY-----' .

verifyKey := GsTlsPublicKey newFromPemString: '-----BEGIN PUBLIC KEY-----
MIGdMAsGCSqGSIb3DQEBCgOBjQAwgYkCgYEAwPc8s5Ox0/BOYYmH/UGHVXlcvsD2
dKu+9Plm2np4BZfjvitYEsobh+sOPJEauzx1UPxRb9vK4dk7NxBHKuHssjfDdD2A
lPUXoaGd3NzUWUHdznLwkkcbHHTbS/xiPT/FkxYM13yzUz3te0q0rQZiktpzQ8J2
qVo7m9joI7X5xVECAwEAAQ==
-----END PUBLIC KEY-----' .

envelope := (PassiveObject newWithContents: aPassiveObjString) activate.
msg := envelope decryptWithPrivateKey: privateKey
                withPublicVerificationKey: verifyKey .
^ msg
%

category: 'Decrypting'
classmethod: GsDigitalEnvelope
decryptMessage: aMsg withPrivateDecryptionKey: aGsTlsPrivateKey encryptedKey: aKey
initVector: anIv tag: aTag cipherId: anInt messageClassName: aString
digitalSignature: aSig withPublicVerificationKey: aPublicKey

"Decrypts the message and stores it in a new instance of the class with name
 aString, which must be a byte object class name.
 See the class comments for more information on GsDigitalEnvelopes."

^ self new encryptedKey: aKey ;
       	   cipherText: aMsg ;
	   initVector: anIv ;
	   cipherId: anInt ;
	   tag: aTag ;
	   messageClassName: aString ;
           digitalSignature: aSig ;
	   decryptWithPrivateKey: aGsTlsPrivateKey
           withPublicVerificationKey: aPublicKey
%

category: 'Examples'
classmethod: GsDigitalEnvelope
encryptExampleWithMessage: msg

"Create a GsDigitalEnvelope and passivate it to a string for transmission"

| publicKey envelope stream aSigningKey |

"Create RSA public key"
publicKey := GsTlsPublicKey newFromPemString:
'-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDAV0Fmi1u0Iblrzte1+XPC2A28
OuYn+EEdgE2jWdAqt0OkPmgrJ5k9UNwLysFMdGNz5wEiy5dMzUDfeJ2zT/Nb0/9A
+CdAodR8BlBK2UXiwzdg0qFBC3Z5m64EddBpa4stxw+sG9KvofzeOfCaUerE2IVZ
S7b5xmACS9jluZFUVQIDAQAB
-----END PUBLIC KEY-----' .

aSigningKey := GsTlsPrivateKey newFromPemString:
'-----BEGIN PRIVATE KEY-----
MIICdQIBADALBgkqhkiG9w0BAQoEggJhMIICXQIBAAKBgQDA9zyzk7HT8E5hiYf9
QYdVeVy+wPZ0q770+WbaengFl+O+K1gSyhuH6w48kRq7PHVQ/FFv28rh2Ts3EEcq
4eyyN8N0PYCU9RehoZ3c3NRZQd3OcvCSRxscdNtL/GI9P8WTFgzXfLNTPe17SrSt
BmKS2nNDwnapWjub2OgjtfnFUQIDAQABAoGAVWbWwa9zO5aWSgrBWe+/gq/EwVPL
f9VnHSqoP7eGGQuhKtAqGZ7DUoNQeLPLveRDE8WoETaYcx5eW79jj/IPfAfKbgol
wrd+AxSGRcsK/Gskh6Drt84kCcAoXmhO/s0nfO8HgJ4cvyXWQw9l/ig8KFIl0bFd
M059mBIApIgKrTECQQDouAH+3oYk2hZ8Nlx/WmulW5JDqLAf7FR6PnclHnkM0/mC
GnYEuHlPzUakWepsaTUY8LCl3GpwfDx9U2NTt4hNAkEA1EUkzLd/YPs+9GzkL2W4
ot0sC/JujzDCWKB2d3RIRVo0pbW2pwUEQTy7f1fFpPo3qzJP1DrP+yLCAp3qxPVz
FQJBAJlEJrxOnZZDs69WthCB4odjCa9Zt7Uulmx0G0/tA9g4+wh+mN9/BxZRoYa4
WTXRDFFCo3R49/jhOY1oj/Ag3bkCQA0kwuSSMCb3J6zG2VI+ADLFcybCOipPoJkQ
RoWbA6aXsU7Zc5ff7aWEdy+pZamTfMLy+JJxmdM5Eb5LvO+5KwkCQQCWTte4IvnU
AkH1J5dEDWvpXXX/9NiTxCvdKFI2PJWxpsq6gSkoDwF2Vghe2a+ca1mQB6/HCftp
Ux5Vxey5pUsm
-----END PRIVATE KEY-----' .

"Create envelope"
envelope := GsDigitalEnvelope encryptMessage: msg
	       			 withPublicEncryptionKey: publicKey
				 cipherId: 10
                                 withPrivateSigningKey: aSigningKey.

stream := WriteStream on: String new.
"Convert to passive object format"
PassiveObject passivate: envelope toStream: stream .

"Ready for transport"
^ stream contents
%

category: 'Encrypting'
classmethod: GsDigitalEnvelope
encryptMessage: bytes withPublicEncryptionKey: aGsTlsPublicKey cipherId: anInt
withPrivateSigningKey: aSigningKey

"Encrypts the message in bytes and stores it into an instance of GsDigitalEnvelope.
 Returns the new instance or raises an exception on error.
 See the class comments for more information on GsDigitalEnvelopes."

^ (self encryptMessage: bytes withPublicEncryptionKeys: { aGsTlsPublicKey }
cipherId: anInt withPrivateSigningKey: aSigningKey) first
%

category: 'Encrypting'
classmethod: GsDigitalEnvelope
encryptMessage: bytes withPublicEncryptionKeys: arrayOfPubKeysOrCerts
cipherId: anInt withPrivateSigningKey: aSigningKey
"See the class comments for more information on GsDigitalEnvelopes."

^ self _primEncryptMessage: bytes withPublicEncryptionKeys: arrayOfPubKeysOrCerts
       cipherId: anInt withPrivateSigningKey: aSigningKey
%

category: 'Examples'
classmethod: GsDigitalEnvelope
example

| msg passiveString decryptedMsg |
msg := String withAll:
'Once upon a midnight dreary, while I pondered, weak and weary,
Over many a quaint and curious volume of forgotten lore-
While I nodded, nearly napping, suddenly there came a tapping,
As of some one gently rapping, rapping at my chamber door.
"Tis some visitor, " I muttered, "tapping at my chamber door-
Only this and nothing more."' .

passiveString := GsDigitalEnvelope encryptExampleWithMessage: msg .
decryptedMsg := GsDigitalEnvelope decryptExampleFromString: passiveString .
^ decryptedMsg = msg
%

category: 'Private'
classmethod: GsDigitalEnvelope
_primEncryptMessage: bytes withPublicEncryptionKeys: arrayOfPubKeysOrCerts
cipherId: anInt withPrivateSigningKey: aSigningKey

"A GsDigitalEnvelope is a class used to encrypt data with one or more public
 encryption keys such that the data may only be decrypted with one of the
 matching private keys. Only RSA public/private key pairs are supported.

 To create a secure digital envelope, a random session key and salt are
 created. The session key is then encrypted with each public key provided.

 bytes is message to be encrypted and must be a byte collection. Byte
 collections with a character size greater than one are accepted and will
 be converted to big endian format if necessary before encryption.

 arrayOfPubKeysOrCerts is an array containing at least 1 and no more than 16
 instances of GsTlsPublicKey or GsX509Certificate.

 cipherId determines which AEAD (Authenticated Encryption with Additional
 Data) cipher to use from the following list:

 ================================
                        Key Size
 opCode Cipher   Mode  bits/Bytes
 ================================
   4     AES     OCB     128/16
   5     AES     OCB     192/24
   6     AES     OCB     256/32
   7     AES     GCM     128/16
   8     AES     GCM     192/24
   9     AES     GCM     256/32
  10   CHACHA20 Poly1305 256/32
 ================================

 AEAD guarantees the message has not been altered. Modes 6 and 10 are thought
 to be the most secure and are recommended for most applications.

 aSigningKey must be an instance of GsTlsPrivateKey valid for generating
 digital signatures.

 Returns an Array of GsDigitalEnvelopes (one for each element of arrayOfKeys)
 upon success or raises an exception on error."

<primitive: 1088>
bytes _validateIsBytes .
arrayOfPubKeysOrCerts _validateClass: Array .
arrayOfPubKeysOrCerts size == 0
  ifTrue:[ arrayOfPubKeysOrCerts _error: #objErrCollectionEmpty].
arrayOfPubKeysOrCerts size > 16
  ifTrue:[ arrayOfPubKeysOrCerts _error: #errArgTooLarge args: {16 } ].
arrayOfPubKeysOrCerts do:[:e|
  e _validateClasses: { GsTlsPublicKey . GsX509Certificate } ; _validateIsRsa ] .
anInt _validateClass: SmallInteger .
((anInt < 4) or:[anInt > 10])
  ifTrue:[ anInt _error: #rtErrArgOutOfRange args:{ 4 . 10 } ] .
aSigningKey _validateClass: GsTlsPrivateKey ;
            _validateCreatesDigitalSignatures .
^ self _primitiveFailed:
  #_primEncryptMessage:withPublicEncryptionKeys:cipherId:withPrivateSigningKey:
%

!		Instance methods for 'GsDigitalEnvelope'

category: 'Accessing'
method: GsDigitalEnvelope
cipherId
  ^cipherId
%

category: 'Updating'
method: GsDigitalEnvelope
cipherId: anInt
  cipherId := anInt
%

category: 'Accessing'
method: GsDigitalEnvelope
cipherText
  ^cipherText
%

category: 'Updating'
method: GsDigitalEnvelope
cipherText: aByteArray
  cipherText := aByteArray
%

category: 'Decrypting'
method: GsDigitalEnvelope
decryptWithPrivateKey: aGsTlsPrivateKey withPublicVerificationKey: aPublicKey
"Decrypts the receiver using aGsTlsPrivateKey and stores it
 a new instance of the class name contained in messageClassName.

 All inst vars except for #publicEncryptionKey must be set correctly before
 invoking this method.

 Returns a new instance of messageClassName on success or raises
 an exception on error."
 | cls |
 cls := GsCurrentSession currentSession  objectNamed: self messageClassName  .
 ^ cls
      ifNil:[ self _error: #rtErrObjNotFound
                      args: { self messageClassName } ]
   ifNotNil:[ self _primDecryptWithPrivateKey: aGsTlsPrivateKey
                   into: cls basicNew
                   withPublicVerificationKey: aPublicKey ]
%

category: 'Accessing'
method: GsDigitalEnvelope
digitalSignature
  ^digitalSignature
%

category: 'Updating'
method: GsDigitalEnvelope
digitalSignature: aSig
  digitalSignature := aSig
%

category: 'Accessing'
method: GsDigitalEnvelope
encryptedKey
 ^encryptedKey
%

category: 'Updating'
method: GsDigitalEnvelope
encryptedKey: aByteArray
 encryptedKey := aByteArray
%

category: 'Accessing'
method: GsDigitalEnvelope
initVector
  ^initVector
%

category: 'Updating'
method: GsDigitalEnvelope
initVector: aByteArray
  initVector := aByteArray
%

category: 'Accessing'
method: GsDigitalEnvelope
messageClassName
  ^messageClassName
%

category: 'Updating'
method: GsDigitalEnvelope
messageClassName: aString
  messageClassName := aString
%

category: 'Accessing'
method: GsDigitalEnvelope
publicEncryptionKey
 ^publicEncryptionKey
%

category: 'Updating'
method: GsDigitalEnvelope
publicEncryptionKey: aGsTlsPublicKey
  publicEncryptionKey := aGsTlsPublicKey
%

category: 'Accessing'
method: GsDigitalEnvelope
tag
  ^tag
%

category: 'Updating'
method: GsDigitalEnvelope
tag: aByteArray
  tag := aByteArray
%

category: 'Private'
method: GsDigitalEnvelope
_primDecryptWithPrivateKey: aGsTlsPrivateKey into: aCharColl
withPublicVerificationKey: aPublicKey

<primitive: 1090>

"We don't care about publicEncryptionKey inst var for decryption"
aGsTlsPrivateKey _validateClass: GsTlsPrivateKey ; _validateIsRsa .
aPublicKey _validateClasses: { GsTlsPublicKey . GsX509Certificate } ;
           _validateValidatesDigitalSignatures .
aCharColl    _validateIsBytes .
encryptedKey _validateClass: ByteArray ; _validateNotEmpty .
cipherText   _validateClass: ByteArray ; _validateNotEmpty .
initVector   _validateClass: ByteArray ; _validateNotEmpty .
tag          _validateClass: ByteArray ; _validateNotEmpty .
digitalSignature _validateClass: ByteArray ; _validateNotEmpty .
cipherId     _validateClass: SmallInteger .
((cipherId < 4) or:[cipherId > 10])
  ifTrue:[ cipherId _error: #rtErrArgOutOfRange args:{ 4 . 10 } ] .
^ self _primitiveFailed:
  #_primDecryptWithPrivateKey:into:withPublicVerificationKey:
%

! Class implementation for 'GsFileIn'

!		Class methods for 'GsFileIn'

category: 'File in'
classmethod: GsFileIn
fromClientPath: aString
"file in from path on session client machine into current session"
	self
		fromGciHostPath: aString
		to: nil.
%

category: 'Deprecated'
classmethod: GsFileIn
fromClientPath: aString to: anExternalSession
	self deprecated: 'GsFileIn class >> fromClientPath:to: deprecated v3.7.  Use fromGciHostPath:to:'.
	self
		fromPath: aString
		on: #clientText
		to: anExternalSession.
%

category: 'File in'
classmethod: GsFileIn
fromGciHostPath: aString

	self
		fromGciHostPath: aString
		to: nil.
%

category: 'File in'
classmethod: GsFileIn
fromGciHostPath: aString to: anExternalSession

	self
		fromPath: aString
		on: #clientText
		to: anExternalSession.
%

category: 'File in'
classmethod: GsFileIn
fromGemHostPath: aString

	self
		fromGemHostPath: aString
		to: nil.
%

category: 'File in'
classmethod: GsFileIn
fromGemHostPath: aString to: anExternalSession

	self
		fromPath: aString
		on: #serverText
		to: anExternalSession.
%

category: 'File in'
classmethod: GsFileIn
fromPath: aString on: aFileType to: anExternalSession
  ^ self fromPath: aString on: aFileType to: anExternalSession 
       sourceClass: StringConfiguration"from Globals" .
%

category: 'File in'
classmethod: GsFileIn
fromPath: aString on: aFileType to: anExternalSession sourceClass: aClass
"aString is file path to file containg topaz file-out format of smalltalk code.
type is one of #clientFile #serverFile  #clientUtf8File #serverUtf8File 
to denote relative user action to use.
If anExternalSession is not nil, it must be a GsTsExternalSession and file-in executes 
into that session"

	(self _fromPath: aString type: aFileType sourceClass: aClass)
      		session: anExternalSession; 
		doFileIn	
%

category: 'File in'
classmethod: GsFileIn
fromServerPath: aString
	self
		fromGemHostPath: aString
		to: nil.
%

category: 'Deprecated'
classmethod: GsFileIn
fromServerPath: aString to: anExternalSession
	self deprecated: 'GsFileIn class >> fromServerPath:to: deprecated v3.7, use fromGemHostPath:to:'.
	self
		fromPath: aString
		on: #serverText
		to: anExternalSession.
%

category: 'File in'
classmethod: GsFileIn
fromStream: aStream
  ^ (self newFromStream: aStream) doFileIn
%

category: 'Instance Creation'
classmethod: GsFileIn
new
  | inst |
	(inst := super new) initialize .
  ^ inst
%

category: 'Instance Creation'
classmethod: GsFileIn
newFromStream: aStream
	| inst srcCls species |
	species := aStream collectionSpecies.
	(species inheritsFrom: CharacterCollection)
		ifTrue: [ srcCls := species ]
		ifFalse: [ 
			species == UndefinedObject
				ifTrue: [ srcCls := StringConfiguration ]
				ifFalse: [ 
					ArgumentError
						signal: 'expected a string or unicode string, got a ' , species name ] ].
	(inst := self new)
		stream: aStream;
		clientFiles: false;
		sourceStringClass: srcCls;
		fileFormat: #'utf8'.
	^ inst
%

category: 'private'
classmethod: GsFileIn
_fromPath: aString type: aFileType sourceClass: aClass
  "Returns an Array { aStream . clientFilesBoolean } "
	| aFile fBytes aStream isClient fmt inst |
  fmt := (aFileType == #clientUtf8File or:[ aFileType == #serverUtf8File])  
         ifTrue:[ #utf8 ] ifFalse:[ #'8bit' ].
  (aFileType == #clientText or:[ aFileType == #clientUtf8File]) ifTrue:[
    isClient := true .
    aFile := GsFile open: aString mode: 'r' onClient: true .
  ].
	(aFileType == #serverText or:[ aFileType == #serverUtf8File]) ifTrue:[
    isClient := false .
		aFile := GsFile open: aString mode: 'r' onClient: false .
  ].
  isClient ifNil:[
     ArgumentError signal:'unknown file type ', aFileType printString .
  ].
  (aClass == Unicode16 or:[ aClass == String]) ifFalse:[
    ArgumentError signal:'source class is neither Unicode16 nor String, ', aClass name .
  ].
  aFile ifNil:[ ^ Error signal:'File open failed, path ', aString printString,
      '; ', GsFile lastErrorString ].
  fBytes := aFile contents .
  fBytes ifNil:[ ^ Error signal:'File read failed, ', aFile lastErrorString ].
  aFile close .
  (aFileType == #clientUtf8File or:[ aFileType == #serverUtf8File]) ifTrue:[
    aClass == Unicode16 ifTrue:[ fBytes := fBytes decodeFromUTF8ToUnicode ]
                       ifFalse:[ fBytes := fBytes decodeFromUTF8ToString ].
  ] ifFalse:[
    aClass == Unicode16 ifTrue:[ 
      fBytes := Unicode7 withAll: fBytes .
      fBytes class ~~ Unicode7 ifTrue:[ 
        Error signal: 'File contains code points > 127, and utf8 not specified'.
      ]. 
    ].
  ].
	aStream := ReadByteStreamPortable on: fBytes .
  (inst := self new)
     path: aString ; stream: aStream ; clientFiles: isClient ;
     sourceStringClass: aClass ;
     fileFormat: fmt .
  ^ inst
%

category: 'private'
classmethod: GsFileIn
_remoteCompile: srcUtf8 categ: catUtf8 class: aClass unicode: uBool env: envId classMeth: clsMethBool
  | src cat cls |
  uBool ifTrue:[
    src := srcUtf8 decodeToUnicode .
    cat := catUtf8 decodeToUnicode .
  ] ifFalse:[ 
    src := srcUtf8 decodeToString .
    cat := catUtf8 decodeToString .
  ].
  cls := clsMethBool ifTrue:[ aClass class ] ifFalse:[ aClass ] .
  cls compileMethod: src category: cat environmentId: envId
%

category: 'private'
classmethod: GsFileIn
_remoteTraitCompile: srcUtf8 categ: catUtf8 trait: aTrait unicode: uBool classMeth: clsMethBool
  | src cat trait |
  uBool ifTrue:[
    src := srcUtf8 decodeToUnicode .
    cat := catUtf8 decodeToUnicode .
  ] ifFalse:[ 
    src := srcUtf8 decodeToString .
    cat := catUtf8 decodeToString .
  ].
  trait := clsMethBool ifTrue:[ aTrait classTrait ] ifFalse:[ aTrait ] .
  trait compile: src category: cat
%

category: 'private'
classmethod: GsFileIn
_remoteUnicodeExecute: aUtf8
  | src |
  src := aUtf8 decodeToUnicode .
  ^ src evaluate 
%

category: 'private'
classmethod: GsFileIn
_removeAllClassMethods: aClass
  aClass class removeAllMethods .
%

category: 'private'
classmethod: GsFileIn
_resolveClass: aString
  | assoc sym cls |
  sym := Symbol _existingWithAll: aString . 
  sym ifNil:[ ^ self error: 'invalid class name ', aString printString ].
  assoc := GsCurrentSession currentSession resolveSymbol: sym .
  assoc ifNil:[ ^ self error: 'class name not found ' , aString printString ].
  cls := assoc _value .
  cls isBehavior ifFalse:[ ^ self error: 'value of ', aString printString,' is not a Behavior'].
  cls isMeta ifTrue:[ ^ self error: 'value of ', aString printString,' is a Metaclass'].
  ^ cls
%

category: 'private'
classmethod: GsFileIn
_resolveTrait: aString
  | assoc sym trait |
  sym := Symbol _existingWithAll: aString . 
  sym ifNil:[ ^ self error: 'invalid trait name ', aString printString ].
  assoc := GsCurrentSession currentSession resolveSymbol: sym .
  assoc ifNil:[ ^ self error: 'class trait not found ' , aString printString ].
  trait := assoc _value .
  trait isTrait ifFalse:[ ^ self error: 'value of ', aString printString,' is not a Trait'].
  ^ trait
%

category: 'private'
classmethod: GsFileIn
_traitRemoveAllClassMethods: aTrait
  aTrait classTrait removeAllMethods .
%

!		Instance methods for 'GsFileIn'

category: 'processing'
method: GsFileIn
abort
  ^ self abortTransaction
%

category: 'processing'
method: GsFileIn
abortTransaction
	session ifNotNil:[:sess | sess abort ] ifNil:[ System abortTransaction ]
%

category: 'processing'
method: GsFileIn
category
  | cat words |
  words := self words: line .
  ((cat := words atOrNil: 2) codePointCompareTo: ':') == 0 ifTrue:[
    cat := words atOrNil:3 .
  ].
  cat ifNil:[ Error signal:'missing argument to CATEGORY'].
	self currentCategory: cat
%

category: 'processing'
method: GsFileIn
classMethod
  self parseClassmethodLine ; 
        classMethodBody .
%

category: 'processing'
method: GsFileIn
classMethodBody
  | src |
	currentClassObj ifNil: [self error: 'current class not defined'].
  src := self nextChunk .
  session ifNil:[
    currentClassObj class compileMethod: src 
       category: category 
       environmentId: compileEnvironment.
  ] ifNotNil:[ 
    self _remoteMethod: src classMethod: true 
  ]
%

category: 'accessors'
method: GsFileIn
clientFiles: aBoolean
  clientFiles := aBoolean .
%

category: 'processing'
method: GsFileIn
commit
  ^ self commitTransaction
%

category: 'processing'
method: GsFileIn
commitTransaction
	session ifNotNil:[:sess | sess commit ] ifNil:[ System commit ]
%

category: 'processing'
method: GsFileIn
compileEnvironment: arg
  | env |
	arg isDigits ifFalse:[ ^ self error: 'ENV  only accepts integers'].
  env := Integer fromString: arg .
  (env < 0 or:[ env > 255]) ifTrue:[ self error:'arg to ENV must be in range 0..255' ].
  compileEnvironment := env .
%

category: 'processing'
method: GsFileIn
currentCategory: cat
  "implementation of SET CATEGORY"
  category := cat .
	cat isEmpty ifTrue: [self error: 'category is empty'].
	cat first = $' ifTrue: [
		cat last = $' ifFalse:[
      self error: 'category begins with quote but does not end with quote'
    ].
		category := cat copyFrom: 2 to: category size - 1.
	] ifFalse:[
    cat last = $' ifTrue:[
       self error: 'category ends with quote but does not start with quote'.
    ].
  ].
	(category includes: $') ifTrue:[ category := cat evaluate ].
%

category: 'processing'
method: GsFileIn
currentClass
  "Returns a String (a class name) "
	^ currentClassName
%

category: 'processing'
method: GsFileIn
currentClass: aClassName
    "The current category is cleared by the LOGOUT, LOGIN, SET CLASS,
    and SET SESSION commands. "

	self _setClass: aClassName .
	category := self _defaultCategory.
%

category: 'processing'
method: GsFileIn
currentTrait: aTraitName
	self _setTrait: aTraitName .
%

category: 'processing'
method: GsFileIn
doFileFormat: aString
  | arg |
  aString ifNil:[ Error signal:'missing argument to FILEFORMAT'].
  arg := aString asLowercase .
  (arg codePointCompareTo: 'utf8') == 0 ifTrue:[
    fileFormat == #utf8 ifFalse:[ | bytes str |
      bytes := stream upToEnd . 
      bytes charSize > 1 ifTrue:[ Error signal:'Stream aleady decoded to ', bytes class name].
      str := sourceStringClass == Unicode7 
              ifTrue:[ bytes decodeFromUTF8ToUnicode ]
              ifFalse:[ bytes decodeFromUTF8ToString ].
      stream := ReadByteStreamPortable on: str .
      fileFormat := #utf8 .
    ].
    ^ self
  ].
  (arg codePointCompareTo: '8bit') == 0 ifTrue:[
    fileFormat == #'8bit' ifFalse:[ | bytes str |
      bytes := stream upToEnd encodeAsUTF8 .
      str := bytes decodeFromUTF8ToString .
      str class == String ifFalse:[
        Error signal:'for FILEFORMAT 8BIT, remaining bytes have codePoint(s) above 255' .
      ].
      stream := ReadByteStreamPortable on: str .
      fileFormat := #'8bit' .
    ].
    ^ self
  ].
  ^ self error:'unrecognized fileformat ', aString printString  .
%

category: 'processing'
method: GsFileIn
doFileIn
 [ lineNum := 0 .
	 [
		 stream atEnd not.
	 ] whileTrue: [
		 line := stream nextLine trimSeparators.
     lineNum := lineNum + 1 .
		 [
       self processLine
     ] on: Error do:[:ex | | loc |
       loc := ', at line ', lineNum asString .
       path ifNotNil:[ loc add:' file ', path asString ].
       ex messageText ifNil:[ ex messageText: loc ]
                   ifNotNil:[:str | ex messageText:(str copy addAll: loc; yourself)].
       ex pass
     ]
	 ]
 ] ensure: [ 
   "topmost doFileIn should clear the topaz sesion state"
    self _clearTopazSessionState ifTrue: [ 
        self currentProject: nil. 
        self currentPackage: nil 
    ]
  ]
%

category: 'processing'
method: GsFileIn
doit

	self execute: self nextChunk.
%

category: 'processing'
method: GsFileIn
execute: aString
  session ifNil:[ 
    aString evaluate .
  ] ifNotNil:[:sess | 
    sourceStringClass == String ifTrue:[
	    sess executeString: aString .
    ] ifFalse:[ | srcOop |
      srcOop := sess newUtf8String: aString encodeAsUTF8 toUnicode: false.
      [ sess send: '_remoteUnicodeExecute:' to: remoteGsFileInClassOop 
               withOops: { srcOop } .
      ] ensure:[ 
        sess releaseOop: srcOop .
      ]
    ]
  ].
%

category: 'processing'
method: GsFileIn
executeString:  string

	string evaluate.
	^nil
%

category: 'accessors'
method: GsFileIn
fileFormat
  ^ fileFormat ifNil:[ #'8bit' ].
%

category: 'accessors'
method: GsFileIn
fileFormat: aSymbol
  (aSymbol == #'8bit' or:[ aSymbol == #utf8 ]) ifFalse:[
     ArgumentError signal:'invalid file format'
  ].
  fileFormat := aSymbol
%

category: 'processing'
method: GsFileIn
ignoreList

	^#('EXPECTVALUE'
		'EXPECTERROR'
		'ERRORCOUNT'
		'FILEOUT'
		'DISPLAY'
		'LEVEL'
		'LIMIT'
		'LIST'
		'IFERR'
		'IFERR_LIST'
		'IFERR_CLEAR'
		'OMIT'
		'OUTPUT'
		'REMARK'
		'STATUS'
		'TIME'
		'LOGIN'
		'LOGOUT')
%

category: 'initialize'
method: GsFileIn
initialize

	category := self _defaultCategory.
	compileEnvironment := 0 .
%

category: 'processing'
method: GsFileIn
inputNestedFile: aPath
	"input nested file"
	| aType |
  aType := self _nestedType .
  (self class _fromPath: aPath type: aType sourceClass: self sourceStringClass)
     session: session ;
     _clearTopazSessionState: false ;
     doFileIn .
%

category: 'processing'
method: GsFileIn
method
  self parseMethodLine ;
       methodBody
%

category: 'processing'
method: GsFileIn
methodBody
  | src |
	currentClassObj ifNil: [self error: 'current class not defined'].
  src := self nextChunk .
  session ifNil:[
    currentClassObj compileMethod: src 
       category: category 
       environmentId: compileEnvironment.
  ] ifNotNil:[ 
    self _remoteMethod: src classMethod: false
  ]
%

category: 'processing'
method: GsFileIn
nextChunk
	| str |
	str := sourceStringClass new. "String or Unicode7"
	[
		stream atEnd not.
	] whileTrue: [
		line := stream nextLine .
    lineNum := lineNum + 1 .
    (line notEmpty and: [line first = $%]) ifTrue: [
			^ str
		].
		str addAll: line; lf.
	].
  ^ str "EOF equivalent to % terminator"
%

category: 'processing'
method: GsFileIn
parseClassmethodLine
  | words |
  words := self words: line .
  (words atOrNil:2) ifNotNil:[:s |
     (s codePointCompareTo: ':') == 0 ifTrue:[ Error signal:'illegal class specification '':'' '].
     self _setClass: s . 
  ].
%

category: 'processing'
method: GsFileIn
parseMethodLine
	| words |
  words := self words: line .
  (words atOrNil:2) ifNotNil:[:s |
     (s codePointCompareTo: ':') == 0 ifTrue:[ Error signal:'illegal class specification '':'' ' ].
     self _setClass: s . 
  ].
%

category: 'processing'
method: GsFileIn
parseTraitClassmethodLine
  | words |
  words := self words: line .
  (words atOrNil:2) ifNotNil:[:s |
     (s codePointCompareTo: ':') == 0 ifTrue:[ Error signal:'illegal trait specification '':'' '].
     self _setTrait: s . 
  ].
%

category: 'processing'
method: GsFileIn
parseTraitmethodLine
  | words |
  words := self words: line .
  (words atOrNil:2) ifNotNil:[:s |
     (s codePointCompareTo: ':') == 0 ifTrue:[ Error signal:'illegal trait specification '':'' '].
     self _setTrait: s . 
  ].
%

category: 'accessors'
method: GsFileIn
path: aString
	path := aString .
%

category: 'processing'
method: GsFileIn
processLine
	| words command firstChar |
	(line size == 0) ifTrue: [^self].
	words := line subStrings . 
	command := (words at:1) asUppercase.
  command isUnicodeString ifTrue:[ command := String withAll: command ].
	(#('DOIT' 'PRINTIT' 'RUN' 'NBRUN') includes: command) ifTrue:[
     ^self doit
  ].
	((firstChar := command at:1) == $! or:[ firstChar == $#])  ifTrue: [^nil].

	firstChar == $S ifTrue:[
	  command = 'SET' ifTrue: [
		  ((words at: 2) equalsNoCase: 'compile_env:') ifTrue:[
				words size == 3 ifFalse:[
					self error:'wrong number of arguments to SET COMPILE_ENV:'
				].
				^self compileEnvironment: (words at: 3)
			].
		  (((words at: 2) equalsNoCase: 'class')
			  or: [(words at: 2) equalsNoCase: 'class:']) ifTrue: [
				  words size == 3 ifFalse:[
					  self error:'wrong number of arguments to SET CLASS'
				  ].
				  ^self currentClass: (words at: 3)
           ].
		  (((words at: 2) equalsNoCase: 'trait')
			  or: [(words at: 2) equalsNoCase: 'trait:']) ifTrue: [
				  words size == 3 ifFalse:[
					  self error:'wrong number of arguments to SET TRAIT'
				  ].
				  ^self currentTrait: (words at: 3)
           ].
		  (((words at: 2) equalsNoCase: 'category')
			  or: [(words at: 2) equalsNoCase: 'category:']) ifTrue: [
				  words size == 3 ifFalse:[
					  self error:'wrong number of arguments to SET CATEGORY'
				  ].
				  ^self currentCategory: (words at: 3)
			  ].
		  ((words at: 2) equalsNoCase: 'enableremoveall') ifTrue: [
				  words size == 3 ifFalse:[
					  self error:'wrong number of arguments to SET ENABLEREMOVEALL'
				  ].
				  ^self setEnableRemoveAll: ((words at: 3) equalsNoCase: 'on')
			  ].
		  (((words at: 2) equalsNoCase: 'project')
			  or: [(words at: 2) equalsNoCase: 'project:']) ifTrue: [
                  words size == 2 ifTrue: [ 
                      "clear current project"
                      ^self currentProject: nil ].
				  words size == 3 ifFalse:[
					  self error:'wrong number of arguments to SET PROJECT'
				  ].
				  ^self currentProject: (words at: 3)
			  ].
		  (((words at: 2) equalsNoCase: 'package')
			  or: [(words at: 2) equalsNoCase: 'package:']) ifTrue: [
                  words size == 2 ifTrue: [ 
                      "clear current package"
                      ^self currentPackage: nil ].
				  words size == 3 ifFalse:[
					  self error:'wrong number of arguments to SET PACKAGE'
				  ].
				  ^self currentPackage: (words at: 3)
			  ].
		  ((words at: 2) equalsNoCase: 'sourcestringclass') ifTrue:[ | cName |
				words size == 3 ifFalse:[
					self error:'wrong number of arguments to SET SOURCESTRINGCLASS'
				].
        cName := String withAll:(words at: 3) .
        cName = 'String' ifTrue:[ self sourceStringClass: String ] ifFalse:[
        cName = 'Unicode16' ifTrue:[ 
           self sourceStringClass: Unicode16 ; doFileFormat: 'utf8' 
        ] ifFalse:[ self error:'arg to SET SOURCESTRINGCLASS must be String or Unicode16'. ]]. 
        ^ self  
      ].
      #( 'comp' 'cla' 'cat' 'enable' 'proj' 'pack' 'so' ) do:[:str |
        ((words at: 2) at: 1 equals: str) ifTrue:[
           self error:'unrecognized SET ', (words at: 2) asString .
        ].
      ].
      GsFile gciLogServer: 'WARNING, unrecognized SET ', (words at: 2) asString.
		  ^nil
    ].
    command = 'SEND' ifTrue:[
      self _sendIsLegal ifFalse:[ self error: 'SEND not supported' ].
      words size > 3 ifTrue:[ self error:'more than 2 args to SEND'].
      ^ self execute: (words at: 2), ' ', (words at: 3)
    ]
  ].
  firstChar == $C ifTrue:[
	  (command = 'CATEGORY:' or: [command = 'CATEGORY']) ifTrue: [^self category].
	  command = 'CLASSMETHOD' ifTrue: [^self classMethod ].
	  command = 'CLASSMETHOD:' ifTrue: [^self classMethod ].
	  command = 'COMMIT' ifTrue: [^self commitTransaction].
  ].
  firstChar == $M ifTrue:[
	  command = 'METHOD' ifTrue: [^self method ].
	  command = 'METHOD:' ifTrue: [^self method ].
  ].
  firstChar == $E ifTrue:[
    command = 'ENV' ifTrue:[
      words size == 2 ifTrue:[ ^ self compileEnvironment: (words at: 2)].
      words size == 1 ifTrue:[ ^ nil "no change to env"].
      self error:'wrong number of arguments to ENV'.
    ].
   ].
	firstChar == $R ifTrue: [
		command = 'REMOVEALLMETHODS' ifTrue: [^self removeAllMethods: (words atOrNil: 2)].
		command = 'REMOVEALLCLASSMETHODS' ifTrue: [^self removeAllClassMethods: (words atOrNil: 2)].
	].
	firstChar == $A ifTrue: [
		command = 'ABORT' ifTrue: [^self abort ].
	].
	firstChar == $I ifTrue: [
		command = 'INPUT' ifTrue: [words size == 1 ifTrue: [self error:'wrong number of arguments to input'].
		  ^self inputNestedFile: (words at: 2)
    ].
	].
  firstChar == $F ifTrue:[
    command = 'FILEFORMAT' ifTrue:[
      ^ self doFileFormat: (words atOrNil: 2).
    ]
  ].
  firstChar == $T ifTrue:[
    command = 'TFILE' ifTrue:[ | reader |  
      reader := (Globals at: #RowanKernel_tonel) at: #RwTopazTonelReader .
      ^ reader perform: #topazReadTonelFile: with: (words atOrNil: 2).
    ].
	command = 'TRCLASSMETHOD' ifTrue: [^self traitClassMethod ].
	command = 'TRCLASSMETHOD:' ifTrue: [^self traitClassMethod ].
	command = 'TRMETHOD' ifTrue: [^self traitMethod ].
	command = 'TRMETHOD:' ifTrue: [^self traitMethod ].
    command = 'TRREMOVEALLMETHODS'
      ifTrue: [ ^ self traitRemoveAllMethods: (words atOrNil: 2) ].
    command = 'TRREMOVEALLCLASSMETHODS'
      ifTrue: [ ^ self traitRemoveAllClassMethods: (words atOrNil: 2) ]  ].
    
  ^(self ignoreList includes: command)
		ifTrue: [nil ]
		ifFalse: [self error:  'unrecognized command: ' , command printString ].
%

category: 'processing'
method: GsFileIn
removeAllClassMethods

	self removeAllEnabled ifFalse: [ ^ self ].
	currentClassObj ifNil: [self error: 'current class not defined'].
  session ifNil:[
	  currentClassObj  class removeAllMethods
  ] ifNotNil:[
    session send: '_removeAllClassMethods:' to: remoteGsFileInClassOop
         withOops: { currentClassObj }
  ]
%

category: 'processing'
method: GsFileIn
removeAllClassMethods: aClassName
"removes all  class methods for supplied class. Supplied class becomes current class"

	self removeAllEnabled ifFalse: [ ^ self ].
	aClassName ifNotNil: [ self _setClass: aClassName ].
	currentClassObj ifNil: [self error: 'current class not defined'].
	self removeAllClassMethods
%

category: 'accessors'
method: GsFileIn
removeAllEnabled
	"if true (default), removeAllMethods is enabled"

	^ removeAll ~~ false
%

category: 'processing'
method: GsFileIn
removeAllMethods

	self removeAllEnabled ifFalse: [ ^ self ].
	currentClassObj ifNil: [self error: 'current class not defined'].
  session ifNil:[
    currentClassObj removeAllMethods
  ] ifNotNil:[
    session send: 'removeAllMethods' to: currentClassObj withArguments:#() 
  ]
%

category: 'processing'
method: GsFileIn
removeAllMethods: aClassName
"remove all methods for supplied class. Supplied class becomes current class"

	self removeAllEnabled ifFalse: [ ^ self ].
	aClassName ifNotNil: [ self _setClass: aClassName ].
	currentClassObj ifNil: [self error: 'current class not defined'].
	self removeAllMethods
%

category: 'accessors'
method: GsFileIn
session: anExternalSession
    "The current category is cleared by the LOGOUT, LOGIN, SET CLASS,
    and SET SESSION commands. "

  (session := anExternalSession) ifNotNil:[:sess|
    remoteGsFileInClassOop := (sess executeString:'GsFileIn') at: 1 "anOop".
  ].
	category := self _defaultCategory.
%

category: 'accessors'
method: GsFileIn
setCurrentClass: aClassName
    "The current category is cleared by the LOGOUT, LOGIN, SET CLASS,
    and SET SESSION commands. "

	self currentClass: aClassName
%

category: 'accessors'
method: GsFileIn
setCurrentTrait: aTraitName
	self currentTrait: aTraitName
%

category: 'accessors'
method: GsFileIn
setEnableRemoveAll: aBool
	"if true (default), removeAllMethods is enabled"
	removeAll := aBool
%

category: 'accessors'
method: GsFileIn
setSession: aSession
	aSession ifNotNil:[ 
    (aSession isKindOfClass: GsTsExternalSession) ifFalse:[
      ArgumentError signal: 'Expected a GsTsExternalSession, got a ', aSession class name .
    ]
  ].
  session := aSession .
%

category: 'accessors'
method: GsFileIn
sourceStringClass

  | cls |
  (cls := sourceStringClass) == Unicode7 ifTrue:[ ^ Unicode16].
  ^ cls  "String"
%

category: 'accessors'
method: GsFileIn
sourceStringClass: aClass
  aClass == String ifTrue:[ 
    sourceStringClass := aClass 
  ] ifFalse:[
    aClass == Unicode16 ifTrue:[
      sourceStringClass := Unicode7 
    ] ifFalse:[
      ArgumentError signal:'argument must be String or Unicode16'.
    ]
  ]
%

category: 'accessors'
method: GsFileIn
stream: aFileStream
	stream := aFileStream.
%

category: 'processing'
method: GsFileIn
traitClassMethod
  self parseTraitmethodLine ; 
       traitClassMethodBody .
%

category: 'processing'
method: GsFileIn
traitClassMethodBody
  | src |
	currentTraitObj ifNil: [self error: 'current trait not defined'].
  src := self nextChunk .
  session ifNil:[
    currentTraitObj classTrait compile: src 
       category: category.
  ] ifNotNil:[ 
    self _remoteTraitMethod: src classMethod: true 
  ]
%

category: 'processing'
method: GsFileIn
traitMethod
  self parseTraitmethodLine ; 
       traitMethodBody .
%

category: 'processing'
method: GsFileIn
traitMethodBody
  | src |
	currentTraitObj ifNil: [self error: 'current trait not defined'].
  src := self nextChunk .
  session ifNil:[
    currentTraitObj compile: src 
       category: category.
  ] ifNotNil:[ 
    self _remoteTraitMethod: src classMethod: false
  ]
%

category: 'processing'
method: GsFileIn
traitRemoveAllClassMethods

	self removeAllEnabled ifFalse: [ ^ self ].
	currentTraitObj ifNil: [self error: 'current trait not defined'].
  session ifNil:[
	  currentTraitObj  classTrait removeAllMethods
  ] ifNotNil:[
    session send: '_traitRemoveAllClassMethods:' to: remoteGsFileInClassOop
         withOops: { currentTraitObj }
  ]
%

category: 'processing'
method: GsFileIn
traitRemoveAllClassMethods: aTraitName
"removes all  class methods for supplied class. Supplied class becomes current class"

	self removeAllEnabled ifFalse: [ ^ self ].
	aTraitName ifNotNil: [ self _setTrait: aTraitName ].
	currentTraitObj ifNil: [self error: 'current trait not defined'].
	self traitRemoveAllClassMethods
%

category: 'processing'
method: GsFileIn
traitRemoveAllMethods

	self removeAllEnabled ifFalse: [ ^ self ].
	currentTraitObj ifNil: [self error: 'current trait not defined'].
  session ifNil:[
    currentTraitObj removeAllMethods
  ] ifNotNil:[
    session send: 'removeAllMethods' to: currentTraitObj withArguments:#() 
  ]
%

category: 'processing'
method: GsFileIn
traitRemoveAllMethods: aTraitName
"remove all methods for supplied trait. Supplied trait becomes current trait"

	self removeAllEnabled ifFalse: [ ^ self ].
	aTraitName ifNotNil: [ self _setTrait: aTraitName ].
	currentTraitObj ifNil: [self error: 'current trait not defined'].
	self traitRemoveAllMethods
%

category: 'private'
method: GsFileIn
words: lineArg
  | arr n cls aLine aWord |
  aLine := lineArg trimSeparators .
  arr := { } .
  aWord := (cls := aLine class) new . 
  n := 1 .
  [ n <= aLine size ] whileTrue:[ | ch |
    ch := aLine at: n .
    ch isSeparator ifTrue:[ 
      aWord size > 0 ifTrue:[ arr add: aWord . aWord := cls new ].
      n := n + 1 .
      aWord := cls new .
      [ (ch := aLine atOrNil: n) ~~ nil and:[ ch isSeparator]] whileTrue:[ n := n + 1 ].
    ] ifFalse:[
       ch == $' ifTrue:[ | done |
         aWord size > 0 ifTrue:[ arr add: aWord . aWord := cls new ].
         n := n + 1 .
         [ n < aLine size and:[ done == nil] ] whileTrue:[
           ch := aLine at: n .
           ch == $' ifTrue:[
             (aLine atOrNil: n+1) == $' ifTrue:[ n := n + 2 .  aWord add: $' ]
                 ifFalse:[ done := true . arr add: aWord . aWord := cls new ].
           ] ifFalse:[
             aWord add: ch .
           ].
           n := n + 1 .
         ].
       ] ifFalse:[
        aWord add: ch .
        n := n + 1 .
      ] 
    ]. 
  ].
  aWord size > 0 ifTrue:[
    arr add: aWord .
  ].
  ^ arr
%

category: 'accessors'
method: GsFileIn
_clearTopazSessionState
	^ clearTopazSessionState == true
%

category: 'accessors'
method: GsFileIn
_clearTopazSessionState: aBool
  clearTopazSessionState := aBool .
%

category: 'private'
method: GsFileIn
_defaultCategory
	^ 'as yet unspecified'
%

category: 'private'
method: GsFileIn
_nestedType
  ^ clientFiles ifTrue:[
     fileFormat == #utf8 ifTrue:[ #clientUtf8File ] ifFalse:[ #clientText ]
   ] ifFalse:[
    fileFormat == #utf8 ifTrue:[ #serverUtf8File ] ifFalse:[ #serverText ]
   ]
%

category: 'private'
method: GsFileIn
_remoteMethod: srcArg classMethod: clsMethBool
  | remoteSrcOop remoteCategOop sess |
  sess := session .
	remoteSrcOop := sess newUtf8String: srcArg encodeAsUTF8 toUnicode: false. 
	remoteCategOop := sess newUtf8String: category encodeAsUTF8 toUnicode: false. 
	[ sess send: '_remoteCompile:categ:class:unicode:env:classMeth:'
          to: remoteGsFileInClassOop
          withOops: { remoteSrcOop . remoteCategOop . currentClassObj . 
                   (sourceStringClass == Unicode7) asOop .  
                   compileEnvironment asOop . clsMethBool asOop }.
  ] ensure:[
	  sess releaseOop: remoteSrcOop ; releaseOop: remoteCategOop .
  ]
%

category: 'private'
method: GsFileIn
_remoteTraitMethod: srcArg classMethod: clsMethBool
  | remoteSrcOop remoteCategOop sess |
  sess := session .
	remoteSrcOop := sess newUtf8String: srcArg encodeAsUTF8 toUnicode: false. 
	remoteCategOop := sess newUtf8String: category encodeAsUTF8 toUnicode: false. 
	[ sess send: '_remoteTraitCompile:categ:trait:unicode:classMeth:'
          to: remoteGsFileInClassOop
          withOops: { remoteSrcOop . remoteCategOop . currentTraitObj . 
                   (sourceStringClass == Unicode7) asOop .  
                    clsMethBool asOop }.
  ] ensure:[
	  sess releaseOop: remoteSrcOop ; releaseOop: remoteCategOop .
  ]
%

category: 'private'
method: GsFileIn
_resolveClass: aString 
  session ifNil:[  
    ^ self class _resolveClass: aString 
  ] ifNotNil:[:sess| | strOop res |
    strOop := sess newUtf8String: aString encodeAsUTF8 toUnicode: true .
    res := sess send: '_resolveClass:' to: remoteGsFileInClassOop withOops: { strOop }.
    ^ (res at: 1) "anOop"
  ]
%

category: 'private'
method: GsFileIn
_resolveTrait: aString 
  session ifNil:[  
    ^ self class _resolveTrait: aString 
  ] ifNotNil:[:sess| | strOop res |
    strOop := sess newUtf8String: aString encodeAsUTF8 toUnicode: true .
    res := sess send: '_resolveTrait:' to: remoteGsFileInClassOop withOops: { strOop }.
    ^ (res at: 1) "anOop"
  ]
%

category: 'private'
method: GsFileIn
_sendIsLegal
  ^ true
%

category: 'private'
method: GsFileIn
_setClass: aString
  | cls |
  cls := self _resolveClass: aString .
  currentClassObj := cls . "an object or oop of a remote object"
  self _setCurrentClassName: aString . 
%

category: 'private'
method: GsFileIn
_setCurrentClassName: aString
	currentClassName := aString
%

category: 'private'
method: GsFileIn
_setCurrentTraitName: aString
	currentTraitName := aString
%

category: 'private'
method: GsFileIn
_setTrait: aString
  | trait |
  trait := self _resolveTrait: aString .
  currentTraitObj := trait . "an object or oop of a remote object"
  self _setCurrentTraitName: aString .
%

! Class implementation for 'GsObjectInventory'

!		Class methods for 'GsObjectInventory'

category: 'Garbage Analysis'
classmethod: GsObjectInventory
fastProfileGarbageFromFile: aFilename includeHiddenObjects: aBoolean

"Same as the #profileGarbageFromFile:includeHiddenObjects: method
 except the scan is performed  aggressively in order to complete
 in as little time as possible.

 This method may consume most or all host system resources while it
 is in progress."

System needsCommit
    ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .
(GsBitmap newForHiddenSet: #GcCandidates) removeAll.
SystemRepository loadGcCandidatesFromFile: aFilename intoHiddenSet: #GcCandidates .
^ self _objInventory: SystemRepository _aggressiveMaxThreadCount waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 95 showHiddenClasses: aBoolean
       objsIn: (GsBitmap newForHiddenSet: #GcCandidates)
       listInstances: nil toFile: nil inMemory: 0
%

category: 'Profiling'
classmethod: GsObjectInventory
fastProfileObjectsIn: aCollectionOrGsBitmap

"Same as the #profileObjectsIn: method except the scan is performed
 aggressively in order to complete in as little time as possible.

 This method may consume most or all host system resources while it
 is in progress."

| anArray objInvBm |
System needsCommit
  ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .
(aCollectionOrGsBitmap isKindOf: GsBitmap)
  ifTrue: [ objInvBm := aCollectionOrGsBitmap ]
  ifFalse: [ anArray := aCollectionOrGsBitmap asArray.
             objInvBm := GsBitmap newForHiddenSet: #ObjInventory.
             objInvBm removeAll.
             objInvBm addAll: anArray ].

^ self _objInventory: SystemRepository _aggressiveMaxThreadCount waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 95 showHiddenClasses: true objsIn: objInvBm
       listInstances: nil toFile: nil inMemory: 0
%

category: 'Profiling'
classmethod: GsObjectInventory
fastProfileObjectsInHiddenSet: hiddenSetSpecifier showHiddenClasses: aBool

"Same as the #profileObjectsInHiddenSet:showHiddenClasses: method
 except the scan is performed  aggressively in order to complete
 in as little time as possible.

 This method may consume most or all host system resources while it
 is in progress."

System needsCommit
    ifTrue: [ self _error: #rtErrAbortWouldLoseData ].

^ self _objInventory: SystemRepository _aggressiveMaxThreadCount waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 95 showHiddenClasses: aBool 
       objsIn: (GsBitmap newForHiddenSet: hiddenSetSpecifier)
       listInstances: nil toFile: nil inMemory: 0
%

category: 'Repository Analysis'
classmethod: GsObjectInventory
fastProfileRepository

"Same as the #profileRepository method except the scan is performed
 aggressively in order to complete in as little time as possible.

 This method may consume most or all host system resources while it
 is in progress."

System needsCommit
    ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

^self _fastProfileRepositoryAndShowHiddenClasses: true
%

category: 'Repository Analysis'
classmethod: GsObjectInventory
fastProfileRepositoryAndSkipHiddenClasses

"Same as the #profileRepositoryAndSkipHiddenClasses method except the scan is performed
 aggressively in order to complete in as little time as possible.

 This method may consume most or all host system resources while it
 is in progress."

^self _fastProfileRepositoryAndShowHiddenClasses: false
%

category: 'Garbage Analysis'
classmethod: GsObjectInventory
profileGarbageFromFile: aFilename includeHiddenObjects: aBoolean

"Analyze the disconnected (garbage) objects in the repository using
 aFilename (an instance of String), which was produced by one of the
 Repository>>findDisconnectedObjectsAndWriteToFile: methods.  Only objects
 which still exist in the repository are analyzed.  Does not create
 references to any object in the file.

 Scans the entire repository and creates a profile by class of the objects
 in the file.  Returns a new instance of the receiver.

 DeadNotReclaimed objects (those pending garbage collection reclamation)
 are not included in the result.

 IMPORTANT:  This method stays in a transaction for its entire duration and
             is therefore not recommended for use on production systems.

 Requires the #GarbageCollection privilege.

 Acquires the garbage collection lock which prevents running garbage
 collection or other scans which requires the GC lock while this method
 is running.

 Raises error #rtErrGetGcLockFailed if the GC lock could not be acquired
 within 3 minutes.

 If this session contains uncommitted changes to the repository,
 the method  signals a error: #rtErrAbortWouldLoseData,
 to indicate that data could be lost. Otherwise
 it puts the session into auto-begin transaction mode and aborts."

System needsCommit
    ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .
(GsBitmap newForHiddenSet: #GcCandidates) removeAll.
SystemRepository loadGcCandidatesFromFile: aFilename intoHiddenSet: #GcCandidates .
^ self _objInventory: SystemRepository getDefaultNumThreads waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 90 showHiddenClasses: aBoolean 
       objsIn: (GsBitmap newForHiddenSet: #GcCandidates)
       listInstances: nil toFile: nil inMemory: 0
%

category: 'Repository Analysis'
classmethod: GsObjectInventory
profileMemory

"Scans this session's temporary object memory and creates a profile by class.
 Returns a new instance of the receiver.

 Counts the number of instances and total physical bytes occupied
 for objects in memory.
"

^ self _objInventory: SystemRepository getDefaultNumThreads waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 90 showHiddenClasses: true objsIn: (GsBitmap new)
       listInstances: nil toFile: nil inMemory: 2
%

category: 'Repository Analysis'
classmethod: GsObjectInventory
profileMemoryNoPom

"Scans this session's temporary object memory and creates a profile by class.
 Returns a new instance of the receiver.
 Excludes pom_gen and code_gen memory .

 Counts the number of instances and total physical bytes occupied
 for objects in memory.
"

^ self _objInventory: SystemRepository getDefaultNumThreads waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 90 showHiddenClasses: true objsIn: (GsBitmap new)
       listInstances: nil toFile: nil inMemory: 1
%

category: 'Profiling'
classmethod: GsObjectInventory
profileObjectsIn: aCollectionOrGsBitmap

"Generate a profile of the objects in the given collection.
 The collection must not contain any special objects, otherwise
 an error will be raised.

 The argument may be either a collection or a GsBitmap.

 Returns an instance of the receiver."

| anArray objInvBm |
System needsCommit
  ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .


(aCollectionOrGsBitmap isKindOf: GsBitmap)
  ifTrue: [ objInvBm := aCollectionOrGsBitmap ]
  ifFalse: [ anArray := aCollectionOrGsBitmap asArray.
             objInvBm := GsBitmap newForHiddenSet: #ObjInventory.
             objInvBm removeAll.
             objInvBm addAll: anArray ].

^ self _objInventory: SystemRepository getDefaultNumThreads waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 90 showHiddenClasses: true objsIn: objInvBm
       listInstances: nil toFile: nil inMemory: 0
%

category: 'Profiling'
classmethod: GsObjectInventory
profileObjectsIn: aCollectionOrGsBitmap threads: numThreads

" Same as profileObjectsIn: except that it allows specifying the number of threads to use for the scan.
 The number of threads can be overridden for any other profiling method by executing:
    SystemRepository setDefaultNumThreads: numThreads
 before executing the method.
"

| anArray objInvBm |
System needsCommit
  ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

(aCollectionOrGsBitmap isKindOf: GsBitmap)
  ifTrue: [ objInvBm := aCollectionOrGsBitmap ]
  ifFalse: [ anArray := aCollectionOrGsBitmap asArray.
             objInvBm := GsBitmap newForHiddenSet: #ObjInventory.
             objInvBm removeAll.
             objInvBm addAll: anArray ].

^self _objInventory: numThreads waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 90 showHiddenClasses: true objsIn: objInvBm
       listInstances: nil toFile: nil inMemory: 0
%

category: 'Profiling'
classmethod: GsObjectInventory
profileObjectsInHiddenSet: hiddenSetSpecifier showHiddenClasses: aBool

"Generate a profile of the objects in the given hidden set which
 exist and for which the session has permission to read.  Objects
 which do not meet these criteria are silently omitted from the result.

 The hiddenSetSpecifer is from GsBitmap, e.g. #ListInstances.

 This method does not alter the contents of the hidden set.

 Returns an instance of the receiver.

 If this session contains uncommitted changes to the repository,
 the method  signals a error: #rtErrAbortWouldLoseData,
 to indicate that data could be lost. Otherwise
 it puts the session into auto-begin transaction mode and aborts."

System needsCommit
    ifTrue: [ self _error: #rtErrAbortWouldLoseData ].

^ self _objInventory: SystemRepository getDefaultNumThreads waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 90 showHiddenClasses: aBool 
       objsIn: (GsBitmap newForHiddenSet: hiddenSetSpecifier)
       listInstances: nil toFile: nil inMemory: 0
%

category: 'Repository Analysis'
classmethod: GsObjectInventory
profileRepository

"Scans the entire repository and creates a profile by class.  Returns a new
 instance of the receiver.

 Counts the number of instances and total physical bytes occupied of each
 class in the repository with one or more instances.

 Objects which are pending garbage collection reclamation are not included
 in the result.

 Acquires the garbage collection lock which prevents running garbage
 collection or other scans which require the GC lock while this method
 is running.

 Raises error #rtErrGetGcLockFailed if the GC lock could not be acquired
 within 3 minutes.

 If this session contains uncommitted changes to the repository,
 the method  signals a error: #rtErrAbortWouldLoseData,
 to indicate that data could be lost. Otherwise
 it puts the session into auto-begin transaction mode and aborts."

System needsCommit
    ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

^self _profileRepositoryAndShowHiddenClasses: true
%

category: 'Repository Analysis'
classmethod: GsObjectInventory
profileRepositoryAndListInstancesInPageOrder: anArrayOfClasses toFile: aString

"Combines the functions of the following methods in a single scan of the
 repository:

   GsObjectInventory>>profileRepository
   Repository>>listInstancesInPageOrder: toFile:

 Refer to the comments in these methods for more information.

 Requires the #GarbageCollection privilege.

 Acquires the garbage collection lock which prevents running garbage
 collection or other scans which requires the GC lock while this method
 is running.

 Raises error #rtErrGetGcLockFailed if the GC lock could not be acquired
 within 3 minutes.

 Aborts the current transaction.   If this session contains uncommitted
 changes to the repository, the method  signals a error:
 #rtErrAbortWouldLoseData, to indicate that data could be lost. Otherwise
 it puts the session into auto-begin transaction mode and aborts.

 Returns an Array containing 2 elements:
  [1] - An new instance of the receiver.
  [2] - An Integer indicating the number of object identifiers written
        to the file."

| idSet objinv count |
System needsCommit
  ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

idSet := IdentitySet withAll: anArrayOfClasses .
objinv :=  self _objInventory: SystemRepository getDefaultNumThreads waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 90 showHiddenClasses: true
       objsIn: (GsBitmap new)
       listInstances: idSet toFile: aString inMemory: 0 .
count := 0.
objinv entriesByCount do: [:entry |
  (idSet includes: (entry theClass))
     ifTrue: [ count := count + (entry instanceCount)]].
^ Array with: objinv with: count
%

category: 'Repository Analysis'
classmethod: GsObjectInventory
profileRepositoryAndSkipHiddenClasses

"Performs the same function as the #profileRepository method except that
 statistics for GemStone private classes (e.g. LargeObjectNode,
 NscSetLeaf, etc) are not shown.  In effect, instances of private classes
 are ignored during the scan.  However the approximate physical space
 occupied by private objects is included in the physical size of the
 private object's root object, which will always be a public class.
 For example, the approximate physical bytes consumed by a NscSetLeaf object
 will be included in the physical size reported for root object, which will be
 an IdentitySet (or a subclass of IdentitySet)."

^self _profileRepositoryAndShowHiddenClasses: false
%

category: 'Repository Analysis'
classmethod: GsObjectInventory
profileRepositoryAndSkipHiddenClassesAndListInstancesInPageOrder: anArrayOfClasses toFile: aString

"Combines the functions of the following methods in a single scan of the
 repository:

   GsObjectInventory>>profileRepositoryAndSkipHiddenClasses
   Repository>>listInstancesInPageOrder: toFile:

 Refer to the comments in these methods for more information.

 Requires the #GarbageCollection privilege.

 Acquires the garbage collection lock which prevents running garbage
 collection or other scans which requires the GC lock while this method
 is running.

 Raises error #rtErrGetGcLockFailed if the GC lock could not be acquired
 within 3 minutes.

 Aborts the current transaction.   If this session contains uncommitted
 changes to the repository, the method  signals a error:
 #rtErrAbortWouldLoseData, to indicate that data could be lost. Otherwise
 it puts the session into auto-begin transaction mode and aborts.

 Returns an Array containing 2 elements:
  [1] - An new instance of the receiver.
  [2] - An Integer indicating the number of object identifiers written
        to the file."

| idSet objinv count |
System needsCommit
  ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

idSet := IdentitySet withAll: anArrayOfClasses .
objinv :=  self _objInventory: SystemRepository getDefaultNumThreads
       waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 90 showHiddenClasses: false
       objsIn: (GsBitmap new)
       listInstances: idSet toFile: aString inMemory: 0 .
count := 0.
objinv entriesByCount do: [:entry |
  (idSet includes: (entry theClass))
     ifTrue: [ count := count + (entry instanceCount)]].
^ Array with: objinv with: count
%

category: 'Private'
classmethod: GsObjectInventory
_fastProfileRepositoryAndShowHiddenClasses: aBoolean

System needsCommit
  ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

^ self _objInventory: SystemRepository _aggressiveMaxThreadCount waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 95 showHiddenClasses: aBoolean
       objsIn: (GsBitmap new) listInstances: nil toFile: nil inMemory: 0
%

category: 'Private'
classmethod: GsObjectInventory
_objInventory: maxSessions waitForLock: lockWaitTime 
      pageBufSize: aBufSize percentCpuActiveLimit: percentCpu
      showHiddenClasses: aBoolean objsIn: aGsBitmap
      listInstances: anIDSetOfClasses toFile: aFileName
      inMemory: inMemInt

" This primitive method performs a scan of the Repository.
  If inMemBoolean==true the scan only looks at temporary object memory,
  otherwise the scan only looks at committed objects .

  This primitive uses a multi-threaded algoritm to sweep the active
  data pages in the repository to gather the information requested.

  The maxSessions argument specifies the maximum number of slave sessions
  (threads) that will be used during the operation.  The actual number of
  active threads can be adjusted to a lower value automatically at runtime
  by the main thread based on the percentCpuActiveLimit and by the user
  by interactively setting the mtThreadLimit (see details below).

  The lockWaitTime argument is used to specify how many seconds method should
  wait while attempting to acquire the gcLock.  No other garbage collection
  operations may be started or in progress while this method is running.
  Objects in the possibleDead or deadNotReclaimed sets at the start of
  the scan are ignored by the scan.

  The pageBufSize, which must be a power of two, specifies the number
  of pages to buffer per thread. This parameter in conjunction with the
  maxSessions largely determines the memory footprint needed to perform
  this operation.  The pageBufSize doesn't have much impact on the
  performance of the scan, so a default size of 8 is probably sufficient.

  The percentCpu specifies a level of total cpu activity at which the
  algorithm automatically inactivates threads to prevent overload
  of system resources.

  This algorithm makes use of additional sessions (threads) to achieve
  significant performance improvements.  It also makes space/time trade offs
  so that heap memory in addition to the TemporaryObjectCache (TOC)
  resources are used.  In fact, this algorithm doesn't require much TOC,
  except for the operations that return array results, so configuring this
  process for a smaller TOC space is advantageous.

  The memory space that is needed is variable and depends upon number of
  instances being searched for, the number found, the number of sessions
  requested and the pageBufSize specified for each.

  The objsIn: argument is a GsBitmap that specifies the objects to inventory.
  specifier, e.g. #ListInstances.

  If aGsBitmap is non empty, then only objects in the hidden set are included 
  in the results.

  If the hiddenSetSpecifier is not an empty GsBitmap, then only objects in the hidden set
  are included in the results.

  If aGsBitmap is not #GcCandidates, then the primitive a assumes that it 
  is analyzing the contents of a collection and performs the scan in a transaction 
  which can cause a large commit record backlog if the set is large and there is 
  a lot of commit activity.  Otherwise, the operation can cause the session to 
  abort to prevent a commit record backlog during the scan.

  If inMemInt > 0 , ignores arguments
     maxSessions, lockWaitTime, aBufSize, percentCpu
     aGsBitmap, aBoolean, aFileName
  and reports on the in-memory objects of this session .
  inMemInt == 1 means exclude pom_gen and code_gen 
  inMemInt == 2  includes all of temp obj memory.

  The anIDSetOfClasses and aFileName arguments are used for the combined
  functions of profiling the repository and listing specified instances.

  See the profileRepository* methods below.
"

<primitive: 897>
  | maxInt |
  maxInt := SmallInteger maximum32bitInteger .
  maxSessions _validateClass: SmallInteger; _validateMin: 1 max: maxInt .
  lockWaitTime _validateClass: SmallInteger ; _validateMin: -1 max: maxInt .
  aBufSize _validateClass: SmallInteger; _validateIsPowerOf2 .
  Repository _validatePercentage: percentCpu  .
  inMemInt _validateClass: SmallInteger.
  aGsBitmap _validateClass: GsBitmap .
  anIDSetOfClasses _validateInstanceOf: IdentitySet.
  aFileName _validateKindOfClass: String.
^ self _primitiveFailed: #_objInventory:waitForLock:pageBufSize:percentCpuActiveLimit:showHiddenClasses:objsIn:listInstances:toFile:inMemory:
       args: { maxSessions . lockWaitTime . aBufSize .
               percentCpu . aBoolean . aGsBitmap .
               anIDSetOfClasses . aFileName . inMemInt }
%

category: 'Private'
classmethod: GsObjectInventory
_profileRepositoryAndShowHiddenClasses: aBoolean

System needsCommit
  ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

^ self _objInventory: SystemRepository getDefaultNumThreads waitForLock: 60 pageBufSize: 8
       percentCpuActiveLimit: 90 showHiddenClasses: aBoolean
       objsIn: (GsBitmap new)
       listInstances: nil toFile: nil inMemory: 0
%

!		Instance methods for 'GsObjectInventory'

category: 'Formatting'
method: GsObjectInventory
asString

| sz result|
sz := self entriesByCount size.
result := String new.
result addAll: 'a'; addAll: self class name; addAll: ' of '; addAll: sz asString; addAll: ' classes.'.
^result
%

category: 'Reporting'
method: GsObjectInventory
byteCountReport
	^self byteCountReportDownTo: 0
%

category: 'Reporting'
method: GsObjectInventory
byteCountReportDownTo: minCountToReport

"Return a String showing the receiver in tabular form sorted by instance count."

| totalBytes totalCount result tmp lf array line space|
lf := Character lf.
space := Character space.
result := String new.
tmp := String withAll: '*** GsObjectInventory byteCountReport printed at: '.
tmp addAll: DateTime now asString.
tmp addAll: ' ***'.
result addLineWith: tmp centeredToWidth: 80 ;
       add: lf.
result addAll: 'Hidden classes are '.
self includeHiddenClasses
  ifFalse:[ result addAll: 'not '.].
result addAll: 'included in this report.'; add: lf.
line := String new.
80 timesRepeat:[line add: $_].
line add: lf.
result addAll: line.

result 	addAll: ((String withAll: 'Class') width: 50; yourself); add: space;
		addAll: ((String withAll: 'Instances') width: -14; yourself); add: space;
		addAll: ((String withAll: 'Bytes') width: -14; yourself); add: lf.
result addAll: line.
totalBytes := 0.
totalCount := 0.
array := self entriesByBytes.
1 to: array size do:[:n| |entry|
  entry := array at: n.
  (entry byteCount < minCountToReport)
	ifTrue:[result addAll: line.
		^result ].
  result addAll: (entry theClass name asString width: 50); add: space;
		addAll: (entry instanceCount asString width: -14); add: space;
		addAll: (entry byteCount asString width: -14); add: lf.
  totalCount := totalCount + entry instanceCount.
  totalBytes := totalBytes + entry byteCount.
].
result addAll: line.
result 	addAll: ((String withAll: 'Totals') width: 50; yourself); add: space;
        addAll: (totalCount asString width: -14) ; add: space;
        addAll: (totalBytes asString width: -14); add: lf.
result addAll: line.
^result
%

category: 'Accessing'
method: GsObjectInventory
entriesByBytes

^entriesByBytes
%

category: 'Updating'
method: GsObjectInventory
entriesByBytes: newValue

entriesByBytes := newValue
%

category: 'Accessing'
method: GsObjectInventory
entriesByCount

^entriesByCount
%

category: 'Updating'
method: GsObjectInventory
entriesByCount: newValue

entriesByCount := newValue
%

category: 'Accessing'
method: GsObjectInventory
includeHiddenClasses

^includeHiddenClasses
%

category: 'Updating'
method: GsObjectInventory
includeHiddenClasses: newValue

includeHiddenClasses := newValue
%

category: 'Reporting'
method: GsObjectInventory
instanceCountReport

"Return a String showing the receiver in tabular form sorted by instance count."
^self instanceCountReportDownTo: 0
%

category: 'Reporting'
method: GsObjectInventory
instanceCountReportDownTo: minCountToReport

"Return a String showing the receiver in tabular form sorted by instance count."
| totalCount totalBytes result tmp lf array line space|
lf := Character lf.
space := Character space.
result := String new.
tmp := String withAll: '*** GsObjectInventory instanceCountReport printed at: '.
tmp addAll: DateTime now asString.
tmp addAll: ' ***'.
result addLineWith: tmp centeredToWidth: 80 ;
       add: lf.
result addAll: 'Hidden classes are '.
self includeHiddenClasses
  ifFalse:[ result addAll: 'not '.].
result addAll: 'included in this report.'; add: lf.

line := String new.
80 timesRepeat:[line add: $_].
line add: lf.
result addAll: line.
result 	addAll: ((String withAll: 'Class') width: 50; yourself); add: space;
		addAll: ((String withAll: 'Instances') width: -14; yourself); add: space;
		addAll: ((String withAll: 'Bytes') width: -14; yourself); add: lf.
result addAll: line.
array := self entriesByCount.
totalCount := 0.
totalBytes := 0.
1 to: array size do:[:n| |entry|
  entry := array at: n.
  (entry instanceCount < minCountToReport)
	ifTrue:[	result addAll: line.
			^result
	].
  result addAll: (entry theClass name asString width: 50); add: space;
		addAll: (entry instanceCount asString width: -14); add: space;
		addAll: (entry byteCount asString width: -14); add: lf.
  totalCount := totalCount + entry instanceCount.
  totalBytes := totalBytes + entry byteCount.
].
result addAll: line.
result 	addAll: ((String withAll: 'Totals') width: 50; yourself); add: space;
        addAll: (totalCount asString width: -14) ; add: space;
        addAll: (totalBytes asString width: -14); add: lf.
result addAll: line.
^result
%

! Class implementation for 'GsObjectInventoryEntry'

!		Instance methods for 'GsObjectInventoryEntry'

category: 'Formatting'
method: GsObjectInventoryEntry
asString

| result myName |
myName := self class name.
result := String new.
self theClass == nil
	ifTrue:[result addAll: 'An empty '; addAll: myName ]
	ifFalse:[ result addAll: 'a'; addAll: myName; addAll: ' for '; addAll: self theClass name].
^result

%

category: 'Accessing'
method: GsObjectInventoryEntry
byteCount

^byteCount
%

category: 'Updating'
method: GsObjectInventoryEntry
byteCount: newValue

byteCount := newValue
%

category: 'Accessing'
method: GsObjectInventoryEntry
instanceCount

^instanceCount
%

category: 'Updating'
method: GsObjectInventoryEntry
instanceCount: newValue

instanceCount := newValue
%

category: 'Accessing'
method: GsObjectInventoryEntry
theClass

^theClass
%

category: 'Updating'
method: GsObjectInventoryEntry
theClass: newValue

theClass := newValue
%

! Class implementation for 'GsPackageLibrary'

!		Class methods for 'GsPackageLibrary'

category: 'Operations'
classmethod: GsPackageLibrary
createPackageNamed: aSymbol

    | package packageLibrary |
    package := self packageNamed: aSymbol.
    package ~~ nil ifTrue: [ ^package ].
    packageLibrary := self packageLibrary.
    packageLibrary createDictionaryNamed: aSymbol at: 1.
    ^GsPackage installIn: (packageLibrary objectNamed: aSymbol).
%

category: 'Private - Installation Support'
classmethod: GsPackageLibrary
getMonticelloRepositoryDirectory
| basePath |
basePath := self getSeasideDirectory .
basePath ==  nil
  ifTrue:[ ^nil ] .
basePath addAll: 'monticello/repository/' .
^ basePath
%

category: 'Private - Installation Support'
classmethod: GsPackageLibrary
getSeasideDirectory
| basePath |
basePath := System gemEnvironmentVariable: 'SEASIDE'.
basePath == nil
 ifTrue:[
   basePath := System gemEnvironmentVariable: 'GEMSTONE'.
   basePath == nil
     ifTrue:[^nil]
     ifFalse:[basePath addAll: '/seaside/'].
  ]
  ifFalse:[
    basePath last == $/
      ifFalse: [ basePath add: $/ ].
  ].
^basePath
%

category: 'private'
classmethod: GsPackageLibrary
installMonticelloPackagesDuring: aBlock
        "install the libraries #'SessionMethods' and #'Monticell_Methods'.
         Enable #'SessionMethods' and configure for new classes to be installed into UserGlobals.
         Evaluate <aBlock> with the SymbolDictionary named #'Monticello_Globals' as the argument.
         Uninstall the library #'Monticell_Methods', but leave #'SessionMethods' enabled"

        ^self
            installMonticelloPackagesHome: (GsCurrentSession currentSession objectNamed: #UserGlobals)
            during: aBlock
%

category: 'private'
classmethod: GsPackageLibrary
installMonticelloPackagesHome: homeSymbolDict during: aBlock
        "install the libraries #'SessionMethods' and #'Monticell_Methods'.
         Enable #'SessionMethods' and configure for new classes to be installed into <homeSymbolDict>.
         Evaluate <aBlock> with the SymbolDictionary named #'Monticello_Globals' as the argument.
         Uninstall the library #'Monticell_Methods', but leave #'SessionMethods' enabled"

	| policy methodsPackage sessionMethodsPackage preInstalled enabled |
	methodsPackage := self packageNamed: #'Monticello_Methods'.
	sessionMethodsPackage := GsPackageLibrary createPackageNamed: #SessionMethods.
	preInstalled := (self userSymbolList objectNamed: methodsPackage symbolDict name) ~~ nil.
	enabled := GsPackagePolicy current enabled.

	[
	preInstalled
		ifTrue: [ enabled ifFalse: [ GsPackagePolicy current enable ] ]
		ifFalse: [
			self installPackage: sessionMethodsPackage.
			self installPackage: methodsPackage ].

	policy := GsPackagePolicy current.
	policy homeSymbolDict:  homeSymbolDict.
	policy externalSymbolList: Array new.

	aBlock value: (self packageNamed: #'Monticello_Globals') ]
		ensure: [
			preInstalled ifFalse: [ self uninstallPackage: methodsPackage ].
			enabled ifFalse: [ GsPackagePolicy current disable ] ].

%

category: 'Operations'
classmethod: GsPackageLibrary
installPackage: aPackage

    	self installPackage: aPackage enable: true
%

category: 'Operations'
classmethod: GsPackageLibrary
installPackage: aPackage enable: aBool

    	| symDict pkgDict |
    	symDict := aPackage symbolDict.
	pkgDict := Globals.
    	aPackage prereqs do: [:symbolDict |  | p |
     		p := symbolDict at: aPackage class globalName otherwise: nil.
        	p ~~ nil
			ifTrue: [ self installPackage: p  enable: false ].
		(self userSymbolList indexOf: symbolDict) < (self userSymbolList indexOf: pkgDict)
			ifTrue: [ pkgDict := p symbolDict ].
    	].
	(self userSymbolList objectNamed: symDict name) == nil
		ifTrue: [ self userSymbolList add: symDict before: pkgDict ].
	(self sessionSymbolList objectNamed: symDict name) == nil
		ifTrue: [ self  sessionSymbolList add: symDict before: pkgDict ].
	aBool
		ifTrue: [ | policy |
			policy := GsPackagePolicy current.
			policy enable.
			policy homeSymbolDict:  aPackage symbolDict.
			policy externalSymbolList: (self sessionSymbolList asArray copyWithout: aPackage symbolDict).
		].
%

category: 'Operations'
classmethod: GsPackageLibrary
installPackageNamed: aSymbol
  | pkg |
  (pkg := self packageNamed: aSymbol) ifNil:[
    Error signal:'Package ', aSymbol asString,' not found'.
  ].
  ^ self installPackage: pkg
%

category: 'Testing'
classmethod: GsPackageLibrary
isPackageInstalled: aPackage
	"Ansser true if <aPackage> has already been installed"

	^(self userSymbolList objectNamed: aPackage symbolDict name) ~~ nil
%

category: 'Monticello'
classmethod: GsPackageLibrary
lastFileNameOf: packageName inDirectory: directory
	"returns a String"

	| versionNumberBlock mczFilename |
	versionNumberBlock := self versionNumberBlock.
	mczFilename := (((directory childFiles
				collect: [:reference | reference basename])
					select: [:mczName | (mczName indexOfSubCollection: packageName) = 1])
					sortBy: [:a :b | (versionNumberBlock value: a) <= (versionNumberBlock value: b)])
					last.
	^mczFilename
%

category: 'Monticello'
classmethod: GsPackageLibrary
lastFileNameOf: packageName inPath: aPath
  "returns a String"
  self installMonticelloPackagesDuring: [:globalsPackage |
   | directory |
    directory := ((globalsPackage symbolDict at: #FSDiskFilesystem) current
                     pathFromString: aPath ) asReference.
   ^ self lastFileNameOf: packageName inDirectory: directory
  ].
%

category: 'Monticello'
classmethod: GsPackageLibrary
loadLastVersionOf: packageName fromRepositoryPath: repositoryPath
	"load the latest version of the package <packageName> into the current user's UserGlobals symbol dictionary from
	the repository located in the directory <repositoryPath> on the server."

	self installMonticelloPackagesDuring: [:globalsPackage |
    | directory repository mczFilename |
		directory := ((globalsPackage symbolDict at: #FSDiskFilesystem) current
										pathFromString: repositoryPath) asReference.
		mczFilename := self lastFileNameOf: packageName inDirectory: directory.

		repository := (globalsPackage symbolDict at: #MCFilesystemRepository) new directory: directory.
		self loadMCZFile: mczFilename fromRepository: repository
  ]
%

category: 'private'
classmethod: GsPackageLibrary
loadMCZFile: mczFilename fromRepository: repository
	"load the given <mczFilename> from the given GsMonticello repository <repository>"

        GsFile gciLogServer: 'loading ', mczFilename printString.
	(repository loadVersionFromFileNamed: mczFilename) load.
%

category: 'Monticello'
classmethod: GsPackageLibrary
loadMCZFile: mczFilename fromRepositoryPath: repositoryPath
	"load the given mcz file <mczFilename> into the current user's UserGlobals symbol dictionary from
	the repository located in the directory <repositoryPath> on the server."

	self
            loadMCZFile: mczFilename
            home: #UserGlobals
            fromRepositoryPath: repositoryPath
%

category: 'Monticello'
classmethod: GsPackageLibrary
loadMCZFile: mczFilename home: homeSymbolDictName fromRepositoryPath: repositoryPath
    "load the given mcz file <mczFilename> into the current user'ssymbol
     dictionary named <homeSymbolDictName> from
     the repository located in the directory <repositoryPath> on the server."

    self
      installMonticelloPackagesHome: (GsCurrentSession currentSession objectNamed: homeSymbolDictName asSymbol)
      during: [:globalsPackage | |repository |
		repository := (globalsPackage symbolDict at: #MCFilesystemRepository) new
			directory: ((globalsPackage symbolDict at: #FSDiskFilesystem) current pathFromString: repositoryPath) asReference.
		self loadMCZFile: mczFilename fromRepository: repository ].
%

category: 'Accessing'
classmethod: GsPackageLibrary
packageLibrary

    | packageLibrary |
    packageLibrary := (AllUsers userWithId: self packageLibraryUserName ifAbsent: []) symbolList objectNamed: self packageLibraryName.
    packageLibrary == nil
        ifTrue: [
            packageLibrary := SymbolList new.
            self userGlobals at: self packageLibraryName put: packageLibrary.
        ].
    ^packageLibrary
%

category: 'Accessing'
classmethod: GsPackageLibrary
packageLibraryName

    ^#PackageLibrary
%

category: 'Accessing'
classmethod: GsPackageLibrary
packageLibraryUserName

    ^'DataCurator'
%

category: 'Searching'
classmethod: GsPackageLibrary
packageNamed: aSymbol

    	| symDict |
	symDict := self packageLibrary objectNamed: aSymbol.
	symDict ifNil:[ ^ nil ].
	^symDict at: GsPackage globalName otherwise: nil
%

category: 'Reporting'
classmethod: GsPackageLibrary
packagesReport
  | aSymList str |
  str := String new .
  aSymList := self packageLibrary .
  aSymList do:[:aDict |
    (aDict at: GsPackage globalName otherwise: nil) ifNotNil:[:pack |
       str add: 'GsPackage oop ' , pack asOop asString .
       pack name ifNotNil:[:nam|  str add: ' for ' , nam ].
       str lf .
    ].
  ].
  ^ str
%

category: 'Monticello'
classmethod: GsPackageLibrary
saveNewVersionOf: packageName author: authorInitials message: commitComment
  toPath: repositoryPath
  "write a new version of the package <packageName>
   to the repository located in the directory <repositoryPath> on the server."
	self installMonticelloPackagesDuring:
		[:globalsPackage |
		| directory repository pkg wc version verName |
		directory := ((globalsPackage symbolDict at: #FSDiskFilesystem) current
					pathFromString: repositoryPath) asReference.
		repository := (globalsPackage symbolDict at: #MCFilesystemRepository) new
					directory: directory.
		(globalsPackage symbolDict at: #MCPlatform) current authorInitials: authorInitials.
		pkg := (globalsPackage symbolDict at: #MCPackage) named: packageName.
		wc := pkg workingCopy.
		version := wc newVersionWithName: (verName := wc uniqueVersionName)
					message: commitComment.
		repository storeVersion: version.
		System commitTransaction ifFalse: [Error signal: 'commit failed'].
		^'wrote ' , verName asString , ' , ' , version summary]
%

category: 'Accessing'
classmethod: GsPackageLibrary
sessionSymbolList

  ^ GsSession currentSession symbolList      "fix 49328"
%

category: 'Operations'
classmethod: GsPackageLibrary
uninstallPackage: aPackage

    self userSymbolList remove: aPackage symbolDict ifAbsent: [].
    self sessionSymbolList remove: aPackage symbolDict ifAbsent: [].
    GsPackagePolicy current refreshSessionMethodDictionary.
%

category: 'Operations'
classmethod: GsPackageLibrary
uninstallPackageAndPrereqs: aPackage

    "Recursively uninstall the package and its prereqs"

    | symDict pkg |
    symDict := aPackage symbolDict.
    aPackage prereqs do: [:symbolDict |
        pkg := symbolDict at: GsPackage globalName otherwise: nil.
        pkg ~~ nil ifTrue: [ GsPackageLibrary uninstallPackageAndPrereqs: pkg ].
    ].
    self userSymbolList remove: symDict ifAbsent: [].
    self sessionSymbolList remove: symDict ifAbsent: [].
%

category: 'Accessing'
classmethod: GsPackageLibrary
userGlobals

    ^self userSymbolList objectNamed: #UserGlobals
%

category: 'Accessing'
classmethod: GsPackageLibrary
userSymbolList

    ^System myUserProfile symbolList
%

category: 'private'
classmethod: GsPackageLibrary
versionNumberBlock
	"Private. Version number is apparently the portion of the name between the last two periods.
	If no periods, the entire name. If one period, everything before that period."

	^
	[:aName |
	| lastIndex numberPortion foundPeriod index |
	foundPeriod := false.
	index := aName size.
	[foundPeriod or: [index = 0]] whileFalse:
			[(aName at: index = $.) ifTrue: [foundPeriod := true].
			index := index - 1].
	numberPortion := foundPeriod
				ifTrue:
					[lastIndex := index.
					foundPeriod := false.
					[foundPeriod or: [index = 0]] whileFalse:
							[(aName at: index = $.) ifTrue: [foundPeriod := true].
							index := index - 1].
					aName copyFrom: index + 1 to: lastIndex]
				ifFalse: [aName].
	numberPortion asNumber]
%

! Class implementation for 'GsReferencePath'

!		Class methods for 'GsReferencePath'

category: 'Formatting'
classmethod: GsReferencePath
pathArrayAsString: path
"Returns a String describing the path in the form
   <pathIdx> Oop = <objectId> (<className>)
"
| pathLength obj result |

pathLength := path size.
result := String new.

1 to: pathLength do: [:i |  | refPath |
  obj := path at: i.
  result add: ( '  ' , i asString, ' oop = ', (GciInterface _oopForObject: obj) asString,
            ' (', obj class name asString , ')').
  refPath := GsReferencePath _refPathForObject: obj .
  (refPath status == #noInfo)
     ifFalse: [
       (refPath inSearchOops)
          ifTrue: [ result add: (' has ' , refPath numParents asString , ' parents') ]
          ifFalse: [
             (refPath moreParents) ifTrue: [ result add: (' has more than one parent') ]
                                ifFalse: [ result add: (' has only one parent') ]
          ].
     ].
   result add: Character lf.
].
^result
%

category: 'Primitive'
classmethod: GsReferencePath
_refPathForObject: anObjOrGsBitmap

"Returns a reference path to a single object.

 This method returns a new GsReferencePath instance.

 If a GsBitmap is passed as an argument, then each object in the bitmap is
 tested and the first object to have a complete path is returned.  If no
 object has a complete path then the status returned is #noInfo.
"

<primitive: 1024>
^ self _primitiveFailed:
    #_refPathForObject:
    args: { anObjOrGsBitmap }
%

!		Instance methods for 'GsReferencePath'

category: 'Accessing'
method: GsReferencePath
inSearchOops
 "Answer whether the target was in the searchOops."

^inSearchOops
%

category: 'Updating'
method: GsReferencePath
inSearchOops: aBoolean

inSearchOops := aBoolean
%

category: 'Testing'
method: GsReferencePath
isComplete
  "Answers whether the path returned is complete, i.e., terminates with an object
   in the limit set"

^ status == #complete
%

category: 'Testing'
method: GsReferencePath
isCycle
  "Answers whether the path contains a cycle, i.e., terminates with an object that appears
   at another position in the path."

^status == #cycle
%

category: 'Testing'
method: GsReferencePath
isNotConnected

  "Answers true if the head of the path has no parents"

^ status == #notConnected
%

category: 'Accessing'
method: GsReferencePath
moreParents
 "Answer whether it is known if there are moreParents than specified in numParents."

^moreParents
%

category: 'Updating'
method: GsReferencePath
moreParents: aBoolean

moreParents := aBoolean
%

category: 'Accessing'
method: GsReferencePath
numParents
 "Answer the number of parent objects for the target"

^numParents
%

category: 'Updating'
method: GsReferencePath
numParents: anInt

numParents := anInt
%

category: 'Accessing'
method: GsReferencePath
path
 "Answer an array of the oops that define a path to the target object"

^path
%

category: 'Updating'
method: GsReferencePath
path: anArray

path := anArray
%

category: 'Accessing'
method: GsReferencePath
status
  "Answers a symbol which defines the result for the path.
   Possible values are:
      #complete        if the path starts with an object in the limit set.
      #cycle           if an object occurs more than once in the path.
      #notConnected    if the head of the path has no parents.
  "
^status
%

category: 'Updating'
method: GsReferencePath
status: aSymbol

status := aSymbol
%

category: 'Accessing'
method: GsReferencePath
target
 "Answer the target object for the path."

^target
%

category: 'Updating'
method: GsReferencePath
target: anObj

target := anObj
%

! Class implementation for 'GsReferencePathParentsInfo'

!		Class methods for 'GsReferencePathParentsInfo'

category: 'Accessing'
classmethod: GsReferencePathParentsInfo
allParentsOfOops: aGsBitmap
"Answer a GsBitmap containing the parent objects found by the last scan of each
 child object contained in aGsBitmap."

^ self refPathParentsOf: aGsBitmap
%

category: 'Accessing'
classmethod: GsReferencePathParentsInfo
refPathParentsOf: anObj

"Returns an instance of GsReferencePathParentsInfo if anObj is a
 committed non-special object.

 If anObj is an instance of GsBitmap, returns new instance of
 GsBitmap containing all parent objects of all child objects contained
 in the argument GsBitmap found during the last scan.

 If anObj is not an instance of GsBitmap, it must be a committed
 non-special object, or a SmallInteger; a SmallInteger must be the
 objectId of a committed non-special object and can be resolved as
 (Object _objectForOop: anObj).

 If the _refPathDoScanForParents method was run with onlySearchObjs having
 the value true, then if the object was NOT in the search set for the scan,
 then an error is reported with the message: 'No info available for objects
 not in searchOops'."

| res |
res := self _refPathParentsOf: anObj .
res _isOneByteString ifTrue:[ ^ ArgumentError signal: res ].
^ res
%

category: 'Private'
classmethod: GsReferencePathParentsInfo
_refPathParentsOf: anObj

"Returns a GsBitmap, an GsReferencePathParentsInfo or a String with error details"

<primitive: 1025>
^ self _primitiveFailed: #refPathParentsOf: args: { anObj }
%

!		Instance methods for 'GsReferencePathParentsInfo'

category: 'Accessing'
method: GsReferencePathParentsInfo
additionalParentsAvailable
 "Answer whether there are known to be more parent references than were
  returned from the #refPathParentsOf: call."

^additionalParentsAvailable
%

category: 'Updating'
method: GsReferencePathParentsInfo
additionalParentsAvailable: aBoolean

additionalParentsAvailable := aBoolean
%

category: 'Accessing'
method: GsReferencePathParentsInfo
parentClassCounts
 "Answer an array containing the counts of the number of referencing object instances of the class with the corresponding
  index in the parentClassIds array.
   If the target is not found in the search objects, answer an empty array."

^parentClassCounts
%

category: 'Updating'
method: GsReferencePathParentsInfo
parentClassCounts: someIntegers

parentClassCounts := someIntegers
%

category: 'Accessing'
method: GsReferencePathParentsInfo
parentClassOops
 "Answer an array of the oops of each referencing object's class.
   If the target is not found in the search objects, answer an empty array."

^parentClassOops
%

category: 'Updating'
method: GsReferencePathParentsInfo
parentClassOops: someIntegers

parentClassOops := someIntegers
%

category: 'Accessing'
method: GsReferencePathParentsInfo
parentClassReferences
 "Answer the parent objects class reference."

^self parentClassOops collect: [:refOop | Object _objectForOop: refOop]
%

category: 'Accessing'
method: GsReferencePathParentsInfo
parentOops
 "Answer a GsBitmap containing the oops of each referencing object.
  If the target is not found in the search objects, there can only be a single parent reference returned."

^parentOops
%

category: 'Accessing'
method: GsReferencePathParentsInfo
parentOopsAsArray

 "Answer an array containing the oops of each referencing object.
  If the target is not found in the search objects, there can only be a single parent reference returned."

^parentOops asArray
%

category: 'Accessing'
method: GsReferencePathParentsInfo
parentReferences
 "Answer the parent objects referencing the target."

^self parentOops collect: [:refOop | Object _objectForOop: refOop]
%

category: 'Accessing'
method: GsReferencePathParentsInfo
parentSizesInBytes
 "Answer an array of the sum of the size in bytes (from the object header) of the referencing objects with the
  class that corresponds to the entry with the same index in the parentClassOops array.
  If the target is not found in the search objects, answer an empty array."

^parentSizesInBytes
%

category: 'Updating'
method: GsReferencePathParentsInfo
parentSizesInBytes: someIntegers

parentSizesInBytes := someIntegers
%

category: 'Accessing'
method: GsReferencePathParentsInfo
target
 "Answer the argument passed to #refPathParentsOf:."

^target
%

category: 'Updating'
method: GsReferencePathParentsInfo
target: anObject

target := anObject
%

category: 'Accessing'
method: GsReferencePathParentsInfo
targetFoundInSearch
 "Answer whether the target is found in the search objects array passed to
  Repository>>#_refPathDoScanForParents:excludeParentRefs:."

^targetFoundInSearch
%

category: 'Updating'
method: GsReferencePathParentsInfo
targetFoundInSearch: aBoolean

targetFoundInSearch := aBoolean
%

! Class implementation for 'GsSftpRemoteFile'

!		Class methods for 'GsSftpRemoteFile'

category: 'Instance Creation'
classmethod: GsSftpRemoteFile
createNewRemoteFile: fileName withSftpSocket: aGsSftpSocket

"Creates a new remote file for writing with default permissions on a remote host using a connected instance of GsSftpSocket.
Raises an error if the remote file already exists.
Returns a new instance of the receiver or raises an exception on error."

^self openRemoteFile: fileName mode: 'w' permissions: nil errorIfExists: true withSftpSocket: aGsSftpSocket
%

category: 'Instance Creation'
classmethod: GsSftpRemoteFile
createOrOverwriteRemoteFile: fileName withSftpSocket: aGsSftpSocket

"Opens or creates a remote file with default permissions for writing on a remote host using a connected instance of GsSftpSocket.
If the file already exists it is overwritten. If the file does not exist it will be created.

Returns a new instance of the receiver or raises an exception on error."

^self openRemoteFile: fileName mode: 'w' permissions: nil errorIfExists: false withSftpSocket: aGsSftpSocket
%

category: 'Examples'
classmethod: GsSftpRemoteFile
createRandomRemoteFileFromSftpSocket: sftpSock forSelector: aSelector

"Create a new remote file with a random file name and upload 64 K of random data to it.
Answer the new remote file name."

|  sftpFile remoteFn ba |
remoteFn := self randomRemoteFileNameForSelector: aSelector .
"Create a new write-only sftpFile instance using the sftp socket we created."
ba := ByteArray withRandomBytes: 65536 .
sftpFile := GsSftpRemoteFile createNewRemoteFile: remoteFn withSftpSocket: sftpSock .
sftpFile writeAllFrom: ba .
sftpFile close. "Close remote file"
^ remoteFn
%

category: 'Examples'
classmethod: GsSftpRemoteFile
downloadToLocalFileExample
"This example will download a random file from the sftp server to the local /tmp directory."

"GsSftpRemoteFile downloadToLocalFileExample"

| sftpSock sftpFile gsFile  localFn bytes anyFile sel |
sel := (GsProcess methodAt: 1 ) selector .
"Common example method to create the sftpSocket"
sftpSock := self getSftpSocketExample .
anyFile := self createRandomRemoteFileFromSftpSocket: sftpSock  forSelector: sel.
localFn := '/tmp/', anyFile .
"Create a new read-only sftpFile instance using the sftp socket we created.
We will download the file named anyFile on ssh-test to local file /tmp/anyFile"
sftpFile := self openRemoteFileReadOnly: anyFile withSftpSocket: sftpSock .

"Open a new GsFile instance where we will write the data. Delete file if it's already there"
gsFile := GsFile removeServerFile: localFn ; openWriteOnServer: localFn .
"Download the entire file"
bytes := sftpFile readAllInto: gsFile .
gsFile close.
sftpFile close.
sftpSock removeRemoteFile: anyFile ; close.
^ 'success: ', bytes asString , ' bytes were downloaded to ', localFn
%

category: 'Examples'
classmethod: GsSftpRemoteFile
downloadToObjectExample
"This example downloads the first 64K of a random remote file into a ByteArray object."

"GsSftpRemoteFile downloadToObjectExample"

| sftpSock sftpFile  bytes byteArray anyFile sel |
sel := (GsProcess methodAt: 1 ) selector .
"Common example method to create the sftpSocket"
sftpSock := self getSftpSocketExample .
anyFile :=self createRandomRemoteFileFromSftpSocket: sftpSock  forSelector: sel.
"Create a new read-only sftpFile instance using the sftp socket we created."
sftpFile := self openRemoteFileReadOnly: anyFile withSftpSocket: sftpSock .
byteArray := ByteArray new.

"Download the first 64K of the file into the ByteArray"
bytes := sftpFile readAllInto: byteArray .
sftpFile close.
sftpSock removeRemoteFile: anyFile ; close.
^ Array with: ('success: ', bytes asString , ' bytes were downloaded to a ByteArray ') with: byteArray
%

category: 'Examples'
classmethod: GsSftpRemoteFile
getSftpSocketExample

"GsSftpRemoteFile getSftpSocketExample"

| sftpSock host |
host :=  GsSshSocket exampleHost .

"Uncomment next line to turn on tracing to a log file in /tmp"
"GsSftpSocket enableTraceFileInDirectory: '/tmp' ."
"Get a GsSftpSocket connection to the test sftp server on ssh port 22"
sftpSock := GsSftpSocket newClient.
[sftpSock connectTo: 22 on: host] onException: (SocketError, SshSocketError) do:[:ex|
	sftpSock close.
	ex pass
].
"Set userId / password for test server"
sftpSock userId: GsSshSocket exampleUserId ; password: GsSshSocket examplePassword   .
"Disable authenticating the remote host"
sftpSock disableHostAuthentication .
"Connect and perform ssh handshake. If this fails, check firewall settings"
sftpSock sshConnect .
^sftpSock
%

category: 'Examples'
classmethod: GsSftpRemoteFile
lstatExample
"This example does an lstat operation on a random remote file on the sftp server and returns an instance of GsFileStat."
"GsSftpRemoteFile lstatExample"

| sftpSock anyFile stat  |
"Common example method to create the sftpSocket"
sftpSock := self getSftpSocketExample .
anyFile := (sftpSock contentsOfRemoteDirectoryNoDotFiles: '.') first.
stat := sftpSock lstat: anyFile .
sftpSock close.
^ stat
%

category: 'Instance Creation'
classmethod: GsSftpRemoteFile
new
  self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: GsSftpRemoteFile
new: aSize
  self shouldNotImplement: #new:
%

category: 'Instance Creation'
classmethod: GsSftpRemoteFile
openRemoteFile: fileName mode: openMode permissions: permInt errorIfExists: aBoolean withSftpSocket: aGsSftpSocket

"Opens or creates a remote file on a remote host using a connected instance of GsSftpSocket.
The fileName argument  is name of the file on the remote host.  The openMode argument must be a String that that is equal to one of the
 following: 'r', 'w', 'a', 'r+', 'w+', 'a+' '.  The mode has the same meaning as it does for the
 C library function, fopen().

For modes that create a new file, permInt must be a SmallInteger between 0 and 8r777,
or nil which causes the default file permissions of 8r770 to be used.

If aBoolean is true and the mode is a write or append mode, an error will be raised if the file already exists.
If aBoolean is false and the mode is a write or append mode, the file will be overwritten if it already exists.
For read modes, aBoolean is ignored and an error will be raised if the file does not exist.

Returns a new instance of the receiver or raises an exception on error."

| result |
result := self _fiveArgSftpRemoteFilePrim: 100 with: fileName with: openMode with: permInt with: aBoolean with: aGsSftpSocket .
result remoteFileName: fileName copy ;  initializeWith: aGsSftpSocket .
^result
%

category: 'Instance Creation'
classmethod: GsSftpRemoteFile
openRemoteFileAppend: fileName withSftpSocket: aGsSftpSocket

"Opens a remote file for appending (writing at the end) on a remote host using a connected instance of GsSftpSocket.
Creates the file if it does not exist.
Returns a new instance of the receiver or raises an exception on error."

^self openRemoteFile: fileName mode: 'a' permissions: nil errorIfExists: false withSftpSocket: aGsSftpSocket
%

category: 'Instance Creation'
classmethod: GsSftpRemoteFile
openRemoteFileReadOnly: fileName withSftpSocket: aGsSftpSocket

"Opens a remote file for reading on a remote host using a connected instance of GsSftpSocket.
Raises an error if the remote file does not exist.
Returns a new instance of the receiver or raises an exception on error."

^self openRemoteFile: fileName mode: 'r' permissions: nil errorIfExists: false withSftpSocket: aGsSftpSocket
%

category: 'Examples'
classmethod: GsSftpRemoteFile
randomRemoteFileNameForSelector: aSelector

"Create a new remote file with a random file name including aSelector"

^ aSelector asString, '_', GsUuidV4 new asString, '.rnd' . "generate random remote filename which includes the callers selector"
%

category: 'Examples'
classmethod: GsSftpRemoteFile
statExample
"This example does an stat operation on a random remote file on the sftp server and returns an instance of GsFileStat."
"GsSftpRemoteFile statExample"

| sftpSock anyFile stat  |
"Common example method to create the sftpSocket"
sftpSock := self getSftpSocketExample .
anyFile := (sftpSock contentsOfRemoteDirectoryNoDotFiles: '.') first.
stat := sftpSock stat: anyFile .
sftpSock close.
^ stat
%

category: 'Examples'
classmethod: GsSftpRemoteFile
uploadObjectToRemoteFileAndRenameExample
"This example uploads the data contained in a ByteArray to a new file on the sftp server and then renames the file"

"GsSftpRemoteFile uploadObjectToRemoteFileAndRenameExample"

| sftpSock sftpFile bytes remoteFn randomData newRemoteFn sel |
sel := (GsProcess methodAt: 1 ) selector .
"Common example method to create the sftpSocket"
sftpSock := self getSftpSocketExample .

remoteFn := self randomRemoteFileNameForSelector: sel . "generate random remote filename"
"Create a new write-only sftpFile instance using the sftp socket we created."
sftpFile := self createNewRemoteFile: remoteFn withSftpSocket: sftpSock .
"Create a ByteArray of random data"
randomData := ByteArray withRandomBytes: 65536 .

"Upload the entire ByteArray to the file"
bytes := sftpFile writeAllFrom: randomData .
sftpFile close.
"Cleanup: Tell the sftpSocket to delete the remote file"
newRemoteFn := GsUuidV4 new asString . "generate random new remote filename"
sftpSock renameRemoteFile: remoteFn to: newRemoteFn .
sftpSock removeRemoteFile: newRemoteFn ; close.
^ 'success: ', bytes asString , ' bytes were uploaded to ', remoteFn , ' and renamed to ', newRemoteFn
%

category: 'Examples'
classmethod: GsSftpRemoteFile
uploadObjectToRemoteFileExample
"This example uploads the data contained in a ByteArray to a new file on the sftp server"

"GsSftpRemoteFile uploadObjectToRemoteFileExample"

| sftpSock sftpFile bytes remoteFn randomData sel |
sel := (GsProcess methodAt: 1 ) selector .
"Common example method to create the sftpSocket"
sftpSock := self getSftpSocketExample .

remoteFn := self randomRemoteFileNameForSelector: sel . "generate random remote filename"
"Create a new write-only sftpFile instance using the sftp socket we created."
sftpFile := self createNewRemoteFile: remoteFn withSftpSocket: sftpSock .
"Create a ByteArray of random data"
randomData := ByteArray withRandomBytes: 65536 .

"Upload the entire ByteArray to the file"
bytes := sftpFile writeAllFrom: randomData  .
sftpFile close.
"Cleanup: Tell the sftpSocket to delete the remote file"
sftpSock removeRemoteFile: remoteFn ; close .
^ 'success: ', bytes asString , ' bytes were uploaded to ', remoteFn
%

category: 'Examples'
classmethod: GsSftpRemoteFile
uploadToRemoteFileExample
"This example uploads the file $GEMSTONE/bin/intiail.config to the sftp server under a new random file name"

"GsSftpRemoteFile uploadToRemoteFileExample"

| sftpSock sftpFile gsFile localFn bytes remoteFn gs sel |
sel := (GsProcess methodAt: 1 ) selector .
"Common example method to create the sftpSocket"
sftpSock := self getSftpSocketExample .
gs := System gemEnvironmentVariable: 'GEMSTONE'.
localFn := gs, '/bin/initial.config' .
remoteFn := self randomRemoteFileNameForSelector: sel .
"Create a new write-only sftpFile instance using the sftp socket we created."
sftpFile := self  createNewRemoteFile: remoteFn withSftpSocket: sftpSock .
"Open a new GsFile instance where we will read the data from."
gsFile := GsFile openReadOnServer: localFn .
gsFile ifNil:[ self halt: ('Cannot find local file ', localFn) ].
"Upload the entire file"
bytes := sftpFile writeAllFrom: gsFile .
gsFile close. "Close source file"
sftpFile close. "Close remote file"
sftpSock removeRemoteFile: remoteFn ; close.
^ 'success: ', bytes asString , ' bytes were uploaded to ', remoteFn
%

category: 'Private'
classmethod: GsSftpRemoteFile
_fiveArgSftpRemoteFilePrim: opcode with: arg1 with: arg2 with: arg3 with: arg4 with: arg5

"opcode function
1		instance method:	readFromOffset: to: into: startingAt:
2		instance method:	writeToOffset: from: startingAt: endingAt:
100		class method: 		openRemoteFile:mode:permissions:errorIfExists:withSftpSocket:

"
<primitive: 905>

^self _primitiveFailed: #_fiveArgSftpRemoteFilePrim:with:with:with:with:with: args: {opcode}
%

!		Instance methods for 'GsSftpRemoteFile'

category: 'Assertions'
method: GsSftpRemoteFile
assertOpen

^ self isOpen
	ifTrue: [ self ]
	ifFalse:[ SshSocketError signal: 'Attempted operation on a remote file which is not open']
%

category: 'Assertions'
method: GsSftpRemoteFile
assertReadable

^ self isReadable
	ifTrue: [ self ]
	ifFalse:[ SshSocketError signal: 'Attempt to read a remote file not opened for reading']
%

category: 'Testing'
method: GsSftpRemoteFile
atEnd
"Returns true if the receiver is currently positioned at the end of its
 file, false if not. Raises an exception if the receiver is not open or if an error occurs."

self assertOpen ; assertReadable.
^ self position >= self size
%

category: 'Closing'
method: GsSftpRemoteFile
close

self _zeroArgSftpRemoteFilePrim: 70 .
sftpSocket _removeReference: self .
sftpSocket := nil.
^ self
%

category: 'File Operations'
method: GsSftpRemoteFile
fstat

"Return an instance of GsFileStat describing the remote file.
Raise an exception if the file is not open or cannot be accessed."

^ self _zeroArgSftpRemoteFilePrim: 72
%

category: 'Private'
method: GsSftpRemoteFile
initializeWith: aGsSftpSocket

"primitive stores aGsSftpSocket in inst var aGsSftpSocket"
aGsSftpSocket _addReference: self .
^ self
%

category: 'Testing'
method: GsSftpRemoteFile
isAppendable

"Answer a Boolean indicating if the receiver is open for appending"

^ self _zeroArgSftpRemoteFilePrim: 75
%

category: 'Testing'
method: GsSftpRemoteFile
isOpen

"Answer a Boolean indicating if the receiver is open"

^ self _zeroArgSftpRemoteFilePrim: 71
%

category: 'Testing'
method: GsSftpRemoteFile
isReadable

"Answer a Boolean indicating if the receiver is open for reading"

^ self _zeroArgSftpRemoteFilePrim: 73
%

category: 'Testing'
method: GsSftpRemoteFile
isWritable

"Answer a Boolean indicating if the receiver is open for writing"

^ self _zeroArgSftpRemoteFilePrim: 74
%

category: 'Reading'
method: GsSftpRemoteFile
peek

"Returns the a Character representing the next byte in the receiver without advancing
the file pointer. The receiver must be open for reading. Returns nil if the receiver is at the end
of file. Raises an exception on error."

|ba|
^ (1 == (self peek: 1 into: (ba := ByteArray new: 1)))
	ifTrue:[ ba charAt: 1 ]
	ifFalse:[ nil ]
%

category: 'Reading'
method: GsSftpRemoteFile
peek: amount into: aByteObject

"Reads the next amount bytes from the receiver and stores into aByteObject without advancing the receiver's file pointer.
The receiver must be open for reading. Returns the number of bytes stored in the receiver, which may be less than amount
if the operation would read beyond the end of the receiver. Raises an exception on error."

|pos result |
pos := self position .
result := self read: amount into: aByteObject .
self position: pos.
^ result
%

category: 'Positioning'
method: GsSftpRemoteFile
position

"Answer the current position in the remote file. The position is the zero-based offset from the first byte in the remote file,
i.e. the beginning of the file has a position of 0."

^ self _zeroArgSftpRemoteFilePrim: 76
%

category: 'Positioning'
method: GsSftpRemoteFile
position: anInt

"Changes the position of file pointer of the receiver to be anInt. The position is the zero-based offset from the first byte in the remote file,
i.e. the beginning of the file has a position of 0.
Raises an error if anInt would change the position to be beyond the end of the remote file.
Returns the receiver."

^self _oneArgSftpRemoteFilePrim: 70 with: anInt
%

category: 'Reading'
method: GsSftpRemoteFile
read: amount into: byteObjOrGsFile

"Reads up to the given number of bytes into byteObjOrGsFile starting at the current file position of the receiver.
The receiver must be open for reading. If byteObjOrGsFile is a byte object, the data read is stored starting at index 1.
If byteObjOrGsFile is an instance of GsFile, the data read is stored into the GsFile as if the method #write:from: method
had been called. The GsFile must be opened for writing or appending.

Returns the number of bytes stored into byteObjOrGsFile."

^self _twoArgSftpRemoteFilePrim: 70 with: amount with: byteObjOrGsFile
%

category: 'Reading'
method: GsSftpRemoteFile
readAllInto: byteObjOrGsFile

"Reads the contents of the receiver into byteObjOrGsFile. Reading begins at the current position of the reeiver's file pointer.
The receiver must be open for reading. If byteObjOrGsFile is a byte object, the data read is stored starting at index 1.
If byteObjOrGsFile is an instance of GsFile, the data read is stored into the GsFile as if the method #write:from: method
had been called. The GsFile must be opened for writing or appending.

Returns the number of bytes stored into byteObjOrGsFile."

^self read: -1 into: byteObjOrGsFile
%

category: 'Accessing'
method: GsSftpRemoteFile
remoteFileName
	^remoteFileName
%

category: 'Updating'
method: GsSftpRemoteFile
remoteFileName: newValue
	remoteFileName := newValue
%

category: 'Accessing'
method: GsSftpRemoteFile
size

"Answer a SmallInteger indicating the size of the remote file in bytes.
Raises an error if the receiver is not open."

^ self fstat size
%

category: 'Writing'
method: GsSftpRemoteFile
write: amount from: byteObjOrGsFile

"Writes the given number of bytes from byteObjOrGsFile to the receiver which must be open for writing or appending.
If the receiver is open for appending, the write begins at the end of the file. Otherwise the write begins at the receiver's current
file pointer position.

byteObjOrGsFile must be either an instance of a ByteClass or an instance of GsFile open for reading.
Returns the number of bytes written to the receiver."

^self _twoArgSftpRemoteFilePrim: 71 with: amount with: byteObjOrGsFile
%

category: 'Writing'
method: GsSftpRemoteFile
writeAllFrom: byteObjOrGsFile

"Writes the contents of byteObjOrGsFile into the receiver. The receiver must be open for writing or appending.
If the receiver is open for appending, the write begins at the end of the file. Otherwise the write begins at the receiver's current
file pointer position.

byteObjOrGsFile must be either an instance of a ByteClass or an instance of GsFile open for reading.
If byteObjOrGsFile is a GsFile, reading begins at the current position of the file pointer.
Returns the number of bytes written to the receiver."

^self write: -1 from: byteObjOrGsFile
%

category: 'Private'
method: GsSftpRemoteFile
_fiveArgSftpRemoteFilePrim: opcode with: arg1 with: arg2 with: arg3 with: arg4 with: arg5

"opcode function
1		instance method:	readFromOffset: to: into: startingAt:
2		instance method:	writeToOffset: from: startingAt: endingAt:
100		class method: 		openRemoteFile:mode:permissions:errorIfExists:withSftpSocket:

"
<primitive: 905>

^self _primitiveFailed: #_fiveArgSftpRemoteFilePrim:with:with:with:with:with: args: {opcode}
%

category: 'Private'
method: GsSftpRemoteFile
_oneArgSftpRemoteFilePrim: opcode with: arg1

"GsSshSocket opCodes
opcode	method
1		instance method: hostAuthenticationEnabled:
2		instance method: password:
3		instance method: privateKey:
4		instance method: executeRemoteCommand:
5		instance method: makeBlocking / makeNonBlocking
6		instance method: nbExecuteRemoteCommand:
100		class method enableTraceFileInDirectory:
101		class method setSshTraceLevel:

GsSftpSocket opCodes
51		instance method: removeRemoteDirectory:
53		instance method: removeRemoteFile:
54		instance method: stat:
55		instance method: lstat:

GsSftpRemoteFile opCodes:
70		instance method: position:
"
<primitive: 903>
^ self _primitiveFailed: #_oneArgSftpRemoteFilePrim:with: args: { opcode }
%

category: 'Private'
method: GsSftpRemoteFile
_twoArgSftpRemoteFilePrim: opcode with: arg1 with: arg2
"
GsSshSocket opCodes
opcode  function
1	instance methods: sshOptionAt: / sshOptionAt:put:

GsSftpSocket opCodes
50	instance method: createRemoteDirectory:mode:
51	instance method: renameRemoteFile: to:
52	instance method: contentsAndStatDetailsOfRemoteDirectory:withPattern:
53	instance method: contentsOfRemoteDirectorywithPattern:

GsSftpRemoteFile opCodes
70	instance method: read:into:
71	instance method: write:from:
"

<primitive: 904>
^ self _primitiveFailed: #_twoArgSftpRemoteFilePrim:with:with: args: {opcode}
%

category: 'Private'
method: GsSftpRemoteFile
_zeroArgSftpRemoteFilePrim: opCode

"GsSshSocket opCodes
opcode  method
1		instance method: initializeAsClient
2		instance method: initializeAfterConnect
3		instance method _sshConnect
4		instance method hasSshConnectInProgress
5		instance method _sshClose
6		instance method nbRemoteCommandResult
7		instance method: hasCommandInProgress
8		instance method isBlocking
9		instance method nbRemoteCommandResultReady
100		class method disableTraceFile
101 	class method getSshLogLevel
102		class method libSshVersion
103		class method traceFileName

GsSftpSocket opCodes
opcode  method
50		instance method: currentRemoteDirectory

GsSftpRemoteFile opCodes
opcode  method
70		instance method: close
71		instance method: isOpen
72		instance method: fstat
73		instance method: isReadable
74		instance method: isWriteable
75		instance method: isAppendable
76		instance method: position
"

<primitive: 902>
^ self _primitiveFailed: #_zeroArgSftpRemoteFilePrim: args: { opCode }
%

! Class implementation for 'GsSysLog'

!		Class methods for 'GsSysLog'

category: 'Setting Flags'
classmethod: GsSysLog
allFlagBits
^ 63
%

category: 'Setting Flags'
classmethod: GsSysLog
defaultFlags
"Answer a SmallInteger containing the default flags used for writing messages
 to the system log."
^ self setFlagIncludePid: (self setFlagLogToConsoleOnError: 0)
%

category: 'Setting Flags'
classmethod: GsSysLog
setFlagForStderr: anInt
^ anInt bitOr: 1
%

category: 'Setting Flags'
classmethod: GsSysLog
setFlagIncludePid: anInt
^ anInt bitOr: 8
%

category: 'Setting Flags'
classmethod: GsSysLog
setFlagLogOnGemHost: anInt
^ anInt bitOr: 32
%

category: 'Setting Flags'
classmethod: GsSysLog
setFlagLogOnStoneHost: anInt
^ anInt bitOr: 16
%

category: 'Setting Flags'
classmethod: GsSysLog
setFlagLogToConsoleOnError: anInt
^ anInt bitOr: 4
%

category: 'Setting Flags'
classmethod: GsSysLog
setFlagNoCloselog: anInt
^ anInt bitOr: 2
%

category: 'Logging'
classmethod: GsSysLog
writeErrorMessage: messageString
"Writes an error message to the syslog using default settings."

^ self writeLogMessage: messageString
       prefix: nil
       priority: #LOG_ERR
       facility: #LOG_USER
       flags: self defaultFlags
%

category: 'Logging'
classmethod: GsSysLog
writeInfoMessage: messageString
"Writes an informational message to the syslog using default settings."
^ self writeLogMessage: messageString
       prefix: nil
       priority: #LOG_INFO
       facility: #LOG_USER
       flags: self defaultFlags
%

category: 'Logging'
classmethod: GsSysLog
writeLogMessage: messageString prefix: prefixString priority: priSym facility: facSym flags: flagsInt
"Writes messageString to the system log by calling the UNIX fuctions openlog(),
 syslog() and closelog().

 The messageString argument must be an instance of String or a instance of a
 subclass of String, or an instance of Utf8.
 It also must have a size between 1 and 4905 characters.
 The message written vi syslog() will be terminated at any codepoint of zero
 within messageString .

 The prefixString argument must be an instance of String, an instance of a
 subclass of String, or nil.  If it is not nil, then it also must have a size
 between 1 and 1023 characters.  A value of nil causes the default prefix
 of 'GemStone' to be used for the prefix.  Characters beyond a codepoint of zero
 in prefixString are ignored.

 The priSym argument indicates the priority of the message and must be one
 of the following symbols:

   #LOG_EMERG      system is unusable
   #LOG_ALERT      action must be taken immediately
   #LOG_CRIT       critical conditions
   #LOG_ERR        error conditions
   #LOG_WARNING    warning conditions
   #LOG_NOTICE     normal, but significant, condition
   #LOG_INFO       informational message
   #LOG_DEBUG      debug-level message

 The facSym argument indicates what type of program is logging the message
 (called the facility) and must be one of the following symbols:

   #LOG_USER       generic user-level messages
   #LOG_LOCAL0     reserved for local use
   #LOG_LOCAL1     reserved for local use
   #LOG_LOCAL2     reserved for local use
   #LOG_LOCAL3     reserved for local use
   #LOG_LOCAL4     reserved for local use
   #LOG_LOCAL5     reserved for local use
   #LOG_LOCAL6     reserved for local use
   #LOG_LOCAL7     reserved for local use

The flagsInt argument is a SmallInteger which is either 0 or the bitwise-OR
of any of the following values:

  1 - Write the message to stderr of this process as well as the system
      logger.
  2 - Do not call closelog() after writing the message.
  4 - Write directly to system console if there is an error while sending
      to system logger (LOG_CONS option).
  8 - Include the PID with each message (LOG_PID option).
 16 - Write the message to the system logger on the stone's host.  Has no
      effect unless the gem is running on a host remote from the stone.
 32 - Write the message on the system logger gem's host.  Has no
      effect unless the gem is running on a host remote from the stone.

 For sessions that are not on same host as the stone, at least one of the bits
 corresponding to the values 16 and 32 must be set.

 Note: The host system may impose message and prefix size limits smaller than
       the limits specified above.  Consult the system documentation for the
       syslog() function to determine what the actual limits enforced by the
       system are.

 Signals an error if the privilege NoPerformOnServer is true and the
 special entry /GsSysLog/writeLogMessage is not present in the allowlist of
 allowed commands for the session's UserProfile. See the methods in
 UserProfile under category PerformOnServer for more information.

 Returns the receiver."

<primitive: 1006>
self _validateString: messageString withMaxSize: 4095 .
prefixString == nil
  ifFalse:[ self _validateString: prefixString withMaxSize: 1023 ] .
priSym  _validateClass: Symbol .
facSym  _validateClass: Symbol .
flagsInt _validateClass: SmallInteger .
((flagsInt < 0) or:[ flagsInt > self allFlagBits ])
  ifTrue:[ flagsInt _error: #rtErrArgOutOfRange args:{ 0 . self allFlagBits } ] .
(self _allPrioritySymbols includesIdentical: priSym)
  ifFalse:[ ArgumentError new object: priSym ;
                          signal: 'Invalid priority'].
(self _allFacilitySymbols includesIdentical: facSym)
  ifFalse:[ ArgumentError new object: facSym ;
                          signal: 'Invalid facility'].
((flagsInt bitAnd: (16 bitOr:32)) == 0 and:[ System sessionIsOnStoneHost not])
  ifTrue:[ ArgumentError new object: flagsInt ;
		signal:'sessionIsOnStoneHost==true, flags must specify stone or gem host'].
^ self _primitiveFailed: #_primSysLogMessage:prefix:priority:facility:flags:
       args: { messageString . prefixString . priSym . facSym . flagsInt  }
%

category: 'Logging'
classmethod: GsSysLog
writeWarningMessage: messageString
"Writes a warning message to the syslog using default settings."

^ self writeLogMessage: messageString
       prefix: nil
       priority: #LOG_WARNING
       facility: #LOG_USER
       flags: self defaultFlags
%

category: 'Private'
classmethod: GsSysLog
_allFacilitySymbols

^ { #LOG_USER   . #LOG_LOCAL0  . #LOG_LOCAL1 . #LOG_LOCAL2 . #LOG_LOCAL3 .
    #LOG_LOCAL4 . #LOG_LOCAL5  . #LOG_LOCAL6 . #LOG_LOCAL7 }
%

category: 'Private'
classmethod: GsSysLog
_allPrioritySymbols

^ { #LOG_EMERG  . #LOG_ALERT . #LOG_CRIT . #LOG_ERR . #LOG_WARNING .
    #LOG_NOTICE . #LOG_INFO  . #LOG_DEBUG }
%

category: 'Private'
classmethod: GsSysLog
_validateString: anObj withMaxSize: anInt
| sz |
(anObj isKindOfClass: Utf8) ifFalse:[
  anObj  _validateKindOfClass: String .  "single byte strings or Utf8 only"
].
sz := anObj _basicSize . "Use #_basicSize in case #size has been overloaded."
((sz == 0) or:[ sz > anInt ])
  ifTrue:[ anObj _error: #rtErrBadSize args:{ 1 . anInt } ] .
^ true
%

! Class implementation for 'GsTlsCredential'

!		Class methods for 'GsTlsCredential'

category: 'Class Membership'
classmethod: GsTlsCredential
isOpenSshClass

^ self subclassResponsibility: #isOpenSshClass
%

category: 'Class Membership'
classmethod: GsTlsCredential
isOpenSslClass

^ self isOpenSshClass not
%

category: 'Storing and Loading'
classmethod: GsTlsCredential
loadFrom: passiveObj

"Creates and returns an active instance of the receiver from the passive form
 of the object"

| inst str |
str := passiveObj readObject.
inst := self isOpenSslClass 
	ifTrue:[ self newFromPemString: str ]
	ifFalse:[ self newFromOpenSshString: str ].
passiveObj hasRead: inst.
^inst.
%

category: 'Class Membership'
classmethod: GsTlsCredential
speciesForOpenSshPrivateKey
  ^ GsSshPrivateKey
%

category: 'Class Membership'
classmethod: GsTlsCredential
speciesForOpenSshPublicKey
  ^ GsSshPublicKey
%

category: 'Class Membership'
classmethod: GsTlsCredential
speciesForOpenSslPrivateKey
  ^ GsTlsPrivateKey
%

category: 'Class Membership'
classmethod: GsTlsCredential
speciesForOpenSslPublicKey
  ^ GsTlsPublicKey
%

category: 'Private'
classmethod: GsTlsCredential
tls0ArgClassPrim: opCode

"
  OpCode   Function
=========================================================================
     0      instance: asPemString
     1      instance: hash
     2      instance: algorithm
     3      instance: sslAlgorithm
     4      instance: description
     5      instance: securityBits
     6      instance: supportsDigitalSignatures
     7      instance: asOpenSshString
     8      instance: asOpenSshStringOneLine
=========================================================================
"

<primitive: 1057>
^ self _primitiveFailed: #tls0ArgClassPrim: args: { opCode }
%

category: 'Private'
classmethod: GsTlsCredential
tls3ArgPrim: opCode with: aString with: pfArg with: type

"
  OpCode   Function
=========================================================================
     0      New GsTlsCredential from PEM file, pfArg is the passphrase
     1      New GsTlsCredential from PEM string, pfArg is the passphrase
     2      New GsX509CertificateChain from PEM file
     3      New GsX509CertificateChain from PEM file
     4      New GsTlsPublicKey from a GsX509Certificate
     5      New GsTlsCredential from PEM file, pfArg is a file name
     6      New GsTlsCredential from PEM string, pfArg is a file name
     7      New GsTlsCredential from OpenSSH file, pfArg is the passphrase
     8      New GsTlsCredential from OpenSSH string, pfArg is the passphrase
     9      New GsTlsCredential from OpenSSH file, pfArg is a file name
    10      New GsTlsCredential from OpenSSH string, pfArg is a file name
=========================================================================

  Type      Kind
============================
    1       Private Key
    2       Public Key
    3       X509 Certificate
============================
"

<primitive: 1056>
^ self _primitiveFailed: #tls3ArgPrim:with:with:with: args: { opCode . aString . pfArg . type }
%

!		Instance methods for 'GsTlsCredential'

category: 'Testing'
method: GsTlsCredential
= anObj

^ self tls1ArgInstPrim: 0 with: anObj
%

category: 'Accessing'
method: GsTlsCredential
algorithm

"Answers a Symbol indicating the type of high-level PKI algorithm the
receiver uses. The high-level PKI algorithms currently supported are:

   #RSA - Rivest-Shamir-Adleman
   #DSA - Data Signature Algorithm
   #EC  - Elliptic Curve Cryptography

 All high-level algorithm have various sub-types. Use the sslAlgorithm
 method to obtain information about the specific PKI algorithm of the
 receiver.

 If the receiver is an instance of GsX509Certificate, the result
 indicates the algorithm of the public key contained therein.

 Returns #UNSUPPORTED if the algorithm could not be determined."

^ self tls0ArgInstPrim: 2
%

category: 'Converting'
method: GsTlsCredential
asOpenSshKey
  self subclassResponsibility: #asOpenSshKey
%

category: 'Converting'
method: GsTlsCredential
asOpenSshString

"Returns a String representing the receiver in OpenSSH base 64 format.
 For private keys, base64 text lines are limited to 70 characters."
 
  ^ self tls0ArgInstPrim: 7
%

category: 'Converting'
method: GsTlsCredential
asOpenSshStringOneLine

"Returns a String representing the receiver in OpenSSH base 64 format.
 Base64 text is placed on a single line"
 
  ^ self tls0ArgInstPrim: 8
%

category: 'Converting'
method: GsTlsCredential
asOpenSslKey
  self subclassResponsibility: #asOpenSslKey
%

category: 'Converting'
method: GsTlsCredential
asPemString

^ self tls0ArgInstPrim: 0
%

category: 'Testing'
method: GsTlsCredential
canCreateDigitalSignatures
  self subclassResponsibility: #canCreateDigitalSignatures
%

category: 'Testing'
method: GsTlsCredential
canVerifyDigitalSignatures
  self subclassResponsibility: #canVerifyDigitalSignatures
%

category: 'Printing'
method: GsTlsCredential
description
"Answers a String obtained from SSL describing the receiver. The contents
 and format of the string vary depending on the receiver's class."

^ self tls0ArgInstPrim: 4
%

category: 'Hashing'
method: GsTlsCredential
hash

^ self tls0ArgInstPrim: 1
%

category: 'Testing'
method: GsTlsCredential
isDsa

"Answer a Boolean indicating if the receiver uses DSA cryptography"
^ self algorithm == #DSA
%

category: 'Testing'
method: GsTlsCredential
isEllipticCurve

"Answer a Boolean indicating if the receiver uses elliptic curve cryptography"
^ self algorithm == #EC
%

category: 'Testing'
method: GsTlsCredential
isOpenSshKey
  ^ self class isOpenSshClass
%

category: 'Testing'
method: GsTlsCredential
isOpenSslKey
  ^ self class isOpenSslClass
%

category: 'Testing'
method: GsTlsCredential
isPrivateKey
  self subclassResponsibility: #isPrivateKey
%

category: 'Testing'
method: GsTlsCredential
isPublicKey
  self subclassResponsibility: #isPublicKey
%

category: 'Testing'
method: GsTlsCredential
isRsa

"Answer a Boolean indicating if the receiver uses RSA cryptography"
^ self algorithm == #RSA
%

category: 'Testing'
method: GsTlsCredential
isX509Certificate
  self subclassResponsibility: #isX509Certificate
%

category: 'Comparing'
method: GsTlsCredential
matches: anotherKey

"Determines if the receiver and anotherKey match each other as a valid
 public-private key pair. If the receiver is a public key, anotherKey
 is expected to be a private key. If the receiver is a private key,
 another key is expected to be a public key.

 If the receiver or anotherKey is an instance of GsX509Certificate, the
 public key is extracted from the certificate and the comparison is
 performed as described above.

 RSA and DSA key pairs match if both keys use the same modulus.
 Elliptic curve key pairs match if both keys use the same curve and the
 same point on that curve.

 Returns true if the keys match, false if they do not match.
 Raises an error if the receiver and anotherKey are both the same type
 (public or private keys)."

^ self tls1ArgInstPrim: 2 with: anotherKey
%

category: 'Accessing'
method: GsTlsCredential
securityBits
"Answers a SmallInteger representing the number of security bits of the
 receiver.  Bits of security is defined in NIST SP800-57.  See
   https://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-57pt1r4.pdf
 for further information.

 For instances of GsX509Certificate, answers the security bits of the public
 key contained therein."

^ self tls0ArgInstPrim: 5
%

category: 'Accessing'
method: GsTlsCredential
sslAlgorithm

"Answers a Symbol indicating the SSL type of PKI algorithm the
 receiver uses. The values returned by OpenSSL as of version
 1.1.1 are:

    #EVP_PKEY_NONE
    #EVP_PKEY_RSA
    #EVP_PKEY_RSA2
    #EVP_PKEY_RSA_PSS
    #EVP_PKEY_DSA
    #EVP_PKEY_DSA1
    #EVP_PKEY_DSA2
    #EVP_PKEY_DSA3
    #EVP_PKEY_DSA4
    #EVP_PKEY_DH
    #EVP_PKEY_DHX
    #EVP_PKEY_EC
    #EVP_PKEY_SM2
    #EVP_PKEY_HMAC
    #EVP_PKEY_CMAC
    #EVP_PKEY_SCRYPT
    #EVP_PKEY_TLS1_PRF
    #EVP_PKEY_HKDF
    #EVP_PKEY_POLY1305
    #EVP_PKEY_SIPHASH
    #EVP_PKEY_X25519
    #EVP_PKEY_ED25519
    #EVP_PKEY_X448
    #EVP_PKEY_ED448

 If the recevier is an instance of GsX509Certificate, the result
 indicates the algorithm of the public key contained therein."

^ self tls0ArgInstPrim: 3
%

category: 'Testing'
method: GsTlsCredential
supportsDigitalSignatures
"Answers a Boolean indicating if the receiver supports digital signatures.
 The type of support offered, either signing or verifying, depends upon the
 class of the receiver."

^ self tls0ArgInstPrim: 6
%

category: 'Private'
method: GsTlsCredential
tls0ArgInstPrim: opCode

"
  OpCode   Function
=========================================================================
     0      instance: asPemString
     1      instance: hash
     2      instance: algorithm
     3      instance: sslAlgorithm
     4      instance: description
     5      instance: securityBits
     6      instance: supportsDigitalSignatures
     7      instance: asOpenSshString
     8      instance: asOpenSshStringOneLine
     9      instance: subjectName
    10      instance: issuerName
    11      instance: notBeforeTimeGmtSeconds
    12      instance: notAfterTimeGmtSeconds
    13      instance: subjectAlternateNames
=========================================================================
"

<primitive: 1057>
^ self _primitiveFailed: #tls0ArgInstPrim: args: { opCode }
%

category: 'Private'
method: GsTlsCredential
tls1ArgInstPrim: opCode with: anObj

"
  OpCode   Function
=========================================================================
     0      instance: =
     1      instance: asPublicKey
     2      instance: matches:
     3      instance: encrypt:
     4      instance: decrypt:
=========================================================================
"

<primitive: 1058>
^ self _primitiveFailed: #tls1ArgInstPrim:with: args: { opCode . anObj }
%

category: 'Storing and Loading'
method: GsTlsCredential
writeTo: passiveObj
"Writes the passive form of the receiver into passiveObj, expressed as
 a PEM string."

| str |
passiveObj writeClass: self class.
str := self isOpenSshKey
	ifTrue:[ self asOpenSshString ]
	ifFalse:[ self asPemString ].
str writeTo: passiveObj .
passiveObj space
%

category: 'Private'
method: GsTlsCredential
_validateAlgorithm: expectedSymbol

^ self algorithm == expectedSymbol
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal:
  ('Incorrect key algorithm. Expected: ', expectedSymbol asString, ' Actual: ', self algorithm asString)]
%

category: 'Private'
method: GsTlsCredential
_validateCreatesDigitalSignatures
^ self canCreateDigitalSignatures
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'This key is not valid for creating digital signatures']
%

category: 'Private'
method: GsTlsCredential
_validateIsPrivateKey
^ self isPrivateKey
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: expected a private key']
%

category: 'Private'
method: GsTlsCredential
_validateIsPublicKey
^ self isPublicKey
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: expected a public key']
%

category: 'Private'
method: GsTlsCredential
_validateIsRsa

^ self algorithm == #RSA
     ifTrue:[ true ]
    ifFalse:[  CryptoError signal: 'An RSA key or certificate is required']
%

category: 'Private'
method: GsTlsCredential
_validateValidatesDigitalSignatures
^ self canVerifyDigitalSignatures
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'This key is not valid for validating digital signatures']
%

! Class implementation for 'GsTlsPrivateKey'

!		Class methods for 'GsTlsPrivateKey'

category: 'Examples'
classmethod: GsTlsPrivateKey
encryptDecryptBase64Example

|privKey pubKey poe b64 poe2 |

privKey := GsTlsPrivateKey newFromPemString:
'-----BEGIN PRIVATE KEY-----
MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMBXQWaLW7QhuWvO
17X5c8LYDbw65if4QR2ATaNZ0Cq3Q6Q+aCsnmT1Q3AvKwUx0Y3PnASLLl0zNQN94
nbNP81vT/0D4J0Ch1HwGUErZReLDN2DSoUELdnmbrgR10Glriy3HD6wb0q+h/N45
8JpR6sTYhVlLtvnGYAJL2OW5kVRVAgMBAAECgYEAl6My+Hld7wG3gXstLVZhIXfc
PE3jLhfWnj+M9f/U0hhxx4c78OnjMigRk2piQrhvv+ybRKdlvTMEtioNilS58ogV
/I5dRoHsRd2opsUeDMloRdOMcL6HhinjGtPFqY/QXdeKKLLAfR2Mw1GKaro55hQv
DRqRk01Gd/KvWij5roECQQDz+9VW54+qolrDH2iw0BBeeYBog/ELA8vNw7te4OWH
0TrPHUDyvHkJCQ/GSWHLVQ2Rw/WoyKMTn7u/LF8pspp9AkEAydBN8IPdID8m5rk8
JYr1iPceAyoI5ZeUA1cqrFjx4HdtyVAuLGQAvVSY7fJaSzlrBeH8HVa3GlDJ3Qr1
Tt1wuQJAJnbhX14KTEBkRrbA7n8e1YYaNF/4tF/Y1YuyEncqOItH1jcqcho8iqwf
DIetHz09cmmOZRmcfA+GrdD0/8HkkQJANUUxvYHhFYj16MMOWE6Uv0GTf3xR+uCG
5lbU4cdcmUaNCS2L8pW3CELTV0O4h9CxKk1bchcYn+6hSiKBW/7hqQJBAKcucW2t
HDhYqOhZi+Eq+z7mnua7x867COGlijb3yE80rvmqBOOZc3PtJNr2SKQoBjD++B4w
HSedUWX12Gyb0SE=
-----END PRIVATE KEY-----' .

pubKey := GsTlsPublicKey newFromPemString:
'-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDAV0Fmi1u0Iblrzte1+XPC2A28
OuYn+EEdgE2jWdAqt0OkPmgrJ5k9UNwLysFMdGNz5wEiy5dMzUDfeJ2zT/Nb0/9A
+CdAodR8BlBK2UXiwzdg0qFBC3Z5m64EddBpa4stxw+sG9KvofzeOfCaUerE2IVZ
S7b5xmACS9jluZFUVQIDAQAB
-----END PUBLIC KEY-----' .

poe := 'Once upon a midnight dreary, while I pondered, weak and weary,'.

"Encrypt using public key. b64 is a String "
b64 := (pubKey encrypt: poe) asBase64String.

"Decrypt using private key and convert ByteArray into String"
poe2 := (privKey decrypt: (ByteArray fromBase64String: b64)) bytesIntoString .
^ poe = poe2
%

category: 'Examples'
classmethod: GsTlsPrivateKey
encryptDecryptExample

|privKey pubKey poe crypt poe2 |

privKey := GsTlsPrivateKey newFromPemString:
'-----BEGIN PRIVATE KEY-----
MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMBXQWaLW7QhuWvO
17X5c8LYDbw65if4QR2ATaNZ0Cq3Q6Q+aCsnmT1Q3AvKwUx0Y3PnASLLl0zNQN94
nbNP81vT/0D4J0Ch1HwGUErZReLDN2DSoUELdnmbrgR10Glriy3HD6wb0q+h/N45
8JpR6sTYhVlLtvnGYAJL2OW5kVRVAgMBAAECgYEAl6My+Hld7wG3gXstLVZhIXfc
PE3jLhfWnj+M9f/U0hhxx4c78OnjMigRk2piQrhvv+ybRKdlvTMEtioNilS58ogV
/I5dRoHsRd2opsUeDMloRdOMcL6HhinjGtPFqY/QXdeKKLLAfR2Mw1GKaro55hQv
DRqRk01Gd/KvWij5roECQQDz+9VW54+qolrDH2iw0BBeeYBog/ELA8vNw7te4OWH
0TrPHUDyvHkJCQ/GSWHLVQ2Rw/WoyKMTn7u/LF8pspp9AkEAydBN8IPdID8m5rk8
JYr1iPceAyoI5ZeUA1cqrFjx4HdtyVAuLGQAvVSY7fJaSzlrBeH8HVa3GlDJ3Qr1
Tt1wuQJAJnbhX14KTEBkRrbA7n8e1YYaNF/4tF/Y1YuyEncqOItH1jcqcho8iqwf
DIetHz09cmmOZRmcfA+GrdD0/8HkkQJANUUxvYHhFYj16MMOWE6Uv0GTf3xR+uCG
5lbU4cdcmUaNCS2L8pW3CELTV0O4h9CxKk1bchcYn+6hSiKBW/7hqQJBAKcucW2t
HDhYqOhZi+Eq+z7mnua7x867COGlijb3yE80rvmqBOOZc3PtJNr2SKQoBjD++B4w
HSedUWX12Gyb0SE=
-----END PRIVATE KEY-----' .

pubKey := GsTlsPublicKey newFromPemString:
'-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDAV0Fmi1u0Iblrzte1+XPC2A28
OuYn+EEdgE2jWdAqt0OkPmgrJ5k9UNwLysFMdGNz5wEiy5dMzUDfeJ2zT/Nb0/9A
+CdAodR8BlBK2UXiwzdg0qFBC3Z5m64EddBpa4stxw+sG9KvofzeOfCaUerE2IVZ
S7b5xmACS9jluZFUVQIDAQAB
-----END PUBLIC KEY-----' .

poe := 'Once upon a midnight dreary, while I pondered, weak and weary,'.

"Encrypt using public key. crypt is a ByteArray"
crypt := pubKey encrypt: poe.

"Decrypt using private key and convert ByteArray into String"
poe2 :=  (privKey decrypt: crypt) bytesIntoString .

^ poe = poe2
%

category: 'Class Membership'
classmethod: GsTlsPrivateKey
isOpenSshClass

^ false
%

category: 'Instance Creation'
classmethod: GsTlsPrivateKey
newFromPemFile: fileNameString
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. If the PEM file contains multiple keys, only the
 first is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver.

 The private key is assumed to not have a passphrase."

^ self tls3ArgPrim: 0 with: fileNameString with: nil with: 1
%

category: 'Instance Creation'
classmethod: GsTlsPrivateKey
newFromPemFile: fileNameString withPassphrase: aPf
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. If the PEM file contains multiple keys, only the
 first is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver or if the
 passphrase is incorrect."

^ self tls3ArgPrim: 0 with: fileNameString with: aPf with: 1
%

category: 'Instance Creation'
classmethod: GsTlsPrivateKey
newFromPemFile: fileNameString withPassphraseFile: aPfFile
"Reads data from the given file name in PEM format and the passphrase from 
 the text file aPfFile, then creates a new instance of the receiver.
 If the PEM file contains multiple keys, only the first key is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver or if 
 aPfFile does not exist or cannot be read."
 
^ self tls3ArgPrim: 5 with: fileNameString with: aPfFile with: 1
%

category: 'Instance Creation'
classmethod: GsTlsPrivateKey
newFromPemString: aPemString
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple keys, only the first is read.

 Raises an exception if the string is not in PEM format or if the type
 of object in the PEM string does not match the receiver.

 The private key is assumed to not have a passphrase."

^ self tls3ArgPrim: 1 with: aPemString with: nil with: 1
%

category: 'Instance Creation'
classmethod: GsTlsPrivateKey
newFromPemString: aPemString withPassphrase: aPf
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple keys, only the first is read.

 Raises an exception if the string is not in PEM format or if the type
 of object in the PEM string does not match the receiver or if the
 passphrase is incorrect."

^ self tls3ArgPrim: 1 with: aPemString with: aPf with: 1
%

category: 'Instance Creation'
classmethod: GsTlsPrivateKey
newFromPemString: aPemString withPassphraseFile: aPfFile
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple keys, only the first is read. Reads the passphrase
 from the file aPfFile.

 Raises an exception if the string is not in PEM format, if the type 
 of object in the PEM string does not match the receiver, if the 
 passphrase is incorrect, or if aPfFile does not exist or cannot
 be read."

^ self tls3ArgPrim: 6 with: aPemString with: aPfFile with: 1
%

category: 'Class Membership'
classmethod: GsTlsPrivateKey
speciesForPublicKey
  ^ GsTlsPublicKey
%

!		Instance methods for 'GsTlsPrivateKey'

category: 'Converting'
method: GsTlsPrivateKey
asOpenSshKey
  ^ self class speciesForOpenSshPrivateKey newFromOpenSshString: self asOpenSshString
%

category: 'Converting'
method: GsTlsPrivateKey
asOpenSslKey
  ^ self
%

category: 'Converting'
method: GsTlsPrivateKey
asPublicKey
"Answers a new object which represents the public key for the receiver.
 The class of the new instance is the result of the message
 #speciesForPublicKey, which is GsTlsPublicKey by default"

^ self tls1ArgInstPrim: 1 with: self speciesForPublicKey
%

category: 'Testing'
method: GsTlsPrivateKey
canCreateDigitalSignatures
^ self supportsDigitalSignatures
%

category: 'Testing'
method: GsTlsPrivateKey
canVerifyDigitalSignatures
"Only public keys and certificates may be used to verify signatures."
^ false
%

category: 'Decrypting'
method: GsTlsPrivateKey
decrypt: aByteArray
"Decrypts aByteArray which was previously encrypted with the receiver's matching 
 public key. Only RSA keys are supported for encrypting and decrypting.

 aByteArray must be an instance of a ByteArray.

 Returns a new instance ByteArray on success.
 Raises an exception on error."

^ self tls1ArgInstPrim: 4 with: aByteArray
%

category: 'Testing'
method: GsTlsPrivateKey
isPrivateKey
 ^ true
%

category: 'Testing'
method: GsTlsPrivateKey
isPublicKey
 ^ false
%

category: 'Testing'
method: GsTlsPrivateKey
isX509Certificate
 ^ false
%

category: 'Class Membership'
method: GsTlsPrivateKey
speciesForPublicKey
  ^ self class speciesForPublicKey
%

category: 'Private'
method: GsTlsPrivateKey
_validateIsNotRsaPss
^ self sslAlgorithm ~~ #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: illegal RSS_PSS private key']
%

category: 'Private'
method: GsTlsPrivateKey
_validateIsRsa
^ self algorithm == #RSA
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key algorithm: expected an RSA private key']
%

category: 'Private'
method: GsTlsPrivateKey
_validateIsRsaPss
^ self sslAlgorithm == #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: expected an RSS_PSS private key']
%

! Class implementation for 'GsSshPrivateKey'

!		Class methods for 'GsSshPrivateKey'

category: 'Class Membership'
classmethod: GsSshPrivateKey
isOpenSshClass

^ true
%

category: 'Instance Creation'
classmethod: GsSshPrivateKey
newFromOpenSshFile: fileNameString
"Reads data from the given file name in OpenSSH base64 format and creates
 a new instance of the receiver. 

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. 
 Note: dsa keys are no longer supported by libssh.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported.

 The private key is assumed to not have a passphrase."

^ self tls3ArgPrim: 7 with: fileNameString with: nil with: 1
%

category: 'Instance Creation'
classmethod: GsSshPrivateKey
newFromOpenSshFile: fileNameString withPassphrase: aPf
"Reads data from the given file name in OpenSSH base64 format and creates 
 a new instance of the receiver.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the
 passphrase is incorrect."

^ self tls3ArgPrim: 7 with: fileNameString with: aPf with: 1
%

category: 'Instance Creation'
classmethod: GsSshPrivateKey
newFromOpenSshFile: fileNameString withPassphraseFile: aPfFile
"Reads data from the given file name in OpenSSH base64 format and the 
 passphrase from the text file aPfFile, then creates a new instance of the 
 receiver.

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. 
 Note: dsa keys are no longer supported by libssh.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported."
 
^ self tls3ArgPrim: 9 with: fileNameString with: aPfFile with: 1
%

category: 'Instance Creation'
classmethod: GsSshPrivateKey
newFromOpenSshString: aBase64String
"Creates a new instance of the receiver based on the OpenSSH base64 string. 

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. 
 Note: dsa keys are no longer supported by libssh.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported.

 The private key is assumed to not have a passphrase."

^ self tls3ArgPrim: 8 with: aBase64String with: nil with: 1
%

category: 'Instance Creation'
classmethod: GsSshPrivateKey
newFromOpenSshString: aBase64String withPassphrase: aPf
"Creates a new instance of the receiver based on the OpenSSH base64 string. 

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. dsa keys are 
 no longer supported by OpenSSH.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported."

^ self tls3ArgPrim: 8 with: aBase64String with: aPf with: 1
%

category: 'Instance Creation'
classmethod: GsSshPrivateKey
newFromOpenSshString: aBase64String withPassphraseFile: aPfFile
"Creates a new instance of the receiver based on the OpenSSH base64 string. 

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. 
 Note: dsa keys are no longer supported by libssh.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported."

^ self tls3ArgPrim: 10 with: aBase64String with: aPfFile with: 1
%

category: 'Class Membership'
classmethod: GsSshPrivateKey
speciesForPublicKey
  ^ GsSshPublicKey
%

!		Instance methods for 'GsSshPrivateKey'

category: 'Converting'
method: GsSshPrivateKey
asOpenSshKey
  ^ self
%

category: 'Converting'
method: GsSshPrivateKey
asOpenSslKey
  ^ self class speciesForOpenSslPrivateKey newFromPemString: self asPemString
%

category: 'Testing'
method: GsSshPrivateKey
isPrivateKey
 ^ true
%

category: 'Testing'
method: GsSshPrivateKey
isPublicKey
 ^ false
%

category: 'Testing'
method: GsSshPrivateKey
isX509Certificate
 ^ false
%

! Class implementation for 'GsTlsPublicKey'

!		Class methods for 'GsTlsPublicKey'

category: 'Instance Creation'
classmethod: GsTlsPublicKey
fromCertificate: aGsX509Certificate

"Extract the public key from the argument and return a new instance of the
 receiver."

^ self tls3ArgPrim: 4  with: aGsX509Certificate with: nil with: 2
%

category: 'Class Membership'
classmethod: GsTlsPublicKey
isOpenSshClass

^ false
%

category: 'Instance Creation'
classmethod: GsTlsPublicKey
newFromPemFile: fileNameString
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. If the PEM file contains multiple keys, only the
 first is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver."

^ self tls3ArgPrim: 0 with: fileNameString with: nil with: 2
%

category: 'Instance Creation'
classmethod: GsTlsPublicKey
newFromPemString: aPemString
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple keys, only the first is read.

 Raises an exception if the string is not in PEM format or if the type of
 object in the PEM string does not match the receiver."

^ self tls3ArgPrim: 1 with: aPemString with: nil with: 2
%

!		Instance methods for 'GsTlsPublicKey'

category: 'Converting'
method: GsTlsPublicKey
asOpenSshKey

"Not supported. Libssh does not support importing public keys from OpenSSL PEM format."

^ self shouldNotImplement: #asOpenSshKey
%

category: 'Converting'
method: GsTlsPublicKey
asOpenSshString

"Not supported. Libssh does not support importing public keys from OpenSSL PEM format."

^ self shouldNotImplement: #asOpenSshString
%

category: 'Converting'
method: GsTlsPublicKey
asOpenSshStringOneLine

"Not supported. Libssh does not support importing public keys from OpenSSL PEM format."

^ self shouldNotImplement: #asOpenSshStringOneLine
%

category: 'Converting'
method: GsTlsPublicKey
asOpenSslKey
  ^ self
%

category: 'Converting'
method: GsTlsPublicKey
asPublicKey
 ^ self
%

category: 'Testing'
method: GsTlsPublicKey
canCreateDigitalSignatures
"Only private keys may be used to create signatures."
^ false
%

category: 'Testing'
method: GsTlsPublicKey
canVerifyDigitalSignatures
^ self supportsDigitalSignatures
%

category: 'Encrypting'
method: GsTlsPublicKey
encrypt: aByteObj
"Encrypts aByteObj using the receiver which must be an RSA public key 
 or X509 certificate object. This method supports RSA keys only.
 Encryption is performed using the RSA-OAEP padding algorithm. 

 Only small amounts of data may be encrypted using asymmetric 
 keys. The maximum allowed size of aByteObj is dependent on the 
 the number of bits in the receiver's public key. For 2048 bit keys, 
 the maximum size is 214 bytes. For 4096 bit keys, the maximum size is 
 470 bytes.

 aByteObj must be an instance of a byte class, typically ByteArray.
 Byte objects with character sizes greater than 1 are not supported.

 Returns a new instance of ByteArray containing the encrypted data.
 Raises an exception on error."

^ self tls1ArgInstPrim: 3 with: aByteObj
%

category: 'Testing'
method: GsTlsPublicKey
isPrivateKey
 ^ false
%

category: 'Testing'
method: GsTlsPublicKey
isPublicKey
 ^ true
%

category: 'Testing'
method: GsTlsPublicKey
isX509Certificate
 ^ false
%

category: 'Private'
method: GsTlsPublicKey
_validateIsNotRsaPss
^ self sslAlgorithm ~~ #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: illegal RSS_PSS public key']
%

category: 'Private'
method: GsTlsPublicKey
_validateIsRsaPss
^ self sslAlgorithm == #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: expected an RSS_PSS public key']
%

! Class implementation for 'GsSshPublicKey'

!		Class methods for 'GsSshPublicKey'

category: 'Class Membership'
classmethod: GsSshPublicKey
isOpenSshClass

^ true
%

category: 'Instance Creation'
classmethod: GsSshPublicKey
newFromOpenSshFile: fileNameString
"Reads data from the given file name in OpenSSH base64 format and creates a new instance
 of the receiver. 

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver."

^ self tls3ArgPrim: 7 with: fileNameString with: nil with: 2
%

category: 'Instance Creation'
classmethod: GsSshPublicKey
newFromOpenSshString: aBase64String
"Creates a new instance of the receiver based on the OpenSSH base64 string. 

 Raises an exception if the string is not in OpenSSH base64 format or if the type
 of object in the string does not match the receiver."

^ self tls3ArgPrim: 8 with: aBase64String with: nil with: 2
%

!		Instance methods for 'GsSshPublicKey'

category: 'Converting'
method: GsSshPublicKey
asOpenSshKey
  ^ self
%

category: 'Converting'
method: GsSshPublicKey
asOpenSshString

"Returns a String representing the receiver in OpenSSH base 64 format.
 For private keys, base64 text lines are limited to 70 characters."
 
  ^ self tls0ArgInstPrim: 7
%

category: 'Converting'
method: GsSshPublicKey
asOpenSshStringOneLine

"Returns a String representing the receiver in OpenSSH base 64 format.
 Base64 text is placed on a single line"
 
  ^ self tls0ArgInstPrim: 8
%

category: 'Converting'
method: GsSshPublicKey
asOpenSslKey
  ^ self class speciesForOpenSslPublicKey newFromPemString: self asPemString
%

category: 'Testing'
method: GsSshPublicKey
isPrivateKey
 ^ false
%

category: 'Testing'
method: GsSshPublicKey
isPublicKey
 ^ true
%

category: 'Testing'
method: GsSshPublicKey
isX509Certificate
 ^ false
%

! Class implementation for 'GsX509Certificate'

!		Class methods for 'GsX509Certificate'

category: 'Class Membership'
classmethod: GsX509Certificate
isOpenSshClass

^ false
%

category: 'Instance Creation'
classmethod: GsX509Certificate
newFromPemFile: fileNameString
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. If the PEM file contains multiple certificates, only
 the first is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver."

^ self tls3ArgPrim: 0 with: fileNameString with: nil with: 3
%

category: 'Instance Creation'
classmethod: GsX509Certificate
newFromPemString: aPemString
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple certificates, only the first is read.

 Raises an exception if the string is not in PEM format or if the type of object in
 the PEM string does not match the receiver."

^ self tls3ArgPrim: 1 with: aPemString with: nil with: 3
%

!		Instance methods for 'GsX509Certificate'

category: 'Converting'
method: GsX509Certificate
asOpenSshKey
  ^ self class speciesForOpenSshPublicKey newFromOpenSshString: self asPublicKey asOpenSshString
%

category: 'Converting'
method: GsX509Certificate
asOpenSslKey
  ^ self asPublicKey
%

category: 'Converting'
method: GsX509Certificate
asPublicKey
"Extract the public key from the receiver and return a new instance
 of the public key class for the receiver (default: GsTlsPublicKey)."

 ^ self publicKeySpecies fromCertificate: self
%

category: 'Testing'
method: GsX509Certificate
canCreateDigitalSignatures

^ false
%

category: 'Testing'
method: GsX509Certificate
canVerifyDigitalSignatures
^ self supportsDigitalSignatures
%

category: 'Encrypting'
method: GsX509Certificate
encrypt: aByteObj
"Encrypts aByteObj using the receiver which must be an RSA public key 
 or X509 certificate object. This method supports RSA keys only.
 Encryption is performed using the RSA-OAEP padding algorithm. 

 Only small amounts of data may be encrypted using asymmetric 
 keys. The maximum allowed size of aByteObj is dependent on the 
 the number of bits in the receiver's public key. For 2048 bit keys, 
 the maximum size is 214 bytes. For 4096 bit keys, the maximum size is
 470 bytes.

 aByteObj must be an instance of a byte class, typically ByteArray.
 Byte objects with character sizes greater than 1 are not supported.

 Returns a new instance of ByteArray containing the encrypted data.
 Raises an exception on error."

^ self tls1ArgInstPrim: 3 with: aByteObj
%

category: 'Testing'
method: GsX509Certificate
isPrivateKey
 ^ false
%

category: 'Testing'
method: GsX509Certificate
isPublicKey
 ^ false
%

category: 'Testing'
method: GsX509Certificate
isSelfSigned

"Answer a Boolean indicating if the receiver is a self-signed certificate."

^self subjectName = self issuerName
%

category: 'Accessing'
method: GsX509Certificate
issuerName

"Returns a string representing the issuer common name of the receiver."

^ self tls0ArgInstPrim: 10
%

category: 'Testing'
method: GsX509Certificate
isValidNow

"Answer a Boolean indicating if the receiver is valid at this point in time,
 that is the current time falls within the window between the receiver's 'not before'
 and 'not after' times."

| gmtNow |
gmtNow := System timeGmt .
^ (gmtNow >= self notBeforeTimeGmtSeconds) and:[ gmtNow <= self notAfterTimeGmtSeconds ]
%

category: 'Testing'
method: GsX509Certificate
isX509Certificate
 ^ true
%

category: 'Accessing'
method: GsX509Certificate
notAfterTime

"Returns a SmallDateAndTime representing the 'not after' time of the receiver in GMT"

 ^ DateAndTime posixSeconds: self notAfterTimeGmtSeconds offset: Duration zero
%

category: 'Accessing'
method: GsX509Certificate
notAfterTimeGmtSeconds

"Returns a SmallInteger representing 'not after' time of the receiver 
 expressed as the number of seconds since 00:00:00UTC January 1, 1970."
 
^ self tls0ArgInstPrim: 12
%

category: 'Accessing'
method: GsX509Certificate
notBeforeTime

"Returns a SmallDateAndTime representing the 'not before' time of the receiver in GMT"

 ^ DateAndTime posixSeconds: self notBeforeTimeGmtSeconds offset: Duration zero
%

category: 'Accessing'
method: GsX509Certificate
notBeforeTimeGmtSeconds

"Returns a SmallInteger representing 'not before' time of the receiver 
 expressed as the number of seconds since 00:00:00UTC January 1, 1970."
 
 ^ self tls0ArgInstPrim: 11
%

category: 'Converting'
method: GsX509Certificate
publicKeySpecies
 ^ GsTlsPublicKey
%

category: 'Accessing'
method: GsX509Certificate
subjectAlternateNames

"Returns an Array of Strings representing the contents of the subject alternate
 extension contained in the receiver or an empty array if the receiver does not
 contain the extension."

^ self tls0ArgInstPrim: 13
%

category: 'Accessing'
method: GsX509Certificate
subjectName

"Returns a string representing the subject common name of the receiver."

^ self tls0ArgInstPrim: 9
%

! Class implementation for 'GsUuidV4'

!		Class methods for 'GsUuidV4'

category: 'Instance Creation'
classmethod: GsUuidV4
fromString: aUuidString

"Returns a new instance of the receiver. Raises an exception if aUuidString
 is not a valid UUID version 4 string in the following format:

   xxxxxxxx-xxxx-4xxx-Vxxx-xxxxxxxxxxxx

 where x is any valid lower-case hex digit and V is one of 8,9,a or b.

 See RFC 4122 for details"

^ self _oneArgClassPrim: aUuidString opCode: 1
%

category: 'Instance Creation'
classmethod: GsUuidV4
new
^ self _basicNew
%

category: 'Instance Creation'
classmethod: GsUuidV4
new: aSize
^ self shouldNotImplement: #new:
%

category: 'Private'
classmethod: GsUuidV4
_basicNew

^self _zeroArgClassPrim: 1
%

category: 'Private'
classmethod: GsUuidV4
_oneArgClassPrim: arg opCode: opCode

"
opCode	kind	method
===============================
1	class	fromString:
2       inst	<
===============================
"

<primitive: 1123>
opCode _validateClass: SmallInteger .
self _primitiveFailed: #_oneArgClassPrim: .
self _uncontinuableError
%

category: 'Private'
classmethod: GsUuidV4
_zeroArgClassPrim: opCode

"
opCode	kind	method
===============================
1	class	_basicNew
2	inst	asString
3       inst    asInteger
===============================
"

<primitive: 1122>
opCode _validateClass: SmallInteger .
self _primitiveFailed: #_zeroArgClassPrim: .
self _uncontinuableError
%

!		Instance methods for 'GsUuidV4'

category: 'Comparing'
method: GsUuidV4
< aUuid

"Answer a Boolean indicating if the receiver is less than
 aUuid. Raises an exception if aUuid is not a valid instance
 of GsUuidV4 or a subclass."
 
^self _oneArgInstancePrim: aUuid opCode: 2
%

category: 'Comparing'
method: GsUuidV4
<= aUuid
"Answer a Boolean indicating if the receiver is less than
 or equal to aUuid. Raises an exception if aUuid is not a valid instance
 of GsUuidV4 or a subclass."

^ (self = aUuid) or:[self < aUuid]
%

category: 'Comparing'
method: GsUuidV4
= anotherUuid
	"Returns true if all of the following conditions are true, otherwise
	returns false.

	1.  The receiver and anotherUuid are of the same class.
	2.  The two objects are the same size.
	3.  The corresponding elements of the receiver and anotherUuid
		are equal."

	<primitive: 613>
	^ false
%

category: 'Comparing'
method: GsUuidV4
> aUuid
"Answer a Boolean indicating if the receiver is greater than
 aUuid. Raises an exception if aUuid is not a valid instance
 of GsUuidV4 or a subclass."
 
^ aUuid < self
%

category: 'Comparing'
method: GsUuidV4
>= aUuid
"Answer a Boolean indicating if the receiver is greater than
 or equal to aUuid. Raises an exception if aUuid is not a valid instance
 of GsUuidV4 or a subclass."
 
^ (self = aUuid) or:[self > aUuid]
%

category: 'Converting'
method: GsUuidV4
asInteger

^ self _zeroArgInstancePrim: 3
%

category: 'Private - Converting'
method: GsUuidV4
asInteger2
"Smalltalk implementation of the asInteger method."

| sum |
sum := 0 .
1 to: 16 do:[:n| sum := sum + ((self at: n) * (256 raisedTo: (n - 1)))].
^sum
%

category: 'Converting'
method: GsUuidV4
asString
"Returns a 36 character string representing the receiver formatted as specified in
 RFC 4122."
 
^ self _zeroArgInstancePrim: 2 .
%

category: 'Converting'
method: GsUuidV4
asString36
"Encode the receiver as a base 36 string using 0-9 and lowercase a-z.
 Returns an instance of String."

^ (self asInteger printStringRadix: 36) asLowercase
%

category: 'Comparing'
method: GsUuidV4
hash

"Returns a positive SmallInteger based on the byte contents of the receiver.
 Uses a case-sensitive string hash algorithm.
 The algorithm implemented is described in:

 [Pearson 90]
 Pearson, Peter K., Fast Hashing of Variable-Length Text Strings,
 Communications of the ACM 33, 6, (June 1990), 677-680."

<primitive: 31>
self _primitiveFailed: #hash .
self _uncontinuableError
%

category: 'Storing and Loading'
method: GsUuidV4
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into the receiver."

super loadFrom: passiveObj .
self immediateInvariant .
^ self
%

category: 'Copying'
method: GsUuidV4
postCopy
self immediateInvariant .
^ self
%

category: 'Printing'
method: GsUuidV4
printOn: aStream
"Prints a representation of the receiver onto aStream."
 
^ aStream nextPutAll: 'an UUID(';
  	  nextPutAll: self asString ;
	  nextPut: $) ;
	  yourself
%

category: 'Printing'
method: GsUuidV4
printString
"Returns a 36 character string representing the receiver formatted as specified in
 RFC 4122."
 
^ self asString
%

category: 'Updating'
method: GsUuidV4
size: anInteger
^ self shouldNotImplement: #size:
%

category: 'Accessing'
method: GsUuidV4
version
"Answer the UUID version of this object.  See RFC 4122 for UUID version
 definitions."
 
 ^ 4
%

category: 'Updating'
method: GsUuidV4
_basicSize: anInteger
^ self shouldNotImplement: #_basicSize:
%

category: 'Private'
method: GsUuidV4
_oneArgInstancePrim: arg opCode: opCode

"
opCode	kind	method
===============================
1	class	fromString:
2	inst    <
===============================
"

<primitive: 1123>
opCode _validateClass: SmallInteger .
self _primitiveFailed: #_oneArgClassPrim: .
self _uncontinuableError
%

category: 'Private'
method: GsUuidV4
_zeroArgInstancePrim: opCode

"
opCode	kind	method
===============================
1	class	_basicNew
2	inst	asString
3       inst    asInteger
===============================
"

<primitive: 1122>
opCode _validateClass: SmallInteger .
self _primitiveFailed: #_zeroArgInstancePrim: .
self _uncontinuableError
%

! Class implementation for 'HtHeap'

!		Class methods for 'HtHeap'

category: 'instance creation'
classmethod: HtHeap
new: count

	^ (self basicNew: count * 2)
		  initialize;
		  yourself
%

!		Instance methods for 'HtHeap'

category: 'asserting'
method: HtHeap
assertEmpty

	tally == 0 ifFalse: [ self error: 'Expected empty heap' ]
%

category: 'auditing'
method: HtHeap
auditEmptyOnto: stream
	tally = 0
		ifFalse: [ 
			stream
				nextPutAll:
						'Expected heap to be empty with zero tally, but tally is ' , tally printString;
				lf ]
%

category: 'accessing'
method: HtHeap
buildMinHeap
	"Re-order the heap to satisfy the 'heap property' (i.e. sort it into heap order).
	Note that this implementation allows duplicate key values, so only has to re-order
	elements if they violate the heap constraint.
	
	tally // 4 * 2 is the index of the last value that has children. All past that
	already have the heap property, since they have no children. "

	tally // 4 * 2 to: 2 by: -2 do: [ :i | self minHeapify: i ]
%

category: 'accessing'
method: HtHeap
bulkAddHash: hash index: index
	"Add the given hash/index pair (both SmallIntegers) without maintaining the heap property."

	tally := tally + 2.
	self
		_basicAt: tally - 1 put: hash;
		_basicAt: tally put: index
%

category: 'enumerating'
method: HtHeap
destructiveKeysAndValuesDo: aBinaryBlock
	"Remove key/value pairs in ascending key order, evaluating the given block for each.
	This message is not used by TreeDictionary"

	[ tally > 0 ] whileTrue: [
		aBinaryBlock value: (self _basicAt: 1) value: (self _basicAt: 2).
		self _basicAt: 1 put: (self _basicAt: tally - 1).
		self _basicAt: 2 put: (self _basicAt: tally).
		self _basicAt: tally - 1 put: nil.
		self _basicAt: tally put: nil.
		tally := tally - 2.
		self minHeapify: 2 ]
%

category: 'initialization'
method: HtHeap
initialize

	tally := 0
%

category: 'private'
method: HtHeap
minHeapify: index
	"index, and the others, point to the value of the cell to be considered.
	The key is one before that."

	| left right smallest |
	left := 2 * index.
	right := left + 2.
	smallest := index.

	(left <= tally and: [
		 (self _basicAt: left - 1) < (self _basicAt: smallest - 1) ]) ifTrue: [
		smallest := left ].

	(right <= tally and: [
		 (self _basicAt: right - 1) < (self _basicAt: smallest - 1) ])
		ifTrue: [ smallest := right ].

	smallest = index ifFalse: [
		| tKey tValue |
		tKey := self _basicAt: index - 1.
		tValue := self _basicAt: index.
		self _basicAt: index - 1 put: (self _basicAt: smallest - 1).
		self _basicAt: index put: (self _basicAt: smallest).
		self _basicAt: smallest - 1 put: tKey.
		self _basicAt: smallest put: tValue.
		self minHeapify: smallest ]
%

category: 'enumerating'
method: HtHeap
minKey
	"Answer the key that is currently the minimum key, assuming
	that I currently have the heap property."

	^ self _basicAt: 1
%

category: 'enumerating'
method: HtHeap
removeValueWithMinKey
	"Remove a value with the minimum key, and answer it."

	| result |
	tally > 0 ifFalse: [ LookupError new
							object: self;
							signal: 'Heap is empty'].
	result := self _basicAt: 2.
	self _basicAt: 1 put: (self _basicAt: tally - 1).
	self _basicAt: 2 put: (self _basicAt: tally).
	self _basicAt: tally - 1 put: nil.
	self _basicAt: tally put: nil.
	tally := tally - 2.
	self minHeapify: 2.
	^ result
%

! Class implementation for 'HtTreeWalker'

!		Class methods for 'HtTreeWalker'

category: 'instance creation'
classmethod: HtTreeWalker
forCollection: aCollection
	^ self new
		collection: aCollection;
		yourself
%

!		Instance methods for 'HtTreeWalker'

category: 'auditing'
method: HtTreeWalker
auditOnto: stream for: aCollection
	"I'm dbTransient, so it is legit for all of my contents to be nil.
	But if non-nil, should be correct."

	| identifier |
	identifier := self class name , ' ' , self asOop printString , ' '.
	found
		ifNotNil: [ 
			found == false
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'found is ' , found printString , ', should be false';
						lf ] ].
	collection
		ifNotNil: [ 
			collection == aCollection
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'collection is ' , collection printString , ' with oop '
										, collection asOop printString
										, ' should be the collection I belong to';
						lf ] ].
	value
		ifNotNil: [ 
			stream
				nextPutAll:
						identifier , 'value is ' , value printString , ' with oop '
								, value asOop printString , ' should be nil';
				lf ]
%

category: 'accessing'
method: HtTreeWalker
collection: aCollection
	collection := aCollection
%

category: 'accessing'
method: HtTreeWalker
found
	^ found
%

category: 'accessing'
method: HtTreeWalker
reset
	found := false.
	value := nil
%

category: 'private-query'
method: HtTreeWalker
searchInteriorNode: node forValueAt: key withHash: hash
	| child childIndex maxIndex nextHash |
	childIndex := node lowestChildIndexForHash: hash.
	nextHash := hash.
	maxIndex := node maxChildIndex.
	[ nextHash = hash and: [ childIndex <= maxIndex and: [ found not ] ] ]
		whileTrue: [ 
			child := node at: childIndex.
			self searchNode: child forValueAt: key withHash: hash.
			nextHash := node at: childIndex + 1.
			childIndex := childIndex + 2 ]
%

category: 'private-removing'
method: HtTreeWalker
searchInternalNode: node isFinalSibling: nodeIsFinal forRemoveKey: key withHash: hash
	| child childIndex maxIndex nextHash childPercentFull |
	childIndex := node lowestChildIndexForHash: hash.
	nextHash := hash.
	maxIndex := node maxChildIndex.
	[ nextHash = hash and: [ childIndex <= maxIndex and: [ found not ] ] ]
		whileTrue: [ 
			child := node at: childIndex.
			nextHash := node at: childIndex + 1.

			childPercentFull := self
				searchNode: child
				isFinalSibling: (nodeIsFinal and: [ nextHash > hash ])
				forRemoveKey: key
				withHash: hash.
			childIndex := childIndex + 2 ].

	(found and: [ childPercentFull <= 40 ])
		ifTrue: [ 
			| childSibling "Child has gotten small. Try to consolidate it with a sibling." |
			"Try right sibling first."
			childIndex <= maxIndex
				ifTrue: [ 
					childSibling := node at: childIndex.
					childPercentFull + childSibling percentFull <= 85
						ifTrue: [ 
							child absorbRightSibling: childSibling.
							node removeLeftwardChildAtIndex: childIndex.
							^ node percentFull ] ].
			childIndex := childIndex - 4.
			childIndex >= 2
				ifTrue: [ 
					childSibling := node at: childIndex.
					childPercentFull + childSibling percentFull <= 85
						ifTrue: [ 
							child absorbLeftSibling: childSibling.
							node removeRightwardChildAtIndex: childIndex ] ] ].
	^ node percentFull
%

category: 'private-query'
method: HtTreeWalker
searchLeafNode: node forValueAt: key withHash: hash
	self subclassResponsibility
%

category: 'private-removing'
method: HtTreeWalker
searchLeafNode: node isFinalSibling: nodeIsFinal forRemoveKey: key withHash: hash
	self subclassResponsibility
%

category: 'private-query'
method: HtTreeWalker
searchNode: node forValueAt: key withHash: hash

	node isLeaf
		ifTrue: [ self searchLeafNode: node forValueAt: key withHash: hash ]
		ifFalse: [
		self searchInteriorNode: node forValueAt: key withHash: hash ]
%

category: 'private-removing'
method: HtTreeWalker
searchNode: node isFinalSibling: nodeIsFinal forRemoveKey: key withHash: hash
	"Answer the percent full (as an integer) that the  node is after removal"

	^ node isLeaf
		ifTrue: [ 
			self
				searchLeafNode: node
				isFinalSibling: nodeIsFinal
				forRemoveKey: key
				withHash: hash ]
		ifFalse: [ 
			self
				searchInternalNode: node
				isFinalSibling: nodeIsFinal
				forRemoveKey: key
				withHash: hash ]
%

category: 'public'
method: HtTreeWalker
searchTree: rootNode forValueAt: key withHash: hash
	found := false.
	self searchNode: rootNode forValueAt: key withHash: hash.
	^ found
%

category: 'public'
method: HtTreeWalker
searchTree: rootNode removeKey: key withHash: hash
	"Answer nil, or new root node if the tree is losing a level.
	Root node has no siblings, so is always the final sibling."

	found := false.
	self
		searchNode: rootNode
		isFinalSibling: true
		forRemoveKey: key
		withHash: hash.
	^ rootNode isDegenerate
		ifTrue: [ rootNode soleChild ]
		ifFalse: [ nil ]
%

category: 'accessing'
method: HtTreeWalker
value
	^value
%

! Class implementation for 'HtDictionaryTreeWalker'

!		Instance methods for 'HtDictionaryTreeWalker'

category: 'private-updating'
method: HtDictionaryTreeWalker
searchInternalNode: node isFinalSibling: nodeIsFinal forAt: key withHash: hash put: aValue
	| child childIndex maxIndex nextHash newChildNode |
	childIndex := node lowestChildIndexForHash: hash.
	nextHash := hash.
	maxIndex := node maxChildIndex.
	newChildNode := nil.
	[ nextHash = hash and: [ childIndex <= maxIndex and: [ found not ] ] ]
		whileTrue: [ 
			child := node at: childIndex.
			nextHash := node at: childIndex + 1.

			newChildNode := self
				searchNode: child
				isFinalSibling: (nodeIsFinal and: [ nextHash > hash ])
				forAt: key
				withHash: hash
				put: aValue.
			childIndex := childIndex + 2 ].
	nodeIsFinal
		ifFalse: [ ^ nil ].
	newChildNode ifNil: [ ^ nil ].
	node insertChildNode: newChildNode atIndex: childIndex.
	^ node isFull
		ifTrue: [ node split ]
		ifFalse: [ nil ]
%

category: 'private-query'
method: HtDictionaryTreeWalker
searchLeafNode: node forValueAt: key withHash: hash

	| index |
	index := node indexForKey: key withHash: hash.
	(node at: index) == nil ifFalse: [
		found := true.
		value := node at: index + 1 ]
%

category: 'private-updating'
method: HtDictionaryTreeWalker
searchLeafNode: node isFinalSibling: nodeIsFinal forAt: key withHash: hash put: aValue

	| index |
	index := node indexForKey: key withHash: hash.
	(node at: index) ifNotNil: [
		found := true.
		node at: index + 1 put: aValue.
		^ nil ].

	"If key is not yet found and I'm the last leaf to be searched, add the key/value pair."
	nodeIsFinal ifFalse: [ ^ nil ].
	node addKey: key value: aValue atKeyIndex: index.
	^ node isFull
		  ifTrue: [ node split ]
		  ifFalse: [ nil ]
%

category: 'private-removing'
method: HtDictionaryTreeWalker
searchLeafNode: node isFinalSibling: nodeIsFinal forRemoveKey: key withHash: hash
	| index |
	index := node indexForKey: key withHash: hash.
	(node at: index)
		ifNotNil: [ 
			found := true.
			value := node at: index + 1.
			node removeKeyAt: index ].
	^ node percentFull
%

category: 'private-updating'
method: HtDictionaryTreeWalker
searchNode: node isFinalSibling: nodeIsFinal forAt: key withHash: hash put: aValue

	^ node isLeaf
		  ifTrue: [
			  self
				  searchLeafNode: node
				  isFinalSibling: nodeIsFinal
				  forAt: key
				  withHash: hash
				  put: aValue ]
		  ifFalse: [
			  self
				  searchInternalNode: node
				  isFinalSibling: nodeIsFinal
				  forAt: key
				  withHash: hash
				  put: aValue ]
%

category: 'public'
method: HtDictionaryTreeWalker
searchTree: rootNode at: key withHash: hash put: aValue
	"Root node has no siblings, so is always the final sibling."

	| newNode |
	found := false.
	newNode := self
		searchNode: rootNode
		isFinalSibling: true
		forAt: key
		withHash: hash
		put: aValue.
	found := false.
	^ newNode
%

! Class implementation for 'HtSetTreeWalker'

!		Instance methods for 'HtSetTreeWalker'

category: 'private-updating'
method: HtSetTreeWalker
searchInternalNode: node isFinalSibling: nodeIsFinal forAdd: key withHash: hash
	| child childIndex maxIndex nextHash newChildNode |
	childIndex := node lowestChildIndexForHash: hash.
	nextHash := hash.
	maxIndex := node maxChildIndex.
	newChildNode := nil.
	[ nextHash = hash and: [ childIndex <= maxIndex and: [ found not ] ] ]
		whileTrue: [ 
			child := node at: childIndex.
			nextHash := node at: childIndex + 1.

			newChildNode := self
				searchNode: child
				isFinalSibling: (nodeIsFinal and: [ nextHash > hash ])
				forAdd: key
				withHash: hash.
			childIndex := childIndex + 2 ].
	nodeIsFinal
		ifFalse: [ ^ nil ].
	newChildNode ifNil: [ ^ nil ].
	node insertChildNode: newChildNode atIndex: childIndex.
	^ node isFull
		ifTrue: [ node split ]
		ifFalse: [ nil ]
%

category: 'private-query'
method: HtSetTreeWalker
searchLeafNode: node forValueAt: key withHash: hash

	| index keyFound |
	index := node indexForKey: key withHash: hash.
	keyFound := node at: index.
	keyFound == nil ifFalse: [
		found := true.
		value := keyFound ]
%

category: 'private-updating'
method: HtSetTreeWalker
searchLeafNode: node isFinalSibling: nodeIsFinal forAdd: key withHash: hash
	| index keyFound |
	index := node indexForKey: key withHash: hash.
	keyFound := node at: index.
	keyFound
		ifNotNil: [ 
			found := true.	"Already present; done."
			^ nil ].	

	"If key is not yet found and I'm the last leaf to be searched, add the key."
	nodeIsFinal
		ifFalse: [ ^ nil ].
	node addKey: key atKeyIndex: index.
	^ node isFull
		ifTrue: [ node split ]
		ifFalse: [ nil ]
%

category: 'private-removing'
method: HtSetTreeWalker
searchLeafNode: node isFinalSibling: nodeIsFinal forRemoveKey: key withHash: hash
	| index keyFound |
	index := node indexForKey: key withHash: hash.
	keyFound := node at: index.
	keyFound
		ifNotNil: [ 
			found := true.
			value := keyFound.
			node removeKeyAt: index ].
	^ node percentFull
%

category: 'private-updating'
method: HtSetTreeWalker
searchNode: node isFinalSibling: nodeIsFinal forAdd: key withHash: hash
	^ node isLeaf
		ifTrue: [ 
			self
				searchLeafNode: node
				isFinalSibling: nodeIsFinal
				forAdd: key
				withHash: hash ]
		ifFalse: [ 
			self
				searchInternalNode: node
				isFinalSibling: nodeIsFinal
				forAdd: key
				withHash: hash ]
%

category: 'public'
method: HtSetTreeWalker
searchTree: rootNode toAdd: key withHash: hash
	"Root node has no siblings, so is always the final sibling."

	| newNode |
	found := false.
	newNode := self
		searchNode: rootNode
		isFinalSibling: true
		forAdd: key
		withHash: hash.
	found := false.
	^ newNode
%

! Class implementation for 'JsonParser'

!		Class methods for 'JsonParser'

category: 'other'
classmethod: JsonParser
parse: aString

	^self new
		initialize: aString;
		_value
%

!		Instance methods for 'JsonParser'

category: 'other'
method: JsonParser
array

	| array char |
	array := Array new.
	self assert: self nextChar is: $[.
	[
		(char := self peekChar) ifNil: [self error: 'Unterminated array!'].
		char ~~ $].
	] whileTrue: [ | v |
    v := self _value.
		array add: v.
		char := self peekChar.
		char == $, ifTrue: [
			self nextChar. 
			char := self peekChar.
		].
	].
	self assert: self nextChar is: $].
	^array
%

category: 'other'
method: JsonParser
assert: actual is: expected
	actual = expected ifTrue: [^self].
	Error signal: 'Invalid JSON, at ', self positionAsString,
        ' expected ' , expected printString,' actual ', actual printString
%

category: 'other'
method: JsonParser
initialize: aString

	stream := ReadByteStream on: aString.
  linePosition := 1 .
  lineNumber := 1 .
%

category: 'other'
method: JsonParser
nextChar

	| char |
	char := self peekChar.
	char ifNotNil: [stream next].
	^char
%

category: 'other'
method: JsonParser
number

	| char sign number fraction divisor exponent |
	char := self peekChar.
	char == $- ifTrue: [
		sign := -1.
		char := stream next; peek.
	] ifFalse: [
		sign := 1.
	].
	number := 0.
  char isDigit ifFalse:[ 
     Error signal: 'Invalid JSON, at ', self positionAsString,
          'expected a digit, got ', char printString .
  ].
	char == $0 ifTrue: [
		char := stream next; peek.
	] ifFalse: [
		[char ~~ nil and: [char isDigit]] whileTrue: [
			number := number * 10 + char codePoint - $0 codePoint.
			char := stream next; peek.
		].
	].
	divisor := 1.0.
	fraction := 0.
	char == $. ifTrue: [
		[
			char := stream next; peek.
			char notNil and: [char isDigit].
		] whileTrue: [
			fraction := fraction * 10 + char codePoint - $0 codePoint.
			divisor := divisor * 10.
			
		].
		number := number + (fraction / divisor).
	].
	number := number * sign.
	(char == $e or: [char == $E]) ifTrue: [
		char := stream next; peek.
		sign := 1.
		char == $- ifTrue: [sign := -1. char := stream next; peek] ifFalse: [
		char == $+ ifTrue: [char := stream next; peek]].
		exponent := 0.
		[char notNil and: [char isDigit]] whileTrue: [
			exponent := exponent * 10 +char codePoint - $0 codePoint.
			char := stream next; peek.
		].
		number := number * (10.0 raisedTo: exponent * sign).
	].
	^number
%

category: 'other'
method: JsonParser
object

	| char key object |
	object := Dictionary new.
	self assert: self nextChar is: ${.
	[
		(char := self peekChar) ifNil: [self error: 'Unterminated object!'].
		char ~~ $}.
	] whileTrue: [
		key := self string.
		self assert: self nextChar is: $:.
		object at: key put: self _value.
		char := self peekChar.
		char == $, ifTrue: [
			self nextChar.
			char := self peekChar.
		].
	].
	self nextChar.
	^object
%

category: 'other'
method: JsonParser
parse: aString

    ^self
        initialize: aString;
        _value
%

category: 'other'
method: JsonParser
peekChar
	| char isSep |
	[
		stream atEnd ifTrue: [^nil].
		char := stream peek.
			(isSep := char isSeparator) ifTrue:[
				 char codePoint == 10 ifTrue:[ 
         lineNumber := lineNumber + 1 .  
         linePosition := stream position + 2 .
       ].
    ].
    isSep
	] whileTrue: [stream next].
	^char
%

category: 'other'
method: JsonParser
positionAsString
  | pos |
  ^  'stream position ', (pos := stream position) asString, 
        ' (at ', (pos - linePosition + 1) asString , ' in line ', lineNumber asString, $)
%

category: 'other'
method: JsonParser
string
	"Began with double quotes character"

	| char str |
	str := String new.
	self assert: self nextChar is: $".
	[
		char := stream next.
		char ~~ $".
	] whileTrue: [
		char == $\ ifTrue: [
			char := stream next.
			char == $"	ifTrue: [ str add: $"	] ifFalse: [
			char == $\	ifTrue: [ str add: $\	] ifFalse: [
			char == $/	ifTrue: [ str add: $/	] ifFalse: [
			char == $b	ifTrue: [ str addCodePoint: 8	] ifFalse: [
			char == $f	ifTrue: [ str addCodePoint: 12	] ifFalse: [
			char == $n	ifTrue: [ str addCodePoint: 10	] ifFalse: [
			char == $r	ifTrue: [ str addCodePoint: 13	] ifFalse: [
			char == $t	ifTrue: [ str addCodePoint: 9	] ifFalse: [
			char == $u	ifTrue: [
				| code |
				code := '16r' , (stream next: 4).
				str add: (Character codePoint: code asNumber).
			]]]]]]]]]
		] ifFalse: [
			str add: char.
		].
	].
	^ str
%

category: 'other'
method: JsonParser
test
"
	GciJsonParser new test.
"

	| val |
	self initialize: 'true'.	self assert: self _value is: true.
	self initialize: 'false'.	self assert: self _value is: false.
	self initialize: 'null'.	self assert: self _value is: nil.
	"number"
	self initialize: '0'.			self assert: self _value is: 0.
	self initialize: '1'.			self assert: self _value class is: SmallInteger.
	self initialize: '123'.		self assert: self _value is: 123.
	self initialize: '-456'.		self assert: self _value is: -456.
	self initialize: '0.'.			self assert: self _value is: 0.
	self initialize: '0.0'.		self assert: self _value is: 0.
	self initialize: '0.25'.		self assert: self _value is: 0.25.
	self initialize: '0.25e2'.	self assert: self _value is: 25.
	self initialize: '25e-2'.	self assert: self _value is: 0.25.
	"string"
	self initialize: '"abc"'.		self assert: self _value is: 'abc'.
	self initialize: '"x\ty"'.	self assert: self _value is: 'x	y'.
	"array"
	self initialize: ' [ 1 , 2 ] '.	self assert: self _value is: #(1 2).
	"object"
	self initialize: '{"x": 1, "y": [2], "z": 3}'.
	val := self _value.
	self
		assert: val size is: 3;
		assert: (val at: 'x') is: 1;
		assert: (val at: 'y') is: #(2);
		assert: (val at: 'z') is: 3 .
%

category: 'other'
method: JsonParser
_value

	| char |
	char := self peekChar.
	char == ${	ifTrue: [^self object	].
	char == $[	ifTrue: [^self array	].
	char == $"	ifTrue: [^self string	].
	char == $t	ifTrue: [self assert: (stream next: 4) is: 'true'	. ^true	].
	char == $f	ifTrue: [self assert: (stream next: 5) is: 'false'	. ^false	].
	char == $n	ifTrue: [self assert: (stream next: 4) is: 'null'	. ^nil		].
	^self number
%

! Class implementation for 'KerberosPrincipal'

!		Class methods for 'KerberosPrincipal'

category: 'Accessing'
classmethod: KerberosPrincipal
allPrincipals
  ^ Globals at: #AllKerberosPrincipals otherwise: nil
%

category: 'Private'
classmethod: KerberosPrincipal
basicNewWithName: aStringOrSymbol loginUserProfile: aUserProfile
"Creates a new instance of the receiver, but does not add the new instance
 to the list to AllKerberosPrincipals.  It is an error if a principal with the same name
 already exists.  It is allowed to use nil for aUserProfile, in the case the
 KerberosPrincipal does not map to a single UserProfile."

| result |
((self principalWithName: aStringOrSymbol) notNil)
  ifTrue:[ ^ self _error: #rtErrPrincipalAlreadyExists args: { aStringOrSymbol } ] .

result := super new .
result _initializeForName: aStringOrSymbol ; loginUserProfile: aUserProfile .
^ result
%

category: 'Illegal Operations'
classmethod: KerberosPrincipal
new

"Disallowed.  To create a new KerberosPrincipal, use newWithName:loginUserProfile: instead "

self shouldNotImplement: #new
%

category: 'Illegal Operations'
classmethod: KerberosPrincipal
new: anInt

"Disallowed.  To create a new KerberosPrincipal, use newWithName:loginUserProfile: instead."
self shouldNotImplement: #new:
%

category: 'Updating'
classmethod: KerberosPrincipal
newPrincipalWithName: aStringOrSymbol loginUserProfile: aUserProfile
"Creates a new instance of KerberosPrincipal and adds it to the AllKerberosPrincipals
 collection. It is an error if a principal with the same name already exits. It is allowed to
 use nil for aUserProfile, in the case the KerberosPrincipal does not map to a single
 UserProfile.

 Requires write access to the GsObjectSecurityPolicy for DataCurator."

| result |
result := self basicNewWithName: aStringOrSymbol loginUserProfile: aUserProfile .
self allPrincipals at: aStringOrSymbol put: result .
^ result
%

category: 'Accessing'
classmethod: KerberosPrincipal
principalWithName: aStringOrSymbol
"Answer the KerberosPrincipal that has the given name or nil if no
 such KerberosPrincipal exists."

  ^ self allPrincipals at: aStringOrSymbol otherwise: nil
%

category: 'Group Management'
classmethod: KerberosPrincipal
removeGroup: aUserProfileGroup

"Remove the given UserProfileGroup object from every instance of KerberosPrincipal contained
 in the global collection AllKerberosPrincipals.  Returns the receiver.

 Requires write access to the DataCurator segment."

aUserProfileGroup _validateClass: UserProfileGroup .
self allPrincipals valuesDo:[:eachPrincipal| eachPrincipal removeGroup: aUserProfileGroup ].
^ self
%

category: 'Group Management'
classmethod: KerberosPrincipal
removeGroupWithName: aStringOrSymbol

"Remove the UserProfileGroup with name aStringOrSymbol from every instance of
 KerberosPrincipal contained in the global collection AllKerberosPrincipals.
 Returns the receiver.

 Requires write access to the DataCurator segment."

| group |
group := UserProfileGroup groupWithName: aStringOrSymbol ifAbsent:[^ self ].
self allPrincipals valuesDo:[:eachPrincipal| eachPrincipal removeGroup: group ].
^ self
%

!		Instance methods for 'KerberosPrincipal'

category: 'Accessing'
method: KerberosPrincipal
addGroup: aUserProfileGroup
  aUserProfileGroup _validateClass: UserProfileGroup .
  loginUserProfileGroups add: aUserProfileGroup .
  ^ self
%

category: 'Accessing'
method: KerberosPrincipal
loginAsAnyoneEnabled
  ^ loginAsAnyoneEnabled
%

category: 'Updating'
method: KerberosPrincipal
loginAsAnyoneEnabled: aBoolean
  loginAsAnyoneEnabled := aBoolean
%

category: 'Accessing'
method: KerberosPrincipal
loginUserProfile
  ^ loginUserProfile
%

category: 'Updating'
method: KerberosPrincipal
loginUserProfile: aUserProfile
  loginUserProfile := aUserProfile
%

category: 'Accessing'
method: KerberosPrincipal
loginUserProfileGroups
  ^ loginUserProfileGroups
%

category: 'Accessing'
method: KerberosPrincipal
name
  ^ name
%

category: 'Removing'
method: KerberosPrincipal
removeGroup: aUserProfileGroup
  loginUserProfileGroups removeIdentical: aUserProfileGroup ifAbsent:[] .
  ^ self
%

category: 'Removing'
method: KerberosPrincipal
removeGroup: aUserProfileGroup ifAbsent: aBlock
  aUserProfileGroup _validateClass: UserProfileGroup .
  loginUserProfileGroups removeIdentical: aUserProfileGroup ifAbsent: aBlock .
  ^ self
%

category: 'Testing'
method: KerberosPrincipal
validateLoginFor: aUserProfile

aUserProfile _validateClass: UserProfile .
(aUserProfile userId = 'SystemUser')
  ifTrue:[ ^ false ]. "Passwordless login may not be used for SystemUser"

(aUserProfile == loginUserProfile)
  ifTrue:[ ^ true ].

loginAsAnyoneEnabled == true
  ifTrue:[ ^ true ].

^ (loginUserProfileGroups detect:[:e| e includesIdentical: aUserProfile] ifNone:[nil]) notNil
%

category: 'Private'
method: KerberosPrincipal
_initializeForName: aStringOrSymbol
"Private.  Initializes the receiver. Used only at instance creation time."
name := aStringOrSymbol asSymbol .
loginUserProfileGroups := IdentitySet new .
loginAsAnyoneEnabled := false .
^ self

%

! Class implementation for 'LdapDirectoryServer'

!		Class methods for 'LdapDirectoryServer'

category: 'Accessing'
classmethod: LdapDirectoryServer
allServers
  ^ AllLdapDirectoryServers
%

category: 'Instance Creation'
classmethod: LdapDirectoryServer
basicNewWithUri: uri bindDN: aBindDn password: password
"Creates a new instance of the receiver, but does not add the new instance
 to the list of LDAP servers used to process login requests."

| result |
result := super new.
result uri: uri ;
       bindDN: aBindDn ;
       password: password .

^ result
%

category: 'Instance Creation'
classmethod: LdapDirectoryServer
basicNewWithUri: uri bindDN: aBindDn password: password baseDN: baseDn tlsCaCert: caCert tlsCert: cert tlsKey: key tlsReqCert: aSymbol
"Creates a new instance of the receiver but does not add it 
 the list of LdapDirectoryServer objects used to authorize logins."
 
| result |
result := super new.
result uri: uri ;
	bindDN: aBindDn ;
	password: password ;
	baseDN: baseDn ;
	tlsCaCert: caCert ;
	tlsCert: cert ;
	tlsKey: key ;
	tlsReqCert: aSymbol .
   
^ result
%

category: 'Searching'
classmethod: LdapDirectoryServer
findServerWithUri: aUriString
"Searches for an instance of LdapDirectoryServer with the given URI.
 Returns nil if the directory server was not found."

^ self allServers detect:[:e| e uri = aUriString ] ifNone:[ nil ]
%

category: 'Illegal Operations'
classmethod: LdapDirectoryServer
new

"Disallowed.  To create a new LdapDirectoryServer, use newWithUri:... instead."

self shouldNotImplement: #new
%

category: 'Illegal Operations'
classmethod: LdapDirectoryServer
new: anInt

"Disallowed.  To create a new LdapDirectoryServer, use newWithUri:... instead."
self shouldNotImplement: #new:
%

category: 'Instance Creation'
classmethod: LdapDirectoryServer
newWithUri: uri bindDN: aBindDn password: password
"Creates a new instance of the receiver and adds the resulting object to
 the list of LdapDirectoryServer objects used to authorize logins."

| result |
result := self basicNewWithUri: uri
               bindDN: aBindDn
	       password: password .
self allServers add: result .
^ result
%

category: 'Instance Creation'
classmethod: LdapDirectoryServer
newWithUri: uri bindDN: aBindDn password: password baseDN: baseDn tlsCaCert: caCert tlsCert: cert tlsKey: key tlsReqCert: aSymbol
"Creates a new instance of the receiver and adds the resulting object to
 the list of LdapDirectoryServer objects used to authorize logins."
 
| result |
result := self basicNewWithUri: uri bindDN: aBindDn password: password baseDN: baseDn tlsCaCert: caCert tlsCert: cert tlsKey: key tlsReqCert: aSymbol .
self allServers add: result .	       
^ result
%

category: 'Removing'
classmethod: LdapDirectoryServer
removeServerWithUri: aUriString
"Removes an instance of LdapDirectoryServer with the given URI.
 Returns true if the directory server was removed, false if it
 could not be found."

| server |
server := self findServerWithUri: aUriString .
server isNil
  ifTrue:[ ^ false "not found" ] .

self allServers removeIdentical: server .
^ true
%

category: 'Connection Testing'
classmethod: LdapDirectoryServer
testConnectionToServer: uri bindDN: aBindDn password: password
"Attempts to perform a bind using aBindDn and password to the LDAP server specified by
 uri.  Returns true if the connection was successful, otherwise returns false."

 | result |
 "Create a temporary instance."
result := self basicNewWithUri: uri
               bindDN: aBindDn
	       password: password .
^ result testBind
%

category: 'Connection Testing'
classmethod: LdapDirectoryServer
testConnectionToServer: uri bindDN: aBindDn password: password baseDN: baseDn tlsCaCert: caCert tlsCert: cert tlsKey: key tlsReqCert: aSymbol
"Attempts to perform a bind using aBindDn and password to the LDAP server specified by
 uri.  Also sets the TLS credentials if those arguments are not nil.
Returns true if the connection was successful, otherwise returns false."
 
 | result |
 "Create a temporary instance."
result := self basicNewWithUri: uri
               bindDN: aBindDn
	       password: password 
	       baseDN: baseDn
	       tlsCaCert: caCert
	       tlsCert: cert
	       tlsKey: key 
	       tlsReqCert: aSymbol .
^ result testBind
%

category: 'Private - Initializing'
classmethod: LdapDirectoryServer
_smartInitialize
"This method should only be called once during filein or image upgrade."
  AllLdapDirectoryServers ifNil:[ | newArray |
      (Object _objectForOop: 156929) ifNotNil:[:o| 
         Error signal:'oop 156929 already exists as a ', o class name .
      ].
      newArray := Array new .
      newArray _unsafeSetOop: 156929  "OOP_AllLdapDirectoryServers".
      newArray objectSecurityPolicy: (Globals at:#DataCuratorObjectSecurityPolicy) .
      AllLdapDirectoryServers := newArray .
      ^ 'created'
  ] .
  ^ 'exists'
%

!		Instance methods for 'LdapDirectoryServer'

category: 'Accessing'
method: LdapDirectoryServer
baseDN
  ^ baseDN
%

category: 'Updating'
method: LdapDirectoryServer
baseDN: newValue
  baseDN := newValue copy
%

category: 'Accessing'
method: LdapDirectoryServer
bindDN
  ^ bindDN
%

category: 'Updating'
method: LdapDirectoryServer
bindDN: aString
  bindDN := aString copy
%

category: 'Accessing'
method: LdapDirectoryServer
bindPW
  ^ bindPW
%

category: 'Updating'
method: LdapDirectoryServer
password: aString
^ aString == nil
    ifTrue:[ nil ]
   ifFalse:[ self _encryptPassword: aString ]
%

category: 'Private'
method: LdapDirectoryServer
testBind
"Attempt to bind to the specified LDAP server. Returns true if successful, false if
 the password is invalid.  Raises an error if an LDAP error occurs."

| result |
result := self _testBind .
result class == String
  ifTrue:[ IOError signal: result ].
^ result
%

category: 'Accessing'
method: LdapDirectoryServer
tlsCaCert
  ^ tlsCaCert
%

category: 'Updating'
method: LdapDirectoryServer
tlsCaCert: newValue
  tlsCaCert := newValue copy
%

category: 'Accessing'
method: LdapDirectoryServer
tlsCaCertDir
  ^ tlsCaCertDir
%

category: 'Updating'
method: LdapDirectoryServer
tlsCaCertDir: newValue
  tlsCaCertDir := newValue copy
%

category: 'Accessing'
method: LdapDirectoryServer
tlsCert
  ^ tlsCert
%

category: 'Updating'
method: LdapDirectoryServer
tlsCert: newValue
  tlsCert := newValue copy
%

category: 'Accessing'
method: LdapDirectoryServer
tlsKey
  ^ tlsKey
%

category: 'Updating'
method: LdapDirectoryServer
tlsKey: newValue
  tlsKey := newValue copy
%

category: 'Accessing'
method: LdapDirectoryServer
tlsReqCert
  ^ tlsReqCert
%

category: 'Updating'
method: LdapDirectoryServer
tlsReqCert: newValue
"A symbol which specifies what checks to perform on server certificates
in a TLS session, if any. The following symbols are recognized:

	#never -   The client will not request or check any server certificate.
	#allow -   The  server certificate is requested. If no certificate is provided,
		          the session proceeds normally. If a bad certificate is provided,
			it will be ignored and the session proceeds normally.
	#try -	The server certificate is requested. If no certificate is provided,
			the session proceeds normally. If a bad certificate is provided,
			the session is immediately terminated.
	#demand -  The server certificate is requested. If no certificate is provided,
			or a bad certificate is provided, the session is immediately
			terminated. This is the default setting.
"
newValue isSymbol
	ifTrue:[  
		({ #never . #allow . #try . #demand } includesIdentical: newValue)
				ifFalse:[ ^ ArgumentError signal: 'Illegal tlsReqCert symbol' ].
	] ifFalse:[
		newValue isNil 
			ifFalse:[ ^ ArgumentError signal: 'Illegal object for tlsReqCert ' ] 
	].
	tlsReqCert := newValue 
%

category: 'Accessing'
method: LdapDirectoryServer
uri
  ^ uri
%

category: 'Updating'
method: LdapDirectoryServer
uri: aString
  uri := aString copy
%

category: 'Password Validation'
method: LdapDirectoryServer
validatePassword: aPassword forUserId: aUserId withBaseDn: aBaseDn filterDn: aFilterDn
"Use the receiver validate the password aPassword is valid for aUserId.  

 In order to validate the password, the complete distinguish name (DN) for 
 aUserId must be determined.  The DN can either be constructed from the aBaseDn
 pattern (explicit mode) or the DN may be resolved by searching the LDAP directory
 (search mode).  In explicit mode, aBaseDn must be a string that contains the string
 wildcard sequence '%s'.  GemStone will substitute '%s' with aUserId before
 doing the password validation.  aFilterDn must be nil in explicit mode.

 In search mode, aBaseDn is the search pattern used to resolve the DN and must
 NOT contain the string wildcard sequence '%s'.  In search mode, aFilterDn must
 be a string that contains the string wildcard sequence '%s'.  See the examples
 below.

 aUserId must be a string which represents the aUserId to be validated.
 aPassword must be a string which is the password for aUserId.

 Returns true if aPassword is the correct password for aUserId. Otherwise returns
 false if the password is incorrect or an error occurred while communicating
 with the LDAP server.  

 Setting the variable GS_DEBUG_LDAP=7 in the gem's environment will cause LDAP debugging
 information to be printed to stdout. Setting the variable GS_DEBUG_LDAP_DIR in the gem's
 environment will cause LDAP debugging information to be written to a new file in that
 directory.

 Example 1: Explicit mode

(LdapDirectoryServer basicNewWithUri: 'ldaps://myldap.mydomain.com'
 bindDN: nil password: nil baseDN: nil tlsCaCert: '/home/gemstone/cacert.pem'
 tlsCert: '/home/gemstone/cert.pem' 
tlsKey: '/home/gemstone/key.pem' tlsReqCert: #never)
validatePassword: 'swordfish' forUserId: 'DataCurator' 
withBaseDn: 'uid=%s,ou=Users,dc=mycompany,dc=com' filterDn: nil

 Example 2: Search mode with anonymous bind

(LdapDirectoryServer basicNewWithUri: 'ldaps://myldap.mydomain.com'
 bindDN: nil password: nil baseDN: nil tlsCaCert: '/home/gemstone/cacert.pem'
 tlsCert: '/home/gemstone/cert.pem' 
tlsKey: '/home/gemstone/key.pem' tlsReqCert: #never)
validatePassword: 'swordfish' forUserId: 'DataCurator' 
withBaseDn: 'ou=Users,dc=mycompany,dc=com' filterDn: '(uid=%s)'

Example 3: Search mode with authenticated bind

(LdapDirectoryServer basicNewWithUri: 'ldaps://myldap.mydomain.com'
 bindDN: 'LdapBindUser'  password: 'LdapBindPassword' baseDN: nil tlsCaCert: '/home/gemstone/cacert.pem'
 tlsCert: '/home/gemstone/cert.pem' 
tlsKey: '/home/gemstone/key.pem' tlsReqCert: #never)
validatePassword: 'swordfish' forUserId: 'DataCurator' 
withBaseDn: 'ou=Users,dc=mycompany,dc=com' filterDn: '(uid=%s)'
"

^ self _oneArgLdapPrim: 1 with: (Array with: aUserId with: aPassword with: aBaseDn with: aFilterDn)
%

category: 'Private'
method: LdapDirectoryServer
_encryptPassword: aString
"Encrypt aString into a ByteArray. Store the ByteArray in the bindPW inst var.
 Returns the receiver."

<primitive: 1008>
self _validateClass: LdapDirectoryServer .
aString _validateClass: String .
self _primitiveFailed: #_encryptPassword: args: { aString } .
self _uncontinuableError
%

category: 'Private'
method: LdapDirectoryServer
_oneArgLdapPrim: opCode with: arg

<primitive: 1009>
self _validateClass: LdapDirectoryServer .
self _primitiveFailed: #_oneArgLdapPrim:with: args: { opCode . arg} . 
self _uncontinuableError
%

category: 'Private'
method: LdapDirectoryServer
_testBind
^ self _oneArgLdapPrim: 0 with: nil
%

! Class implementation for 'PassiveObject'

!		Class methods for 'PassiveObject'

category: 'Instance Creation'
classmethod: PassiveObject
fromClientTextFile: fileName

"Creates a new instance of the receiver, and sets the instance's description
 string from the contents of the given client text file."

^ super new fromClientTextFile: fileName
%

category: 'Instance Creation'
classmethod: PassiveObject
fromServerTextFile: fileName

"Creates a new instance of the receiver, and sets the instance's description
 string from the contents of the given text file."

^ super new fromServerTextFile: fileName
%

category: 'Instance Creation'
classmethod: PassiveObject
new

"Disallowed.  Use one of the other methods in category 'Instance Creation'
 to obtain a new PassiveObject."

self shouldNotImplement: #new
%

category: 'Stream I/O'
classmethod: PassiveObject
newOnStream: aStream
  "Creates a new instance of the receiver, and sets the instance's description
 from the text on the given stream."

  ^ super new contents: aStream
%

category: 'Instance Creation'
classmethod: PassiveObject
newWithContents: passiveString

"Create a new PassiveObject for an existing description.  This is normally
 used to create an instance of PassiveObject for use in activating an object
 previously stored into a passive textual description.  The argument is the
 contents instance variable from a PassiveObject in which descriptions of other
 objects were written."

^super new contents: passiveString
%

category: 'Instance Creation'
classmethod: PassiveObject
passivate: anObject

"Writes the given file to a new instance of this class.  This method is normally
 invoked indirectly by sending the message 'passivate' to an object."

^super new passivate: anObject
%

category: 'Stream I/O'
classmethod: PassiveObject
passivate: anObject toStream: stream

"Writes the given object to the given stream, returning the stream."

^ (super new) passivate: anObject toStream: stream
%

!		Instance methods for 'PassiveObject'

category: 'Reading'
method: PassiveObject
activate
"Loads the object(s) whose representation is contained in the receiver's
 stream."

| object cancelBlock delim |

self initializeForActivation.
(contents class isBytes) ifTrue: [
  str := self readStreamClass on: contents
]
ifFalse: [
  (contents isKindOf: GsFile) ifTrue: [
    file := contents.
    file isOpen ifFalse:[ file open "reopen the file" ].
    str := self readStreamClass on: String new.
    epos := file position.
  ]
  ifFalse: [
    str := contents.
  ].
].
cancelBlock := [ objects := classes := str := exitBlock :=
  cancelBlock := exitBlock := nil ].
exitBlock  := [ cancelBlock value.  ^self].  "for error exits"
self peek == $^ ifTrue:[
  self next . "skip the $^ "
  version := self readInt .
  "skip the $^ that terminates the version header "
  (delim := self next) == $^ ifFalse:[
    self _halt: 'Version header trailing $^ not found.'
  ].
] ifFalse:[
  self halt: 'missing version header, or passive object from Gemstone/S 32bit v4.x'
].
object := self readObject.
cancelBlock value.  "comment out for debugging activation."
cancelBlock := exitBlock := nil .
file ifNotNil:[ file close ].  "reduce number of open files"
^object
%

category: 'Private - File Buffering'
method: PassiveObject
atEnd

"Private."

(file ~~ nil and: [epos == nil or: [str atEnd]]) ifTrue: [
  ^file atEnd
].
^str atEnd
%

category: 'Private - File Buffering'
method: PassiveObject
backupExternal
  "Backup the file stream to current position."

  epos
    ifNotNil: [
      file position: epos + str _fastPosition - 1.
      epos := nil	"epos being nil shows that str is invalid" ]
%

category: 'Private'
method: PassiveObject
bagMark

"Returns the character that precedes the end of instance variables markers in
 Bag objects."

^ $/
%

category: 'Private'
method: PassiveObject
checkEBuf

"Loads the cached stream from the external stream if necessary."

(file ~~ nil and: [ epos == nil or: [ str atEnd ] ]) ifTrue: [
  self loadEBuf
].
%

category: 'Private'
method: PassiveObject
checkForBagMark

"Sees the comment in writeBagMark for an explanation of Bag markers.  Skips any
 white space and then returns whether the next token is a Bag marker."

self skipWhiteSpace.
self atEnd ifTrue: [ ^false ].
^(self next == self bagMark) ifTrue: [ true ] ifFalse: [ str skip: -1. false ]
%

category: 'Private'
method: PassiveObject
checkForInstVarMark

"Sees the comment in writeBagMark for an explanation of Bag markers.  Skips any
 white space and then returns whether the next token is a Bag marker."

| char |

self skipWhiteSpace.
self atEnd ifTrue: [ ^false ].
char := self next.
str skip: -1.
^ char == $" .
%

category: 'Private'
method: PassiveObject
contents

"Returns the content string of the receiver."

^contents
%

category: 'Private'
method: PassiveObject
contents: aStringOrStreamOrGsFile
  "Sets the content string of the receiver."

  contents := aStringOrStreamOrGsFile
%

category: 'Private'
method: PassiveObject
cr

str lf
%

category: 'Private'
method: PassiveObject
endNamedInstVars

"An empty instance variable name identifies the end of named instance
 variables."

str nextPut: $" ; nextPut: $"
%

category: 'File I/O'
method: PassiveObject
fromClientTextFile: fileName

"Sets the receiver's description string from the contents of the given text
 file."

contents := GsFile openRead: fileName .
contents ifNil:[ self _halt:'Unable to open file: ' , fileName ].
%

category: 'File I/O'
method: PassiveObject
fromServerTextFile: fileName

"Sets the receiver's description string from the contents of the given text
 file."

contents := GsFile openReadOnServer: fileName .
contents ifNil:[ self _halt:'Unable to open file: ' , fileName ].
%

category: 'Reading'
method: PassiveObject
hasRead: anObject

"The given object has been instantiated but not filled out with values yet:
 assign it an identifier.  All classes must send this message to their
 strObject before filling in a new instance's values."
anObject isSpecial ifTrue:[ Error signal:'arg to hadRead: is special'. ].
objects add: anObject .
"self _checkObjectAt: objects size." "uncomment to debug activate"
^ anObject
%

category: 'Reading'
method: PassiveObject
hasRead: anObject marker: marker

"For objects whose values must be at least partially read before the object
 can be marked as read, the objectPositionMarker method can be used to
 reserve the correct object number for the as yet uninstantiated object.
 The marker token returned by objectPositionMarker can then later be used
 with this method to record the instantiated object.  For an example
 see ExecBlock class | loadFrom:."

anObject isSpecial ifTrue:[ Error signal:'arg to hadRead: is special'. ].
objects at: marker put: anObject.
"self _checkObjectAt: marker . " "uncomment to debug activate"
^anObject
%

category: 'Private'
method: PassiveObject
hasWritten: anObject
"Sees if the given object has been written already.  If so, writes out its
 identifier and returns true.  Otherwise, returns false."
| id |
anObject containsIdentity ifTrue: [^false].
id := System _inMap: 2"objects" at: anObject putIfAbsent: nextObjectNo
      serialNum: mapCache .
id == nextObjectNo ifTrue: [
  "a new entry"
  anObject isSpecial ifTrue:[ Error signal:'special object not expected'].
  objects add: anObject .
  nextObjectNo := nextObjectNo + 1.
  ^ false
] ifFalse: [
  str nextPut: $: .
  self writeInt: id .
  ^ true
]
%

category: 'Private - Initialization'
method: PassiveObject
initializeForActivation

"Prepares the receiver to activate an object that is in its passive form."

"uncomment to debug activate with _checkObjectAt: "
"objects size > 0 ifTrue:[ self dynamicInstVarAt:#saveObjs put: objects ]."

classes := { } .
objects := { } .
ivNames := { } .
nextClassNo  :=
nextObjectNo :=
nextIVNo     := 1.
epos := nil.
version := nil "the activate method will read the version header" .
%

category: 'Private - Initialization'
method: PassiveObject
initializeForStore

"Prepares the receiver to passivate an object."
classes := { } . "prevent gc of temp objects"
objects := { } . "prevent gc of temp objects"
mapCache := System _initMap: 1 "classes".
System _initMap: 2 "objects".
ivStrings := { } .
nextClassNo  :=
nextObjectNo :=
nextIVNo     := 1.
str := self writeStreamClass on: (String new).
version := 620 .
%

category: 'Private'
method: PassiveObject
ivName

"Returns the name of the last named instance variable read with readNamedIV.
 If no variable was found in readNamedIV, returns nil."

^ ivName
%

category: 'Private'
method: PassiveObject
ivValue

"Returns the value of the last named instance variable read with readNamedIV.
 If no variable was found in readNamedIV, returns nil."

^ ivVal
%

category: 'Private'
method: PassiveObject
lf

str lf
%

category: 'Reading'
method: PassiveObject
load: amount byteStringsInto: byteObj
  "Loads the given number of formatted byte-sized numbers into the given byte
 object."

  | nextIdx |
  file
    ifNotNil: [
      self backupExternal.
      file next: amount byteStringsInto: byteObj ]
    ifNil: [
      nextIdx := System
        userAction: #'GsfPassiveObjLoadByteStrings'
        with: byteObj
        with: amount
        with: str _collection
        with: str _fastPosition.
      nextIdx ifNotNil: [ str _fastPosition: nextIdx ] ]
%

category: 'Private'
method: PassiveObject
loadEBuf

"Load bytes into the cached input stream."

| c |

c := str _collection.
(epos ~~ nil and: [str atEnd not]) ifTrue: [
  "loading while not at the end of the cache stream - append the next line
   to the string"
  c add: file nextLine.
  ^self
].
epos := file position.
c size: 0.
c add: file nextLine.
str _fastPosition: 1.
%

category: 'Private'
method: PassiveObject
next

"Inlined checkEBuf."

(file ~~ nil and: [ epos == nil or: [str atEnd]]) ifTrue: [ self loadEBuf ].

^ str _fastNext
%

category: 'Private'
method: PassiveObject
next: n bytesTo: aString

"Stores the next n input bytes into the given string."

epos ifNotNil: [ self backupExternal ].
^ file ifNotNil: [ file next: n into: aString ]
          ifNil: [ str  nextBytes: n addTo: aString ]
%

category: 'Private'
method: PassiveObject
nextClassNumber

"Private."

| cur |

cur := nextClassNo.
nextClassNo := nextClassNo + 1.
^ cur
%

category: 'Private'
method: PassiveObject
nextPut: aCharacter

"Private."

str nextPut: aCharacter
%

category: 'Private'
method: PassiveObject
nextPutAll: aString

"Private."

str nextPutAll: aString
%

category: 'Private'
method: PassiveObject
nextPutAllBytes: aString

"Private."

str _nextPutAllBytes: aString
%

category: 'Private - Initialization'
method: PassiveObject
nextPutVersion

"Writes the version header to the receiver's stream."

self nextPut: $^ ; nextPutAll: version asString; nextPut: $^
%

category: 'Reading'
method: PassiveObject
objectPositionMarker

"Reserve a place for an object that's being read but has no ID yet.  The marker
 can be used with hasRead:marker: when the object has been created.  An example
 use is activation of ExecBlock objects, which must read a source code
 string and compile it to create the block object.  On writing the block, the
 block is assigned an object number before the string, so on reading the block
 back in this ordering must be maintained."

objects add: nil.
^ objects size
%

category: 'Accessing'
method: PassiveObject
oldClassMap

"Returns the value of the oldClassMap instance variable."

^ oldClassMap
%

category: 'Accessing'
method: PassiveObject
oldClassMap: aSymbolDictionary

"Updates the value of the oldClassMap instance variable."

oldClassMap := aSymbolDictionary
%

category: 'Private'
method: PassiveObject
passivate: anObject
self initializeForStore.
self nextPutVersion .
self hasWritten: anObject.  "assigns an identifier for the object"
anObject writeTo: self.
contents := str _collection.
System _initMap: 1"classes";  "deallocate map"
       _initMap: 2"objects".  "deallocate map"

"uncomment to debug, to check for sends of objectPositionMarker
  without matching send of  hasRead:marker: "
"1 to: objects size do:[:n | (objects at: n) == nil ifTrue:[ nil pause ]]."

classes := objects := str := nil.  "comment out if using _checkObjectAt: for debugging activate"
^ self
%

category: 'Stream I/O'
method: PassiveObject
passivate: anObject toStream: streamOrFile

"Passivates the given object, writing the description out to the given stream.
 This does not result in a state where the receiver can activate the object.

 It is intended that streamOrFile be an instance of GsFile opened
 for writing, and that a new instance of PassiveObject be used to read
 the file when re-activation is desired."

self initializeForStore.
str := streamOrFile.
self nextPutVersion .
self hasWritten: anObject.  "assigns an identifier for the object"
anObject writeTo: self.
System _initMap: 1"classes"; "deallocate map"
       _initMap: 2"objects". "deallocate map"
str isExternal ifTrue:[ str close ] .
str := nil.

"uncomment to debug, to check for sends of objectPositionMarker
  without matching send of  hasRead:marker: "
"1 to: objects size do:[:n | (objects at: n) == nil ifTrue:[ nil pause ]]."

classes := objects := str := nil. "comment out if using _checkObjectAt: for debugging activate"

^ self
%

category: 'Private'
method: PassiveObject
peek

"Inlined checkEBuf."

(file ~~ nil and: [ epos == nil or: [str atEnd]]) ifTrue: [ self loadEBuf ].
^str peek
%

category: 'Private'
method: PassiveObject
putIvName: ivname
| id s nivno |
"classes dict is overloaded - no need to keep two dictionaries"
id := System _inMap: 1"classes" at: ivname putIfAbsent: (nivno := nextIVNo)
      serialNum: mapCache .
id == nivno ifTrue: [
  classes add: ivname .
  nextIVNo := nivno + 1.
  s := String new.
  s add: $" ; addAll: ivname; add: $" .
  str nextPutAll: s.
  s size: 1; addAll: id asString; add: $".
  ivStrings add: s.
] ifFalse: [
  str nextPutAll: (ivStrings at: id)
].
%

category: 'Private'
method: PassiveObject
readClass

"Private.  Reads in a class name or ID and returns the corresponding class."

| id name class ch |

self skipWhiteSpace.
ch := self next.
ch == $? ifTrue:[
  id := self readInt.
  ^ classes at: id
].
"get the class name and see if the class exists in this image"
name := String with: ch .
name addAll: (self upTo: $( ).

(class := self resolveSymbol: name ) ifNil:[
  self _halt: 'Your GemStone repository is missing class ' , name  .

  "if application proceeded from the notification error, try
  to fetch the object again.  Exit if not found"
  class := self resolveSymbol: name.
  "class is either nil (not found) or the Association for 'name'"
  class ifNil: [exitBlock value].
  class := class value.
] ifNotNil: [
  class := class value
].
classes add: class.
^ class
%

category: 'Private'
method: PassiveObject
readInt
  "Reads an int from the input position"

  | idx coll int c neg size |
  (file ~~ nil and: [ epos == nil or: [ str atEnd ] ])
    ifTrue: [ self loadEBuf ].	"this code disrespects the privacy of the stream, but this
 method must be as fast as possible"
  idx := str _fastPosition.
  coll := str _collection.
  int := 0.
  size := coll size.
  neg := (coll at: idx) == $-.
  neg
    ifTrue: [ idx := idx + 1 ].
  idx to: size do: [ :i |
    c := (coll at: i) codePoint.
    (48 <= c and: [ c <= 57 ])
      ifTrue: [ int := int * 10 + c - 48 ]
      ifFalse: [
        "End of integer"
        idx := i.
        c == 32
          ifTrue: [ idx := idx + 1 ].
        str _fastPosition: idx.
        ^ neg
          ifTrue: [ int * -1 ]
          ifFalse: [ int ] ] ].	"End of string"
  idx := size + 1.
  str _fastPosition: idx.
  ^ neg
    ifTrue: [ int * -1 ]
    ifFalse: [ int ]
%

category: 'Private'
method: PassiveObject
readNamedIV

"Reads the next instance variable name and object and puts them into ivName and
 ivValue in the receiver.  Returns false if the next input item is not an
 instance variable name or the end-of-named-instance-variables mark, and true
 otherwise.  If a name and object are not both read, ivName and ivValue will be
 nil."

| char obj name globalName ascii int |

"Care must be taken in this method to not rely on the state of ivName
 and ivVal.  This method must be reentrant for recursive activations
 started within this method, and it must return the correct values in
 ivName/ivVal when completed"

ivName := ivVal := nil.

self skipWhiteSpace.
self atEnd ifTrue: [ ^false ].
self checkEBuf.
char := str _fastNext.
char == $/ ifTrue: [
  "end of Bag mark - precedes ivPrefix marks"
  str skip: -1.
  ^true
].

char == $"  ifFalse: [
  str skip: -1.
  ^false
].

"check for end of named instance variables"
char := str _fastNext.
char == $"  ifTrue: [
  str skip: -2.
  ^true
].

ascii := char codePoint.
(ascii <= 57 and: [48 <= ascii]) ifTrue: [ | ivSz |
  str skip: -1.
  int := self readInt.
  self next. "consume the quote char"
  int > (ivSz := ivNames size) ifTrue: [
    self _halt:
'A forward instance variable name reference has been encountered
during object activation.  Select "continue" to proceed and
skip activation of this object'.
    exitBlock value
  ].
  name := ivNames at: int.
]
ifFalse: [
  name := String with: char.
  [ str atEnd not and: [
    char := str _fastNext.  char ~~ $"  ] ] whileTrue: [
    name add: char
  ].
  ivNames add: name.
].

self skipWhiteSpace.
char := str peek.
char == $. ifTrue: [
  str next.
  ivName := name.
  ivVal := nil.
  ^true
].
char == $* ifTrue: [
  str next.
  ivName := name.
  ivVal := true.
  ^true
].
char == $~ ifTrue: [
  str next.
  ivName := name.
  ivVal := false.
  ^true
].
(char == $# and:[ version >= 500]) ifTrue: [
  str next.
  ivName := name.
  ivVal := _remoteNil .
  ^true
].

ascii := char codePoint.

((57 >= ascii and: [ascii >= 48]) or: [char == $-]) ifTrue: [
  obj := self readInt.
  obj _isSmallInteger ifFalse: [
    (version >= 500) ifTrue:[
      self hasRead: obj.  "identity of object was relevant at passivation"
    ].
  ].
  ivName := name.
  ivVal := obj.
  ^true
].

char == $: ifTrue: [ | oSz |
  "identifier of an object that's already been activated"
  str _fastNext.
  obj := self readInt.
  (oSz := objects size) >= obj ifTrue: [ obj := objects at: obj ]
  ifFalse: [
    self _halt: 'An object identifier was found in passive description
that has not yet been defined.' .
    exitBlock value
  ].
  ivName := name.
  ivVal  := obj.
  ^true
].

char == $$ ifTrue: [ "8-bit Character"
  str _fastNext.
  obj := str _fastNext.
  "chars contain their identity, so no identifier is needed"
  ivName := name.
  ivVal  := obj.
  ^true
].
(char == $! _and:[ version >= 500]) ifTrue: [ "16-bit Character"
  str _fastNext.
  obj := Character withValue:
    (( str _fastNext codePoint * 256) + str _fastNext codePoint) .
  ivName := name.
  ivVal  := obj.
  ^true
].
(char == $& _and:[ version >= 600]) ifTrue:[ "32bit character"
  str _fastNext.
  obj := 0 .
  4 timesRepeat:[ obj := (obj * 256) + str _fastNext codePoint ].
  ivName := name.
  ivVal  := Character withValue: obj .
  ^true
].
"check for a letter or a name token.  Character isLetter is "
(char == $? or: [char isLetter]) ifTrue: [
  "a class ID or name"
  obj := (self readClass loadFrom: self).
  ivName := name.
  ivVal  := obj.
  ^true
].

(char == $@ or: [char == $%]) ifFalse: [
  self _halt: 'Unknown token type encountered in passive object description.' .
  exitBlock value
].

"a global reference"
str _fastNext.
globalName := self upTo: $ .
obj := self resolveSymbol: globalName .
obj ifNotNil:[
  obj := obj value
] ifNil: [
  self _halt:
     'A passive object is being activated that refers to an object named '
     , globalName , '. ' ,
     'However, your environment does not include an object by this name.' .
  ^exitBlock value
].

"check for metaclass reference"
char == $% ifTrue: [
  obj := obj class
].

self hasRead: obj.
ivName := name.
ivVal  := obj.
^true
%

category: 'Reading'
method: PassiveObject
readObject
"Returns the next object from the stream."

| char obj ascii globalName |

self skipWhiteSpace.
self atEnd ifTrue: [
  ^nil
].
self checkEBuf.
char := str peek.

char == $. ifTrue: [
  str next.
  ^nil
].
char == $# ifTrue: [
  str next.
  ^ _remoteNil
].

char == $* ifTrue: [
  str next.
  ^true
].

char == $~ ifTrue: [
  str next.
  ^false
].

ascii := char codePoint.

((57 >= ascii and: [ascii >= 48]) or: [char == $-]) ifTrue: [
  obj := self readInt.
  obj _isSmallInteger ifFalse: [
    (version >= 500) ifTrue:[
      self hasRead: obj.  "identity of object was relevant at passivation"
    ]
  ].
  ^obj
].

char == $: ifTrue: [
  "identifier of an object that's already been activated"
  self next.
  obj := self readInt.
  (objects size >= obj) ifTrue: [ obj := objects at: obj ]
  ifFalse: [
    self _halt: 'An object identifier was found in passive description
that has not yet been defined.' .
    exitBlock value
  ].
  ^obj
].

char == $$ ifTrue: [ "8-bit Character"
  str _fastNext.
  obj := str _fastNext.
  "chars contain their identity, so no identifier is needed"
  ^obj
].
(char == $! _and:[ version >= 500]) ifTrue: [ "16-bit Character"
  str _fastNext.
  obj := Character withValue:
    (( str _fastNext codePoint * 256) + str _fastNext codePoint) .
  "chars contain their identity, so no identifier is needed"
  ^obj
].
(char == $& _and:[ version >= 600]) ifTrue:[ "32bit character"
  str _fastNext.
  obj := 0 .
  4 timesRepeat:[ obj := (obj * 256) + str _fastNext codePoint ].
  ^ Character withValue: obj
].
"check for a letter or a name token.  Character isLetter is "
(char isLetter or: [char == $?]) ifTrue: [
  "a class ID or name"
  ^ self readClass loadFrom: self .
].

(char == $@ or: [char == $%]) ifFalse: [
  self _halt:
'Unknown token type encountered in passive object description.' .
  exitBlock value
].

"a global reference"
self next.  "gobble the prefix"
globalName := self upTo: $ .
globalName := globalName asSymbol.
obj := self resolveSymbol: globalName .
obj ifNotNil: [
  obj := obj value
] ifNil: [
  self _halt:
    'A passive object is being activated that refers to an object named '
       , globalName , '. ' ,
    'However, your environment does not include an object by this name.' .
  ^exitBlock value
].

"check for metaclass reference"
char == $% ifTrue: [
  obj := obj class
].

self hasRead: obj .
^obj
%

category: 'Private'
method: PassiveObject
readSize

^self skipWhiteSpace; readInt
%

category: 'Private'
method: PassiveObject
readStreamClass

^ ReadByteStreamLegacy
%

category: 'Private'
method: PassiveObject
resolveSymbol: aString

"Private.  Returns the SymbolAssociation found by searching the appropriate
 dictionaries and symbol list, or nil if not found."

| sym assoc |
sym := Symbol _existingWithAll: aString  .
sym ifNil:[ ^ nil ].
oldClassMap ifNotNil:[
  assoc := oldClassMap associationAt: sym otherwise: nil .
  assoc ifNotNil:[ ^ assoc ].
].
^ GsSession currentSession resolveSymbol: sym
%

category: 'Private'
method: PassiveObject
skipNamedInstVars

"Read any remaining named instance variables - they are obsolete now."

| c bagMark |

bagMark := self bagMark.
self skipWhiteSpace .
[ ((c := self next) == $" ) and:[self next == $" ] ] whileFalse: [
  (c == bagMark) ifTrue: [
    str skip: 1.
    ^self
  ] ifFalse: [
    str skip: -2.
  ].
  (self readNamedIV) ifFalse: [ ^self ].
  self skipWhiteSpace.
].
%

category: 'Private'
method: PassiveObject
skipWhiteSpace

| c |
[ self atEnd ] whileFalse: [
  c := (self next) codePoint.  "read from self to make sure buffering is ok"
  (c < 33 and: [c == 32 or: [c == 10 or: [c == 9 or: [c == 13 or: [c == 12]]]]])
  ifFalse: [
    str skip: -1.
    ^self.
  ].
].
%

category: 'Private'
method: PassiveObject
space

str nextPut: $  .
%

category: 'File I/O'
method: PassiveObject
toClientTextFile: fileName

"Writes the receiver's passive description to the given text file."

self deprecated: 'PassiveObject>>toClientTextFile: deprecated in v3.x.  Use an instance of GsFile to access the file system.'.

contents ifNil: [
   ''  toClientTextFile: fileName
] ifNotNil: [
  contents toClientTextFile: fileName
]
%

category: 'File I/O'
method: PassiveObject
toServerTextFile: fileName

"Writes the receiver's passive description to the given text file."

self deprecated: 'PassiveObject>>toServerTextFile: deprecated in v3.x.  Use an instance of GsFile to access the file system.'.

contents ifNil: [
   ''  toServerTextFile: fileName
] ifNotNil: [
  contents toServerTextFile: fileName
]
%

category: 'Private'
method: PassiveObject
upTo: aChar

^str upTo: aChar
%

category: 'Private'
method: PassiveObject
upToSeparator

| c result size |

result := String new.
self checkEBuf.
size := str size.
[str atEnd or: [(c := str next) isSeparator]] whileFalse: [
  result add: c.
  c := nil
].
c ifNotNil: [
  str skip: -1
].
^result
%

category: 'Accessing'
method: PassiveObject
version

"Returns the value of the version instance variable, which represents the
 version of GemStone that wrote the passivated object(s).
 Version 5.x of GemStone 32bit has value 500.
 Gemstone/64 v2.4 has value 510 .
 Gemstone/64 v2.4.x has value 600 .
 Gemstone/64 v3.0 has value 610 . 
 Gemstone/64 v3.6 has value 620 . "

^ version
%

category: 'Private'
method: PassiveObject
writeBagMark

"Older versions of GemStone did not allow named instance variables in Bag and
 its subclasses so the passive descriptions of these objects did not include
 named instance variable sections.  These classes can now have named instance
 variables, so descriptions of their instances now have named instance variable
 sections.  The loading algorithms have difficulty in distinguishing a
 zero-length Bag from its surrounding objects without the help of a special
 token.  This method writes that token onto the output stream."

self nextPut: self bagMark
%

category: 'Private'
method: PassiveObject
writeBytes: byteObj

str isExternal ifTrue: [
  str printBytes: byteObj
]
ifFalse: [
  str nextPutAll: (System userAction: #GsfPassiveObjPrint with: byteObj)
]
%

category: 'Private'
method: PassiveObject
writeClass: aClass
"Sees if the given class has been written to str already.  If so, writes out its
 identifier and returns true.  Otherwise, writes out its name and returns
 false."
| id |
id := System _inMap: 1"classes" at: aClass putIfAbsent: nextClassNo
      serialNum: mapCache .
id == nextClassNo ifTrue: [
  "a new class"
  classes add: aClass .
  nextClassNo := nextClassNo + 1.
  str nextPutAll: aClass name; nextPut: $( .
  ^ false
] ifFalse: [
  str nextPut: $? .
  self writeInt: id .
  ^ true
]
%

category: 'Private'
method: PassiveObject
writeGlobalRef: name

str nextPut: $@; nextPutAll: name; nextPut: $ .
%

category: 'Private'
method: PassiveObject
writeInt: anInteger

"Write an Integer to the output stream."

str nextPutAll: anInteger asString; nextPut: $ .
%

category: 'Writing'
method: PassiveObject
writeNamedIvsFrom: anObject class: aClass

  | ivs nFixedIvs sym |
  ivs := aClass _instVarNames .
  nFixedIvs := aClass instSize .
  aClass firstPublicInstVar to: nFixedIvs do: [:i |
    sym := ivs at: i .
    (anObject shouldWriteInstVar: sym ) ifTrue: [
      self writeObject: (anObject instVarAt: i) named: sym .
    ].
  ].
  anObject tagSize ~~ 0 ifTrue:[ |dynIvNames |
    dynIvNames := anObject _instvarNamesAfter: nFixedIvs .
    1 to: dynIvNames size do:[:j |
      sym := dynIvNames at: j .
      (anObject shouldWriteDynamicInstVar: sym) ifTrue:[
        self writeObject: (anObject dynamicInstVarAt: sym) named: sym
      ].
    ].
  ].
%

category: 'Writing'
method: PassiveObject
writeObject: anObject
"Use this method to write components of another object to the output stream."

"true, false and nil are handled internally since they make up a large
 part of many objects.  This lets activation and passivation avoid
 checking to see if these objects have been read/written each time
 they are encountered."

anObject ifNil:[
  str nextPut: $. .
  ^nil
  ].
anObject == _remoteNil ifTrue:[
  str nextPut: $# .
  ^_remoteNil
  ].
anObject == true ifTrue: [
  str nextPut: $* .
  ^true
  ].
anObject == false ifTrue: [
  str nextPut: $~ .
  ^false
  ].

(self hasWritten: anObject) ifTrue: [^anObject].

"at this point, a query to global directories could be made, and
  a 'Global' entry could be made in the stream, instead of passivating
  'anObject'.  This could be useful in clamping off objects that have
  their own version-control lists"

(anObject isBehavior) ifTrue: [
  anObject isMeta ifTrue: [
    self nextPut: $%; nextPutAll: anObject thisClass name
  ]
  ifFalse: [
    self nextPut: $@; nextPutAll: anObject name; nextPut: $ .
  ].
]
ifFalse: [
  anObject writeTo: self
].
^anObject
%

category: 'Writing'
method: PassiveObject
writeObject: anObject named: objName

"Use this method to write components of another object to the output stream with
 instance variable names included.  When read back in, the corresponding named
 instance variable reading method must be used."

(anObject isKindOf: Collection) ifTrue: [
  str lf
].
self putIvName: objName.
^self writeObject: anObject
%

category: 'Private'
method: PassiveObject
writeSize: anInteger

"Write a size to the string"

str nextPutAll: anInteger asString; nextPut: $ .
%

category: 'Private'
method: PassiveObject
writeStreamClass

^WriteStreamLegacy
%

category: 'Private'
method: PassiveObject
_checkObjectAt: idx
(self dynamicInstVarAt:#saveObjs) ifNotNil:[:saveObjs | | saveCls cls ok |
  saveCls := (saveObjs at: idx) class .
  cls := (objects at: idx) class .
  (ok := saveCls == cls) ifFalse:[  
    cls == ExecBlock ifTrue:[ ok := saveCls _subclassOf: ExecBlock ].
  ].
  ok ifFalse:[
    self _halt:' bad object'.
  ].
].
%

category: 'Private'
method: PassiveObject
_halt: aString
 | pos line column ln |
 [ str ifNotNil:[
    pos := str position .
    line := (ln := (contents ifNil:[ str _collection]) _lineNumberFor: pos) at: 1 .
    column := ln at: 2 .
  ].
 ] on: Error do:[:ex | "ignore" ].
 ^ super _halt: aString .
%

! Class implementation for 'Pragma'

!		Class methods for 'Pragma'

category: 'finding'
classmethod: Pragma
allNamed: aSymbol from: aSubClass to: aSuperClass
	"Answer a collection of all pragmas found in methods of all classes between aSubClass and aSuperClass (inclusive) whose keyword is aSymbol."

	| stream |
	stream := WriteStream on: (Array new: 100).
	{aSubClass} , aSubClass allSuperClasses do:
			[:class |
			self withPragmasIn: class
				do: [:pragma | pragma keyword = aSymbol ifTrue: [stream nextPut: pragma]].
			aSuperClass = class ifTrue: [^stream contents]].
	^stream contents
%

category: 'finding'
classmethod: Pragma
allNamed: aSymbol from: aSubClass to: aSuperClass sortedByArgument: anInteger
	"Answer a collection of all pragmas found in methods of all classes between aSubClass and aSuperClass (inclusive) whose keyword is aSymbol, sorted according to argument anInteger."

	^ self allNamed: aSymbol from: aSubClass to: aSuperClass sortedUsing: [ :a :b | (a argumentAt: anInteger) < (b argumentAt: anInteger) ].
%

category: 'finding'
classmethod: Pragma
allNamed: aSymbol from: aSubClass to: aSuperClass sortedUsing: aSortBlock
	"Answer a collection of all pragmas found in methods of all classes between aSubClass and aSuperClass (inclusive) whose keyword is aSymbol, sorted according to aSortBlock."

	^ (self allNamed: aSymbol from: aSubClass to: aSuperClass) sortWithBlock: aSortBlock.
%

category: 'finding'
classmethod: Pragma
allNamed: aSymbol in: aClass
	"Answer a collection of all pragmas found in methods of aClass whose keyword is aSymbol."

	| stream |
	stream := WriteStream on: (Array new: 100).
	self withPragmasIn: aClass
		do: [:pragma | pragma keyword = aSymbol ifTrue: [stream nextPut: pragma]].
	^stream contents
%

category: 'finding'
classmethod: Pragma
allNamed: aSymbol in: aClass sortedByArgument: anInteger
	"Answer a collection of all pragmas found in methods of aClass whose keyword is aSymbol, sorted according to argument anInteger."

	^ self allNamed: aSymbol in: aClass sortedUsing: [ :a :b | (a argumentAt: anInteger) < (b argumentAt: anInteger) ].
%

category: 'finding'
classmethod: Pragma
allNamed: aSymbol in: aClass sortedUsing: aSortBlock
	"Answer a collection of all pragmas found in methods of aClass whose keyword is aSymbol, sorted according to aSortBlock."

	^ (self allNamed: aSymbol in: aClass) sortWithBlock: aSortBlock.
%

category: 'private'
classmethod: Pragma
keyword: aSymbol arguments: anArray
	^ self new
		setKeyword: aSymbol;
		setArguments: anArray;
		yourself.
%

category: 'private'
classmethod: Pragma
withPragmasIn: aClass do: aBlock
	(aClass methodDictForEnv: 0) keysAndValuesDo: [ :selector :method | method pragmas do: aBlock ].
%

!		Instance methods for 'Pragma'

category: 'accessing-pragma'
method: Pragma
argumentAt: anInteger
	"Answer one of the arguments of the pragma."

	^ self arguments at: anInteger.
%

category: 'accessing-pragma'
method: Pragma
arguments
	"Answer the arguments of the receiving pragma. For a pragma defined as <key1: val1 key2: val2> this will answer #(val1 val2)."

	^ arguments
%

category: 'accessing-pragma'
method: Pragma
keyword
	"Answer the keyword of the receiving pragma. For a pragma defined as <key1: val1 key2: val2> this will answer #key1:key2."

	^ keyword
%

category: 'accessing-pragma'
method: Pragma
message
	"Answer the message of the receiving pragma."

	^ Message selector: self keyword arguments: self arguments.
%

category: 'accessing-method'
method: Pragma
method
	"Answer the compiled-method containing the pragma."

	^ method
%

category: 'accessing-method'
method: Pragma
methodClass
	"Answer the class of the method containing the pragma."

	^self method inClass
%

category: 'accessing-pragma'
method: Pragma
numArgs
	"Answer the number of arguments in the pragma."

	^ self arguments size.
%

category: 'printing'
method: Pragma
printOn: aStream
	aStream nextPut: $<.
	self keyword precedence = 1
		ifTrue: [ aStream space; nextPutAll: self keyword ]
		ifFalse: [
			self keyword keywords with: self arguments do: [ :key :arg |
				aStream space; nextPutAll: key; space; print: arg ]].
	aStream space; nextPut: $>.
%

category: 'accessing-method'
method: Pragma
selector
	"Answer the selector of the method containing the pragma."

	^ method selector.
%

category: 'initialization'
method: Pragma
setArguments: anArray
	arguments := anArray
%

category: 'initialization'
method: Pragma
setKeyword: aSymbol
	keyword := aSymbol
%

category: 'initialization'
method: Pragma
setMethod: aCompiledMethod
	method := aCompiledMethod
%

category: 'testing'
method: Pragma
_refersToLiteral: aLiteral
  ^ self keyword == aLiteral or: [ self arguments _refersToLiteral: aLiteral ]
%

! Class implementation for 'Processor'

!		Class methods for 'Processor'

category: 'Accessing'
classmethod: Processor
activePriority

^ self _scheduler activePriority
%

category: 'Accessing'
classmethod: Processor
activeProcess

^ self _scheduler activeProcess
%

category: 'Accessing'
classmethod: Processor
allProcesses

^ self _scheduler allProcesses
%

category: 'Event Scheduling'
classmethod: Processor
cancelWhenReadable: aGsSocket signal: objToNotify

^ self _scheduler cancelWhenReadable: aGsSocket signal: objToNotify
%

category: 'Event Scheduling'
classmethod: Processor
cancelWhenWritable: aGsSocket signal: objToNotify

^ self _scheduler cancelWhenWritable: aGsSocket signal: objToNotify
%

category: 'Priorities'
classmethod: Processor
highestPriority

^ self _scheduler highestPriority
%

category: 'Priorities'
classmethod: Processor
highIOPriority

^ self _scheduler highIOPriority
%

category: 'Priorities'
classmethod: Processor
lowestPriority

^ self _scheduler lowestPriority
%

category: 'Priorities'
classmethod: Processor
lowIOPriority

^ self _scheduler lowIOPriority
%

category: 'Accessing'
classmethod: Processor
readyProcesses

^ self _scheduler readyProcesses
%

category: 'Accessing'
classmethod: Processor
suspendedProcesses

^ self _scheduler suspendedProcesses
%

category: 'Priorities'
classmethod: Processor
systemBackgroundPriority

^ self _scheduler systemBackgroundPriority
%

category: 'Priorities'
classmethod: Processor
timingPriority

^ self _scheduler timingPriority
%

category: 'Priorities'
classmethod: Processor
userBackgroundPriority

^ self _scheduler userBackgroundPriority
%

category: 'Priorities'
classmethod: Processor
userInterruptPriority

^ self _scheduler userInterruptPriority
%

category: 'Priorities'
classmethod: Processor
userSchedulingPriority

^ self _scheduler userSchedulingPriority
%

category: 'Accessing'
classmethod: Processor
waitingProcesses

^ self _scheduler waitingProcesses
%

category: 'Event Scheduling'
classmethod: Processor
whenReadable: aGsSocket signal: objToNotify

^ self _scheduler whenReadable: aGsSocket signal: objToNotify
%

category: 'Event Scheduling'
classmethod: Processor
whenWritable: aGsSocket signal: objToNotify

^ self _scheduler  whenWritable: aGsSocket signal: objToNotify
%

category: 'Process State Change'
classmethod: Processor
yield

^ self _scheduler yield
%

category: 'Private'
classmethod: Processor
_scheduler

"Returns   ProcessorScheduler scheduler "
<primitive: 457>

self _primitiveFailed: #_scheduler
%

! Class implementation for 'ProfMonitor'

!		Class methods for 'ProfMonitor'

category: 'Estimating'
classmethod: ProfMonitor
computeInterval: unprofiledCpuTimeSeconds
 "Returns an estimated profiling interval in nanoseconds for an execution
  taking the specified amount of cpu time, to yield
  approximately 100000 samples.  The number of samples might vary
  by +/- 30% from the target.  The profiled execution will take much
  longer to execute than the same non-profiled execution.

  The 10.0/100000 portion of this computation is an approximation.
  A more sophisticated algorithm might use a different value for
  <= 1 second cpu  than it does for 20 seconds of cpu. There might
  also be some variation in the constant needed between very slow
  and very fast cpu hardware.  As the total cpu time gets smaller,
  the overhead of profiling , plus limited resolution of the software
  clocks could require some non-linearity in the algorithm.
  A more sophisticated algorithm might calibrates itself to a specific
  real or virtualized cpu  and store calibration data in SessionTemps current .
"
 | ns |
 ns := (10.0 * unprofiledCpuTimeSeconds / 100000 / 1.0e-9 + 1) asInteger .
 ns < 1000 ifTrue:[ ns := 1000 ].
 ^ ns
%

category: 'Defaults'
classmethod: ProfMonitor
defaultIntervalNs

"Returns the number of CPU nanoseconds used for a monitoring interval if no
 interval is given.
 This value produces about 100000 samples for an unprofiled CPU time of 5 seconds."

 ^ 500000 "500 micro seconds"
%

category: 'Reporting'
classmethod: ProfMonitor
defaultReports
  ^{#samples . #stackSamples . #senders . #objCreation}
%

category: 'Quick Profiling'
classmethod: ProfMonitor
monitorBlock: aBlock

"Profile the execution of a block and return a formatted report of the results.
 An interval of 1 millisecond is used, and the results are reported down
 methods that use 3% of the total time"

^self monitorBlock: aBlock
       downTo: 0.03
       intervalNs: self defaultIntervalNs
       options: #()
%

category: 'Quick Profiling'
classmethod: ProfMonitor
monitorBlock: aBlock downTo: threshold

"Profile the execution of a block and return a formatted report of the results.
 An interval of 1 millisecond is used. The threshold argument should be
 a Float 0.01-0.99, or a SmallInteger > 1, specifying the percent of time or
 the number of hits, below which to exclude methods from the report."

 ^self monitorBlock: aBlock
       downTo: threshold
       intervalNs: self defaultIntervalNs
       options: #()
%

category: 'Quick Profiling'
classmethod: ProfMonitor
monitorBlock: aBlock downTo: threshold interval: millisecondsPerSample

"Profile the execution of a block and return a formatted report of the results.
 The millisecondsPerSample argument gives the CPU time interval between
 samples in milliseconds.  The threshold argument should be a Float 0.01-0.99,
 or a SmallInteger > 1, specifying the percent of time or the number of hits,
 below which to exclude methods from the report."

^self monitorBlock: aBlock
       downTo: threshold
       intervalNs: (millisecondsPerSample * 1000000)
       options: #()
%

category: 'Quick Profiling'
classmethod: ProfMonitor
monitorBlock: aBlock downTo: threshold intervalNs: nanosecondsPerSample

"Profile the execution of a block and return a formatted report of the results.
 The nanosecondsPerSample argument gives the CPU time interval between
 samples in nanoseconds. The threshold argument should be a Float 0.01-0.99,
 or a SmallInteger > 1, specifying the percent of time or the number of hits,
 below which to exclude methods from the report."

 ^self monitorBlock: aBlock
       downTo: threshold
       intervalNs: nanosecondsPerSample
       options: #()
%

category: 'Quick Profiling'
classmethod: ProfMonitor
monitorBlock: aBlock downTo: threshold intervalNs: nanosecondsPerSample options: anArray
 "Profile the execution of a block and return a formatted report of the results.
  threshold should be a Float in the range 0.01 to 0.99 specifying a percent of
  total time below which to exclude methods from the report, or a SmallInteger > 1
  specifying a sample count below which to exclude methods from the report.
  The nanosecondsPerSample argument gives the CPU time interval between samples.
  anArray is an Array of Strings or Symbols containing at most one of
    #objFaults #pageFaults #edenUsage #gcTime #objCreation
  and optionally
    #cpu or #real .
  #cpu or #real (if included) specifies real or cpu time sampling, otherwise the i
  default depends on the type of profiling.
    If profiling type is not specified, the default is #cpu.
    #gcTime defaults to #cpu, and is in units of milliseconds  .
    #objFaults and #pageFaults default to #real, and are in units of faults .
    #edenUsage defaults to #reali, and is in units of bytes.
    #objCreation defaults to #cpu, and produces additional reports."

  | inst result |
  inst := self basicNew initializeNoFile .
  inst setOptions: anArray .
  threshold _validateClasses: { Float . SmallInteger }.
  threshold < 0.01 ifTrue:[ ArgumentError signal:'threshold must be > 0.01' ].
  inst _createFile: self newProfileFileName;  intervalNs: nanosecondsPerSample .
  inst runBlock: aBlock.
  result := inst reportDownTo: threshold reports: self defaultReports .
  inst removeResults ; removeFile .
  ^ result
%

category: 'Quick Profiling'
classmethod: ProfMonitor
monitorBlock: aBlock downTo: threshold intervalNs: nanosecondsPerSample reports: reportArray
 "Profile the execution of a block and get a report of the result.
  threshold should be a Float in the range 0.01 to 0.99 specifying a percent of total time below
   which to exclude methods from the report, or a SmallInteger > 1 specifying a sample count below
  which to exclude methods from the report.
  The nanosecondsPerSample argument gives the CPU time interval between samples.
  anArray is an Array of Strings or Symbols.
 reportsArray can include any or all of
      #samples #stackSamples #senders #objCreation #tree #objCreationTree
  specifying which reports to include and the desired order.
  specifying an obj creation report enables object creation; specifying a tree
  report uses ProfMonitorTree."

| inst result |
inst := ((reportArray includes: #tree) or: [reportArray includes: #objCreationTree])
	ifTrue: [(Globals at: #ProfMonitorTree) basicNew initializeNoFile .]
	ifFalse: [self basicNew initializeNoFile .].

((reportArray includes:  #objCreation) or: [reportArray includes: #objCreationTree])
	ifTrue: [inst setOptions: {#objCreation} ].

  threshold _validateClasses: { Float . SmallInteger }.
  threshold < 0.01 ifTrue:[ ArgumentError signal:'threshold must be > 0.01' ].
  inst _createFile: self newProfileFileName;  intervalNs: nanosecondsPerSample .
  inst runBlock: aBlock.
  result := inst reportDownTo: threshold reports: reportArray .
  inst removeResults ; removeFile .
  ^ result
%

category: 'Quick Profiling'
classmethod: ProfMonitor
monitorBlock: aBlock intervalNs: nanosecondsPerSample

"Profile the execution of a block and return a formatted report of the results.
 The nanosecondsPerSample argument gives the CPU time interval
 between samples, and the results are reported down to methods that
 use 3% of the total time"

^ self monitorBlock: aBlock
       downTo: 0.03
       intervalNs: nanosecondsPerSample
       options: #()
%

category: 'Quick Profiling'
classmethod: ProfMonitor
monitorBlock: aBlock intervalNs: nanosecondsPerSample options: anArray
 "Profile the execution of a block and return a formatted report of the results.
  The report includes sampled items each of which is more than 3% of the total.
  The nanosecondsPerSample argument gives the CPU time interval between samples.
  anArray is an Array of Strings or Symbols containing at most one of
  #objFaults #pageFaults #edenUsage #gcTime #objCreation   and optionally
  #cpu or #real .
  For details see commnets in monitorBlock:downTo:intervalNs:options:."

^ self monitorBlock: aBlock
       downTo: 0.03
       intervalNs: nanosecondsPerSample
       options: anArray
%

category: 'Quick Profiling'
classmethod: ProfMonitor
monitorBlock: aBlock reports: reportsArray

"Profile the execution of a block and return a formatted report of
 the results. An interval of 1 millisecond is used, and the results
 are reported down to 3% of the number of hits per method.
 reportsArray can include any or all of
      #samples #stackSamples #senders #objCreation #tree #objCreationTree
  specifying which reports to include and the desired order.
  specifying an obj creation report enables object creation; specifying a tree
  report uses ProfMonitorTree."

^self monitorBlock: aBlock
       downTo: 0.03
       intervalNs: self defaultIntervalNs
       reports: reportsArray
%

category: 'Instance Creation'
classmethod: ProfMonitor
new

"Returns a new profiler with default initialization."

^ self basicNew initialize
%

category: 'Private'
classmethod: ProfMonitor
newProfileFileName

"Returns a String to be used as the name of a temporary file which will
 contain profiling data.  The file name will be gem<processId>_<randomInt>.pro,
 in the directory defined by the environment variable $GEMSTONE_CHILD_LOG,
 the current directory or /tmp if neither of the above can be created."

| result pidStr aFile env filename randInt |
pidStr := (System gemVersionAt: #processId ) printString.
filename := (String withAll: 'gem').
randInt := HostRandom new integerBetween:100000 and:999999 .
filename addAll: pidStr; add: $_ ; addAll: randInt asString; addAll: '.pro'.

env := (System gemEnvironmentVariable: 'GEMSTONE_CHILD_LOG').
env == nil
  ifTrue: [  result := String withAll: './'.]
  ifFalse: [ result := String withAll: env. result addAll: '/'].
result addAll: filename.

aFile := GsFile openWriteOnServer: result.
aFile ifNotNil:[
  aFile close .
  ^ result
  ].
result := (String withAll: '/tmp/').
result addAll: filename.
^ result
%

category: 'Instance Creation'
classmethod: ProfMonitor
newWithFile: fileName

"Creates a new profiler with the given output file name and default monitoring
 interval."

^self newWithFile: fileName intervalNs: self defaultIntervalNs
%

category: 'Instance Creation'
classmethod: ProfMonitor
newWithFile: fileName interval: millisecondsPerSample

"Creates a new profiler with the specified output file name and monitoring
 interval"

| inst |
(inst := self basicNew) initializeNoFile ;
   _createFile: fileName;
   interval: millisecondsPerSample .
^ inst
%

category: 'Instance Creation'
classmethod: ProfMonitor
newWithFile: fileName intervalNs: nanosecondsPerSample

"Creates a new profiler with the specified output file name and monitoring
 interval"

| inst |
(inst := self basicNew) initializeNoFile ;
   _createFile: fileName;
   intervalNs: nanosecondsPerSample .
^ inst
%

category: 'Profiling'
classmethod: ProfMonitor
profileOn

"Creates a default instance, starts it monitoring, and returns it.
 To turn off profiling, send the message profileOff to the instance."

| inst |

inst := self new .
inst startMonitoring.
^inst.
%

category: 'Profiling'
classmethod: ProfMonitor
runBlock: aBlock

"Profile the execution of a block and return an instance of the receiver.
 The default sample interval will result in about 25000 samples per
 second of CPU time.

 Use gatherResults followed by reporting methods to view results."

| inst |
inst := self basicNew initializeNoFile .
inst _createFile: self newProfileFileName;
             intervalNs: self defaultIntervalNs  .
inst runBlock: aBlock .
^ inst
%

category: 'Profiling'
classmethod: ProfMonitor
runBlock: aBlock intervalNs: nanosecondsPerSample

"Profile the execution of a block and return an instance of the receiver.
 The nanosecondsPerSample argument gives the CPU time interval between
 samples.

 Use gatherResults followed by reporting methods to view results."

| inst |
inst := self basicNew initializeNoFile .
inst _createFile: self newProfileFileName;  intervalNs: nanosecondsPerSample .
inst runBlock: aBlock .
^ inst
%

!		Instance methods for 'ProfMonitor'

category: 'Accessing'
method: ProfMonitor
endTime

	^endTime
%

category: 'Accessing'
method: ProfMonitor
fileName

"Returns the name of the active file."

file ifNil:[ ^ nil ].
^ file name
%

category: 'Private'
method: ProfMonitor
forChild: childEntry tallyParentMethod: aSender rcvrClass: rcvrClass in: tempDict
increment: anInteger

"Private."

| children parentEntry d childTallies cTally parentTallies |
(aSender class == GsNMethod) ifFalse:[
  "ignore methods that were garbage collected and reused."
  ^ nil
  ].

"Add parent to child"
(d := tempDict at: aSender otherwise: nil ) ifNil:[
	d := IdentityKeyValueDictionary new.
	tempDict at: aSender put: d ].

(parentEntry := d at: rcvrClass otherwise: nil) ifNil:[
  parentEntry := ProfMonitorEntry newForMethod: aSender
                    receiverClass: rcvrClass.
  parentEntry total: anInteger .
  d at: rcvrClass put: parentEntry
] ifNotNil:[
  parentEntry incrementTotal: anInteger .
].

childTallies := parentEntry childTallies.
cTally := childTallies at: childEntry otherwise: 0.
childTallies at: childEntry put: (cTally + 1).

childEntry parents add: parentEntry.

"Add child to parent"
(children := parentEntry children ) ifNil:[
  children := IdentitySet new .
  parentEntry children: children .
].
children add: childEntry.

parentTallies := childEntry parentTallies.
cTally := parentTallies at: parentEntry otherwise: 0.
parentTallies at: parentEntry put: (cTally + 1).

^parentEntry
%

category: 'Reporting'
method: ProfMonitor
gatherResults
"If the receiver's file of sampling data has not been read, read it into memory,
 analyze the samples and store the results of analysis in the
 results instance variable of the receiver.
 After gatherResults has run, this instances' sample file is no longer needed
 and can be deleted with  ProfMonitor>>removeFile .

 For 100000 samples, GEM_TEMPOBJ_CACHE_SIZE should
 be set to at least 300MB to avoid AlmostOutOfMemory errors ."

  | resultSet mthDict objDict rawArray j sysRepos rawArraySiz totalSamples elapsedTime
    statBlock tlyInfo fileData statStr |

  "Now process the statistical sample file."
  results ifNotNil:[ ^ self "sample file was already read" ].

  mthDict := IdentityKeyValueDictionary new .
  objDict := KeyValueDictionary new .
  fileData := self _readSampleFile .
  fileData ifNil:[ ^ 'No profiling data available: check profiling parameters' ].

  rawArray := fileData at: 1 .
  rawArraySiz := rawArray size .
  rawArraySiz == 0 ifTrue:[
    results := nil .
    ^ self .
  ].
  sysRepos := SystemRepository .
  j := 1 .
  tlyInfo := self _tallyInfo .
  statBlock := tlyInfo at: 2 .
  self dynamicInstVarAt:#tallyName put: (tlyInfo at: 1).

  [j < rawArraySiz ] whileTrue:[
    | sample recursionSet aMethod rcvrClass depth statsWord sTly |
    sample := rawArray at: j .
    sample == sysRepos
      ifFalse: [ Error signal: 'valid sample file: bad frame header' ]
      ifTrue:[   "sample header"
        j := j + 1 .
        (sample := rawArray at: j) _isSmallInteger
           ifTrue:[ depth := sample.  j := j + 1 ]
           ifFalse:[ Error signal:'invalid sample file: invalid depth' ].
        (sample := rawArray at: j) _isSmallInteger
           ifTrue:[ statsWord := sample. j := j + 1 ]
           ifFalse:[ Error signal:'invalid sample file: invalid statsWord'].
        sTly := statBlock ifNil:[ 1 ] ifNotNil:[ statBlock value: statsWord ]
      ].
    recursionSet := IdentitySet new.
    aMethod := rawArray at: j .
    aMethod == true ifTrue:[ "an object creation sample"
      | newObjClass aSender rcvr key d d2 anEntry child |
      newObjClass := rawArray at: j + 1 .
      j := j + 2.
      aSender := rawArray at: j.
      rcvr := rawArray at: j + 1.
      rcvr := Object. "suppress polymorphism reporting, TODO add enable/disable"
      key := (Array with: newObjClass with: aSender).
      (d := objDict at: key otherwise: nil) ifNil: [
        d := KeyValueDictionary new.
        objDict at: key put: d. ].
      (d2 := d at: aSender otherwise: nil) ifNil: [
        d2 := IdentityKeyValueDictionary new.
        d at: aSender put: d2 ].

      (anEntry := d2 at: rcvr otherwise: nil) ifNil: [
        anEntry := ProfMonitorEntry newForClass: newObjClass
                        method: aSender receiverClass: rcvr.
        d2 at: rcvr put: anEntry ].
       anEntry incrementTally: 1 .
      "Now scan through call stack"
      child := anEntry.
      recursionSet add: child.
      1 to: depth-1 do: [:m |
        child ifNotNil: [
          aSender := rawArray at: j + (m * 2).
          rcvr := rawArray at: j + (m * 2) + 1.
          aSender ifNotNil: [ rcvr ifNotNil:[
            rcvr := Object .  "supress polymorphism reporting,"
                              "TODO add enable/disable "
            child := self forChild: child
                          tallyParentMethod: aSender
                          rcvrClass: rcvr
                          in: d increment: 1 .
            (recursionSet includes: child) ifTrue: [
              child recursed: true].
            recursionSet add: child ]]]]
    ] ifFalse:[ "statistical method execution sample"
     sTly > 0 ifTrue: [
      rcvrClass := rawArray at: j + 1.
      ((aMethod class == GsNMethod or:[ aMethod == #GCI ])
         and:[ rcvrClass isBehavior]) ifTrue:[
        | d anEntry |
        "method still exists or is a reenter marker"
        (d := mthDict at: aMethod otherwise: nil) ifNil: [
          d := IdentityKeyValueDictionary new.
          mthDict at: aMethod put: d. ].
        rcvrClass := Object .  "supress polymorphism reporting,"
                               "TODO add enable/disable "
        (anEntry := d at: rcvrClass otherwise: nil) ifNil:[
          anEntry := ProfMonitorEntry newForMethod: aMethod
                        receiverClass: rcvrClass.
          d at: rcvrClass put: anEntry ].
        anEntry incrementTally: sTly  .
        depth > 1 ifTrue:[ | child rcvr |
          child := anEntry.
          recursionSet add: child.
          0 to: depth-2 do: [:m |
            child ifNotNil: [ | aSender |
              aSender := rawArray at: j + (m * 2) + 2.
              aSender ifNotNil: [
              rcvr := rawArray at: j + (m * 2) + 3.
              rcvr ifNotNil: [
                rcvr := Object .  "supress polymorphism reporting,"
                                  "TODO add enable/disable "
                child := self forChild: child
                              tallyParentMethod: aSender
                              rcvrClass: rcvr
                              in: mthDict increment: sTly  .
                (recursionSet includes: child) ifTrue: [
                  child recursed: true].
                recursionSet add: child. ]]]]]]]].
    j := j + (depth * 2).
  ].

  (endTime >= startTime) ifTrue: [
    elapsedTime := endTime - startTime.
  ] ifFalse: [
    elapsedTime := endTime + (16rffffffff - startTime).
  ].

  "Consolidate results"
  resultSet := IdentityBag new.
  totalSamples := 0.
  mthDict valuesDo: [:d |
    d valuesDo: [ :anEntry |
      resultSet add: anEntry .
      anEntry cmethod class == GsNMethod ifTrue:[
        totalSamples := totalSamples + anEntry tally ]]].

  (statStr := String new) add: (fileData at: 5) asString ; add:' pageFaults  ';
    add: ((fileData at: 3"reads") + (fileData at: 4"wrts")) asString; add: ' objFaults  ';
    add: (fileData at: 2) asString; add:' gcMs  ' ;
    add: (fileData at: 6) asString; add:' edenBytesUsed' .
  results := { resultSet . objDict . totalSamples . statStr } .
%

category: 'Private'
method: ProfMonitor
initialize

"Private."

self initializeNoFile .
self _createFile: self class newProfileFileName .
file close .
%

category: 'Private'
method: ProfMonitor
initializeNoFile

"Private."

interval := self class defaultIntervalNs .
sampleDepth := 1000.
traceObjCreation := 0 . "object creation trace disabled, cpu time sampling"
%

category: 'Accessing'
method: ProfMonitor
interval

	^interval
%

category: 'Updating'
method: ProfMonitor
interval: milliseconds

"Assign the sampling interval of the receiver."

| ns |
milliseconds _isSmallInteger ifFalse:[ ns _validateClass: SmallInteger ].
ns := milliseconds * 1000000 .
self intervalNs: ns .
%

category: 'Updating'
method: ProfMonitor
intervalNs: nanoseconds
  "Assign the sampling interval of the receiver.
   See also class method  computeInterval:  .
  "

nanoseconds _isSmallInteger ifFalse:[ nanoseconds _validateClass: SmallInteger ].
((nanoseconds < 1000) and: [nanoseconds ~~ 0]) ifTrue:[
  OutOfRange new name:'' min: 1000 actual: nanoseconds;
   details: 'invalid sampling interval(nanoseconds)'; signal.
].
interval := nanoseconds
%

category: 'Monitoring'
method: ProfMonitor
monitorBlock: aBlock

"This method starts profiling, executes the block, and terminates profiling,
 and reads the sample file into memory .
 Use reportDownTo: to generate results"

self runBlock: aBlock .
self gatherResults ; removeFile .
%

category: 'Sampling'
method: ProfMonitor
numberOfSamples
  "Returns a SmallInteger, the number of stack samples actually taken during
   the profiled execution.  The result is zero until stopMonitoring
   has been sent at least once."
  ^ numSamples ifNil:[ 0 ]
%

category: 'Private'
method: ProfMonitor
prepareForReportWithThreshold: thresholdArg
  "Reporting uses some dynamic instance variables for the thresholds, time, and totals"

  | total  |
  results ifNil:[ self gatherResults; removeFile  ].
  results ifNil:[ ^self].

  total := 0.
  (results at: 1) do: [:each |
    each cmethod class == GsNMethod ifTrue:[
      total := total + each tally ]].
  self dynamicInstVarAt: #totalTallies put: total.
  self dynamicInstVarAt: #reportThreshold put: (thresholdArg < 1.0
	ifTrue:[ (thresholdArg * total) asInteger ]
	ifFalse:[ thresholdArg asInteger ]).

  self dynamicInstVarAt: #elapsedTime put: ((endTime >= startTime)
	ifTrue: [endTime - startTime]
	ifFalse: [endTime + (16rffffffff - startTime)]).
%

category: 'Monitoring'
method: ProfMonitor
profileOff
 |rpt |
"Stop the given monitor and report."

self stopMonitoring; gatherResults; removeFile.
rpt := self reportDownTo: 0.03 .
^ rpt
%

category: 'Updating'
method: ProfMonitor
removeFile

"Removes the file generated by profiling operations in this profile monitor,
 if the file still exists."

| f fileName |
(f := file) ifNotNil:[
  fileName := file pathName .
  f close .
  GsFile removeServerFile: fileName .
  file := nil .
].
%

category: 'Updating'
method: ProfMonitor
removeResults

"Releases results to aid garbage collection."

results ifNotNil:[
  results := nil .
  ].
%

category: 'Reporting'
method: ProfMonitor
report

"Formats and returns a string holding a report of the receiver's most
 recent profile run."

 ^ self reportDownTo: 0.03.
%

category: 'Reporting'
method: ProfMonitor
reportAfterRun

"Formats and returns a string holding a report of the receiver's most
 recent profile run."
 | res |
 self gatherResults ; removeFile .
 res := self reportDownTo: 0.03.
 self removeResults .
 ^ res
%

category: 'Reporting'
method: ProfMonitor
reportAfterRunDownTo: tallyThreshold

"Formats and returns a string holding a report of the receiver's most
 recent profile run."
 | res |
 self gatherResults ; removeFile .
 res := self reportDownTo: tallyThreshold.
 self removeResults .
 ^ res
%

category: 'Reporting'
method: ProfMonitor
reportDownTo: thresholdArg

"Formats and returns a string holding a report of the receiver's most recent
 profile run.  Stops reporting when a tally smaller than tally is
 encountered. "

 ^self reportDownTo: thresholdArg reports: self class defaultReports
%

category: 'Reporting'
method: ProfMonitor
reportDownTo: thresholdArg reports: arrayOfReports

"Formats and returns a string holding a report of the receiver's most recent
 profile run.  Stops reporting when a tally smaller than tally is encountered.

 thresholdArg should be a SmallInteger or a Float > 0 .
 A thresholdArg < 1.0 is interpreted as a percentage of the total
 samples, otherwise thresholdArg is intepreted as an absolute value.
 Report elements whose sample count is less than the threshold are
 omitted from the report."

  | saveFpe |
  results ifNil:[ self gatherResults ; removeFile ].
  results ifNil:[ ^ 'No profiling data available: check profiling parameters.'].
  ^ [ |rpt|
      saveFpe := FloatingPointError enabledExceptions .
      FloatingPointError enableExceptions: nil .
      self prepareForReportWithThreshold: thresholdArg.
      rpt := String new .
      (self dynamicInstVarAt: #overrunStr) ifNotNil:[:str | rpt add: str ; lf].

      arrayOfReports do: [:sym |
        sym == #samples ifTrue: [
	   rpt addAll: (self _samplingReport); lf; lf ].
        sym == #stackSamples ifTrue: [
	   rpt addAll: (self _stackReport); lf; lf ].
        (sym == #senders and: [(self dynamicInstVarAt: #totalTallies) > 0])  ifTrue: [
	   rpt addAll: (self _sendersReport); lf; lf ].
        (sym == #objCreation and: [ (traceObjCreation bitAnd: 1) ~~ 0 and:
	  [(self dynamicInstVarAt: #totalTallies) > 0]]) ifTrue: [
	   rpt addAll: (self _objCreationReport); lf; lf.].
      ].
      rpt
    ] ensure:[
      saveFpe size > 0 ifTrue:[ FloatingPointError enableExceptions: saveFpe].
    ]
%

category: 'Accessing'
method: ProfMonitor
results

"Returns the value of the instance variable results."

^results
%

category: 'Updating'
method: ProfMonitor
results: newValue

 "Modify the value of the instance variable results."

results:= newValue
%

category: 'Monitoring'
method: ProfMonitor
resumeSampling
  "if high resolution sampling in use, resumes sampling."
interval >= 10000000 ifTrue:[
  Error signal:'resume only supported with high resolution sampling'
].
self _zeroArgPrim: 5
%

category: 'Monitoring'
method: ProfMonitor
runBlock: aBlock

"Starts profiling, executes the block, and terminates profiling.
 Does not read the sample file.
 Use gatherResults followed by reporting methods to view results."

[ self startMonitoring.
  aBlock value.
] ensure:[
  self stopMonitoring .
].
%

category: 'Accessing'
method: ProfMonitor
sampleDepth

        ^sampleDepth
%

category: 'Updating'
method: ProfMonitor
sampleDepth: newValue

"Modify the value of the instance variable sampleDepth. Should be
 at least 20; small values will prune method call stacks and object
 creation stacks."

sampleDepth := newValue
%

category: 'Accessing'
method: ProfMonitor
sampling
  "Returns the type of sampling in use,  #real or #cpu ."

  ^ (traceObjCreation bitAnd: 2) == 0 ifTrue:[ #cpu ] ifFalse:[ #real ]
%

category: 'Updating'
method: ProfMonitor
setOptions: anArray
 "By default ProfMonitor analyzes execution time using cpu time .
  Alternatively, one of the following kinds of profiling can be selected.
      #objFaults #pageFaults #edenUsage #gcTime #objCreation .

  anArray is an Array of Strings or Symbols containing
    at most one of #objFaults #pageFaults #edenUsage #gcTime #objCreation .
  and optionally  #cpu or #real .

  The last #cpu or #real if any specifies real or cpu time sampling.
  #gcTime implies default #cpu  and is in units of milliseconds  .
  #objFaults and #pageFaults are in units of faults and imply default #real .
  #edenUsage  is in units of bytes and implies default #real .
  #objCreation implies default #cpu .
  "
  | sKind cnt mask defKind |
  cnt := 0 .
  mask := 0 .
  anArray do:[:x | | sym |
    sym := Symbol _existingWithAll: x .
    sym == #real ifTrue:[ sKind := #real ] ifFalse:[
    sym == #cpu ifTrue:[ sKind := #cpu ] ifFalse:[
    sym == #objFaults ifTrue:[ defKind := #real . mask := 16r4 . cnt := cnt + 1 ] ifFalse:[
    sym == #pageFaults ifTrue:[ defKind := #real . mask := 16r8 . cnt := cnt + 1 ] ifFalse:[
    sym == #edenUsage ifTrue:[ defKind := #real . mask := 16r10 . cnt := cnt + 1 ] ifFalse:[
    sym == #gcTime ifTrue:[ defKind := #cpu . mask := 16r20 . cnt := cnt + 1 ] ifFalse:[
    sym == #objCreation ifTrue:[ defKind := #cpu . mask := 16r1 . cnt := cnt + 1 ] ifFalse:[
      Error signal: 'unrecognized option ', x asString
    ]]]]]]].
  ].
  cnt > 1 ifTrue:[ Error signal:'too many options given' ].
  sKind ifNil:[ sKind := defKind ifNil:[ #cpu ]].
  sKind == #real ifTrue:[
    (System gemVersionAt: #osName) = 'Darwin' ifTrue:[ "clock_gettime not avail"
      Error signal:'Only #cpu profiling is supported on Darwin OS'.
    ].
    mask := mask bitOr: 16r2
  ].
  traceObjCreation := mask .
%

category: 'Monitoring'
method: ProfMonitor
startMonitoring

"Starts monitoring."
results ifNotNil:[ results := nil "force re-read of sample file"].
self _openFileAppend .
self _zeroArgPrim: 1 .  "enable and start monitoring in the virtual machine"
%

category: 'Accessing'
method: ProfMonitor
startTime

	^startTime
%

category: 'Monitoring'
method: ProfMonitor
stopMonitoring

"Stops monitoring. stores total number of samples written to file
  in the numSamples instVar."
| cnt delta |
cnt := self _zeroArgPrim: 2  . "stop monitoring in the virtual machine"
(delta := endTime - startTime) <= 1 ifTrue:[  "fix 41260"
  (OutOfRange new )
     name: 'CPU time used' min: 2 actual: delta ;
     details: 'code to be profiled must use more than 1ms of CPU or real time' ;
	 signal
].
numSamples ifNil:[ numSamples := 0 ].
numSamples := numSamples + cnt  .
self dynamicInstVarAt: #overrunStr put: (self _zeroArgPrim: 6).
file close .
%

category: 'Monitoring'
method: ProfMonitor
suspendSampling
  "if high resolution sampling in use, suspends sampling."
interval >= 10000000 ifTrue:[
  Error signal:'suspend only supported with high resolution sampling'
].
self _zeroArgPrim: 4
%

category: 'Updating'
method: ProfMonitor
traceObjectCreation: aBoolean

"Enable (aBoolean == true) or disable profiling of object creation.  The state
 change will take effect on the next invocation of ProfMonitor>>startMonitoring
 for the receiver."

aBoolean _validateClass: Boolean .
aBoolean ifTrue:[ traceObjCreation := traceObjCreation bitOr: 1 ]
         ifFalse:[ traceObjCreation := traceObjCreation bitAnd: 1 bitInvert ].
sampleDepth < 2 ifTrue:[ sampleDepth := 2 ].
%

category: 'Private'
method: ProfMonitor
_createFile: fileName

"Creates the sampling file for writing with the specified file name."
| f |
(f := file) ifNotNil:[
  f isOpen ifTrue:[ f close ].
  file := nil .
].
f := GsFile open: fileName mode: 'wb+' onClient: false .
f ifNil:[
  Error signal: 'Error creating profiling data file ', fileName, ', ', GsFile serverErrorString .
].
file := f .
%

category: 'Private'
method: ProfMonitor
_intervalHeaderString

| res divisor units tmp |
res := 'monitoring interval:  ' copy.
interval < 1000 ifTrue:[ "currently illegal argument"
  res addAll: interval asString ; addAll: ' ns'.  ^ res  ].

interval >= 1000000
  ifTrue: [divisor := 1000000 . units := ' ms']
  ifFalse: [divisor := 1000 . units := ' us' ].

res addAll: (interval // divisor ) asString.
tmp := (interval \\ divisor ).
tmp > 0 ifTrue:
   [res add: $. ; addAll: (interval \\ divisor ) asString].
res addAll: units .
res add: ' ,  ' ; add: self numberOfSamples asString ; add: ' samples' .
^ res
%

category: 'Private'
method: ProfMonitor
_objCreationReport

  | classes minTally tallySet rpt nonrep nonreptallies meths counts |

  minTally := self dynamicInstVarAt: #reportThreshold.
  rpt := String new .
  rpt add:'================'; lf ;
      add:'OBJECT CREATION REPORT'; lf;
      addAll: ' tally  class of created object'; lf.
  (sampleDepth > 1)
    ifTrue: [ rpt addAll: '           call stack'; lf ]
    ifFalse: [ rpt addAll: '           callers'; lf ].

  nonrep := 0.  "non reported classes (below threshold)"
  nonreptallies := 0.

  counts := IdentityKeyValueDictionary new.
  (results at: 2) keysAndValuesDo: [:k :d | | cls tally |
    cls := k at: 1.
    tally := (counts at: cls ifAbsent: [ counts at: cls put: 0 ]).
    d valuesDo: [:d2 |
      d2 valuesDo: [:e |
        e cclass == nil  ifFalse: [ tally := tally + (e tally) ]]].
    counts at: cls put: tally ].
  classes := Array new.
  counts keysAndValuesDo: [:k :v | classes add: (Array with: k with: v)].
  classes := classes asSortedCollection: [:x :y | (x at: 2) > (y at: 2)].
  classes := classes collect: [:x | x at: 1].

  classes do: [:class |

    (counts at: class) < minTally ifTrue: [
      nonrep := nonrep + 1.
      nonreptallies := nonreptallies + (counts at: class).
      ]
    ifFalse:[
      rpt
        addAll: '------  -----------------------------------------'; lf.
	  rpt lf ;
	    addAll: ((counts at: class) asString width: -6); addAll: '  ' ;
	    addAll: (class name asString width: 12) ; lf.

    tallySet := IdentitySet new.
    (results at: 2) keysAndValuesDo: [:k :d |
      ((k at: 1) = class) ifTrue: [ | sender |
        sender := (k at: 2).
        d valuesDo: [:d2 |
          d2 valuesDo: [:e |
               e cclass == nil  ifFalse: [
                 tallySet add: e]]]]].

    meths := tallySet sortDescending: 'tally'.
    meths do: [:each | | aMeth |
      aMeth := each cmethod .
      (aMeth _class == GsNMethod _or:[ aMeth == #GCI ]) ifTrue:[

        | aClass |
        aClass := aMeth .
        (sampleDepth > 1) ifTrue: [
          rpt addAll: ' - - -  - - - - - - - - - - - - - - - - - - - - -'; lf ].
        rpt add: '         ';
            add: (each tally asString width: -6);
            add: '  ';
            add: (each asStringWidth: 12) ; lf.
        self _objCreationReportScanParents: each level: 0
             to: rpt seen: Set new ]]]].

  nonrep > 0 ifTrue: [
    rpt lf; lf;
        addAll: '------  -----------------------------------------'; lf;
        addAll: (nonreptallies asString width: -6); addAll: '  ' ;
        addAll: 'Instances of ' ;
        addAll: nonrep asString ;
        addAll: ' other classes'; lf
  ].

  ^rpt
%

category: 'Private'
method: ProfMonitor
_objCreationReportScanParents: entry level: level to: rpt seen: visited

  "Scan the parents of a given entry, printing them out indented
   according to how deep in the scan we are.  Stop when we hit an
   entry we've already visited. "

  | parents tallies lf |

  lf := Character lf.
  (parents := entry parents) ifNotNil: [
    tallies := entry parentTallies.
    parents := (parents sortDescending: 'tally') asArray.
    parents do: [:parent | |  visit |
      visit := Array with: parent with: entry.
      (visited includes: visit)
      ifFalse: [
        rpt add: '             '.
        level timesRepeat: [ rpt add: '  ' ].
        rpt
          add: ((parent childTallies at: entry otherwise: -1)
               asString width: -4);
          add: '  ';
          add: (parent asStringWidth: 12) ; lf.
          visited add: visit.
               self _objCreationReportScanParents: parent
                   level: (level + 1) to: rpt seen: visited ]]].
%

category: 'Private'
method: ProfMonitor
_openFileAppend

"Reopens the sampling file for writing."

| f |
(f := file ) ifNil:[ Error signal: 'cannot append to nil file'].
f isOpen ifFalse:[ | fileName |
  fileName := f pathName .
  f := GsFile open: fileName mode: 'ab+' onClient: false .
  f ifNil:[
    Error signal: 'Error opening for append profiling data file ', fileName, ', ', GsFile serverErrorString .
  ].
  file := f
].
%

category: 'Private'
method: ProfMonitor
_openFileRead

"Reopens the sampling file for reading."

| f fileName |
(f := file ) ifNil:[ Error signal: 'Profiling result file is nil'].
"ignore any lost transient state on the file."
([ f isOpen ] on: Error do:[:ex | ex return: false]) ifTrue:[
  f seekFromBeginning: 0 .
] ifFalse:[
  fileName := f pathName .
  f := GsFile open: fileName mode: 'rb' onClient: false .
  f ifNil:[
    Error signal: 'Error opening profiling data file ', fileName, ', ', GsFile serverErrorString .
  ].
  file := f
].
%

category: 'Private'
method: ProfMonitor
_readSampleFile

"Returns the raw sample data generated by the monitoring code, for use
 by the output routines.

 result is an Array of the form
    { sampleArray . gcTime . objReads . objWrites . pageFaults . edenBytesUsed }

 sampleArray has the following format:
           aSmallInteger - depth of sampling for next section of Array,
           aSmallInteger - stats sample word
 optional: nil
 optional: aClass
           aGsNMethod 1
           aClass     1
           aGsNMethod 2
           aClass     2
           ...
           aGsNMethod N
           aClass     N

 where N = depth as specified by the initial aSmallInteger.

 The (aGsNMethod, aClass) pairs represent stack frames.
 The optional (nil, aClass) pair at the beginning indicate the sample
 was taken during the creation of an instance of the designated class.
"

| arr |
self _openFileRead.
arr := self _zeroArgPrim: 3.
file close .
(arr at: 1) ifNil:[ ^ nil ].
^ arr
%

category: 'Private'
method: ProfMonitor
_reportHeader: nameStr
  | rpt |
  rpt := String new.
  rpt add:'================'; lf ; add: nameStr; lf ;
       add: self _timeHeaderString; lf;
	 add: self _intervalHeaderString; lf;
	 add: self _reportThresholdHeaderString; lf.
  ^rpt
%

category: 'Private'
method: ProfMonitor
_reportThresholdHeaderString

  | pct rpt |
  rpt := String new.
  rpt add: 'report limit threshold: '.
  ((self dynamicInstVarAt: #reportThreshold) = 0 or: [(self dynamicInstVarAt: #totalTallies) = 0])
	ifTrue: [rpt add: ' 0 hits'.  ^rpt].
  pct := (((self dynamicInstVarAt: #reportThreshold) / (self dynamicInstVarAt: #totalTallies)) * 100.0) asStringUsingFormat: #(1 1 false).
  rpt
      add: (self dynamicInstVarAt: #reportThreshold) asString;
	add: ' hits / ';
	add: pct;
	add: '%'.
  ^rpt
%

category: 'Private'
method: ProfMonitor
_samplingReport

  | rpt lf nonrep nonrepTallies total ave pct meths tallySet nameStr
    thresh tlyName |

  thresh := self dynamicInstVarAt: #reportThreshold.
  total := self dynamicInstVarAt: #totalTallies.

  tallySet := results at: 1 .
  rpt := String new .
  nameStr := 'STATISTICAL SAMPLING RESULTS' .
  lf := Character lf.
  meths := tallySet sortDescending: 'tally'.

  rpt add: (self _reportHeader: nameStr).
  rpt add: (results at: 4"statsSummary"); lf .

  rpt lf;
    add:   (tlyName := self dynamicInstVarAt:#tallyName) ;
    addAll:          '    %   class and method name'; lf;

    addAll: '------   -----   --------------------------------------'; lf.

  total = 0 ifTrue:[
    rpt add: 'total '; add: tlyName; add:' is zero '; lf.
    ^ rpt
  ].

  nonrep := 0.  "non reported methods (below tally threshold.)"
  nonrepTallies := 0.
  meths do: [:each |
    each cmethod class == GsNMethod ifTrue:[ | tly |
      (tly := each tally) < thresh ifTrue: [
	nonrep := nonrep + 1.
	nonrepTallies := nonrepTallies + tly ]
      ifFalse: [
	pct := tly asFloat * 100.0 / total.
	rpt add: (tly  asString width: -6); addAll: '  ' ;
	    add: (pct asStringUsingFormat: #(-6 2 false)); addAll: '   ';
	    add: (each asStringWidth: 25) ; lf ]]].

  nonrep > 0 ifTrue: [
    pct := nonrepTallies asFloat * 100.0 / total.
    rpt addAll: (nonrepTallies asString width: -6); addAll: '  ' ;
        addAll: (pct asStringUsingFormat: #(-6 2 false)); addAll: '   ';
        addAll: nonrep asString ; addAll: ' other methods'; lf ].

  ave := total // (meths size max: 1).
  rpt addAll: (total asString width: -6); addAll: '  100.00   ';
    addAll: 'Total'; lf.
  ^rpt
%

category: 'Private'
method: ProfMonitor
_sendersReport
"Report formatting is:

  %     %                       Parent
 self total   total local  Method
 Time  Time    secs   %         Child

"

  | tallyThreshold tallySet nameStr rpt meths elapsedTime totalSamples methodMs pMap cMap |

  elapsedTime := self dynamicInstVarAt: #elapsedTime.
  tallyThreshold := self dynamicInstVarAt: #reportThreshold.
  tallySet := results at: 1 .
  nameStr := 'STATISTICAL METHOD SENDERS RESULTS' .
  rpt := String new .
  meths := tallySet sortDescending: 'total'.
  rpt add: (self _reportHeader: nameStr).

  totalSamples := results at: 3 .

  rpt lf;
    addAll: '     %       %                     Parent'; lf;
    addAll: '  self  total   total  local  Method'; lf;
    addAll: '  Time   Time      ms    %         Child'; lf;
    addAll: '------ ------  ------  -----  -----------'; lf.
  meths do: [:each | | aMeth |
    aMeth := each cmethod .
    (aMeth class == GsNMethod or:[ aMeth == #GCI ]) ifTrue:[
      each total < tallyThreshold ifFalse:[ | parents children |
        rpt lf .
        methodMs := each total * elapsedTime asFloat / totalSamples.
        pMap := each parentTallies.
        cMap := each childTallies.
        "PARENTS"
        (parents := each parents) ifNotNil: [
          parents do: [:parent | | pt |
            pt := pMap at: parent otherwise: 0.
            rpt
              add: '                 ';
              add: ((pt * elapsedTime asFloat / totalSamples)
                   asStringUsingFormat: #(-6 1 false)); space;
              add: ((pt * elapsedTime *100.0 / totalSamples / methodMs)
                   asStringUsingFormat: #(-6 1 false)); space; space;
              add: '     ';
              add: (parent asStringWidth: 12) ; lf ]].
        "SELF"
        rpt add:'= ' ;
          add: ((each tally * 100.0 / totalSamples)
               asStringUsingFormat: #(-6 1 false)); space;
          add: ((each total * 100.0  / totalSamples)
               asStringUsingFormat: #(-6 1 false)); space; space;
          add: (methodMs asStringUsingFormat: #(-6 1 false)); space;
          add: ((each tally * elapsedTime *100.0 / totalSamples / methodMs)
               asStringUsingFormat: #(-6 1 false)); space; space;
          add: (each asStringWidth: 12 );
          add: '   [oop ' , aMeth asOop asString ; add: $] ; lf .
        "CHILDREN"
        (children := each children) ~~ nil  ifTrue: [
          children do: [:child | | ct |
            ct := cMap at: child otherwise: 0.
            rpt
              add: '                 ';
              add: ((ct * elapsedTime asFloat / totalSamples)
                   asStringUsingFormat: #(-6 1 false)); space;
              add: ((ct * elapsedTime * 100.0 / totalSamples / methodMs)
                   asStringUsingFormat: #(-6 1 false)); space; space;
              add: '     ';
              add: (child asStringWidth: 12) ; lf ]].
        rpt addAll: '-----------------------------------------------------';
            lf ]]].
  ^rpt
%

category: 'Private'
method: ProfMonitor
_stackReport

  | rpt nonrep nonreptallies ave pct meths tallySet nameStr
    tlyName tallyThreshold total |

  tallyThreshold := self dynamicInstVarAt: #reportThreshold.
  total := self dynamicInstVarAt: #totalTallies.

  tallySet := results at: 1 .
  nameStr := 'STATISTICAL STACK SAMPLING RESULTS' .
  rpt := String new .

  meths := tallySet sortDescending: 'total'.

  rpt add: (self _reportHeader: nameStr).
  rpt add: (results at: 4"statsSummary"); lf .
  ((tlyName := self dynamicInstVarAt:#tallyName ) at: 1 equals:'tally') ifFalse:[
     rpt add: 'tallying:  ' ; add: tlyName ; lf .
  ].
  rpt lf;
    addAll: ' total       %   class and method name'; lf;
    addAll: '------   -----   --------------------------------------'; lf.
  total = 0 ifTrue:[
    rpt add: 'total '; add: tlyName; add:' is zero '; lf.
    ^ rpt
  ].
  nonrep := 0.  "non reported methods (below tally threshold."
  nonreptallies := 0.
  meths do: [:each | | aTotal |
    each cmethod class == GsNMethod ifTrue:[
      (aTotal := each total) < tallyThreshold ifTrue: [
	      nonrep := nonrep + 1.
	      nonreptallies := nonreptallies + each tally.
      ] ifFalse: [
	      pct := aTotal asFloat * 100.0 / total.
	      rpt add: (aTotal asString width: -6); addAll: '  ' ;
				add: (pct asStringUsingFormat: #(-6 2 false)); addAll: '   ';
			  add: (each asStringWidth: 25);  lf .
      ].
    ].
  ].

  nonrep > 0 ifTrue: [
    pct := nonreptallies asFloat * 100.0 / total.
    rpt addAll: (nonreptallies asString width: -6); addAll: '  ' ;
        addAll: (pct asStringUsingFormat: #(-6 2 false)); addAll: '   ';
        addAll: nonrep asString ; addAll: ' other methods'; lf
  ].

  ave := total // (meths size max: 1).
  rpt addAll: (total asString width: -6); addAll: '  100.00   ';
    addAll: 'Total'; lf.
  ^rpt
%

category: 'Private'
method: ProfMonitor
_tallyInfo
 | iv |
 "Returns an Array of the form { tallyNameString . statsWordExtractionBlock }."
 iv := traceObjCreation.
 "following must agree with VM C code in profileStatsWord() and code in setOptions:
    16r4  for elapsed time sampling, tally object faults
    16r8  for elapsed time sampling, tally page faults
    16r10  for elapsed time sampling, tally eden bytes used
    16r20  for elapsed time sampling, tally temp obj memory gc time
 "
 (iv bitAnd: 16r4) ~~ 0 ifTrue:[
       "10 bits of objWrites and 13 bits of objReads"
   ^ { ' objFaults' .
     [:w | ((w bitShift: -20) bitAnd: 16r3FF) + ((w bitShift: -30) bitAnd: 16r1FFF)]} ].

 (iv bitAnd: 16r8) ~~ 0 ifTrue:[
   ^ { 'pageFaults' . [:w | w bitAnd: 16r3FF ] "10 bits of page faults"}].

 (iv bitAnd: 16r10) ~~ 0 ifTrue:[  "17 bits of eden bytes used"
   ^ { 'edenBytes' . [:w | (w bitShift: -43) bitAnd: 16r1FFFF ] } ].

 (iv bitAnd: 16r20) ~~ 0 ifTrue:[  "10 bits of gc time"
   ^ { 'gcTimeMs ' . [:w | (w bitShift: -10) bitAnd: 16r3FF ]} ].

 ^   { 'tally    ' . nil } "assume just time sampling"
%

category: 'Private'
method: ProfMonitor
_timeHeaderString

  | rpt |
  rpt := String new.
  rpt
	add: 'elapsed ';
      add: (self sampling == #cpu ifTrue:['CPU'] ifFalse:['REAL']) ;
      add: ' time:    ';
      add: (self dynamicInstVarAt: #elapsedTime) asString; add: ' ms' .
  ^rpt
%

category: 'Private'
method: ProfMonitor
_zeroArgPrim: opcode

"opcode      function
   1		start profiling - returns receiver
   2		stop profiling - returns number of samples written to sample file
   3    read sample file - returns contents of file in an Array
   4    suspend high res sampling
   5    resume  high res sampling
   6    get and clear overrun info, result is a String or nil
   7    read clock
"
<primitive: 191>
self _primitiveFailed: #_zeroArgPrim: args: { opcode }
%

! Class implementation for 'ProfMonitorTree'

!		Class methods for 'ProfMonitorTree'

category: 'Reporting'
classmethod: ProfMonitorTree
defaultReports
  ^super defaultReports, {#tree . #objCreationTree}
%

!		Instance methods for 'ProfMonitorTree'

category: 'Private'
method: ProfMonitorTree
gatherPMEsForTree

  | res rawArraySiz rawArrayPointer sampleStart sampleEnd reposCls fileData |

  res := OrderedCollection new.
  fileData := self _readSampleFile .
  fileData ifNil:[ ^ 'No profiling data available: check profiling parameters.' ].
  rawArray := fileData at: 1 .
  (rawArraySiz := rawArray size) < 1 ifTrue:[ ^ self ].
  rawArrayPointer := 1 .
  rootPME := self readFirstPME.
  objRootPMEDict := IdentityKeyValueDictionary new.
  reposCls := SystemRepository.
  [ rawArrayPointer < rawArraySiz ] whileTrue:[
      (rawArray at: rawArrayPointer) == reposCls ifFalse:[
         Error signal: 'data order problem'
      ].
      sampleStart := rawArrayPointer + 3.   "skip count and statsWord"
      sampleEnd := sampleStart + ((rawArray at: rawArrayPointer + 1) * 2) - 1.
      ((rawArray at: sampleStart) == true)
      ifTrue: [
        "handle object trace report"
        sampleEnd := sampleEnd + 2.
        self tallyObjPME: (rawArray at: sampleStart + 1)
          position: sampleEnd
 