! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(Date
	_newKernelSubclass:'ObsoleteDateTime50'
	instVarNames: #(seconds)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 101121
)
		category: nil;
		comment: 'An instance of ObsoleteDateTime50 describes a moment in time (with one-second resolution)
 on a date after December 31, 1900.

 The internal representation of a ObsoleteDateTime50 is based on Greenwich Mean Time.
 However, many methods express time in the local timezone.  ("Local" time is
 local to your Gem process.)  These methods automatically convert between
 timezones, but the internal representation remains in Greenwich Mean Time.
 Hence, you can interact with ObsoleteDateTime50 methods in a natural way, but ObsoleteDateTime50
 objects can be safely compared to each other no matter what time zone is used
 to express them.

 You can convert a ObsoleteDateTime50 to a String (using Formatting instance methods), and
 you can convert a String to a ObsoleteDateTime50 (using Instance Creation class methods).
 Such conversions require a specification to describe the format of the String.
 Some methods provide for the default format, DD/MM/YYYY HH:MM:SS, which
 expresses the day and month (in that order) as digits and uses a 24-hour clock.

 Explicit string-formatting specifications take the form of an Array, described
 in the following table.  A specification is incorrect if it is missing an
 element or if an element value is not one of the acceptable values listed in
 the table.

 String-formatting Specification Array for ObsoleteDateTime50.

 Element   Acceptable Value       Explanation

 1st,      Integers 1, 2,         Determines the position of the day (1),
 2nd, and  and 3, in any          month (2), and year (3).
 3rd       order

 4th       A Character literal    Separates year, month, and day.
           (such as a space, $ )

 5th       Integer                Determines the month format to be a number (1),
                                  three-letter abbreviation (2), or the entire
                                  name (3).

 6th       Integer                Determines the year format to be the entire
                                  number (1), or only the last two digits (2).

 7th       A Character literal    Separates hours, minutes, and seconds.
           (such as $: or $.)

 8th       true                   Include the time of day.

 8th       false                  Do not include the time of day.  Ignore elements
                                  7, 9, and 10.  Elements 9 and 10 are optional
                                  in the specification.

 9th       true                   Include seconds.

 9th       false                  Do not include seconds.

 10th      true                   Time is expressed in 12-hour format, with
                                  am or pm (such as 1:30:55 pm).  The space is
                                  required preceding the am or pm indicator.

 10th      false                  Time is expressed in 24-hour format
                                  (such as 13:30:55).

Constraints:
	year: SmallInteger
	dayOfYear: SmallInteger
	seconds: SmallInteger

instVar seconds -- The number of seconds since midnight, Greenwich Mean Time.
';
		immediateInvariant.
true.
%

removeallmethods ObsoleteDateTime50
removeallclassmethods ObsoleteDateTime50

doit
(Object
	_newKernelSubclass:'ObsoleteGsFile'
	instVarNames: #(id pathName mode errorCode errorMessage)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 110337
)
		category: nil;
		comment: 'The class ObsoleteGsFile is obsolete as of GemStone version 5.0 and will be removed 
in a future release.';
		immediateInvariant.
true.
%

removeallmethods ObsoleteGsFile
removeallclassmethods ObsoleteGsFile

doit
(TimeZoneInfo
	subclass: 'ObsoleteTimeZone2'
	instVarNames: #(standardPrintString dstPrintString dstStartTimeList dstEndTimeList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
)
		category: nil;
		comment: 'This provides GemStone/S overrides and extensions to the
ANSI TimeZone behavior.';
		immediateInvariant.
true.
%

removeallmethods ObsoleteTimeZone2
removeallclassmethods ObsoleteTimeZone2

! Class implementation for 'ObsoleteDateTime50'

!		Class methods for 'ObsoleteDateTime50'

category: 'Private'
classmethod: ObsoleteDateTime50
dateTimeClass

^ DateTime
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
fromStream: aStream

"Creates and returns an instance of the receiver by reading a String from
 aStream.  The String expresses local time in the default format
 (DD/MM/YYYY HH:MM:SS).  Generates an error if the String does not conform to
 the format."

^ self fromStream: aStream usingFormat: #(1 2 3 $/ 1 1 $: true true false)
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
fromStream: aStream usingFormat: anArray

"Creates and returns an instance of the receiver by reading a String from
 aStream.  The String expresses local time in the format specified by
 anArray.  The expression is terminated either by a space character or by the
 end of the Stream.  Generates an error if the String does not conform to the
 format, or if anArray contains an incorrect formatting specification.

 See the class documentation of ObsoleteDateTime50 for a complete description of the
 String-formatting specification Array.

 If the month format (5th element) indicates either an abbreviation (2) or an
 entire name (3), then this method tries to determine the month by decoding a
 character substring.  That substring may include any number of characters, but
 must exactly match a legal month name (or the initial portion of that month
 name).  If the substring matches more than one month, the first month matched
 is used (the search begins with January).

 If the specification indicates that seconds should not be included (9th
 element is false), and aString includes seconds, this method generates an
 error."

^ (self fromStreamGmt: aStream usingFormat: anArray )
     addSeconds: Time gmtOffsetSeconds
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
fromStreamGmt: aStream

"Creates and returns an instance of the receiver by reading a String from
 aStream.  The String expresses Greenwich Mean Time in the default format
 (DD/MM/YYYY HH:MM:SS).  Generates an error if the String does not conform to
 the format."

^ self fromStreamGmt: aStream usingFormat: #(1 2 3 $/ 1 1 $: true true false)
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
fromStreamGmt: aStream usingFormat: anArray

"Creates and returns an instance of the receiver by reading a String from
 aStream.  The String expresses Greenwich Mean Time in the format specified by
 anArray.  The expression is terminated either by a space character or by the
 end of the Stream.  Generates an error if the String does not conform to the
 format, or if anArray contains an incorrect formatting specification.

 See the class documentation of ObsoleteDateTime50 for a complete description of the
 String-formatting specification Array.

 If the month format (5th element) indicates either an abbreviation (2) or an
 entire name (3), then this method tries to determine the month by decoding a
 character substring.  That substring may include any number of characters, but
 must exactly match a legal month name (or the initial portion of that month
 name).  If the substring matches more than one month, the first month matched
 is used (the search begins with January).

 If the specification indicates that seconds should not be included (9th
 element is false), and aString includes seconds, this method generates an
 error."

| dayInt monthInt yearInt hourInt minInt secInt timeDelim dateDelim ampm
  ampmPresent secondsPresent timePresent result parseDay
  blkNo parseMonth parseYear parseField |

"This block returns a string up from the input stream up to the specified
 delimiter.  If will also allow an eof if that parameter is set true.
 It then skips over the delimiter if it is found.
"
parseField := [ :delim :allowEof | | str |
                str := aStream contents class new.
                [ ((aStream peek isEquivalent: delim) not) and:[aStream atEnd not] ]
                whileTrue:
                  [ str add: aStream next ].
                (aStream atEnd)
                ifTrue:
                  [ allowEof
                    ifFalse:
                      [ ObsoleteDateTime50 _error: #rtErrBadFormat args: { aStream } ]
                  ]
                ifFalse:
                  [ aStream next "skip over delimiter" ].
                str
             ].

parseDay:= "parse day"
  [ :delim | | nextField |
    nextField := parseField value: delim value: (delim isEquivalent: $ ).
    dayInt := Integer fromCompleteString: nextField
  ].
parseMonth:= "parse month"
  [ :delim | | nextField |
    nextField := parseField value: delim value: (delim isEquivalent: $ ).
    (nextField =  '' )
    ifTrue:
      [ ObsoleteDateTime50 _error: #rtErrBadFormat args: { aStream }].
    (anArray at: 5) = 1
    ifTrue:
      [ monthInt := Integer fromCompleteString: nextField ]
    ifFalse:
      [ monthInt := self _getMonthFrom: nextField ].
    (monthInt < 1) | (monthInt > 12)
    ifTrue:
      [ ObsoleteDateTime50 _error: #rtErrBadFormat args: { aStream } ]
  ].
parseYear := "parse year"
  [ :delim | | nextField |
    nextField := parseField value: delim value: (delim isEquivalent: $ ).
    yearInt := Integer fromCompleteString: nextField.
    (anArray at: 6) = 2
    ifTrue:
      [ (yearInt > 99)
        ifFalse: [yearInt := yearInt + ((ObsoleteDateTime50 now yearGmt) // 100 * 100) ]
      ]
  ].

self _checkReadStream: aStream forClass: CharacterCollection.

ObsoleteDateTime50 _checkFormat: anArray.

dateDelim := anArray at: 4.
timeDelim := anArray at: 7.
timePresent := anArray at: 8.

"parse the date, with day, month, year in the specified format order"
true ifTrue:[ | delim |
  (delim:= Array new) add: dateDelim; add: dateDelim; add: $ .
  1 to: 3 do: [:i | blkNo:= anArray at: i.
            (blkNo = 1) ifTrue: [parseDay value: (delim at: i)].
            (blkNo = 2) ifTrue: [parseMonth value: (delim at: i)].
            (blkNo = 3) ifTrue: [parseYear value: (delim at: i)]
  ].
].

timePresent ifTrue:[ "read the time"
    secondsPresent := anArray at: 9.
    ampmPresent := anArray at: 10.
    hourInt := Integer fromCompleteString: (parseField value: timeDelim value: false).
    minInt := Integer fromCompleteString:
                     (parseField value: (secondsPresent
                                         ifTrue: [timeDelim]
                                         ifFalse: [$ ])
                                 value: (secondsPresent not and:[ ampmPresent not])).
    secondsPresent ifTrue: [
      secInt := Integer fromCompleteString: (parseField value: $  value: ampmPresent not)]
    ifFalse:[ secInt := 0 ].

    ampmPresent ifTrue: [
        hourInt < 0 ifTrue: [
          ObsoleteDateTime50 _error: #rtErrBadFormat args: { aStream }].
        hourInt > 12 ifTrue: [
          ObsoleteDateTime50 _error: #rtErrBadFormat args: { aStream }].
	(ampm := String new) add: (aStream next); add: aStream next.
        (ampm isEquivalent: 'PM') ifTrue: [
	  hourInt := hourInt + 12.
	  hourInt == 24 ifTrue: [
            hourInt := 12].
          ]
        ifFalse: [
	  (ampm isEquivalent: 'AM') ifFalse: [
            ObsoleteDateTime50 _error: #rtErrBadFormat args: { aStream } ].
	  hourInt == 12 ifTrue: [
            hourInt := 0].
          ].
      ]
  ]
ifFalse:[ "ignore the time"
    hourInt := 0.
    minInt := 0.
    secInt := 0
  ].

result := self newGmtWithYear: yearInt
                month: monthInt
                day: dayInt
                hours: hourInt
                minutes: minInt
                seconds: secInt.

"This is an easy way to test that all of the values specified were in
 in range.  If any of them were not, the result will be different
 than what we specified."

(result asPartsGmt = { yearInt . monthInt . dayInt . hourInt . minInt . secInt })
ifFalse:
  [ ObsoleteDateTime50 _error: #rtErrBadFormat args: { aStream } ].

^ result
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
fromString: aString

"Creates and returns an instance of the receiver from the String aString.
 The String expresses local time in the default format
 (DD/MM/YYYY HH:MM:SS).  Generates an error if the String does not conform to
 the format."

^ self fromString: aString usingFormat: #(1 2 3 $/ 1 1 $: true true false)
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
fromString: aString usingFormat: anArray

"Creates and returns an instance of the receiver from the String aString.
 The String expresses local time in the format specified by anArray.
 The expression is terminated either by a space character or by the end of the
 String.  Generates an error if the String does not conform to the format,
 or if anArray contains an incorrect formatting specification.

 See the class documentation of ObsoleteDateTime50 for a complete description of the
 String-formatting specification Array.

 If the month format (5th element) indicates either an abbreviation (2) or an
 entire name (3), then this method tries to determine the month by decoding a
 character substring.  That substring may include any number of characters, but
 must exactly match a legal month name (or the initial portion of that month
 name).  If the substring matches more than one month, the first month matched
 is used (the search begins with January).

 If the specification indicates that seconds should not be included (9th
 element is false), and aString includes seconds, this method generates an
 error."

^ (self fromStringGmt: aString usingFormat: anArray)
    addSeconds: (Time gmtOffsetSeconds)
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
fromStringGmt: aString

"Creates and returns an instance of the receiver from the String aString.
 The String expresses Greenwich Mean Time in the default format
 (DD/MM/YYYY HH:MM:SS).  Generates an error if the String does not conform to
 the format."

^ self fromStringGmt: aString usingFormat: #(1 2 3 $/ 1 1 $: true true false)
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
fromStringGmt: aString usingFormat: anArray

"Creates and returns an instance of the receiver from the String aString.
 The String expresses Greenwich Mean Time in the format specified by anArray.
 The expression is terminated either by a space character or by the end of the
 String.  Generates an error if the String does not conform to the format,
 or if anArray contains an incorrect formatting specification.

 See the class documentation of ObsoleteDateTime50 for a complete description of the
 String-formatting specification Array.

 If the month format (5th element) indicates either an abbreviation (2) or an
 entire name (3), then this method tries to determine the month by decoding a
 character substring.  That substring may include any number of characters, but
 must exactly match a legal month name (or the initial portion of that month
 name).  If the substring matches more than one month, the first month matched
 is used (the search begins with January).

 If the specification indicates that seconds should not be included (9th
 element is false), and aString includes seconds, this method generates an
 error."

| s result |

s := ReadStreamPortable on: aString.
result := self fromStreamGmt: s usingFormat: anArray.
[ s atEnd ]
whileFalse:
  [ (s next isEquivalent:  $ )
    ifFalse:
      [ self _errIncorrectFormat: aString ]
  ].
^ result
%

category: 'Storing and Loading'
classmethod: ObsoleteDateTime50
loadFrom: passiveObj

"Creates and returns an active instance of the receiver from the passive form
 of the object, which expresses itself in Greenwich Mean Time."

| inst |

inst := self _newGmtWithYear: passiveObj readObject
               month: passiveObj readObject
               day: passiveObj readObject
               seconds: passiveObj readObject.
passiveObj version >= 500 ifFalse:[ "convert 4.1.3 local time to GMT"
  inst := inst addSeconds: Time gmtOffsetSeconds
  ].
passiveObj hasRead: inst.
^inst.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
newFromDateTime: aDateTime

| anObsDateTime |

anObsDateTime := self basicNew.
anObsDateTime year: aDateTime yearGmt.
anObsDateTime dayOfYear: aDateTime dayOfYearGmt.
anObsDateTime seconds: aDateTime timeSinceMidnightGmt.
anObsDateTime immediateInvariant.
^ anObsDateTime.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
newGmtWithYear: year dayOfYear: dayCount seconds: seconds

"Creates and returns an instance of the receiver from the specified values,
 which express Greenwich Mean Time.

 Generates an error if any of the values are out of range.  The argument
 year must be a positive Integer between 1901 and 1,000,000 inclusive."

| aDateTime |

aDateTime := self dateTimeClass newGmtWithYear: year dayOfYear:
                  dayCount seconds: seconds.

^ self newFromDateTime: aDateTime.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
newGmtWithYear: yearInt month: monthInt day: dayInt hours: hourInt
  minutes: minuteInt seconds: secondInt

"Creates and returns an instance of the receiver from the specified values,
 which express Greenwich Mean Time.

 Generates an error if any of the values are out of range.  The argument
 yearInt must be a positive Integer between 1901 and 1,000,000 inclusive."

| aDateTime |

aDateTime := self dateTimeClass newGmtWithYear: yearInt month: monthInt
                  day: dayInt hours: hourInt minutes: minuteInt
                  seconds: secondInt.

^ self newFromDateTime: aDateTime.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
newWithYear: year dayOfYear: dayCount seconds: seconds

"Creates and returns an instance of the receiver from the specified values,
 which express local time.

 Generates an error if any of the values are out of range.  The argument
 year must be a positive Integer between 1901 and 1,000,000 inclusive."

^ (self newGmtWithYear: year dayOfYear: dayCount seconds: seconds)
  addSeconds: Time gmtOffsetSeconds
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
newWithYear: yearInt month: monthInt day: dayInt hours: hourInt
  minutes: minuteInt seconds: secondInt

"Creates and returns an instance of the receiver from the specified values,
 which express local time.

 Generates an error if any of the values are out of range.  The argument
 yearInt must be a positive Integer between 1901 and 1,000,000 inclusive."

^ (self newGmtWithYear: yearInt month: monthInt day: dayInt hours: hourInt
    minutes: minuteInt seconds: secondInt)
  addSeconds: Time gmtOffsetSeconds
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
now

"Creates and returns an instance of the receiver from the system calendar and
 clock on the machine that is running the Gem process, which are assumed to
 represent the current date and time of day expressed in Greenwich Mean Time."

| aDateTime |

aDateTime := self dateTimeClass now.
^ self newFromDateTime: aDateTime.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
_checkFormat: anArray

"Private.  Verifies that anArray is a valid string-formatting specification for
 the receiver.  Generates an error if it is not."

"anArray is a format array as documented in ObsoleteDateTime50>>asStringUsingFormat:"

| v doTime |

anArray _validateClass: Array.
(anArray size < 8 or:[ anArray size > 10])
  ifTrue:[ ObsoleteDateTime50 _error: #rtErrBadFormatSpec args: { anArray } ].

"Check for a combination of the digits 1, 2, and 3"
((anArray at: 1) + (anArray at: 2) + (anArray at: 3) = 6 and:
        [(anArray at: 1) * (anArray at: 2) * (anArray at: 3) = 6])
  ifFalse:[ ObsoleteDateTime50 _error: #rtErrBadFormatSpec args: { anArray } ].

(anArray at: 4) _validateClass: Character.

((v := anArray at: 5) = 1 or: [v = 2 or: [v = 3]])
  ifFalse:[ ObsoleteDateTime50 _error: #rtErrBadFormatSpec args: { anArray } ].

((anArray at: 6) = 1 or: [(anArray at: 6) = 2])
  ifFalse:[ ObsoleteDateTime50 _error: #rtErrBadFormatSpec args: { anArray } ].

(doTime := anArray at: 8) _validateClass: Boolean.
doTime ifTrue:[
  anArray size = 10
    ifFalse:[ ObsoleteDateTime50 _error: #rtErrBadFormatSpec args: { anArray } ].
  (anArray at: 7) _validateClass: Character.
  (anArray at: 9) _validateClass: Boolean.
  (anArray at: 10) _validateClass: Boolean.
  ]
%

category: 'Repository Conversion'
classmethod: ObsoleteDateTime50
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteDateTime50)
  ifTrue: [ ^ DateTime ].

^ self.
%

category: 'Private'
classmethod: ObsoleteDateTime50
_newGmtWithYear: year dayOfYear: dayCount seconds: seconds

"Creates and returns an instance of the receiver from the specified values,
 which express Greenwich Mean Time.

 Generates an error if any of the values are out of range.  The argument
 year must be a positive Integer between 1901 and 1,000,000 inclusive."

| extraDays newSeconds newDayOfYear |

(seconds abs >= 86400)
  ifTrue: [
    extraDays := seconds // 86400.
    newDayOfYear := dayCount + extraDays.
    newSeconds := seconds \\ 86400.
    ]
  ifFalse: [
    newDayOfYear := dayCount.
    newSeconds := seconds.
    ].

^ self newGmtWithYear: year dayOfYear: newDayOfYear seconds: newSeconds
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
_newGmtWithYear: yearInt month: monthInt day: dayInt seconds: secondInt

"Creates and returns an instance of the receiver from the specified values,
 which express Greenwich Mean Time.

 Generates an error if any of the values are out of range.  The argument
 year must be a positive Integer between 1901 and 1,000,000 inclusive."

| aDateTime |

aDateTime := self dateTimeClass _newGmtWithYear: yearInt month: monthInt
                  day: dayInt seconds: secondInt.

^ self newFromDateTime: aDateTime.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime50
_newJulianDay: anInteger second: anotherInteger

"Creates and returns an instance of the receiver from the specified values,
 which express Greenwich Mean Time.  Generates an error if any of the values
 are out of range."

| aDateTime |

aDateTime := self dateTimeClass _newJulianDay: anInteger second: anotherInteger.
^ self newFromDateTime: aDateTime.
%

!		Instance methods for 'ObsoleteDateTime50'

category: 'Comparing'
method: ObsoleteDateTime50
< aObsoleteDateTime50

"Returns true if the receiver represents a moment in time before that of the
 argument, and false if it doesn't.  Generates an error if the argument is not
 a ObsoleteDateTime50."

| argYear argDayOfYear |

argYear := aObsoleteDateTime50 yearGmt.
(year < argYear) ifTrue: [ ^true ].
(year > argYear) ifTrue: [ ^false ].

"The years are the same"

argDayOfYear := aObsoleteDateTime50 dayOfYearGmt .
(dayOfYear < argDayOfYear) ifTrue: [ ^true ].
(dayOfYear > argDayOfYear) ifTrue: [ ^false ].

"The days are the same"

^ (seconds < aObsoleteDateTime50 timeAsSeconds).
%

category: 'Comparing'
method: ObsoleteDateTime50
= aObsoleteDateTime50

"Returns true if the receiver represents the same moment in time as that of the
 argument, and false if it doesn't."

(aObsoleteDateTime50 isKindOf: self class) ifFalse: [ ^false ].
^ (year = aObsoleteDateTime50 yearGmt)
  and: [(dayOfYear = aObsoleteDateTime50 dayOfYearGmt)
    and: [seconds = aObsoleteDateTime50 timeAsSeconds]
    ]
%

category: 'Comparing'
method: ObsoleteDateTime50
> aObsoleteDateTime50

"Returns true if the receiver represents a moment in time after that of the
 argument, and false if it doesn't.  Generates an error if the argument is not
 a ObsoleteDateTime50."

| argYear argDayOfYear |

argYear := aObsoleteDateTime50 yearGmt.
(year > argYear) ifTrue: [ ^true ].
(year < argYear) ifTrue: [ ^false ].

"The years are the same"

argDayOfYear := aObsoleteDateTime50 dayOfYearGmt.
(dayOfYear > argDayOfYear) ifTrue: [ ^true ].
(dayOfYear < argDayOfYear) ifTrue: [ ^false ].

"The days are the same"

^ (seconds > aObsoleteDateTime50 timeAsSeconds).
%

category: 'Arithmetic'
method: ObsoleteDateTime50
addDays: anInteger

"Returns a ObsoleteDateTime50 that describes a moment in time anInteger days
 later than that of the receiver."

^ (self class) newGmtWithYear: year dayOfYear: (dayOfYear + anInteger)
		   seconds: seconds.
%

category: 'Arithmetic'
method: ObsoleteDateTime50
addHours: aNumber

"Returns a ObsoleteDateTime50 that describes a moment in time aNumber hours
 later than that of the receiver."

^ (self class) _newGmtWithYear: year dayOfYear: dayOfYear
                  seconds: (seconds + (aNumber * 3600)) asInteger.
%

category: 'Arithmetic'
method: ObsoleteDateTime50
addMinutes: aNumber

"Returns a ObsoleteDateTime50 that describes a moment in time aNumber minutes
 later than that of the receiver."

^ (self class) _newGmtWithYear: year dayOfYear: dayOfYear
           seconds: (seconds + (aNumber * 60)) asInteger .
%

category: 'Arithmetic'
method: ObsoleteDateTime50
addMonths: anInteger

"Returns a ObsoleteDateTime50 that describes a moment in time anInteger months
 later than that of the receiver.

 This method attempts to keep the day of the month the same.  If the
 new month has fewer days than the receiver's original month, then it
 truncates to the last day of the new month."

| t newMonth newYear |

t := self _yearMonthDayGmt.
newMonth := ((t at: 2) + anInteger) .
newYear := (t at: 1) .
(newMonth == 0) ifTrue:[ newYear := newYear - 1 ].
^ (self class) _newGmtWithYear: newYear
               month: newMonth
               day: (t at: 3)
               seconds: seconds
%

category: 'Arithmetic'
method: ObsoleteDateTime50
addSeconds: aNumber

"Returns a ObsoleteDateTime50 that describes a moment in time aNumber seconds
 later than that of the receiver."

^ (self class) _newGmtWithYear: year dayOfYear: dayOfYear
		seconds: (seconds + aNumber) asInteger .
%

category: 'Arithmetic'
method: ObsoleteDateTime50
addWeeks: anInteger

"Returns a ObsoleteDateTime50 that describes a moment in time anInteger weeks
 later than that of the receiver."

^ (self class) newGmtWithYear: year dayOfYear: (dayOfYear + (anInteger * 7))
		   seconds: seconds.
%

category: 'Arithmetic'
method: ObsoleteDateTime50
addYears: anInteger

"Returns a ObsoleteDateTime50 that describes a moment in time anInteger years
 later than that of the receiver."

^ (self class) newGmtWithYear: (year + anInteger) dayOfYear: dayOfYear
		   seconds: seconds.
%

category: 'Instance Creation'
method: ObsoleteDateTime50
asDateTime

| aDateTime |

aDateTime := self class dateTimeClass newGmtWithYear: (self yearGmt)
                        dayOfYear: (self dayOfYearGmt)
                        seconds: (self timeAsSeconds).
^ aDateTime.
%

category: 'Converting'
method: ObsoleteDateTime50
asObsoleteDateTime50

"Returns the receiver."

^ self.
%

category: 'Converting'
method: ObsoleteDateTime50
asParts

"Returns an Array of six SmallIntegers (year month day hours minutes seconds)
 that expresses the receiver in local time."

^ ( self subtractSeconds: Time gmtOffsetSeconds) asPartsGmt  .
%

category: 'Converting'
method: ObsoleteDateTime50
asPartsGmt

"Returns an Array of six SmallIntegers (year month day hours minutes seconds)
 that expresses the receiver in Greenwich Mean Time."

| result |

result := self _yearMonthDayGmt.  "year/month/day"
result addLast: (seconds // 3600).  "hours"
result addLast: (seconds \\ 3600) // 60.  "minutes"
result addLast: (seconds \\ 60).  "seconds"
^ result
%

category: 'Converting'
method: ObsoleteDateTime50
asSeconds

"Returns an Integer that represents the receiver in units of seconds since
 midnight January 1, 1901, Greenwich Mean Time."

^ ((self asDays) * 86400) + seconds.
%

category: 'Formatting'
method: ObsoleteDateTime50
asString

"Returns a String that expresses the receiver in local time
 in the default format (DD/MM/YYYY HH:MM:SS)."

|localDt|

localDt := self subtractSeconds: Time gmtOffsetSeconds .
^ localDt asStringGmt
%

category: 'Formatting'
method: ObsoleteDateTime50
asStringGmt

"Returns a String that expresses the receiver in Greenwich Mean Time
 in the default format (DD/MM/YYYY HH:MM:SS)."

| t result |

t := self _yearMonthDayGmt.
result := (t at: 3) _digitsAsString .
result addAll: '/';
  addAll: (t at: 2) _digitsAsString;
  addAll: '/';
  addAll: (t at: 1) _digitsAsString;
  addAll: ' ';
  addAll: (seconds // 3600) _digitsAsString;
  addAll: ':';
  addAll: (seconds \\ 3600 // 60) _digitsAsString;
  addAll: ':';
  addAll: (seconds \\ 60) _digitsAsString .
^ result
%

category: 'Formatting'
method: ObsoleteDateTime50
asStringGmtUsingFormat: anArray

"Returns a String that expresses the receiver in Greenwich Mean Time
 in the format defined by anArray.  Generates an error if anArray
 contains an incorrect formatting specification.

 See the class documentation of ObsoleteDateTime50 for a complete description of the
 String-formatting specification Array."

|t dateSeparator timeSeparator monthName aString
 hour hourInt min sec day yearNumber |

t := self _yearMonthDayGmt.
ObsoleteDateTime50 _checkFormat: anArray.
dateSeparator := (anArray at: 4) asString.

timeSeparator := (anArray at: 7) asString.

((anArray at: 5) = 2) "get the month name according to the format"
   ifTrue: [monthName := self _monthAbbrev: (t at: 2)]
   ifFalse: [((anArray at: 5) = 3) "month as number is default"
      ifTrue: [monthName := self _monthName: (t at: 2)]
      ifFalse: [monthName := (t at: 2) _digitsAsString]].

((anArray at: 6) = 2)
   ifTrue: [yearNumber := ((t at: 1) \\ 100) _digitsAsString]
   ifFalse: [yearNumber := (t at: 1) asString].  "YYYY is default"

day := (t at:3) _digitsAsString.
((anArray at: 1) = 2) "month first"
   ifTrue: [aString := monthName , dateSeparator]
   ifFalse: [((anArray at: 1) = 3) "yearNumber first"
      ifTrue: [aString := yearNumber , dateSeparator]
      ifFalse: [aString := day , dateSeparator]].  "day first is default"

((anArray at: 2) = 1) "day second"
   ifTrue: [aString addAll: day; addAll: dateSeparator] "yearNumber second"
   ifFalse: [((anArray at: 2) = 3) "month second is default"
      ifTrue: [aString addAll: yearNumber; addAll: dateSeparator]
      ifFalse: [aString addAll: monthName; addAll: dateSeparator]].

((anArray at: 3) = 1) "day third"
   ifTrue: [aString addAll: day]
   ifFalse: [((anArray at: 3) = 2) "month third"
      ifTrue: [aString addAll: monthName]
      ifFalse: [aString addAll: yearNumber]].  "yearNumber third is default"

hourInt := seconds // 3600.
hour := hourInt _digitsAsString.
min := (seconds \\ 3600 // 60) _digitsAsString.
sec := (seconds \\ 60) _digitsAsString.

(anArray at: 8) ifTrue: [ "print the time"
  aString add: $ .
  (anArray at: 10) ifTrue: [ "12-hour format"
    (hourInt > 12) ifTrue: [
      aString addAll: (hourInt - 12) _digitsAsString;
              addAll: timeSeparator;
              addAll: min.

      (anArray at: 9) ifTrue: [
        aString addAll: timeSeparator;
                addAll: sec
        ].
      ]
    ifFalse: [
      aString addAll: (hourInt = 0 ifTrue: ['12'] ifFalse: [hour]);
              addAll: timeSeparator;
              addAll: min.

      (anArray at: 9) ifTrue: [
        aString addAll: timeSeparator;
                addAll: sec.
        ].
      ].

    aString addAll: (hourInt >= 12 ifTrue: [' pm'] ifFalse: [' am']).
    ]
  ifFalse: [
    aString addAll: hour;
            addAll: timeSeparator;
            addAll: min.

    (anArray at: 9) ifTrue: [
      aString addAll: timeSeparator;
              addAll: sec.
      ].
    ].
  ].

^ aString
%

category: 'Formatting'
method: ObsoleteDateTime50
asStringUsingFormat: anArray

"Returns a String that expresses the receiver in local time
 in the format defined by anArray.  Generates an error if anArray
 contains an incorrect formatting specification.

 See the class documentation of ObsoleteDateTime50 for a complete description of the
 String-formatting specification Array."

| localDt |
localDt := self subtractSeconds: Time gmtOffsetSeconds .
^ localDt asStringGmtUsingFormat: anArray
%

category: 'Accessing'
method: ObsoleteDateTime50
dayOfMonth

"Returns a SmallInteger that gives the day of the month described by the
 receiver, expressed in local time."

^  ((self subtractSeconds: Time gmtOffsetSeconds) _yearMonthDayGmt) at: 3
%

category: 'Accessing'
method: ObsoleteDateTime50
dayOfMonthGmt

"Returns a SmallInteger that gives the day of the month described by the
 receiver, expressed in Greenwich Mean Time."

^  (self _yearMonthDayGmt) at: 3
%

category: 'Accessing'
method: ObsoleteDateTime50
dayOfWeek

"Returns a SmallInteger that gives the numeric index of the day of the week
 described by the receiver, expressed in local time.  The index is a
 number between 1 and 7 inclusive, where 1 signifies Sunday."

^ (self subtractSeconds: Time gmtOffsetSeconds) julianDay - 2299295 - 1 \\ 7 + 1

  "the julian day 2299298 is converted to the Gregorian"
  "date of March 1, 1583 by Communications of the ACM #199 algorithm"
  "was March 1, 1583 a Thursday?"
%

category: 'Accessing'
method: ObsoleteDateTime50
dayOfWeekGmt

"Returns a SmallInteger that gives the numeric index of the day of the week
 described by the receiver, expressed in Greenwich Mean Time.  The index is a
 number between 1 and 7 inclusive, where 1 signifies Sunday."

^ self julianDay - 2299295 - 1 \\ 7 + 1

  "the julian day 2299298 is converted to the Gregorian"
  "date of March 1, 1583 by Communications of the ACM #199 algorithm"
  "was March 1, 1583 a Thursday?"
%

category: 'Accessing'
method: ObsoleteDateTime50
dayOfYear

"Returns a SmallInteger that gives the day of the year described by the
 receiver, expressed in local time."

self shouldNotImplement: #dayOfYear .  "expect no instances of ObsoleteDateTime50"
"was
  ^ (self subtractSeconds: Time gmtOffsetSeconds) _dayOfYear
"
%

category: 'Updating'
method: ObsoleteDateTime50
dayOfYear: aDay

dayOfYear := aDay.
^ self
%

category: 'Accessing'
method: ObsoleteDateTime50
dayOfYearGmt

"Returns a SmallInteger that gives the day of the year described by the
 receiver, expressed in Greenwich Mean Time."

^ dayOfYear

%

category: 'Accessing'
method: ObsoleteDateTime50
daysInMonthGmt

"Returns a SmallInteger that gives the number of days in the month described by
 the receiver, expressed in Greenwich Mean Time."

^ self _daysInMonth: self monthOfYearGmt
%

category: 'Comparing'
method: ObsoleteDateTime50
hash

"Returns an Integer hash code for the receiver."

^ (((year hash) bitShift: -1) bitXor: (dayOfYear hash)) bitXor: (seconds hash).
%

category: 'Accessing'
method: ObsoleteDateTime50
hours

"Returns a SmallInteger (between zero and 23 inclusive) that gives the number of
 hours represented by the receiver since midnight, local time."

^ (seconds - Time gmtOffsetSeconds \\ 86400) // 3600
%

category: 'Accessing'
method: ObsoleteDateTime50
hoursGmt

"Returns a SmallInteger (between zero and 23 inclusive) that gives the number of
 hours represented by the receiver since midnight, Greenwich Mean Time."

^ seconds // 3600
%

category: 'Deprecated'
method: ObsoleteDateTime50
julianSecond
	"Returns a SmallInteger (between zero and 86399 inclusive) that gives the number
	of seconds represented by the receiver since midnight, local time."

self deprecated: 'julianSecond  Obsolete in GemStone 5.0.'.
^ (seconds - Time gmtOffsetSeconds + 86400) \\ 86400.
%

category: 'Accessing'
method: ObsoleteDateTime50
leap

"Returns true if the receiver describes a leap year, expressed in local time,
 and false if it does not."

^ (self subtractSeconds: Time gmtOffsetSeconds) leapGmt
%

category: 'Accessing'
method: ObsoleteDateTime50
leapGmt

"Returns true if the receiver describes a leap year, expressed in Greenwich Mean
 Time, and false if it does not."

^ super leap
%

category: 'Accessing'
method: ObsoleteDateTime50
minutes

"Returns a SmallInteger (between zero and 59 inclusive) that gives the number of
 minutes represented by the receiver since the previous hour, local time."

^ ((seconds - Time gmtOffsetSeconds) \\ 3600) // 60
%

category: 'Accessing'
method: ObsoleteDateTime50
minutesGmt

"Returns a SmallInteger (between zero and 59 inclusive) that gives the number of
 minutes represented by the receiver since the previous hour, Greenwich Mean
 Time."

^ (seconds \\ 3600) // 60
%

category: 'Accessing'
method: ObsoleteDateTime50
monthNameGmt

"Returns a String that gives the name of the month of the year described by the
 receiver, expressed in Greenwich Mean Time, in the user's native language."

^ MonthNames value at: self monthOfYearGmt
%

category: 'Accessing'
method: ObsoleteDateTime50
monthOfYear

"Returns a SmallInteger that gives the numeric index of the month of the year
 described by the receiver, expressed in local time.  The index is a number
 between 1 and 12 inclusive, where 1 signifies January."

^ (self subtractSeconds: Time gmtOffsetSeconds) monthOfYearGmt
%

category: 'Accessing'
method: ObsoleteDateTime50
monthOfYearGmt

"Returns a SmallInteger that gives the numeric index of the month of the year
 described by the receiver, expressed in Greenwich Mean Time.  The index is a
 number between 1 and 12 inclusive, where 1 signifies January."

^ self _yearMonthDay at: 2
%

category: 'Accessing'
method: ObsoleteDateTime50
seconds

"Returns a SmallInteger (between zero and 59 inclusive) that gives the number of
 seconds represented by the receiver since the previous minute."

^ (seconds - Time gmtOffsetSeconds) \\ 60.
%

category: 'Updating'
method: ObsoleteDateTime50
seconds: secs

seconds := secs.
^ self
%

category: 'Accessing'
method: ObsoleteDateTime50
secondsGmt

"Returns a SmallInteger (between zero and 59 inclusive) that gives the number of
 seconds represented by the receiver since the previous minute."

^ seconds \\ 60.
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractDate: aObsoleteDateTime50

"Returns a positive Integer that counts the number of times midnight local time
 occurs between the times described by the receiver and aObsoleteDateTime50."

| gmtOff |
gmtOff := Time gmtOffsetSeconds .
^ ((self subtractSeconds: gmtOff ) asDays -
   (aObsoleteDateTime50 subtractSeconds: gmtOff ) asDays) abs
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractDateGmt: aObsoleteDateTime50

"Returns a positive Integer that counts the number of times that midnight
 Greenwich Mean Time occurs between the times described by the receiver and
 aObsoleteDateTime50."

^ (self asDays - aObsoleteDateTime50 asDays) abs
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractDays: anInteger

"Returns a ObsoleteDateTime50 that describes a moment in time anInteger days
 earlier than that of the receiver."

^ (self class) newGmtWithYear: year dayOfYear: (dayOfYear - anInteger)
		      seconds: seconds.
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractHours: aNumber

"Returns a ObsoleteDateTime50 that describes a moment in time aNumber hours
 earlier than that of the receiver."

^ (self class) _newGmtWithYear: year dayOfYear: dayOfYear
		  seconds: (seconds - (aNumber * 3600)) asInteger.
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractMinutes: aNumber

"Returns a ObsoleteDateTime50 that describes a moment in time aNumber minutes
 earlier than that of the receiver."

^ (self class) _newGmtWithYear: year dayOfYear: dayOfYear
		seconds: (seconds - (aNumber * 60)) asInteger .
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractMonths: anInteger

"Returns a ObsoleteDateTime50 that describes a moment in time anInteger months
 earlier than that of the receiver.

 This method attempts to keep the day of the month the same.  If the
 new month has fewer days than the receiver's original month, then it
 truncates to the last day of the new month."

^ self addMonths: (anInteger negated).
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractSeconds: aNumber

"Returns a ObsoleteDateTime50 that describes a moment in time aNumber seconds
 earlier than that of the receiver."

^ (self class) _newGmtWithYear: year dayOfYear: dayOfYear
		seconds: (seconds - aNumber) asInteger.
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractTime: aObsoleteDateTime50

"Returns an Array of three positive Integers that count the hours, minutes, and
 seconds, respectively, between the times of day described by the receiver and
 aObsoleteDateTime50.

 The computation ignores the dates of both the receiver and aObsoleteDateTime50, and
 assumes that the receiver is the later time.  Hence, if the time of day in the
 receiver is less than the time of day in aObsoleteDateTime50, then the receiver's time of
 day is assumed to occur on the day following that of aObsoleteDateTime50."

| parts h m s |

parts := self asPartsGmt .
h := parts at: 4.
m := parts at: 5.
s := parts at: 6.

parts := aObsoleteDateTime50 asPartsGmt .
h < (parts at: 4) ifTrue:[ h := h + 24 ].
h := h - (parts at: 4).
m := m - (parts at: 5).
s := s - (parts at: 6).

s < 0 ifTrue: [
  s := s + 60.
  m := m - 1
].
s > 60 ifTrue: [
  s := s - 60.
  m := m + 1
].
m < 0 ifTrue: [
  m := m + 60.
  h := h - 1
].
m > 60 ifTrue: [
  m := m - 60.
  h := h + 1
].
^{ h . m . s }
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractWeeks: anInteger

"Returns a ObsoleteDateTime50 that describes a moment in time anInteger weeks
 earlier than that of the receiver."

^ (self class) newGmtWithYear: year dayOfYear: (dayOfYear - (anInteger * 7))
		seconds: seconds.
%

category: 'Arithmetic'
method: ObsoleteDateTime50
subtractYears: anInteger

"Returns a ObsoleteDateTime50 that describes a moment in time anInteger years
 earlier than that of the receiver."

^ (self class) newGmtWithYear: (year - anInteger) dayOfYear: dayOfYear
		seconds: seconds.
%

category: 'Converting'
method: ObsoleteDateTime50
timeAsSeconds

"Returns a SmallInteger (between zero and 86399 inclusive) that gives the number
 of seconds represented by the receiver since midnight, Greenwich Mean Time."

^ seconds
%

category: 'Formatting'
method: ObsoleteDateTime50
US12HrFormat

"Returns a String that expresses the receiver in local time.  The date is in
 United States format (month first) and the time of day is based on the 12-hour
 clock (MM/DD/YY HH:MM:SS pm)."

^self asStringUsingFormat: #(2 1 3 $/ 1 2 $: true false true)
%

category: 'Formatting'
method: ObsoleteDateTime50
US24HrFormat

"Returns a String that expresses the receiver in local time.  The date is in
 United States format (month first) and the time of day is based on the 24-hour
 clock (MM/DD/YY HH:MM:SS)."

^self asStringUsingFormat: #(2 1 3 $/ 1 2 $: true false false)
%

category: 'Storing and Loading'
method: ObsoleteDateTime50
writeTo: passiveObj

"Writes the passive form of the receiver into passiveObj, expressed in
 Greenwich Mean Time."

passiveObj writeClass: self class.
self _yearMonthDayGmt do: [:each |  each writeTo: passiveObj].
seconds writeTo: passiveObj.
passiveObj space
%

category: 'Accessing'
method: ObsoleteDateTime50
year

"Returns a SmallInteger that gives the year described by the receiver,
 expressed in local time."

^  (self subtractSeconds: Time gmtOffsetSeconds) yearGmt
%

category: 'Updating'
method: ObsoleteDateTime50
year: aYear

year := aYear.
^ self
%

category: 'Accessing'
method: ObsoleteDateTime50
yearGmt

"Returns a SmallInteger that gives the year described by the receiver, expressed
 in Greenwich Mean Time."

^ year
%

category: 'Deprecated'
method: ObsoleteDateTime50
_monthName: anIndex

"Private.  Returns a String that gives the name, in the user's native language,
 of the month of the year whose numeric index is anIndex.  The index is a number
 between 1 and 12 inclusive, where 1 signifies January."

self deprecated: '_monthName: obsolete, Use the nameOfMonth: method instead (inherited from Date).'.
^ Date nameOfMonth: anIndex
%

category: 'Accessing'
method: ObsoleteDateTime50
_yearMonthDayGmt

"Returns a three-element Array of SmallIntegers containing the year, index of
 the month, and the day of the month represented by the receiver, expressed in
 Greenwich Mean Time."

^ self asDateTime _yearMonthDayGmt.
%

! Class implementation for 'ObsoleteGsFile'

!		Class methods for 'ObsoleteGsFile'

category: 'Instance Creation'
classmethod: ObsoleteGsFile
new

"Disallowed.  This class is obsolete."

self shouldNotImplement: #new
%

!		Instance methods for 'ObsoleteGsFile'

category: 'Accessing'
method: ObsoleteGsFile
mode

"Return the mode instance variable."
^ mode
%

category: 'Accessing'
method: ObsoleteGsFile
pathName

"Return the pathName instance variable."
^ pathName
%

! Class implementation for 'ObsoleteTimeZone2'

!		Class methods for 'ObsoleteTimeZone2'

category: 'querying'
classmethod: ObsoleteTimeZone2
availableZones
 "Returns a sorted Array of Strings which are time zones supported by
  the Olson database shipped in $GEMSTONE/pub/timezone/usr/share/zoneinfo/.
  These Strings may be used as arguments to TimeZone(C)>>named: "
  | res dirs ofs basePath basePathSize |
  res := { } .
  dirs := { (basePath := self _olsonPath , $/)  } .
  basePathSize := basePath size .
  ofs := 1 .
  [ ofs <= dirs size ] whileTrue:[ | list aDir |
    aDir := dirs at: ofs .
    list := GsFile contentsAndTypesOfDirectory: aDir onClient: false .
    1 to: list size by: 2 do:[:n | | elem isFile elemSiz |
      elem := list at: n .  elemSiz := elem size .
      isFile := list at: n + 1 .
      ((elem at: elemSiz) == $. or:[ elem at: elemSiz - 3 equals: '.tab']) ifFalse:[
        isFile ifTrue:[
          (self _isTimeZoneFile: elem) ifTrue:[ | relPath |
            relPath := elem copyFrom: basePathSize + 1 to: elemSiz .
            res add:  relPath
          ].
        ] ifFalse:[ dirs add: elem , $/ ].
      ].
    ].
    ofs := ofs + 1.
  ].
  ^ Array withAll: (SortedCollection withAll: res)
%

category: 'singleton'
classmethod: ObsoleteTimeZone2
current

"Returns the current session's current TimeZoneInfo. E.g. TimeZoneInfo current."

^ System __sessionStateAt: 17.
%

category: 'singleton'
classmethod: ObsoleteTimeZone2
default

	^default.
%

category: 'singleton'
classmethod: ObsoleteTimeZone2
default: aTimeZone

"Makes the specified time zone the default time zone. Returns aTimeZone.
 Must be SystemUser to do so."

aTimeZone _validateClass: TimeZone.
System myUserProfile userId = 'SystemUser' ifFalse:[
  self error:'instance only modifiable by SystemUser'.
  self _uncontinuableError .
].
super default: aTimeZone.
ObsoleteTimeZone default: aTimeZone.  "work-around for #36178"
^aTimeZone.
%

category: 'cache'
classmethod: ObsoleteTimeZone2
for: aPlace

"Returns a TimeZoneInfo object for the specified place if it has been defined
 and stored in the class. Returns nil if it is not defined.
 E.g. TimeZoneInfo for: #'America/Los_Angeles'."

^self cacheAt: aPlace.
%

category: 'cache'
classmethod: ObsoleteTimeZone2
for: aPlace put: aTimeZone

"Stores aTimeZone as the TimeZoneInfo object identified with a particular
 place. A single TimeZoneInfo can be associated with any number of places.
 E.g. TimeZoneInfo for: #'America/Los_Angeles' put: aTimeZone;
 TimeZoneInfo for: #'Europe/Berlin' put: aTimeZone.
 Returns aTimeZone."

self cacheAt: aPlace put: aTimeZone.
^aTimeZone.
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
fromGciPath: pathString
  ^ self _fromPath: pathString onClient: true
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
fromGemPath: pathString
  ^ self _fromPath: pathString onClient: false
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
fromGsFile: aGsFile

	| instance |
	[
		instance := self fromStream: aGsFile.
	] ensure: [
		aGsFile close.
	].
	^instance.
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
fromLinux

	^TimeZone fromGemPath: '/etc/localtime'.
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
fromObsolete: anObsoleteTimeZone
"
TimeZone fromObsolete: ObsoleteTimeZone default.
"
  | res |
  (res := self basicNew) initializeFromObsolete: anObsoleteTimeZone.
  ^ res
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
fromOS

	| osName |
	osName := System gemVersionReport at: #osName.
	osName = 'Linux' ifTrue: [^self fromLinux  ].
	osName = 'SunOS' ifTrue: [^self fromSolaris].
        osName = 'Darwin' ifTrue: [^self fromLinux  ].
	^nil.
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
fromPath: aString

	| block |
	block := [:prefix |
		| path |
		path := prefix , aString.
		(GsFile existsOnServer: path) == true ifTrue: [
			^self fromGemPath: path.
		].
		(GsFile exists: path) == true ifTrue: [
			^self fromGciPath: path.
		].
	].
	block
		value: '';	"full path"
		value: '/usr/share/lib/zoneinfo/';	"Solaris"
		value: '/usr/share/zoneinfo/';		"Linux"
		value: '$GEMSTONE/pub/timezone/usr/share/zoneinfo/' .	"GemStone on linux/unix"
	^nil.
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
fromSolaris

	^TimeZone fromGemPath: '/usr/share/lib/zoneinfo/' , (System gemEnvironmentVariable: 'TZ').
%

category: 'other'
classmethod: ObsoleteTimeZone2
migrateNew

"Override default migrateNew behavior with #_basicNew because
we disallow #new (which is called by Behavior>>migrateNew)."

^ self _basicNew
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
named: aString
  "Return an instance of TimeZone using the specified zone
   from the Olson database shipped in $GEMSTONE/pub/timezone/usr/share/zoneinfo/.
  See TimeZone(C)>>availableZones for legal arguments"

  | f path |
  path := self _olsonPath , $/ , aString .
  f := GsFile openReadOnServer: path .
  f ifNil:[
    Error signal: aString asString,' ' , 'does not specify a TimeZone; ' ,
      GsFile lastErrorString
  ].
  ^ self fromGsFile: f .
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
timeDifferenceHrs: hours dstHrs: dstHrs atTimeHrs: startTimeHrs
fromDayNum: startDay toDayNum: endDay on: nameOfDay beginning: startYear
stdPrintString: stdString dstPrintString: dstString

| oldTZ |
oldTZ := ObsoleteTimeZone
	timeDifferenceHrs: hours
	dstHrs: dstHrs
	atTimeHrs: startTimeHrs
	fromDayNum: startDay
	toDayNum: endDay
	on: nameOfDay
	beginning: startYear
	stdPrintString: stdString
	dstPrintString: dstString.
^self fromObsolete: oldTZ.
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
timeDifferenceMin: minutes dstMin: dstMins atTimeMin: startTimeMins
fromDayNum: startDay toDayNum: endDay on: nameOfDay beginning: startYear
stdPrintString: stdString dstPrintString: dstString

| oldTZ |
oldTZ := ObsoleteTimeZone
	timeDifferenceMin: minutes
	dstMin: dstMins
	atTimeMin: startTimeMins
	fromDayNum: startDay
	toDayNum: endDay
	on: nameOfDay
	beginning: startYear
	stdPrintString: stdString
	dstPrintString: dstString.
^self fromObsolete: oldTZ.
%

category: 'instance creation'
classmethod: ObsoleteTimeZone2
_fromPath: aString onClient: onClient
  | f |
  f := GsFile open: aString mode: 'rb' onClient: onClient .
  f ifNil:[
    Error signal: aString asString,' ' , 'does not specify a TimeZone file; ' ,
      GsFile lastErrorString
  ].
  ^ self fromGsFile: f .
%

category: 'jrivate'
classmethod: ObsoleteTimeZone2
_isTimeZoneFile: aPath

(GsFile openReadOnServer: aPath) ifNotNil:[:f | | str |
  str := String new .
  f read: 4 into: str .
  f close .
  str = 'TZif' ifTrue:[ ^ true ].
].
^ false
%

category: 'private'
classmethod: ObsoleteTimeZone2
_olsonPath
  | path list suffix sufSize |
  path := (GsFile _expandEnvVariable:'GEMSTONE' isClient: false) , '/pub/timezone/usr/share'.
  " use contentsAndTypesOfDirectory on parent of target directory so as to expand symlinks"
  list := GsFile contentsAndTypesOfDirectory: path onClient: false .
  suffix := '/zoneinfo' .
  sufSize := suffix size .
  1 to: list size by: 2 do:[:n | | kind |
    kind := list at: n + 1 .
    kind ifFalse:[ "a directory" | elem |
       elem := list at: n .
       (elem at:(elem size - sufSize + 1) equals: suffix) ifTrue:[ ^ elem].
    ]
  ].
  Error signal:'could not find zoneinfo subdirectory'
%

!		Instance methods for 'ObsoleteTimeZone2'

category: 'accessors'
method: ObsoleteTimeZone2
= aTimeZone

	^(aTimeZone isKindOf: TimeZone)
		and: [self transitions = aTimeZone transitions
		and: [self leapSeconds = aTimeZone leapSeconds
		and: [self standardPrintString = aTimeZone standardPrintString
		and: [self dstPrintString = aTimeZone dstPrintString]]]].
%

category: 'Printing'
method: ObsoleteTimeZone2
asString
  | str |
  str := self standardPrintString .
  (str size == 0 and:[ self secondsFromGmt == 0]) ifTrue:[ str := 'UTC'] .
  ^ str
%

category: 'Updating'
method: ObsoleteTimeZone2
become: anObject

	super become: anObject.
	self initializeCache.
	anObject initializeCache.
%

category: 'legacy protocol'
method: ObsoleteTimeZone2
dateTimeClass

"Returns the class of DateTime objects that are to be created by the
 various methods in this class."

^ DateTime
%

category: 'obsolete accessors'
method: ObsoleteTimeZone2
dayEndDst

	| transition dt |
	transition := self detectLastTransition: [:each | each isDST not].
	dt := transition asDateAndTimeUTC asLocal.
	^dt dayOfYear.
%

category: 'obsolete accessors'
method: ObsoleteTimeZone2
dayStartDst

	| transition dt |
	transition := self detectLastTransition: [:each | each isDST].
	dt := transition asDateAndTimeUTC asLocal.
	dt := dt + (Duration seconds: self secondsForDst negated).
	^dt dayOfYear.
%

category: 'obsolete accessors'
method: ObsoleteTimeZone2
dstEndTimeList

"Returns the dstEndTimeList instance variable."

^ dstEndTimeList
%

category: 'legacy protocol'
method: ObsoleteTimeZone2
dstPrintString

	^dstPrintString.
%

category: 'legacy protocol'
method: ObsoleteTimeZone2
dstPrintString: aString

"Sets the dstPrintString instance variable. Returns the receiver."

dstPrintString := aString.
^ self
%

category: 'obsolete accessors'
method: ObsoleteTimeZone2
dstStartTimeList

"Returns the dstStartTimeList instance variable."

^ dstStartTimeList
%

category: 'queries'
method: ObsoleteTimeZone2
endOfDstFor: aYear

	^ (dstEndTimeList at: aYear otherwise: nil)
		ifNil:[ self endOfDstForA: aYear].
%

category: 'internal'
method: ObsoleteTimeZone2
endOfDstForA: aYear

	| dt transition next |
	dt := DateAndTime year: aYear + 1 day: 1 hour: 0 minute: 0 second: 0.
	[
		(next := self transitionAtUTC: dt) == nil ifTrue: [^nil].
		next = transition ifTrue: [^nil].
		transition := next.
		dt := transition asDateAndTimeUTC.
		dt year ~~ aYear ifTrue: [^nil].
		dt := dt - (Duration seconds: 1).
		transition isDST.
	] whileTrue: [].
	dt := DateTime
		newGmtWithYear: dt year
		month: dt month
		day: dt dayOfMonth
		hours: dt hour
		minutes: dt minute
		seconds: dt second
		timeZone: self.
	^dt addSeconds: 1.
%

category: 'accessors'
method: ObsoleteTimeZone2
hash

	^transitions first hash + standardPrintString hash.
%

category: 'internal'
method: ObsoleteTimeZone2
initialize: aStream

	| transition |
	super initialize: aStream.
	transition := self detectLastTransition: [:each | each isDST].
	dstPrintString := transition == nil
		ifTrue:  ['']
		ifFalse: [transition abbreviation].
	transition := self detectLastTransition: [:each | each isDST not].
	standardPrintString := transition == nil
		ifTrue:  ['']
		ifFalse: [transition abbreviation].
	self initializeCache.
%

category: 'internal'
method: ObsoleteTimeZone2
initializeCache

	dstStartTimeList := IntegerKeyValueDictionary new.
	dstEndTimeList := IntegerKeyValueDictionary new.
	self
		populateCacheFor: (1950 to: 2050);
		"_yearStartDst;
		_secondsForDst;
		_secondsFromGmt;"
		yourself.
%

category: 'internal'
method: ObsoleteTimeZone2
initializeFromObsolete: anObsoleteTimeZone

	| base startArray endArray old new |
	base := (DateTime newWithYear: 1970 dayOfYear: 1 seconds: 0) asSeconds.
	transitions := OrderedCollection new.
	standardPrintString := anObsoleteTimeZone standardPrintString.
	dstPrintString := anObsoleteTimeZone dstPrintString.
	startArray := { {
		anObsoleteTimeZone secondsFromGmt + anObsoleteTimeZone secondsForDst .
		true .
		dstPrintString } } .
	endArray := { {
		anObsoleteTimeZone secondsFromGmt .
		false .
		standardPrintString } } .
	anObsoleteTimeZone secondsForDst = 0 ifTrue: [
		| year trTim transition |
		year := (anObsoleteTimeZone yearStartDst max: 1900) printString.
		trTim := (DateTime fromStringGmt: '01/01/' ,  year , ' 00:00:00' ) asSecondsGmt - base.
		(transition := TimeZoneTransition new)
			localTimeTypeID: 1;
			transitionTime: trTim ;
			typeList: endArray.
		transitions add: transition.
		self initializeCache.
		^self.
	].
	anObsoleteTimeZone yearStartDst to: 2030 do: [:year |
		| endDateTime startSec endSec start end |
		startSec := (anObsoleteTimeZone startOfDstFor: year) asSecondsGmt - base.
		(start := TimeZoneTransition new)
			localTimeTypeID: 1;
			transitionTime: startSec;
			typeList: startArray.
		(endDateTime := anObsoleteTimeZone endOfDstFor: year) ifNil: [
			transitions add: start.
		] ifNotNil: [
			endSec := endDateTime asSecondsGmt - base.
			(end := TimeZoneTransition new)
				localTimeTypeID: 1;
				transitionTime: endSec;
				typeList: endArray.
			start transitionTimeUTC < end transitionTimeUTC ifTrue: [
				transitions add: start; add: end.
			] ifFalse: [
				transitions add: end; add: start.
			].
		].
	].
	transitions := transitions asArray.
	self initializeCache.

	old := anObsoleteTimeZone.
	new := self.
  TimeZone current ifNotNil:[
	  anObsoleteTimeZone yearStartDst to: 2030 do: [:year |
		  | oldStart oldEnd newStart newEnd |
		  oldStart := old startOfDstFor: year.
		  newStart := new startOfDstFor: year.
		  oldEnd   := old endOfDstFor:   year.
		  newEnd   := new endOfDstFor:   year.
		  oldStart = newStart ifFalse: [self error: 'start date calculation error',
           oldStart asString , ', ' , newStart asString ].
		  oldEnd   = newEnd   ifFalse: [self error: 'end date calculation error ',
		     oldEnd asString , ', ' , newEnd asString ].
	  ].
  ]
%

category: 'singleton'
method: ObsoleteTimeZone2
installAsCurrentTimeZone

"Sets the receiver as the current session's current Timezone. Returns the
 receiver."

System __sessionStateAt: 17 put: self.
^ self.
%

category: 'accessors'
method: ObsoleteTimeZone2
leapSeconds

	^leapSeconds.
%

category: 'Instance Migration'
method: ObsoleteTimeZone2
migrateFrom: anotherObject instVarMap: otherivi

	super migrateFrom: anotherObject instVarMap: otherivi.
	self
		_yearStartDst;
		_secondsForDst;
		_secondsFromGmt;
		yourself.
%

category: 'internal'
method: ObsoleteTimeZone2
populateCacheFor: anInterval

	anInterval do: [:year |
		dstStartTimeList
			at: year
			put: (self startOfDstForA: year).
		dstEndTimeList
			at: year
			put: (self endOfDstForA: year).
	].
%

category: 'obsolete accessors'
method: ObsoleteTimeZone2
secondsForDst

	| isDST isNotDST |
	isDST := self detectLastTransition: [:each | each isDST].
	isDST == nil ifTrue: [^0].
	isNotDST := self detectLastTransition: [:each | each isDST not].
	isNotDST == nil ifTrue: [^0].
	^isDST offsetFromUTC - isNotDST offsetFromUTC.
%

category: 'obsolete accessors'
method: ObsoleteTimeZone2
secondsFromGmt

	| transition |
	transition := self detectLastTransition: [:each | each isDST not].
	^transition == nil
		ifTrue: [0]
		ifFalse: [transition offsetFromUTC].
%

category: 'legacy protocol'
method: ObsoleteTimeZone2
shouldWriteInstVar: instVarName

"Returns whether the given instance variable should be written out."

"exclude the ditionaries"

instVarName == #dstStartTimeList ifTrue:[ ^ false ].
instVarName == #dstEndTimeList ifTrue:[ ^ false ].
^ true
%

category: 'legacy protocol'
method: ObsoleteTimeZone2
standardPrintString

	standardPrintString == nil ifTrue: [
		standardPrintString := (self detectLastTransition: [:each | each isDST not]) abbreviation.
	].
	^standardPrintString.
%

category: 'legacy protocol'
method: ObsoleteTimeZone2
standardPrintString: aString

"Sets the standardPrintString instance variable. Returns the receiver."

standardPrintString := aString.
^ self
%

category: 'queries'
method: ObsoleteTimeZone2
startOfDstFor: aYear

	^ ( dstStartTimeList at: aYear otherwise: nil)
		ifNil:[ self startOfDstForA: aYear ].
%

category: 'internal'
method: ObsoleteTimeZone2
startOfDstForA: aYear

	| dt transition next |
	dt := DateAndTime year: aYear + 1 day: 1 hour: 0 minute: 0 second: 0.
	[
		(next := self transitionAtUTC: dt) == nil ifTrue: [^nil].
		next = transition ifTrue: [^nil].
		transition := next.
		dt := transition asDateAndTimeUTC.
		dt year ~~ aYear ifTrue: [^nil].
		dt := dt - (Duration seconds: 1).
		transition isDST not.
	] whileTrue: [
	].
	dt := DateTime
		newGmtWithYear: dt year
		month: dt month
		day: dt dayOfMonth
		hours: dt hour
		minutes: dt minute
		seconds: dt second
		timeZone: self.
	^dt addSeconds: 1.
%

category: 'obsolete accessors'
method: ObsoleteTimeZone2
timeStartDst

	| transition dt |
	transition := self detectLastTransition: [:each | each isDST].
	dt := transition asDateAndTimeUTC - (Duration seconds: 1).
	dt := DateAndTime
		secondsUTC: dt asSeconds
		offset: (Duration seconds: (self offsetAtUTC: dt)).
	^dt hour * 60 + dt minute * 60 + dt second + 1.
%

category: 'accessors'
method: ObsoleteTimeZone2
transitions

	^transitions.
%

category: 'obsolete accessors'
method: ObsoleteTimeZone2
weekDayStartDst

	| transition year dateTime date |
	transition := self detectLastTransition: [:each | each isDST].
	year := transition asDateAndTimeUTC year.
	dateTime := self startOfDstFor: year.
	dateTime := dateTime addSeconds: self secondsForDst negated.
	date := dateTime asDateIn: self.
	^date weekDayName asSymbol.
%

category: 'obsolete accessors'
method: ObsoleteTimeZone2
yearStartDst
	"calculate and save in cache"

	| transition |
	transition := transitions
		detect: [:each | each isDST]
		ifNone: [self error: 'DST is not observed in this TimeZone (see bugnote for 36401)!'].
	^transition asDateAndTimeUTC year.
%

! Class extensions for 'Activation'

!		Class methods for 'Activation'

removeallmethods Activation
removeallclassmethods Activation

category: 'Instance Creation'
classmethod: Activation
new

"Disallowed."

self shouldNotImplement: #new
%

!		Instance methods for 'Activation'

category: 'Copying'
method: Activation
copy

"Disallowed."

self shouldNotImplement: #copy
%

! Class extensions for 'Block'

!		Instance methods for 'Block'

removeallmethods Block
removeallclassmethods Block

category: 'Copying'
method: Block
copy

   "Obsolete"
   self _error: #rtErrObsolete args: #(#copy) .
   self _uncontinuableError

%

category: 'Flow of Control'
method: Block
untilFalse

   "Obsolete"
   self _error: #rtErrObsolete args: #(#untilFalse) .
   self _uncontinuableError

%

category: 'Flow of Control'
method: Block
untilTrue

   "Obsolete"
   self _error: #rtErrObsolete args: #(#untilTrue) .
   self _uncontinuableError

%

category: 'Block Evaluation'
method: Block
value

   "Obsolete"
   self _error: #rtErrObsolete args: #(#value) .
   self _uncontinuableError

%

category: 'Block Evaluation'
method: Block
value: anObject

   "Obsolete"
   self _error: #rtErrObsolete args: #(#value:) .
   self _uncontinuableError
%

category: 'Block Evaluation'
method: Block
value: firstObject value: secondObject

   "Obsolete"
   self _error: #rtErrObsolete args: #(#value:value:) .
   self _uncontinuableError

%

category: 'Block Evaluation'
method: Block
value: firstObject value: secondObject value: thirdObject

   "Obsolete"
   self _error: #rtErrObsolete args: #(#value:value:value:) .
   self _uncontinuableError

%

category: 'Block Evaluation'
method: Block
valueWithArguments: argList

   "Obsolete"
   self _error: #rtErrObsolete args: #(#valueWithArguments:) .
   self _uncontinuableError

%

category: 'Flow of Control'
method: Block
whileFalse: aBlock

   "Obsolete"
   self _error: #rtErrObsolete args: #(#whileFalse:) .
   self _uncontinuableError

%

category: 'Flow of Control'
method: Block
whileTrue: aBlock

   "Obsolete"
   self _error: #rtErrObsolete args: #(#whileTrue:) .
   self _uncontinuableError

%

category: 'Storing and Loading'
method: Block
writeTo: aPassiveObject

   "Obsolete"
   self _error: #rtErrObsolete args: #(#writeTo:) .
   self _uncontinuableError
%

category: 'Accessing'
method: Block
_initialPC

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_initialPC) .
   self _uncontinuableError

%

category: 'Accessing'
method: Block
_nargs

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_nargs) .
   self _uncontinuableError

%

category: 'Accessing'
method: Block
_report

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_report) .
   self _uncontinuableError

%

category: 'Accessing'
method: Block
_tempAt: anIndex

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_tempAt:) .
   self _uncontinuableError

%

! Class extensions for 'ComplexBlock'

!		Class methods for 'ComplexBlock'

removeallmethods ComplexBlock
removeallclassmethods ComplexBlock

category: 'Disassembly'
classmethod: ComplexBlock
_cost

^ 2

%

!		Instance methods for 'ComplexBlock'

category: 'Accessing'
method: ComplexBlock
selfValue

"Returns the value of the instance variable selfValue."

^ selfValue
%

category: 'Accessing'
method: ComplexBlock
staticLink

"Returns the value of the instance variable staticLink."

^ staticLink
%

category: 'Block Evaluation'
method: ComplexBlock
value

"Return the value of the receiver evaluated with no arguments.
 If the block expects any arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: anObject

"Return the value of the receiver evaluated with anObject as its argument.  If
 the block expects a different number of arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: firstObject value: secondObject

"Return the value of the receiver evaluated with the two objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: firstObject value: secondObject value: thirdObject

"Return the value of the receiver evaluated with the three objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: first value: second value: third value: fourth

"Return the value of the receiver evaluated with the four objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: first value: second value: third value: fourth value: fifth

"Return the value of the receiver evaluated with the five objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
valueWithArguments: argList

"Return the value of the receiver evaluated with the elements of the Array
 argList as arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Accessing'
method: ComplexBlock
_sourceString

"Returns a String that will create a block similar to the receiver when
 the string is compiled.  References to variables in other contexts or
 to the pseudovariable 'self' will not recompile properly if the source
 string is used to create a new block similar to the receiver."

| result tempsArr lnk atemps |
result := String new.
result addAll: '"This is source for a ComplexBlock.  If there are
references to ''self'', or if non-block temporaries are used that
are not initialized in the block, it may not recreate a useful
block"
 | '.
"fold the arguments and temporaries of surrounding scopes together - the scopes
 won't be there if the source is used to create a new block, so duplicates
 must be eliminated"
tempsArr := { } .
atemps := method argsAndTemps .
atemps ~~ nil ifTrue: [
  tempsArr addAll: atemps
  ].
lnk := staticLink.
[ lnk ~~ nil ] whileTrue: [
  lnk := lnk at: 1.
  (lnk isKindOf: ComplexVCBlock) ifTrue: [
    atemps := lnk argsAndTemps .
    atemps ~~ nil ifTrue: [
      atemps do: [:a | (tempsArr includesValue: a) ifFalse: [ tempsArr add: a ] ].
      ].
    lnk := lnk staticLink.
    ]
  ifFalse: [
    lnk := nil
    ].
  ].
tempsArr do: [:e |
  result addAll: e; add: $ .
  ].
result addAll: '|
^' .

result addAll:( method _sourceString copyFrom: firstSourceOffset to: lastSourceOffset) .
^result
%

! Class extensions for 'ComplexVCBlock'

!		Class methods for 'ComplexVCBlock'

removeallmethods ComplexVCBlock
removeallclassmethods ComplexVCBlock

category: 'Disassembly'
classmethod: ComplexVCBlock
_cost

^ 3

%

! Class extensions for 'EUCString'

!		Class methods for 'EUCString'

removeallmethods EUCString
removeallclassmethods EUCString

category: 'Formatting'
classmethod: EUCString
charSize

"Returns the number of bytes that make up a character"
^1
%

!		Instance methods for 'EUCString'

category: 'Formatting'
method: EUCString
charSize

"Returns the number of bytes that make up a character"
^1
%

category: 'Accessing'
method: EUCString
codePointAt: anIndex

"Returns the jisValue of the JISCharacter at the specified index."

<primitive: 244>

(anIndex _isSmallInteger)
ifTrue:[ ^ self _errorIndexOutOfRange: anIndex]
ifFalse:[^ self _errorNonIntegerIndex: anIndex].

self _primitiveFailed: #codePointAt: args: { anIndex } .
self _uncontinuableError
%

category: 'Accessing'
method: EUCString
size

"Returns the number of JISCharacters in the receiver."

<primitive: 76>

self _primitiveFailed: #size .
self _uncontinuableError
%

! Class extensions for 'ExecutableBlock'

!		Class methods for 'ExecutableBlock'

removeallmethods ExecutableBlock
removeallclassmethods ExecutableBlock

category: 'Storing and Loading'
classmethod: ExecutableBlock
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| src result marker meth o symbolList |

"Returns a new instance of the receiver read from the given PassiveObject"

marker := passiveObj objectPositionMarker.
src := passiveObj readObject.
symbolList := GsCurrentSession currentSession symbolList .
meth := src _compileInContext: (o := Object new) symbolList: symbolList.
result := meth _executeInContext: o.
(result == nil or: [(result isKindOf: ExecutableBlock) not]) ifTrue: [
  "error in compiling"
  self _halt: 'Error in recreating a ' , name.
  ^nil
  ]
ifFalse: [
  passiveObj hasRead: result marker: marker.
  ^result
  ]
%

category: 'Reloading Decompiled Methods'
classmethod: ExecutableBlock
_with: anArray

"For use only when recreating blocks from decompiled methods.  Other
 use may cause incorrect execution of the GemStone Smalltalk virtual machine."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

!		Instance methods for 'ExecutableBlock'

category: 'Accessing'
method: ExecutableBlock
argsAndTemps

"Return the value of the argsAndTemps instance variable."

^argsAndTemps
%

category: 'Accessing'
method: ExecutableBlock
argumentCount
	"A SelectBlock can only take one argument."

	^self numberArgs.
%

category: 'Block Evaluation'
method: ExecutableBlock
ensure: aBlock
"Evaluate the receiver.  Evaluate aBlock after evaluating the receiver,
 or before any return from a block that would return to the sender."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Accessing'
method: ExecutableBlock
firstPC

"Return the value of the firstPC instance variable."

^firstPC
%

category: 'Accessing'
method: ExecutableBlock
firstSourceOffset

"Return the value of the firstSourceOffset instance variable."

^firstSourceOffset
%

category: 'Processes - Blue Book'
method: ExecutableBlock
fork
  "forks the receiver as a new process at the current scheduling priority"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Processes - Blue Book'
method: ExecutableBlock
forkAt: priority
  "forks the receiver as a new process at the given priority"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Processes'
method: ExecutableBlock
forkAt: priority with: blockArgs
  "forks the receiver as a new process at the given priority"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Processes'
method: ExecutableBlock
forkWith: blockArgs
  "forks the receiver as a new process at the current scheduling priority"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Accessing'
method: ExecutableBlock
lastSourceOffset

"Return the value of the lastSourceOffset instance variable."

^lastSourceOffset
%

category: 'Accessing'
method: ExecutableBlock
method

"Return the value of the method instance variable."

^method
%

category: 'Processes - Blue Book'
method: ExecutableBlock
newProcess
  "creates a new process holding the receiver"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Processes - Blue Book'
method: ExecutableBlock
newProcessWith: argArray
  "creates a new process holding the receiver to be evaluated with the
   given arguments"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Accessing'
method: ExecutableBlock
numberArgs

"Return the value of the numberArgs instance variable."

^numberArgs
%

category: 'Accessing'
method: ExecutableBlock
numberTemps

"Return the value of the numberTemps instance variable."

^numberTemps
%

category: 'Block Evaluation'
method: ExecutableBlock
on: selector do: action

	"Try to evaluate the receiver, and should an exception occur which is matched
	by selector (normally a class object which is a subclass of ExceptionA but can
	also be an ExceptionSet instance with subclasses of ExceptionA or any other
	object that matches the protocol defined for an ExceptionSelector), evaluate the
	<monadicBlock>, action, passing it the exception instance as its argument."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ExecutableBlock
onException: selector do: action

	"Try to evaluate the receiver, and should an exception occur which is matched
	by selector (normally a class object which is a subclass of ExceptionA but can
	also be an ExceptionSet instance with subclasses of ExceptionA or any other
	object that matches the protocol defined for an ExceptionSelector), evaluate the
	<monadicBlock>, action, passing it the exception instance as its argument."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Flow of Control'
method: ExecutableBlock
untilFalse

"(Reserved selector.)  Evaluates the receiver repeatedly until the evaluation's
 result is false.  Return nil.  Generates an error if the receiver is not a
 zero-argument block."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Flow of Control'
method: ExecutableBlock
untilTrue

"(Reserved selector.)  Evaluates the receiver repeatedly until the evaluation's
 result is true.  Return nil.  Generates an error if the receiver is not a
 zero-argument block."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Obsolete'
method: ExecutableBlock
valueNowOrOnUnwindDo: aBlock
"Obsolete in GemStone/64. Use ensure: instead."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Flow of Control'
method: ExecutableBlock
whileFalse: aBlock

"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
 while the receiver evaluates to false.  Return nil.  Generates an error if the
 receiver is not a zero-argument block."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Flow of Control'
method: ExecutableBlock
whileTrue: aBlock

"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
 while the receiver evaluates to true.  Return nil.  Generates an error if the
 receiver is not a zero-argument block."

"The following is a control structure optimization, not a recursive send."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Storing and Loading'
method: ExecutableBlock
writeTo: aPassiveObject

"Converts the receiver to its passive form and writes that information on
 aPassiveObject.

 SimpleBlocks can usually be passivated and then reactivated.  ComplexBlocks
 can be passivated but may have to be massaged to be reactivated.  References
 to 'self' in complex blocks will resolve to an instance of Object when the
 block is activated, and any arguments or temporaries from enclosing scopes
 will be nil."

aPassiveObject writeClass: self class.
aPassiveObject writeObject: self _sourceString; cr
%

category: 'Decompiling without Sources'
method: ExecutableBlock
_asSource

"return a stripped source representation of the block."

| result |
result := String new.
result addAll: self class name ;
  addAll: ' _with: #( ' ;
      "method will be supplied at regeneration time, so we skip it."
  addAll: firstPC asString ; add: $  ;
  addAll: numberArgs asString ; add: $  ;
  addAll: numberTemps asString ; add: $  ;
    "firstSourceOffset regenerated as 1"
    "lastSourceOffset regenerated as 1"
    "argsAndTemps regenerated as nil "
  addAll: ' ) ' .

^ result
%

category: 'Private'
method: ExecutableBlock
_gbsTraversalCallback

"Private.  When GemBuilder Smalltalk traverses an ExecutableBlock, this method
 is called to place the block's source string in the traversal buffer."

^self _sourceString
%

category: 'Private'
method: ExecutableBlock
_gsReturnNoResult

"Returns from the block with no result left on the GemStone Smalltalk stack."

"To be sent only by the method _valueOnUnwind.
 Any other use corrupts the virtual machine's stack.  This is a special
 selector in Object and is optimized by the compiler."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Reloading Decompiled Methods'
method: ExecutableBlock
_initialize: anArray

"For use only when recreating blocks from decompiled methods.  Other
 use may cause incorrect execution of the GemStone Smalltalk virtual machine."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Private'
method: ExecutableBlock
_installAsUnwindBlock

"Install the receiver as an unwind block."

"The sender must be executing with a VariableContext; if not, the
 primitive will fail."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Reloading Decompiled Methods'
method: ExecutableBlock
_method: aGsMethod

"For use only when recreating blocks from decompiled methods.  Other
 use may cause incorrect execution of the GemStone Smalltalk virtual machine."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Modification Tracking'
method: ExecutableBlock
_setModificationTrackingTo: tracker

"Private.

 No modification tracking is required for blocks,
 even if they are not invariant."

^self
%

category: 'Accessing'
method: ExecutableBlock
_sourceString

"(Subclass responsibility.)"

^ ExecutableBlock subclassResponsibility: #_sourceString
%

category: 'Private'
method: ExecutableBlock
_valueOnUnwind

"This method should be invoked only from within the virtual machine. Other
 use from a Smalltalk program will corrupt the Smalltalk execution
 stack."

"Used to implement valueNowOrOnUnwind:"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

! Class extensions for 'GsMethod'

!		Class methods for 'GsMethod'

removeallmethods GsMethod
removeallclassmethods GsMethod

category: 'Instance Creation'
classmethod: GsMethod
new

"Disallowed.  You cannot create new instances of GsMethod."

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: GsMethod
new: anInteger

"Disallowed.  You cannot create new instances of GsMethod."

self shouldNotImplement: #new:
%

category: 'Debugging Support'
classmethod: GsMethod
_addMarkerIds: anArray

""

| placesMarked markerLine markerLineSize space addToEnd markPosition
  aStr neededSize subStr |

placesMarked:= anArray at: 1.
markerLine:= anArray at: 2.
space:= Character space.

"have the source marked at each error with ^; now add marker identifier"
addToEnd:= false.
1 to: (placesMarked size) do: [:i |
   markPosition:= (placesMarked at: i) at: 1.
   aStr:= ((placesMarked at: i) at: 2) asString.
   neededSize:= markPosition + aStr size.
   markerLineSize := markerLine size .
   (markerLineSize < neededSize) ifTrue: [
       markerLine size: neededSize.
       markerLineSize + 1 to: neededSize do: [:k | markerLine at: k put: space].
       markerLineSize:= neededSize.
   ].

   (addToEnd) ifFalse: [
      subStr:= markerLine copyFrom: markPosition + 1
                                to: (markPosition + aStr size).
      subStr do: [:each | (each == $ ) ifFalse: [addToEnd := true]].
   ].
   (addToEnd) ifTrue: [
       markerLine add: aStr.
       (i == placesMarked size) ifFalse: [ markerLine add: ',']
   ] ifFalse: [  | destIdx |
      destIdx := markPosition + 1 .
      markerLine replaceFrom: destIdx to: destIdx + aStr size - 1 with: aStr startingAt: 1 .
   ]
].
(68 - markerLine size) timesRepeat:[ markerLine add: $ ].
(75 - markerLine size) timesRepeat:[ markerLine add: $* ] .
markerLine add: Character lf.
^ true
%

category: 'Debugging Support'
classmethod: GsMethod
_buildMarkedSourceFrom: sourceStr sourceSize: aSize markers: markerArray

"Given a source string, its size (passed in for efficiency), and a marker
 Array, returns an instance of sourceStr's class containing the marked source."

| lineFeed tab space
  placesMarked     "an Array of markers marked on the current line"
  markerLineIndex "index into the current marker line"
  result          "the result of this method"
  markerLine      "the current marker line"
  aChar           "one Character of the source"
  displayWidth    "the number of positions it takes to display aChar"
  lineSz
|

"initialize"
lineFeed := Character lf.
tab:= Character tab.
space:= Character space.

placesMarked:= { } .
markerLineIndex:= 1.
result:= sourceStr class new .
result addAll: '   ' .
lineSz := 0 .
markerLine:= String new .
markerLine add: $  .
1 to: aSize do: [:i |
   aChar:= sourceStr at: i.  "fetch a char"
   displayWidth:= aChar displayWidth.

   "Add the char to the result"
   (aChar == tab)
   ifTrue: [
      displayWidth:= 8 - (lineSz \\ 8).
      displayWidth timesRepeat: [result add: space].
      lineSz := lineSz + displayWidth .
   ]
   ifFalse: [
      result add: aChar.
      lineSz := lineSz + displayWidth .
      ((i == aSize) and: [aChar ~~ lineFeed]) ifTrue: [
        result add: lineFeed .
      ].
   ].

   ((markerArray at: i) == nil) "no marker at this position"
   ifTrue: [
      displayWidth timesRepeat: [markerLine add: space].
   ]
   ifFalse: [ "found an error at this position"
      placesMarked add: { markerLineIndex + 1 . markerArray at: i }.
      markerLine add: $^ .
      displayWidth - 1 timesRepeat: [markerLine add: space].
   ].
   markerLineIndex:= markerLineIndex + displayWidth.

   ((aChar == lineFeed) or: [i == aSize])
   ifTrue: [ "we are at end of line"
      "add error identifiers to marker line "
      (placesMarked size ~~ 0) ifTrue: [
         self _addMarkerIds: { placesMarked . markerLine . markerLineIndex }.
         result add: $  ; add: $* .
         result add: markerLine.
         ] .

      (i == aSize) ifFalse: [
         result addAll: '   ' .
         lineSz := 0 .
      ].
      markerLine size: 1.
      markerLineIndex:= 1.
      placesMarked size: 0.
   ]
].
^result
%

category: 'Debugging Support'
classmethod: GsMethod
_buildMarkersFrom: sourceOffsets ofSize: sizeArg

"Given an Array of source offsets, build an Array of size sizeArg containing
 the index into anArray at the position corresponding to anArray's element.
 The remainder of the Array contains nil.  Negative offsets denote disabled
 breakpoints."

| markerArray anOffset posOffset aSize |
aSize := 1 max: sizeArg .                          "fix bug 14976"
markerArray:= Array new: aSize.
1 to: sourceOffsets size do: [:i |
  anOffset := sourceOffsets at: i .
  anOffset == nil ifFalse:[
    posOffset:= (anOffset abs max: 1) min: aSize.  "limit within range"
    (markerArray at: posOffset) == nil ifTrue:[
       anOffset < 0 ifTrue:[ markerArray at: posOffset put: i negated ]
		    ifFalse:[ markerArray at: posOffset put: i ]
       ]
    ]
  ].
^markerArray
%

category: 'Debugging Support'
classmethod: GsMethod
_sourceWithErrors: compilerError fromString: aString

"This method returns an instance of aString's class containing the text in a
 string with compiler errors marked, plus the error text for each error.

 The argument compilerError is the result Array from either the
 Behavior | compileMethod:dictionaries:category:  method or the
 GsMethod | _recompileWithSource: method.

 The argument aString is the source string which was an input to either the
 Behavior | compileMethod:dictionaries:category: method or the
 GsMethod | _recompileWithSource: method."

| lineFeed result aStringSize offsets errNumbers thisErr pos
  markerArray errDict errMsgs auxMsgs errsz |

"initialize"
lineFeed := Character lf.
"only ask for source size once for efficiency for Japanese"
aStringSize:= aString size.
offsets := Array new: (errsz := compilerError size) .
errNumbers := Array new: errsz .
errMsgs := Array new: errsz .
auxMsgs := Array new: errsz .

"get an Array of source offsets with errors, and an Array of error numbers"
1 to: errsz do: [:i |
   thisErr := compilerError at: i.
   offsets at: i put: (thisErr at: 2 "source offset").
   errNumbers at: i put: (thisErr at: 1 "error number") .
   thisErr size >= 3 ifTrue:[
     errMsgs at: i put: (thisErr at: 3"error message String") .
     thisErr size >= 4 ifTrue:[
       auxMsgs at: i put: (thisErr at: 4 "additional message text")
       ].
     ].
   ].

"build an Array parallel to the source that contains nil if no error at
 that source position, and an index into offsets if there is an error at
 that source position"
markerArray:= self _buildMarkersFrom: offsets ofSize: aStringSize.

result:= self _buildMarkedSourceFrom: aString
                          sourceSize: aStringSize
                             markers: markerArray.

"add error strings"
errDict := GemStoneError at: System myUserProfile nativeLanguage.
1 to: errNumbers size do: [:i | | msg |
  result add: lineFeed.
  result addAll: i asString.
  result addAll: ': ['.
  pos := errNumbers at: i.
  result addAll: pos asString.
  result addAll: '] '.
  msg := errMsgs at: i .
  msg == nil ifTrue:[
    pos > errDict size
      ifTrue: [ msg := '(unknown error number)']
      ifFalse: [ msg := (errDict at: pos) asString].
    ].
  result addAll: msg .
  (auxMsgs at: i) ~~ nil ifTrue:[ result addAll: (auxMsgs at: i) ].
  ].
result add: lineFeed.

^result
%

!		Instance methods for 'GsMethod'

category: 'Accessing'
method: GsMethod
argsAndTemps

"Returns an Array of Symbols which are the names of arguments and
 temporaries for this method."

| offset numArgsTmps |
numArgsTmps := self _numArgsAndTemps .
numArgsTmps < 1 ifTrue:[ ^  #()  ].

offset := self _debugInfoHeaderSize + 1.
^ debugInfo copyFrom: offset to: (offset + numArgsTmps - 1)
%

category: 'Disassembly'
method: GsMethod
blockLiterals

"return an Array of Block Literals that the receiver contains,
 or nil if the receiver contains no block literals.
 literals of for select blocks are not included."

| pc blockLits |

"virtual machine constants"
pc := 1 .

"iterate over the instructions in the method. pc here is 1 based,
 literalsOffset is zero based."
[pc <= literalsOffset ] whileTrue:[ | aWord info |
  aWord := self at: pc .
  info := self _opcodeInfo: aWord .
  (info bitAnd: 16r2000000) ~~ 0 ifTrue:[
    blockLits == nil ifTrue:[ blockLits := { }  ].
    blockLits addLast: ( self at: pc + 1 ).  "a block literal"
    ].

  "advance to the next instruction."
  pc := pc + (info bitAnd: 16rFF)
  ].
^ blockLits
%

category: 'Copying'
method: GsMethod
copy

"Disallowed.  You may not create new instances of GsMethod."

self shouldNotImplement: #copy
%

category: 'Accessing'
method: GsMethod
environmentId
  "Return a SmallInteger,
   the 8 bit unsigned compilation environment identifier of this method."

  ^ 0
%

category: 'Repository Conversion'
method: GsMethod
fixRefsAfterConversion

"Default method for fixing references to ObsLargePositiveInteger and
 ObsLargeNegativeInteger instances that can now be represented as
 a SmallInteger and Floats and SmallFloats which can now be represented
 as a SmallDouble.

 Has no effect in this release since all GsMethod's must be recompiled
  to produce GsNMethod's ."

^true
%

category: 'Disassembly'
method: GsMethod
hasBlockLiteralsOfCost: aBlockClass

"Return true if the receiver contains a block as costly as, or
 more costly than aBlockClass, return false otherwise.

 For the purposes of this analysis, the block classes are considered
 to have this hierarchy:
    ComplexVCBlock   cost == 3 .
      ComplexBlock   cost == 2 .
        SimpleBlock  cost == 1 .

 Note that the actual implementation hierarchy of the block classes is
    ExecutableBlock
    ComplexBlock
      ComplexVCBlock
    SimpleBlock  "

| pc argCost |

"virtual machine constants"
pc := 1 .
argCost := aBlockClass _cost .

"iterate over the instructions in the method. pc here is 1 based,
 literalsOffset is zero based."
[pc <= literalsOffset ] whileTrue:[ | info aWord |
  aWord := self at: pc .
  info := self _opcodeInfo: aWord .
  (info bitAnd: 16r2000000) ~~ 0 ifTrue:[ | aBlockLit |
    aBlockLit :=  self at: pc + 1 .  "a block literal"
    aBlockLit class _cost >= argCost ifTrue:[ ^ true ].
    ].

  "advance to the next instruction."
  pc := pc + (info bitAnd: 16rFF)
  ].
^ false
%

category: 'Accessing'
method: GsMethod
inClass

"Returns the class in which the receiver was compiled."

selector == nil ifTrue:[ ^ nil "anonymous method, as from GciExecute" ].
^ inClass
%

category: 'Disassembly'
method: GsMethod
instVarsAccessed

"return a Set of instVarNames that the method accesses."

| pc report  |

"virtual machine constants"
pc := 1 .
report := SymbolSet new .

"iterate over the instructions in the method. pc here is 1 based,
 literalsOffset is zero based."
[pc <= literalsOffset ] whileTrue:[ | aWord info ivOffset |
  aWord := self at: pc .
  info := self _opcodeInfo: aWord .
  (info bitAnd: 16r1000000) ~~ 0 ifTrue:[
    "get zero-based instance variable offset"
    ivOffset := (info bitAnd: 16rFFFF00) bitShift: -8 .
    report add: (inClass _instVarNames at: (ivOffset + 1) ).
    ].
  "advance to the next instruction."
  pc := pc + (info bitAnd: 16rFF) .
  ].
^ report
%

category: 'Reporting'
method: GsMethod
isSenderOf: aSymbol

"Returns true if the receiver sends the message aSymbol.  Returns false
 otherwise."

1 to: literalsOffset - 1 do:[:j |
  (self at: j) == aSymbol ifTrue:[ ^ true ].
  ].
^ false
%

category: 'Accessing'
method: GsMethod
literals

"Returns an Array containing the literal pool of the receiver."

| y |

y := { } .
literalsOffset to: self size do: [:i |
  y add: (self at: i)
  ].
^y
%

category: 'Accessing'
method: GsMethod
literalsOffset

"Returns the value of the instance variable named literalsOffset."

^ literalsOffset
%

category: 'Accessing'
method: GsMethod
loadedSizeBytes

 "Return the number of bytes of memory that the receiver will
  occupy when loaded in memory."

  "header + namedIvs = 3 + 9 = 12 words"
  "don't count send-caches, GsMethod is obsolete and not executable."

  ^ (12 + self size) * 8
%

category: 'Accessing'
method: GsMethod
methodCompilerVersion

"Returns the method compiler version.
 2 indicates a method compiled by Gs64 v2.0 or above method compiler,
 1 indicates a method compiled in a previous version and processed by
   repository conversion.

 Any other value indicates a method from a previous version that
 did not get converted.  However the faulting-in of such a method
 will cause an error 2261, so normally you can't send this message
 to such unconverted methods."

"extract bottom 8 bits as a unsigned value"
^ invocationCount bitAnd: 16rFF
%

category: 'Accessing'
method: GsMethod
numArgs

"Returns the value of the instance variable named numArgs."

^ numArgs
%

category: 'Pragmas'
method: GsMethod
pragmas
    self inClass == nil ifTrue: [ ^#() ].
    ^self inClass pragmasForMethod: self selector
%

category: 'Repository Conversion'
method: GsMethod
recompile

"Recompiles the method for execution in a Gs64 v3.0 or later system.
 Returns a GsNMethod, or signals a CompileError or CompileWarning .

 See also  recompileIntoMethodDict:intoCategories: "

^ self recompileIntoMethodDict: nil intoCategories: nil
%

category: 'Repository Conversion'
method: GsMethod
recompileIntoMethodDict: aMethodDict intoCategories: aCategDict

"Recompiles the method for execution in a Gs64 v3.0 or later system.

 Literal variables whose key is in the GsMethod class variable ObsoleteClassesDict
 are replaced by the appropriate association from the ObsoleteClassesDict .
 Other literal variables are looked up in the literal pool of the receiver,
 before searching class variables, class pool dictionaries, or
 the current symbolList.  Thus recompilation should work without knowing
 what symbolList was used when the receiver was created.

 The result is a GsNMethod if compilation succeeds, otherwise
 an error is generated.  environmentId zero is used for all compilations.

 If aMethodDict is not nil, and the compilation succeeds,
 the resulting method is added to aMethodDict instead of to
 the receiver's method dictionary.  This is used to add methods
 to per-session dictionaries.

 If aMethodDict is not nil and aCategDict is not nil and
 the compilation succeeds, the resulting method is added aCategDict
 instead of the receiver's categories.

 If the receiver is an anonymous method, the sender of this method is
 reponsible for saving the result."

| cls litVars symAssocCls obsDict newSrc |
litVars := { }  .
symAssocCls := SymbolAssociation .
obsDict := ObsoleteClassesDict .
literalsOffset to: self size do: [:j | | aLit |
  aLit := self at: j .
  (aLit isKindOf: symAssocCls) ifTrue:[ | litName aVal newLit srcName lookupKey obsArr |
    litName := aLit key .
    (obsArr := obsDict at: litName otherwise: nil) ifNotNil:[
      aVal := aLit value .
      (aVal ~~ nil and:[ aVal == (obsArr at:1)]) ifTrue:[
         srcName := obsArr at: 2 .
         lookupKey := obsArr at: 3 .
         newLit := Globals associationAt: lookupKey otherwise: nil .
      ].
    ].
    newLit ifNotNil:[ litVars add: srcName ; add: newLit ]
           ifNil:[    litVars add: litName ; add: aLit ].
  ]
].
SessionTemps current at:#OldLitVars put: litVars .
newSrc := GsNMethod convertArrayBuildersInString: sourceString  .
cls := self inClass .
cls ifNil:[
  ^ newSrc _compileInContext: nil symbolList: nil oldLitVars: litVars
		environmentId: 0 flags: 0
] ifNotNil:[ | categ |
 categ := cls categoryOfSelector: selector .
  ^ cls _checkCompileResult: ( cls _primitiveCompileMethod: newSrc symbolList: nil
         category: categ oldLitVars: litVars
         intoMethodDict: aMethodDict intoCategories: aCategDict
         environmentId: 0 ) 
       source: newSrc suppressCompileWarning: false
]
%

category: 'Accessing'
method: GsMethod
selector

"Returns the value of the instance variable named selector."

^ selector
%

category: 'Accessing'
method: GsMethod
sourceString

"Returns a CharacterCollection that contains the source code of the receiver."

^ sourceString
%

category: 'Storing and Loading'
method: GsMethod
writeTo: aPassiveObject

"Instances of GsMethod cannot be converted to passive form.  This method writes
 nil to aPassiveObject and stops GemStone Smalltalk execution with a notifier."

aPassiveObject writeObject: nil.
self _error: #rtErrAttemptToPassivateInvalidObject.
%

category: 'Debugging Support'
method: GsMethod
_allBreakpoints

 "Returns nil if no method breakpoints set in the receiver."

^ nil
%

category: 'CodeModification Override'
method: GsMethod
_at: anIndex put: aValue

self _validatePrivilege.
^ super _at: anIndex put: aValue
%

category: 'CodeModification Override'
method: GsMethod
_basicAt: anIndex put: aValue

self _validatePrivilege.
^ super _basicAt: anIndex put: aValue
%

category: 'Debugging Support'
method: GsMethod
_breakPointKind: anIp

"This method infers the kind of action associated with a given bytecode."

self error:'not implemented'
%

category: 'Debugging Support'
method: GsMethod
_buildIpMarkerArray

"This method builds a marker Array for the receiver's source code string.
 containing IPs of all step points.

 The result Array is the same size as the source string and
 contains IP numbers at offsets corresponding to the source string."

| srcOffsets ipsArr srcSize mrkSize markerArray bias |

srcOffsets := self _sourceOffsets  .  "source offsets of the step points"
ipsArr := self _ipSteps .             "relative IPs of each step point"
srcSize := self sourceString size .

mrkSize := 1 max: srcSize .                          "fix bug 14976"
markerArray:= Array new: mrkSize .
bias := self class instSize .
1 to: srcOffsets size do: [:i | | anOffset anIp posOffset|
  anOffset := srcOffsets at: i .
  anIp := (ipsArr at: i ) + bias .
  posOffset := (anOffset abs max: 1) min: mrkSize.  "limit within range"
  (markerArray at: posOffset) == nil ifTrue:[
     markerArray at: posOffset put: anIp
  ]
].
^markerArray
%

category: 'Debugging Support'
method: GsMethod
_buildMarkerArray: allSteps ofSize: aSize

"This method builds a marker Array for the receiver's source code string.

 allSteps == true , show all steps
          == false, show steps where a breakpoint currently exists
          a SmallInteger, show just that step point

 The result Array is the same size as the source string and
 contains step numbers at offsets corresponding to the source string."

| srcOffsets stepToDisplay |

srcOffsets := self _sourceOffsets  .
(allSteps _isSmallInteger ) ifTrue:[
    stepToDisplay := allSteps .
    1 to: srcOffsets size do:[ :j |
       j == stepToDisplay ifFalse:[ srcOffsets at: j put: nil ].
    ]
  ]
  ifFalse:[
    allSteps ifFalse:[ self _setBreakpointsInSourceOffsets: srcOffsets ].
  ].

^ self class _buildMarkersFrom: srcOffsets ofSize: aSize
%

category: 'Reporting'
method: GsMethod
_classAndSelectorNameWidth: anInt

"Return a String of the form className | selector with the className substring
 padded to width anInt."

"Used by ProfMonitor"

|text sel|
selector == nil
  ifTrue:[sel := 'unbound method']
  ifFalse:[ sel := selector].
inClass == nil
  ifTrue: [ text := String withAll: 'executed code'.  ]
  ifFalse: [ text := String withAll: inClass name  ].
text width: anInt; addAll: ' >> '; addAll: sel .
^ text
%

category: 'Debugging Support'
method: GsMethod
_debugInfoHeaderSize

""

^ 4
%

category: 'Accessing'
method: GsMethod
_inClass

"Returns the class in which this method was compiled."

^ inClass
%

category: 'Debugging Support'
method: GsMethod
_ipForStepPoint: aStepPoint

"Return zero-based offset of instruction relative to the first indexable
 instance variable in the portable code."

| offset aStep |

aStepPoint == 0 ifTrue:[ ^ 0 "method entry"] .
aStep := aStepPoint abs .
aStepPoint > self _numIpSteps ifTrue:[ ^ nil ].

offset := self _numArgsAndTemps + self _debugInfoHeaderSize .
^ debugInfo at: (offset + aStepPoint)
%

category: 'Accessing'
method: GsMethod
_ipSteps

"Returns an Array containing the step points for the portable code for the
 method."

| offset |
offset := self _debugInfoHeaderSize + 1 + self _numArgsAndTemps  .
^ debugInfo copyFrom: offset to: (offset + self _numIpSteps - 1)
%

category: 'Private'
method: GsMethod
_isProtected

^ self _dnuError: #_isProtected args: #() reason: 1
%

category: 'Debugging Support'
method: GsMethod
_lineNumberForIp: targetIp

"Returns the line number in the receiver's source string for the
 specified IP value within the receiver.
 Assumes that the IP is from a frame that is Not at top of Stack."

| stepPoint |
stepPoint := self _previousStepPointForIp: targetIp quick: false .
^ self _lineNumberForStep: stepPoint
%

category: 'Debugging Support'
method: GsMethod
_lineNumberForStep: aStepPoint

"Returns the line number in the receiver's source string for the
 step point with number aStepPoint.
 Returns 1 if aStepPoint is out of range."

| sourceOffset offset lf  lineNumber|
sourceOffset := self _sourceOffsetsAt: aStepPoint .
sourceOffset == nil ifTrue:[ ^ 1 ].

" find the first end-of-line which is at or after the sourceOffset of the step point"
lf := Character lf .
offset := 1 .
lineNumber := 0 .
[ offset <= sourceOffset ] whileTrue:[
  lineNumber := lineNumber + 1 .
  offset := sourceString indexOf: lf startingAt: offset .
  offset == 0 ifTrue:[ ^ lineNumber ].
  offset := offset + 1 .
  ].
^ lineNumber .
%

category: 'Debugging Support'
method: GsMethod
_lineNumberForTosIp: targetIp

"Returns the line number in the receiver's source string for the
 specified IP value within the receiver.
 Assumes that the IP is from a frame that IS at top of Stack ."

| stepPoint |
stepPoint := self _nextStepPointForIp: targetIp quick: false .
^ self _lineNumberForStep: stepPoint
%

category: 'Decompiling without Sources'
method: GsMethod
_litArrayString

"Returns a String containing an Array-builder production describing the literal
 pool of the receiver."

| result lastSize aLit j literalsSize |
literalsSize := self size - literalsOffset .
literalsSize <= 0 ifTrue:[ ^ ' #() ' ] .

result := String new .
result addAll: '{ ' .
lastSize := result size .
j := 1 + literalsOffset .
literalsSize timesRepeat:[
  aLit := self at: j .
  (aLit isKindOf: SymbolAssociation) ifTrue:[
       result addAll: true _asSource ; "flag next as key of a literal variable"
              addAll: ' . ' ;
              addAll: aLit key _asSource.
  ] ifFalse:[
       "a block or other kind of literal"
       aLit == true ifTrue:[ self _halt:'true not expected as a literal' ].
       result addAll: aLit _asSource
  ] .
  lastSize := result size .
  result addAll: ' . ' ; add: Character lf ; addAll: '   '.
  j := j + 1 .
].
result size: lastSize .  "remove the last $. "
result addAll:' } ' .
^ result
%

category: 'Class organizer support'
method: GsMethod
_literalsIncludesValue: anObject

^ self literals includesIdentical: anObject
%

category: 'Accessing'
method: GsMethod
_nArgs

"Returns the number of arguments expected by the method."

^ numArgs
%

category: 'Debugging Support'
method: GsMethod
_nextStepPointForIp: anIp quick: isQuick

"Returns the offset in the ipSteps Array of the receiver which represents
 the step point at or just after the given instruction pointer offset.  If
 anIp is after the last step point, returns an integer one greater than
 the last step point.

 The anIp argument is a zero-based offset relative to first named instance
 variable in the receiver."

"This method is useful when doing low-level debugging of the virtual machine."

| numIpSteps aStep offset j  bias posIp |
numIpSteps := self _numIpSteps .
offset := self _numArgsAndTemps + self _debugInfoHeaderSize .

"search backwards so that if anIp points at the last element of an in-line
 send cache, we get the right answer.

 steps in debugInfo are zero based relative to first instruction in portable
 code ."

bias := self class instSize .
posIp := anIp abs .
(isQuick and:[ numIpSteps > 50]) ifTrue:[
  aStep := (debugInfo at: (offset + numIpSteps - 50)) + bias .
  posIp < aStep ifTrue:[ ^ nil ].
  ].
j := numIpSteps.
[j >= 1] whileTrue:[
  aStep := (debugInfo at: (offset + j )) + bias .
  aStep <= posIp ifTrue:[
     aStep == posIp ifTrue:[ ^ j ].
     ^ j + 1 .
     ] .
  j := j - 1 .
  ].
^ 1 .
%

category: 'Debugging Support'
method: GsMethod
_numArgs

""

^ debugInfo at: 2
%

category: 'Debugging Support'
method: GsMethod
_numArgsAndTemps

""

^ debugInfo at: 1
%

category: 'Debugging Support'
method: GsMethod
_numIpSteps

""

^ debugInfo at: 3
%

category: 'Debugging Support'
method: GsMethod
_numSourceOffsets

""

^ debugInfo at: 4
%

category: 'Disassembly'
method: GsMethod
_opcodeInfo: instrWord

"instrWord must be a SmallInteger from the body of A GsMethod, containing
 a valid opcode.  If the instrWord represents a currently installed breakpoint,
 the result is for the instruction that the breakpoint is replacing.

 returns a SmallInteger with the following bit fields
           16rFF  instruction size in words , including the opcode word and any
	  	  in-line literal words , an unsigned 8-bit int
       16rFFFF00  instVar offset for instVarAccess
      16r1000000  boolean, 1 means opcode is an instVarAccess
      16r2000000  boolean, 1 means opcode is a pushBlock
   16rFFF0000000  opcode
 "
"primitive 536 no longer in VM"
Error signal:'_opcodeInfo:  not implemented'.
%

category: 'Debugging Support'
method: GsMethod
_previousStepPointForIp: anIp quick: isQuick

"Returns the offset in the ipSteps Array of the receiver which represents
 the step point preceding the given instruction pointer offset.

 The anIp argument is a zero-based offset relative to first named instance
 variable in the receiver."

"This method is useful when doing low-level debugging of the virtual machine."

| numIpSteps aStep offset bias posIp |
numIpSteps := self _numIpSteps .
offset := self _numArgsAndTemps + self _debugInfoHeaderSize .

"search forwards.
 steps in debugInfo are zero based relative to first instruction in portable
 code ."

bias := self class instSize .
posIp := anIp abs .
(isQuick and:[ numIpSteps > 50]) ifTrue:[
  aStep := (debugInfo at: (offset + 50 )) + bias .
  posIp > aStep ifTrue:[ ^ nil ].
  ].

1 to: numIpSteps do:[ :j |
  aStep := (debugInfo at: (offset + j )) + bias .
  aStep >= posIp ifTrue:[
     j > 1 ifTrue:[ ^ j - 1 ].
     ^ j
     ] .
  ].
^ numIpSteps
%

category: 'CodeModification Override'
method: GsMethod
_primitiveAt: anIndex put: aValue

self _validatePrivilege.
^ super _primitiveAt: anIndex put: aValue
%

category: 'Accessing'
method: GsMethod
_selector

"Returns the value of the instance variable named selector."

^ selector
%

category: 'Reporting'
method: GsMethod
_selectorPool

"Return a SymbolSet containing the selectors sent by the receiver."

| instr result |

result := SymbolSet new .
1 to: literalsOffset - 1 do:[:j |
  (instr := self at: j) _isSmallInteger ifFalse:[
     instr _isSymbol ifTrue:[ result add: instr ].
     ].
  ].
^ result
%

category: 'Debugging Support'
method: GsMethod
_sendCount: anIp

"This method returns the number of arguments (excluding receiver)
 associated with the message send at this offset."

self error:'not implemented'
%

category: 'Debugging Support'
method: GsMethod
_sourceAtIp: anIp

"Return the source string with marker for step point closest to
 the specified IP .
 Assumes that the IP is from a frame that is Not at top of Stack."

| aStep |
aStep := self _previousStepPointForIp: anIp quick: false .
^ self _sourceWithSteps: aStep
%

category: 'Debugging Support'
method: GsMethod
_sourceAtTosIp: anIp

"Return the source string with marker for step point closest to
 the specified IP .
 Assumes that the IP is from a frame that IS at top of Stack."

| aStep |
aStep := self _nextStepPointForIp: anIp quick: false .
^ self _sourceWithSteps: aStep
%

category: 'Reporting'
method: GsMethod
_sourceOffsetOfFirstSendOf: aSymbol

"Returns the source offset of the step point for the first send in the receiver
 that sends aSymbol.  If the receiver is not a sender of aSymbol, or if aSymbol
 is not a Symbol, returns nil."

1 to: literalsOffset - 1 do:[:j |
  (self at: j) == aSymbol ifTrue:[
     ^ self _sourceOffsetOfSendAt: j .
     ].
  ].
^ nil
%

category: 'Debugging Support'
method: GsMethod
_sourceOffsetOfSendAt: instrOffset

"Returns the source offset of the step point for the send using the selector
 found at instrOffset.

 The instrOffset argument is one-based relative to first indexable instance
 variable."

| ipOffset stepPoint |

ipOffset := instrOffset + self class instSize "convert to zero-based" .
stepPoint := self _previousStepPointForIp: ipOffset quick: false .
^ self _sourceOffsetsAt: stepPoint
%

category: 'Debugging Support'
method: GsMethod
_sourceOffsets

"Returns an InvariantArray (that holds SmallIntegers) which is a list
 of offsets into sourceString, corresponding in order to the step points."

| offset numIpSteps numSrcOffsets |
numIpSteps := self _numIpSteps .
numSrcOffsets := self _numSourceOffsets .
(numIpSteps == 0 or:[ numSrcOffsets == 0])
   ifTrue:[ ^ #( 1 ) ].  "handle certain primitive methods"

offset :=
  self _debugInfoHeaderSize + 1 + self _numArgsAndTemps + numIpSteps .
^ debugInfo copyFrom: offset to: (offset + numSrcOffsets - 1)
%

category: 'Debugging Support'
method: GsMethod
_sourceOffsetsAt: aStepPoint

"Returns the source offset for the step point with number aStepPoint.
 Returns nil if aStepPoint is out of range."

| numIpSteps numSrcOffsets |
numIpSteps := self _numIpSteps .
numSrcOffsets := self _numSourceOffsets .
(numIpSteps == 0 or:[ numSrcOffsets == 0]) ifTrue:[
  "handle certain primitive methods, whose source offsets is #( 1 ) "
  aStepPoint == 1 ifFalse:[ ^ nil ].
  ^ 1
  ].

(aStepPoint < 1 or:[ aStepPoint > numSrcOffsets ]) ifTrue:[ ^ nil ].

^ debugInfo at:
  self _debugInfoHeaderSize + aStepPoint + self _numArgsAndTemps + numIpSteps .
%

category: 'Accessing'
method: GsMethod
_sourceString

"Returns the value of the instance variable sourceString."

^ sourceString
%

category: 'Accessing'
method: GsMethod
_sourceStringWithFileName

^ self sourceString
%

category: 'Debugging Support'
method: GsMethod
_sourceWithStepIps

"This method returns the source string with intermixed control information
 indicating IP values of each step point.
 "

| markerArray "A parallel Array to the source string.  It is filled with nils
               except for locations pointed to by the sourceOffsets Array."
  aSize "the size of the source"
  result |

aSize:= sourceString size.
  "only ask for the source size once for efficiency for Japanese"
markerArray := self _buildIpMarkerArray .
result := self class _buildMarkedSourceFrom: sourceString
                             sourceSize: aSize
                                markers: markerArray .
^ result
%

category: 'Debugging Support'
method: GsMethod
_sourceWithSteps: allSteps

"This method returns the source string with intermixed control information
 indicating where step points are.

 allSteps == true , show all steps
          == false, show steps where a breakpoint currently exists
          a SmallInteger, show just that step point
 "

| markerArray "A parallel Array to the source string.  It is filled with nils
               except for locations pointed to by the sourceOffsets Array."
  aSize "the size of the source"
  result |

aSize:= sourceString size.
  "only ask for the source size once for efficiency for Japanese"
markerArray := self _buildMarkerArray: allSteps ofSize: aSize.
result := self class _buildMarkedSourceFrom: sourceString
                             sourceSize: aSize
                                markers: markerArray .
				"deleted   'reduce garbage' code"
^ result
%

category: 'Debugging Support'
method: GsMethod
_stepPointForIp: ipOffset level: aLevel quick: isQuick

""
"ipOffset is zero-based relative to first named instance variable."

aLevel == 1 ifTrue:[  "top of stack"
   ^ self _nextStepPointForIp: ipOffset quick: isQuick
    ]
 ifFalse:[
   ^ self _previousStepPointForIp: ipOffset quick: isQuick
    ]
%

category: 'CodeModification Override'
method: GsMethod
_unsafeAt: anIndex put: aValue

self _validatePrivilege.
^ super _unsafeAt: anIndex put: aValue
%

category: 'CodeModification Override'
method: GsMethod
_validatePrivilege

System myUserProfile _validateCodeModificationPrivilege

%

! Class extensions for 'InvariantEUCString'

!		Instance methods for 'InvariantEUCString'

removeallmethods InvariantEUCString
removeallclassmethods InvariantEUCString

category: 'Formatting'
method: InvariantEUCString
asEUCString

"Returns an EUCString representing the receiver."

^ EUCString withBytes: self
%

! Class extensions for 'JapaneseString'

!		Class methods for 'JapaneseString'

removeallmethods JapaneseString
removeallclassmethods JapaneseString

category: 'Private'
classmethod: JapaneseString
withBytes: aByteObject

"Returns a new instance of the receiver that contains the bytes in the
 argument aByteObject. "

| result size |
size := aByteObject _basicSize.
((size \\ self charSize) ~= 0) ifTrue: [
  self _error: #objErrBadSize args: { size . self class }
].
result:= self new _basicSize: size.
1 to: size do: [:i | result _basicAt: i put: (aByteObject _basicAt: i) ].
^ result.
%

!		Instance methods for 'JapaneseString'

category: 'Converting'
method: JapaneseString
asUnicodeString

"Returns an EUCString representing the receiver."

"Must be reimplemented in EUCString to return self !!
 This implementation handles other weird kinds of multiple-byte Strings
 that the user or engineers might dream up."

| s |
s := Unicode7 new .
1 to: self size do:[:n| s addCodePoint: (self codePointAt: n) ].
^ s
%

! Class extensions for 'JISCharacter'

!		Class methods for 'JISCharacter'

removeallmethods JISCharacter
removeallclassmethods JISCharacter

category: 'Instance Creation'
classmethod: JISCharacter
withValue: aJISValue

"No longer supported. primitive 252, method not in base image"

self shouldNotImplement: #withValue::
%

!		Instance methods for 'JISCharacter'

category: 'Converting'
method: JISCharacter
asCharacter

"Returns the Unicode Character corresponding to the receiver."

^ Character codePoint: self jisValue
%

category: 'Accessing'
method: JISCharacter
jisValue

 "Returns the JIS code of the receiver as a SmallInteger."

 <primitive: 247>

 ^ self _primitiveFailed: #jisValue
%

category: 'Testing'
method: JISCharacter
_category

self shouldNotImplement: #_category
%

! Class extensions for 'JISString'

!		Class methods for 'JISString'

removeallmethods JISString
removeallclassmethods JISString

category: 'Formatting'
classmethod: JISString
charSize

"Returns the number of bytes that make up a character"
^2
%

!		Instance methods for 'JISString'

category: 'Formatting'
method: JISString
charSize

"Returns the number of bytes that make up a character"
^2
%

category: 'Accessing'
method: JISString
codePointAt: anIndex

"Returns the JIS code point at anIndex."

| highByte lowByte offset |

offset := anIndex + anIndex  .
lowByte := self _basicAt: offset .
highByte := self _basicAt: offset - 1 .
 ^ (highByte * 256) + lowByte
%

category: 'Accessing'
method: JISString
size

"Returns the size of the receiver in Characters."

^ self _basicSize // 2
%

! Class extensions for 'ObsoleteClampSpecification'

!		Class methods for 'ObsoleteClampSpecification'

removeallmethods ObsoleteClampSpecification
removeallclassmethods ObsoleteClampSpecification

category: 'Instance Creation'
classmethod: ObsoleteClampSpecification
new

"Disallowed.  This class is obsolete."

self shouldNotImplement: #new
%

! Class extensions for 'ObsoleteDateTime'

!		Class methods for 'ObsoleteDateTime'

removeallmethods ObsoleteDateTime
removeallclassmethods ObsoleteDateTime

category: 'Instance Creation'
classmethod: ObsoleteDateTime
fromStream: aStream

"New instances cannot be created for obsolete classes."

^ self _error: #rtObsoleteClass.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
fromStream: aStream usingFormat: anArray

"New instances cannot be created for obsolete classes."

^ self _error: #rtObsoleteClass.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
fromString: aString

"New instances cannot be created for obsolete classes."

^ self _error: #rtObsoleteClass.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
fromString: aString usingFormat: anArray

"New instances cannot be created for obsolete classes."

^ self _error: #rtObsoleteClass.
%

category: 'Storing and Loading'
classmethod: ObsoleteDateTime
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ DateTime loadFrom: passiveObj
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
new

"Disallowed.  To create a new ObsoleteDateTime, use one of the other instance creation
 methods listed here."

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
new: anInteger

"Disallowed.  To create a new ObsoleteDateTime, use one of the other instance creation
 methods listed here."

self shouldNotImplement: #new:
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
newWithYear: yearInt month: monthInt day: dayInt hours: hourInt
  minutes: minuteInt seconds: secondInt

"New instances cannot be created for obsolete classes."

^ self _error: #rtObsoleteClass.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
now

"New instances cannot be created for obsolete classes."

^ self _error: #rtObsoleteClass.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
_checkFormat: anArray

""

"anArray is a format Array as documented in ObsoleteDateTime>>asStringUsingFormat:"

| v doTime |

anArray _validateClass: Array.
(anArray size < 8 or:[ anArray size > 10])
  ifTrue:[ ObsoleteDateTime _error: #rtErrBadFormatSpec args: { anArray } ].

"Check for a combination of the digits 1, 2, and 3"
((anArray at: 1) + (anArray at: 2) + (anArray at: 3) = 6 and:
        [(anArray at: 1) * (anArray at: 2) * (anArray at: 3) = 6])
  ifFalse:[ ObsoleteDateTime _error: #rtErrBadFormatSpec args: { anArray } ].

(anArray at: 4) _validateClass: Character.

((v := anArray at: 5) = 1 or: [v = 2 or: [v = 3]])
  ifFalse:[ ObsoleteDateTime _error: #rtErrBadFormatSpec args: { anArray } ].

((anArray at: 6) = 1 or: [(anArray at: 6) = 2])
  ifFalse:[ ObsoleteDateTime _error: #rtErrBadFormatSpec args: { anArray } ].

(doTime := anArray at: 8) _validateClass: Boolean.
doTime ifTrue:[
  anArray size = 10
    ifFalse:[ ObsoleteDateTime _error: #rtErrBadFormatSpec args: { anArray } ].
  (anArray at: 7) _validateClass: Character.
  (anArray at: 9) _validateClass: Boolean.
  (anArray at: 10) _validateClass: Boolean.
  ]
%

category: 'Repository Conversion'
classmethod: ObsoleteDateTime
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteDateTime)
  ifTrue: [ ^ DateTime ].

^ self.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
_getMonthFrom: aCharCollection

"Reads a month name or abbreviation from aCharCollection and returns the
 integer corresponding to the month of the year."

| whichMonth monthArray argSize matchMonth |

monthArray := MonthNames value.
matchMonth:= [:monthStr | | strSize match i |
   i:= 1.
   match:= false.
   strSize:= monthStr size.
   [ ((i <= argSize) and:[i <= strSize]) and:
     [match:= (aCharCollection at: i) isEquivalent: (monthStr at: i)]]
   whileTrue: [
      i:= i + 1.
   ].
   match
].

   argSize:= aCharCollection size.
   whichMonth:= 1.
   [ (whichMonth <= 12) and:
     [(matchMonth value: (monthArray at: whichMonth)) not]
   ]
   whileTrue:
      [whichMonth := whichMonth + 1].

   (whichMonth <= 12)
      ifTrue: [ ^whichMonth].
   ^ 0
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
_newJulianDay: anInteger second: anotherInteger

"New instances cannot be created for obsolete classes."

^ self _error: #rtObsoleteClass.
%

category: 'Instance Creation'
classmethod: ObsoleteDateTime
_newWithYear: yearInt month: monthInt day: dayInt seconds: secondInt

"New instances cannot be created for obsolete classes."

^ self _error: #rtObsoleteClass.
%

!		Instance methods for 'ObsoleteDateTime'

category: 'Comparing'
method: ObsoleteDateTime
< aObsoleteDateTime

"Returns true if the receiver represents a ObsoleteDateTime before the argument, false
 if it doesn't.  Generates an error if the argument is not a ObsoleteDateTime."

| t |

(self julianDay = (t := aObsoleteDateTime julianDay))
   ifTrue: [ ^ self julianSecond < aObsoleteDateTime julianSecond ].
^ self julianDay < t
%

category: 'Comparing'
method: ObsoleteDateTime
= aObsoleteDateTime

"Returns true if the receiver represents the same ObsoleteDateTime as the argument,
 false if it doesn't."

aObsoleteDateTime class == self class ifFalse: [ ^false ].
^ (self julianDay = aObsoleteDateTime julianDay) and:
   [self julianSecond = aObsoleteDateTime julianSecond ]
%

category: 'Comparing'
method: ObsoleteDateTime
> aObsoleteDateTime

"Returns true if the receiver represents a ObsoleteDateTime after the argument, false
 if it doesn't.  Generates an error if the argument is not a ObsoleteDateTime."

| t |

(self julianDay = (t := aObsoleteDateTime julianDay))
   ifTrue: [ ^self julianSecond > aObsoleteDateTime julianSecond ].
^self julianDay > t
%

category: 'Arithmetic'
method: ObsoleteDateTime
addDays: anInteger

"Returns a ObsoleteDateTime anInteger days after the receiver."

^ (self class) _newJulianDay: (self julianDay + anInteger)
                      second: (self julianSecond)
%

category: 'Arithmetic'
method: ObsoleteDateTime
addHours: anInteger

"Returns a ObsoleteDateTime anInteger hours after the receiver."

^ self addSeconds: anInteger * 3600
%

category: 'Arithmetic'
method: ObsoleteDateTime
addMinutes: anInteger

"Returns a ObsoleteDateTime anInteger minutes after the receiver."

^ self addSeconds: anInteger * 60
%

category: 'Arithmetic'
method: ObsoleteDateTime
addMonths: anInteger

"Returns a ObsoleteDateTime anInteger months after the receiver.  This method attempts
 to keep the day of the month the same.  If the new month has fewer days than
 the receiver's original month, the method will truncate to the last day of the
 new month."

| t newMonth newYear |

t := self _yearMonthDay.
newMonth := ((t at: 2) + anInteger) .
newYear := (t at: 1) .
(newMonth == 0) ifTrue:[ newYear := newYear - 1 ].
^ (self class) _newWithYear: newYear
               month: newMonth
               day: (t at: 3)
               seconds: (self julianSecond)
%

category: 'Arithmetic'
method: ObsoleteDateTime
addSeconds: anInteger

"Returns a ObsoleteDateTime anInteger seconds after the receiver."

^ (self class) _newJulianDay: (self julianDay)
                      second: (self julianSecond + anInteger)
%

category: 'Arithmetic'
method: ObsoleteDateTime
addWeeks: anInteger

"Returns a ObsoleteDateTime anInteger weeks after the receiver."

^ self addDays: anInteger * 7
%

category: 'Arithmetic'
method: ObsoleteDateTime
addYears: anInteger

"Returns a ObsoleteDateTime anInteger years after the receiver."

| t |

t := self _yearMonthDay.
^ (self class) _newWithYear: ((t at: 1) + anInteger)
                  month: (t at: 2)
                    day: (t at: 3)
                seconds: (self julianSecond)
%

category: 'Converting'
method: ObsoleteDateTime
asDateTime

"Returns an instance of DateTime with the date and time contained in
 the receiver."

| aDateTime aTimeZone |

aTimeZone := TimeZone current.
aDateTime := (self transformIntoDateTime) subtractSeconds: (aTimeZone secondsFromGmt).

(aDateTime isDstIn: aTimeZone)
  ifTrue:  [ ^ aDateTime subtractSeconds: (aTimeZone secondsForDst)]
  ifFalse: [ ^ aDateTime ].
%

category: 'Converting'
method: ObsoleteDateTime
asParts

"Returns an Array of SmallIntegers (year month day hours minutes
 seconds) corresponding to the receiver."

| t |

t := self _yearMonthDay.  "year/month/day"
t addLast: self julianSecond // 3600.  "hours"
t addLast: self julianSecond \\ 3600 // 60.  "minutes"
t addLast: self julianSecond \\ 60.  "seconds"
^ t
%

category: 'Converting'
method: ObsoleteDateTime
asSeconds

"Returns an Integer representing the receiver in units of seconds
 since 1 March 1583."

^ self julianDay - 2299298 * 86400 + self julianSecond

  "86400 = seconds/24-hour day"
  "converts to March 1, 1583, Gregorian"
%

category: 'Formatting'
method: ObsoleteDateTime
asString

"Returns a String representing the receiver.  The String is in
 the format DD/MM/YYYY HH:MM:SS, with hours in military time."

| t julSec |

t := self _yearMonthDay.
julSec := self julianSecond.
^ (t at: 3) _digitsAsString
  addAll: '/';
  addAll: (t at: 2) _digitsAsString;
  addAll: '/';
  addAll: (t at: 1) _digitsAsString;
  addAll: ' ';
  addAll: (julSec // 3600) _digitsAsString;
  addAll: ':';
  addAll: (julSec \\ 3600 // 60) _digitsAsString;
  addAll: ':';
  addAll: (julSec \\ 60) _digitsAsString
%

category: 'Formatting'
method: ObsoleteDateTime
asStringUsingFormat: anArray

"Returns a String representing the receiver.  The format of the String is
 determined by anArray, whose elements are described in the following table.

 Generates an error if anArray does not contain all required elements or
 if the value of any Array element does not conform to the requirements set
 forth in the following table.  anArray must contain at least 8 elements if
 time is not printed, and must contain 10 elements otherwise.

 ObsoleteDateTime String Format

 Element       Acceptable Value        Explanation

 1st,2nd,3rd   The integers 1, 2, 3,   Determines the position of day,
               in any order            month, year.  1 corresponds
                                       to day, 2=month, 3=year.

 4th           A separator Character   Separates year, month, and day.
               (preceded by $)

 5th           Month format            With asStringUsingFormat:
                                       1 = print as number
                                       2 = print 3-letter abbreviation
                                       3 = print entire name

                                       With fromStreamUsingFormat: or
                                       fromString:usingFormat:
                                       1 = decode a number to determine
                                           the month
                                       2 or 3 = decode a character string to
                                           determine the month

 6th           Year format             With asStringUsingFormat:
                                       1 = print entire year
                                       2 = print last 2 digits (year mod 100)

                                       With fromStreamUsingFormat: or
                                       fromString:usingFormat:
                                       1 = read entire year
                                       2 = read only the last 2 digits

 7th           A separator Character   Separates hours, minutes, and seconds.
               (preceded by $)

 8th           true or false           If true, print or read the time as
                                       indicated by the 7th, 9th and 10th
                                       elements.  If false, ignore those
                                       elements, and the 9th and 10th elements
                                       are optional.

 9th           true or false           Whether or not to print or read seconds.

 10th          true or false           true = print (read) time in 12-hour
                                       format, with am or pm (such as
                                       1:30:55 pm).  The space is required
                                       preceding the am or pm indicator.

                                       false = print (read) time in 24-hour
                                       format (such as 13:30:55)"

|t julSec dateSeparator timeSeparator monthName aString
 hour hourInt min sec day year|

t := self _yearMonthDay.
julSec := self julianSecond.

ObsoleteDateTime _checkFormat: anArray.

dateSeparator := (anArray at: 4) asString.

timeSeparator := (anArray at: 7) asString.

((anArray at: 5) = 2) "get the month name according to the format"
   ifTrue: [monthName := self _monthAbbrev: (t at: 2)]
   ifFalse: [((anArray at: 5) = 3) "month as number is default"
      ifTrue: [monthName := self _monthName: (t at: 2)]
      ifFalse: [monthName := (t at: 2) _digitsAsString]].

((anArray at: 6) = 2)
   ifTrue: [year := ((t at: 1) \\ 100) _digitsAsString]
   ifFalse: [year := (t at: 1) asString].  "YYYY is default"

day := (t at:3) _digitsAsString.
((anArray at: 1) = 2) "month first"
   ifTrue: [aString := monthName + dateSeparator]
   ifFalse: [((anArray at: 1) = 3) "year first"
      ifTrue: [aString := year + dateSeparator]
      ifFalse: [aString := day + dateSeparator]].  "day first is default"

((anArray at: 2) = 1) "day second"
   ifTrue: [aString addAll: day; addAll: dateSeparator] "year second"
   ifFalse: [((anArray at: 2) = 3) "month second is default"
      ifTrue: [aString addAll: year; addAll: dateSeparator]
      ifFalse: [aString addAll: monthName; addAll: dateSeparator]].

((anArray at: 3) = 1) "day third"
   ifTrue: [aString addAll: day]
   ifFalse: [((anArray at: 3) = 2) "month third"
      ifTrue: [aString addAll: monthName]
      ifFalse: [aString addAll: year]].  "year third is default"

hourInt := julSec // 3600.
hour := hourInt _digitsAsString.
min := (julSec \\ 3600 // 60) _digitsAsString.
sec := (julSec \\ 60) _digitsAsString.

(anArray at: 8) ifTrue: [ "print the time"
  aString add: $ .
  (anArray at: 10) ifTrue: [ "12-hour format"
    (hourInt > 12) ifTrue: [
      aString addAll: (hourInt - 12) _digitsAsString;
              addAll: timeSeparator;
              addAll: min.

      (anArray at: 9) ifTrue: [
        aString addAll: timeSeparator;
                addAll: sec
        ].
      ]
    ifFalse: [
      aString addAll: (hourInt = 0 ifTrue: ['12'] ifFalse: [hour]);
              addAll: timeSeparator;
              addAll: min.

      (anArray at: 9) ifTrue: [
        aString addAll: timeSeparator;
                addAll: sec.
        ].
      ].

    aString addAll: (hourInt >= 12 ifTrue: [' pm'] ifFalse: [' am']).
    ]
  ifFalse: [
    aString addAll: hour;
            addAll: timeSeparator;
            addAll: min.

    (anArray at: 9) ifTrue: [
      aString addAll: timeSeparator;
              addAll: sec.
      ].
    ].
  ].

^ aString
%

category: 'Accessing'
method: ObsoleteDateTime
at: anIndex put: aValue

"Disallowed.  You may not change the value of a ObsoleteDateTime."

self shouldNotImplement: #at:put:
%

category: 'Repository Conversion'
method: ObsoleteDateTime
convertToDateTime

"Converts an instance of ObsoleteDateTime (GemStone 4.1 and earlier) to an
 instance of current DateTime.  The object identity is left the same.
 Returns the receiver.

 The receiver is assumed to represent a date and time in the local time
 zone and is converted to a DateTime in Greenwich Mean Time."

| newDt |

newDt := self asDateTime.
newDt become: self.
^ self.
%

category: 'Accessing'
method: ObsoleteDateTime
dayOfMonth

"Returns the day of the month as a SmallInteger."

^  (self _yearMonthDay) at: 3
%

category: 'Accessing'
method: ObsoleteDateTime
dayOfWeek

"Returns the numeric index of the day of the week (1-7), where 1 = Sunday."

^ self julianDay - 2299295 - 1 \\ 7 + 1

  "the Julian day 2299298 is converted to the Gregorian"
  "date of March 1, 1583 by Communications of the ACM #199 algorithm"
  "was March 1, 1583 a Thursday?"
%

category: 'Accessing'
method: ObsoleteDateTime
dayOfYear

"Returns the day of the year as a SmallInteger."

|t y |

t := self _yearMonthDay.
y := 0.
1 to: ((t at: 2) - 1) do: [:month |
   ((month = 1) or: [(month = 3) or: [(month = 5) or: [(month = 7) or:
   [(month = 8) or: [(month = 10) or: [(month = 12)]]]]]])
      ifTrue: [y := y + 31].
   ((month = 4) or: [(month = 6) or: [(month = 9) or: [(month = 11)]]])
      ifTrue: [y := y + 30].
   (month = 2)
      ifTrue:[(self leap)
         ifTrue: [y := y + 29]
         ifFalse: [y := y + 28]]].
^ y + (t at: 3)
%

category: 'Accessing'
method: ObsoleteDateTime
daysInMonth

"Returns the number of days in the month represented by the receiver."

|t month|

t := self _yearMonthDay.
month := t at: 2.
((month = 1) or: [(month = 3) or: [(month = 5) or: [(month = 7) or:
   [(month = 8) or: [(month = 10) or: [(month = 12)]]]]]])
   ifTrue: [^ 31].
((month = 4) or: [(month = 6) or: [(month = 9) or: [(month = 11)]]])
   ifTrue: [^ 30].
(self leap)
   ifTrue: [^ 29].
^ 28
%

category: 'Accessing'
method: ObsoleteDateTime
daysInYear

"Returns the number of days in the year represented by the receiver."

(self leap)
   ifTrue: [^ 366].
^ 365
%

category: 'Comparing'
method: ObsoleteDateTime
hash

"Returns an Integer hash code for the receiver."

^ ((self julianDay hash) bitShift: -1) bitXor: (self julianSecond hash)
%

category: 'Accessing'
method: ObsoleteDateTime
hours

"Returns the hours since midnight (0-23)."

^ self julianSecond // 3600
%

category: 'Accessing'
method: ObsoleteDateTime
julianDay

"Returns the Julian Day, a SmallInteger representing the number of days since
 January 1, 4713 BC (as defined in Communications of the ACM algorithm #199)."

^ self asDateTime julianDay.
%

category: 'Accessing'
method: ObsoleteDateTime
julianSecond

"Returns a SmallInteger representing the number of seconds since midnight."

^ self asDateTime seconds
%

category: 'Accessing'
method: ObsoleteDateTime
leap

"Returns true if the receiver represents a leap year and false if it does not."

| yr |
  "a year is a leap year if: (it is evenly divisible by 4 and it is not a
   century year) or (it is a century year and evenly divisible by 400)"

yr := (self _yearMonthDay) at: 1.
((yr \\ 100) = 0)
   ifTrue: [^ ((yr \\ 400) = 0)].
^ ((yr \\ 4) = 0)
%

category: 'Accessing'
method: ObsoleteDateTime
minutes

"Returns the minutes since the hour (0-59)."

^ self julianSecond \\ 3600 // 60
%

category: 'Accessing'
method: ObsoleteDateTime
monthName

"Returns the name of the month (a String) in the user's native language."

^ MonthNames value at: ((self _yearMonthDay) at: 2)
%

category: 'Accessing'
method: ObsoleteDateTime
monthOfYear

"Returns the numeric index of the month (1-12)."

^ (self _yearMonthDay) at: 2
%

category: 'Formatting'
method: ObsoleteDateTime
printOn: aStream

"Puts a displayable representation of the receiver on the given stream."

aStream nextPut: $' .
aStream nextPutAll: self asString .
aStream nextPut: $'
%

category: 'Accessing'
method: ObsoleteDateTime
seconds

"Returns the seconds since the minute (0-59)."

^ self julianSecond \\ 60
%

category: 'Accessing'
method: ObsoleteDateTime
size: anInteger

"Disallowed.  You may not change the size of a ObsoleteDateTime."

self shouldNotImplement: #size:
%

category: 'Arithmetic'
method: ObsoleteDateTime
subtractDate: aObsoleteDateTime

"Returns the number of days between the receiver and aObsoleteDateTime."

^ (self julianDay - aObsoleteDateTime julianDay) abs
%

category: 'Arithmetic'
method: ObsoleteDateTime
subtractDays: anInteger

"Returns a ObsoleteDateTime anInteger days before the receiver."

^ self addDays: anInteger negated
%

category: 'Arithmetic'
method: ObsoleteDateTime
subtractHours: anInteger

"Returns a ObsoleteDateTime anInteger hours before the receiver."

^ self addSeconds: anInteger * 3600 negated
%

category: 'Arithmetic'
method: ObsoleteDateTime
subtractMinutes: anInteger

"Returns a ObsoleteDateTime anInteger minutes before the receiver."

^ self addSeconds: anInteger * 60 negated
%

category: 'Arithmetic'
method: ObsoleteDateTime
subtractMonths: anInteger

"Returns a ObsoleteDateTime anInteger months before the receiver.  As with addMonths:,
 this method attempts to keep the day of the month the same.  If the new month
 has fewer days than the receiver's original month, the method will truncate to
 the last day of the new month."

^ self addMonths: anInteger negated
%

category: 'Arithmetic'
method: ObsoleteDateTime
subtractSeconds: anInteger

"Returns a ObsoleteDateTime anInteger seconds before the receiver."

^ self addSeconds: anInteger negated
%

category: 'Arithmetic'
method: ObsoleteDateTime
subtractTime: adate

"Subtracts the given ObsoleteDateTime's hours/minutes/seconds from the
 receiver's and returns the result in an Array of {hours. minutes. seconds}."

| parts h m s |
parts := self asParts.
h := parts at: 4.
m := parts at: 5.
s := parts at: 6.
parts := adate asParts.
s := s - (parts at: 6).
m := m - (parts at: 5).
h := h - (parts at: 4).
s < 0 ifTrue: [
  s := s + 60.
  m := m - 1
].
s > 60 ifTrue: [
  s := s - 60.
  m := m + 1
].
m < 0 ifTrue: [
  m := m + 60.
  h := h - 1
].
m > 60 ifTrue: [
  m := m - 60.
  h := h + 1
].
^{ h . m . s }
%

category: 'Arithmetic'
method: ObsoleteDateTime
subtractWeeks: anInteger

"Returns a ObsoleteDateTime anInteger weeks before the receiver."

^ self addDays: anInteger * 7 negated
%

category: 'Arithmetic'
method: ObsoleteDateTime
subtractYears: anInteger

"Returns a ObsoleteDateTime anInteger years before the receiver."

^ self addYears: anInteger negated
%

category: 'Accessing'
method: ObsoleteDateTime
timeAsSeconds

"Returns the number of seconds since midnight represented by the receiver."

^ self julianSecond
%

category: 'Private'
method: ObsoleteDateTime
transformIntoDateTime

"Returns an instance of DateTime with the date and time contained in
 the receiver."

^ self transformIntoDateTime: (TimeZone current).
%

category: 'Formatting'
method: ObsoleteDateTime
US12HrFormat

"Returns a string representation of the receiver in the form `m/d/y hh:mm'
 with 12-hour time representation."

^self asStringUsingFormat: #(2 1 3 $/ 1 2 $: true false true)
%

category: 'Formatting'
method: ObsoleteDateTime
US24HrFormat

"Returns a string representation of the receiver in the form `m/d/y hh:mm'
 with 24-hour time representation."

^self asStringUsingFormat: #(2 1 3 $/ 1 2 $: true false false)
%

category: 'Formatting'
method: ObsoleteDateTime
USDateFormat

"Returns a string representation of the receiver in the form `m/d/y'."

^self asStringUsingFormat: #(2 1 3 $/ 1 2 $: false )
%

category: 'Accessing'
method: ObsoleteDateTime
weekDayName

"Returns the name of the day of the week (a String) in the user's native
 language."

^ WeekDayNames value at: (self dayOfWeek)
%

category: 'Storing and Loading'
method: ObsoleteDateTime
writeTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

passiveObj writeClass: self class.
self _yearMonthDay do: [:each |  each writeTo: passiveObj].
self julianSecond writeTo: passiveObj.
passiveObj space
%

category: 'Accessing'
method: ObsoleteDateTime
year

"Returns the calendar year as an integer."

^ (self _yearMonthDay) at: 1
%

category: 'New Indexing Comparison'
method: ObsoleteDateTime
_classSortOrdinal

^ 59
%

category: 'Formatting'
method: ObsoleteDateTime
_monthAbbrev: aMonthInt

"Given the month of the year as a SmallInteger, returns a three-letter string
 that is its abbreviation."

|theMonth itsAbbrev|

theMonth := self _monthName: aMonthInt.  "get its full name"
itsAbbrev := String new.
1 to: 3 do: "take the first three letters"
   [:aChar | itsAbbrev := itsAbbrev + (theMonth at: aChar)].
^ itsAbbrev
%

category: 'Formatting'
method: ObsoleteDateTime
_monthName: aMonthInt

"Given the month of the year as a SmallInteger, returns a String that is its
 full name."

^ (MonthNames value) at: aMonthInt
%

category: 'Accessing'
method: ObsoleteDateTime
_yearMonthDay

"Returns a three-element Array of SmallIntegers containing the year, index of
 the month, and the day of the month of the Gregorian calendar calculated from
 the Julian day of the receiver."

^ self asDateTime _yearMonthDay
%

! Class extensions for 'ObsoleteDictionary'

!		Class methods for 'ObsoleteDictionary'

removeallmethods ObsoleteDictionary
removeallclassmethods ObsoleteDictionary

category: 'Storing and Loading'
classmethod: ObsoleteDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: Dictionary
%

category: 'Storing and Loading'
classmethod: ObsoleteDictionary
loadFrom: passiveObj mappingToClass: newClass

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

| newDict oldDict size |
(passiveObj version >= 500 or:[ newClass == self]) ifTrue:[
  size := passiveObj readSize.
  newDict := self new.
  newDict loadFrom: passiveObj size: size.
  ]
ifFalse:[
  "handle activation of objects written by 4.1.3"

  (self instSize - self firstPublicInstVar) >
  (newClass instSize - newClass firstPublicInstVar) ifTrue:[
    self _halt:'Unable to map subclass of ' , self name ,
               ' to class ' , newClass name .
    ].
  newDict := newClass new .
  passiveObj hasRead: newDict .
  size := passiveObj readSize.
  oldDict := self new .
  oldDict basicLoadFromNoRead: passiveObj size: size newResult: newDict .
].
^ newDict
%

category: 'Repository Conversion'
classmethod: ObsoleteDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteDictionary)
  ifTrue: [ ^ Dictionary ].

^ self.
%

!		Instance methods for 'ObsoleteDictionary'

category: 'Enumerating'
method: ObsoleteDictionary
accompaniedBy: anObj keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 2nd and 3rd arguments.
 aBlock must be a 3 argument block, with arguments anObj, key value ."

self do:[:anAssoc |  aBlock value: anObj value: anAssoc key value: anAssoc value].
%

category: 'Adding'
method: ObsoleteDictionary
add: anAssociation

"Requires an Association as the argument.  If the receiver already includes an
 Association whose key is equal to that of anAssociation, then this method
 redefines the value portion of that Association."

| aKey existingAssoc |

aKey := anAssociation key.
existingAssoc := self associationAt: aKey
                      ifAbsent:[ ^ super add: anAssociation ] .
existingAssoc value: anAssociation value
%

category: 'Accessing'
method: ObsoleteDictionary
associationAt: aKey

"Returns the Association with key aKey.  Generates an error if
 no such Association exists."

^ self associationAt: aKey
       ifAbsent: [^ self _errorKeyNotFound: aKey]
%

category: 'Accessing'
method: ObsoleteDictionary
associationAt: aKey ifAbsent: aBlock

"Returns the Association with key aKey.  If no such Association exists, returns
 the result of evaluating the zero-argument block aBlock."

| anAssoc |
1 to: self size do: [ :j |
  anAssoc := self _at: j .
  (aKey = anAssoc key) ifTrue: [ ^ anAssoc ]
].
^ aBlock value
%

category: 'Accessing'
method: ObsoleteDictionary
associationAt: aKey otherwise: defaultValue

"Returns the Association with key aKey.  If no such Association
 exists, returns the given default value."

| anAssoc |
1 to: self size do: [ :j |
    anAssoc := self _at: j .
    (aKey = anAssoc key) ifTrue: [ ^anAssoc ]
    ].
^defaultValue
%

category: 'Enumerating'
method: ObsoleteDictionary
associationsDo: aBlock

"Evaluates the one-argument block aBlock with each of the receiver's
 Associations as the argument.  Compare with keysDo: and valuesDo:."

^ self do: aBlock
%

category: 'Accessing'
method: ObsoleteDictionary
at: aKey

"Returns the value of the Association with key aKey.  Generates an error if no
 such Association exists."

| anAssoc |
1 to: self size do: [ :j |
  anAssoc := self _at: j .
  aKey = anAssoc key ifTrue: [ ^ anAssoc value ]
] .

"if continuing execution with default result provided by an Exception,
  the default result must be an Association"

anAssoc := self _errorKeyNotFound: aKey .
^ anAssoc value
%

category: 'Accessing'
method: ObsoleteDictionary
at: aKey ifAbsent: aBlock

"Returns the value of the Association with key aKey.  If no such Association
 exists, returns the result of evaluating the zero-argument block aBlock."

| anAssoc |
1 to: self size do: [ :j |
  anAssoc := self _at: j .
  aKey = anAssoc key ifTrue: [ ^ anAssoc value ]
] .
^ aBlock value
%

category: 'Accessing'
method: ObsoleteDictionary
at: aKey otherwise: aValue

"Returns the value of the Association with key aKey.  If no such Association
 exists, returns the given value."

^ self at: aKey ifAbsent:[ aValue ]
%

category: 'Updating'
method: ObsoleteDictionary
at: aKey put: aValue

"Creates a new Association with the given key and value and adds it to the
 receiver.  If the receiver already contains an Association with the given key,
 this makes aValue the value of that Association.  Returns aValue."

| theAssoc |
1 to: self size do: [ :j |
  theAssoc := self _at: j .
  (aKey = theAssoc key) ifTrue: [
     theAssoc value: aValue .
     ^ aValue
     ]
  ].
"not found so add a new Association"
super add: (Association new key: aKey value: aValue).
^ aValue
%

category: 'Storing and Loading'
method: ObsoleteDictionary
basicLoadFromNoRead: passiveObj size: varyingSize newResult: newDict

""

varyingSize = 0 ifTrue: [
  "Old NSC format had no named instance variable section.  A zero-length NSC in
   the old format might read instance variables from an enclosing object if
   there were not a special delimiter that could be reliably found."
  passiveObj checkForBagMark ifFalse: [
    passiveObj checkForInstVarMark ifFalse: [
      ^self
    ].
  ].
].
(passiveObj readNamedIV) ifTrue: [
  "not old NSC format with no named instance variables"
  newDict loadNamedIVsFrom: passiveObj.
  ].
newDict loadVaryingFrom: passiveObj size: varyingSize.
%

category: 'Searching'
method: ObsoleteDictionary
collectAssociations: aBlock

"Evaluates aBlock with each of the receiver's elements as the argument.
 Collects the resulting values into a collection of the same class as the
 receiver, and returns the new collection.  The argument aBlock must be a
 one-argument block."

^ super collect: aBlock
%

category: 'Repository Conversion'
method: ObsoleteDictionary
convertPoolDictionary

"Converts a pool dictionary to a new SymbolDictionary.  Retains the same
 OOP. Returns the receiver."

<primitive: 2001> "enter protected mode"
| prot |
prot := System _protectedMode .
[
  | newSymDict anArray |

  ((self class == ObsoleteDictionary) or:
  [ self class == ObsoleteSymbolDictionary ]) ifFalse: [
    ^ self
  ].

  anArray := Array new.

  self doAssociations: [ :anAssoc |
    anAssoc convertTo5 .
    anArray add: anAssoc.
    ].

  newSymDict := SymbolDictionary new.
  newSymDict objectSecurityPolicy: self objectSecurityPolicy .
  newSymDict _becomeDictionary: self.
  anArray accompaniedBy: self do: [ :me :anAssoc | me add: anAssoc ].
] ensure:[
  prot _leaveProtectedMode
].
^ self
%

category: 'Searching'
method: ObsoleteDictionary
detectAssociations: aBlock

"Evaluates aBlock repeatedly, with elements of the receiver as the argument.
 Returns the first element for which aBlock evaluates to true.  If none of the
 receiver's elements evaluates to true, generates an error.  The argument
 aBlock must be a one-argument block.  Uses associative access when the
 argument is a SelectionBlock."

^ self detectAssociations: aBlock
       ifNone: [^ self _error: #assocErrNoElementsDetected args: { aBlock }]
%

category: 'Searching'
method: ObsoleteDictionary
detectAssociations: aBlock ifNone: exceptionBlock

"Same function as in class Collection, renamed to make it clear that the
 operations are on Associations."

^ super detect: aBlock ifNone: exceptionBlock
%

category: 'Enumerating'
method: ObsoleteDictionary
doAssociations: aBlock

"Evaluates the one-argument block aBlock with each of the receiver's
 Associations as the argument.  Compare with keysDo: and valuesDo:."

^ self do: aBlock
%

category: 'Deprecated'
method: ObsoleteDictionary
doKeys: aBlock

"For each Association in the receiver, evaluates the one-argument block aBlock
 with the Association's key as the argument."
self deprecated: 'doKeys: obsolete,  Use #keysDo:'.
^self keysDo: aBlock
%

category: 'Enumerating'
method: ObsoleteDictionary
doKeysAndValues: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 arguments.  The argument aBlock must be a two-argument block.  The
 first argument is the key and the second argument is the value of
 each key/value pair.  Returns the receiver."

^ self keysAndValuesDo: aBlock.
%

category: 'Enumerating'
method: ObsoleteDictionary
doValues: aBlock

"For each Association in the receiver, evaluates the one-argument block aBlock
 with the Association's value as the argument."

^ self valuesDo: aBlock.
%

category: 'Searching'
method: ObsoleteDictionary
includesAssociation: anAssociation

"Returns true if the argument anAssociation is an element of the receiver.
 Returns false otherwise."

^ super includesIdentical: anAssociation
%

category: 'Searching'
method: ObsoleteDictionary
includesKey: aKey

"Returns true if the receiver contains an Association whose key
 is equal to aKey.  Returns false otherwise."

1 to: self size do: [ :j |
  (aKey = (self _at: j) key)
    ifTrue: [ ^ true ]
].
^ false
%

category: 'Searching'
method: ObsoleteDictionary
includesValue: aValue

"Returns true if any Association in the receiver has the value aValue.  Returns
 false otherwise."

1 to: self size do: [ :j |
   (aValue == (self _at: j) value)
   ifTrue: [ ^true ]
   ].
^ false
%

category: 'Accessing'
method: ObsoleteDictionary
keyAtValue: anObject

"Returns the key of the first value matching the given object, anObject.
 If no match is found, runtime error objErrNotInColl is signaled."

^self keyAtValue: anObject
      ifAbsent: [^ self _error: #objErrNotInColl args: { anObject }]
%

category: 'Accessing'
method: ObsoleteDictionary
keyAtValue: anObject ifAbsent: aBlock

"Returns the key of the first value matching the given object, anObject.  If no
 match is found, evaluate and returns the result of the block aBlock."

1 to: self size do: [:i |
  anObject == ((self _at: i) value) ifTrue: [
    ^(self _at: i) key
  ]
].
^aBlock value
%

category: 'Accessing'
method: ObsoleteDictionary
keys

"Returns a Set containing the receiver's keys."

| result|

result:= IdentitySet new.
1 to: self size do:[:j| result add: (self _at: j) key ].
^result
%

category: 'Enumerating'
method: ObsoleteDictionary
keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 arguments.  The argument aBlock must be a two-argument block.  The
 first argument is the key and the second argument is the value of
 each key/value pair.  Returns the receiver."

self do:[:anAssoc | aBlock value: anAssoc key value: anAssoc value ]
%

category: 'Enumerating'
method: ObsoleteDictionary
keysDo: aBlock

"For each Association in the receiver, evaluates the one-argument block aBlock
 with the Association's key as the argument."

1 to: self size do: [ :j | aBlock value: ((self _at: j) key) ]
%

category: 'Searching'
method: ObsoleteDictionary
occurrencesOf: aValue

"Returns the number of Associations in the receiver with value aValue."

|result|

result:= 0.
1 to: self size do: [ :j |
  (aValue == ((self _at: j) value))
    ifTrue: [ result := result + 1 ]
].
^result
%

category: 'Repository Conversion'
method: ObsoleteDictionary
rehashForConversion

"Private. Converts the receiver to an instance of Dictionary. Only done if
 the receiver is an instance of ObsoleteDictionary. Instances of subclasses
 of ObsoleteDictionary are not converted. Returns the receiver."

<primitive: 2001> "enter protected mode"
| prot |
prot := System _protectedMode .
[ | newDict |
  self class == ObsoleteDictionary ifFalse: [
    ^ self
  ].

  newDict := Dictionary new: (self size).
  newDict objectSecurityPolicy: self objectSecurityPolicy.
  self associationsDo: [ :anAssoc | newDict add: anAssoc ].
  newDict _becomeDictionary: self.
] ensure:[
  prot _leaveProtectedMode
].
^ self
%

category: 'Searching'
method: ObsoleteDictionary
rejectAssociations: aBlock

"Evaluates aBlock with each of the receiver's elements as the argument.  Stores
 the values for which aBlock is false into a collection of the same class as
 the receiver, and returns the new collection.  The argument aBlock must be a
 one-argument block.  Uses associative access when the argument is a
 SelectionBlock."

^ super reject: aBlock
%

category: 'Removing'
method: ObsoleteDictionary
remove: anObject

"Disallowed.  Use removeKey: instead."

self shouldNotImplement: #remove:
%

category: 'Removing'
method: ObsoleteDictionary
remove: anObject ifAbsent: aBlock

"Disallowed.  Use removeKey:ifAbsent: instead."

self shouldNotImplement: #remove:ifAbsent:
%

category: 'Removing'
method: ObsoleteDictionary
removeAssociation: anAssociation

"Removes anAssociation from the receiver, and returns the receiver.
 If anAssociation is absent, generates an error."

^ self removeAssociation: anAssociation
       ifAbsent: [^ self _errorNotFound: anAssociation]
%

category: 'Removing'
method: ObsoleteDictionary
removeAssociation: anAssociation ifAbsent: aBlock

"Removes anAssociation from the receiver, and returns the receiver.
 If anAssociation is absent, evaluates the zero-argument block aBlock
 and returns the result of that evaluation."

^ super remove: anAssociation ifAbsent: aBlock
%

category: 'Removing'
method: ObsoleteDictionary
removeKey: aKey

"Removes the Association with key aKey from the receiver and returns the value
 of that Association.  Generates an error if no Association is present with key
 aKey."

^ self removeKey: aKey
       ifAbsent: [^ self _errorKeyNotFound: aKey]
%

category: 'Removing'
method: ObsoleteDictionary
removeKey: aKey ifAbsent: aBlock

"Removes the Association with key aKey from the receiver and returns the value
 of that Association.  If no Association is present with key aKey, evaluates
 the zero-argument block aBlock and returns the result of that evaluation."

| anAssoc |
anAssoc:= self associationAt: aKey
                    ifAbsent: [^ aBlock value].
self removeAssociation: anAssoc .
^ anAssoc value
%

category: 'Removing'
method: ObsoleteDictionary
removeKeys: keys

"Removes each of the given keys from the receiver.  Does not generate
 an error if the keys do not exist."

| assn removals |
1 to: self size do: [:i |
  assn := self _at: i.
  (keys includesValue: assn key) ifTrue: [
    removals == nil ifTrue: [ removals := IdentitySet new ].
    removals add: assn
  ].
].
1 to: removals size do: [:j |
  super remove: (removals _at: j)
].
%

category: 'Searching'
method: ObsoleteDictionary
selectAssociations: aBlock

"Evaluates aBlock with each of the receiver's elements as the argument.  Stores
 the values for which aBlock is true into a collection of the same class as the
 receiver, and returns the new collection.  The argument aBlock must be a
 one-argument block.  Uses associative access when the argument is a
 SelectionBlock."

^ super select: aBlock
%

category: 'Accessing'
method: ObsoleteDictionary
values

"Returns an OrderedCollection containing the receiver's values."

|result|
result:=  OrderedCollection new.
1 to: self size do:[:j| result add: (self _at: j) value ].
^result
%

category: 'Enumerating'
method: ObsoleteDictionary
valuesDo: aBlock

"For each Association in the receiver, evaluates the one-argument block aBlock
 with the Association's value as the argument."

1 to: self size do: [ :j | aBlock value: ((self _at: j) value) ]
%

category: 'Private'
method: ObsoleteDictionary
_basicAdd: anObject

"Same as IdentityBag | add:.  Has no effect if anObject is nil."

<primitive: 208>

self _primitiveFailed: #_basicAdd: args: { anObject } .
self _uncontinuableError
%

category: 'Searching'
method: ObsoleteDictionary
_detect: aBlock ifNone: errBlock

"Provided for access to Bag|detect:ifNone:"

^super detect: aBlock ifNone: errBlock
%

category: 'Error Handling'
method: ObsoleteDictionary
_errorKeyNotFound: aKey

"No Association with given key, aKey, was found."

^ self _error: #rtErrKeyNotFound args: { aKey }
%

category: 'Searching'
method: ObsoleteDictionary
_idxOccurrencesOf: aValue

"Dictionaries can contain only Associations."

^ 0
%

category: 'Searching'
method: ObsoleteDictionary
_indexOf: aKey

"This method returns the numerical index (as found by _#at:) of the Association
 in the receiver with the given key.  If the key cannot be found, then returns
 nil.  The search is done on equality."

1 to: self size do: [ :i |
  aKey = (self _at: i) key
    ifTrue: [ ^i ]
].
^nil
%

category: 'Searching'
method: ObsoleteDictionary
_keysWithValue: aValue

"Returns a (possibly empty set) of keys associated with the value, aValue."

| result |

result:= IdentitySet new.  "a Set, since we should not have duplicate keys"
self do: [:assoc |
            (assoc value = aValue)
            ifTrue:
               [result add: assoc key]
         ].
^ result
%

category: 'Updating'
method: ObsoleteDictionary
_privAt: aKey put: aValue

"Returns aValue.  Does not check to see if receiver already contains given key.
 Adds new Association containing key and value.  Use with extreme caution since
 you may get multiple occurrences of a key!"

super _basicAdd: (Association new key: aKey value: aValue).
^ aValue
%

! Class extensions for 'ObsoleteException'

!		Class methods for 'ObsoleteException'

removeallmethods ObsoleteException
removeallclassmethods ObsoleteException

category: 'Instance creation'
classmethod: ObsoleteException
new
  self shouldNotImplement: #new
%

category: 'Instance creation'
classmethod: ObsoleteException
new: aSize
  self shouldNotImplement: #new:
%

category: 'Instance creation'
classmethod: ObsoleteException
_basicNew
  self shouldNotImplement: #_basicNew
%

category: 'Instance creation'
classmethod: ObsoleteException
_basicNew: aSize
  self shouldNotImplement: #_basicNew:
%

! Class extensions for 'ObsoleteGsProcess'

!		Class methods for 'ObsoleteGsProcess'

removeallmethods ObsoleteGsProcess
removeallclassmethods ObsoleteGsProcess

category: 'Instance creation'
classmethod: ObsoleteGsProcess
new
  self shouldNotImplement: #new
%

category: 'Instance creation'
classmethod: ObsoleteGsProcess
new: aSize
  self shouldNotImplement: #new:
%

category: 'Instance creation'
classmethod: ObsoleteGsProcess
_basicNew
  self shouldNotImplement: #_basicNew
%

category: 'Instance creation'
classmethod: ObsoleteGsProcess
_basicNew: aSize
  self shouldNotImplement: #_basicNew:
%

! Class extensions for 'ObsoleteIdentityCollisionBucket'

!		Instance methods for 'ObsoleteIdentityCollisionBucket'

removeallmethods ObsoleteIdentityCollisionBucket
removeallclassmethods ObsoleteIdentityCollisionBucket

category: 'Private'
method: ObsoleteIdentityCollisionBucket
compareKey: key1 with: key2

"Returns true if key1 is identical to key2, and false otherwise."

^ key1 == key2
%

! Class extensions for 'ObsoleteIdentityDictionary'

!		Class methods for 'ObsoleteIdentityDictionary'

removeallmethods ObsoleteIdentityDictionary
removeallclassmethods ObsoleteIdentityDictionary

category: 'Storing and Loading'
classmethod: ObsoleteIdentityDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: IdentityDictionary
%

category: 'Repository Conversion'
classmethod: ObsoleteIdentityDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteIdentityDictionary)
  ifTrue: [ ^ IdentityDictionary ].

^ self.
%

!		Instance methods for 'ObsoleteIdentityDictionary'

category: 'Accessing'
method: ObsoleteIdentityDictionary
associationAt: aKey ifAbsent: aBlock

"Returns the Association with key aKey.  Comparison is based on identity, not
 equality.  If no such Association exists, returns the result of evaluating the
 zero-argument block aBlock."

^self _detect: {:x | x.key == aKey} ifNone: [aBlock value]
%

category: 'Accessing'
method: ObsoleteIdentityDictionary
at: aKey

"Returns the value of the Association with key aKey.  Comparison is based on
 identity, not equality.  Generates an error if no such Association exists."

| theAssoc |
theAssoc := self _detect: {:x | x.key == aKey}
                  ifNone: [ theAssoc := self _errorKeyNotFound: aKey] .
^ theAssoc value
%

category: 'Accessing'
method: ObsoleteIdentityDictionary
at: aKey ifAbsent: aBlock

"Returns the value of the Association with key aKey.  Comparison is based on
 identity, not equality.  If no such Association exists, returns the result of
 evaluating the zero-argument block aBlock."

self size = 0 ifTrue: [^aBlock value].
^(self associationAt: aKey ifAbsent: [^aBlock value]) value
%

category: 'Accessing'
method: ObsoleteIdentityDictionary
at: aKey otherwise: aValue

"Returns the value of the Association with key aKey.  If no such Association
 exists, returns the given value."

| sz anAssoc |
sz := self size.
sz = 0 ifTrue: [ ^aValue ].

1 to: sz do: [ :j |
  anAssoc := self _at: j.
  aKey == anAssoc key ifTrue: [ ^anAssoc value ]
].
^aValue
%

category: 'Updating'
method: ObsoleteIdentityDictionary
at: aKey put: aValue

"Creates a new Association with the given key and value and adds it to the
 receiver.  If the receiver already contains an Association with the given key,
 this makes aValue the value of that Association.  Returns aValue."

| assn |
assn := self associationAt: aKey ifAbsent: [nil].
assn == nil ifTrue: [
  super _basicAdd:
    ((Association) new key: aKey value: aValue)
  ]
ifFalse: [
  assn value: aValue
  ].
^aValue
%

category: 'Searching'
method: ObsoleteIdentityDictionary
includesKey: aKey

"Returns true if the receiver contains an Association whose key is aKey.
 Returns false otherwise."

^ (self associationAt: aKey otherwise: nil ) ~~ nil
%

category: 'Repository Conversion'
method: ObsoleteIdentityDictionary
rehashForConversion

    "Replace the 5.1.2 version of this method. This version will cause
    the receiver to become an IdentityKeyValueDictionary rather than
    an IdentityDictionary. The new choice is more efficient and is the
    class that is mapped to VW's IdentityDictionary."

<primitive: 2001> "enter protected mode"
| prot |
prot := System _protectedMode .
[
  | newDict |
  self class == ObsoleteIdentityDictionary ifFalse:[
    ^self
  ].
  newDict := IdentityKeyValueDictionary new: self size.
  newDict objectSecurityPolicy: self objectSecurityPolicy.
  self keysAndValuesDo: [ :key :value |
       newDict at: key put: value
  ].
  newDict _becomeDictionary: self.
] ensure:[
  prot _leaveProtectedMode
]
%

category: 'Removing'
method: ObsoleteIdentityDictionary
removeKey: aKey ifAbsent: aBlock

"Removes the Association with key aKey from the receiver and returns the value
 of that Association.  If no Association is present with key aKey, this method
 evaluates the zero-argument block aBlock and returns the result of that
 evaluation."

|assn|

assn := self associationAt: aKey ifAbsent: [^aBlock value].
self removeAssociation: assn.
^assn value
%

! Class extensions for 'ObsoleteLanguageDictionary'

!		Class methods for 'ObsoleteLanguageDictionary'

removeallmethods ObsoleteLanguageDictionary
removeallclassmethods ObsoleteLanguageDictionary

category: 'Storing and Loading'
classmethod: ObsoleteLanguageDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: LanguageDictionary
%

category: 'Repository Conversion'
classmethod: ObsoleteLanguageDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteLanguageDictionary)
  ifTrue: [ ^ LanguageDictionary ].

^ self.
%

!		Instance methods for 'ObsoleteLanguageDictionary'

category: 'Repository Conversion'
method: ObsoleteLanguageDictionary
rehashForConversion

"Private. Converts the receiver to an instance of Dictionary. Only done if
 the receiver is an instance of ObsoleteDictionary. Instances of subclasses
 of ObsoleteDictionary are not converted. Returns the receiver."

<primitive: 2001> "enter protected mode"
| prot |
prot := System _protectedMode .
[
  | newDict anArray aSet |

  self class == ObsoleteLanguageDictionary ifFalse: [
    ^ self
  ].

  anArray := Array new.
  aSet := IdentitySet new.
  self associationsDo: [ :anAssoc |
    anArray add: anAssoc.
    aSet add: anAssoc class
    ].

  "If all the ObsoleteSymbolAssociations  have not been converted to
   SymbolAssociation, retain the receiver as an ObsoleteLanguageDictionary."
  (aSet includes: ObsoleteSymbolAssociation)
    ifTrue: [ ^ self ].

  newDict := LanguageDictionary new: (self size).
  newDict objectSecurityPolicy: self objectSecurityPolicy.
  newDict _becomeDictionary: self.
  anArray accompaniedBy: self do: [ :me :anAssoc | me add: anAssoc ].
] ensure:[
  prot _leaveProtectedMode
].
^ self
%

category: 'Accessing'
method: ObsoleteLanguageDictionary
value

"Returns the value associated with the user's native language symbol.  The
 user's language symbol is taken from his UserProfile object.  If there is no
 entry for the given language, an error is generated."

|myLanguage "the Symbol representing the user's native language"|

myLanguage := System myUserProfile nativeLanguage.
^ self at: myLanguage
       ifAbsent: [^ self _errorKeyNotFound: myLanguage]
%

! Class extensions for 'ObsoleteMetaclass'

!		Instance methods for 'ObsoleteMetaclass'

removeallmethods ObsoleteMetaclass
removeallclassmethods ObsoleteMetaclass

category: 'Class Instance Variables'
method: ObsoleteMetaclass
addInstVarNames: instVarNamesArray

"Adds the instance variables specified in the argument to the receiver and any
 of its subclasses.  Generates an error upon encountering a name that is not a
 valid instance variable name or that is already an instance variable of the
 receiver.

 Instance variables that are added to a Metaclass are called
 Class Instance Variables."

| ivnames oldEnd |

(thisClass isInvariant not or: [thisClass subclassesDisallowed]) ifFalse: [
  ^ self _error: #rtErrClassNotModifiable
  ].
instVarNamesArray size == 0 ifTrue: [ ^self ].
"allow an error handler to proceed from the errors signaled by the validation
 method and thus skip offending instance variable names"
ivnames := { } .
instVarNamesArray do:[ :aStr | ivnames add: aStr asSymbol ].
ivnames := ivnames select: [:e |
  self _validateNewClassInstVar: e
  ].
oldEnd := self instSize + 1.
self _inheritCIVs: ivnames at: oldEnd.
%

category: 'Accessing'
method: ObsoleteMetaclass
classHistory

"Returns the classHistory for the Class of which the receiver is a Metaclass."

^ thisClass classHistory
%

category: 'Updating the Method Dictionary'
method: ObsoleteMetaclass
compileAccessingMethodsFor: anArrayOfSymbols

"Reimplemented to treat class instance variables specially.
 The new methods have environmentId == 0 .  "

| allVarNames varName symlst |

symlst := SymbolList new.
varName := 'newValue'.
allVarNames := self allInstVarNames.
[allVarNames includesValue: varName] whileTrue: [
  varName := 'z' , varName.
].
anArrayOfSymbols do: [ :var | | lf methodtext |
  lf := Character lf .
  (methodtext := String new) add: var ; add: lf ; add: lf ;
    add: '   "Return the value of the instance variable ''' ; add: var ;
    add: '''."' ; add: lf  ; add: '   ^' ; add: var ; add: lf .
  [  self compileMethod: methodtext dictionaries: symlst
       category: #Accessing environmentId: 0
  ] onException: CompileError do:[:ex |
     self _error: #classErrNotAVar args: { var }
  ].
  (allVarNames indexOf: var) > ObsoleteMetaclass instSize ifTrue: [
    "compile a method that lets the variable be modified if the user has
     the proper authority"
    (methodtext := String new )
      add: var; add: ': '; add: varName; add: lf;
      add: '  "changes the value of the receiver''s class instance variable ''';
      add: var; add: '''"'; add: lf;
      add: lf;
      add: '  self atClassInstVar: #'; add: var;
      add: ' put: '; add: varName; add: lf .
    [ self compileMethod: methodtext
       dictionaries: symlst
       category: #Updating environmentId: 0
    ] onException: CompileError do:[:ex |
         self _error: #classErrNotAVar args: { var }
    ].
  ] ifFalse: [
    (methodtext := String new ) add: var ; add: ': ' ; add: varName ; add: lf ; add: lf ;
      add: '   "Modify the value of the instance variable ''' ; add: var ;
      add: '''."' ; add: lf ; add:'   ' ; add: var ; add:' := ' ; add: varName ; add: lf .
    [ self compileMethod: methodtext
      dictionaries: symlst
      category: #Updating environmentId: 0
    ] onException: CompileError do:[:ex |
      self _error: #classErrNotAVar args: { var }
    ].
  ].
].
%

category: 'Accessing'
method: ObsoleteMetaclass
extraDict

"Returns the extraDict of the receiver's sole instance.  See Class | extraDict."

^thisClass extraDict
%

category: 'Displaying'
method: ObsoleteMetaclass
instanceString

"Returns a string that can be used to name an instance of the receiver.  Since
 the receiver has one instance, returns the name of that instance."

^thisClass name
%

category: 'Displaying'
method: ObsoleteMetaclass
instanceSymbol

"Returns a symbol that can be used to name an instance of the receiver.  Since
 a Metaclass has only one instance, returns the name of that instance."

^thisClass name
%

category: 'Queries'
method: ObsoleteMetaclass
isMeta

"Returns whether the receiver is a kind of Metaclass."

^true
%

category: 'Method Timestamps'
method: ObsoleteMetaclass
methodStampDictName
  ^ #GSMetaMethodStampDict
%

category: 'Accessing'
method: ObsoleteMetaclass
name

"Returns the name of the receiver.  For example, SmallInteger class
 name returns SmallInteger class (the receiver, a Metaclass)."

(thisClass == nil)
  ifTrue:[^'aMetaclass']
  ifFalse:[^thisClass name , ' class']
%

category: 'Instance Creation'
method: ObsoleteMetaclass
new

"Disallowed.  To create a new Class or Metaclass, use
 Class | subclass:instVarNames:.. instead."

self shouldNotImplement: #new
%

category: 'Instance Creation'
method: ObsoleteMetaclass
new: anInteger

"Disallowed.  To create a new Class or Metaclass, use
 Class | subclass:instVarNames:.. instead."

self shouldNotImplement: #new:
%

category: 'Pragmas'
method: ObsoleteMetaclass
pragmaDictName

  ^ #GSMetaMethodPragmaDict
%

category: 'Class Timestamps'
method: ObsoleteMetaclass
theNonMetaClass
  "Sent to a class or metaclass, always return the class.
   Used by Monticello."

  ^ thisClass
%

category: 'Accessing'
method: ObsoleteMetaclass
thisClass

"Returns the Class of which the receiver is a Metaclass.  For example,
 SmallInteger class thisClass returns SmallInteger (the Class)."

^ thisClass
%

category: 'Accessing'
method: ObsoleteMetaclass
transientMethodDictForEnv: envId
  "instances of ObsoleteMetaclass have no transient method dicts"
  ^ nil
%

category: 'Category'
method: ObsoleteMetaclass
_classCategory

"Returns the classCategory of the receiver."

^ thisClass _classCategory
%

category: 'Private'
method: ObsoleteMetaclass
_gbsTraversalCallback

"Private.  When GemBuilder Smalltalk traverses a Metaclass, this method
 is called to return a description of the Metaclass."

^self printString
%

category: 'Class Instance Variables'
method: ObsoleteMetaclass
_inheritCIVs: ivnames at: inheritedIVIndex

"Adds the instance variables specified in the argument to the receiver at the
 given location.

 Instance variables that are added to a Metaclass are called
 Class Instance Variables."

| constr names vname subClss numNewIvs |

(numNewIvs := ivnames size) == 0 ifTrue: [ ^self ].
(numNewIvs + self instSize) > GEN_MAX_INSTANCE_VARS ifTrue:[
  self error: 'new instVars would exceed max number of instVars'
].
constr := { Object }.
names := Array withAll: instVarNames.
1 to: numNewIvs do: [:i |
  vname := ( ivnames at: i) asSymbol .
  names insertObject: vname at: (inheritedIVIndex + i - 1).
  self _incrementInstVars: 1  .
  self _unsafeAt: 4 put: (InvariantArray withAll: names).
  self _unsafeAt: 5 put: constraints + constr.
  "force the class to increase in size by storing one position off the end"
  self _refreshClassCache: false .
  thisClass _insertCivAt: (inheritedIVIndex + i - 1).
  ].
thisClass _refreshClassCache: false .
thisClass subclassesDisallowed ifFalse: [
  subClss := self _subclasses.
  subClss ~~ nil ifTrue:[
    subClss do: [:e |
      e _inheritCIVs: ivnames at: inheritedIVIndex.
      ].
    ].
  ].
"finally, recompile my methods to ensure that the instance variable indexes are
 correct"
self _recompileMethodsAfterNewIvOffset: inheritedIVIndex.
%

category: 'Modifying Classes'
method: ObsoleteMetaclass
_setClassVars: aDict old: previousDict
  classVars ~~ aDict ifTrue:[
    previousDict ~~ classVars ifTrue:[ self error:'invalid store to classVars'].
    classVars := aDict .
    thisClass _setClassVars: aDict old: previousDict
  ].
%

category: 'Accessing'
method: ObsoleteMetaclass
_subclasses

"If thisClass is tracking subclasses, returns the corresponding list
 of Metaclasses."

| subclss result |

subclss := thisClass _subclasses .
subclss == nil ifTrue:[ ^ nil ].
result := IdentitySet new .
subclss do:[ :aClass | result add: aClass class ].
^ result
%

category: 'Class Instance Variables'
method: ObsoleteMetaclass
_validateNewClassInstVar: ivname

"Returns true if the name passes all tests.  Generates errors if the name fails
 due to a) being an invalid identifier or b) being a duplicate of an existing
 instance variable, either in this Metaclass or in one of this Metaclass's
 instance's subclasses Metaclasses."

| subs |
((ivname size == 0
  or: [ivname isValidIdentifier not])
  or:[ ivname _isSymbol not]) ifTrue: [
  self _error: #classErrBadIdentifier args: { ivname }.
  ^false
  ].
(instVarNames includesIdentical: ivname) ifTrue: [
  self _error: #rtErrAddDupInstvar args: { ivname }.
  ^false
  ].
thisClass isModifiable ifTrue: [
  subs := self _subclasses .
  subs ~~ nil ifTrue: [
    subs do: [:sub |
      (sub _validateNewClassInstVar: ivname) ifFalse: [ ^false ]
      ].
    ].
  ].
^true
%

! Class extensions for 'ObsoleteSymbol'

!		Class methods for 'ObsoleteSymbol'

removeallmethods ObsoleteSymbol
removeallclassmethods ObsoleteSymbol

category: 'Storing and Loading'
classmethod: ObsoleteSymbol
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst |

"since ObsoleteSymbols can't refer to other objects, the 'hasRead:' message
 may be sent after values have been filled in.  Subclasses of ObsoleteSymbol
 that contain pointer variables must reimplement this method"

inst := String new .
inst size: passiveObj readSize.
inst loadFrom: passiveObj .
inst changeClassTo: self.
^inst
%

category: 'Repository Conversion'
classmethod: ObsoleteSymbol
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbol)
  ifTrue: [ ^ Symbol ].

^ self.
%

!		Instance methods for 'ObsoleteSymbol'

category: 'Comparing'
method: ObsoleteSymbol
= aCharCollection

"Returns true if the receiver is equivalent to the argument, returns false
 otherwise."

aCharCollection _isSymbol ifTrue:[
  "Use the primitive in Symbol for special behavior of ObsoleteSymbols."
  ^ aCharCollection = self
  ].
^ super = aCharCollection
%

category: 'Converting'
method: ObsoleteSymbol
asObsoleteSymbol

"Returns the receiver."

^ self
%

category: 'Converting'
method: ObsoleteSymbol
asObsoleteSymbolKind

"Equivalent to asObsoleteSymbol."

 ^self
%

category: 'Converting'
method: ObsoleteSymbol
asString

"Returns a copy of the receiver as an instance of class String."

^ String withAll: self
%

category: 'Converting'
method: ObsoleteSymbol
asSymbol

"Returns a copy of the receiver as an instance of class Symbol."

^ Symbol withAll: self
%

category: 'Repository Conversion'
method: ObsoleteSymbol
convertTo5

"Returns a copy of the receiver as an instance of class Symbol."

^ Symbol withAll: self
%

category: 'Converting'
method: ObsoleteSymbol
copy

"Returns a copy of the receiver."

^ ObsoleteSymbol withAll: self
%

category: 'Testing'
method: ObsoleteSymbol
isObsoleteSymbol

"Returns true."

 ^true
%

category: 'Formatting'
method: ObsoleteSymbol
printOn: aStream

"Puts a displayable representation of the receiver on the given stream.
 That representation conforms to GemStone Smalltalk parsing rules."

| mySize |
(mySize := self size) == 0 ifTrue:[
  aStream nextPut: $# .
  aStream nextPut: $' .
  aStream nextPut: $' .
  ]
ifFalse:[
  mySize < 50 ifTrue:[
    self containsSeparator   "containsSeparator is expensive"
    ifFalse:[
      aStream nextPut: $# .
      aStream nextPutAll: self
      ]
    ifTrue:[
      aStream nextPut: $# .
      super printOn: aStream
      ]
    ]
  ifFalse:[
    "do it the efficient way for large ObsoleteSymbols"
    aStream nextPut: $# .
    super printOn: aStream
    ]
  ]
%

category: 'Repository Conversion'
method: ObsoleteSymbol
transformIntoString

"Private. Transforms the receiver from an ObsoleteSymbol to a
 String while keeping its identity the same."

<primitive: 488>
self _primitiveFailed: #transformIntoString
%

category: 'Repository Conversion'
method: ObsoleteSymbol
transformIntoSymbol

"Private. Attempts to transform the receiver from an ObsoleteSymbol to a
 Symbol while keeping its identity the same. If retaining the identity is not
 possible, returns a Symbol with the same contents."

<primitive: 479>
self _primitiveFailed: #transformIntoSymbol
%

category: 'Formatting'
method: ObsoleteSymbol
withNoColons

"Returns a copy of the receiver with all colons removed."

^self copyWithout: $:
%

! Class extensions for 'ObsoleteSymbolAssociation'

!		Class methods for 'ObsoleteSymbolAssociation'

removeallmethods ObsoleteSymbolAssociation
removeallclassmethods ObsoleteSymbolAssociation

category: 'Repository Conversion'
classmethod: ObsoleteSymbolAssociation
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolAssociation)
  ifTrue: [ ^ SymbolAssociation ].

^ self.
%

!		Instance methods for 'ObsoleteSymbolAssociation'

category: 'Repository Conversion'
method: ObsoleteSymbolAssociation
convertTo5

"Converts the receiver from an instance of ObsoleteSymbolAssociation
 to an instance of SymbolAssociation without changing its identity.
 Returns the converted receiver."

<primitive: 472>

self _primitiveFailed: #convertTo5.
%

category: 'Private'
method: ObsoleteSymbolAssociation
_resolveRcConflictsWith: conflictObjects

"A logical write-write conflict has occurred on the receiver.  This
 may have occurred due to artificially placing the receiver in the write
 set when a subclass re-implemented this method (this is done to maintain
 cache coherency. See if the state has changed in this transaction.  If
 so, then it is a valid conflict (and returns false); otherwise returns true."

| preAbortValue |
preAbortValue := value.
self _selectiveAbort.
^ value == preAbortValue
%

! Class extensions for 'ObsoleteSymbolDictionary'

!		Class methods for 'ObsoleteSymbolDictionary'

removeallmethods ObsoleteSymbolDictionary
removeallclassmethods ObsoleteSymbolDictionary

category: 'Storing and Loading'
classmethod: ObsoleteSymbolDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: SymbolDictionary
%

category: 'Repository Conversion'
classmethod: ObsoleteSymbolDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolDictionary)
  ifTrue: [ ^ SymbolDictionary ].

^ self.
%

!		Instance methods for 'ObsoleteSymbolDictionary'

category: 'Adding'
method: ObsoleteSymbolDictionary
addAll: aCollection

"Adds all of the elements of aCollection to the receiver and returns the
 receiver.  If aCollection is a kind of KeyValueDictionary, then adds new
 Associations that reference the key/value pairs found in aCollection."

(self == aCollection) ifTrue: [ ^ self addAll: (aCollection copy) ].
aCollection accompaniedBy: self do: [:me :each | me add: each ].
^ self
%

category: 'Repository Conversion'
method: ObsoleteSymbolDictionary
asGsMethodDictionary

"Convert an instance of ObsoleteSymbolDictionary to an instance of
 GsMethodDictionary."

| newGsDict |

newGsDict := GsMethodDictionary new.
self keysAndValuesDo: [ :aKey :aValue |
  newGsDict at: (aKey convertTo5) put: aValue.
  ].
newGsDict objectSecurityPolicy: self objectSecurityPolicy .
^ newGsDict.
%

category: 'Accessing'
method: ObsoleteSymbolDictionary
associationAt: aKey ifAbsent: aBlock

"Returns the SymbolAssociation with key aKey.  If no such SymbolAssociation
 exists, returns the result of evaluating the zero-argument block aBlock."

<primitive: 48>
| aSym |
aKey _isSymbol ifFalse:[
  aSym := Symbol _existingWithAll: aKey .
  aSym ~~ nil ifTrue:[
    ^ self associationAt: aSym ifAbsent: aBlock .
    ].
  ].
aBlock == nil ifTrue:[ ^ nil ] .
^ aBlock value
%

category: 'Accessing'
method: ObsoleteSymbolDictionary
at: aKey

"Returns the value of the SymbolAssociation with key aKey.  Generates an error
 if no such SymbolAssociation exists."

| anAssoc |
anAssoc := self associationAt: aKey
                ifAbsent: nil "avoid creating a ComplexBlock" .
anAssoc == nil ifTrue:[ anAssoc := self _errorKeyNotFound: aKey ].
^ anAssoc value
%

category: 'Accessing'
method: ObsoleteSymbolDictionary
at: aKey ifAbsent: aBlock

"Returns the value of the Association with key aKey.  If no such
 Association exists, returns the result of evaluating the zero-argument
 block aBlock."

| assoc |
assoc := self associationAt: aKey otherwise: nil .
assoc == nil ifTrue:[
  aBlock == nil ifTrue:[ ^ nil ].
  ^ aBlock value
  ].
^ assoc value
%

category: 'Updating'
method: ObsoleteSymbolDictionary
at: aKey put: aValue

"Creates a new SymbolAssociation with the given key and
 value and adds it to the receiver.  If the receiver already contains an
 Association with the given key, this makes aValue the value of that
 Association.  Returns aValue."

<primitive: 304>
aKey _isSymbol ifFalse:[
  ^ self at: (aKey asSymbol) put: aValue
  ].
^ self _primitiveFailed: #at:put: args: { aKey . aValue }
%

category: 'Repository Conversion'
method: ObsoleteSymbolDictionary
convertTo5

"Returns an instance of SymbolDictionary containing the converted contents
 of the receiver."

<primitive: 2001> "enter protected mode"
| prot |
prot := System _protectedMode .
[
  | newSymDict tempArray |

  (self class == ObsoleteSymbolDictionary) ifFalse: [
    ^ self
  ].
  "User defined subclasses cannot be converted here."

  newSymDict := SymbolDictionary new.
  tempArray := Array new.

  self doAssociations: [ :anObsSymAssoc |
    tempArray add: (anObsSymAssoc convertTo5)
    ].

  newSymDict objectSecurityPolicy: self objectSecurityPolicy .
  self _becomeDictionary: newSymDict .

  tempArray do: [ :anAssoc |
    self addAssociation: anAssoc
    ].
] ensure:[
  prot _leaveProtectedMode
].
^ self
%

category: 'Repository Conversion'
method: ObsoleteSymbolDictionary
convertToCategories

"Convert an instance of ObsoleteSymbolDictionary to an instance of
 GsMethodDictionary."

| newGsDict |

newGsDict := GsMethodDictionary new.
self keysAndValuesDo: [ :aKey :aValue |
  newGsDict at: (aKey asSymbol) put: (aValue convertToSymbolSet).
  ].
newGsDict objectSecurityPolicy: self objectSecurityPolicy .
^ newGsDict.
%

category: 'Searching'
method: ObsoleteSymbolDictionary
includesKey: aKey

"Returns true if the receiver contains a SymbolAssociation whose key is equal
 to aKey.  Returns false otherwise."

self at: aKey ifAbsent:[ ^ false ].
^ true
%

category: 'Accessing'
method: ObsoleteSymbolDictionary
keys

"Reimplemented.  Returns a SymbolSet containing the receiver's keys."

| result |
result := SymbolSet new.
1 to: self size do:
  [ :i | result _addSymbol: (self _at: i) key ].
^result
%

category: 'Accessing'
method: ObsoleteSymbolDictionary
name

"Returns the key of an Association whose value is the receiver.  If the
 receiver contains no such Association, returns nil."

^ (self detectAssociations:{:i| i.value == self } ifNone:[^ nil ] ) key .
%

category: 'Repository Conversion'
method: ObsoleteSymbolDictionary
rehashForConversion

"Private. Converts the receiver to an instance of Dictionary. Only done if
 the receiver is an instance of ObsoleteDictionary. Instances of subclasses
 of ObsoleteDictionary are not converted. Returns the receiver."

<primitive: 2001> "enter protected mode"
| prot |
prot := System _protectedMode .
[ | newDict anArray onlySymbols |

  self class == ObsoleteSymbolDictionary ifFalse: [
    ^ self
  ].

  anArray := Array new.
  onlySymbols := true.
  self doAssociations: [ :anAssoc |
    (anAssoc class == SymbolAssociation) ifFalse: [ onlySymbols := false ].
    anArray add: anAssoc.
    ].

  (onlySymbols)
    ifTrue: [ newDict := SymbolDictionary new: (self size) ]
    ifFalse: [ newDict := Dictionary new: (self size) ].

  newDict objectSecurityPolicy: self objectSecurityPolicy.
  newDict _becomeDictionary: self.

  anArray accompaniedBy: self do: [:me :anAssoc | me add: anAssoc.  ].
] ensure:[
  prot _leaveProtectedMode
].
^ self
%

category: 'Accessing'
method: ObsoleteSymbolDictionary
_behaviorKeys

"Returns a SymbolSet containing keys in the receiver whose values are
 Behaviors."

"This is used as an optimization by the GemBuilder for Smalltalk browser."

| result |
result := SymbolSet new.
1 to: self size do:
  [ :i |
    (self _at: i) value isBehavior
      ifTrue: [ result _addSymbol: (self _at: i) key ].
  ].
^result
%

category: 'Browser Methods'
method: ObsoleteSymbolDictionary
_classAndVersionStrings

"For all Behaviors in the receiver, returns an OrderedCollection of Strings
 showing the class name and version.  This method is used as an optimization by
 the GemBuilder for Smalltalk browser."

| result |
result := OrderedCollection new .
self do: [ :anAssoc | | each |
  each := anAssoc value.
  each isBehavior
  ifTrue: [ result add:
              ( each classHistory size = 1
                 ifTrue: [ each name asString ]
                 ifFalse: [ each name , ' [ ' ,
                      ( each classHistory indexOf: each ) printString , ' ]' ]
               )
    ]
  ].
^result
%

! Class extensions for 'ObsoleteSymbolKeyValueDictionary'

!		Class methods for 'ObsoleteSymbolKeyValueDictionary'

removeallmethods ObsoleteSymbolKeyValueDictionary
removeallclassmethods ObsoleteSymbolKeyValueDictionary

category: 'Storing and Loading'
classmethod: ObsoleteSymbolKeyValueDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: SymbolKeyValueDictionary
%

category: 'Repository Conversion'
classmethod: ObsoleteSymbolKeyValueDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolKeyValueDictionary)
  ifTrue: [ ^ SymbolKeyValueDictionary ].

^ self.
%

!		Instance methods for 'ObsoleteSymbolKeyValueDictionary'

category: 'Updating'
method: ObsoleteSymbolKeyValueDictionary
at: aKey put: aValue

"Stores the aKey/aValue pair in the receiver.  If aKey is a CharacterCollection
 but not an obsolete symbol, an obsolete symbol of equal value is created for
 the key.  Rebuilds
 the hash table if the addition causes the number of collisions to exceed the
 limit allowed.  Returns aValue.

 If aKey is being added for the first time, an invariant copy of it is stored
 as the key."

"_stringAt:put: primitive has been removed from the VM."
Error signal:'ObsoleteSymbolKeyValueDictionary>>at:put: no longer implemented'.
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
containsOnlySymbols

"Private. Checks to see if all its keys are Symbols (and not ObsoleteSymbols)"

self keysDo: [ :aKey |
  (aKey _isSymbol) ifFalse: [ ^ false ]
  ].

^ true.
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
convertToStringKeyValDict

"Private. Converts the receiver to be an instance of StringKeyValueDictionary."

<primitive: 484>
self _primitiveFailed: #convertToStringKeyValDict
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
convertToSymbolKeyValDict

"Private. Converts the receiver to be an instance of SymbolKeyValueDictionary."

<primitive: 484>
self _primitiveFailed: #convertToSymbolKeyValDict
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
rehashForConversion

"Private. Rehashes the receiver because the hash values of some of its keys
 may have changed."

| newSize |

(self class == ObsoleteSymbolKeyValueDictionary)
  ifTrue: [
    (self containsOnlySymbols)
      ifTrue:  [ self convertToSymbolKeyValDict ]
      ifFalse: [ self convertToStringKeyValDict ].
    ].

newSize := (Integer _selectedPrimeGreaterThan: numElements) max: tableSize.
self rebuildTable: newSize.
%

! Class extensions for 'ObsoleteSymbolListDictionary'

!		Class methods for 'ObsoleteSymbolListDictionary'

removeallmethods ObsoleteSymbolListDictionary
removeallclassmethods ObsoleteSymbolListDictionary

category: 'Storing and Loading'
classmethod: ObsoleteSymbolListDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: SymbolDictionary
%

category: 'Storing and Loading'
classmethod: ObsoleteSymbolListDictionary
loadFrom: passiveObj mappingToClass: newClass

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

| newDict oldDict size |
(passiveObj version >= 500 or:[ newClass == self]) ifTrue:[
  size := passiveObj readSize.
  newDict := self new.
  newDict loadFrom: passiveObj size: size.
  ]
ifFalse:[
  "handle activation of objects written by 4.1.3"

  (self instSize - self firstPublicInstVar) >
  (newClass instSize - newClass firstPublicInstVar) ifTrue:[
    self _halt:'Unable to map subclass of ' + self name +
               ' to class ' + newClass name .
    ].
  newDict := newClass new .
  passiveObj hasRead: newDict .
  size := passiveObj readSize.
  oldDict := self new .
  oldDict basicLoadFromNoRead: passiveObj size: size .
  oldDict associationsDo:[:assoc | newDict addAssociation: assoc ].
  oldDict initialize: 1 .
].
^ newDict
%

category: 'Repository Conversion'
classmethod: ObsoleteSymbolListDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolListDictionary)
  ifTrue: [ ^ SymbolDictionary ].

^ self.
%

!		Instance methods for 'ObsoleteSymbolListDictionary'

category: 'Enumerating'
method: ObsoleteSymbolListDictionary
accompaniedBy: anObj keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 2nd and 3rd arguments.
 aBlock must be a 3 argument block, with arguments anObj, key value ."

super keysAndValuesDo: [ :aKey :aSymAssoc |
  aBlock value: anObj value: aKey value: aSymAssoc value
].
%

category: 'Adding'
method: ObsoleteSymbolListDictionary
add: aSymAssoc

"Requires a ObsoleteSymbolAssociation as the argument.  If the receiver already
 includes a ObsoleteSymbolAssociation whose key is equal to that of aSymAssoc, this
 method redefines the value portion of that ObsoleteSymbolAssociation."

| anAssoc aKey |
aKey:= aSymAssoc key.
anAssoc:= self associationAt: aKey otherwise: nil .
anAssoc == nil ifTrue:[ super at: aKey put: aSymAssoc.
                      ^self ].
anAssoc value: (aSymAssoc value).
^self
%

category: 'Repository Conversion'
method: ObsoleteSymbolListDictionary
asGsMethodDictionary

"Convert an instance of ObsoleteSymbolListDictionary to an instance of
 GsMethodDictionary."

| newGsDict |

newGsDict := GsMethodDictionary new.
self associationsDo: [ :anObsSymAssoc |
  newGsDict addAssociation: (anObsSymAssoc convertTo5)
  ].
newGsDict objectSecurityPolicy: self objectSecurityPolicy .
^ newGsDict.
%

category: 'Accessing'
method: ObsoleteSymbolListDictionary
associationAt: aKey

"Returns the ObsoleteSymbolAssociation with key aKey.  Generates an error if
 no such ObsoleteSymbolAssociation exists."

| anAssoc |

anAssoc :=  self associationAt: aKey otherwise: nil.
anAssoc == nil ifTrue:[ anAssoc := self _errorKeyNotFound: aKey] .
^ anAssoc
%

category: 'Accessing'
method: ObsoleteSymbolListDictionary
associationAt: aKey ifAbsent: aBlock

"Returns the ObsoleteSymbolAssociation with key aKey.  If no such
 ObsoleteSymbolAssociation
 exists, returns the result of evaluating the zero-argument block aBlock."

^ super at: aKey ifAbsent: aBlock.
%

category: 'Accessing'
method: ObsoleteSymbolListDictionary
associationAt: aKey otherwise: defaultValue

"Returns the ObsoleteSymbolAssociation with key aKey.  If no such ObsoleteSymbolAssociation
 exists, returns the given default value."

^ super at: aKey otherwise: defaultValue.
%

category: 'Enumerating'
method: ObsoleteSymbolListDictionary
associationsDo: aBlock

"Evaluates aBlock with each of the receiver's Associations as the
 argument. The argument aBlock must be a one-argument block.  Returns
 the receiver."

super keysAndValuesDo: [ :aKey :aSymAssoc | aBlock value: aSymAssoc ].
^self
%

category: 'Accessing'
method: ObsoleteSymbolListDictionary
at: aKey

"Returns the value of the ObsoleteSymbolAssociation with key
 aKey.  Generates an error if no such ObsoleteSymbolAssociation exists."

| anAssoc |
anAssoc:= self associationAt: aKey otherwise: nil .
anAssoc == nil ifTrue:[ anAssoc := self _errorKeyNotFound: aKey ].
^anAssoc value
%

category: 'Accessing'
method: ObsoleteSymbolListDictionary
at: aKey ifAbsent: aBlock

"Returns the value of the ObsoleteSymbolAssociation with key aKey.  If no such
 ObsoleteSymbolAssociation exists, returns the result of evaluating the
 zero-argument block aBlock."

| symAssoc |
symAssoc := super at: aKey ifAbsent: [nil].
symAssoc ~~ nil ifTrue: [ ^ symAssoc value ].
^ aBlock value.
%

category: 'Accessing'
method: ObsoleteSymbolListDictionary
at: aKey otherwise: aValue

"Returns the value that corresponds to aKey.  If no such key/value pair
 exists, returns the given alternate value."

| anAssoc |
aKey == nil ifTrue:[ ^aValue ] .
anAssoc := self associationAt: aKey otherwise: nil .
anAssoc == nil ifTrue:[ ^ aValue] .
^ anAssoc value
%

category: 'Updating'
method: ObsoleteSymbolListDictionary
at: aKey put: aValue

"If the receiver already contains a ObsoleteSymbolAssociation with the given key, this
 makes aValue the value of that ObsoleteSymbolAssociation.  Otherwise, this creates a
 new ObsoleteSymbolAssociation with the given key and value and adds it to the
 receiver.  Returns aValue."

| tempKey anAssoc |

(aKey _isSymbol)
  ifTrue: [ tempKey := aKey ]
  ifFalse: [ tempKey := ObsoleteSymbol withAll: aKey ].

anAssoc:= self associationAt: aKey otherwise: nil .
anAssoc == nil
  ifTrue:[ | newAssoc |
    (tempKey _isSymbol)
      ifTrue: [
        newAssoc := SymbolAssociation newWithKey: tempKey value: aValue
	]
      ifFalse: [
        newAssoc := ObsoleteSymbolAssociation newWithKey: tempKey value: aValue
        ].
     super at: tempKey put: newAssoc.
     ^aValue
    ].

anAssoc value: aValue.
^aValue
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
collectAssociations: aBlock

"Evaluates aBlock with each of the receiver's Associations as the argument.
 Collects the resulting values into a new hash dictionary and returns that
 dictionary.  The argument aBlock must be a one-argument block."

|result|

result:= self speciesForCollect new: self tableSize.
super doKeysAndValues: [:aKey :aSymAssoc |
  result at: aKey put: ( aBlock value: aSymAssoc )
  ] .
^ result
%

category: 'Repository Conversion'
method: ObsoleteSymbolListDictionary
containsOnlySymbols

"Private. Checks to see if all its keys are Symbols (and not ObsoleteSymbols)"

self keysDo: [ :aKey |
  (aKey _isSymbol) ifFalse: [ ^ false ]
  ].

^ true.
%

category: 'Repository Conversion'
method: ObsoleteSymbolListDictionary
convertPoolDictionary

"Converts a pool dictionary to a new SymbolDictionary.  Retains the same
 OOP."

^self convertTo5
%

category: 'Repository Conversion'
method: ObsoleteSymbolListDictionary
convertTo5

"Returns a new instance of SymbolDictionary containing the contents of the
 receiver."

| newDict anArray |

(self class == ObsoleteSymbolListDictionary) ifFalse: [ ^ self ].
"Cannot convert user defined subclasses of ObsoleteSymbolListDictionary"

anArray := Array new.
self associationsDo: [ :anObsSymAssoc |
  anObsSymAssoc convertTo5.
  anArray add: anObsSymAssoc .
  ].

newDict := SymbolDictionary new .
newDict objectSecurityPolicy: self objectSecurityPolicy.
self _becomeDictionary: newDict .
anArray accompaniedBy: self do: [ :me :anAssoc | me add: anAssoc ].

^ self
%

category: 'Repository Conversion'
method: ObsoleteSymbolListDictionary
convertToSymbolDict

"Private. Converts the receiver to be an instance of SymbolDictionary."

<primitive: 483>
self _primitiveFailed: #convertToSymbolDict
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
detect: aBlock

"Evaluates aBlock repeatedly, with the ObsoleteSymbolAssociations of the receiver as
 the argument.  Returns the first ObsoleteSymbolAssociation for which aBlock evaluates
 to true.  If none of the receiver's elements evaluates to true, generates an
 error.  The argument aBlock must be a one-argument block."

self associationsDo: [:aSymAssoc | (aBlock value: aSymAssoc)
                       ifTrue: [^aSymAssoc]
         ].
^ self _error: #assocErrNoElementsDetected args: { aBlock } .
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
detectAssociations: aBlock

"Evaluates aBlock repeatedly, with the Associations of the receiver as the
 argument.  Returns the first Association for which the block evaluates to true
 when the Association is used as the argument to the block.  If none of the
 receiver's Associations evaluates to true, generates an error.  The argument
 aBlock must be a one-argument block."

^ self detect: aBlock
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
detectAssociations: aBlock ifNone: exceptionBlock

"Same function as in class Collection, renamed to make it clear that the
 operations are on Associations."

^ self detect: aBlock ifNone: exceptionBlock
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
detectValues: aBlock ifNone: exceptionBlock

"Evaluates aBlock repeatedly, with the values of the receiver as the argument.
 Returns the first key for which aBlock evaluates to true.  If none of the
 receiver's values evaluates to true, this evaluates the exceptionBlock and
 returns its value.  The argument aBlock must be a one-argument block, and
 exceptionBlock must be a zero-argument block."

self doKeysAndValues: [:aKey :aValue | (aBlock value: aValue)
                                       ifTrue: [^aKey]].
^exceptionBlock value
%

category: 'Enumerating'
method: ObsoleteSymbolListDictionary
do: aBlock

"Evaluates aBlock with each of the receiver's ObsoleteSymbolAssociations as the
 argument.  The argument aBlock must be a one-argument block."

super do: [:aSymAssoc | aBlock value: (aSymAssoc value)].
^ self
%

category: 'Accessing'
method: ObsoleteSymbolListDictionary
keyAtValue: anObject ifAbsent: aBlock

"Returns the key of the first value matching the given object, anObject.  If no
 match is found, this method evaluates the block aBlock and returns its
 result."

"Reimplemented for improved performance"

| aKey collisionBkt |

aBlock _isExecBlock ifFalse:[ aBlock _validateClass: ExecBlock] .

1 to: tableSize * 2 by: 2 do: [ :tableIndex |
  (aKey := self _at: tableIndex) == nil ifTrue: [
    (collisionBkt := self _at: (tableIndex + 1)) == nil ifFalse: [
      1 to: collisionBkt _basicSize by: 2 do: [ :j |
        (aKey := collisionBkt _at: j) == nil ifFalse: [
          anObject == (collisionBkt _at: j + 1) value ifTrue: [
            ^ aKey
            ].
          ].
        ].
      ].
    ]
  ifFalse: [
    anObject == (self _at: tableIndex + 1) value ifTrue: [
      ^ aKey
      ].
    ].
  ].

^aBlock value.
%

category: 'Enumerating'
method: ObsoleteSymbolListDictionary
keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the arguments.
 The argument aBlock must be a two-argument block.  The first argument is the
 key and the second argument is the value of each key/value pair."

super keysAndValuesDo: [:aKey :aSymAssoc |
   aBlock value: aKey value: aSymAssoc value].
^self
%

category: 'Accessing'
method: ObsoleteSymbolListDictionary
name

"Returns the key of a ObsoleteSymbolAssociation whose value is the receiver.  If the
 receiver contains no such ObsoleteSymbolAssociation, returns nil."

^self keyAtValue: self ifAbsent: [^nil]
%

category: 'Hashing'
method: ObsoleteSymbolListDictionary
rebuildTable: newSize

"Rebuilds the receiver to be a new size specified by newSize."

"Reimplemented to ensure that the identity of the receiver's keys and values
 are preserved."

| saveArray index saveCollLimit|

collisionLimit == 536870911 ifTrue:[
  ^ self "prevent recursive rebuild"
  ].

saveArray := Array new: (self numElements).
index:= 1.
self associationsDo: [ :aSymAssoc | saveArray at: index put: aSymAssoc.
                        index:= index + 1 ].
self tableSize: newSize.
saveCollLimit := collisionLimit .
collisionLimit := 536870911 . "prevent recursive rebuild"

1 to: saveArray size do: [ :i | self add: (saveArray at: i)].

collisionLimit := saveCollLimit .
^self
%

category: 'Repository Conversion'
method: ObsoleteSymbolListDictionary
rehashForConversion

"Private. Rehashes the receiver because the hash values of some of its keys
 may have changed."

<primitive: 2001> "enter protected mode"
| prot |
prot := System _protectedMode .
[
  | newSize newDict |

  (self class == ObsoleteSymbolListDictionary)
    ifFalse: [
      newSize := (Integer _selectedPrimeGreaterThan: numElements) max: tableSize.
      self rebuildTable: newSize.
      ^ self
      ].

  (self containsOnlySymbols)
    ifFalse: [ | anArray |
      anArray := Array new.
      self doAssociations: [ :anAssoc | anArray add: anAssoc ].
      newDict := Dictionary new: (self size).

      newDict objectSecurityPolicy: self objectSecurityPolicy.
      newDict _becomeDictionary: self.

      anArray do: [ :anAssoc |
	self add: anAssoc.
	].
      ^ self.
      ].

  self convertToSymbolDict.
  newSize := (Integer _selectedPrimeGreaterThan: numElements) max: tableSize.
  self rebuildTable: newSize.
] ensure:[
  prot _leaveProtectedMode
].
^ self
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
reject: aBlock

"Evaluates aBlock with each of the receiver's ObsoleteSymbolAssociations as the
 argument.  Stores the values for which aBlock is false into a collection of
 the same class as the receiver, and returns the new collection.  The argument
 aBlock must be a one-argument block."

|result|
result:= self class new.
self associationsDo: [:aSymAssoc | (aBlock value: aSymAssoc)
                       ifFalse: [result add: aSymAssoc]
         ].
^result
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
rejectAssociations: aBlock

"Same function as in class Collection, renamed to make it clear that the
 operations are on Associations."

^ self reject: aBlock
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
rejectValues: aBlock

"Evaluates aBlock with each of the receiver's ObsoleteSymbolAssociations as the
 argument.  Returns an instance of the class of the receiver containing the
 values for which aBlock is false.  The argument aBlock must be a one-argument
 block."

| result |
result:= self class new.
self associationsDo: [:aSymAssoc | (aBlock value: (aSymAssoc value))
                       ifFalse: [ result add: aSymAssoc ]].
^result
%

category: 'Removing'
method: ObsoleteSymbolListDictionary
removeAssociation: aSymAssoc

"Removes aSymAssoc from the receiver, and returns the receiver.
 If aSymAssoc is absent, generates an error."

^self removeAssociation: aSymAssoc ifAbsent: [
  ^ self _errorNotFound: aSymAssoc
].
%

category: 'Removing'
method: ObsoleteSymbolListDictionary
removeAssociation: aSymAssoc ifAbsent: aBlock

"Removes aSymAssoc from the receiver.  If aSymAssoc is absent, evaluates the
 zero-argument block aBlock and returns the result of that evaluation."

"We must remove this particular ObsoleteSymbolAssociation (aSymAssoc), not
 just any ObsoleteSymbolAssociation with the same key as aSymAssoc"

|object|
object:= self associationAt: (aSymAssoc key) otherwise: nil .
object == nil ifTrue:[ ^aBlock value ].
(object == aSymAssoc)
   ifTrue: [ self removeKey: aSymAssoc key ]
   ifFalse:[ ^aBlock value].
^self
%

category: 'Removing'
method: ObsoleteSymbolListDictionary
removeKey: aKey

"Removes the key/value pair that corresponds to aKey."

|anAssoc|
anAssoc:= super removeKey: aKey ifAbsent: nil.
^anAssoc value
%

category: 'Removing'
method: ObsoleteSymbolListDictionary
removeKey: aKey ifAbsent: aBlock

"Removes the key/value pair with key aKey from the receiver and returns
 the value.  If no key/value pair is present with key aKey, evaluates
 the zero-argument block aBlock and returns the result of that evaluation."

|anAssoc|
anAssoc:= super removeKey: aKey ifAbsent: [^aBlock value].
^anAssoc value
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
select: aBlock

"Evaluates aBlock with each of the receiver's ObsoleteSymbolAssociations as the
 argument.  Stores the values for which aBlock is true into a collection of the
 same class as the receiver, and returns the new collection.  The argument
 aBlock must be a one-argument block."

|result|
result:= self class new.
self associationsDo: [:aSymAssoc | (aBlock value: aSymAssoc)
                       ifTrue: [result add: aSymAssoc]
         ].
^result
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
selectAssociations: aBlock

"Same function as in class Collection, renamed to make it clear that the
 operations are on Associations."

^ self select: aBlock
%

category: 'Searching'
method: ObsoleteSymbolListDictionary
selectValues: aBlock

"Evaluates aBlock with each of the receiver's values as the argument.  Returns
 an instance of the class of the receiver containing the values for which
 aBlock is true.  The argument aBlock must be a one-argument block."

| result |
result:= self class new.
self associationsDo: [:aSymAssoc | (aBlock value: (aSymAssoc value))
                       ifTrue: [ result add: aSymAssoc ]].
^result
%

category: 'Browser Methods'
method: ObsoleteSymbolListDictionary
_classAndVersionStrings

"For all Behaviors in the receiver, returns an OrderedCollection of Strings
 showing the class name and version.  This method is used as an optimization by
 the GemBuilder for Smalltalk browser."

| result |
result := OrderedCollection new .
self do: [ :anAssoc | | each |
  each := anAssoc value.
  each isBehavior
  ifTrue: [ result add:
              ( each classHistory size = 1
                 ifTrue: [ each name asString ]
                 ifFalse: [ each name , ' [ ' ,
                      ( each classHistory indexOf: each ) printString , ' ]' ]
               )
    ]
  ].
^result
%

category: 'Locking Support'
method: ObsoleteSymbolListDictionary
_lockableValues

"Returns an Array of the receiver's Associations."

| result |

result := Array new .
super keysAndValuesDo: [:aKey :aSymAssoc | result add: aSymAssoc] .
^ result
%

! Class extensions for 'ObsoleteSymbolSet'

!		Class methods for 'ObsoleteSymbolSet'

removeallmethods ObsoleteSymbolSet
removeallclassmethods ObsoleteSymbolSet

category: 'Repository Conversion'
classmethod: ObsoleteSymbolSet
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolSet)
  ifTrue: [ ^ SymbolSet ].

^ self.
%

!		Instance methods for 'ObsoleteSymbolSet'

category: 'Repository Conversion'
method: ObsoleteSymbolSet
convertToSymbolSet

"Private. Changes the receiver from being an instance of ObsoleteSymbolSet to
 an instance of SymbolSet. Used in Repository Conversion."

<primitive: 487>
self _primitiveFailed: #convertToSymbolSet
%

category: 'Repository Conversion'
method: ObsoleteSymbolSet
rehashForConversion

"Private. Rebuilds an NSC to fix up internal sort order of the elements.
 Returns the receiver."

| contentClassSet |

contentClassSet := IdentitySet new.
self do: [ :anElement |
  contentClassSet add: (anElement class)
  ].

(contentClassSet includes: ObsoleteSymbol)
  ifFalse: [ self convertToSymbolSet ].

^ self.
%

category: 'Adding'
method: ObsoleteSymbolSet
_addSymbol: aSymbol

"Obsolete, provided for compatibility.
 Same functionality as IdentitySet | add: "

^ self add: aSymbol
%

category: 'Accessing'
method: ObsoleteSymbolSet
_returnValueOf: anObject

"Returns the element of the receiver whose value is the same as the argument.
 If the argument is not equal to any value in the receiver, then add the
 argument to the receiver."

|symbolizedObject|

symbolizedObject := anObject asObsoleteSymbol.
self add: symbolizedObject.
^ symbolizedObject
%

! Class extensions for 'ObsoleteVariableContext'

!		Class methods for 'ObsoleteVariableContext'

removeallmethods ObsoleteVariableContext
removeallclassmethods ObsoleteVariableContext

category: 'Instance creation'
classmethod: ObsoleteVariableContext
new
  self shouldNotImplement: #new
%

category: 'Instance creation'
classmethod: ObsoleteVariableContext
new: aSize
  self shouldNotImplement: #new:
%

category: 'Instance creation'
classmethod: ObsoleteVariableContext
_basicNew
  self shouldNotImplement: #_basicNew
%

category: 'Instance creation'
classmethod: ObsoleteVariableContext
_basicNew: aSize
  self shouldNotImplement: #_basicNew:
%

! Class extensions for 'ReenterBlock'

!		Instance methods for 'ReenterBlock'

removeallmethods ReenterBlock
removeallclassmethods ReenterBlock

category: 'Block Evaluation'
method: ReenterBlock
_blockCopy: numberOfArgs

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_blockCopy:) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_report

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_report) .
   self _uncontinuableError

%

category: 'Block Evaluation'
method: ReenterBlock
_selectBlockCopy: aSelectionBlock
          withPc: anIntegerOffset

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_selectBlockCopy:withPc:) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_stackVars

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_stackVars) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_stepPoint: atTop

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_stepPoint:) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_stepPointString: atTop

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_stepPointString:) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_variableCount: aName

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_variableCount:) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_variableList: aName

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_variableList:) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_variableList: aName continuing: aBool

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_variableList:continuing:) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_variableNames

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_variableNames) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_variableNames: continuing

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_variableNames:) .
   self _uncontinuableError

%

category: 'Debugging Support'
method: ReenterBlock
_variableNamesAndValues

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_variableNamesAndValues) .
   self _uncontinuableError

%

! Class extensions for 'SelectionBlock'

!		Instance methods for 'SelectionBlock'

removeallmethods SelectionBlock
removeallclassmethods SelectionBlock

category: 'Accessing'
method: SelectionBlock
_bindPc

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_bindPc) .
   self _uncontinuableError

%

category: 'Block Evaluation'
method: SelectionBlock
_bindQuery

   "Obsolete"
   self _error: #rtErrObsolete args: #(#_bindQuery) .
   self _uncontinuableError

%

! Class extensions for 'SimpleBlock'

!		Class methods for 'SimpleBlock'

removeallmethods SimpleBlock
removeallclassmethods SimpleBlock

category: 'Disassembly'
classmethod: SimpleBlock
_cost

^ 1

%

!		Instance methods for 'SimpleBlock'

category: 'Testing'
method: SimpleBlock
isSimple

"Return true.  The receiver is a simple block."

^ true
%

category: 'Block Evaluation'
method: SimpleBlock
value

"Return the value of the receiver evaluated with no arguments.
 If the block expects any arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: anObject

"Return the value of the receiver evaluated with anObject as its argument.  If
 the block expects a different number of arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: firstObject value: secondObject

"Return the value of the receiver evaluated with the two objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: firstObject value: secondObject value: thirdObject

"Return the value of the receiver evaluated with the three objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: first value: second value: third value: fourth

"Return the value of the receiver evaluated with the four objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: first value: second value: third value: fourth value: fifth

"Return the value of the receiver evaluated with the five objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
valueWithArguments: argList

"Return the value of the receiver evaluated with the elements of the Array
 argList as arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Accessing'
method: SimpleBlock
_sourceString

"Return a string that will create a block similar to the receiver when
 the string is compiled."

| result |
(result := '^ ' copy )
   addAll: ( method _sourceString copyFrom: firstSourceOffset to: lastSourceOffset  ) .
^result
%

! Class extensions for 'StackBuffer'

!		Class methods for 'StackBuffer'

removeallmethods StackBuffer
removeallclassmethods StackBuffer

category: 'Instance Creation'
classmethod: StackBuffer
new

"Disallowed."

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: StackBuffer
new: aSize

"Disallowed."

self shouldNotImplement: #new:
%

!		Instance methods for 'StackBuffer'

category: 'Copying'
method: StackBuffer
copy

"Disallowed."

self shouldNotImplement: #copy
%

! Class extensions for 'StackSegment'

!		Class methods for 'StackSegment'

removeallmethods StackSegment
removeallclassmethods StackSegment

category: 'Instance Creation'
classmethod: StackSegment
new

"Disallowed."

self shouldNotImplement: #new
%

!		Instance methods for 'StackSegment'

category: 'Copying'
method: StackSegment
copy

"Disallowed."

self shouldNotImplement: #copy
%

