! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class extensions for 'Class'

!		Instance methods for 'Class'

category: 'Private'
method: Class
_subclass: className
instVarNames: anArrayOfInstvarNames
format: theFormat
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
inClassHistory: aClassHistory
description: aDescription
options: optionsArray

	"The preferred private subclass creation method.
 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant .
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogServer:  of class creation / equivalence.
"

	| cvDict result theName ivNames theHist poolDicts modifiableBool fmtArr fmt nCivs sza szb
    civNames tNow |
	self _validatePrivilege ifFalse: [^nil].
	className _isOneByteString
		ifFalse: [(className _validateClass: CharacterCollection) ifFalse: [^nil]].
	self subclassesDisallowed
		ifTrue: [^self _error: #classErrSubclassDisallowed].
	anArrayOfClassInstVars
		ifNotNil:
			[anArrayOfClassInstVars _isArray
				ifFalse: [(anArrayOfClassInstVars _validateClass: Array) ifFalse: [^nil]]].
	aDictionary
		ifNotNil: [(aDictionary _validateClass: SymbolDictionary) ifFalse: [^nil]].
	fmtArr := self _validateOptions: optionsArray withFormat: theFormat newClassName: className .
	fmt := fmtArr at: 1.
	modifiableBool := fmtArr at: 2.
	(self instancesInvariant and: [(fmt bitAnd: 16r8) == 0])
		ifTrue: [^self _error: #classErrInvariantSuperClass].
	anArrayOfInstvarNames _isArray
		ifFalse: [(anArrayOfInstvarNames _validateClass: Array) ifFalse: [^nil]].
	ivNames := {}.
	1 to: anArrayOfInstvarNames size
		do: [:j | ivNames add: (anArrayOfInstvarNames at: j)].
	nCivs := anArrayOfClassInstVars size.
	civNames := anArrayOfClassInstVars.
	nCivs ~~ 0
		ifTrue:
			[| aSet |
			civNames := Array new: nCivs.
			aSet := IdentitySet new.
			1 to: nCivs
				do:
					[:k |
					| aName |
					aName := (anArrayOfClassInstVars at: k) asSymbol.
					self class _validateNewClassInstVar: aName.
					civNames at: k put: aName.
					aSet add: aName.
					aSet size < k
						ifTrue:
							[ImproperOperation
								signal: 'array of new class instanceVariables contains a duplicate '
										, aName printString]]].

	"Gs64 v3.0 , cvDict and poolDicts maybe nil from caller,
    and will be converted to nil if caller passed an empty Array."
	cvDict := self _makeClassVarDict: anArrayOfClassVars.

	"undo the compiler's canonicalization of empty arrays (fix bug 14103) "
	poolDicts := anArrayOfPoolDicts.
	(poolDicts _isArray and: [poolDicts size == 0]) ifTrue: [poolDicts := nil].
	theName := className asSymbol.
	tNow := DateTime now.
	result := self
				_subclass: theName
				instVarNames: ivNames
				format: fmt
				classVars: cvDict
				poolDictionaries: poolDicts
				classInstanceVars: civNames.
	modifiableBool ifTrue: [result _subclasses: IdentitySet new].
	subclasses ifNotNil: [subclasses add: result].
	aDictionary ifNotNil: [aDictionary at: theName put: result].
	"leave extraDict as nil"
	result _commentOrDescription: aDescription.
	theHist := aClassHistory.
	theHist ifNil: [theHist := ClassHistory new name: className].
	theHist notEmpty
	  ifTrue: [ 
		"remove receiver from traits, but leave the trait methods installed -- preserve existing method dictionary ... as is"
		| theCurHist|
		theCurHist := theHist current.
		result category:theCurHist _classCategory.
		theCurHist traits do: [:trait | trait removeDependentOnly: theCurHist ].
		theCurHist classTraits do: [:classTrait | classTrait removeDependentOnly: theCurHist ].
		theCurHist 
			 _extraDictRemoveKey: #traits;
			 _extraDictRemoveKey: #classTraits ].
	theHist add: result.
	result classHistory: theHist.
	result timeStamp: tNow  .
	result userId: System myUserProfile userId.
	sza := self class instSize + anArrayOfClassInstVars size.
	szb := result class instSize.
	sza == szb
		ifFalse:
			[InternalError
				signal: 'prim 233: inconsistent class instance variables, superClass+args=>'
						, sza asString , '  newClass=>'
						, szb asString].
	modifiableBool ifFalse: [result immediateInvariant].
	result copyVariables.
	self _clearCachedOrganizer.
  (fmtArr at: 3) ifTrue: [ 
    "not the final oop if a reserved oop class"
    self _logServer: 'created class ' , className, ' oop ', result asOop asString  .
  ].
	^result
%

! Class extensions for 'DateTime'

!		Class methods for 'DateTime'

category: 'Instance Creation'
classmethod: DateTime
now

"Creates and returns an instance of the receiver representing the current
 time."
  ^ self now: TimeZone current
%

! Class extensions for 'Upgrade3Init'

!		Class methods for 'Upgrade3Init'

category: 'Image Upgrade'
classmethod: Upgrade3Init
initialize
  System myUserProfile userId = 'SystemUser' ifFalse:[Error signal:'not SystemUser'].

  self _initIrClasses .
  System currentObjectSecurityPolicy: SystemObjectSecurityPolicy .
  self _testCharacter ;
     _initIcuCollator ;
     _initIndexing ;
     _createFloatAliases .
  CanonicalObjectManager default ifNil:[
    Error signal:'CanonicalObjectManager default is nil'.
  ].
  GsEventLog current.
  LdapDirectoryServer _smartInitialize .
  "SystemRepository _setVersion . " "moved to upgradeImage.topaz"
  System commit .

  "most classmethods in  bomlastconv.gs"
  self _checkNpClasses ;
    _checkSoftRefClasses ;
    _disallowGciCreateStore_onMetaclasses;
    _disallowGciCreateStore_onExceptions;
    _disallowGciCreateStore_onVM_FFI ;
    _userProfile_allowAddInstVar ;
    _checkSymbolClasses ;
    _allUsers_addInversePrivileges ;
    _initUndefinedObject .
  System commit .
  self _buildConfigDicts ;
       _recompileNumericMethods ;
       _buildInstancesDisallowed ;
       _buildCollatingTables ;
       _initSharedDepList ;
       _setTimeStamps ;
       _checkVmClasses ;
       _initAllUsers .
  TimeZone _initialize3 .
  System commit .
  self _migrateGroups .
  System commit .
  self _patchObsoleteClasses;
       _checkObsoleteClasses;
       _checkOptionalObsoleteClasses ;
       _checkClasses44744 ;
       _checkNoConstraints ;
       _checkFdcResults ;
       _removeMethodsAfterUpgrade ;
       _removeEmptyCategories .
  GciTsLibrary _initializeDefault .
  System commit .
  self _installDocumentation .
  System commit .
  self _createClusterBuckets .
  "Do NOT remove, Leave in symbolList:
    System myUserProfile symbolList removeAllIdentical:
    { ObsoleteClasses . GsCompilerClasses .
      GemStone_Legacy_Streams . GemStone_Portable_Streams } .
  "
  System commit .
  ^ true
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
oldestImageVersion
  "returns a Float. for use after image upgrade completes, returns oldest version."
  | hist |
  (hist := Globals at: #DbfHistory otherwise: nil) ifNil:[ ^ 3.6 "slowfilein"].
  (hist includesString: 'GemStone/S 64 Bit 3.3' ) ifTrue:[ ^ 3.3 ].
  (hist includesString: 'GemStone/S64 v3.3' ) ifTrue:[ ^ 3.3 ].
  (hist includesString: 'GemStone/S 64 Bit 3.4' ) ifTrue:[ ^ 3.4 ].
  (hist includesString: 'GemStone/S64 v3.4' ) ifTrue:[ ^ 3.4 ].
  (hist includesString: 'GemStone/S64 v3.5' ) ifTrue:[ ^ 3.5 ].
  (hist includesString: 'GemStone 3.5' ) ifTrue:[ ^ 3.5 ].
  (hist includesString: 'GemStone/S64 v3.6' ) ifTrue:[ ^ 3.6 ].
  (hist includesString: 'GemStone 3.6' ) ifTrue:[ ^ 3.6 ].
  (hist includesString: 'GemStone/S64 v3.7' ) ifTrue:[ ^ 3.7 ].
  Error signal:'unknown image version'.
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
oldImageVersion
  "returns a Float.  also coded inline in upgradeImage.topaz.
   for use before image upgrade completes, returns most recent version."
  | hist |
  (hist := Globals at: #DbfHistory otherwise: nil) ifNil:[ ^ 3.7 "slowfilein"].
  (hist includesString: 'GemStone/S64 v3.7' ) ifTrue:[ ^ 3.7 ].
  (hist includesString: 'GemStone 3.6' ) ifTrue:[ ^ 3.6 ].
  (hist includesString: 'GemStone/S64 v3.6' ) ifTrue:[ ^ 3.6 ].
  (hist includesString: 'GemStone 3.5' ) ifTrue:[ ^ 3.5 ].
  (hist includesString: 'GemStone/S64 v3.5' ) ifTrue:[ ^ 3.5 ].
  (hist includesString: 'GemStone/S64 v3.4' ) ifTrue:[ ^ 3.4 ].
  (hist includesString: 'GemStone/S 64 Bit 3.4' ) ifTrue:[ ^ 3.4 ].
  (hist includesString: 'GemStone/S64 v3.3' ) ifTrue:[ ^ 3.3 ].
  (hist includesString: 'GemStone/S 64 Bit 3.3' ) ifTrue:[ ^ 3.3 ].
  Error signal:'unknown image version'.
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_allUsers_addInversePrivileges
" adjust existing UserProfiles to grant new inverse privileges"
| setBlk clearBlk inversePrivs newPrivs LF |
System myUserProfile userId = 'SystemUser' ifFalse:[ nil error:'wrong user'].
LF := Character lf .
newPrivs := #( #SessionPriority ) .
inversePrivs := #( #NoPerformOnServer #NoUserAction
             #NoGsFileOnServer #NoGsFileOnClient ) .
setBlk := [ :aUp :anArray :aName |
  anArray do:[ :aPriv | aUp addPrivilege: aPriv ] .
  GsFile gciLogServer:'set ', aName , ' priv bits for ' , aUp userId , LF .
].
clearBlk := [ :aUp :anArray :aName |
  anArray do:[ :aPriv | aUp deletePrivilege: aPriv] .
  GsFile gciLogServer:'cleared ', aName, ' priv bits for ' , aUp userId , LF .
].
AllUsers do:[ :aUp | | uid |
  uid := aUp userId .
  (UserProfile isSpecialUserId: uid) ifTrue:[
    (uid = 'SystemUser' or:[ uid = 'DataCurator']) ifTrue:[
      clearBlk value: aUp value: inversePrivs value: 'inverse' .
      setBlk value: aUp value: newPrivs value: 'new' .
      uid = 'DataCurator' ifTrue:[ 
        aUp deletePrivilege: #CompilePrimitives.
        aUp addPrivilege: #MigrateObjects .
      ].
      uid = 'SystemUser' ifTrue:[ 
        aUp addPrivilege: #CompilePrimitives .
        aUp addPrivilege: #MigrateObjects .
      ].
    ] ifFalse:[  "gcuser, symboluser, nameless"
      clearBlk value: aUp value: inversePrivs value: 'inverse' .
      aUp deletePrivilege: #CompilePrimitives .
      aUp deletePrivilege: #MigrateObjects .
    ].
  ] ifFalse:[
    "preexisting customer user profiles not affected.
     If customers have blindly set all priv bits those Up's need adjustment.
    "
  ].
].
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_buildCollatingTables
" Create collating tables for raw ASCII collating order for use with
  String compare methods  in category 'Other comparisons'"
| a |
a := String new .
0 to: 255 do:[:j| a add: (Character withValue: j )].
Globals at:#AsciiCollatingTable put: a .
a immediateInvariant .
a size == 256 ifFalse:[ Error signal:'bad size' ].

a := DoubleByteString new .
0 to: 255 do:[:j| a add: (Character withValue: j )].
Globals at:#DoubleByteAsciiCollatingTable put: a .
a immediateInvariant .
a size == 256 ifFalse:[ Error signal:'bad size D' ].

a := QuadByteString new .
0 to: 255 do:[:j| a add: (Character withValue: j )].
Globals at:#QuadByteAsciiCollatingTable put: a .
a immediateInvariant .
a size == 256 ifFalse:[ Error signal:'bad size Q' ].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_buildConfigDicts
Globals at:#ConfigurationParameterDict put:
(System _configFileParameterDict) .

"dictionary to translate names to internal identifiers"
Globals at:#VersionParameterDict put:
(System _versionParameterDict) .
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_buildInstancesDisallowed
" build the set of classes for which instances are disallowed"
| obsDict |
self _checkObsoleteInstancesDisallowed.
(obsDict := Globals at: #ObsoleteClasses otherwise: nil) ifNil:[
  Error signal: 'ObsoleteClasses missing from Globals'.
].
 
Globals at:#InstancesDisallowed put:
 ( IdentitySet withAll:
  { (obsDict at: #Activation) . Character . Behavior . (obsDict at: #Block) . BlockClosure . 
      Boolean .
      Class . (obsDict at: #GsMethod) . (obsDict at: #ComplexBlock) . 
      (obsDict at: #ComplexVCBlock) . DateTime .
      ExecBlock . (obsDict at: #ExecutableBlock) . Float . DecimalFloat . SmallFloat . BinaryFloat .
      SmallDate . SmallTime . SmallDateAndTime . SmallScaledDecimal .
      Integer . (obsDict at: #JISCharacter) .
      LargeInteger . (obsDict at: #ObsoleteMetaclass) . (obsDict at: #MethodContext) . Number .
      (obsDict at: #Process) .
      Repository . GsObjectSecurityPolicy . SelectBlock . (obsDict at: #SelectionBlock) . 
      (obsDict at: #SimpleBlock) .
      SmallInteger . (obsDict at: #StackBuffer) . (obsDict at: #StackSegment) . System . 
      UndefinedObject .
      UserProfile . VariableContext . 
      Special56bit0 .  Special56bit1 .  Special56bit2 .  Special56bit3 .  Special56bit4 .
      Special56bit5 .  Special56bit6 .  Special56bit7 .  Special56bit8 .  Special56bit9 .
      Special56bit10 .  Special56bit11 .  Special56bit12 .  Special56bit13 .  Special56bit14 .
      Special56bit15 
  }) .
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkClasses44744
 | str |
  str := String new .
 { GsQueryGrammar .
   GsQueryParser .
   PPCompositeParser .
   PPMemento .
   PPStream .
   PPToken .
   PPFailure .
   ProfMonitorEntry } 
 do:[:cls |
    cls classHistory size ~~ 1 ifTrue:[ str add: cls name,' has more than 1 version'; lf]. 
 ] .
 PPMemoizedParser classHistory size > 2 ifTrue:[ 
   str add: 'PPMemoizedParser has more than 2 versions'; lf .
 ].
 str size == 0 ifFalse:[
   GsFile gciLogServer:'WARNING:  classes with more than one version (';
      gciLogServer: str , ' )'.
 ].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkFdcResults
	"ensure Association for FdcResults is in DataCurator objectSecurityPolicy"
| res dcSeg |
dcSeg := Globals at:#DataCuratorObjectSecurityPolicy .
(Globals includesKey:#FdcResults) ifTrue:[
  (Globals associationAt:#FdcResults) objectSecurityPolicy: dcSeg .
  res := 'changed objectSecurityPolicy of FdcResults' .
] ifFalse:[
  dcSeg setCurrentWhile:[
    Globals at:#FdcResults put: nil .
    res := 'created FdcResults' .
  ]
].
GsFile gciLogServer: res .
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkGsIndexOptions
  "add legacyIndex option to default GsIndexOptions, if upgrading from 3.3.x or before"
  "Should be called by upgradeImage.topaz only." 

  (Globals includesKey: #'GsDefaultIndexOptions')
    ifFalse: [ 
      "prior to 3.4.0, #GsDefaultIndexOptions not present in Globals"
      "dbf originated prior to 3.4.0, when legacy indexes were the only
        option, after upgrade to 3.4, legacy indexes should be the default."
      GsIndexOptions default: GsIndexOptions legacyIndex.
      GsFile gciLogServer: 'set GsDefaultIndexOptions to legacy'.
      ^ self ].
  GsFile gciLogServer: 'GsDefaultIndexOptions unchanged'
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkNoConstraints
  " check for empty constraints on system classes"
  | str |
  self oldImageVersion = 3.3 ifTrue:[
    self _removeConstraints 
  ].
  [
    Globals classesDo: [:aUserProfile :aSymbolDictionary :aClass |
      aClass _constraints ifNotNil:[
        str add:' ', aClass _versionedName,' oop ', aClass asOop asString,';'.
      ].
    ].
  ] on: Deprecated do: [:ex | ex resume].
  str size == 0 ifFalse:[
    GsFile gciLogServer: str .
    Error signal:'unexpected constraints on ' , str.
  ].
  ^ true .
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkNpClasses
 "NP should have been set in bom.c for these classes"
{ Semaphore . ProcessorScheduler } do:[:aClass |
  aClass instancesNonPersistent ifFalse:[
    Error signal: aClass name,' instancesNonPersistent==false'
  ]
].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkObsoleteClasses
  "Check for expected contents of ObsoleteClasses in a virgin dbf"
  | keys errs rpt obsDict historicalObsoleteClassKeys |
  (obsDict := Globals at: #ObsoleteClasses otherwise: nil) ifNil:[
    Error signal: 'ObsoleteClasses missing from Globals'.
  ].
  errs := String new .  (rpt := 'Starting _checkObsoleteClasses' copy) lf  .
  
  "ObsoleteClasses that may not be present in an upgraded image (50327)"
  historicalObsoleteClassKeys := #( 
    GsCloneList
    ObsDoubleByteString
    ObsDoubleByteSymbol
    ObsFloat
    ObsLargeNegativeInteger
    ObsLargePositiveInteger
    ObsMultiByteString
    Obsolete23ClampSpecification
    Obsolete23GsFile
    ObsoleteClampSpecification
    ObsoleteConstrainedPathEvaluator
    ObsoleteConstrainedPathTerm
    ObsoleteDateTime
    ObsoleteDateTime50
    ObsoleteDictionary
    ObsoleteEqualityIndexQueryEvaluator
        ObsoleteGsRdbConnection
        ObsoleteGsSocket
        ObsoleteIdentityIndexQueryEvaluator
        ObsoleteIndexedQueryEvaluator
        ObsoletePathEvaluator
        ObsoletePathSorter
        ObsoleteSetValuedPathEvaluator
        ObsoleteSetValuedPathTerm
        ObsQuadByteString
        ObsQuadByteSymbol
        ObsSmallFloat
        OldRepository
        RubyCextData RubyProc RubySocket RubyConstantRef RubyHash RubyTime
    ).
  keys := #( Activation AbstractCharacter Block 
          CanonicalStringDictionary CompiledMethod ComplexBlock ComplexVCBlock
          EUCString EUCSymbol
          ExecutableBlock
          GsCloneList GsMethod
          InvariantEUCString JapaneseString JISCharacter JISString
          MethodContext
          ObsDoubleByteString ObsDoubleByteSymbol
        ObsFloat
        ObsLargeNegativeInteger
        ObsLargePositiveInteger
        ObsMultiByteString
        Obsolete23ClampSpecification
        Obsolete23GsFile
        ObsoleteClampSpecification
        ObsoleteConstrainedPathEvaluator
        ObsoleteConstrainedPathTerm
        ObsoleteDateTime
        ObsoleteDateTime50
        ObsoleteDictionary
        ObsoleteEqualityIndexQueryEvaluator
        ObsoleteException
        ObsoleteGsFile
        ObsoleteGsProcess
        ObsoleteGsRdbConnection
        ObsoleteGsSocket
        ObsoleteIdentityCollisionBucket
        ObsoleteIdentityDictionary
        ObsoleteIdentityIndexQueryEvaluator
        ObsoleteIndexedQueryEvaluator
        ObsoleteLanguageDictionary
        ObsoleteMetaclass
        ObsoletePathEvaluator
        ObsoletePathSorter
        ObsoleteRcCollisionBucket
        ObsoleteSetValuedPathEvaluator
        ObsoleteSetValuedPathTerm
        ObsoleteSymbol
        ObsoleteSymbolAssociation
        ObsoleteSymbolDictionary
        ObsoleteSymbolKeyValueDictionary
        ObsoleteSymbolListDictionary

        ObsoleteSymbolSet
        ObsoleteTimeZone
        ObsoleteTimeZone2
        ObsoleteVariableContext
        ObsQuadByteString
        ObsQuadByteSymbol
        ObsSmallFloat
        OldRepository
        Process
        RubyCextData RubyProc RubySocket RubyConstantRef RubyHash RubyTime RubyThrowException 
        RubyBreakException
        ReenterBlock RegexpError Regexp 
        SelectionBlock
        SimpleBlock
        StackBuffer
        StackSegment
        UnimplementedFloat1 UnimplementedFloat2 ).
   keys do:[:sym | 
      (Globals includesKey: sym) ifTrue:[ 
        (obsDict includesKey: sym) ifTrue:[
          errs add: sym, ' is in both Globals and ObsoleteClasses'; lf .
        ] ifFalse:[ | assoc |
          assoc := Globals associationAt: sym  .
          Globals removeAssociation: assoc .
          obsDict addAssociation: assoc .
          rpt add: 'Moved ', sym,' from Globals to ObsoleteClasses'; lf .
        ].
      ] ifFalse:[
        rpt add: sym , ' not found in Globals'; lf.
      ].
      (obsDict includesKey: sym) ifFalse:[ 
        (historicalObsoleteClassKeys includes: sym)
          ifFalse: [ 
						"avoid issuing a WARNING, if the class is in historicalObsoleteClassKeys, 
							since those classes are optionally present"
						rpt add:'WARNING: ',  sym,' not in ObsoleteClasses'; lf] ].
   ].
   GsFile gciLogServer: rpt .
   errs size > 0 ifTrue:[
     GsFile gciLogServer: 'ERROR, ', errs .
     Error signal: 'ObsoleteClasses not as expected'.
   ].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkOptionalObsoleteClasses
  "items which may be in ObsoleteClasses after an upgrade"
  | keys rpt |
  rpt := String new .
  keys := #(
    ObsoleteAbstractIndexSpecification
    ObsoleteEqualityIndexSpecification
    ObsoleteError
    ObsoleteExampleSetTest
    ObsoleteExceptionHandler
    ObsoleteExceptionSet
    ObsoleteFailedMessage
    ObsoleteIdentityIndexSpecification
    ObsoleteMessageNotUnderstood
    ObsoleteNotification
    ObsoleteRcEqualityIndexSpecification
    ObsoleteResumableTestFailure
    ObsoleteResumableTestFailureTestCase
    ObsoleteSimpleTestResourceTestCase
    ObsoleteSUnitTest
    ObsoleteTestCase
    ObsoleteTestFailure
    ObsoleteTestResource
    ObsoleteWarning
    ObsoleteZeroDivide ).
  keys do:[:sym | (Globals includesKey: sym) ifTrue:[ rpt add: sym, ' is in Globals'; lf]].
  rpt size == 0 ifTrue:[ ^ true ].
  GsFile gciLogServer: 'ERROR: ' , rpt .
  Error signal: 'ObsoleteClasses not as expected'.
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkSoftRefClasses
  | hist obsDict |
(obsDict := Globals at: #ObsoleteClasses otherwise: nil) ifNil:[
  Error signal: 'ObsoleteClasses missing from Globals'.
].

  Float classHistory size == 1 ifFalse:[ Error signal:'bad Float classHistory'].
  (hist := (obsDict at: #ObsoleteRcCollisionBucket) classHistory) size < 2 ifTrue:[
    hist at: 2 put: RcCollisionBucket .
    GsFile gciLogServer:'adjusted ObsoleteRcCollisionBucket classHistory'.
  ].
  SoftReference instancesNonPersistent ifFalse:[ Error signal:'SoftReference should be NP'].
  SoftReference subclassesDisallowed ifFalse:[ Error signal: 'should have subcls disallow'].
  SoftCollisionBucket instancesNonPersistent ifFalse:[ Error signal:'should be NP'].
  IdentitySoftCollisionBucket instancesNonPersistent ifFalse:[ Error signal:'should be NP'].
  KeySoftValueDictionary instancesNonPersistent ifFalse:[ Error signal:'should be NP'].
  IdentityKeySoftValueDictionary instancesNonPersistent ifFalse:[ Error signal:'should be NP'].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkSymbolClasses
{ Symbol . DoubleByteSymbol . QuadByteSymbol . String } do:[:cls |
   cls currentVersion == cls ifFalse:[ Error signal:'bad version of ', cls name ].
].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkVmClasses
 "Check that certain kernel classes have only one version defined.
  The virtual machine contains optimizations which assume that
  the classes checked below have only one version, and thus the
  virtual machine can skip looking at the classHistory when doing
  certain isKindOf checks on arguments to primitives.
  See fix 32339"
| clsList obsDict |
self _checkObsoleteVmClasses.
(obsDict := Globals at: #ObsoleteClasses otherwise: nil) ifNil:[
  Error signal: 'ObsoleteClasses missing from Globals'.
].

clsList := { (obsDict at: #AbstractCharacter) .
  Array .
  ExecBlock .
  (obsDict at: #ExecutableBlock) .
  GsNMethod .
  GsProcess .
  GsSocket .
  IdentityBag .
  Interval .
  SequenceableCollection .
  SmallFloat .
  SmallDouble .
  VariableContext  }.
clsList do:[ :aCls | | hist val sz |
  hist := aCls classHistory .
  sz := hist size .
  sz == 1 ifFalse:[
    Error signal:'classHistory for ' , aCls name , ' too big'
  ].
  val := hist at: 1 .
  val == aCls ifFalse:[
    Error signal:'classHistory for ' , aCls name , ' is corrupt'
  ].
].
"primitives for Float do not check classHistory, but explicitly
 check arguments for both SmallDouble and Float ."
true ifTrue:[ | hist val sz |
  hist := Float classHistory .
  sz := hist size .
  sz == 1 ifFalse:[
    Error signal: 'classHistory for Float has wrong size.'
  ].
  val := hist at: 1 .
  val == Float ifFalse:[
    Error signal:'classHistory for Float, bad value at:1' .
  ].
].
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_createClusterBuckets
AllClusterBuckets size == 0 ifTrue:[
 GsObjectSecurityPolicy setCurrent: (Globals at:#DataCuratorObjectSecurityPolicy) while:[
  "Cluster bucket 1"
  (ClusterBucket new)
    description: 'Generic bucket 1. The default bucket after login.' ;
    immediateInvariant  "This bucket may not be changed".

  "Cluster bucket 2"
  (ClusterBucket new) description: 'Generic bucket 2' .

  "Cluster bucket 3"
  (ClusterBucket new) description: 'Generic bucket 3' .

  "Cluster bucket 4"
  (ClusterBucket new) description: 'Kernel classes behavior bucket' .

  "Cluster bucket 5"
  (ClusterBucket new) description: 'Kernel classes description bucket' .

  "Cluster bucket 6"
  (ClusterBucket new) description: 'Kernel bucket for AllSymbols and other kernel objects' .

  "Cluster bucket 7"
  "  provided so the maximum clusterId returns a generic bucket in the
     GemStone kernel for compatibility with prior releases"
  (ClusterBucket new) description: 'Generic bucket 7' .
 ].
 GsFile gciLogServer:'created cluster buckets 1..7 '.
] ifFalse:[ | sz |
  (sz := AllClusterBuckets size) < 7 ifTrue:[
    Error signal:'AllClusterBuckets size ', sz asString
  ].
].
AllClusterBuckets clusterInBucket: 1.
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_createFloatAliases
    | report |
  report := String new .
  { #FloatE . #FloatD . #FloatQ } do:[:k |
    (Globals includesKey: k) ifFalse:[
       Globals at: k put: Float .
       (Globals associationAt: k) immediateInvariant .
       report add: 'added ' ; add: k ; lf .
    ].
  ].
  GsFile gciLogServer: report
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_disallowGciCreateStore_onExceptions
" gss64 v3.2 , disallow structural update on a bunch of classes
   to restrict use of instVarAt:put:  "
| count |
count := 0 .
Globals valuesDo:[:v |
  (v isBehavior and:[v isSubclassOf: AbstractException]) ifTrue:[
      v _structuralUpdatesDisallowed ifFalse:[
        v _disallowGciCreateStore . count := count + 1 ]
  ]
].
^ count
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_disallowGciCreateStore_onMetaclasses
"Disallow GCI create/store of instances of Metaclasses.
 We don't patch customer classes.  Newly created metaclasses will get this
 automatically."
| count |
count := 0 .
Class class _structuralUpdatesDisallowed ifFalse:[
  { Globals . ObsoleteClasses .  GemStone_Portable_Streams .
    GemStone_Legacy_Streams . ObsoleteClasses } do:[:dict |
      dict valuesDo:[:v |
        v isBehavior ifTrue:[ | m |
        (m := v class) isMeta ifTrue:[
          m _disallowGciCreateStore . count := count + 1
        ].
      ].
    ].
  ].
].
^ count
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_disallowGciCreateStore_onVM_FFI
| count |
GsFile gciLogServer:'In _disallowGciCreateStore_onVM_FFI' .
count := 0 .
{ CBuffer .
  CCallin .
  CCallout .
  CCalloutStructs .
  CFunction .
  ClassHistory .
  Delay .
  ExecBlock2 .
  GsObjectSecurityPolicy .
  GsProcess .
  GsSocket  .
  GsSignalingSocket .
  GsSecureSocket .
  GsStackBuffer .
  ProcessorScheduler .
  Semaphore .
  UserSecurityData .
  VariableContext .
  SymbolList .
} do:[:cls |
  cls _structuralUpdatesDisallowed ifFalse:[
    cls _disallowGciCreateStore . 
    count := count + 1 .
    GsFile gciLogServer: cls name, ' _disallowGciCreateStore' .
  ] 
].

" Make various classes in the indexing subsystem 'protected'.
  This prevents accessing an instance through structural access
  31162: also protect classes for code security."
{ GsObjectSecurityPolicySet .  SetValuedPathTerm .  SetValuedPathEvaluator .
  UserSecurityData .
"31162"
   GsNMethod .  Class . GsMethodDictionary . SymbolDictionary .
   SymbolList .  UserProfile }
    do: [ :aClass | aClass _makeProtected ].
^ count
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_initAllUsers
| dcPolicy  |
AllUsers _initialize  .
dcPolicy  := Globals at:#DataCuratorObjectSecurityPolicy .
AllUsers objectSecurityPolicy == dcPolicy  ifTrue:[
  GsFile gciLogServer: 'AllUsers objectSecurityPolicy ok'.
] ifFalse:[
  AllUsers objectSecurityPolicy: dcPolicy  .
  AllUsers do:[ :aUp |
    aUp objectSecurityPolicy == dcPolicy  ifFalse:[ aUp objectSecurityPolicy: dcPolicy ].
  ].
  GsFile gciLogServer: 'changed AllUsers objectSecurityPolicy'.
].
(Globals at: #DataCuratorObjectSecurityPolicy) setCurrentWhile:[
  | symList userGlobals |
  symList:= (AllUsers detect: [:x | x userId = 'DataCurator']) symbolList.
  userGlobals := symList objectNamed: #UserGlobals.
  (userGlobals includesKey: GsPackagePolicy globalName) ifFalse:[
      userGlobals add: (SymbolAssociation newWithKey: GsPackagePolicy globalName
                                      value: GsPackagePolicy new).
  ].
].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_initIcuCollator
(IcuCollator _resolveClassVar: #LibraryVersion) ifNil:[
  IcuCollator _addClassVar: #LibraryVersion value: (IcuCollator libraryVersion).
  ^ 'added'
].
^ ' no change'
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_initIndexing
  IndexManager current .
  GsQuery _initialize.
  GsQueryFormula _initialize.
  GsQueryTokenParser _initialize.
  GsPackagePolicy restrictedClasses.
  System commit .
  (Globals includesKey: #'GsDefaultIndexOptions')
    ifFalse: [
      "during upgradeImage, the default GsIndexOption needs to be preserved" 
      GsIndexOptions default: GsIndexOptions btreePlusIndex + GsIndexOptions optimizedComparison ].
  System commit .
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_initIrClasses
  | gsCompDict |
  (gsCompDict := Globals at: #GsCompilerClasses otherwise: nil) ifNil:[
    Error signal: 'GsCompilerClasses missing from Globals'.
  ].
  (gsCompDict at: #GsComSelectorLeaf) _initializeSpecialSelectors .
  (gsCompDict at: #GsComMethNode) checkRubyInfoMasks .
  (gsCompDict at: #GsComSendNode) initialize.
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_initSharedDepList
(Globals at: #SharedDependencyLists otherwise: nil) ifNil: [
  Globals at: #SharedDependencyLists put: DepListTable new  .
  GsFile gciLogServer:'created SharedDependencyLists' .
] ifNotNil:[:list |
  list class == DepListTable ifFalse:[
    Error signal:'bad class ', list class name
  ].
  GsFile gciLogServer:'created SharedDependencyLists exists' .
].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_initUndefinedObject
  UndefinedObject _removeClassVar: #_noResultNil ifAbsent:[]. "fix 49270"
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_installDocumentation
" Install class documentation for kernel classes only."
| classes blk symList obsDict |
(obsDict := Globals at: #ObsoleteClasses otherwise: nil) ifNil:[
  Error signal: 'ObsoleteClasses missing from Globals'.
].

blk := [
  " list of placeholder classes within the server "
  { (obsDict at: #UnimplementedFloat1) . (obsDict at: #UnimplementedFloat2) } do: [ :aClass |
      aClass comment:
      aClass name, ' implements GemStone internals.
It is not intended for customer use, by creating instances or by subclassing.'.
  ].
].
[ blk value ] on: Deprecated do: [:ex | ex resume].
symList := System myUserProfile symbolList .
symList do:[:dict |
  classes := ClassSet new.
  (dict values) do: [ :each |
    ( (each isKindOf: Class)
      and:[(each class includesSelector: #installDocumentation)] ) ifTrue: [ classes add: each.  ].
  ].
  classes do: [ :aClass |
    [
      aClass installDocumentation .
      aClass class removeSelector: #installDocumentation .
      GsFile gciLogServer:'installed doc for ', aClass name  .
    ] on: Error do:[:ex | | nm |
      nm := [ aClass name ] on: Error do:[:exb | aClass asOop asString ] .
      GsFile gciLogServer:'skipped class ' , nm , ' due to ' , ex asString .
    ].
  ].
  classes := ClassSet new.
  (dict values) do: [ :each |
    ( each ~~ Class and:[ (each isKindOf: Class)
       and:[ each class includesSelector: #comment]]) ifTrue: [ classes add: each.  ].
  ].
  classes do: [ :aClass |
    [  aClass comment: aClass comment .
       aClass class removeSelector: #comment .
    ] on: Error do:[:ex | | nm |
		  nm := [ aClass name ] on: Error do:[:exb | aClass asOop asString ] .
		  GsFile gciLogServer:'skipped class ' , nm , ' due to ' , ex asString .
	  ].
  ].
].
^true
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_migrateGroups
self _checkObsoleteMigrateGroups.
GsObjectSecurityPolicy setCurrent: (Globals at:#DataCuratorObjectSecurityPolicy) while:[
  | published publishedSeg gbRef migrateBlock createBlock obsDict |
(obsDict := Globals at: #ObsoleteClasses otherwise: nil) ifNil:[
  Error signal: 'ObsoleteClasses missing from Globals'.
].

  AllGroups class == SymbolKeyValueDictionary ifFalse:[ | cls |
    (cls := AllGroups class) == (obsDict at: #CanonicalStringDictionary) ifTrue:[ |newDict |
      newDict :=  SymbolKeyValueDictionary new: 53 .
      AllGroups do:[ :aStr | | sym newGroup |
        sym := Symbol withAll: aStr .
        newGroup := UserProfileGroup _primNewWithName: sym .
        newDict at: sym put: newGroup .
        ].
      AllGroups := newDict .
      GsFile gciLogServer:'Converted AllGroups to a SymbolKeyValueDictionary'.
    ] ifFalse:[
      Error signal: 'AllGroups has unexpected class ', cls name asString .
    ].
  ].

  AllGroups class == SymbolKeyValueDictionary ifFalse:[
    Error signal:'AllGroups is not a SymbolKeyValueDictionary'.
  ].

  createBlock := [:str|
     (UserProfileGroup groupWithName: str otherwise: nil)
    ifNil:[ UserProfileGroup newGroupWithName: str ]
  ].

  createBlock value: 'System' ;
              value: 'Publishers' ;
	      value: 'Subscribers' ;
	      value: 'SymbolUser' ;
	      value: 'DataCuratorGroup' .

  publishedSeg := (Globals at:#SystemRepository) at: 6 .
  gbRef := Globals at:#PublishedObjectSecurityPolicy otherwise: nil .
  publishedSeg == gbRef ifFalse:[ Error signal:'invalid PublishedObjectSecurityPolicy ref' ].

  publishedSeg group: 'Subscribers' authorization: #read  ;
    group: 'Publishers'  authorization: #write .

"Create Published if it does not yet exist"
  (System myUserProfile objectNamed: #Published)
    ifNil:[
       GsObjectSecurityPolicy setCurrent: publishedSeg while:[
          (published := SymbolDictionary new) name: #Published .
    ].
  ].
  migrateBlock := [:idSet| | arrayOfStrings |
    (idSet size > 0) ifTrue:[ "Weeds out nils"
      arrayOfStrings := idSet asArray .
      idSet removeAll: idSet .
       arrayOfStrings do:[:obj|
           obj class == UserProfileGroup
	     ifTrue:[ idSet add: obj ]
	     ifFalse:[  |newGroup|
	       obj _validateClass: String .
               newGroup := AllGroups at: obj otherwise: nil .
               newGroup notNil ifTrue:[ idSet add: newGroup ]]]]
   ].
  SystemRepository _migrateGroups: migrateBlock .
  AllUsers do:[:aUserPro |
    aUserPro _migrateGroups: migrateBlock .
    published notNil ifTrue:[ aUserPro symbolList addLast: published ] .
    aUserPro addGroup: 'Subscribers' .
    ].

  (AllUsers userWithId: 'DataCurator')
     addGroup: 'System' ;
     addGroup: 'Publishers';
     addGroup:'DataCuratorGroup' .

  (AllUsers userWithId: 'SystemUser')
     addGroup: 'System' ;
     addGroup: 'Publishers' .

"Minimum password length is 1 as of 3.4.  Zero-length password now used for passwordless login."
  (AllUsers minPasswordSize == 0)
    ifTrue:[ AllUsers minPasswordSize: 1 ] .

  (Globals at: #DataCuratorObjectSecurityPolicy) group:'DataCuratorGroup' authorization: #write .

"Initialize AllKerberosPrincipals global if needed."
  (Globals at: #AllKerberosPrincipals otherwise: nil)
    ifNil:[ |allPrins|
      allPrins := SymbolKeyValueDictionary new: 103.
      allPrins _unsafeSetOop: 157953 .
      Globals at: #AllKerberosPrincipals put: allPrins .
    ].
].
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_patchObsoleteClasses
  | arr str | str := '_patchObsoleteClasses  ' copy.
  arr := #( 92417 #ObsoleteGeode #Geode
           104705 #ObsoleteGsRdbConnection #GsRdbConnection ) .
  1 to: arr size by: 3 do:[:n | | oop nam oldName |
    oop := arr at: n .
    nam := arr at: n + 1 .
    oldName := arr at: n + 2 .
    (Object _objectForOop: oop ) ifNotNil:[:cls |
      cls name == oldName ifTrue: [
        cls _unsafeAt: 11 put: nam . str add:'changed name to ',nam ; lf .
      ].
    (Globals includesKey: oldName ) ifTrue:[
       Globals removeKey: oldName .   str add:'removed ', oldName,' from Globals '; lf .
    ].
    (ObsoleteClasses includesKey: oldName ) ifTrue:[
       ObsoleteClasses removeKey: oldName .   str add:'removed ', oldName,' from ObsoleteClasses ';lf.
    ].
    (Globals includesKey: nam ) ifTrue:[
       Globals removeKey: nam .  str add:'removed ', nam, ' from Globals';lf .
    ].
    ObsoleteClasses at: nam ifAbsentPut:[
        str add: 'added ', nam, ' to ObsoleteClasses';lf . cls ].
    ] ifNil:[ str add: oop asString,' does not exist'; lf .].
  ].
  str lf .
  GsFile gciLogServer: str 
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_recompileNumericMethods
 " recompile methods for classes referencing the Maximum...
  numeric value classVars for faster references to those values"
  { Integer . Interval . LargeInteger . Fraction . ScaledDecimal . DecimalFloat }
  do:[:aClass | aClass _recompileAllMethods ].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_removeConstraints
  Globals classesDo:[:aUserProfile :aSymbolDictionary :aClass |
    [aClass _constraints ifNotNil:[
      GsFile gciLogServer:'Clearing constraints on class ', aClass name asString,
           ' oop ', aClass asOop asString .
      aClass _clearConstraints .
    ]] on: Deprecated do: [:ex | ex resume].
  ] .
  ^ true .
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_removeEmptyCategories
"Removes empty categories from all Classes and metaclasses in Globals.
 Returns an Array describing the categories removed.
  was in image/removeemptycateg.gs "
| report |
(report := 'Removed empty categories' copy)  lf .
Globals associationsDo: [ :globalsAssoc | | aClass |
  aClass := globalsAssoc value .

  (aClass isKindOf: Behavior) ifTrue:[ | theClass empties envId |
    theClass := aClass .
    envId := 0 .
    2 timesRepeat:[
      empties := { }  .
      theClass categorysDo:[ :categName :selectors |
          selectors size == 0 ifTrue:[
            empties add: { categName . envId } .
	  ].
      ].
      empties do:[ :anArr || aName |
        aName := anArr at:1 .
        theClass removeCategory: aName environmentId: (anArr at:2) .
        report add: '  ', theClass name,'  ', aName; lf .
      ].
      theClass := theClass class . "handle the metaclass on second pass"
    ].
  ].
].
GsFile gciLogServer: report .
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_removeMethodsAfterUpgrade
 self oldImageVersion < 3.6 ifTrue:[
  {
   { BlockClosure  . #(setPackage:withInMetacelloConfig: )}.
   { CanonStringDict . #( collect: reject: )}.
   { CharacterCollection . #( tonelSubstrings: )}.
   { Collection . #( asMetacelloAttributeList
                setForDo:withInMetacelloConfig:
                setIncludesInMetacelloPackage:
                setLoadsInMetacelloProject:
                setRequiresInMetacelloPackage:
                sorted: )}.
   { Class . #( _newKernelSubclass:instVarNames:inDictionary: )}.
   { CZstream class . #( _initializeConstants )}.
   { DateAndTimeANSI . #( _secondsUTC:offset: )}.
   { DateAndTime     . #( offset: )}.
   { Dictionary class . #( newFromPairs: 
               _nonInheritedOptions  _optionsForDefinition  )}.
   { GsBitmap . #( _enumerateAsOopsWithLimit:startingAfter: ) }.
   { GsSecureSocket class . #( httpsClientExampleForHost:certificateDirectory: )}.
   { Interval . #( asParser )}.

   { MessageNotUnderstood . #( selector selector: ) } .
   { Object . #( _isRegexp _isRubyHash ) }.
   {  Object class . #( fixReferencesAfterConversionFromDirectory: )}.
   { PositionableStream . #(  originalContents )}.
   { SequenceableCollection . #(  writeStream )}.
   { String . #( addToMetacelloRepositories:
                  addToMetacelloRepositories:
                  asObsoleteSymbol
                  asObsoleteSymbol
                  execute:against:
                  execute:against:
                  fetchRequiredForMetacelloMCVersion:
                  fetchRequiredForMetacelloMCVersion:
                  loadRequiredForMetacelloMCVersion:
                  loadRequiredForMetacelloMCVersion:
                  mergeIntoMetacelloRepositories:
                  mergeIntoMetacelloRepositories:
                  packageFileSpecFor:
                  packageFileSpecFor:
                  recordRequiredForMetacelloMCVersion:
                  recordRequiredForMetacelloMCVersion:
                  removeFromMetacelloRepositories:
                  removeFromMetacelloRepositories:
                  resolvePackageSpecsNamedForMetacelloMCVersion:visited:ifAbsent:
                  resolvePackageSpecsNamedForMetacelloMCVersion:visited:ifAbsent:
                  setIncludesInMetacelloPackage:
                  setIncludesInMetacelloPackage:
                  setLoadsInMetacelloProject:
                  setLoadsInMetacelloProject:
                  setRequiresInMetacelloPackage:
                  setRequiresInMetacelloPackage: )}.
  { Symbol . #( asMetacelloAttributeList
              asMetacelloAttributePath
              setForDo:withInMetacelloConfig:
              setForVersion:withInMetacelloConfig:
              setPostLoadDoItInMetacelloSpec:
              setPreLoadDoItInMetacelloSpec: )}.
  { System class . #( fastFindObjectsLargerThan:limit:
                       findObjectsLargerThan:limit:  )}.
  { Time . #( _initialize: )}.
   } do:[:elem | | cls |
      cls := elem at: 1 .
     (elem at: 2) do:[:sym | cls removeSelector: sym ifAbsent:[]]
   ].
 ].
%

category: 'private'
classmethod: Upgrade3Init
_setTimeStamps
| classes epoch blk |
epoch :=  DateTime now  .
classes := IdentitySet new .
{ Globals . ObsoleteClasses .  GemStone_Portable_Streams .
    GemStone_Legacy_Streams . ObsoleteClasses } do:[:dict |
 dict valuesDo:[ :aValue|
    (aValue isKindOfClass: Class) ifTrue:[ classes add: aValue].
  ].
].
blk := [:cls :ivName :val | | ofs |
 "Class >> instVarAt:put:"
   ofs := cls class _ivOffsetOf: ivName .
   cls _unsafeAt: ofs put: val .
   ].
classes asArray do:[ :aClass |
  aClass timeStamp ifNil:[
    blk value: aClass value: #timeStamp value: epoch .
    blk value: aClass value: #userId    value: 'SystemUser'.
    "let extraDict be created as needed by setters"
    "classHistory initialized by bom.c / repository conversion "
    "destClass instance variable left as nil "
  ].
].
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_testCharacter
  | ary exp rpt |
  ary := { } .
  rpt := String new .
  #( lf cr space tab backspace ) do:[:sel | ary add:( Character perform: sel) codePoint ].
  ary = (exp := #( 10 13 32 9 8 )) ifFalse:[
    rpt add:'bad Character literal(s); ', ary printString ; lf ;
        add:' expected ', exp printString; lf .
    GsFile gciLogServer: rpt .
    Error signal: rpt .
  ].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_userProfile_allowAddInstVar
| cls |
" allow adding instance variables UserProfile .  fixes bug 6569"
  cls := UserProfile .
  cls _unsafeAt: 4 "instVarNames"
                 put: (Array withAll: (cls instVarAt: 4)) .
  cls _refreshClassCache: false
%

! Class Initialization Excluded by export visitor
!  Upgrade3Init initialize.
