expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #RWBinaryOrTextStreamTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'RWBinaryOrTextStreamTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'RWBinaryOrTextStreamTest') .
	newCls category: 'RWBinaryOrTextStream-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods RWBinaryOrTextStreamTest
removeallclassmethods RWBinaryOrTextStreamTest


expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ReadWriteStreamTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'ReadWriteStreamTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ReadWriteStreamTest') .
	newCls category: 'CollectionsTests-Monticello-Streams'.newCls classComment: 'This is the unit test for the class ReadWriteStream.
Unit tests are a good way to exercise the
functionality of your system in a repeatable and
automatic manner. They are therefore recommended if
you plan to release anything. For more information,
see: 
	- http://www.c2.com/cgi/wiki?UnitTest
	- http://minnow.cc.gatech.edu/squeak/1547
	- the sunit class category' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ReadWriteStreamTest
removeallclassmethods ReadWriteStreamTest

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ReadWriteStream otherwise: nil.
oldCls == nil ifTrue: [
	AnsiWriteStream subclass: 'ReadWriteStream'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ReadWriteStream') .
	newCls category: 'Collections-Monticello-Streams'.newCls classComment: 'I represent an accessor for a sequence of objects. My instances can both read and store objects.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ReadWriteStream
removeallclassmethods ReadWriteStream

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #RWBinaryOrTextStream otherwise: nil.
oldCls == nil ifTrue: [
	ReadWriteStream subclass: 'RWBinaryOrTextStream'
	instVarNames: #( isBinary )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'RWBinaryOrTextStream') .
	newCls category: 'Collections-Monticello-Streams'.newCls classComment: 'A simulation of a FileStream, but living totally in memory.  Hold the contents of a file or web page from the network.  Can then fileIn like a normal FileStream.

Need to be able to switch between binary and text, as a FileStream does, without recopying the whole collection.  Convert to binary upon input and output.  Always keep as text internally.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods RWBinaryOrTextStream
removeallclassmethods RWBinaryOrTextStream


category: 'tests'
method: ReadWriteStreamTest
testConstructionUsingWith
	"Use the with: constructor."

	| aStream |
	aStream := ReadWriteStream with: #(1 2).
	self assert: (aStream contents = #(1 2)) description: 'Ensure correct initialization.'
%

category: 'tests - testing'
method: ReadWriteStreamTest
testIsEmpty
	| stream |
	stream := ReadWriteStream on: String new.
	self assert: stream isEmpty.
	stream nextPut: $a.
	self deny: stream isEmpty.
	stream reset.
	self deny: stream isEmpty.
	stream next.
	self deny: stream isEmpty.
%

category: 'tests'
method: ReadWriteStreamTest
testNew

	self should: [ReadWriteStream new] raise: Error.
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
asBinaryOrTextStream

	^ self
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
ascii
	isBinary := false
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
binary
	isBinary := true
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
contents

	self isBinary ifFalse: [^ super contents].	"String"
	^itsCollection asByteArray
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
isBinary
	isBinary == nil ifTrue: [ ^false ].
	^ isBinary
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
closed
	^false
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
rwbotNext

(self atEnd)
   ifTrue: [ ^ nil].
self position: self position + 1.
^ itsCollection at: self position
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
next

	| byte |
	^ self isBinary 
		ifTrue: [
			byte := self rwbotNext.
			byte ifNil: [nil] ifNotNil: [byte asInteger]]
		ifFalse: [self rwbotNext].

%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
nextInto: aCollection
	"Read the next elements of the receiver into aCollection.
	Return aCollection or a partial copy if less than aCollection
	size elements have been read."
	^self next: aCollection size into: aCollection startingAt: 1.
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
next: anInteger 
	"Answer the next anInteger elements of my collection. Must override to get class right."

	| newArray |
	newArray := (self isBinary ifTrue: [ByteArray] ifFalse: [String]) new: anInteger.
	^ self nextInto: newArray
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
next: n into: aCollection startingAt: startIndex
	"Read n objects into the given collection. 
	Return aCollection or a partial copy if less than
	n elements have been read."
	| obj collBinary |
        collBinary := aCollection class == ByteArray.
	0 to: n-1 do:[:i|
		self atEnd ifTrue: [ ^aCollection copyFrom: 1 to: startIndex+i-1 ].
		obj := self next.
		collBinary 
			ifTrue: [ obj := obj asInteger ]
			ifFalse: [ obj := obj asCharacter ].
		aCollection at: startIndex+i put: obj].
	^aCollection
%

category: 'writing'
method: RWBinaryOrTextStream
next: anInteger putAll: aCollection startingAt: startIndex
	"Store the next anInteger elements from the given collection."
	(startIndex = 1 and:[anInteger = aCollection size])
		ifTrue:[^self nextPutAll: aCollection].
	^self nextPutAll: (aCollection copyFrom: startIndex to: startIndex+anInteger-1)
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
nextPut: charOrByte
	^super nextPut: charOrByte asCharacter
%

category: 'writing'
method: RWBinaryOrTextStream
nextPutAll: aCollection
	^aCollection class == ByteArray 
		ifTrue: [ super nextPutAll: aCollection asString ]
		ifFalse: [ super nextPutAll: aCollection ]
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
padToEndWith: aChar
	"We don't have pages, so we are at the end, and don't need to pad."
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
setFileTypeToObject
	"do nothing.  We don't have a file type"
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
text
	isBinary := false
%

category: 'writing'
method: RWBinaryOrTextStream
upTo: anObject 
	"Answer a subcollection from the current access position to the 
	occurrence (if any, but not inclusive) of anObject in the receiver. If 
	anObject is not in the collection, answer the entire rest of the receiver."
	| newStream element species |
	species := self isBinary ifTrue:[ByteArray] ifFalse:[String].
	newStream := WriteStream on: (species new: 100).
	[self atEnd or: [(element := self next) = anObject]]
		whileFalse: [
                	self isBinary ifTrue: [ element := element asInteger ].
                	newStream nextPut: element].
	^newStream contents
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
_initStreamWith: aCollection

	super _initStreamWith: aCollection.
	isBinary ifNil: [isBinary := false].
	aCollection class == ByteArray ifTrue: ["Store as String and convert as needed."
		itsCollection := aCollection asString.
		isBinary := true].
%

category: 'as yet unclassified'
method: RWBinaryOrTextStream
upToEnd
	"Must override to get class right."
	| newArray |
	newArray := (self isBinary ifTrue: [ByteArray] ifFalse: [String]) new: itsCollection size - self position.
	^ self nextInto: newArray
%

category: 'testing'
method: ReadWriteStream
= other

	(self class == ReadWriteStream and: [other class == ReadWriteStream]) ifFalse: [
		^ super = other].	"does an identity test.  Don't read contents of FileStream"
	^ self position = other position and: [self contents = other contents]
%

category: 'accessing'
method: ReadWriteStream
contents
	"Answer with a copy of my collection."

	^itsCollection copyFrom: 1 to: itsCollection size
%

category: 'accessing'
method: ReadWriteStream
name
	^ 'a stream'   "for fileIn compatibility"
%

category: 'accessing'
method: ReadWriteStream
next
"Returns the next object that the receiver can access for reading. Return nil if atEnd."

(self atEnd)
   ifTrue: [ ^ nil].
self position: self position + 1.
^ itsCollection at: self position
%

category: 'accessing'
method: ReadWriteStream
next: count

	"Returns the next count elements in the receiver's collection."

	| result |
	self isBinary
		ifTrue: [ result := ByteArray new ]
		ifFalse: [result := itsCollection species new ].
	count timesRepeat: [ 
		self atEnd ifTrue: [ ^ result ].
		result add: self next ].
	^result
%

category: 'converting'
method: ReadWriteStream
readStream
	"polymorphic with SequenceableCollection.  Return self"

	^ self
%

category: 'tests'
method: RWBinaryOrTextStreamTest
testNext
	{
		'abcd'.
		'abcd' asByteArray.
	}
		do: [ :collection | 
			| strm |
			strm := RWBinaryOrTextStream with: collection.
			strm _position: 0.
			strm binary.
			self assert: strm next == ($a asInteger).
			strm ascii.
			self assert: strm next == $b ]
%
run
RWBinaryOrTextStreamTest setStamp: 'DaleHenrichs 10/19/2010 12:42' forMethod: #'testNext'.
true
%

category: 'tests'
method: RWBinaryOrTextStreamTest
testNextIntoStartingAt
	{
		'abcdefg'.
		'abcdefg' asByteArray.
	}
		do: [ :collection | 
			| strm dest |
			strm := RWBinaryOrTextStream with: collection.
			strm _position: 0.
			strm binary.
			dest := strm next: 2 into: (ByteArray new: 2) startingAt: 1.
			self assert: dest = ('ab' asByteArray).
			strm _position: 0.
			dest := strm next: 2 into: (ByteArray new: 4) startingAt: 3.
			self assert: dest = (#(0 0) asByteArray, ('ab' asByteArray)).
			strm _position: 0.
			dest := strm next: 2 into: (String new: 4) startingAt: 3.
			strm _position: 0.
			strm ascii.
			dest := strm next: 2 into: (String new: 2) startingAt: 1.
			self assert: dest = 'ab' .
			strm _position: 0.
			dest := strm next: 2 into: (String new: 4) startingAt: 3.
			self assert: dest = (#(0 0) asByteArray asString, 'ab').
			strm _position: 0.
			dest := strm next: 2 into: (ByteArray new: 4) startingAt: 3 ]
%
run
RWBinaryOrTextStreamTest setStamp: 'DaleHenrichs 10/19/2010 12:56' forMethod: #'testNextIntoStartingAt'.
true
%

category: 'tests'
method: RWBinaryOrTextStreamTest
testNextIntoStartingAtPartial
	{
		'abcd'.
		'abcd' asByteArray.
	}
		do: [ :collection | 
			| strm dest |
			strm := RWBinaryOrTextStream with: collection.
			strm _position: 2.
			strm binary.
			dest := strm next: 4 into: (ByteArray new: 4) startingAt: 1.
			self assert: dest = ('cd' asByteArray).
			strm ascii.
			strm _position: 2.
			dest := strm next: 4 into: (String new: 4) startingAt: 1.
			self assert: dest = 'cd'.
			 ]
%
run
RWBinaryOrTextStreamTest setStamp: 'DaleHenrichs 10/19/2010 12:55' forMethod: #'testNextIntoStartingAtPartial'.
true
%

category: 'tests'
method: RWBinaryOrTextStreamTest
testNextn
	{
		'abcd'.
		'abcd' asByteArray.
	}
		do: [ :collection | 
			| strm |
			strm := RWBinaryOrTextStream with: collection.
			strm _position: 0.
			strm binary.
			self assert: (strm next: 2) = ('ab' asByteArray).
			strm ascii.
			self assert: (strm next: 2) = 'cd' ]
%
run
RWBinaryOrTextStreamTest setStamp: 'DaleHenrichs 10/19/2010 12:42' forMethod: #'testNextn'.
true
%

category: 'tests'
method: RWBinaryOrTextStreamTest
testNextPut
	{
		(String new).
		(ByteArray new).
	}
		do: [ :collection | 
			| strm |
			strm := RWBinaryOrTextStream on: collection.
			strm binary.
			strm nextPut: $c.
			strm nextPut: $c asInteger.
			self assert: strm contents = 'cc' asByteArray.
			strm ascii.
			strm nextPut: $c.
			strm nextPut: $c asInteger.
			self assert: strm contents = 'cccc'.
			 ]
%
run
RWBinaryOrTextStreamTest setStamp: 'DaleHenrichs 10/19/2010 12:44' forMethod: #'testNextPut'.
true
%

category: 'tests'
method: RWBinaryOrTextStreamTest
testNextPutAll
	{
		(String new).
		(ByteArray new).
	}
		do: [ :collection | 
			| strm |
			strm := RWBinaryOrTextStream on: collection.
			strm binary.
			strm nextPutAll: 'abc'.
			strm nextPutAll: 'abc' asByteArray.
			self assert: strm contents = 'abcabc' asByteArray.
			strm ascii.
			strm nextPutAll: 'abc'.
			strm nextPutAll: 'abc' asByteArray.
			self assert: strm contents = 'abcabcabcabc'.
			 ]
%
run
RWBinaryOrTextStreamTest setStamp: 'DaleHenrichs 10/19/2010 12:44' forMethod: #'testNextPutAll'.
true
%

category: 'tests'
method: RWBinaryOrTextStreamTest
testNextPutAllStartingAt
	{
		(String new).
		(ByteArray new).
	}
		do: [ :collection | 
			| strm |
			strm := RWBinaryOrTextStream on: collection.
			strm binary.
			strm next: 3 putAll: 'abcd' startingAt: 2.
			strm next: 3 putAll: 'abcd' asByteArray startingAt: 2.
			self assert: strm contents = 'bcdbcd' asByteArray.
			strm ascii.
			strm next: 3 putAll: 'abcd' startingAt: 2.
			strm next: 3 putAll: 'abcd' asByteArray startingAt: 2.
			self assert: strm contents = 'bcdbcdbcdbcd'.
			 ]
%
run
RWBinaryOrTextStreamTest setStamp: 'DaleHenrichs 10/19/2010 12:45' forMethod: #'testNextPutAllStartingAt'.
true
%

category: 'tests'
method: RWBinaryOrTextStreamTest
testUpTo
	{
		'abcd'.
		'abcd' asByteArray.
	}
		do: [ :collection | 
			| strm |
			strm := RWBinaryOrTextStream with: collection.
			strm _position: 0.
			strm binary.
			self assert: (strm upTo: $d asInteger) = ('abc' asByteArray).
			strm _position: 0.
			strm ascii.
			self assert: (strm upTo: $d) = 'abc' ]
%
run
RWBinaryOrTextStreamTest setStamp: 'DaleHenrichs 10/19/2010 12:42' forMethod: #'testUpTo'.
true
%

category: 'tests'
method: RWBinaryOrTextStreamTest
testUpToEnd
	{
		'abcd'.
		'abcd' asByteArray.
	}
		do: [ :collection | 
			| strm |
			strm := RWBinaryOrTextStream with: collection.
			strm _position: 1.
			strm binary.
			self assert: strm upToEnd = ('bcd' asByteArray).
			strm _position: 1.
			strm ascii.
			self assert: strm upToEnd = 'bcd' ]
%
run
RWBinaryOrTextStreamTest setStamp: 'DaleHenrichs 10/19/2010 12:42' forMethod: #'testUpToEnd'.
true
%
