# Copyright (C) GemTalk Systems 1986-2024.  All Rights Reserved.
#
# GDB commands for GemStone's pstack for Linux and Darwin

# Get a full stack with no user interaction
set confirm off
set pagination off
set backtrace limit 0

handle SIGIO pass nostop print
handle SIGPOLL pass nostop print
handle SIGPIPE pass nostop print
handle SIGWINCH pass nostop print
handle SIGFPE pass nostop print
handle SIGUSR1 pass nostop print
handle SIGUSR2 pass nostop print
handle SIGQUIT pass nostop print
handle SIG33 pass nostop print
handle SIG34 pass nostop print
handle SIG32 pass nostop print
handle SIGVTALRM pass nostop print
handle SIGSEGV  nopass stop print 
handle SIGBUS  nopass stop print 

# get stacks with one line per frame
thread apply all backtrace

# get the stacks of all threads, dumping local variables
#   if available.
thread apply all backtrace full

set gdbIsAttached = 1
# print smalltalk stacks, one line per frame
print (int) printStack(0)
# print smalltalk stack with receiver, args, temps for each frame
print (int) printStack(2)

# do last, it may not be resolvable
print IntLpBCLoop

# Done, let the process continue
set gdbIsAttached = 0
detach
quit
