!=========================================================================
! Copyright (C) GemTalk Systems 1986-2024.  All Rights Reserved.
!
! Description -
!   This file contains some useful GemStone Smalltalk commands.
!
!   Some commands include parameters, in capitals, that require you to
!   substitute the appropriate value.
!
!========================================================================

******************************************
*              CLASSES                   *
******************************************


 TO VIEW ALL THE SELECTORS UNDERSTOOD BY INSTANCES OF A CLASS 
    | r lf |
    lf := Character lf.
    (r := String new) add: lf .
    CLASSNAME allSelectors do: [:each |
      r addAll: each; add: lf ].
    ^r


 TO VIEW ALL THE SELECTORS UNDERSTOOD BY A CLASS OBJECT 
    | r lf |
    lf := Character lf.
    (r := String new) add: lf .
    CLASSNAME class allSelectors do: [:each |
      r addAll: each; add: lf ].
    ^r


 TO VIEW THE SOURCE CODE FOR AN INSTANCE METHOD
    ^CLASSNAME sourceCodeAt: #SELECTOR


 TO VIEW THE SOURCE CODE FOR A CLASS METHOD
    ^CLASSNAME class sourceCodeAt: #SELECTOR


 TO VIEW THE SELECTORS USED IN AN INSTANCE METHOD
    | r lf sels |
    lf := Character lf.
    (r := String new) add: lf .
    sels := (CLASSNAME compiledMethodAt: #SELECTOR) _selectorPool.
    sels do: [ :aSel |
        r addAll: aSel; add: lf.
        ].
    ^r


 TO VIEW THE SELECTORS USED IN A CLASS METHOD
    | r lf sels |
    lf := Character lf.
    (r := String new) add: lf .
    sels := (CLASSNAME class compiledMethodAt: #SELECTOR) _selectorPool.
    sels do: [ :aSel |
        r addAll: aSel; add: lf.
        ].
    ^r


******************************************
*             REPOSITORIES               *
******************************************


 TO VIEW THE FILENAMES OF THE SYSTEM REPOSITORY
    | r lf |
    lf := Character lf.
    (r := String new) add: lf .
    SystemRepository fileNames do: [ :fn |
            r addAll: fn;  add: lf.
            ].
    ^r


******************************************
*              SYSTEM                    *
******************************************

 TO SEE THE USER IDs OF PEOPLE CURRENTLY USING THE GEMSTONE 
    # requires Session Access privilege 
    System currentSessionNames


 TO SUSPEND LOGINS
    # requires System Control privilege 
    System suspendLogins


 TO SHUT DOWN THE GEMSTONE SYSTEM
    # requires System Control privilege 
    System shutDown


 TO STOP ALL SESSIONS BUT THIS ONE
    # requires System Control privilege 
    System stopUserSessions 


 TO RESUME LOGINS
    # requires System Control privilege 
    System resumeLogins


 TO SEE ALL GEMSTONE USERS
    | r lf |
    lf := Character lf.
    (r := String new) add: lf .
    AllUsers do: [:each |
      r addAll: each userId; add: lf ].
    ^r


 TO CHANGE A USER'S PRIVILEGES
    # you must be have OtherPassword privilege and write access to 
    # DataCuratorObjectSecurityPolicy. 
    # Replace PRIV_STRING with privilege string literals, such as 'SystemControl' 
    # or 'SessionAccess'. The full list is documented in the UserProfile>>privileges
    # method.

    (AllUsers userWithId: 'USER_ID' ) 
       privileges:  #{ PRIV_STRING . PRIV_STRING . ... }.


 TO ADD A NEW USER TO GEMSTONE (short form - no privileges or groups)
    # you must be have OtherPassword privilege and write access to 
    # DataCuratorObjectSecurityPolicy. 

    AllUsers addNewUserWithId: #USER_ID password: 'PASSWORD'


 TO ADD A NEW USER TO GEMSTONE (long form)
    # you must be have OtherPassword privilege and write access to 
    # DataCuratorObjectSecurityPolicy. 

    AllUsers addNewUserWithId: 'USER_ID' 
        password: 'PASSWORD'
        defaultObjectSecurityPolicy: anObjectSecurityPolicy
        privileges:  #{ PRIV_STRING . PRIV_STRING . ... }.
        inGroups: { GROUPNAME . GROUPNAME .  ... }



******************************************
*              USERGLOBALS               *
******************************************


 TO VIEW ALL THE ENTRIES IN UserGlobals (or other SymbolDictionary)
    | r lf |
    lf := Character lf.
    (r := String new) add: lf .
    UserGlobals keys do: [ :each |
      r addAll: each; add: lf ].
    ^r


 TO REMOVE AN ENTRY FROM UserGlobals (or other SymbolDictionary)
    UserGlobals removeKey: #KEY_TO_REMOVE



******************************************
*              USERPROFILES              *
******************************************


 TO FIND WHICH DICTIONARY OF YOUR SYMBOL LIST HOLDS A NAMED OBJECT
    | das |
    das := System myUserProfile dictionariesAndSymbolsOf: OBJECTNAME.
    das size < 1 ifTrue: [^'object is not found'] ifFalse: [das := das first].
    " das now holds Array #(dict, symbol) for the object. 
      Now find the symbol of the dict: "
    das := System myUserProfile dictionariesAndSymbolsOf: (das at: 1).
    das size < 1 
       ifTrue: [^'dictionary holding object is not named'] 
       ifFalse: [^das at: 2].


 TO LIST THE NAMES OF THE DICTIONARIES IN YOUR SYMBOL LIST
    | r lf userPro das |
    lf := Character lf.
    (r := String new) add: lf .
    userPro := System myUserProfile.
    userPro symbolList do: [ :aDict |
        das := userPro dictionariesAndSymbolsOf: aDict.
        das size < 1 
              ifTrue: [r addAll: 'unnamed dictionary'; add: lf. ]
              ifFalse: [r addAll: (das first at: 2); add: lf. ].
        ].
    ^r


 TO LIST YOUR SYMBOL LIST AND ITS CONTENTS
    | r lf userPro das |
    lf := Character lf.
    (r := String new) add: lf .
    userPro := System myUserProfile.
    " for each dictionary in the symbol list, list name and contents "
    userPro symbolList do: [ :aSymDict |
        das := userPro dictionariesAndSymbolsOf: aSymDict.
        das size < 0 ifTrue: [
            r addAll: 'unnamed dictionary'; add: lf. ]
        ifFalse: [
            " for each entry in the dictionary, list name and class "
            r addAll: (das first at: 2); add: lf.
            aSymDict keysAndValuesDo: [ :key :val |
                r addAll: '    '; addAll: (key);
                  addAll: ' '.
                (30 - key size) timesRepeat: [ r addAll: ' ' ].
                r addAll: (val class name); add: lf.
                ].
            ].
        ].
    ^r


 TO LIST YOUR SYMBOL LIST AND ALL CLASS OBJECTS IT CONTAINS
    | r userPro das |
    r := String new.
    userPro := System myUserProfile.
    " for each dictionary in the symbol list, list name and contents "
    userPro symbolList do: [ :aSymDict |
        das := userPro dictionariesAndSymbolsOf: aSymDict.
        das size < 0 ifFalse: [
            " for each entry in the dictionary, list name and class "
            r lf; add: (das first at: 2); lf.
                aSymDict keys asSortedCollection do: [:key |  | val |
                     val := aSymDict at: key.
                (val isKindOf: Behavior) ifTrue: [
                    r tab; add: key; space.
                          val class name ~= (key, ' class')
                                ifTrue: [r add: ' (', val class name, ')'].
                          r lf]]]].
    ^r



