Class {
	#name : 'RowanPackageGroupService',
	#superclass : 'RowanComponentDefinitionService',
	#instVars : [
		'condition',
		'packageServices',
		'projectName'
	],
	#category : 'Rowan-Services-Core'
}

{ #category : 'constants' }
RowanPackageGroupService class >> allPackagesGroupName [
	^'All Packages'
]

{ #category : 'instance creation' }
RowanPackageGroupService class >> forPackageGroupNamed: packageGroupName loadedProject: rwProject [
	| inst packageGroup |
	packageGroup := rwProject packageGroupNamed: packageGroupName.
	inst := self new name: packageGroupName.
	inst condition: packageGroup condition.
	inst computeLoadedPackageNamesFor: rwProject.
	inst computePackageServices;
	projectName: rwProject name. 
	^ inst
]

{ #category : 'instance creation' }
RowanPackageGroupService class >> forPackageGroupNamed: packageGroupName projectDefinition: projectDefService [
	| inst projectDefinition |
	inst := self new name: packageGroupName; projectDefinitionService: projectDefService.
	projectDefinition := projectDefService definition. 
	inst condition: (projectDefinition packageGroupNamed: packageGroupName) condition.
	inst computePackageNames.
	^ inst
]

{ #category : 'client commands support' }
RowanPackageGroupService >> computeLoadedPackageNamesFor: rwProject [
	| packageGroup |
	packageNames := name = self class allPackagesGroupName
		ifTrue: [ Rowan image packageNamesForLoadedProjectNamed: rwProject name ]
		ifFalse: [ 
			packageGroup := rwProject packageGroupNamed: name.
			packageGroup packageNames
				select: [ :packageName | (Rowan image loadedPackageNamed: packageName ifAbsent: [  ]) notNil ] ]
]

{ #category : 'client commands support' }
RowanPackageGroupService >> computePackageNames [
	projectDefinitionService := RowanProjectDefinitionService new name: projectDefinitionService name.  "Always get a new one in browser"
	name = self class allPackagesGroupName
		ifTrue: [ 
			packageNames := Rowan image
				packageNamesForLoadedProjectNamed: projectDefinitionService name ]
		ifFalse: [ 
			| loadedPackageNames packageGroup |
			loadedPackageNames := (Rowan image
				loadedProjectNamed: projectDefinitionService name) packageNames.
			packageGroup :=  self projectDefinition packageGroupNamed: name. 
			packageNames := packageGroup packageNames
				select: [ :pkgName | loadedPackageNames includes: pkgName ] ]
]

{ #category : 'updating' }
RowanPackageGroupService >> computePackageServices [
	packageServices := packageNames
		collect: [ :packageName | (RowanPackageService forPackageNamed: packageName) update ]
]

{ #category : 'accessing' }
RowanPackageGroupService >> condition [
	^condition
]

{ #category : 'accessing' }
RowanPackageGroupService >> condition: object [
	condition := object
]

{ #category : 'replication' }
RowanPackageGroupService >> excludedInstVars [

	^super excludedInstVars, #( #projectDefinition)
]

{ #category : 'accessing' }
RowanPackageGroupService >> projectDefinition [
	^projectDefinitionService initializeDefinitionOop definition
]

{ #category : 'accessing' }
RowanPackageGroupService >> projectName [
	^projectName
]

{ #category : 'accessing' }
RowanPackageGroupService >> projectName: object [
	projectName := object
]

{ #category : 'updating' }
RowanPackageGroupService >> update [
	| rwProject theProjectName |
	theProjectName := projectDefinitionService
		ifNil: [ projectName ]
		ifNotNil: [ projectDefinitionService name ].
	rwProject := Rowan projectNamed: theProjectName.
	self computeLoadedPackageNamesFor: rwProject.
	self computePackageServices.
	wasUpdated := true.
	RowanCommandResult addResult: self.
	shouldUpdate := false	"don't perform the secondary update"
]
