Extension { #name : 'Class' }

{ #category : 'Private' }
Class >> _clearCachedOrganizer [
  ^ self "bootstrap implementation , remplemented in class2.gs"

]

{ #category : 'Subclass Creation' }
Class >> _makeClassVarDict: anArrayOfClassVars [

"Turns Array of class variable names into a SymbolDictionary.
 Returns nil if anArrayOfClassVars is empty or nil.

 FINAL implementation in class2.gs "

| newDict |
self _validatePrivilege ifTrue:[
  anArrayOfClassVars ifNotNil:[
    anArrayOfClassVars _isArray ifFalse:[
      (anArrayOfClassVars _validateClass: Array) ifFalse:[ ^ nil ].
    ].
    anArrayOfClassVars size ~~ 0 ifTrue:[
      newDict := SymbolDictionary new.
      1 to: anArrayOfClassVars size do: [:index|
        | aVarName aSym definingClass |
        aVarName := anArrayOfClassVars at: index .
        (aVarName _isOneByteString or:[ aVarName _validateClass: CharacterCollection]) ifTrue:[
          aSym := aVarName asSymbol .
          aSym validateIsIdentifier "fix bug 9666" .
          definingClass := self _classDefiningClassVar: aSym .  "fix bug 10480"
          definingClass ifNotNil:[
            LookupError new object: definingClass; key: aSym ; reason: #classErrClassVarNameExists ;
                details: 'class variable already exists'; signal
          ] ifNil:[
            newDict at: aSym put: nil
          ]
        ].
      ].
    ].
  ].
].
^ newDict .

]

{ #category : 'Private' }
Class >> _rwCategory: newCategory [
"Sets the classCategory variable of the receiver.
 The argument should be a kind of CharacterCollection or nil."
"Stub method for use when Rowan is NOT installed.Rowan overrides this method to include additional functionality required by Rowan" 

	self _category: newCategory
]

{ #category : 'Private' }
Class >> _rwCreateSubclass: aString instVarNames: anArrayOfInstvarNames classVars: anArrayOfClassVars classInstVars: anArrayOfClassInstVars poolDictionaries: anArrayOfPoolDicts inDictionary: aDictionary newVersionOf: oldClass description: aDescription options: optionsArray ifUnpackagedDo: unpackagedBlock [
	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

^ unpackagedBlock value
]

{ #category : 'Private' }
Class >> _sortedClassVarNames [

"Return an unsorted list because the image is still being bootstrapped."
  classVars ifNil:[ ^ { } ].
  ^ classVars keys

]

{ #category : 'Subclass Creation' }
Class >> _subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
newVersionOf: oldClass
description: aDescription
options: optionsArray [

 "optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

	| hist descr |
	descr := aDescription.
	oldClass
		ifNotNil:
			[ (self
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: optionsArray
				newFormat: oldClass format
				newInstVars: anArrayOfInstvarNames
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false)
					ifTrue:
						[oldClass _commentOrDescription: aDescription.
						^oldClass	"avoid creation of a new version"].
			hist := oldClass classHistory.
			descr
				ifNil:
					[descr := [oldClass commentForFileout] on: Error
								do: [:ex | 'old comment not available']]].
	^self
		_subclass: aString
		instVarNames: anArrayOfInstvarNames
		format: format
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: hist
		description: descr
		options: optionsArray

]

{ #category : 'Private' }
Class >> _subclass: className
instVarNames: anArrayOfInstvarNames
format: theFormat
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
inClassHistory: aClassHistory
description: aDescription
options: optionsArray [

	"The preferred private subclass creation method.
 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant .
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.
"

"Final version of this method installed in Filein3Init package"

	| cvDict result theName ivNames theHist poolDicts modifiableBool fmtArr fmt nCivs sza szb
    civNames tNow |
	self _validatePrivilege ifFalse: [^nil].
	className _isOneByteString
		ifFalse: [(className _validateClass: CharacterCollection) ifFalse: [^nil]].
	self subclassesDisallowed
		ifTrue: [^self _error: #classErrSubclassDisallowed].
	anArrayOfClassInstVars
		ifNotNil:
			[anArrayOfClassInstVars _isArray
				ifFalse: [(anArrayOfClassInstVars _validateClass: Array) ifFalse: [^nil]]].
	aDictionary
		ifNotNil: [(aDictionary _validateClass: SymbolDictionary) ifFalse: [^nil]].
	fmtArr := self _validateOptions: optionsArray withFormat: theFormat newClassName: className .
	fmt := fmtArr at: 1.
	modifiableBool := fmtArr at: 2.
	(self instancesInvariant and: [(fmt bitAnd: 16r8) == 0])
		ifTrue: [^self _error: #classErrInvariantSuperClass].
	anArrayOfInstvarNames _isArray
		ifFalse: [(anArrayOfInstvarNames _validateClass: Array) ifFalse: [^nil]].
	ivNames := {}.
	1 to: anArrayOfInstvarNames size
		do: [:j | ivNames add: (anArrayOfInstvarNames at: j)].
	nCivs := anArrayOfClassInstVars size.
	civNames := anArrayOfClassInstVars.
	nCivs ~~ 0
		ifTrue:
			[| aSet |
			civNames := Array new: nCivs.
			aSet := IdentitySet new.
			1 to: nCivs
				do:
					[:k |
					| aName |
					aName := (anArrayOfClassInstVars at: k) asSymbol.
					self class _validateNewClassInstVar: aName.
					civNames at: k put: aName.
					aSet add: aName.
					aSet size < k
						ifTrue:
							[ImproperOperation
								signal: 'array of new class instanceVariables contains a duplicate '
										, aName printString]]].

	"Gs64 v3.0 , cvDict and poolDicts maybe nil from caller,
    and will be converted to nil if caller passed an empty Array."
	cvDict := self _makeClassVarDict: anArrayOfClassVars.

	"undo the compiler's canonicalization of empty arrays (fix bug 14103) "
	poolDicts := anArrayOfPoolDicts.
	(poolDicts _isArray and: [poolDicts size == 0]) ifTrue: [poolDicts := nil].
  self _validateNewClassName: className . "reject invalids before converting to Symbol"
	theName := className asSymbol.
	tNow := DateTime now.
	result := self
				_subclass: theName
				instVarNames: ivNames
				format: fmt
				classVars: cvDict
				poolDictionaries: poolDicts
				classInstanceVars: civNames.
	modifiableBool ifTrue: [result _subclasses: IdentitySet new].
	subclasses ifNotNil: [subclasses add: result].
	aDictionary 
		ifNotNil: [
			"Avoid permission errors for classes that have not changed --- Rowan bootstrap
				class defintions should not be changing the oop of the class --- upgrades? "
			result == (aDictionary at: theName ifAbsent: []) 
				ifFalse: [ aDictionary at: theName put: result ] ].
	"leave extraDict as nil"
	result _commentOrDescription: aDescription.
	theHist := aClassHistory.
	theHist ifNil: [theHist := ClassHistory new name: className].
	theHist notEmpty ifTrue: [result category: theHist current _classCategory].
	theHist add: result.
	result classHistory: theHist.
	result timeStamp: tNow  .
	result userId: System myUserProfile userId.
	sza := self class instSize + anArrayOfClassInstVars size.
	szb := result class instSize.
	sza == szb
		ifFalse:
			[InternalError
				signal: 'prim 233: inconsistent class instance variables, superClass+args=>'
						, sza asString , '  newClass=>'
						, szb asString].
	modifiableBool ifFalse: [result immediateInvariant].
	result copyVariables.
	self _clearCachedOrganizer.
  (fmtArr at: 3) ifTrue: [ 
    "not the final oop if a reserved oop class"
     self _logServer: 'created class ' , className, ' oop ', result asOop asString  .
  ].
	^result

]

{ #category : 'Private' }
Class >> _logServer: aString [
 "bootstrap implementation"
  GsFile gciLogServer: aString .
]

{ #category : 'Private' }
Class >> _validateInstancesPersistent [

"check that it is legal to make instances of the receiver
 persistent."

^ true

]

{ #category : 'Subclass Creation' }
Class >> subclass: aString instVarNames: anArrayOfInstvarNames classVars: anArrayOfClassVars classInstVars: anArrayOfClassInstVars poolDictionaries: anArrayOfPoolDicts inDictionary: aDictionary newVersionOf: oldClass description: aDescription options: optionsArray [
	"optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

	"final version defined in File4Rowan"

	^ self
		_subclass: aString
		instVarNames: anArrayOfInstvarNames
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		newVersionOf: oldClass
		description: aDescription
		options: optionsArray
]
