Extension { #name : 'ArgumentError' }

{ #category : 'Formatting' }
ArgumentError >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    gsDetails ifNotNil:[:det |
      (str := String new ) add: det asString .
      object ifNotNil:[:o|
        str add:', '; add: o  asString
      ] ifNil:[
        gsArgs ifNotNil:[:ga | (ga atOrNil: 1) ifNotNil:[:d | str add: d asString]]
      ]
    ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
ArgumentError >> initialize [
  gsNumber := ERR_ArgumentError.
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Instance initialization' }
ArgumentError >> name: aName [
  object := aName

]
