Extension { #name : 'ArgumentTypeError' }

{ #category : 'Instance initialization' }
ArgumentTypeError >> _legacyHandlerArgs [
  | arr |
  arr := { object . expectedClass . actualArg } .
  gsArgs ifNotNil:[:a |  arr addAll: a ].
  ^ arr

]

{ #category : 'Instance initialization' }
ArgumentTypeError >> args: anArray [
  anArray _isArray ifTrue:[ | sz |
    object := anArray atOrNil: 1 .
    expectedClass := anArray atOrNil: 2 .
    actualArg := anArray atOrNil: 3  .
    (sz := anArray size) > 3 ifTrue:[
      gsArgs := anArray copyFrom: 4 to: sz
    ].
  ]

]

{ #category : 'Formatting' }
ArgumentTypeError >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    gsDetails ifNotNil:[ :d |  "example use: attempt to modify invariant object"
      str := d asString copy .
      object ifNotNil:[:a | str add: ', ' ; add: a asString ].
    ] ifNil:[ | exp act |
      exp := expectedClass . act := actualArg .
      (exp ~~ nil or:[ act ~~ nil]) ifTrue:[
        str := String new .
        object ifNotNil:[:o | str add: 'for '; add: o asString ; add:'  '].
        exp ifNotNil:[ str add: 'expected a ' ; add: exp name ].
        act ifNotNil:[ str add:', arg is a '; add: act class name ].
      ].
    ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
ArgumentTypeError >> constrainedIv: aName expectedClass: aClass actualArg: anObject [
  gsNumber := 2107 .  "legacy error info"
  gsReason := #objErrConstraintViolation .
  object := aName .
  expectedClass := aClass "may be an array of Classes" .
  actualArg := anObject

]

{ #category : 'Instance initialization' }
ArgumentTypeError >> initialize [
  gsNumber := ERR_ArgumentTypeError.
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Instance initialization' }
ArgumentTypeError >> name: aName expectedClass: aClass actualArg: anObject [
  object := aName .
  expectedClass := aClass "may be an array of Classes" .
  actualArg := anObject

]
