Extension { #name : 'BitSet' }

{ #category : 'Instance creation' }
BitSet class >> new: numberOfBits [
  "allocated size is always a multiple of 4 bytes,
   all bits in the result are set to zero."

^ super new: ((numberOfBits + 31) // 32) * 4

]

{ #category : 'Accessing' }
BitSet >> at: offset [
"Return the specified bit, result is 0 or 1.
 offset is a zero-based SmallInteger,
 0 specifies the least significant bit.
 offset < 0 generates an error.
 0 is returned for any offset > allocated size. "

<primitive: 748>
offset _validateClass: SmallInteger.
offset < 0 ifTrue:[ offset _error: #errArgTooSmall args:{ 0 } ].
self _primitiveFailed: #at: args: { offset }

]

{ #category : 'Updating' }
BitSet >> at: offset put: aValue [

"offset is zero-based, 0 specifies the least significant bit.
 aValue must be 0 or 1 .
 Returns previous state of the specified bit. "

<primitive: 751>
offset _validateClass: SmallInteger.
offset < 0 ifTrue:[ offset _error: #errArgTooSmall args:{ 0 } ].
(aValue == 0 or:[ aValue == 1]) ifFalse:[
  aValue _error: #rtErrArgOutOfRange args:{ 0 . 1 } ].
self _primitiveFailed: #at:put: args: { offset . aValue }

]

{ #category : 'Updating' }
BitSet >> bitAnd: aBitSet [

"clear bits in the receiver which are not also set in the argument.
 aBitSet must be an instance of the class of the receiver.
 Returns receiver. "

<primitive: 752>
aBitSet _validateInstanceOf: self class .
self _primitiveFailed: #bitAnd: args: { aBitSet }

]

{ #category : 'Updating' }
BitSet >> bitInvert [
"Inverts the  bits of the receiver."

<primitive: 755>
self _primitiveFailed: #bitInvert

]

{ #category : 'Updating' }
BitSet >> bitOr: aBitSet [

"Set bits in the receiver that are set in the argument
 Grows receiver as needed.
 aBitSet must be an instance of the class of the receiver.
 Returns receiver. "

<primitive: 753>
aBitSet _validateInstanceOf: self class .
self _primitiveFailed: #bitOr: args: { aBitSet }

]

{ #category : 'Updating' }
BitSet >> bitXor: aBitSet [
"Sets receiver to be the exclusive-or of the receiver with argument.
 Grows receiver as needed.
 aBitSet must be an instance of the class of the receiver.
 Returns receiver."
<primitive: 754>
aBitSet _validateInstanceOf: self class .
self _primitiveFailed: #bitXor: args: { aBitSet }

]

{ #category : 'Updating' }
BitSet >> clear [
  "set all bits in receiver to zero, returns receiver.
   does not change allocated size of receiver."
<primitive: 750>
self _primitiveFailed: #clear

]

{ #category : 'Accessing' }
BitSet >> countBits [
"return the number of bits set in the receiver"

<primitive: 749>
self _primitiveFailed: #countBits

]

{ #category : 'Accessing' }
BitSet >> size [

"return the allocated size in bits"

^ super size * 8

]

{ #category : 'Updating' }
BitSet >> size: numberOfBits [

 "change the allocated size. allocated size is always a multiple of 4 bytes,
  rounded up from the specified size.
  If the new size is larger than current size,
   newly allocated bits will be set to zero."

super size: ((numberOfBits + 31) // 32) * 4

]
