Extension { #name : 'Breakpoint' }

{ #category : 'Instance initialization' }
Breakpoint >> initialize [
  gsNumber := ERR_Breakpoint.
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Instance initialization' }
Breakpoint >> resignalAs: anException [
  "not working yet."
  ^ super resignalAs: anException

]

{ #category : 'Instance initialization' }
Breakpoint >> resume [
  "Resume execution at the step point where this Breakpoint was signalled
   and attempt to execute the bytecode at that step point."

  ^ self resume: nil

]

{ #category : 'Instance initialization' }
Breakpoint >> resume: aValue [
  "Resume execution at the step point where this Breakpoint was signalled
   and attempt to execute the bytecode at that step point."

  ^ super resume: aValue

]

{ #category : 'Instance initialization' }
Breakpoint >> return [
  "Return from the on:do: which installed a handler for this Breakpoint.
   Set the current GsProcess' state so that the breakpoint is reenabled."

  GsProcess _current clearLastBreakpointHistory .
  ^ super return

]

{ #category : 'Instance initialization' }
Breakpoint >> return: aValue [
  "Return from the on:do: which installed a handler for this Breakpoint.
   Set the current GsProcess' state so that the breakpoint is reenabled."

  GsProcess _current clearLastBreakpointHistory .
  ^ super return: aValue

]
