Extension { #name : 'Class' }

{ #category : 'Filein Support' }
Class class >> _resolveReservedClass: reservedOop name: className [

  " returns an Array of size 2.
     result at:1 is already existing class or nil .
     result at: 2 is a String describing Globals modifications made"

  | oldCls result |
  result := Array new: 2 .
  result at: 2 put: String new .
  reservedOop ifNotNil:[ | oop |
    oop := reservedOop .
    oop _isOneByteString ifTrue:[ oop := Integer fromString: oop ].
    oldCls := Object _objectForOop: oop .
  ] ifNil:[
    oldCls := (System myUserProfile resolveSymbol: className asSymbol) ifNotNil:[:assoc | assoc value ]
  ].
  result at:1 put: oldCls .
  ^ result

]

{ #category : 'Private' }
Class >> __definition [
	"Returns a String.
	For insteractive use to show constraints in a class
  in an upgraded repository."

	^self _definitionInContext: System myUserProfile withConstraints: true

]

{ #category : 'Private' }
Class >> __makeVariant [

"Makes the receiver variant."

<primitive: 272>
self _primitiveFailed: #__makeVariant .
self _uncontinuableError

]

{ #category : 'Private' }
Class >> _addByteSwizzle: aSymbol toFormat: fmt newClassName: subClsName signed: isSigned [
 | swiz newFmt oldSwiz signedMask |
  "uses GC_BEHAV_byteSwizKind_shift"
  aSymbol == #'2byteWords' ifTrue:[ swiz := 1 ].
  aSymbol == #'4byteWords' ifTrue:[ swiz := 2 ].
  aSymbol == #'8byteWords' ifTrue:[ swiz := 3 ].
  aSymbol == #'signed2byteWords' ifTrue:[ swiz := 1 ].
  aSymbol == #'signed4byteWords' ifTrue:[ swiz := 2 ].
  aSymbol == #'signed8byteWords' ifTrue:[ swiz := 3 ].
  swiz ifNil:[ Error signal:'invalid argument ' , aSymbol].

  oldSwiz := (format bitShift: -31"GC_BEHAV_byteSwizKind_shift") bitAnd: 3 .
  oldSwiz > 0 ifTrue:[
    oldSwiz = swiz ifFalse:[
       subClsName _error: #classErrBadFormat
        with: ' option ', aSymbol printString,' incompatible with superclass'.
    ].
  ].
  newFmt := fmt bitOr: (swiz bitShift: 31"GC_BEHAV_byteSwizKind_shift" ) .
  signedMask := 1 bitShift: 33"GC_BEHAV_signedWords_shift" .
  isSigned ifTrue:[ newFmt := newFmt bitOr: signedMask ]
          ifFalse:[ newFmt := newFmt bitAnd: (signedMask bitInvert) ].
  ^ newFmt

]

{ #category : 'Private' }
Class >> _adjustClassVars: anArray [
  classVars ifNil:[
    1 to: anArray size do:[:j | self _addClassVar: (anArray at: j) value: nil ]
  ] ifNotNil:[
    | argSet existingSet toRemove toAdd assocs |
    existingSet := IdentitySet new .
    assocs := { } .
    argSet := IdentitySet withAll: anArray  .
    "GsDevKit and Seaside need to be able to override classVarNames for
     implementation of SharedPool ,
     so must use   self classVarNames    here."
    self classVarNames do: [:classVarName | | a |
      a := classVars associationAt: classVarName.
      assocs add: a . existingSet add: a key ].
    toRemove := existingSet - argSet  .
    classHistory size > 1 ifTrue:[  | cvd | "create a new dictionary"
      cvd := SymbolDictionary new objectSecurityPolicy: classVars objectSecurityPolicy ; yourself.
      assocs do:[:a | (toRemove includes: a key) ifFalse:[ cvd addAssociation: a ]].
      self _setClassVars: cvd old: classVars .
    ] ifFalse:[
      toRemove do:[ :aKey | self removeClassVarName: aKey ].
    ].
    toAdd := argSet - existingSet .
    toAdd do:[ :aKey | self _addClassVar: aKey value: nil ].
  ].

]

{ #category : 'Private' }
Class >> _adjustOptions: opts formatArr: fmtArray [
  | fmt newFmt modifiableBool fmtToStore |
  fmt := format .
  fmtToStore := fmt .
  newFmt := fmtArray at: 1 .
  modifiableBool := fmtArray at: 2 .
  ((fmt bitAnd: 16r20) ~~ 0 and:[ (newFmt bitAnd: 16r20) == 0 ]) ifTrue:[
     "clear subclassesDisallowed bit."
     fmtToStore := fmtToStore bitAnd: 16r20 bitInvert .
  ].
  ((fmt bitAnd: 16r800) == 0 and:[ (newFmt bitAnd: 16r800) ~~ 0 ]) ifTrue:[
    "set instancesNonPersistent bit"
    fmtToStore := fmtToStore bitOr: 16r800 .
  ].
  (fmt bitAnd: 16r400) ~~ (newFmt bitAnd: 16r400) ifTrue:[
     "change state of traverseByCallback"
     fmtToStore := (fmtToStore bitAnd:( 16r400 bitInvert)) bitOr:( newFmt bitAnd: 16r400) .
  ].
  (fmt bitAnd: 16r200) ~~ (newFmt bitAnd: 16r200) ifTrue:[
     "change state of disallowGciStore"
     fmtToStore := (fmtToStore bitAnd:( 16r200 bitInvert)) bitOr:( newFmt bitAnd: 16r200) .
  ].
  (fmt bitAnd: 16r2000) ~~ (newFmt bitAnd: 16r2000) ifTrue:[
     "change state of selfCanBeSpecial"
     fmtToStore := (fmtToStore bitAnd:( 16r2000 bitInvert)) bitOr:( newFmt bitAnd: 16r2000) .
  ].
  fmtToStore ~~ fmt ifTrue:[
		 self _unsafeAt: 2 "offset of format" put: fmtToStore .
		 (fmtArray at: 3) ifTrue:[ "logBool"
				self _logServer: 'modified format of class ' , self name,' to ', fmtToStore asString .
		 ].
  ].
  "clear modifiable"
  (self isModifiable and:[ modifiableBool == false ]) ifTrue:[
     self immediateInvariant .
  ].

]

{ #category : 'Private' }
Class >> _beVariantWhile: aBlock [

"Executes the given block while the receiver is in a variant (modifiable) form.
 The block should not contain a return or the receiver will be left in a
 variant state.

 Great caution should be exercised in using this method as it allows
 modification of classes in uncontrolled ways that can lead to corrupted class
 objects."

self _validatePrivilege ifTrue:[
  | was |
  was := self isInvariant.
  was ifTrue: [ self __makeVariant; _refreshClassCache: false  ].
  [
    [
      aBlock value
    ] onException: Error do:[:ex |
      was ifTrue: [
	super immediateInvariant; _refreshClassCache: false.
	was := false
      ].
      ex outer .
    ]
  ] ensure:[
    was ifTrue:[ super immediateInvariant; _refreshClassCache: false ].
  ]
].

]

{ #category : 'Browser Methods' }
Class >> _bytesPerWord [
  "Returns a SmallInteger, the number of bytes per word in instances of the receiver.
   Returns 0 for special format, 8 for oop or nsc format,
   and 1, 2, 4 or 8 for various byte format classes."

  self isBytes ifTrue:[ | swiz |
    swiz := (format bitShift: -31"GC_BEHAV_byteSwizKind_shift") bitAnd: 3"GC_BEHAV_byteSwizKind_mask".
    ^ 1 bitShift: swiz .
  ].
  self _isSpecial ifTrue:[ ^ 0 ].
  ^ 8

]

{ #category : 'Private' }
Class >> _category: newCategory [
"Sets the classCategory variable of the receiver.
 The argument should be a kind of CharacterCollection or nil."
"Implemenation shared by base image and Rowan"

newCategory ifNil:[
	classCategory := nil.
	^ self ].

(newCategory _validateClass: CharacterCollection ) ifFalse:[ ^ nil ].

classCategory := newCategory asString

]

{ #category : 'Category' }
Class >> _classCategory [

"Returns the classCategory of the receiver."

^ classCategory

]

{ #category : 'Subclass Creation' }
Class >> _classDefiningClassVar: aSymbol [

"Returns the receiver or the superclass that defines a class variable with
 name aSymbol, otherwise returns nil."

| aClass |
aClass := self .
[
  aClass _classVars ifNotNil:[ :cvs |
    ( cvs associationAt: aSymbol otherwise: nil ) ifNotNil:[
      ^ aClass
    ].
  ].
  aClass := aClass superClass .
  aClass == nil
] untilTrue .
^ nil

]

{ #category : 'Class Membership' }
Class >> _classHistoryIncludesIdentical: aClass [

 ^ (classHistory indexOfIdentical: aClass) ~~ 0

]

{ #category : 'Accessing' }
Class >> _classInstVars [

"Returns an Array of the receiver's class instance variables."

| civs |

civs := self class allInstVarNames.
civs removeFrom: 1 to: (self class superClass instSize).
^civs

]

{ #category : 'Private' }
Class >> _classNamed: aString inDictionary: aDictionary [
  | v sym |
  aDictionary ifNil:[ ^ nil ].
  (sym := Symbol _existingWithAll: aString) ifNil:[ ^ nil ].
  v := aDictionary at: sym otherwise: nil .
  ^ (v isKindOf: Class) ifTrue:[ v ] ifFalse:[ nil ].

]

{ #category : 'Private' }
Class >> _classVarsChangableTo: anArray [
  ^ self _classVarsChangableTo: anArray log: false
]

{ #category : 'Private' }
Class >> _classVarsChangableTo: anArray log: logBool [
  | ok |
  ok := true .
  anArray ifNotNil:[ | argSet |
    anArray _isArray ifFalse:[
      (anArray _validateClass: Array) ifFalse:[ ^ nil ].
    ].
    argSet := IdentitySet new .
    1 to: anArray size do: [:index| | aVarName aSym definingClass |
      aVarName := anArray at: index .
      (aVarName _isOneByteString or:[ aVarName _validateClass: CharacterCollection]) ifTrue:[
	aSym := aVarName asSymbol .
	aSym validateIsIdentifier "fix bug 9666" .
	definingClass := self _classDefiningClassVar: aSym .  "fix bug 10480"
	(definingClass ~~ nil and:[ definingClass ~~ self]) ifTrue:[  
           ok := false .
           logBool ifTrue:[ self _logServer: aSym , ' defined in ', definingClass name ].
        ].
        argSet add: aSym .  "exists or ok to add"
        anArray at: index put: aSym .
      ].
    ].
    classVars ifNotNil:[ :cvs | | toRemove |
      toRemove := cvs keys - argSet  .
      toRemove do:[:aKey |
        (classVars associationAt: aKey) isInvariant ifTrue:[ 
          ok := false .
          logBool ifTrue:[ self _logServer: aKey , ' an invariant class variable to remove '].
        ]
      ].
    ].
  ].
  ^ true
]

{ #category : 'Private' }
Class >> _commentOrDescription: newComment [
	"For backward compatibility, accept a GsClassDocumentation (although this is deprecated)
	or a string. Copy any GsClassDocumentation to avoid bug 41763."
newComment
	ifNotNil:
		[(newComment isKindOf: GsClassDocumentation)
			ifTrue:
				[| newDesc |
				newDesc := newComment copy.
				newDesc itsClass: self.
				self _description: newDesc]
			ifFalse: [self comment: newComment]].

]

{ #category : 'Private' }
Class >> _definition [
	"Returns a String. Sent by topaz "

	^self _definitionInContext: System myUserProfile

]

{ #category : 'Browser Methods' }
Class >> _definitionInContext: aUserProfile [

^ self _definitionInContext: aUserProfile withConstraints: false

]

{ #category : 'Browser Methods' }
Class >> _definitionInContext: aUserProfile withConstraints: withConstraintsBool [

"Returns a description of the receiver using object names taken from the given
 UserProfile."

| result newByteSubclass anArray lfsp
  firstElement poolDicts civs supercls aSize iVs |
supercls := self superClass .
result := String new.
result addAll: (supercls == nil ifTrue: ['nil'] ifFalse: [supercls name]).
newByteSubclass := false.
(lfsp := Character lf asString) addAll: '  ' .

(self isBytes and: [supercls isBytes not]) ifTrue: [
  result addAll: ' byteSubclass: '''; addAll: name; addLast: $'.
  newByteSubclass := true.
] ifFalse: [
  (self isIndexable and:[ supercls == nil or:[ supercls isIndexable not]]) ifTrue: [
    result addAll: ' indexableSubclass: '''; addAll: name; addLast: $'.
  ] ifFalse: [
    result addAll: ' subclass: '''; addAll: name; addLast: $'.
  ]
].
" instVarNames: #( <list of strings> ) "
iVs := self instVarNames .
(newByteSubclass not or:[ iVs size > 0 ]) ifTrue: [
  result addAll: lfsp;
    addAll: 'instVarNames: #(';
    addAll: (self _instVarNamesWithSeparator: (lfsp , '                 '));
    add: $).
].
" classVars: #( <list of strings> ) "
result addAll: lfsp; addLast: 'classVars: #('.
self _sortedClassVarNames accompaniedBy: result do: [:res :aKey |
  res addLast: $  .
  (aKey includesValue: $')
    ifTrue:[ res addAll: aKey _asSource ]
    ifFalse:[ res addAll: aKey ].
  ].
result addLast: $).

" classInstVars: #( <list of strings> ) "
result addAll: lfsp; addLast: 'classInstVars: #('.
civs := self class allInstVarNames.
civs removeFrom: 1 to: (self class superClass instSize).
civs accompaniedBy: result do: [:res :civName |
  res addLast: $  .
  (civName includesValue: $')
    ifTrue:[ res addAll: civName _asSource ]
    ifFalse:[ res addAll: civName ].
].
result addLast: $).

" poolDictionaries: { <list of dictionary names> } "
result addAll: lfsp; addAll: 'poolDictionaries: ' .
(poolDicts := self sharedPools) size > 0 ifTrue:[
  result addAll: '{ ' .
  firstElement := true.
  poolDicts do: [:each |
    firstElement ifFalse: [ result add: ' . '].
    anArray := aUserProfile dictionariesAndSymbolsOf: each.
    (aSize := anArray size) == 0 ifTrue:[ result add: '"(not named)"' ]
      ifFalse:[ aSize = 1 ifTrue:[ result add:((anArray at:1) at: 2) ]
                      ifFalse:[ result add: '"(multiple names)"' ]].
    firstElement := false.
  ].
  result add: ' }' .
] ifFalse:[
  result add: '#()'
].

" inDictionary: <name of containing dictionary> "
result addAll: lfsp; addAll: 'inDictionary: ' ;
   addAll: (self _dictionaryNameForFileout: aUserProfile) .

withConstraintsBool ifTrue:[
 (newByteSubclass not and: [self _hasConstraints]) ifTrue: [
    result add: self _definitionOfConstraints; lf
  ].
].

"options:"
result add:  lfsp; add: self _optionsStringForDefinition .
result add: Character lf .
^result

]

{ #category : 'Browser Methods' }
Class >> _definitionOfConstraints [

" Returns a string of the form
     constraints: { <Array of instance-variable-symbol/class-name pairs> }
 or
     constraints: <class name>

 As of GemStone 64bit v3.4, constraints are no longer implemented.
 This method is provided for examining classes in repositories upgraded from
 an older version."

| result  aConstraint firstElement |
result := String new.
result lf; add: '  constraints: '.
( constraints isKindOf: Array ) ifTrue: [
    result addAll: '{ '.
    firstElement := true.
    1 to: self instSize do: [ :x |
      aConstraint := constraints atOrNil: x .
      ((aConstraint ~~ nil _and: [aConstraint ~~ Object])
          _and:[ superClass == nil
            _or:[ (superClass _namedIvConstraintAt: x) ~~ aConstraint ]] )
      ifTrue: [
        " if not the first constraint, prefix with a period to separate
          from the last constraint "
        firstElement ifFalse: [
          result add: ' . '; lf; add: '                '
        ]
        ifTrue: [
          firstElement := false
        ].
        result add: '{ #'; add: (instVarNames at: x) ;
              add: ' . '; add: aConstraint name; addLast: $} .
      ]
    ].
    aConstraint:= self _varyingConstraint .
    ( (aConstraint ~~ Object) _and:
        [(superClass _varyingConstraint) ~~ aConstraint] )
    ifTrue:[
      firstElement ifFalse: [
          result add: ' . '; lf; add: '                '
      ]
      ifTrue: [
        firstElement := false
      ].
      result add: '   "the elements"  '; add: aConstraint name
    ].
    result add: ' }'.
  ]
  ifFalse: [
    constraints class class == Metaclass3 ifTrue: [
      result add: constraints name.
    ]
    ifFalse: [
      result add: ' nil'
    ].
  ].

^result

]

{ #category : 'Private' }
Class >> _description [
	"Returns the description of this class.
	Deprecated as of GS/64 3.1: subsumed by the new #comment field."

	self deprecated: 'Class>>_description deprecated v3.1. Replaced by comment'.
	^self _extraDictAt: #description

]

{ #category : 'Private' }
Class >> _description: aDescription [
	"Update the description of this Class.  Returns the argument.
 As of GS/64 3.1, this is deprecated in favor of #comment:"

	self deprecated: 'Deprecated as of GS/64 3.1'.
	self _extraDictAt: #description put: aDescription.
	^aDescription

]

{ #category : 'Browser Methods' }
Class >> _dictionaryNameForFileout: aUserProfile [
  | anArray |
  anArray := aUserProfile dictionariesAndSymbolsOf: self.
  (anArray size) == 0 ifTrue: [ | hist j |
    hist := self classHistory .
    anArray := nil .
    j := hist size .
    [ j >= 1 ] whileTrue:[
      anArray := aUserProfile dictionariesAndSymbolsOf: (hist at: j) .
      anArray size ~~ 0 ifTrue:[ j := 0"exit loop" ] .
      j := j - 1 .
    ]
  ].
  (anArray size) ~~ 0 ifTrue:[
    anArray := aUserProfile dictionariesAndSymbolsOf: ((anArray at: 1) at: 1).
    anArray size == 0 ifTrue:[
      ^ '(dictionary not in your dictionaries)'
    ] ifFalse: [ | dName |
      (dName := (anArray at: 1) at: 2) isValidIdentifier ifTrue: [
        ^ dName
      ] ifFalse: [  "this code moved from sessionmethods.topaz to here for v3.0"
        ^ ( '(GsSession currentSession symbolList objectNamed: ' , dName printString )
	       add: $) ; yourself .
      ]
    ]
  ].
  ^ 'UserGlobals' .
]

{ #category : 'Private' }
Class >> _equivalentSubclass: oldClass
	superCls: actualSelf
	name: aString
	newOpts: optionsArray
	newFormat: theFormat
	newInstVars: anArrayOfInstvarNames
	newClassInstVars: anArrayOfClassInstVars
	newPools: anArrayOfPoolDicts
	newClassVars: anArrayOfClassVars
	inDict: aDictionary
	isKernel: isKernelBool [

 "oldClass is equivalent to the subclass that would be created using
  the other arguments if:
     instVar names match exactly ,
     and class instVar names match exactly ,
     and the classVars in oldClass can be modified to add/remove Associations
        to match anArrayOfClassVars ,
     and pool dictionaries match exactly

  With respect to options and format, oldClass is equivalent if
    The state of format bits dbTransient, instancesInvariant match exactly ,
    and subclassesDisallowed cannot be set in the new subclass if it not set in oldClass ,
    and modifiable  cannot be set if it is not set in oldClass  ,
    and (SELF_CAN_BE_SPECIAL, NSC_DUPLICATES, INDEXABLE, IMPLEMENTATION, NO_STRUCT_UPDATE bits)
        of the formats must match exactly.

  If all other equivalence tests pass, the following changes to oldClass may be
  made to match the arguments and avoid creating a new subclass:
    instancesNonPersistent bit may be set (but not cleared) in the format of the oldClass
    subclassesDisallowed bit may be cleared (but not set) in format of oldClass
    traverseByCallback bit may be set or cleared in format of oldClass
    oldClass may be changed from modifiable to not modifiable (by sending immediateInvariant)
    classVars may be added to oldClass
    classVars having modifiable Associations may be removed from oldClass
"

	| oldOk fmtArr nam supr opts ivs civs poolds cvars cvarsArray logBool oldNam |
	fmtArr := self _validateOptions: optionsArray withFormat: theFormat newClassName: aString .
  logBool := fmtArr at: 3 .
	(oldClass isKindOf: Class) ifFalse: [oldClass _validateClass: Class].
	nam := (oldNam := oldClass name) asString = aString asString.
  nam ifFalse:[ | oldOop |
    oldOop := oldClass asOop .
    (oldOop <= 165121"OOP_CLASS_Special56bit15" and:[ oldOop >= 161281"OOP_CLASS_Special56bit0"])
      ifTrue:[ nam := true ].
  ].
	supr := oldClass superClass == actualSelf.
	opts := oldClass _optionsChangableTo: fmtArr.
	ivs := oldClass _instVarsEqual: anArrayOfInstvarNames.
	civs := oldClass class _instVarsEqual: anArrayOfClassInstVars.
	poolds := oldClass _poolDictsEqual: anArrayOfPoolDicts.
	cvars := oldClass
				_classVarsChangableTo: (cvarsArray := anArrayOfClassVars copy) log: logBool .
	oldOk := nam
				and: [supr and: [(opts==true) and: [ivs and: [civs and: [poolds and: [cvars]]]]]].
	oldOk ifTrue: [| oldVal newName |
			aDictionary ifNotNil: [
				newName := aString asSymbol.
				oldVal := aDictionary at: newName otherwise: nil.
        "allow nil as a value in aDictionary to satisfy forward refs during loading"
        (oldVal ~~ nil and:[ oldVal ~~ oldClass ]) ifTrue:[
             ImproperOperation
							signal: 'no new subclass needed, but aDictionary at: oldClass name ~~ oldClass'.
						^false
         ]
      ].
			oldClass _adjustOptions: optionsArray formatArr: fmtArr.
			oldClass _adjustClassVars: cvarsArray.
			logBool ifTrue:[self _logServer: 'class ' , aString , ' equivalent to requested class'].
			^true
    ] ifFalse:[ 
       logBool ifTrue:[
         self _logServer: '_equivalentSubclass false, nam:' , nam asString ,
                ' supr:' , supr asString , ' opts:' , opts asString ,
                ' ivs:' , ivs asString , ' civs:' , civs asString ,
                ' poolds:' , poolds asString , ' cvars:' , cvars asString]
    ].
	^false

]

{ #category : 'Private' }
Class >> _extraDictAt: key [

  "Return value for key in extraDict.
   Return nil if extraDict or the key are not present. "

  ^ extraDict
      ifNil: [ nil ]
      ifNotNil: [ :ed | ed at: key otherwise: nil ]

]

{ #category : 'Private' }
Class >> _extraDictAt: key put: value [

  "Add value for key to extraDict.  Create extraDict if not present. "

  extraDict ifNil: [
    extraDict := SymbolDictionary new.
    extraDict objectSecurityPolicy: self objectSecurityPolicy ].

  ^ extraDict at: key put: value

]

{ #category : 'Private' }
Class >> _extraDictRemoveKey: key [

  " Remove key/value from extraDict.
    Dont care if extraDict or the key itself are not present. "

  extraDict ifNotNil:[ :ed | ed removeKey: key ifAbsent: [] ].

]

{ #category : 'Filein Support' }
Class >> _finishNewReservedClass: newClass old: oldCls resolv: resolveRes [
  oldCls == nil ifTrue:[
    (((newClass class) superClass) == (self class)) ifFalse:[
       Error signal: 'Inconsistent class hierarchy'
    ].
     GsFile gciLogServer:'created class (reserved oop ', newClass asOop asString , ') : '  , newClass definition 
  ] ifFalse:[
     GsFile gciLogServer: 'class ', oldCls name asString, ' already exists '.
  ].

]

{ #category : 'Private' }
Class >> _gbsTraversalCallback [

"Private.  When GemBuilder Smalltalk traverses a Class, this method
 is called to return a description of the class."

^self definition

]

{ #category : 'Browser Methods' }
Class >> _hasConstraints [

"Determine if there are any constraints on any instance variable; return true if any
exist, false otherwise.
As of GemStone 64bit v3.4, constraints are no longer implemented.
This method is provided for examining classes in repositories upgraded from
an older version."

| aConstraint constrs |
constrs := constraints .
 constrs _isArray  ifTrue: [
    1 to: self instSize do: [:x |
      aConstraint := constrs atOrNil: x .
      ((aConstraint ~~ nil _and: [aConstraint ~~ Object])
          _and: [ superClass == nil
          _or: [ (superClass _namedIvConstraintAt: x) ~~ aConstraint ]] )
                   ifTrue: [^true]
        ].
    aConstraint := self _varyingConstraint .
    ( (aConstraint ~~ Object) _and:
        [(superClass _varyingConstraint) ~~ aConstraint] )
    ifTrue: [^true].
  ] ifFalse: [
    constraints class class == Metaclass3 ifTrue: [^true]
  ].

^false

]

{ #category : 'Private' }
Class >> _insertCivAt: offset [

"insert space for a new class instance variable at the specified offset.
 Each call will cause a markSweep GC of the VM temporary object memory."

<primitive: 486>

self _primitiveFailed: #_insertCivAt: args: { offset }.
self _uncontinuableError

]

{ #category : 'Repository Conversion' }
Class >> _makeClassObsolete: aSymbolDictionary [
"remove association from <aSymbolDictionary>
 rename receiver
 if assoc is invariant:
   create new association for obsolete class
 if not:
   reuse the original association for obsolete class
"

 | newName assoc |
 assoc := aSymbolDictionary associationAt: self name.
 newName := ('Obsolete', self name asString) asSymbol.
 aSymbolDictionary removeAssociation: assoc.
 self _unsafeAt: 11 put: newName.
 assoc isInvariant
   ifTrue: [ aSymbolDictionary at: self name asSymbol put: self ]
   ifFalse: [
      assoc key: self name asSymbol.
      aSymbolDictionary addAssociation: assoc ].
 self removeAllMethods.
 self class removeAllMethods.

]

{ #category : 'Modifying Classes' }
Class >> _makeInstancesDbTransient: aBool [

<protected>
self _validatePrivilege ifTrue:[
  aBool ifTrue:[
    (self isPointers and:[ self isIndexable not]) ifFalse:[
      ^ ImproperOperation new details:'Only non-indexable pointer objects may be DbTransient';
           object: self ; signal
    ].
    format := format bitOr: 16r1000 .
  ] ifFalse:[
    format := format bitAnd: (16r1000 bitInvert)
  ].
  self _refreshClassCache: false .
].

]

{ #category : 'Private' }
Class >> _makeInstancesNonPersistent [

<protected>
self _validatePrivilege ifTrue:[
  format := format bitOr: 16r800 .
  self _refreshClassCache: false .
].

]

{ #category : 'Private' }
Class >> _makeInstancesPersistent [

<protected>
self _validatePrivilege ifTrue:[
  self _validateInstancesPersistent ifTrue:[
    self superClass instancesNonPersistent ifTrue:[
      ^ ImproperOperation new reason: #rtErrSuperclassIsNP;
	details: 'superclass is non-persistent';
	object: self ; signal .
    ]
  ]
].
format := (format bitOr: 16r800 ) bitXor: 16r800 .
self _refreshClassCache: false .

]

{ #category : 'Browser Methods' }
Class >> _modifiableDefinitionInDictionary: dict named: dictName [

"Returns a description of the receiver that is modifiable,
 and that places the class in the given dictionary name.
 Byte classes will not use the modifiable form of class definition as
 they have no information that can be modified."

  | result newByteSubclass lfsp firstElement poolDicts cat nm resolver supercls |

  supercls := self superClass .
  nm := supercls == nil ifTrue: [ 'nil' ] ifFalse: [
      dict keyAtValue: supercls ifAbsent: [ supercls name ]
      ].
  (result := String new) add: $( ; addAll: nm .
  newByteSubclass := false.
  lfsp := (Character lf asString) addAll: '  '.

  (self isBytes and: [supercls isBytes not]) ifTrue:
    [
    result addAll: ' byteSubclass: '.
    newByteSubclass := true.
    ]
  ifFalse:
    [
    (self isIndexable and: [supercls isIndexable not]) ifTrue:
      [ result addAll: ' indexableSubclass: ' ]
    ifFalse:
      [ result addAll: ' subclass: ' ].
    ].

  nm := dict keyAtValue: self ifAbsent: [ self name ].
  result addAll: (String withAll: nm) quoted.

 " instVarNames: #( <list of strings> ) "
  newByteSubclass ifFalse: [
    result addAll: lfsp;
      addAll: 'instVarNames: #(';
      addAll: (self _instVarNamesWithSeparator: (lfsp , '                 '));
      add: $).
  ].

  " classVars: #( <list of strings> ) "

  result addAll: lfsp; addLast: 'classVars: #('.
  self _sortedClassVarNames accompaniedBy: result do: [:res :aKey |
    res addLast: $  .
    (aKey includesValue: $')
      ifTrue:[ res addAll: aKey _asSource ]
      ifFalse:[ res addAll: aKey ].
    ].

  result addLast: $).

  " classInstVars: #( <list of strings> ) "

  result addAll: lfsp; addLast: 'classInstVars: #('.
  self _classInstVars accompaniedBy: result do:[ :res :civName |
    res addLast: $  .
    (civName includesValue: $')
      ifTrue:[ res addAll: civName _asSource ]
      ifFalse:[ res addAll: civName ].
    ].
  result addLast: $).

  " poolDictionaries: { <list of dictionary names> } "

  result addAll: lfsp; addAll: 'poolDictionaries: '.
  (poolDicts := self sharedPools ) size > 0 ifTrue:[
    firstElement := true.
    resolver := System myUserProfile .
    result add: ' {' .
    poolDicts do: [:each | | anArray aSize |
      firstElement ifFalse: [ result add: ' . '].
      anArray := resolver dictionariesAndSymbolsOf: each.
      (aSize := anArray size) == 0 ifTrue:[ result add: '"(not named)"' ]
        ifFalse:[ aSize = 1 ifTrue:[ result add:((anArray at:1) at: 2) ]
                      ifFalse:[ result add: '"(multiple names)"' ]].
      firstElement := false.
    ].
    result add: ' }' .
  ] ifFalse:[
    result add: '#()'
  ].

  " inDictionary: <name of containing dictionary> "
  result addAll: lfsp; addAll: 'inDictionary: '; addAll: dictName.

  "constraints omitted"

  "options:"
  result add:  lfsp; add: self _optionsStringForDefinition .

  result add: $) .
  (cat := classCategory ) ifNotNil:[
    result addAll: ' category: '; addAll: (String withAll: cat) quoted
  ].
  result addLast: Character lf .
  ^result

]

{ #category : 'Filein Support' }
Class >> _newKernelByteSubclass: clsName
classVars: classVarArg
poolDictionaries: poolDicts
inDictionary: aDict
options: options
reservedOop: reservedOopNum [

	"Old (pre-GS64) behavior:
   Created a new class always, to allow upgrade
   scripts to change the definition of a kernel class.  Preserved
   the identity of both the class and the metaClass if the class
   already existed.

 New (Gemstone64) behavior:
   Does not allow redefinition of a
   class in the upgrade case.  Only create class if it does not exist
   by the given name in globals.  The _unsafeSet11Oop primitive does
   not currently allow changing the identity of an already existing
   object.

 Returns the new or existing class .

 If reservedOopNum is ~~ nil, reservedOopNum must be a positive Integer
 that is a legal gs64v1.1 objectId and the methods   Object >> _unsafeSetOop:
 and   Object(C) >> _objectForOop:   must be installed."

  self ifNil:[ Error signal:'superclass not yet defined'].
	self _validatePrivilege ifTrue:
			[| newClass className oldCls resolveRes dictNames result |
      dictNames := #( ObsoleteClasses GsCompilerClasses GemStone_Legacy_Streams).
			(aDict == Globals or:[ dictNames includesIdentical: aDict name])
				ifFalse:[ aDict _error: #rtErrInvalidArgument.  ^nil].
			className := Symbol withAll: clsName.
			resolveRes := Class _resolveReservedClass: reservedOopNum name: className.
			oldCls := resolveRes at: 1.
			oldCls ifNil:[
        GsObjectSecurityPolicy setCurrent: Object objectSecurityPolicy while:[
           newClass := self
										byteSubclass: className
										classVars: classVarArg
										classInstVars: #()
										poolDictionaries: poolDicts
										inDictionary: aDict
										newVersionOf: nil
										description: nil
										options: options.
							reservedOopNum ifNotNil:[
								newClass := newClass _unsafeSetOop: reservedOopNum .
							  (aDict associationAt: className) immediateInvariant ].
         ].
         result := newClass .
       ] ifNotNil:[ | fmt |
					fmt := (format bitAnd: 16r3 bitInvert) bitOr: 16r1 + 16r4.
					(self
						_equivalentSubclass: oldCls
						superCls: self
						name: className
						newOpts: ((options copy)
								add: #logCreation;
								yourself)
						newFormat: fmt
						newInstVars: #()
						newClassInstVars: #()
						newPools: poolDicts
						newClassVars: classVarArg
						inDict: aDict
						isKernel: true)
							ifFalse: [ArgumentError signal: 'existing class not equivalent to arguments'].
          result := oldCls .
      ].
			self _finishNewReservedClass: newClass old: oldCls resolv: resolveRes .
      ^ result
  ].
	^ nil

]

{ #category : 'Filein Support' }
Class >> _newKernelIndexableSubclass: clsName
instVarNames: ivArg
classVars: classVarArg
classInstVars: classInstVarArg
poolDictionaries: poolDicts
inDictionary: aDict
options: options
reservedOop: reservedOopNum [

	"Used by filein.
Old (pre-GS64) behavior:
   Created a new class always, to allow upgrade
   scripts to change the definition of a kernel class.  Perserved
   the identity of both the class and the metaClass if the class
   already existed.
 New (Gemstone64) behavior:
   Does not allow redefinition of a
   class in the upgrade case.  Only create class if it does not exist
   by the given name in globals.  The _unsafeSet11Oop primitive does
   not currently allow changing the identity of an already existing
   object.

 Returns the new class, the old class or nil

 If reservedOopNum is ~~ nil, reservedOopNum must be a positive Integer
 that is a legal gs64v1.1 objectId and the methods   Object >> _unsafeSet11Oop:
 and   Object(C) >> _objectForOop:   must be installed."

  self ifNil:[ Error signal:'superclass not yet defined'].
	self _validatePrivilege
		ifTrue:
			[| newClass className oldCls resolveRes fmt dictNames result |
      dictNames := #( ObsoleteClasses GsCompilerClasses GemStone_Legacy_Streams).
			(aDict == Globals or:[ dictNames includesIdentical: aDict name])
					ifFalse:
					[aDict _error: #rtErrInvalidArgument.
					^false].
			self isBytes
				ifTrue:
					[^clsName _error: #classErrBadFormat
						with: 'cannot create indexable subclass of byte class'].
			self isNsc
				ifTrue:
					[^clsName _error: #classErrBadFormat
						with: 'cannot create indexable subclass of Nsc class'].
			fmt := format bitOr: 16r4.	"add indexable bit"
			className := Symbol withAll: clsName.
			resolveRes := Class _resolveReservedClass: reservedOopNum name: className.
			oldCls := resolveRes at: 1.
			oldCls ifNil:[
          aDict at: className put: nil.
					GsObjectSecurityPolicy setCurrent: Object objectSecurityPolicy while:[
            newClass := self
										_subclass: className
										instVarNames: ivArg
										format: fmt
										classVars: classVarArg
										classInstVars: classInstVarArg
										poolDictionaries: poolDicts
										inDictionary: aDict
										inClassHistory: nil
										description: nil
										options: options.
							reservedOopNum ifNotNil:[
								newClass := newClass _unsafeSetOop: reservedOopNum .
							  (aDict associationAt: className) immediateInvariant ].
           ].
           result := newClass .
         ] ifNotNil: [(self
						_equivalentSubclass: oldCls
						superCls: self
						name: className
						newOpts: ((options copy)
								add: #logCreation;
								yourself)
						newFormat: fmt
						newInstVars: ivArg
						newClassInstVars: classInstVarArg
						newPools: poolDicts
						newClassVars: classVarArg
						inDict: aDict
						isKernel: true)
							ifFalse: [ArgumentError signal: 'existing class not equivalent to arguments'].
           result := oldCls
         ].
			self _finishNewReservedClass: newClass old: oldCls resolv: resolveRes .
      ^ result
      ].
	^false

]

{ #category : 'Filein Support' }
Class >> _newKernelSubclass: clsName
instVarNames: ivArg
classVars: classVarArg
classInstVars: anArrayOfClassInstVars
poolDictionaries: poolDicts
inDictionary: aDict
options: options
reservedOop: reservedOopNum [

^ self _newKernelSubclass: clsName
    subclassOf: self
    instVarNames: ivArg
    classVars: classVarArg
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: poolDicts
    inDictionary: aDict
    options: options
    reservedOop: reservedOopNum

]

{ #category : 'Filein Support' }
Class >> _newKernelSubclass: clsName
subclassOf: actualSelf
instVarNames: ivArg
classVars: classVarArg
classInstVars: anArrayOfClassInstVars
poolDictionaries: poolDicts
inDictionary: aDict
options: options
reservedOop: reservedOopNum [

	"Old (pre-GS64) behavior:
   Created a new class always, to allow upgrade
   scripts to change the definition of a kernel class.  Preserved
   the identity of both the class and the metaClass if the class
   already existed.

 New (Gemstone64) behavior:
   Does not allow redefinition of a
   class in the upgrade case.  Only create class if it does not exist
   by the given name in globals.  The _unsafeSet11Oop primitive does
   not currently allow changing the identity of an already existing
   object.

 Returns a String, either the definition of the new class or a
 message that the class already exists.

 If reservedOopNum is ~~ nil, reservedOopNum must be a positive Integer
 that is a legal gs64v1.1 objectId and the methods   Object >> _unsafeSet11Oop:
 and   Object(C) >> _objectForOop:   must be installed."
  self ifNil:[ Error signal:'superclass not yet defined'].
	self _validatePrivilege ifTrue:[
     | newClass className oldCls resolveRes dictNames result |
      dictNames := #( ObsoleteClasses GsCompilerClasses GemStone_Legacy_Streams).
			(aDict == Globals or:[ dictNames includesIdentical: aDict name])
				ifFalse:
					[aDict _error: #rtErrInvalidArgument.
					^false].
			className := Symbol withAll: clsName.
			resolveRes := Class _resolveReservedClass: reservedOopNum name: className.
			oldCls := resolveRes at: 1.
			oldCls ifNil:[
          aDict at: className put: nil.
					GsObjectSecurityPolicy setCurrent: Object objectSecurityPolicy while:[
            newClass := self
										_subclass: className
										instVarNames: ivArg
										format: format
										classVars: classVarArg
										classInstVars: anArrayOfClassInstVars
										poolDictionaries: poolDicts
										inDictionary: aDict
										inClassHistory: nil
										description: nil
										options: options.
							reservedOopNum ifNotNil:[ "change object identifier"
								newClass := newClass _unsafeSetOop: reservedOopNum .
							  (aDict associationAt: className) immediateInvariant 
              ].
             ].
             result := newClass .
       ] ifNotNil: [
          (self
						_equivalentSubclass: oldCls
						superCls: actualSelf
						name: className
						newOpts: ((options copy)
								add: #logCreation;
								yourself)
						newFormat: oldCls format
						newInstVars: ivArg
						newClassInstVars: anArrayOfClassInstVars
						newPools: poolDicts
						newClassVars: classVarArg
						inDict: aDict
						isKernel: true)
							ifFalse: [ArgumentError signal: 'existing class not equivalent to arguments'].
         result := oldCls .
       ].
			self _finishNewReservedClass: newClass old: oldCls resolv: resolveRes .
      ^ result
   ].
	^ nil

]

{ #category : 'Browser Methods' }
Class >> _optionsArray [
  | result optCount swiz |
  result := { } .
  optCount := 0 .
  self instancesDbTransient ifTrue:[ result add: #dbTransient . optCount := optCount + 1 ].
  self _structuralUpdatesDisallowed ifTrue:[ result add: #disallowGciStore  ].
  self instancesInvariant ifTrue:[ result add:  #instancesInvariant  . optCount := optCount + 1 ].
  self instancesNonPersistent ifTrue:[ result add:  #instancesNonPersistent  . optCount := optCount + 1 ].
  optCount > 1 ifTrue:[
    self _error: #classErrBadFormat
        with:'only one of #dbTransient #instancesNonPersistent  #instancesInvariant allowed' .
  ].
  self isModifiable ifTrue:[ result add: #modifiable  ].
  self selfCanBeSpecial ifTrue:[ result add: #selfCanBeSpecial  ].
  self subclassesDisallowed ifTrue:[ result add: #subclassesDisallowed  ].
  self _traversalByCallback ifTrue:[ result add: #traverseByCallback  ].
  swiz := (format bitShift: -31"GC_BEHAV_byteSwizKind_shift") bitAnd: 3"GC_BEHAV_byteSwizKind_mask" .
  swiz > 0 ifTrue:[ | signed |
    signed := (format bitShift: -33"GC_BEHAV_signedWords_shift") bitAnd: 1 .
    signed == 0 ifTrue:[ result add: ( #( #'2byteWords' #'4byteWords' #'8byteWords' ) at: swiz)]
             ifFalse:[ result add: ( #( #'signed2byteWords' #'signed4byteWords' #'signed8byteWords' ) at: swiz) ]
  ].
  "See also  Class >> _rwOptionsArray  in Rowan ."
  ^ result

]

{ #category : 'Browser Methods' }
Class >> _optionsArrayForDefinition [
  "Returns an Array like that from Class>>_optionsArray for use in
   recreating the receiver or exporting a definition to Rowan files."
  | inheritable myOpts supOpts myInheritable supInheritable notInher result |
  inheritable := IdentitySet withAll: #( subclassesDisallowed disallowGciStore traverseByCallback
                                         dbTransient instancesNonPersistent instancesInvariant ).
  myOpts := IdentitySet withAll: self _optionsArray .
  supOpts := IdentitySet new .
  self superclass ifNotNil:[:sc | supOpts addAll: sc _optionsArray ].
  myInheritable := myOpts * inheritable .
  supInheritable := supOpts * inheritable .
  notInher := supInheritable - myInheritable .
  notInher size > 0 ifTrue:[
    result := { #noInheritOptions } .
    result addAll: (SortedCollection withAll: myOpts) .
  ] ifFalse:[
    myOpts := myOpts - inheritable + (myInheritable - supInheritable) .
    result := Array withAll: (SortedCollection withAll: myOpts).
  ].
  ^ result

]

{ #category : 'Private' }
Class >> _optionsChangableTo: formatArr [

  "formatArr describes format and options that would be produced by
   a new class creation.
   Returns true or a String describing why a new version of the class would be required."
  | fmt newFmt str list |
  fmt := format .
  str := String new .
  newFmt := formatArr at: 1 .
  ((fmt bitAnd: 16r800) ~~ 0 and:[ (newFmt bitAnd: 16r800) == 0 ]) ifTrue:[
     str addAll: 'instancesNonPersistent cannot be cleared,' 
  ].
  list := #( 16r8 instancesInvariant 16r1000 'dbTransient'
             16r40 'nscDuplicates' 16r7 implementationFormat ).
  1 to: list size by: 2 do:[:j | | mask |
    mask := list at: j .
    (fmt bitAnd: mask) ~~ (newFmt bitAnd: mask) ifTrue:[
      str addAll:'difference in ', (list at: j+1),', '.
    ].
  ].
  ((fmt bitAnd: 16r800) == 0 and:[ (newFmt bitAnd: 16r800) ~~ 0 ]) ifTrue:[
     "setting instancesNonPersistent"
     (newFmt bitAnd: 16r1008) ~~ 0 ifTrue:[
       str addAll:
       'instancesNonPersistent not allowed with dbTransient or instancesInvariant,'.
     ].
  ].
  ((fmt bitAnd: 16r20) == 0 and:[ (newFmt bitAnd: 16r20) ~~ 0 ]) ifTrue:[
     str addAll:'cannot set subclassesDisallowed if previously cleared,'.
  ].
  self isModifiable ifFalse:[
    (formatArr at: 2 "modifiableBool") ifTrue:[ str addAll:'cannot reenable modifiable,' ].
  ].
  ((fmt bitOr: newFmt) bitAnd: 16r7FFFC000) ~~ 0 ifTrue:[
     str addAll:'isMetaClass,' 
  ].
  (fmt bitShift: -31) = (newFmt bitShift: -31) ifFalse:[ "GC_BEHAV_byteSwizKind_shift"
     str addAll:'difference in byteSwizKind,'.
  ].
  str size == 0 ifTrue:[ ^ true ].
  ^ str.
]

{ #category : 'Browser Methods' }
Class >> _optionsStringForDefinition [
  | result arr |
  result :=  'options: #(' copy .
  arr := self _optionsArrayForDefinition . "fix 48681"
  1 to: arr size do:[:j | | sym |
    result add: $  .
    sym := arr at: j .
    (sym at: 1) isDigit ifTrue:[ result add: $#; add: $' ; add: sym ; add: $' ]
                      ifFalse:[ result add: sym ].
  ].
  result add: $)  .
  ^ result

]

{ #category : 'Private' }
Class >> _poolDictsEqual: anArray [
  "pool dictionaries should be identical to ensure that compiled-in Associations can be shared"
  "fix bug 42279"

  | sharedPoolsArray |
  sharedPoolsArray := self sharedPools.
  sharedPoolsArray size ~= anArray size ifTrue: [ ^false ].
  1 to: sharedPoolsArray size do: [:index |
    (sharedPoolsArray at: index) == (anArray at: index) ifFalse: [ ^false ]].
  ^true

]

{ #category : 'Private' }
Class >> _recompileAllMethods [

"Unconditionally recompile all env 0 methods."

super _recompileAllMethods .
self class _recompileAllMethods

]

{ #category : 'Private' }
Class >> _removeClassVar: aSymbol [

"Remove the class variable named aSymbol from the receiver.
 Signals an error if there is no such class variable."

self _validatePrivilege ifTrue:[
  (Symbol _existingWithAll: aSymbol) ifNotNil:[ :aSym |
    classVars ifNotNil:[ :cvs | | assoc |
      assoc := cvs associationAt: aSym otherwise: nil .
      assoc ifNotNil:[
         cvs removeKey: aSym  .
         ^ self
      ].
    ].
  ].
  ^ LookupError new reason: #classErrClassVarNotFound; key: aSymbol ; object: self;
	signal
].
]

{ #category : 'Modifying Classes' }
Class >> _setClassVars: aDict old: previousDict [

  classVars ~~ aDict ifTrue:[
    previousDict ~~ classVars ifTrue:[ self error:'invalid store to classVars'].
    classVars := aDict .
    self class _setClassVars: aDict old: previousDict
  ].

]

{ #category : 'Browser Methods' }
Class >> _signedWords [

  "Return true if instances of the receiver are byte format with signed words,
   false otherwise."

  self isBytes ifTrue:[
     ^ ((format bitShift: -33"GC_BEHAV_signedWords_shift") bitAnd: 1) == 1
  ].
  ^ false .

]

{ #category : 'Subclass Creation' }
Class >> _subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
newVersionOf: oldClass
description: aDescription
options: optionsArray [

 "optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

	| hist descr |
	descr := aDescription.
	oldClass
		ifNotNil:
			[ (self
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: optionsArray
				newFormat: oldClass format
				newInstVars: anArrayOfInstvarNames
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false)
					ifTrue:
						[oldClass _commentOrDescription: aDescription.
						^oldClass	"avoid creation of a new version"].
			hist := oldClass classHistory.
			descr
				ifNil:
					[descr := [oldClass commentForFileout] on: Error
								do: [:ex | 'old comment not available']]].
	^self
		_subclass: aString
		instVarNames: anArrayOfInstvarNames
		format: format
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: hist
		description: descr
		options: optionsArray
]

{ #category : 'Modifying Classes' }
Class >> _subclasses [

"Returns the class variable that is the list of subclasses, or
 nil if the receiver does not keep track of subclasses."

^ subclasses

]

{ #category : 'Modifying Classes' }
Class >> _subclasses: anIdentitySet [

"Modifies the class variable that is the list of subclasses."

self _validatePrivilege ifTrue:[
  anIdentitySet ifNotNil:[ (anIdentitySet _validateClass: IdentitySet) ifFalse:[ ^ nil ]].
  subclasses := anIdentitySet
].

]

{ #category : 'Private' }
Class >> _validateOptions: optionsArray  withFormat: theFormat newClassName: subClsName [
  "theFormat is requested format and optionsArray is
   requested options for a new class .
   Returns an Array,
    { (theFormat with possible bits added) .  modifiableBBoolean . logBoolean } .
   signals an Error if the optionsArray contains an unregconized option."
| iOptCount fmt modifiableBool logBool swizSym nSwiz signed |
modifiableBool := false .
logBool := false .
nSwiz := 0 .
fmt := theFormat bitAnd: 16r2000 bitInvert "never inherit selfCanBeSpecial" .
iOptCount := 0 .
1 to: optionsArray size do:[:j | | oSym |
  oSym := optionsArray at: j .
  oSym == #noInheritOptions ifTrue:[
    j == 1 ifFalse:[ subClsName _error: #classErrBadFormat with: '#noInheritOptions must be first element of options'].
    "do not inherit dbTransient,instancesNonPersistent,instancesInvariant,subclassesDisallowed,
                    disallowGciStore,traverseByCallback "
    fmt := fmt bitAnd: (16r1E28  bitInvert) ] ifFalse:[
  oSym == #dbTransient ifTrue:[ iOptCount := iOptCount + 1 . fmt := fmt bitOr: 16r1000 ] ifFalse:[
  oSym == #instancesNonPersistent  ifTrue:[ iOptCount := iOptCount + 1 . fmt := fmt bitOr: 16r800 ] ifFalse:[
  oSym == #instancesInvariant ifTrue:[ iOptCount := iOptCount + 1 . fmt := fmt bitOr: 16r8 ] ifFalse:[
  oSym == #subclassesDisallowed ifTrue:[ fmt := fmt bitOr: 16r20 ] ifFalse:[
  oSym == #disallowGciStore ifTrue:[ fmt := fmt bitOr: 16r200 ] ifFalse:[
  oSym == #traverseByCallback ifTrue:[ fmt := fmt bitOr: 16r400 ] ifFalse:[
  oSym == #selfCanBeSpecial ifTrue:[ fmt := fmt bitOr: 16r2000 ] ifFalse:[
  oSym == #modifiable ifTrue:[ modifiableBool := true ] ifFalse:[
  oSym == #logCreation ifTrue:[ logBool := true ] ifFalse:[
  oSym == #'2byteWords' ifTrue:[ swizSym := oSym  . nSwiz := nSwiz + 1 . signed:=false ] ifFalse:[
  oSym == #'4byteWords' ifTrue:[ swizSym := oSym  . nSwiz := nSwiz + 1 . signed:=false ] ifFalse:[
  oSym == #'8byteWords' ifTrue:[ swizSym := oSym  . nSwiz := nSwiz + 1 . signed:=false ] ifFalse:[
  oSym == #'signed2byteWords' ifTrue:[ swizSym := oSym  . nSwiz := nSwiz + 1 . signed:=true ] ifFalse:[
  oSym == #'signed4byteWords' ifTrue:[ swizSym := oSym  . nSwiz := nSwiz + 1 . signed:=true ] ifFalse:[
  oSym == #'signed8byteWords' ifTrue:[ swizSym := oSym  . nSwiz := nSwiz + 1 . signed:=true ] ifFalse:[
    subClsName _error: #classErrBadFormat with: 'unrecognized option ' , oSym printString
  ]]]]]]]]]]]]]]]].
  "See also  Class >> _rwOptionsArray  in Rowan ."
].
logBool ifFalse:[  "fix 50214"
  (SessionTemps current at:#GsClass_logCreation otherwise: nil) == true ifTrue:[ logBool := true ].
].
iOptCount > 1 ifTrue:[
  subClsName _error: #classErrBadFormat
        with:'only one of #dbTransient #instancesNonPersistent  #instancesInvariant allowed' .
].
nSwiz > 1 ifTrue:[
  subClsName _error: #classErrBadFormat
        with: 'only one of #''2byteWords'' #''4byteWords'' #''8byteWords'' #''signed2byteWords'' #''signed4byteWords'' #''signed8byteWords'' allowed'
].
swizSym ifNotNil:[
  (fmt bitAnd: 3) ~~ 1  ifTrue:[
    subClsName _error: #classErrBadFormat
        with:'A *byteWords options wa specified but new class would not be byte format'.
  ].
  fmt := self _addByteSwizzle: swizSym toFormat: fmt newClassName: subClsName signed: signed .
].
^ { fmt . modifiableBool . logBool  }

]

{ #category : 'Subclass Creation' }
Class >> _validName: str [

"Returns whether the given string contains Characters valid for a class name.
 The string need not be a Symbol."

| ch |

(str size == 0 or: [str size > 64]) ifTrue: [
  ^false
].

ch := str at: 1.
(ch == $_  or: [ch isLetter]) ifFalse: [
  ^false
].

2 to: str size do: [ :i |
  ch := str at: i.
  (ch == $_  or: [ch isAlphaNumeric]) ifFalse: [
    ^false
  ].
].

^true.

]

{ #category : 'Browser Methods' }
Class >> _versionedName [
"used by topaz"

^ [ self versionedName ] onException: Error do:[:ex| ^ self describe]

]

{ #category : 'Class Instance Variables' }
Class >> addClassInstanceVariable: civNameString [

"Adds the given class instance variable to the receiver's metaclass.
 Generates an error if the receiver is either not modifiable or does
 not disallow subclasses."

self _validatePrivilege ifTrue:[
  self class addInstVarNames: { civNameString }
]

]

{ #category : 'Updating Variables' }
Class >> addClassVarName: aString [

"Add aString to the class variable list for the receiver, if the
 class variable is not already defined."

| aSym definingClass |
self _validatePrivilege ifTrue:[
  aSym := aString asSymbol .
  aSym validateIsIdentifier .
  definingClass := self _classDefiningClassVar: aSym .  "fix bug 10480"
  definingClass ifNotNil:[
    definingClass == self ifTrue:[
      "if the receiver already defines the class variable,
         do nothing and return silently    (fix bug 8094) "
      ^ self
      ].
    LookupError new object: definingClass; key: aSym ; reason: #classErrClassVarNameExists ;
		details: 'class variable already exists'; signal .
    ^ self
  ].
  self _addClassVar: aSym value: nil .
]

]

{ #category : 'Updating' }
Class >> addNewVersion: aClass [

"Make aClass a new version of the receiver.  That is, add aClass to the
 receiver's history, and set aClass's history to be the same as the
 receiver's history.  The existing history of aClass will have aClass
 removed from it."

self _validatePrivilege ifTrue:[
  aClass classHistory removeVersion: aClass.
  aClass classHistory: classHistory.
  classHistory newVersion: aClass
].

]

{ #category : 'Updating Variables' }
Class >> addSharedPool: aDictionary [

"Add aDictionary to the end of the shared pool list for the receiver. "
| poolDicts |
self _validatePrivilege ifTrue:[
  (aDictionary _validateClass:  SymbolDictionary ) ifTrue:[
     poolDicts := poolDictionaries .
     (poolDicts ~~ nil and:[ poolDicts includesIdentical: aDictionary]) ifTrue:[
        ^ self _error: #classErrPoolDictExists args: { aDictionary }
     ].
     poolDicts ifNil:[ poolDicts := { } . poolDictionaries := poolDicts ]
       ifNotNil:[ poolDicts isInvariant ifTrue:[
                    poolDicts := Array withAll: poolDicts . poolDictionaries := poolDicts
                ]].
     poolDicts add: aDictionary
  ].
].

]

{ #category : 'Queries' }
Class >> allSubclasses [

	^ClassOrganizer new allSubclassesOf: self.

]

{ #category : 'Queries' }
Class >> allSuperclasses [

	^ClassOrganizer new allSuperclassesOf: self.

]

{ #category : 'Class Instance Variables' }
Class >> atClassInstVar: varName [

"Returns the value of the given class instance variable in the receiver.
 Generates an error if the argument does not name a class instance variable
 in the receiver.  In general, it is more efficient to implement a direct
 accessing method for a class instance variable."

| idx cls varSym |
varSym := Symbol _existingWithAll: varName .
varSym == nil ifTrue:[
  self _error: #classErrNotAVar args: { varName } .
  ^ nil
  ].
cls := self class.
idx := cls.instVarNames indexOf: varSym.
(idx < 0 or: [idx <= cls class instSize ]) ifTrue: [
  self _error: #classErrNotAVar args: { varName } .
  ^ nil
].
^ self instVarAt: idx

]

{ #category : 'Class Instance Variables' }
Class >> atClassInstVar: varName put: newValue [
	"Changes the value of the given class instance variable in the receiver,
 without regard to the variance or invariance of the receiver.  Generates an
 error if the argument does not name a class instance variable in the receiver.
 Returns the argument 'newValue'."

	self _validatePrivilege
		ifTrue:
			[| idx cls varSym |
			varSym := Symbol _existingWithAll: varName.
			varSym == nil
				ifTrue:
					[self _error: #classErrNotAVar args: {varName}.
					^nil].
			cls := self class.
			idx := cls.instVarNames indexOf: varSym.
			(idx < 0 or: [idx <= cls class instSize])
				ifTrue:
					[self _error: #classErrNotAVar args: {varName}.
					^nil].
			self _unsafeAt: idx put: newValue.
			^newValue].
	^nil

]

{ #category : 'Subclass Creation' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary [

^ self byteSubclass: aString
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
    description: nil
    options: #()

]

{ #category : 'Deprecated' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
description: aDescription
isInvariant: invarBoolean [

 | opts |
self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
 opts := invarBoolean ifTrue:[ { #instancesInvariant } ]
           ifFalse:[ self instancesInvariant ifTrue:[ ^ self _error: #classErrInvariantSuperClass ].
                     #() ] .
^self
  byteSubclass: aString
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  description: aDescription
  options: opts

]

{ #category : 'Deprecated' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
inClassHistory: aClassHistory
description: aDescription
isInvariant: invarBoolean [

	| theFormat opts |
	self
		deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category ('
				, aString , ').'.
	(aDictionary _validateClass: SymbolDictionary) ifFalse: [^nil].
	self instSize ~~ 0 ifTrue: [^self _error: #classErrByteObjInstVars].
	self isNsc
		ifTrue:
			[^aString _error: #classErrBadFormat
				with: 'cannot create byte subclass of Nsc class'].
	theFormat := (format bitAnd: 16r3 bitInvert) bitOr: 16r1 + 16r4.
	opts := invarBoolean
				ifTrue: [{#instancesInvariant}]
				ifFalse:
					[self instancesInvariant
						ifTrue: [^self _error: #classErrInvariantSuperClass].
					#()].
	^self
		_subclass: aString
		instVarNames: #()
		format: theFormat
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: aClassHistory
		description: aDescription
		options: opts

]

{ #category : 'Deprecated' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
instancesInvariant: invarBoolean [

 | opts |
 self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods
  are in the Subclass Creation category (' , aString , ').'.

 opts := invarBoolean ifTrue:[ { #instancesInvariant } ]
           ifFalse:[ self instancesInvariant ifTrue:[ ^ self _error: #classErrInvariantSuperClass ].
                     #() ] .
^self
  byteSubclass: aString
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  description: nil
  options: opts

]

{ #category : 'Deprecated' }
Class >> byteSubclass: aString
	classVars: anArrayOfClassVars
	classInstVars: anArrayOfClassInstVars
	poolDictionaries: anArrayOfPoolDicts
	inDictionary: aDictionary
	newVersionOf: oldClass
	description: aDescription
	isInvariant: invarBoolean [

	| hist theFormat opts descr |
	self
		deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category ('
				, aString , ').'.
	aDictionary _validateClass: SymbolDictionary.
	self instSize ~~ 0 ifTrue: [^self _error: #classErrByteObjInstVars].
	self isNsc
		ifTrue:
			[^aString _error: #classErrBadFormat
				with: 'cannot create byte subclass of Nsc class'].
	theFormat := (format bitAnd: 16r3 bitInvert) bitOr: 16r1 + 16r4.
	opts := invarBoolean
				ifTrue: [{#instancesInvariant}]
				ifFalse:
					[self instancesInvariant
						ifTrue: [^self _error: #classErrInvariantSuperClass].
					#()].
	descr := aDescription.
	oldClass
		ifNotNil:
			[(self
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: opts
				newFormat: theFormat
				newInstVars: #()
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false)
					ifTrue:
						[oldClass _commentOrDescription: aDescription.
						^oldClass	"avoid creation of a new version"].
			hist := oldClass classHistory.
			descr
				ifNil:
					[descr := [oldClass commentForFileout] on: Error
								do: [:ex | 'old comment not available']]].
	^self
		_subclass: aString
		instVarNames: #()
		format: theFormat
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: hist
		description: descr
		options: opts
]

{ #category : 'Subclass Creation' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
newVersionOf: oldClass
description: aDescription
options: optionsArray [

	"Creates and returns a new byte subclass of the receiver.  You are not
 permitted to modify the new class after it is created.  If the receiver is not
 some kind of String class, then instances of the new class store and return
 SmallIntegers in the range 0 - 255.

 This method generates an error if instances of the receiver are of special
 storage format, if they are NSCs, or if they have instance variables.

 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 and at most one of the word size definitions for byte format (affects swizzling)
   #'2byteWords' #'4byteWords' #'8byteWords'
   #'signed2byteWords' #'signed4byteWords' #'signed8byteWords'
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

	| hist fmt descr |
	aDictionary
		ifNotNil: [ (aDictionary _validateClass: SymbolDictionary) ifFalse: [^nil] ].
	self isNsc
		ifTrue:
			[^aString _error: #classErrBadFormat
				with: 'cannot create byte subclass of Nsc class'].
	fmt := (format bitAnd: 16r3 bitInvert) bitOr: 16r1 + 16r4.
	descr := aDescription.
	oldClass
		ifNotNil:
			[(self
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: optionsArray
				newFormat: fmt
				newInstVars: #()
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false )
					ifTrue:
						[oldClass _commentOrDescription: aDescription.
						^oldClass	"avoid creation of a new version" ].
			hist := oldClass classHistory.
			descr ifNil: [descr := [ oldClass commentForFileout ] on: Error do:[:ex | 'old comment not available']]].
	^self
		_subclass: aString
		instVarNames: #()
		format: fmt
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: hist
		description: descr
		options: optionsArray
]

{ #category : 'Deprecated' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
newVersionOf: oldClass
instancesInvariant: invarBoolean [

 | opts |
self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
 opts := invarBoolean ifTrue:[ { #instancesInvariant } ]
           ifFalse:[ self instancesInvariant ifTrue:[ ^ self _error: #classErrInvariantSuperClass ].
                     #() ] .
 ^ self byteSubclass: aString
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    newVersionOf: oldClass
    description: (oldClass ifNotNil:[ [ oldClass commentForFileout ] on: Error do:[:ex | 'old comment not available']])
    options: opts
]

{ #category : 'Subclass Creation' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
options: optionsArray [


"Creates and returns a new byte subclass of the receiver.  You are not
 permitted to modify the new class after it is created.  If the receiver is not
 some kind of String class, then instances of the new class store and return
 SmallIntegers in the range 0 - 255.

 If aString is the name of a Class that is visible to the current user, this
 method creates the new class as a new version of the existing class, and they
 then share the same class history.  However, if no class named aString is
 visible to the user, then the new class is no relation to any existing class,
 and it has a new class history.

 This method generates an error if instances of the receiver are of special
 storage format, if they are NSCs, or if they have instance variables.

 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 and at most one of the word size definitions for byte format (affects swizzling)
   #'2byteWords' #'4byteWords' #'8byteWords'
   #'signed2byteWords' #'signed4byteWords' #'signed8byteWords'
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.
"

^ self byteSubclass: aString
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
    description: nil
    options: optionsArray

]

{ #category : 'Deprecated' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
inClassHistory: aClassHistory
description: aDescription
isInvariant: invarBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self byteSubclass: aString
  classVars: anArrayOfClassVars
  classInstVars: #()
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  inClassHistory: aClassHistory
  description: aDescription
  isInvariant: invarBoolean

]

{ #category : 'Deprecated' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
isInvariant: invarBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^ self byteSubclass: aString
    classVars: anArrayOfClassVars
    classInstVars: #()
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    instancesInvariant: invarBoolean

]

{ #category : 'Subclass Creation' }
Class >> byteSubclass: aString
classVars: anArrayOfClassVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
options: optionsArray [

^ self byteSubclass: aString
    classVars: anArrayOfClassVars
    classInstVars: #()
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    options: optionsArray

]

{ #category : 'Instance Migration' }
Class >> cancelMigration [

"Disables class migration by clearing the migrationDestination instance
 variable."

self migrationDestination: nil.

]

{ #category : 'Category' }
Class >> category: newCategory [

"Sets the classCategory variable of the receiver.
 The argument should be a kind of CharacterCollection or nil."

	self _rwCategory: newCategory
]

{ #category : 'Accessing' }
Class >> classHistory [

"Returns the classHistory instance variable for this class, which may be nil."

^ classHistory

]

{ #category : 'Updating' }
Class >> classHistory: aClassHistory [

"Set the class history of the receiver. Returns the receiver."

self _validatePrivilege ifTrue:[
  aClassHistory ifNotNil:[
    (aClassHistory _validateInstanceOf: ClassHistory) ifFalse:[ ^ nil ].
  ].
  classHistory := aClassHistory .
  self _refreshClassCache: false .
].

]

{ #category : 'Accessing' }
Class >> classHistoryAt: aSmallInteger [

"Returns the specified version of this class."

^ classHistory at: aSmallInteger .

]

{ #category : 'Clustering' }
Class >> clusterBehavior [

"Clusters elements of the receiver and its metaclass that are used
 for GemStone Smalltalk execution.

 It is recommended that when several classes are being clustered in a
 transaction, send clusterBehavior to all classes to be clustered, then send
 clusterDescription."

super clusterBehavior ifTrue:[ ^ true ].
self class clusterBehavior .
^ false

]

{ #category : 'Clustering' }
Class >> clusterDescription [

"Clusters elements of the receiver and its metaclass that are not required
 for GemStone Smalltalk execution.

 It is recommended that when several classes are being clustered in a
 transaction, send clusterBehavior to all classes to be clustered, then send
 clusterDescription."

| result |
super clusterDescription ifTrue:[ ^ true ].
result := false .
extraDict ifNotNil:[
  result := extraDict cluster .
  result ifFalse:[ extraDict associationsDo:[:assoc| assoc cluster]].
].
result ifFalse:[ timeStamp ifNotNil:[ result := timeStamp cluster ]].
userId ifNotNil:[ userId cluster ].
result ifFalse:[ result := self class clusterDescription ].
^ result

]

{ #category : 'Class Comments' }
Class >> comment [

" As of GS/64 3.1, comments are now recorded in the class extraDict
  dictionary under the key #comment.  Comment information formerly
  recorded as a GsClassDocumentation under the key #description are
  converted to a string and placed under #comment during DB
  conversion/upgrade. "

  | str |
  (self _extraDictAt: #comment) ifNotNil:[:cmt | ^ cmt ].
  str := 'No class-specific documentation for ' , self name .
  str add: ', hierarchy is:
'; add: (self hierarchy: 0) .
  ^ str

]

{ #category : 'Class Comments' }
Class >> comment: aString [

  (aString isKindOf: CharacterCollection) ifFalse: [
    ArgumentTypeError signal: 'Comment must be a String' ].
  self _extraDictAt: #comment put: aString

]

{ #category : 'Class Comments' }
Class >> commentForFileout [

"Returns a non-empty class comment or nil."

| str |
str := self _extraDictAt: #comment .
str size = 0 ifTrue:[ ^ nil ].
^ str

]

{ #category : 'Private' }
Class >> copyVariables [
| chSize chist priorVersion priorVars civNames priorCivNames toIgnoreCount |
(chSize := (chist := classHistory) size) = 1 ifTrue:[
  ^ self
].
priorVersion := chist at: chSize - 1.
(priorVars := priorVersion _classVars) notNil ifTrue: [
  | cvars |
  (cvars := classVars) notNil ifTrue: [
    priorVars associationsDo: [:anAssociation | |aKey |
      (cvars includesKey: (aKey := anAssociation key)) ifTrue: [
        cvars removeKey: aKey .
        cvars addAssociation: anAssociation.
      ].
    ].
  ].
].
priorCivNames := priorVersion class allInstVarNames.
toIgnoreCount := Class allInstVarNames size.
toIgnoreCount < priorCivNames size ifTrue: [
	priorCivNames := priorCivNames
		copyFrom: toIgnoreCount + 1
		to: priorCivNames size.
	civNames := self class allInstVarNames.
	priorCivNames do: [:each |
		(civNames includesIdentical: each) ifTrue: [
			self atClassInstVar: each put: (priorVersion atClassInstVar: each).
		].
	].
].

]

{ #category : 'Versions' }
Class >> currentVersion [

  "return the most recent version of the receiver"
  classHistory ifNotNil:[ :hist | | sz |
    (sz := hist size) ~~ 0 ifTrue:[ ^ hist at: sz ].
  ].
  ^ self

]

{ #category : 'Accessing' }
Class >> dbTransientInstVarNames [
  "Returns an Array (possibly empty) of instVarNames that are dbTransient on a per-instVar basis "
  | res word |
  res := { } .
  (word := self dbTransientMask) ~~ 0 ifTrue:[
     | mask names |
     mask := 1 .
     names := instVarNames .
     1 to: self instSize do:[:n |
       (word bitAnd: mask) ~~ 0 ifTrue:[ res add:(names at: n) ].
       mask := mask bitShift: 1 .
     ].
  ].
  ^ res

]

{ #category : 'Accessing' }
Class >> dbTransientMask [
  "Returns a SmallInteger"
  ^ dbTransientMask ifNil:[ 0 ] .

]

{ #category : 'Browser Methods' }
Class >> definition [
	"Returns a String containing a GemStone Smalltalk definition for the receiver
 (that is, a subclass creation message).  This method uses the UserProfile
 of the owner of the current session as the correct context."
	"For use with the Topaz run command."

	^self _definitionInContext: System myUserProfile

]

{ #category : 'Accessing' }
Class >> description [

"Returns the description of this class."

self deprecated: 'Class>>description deprecated v3.1. Replaced by comment.'.
^ self _description

]

{ #category : 'Class Comments' }
Class >> description: aDescription [

"Update the description of this Class.  Returns the argument."
self deprecated: 'Deprecated as of GS/64 3.1'.
^ self _description: aDescription

]

{ #category : 'Accessing' }
Class >> extraDict [

"Returns the SymbolDictionary held in extraDict that holds miscellaneous
 information about the receiver.  Result may be nil. "

^ extraDict

]

{ #category : 'Updating' }
Class >> extraDict: aSymbolDictionary [

"Set the value of the extraDict instance variable."

self _validatePrivilege ifTrue:[
  aSymbolDictionary ifNotNil:[
    (aSymbolDictionary _validateClass: SymbolDictionary) ifFalse:[ ^ self].
  ].
  extraDict := aSymbolDictionary
].

]

{ #category : 'Accessing' }
Class >> extraDictForStore [

"Returns the SymbolDictionary held in extraDict that holds miscellaneous
 information about the receiver.  Creates the dictionary if needed."

^ extraDict ifNil:[ extraDict := SymbolDictionary new ].

]

{ #category : 'Subclass Creation' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary [

"Executes
   oldClass := aDictionary at:(aString asSymbol) otherwise: nil
 and returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

^ self indexableSubclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
    description: nil
    options: #()

]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
description: aDescription
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
  indexableSubclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  constraints: aConstraint
  instancesInvariant: invarBoolean
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  description: aDescription
  isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: ignored
instancesInvariant: invarBoolean
inClassHistory: aClassHistory
description: aDescription
isModifiable: modifyBoolean [

| opts fmt |
self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
"Any specified constraints are ignored."
(self isBytes) ifTrue: [ ^ aString _error: #classErrBadFormat with: 'cannot create indexable subclass of byte class'].
(self isNsc) ifTrue: [ ^ aString _error: #classErrBadFormat with: 'cannot create indexable subclass of Nsc class'].
opts := { } .
invarBoolean ifTrue:[ opts add: #instancesInvariant ]
           ifFalse:[ self instancesInvariant ifTrue:[ ^ self _error: #classErrInvariantSuperClass ]].
modifyBoolean ifTrue:[ opts add: #modifiable ].
fmt := format bitOr: 16r4 "add indexable bit" .

^ self _subclass: aString
        instVarNames: anArrayOfInstvarNames
        format: fmt
        classVars: anArrayOfClassVars
        classInstVars: anArrayOfClassInstVars
        poolDictionaries: anArrayOfPoolDicts
        inDictionary: aDictionary
        inClassHistory: aClassHistory
        description: aDescription
        options: opts

]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
  indexableSubclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  constraints: aConstraint
  instancesInvariant: invarBoolean
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  description: nil
  isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: ignored
instancesInvariant: invarBoolean
newVersionOf: oldClass
description: aDescription
isModifiable: modifyBoolean [

	| opts fmt hist descr |
	self
		deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category ('
				, aString , ').'.
	"Any specified constraints are ignored."
	self isBytes
		ifTrue:
			[^aString _error: #classErrBadFormat
				with: 'cannot create indexable subclass of byte class'].
	self isNsc
		ifTrue:
			[^aString _error: #classErrBadFormat
				with: 'cannot create indexable subclass of Nsc class'].
	opts := {}.
	invarBoolean
		ifTrue: [opts add: #instancesInvariant]
		ifFalse:
			[self instancesInvariant
				ifTrue: [^self _error: #classErrInvariantSuperClass]].
	modifyBoolean ifTrue: [opts add: #modifiable].
	fmt := format bitOr: 16r4.	"add indexable bit"
	descr := aDescription.
	oldClass
		ifNotNil:
			[(self
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: opts
				newFormat: fmt
				newInstVars: anArrayOfInstvarNames
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false)
					ifTrue:
						["avoid creation of a new version"
						oldClass _commentOrDescription: aDescription.
						^oldClass].
			hist := oldClass classHistory.
			descr
				ifNil:
					[descr := [oldClass commentForFileout] on: Error
								do: [:ex | 'old comment not available']]].
	^self
		_subclass: aString
		instVarNames: anArrayOfInstvarNames
		format: fmt
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: hist
		description: descr
		options: opts
]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
newVersionOf: oldClass
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^ self indexableSubclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    constraints: aConstraint
    instancesInvariant: invarBoolean
    newVersionOf: oldClass
    description: nil
    isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
instancesInvariant: invarBoolean
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
  indexableSubclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  instancesInvariant: invarBoolean
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
instancesInvariant: invarBoolean
newVersionOf: oldClass
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^ self indexableSubclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    constraints: #()
    instancesInvariant: invarBoolean
    newVersionOf: oldClass
    description: (oldClass ifNotNil:[ [ oldClass commentForFileout ] on: Error do:[:ex | 'old comment not available']])
    isModifiable: modifyBoolean
]

{ #category : 'Subclass Creation' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
newVersionOf: oldClass
description: aDescription
options: optionsArray [
	"Creates and returns a new indexable subclass of the receiver.  Instances of the
 new class are represented as pointer objects.

 This method generates an error if instances of the receiver are of special
 storage format or if they are NSCs.

 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

	| hist fmt descr |
	self isBytes
		ifTrue:
			[^aString _error: #classErrBadFormat
				with: 'cannot create indexable subclass of byte class'].
	self isNsc
		ifTrue:
			[^aString _error: #classErrBadFormat
				with: 'cannot create indexable subclass of Nsc class'].
	fmt := format bitOr: 16r4.	"add indexable bit"
	descr := aDescription.
	oldClass
		ifNotNil:
			[(self
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: optionsArray
				newFormat: fmt
				newInstVars: anArrayOfInstvarNames
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false )
					ifTrue:
						[oldClass _commentOrDescription: aDescription.
						^oldClass	"avoid creation of a new version"].
			hist := oldClass classHistory.
			descr ifNil: [descr := [ oldClass commentForFileout ] on: Error do:[:ex | 'old comment not available']]].
	^self
		_subclass: aString
		instVarNames: anArrayOfInstvarNames
		format: fmt
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: hist
		description: descr
		options: optionsArray
]

{ #category : 'Subclass Creation' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
options: optionsArray [

"Creates and returns a new indexable subclass of the receiver.  Instances of the
 new class are represented as pointer objects.

 This method generates an error if instances of the receiver are of special
 storage format or if they are NSCs.

 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Executes
   oldClass := aDictionary at:(aString asSymbol) otherwise: nil
 and returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

^ self indexableSubclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
    description: nil
    options: optionsArray

]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
inClassHistory: aClassHistory
description: aDescription
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self indexableSubclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: #()
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  constraints: aConstraint
  instancesInvariant: invarBoolean
  inClassHistory: aClassHistory
  description: aDescription
  isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^ self indexableSubclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars: anArrayOfClassVars
    classInstVars: #()
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    constraints: aConstraint
    instancesInvariant: invarBoolean
    isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> indexableSubclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
isInvariant: invarBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^ self indexableSubclass: aString
     instVarNames: anArrayOfInstvarNames
     classVars: anArrayOfClassVars
     classInstVars: #()
     poolDictionaries: anArrayOfPoolDicts
     inDictionary: aDictionary
     constraints: aConstraint
     instancesInvariant: invarBoolean
     isModifiable: false

]

{ #category : 'Queries' }
Class >> instancesInMemory [
"Returns an Array that contains all instances of the receiver.
 that are in the temporary object memory of this session."

^ (SystemRepository listInstancesInMemory: { self }) at: 1

]

{ #category : 'Displaying' }
Class >> instanceString [

"Returns a symbol that can be used to name an instance of the receiver."

^(('AEIOUYaeiouy' indexOf: (name at: 1) startingAt: 1) ~~ 0
   ifTrue: ['an']
   ifFalse: ['a'])
 , name

]

{ #category : 'Displaying' }
Class >> instanceSymbol [

"Returns a symbol that can be used to name an instance of the receiver."

^ ((('AEIOUYaeiouy' indexOf: (name at: 1) startingAt: 1) ~~ 0
  ifTrue: ['An']
  ifFalse: ['A'])
    , name) asSymbol

]

{ #category : 'Class Instance Variables' }
Class >> instVarAt: anIndex put: aValue [
  | sz |
  self _validatePrivilege ifTrue:[
    anIndex <= Class instSize ifTrue:[
      ImproperOperation new object: self ;
         signal: 'instVarAt:put: not allowed to a class instance variable defined for Class'
    ].
    anIndex > (sz := self class instSize) ifTrue:[
       OutOfRange new name:#anIndex max: sz actual: anIndex ; signal .
    ].
    self _unsafeAt: anIndex put: aValue .
    ^ aValue
  ].
  ^ nil

]

{ #category : 'Updating' }
Class >> instVarDbTransient: aSymbol value: aBoolean [
  "Change the per-instVar dbTransient attribute of instVar specifed by aSymbol to aBoolean.

   A instVar with attribute true will have its value  flushed to disk be nil on commit,
   and will be nil when faulted in from disk.  To preserve the in-memory state of the
   instVar,  ensure the object is kept reachable in memory , such as from  SessionTemps current,
   or from the Smalltalk stack.

   For an indexable class with named instVars, such as a subclass of Array ,
   if an instance has  (self size + self class instSize > 2034) 
   the per-instVar dbTransient attribute will always behave as false on that instance.

   The change will not take effect completely until after this session commits, and will only
   be completely in effect in sessions which login after such commit .

   For instances committed prior to setting dbTransient attribute to true, that instVar,
   may be non-nil on disk, but that non-nil value will not be visible to Smalltalk execution
   in sessions that login after the attribute change.  listReferences and markForCollection
   will see the non-nil value; the next commit that changes some other instVar in
   the instance will set that instVar on disk to nil.

   Instance variables that are dbTransient may not participate any Index on an UnorderedCollection,
   errors will be signaled if any element of a path for an Index evaluates to a dbTransient
   instance variable.

   Only the first 60 instVars may be dbTransient .
   If aSymbol specifies an instVar beyond 60 (i.e. instVarAt:61 or subsequent instVar) ,
   an Error will be signalled."

  | ofs word mask |
  (ofs := instVarNames indexOfIdentical: aSymbol) == 0 ifTrue:[
     ^ ImproperOperation signal:'not a valid instVarName: ', aSymbol printString .
  ].
  ofs > 60"GC_Class_max_dbTrIvOffset" ifTrue:[ 
     ^ ImproperOperation signal:'dbTransient is supported only on the first 60 instVars of a class'
  ].
  "prevent changes if instVar names are still changable"
  self isModifiable ifTrue:[ ImproperOperation signal:'class cannot be modifiable' ].
  (word := dbTransientMask) ifNil:[ 
     aBoolean ifFalse:[ ^ self ].
     word := 0 .
  ]. 
  mask := 1 bitShift: ofs - 1 .
  aBoolean ifTrue:[ word := word bitOr: mask ]
          ifFalse:[ word := word bitAnd: mask bitInvert ].
  dbTransientMask := word .

]

{ #category : 'Versions' }
Class >> isVersionOf: anotherClass [

"Returns whether the receiver and the given class share the same class
 history."

| hist |
^ ( hist := classHistory) ~~ nil and:[ anotherClass classHistory == hist ].

]

{ #category : 'Locking' }
Class >> lockableParts [

"Returns an Array of the receiver's contents that are locked by browsers
 and folders."

| parts ed |
parts := super lockableParts.
(ed := extraDict) ifNotNil:[
	parts addLast: ed.
	ed do: [:each | parts addLast: each].
].
^ parts reject:[:ea | ea == nil or:[ ea == #() ] ].

]

{ #category : 'Modifying Classes' }
Class >> makeInstancesDbTransient [

  "Takes effect immediately and will cause any instances that get
   committed to be DbTransient.

   For a DbTransient object, instVars on disk are always nil.
   The first transaction which causes the object to be reachable
   from committed state will commit the object with all instVars on
   disk set to nil .  Thereafter any stores to instVars of the committed
   object in any session do not cause the object to be written
   by the transaction.

   Clustering a committed DbTransient object will
   cause the object to be rewritten to disk with all instVars nil
   when the transaction commits.  So clustering is the only way
   that concurrency conflict could occur involving a DbTransient object.

   The format of the receiver must be    non-indexable, pointer
   otherwise an error is generated.

   You cannot change a non-modifiable class to or from dbTransient ."

  <primitive: 2001>   "enter protected mode"
  | prot |
  prot := System _protectedMode .
  [
    self validateIsModifiable .
    self _makeInstancesDbTransient: true .
  ] ensure: [
    prot _leaveProtectedMode
  ].

]

{ #category : 'Modifying Classes' }
Class >> makeInstancesNonPersistent [

  "Takes effect immediately and will prevent committing new instances
   of the receiver in the current transaction.

   To change a non-modifiable class from persistent to non-persistent ,
   see  ClassOrganizer >> makeInstancesNonPersistent: . "

  <primitive: 2001>   "enter protected mode"
  | prot |
  prot := System _protectedMode .
  [ self validateIsModifiable .
    self _makeInstancesNonPersistent .
  ] ensure:[
    prot _leaveProtectedMode
  ].

]

{ #category : 'Modifying Classes' }
Class >> makeInstancesNotDbTransient [

  "Takes effect immediately and cancels any previous makeInstancesDbTransient.

   The receiver must be a modifiable class."

  <primitive: 2001>   "enter protected mode"
  | prot |
  prot := System _protectedMode .
  [
    self validateIsModifiable .
    self _makeInstancesDbTransient: false .
  ] ensure:[
    prot _leaveProtectedMode .
  ].

]

{ #category : 'Modifying Classes' }
Class >> makeInstancesPersistent [

  "Takes effect immediately.
   To change a non-modifiable class from non-persistent to persistent,
   see  ClassOrganizer >> makeInstancesPersistent: . "

  <primitive: 2001>   "enter protected mode"
  | prot |
  prot := System _protectedMode .
  [ self isModifiable ifFalse:[ self validateIsModifiable . ^ self ].
    self _makeInstancesPersistent .
  ] ensure:[
    prot _leaveProtectedMode
  ].

]

{ #category : 'Method Timestamps' }
Class >> methodStampDictName [
  ^ #GSMethodStampDict

]

{ #category : 'Instance Migration' }
Class >> migrateTo: aClass [

"Enables class migration by setting the migrationDestination instance
 variable."

self _validatePrivilege ifTrue:[
  self migrationDestination: aClass.
].

]

{ #category : 'Accessing' }
Class >> migrationDestination [

"Returns the migrationDestination instance variable of this class."

^ destClass

]

{ #category : 'Updating' }
Class >> migrationDestination: aClass [

"Update the migrationDestination instance variable.  Returns the argument."

self _validatePrivilege ifTrue:[
  aClass ifNotNil:[ aClass _validateClass: Class ].
  destClass := aClass .
  self _refreshClassCache: false .
].
^ aClass

]

{ #category : 'Repository Conversion' }
Class >> needsRecompileFor30 [

 "Returns true if the receiver needs to have methods recompiled."

 ^ super needsRecompileFor30 or:[ self class needsRecompileFor30]

]

{ #category : 'Repository Conversion' }
Class >> needsRecompileFor33 [

 "Returns true if the receiver needs to have methods recompiled."

 ^ super needsRecompileFor33 or:[ self class needsRecompileFor33]

]

{ #category : 'Instance Creation' }
Class >> new [

"Returns an instance of the receiver with no indexed variables."
<primitive: 51>
self _primitiveFailed: #new .
self _uncontinuableError

]

{ #category : 'Instance Creation' }
Class >> new: anInteger [

"Returns an instance of the receiver with the specified number of indexed
 variables.  Generates an error if the receiver is not indexable or if
 anInteger is not a positive SmallInteger.

 For new byte objects, all indexed variables are set to zero;
 for new pointer objects, all indexed variables are set to nil."

<primitive: 53>
(self isIndexable) ifFalse:[ self _errorNotIndexable .  ^ self new ].
(anInteger _isInteger)
  ifFalse:[ anInteger _validateClass: Integer . ^ self new ]
  ifTrue:[
    (anInteger < 0) ifTrue:[ anInteger _error: #rtErrArgNotPositive .
                            ^ self new].
    anInteger _error: #rtErrArgOutOfRange .
    ^ self new
  ].
self _primitiveFailed: #new: args: { anInteger }.
self _uncontinuableError

]

{ #category : 'Pragmas' }
Class >> pragmaDictName [

  ^ #GSMethodPragmaDict

]

{ #category : 'Repository Conversion' }
Class >> recompileAllMethods [

"Recompile all methods for execution in a Gs64 v3.0 or later system."

super recompileAllMethods .
self class recompileAllMethods

]

{ #category : 'Browser Methods' }
Class >> recompileWithDicts: symbolList [

"Recompiles all the receiver's instance and class methods for envId 0.
 Returns the CompiledMethods that fail to compile properly."
| failed |
failed := { }.
self _validatePrivilege ifTrue:[
  | cls envId |
  cls := self .
  envId := 0 .
  2 timesRepeat: [
    cls env: envId unifiedCategoriesDo:[ :categName :selectorList |
      selectorList copy do: [ :aSel| | oldMeth |
        [ oldMeth := cls compiledMethodAt: aSel environmentId: envId .
          cls compileMethod: oldMeth sourceString dictionaries: symbolList
		          category: categName environmentId: envId
        ] onException: CompileError do:[:ex |
          failed add: oldMeth
        ].
      ].
    ].
    cls := self class .
  ].
].
^ failed.

]

{ #category : 'Updating Variables' }
Class >> removeClassVarName: aString [

"Remove the class variable named aString from the receiver.
 The value of the removed Association is set to nil.
 Signals an error if there is no such class variable, or if the
 Association for that class variable is invariant."

self _validatePrivilege ifTrue:[
  (Symbol _existingWithAll: aString) ifNotNil:[ :aSym |
    classVars ifNotNil:[ :cvs | | assoc |
      assoc := cvs associationAt: aSym otherwise: nil .
      assoc ifNotNil:[
         assoc isInvariant ifFalse:[ assoc value: nil ].
         cvs removeKey: aSym  .
         ^ self
      ].
    ].
  ].
  ^ LookupError new reason: #classErrClassVarNotFound; key: aString ; object: self;
	signal
].
]

{ #category : 'Updating Variables' }
Class >> removeSharedPool: aDictionary [

"Remove aDictionary from the shared pool list for the receiver.  Generates an
 error if aDictionary is not a shared pool for the receiver.

 You may use this method only if, when the receiver was created, the argument
 to poolDictionaries: was an Array rather than a literal Array, which would
 create an InvariantArray.  (See Class >> subclass:.)"

self _validatePrivilege ifTrue:[
  poolDictionaries ifNotNil:[ | idx |
    (idx := poolDictionaries indexOfIdentical: aDictionary) ~~ 0 ifTrue:[
       poolDictionaries removeAtIndex: idx .
       ^ self
    ].
  ].
  ^ LookupError new reason: #classErrPoolDictNotFound;  key: aDictionary  ;
	object: self ; signal .
].

]

{ #category : 'Deprecated' }
Class >> subclass: aString
inDictionary: aDictionary
constraints: constraintSpec [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^ self subclass: aString
    instVarNames: #()
    classVars:  #()
    classInstVars:  #()
    poolDictionaries: { }
    inDictionary: aDictionary
    constraints: constraintSpec
    instancesInvariant: false
    isModifiable: false

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classInstVars: anArrayOfClassInstVars
inDictionary: aDictionary
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^ self
    subclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars:  #()
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: { }
    inDictionary: aDictionary
    constraints:  #()
    instancesInvariant: false
    isModifiable: modifyBoolean

]

{ #category : 'Subclass Creation' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary [

"Executes
   oldClass := aDictionary at:(aString asSymbol) otherwise: nil
 and returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

^ self subclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
    description: nil
    options: #()

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
description: aDescription
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  constraints: aConstraint
  instancesInvariant: invarBoolean
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  description: aDescription
  isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: ignored
instancesInvariant: invarBoolean
inClassHistory: aClassHistory
description: aDescription
isModifiable: modifyBoolean [

| opts |
self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
opts := { } .
invarBoolean ifTrue:[ opts add: #instancesInvariant ]
           ifFalse:[ self instancesInvariant ifTrue:[ ^ self _error: #classErrInvariantSuperClass ]].
modifyBoolean ifTrue:[ opts add: #modifiable ].
^ self _subclass: aString
          instVarNames: anArrayOfInstvarNames
          format: format
          classVars: anArrayOfClassVars
          classInstVars: anArrayOfClassInstVars
          poolDictionaries: anArrayOfPoolDicts
          inDictionary: aDictionary
          inClassHistory: aClassHistory
          description: aDescription
          options: opts

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  constraints: aConstraint
  instancesInvariant: invarBoolean
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  description: nil
  isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: ignored
instancesInvariant: invarBoolean
newVersionOf: oldClass
description: aDescription
isModifiable: modifyBoolean [

	| opts hist descr |
	self
		deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category ('
				, aString , ').'.
	"Any specified constraints are ignored."
	opts := {}.
	invarBoolean
		ifTrue: [opts add: #instancesInvariant]
		ifFalse:
			[self instancesInvariant
				ifTrue: [^self _error: #classErrInvariantSuperClass]].
	modifyBoolean ifTrue: [opts add: #modifiable].
	descr := aDescription.
	oldClass
		ifNotNil:
			[(self
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: opts
				newFormat: self format
				newInstVars: anArrayOfInstvarNames
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false)
					ifTrue:
						[oldClass _commentOrDescription: aDescription.
						^oldClass	"avoid creation of a new version"].
			hist := oldClass classHistory.
			descr
				ifNil:
					[descr := [oldClass commentForFileout] on: Error
								do: [:ex | 'old comment not available']]].
	^self
		_subclass: aString
		instVarNames: anArrayOfInstvarNames
		format: format
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: hist
		description: descr
		options: opts
]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
newVersionOf: oldClass
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^ self subclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    constraints: aConstraint
    instancesInvariant: invarBoolean
    newVersionOf: oldClass
    description: nil
    isModifiable: modifyBoolean


]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: ignored
options: optionsArr [

	| hist descr oldClass |
	self
		deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category ('
				, aString , ').'.
	"Any specified constraints are ignored."
	oldClass := self _classNamed: aString inDictionary: aDictionary.
	oldClass
		ifNotNil:
			[(self
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: optionsArr
				newFormat: self format
				newInstVars: anArrayOfInstvarNames
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false) ifTrue: [^oldClass	"avoid creation of a new version"].
			hist := oldClass classHistory.
			descr := [oldClass commentForFileout] on: Error
						do: [:ex | 'old comment not available']].
	^self
		_subclass: aString
		instVarNames: anArrayOfInstvarNames
		format: format
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: hist
		description: descr
		options: optionsArr
]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
instancesInvariant: invarBoolean
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  instancesInvariant: invarBoolean
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
instancesInvariant: invarBoolean
newVersionOf: oldClass
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^ self subclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    constraints: #()
    instancesInvariant: invarBoolean
    newVersionOf: oldClass
    description: (oldClass ifNotNil:[ [ oldClass commentForFileout ] on: Error do:[:ex | 'old comment not available']])
    isModifiable: modifyBoolean
]

{ #category : 'Subclass Creation' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
options: optionsArray [

"Creates and returns a new subclass of the receiver.

 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Executes
   oldClass := aDictionary at:(aString asSymbol) otherwise: nil
 and returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "


^ self subclass: aString
    instVarNames: anArrayOfInstvarNames
    classVars: anArrayOfClassVars
    classInstVars: anArrayOfClassInstVars
    poolDictionaries: anArrayOfPoolDicts
    inDictionary: aDictionary
    newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
    description: nil
    options: optionsArray

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
inClassHistory: aClassHistory
description: aDescription
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: #()
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  constraints: aConstraint
  instancesInvariant: invarBoolean
  inClassHistory: aClassHistory
  description: aDescription
  isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
   subclass: aString
   instVarNames: anArrayOfInstvarNames
   classVars: anArrayOfClassVars
   classInstVars: #()
   poolDictionaries: anArrayOfPoolDicts
   inDictionary: aDictionary
   constraints: aConstraint
   instancesInvariant: invarBoolean
   isModifiable: modifyBoolean

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
isInvariant: invarBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: #()
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  constraints: aConstraint
  instancesInvariant: invarBoolean
  isModifiable: false

]

{ #category : 'Subclass Creation' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
inDictionary: aDictionary [

"Creates and returns a new subclass of the receiver.

 This method is a shortcut for convenience only.  It might not be retained in
 future GemStone releases.  Use it interactively or pedagogically, but avoid
 it in production code.

 The new class has no class variables, no class instance variables,
 and no pool dictionaries.
 Instances of the new class are variant, but the new class itself is not
 modifiable.

 Executes
   oldClass := aDictionary at:(aString asSymbol) otherwise: nil
 and returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

^self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars:  #()
  classInstVars:  #()
  poolDictionaries: { }
  inDictionary: aDictionary
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  description: nil
  options: #()

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
inDictionary: aDictionary
constraints: constraintSpec [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars:  #()
  poolDictionaries: { }
  inDictionary: aDictionary
  constraints: constraintSpec
  instancesInvariant: false
  isModifiable: false

]

{ #category : 'Deprecated' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
inDictionary: aDictionary
isModifiable: modifyBoolean [

self deprecated: 'Obsolete in GemStone/S 64.  The preferred methods are in the Subclass Creation category (' , aString , ').'.
^self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars:  #()
  classInstVars:  #()
  poolDictionaries: { }
  inDictionary: aDictionary
  constraints:  #()
  instancesInvariant: false
  isModifiable: modifyBoolean

]

{ #category : 'Subclass Creation' }
Class >> subclass: aString
instVarNames: anArrayOfInstvarNames
inDictionary: aDictionary
options: optionsArray [

"Creates and returns a new subclass of the receiver.

 This method is a shortcut for convenience only.  It might not be retained in
 future GemStone releases.  Use it interactively or pedagogically, but avoid
 it in production code.

 The new class has no class variables, no class instance variables,
 and no pool dictionaries.
 Instances of the new class are variant, but the new class itself is not
 modifiable.

 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Executes
   oldClass := aDictionary at:(aString asSymbol) otherwise: nil
 and returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

^self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars:  #()
  classInstVars:  #()
  poolDictionaries: { }
  inDictionary: aDictionary
  newVersionOf: (self _classNamed: aString inDictionary: aDictionary)
  description: nil
  options: optionsArray

]

{ #category : 'Queries' }
Class >> subclasses [

	^ClassOrganizer new subclassesOf: self.

]

{ #category : 'Accessing' }
Class >> thisClass [
  ^ self

]

{ #category : 'Accessing' }
Class >> timeStamp [

"Returns the timestamp instance variable of this class, a DateTime showing when
 the class was created."

^ timeStamp

]

{ #category : 'Updating' }
Class >> timeStamp: aDateTime [

"Set the value of the timeStamp instance variable.
 For use only when creating a class, while the class is not yet invariant."

self _validatePrivilege ifTrue:[
  self isInvariant ifFalse:[
    aDateTime ifNotNil:[ (aDateTime _validateClass: DateTime) ifFalse:[ ^ self]].
    timeStamp := aDateTime
  ] ifTrue:[
    self validateIsVariant .
  ].
].

]

{ #category : 'Accessing' }
Class >> userId [

"Returns the userId instance variable of this class, the ID of the user who
 created this class."

^ userId

]

{ #category : 'Updating' }
Class >> userId: aString [

"Set the value of the userId instance variable.
 For use only when creating a class, while the class is not yet invariant."

(self _validatePrivilege) ifTrue:[
  self isInvariant ifFalse:[
    aString ifNotNil:[ (aString _validateClass: CharacterCollection ) ifFalse:[ ^ self]].
    userId := aString
  ] ifTrue:[
    self validateIsVariant .
  ].
].

]

{ #category : 'Accessing' }
Class >> versionedName [
| ofs str |
(classHistory atOrNil: classHistory size) == self ifTrue:[ ^ name ].
(ofs := classHistory indexOfIdentical: self) ~~ 0 ifTrue:[
  (str := String new) addAll: name ; add: $[ ; add: ofs asString; add:$] .
  ^ str
].
Error signal: 'oop ' , self asOop asString, ', not found in classHistory(oop ' ,
    classHistory asOop asString , $) .

]

{ #category : 'Accessing' }
Class >> versionNumber [
 "Returns a SmallInteger"
  | ofs |
  (ofs := classHistory indexOfIdentical: self) ~~ 0 ifTrue:[
     ^ ofs
  ].
  ^ 1

]
