Extension { #name : 'DoubleByteString' }

{ #category : 'Formatting' }
DoubleByteString class >> charSize [

"Returns number of bytes that make up a character for this string class"

^ 2

]

{ #category : 'Instance Creation' }
DoubleByteString class >> new [

"Returns a new instance of the receiver."

^ self _basicNew

]

{ #category : 'Instance Creation' }
DoubleByteString class >> new: aSize [

"Returns a new instance of the receiver, of sufficient size to hold aSize
 Characters of two bytes each."

^ self _basicNew:  aSize + aSize

]

{ #category : 'Instance Creation' }
DoubleByteString class >> withAll: aString [

"Returns an instance of the receiver or an instance of QuadByteString,
 using the minimum bytes per character required to represent the argument."

<primitive: 456>
^ QuadByteString withAll: aString

]

{ #category : 'Private' }
DoubleByteString >> _basicAt: anInteger put: aValue [

"Disallowed"
self shouldNotImplement: #_basicAt:put:

]

{ #category : 'Private' }
DoubleByteString >> _basicSize: anInteger [

"Disallowed"
self shouldNotImplement: #_basicSize:

]

{ #category : 'Converting' }
DoubleByteString >> _convertToQuadByte [

"Change the receiver from a DoubleByteString to a QuadByteString,
 or from a Unicode16 to Unicode32.  Changes the
 class of the receiver and the receiver's storage structure.
 Returns the receiver."

<primitive: 445>

]

{ #category : 'Concatenating' }
DoubleByteString >> , aCharOrCharColl [

"Returns a new instance of the receiver's class that contains the elements of
 the receiver followed by the elements of aCharOrCharColl.  The argument
 must be a String, a DoubleByteString, or a Character.

 The result may not be an instance of the class of the receiver if one of the
 following rules applies:

 1) If the receiver is a DoubleByteSymbol, the result is a DoubleByteString.

 Warning: Creating a new instance and copying the receiver take time.  If you
 can safely modify the receiver, it can be much faster to use the addAll:
 method.  See the documentation of the Concatenating category of class
 SequenceableCollection for more details."

<primitive: 614 >
^ self copy addAll: aCharOrCharColl; yourself

]

{ #category : 'Adding' }
DoubleByteString >> add: aCharOrCharColl [

"Appends all of the elements of aCharOrCharColl to the receiver and returns
 aCharOrCharColl."

<primitive: 437>
| cSize |
aCharOrCharColl class == Character ifTrue:[ | cp |
  cp := aCharOrCharColl codePoint .
  (cp >= 16rD800 and:[ cp <= 16rDFFF]) ifTrue:[
    ^ OutOfRange signal:'codePoint 16r', cp asHexString ,' is illegal'.
  ].
  cp > 16rFFFF ifTrue:[
    ^ self _convertToQuadByte add: aCharOrCharColl
  ].
  ^ self _primitiveFailed: #add: args: { aCharOrCharColl }
].
(cSize := aCharOrCharColl stringCharSize) == 4 ifTrue:[
  aCharOrCharColl _asDoubleByteString ifNotNil:[ :aString |
    ^ self addAll: aString
  ].
  ^ self _convertToQuadByte addAll: aCharOrCharColl
].
aCharOrCharColl _validateClass: CharacterCollection .
^ self add: aCharOrCharColl asDoubleByteString

]

{ #category : 'Adding' }
DoubleByteString >> addAll: aCharOrCharColl [

"Equivalent to add: aCharOrCharColl."

<primitive: 437>
| cSize |
(cSize := aCharOrCharColl stringCharSize) == 4 ifTrue:[
  aCharOrCharColl _asDoubleByteString ifNotNil:[ :aString |
    ^ self addAll: aString
  ].
  ^ self _convertToQuadByte addAll: aCharOrCharColl
].
aCharOrCharColl class == Character ifTrue:[ | cp |
  cp := aCharOrCharColl codePoint .
  (cp >= 16rD800 and:[ cp <= 16rDFFF]) ifTrue:[
    ^ OutOfRange signal:'codePoint 16r', cp asHexString ,' is illegal'.
  ].
  cp > 16rFFFF ifTrue:[
    ^ self _convertToQuadByte add: aCharOrCharColl
  ].
  ^ self _primitiveFailed: #add: args: { aCharOrCharColl }
].
(aCharOrCharColl isKindOf: CharacterCollection) ifTrue:[
  ^ self add: aCharOrCharColl asDoubleByteString.
].
aCharOrCharColl do: [:each | self add: each].
^aCharOrCharColl.

]

{ #category : 'Adding' }
DoubleByteString >> addCodePoint: aSmallInteger [

<primitive: 1048>
^ self add: (Character codePoint: aSmallInteger).

]

{ #category : 'Adding' }
DoubleByteString >> addLast: aCharOrCharColl [

"Equivalent to add: aCharOrCharColl."

<primitive: 437>
| cSize |
aCharOrCharColl class == Character ifTrue:[ | cp |
  cp := aCharOrCharColl codePoint .
  (cp >= 16rD800 and:[ cp <= 16rDFFF]) ifTrue:[
    ^ OutOfRange signal:'codePoint 16r', cp asHexString ,' is illegal'.
  ].
  cp > 16rFFFF ifTrue:[
    ^ self _convertToQuadByte add: aCharOrCharColl
  ].
  ^ self _primitiveFailed: #add: args: { aCharOrCharColl }
].
(cSize := aCharOrCharColl stringCharSize) == 4 ifTrue:[
  aCharOrCharColl _asDoubleByteString ifNotNil:[ :aString |
    ^ self addAll: aString
  ].
  ^ self _convertToQuadByte addAll: aCharOrCharColl
].
aCharOrCharColl _validateClass: CharacterCollection .
^ self add: aCharOrCharColl asDoubleByteString


]

{ #category : 'Deprecated' }
DoubleByteString >> asciiLessThan: aString [

"Returns true if the receiver collates before the argument using the
 ASCII collating table, which collates AB...Z...ab..z."

self deprecated: 'DoubleByteString>>asciiLessThan: deprecated in 3.2'.

^ self lessThan: aString collatingTable: DoubleByteAsciiCollatingTable

]

{ #category : 'Concatenating' }
DoubleByteString >> asDoubleByteString [
 ^ self

]

{ #category : 'Accessing' }
DoubleByteString >> at: anIndex [

"Returns the Character at anIndex."

<primitive: 435>

(anIndex _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #at: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Accessing' }
DoubleByteString >> atOrNil: anIndex [

"Returns the Character at anIndex, or nil if anIndex is beyond end of the receiver"

<primitive: 435>
(anIndex _isSmallInteger)
  ifTrue: [ ^ nil ]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #atOrNil: args: { anIndex } .
self _uncontinuableError

]


{ #category : 'Updating' }
DoubleByteString >> at: anIndex put: aChar [

"Stores aChar at the specified location and returns aChar."

<primitive: 436>
(aChar class == Character) ifTrue:[ | cp |
  (cp := aChar codePoint) > 16rFFFF ifTrue:[
    ^ self _convertToQuadByte at:anIndex put:aChar
  ].
  (cp >= 16rD800 and:[ cp <= 16rDFFF]) ifTrue:[
    ^ OutOfRange signal:'codePoint 16r', cp asHexString ,' is illegal'.
    ].
] ifFalse:[
  aChar _validateClass: Character .
].
(anIndex _isSmallInteger) ifTrue: [
  ((anIndex > (self size + 1)) or: [anIndex <= 0]) ifTrue: [
    ^ self _errorIndexOutOfRange: anIndex
    ].
] ifFalse:[
  ^ self _errorNonIntegerIndex: anIndex
] .
self _primitiveFailed: #at:put: args: { anIndex . aChar }

]

{ #category : 'Formatting' }
DoubleByteString >> charSize [

"Returns number of bytes that make up a character for this string class."

^ 2

]

{ #category : 'Accessing' }
DoubleByteString >> codePointAt: anIndex [

"Returns the integer value of the Character at anIndex in the receiver."

<primitive: 1072>

(anIndex _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #codePointAt: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
DoubleByteString >> codePointAt: anIndex put: aValue [

"Stores aValue at the specified location, with autogrow, 
 and with auto-conversion of receiver to  QuadByteString if needed.
 Returns aValue.
"
<primitive: 1074>
aValue _validateClass: SmallInteger .
^ self at: anIndex put: (Character withValue: aValue)
]

{ #category : 'Encoding' }
DoubleByteString >> encodeAsUTF16 [

"Encode receiver in UTF16 format.  Returns a Utf16 ."

<primitive: 1084>
self _primitiveFailed: #encodeAsUTF16

]

{ #category : 'Encoding' }
DoubleByteString >> encodeAsUTF8 [

"Encode receiver in UTF8 format. Returns a Utf8 ."

<primitive: 468>
self _primitiveFailed: #encodeAsUTF8

]

{ #category : 'Encoding' }
DoubleByteString >> encodeAsUTF8IntoString [
"Encode receiver in UTF8 format.  Returns a String. For Seaside"

<primitive: 994>
self _primitiveFailed: #encodeAsUTF8IntoString

]

{ #category : 'Adding' }
DoubleByteString >> insertAll: aCharOrCharColl at: anIndex [

"Inserts aCharOrCharColl at the specified index.  Returns aCharOrCharColl."

<primitive: 454>
| cSize |
anIndex _isSmallInteger ifFalse:[ anIndex _validateClass: Integer ].
((anIndex <= 0) or: [anIndex > (self size + 1)])
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].

(cSize := aCharOrCharColl stringCharSize) == 4 ifTrue:[ | aString |
  (aString := aCharOrCharColl _asDoubleByteString )
    ifNil:[ ^ self _convertToQuadByte insertAll: aCharOrCharColl at: anIndex]
    ifNotNil:[ ^ self insertAll: aString at: anIndex ].
].
aCharOrCharColl class == Character ifTrue:[
  ^ self insertAll: aCharOrCharColl asString at: anIndex .
].
aCharOrCharColl _validateClasses: { Character . CharacterCollection }.
^self insertAll: aCharOrCharColl asDoubleByteString at: anIndex.

]

{ #category : 'Copying' }
DoubleByteString >> replaceFrom: startIndex to: stopIndex with: charCollection startingAt: repIndex [

"Replaces the elements of the receiver between the indexes startIndex and
 stopIndex inclusive with the elements of aSeqCollection starting at repIndex.
 If aSeqCollection is identical to the receiver, the source and
 destination blocks may overlap.

 Returns the receiver."

<primitive: 439>
| cSize argInfo recInfo src16 |
startIndex _isSmallInteger ifFalse:[ startIndex _validateClass: SmallInteger ].
stopIndex _isSmallInteger ifFalse:[ stopIndex _validateClass: SmallInteger ].
repIndex _isSmallInteger ifFalse:[ repIndex _validateClass: SmallInteger ].
argInfo := charCollection _stringCharSize .
recInfo := self _stringCharSize .
(recInfo bitAnd: 16r8) ~~ 0 ifTrue:[  "receivier is a Utf string"
  (cSize := argInfo bitAnd: 16r7) > 1 ifTrue:[
    src16 := charCollection _asUnicode16 .
    (src16 ~~ nil and:[ src16 ~~ charCollection]) ifTrue:[
      ^ self replaceFrom: startIndex to: stopIndex with: src16 startingAt: repIndex
    ].
    ^ self _convertToQuadByte
     replaceFrom: startIndex to: stopIndex with: charCollection startingAt: repIndex
  ].
].
(cSize := argInfo bitAnd: 16r7) == 4 ifTrue:[
   src16 := charCollection _asDoubleByteString .
   (src16 ~~ nil and:[ src16 ~~ charCollection]) ifTrue:[
      ^ self replaceFrom: startIndex to: stopIndex with: src16 startingAt: repIndex
   ].
   ^ self _convertToQuadByte replaceFrom: startIndex to: stopIndex
                        with: charCollection startingAt: repIndex
].
^ super replaceFrom: startIndex to: stopIndex with: charCollection startingAt: repIndex

]

{ #category : 'Accessing' }
DoubleByteString >> size [

"Returns the number of Characters in the receiver."

^ self _basicSize // 2.

]

{ #category : 'Updating' }
DoubleByteString >> size: anInteger [

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to
 codePoint zero."

^ super _basicSize: anInteger + anInteger

]
