Extension { #name : 'DoubleByteSymbol' }

{ #category : 'Instance Creation' }
DoubleByteSymbol class >> _basicNew [
^ self shouldNotImplement: #_basicNew

]

{ #category : 'Instance Creation' }
DoubleByteSymbol class >> _basicNew: aSize [
^ self shouldNotImplement: #_basicNew:

]

{ #category : 'Class Membership' }
DoubleByteSymbol class >> _classHistoryIncludesIdentical: aClass [
  ^ aClass == Symbol or:[ aClass == DoubleByteSymbol or:[ aClass == QuadByteSymbol]]

]

{ #category : 'Instance Creation' }
DoubleByteSymbol class >> _existingWithAll: aString [

"Return an existing canonical symbol that has the same value as 'aString'.
 If no such Symbol or DoubleByteSymbol already exists, returns nil."

<primitive: 310>
^ Symbol _existingWithAll: aString

]

{ #category : 'Instance Creation' }
DoubleByteSymbol class >> _newString [

"Return a new instance of DoubleByteString."

^ DoubleByteString new

]

{ #category : 'Instance Creation' }
DoubleByteSymbol class >> _newString: aSize [

"Return a new instance of DoubleByteString of the specified size."

^ DoubleByteString new: aSize

]

{ #category : 'Class Membership' }
DoubleByteSymbol class >> isSubclassOf: aClassHistoryOrClass [

  (self _classHistoryIncludesIdentical: aClassHistoryOrClass) ifTrue:[ ^ true].
  ^ super isSubclassOf: aClassHistoryOrClass

]

{ #category : 'Storing and Loading' }
DoubleByteSymbol class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| theSize str marker result |

"since Symbols can't refer to other objects, the 'hasRead:' message
 may be sent after values have been filled in."

theSize := passiveObj readSize .
str := String new .
marker := passiveObj objectPositionMarker .
passiveObj next: theSize bytesTo: str ;
           next .
result :=  (str _changeClassToMultiByte: DoubleByteString) asSymbol .
passiveObj hasRead: result marker: marker .
^ result

]

{ #category : 'Instance Creation' }
DoubleByteSymbol class >> migrateNew [

"Override default migrateNew behavior with #_basicNew."

^ self _basicNew

]

{ #category : 'Instance Creation' }
DoubleByteSymbol class >> new [

"Disallowed.  To create a new DoubleByteSymbol, use the class method
 #withAll: instead."

self shouldNotImplement: #new

]

{ #category : 'Instance Creation' }
DoubleByteSymbol class >> new: size [

"Disallowed.  To create a new DoubleByteSymbol, use the class method #withAll:
 instead."

self shouldNotImplement: #new:

]

{ #category : 'Instance Creation' }
DoubleByteSymbol class >> withAll: aString [

"Returns a canonical symbol that has the same Characters as aString."

<primitive: 300>
^ Symbol withAll: aString

]

{ #category : 'Decompiling without Sources' }
DoubleByteSymbol >> _asSource [

| result |
result := String new .
result add: $#  .
result addAll: super _asSource .
^ result

]

{ #category : 'New Indexing Comparison' }
DoubleByteSymbol >> _idxForCompareEqualTo: arg [

""

^arg _idxForCompareEqualToDoubleByteSymbol: self

]

{ #category : 'New Indexing Comparison' }
DoubleByteSymbol >> _idxForCompareEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ aCharacterCollection _idxForCompareEqualToDoubleByteSymbol: self

]

{ #category : 'New Indexing Comparison - for Compare' }
DoubleByteSymbol >> _idxForCompareEqualToCharacterCollection: aCharacterCollection [
  "second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:."

  ^ false

]

{ #category : 'New Indexing Comparison - for Compare' }
DoubleByteSymbol >> _idxForCompareEqualToUnicode: aUnicodeString collator: aCollator [
"second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:collator:."

  ^ false

]

{ #category : 'New Indexing Comparison' }
DoubleByteSymbol >> _idxForSortEqualTo: arg [
  ""

  ^ arg _idxForSortEqualToSymbol: self

]

{ #category : 'New Indexing Comparison' }
DoubleByteSymbol >> _idxForSortEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ self asString
    _idxForSortEqualTo: aCharacterCollection
    collator: anIcuCollator

]

{ #category : 'New Indexing Comparison' }
DoubleByteSymbol >> _idxForSortEqualToSymbol: aSymbol [
  "second half of a double dispatch call from Symbol>>_idxForSortEqualTo:."

  ^ self asString _idxPrimCompareEqualTo: aSymbol asString

]

{ #category : 'New Indexing Comparison' }
DoubleByteSymbol >> _idxForSortNotEqualTo: aCharacterCollection collator: anIcuCollator [
  ""

  ^ (self _idxForSortEqualTo: aCharacterCollection collator: anIcuCollator) not

]

{ #category : 'Converting' }
DoubleByteSymbol >> -> anObject [

"Returns a SymbolAssociation with the receiver as the key and the given object
 as the value."

^ SymbolAssociation newWithKey: self value: anObject

]

{ #category : 'Concatenating' }
DoubleByteSymbol >> , aCharOrCharCollection [

"Returns a new instance of DoubleByteString that contains the elements of
 the receiver followed by the elements of aCharOrCharCollection.
 A DoubleByteString is returned rather than a DoubleByteSymbol to avoid
 the expense of unnecessary creation and canonicalization of Symbols."

^ ((self _unicodeCompareEnabled ifTrue:[ Unicode16 ] ifFalse:[ DoubleByteString])
    withAll: self) addAll: aCharOrCharCollection ; yourself

]

{ #category : 'Comparing' }
DoubleByteSymbol >> = anObject [

"Returns true if anObject is equal to the receiver.  Since symbols
 are canonicalized, this method does the check based on the
 identities of the receiver and the argument."

^ self == anObject.

]

{ #category : 'Comparing' }
DoubleByteSymbol >> ~= aCharCollection [

"This method can be optimized for symbols since they are canonical."

^ self ~~ aCharCollection

]

{ #category : 'Compatiblity' }
DoubleByteSymbol >> argumentCount [

 ^ self numArgs

]

{ #category : 'Converting' }
DoubleByteSymbol >> asDoubleByteString [

"Returns a copy of the receiver as a DoubleByteString."

^ DoubleByteString withAll: self.

]

{ #category : 'Converting' }
DoubleByteSymbol >> asString [

"Returns a copy of the receiver as a String."

^ String withAll: self.

]

{ #category : 'Converting' }
DoubleByteSymbol >> asSymbol [

"Returns the receiver.  All Symbols and DoubleByteSymbols are canonical."

^ self

]

{ #category : 'Converting' }
DoubleByteSymbol >> asSymbolKind [

"Returns the receiver.  All Symbols and DoubleByteSymbols are canonical."

^ self

]

{ #category : 'Clustering' }
DoubleByteSymbol >> cluster [

"Has no effect.  Clustering of DoubleByteSymbols is only performed by
 the clusterAllSymbols method in class System . "

^ true

]

{ #category : 'Clustering' }
DoubleByteSymbol >> clusterInBucket: aClusterBucketOrId [

"Has no effect.  Clustering of Symbols is only performed by
 the clusterAllSymbols method in class System . "

^ true

]

{ #category : 'Copying' }
DoubleByteSymbol >> copy [

"Returns self.  Copies of (canonical) double byte symbols are not allowed."

^ self

]

{ #category : 'Copying' }
DoubleByteSymbol >> copyReplacing: oldObject withObject: newObject [
	"Returns a String comprising a copy of the receiver in which all occurrences
	 of objects equal to oldObject have been replaced by newObject."

	^self asDoubleByteString copyReplacing: oldObject withObject: newObject

]

{ #category : 'Comparing' }
DoubleByteSymbol >> hash [

"Returns a numeric hash key for the receiver."

^ self identityHash

]

{ #category : 'Converting' }
DoubleByteSymbol >> keywords [

"Returns an Array of the keywords in the receiver, treating
 any colon-delimited segment as if it was a legal keyword."

^ Symbol _keywords: self

]

{ #category : 'Testing' }
DoubleByteSymbol >> precedence [

"Returns the precedence of the receiver, were it a message selector, with
 1=unary, 2=binary and 3=keyword."

^ self isInfix
    ifTrue: [ 2 ]
    ifFalse: [ self isKeyword ifTrue: [ 3 ]
                              ifFalse: [ 1 ] ]

]

{ #category : 'Formatting' }
DoubleByteSymbol >> printOn: aStream [

"Puts a displayable representation of the receiver on the given stream.
 That representation conforms to GemStone Smalltalk parsing rules."

aStream nextPut: $# .
super printOn: aStream

]

{ #category : 'Copying' }
DoubleByteSymbol >> shallowCopy [

"Returns self.  Copies of (canonical) double byte symbols are not allowed."

^ self

]

{ #category : 'Class Membership' }
DoubleByteSymbol >> species [

"Returns a class similar to, or the same as, the receiver's class which
 can be used for containing derived copies of the receiver."

^ DoubleByteString

]

{ #category : 'Private' }
DoubleByteSymbol >> speciesForConversion [

^ DoubleByteString .

]

{ #category : 'Formatting' }
DoubleByteSymbol >> withNoColons [

"Returns a String containing the value of the receiver with all colons removed.

 A String is returned rather than a symbol to avoid the expense of unnecessary
 creation and canonicalization of symbols."

^ self copyWithout: $:   .

]
