Extension { #name : 'EqualityCollisionBucket' }

{ #category : 'Searching' }
EqualityCollisionBucket >> at: aKey put: aValue keyValDict_coll: aKeyValDict [
 "Stores the aKey/aValue pair in the receiver.
  Returns self size if this at:put: added a new key, 0 if this at:put:
  replaced the value of an existing key."
 | emptySlotIdx startTableSize thisKey numElem |

  startTableSize := self tableSize .
  aKey ifNil:[ ^ self _error: #rtErrNilKey ] .
  (numElem := numElements) == 0 ifTrue:[
    emptySlotIdx := 1
  ] ifFalse:[ | idx |
    "search for aKey, or for the first empty slot "
    idx := 1 .
    1 to: startTableSize do:[:n |
      thisKey := self _at: idx . "inline keyAt:"
      thisKey ifNotNil:[
        (aKey = thisKey) ifTrue:[ "Key found.  Store given value"
          self _at: idx + 1 put: aValue .  "inline at:putValue:"
          aKeyValDict _markDirty .
          ^ 0
        ].
      ] ifNil:[
        emptySlotIdx ifNil:[ emptySlotIdx := idx ].
      ].
      idx := idx + 2 .
    ] .
    "Key not found so add key and value"
    emptySlotIdx ifNil:[ " bucket is full so grow it "
      emptySlotIdx := self _basicSize + 1 .
      self size: emptySlotIdx + 7  .  "accommodate 4 more key,value pairs"
    ] .
  ].
  numElem := numElem + 1 .
  numElements := numElem .
  self _at: emptySlotIdx put: aKey. "inline at:putKey:"
  self _at: emptySlotIdx + 1 put: aValue . "inline at:putValue"
  ^ numElem

]

{ #category : 'Private' }
EqualityCollisionBucket >> compareKey: key1 with: key2 [

"Not used by implementation of EqualityCollisionBucket"

self shouldNotImplement: #compareKey:with:

]

{ #category : 'Searching' }
EqualityCollisionBucket >> searchForKey: argKey [

"Returns the index of argKey, or if not found, nil."
   | idx |
   argKey ifNil:[ ^ self _error: #rtErrNilKey ] .
   idx := 1 .
   1 to: self tableSize do: [ :n | | aKey |
      aKey := self _at: idx . "inline keyAt:"
      aKey ifNotNil:[
        argKey = aKey ifTrue:[ ^ n ].
      ].
      idx := idx + 2
   ].
   ^ nil "Key not found"

]
