Extension { #name : 'Fraction' }

{ #category : 'Storing and Loading' }
Fraction class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst num den |
inst := Fraction _basicNew .
passiveObj hasRead: inst.
passiveObj readNamedIV.
num := passiveObj ivValue.
passiveObj readNamedIV.
den := passiveObj ivValue.

passiveObj skipNamedInstVars.

inst _numerator: num denom: den .
^inst.

]

{ #category : 'Private' }
Fraction >> _numerator: n denom: d [
  numerator := n .
  denominator := d .
  ^ self immediateInvariant

]

{ #category : 'Converting' }
Fraction >> asCanonicalForm [
	"Answer self, or, if I am a Fraction with an equivalent
	SmallFraction, answer that SmallFraction.

	Note: SmallFraction inherits Object >> asCanonicalForm."

	| cls res |
	(cls := self class) == Fraction
		ifTrue: [ 
			res := cls _newSmallFraction: numerator denom: denominator reduce: true.
			res class == SmallFraction
				ifTrue: [ ^ res ] ].
	^ self
]

{ #category : 'Accessing' }
Fraction >> denominator [

"Returns the denominator of the receiver."

^ denominator

]

{ #category : 'Accessing' }
Fraction >> instVarAt: anIndex put: aValue [

"Disallowed.  You may not change the value of a Fraction."

self shouldNotImplement: #instVarAt:put:

]

{ #category : 'Accessing' }
Fraction >> numerator [

"Returns the numerator of the receiver."

^ numerator

]

{ #category : 'Copying' }
Fraction >> postCopy [
  ^ self immediateInvariant

]

{ #category : 'Storing and Loading' }
Fraction >> writeTo: passiveObj [

"Converts the receiver to its passive form and writes that information on
 passiveObj."

"Reimplemented from Number since the receiver has a non-literal representation."

^super basicWriteTo: passiveObj

]
