Extension { #name : 'IdentityCollisionBucket' }

{ #category : 'Instance Creation' }
IdentityCollisionBucket class >> new [

^ self new: 0

]

{ #category : 'Private' }
IdentityCollisionBucket >> _validateSortedKeys [

"Private."

| prevOop thisOop |
prevOop := 0 .
1 to: numElements * 2 by: 2 do:[:j |
   thisOop := (self basicAt: j) asOop .
   thisOop <= prevOop
      ifTrue:[ self _halt:'IdentityCollisionBucket not sorted' ].
   prevOop := thisOop
   ].

]

{ #category : 'Private' }
IdentityCollisionBucket >> at: aKey put: aValue keyValDict_coll: aKeyValDict [

"Private.  Adds the key-value pair (aKey, aValue) to the collision bucket.
 Returns 0 if this at:put: replaced the value for an existing  key ,
 Returns self size if this at:put: added a value ."

| marker |

aKey == nil ifTrue:[ ^ self _error: #rtErrNilKey ] .

marker := self binarySearchForInsertKey: aKey.
marker < 0 ifTrue:[ "replace existing key"
  self at: marker negated putValue: aValue.
  aKeyValDict _markDirty .
  ^ 0
  ].
(numElements >= 974) ifTrue:[
  aKeyValDict _rebuildAt: aKey put: aValue .
  ^ 0
  ].
^ self insertAt: marker key: aKey value: aValue.

]

{ #category : 'Searching' }
IdentityCollisionBucket >> binarySearchForInsertKey: aKey [

"Returns the negated index of aKey if found, or the offset at which to
 insert aKey."

"Does a binary search."

<primitive: 448>
aKey == nil ifTrue:[ ^ self _error: #rtErrNilKey ] .
self _primitiveFailed: #binarySearchForInsertKey: args: { aKey }

]

{ #category : 'Private' }
IdentityCollisionBucket >> compareKey: key1 with: key2 [

"Returns true if key1 is identical to key2, and false otherwise."

^ key1 == key2

]

{ #category : 'Private' }
IdentityCollisionBucket >> insertAt: marker key: aKey value: aValue [

"Private.  Inserts the given key-value pair (aKey, aValue) at the
 position marker."

  self insertAll: { aKey . aValue } at: (marker + marker - 1).
  numElements := numElements + 1.
  ^ numElements

]

{ #category : 'Removing' }
IdentityCollisionBucket >> removeKey: aKey ifAbsent: aBlock [

"Removes the key/value pair having the key aKey.  If aKey is not found,
 returns the result of evaluating the zero-argument block aBlock."

  | keyIndex valueOffset aValue |
  keyIndex := self searchForKey: aKey.
  keyIndex == nil
    ifFalse: [
      numElements := numElements - 1.
      aValue := self valueAt: keyIndex.
      valueOffset := keyIndex + keyIndex .
      self removeFrom: valueOffset - 1 to: valueOffset .
      ^aValue
      ]
    ifTrue: [ ^ self _reportKeyNotFound: aKey with: aBlock ]

]

{ #category : 'Removing' }
IdentityCollisionBucket >> removeKey: aKey otherwise: notFoundValue [

"Removes the key/value pair having the key aKey.  If aKey is not found,
 returns the notFoundValue. "

  | keyIndex valueOffset aValue |
  keyIndex := self searchForKey: aKey.
  keyIndex == nil
    ifFalse: [
      numElements := numElements - 1.
      aValue := self valueAt: keyIndex.
      valueOffset := keyIndex + keyIndex .
      self removeFrom: valueOffset - 1 to: valueOffset .
      ^aValue
      ]
    ifTrue: [ ^ notFoundValue ].

]

{ #category : 'Searching' }
IdentityCollisionBucket >> searchForKey: aKey [

"Returns the index of aKey, or nil if not found."

"Does a binary search."

<primitive: 391>
aKey == nil ifTrue:[ ^ self _error: #rtErrNilKey ] .
self _primitiveFailed: #searchForKey: args: { aKey }

]
