Extension { #name : 'IdentitySet' }

{ #category : 'Updating Indexes - Private' }
IdentitySet >> _cleanUpDependencies [

"The receiver is having all of its indexes removed.  Remove dependency
 list entries for objects along the path of the indexes.

 Optimized version for IdentitySet where we don't worry about duplicates."

| rootTerms iList rootTermsSize |

iList := self _indexedPaths.
rootTerms := iList rootTerms.
rootTermsSize := rootTerms size .

1 to: self size do: [ :i | | obj |
  obj := self _at: i.
  1 to: rootTermsSize do: [ :j |
        (rootTerms at: j) cleanupDependencyListFor: obj
   ].
].

iList hasTrackingObjects
  ifTrue: [ iList removeAllIndexesFor: self ]
  ifFalse: [ self _indexedPaths: nil ].

" resize the Array of path terms to avoid object audit errors "
rootTerms size: 0.

]

{ #category : 'Set Arithmetic' }
IdentitySet >> _union: aBagOrSet [

^ self + aBagOrSet

]

{ #category : 'Adding' }
IdentitySet >> add: anObject withOccurrences: anInteger [

"Disallowed.  Each element of an IdentitySet must be unique."

self shouldNotImplement: #add:withOccurrences:

]

{ #category : 'Adding' }
IdentitySet >> addAll: aCollection [

"Adds each element of aCollection to the receiver only if the element is not
 already present in the receiver.  Occurrences of nil in aCollection are not
 added to the receiver."

^ super addAll: aCollection

]

{ #category : 'Adding' }
IdentitySet >> addValue: anObject [

"Adds anObject to the receiver only if it is not already an element of the
 receiver, and if the receiver does not contain an equivalent object.  Has no
 effect if anObject is nil.  Returns anObject."

(self includesValue: anObject) ifFalse:[ self add: anObject ].
^ anObject

]

{ #category : 'Converting' }
IdentitySet >> asIdentitySet [

"Returns an IdentitySet with the contents of the receiver."

^ self.

]

{ #category : 'Converting' }
IdentitySet >> asSet [

^Set withAll: self

]
