Extension { #name : 'LockError' }

{ #category : 'Instance initialization' }
LockError >> _legacyHandlerArgs [
  | arr |
  (arr := { object } ) addAll: super _legacyHandlerArgs .
  ^ arr

]

{ #category : 'Instance initialization' }
LockError >> args: anArray [
  anArray _isArray ifTrue:[ | sz |
    object := anArray atOrNil: 1 .
    (sz := anArray size) > 1 ifTrue:[
      gsArgs := anArray copyFrom:2 to: sz
    ].
  ]

]

{ #category : 'Formatting' }
LockError >> buildMessageText [
^ self buildMessageText:(
  [
    gsDetails ifNotNil:[:s| s asString ]
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
LockError >> initialize [
  gsNumber := ERR_LockError.
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Accessing' }
LockError >> object [
  ^ object

]

{ #category : 'Instance initialization' }
LockError >> object: anObj [

  object := anObj

]
