Extension { #name : 'LookupError' }

{ #category : 'Instance initialization' }
LookupError >> _legacyHandlerArgs [
  | arr |
  arr := { object . key } .
  gsArgs ifNotNil:[:a |  arr addAll: a ].
  ^ arr

]

{ #category : 'Instance initialization' }
LookupError >> args: anArray [
  anArray _isArray ifTrue:[ | sz |
    object := anArray atOrNil: 1 .
    key := anArray atOrNil: 2 .
    (sz := anArray size) > 2 ifTrue:[
      gsArgs := anArray copyFrom: 3 to: sz
    ].
  ]

]

{ #category : 'Formatting' }
LookupError >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    gsDetails ifNotNil:[ :gsd |
      str := String new .
      object ifNotNil:[:o | str add: ' accessing a '; add: o class name ].
      key ifNotNil:[:k|
        (str := String withAll:', ') add: k asString
      ].
      str add: ', ' ; add: gsd  asString .
    ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
LookupError >> initialize [
  gsNumber := ERR_LookupError.
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Instance initialization' }
LookupError >> key: anObject [
  key := anObject

]
