Extension { #name : 'MigrationError' }

{ #category : 'Accessing' }
MigrationError class >> errorNumber [
  ^ ERR_MigrationError

]

{ #category : 'Instance initialization' }
MigrationError >> args: anArray [
  anArray _isArray ifTrue:[ | sz |
    object := anArray atOrNil: 1 .
    (sz := anArray size) > 1 ifTrue:[
      gsArgs := anArray copyFrom:2 to: sz
    ].
  ]

]

{ #category : 'Formatting' }
MigrationError >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    (str := String withAll:'object=a ') add: object class versionedName .
    gsDetails ifNotNil:[:d| str add:', '; add: d  asString ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
MigrationError >> initialize [
  gsNumber := ERR_MigrationError .
  gsResumable := false .
  gsTrappable := true .

]

{ #category : 'Accessing' }
MigrationError >> object [
  ^ object

]

{ #category : 'Instance initialization' }
MigrationError >> object: anObject [
  object := anObject

]
