Extension { #name : 'NameError' }

{ #category : 'Signaling' }
NameError class >> signalNotImplemented [
  "Signal that the sender of this method is 'not implemented' "
   ^ self new selector: ((GsProcess methodAt: 2) selector) ; 
              signal:'not implemented'.

]

{ #category : 'Instance initialization' }
NameError >> _legacyHandlerArgs [
  | arr |
  (arr := { selector } ) addAll: super _legacyHandlerArgs .
  ^ arr

]

{ #category : 'Instance initialization' }
NameError >> args: anArray [
  anArray _isArray ifTrue:[ | sz |
    selector := anArray atOrNil: 1 .
    (sz := anArray size) > 1 ifTrue:[
      gsArgs := anArray copyFrom:2 to: sz
    ].
  ]

]

{ #category : 'Formatting' }
NameError >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    str := String new .
    selector ifNotNil:[:s| str add: s asString ] .
    gsDetails ifNotNil:[:d| str add:', '; add: d  asString ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
NameError >> initialize [
  gsNumber := ERR_NameError.
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Accessing - failedMessage' }
NameError >> selector [
  ^ selector

]

{ #category : 'Accessing - failedMessage' }
NameError >> selector: aSymbol [
  selector := aSymbol

]
