Extension { #name : 'OutOfRange' }

{ #category : 'Instance initialization' }
OutOfRange >> _legacyHandlerArgs [
  | arr |
  arr := { object . minimum . maximum . actual } .
  gsArgs ifNotNil:[:a |  arr add: a ].
  ^ arr

]

{ #category : 'Instance initialization' }
OutOfRange >> args: anArray [
  anArray _isArray ifTrue:[ | sz |
    object := anArray atOrNil: 1 .
    minimum := anArray atOrNil: 2 .
    maximum := anArray atOrNil: 3 .
    actual := anArray atOrNil: 4 .
    (sz := anArray size) > 4 ifTrue:[
      gsArgs := anArray at: 5 .
    ].
  ]

]

{ #category : 'Formatting' }
OutOfRange >> buildMessageText [
^ self buildMessageText:(
  [
    | str |
    str := String new .
    object ifNotNil:[:o |
       o _isOneByteString ifTrue:[ str add: 'for '; add: o quoted]
         ifFalse:[ str add: 'for a '; add: o class name].
    ].
    gsArgs "argName" ifNotNil:[:a|
          str size > 0 ifTrue:[ str add:', ' ].
          str add: ' the value for '; add: a asString ;
		      add: ' is ' ; add: actual asString ]
       ifNil:[ actual ifNotNil: [:a | str add: a asString ] ].
    minimum ifNotNil: [
	   maximum ifNotNil:[ str add: ' should be between ';
                   add: minimum asString; add: ' and '; add: maximum asString ]
		      ifNil: [str add: ' minimum is '; add: minimum asString]
    ] ifNil: [
	     maximum ifNotNil: [str add: ' maximum is '; add: maximum asString]
    ].
    gsDetails ifNotNil: [:arg | str add: ', '; add: arg asString] .
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
OutOfRange >> expectedNumArgs: aNumber actual: aValue [
  minimum := aNumber .
  maximum := aNumber .
  actual := aValue

]

{ #category : 'Instance initialization' }
OutOfRange >> initialize [
  gsNumber := ERR_OutOfRange.
  gsResumable := true .
  gsTrappable := true .

]

{ #category : 'Instance initialization' }
OutOfRange >> name: aName max: aMax actual: aValue [
  gsArgs := aName .
  maximum := aMax .
  actual := aValue

]

{ #category : 'Instance initialization' }
OutOfRange >> name: aName min: aMin actual: aValue [
  gsArgs := aName .
  minimum := aMin .
  actual := aValue

]

{ #category : 'Instance initialization' }
OutOfRange >> name: aName min: aMin max: aMax actual: aValue [
  gsArgs := aName .
  minimum := aMin .
  maximum := aMax .
  actual := aValue

]
