Extension { #name : 'SocketError' }

{ #category : 'Formatting' }
SocketError >> buildMessageText [
^ self buildMessageText:(
  [ | str |
    "get the details from error 2362 thrown from a primitive"
    str := 'socket error ' copy .
    1 to: gsArgs size  do:[:n | | elem |
      elem := gsArgs atOrNil: n .
      (elem _isSymbol or:[ elem _isOneByteString]) ifTrue:[ str add: elem ]
         ifFalse:[  elem _isSmallInteger ifTrue:[ str add: elem asString ]
            ifFalse:[ str add: 'a ' ; add: elem class name ]].
      n < gsArgs size ifTrue:[ str add: ', ' ]
    ].
    gsDetails ifNotNil:[:d| str add:', '; add: d  asString ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)

]

{ #category : 'Instance initialization' }
SocketError >> initialize [
  gsNumber := ERR_SocketError.
  gsResumable := true .
  gsTrappable := true .

]
