Extension { #name : 'UndefinedObject' }

{ #category : 'Instance Creation' }
UndefinedObject class >> fromStream: aStream [

"If the next Characters in aStream are nil (case-insensitive), returns nil.
 Otherwise, generates an error."

| ch |

self _checkReadStream: aStream forClass: CharacterCollection.

ch := aStream next.
[ ch == $  ]
whileTrue:
  [ ch := aStream next ].
aStream skip: -1.

(((aStream next isEquivalent: $N)
 and: [aStream next isEquivalent: $I ])
 and: [aStream next isEquivalent: $L ])
ifTrue:
  [ ^ nil ]
ifFalse:
  [ self _errIncorrectFormat: aStream ]

]

{ #category : 'Instance Creation' }
UndefinedObject class >> fromString: aString [

"If the first three Characters in aString are nil (case-insensitive), returns
 nil.  Otherwise, generates an error."

| s result |

s := ReadStream on: aString.
result := self fromStream: s.
[ s atEnd ]
whileFalse:
  [ (s next == $  )
    ifFalse:
      [ self _errIncorrectFormat: aString ]
  ].
^ result

]

{ #category : 'Storing and Loading' }
UndefinedObject class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

"This method supports activation of passive objects written by a GeODE
 version earlier than 2.0.1."

passiveObj hasRead: nil.
^nil

]

{ #category : 'Instance Creation' }
UndefinedObject class >> new [

"Disallowed.  You cannot create new instances of UndefinedObject."

self shouldNotImplement: #new

]

{ #category : 'Decompiling without Sources' }
UndefinedObject >> _asSource [

""

^ self asString

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _classSortOrdinal [

^ 0

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareEqualTo: aCharacterCollection collator: collator [
  ""

  ^ self _idxForCompareEqualTo: aCharacterCollection

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareGreaterThan: arg [

""

^arg _idxForCompareUndefinedObjectGreaterThanSelf: self

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareGreaterThan: aCharacterCollection collator: collator [
  ""

  ^ self _idxForCompareGreaterThan: aCharacterCollection

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareGreaterThanOrEqualTo: arg [

""

^arg _idxForCompareUndefinedObjectGreaterThanOrEqualToSelf: self

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareGreaterThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any >= comparison"

  ^ self _idxForCompareUndefinedObjectGreaterThanOrEqualToSelf: aUnicodeString

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareGreaterThanUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThan:collator:. Note that aUnicodeString should be the receiver in any > comparison"

  ^ self _idxForCompareGreaterThan: aUnicodeString

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareLessThan: arg [

""

^arg _idxForCompareUndefinedObjectLessThanSelf: self

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareLessThanOrEqualTo: arg [

""

^arg _idxForCompareUndefinedObjectLessThanOrEqualToSelf: self

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareLessThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any <= comparison"

  ^ self _idxForCompareLessThanOrEqualTo: aUnicodeString

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForCompareLessThanUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThan:collator:. Note that aUnicodeString should be the receiver in any < comparison"

  ^ self _idxForCompareLessThan: aUnicodeString

]

{ #category : 'New Indexing Comparison - for Compare' }
UndefinedObject >> _idxForCompareUndefinedObjectGreaterThanOrEqualToSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForCompareGreaterThanOrEqualTo:."

^true

]

{ #category : 'New Indexing Comparison - for Compare' }
UndefinedObject >> _idxForCompareUndefinedObjectGreaterThanSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForCompareGreaterThan:."

^false

]

{ #category : 'New Indexing Comparison - for Compare' }
UndefinedObject >> _idxForCompareUndefinedObjectLessThanOrEqualToSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForCompareLessThanOrEqualTo:."

^true

]

{ #category : 'New Indexing Comparison - for Compare' }
UndefinedObject >> _idxForCompareUndefinedObjectLessThanSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForCompareLessThan:."

^false

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForSortEqualTo: aCharacterCollection collator: collator [
  ""

  ^ self _idxForSortEqualTo: aCharacterCollection

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForSortGreaterThan: arg [

""

^arg _idxForSortUndefinedObjectGreaterThanSelf: self

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForSortGreaterThanOrEqualTo: arg [

""

^arg _idxForSortUndefinedObjectGreaterThanOrEqualToSelf: self

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForSortLessThan: arg [

""

^arg _idxForSortUndefinedObjectLessThanSelf: self

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForSortLessThan: aCharacterCollection collator: collator [
  ""

  ^ self _idxForSortLessThan: aCharacterCollection

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForSortLessThanOrEqualTo: arg [

""

^arg _idxForSortUndefinedObjectLessThanOrEqualToSelf: self

]

{ #category : 'New Indexing Comparison' }
UndefinedObject >> _idxForSortLessThanOrEqualTo: aCharacterCollection collator: collator [
  ""

  ^ self _idxForSortLessThanOrEqualTo: aCharacterCollection

]

{ #category : 'New Indexing Comparison - for Sort' }
UndefinedObject >> _idxForSortUndefinedObjectGreaterThanOrEqualToSelf: anObject [

"second half of a double dispatch call from UndefinedObject>>_idxForSortGreaterThanOrEqualTo:. Note that anUndefinedObject should be the receiver in any >= comparison"

^true

]

{ #category : 'New Indexing Comparison - for Sort' }
UndefinedObject >> _idxForSortUndefinedObjectGreaterThanSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForSortGreaterThan:. Note that anUndefinedObject should be the receiver in any > comparison"

^false

]

{ #category : 'New Indexing Comparison - for Sort' }
UndefinedObject >> _idxForSortUndefinedObjectLessThanOrEqualToSelf: anUndefinedObject [

"second half of a double dispatch call from UndefinedObject>>_idxForSortLessThanOrEqualTo:. Note that anUndefinedObject should be the receiver in any <= comparison"

^true

]

{ #category : 'New Indexing Comparison - for Sort' }
UndefinedObject >> _idxForSortUndefinedObjectLessThanSelf: anObject [

"second half of a double dispatch call from UndefinedObject>>_idxForSortLessThan:. Note that anUndefinedObject should be the receiver in any < comparison"

^false

]

{ #category : 'Filein Support' }
UndefinedObject >> _newKernelSubclass: clsName
instVarNames: ivArg
classVars: classVarArg
classInstVars: classInstVarArg
poolDictionaries: poolDicts
inDictionary: aDict
options: options
reservedOop: reservedOopNum [

"Creates a new class only if a class with the given name does not already exist
 in Globals.  Returns the new class, old class or nil."

| result theClass superClassOffset |

result := Object
  _newKernelSubclass: clsName
  subclassOf: self
  instVarNames: ivArg
  classVars: classVarArg
  classInstVars: classInstVarArg
  poolDictionaries: poolDicts
  inDictionary: aDict
  options: options
  reservedOop: reservedOopNum .

result ifNotNil:[ "change superclass to nil"
  theClass := result .
  superClassOffset := (Behavior _ivOffsetOf: #superClass) .
  (theClass instVarAt: superClassOffset) ifNotNil:[
    theClass _unsafeAt: superClassOffset put: nil .
    theClass class _unsafeAt: superClassOffset put: Object class superClass  .
  ].
].
^ result

]

{ #category : 'Formatting' }
UndefinedObject >> asString [

"Returns the string 'nil'."

self == nil ifTrue:[ ^ String withAll:'nil' ].
"#_remoteNil  is a key in Globals"
self == _remoteNil ifTrue:[ ^ String withAll:'remoteNil' ].

"following are normally only seen by stack printing code in GsProcess.
 and are defined as class variables in UndefinedObject."
self == _exceptionMarkNil ifTrue:[ ^ String withAll:'_exceptionMarkNil' ].
self == _gsExcHandlerMarkNil ifTrue:[ ^ String withAll:'_gsExcHandlerMarkNil' ].
self == _ensureMarkNil ifTrue:[ ^ String withAll:'_ensureMarkNil' ].
self == _rfhMarkNil ifTrue:[ ^ String withAll:'_rfhMarkNil' ].
self == _rfhGsExcHandlerMarkNil ifTrue:[ ^ String withAll:'_rfhGsExcHandlerMarkNil' ].
self == _tosIsIpNil ifTrue:[ ^ String withAll:'_tosIsIpNil' ].
self asOop == 2324 ifTrue:[ ^ String withAll:'_noResultNil' ].
self == _executeHandlerMarkNil ifTrue:[ ^ String withAll:'_executeHandlerMarkNil' ].
self == _reenterMarkNil ifTrue:[ ^ String withAll:'_reenterMarkNil' ].
self == _syncExceptionMarkNil ifTrue:[ ^ String withAll:'_syncExceptionMarkNil'].

  "following instances should not be visible to application code
   unless an internal error occurs during VM execution."
self == _partialContinuaLoadMarkNil ifTrue:[ ^ String withAll:'_partialContinuaLoadMarkNil' ].
^ 'unrecognized instance of UndefinedObject, oop ' , self asOop asString .

]

{ #category : 'Clustering' }
UndefinedObject >> clusterDepthFirst [

"Returns true.  (Because nil is a self-defining object, this method has no
 effect.)"

^ true

]

{ #category : 'Storing and Loading' }
UndefinedObject >> containsIdentity [

"Private."

^true

]

{ #category : 'Copying' }
UndefinedObject >> copy [

"Returns the receiver.  The pseudovariable nil is the only instance of
 UndefinedObject, and must preserve identity."

^self

]

{ #category : 'Formatting' }
UndefinedObject >> describe [
 "when printing stack reports avoid putting an exception handler on the
  stack for printing a nil."
^ self asString

]

{ #category : 'Formatting' }
UndefinedObject >> describeClassName [

"Returns a String to describe classes with nil names."

^ 'unnamed'

]

{ #category : 'Indexing Support' }
UndefinedObject >> getDepListAndAddPathTerm: pathTerm withIVOffset: ivOffset logging: aBoolean [

"Private."

^ self

]

{ #category : 'Testing' }
UndefinedObject >> isSpecial [

"Returns true if the receiver is a special object."

^ true

]

{ #category : 'Json' }
UndefinedObject >> printJsonOn: aStream [

	aStream nextPutAll: 'null'.

]

{ #category : 'Formatting' }
UndefinedObject >> printString [
 "when printing stack reports avoid putting an exception handler on the
  stack for printing a nil."
^ self asString

]

{ #category : 'Deprecated' }
UndefinedObject >> subclass: aString
instVarNames: anArrayOfStrings
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
isModifiable: modifyBoolean [

	"Private.  Creates and returns a new subclass of the receiver.

 For further documentation see the same selector in Class."

	| theClass superClassOffset oldClass opts |
	self
		deprecated: 'UndefinedObject>>subclass:instVarNames:classVars:...constraints:... deprecated before v3.0; constraints no longer supported'.
	oldClass := Object _classNamed: aString inDictionary: aDictionary.
	opts := {}.
	invarBoolean
		ifTrue: [opts add: #instancesInvariant]
		ifFalse:
			[Object instancesInvariant
				ifTrue: [^self _error: #classErrInvariantSuperClass]].
	modifyBoolean ifTrue: [opts add: #modifiable].
	oldClass
		ifNotNil:
			[(Object
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: opts
				newFormat: oldClass format
				newInstVars: anArrayOfStrings
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false) ifTrue: [^oldClass	"avoid creation of a new version"]].
	theClass := Object
				subclass: aString
				instVarNames: anArrayOfStrings
				classVars: anArrayOfClassVars
				classInstVars: anArrayOfClassInstVars
				poolDictionaries: anArrayOfPoolDicts
				inDictionary: aDictionary
				constraints: aConstraint
				instancesInvariant: invarBoolean
				isModifiable: modifyBoolean.
	superClassOffset := Behavior _ivOffsetOf: #superClass.
  (theClass instVarAt: superClassOffset) ifNotNil:[
	  theClass _unsafeAt: superClassOffset put: nil.
	  theClass class _unsafeAt: superClassOffset put: Object class superClass.
  ].
	^theClass

]

{ #category : 'Subclass Creation' }
UndefinedObject >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
newVersionOf: oldClass
description: aDescription
options: optionsArray [

  | descr theClass superClassOffset |
  descr := aDescription.
  oldClass ifNotNil: [
     (Object _equivalentSubclass: oldClass
        superCls: self
        name: aString
        newOpts: optionsArray
        newFormat: oldClass format
        newInstVars: anArrayOfInstvarNames
        newClassInstVars: anArrayOfClassInstVars
        newPools: anArrayOfPoolDicts
        newClassVars: anArrayOfClassVars
        inDict: aDictionary
        isKernel: false ) ifTrue: [
            oldClass _commentOrDescription: aDescription.
            ^oldClass "avoid creation of a new version"
        ].
      descr ifNil:[ descr := [ oldClass commentForFileout ] on: Error do:[:ex | 'old comment not available']]
  ].
  theClass := Object
        subclass: aString
        instVarNames: anArrayOfInstvarNames
        classVars: anArrayOfClassVars
        classInstVars: anArrayOfClassInstVars
        poolDictionaries: anArrayOfPoolDicts
        inDictionary: aDictionary
        newVersionOf: oldClass
        description: descr
        options: optionsArray.
  theClass == oldClass ifFalse:[
    superClassOffset := Behavior _ivOffsetOf: #superClass.
    (theClass instVarAt: superClassOffset) ifNotNil:[
      theClass _unsafeAt: superClassOffset put: nil.
      theClass class _unsafeAt: superClassOffset put: Object class superClass
    ].
  ].
  ^theClass

]

{ #category : 'Subclass Creation' }
UndefinedObject >> subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
options: optionsArray [

^ self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  newVersionOf: (self class _classNamed: aString inDictionary: aDictionary)
  description: nil
  options: optionsArray

]

{ #category : 'Subclass Creation' }
UndefinedObject >> subclass: aString instVarNames: anArrayOfInstvarNames inDictionary: aDictionary [
  ^ self
  subclass: aString
  instVarNames: anArrayOfInstvarNames
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: aDictionary
  options: #()

]



{ #category : 'Deprecated' }
UndefinedObject >> subclass: aString
instVarNames: anArrayOfStrings
inDictionary: aDictionary
constraints: constraintSpec [

"Private.  Creates and returns a new subclass of the receiver.
 For further documentation see the same selector in Class."

self deprecated: 'UndefinedObject>>subclass:instVarNames:inDictionary:constraints: deprecated before v3.0; constraints no longer supported'.
^ self subclass: aString
    instVarNames: anArrayOfStrings
    classVars: #()
    classInstVars: #()
    poolDictionaries: #()
    inDictionary: aDictionary
    constraints: constraintSpec
    instancesInvariant: false
    isModifiable: false

]

{ #category : 'Storing and Loading' }
UndefinedObject >> writeTo: passiveObj [

"Converts the receiver to its passive form and writes that information on
 passiveObj."

| c |
self == _remoteNil ifTrue:[ c := $# ] ifFalse:[ c := $. ].
passiveObj nextPut: c

]
