Extension { #name : 'ZeroDivide' }

{ #category : 'Instance creation' }
ZeroDivide class >> dividend: argument [
	"Signal the occurrence of a division by zero exception. Capture the number
	that was being divided such that it is available from the 'signaled exception.'

	If the message #dividend is subsequently sent to the <ZeroDivide> object
	that is the 'signaled exception' the value of 'argument' is returned."

	argument / 0.

]

{ #category : 'Instance creation' }
ZeroDivide class >> signal [

	0 / 0.

]

{ #category : 'Accessing' }
ZeroDivide >> buildMessageText [
^ self buildMessageText:
   'attempt to divide ' , dividend asString , ' by zero'

]

{ #category : 'Accessing' }
ZeroDivide >> dividend [

	^ dividend

]

{ #category : 'Accessing' }
ZeroDivide >> dividend: aNumber [

  dividend := aNumber

]

{ #category : 'Instance initialization' }
ZeroDivide >> initialize [
  gsNumber := ERR_ZeroDivide.
  gsResumable := true .
  gsTrappable := true .

]
