"

PathTerm represents a single term/instance variable within an index or query
path. PathTerm provides a simple case; subclasses of PathTerm are used for 
specialized features, such as set-valued paths. 

PathTerm implements only GemStone internals, and is not intended for direct use
by customers. 

Constraints:
	name: CharacterCollection
	offset: SmallInteger
	securityPolicies: Object
	children: Object
	updateBtree: Object
	updateDict: Object
	needsDepList: Boolean
"
Class {
	#name : 'PathTerm',
	#superclass : 'Array',
	#instVars : [
		'name',
		'offset',
		'securityPolicies',
		'children',
		'updateBtree',
		'updateDict',
		'needsDepList'
	],
	#gs_reservedoop : '89089',
	#category : nil
}

{ #category : 'Private' }
PathTerm >> _findAllValuesForIdenticalRootObject: rootObject [
	" if index directly on NSC elements or anObject is nil "

	| key tmpList |
	(self indicatesIndexOnNscElements or: [ nil == rootObject ])
		ifTrue: [ key := rootObject ]
		ifFalse: [ key := self _nextObjectFor: rootObject ].
	tmpList := IdentityBag new.
	self updateBtree btreeRoot _findAllValuesForIdenticalKey: key into: tmpList.
	^ (tmpList occurrencesOf: rootObject) <= 1
]
