"
 ChildError is used by GsHostProcess when the child process returns a non-zero
 exit status.
"
Class {
	#name : 'ChildError',
	#superclass : 'Error',
	#instVars : [
    'status',
    'stderr'
  ],
	#category : nil
}

{ #category : 'Instance initialization' }
ChildError >> initialize [
  super initialize .
  gsResumable := true.
]

{ #category : 'Accessing' }
ChildError >> status [
  ^ status
]

{ #category : 'Accessing' }
ChildError >> status: anInteger [
  status := anInteger
]

{ #category : 'Accessing' }
ChildError >> stderr [
  ^ stderr
]

{ #category : 'Accessing' }
ChildError >> stderr: aString [
  stderr := aString
]

{ #category : 'Private' }
ChildError >> buildMessageText [
  self details: 'status ', status asString,', ', stderr asString .
  super buildMessageText
]
