"
GsClassDocumentation is deprecated in GemStone/S 64 Bit v3.1 and later.

This class implements GemStone internals. It is not intended for customer use,
by creating instances or by subclassing.

An instance of GsClassDocumentation retains and organizes textual information
that documents the purpose, operation, and implementation of a class.

Constraints:
	itsClass: Class
	gsObsolete: String
	gsPrivate: Boolean
	classDoc: GsDocText
	instVarDoc: SymbolDictionary
	classVarDoc: SymbolDictionary
	classInstVarDoc: SymbolDictionary
	poolVarDoc: SymbolDictionary
	categoryDoc: SymbolDictionary
	classCategoryDoc: SymbolDictionary
"
Class {
	#name : 'GsClassDocumentation',
	#superclass : 'Object',
	#instVars : [
		'itsClass',
		'gsObsolete',
		'gsPrivate',
		'classDoc',
		'instVarDoc',
		'classVarDoc',
		'classInstVarDoc',
		'poolVarDoc',
		'categoryDoc',
		'classCategoryDoc'
	],
	#gs_reservedoop : '95233',
	#category : nil
}

{ #category : 'Private' }
GsClassDocumentation class >> _newForObsoleteGsClass: aClass asOfGsVersion: aString [

"Private.  Only for use by GemStone."

"Creates an object that documents a GemStone class that is obsolete."

| result |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
result := self newForClass: aClass.
result _markAsObsoleteGsClass: aString.

^ result

]

{ #category : 'Private' }
GsClassDocumentation class >> _newForObsoletePrivateGsClass: aClass asOfGsVersion: aString [

"Private.  Only for use by GemStone."

"Creates an object that documents a GemStone private class that is obsolete."

| result |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
result := self newForClass: aClass.
result _markAsPrivateGsClass.
result _markAsObsoleteGsClass: aString.

^ result

]

{ #category : 'Private' }
GsClassDocumentation class >> _newForPrivateGsClass: aClass [

"Private.  Only for use by GemStone."

"Creates an object that documents a GemStone class that is private."

| result |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
result := self newForClass: aClass.
result _markAsPrivateGsClass.

^ result

]

{ #category : 'Instance Creation' }
GsClassDocumentation class >> new [

"Disallowed.  All instances of this class must initialize the
 itsClass instance variable.  Use newForClass: instead."

self shouldNotImplement: #new .

]

{ #category : 'Instance Creation' }
GsClassDocumentation class >> newForClass: aClass [

"Creates an object that documents a class."

| result |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
result := super new.
result _initialize: aClass.

^ result

]

{ #category : 'Private' }
GsClassDocumentation >> _classDocDetailsDelimiter [

| res |
self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(res := String new) lf; lf; add: ' ' .
^ res

]

{ #category : 'Private' }
GsClassDocumentation >> _classDocDetailsObsolete [

| res |
self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(res := String withAll: 'The class ')
      add: (itsClass name);
      add: ' is obsolete as of GemStone version ';
      add: gsObsolete;
      add: ' and will be removed in a future release.  GemStone recommends';
      add: ' that you retire or migrate your instances in this release.'.
^ res

]

{ #category : 'Private' }
GsClassDocumentation >> _classDocDetailsPrivate [

| res |
self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(res := String withAll: 'The class ')
      add: (itsClass name);
      add: ' implements only GemStone internals.  That is, it provides only';
      add: ' functionality required by GemStone itself.  It is not intended';
      add: ' for customer use, by creating instances or by subclassing.'.
^ res

]

{ #category : 'Private' }
GsClassDocumentation >> _document: aSymbol in: aSymbolDict with: aGsDocText [

""

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(aGsDocText isKindOf: GsDocText)
  ifTrue: [ aSymbolDict at: aSymbol put: aGsDocText. ].

]

{ #category : 'Private' }
GsClassDocumentation >> _getDetailsAbout: aSymbol in: aSymbolDict [

""

| txt |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
aSymbolDict ifNil:[ ^ nil  ].
txt := aSymbolDict at: aSymbol otherwise: nil .
txt ifNil:[ ^ nil ].

^ (txt details)

]

{ #category : 'Private' }
GsClassDocumentation >> _initialize: aClass [

""

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
itsClass ifNil:[
  itsClass := aClass.
  gsPrivate := false.
  ].

]

{ #category : 'Private' }
GsClassDocumentation >> _markAsObsoleteGsClass: theGsVersion [

"Private.  Only for use by GemStone."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
gsObsolete := theGsVersion.

]

{ #category : 'Private' }
GsClassDocumentation >> _markAsPrivateGsClass [

"Private.  Only for use by GemStone."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
gsPrivate := true.

]

{ #category : 'Private' }
GsClassDocumentation >> _prependToGsClassDoc: aGsDocText [

"Prepends appropriate text to the class documentation if the class is
 obsolete or private.  Only GemStone classes can be obsolete or private."

| detls str |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(self isGsObsolete)
  ifTrue:  [ str := self _classDocDetailsObsolete. ]
  ifFalse: [
    (self isGsPrivate)
      ifTrue:  [ str := self _classDocDetailsPrivate. ]
      ifFalse: [ ^ self ].
    ].

detls := aGsDocText details.
(detls == nil) ifFalse: [
  str add: (self _classDocDetailsDelimiter).
  str add: detls.
  ].
aGsDocText details: str.

]

{ #category : 'Private' }
GsClassDocumentation >> _sortKeysFrom: aSymbolDict [

""

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
aSymbolDict ifNil: [ ^ { }  ].

^ Array withAll:( SortedCollection withAll: aSymbolDict keys )

]

{ #category : 'Printing' }
GsClassDocumentation >> asString [

  | str d lf |
  self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
  str := String new .
  lf := Character lf .
  (d := self detailsAboutClass) ifNotNil:[ str add: d; add: lf ].
  { { #instVarList . #detailsAboutInstVar: . 'instVar' } .
     { #classVarList . #detailsAboutClassVar: . 'classVar' } .
     { #poolVarList . #detailsAboutPoolVar: . 'poolVar' } .
     { #classInstVarList . #detailsAboutClassInstVar: . 'classInstVar' } .
     { #classCategoryList . #detailsAboutClassCategory: . 'class Category: ' } .
     { #categoryList . #detailsAboutCategory: . 'Category: ' }
   } do:[ :arr |
    (self perform: (arr at: 1) ) do:[:sym | | s |
      (s := self perform: (arr at: 2) with: sym ) ifNotNil:[
        str add: '--- '; add: (arr at: 3); add:' ' ; add: sym; add: lf ;
	    add: s ; add: lf .
      ].
    ].
  ].
  ^ str

]

{ #category : 'Accessing' }
GsClassDocumentation >> categoryList [

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented instance method categories of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: categoryDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> classCategoryList [

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented class method categories of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: classCategoryDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> classInstVarList [

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented class instance variable names of the class that is associated with
 the receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: classInstVarDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> classVarList [

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented class variable names of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: classVarDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> detailsAboutCategory: aSymbol [

"Returns the CharacterCollection that contains detailed documentation about the
 instance method category named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: categoryDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> detailsAboutClass [

"Returns the CharacterCollection that contains detailed documentation about the
 class as a whole."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(classDoc == nil) ifTrue: [ ^ nil ].
^ (classDoc details)

]

{ #category : 'Accessing' }
GsClassDocumentation >> detailsAboutClassCategory: aSymbol [

"Returns the CharacterCollection that contains detailed documentation about the
 class method category named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: classCategoryDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> detailsAboutClassInstVar: aSymbol [

"Returns the CharacterCollection that contains detailed documentation about the
 class instance variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: classInstVarDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> detailsAboutClassVar: aSymbol [

"Returns the CharacterCollection that contains detailed documentation about the
 class variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: classVarDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> detailsAboutInstVar: aSymbol [

"Returns the CharacterCollection that contains detailed documentation about the
 instance variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: instVarDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> detailsAboutPoolVar: aSymbol [

"Returns the CharacterCollection that contains detailed documentation about the
 pool variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: poolVarDoc)

]

{ #category : 'Updating' }
GsClassDocumentation >> documentCategory: aSymbol with: aGsDocText [

"Documents an instance method category named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(categoryDoc == nil) ifTrue: [ categoryDoc := SymbolDictionary new. ].
self _document: aSymbol in: categoryDoc with: aGsDocText.

]

{ #category : 'Updating' }
GsClassDocumentation >> documentClassCategory: aSymbol with: aGsDocText [

"Documents a class method category named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(classCategoryDoc == nil)
  ifTrue: [ classCategoryDoc := SymbolDictionary new. ].
self _document: aSymbol in: classCategoryDoc with: aGsDocText.

]

{ #category : 'Updating' }
GsClassDocumentation >> documentClassInstVar: aSymbol with: aGsDocText [

"Documents a class instance variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(classInstVarDoc == nil) ifTrue: [
  classInstVarDoc := SymbolDictionary new.
  ].
self _document: aSymbol in: classInstVarDoc with: aGsDocText.

]

{ #category : 'Updating' }
GsClassDocumentation >> documentClassVar: aSymbol with: aGsDocText [

"Documents a class variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(classVarDoc == nil) ifTrue: [ classVarDoc := SymbolDictionary new. ].
self _document: aSymbol in: classVarDoc with: aGsDocText.

]

{ #category : 'Updating' }
GsClassDocumentation >> documentClassWith: aGsDocText [

"Documents the class that is associated with the receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
self _prependToGsClassDoc: aGsDocText.
classDoc := aGsDocText.

]

{ #category : 'Updating' }
GsClassDocumentation >> documentInstVar: aSymbol with: aGsDocText [

"Documents an instance variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(instVarDoc == nil) ifTrue: [ instVarDoc := SymbolDictionary new. ].
self _document: aSymbol in: instVarDoc with: aGsDocText.

]

{ #category : 'Updating' }
GsClassDocumentation >> documentPoolVar: aSymbol with: aGsDocText [

"Documents a pool variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(poolVarDoc == nil) ifTrue: [ poolVarDoc := SymbolDictionary new. ].
self _document: aSymbol in: poolVarDoc with: aGsDocText.

]

{ #category : 'Accessing' }
GsClassDocumentation >> instVarList [

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented instance variable names of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: instVarDoc)

]

{ #category : 'Accessing' }
GsClassDocumentation >> isGsObsolete [

"Returns true when the class that the receiver documents is obsolete."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(gsObsolete == nil) ifTrue: [ ^ false ].

^ true

]

{ #category : 'Accessing' }
GsClassDocumentation >> isGsPrivate [

"Returns true when the class that the receiver documents implements only
 GemStone internals, and false otherwise.  Private means that the class is not
 intended for customer use, by creating instances or by subclassing.  It
 provides only functionality required by GemStone itself."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ gsPrivate

]

{ #category : 'Accessing' }
GsClassDocumentation >> itsClass [

"Returns the class that the receiver documents.
 This method needed by image upgrade."

^ itsClass

]

{ #category : 'Private' }
GsClassDocumentation >> itsClass: aClass [

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
itsClass := aClass .
^ self

]

{ #category : 'Accessing' }
GsClassDocumentation >> poolVarList [

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented pool variable names of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: poolVarDoc)

]
