"
The class LogEntry implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.
"
Class {
	#name : 'LogEntry',
	#superclass : 'Object',
	#instVars : [
		'receiver',
		'selector',
		'argArray'
	],
	#gs_reservedoop : '92161',
	#category : nil
}

{ #category : 'Accessing' }
LogEntry >> argArray [

"Returns the value of the instance variable 'argArray'."

^argArray

]

{ #category : 'Updating' }
LogEntry >> receiver: anObj selector: aSymbol argArray: newValue [
  receiver := anObj .
  selector := aSymbol .
  argArray := newValue
]

{ #category : 'Replaying' }
LogEntry >> printObj: obj [
  obj isSpecial ifTrue:[ ^ obj printString ,' ' ].
  obj _isSymbol ifTrue:[ ^ obj printString ,' ' ].
  ^ ' ', obj asOop asString,'(a ', obj class name,') '
]

{ #category : 'Formatting' }
LogEntry >> printOn: aStream [

"Puts a displayable representation of the receiver on the given stream."

aStream tab; nextPutAll: '(', selector printString, ' withArgs: '; cr.
argArray do: [:obj |
    aStream tab; tab; nextPutAll: ' [', obj class printString, ', ', obj asOop printString, '] '; cr.
].
aStream tab; nextPutAll: ')'; cr.

]

{ #category : 'Accessing' }
LogEntry >> receiver [

"Returns the value of the instance variable 'receiver'."

^receiver

]

{ #category : 'Replaying' }
LogEntry >> redo [

"Replays the message send for the receiver log entry."
| details|
(details := System _gemCommitConflictDetails) > 1 ifTrue: [ 
  (details > 2 or:[ (SessionTemps current increment: #LogEntry_redoCount) < 20 ]) ifTrue:[
    | str sz |
    str :=  '--- LogEntry redo( ' , (self printObj: receiver), selector printString, ' args:(' .
    1 to: (sz := argArray size) do:[:n | | elem |
      elem := argArray at: n .
      str addAll: ( self printObj: elem) .
      n < sz ifTrue:[ str add: $, ].
    ].
    str add: '))' .
    GsFile gciLogServer:str 
  ] .
].
^ receiver perform: selector withArguments: argArray
]

{ #category : 'Accessing' }
LogEntry >> selector [

"Returns the value of the instance variable 'selector'."

^selector

]

