Extension { #name : 'Object' }

{ #category : 'Indexing Support' }
Object class >> _canCreateQueryOnInstances [
  "Cannot create a GsQuery on the receiver"

  ^ false

]

{ #category : 'Updating' }
Object class >> _checkKindForBecome: anObj [

"determine reason for primitive failure of become"
| arr gsCompDict |
(gsCompDict := Globals at: #GsCompilerClasses otherwise: nil) ifNil:[
  Error signal: 'GsCompilerClasses missing from Globals'.
].


anObj isSpecial ifTrue: [ ^ anObj _error: #rtErrCantBecomeSpecial ].

anObj _isExecBlock ifTrue: [
   ^ ArgumentTypeError new reason: #rtErrCantBecomeClassKind ; _number: 2121; object: anObj ;
	details: 'become not allowed on ExecBlocks  '; signal
].
(anObj _isSymbol ) ifTrue: [
   ^ ArgumentTypeError new reason: #rtErrCantBecomeClassKind ; _number: 2121; object: anObj ;
	details: 'become not allowed on Symbols  '; signal
].

arr := { Behavior . GsNMethod .   " to avoid breaking VM"
   GsMethodDictionary . SymbolDictionary . SymbolList .  "for code security"
   "following have CData" GsSocket . GsFile . 
     (gsCompDict at: #GsCompilerIRNode) . CBuffer . CByteArray . CFunction . CLibrary . CPointer .
     CZstream }.
1 to: arr size do:[:n || cls |
  cls := arr at: n .
  (anObj isKindOf: cls) ifTrue:[
    ^ ArgumentTypeError new reason: #rtErrCantBecomeClassKind; _number: 2121 ; object: anObj;
       details: 'become not allowed on instances of ' , cls name ; signal .
  ]
].

]

{ #category : 'Indexing Support' }
Object class >> _idxBasicCanCompareWithCharacterCollectionInstance: aCharacterCollection [
  "Returns true if <aCharacterCollection> may be inserted into a basic BtreeNode
   whose #lastElementClass is the receiver (see RangeEqualityIndex
   class>>isBasicClass:)."

  ^ false

]

{ #category : 'Indexing Support' }
Object class >> _idxBasicCanCompareWithUnicodeInstance: aUnicodeString [
  "Returns true if <aUnicodeString> may be inserted into a basic BtreeNode whose
   #lastElementClass is the receiver (see RangeEqualityIndex class>>isBasicClass:)."

  ^ false

]

{ #category : 'Indexing Support' }
Object class >> _idxCanOptimizeComparison [
  "Answer true if it is possible to optimize index-related comparisons by replacing
   _idxForCompare* calles with a primitive comparison call instead.

     _idxForCompareEqualTo:              #=
     _idxForCompareGreaterThan:          #>
     _idxForCompareGreaterThanOrEqualTo: #>=
     _idxForCompareLessThan:             #<
     _idxForCompareLessThanOrEqualTo:    #<=
     _idxForCompareNotEqualTo:           #~=
   "

  ^ false

]

{ #category : 'Repository Conversion' }
Object class >> _loadBitmap: bm fromFilesIn: directoryPath [
  ^ self
    _loadBitmap: bm
    fromFilesIn: directoryPath
    withPattern: (Array with: '.bm')

]

{ #category : 'Repository Conversion' }
Object class >> _loadBitmap: bm fromFilesIn: directoryPath withPattern: pattern [
  | sys files |
  sys := System.
  bm removeAll.
  files := GsFile contentsOfDirectory: directoryPath onClient: false.
  files := files select: [ :e | (e findPattern: pattern startingAt: 1) ~~ 0 ].
  1 to: files size do: [ :n |
    | fn |
    fn := files at: n.
    bm readFromFile: fn ].
  ^ bm size

]

{ #category : 'Indexing Support' }
Object >> _addObjectToBtreesWithValues: anArray [
  "Adds the receiver to the B-trees of any equality indexes that it participates
   in, using the given Array of index object/value pairs."
  <primitive: 2001>
  | prot |
  prot := System _protectedMode.
  [
    [
      | indexObj vals |
      System _bypassReadAuth.
      1 to: anArray size by: 2 do: [ :i |
        indexObj := anArray at: i.
        vals := anArray at: i + 1.
        1 to: vals size do: [ :j |
          " add an entry to the B-tree "
          indexObj modifiedObject: self userData: (vals at: j) 
        ] 
      ] 
    ] onSynchronous: Error do: [ :ex |
      System disableCommitsWithReason:'error during _addObjectToBtreesWithValues' .
      ex pass 
    ]
  ] ensure: [
    System _exitBypassReadAuth.
    prot _leaveProtectedMode 
  ]
]

{ #category : 'Indexing Support' }
Object >> _addToReferences: anObject offset: offset occurrences: num into: refsToRcvr [

"Add anObject and the offset into the Array of references (refsToRcvr)
 if it is not already present."

1 to: refsToRcvr size by: 2 do: [ :i |
  anObject == (refsToRcvr at: i)
    ifTrue: [
      (refsToRcvr at: i + 1) == offset
        ifTrue: [ ^ self ]
    ]
].
num timesRepeat: [
  refsToRcvr add: anObject.
  refsToRcvr add: offset
]

]

{ #category : 'Indexing Support' }
Object >> _changingSizeTo: newSize [

"Notifies any modification tracking objects that the receiver (an indexable
 object) is having its size changed. Returns self"
 [ | depList |
   depList := DependencyList for: self.
   1 to: depList size by: 2 do: [ :i |
     (depList at: i + 1) == 0
       ifTrue: [ (depList at: i) changingSizeOfObject: self to: newSize ]
   ].
 ] onSynchronous: Error do: [ :ex |
   System disableCommitsWithReason:'error during _changingSizeTo' .
   ex pass 
 ]
]

{ #category : 'Indexing Support' }
Object >> _deletingAt: offset count: count [

"Notifies any modification tracking objects that the receiver (an indexable
 object) is having portions deleted. Returns self"
 [ | depList |
   depList := DependencyList for: self.
   1 to: depList size by: 2 do: [ :i |
     (depList at: i + 1) == 0
       ifTrue: [ (depList at: i) deletingIn: self startingAt: offset count: count ]
   ].
 ] onSynchronous: Error do: [ :ex |
   System disableCommitsWithReason:'error during _deletingAt:count:' .
   ex pass 
 ]
]

{ #category : 'Indexing Support' }
Object >> _doModifyingInstVarAtOffset: anInteger to: newValue depList: depList btreeRemovals: btreeRemovals [
  "The instance variable at the given offset is being modified.  Update any
   indexes that depend upon that instance variable.  Collect list of indexes which
   depend directly on the receiver (btreeRemovals). The caller is expected to call
   _addObjectToBtreesWithValues: with the list. Returns an Array.  If the index
   objects were modified correctly, the first slot in array is nil and the
   second slot is the list of btreeRemovals; otherwise the first slot is a boolean
   and the second slot is an exception."

  | i  |
  i := 1.
  [ i <= depList size ]
    whileTrue: [
      | ivOffsetOrReferenceCount |
      ivOffsetOrReferenceCount := depList at: i + 1.
      ivOffsetOrReferenceCount < 0
        ifTrue: [
          | pathTerm indexObj |
          "remove object from the btrees associated with the last element of
           an index path... caller will add receiver back after instance variable is
           updated"
          "bug 42640 ... upgraded reference counts are not an issue"
          pathTerm := depList at: i.
          indexObj := pathTerm at: pathTerm size.
          btreeRemovals add: indexObj.
          btreeRemovals add: (indexObj _removeBtreeEntriesForKey: self) ]
        ifFalse: [
          (ivOffsetOrReferenceCount == anInteger or: [ (depList at: i) coversIvOffset: anInteger for: self ])
            ifTrue: [
              | resultOrErrorArray |
              resultOrErrorArray := (depList at: i)
                update: self
                at: anInteger
                to: newValue.
              resultOrErrorArray == true
                ifFalse: [
                  "error array"
                  btreeRemovals isEmpty
                    ifFalse: [
                      "ensure that error includes information that indexing objects were modified"
                      resultOrErrorArray at: 1 put: true ].
                  ^ resultOrErrorArray ] ] ].
      i := i + 2 ].
  ^ {nil.
  btreeRemovals}

]

{ #category : 'Error Handling' }
Object >> _error: errorSymbol [
  "Will be deprecated."
  | errNum cls |
  errNum := ErrorSymbols at: errorSymbol otherwise: 2063 .
  cls := ( (LegacyErrNumMap atOrNil: errNum)
             ifNotNil:[ :mv | mv atOrNil: 1 ] ) ifNil:[ InternalError ].
  ^ cls new _number: errNum; reason: errorSymbol ; args: { self } ; signal

]

{ #category : 'Error Handling' }
Object >> _error: errorSymbol args: argList [
  "Will be deprecated."

  | newArgList cls errNum |
  newArgList := { self } .
  newArgList addAll: argList .
  errNum := ErrorSymbols at: errorSymbol otherwise: 2063 .
  cls := ( (LegacyErrNumMap atOrNil: errNum)
             ifNotNil:[ :mv | mv atOrNil: 1 ] ) ifNil:[ InternalError ].
  ^ cls new _number: errNum; reason: errorSymbol ;
                args: newArgList ;  signal

]

{ #category : 'Error Handling' }
Object >> _error: errorSymbol with: argOne [
  "Will be deprecated."
  | errNum cls |
  errNum := ErrorSymbols at: errorSymbol otherwise: 2063 .
  cls := ( (LegacyErrNumMap atOrNil: errNum)
             ifNotNil:[ :mv | mv atOrNil: 1 ] ) ifNil:[ InternalError ].
  ^ cls new _number: errNum; reason: errorSymbol ;
		args: { self . argOne } ; signal

]

{ #category : 'Indexing Support' }
Object >> _findIVOffsetForPathTerm: pathTerm [
  "Returns the instance variable offset stored in the dependency list that
 corresponds to the given path term.  Returns nil if the path term is not found
 in the dependency list."

  | depList offset |
  (depList := DependencyList for: self)
    ifNil: [
      self isInvariant
        ifTrue: [
          "Bug 42643 - brute force lookup"
          offset := pathTerm _ivOffsetFor: self.
          offset == 0
            ifTrue: [ ^ nil ].
          ^ offset ]
        ifFalse: [ ^ nil ] ].
  offset := depList getInstVarOffsetWithPathTerm: pathTerm.
  offset <= 0
    ifTrue: [ ^ nil ].
  ^ offset

]

{ #category : 'Indexing Support' }
Object >> _getIndexReferencesInto: refsToRcvr [
  "Place information about references to the receiver due to the receiver's
 participation in an index into the given Array.  The Array consists of pairs:

 1) An object that references the receiver.  If the object is directly
    contained in an indexed NSC, then this object is the NSC.  If the object
    in the dependency list is a tracking object (for object modification
    tracking), then this object is the tracking object.
 2) The offset of the instance variable in that object that references the
    receiver.
 3) If the object is the last path term, this number is < 0 and is a reference
    count for the number of times .
 3) If the object in the dependency list is a tracking
    object, this number is 0.

 This is used only in support of the 'become:' method."

  | depList pathTerm |
  depList := DependencyList for: self.
  depList ifNil: [ ^ refsToRcvr ].
  1 to: depList size by: 2 do: [ :i |
    (depList at: i + 1) ~~ 0
      ifTrue: [
        pathTerm := depList at: i.
        pathTerm _getPathTermIndexReferencesInto: refsToRcvr for: self ]
      ifFalse: [
        " it is a tracking object "
        refsToRcvr add: (depList at: i).
        refsToRcvr add: -1 ] ].
  ^ refsToRcvr

]

{ #category : 'Indexing Support' }
Object >> _hasDependencyList [

"Returns true if the receiver participates in an index, and false otherwise."

| result |
result := (DependencyList for: self) ~~ nil.
^ result

]

{ #category : 'Indexing Support' }
Object >> _idxBasicPlusCanCompareWithClass: aClass [
  "Returns true if the receiver may be inserted into a basic BtreePlusNode whose
   #lastElementClass is <aClass> (see GsRangeEqualityIndex class>>isBasicClass:)."

  "For now the rules are the same for BtreePlusNode and BtreeNode"

 ^ self _idxBasicCanCompareWithClass: aClass

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForCompareEqualToCharacterCollection: aCharacterCollection [
  "second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:."

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareEqualToUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:collator:."

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareGreaterThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any >= comparison"

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareGreaterThanUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThan:collator:. Note that aUnicodeString should be the receiver in any > comparison"

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareLessThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any <= comparison"

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForCompareLessThanUnicode: aUnicodeString collator: anIcuCollator [

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThan:collator:. Note that aUnicodeString should be the receiver in any < comparison"

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortEqualTo:collator:."

  ^ false

]

{ #category : 'New Indexing Comparison - for Compare' }
Object >> _idxForSortEqualToSymbol: aSymbol [
  "second half of a double dispatch call from Symbol>>_idxForSortEqualTo:."

  ^ false

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortGreaterThanCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThan:collator:. Note that aCharacterCollection should be the receiver in any > comparison"

  ^ aCharacterCollection _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortGreaterThanOrEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThanOrEqualTo:collator:. Note that aCharacterCollection should be the receiver in any >= comparison"

  ^ aCharacterCollection _classSortsGreaterThan: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortLessThanCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortLessThan:collator:. Note that aCharacterCollection should be the receiver in any < comparison"

  ^ aCharacterCollection _classSortsLessThan: self

]

{ #category : 'New Indexing Comparison' }
Object >> _idxForSortLessThanOrEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator [
  "second half of a double dispatch call from CharacterCollection>>_idxForSortLessThanOrEqualTo:collator:. Note that aCharacterCollection should be the receiver in any <= comparison"

  ^ aCharacterCollection _classSortsLessThan: self

]

{ #category : 'Indexing Support' }
Object >> _idxOptimizedCompareWithClass: aClass [
  "Returns true if the receiver may be inserted into a BtreePlusNode whose
   #lastElementClass is <aClass> and whose comparisons are optimized."

  "Sent when index option optimizeComparison is true and aClass responds trut to #_idxCanOptimizeComparison"

  ^ false

]

{ #category : 'Indexing Support' }
Object >> _idxValue [

	^self

]

{ #category : 'Indexing Support' }
Object >> _indexParticipationInfo [

"Returns an Array of pairs: the root NSC and the path String that describes
 the path traversed from the root to reach the receiver."

^ self _indexParticipationInfoInto: { } .

]

{ #category : 'Indexing Support' }
Object >> _indexParticipationInfoInto: array [
  "Returns an Array of pairs: the root NSC and the path String that describes
 the path traversed from the root to reach the receiver."

  | depList pathTerm indexObj pathString included |
  depList := DependencyList for: self.
  1 to: depList size by: 2 do: [ :i |
    (depList at: i + 1) ~~ 0
      ifTrue: [
        pathTerm := depList at: i.
        1 to: pathTerm size do: [ :j |
          indexObj := pathTerm at: j.
          pathString := indexObj
            _partialPathComponentsStringUpTo: pathTerm offset.
          included := false.
          1 to: array size by: 2 do: [ :k |
            ((array at: k) == indexObj nscRoot and: [ (array at: k + 1) = pathString ])
              ifTrue: [ included := true ] ].
          included
            ifFalse: [
              array add: indexObj nscRoot.
              array add: pathString ] ] ] ].
  ^ array

]

{ #category : 'Indexing Support' }
Object >> _inserting: indexableObj at: offset insertSize: aSize [

"Notifies any modification tracking objects that the receiver (an indexable
 object) is having portions inserted. Returns self"
 [ | depList |
   depList := DependencyList for: self.
   1 to: depList size by: 2 do: [ :i |
     (depList at: i + 1) == 0
       ifTrue: [ (depList at: i) inserting: indexableObj into: self at: offset
				   insertSize: aSize
         ].
   ].
 ] onSynchronous: Error do: [ :ex |
   System disableCommitsWithReason:'error during _inserting:at:insertSize:' .
   ex pass 
 ]
]

{ #category : 'Testing' }
Object >> _literalEqual: anotherLiteral [
  "For two literals to be _literalEqual, their class must be identical and
   otherwise equal"

  ^ self class == anotherLiteral class and: [ self = anotherLiteral ]

]

{ #category : 'Indexing Support' }
Object >> _modifyingByteObjectStartingAt: startPt withNewValue: newValue [
  "The byte object is being changed.  Update any indexes that depend upon the byte object.
   Returns nil or an Array of btree removals or signals an error.
   Called from C code in VM ; 
   that C code then calls Object >> _addObjectToBtreesWithValues: with removals as arg.
 "
 ^ [
  | depList inIndex removals |
   self class isBytes ifTrue:[
     depList := DependencyList for: self.
     depList ifNotNil:[
       inIndex := false.
       1 to: depList size by: 2 do: [ :i |
         (depList at: i + 1) ~~ 0
           ifTrue: [ inIndex := true ]
           ifFalse: [
             " modification tracker "
             (depList at: i)
               modifyingByteObject: self
               startingAt: startPt
               withNewValue: newValue ] 
       ].
       inIndex ifTrue:[
         removals := self _removeObjectFromBtrees	
       ].
     ].
   ].
   removals
 ] onSynchronous: Error do: [ :ex |
   System disableCommitsWithReason:'error during _modifyingByteObject' .
   ex pass 
 ]
]

{ #category : 'Indexing Support' }
Object >> _modifyingInstVarAtOffset: anInteger to: newValue [
  "The instance variable at the given offset is being modified.  Update any
   indexes that depend upon that instance variable.  Collect list of indexes which
   depend directly on the receiver (btreeRemovals). The caller is expected to call
   _addObjectToBtreesWithValues: with the list. 
   Returns nil or an Array of btree removals or signals an Error.
   Called from C code in VM ;
   that C code then calls Object >> _addObjectToBtreesWithValues: with removals as arg.
 "
 <primitive: 2001>
 | prot |
 prot := System _protectedMode.
 ^ [
    [ | depList inIndex btreeRemovals |
     inIndex := false.
     depList := DependencyList for: self.	" first handle modification tracking "
     depList ifNotNil:[
       btreeRemovals := { } . 
       1 to: depList size by: 2 do: [ :i |
        (depList at: i + 1) ~~ 0
          ifTrue: [ inIndex := true ]
          ifFalse: [
            anInteger >= self class firstPublicInstVar
              ifTrue: [
                btreeRemovals add: (depList at: i).
                btreeRemovals add:
                    ((depList at: i) aboutToModifyObject: self atOffset: anInteger to: newValue) 
              ]
          ]
       ].
       inIndex ifTrue:[
         System _bypassReadAuth.
          self _doModifyingInstVarAtOffset: anInteger to: newValue depList: depList 
                 btreeRemovals: btreeRemovals 
       ] .
     ].
     btreeRemovals
    ] onSynchronous: Error do: [ :ex |
      System disableCommitsWithReason:'error during _modifyingInstVar' .
      ex pass 
    ]
  ] ensure: [
    System _exitBypassReadAuth.
    prot _leaveProtectedMode .
  ]
]

{ #category : 'Testing' }
Object >> _refersToLiteral: literal [
  "Answer true if literal is identical to any literal in receiver, even if imbedded
   in further structures.
   Object is the end of the imbedded structure path so return false."

  ^ false

]

{ #category : 'Indexing Support' }
Object >> _removeIndexParticipation: refs for: oldObject [

"Private."
[
  | obj offset |
  1 to: refs size by: 2 do: [ :i |
	obj := refs at: i.
	offset := refs at: i + 1.
	offset == 0
	  ifTrue: [ " remove self from the NSC with indexes "
		obj remove: self
	  ]
	  ifFalse: [
		offset > 0
		  ifTrue: [ " it is not a tracking object "
			" set the instance variable reference to nil "
			obj instVarAt: offset put: nil
		  ]
		  ifFalse: [ " it is a tracking object "
			" send tracking msg first so if error is raise, we haven't
			cleared mod tracking yet "
			obj invokingBecomeOn: self to: oldObject.
			self _clearModificationTrackingTo: obj.
		  ]
	  ]
  ].
] onSynchronous: Error do:[: ex |
  System disableCommitsWithReason:'error during Object>>_removeIndexParticipation:for:'.
  ex pass .
]

]

{ #category : 'Indexing Support' }
Object >> _removeObjectFromBtrees [

"Removes the receiver from the B-trees of any equality indexes that it
 participates in.  
 Returns nil or an Array of index object/value pairs, or signals an Error."
  <primitive: 2001>
  | prot |
  prot := System _protectedMode .
 ^ [
    [ | depList removals |
    depList := DependencyList for: self.
    depList ifNotNil:[
      System _bypassReadAuth .
      removals := { } .
      " iterate through each path term dependent upon this object "
      1 to: depList size by: 2 do: [ :i |
        (depList at: i + 1) ~~ 0 ifTrue: [ | pathTerm |
		      pathTerm := depList at: i.
		      " for each index utilizing this path term "
		      1 to: pathTerm size do: [ :j | | indexObj |
	          indexObj := pathTerm at: j.
	          " add the equality index to the answer "
	          removals add: indexObj.
	          " remove the B-tree entries and get the corresponding values "
	          removals add: (indexObj _removeBtreeEntriesForKey: self)
		      ]
	      ]
      ].
    ].
    removals
   ] onSynchronous: Error do: [ :ex |
     System disableCommitsWithReason:'error during _removeObjectFromBtrees' .
    ex pass 
   ]
  ] ensure: [
    System _exitBypassReadAuth .
    prot _leaveProtectedMode
  ].
]

{ #category : 'Indexing Support' }
Object >> _restoreIndexParticipation: refs [

"Private."
[ | obj offset |
  1 to: refs size by: 2 do: [ :i |
	obj := refs at: i.
	offset := refs at: i + 1.
	offset == 0
	  ifTrue: [ " add self back to the NSC " obj add: self.  ] 
    ifFalse: [
		  offset == -1 ifTrue: [ " it is a tracking object "
			   self _setModificationTrackingTo: obj.
		    ] ifFalse: [ " add self back to the NSC "
			    obj instVarAt: offset put: self
		    ]
	   ]
  ].
] onSynchronous: Error do:[: ex |
  System disableCommitsWithReason:'error during _restoreIndexParticipation' .
  ex pass 
]

]

{ #category : 'Modification Tracking' }
Object >> aboutToModifyObject: anObject atOffset: anOffset to: newValue [
  "Notification that the tracked object anObject is about to modified at instance
   variable offset anOffset with value newValue.
   The receiver is registered as a modification tracker for anObject."

  "Default implementation for backward compatibility with pre-3.2 API"

  self modifyingObject: anObject atOffset: anOffset to: newValue.
  ^ #()

]

{ #category : 'Json' }
Object >> asJson [

	| stream gotError |
	stream := AppendStream on: String new.
	gotError := false.
	[
		self printJsonOn: stream.
	] on: (AlmostOutOfStack , AlmostOutOfStackError)  do: [:ex |
		gotError := true.
		ex return.
	].
	gotError ifTrue: [self error: 'Ran out of stack space (probably due to a recursive reference, which is not supported by Json).'].
	^stream contents.

]

{ #category : 'PetitParser converting' }
Object >> asParser [
	"Answer a parser accepting the receiving object."

	^ PPPredicateObjectParser expect: self

]

{ #category : 'Error Handling' }
Object >> cantPerform: aSelectorSymbol withArguments: anArray [
	"This method implements the default response when a message can't be performed
 with _perform:withArguments:.  It raises the rtErrCantPerform exception."
  | ex |
	aSelectorSymbol numArgs == anArray size ifTrue:[
     ^ self doesNotUnderstand: (Message selector: aSelectorSymbol arguments: anArray)
  ].
  (ex := ArgumentError new) _number: 2263; args: { aSelectorSymbol . self . anArray };
         details: 'wrong number of args for selector' .
  ^ ex signal .

]

{ #category : 'Error Handling' }
Object >> cantPerform: aSelectorSymbol withArguments: anArray env: envId [
  | ex |
  envId == 0 ifTrue:[
    ^ self cantPerform: aSelectorSymbol withArguments: anArray
  ].
  aSelectorSymbol numArgs == anArray size ifTrue:[
    (ex := MessageNotUnderstood _basicNew)
       receiver: self selector: aSelectorSymbol args: anArray envId: envId .
    ^ex signal .  "fix for #40871"
  ].
  (ex := ArgumentError new) _number: 2263;
         args: { aSelectorSymbol . self . anArray . envId };
         details: 'wrong number of args for selector' .
  ^ ex signal .

]

{ #category : 'Indexing Support' }
Object >> getDepListAndAddLastElementPathTerm: pathTerm logging: aBoolean [
  "Private."

  | depList depListClass dl |
  self isInvariant
    ifTrue: [ ^ self ].
  depListClass := DependencyList.
  dl := depListClass for: self.
  dl
    ifNil: [
      "reference counts are negative numbers"
      depList := depListClass new: 2.
      depList _basicAt: 1 put: pathTerm.
      depList _basicAt: 2 put: -1 ]
    ifNotNil: [ depList := dl copyAndAddLastElementPathTerm: pathTerm for: self ].
  depListClass set: (SharedDependencyLists at: depList logging: true) for: self

]

{ #category : 'Indexing Support' }
Object >> getDepListAndAddPathTerm: pathTerm withIVOffset: ivOffset logging: aBoolean [
  "Private."

  | depList depListClass dl |
  self isInvariant
    ifTrue: [ ^ self ].
  depListClass := DependencyList.
  dl := depListClass for: self.
  dl
    ifNil: [
      depList := depListClass new: 2.
      depList _basicAt: 1 put: pathTerm.
      depList _basicAt: 2 put: ivOffset ]
    ifNotNil: [ depList := dl copyAndAddPathTerm: pathTerm withIVOffset: ivOffset for: self ].
  depListClass set: (SharedDependencyLists at: depList logging: true) for: self

]

{ #category : 'PetitParser testing' }
Object >> isPetitFailure [
	^ false

]

{ #category : 'PetitParser testing' }
Object >> isPetitParser [
	^ false

]

{ #category : 'Json' }
Object >> jsonKeys [
	"Override this method to specify which instance variables to include.
	Note that calling super is probably not appropriate!"

	^self class allInstVarNames.

]

{ #category : 'Instance Migration' }
Object >> migrateFrom: anotherObject [

"Takes information from the given object and puts it in the receiver.
 This message is sent to an object when its class is being migrated to
 another class using migrate, but not when using migrateInstances:to:.
 To customize migration, the method migrateFrom:instVarMap: should be
 reimplemented in subclasses.

 Dynamic instVars in anotherObject preserved by default.

 Note: If the receiver is a kind of Bag or IdentityBag, then the receiver may
 have objects from anotherObject added to it."

^self migrateFrom: anotherObject
      instVarMap: (InstVarMappingArray mappingFrom: anotherObject class to: self class)

]

{ #category : 'Json' }
Object >> printJsonOn: aStream [

	| allInstVarNames keys delimiter |
	allInstVarNames := self class allInstVarNames.
	keys := self jsonKeys.
	delimiter := ''.
	aStream nextPut: ${.
	1 to: allInstVarNames size do: [:i |
		| ivarName |
		ivarName := allInstVarNames at: i.
		(keys includes: ivarName) ifTrue: [
			aStream nextPutAll: delimiter.
			ivarName printJsonOn: aStream.
			aStream nextPut: $:.
			(self instVarAt: i) printJsonOn: aStream.
			delimiter := ','.
		].
	].
	aStream nextPut: $}.

]

{ #category : 'Storing and Loading' }
Object >> storeString [

"Returns a string that, when evaluated, will recreate a copy of the
 receiver.  The default is to use storeOn: to create the description."

| stream |
stream := AppendStream on: String new .
self storeOn: stream.
^ stream contents

]
