Extension { #name : 'RcCollisionBucket' }

{ #category : 'Private' }
RcCollisionBucket >> _addToWriteSet [

"Make a benign modification to the receiver so that it is placed in
 the write set."

numElements := numElements

]

{ #category : 'Updating' }
RcCollisionBucket >> at: aKey put: aValue [

"Stores the aKey/aValue pair in the RcCollisionBucket.  If the key already
 exists, returns the old value, otherwise, returns nil.

 If the key already exists and the old value is identically aValue,
 does not write the receiver."

| emptySlotIndex startTableSize thisKey oldVal |
startTableSize := self tableSize .
aKey ifNil:[ ^ self _error: #rtErrNilKey ].

" search for aKey, or for the first empty slot "
1 to: startTableSize do: [ :index | | valIdx |
  valIdx := index + index .
  thisKey := self _at: (valIdx - 1) . "inline keyAt:"
  ( nil == emptySlotIndex and: [ nil == thisKey ] ) ifTrue:[
     emptySlotIndex := index
  ] ifFalse: [
    (self compareKey: aKey with: thisKey) ifTrue:[
       "Key found.  Store given value"
	oldVal := self _at: valIdx .  "inline valueAt:"
	oldVal == aValue ifFalse:[
	  self _rcAt: valIdx  .  "put path to value slot in rcReadSet"
	  self at: index putValue: aValue.
	].
	^ oldVal
     ]
  ]
] .

" key not found so add key and value"
emptySlotIndex ifNil:[
   " bucket is full so grow it "
   self size: (self _basicSize + 8 ) . "accommodate 4 more key,value pairs"
   emptySlotIndex := startTableSize + 1 .
] .
self _rcAt:( emptySlotIndex * 2) .  "put path to emptySlot in rcReadSet"
self _addNamedIvsToRcRead .  "for update of numElements"
numElements := numElements + 1.
self at: emptySlotIndex putKey: aKey.
self at: emptySlotIndex putValue: aValue.
^ nil

]

{ #category : 'Updating' }
RcCollisionBucket >> removeKey: aKey ifAbsent: aBlock [
  "Removes the key/value pair with key aKey from the receiver and returns the
   value.  If no key/value pair is present with key aKey, evaluates the
   zero-argument block aBlock and returns the result of that evaluation."

| startTableSize |
startTableSize := self tableSize .
aKey ifNil:[ ^ self _error: #rtErrNilKey ].

1 to: startTableSize do: [ :index | | valIdx thisKey |
  valIdx := index + index .
  thisKey := self _at: (valIdx - 1) . "inline keyAt:"
  thisKey ifNotNil:[
    (self compareKey: aKey with: thisKey) ifTrue:[ "Key found"  | aValue |
       aValue := self _rcAt: valIdx . "add path to value to rcReadSet"
       self _at: valIdx - 1  put: nil.
       self _at: valIdx put: nil.
       self _addNamedIvsToRcRead .  "for update of numElements"
       numElements := numElements - 1.
       ^ aValue
     ]
  ]
] .
aBlock ifNil:[ ^ self _errorKeyNotFound: aKey ] .
^ aBlock value
]

{ #category : 'Updating' }
RcCollisionBucket >> _replayRemoveKey: aKey [
"Removes the aKey/someValue pair from receiver.  
 returns nil if aKey found, false otherwise. "

| startTableSize thisKey |
startTableSize := self tableSize .
aKey ifNil:[ ^ self _error: #rtErrNilKey ].

" search for aKey, or for the first empty slot "
1 to: startTableSize do: [ :index | | valIdx |
  valIdx := index + index .
  thisKey := self _at: (valIdx - 1) . "inline keyAt:"
  thisKey ifNotNil:[
    (self compareKey: aKey with: thisKey) ifTrue:[ "Key found"
       self _at: valIdx - 1  put: nil.
       self _at: valIdx put: nil.
       numElements := numElements - 1.
       ^ true
     ]
  ]
] .
^ false
]

{ #category : 'Accessing' }
RcCollisionBucket >> keyAt: index [

"Returns the key at the specified index."

^ self _at: (index + index - 1)

]

{ #category : 'Updating' }
RcCollisionBucket >> reset [

  "Reset all entries to nil and the number of elements to zero.
   called from RcKeyValueDictionary >> _gciInitialize, not RC "
  self _deleteNoShrinkFrom: 1 to: self _basicSize.
  numElements := 0.

]

{ #category : 'Accessing' }
RcCollisionBucket >> valueAt: index [

"Returns the value at the specified index."

^ self _at: (index + index)

]
