"
Instances of SessionTemps may not be committed. The primary use of this class
 is via the class method #current, which returns an instance of SessionTemps
 that is stored in Transient Session State.

Partial list of keys in  SessionTemps current   used in the base GemStone image:
  #GsClass_logCreation
  #GsNMethod_AllIrs
  #ClassVariablesAssociationClass
  #Gemstone_GciTsLibrary_default
  #GsHostRandomFile
  #GsPackagePolicy_AuthorInitials
  #GsPackagePolicy_SessionMethodDictionary
  #GsRecompileValuesToKeys
  #GsTestCase_Random
  #gciLibrary
  #INDEX_MANAGER_AUTO_COMMIT
  #IcuCollator_AVAILABLE_COLLATORS
  #Module_pinnedClasses
  #OldLitVars
  #PPPredicateObjectParser_cache
  #TranscriptStream_SessionMutex
  #TranscriptStream_SessionStream
  #TransientSessionMethod_Behaviors
  #WaitForDebug

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
"
Class {
	#name : 'SessionTemps',
	#superclass : 'SymbolDictionary',
	#gs_options : [
		'instancesNonPersistent'
	],
	#category : nil
}

{ #category : 'Session Temporaries' }
SessionTemps class >> current [
^ (System __sessionStateAt: 1) ifNil:[
  System __sessionStateAt: 1 put: SessionTemps new .
  System __sessionStateAt: 1
].

]

{ #category : 'Updating' }
SessionTemps >> at: aSymbol put: aValue [
  ^ super _at: aSymbol putNoStub: aValue .

]

{ #category : 'Updating' }
SessionTemps >> increment: aSymbol [
  "Increment the value at the given symbol by 1. 
   If aSymbol not found as a key assume previous value was zero .
   Returns the SmallInteger value after increment."
  | assoc val |
  assoc := self associationAt: aSymbol otherwise: nil .
  assoc ifNil:[ ^ self at: aSymbol put: 1 ].
  val := assoc _value + 1 .
  assoc _value: val .
  ^ val
]

