"
Random is an abstract superclass of generators of random numbers, that is, 
a sequence of numbers that passes statistical tests of randomness. 

See the comment of each subclass for its properties and recommendations for its use. 
For short non-repeatable sequences with high-quality randomness, use HostRandom.
For repeatable (seeded) sequences where randomness requirements are not stringent, 
use Lag1MwcRandom. For long sequences of random numbers (repeatable or not), 
or when you need repeatable random n-tuples, use Lag25000CmwcRandom. 

For convenience, Random class accepts these messages to create instances of subclases:

    new
        Answers the singleton HostRandom. 

    seed: aSmallInteger
       Answers a Lag1MwcRandom with an initial seed generated from the 
       given SmallInteger


Once you have an instance of any subclass of Random, you can generate random numbers 
with these messages:

    float
        Answers a random Float in the range [0,1)

    floats: n
        Answers a collection of n random floats in the range [0,1)

    integer
        Answers a random non-negative 32-bit integer

    integers: n
        Answers a collection of n random non-negative 32-bit integers

    integerBetween: l and: h
        Answers a random integer in the given range

    integers: n between: l and: h
        Answers a collection of n random integers in the given range

    smallInteger
        Answer a random integer in the full SmallInteger range, [-2**60..2**60)

In most cases, you will want to create an instance of a Random subclass and use that 
instance to generate many random numbers. Creating multiple instances of Random 
subclasses and using each one only a few times is much more expensive. Care is needed 
when storing persistent instances of Random subclasses; see the documentation of each 
subclass for details.
"
Class {
	#name : 'Random',
	#superclass : 'Object',
	#category : nil
}
