"
SeededRandom is an abstract superclass of classes of generators of sequences of 
random numbers, with the property that a sequence of random numbers may be generated 
repeatedly by giving the same initial seed to the generator.

See also the class comments of Random and of my subclasses.

Instance creation methods to be sent to subclasses:

    new
        Answers a new generator which will by default be seeded from the host OS /dev/urandom

    seed: aSmallInteger
        Answers a new generator seeded with the given seed, which can be any SmallInteger. 
        Another generator of the same class created with the same seed will produce the 
        same sequence of random numbers.

Instance methods:

    seed: aSmallInteger
        Seeds the receiver from the given seed, which can be any SmallInteger.
        The subsequent random number sequence generated will be the same as if this 
        generator had been created with this seed.

    fullState
    fullState:
        The internal state of a generator is more than can be represented by a single SmallInteger. 
        These messages allow you to retrieve the full state of a generator at any time, and 
        to restore that state later.
        The random number sequence generated after the restoration of the state will be the same 
        as that generated after the retrieval of the state. You might, for instance, allow a 
        generator to get its initial state from /dev/urandom, then save this state so the 
        random sequence can be repeated later.
"
Class {
	#name : 'SeededRandom',
	#superclass : 'Random',
	#instVars : [
		'multiplier',
		'lag',
		'carry',
		'seeds',
		'index'
	],
	#category : nil
}
