"
Deprecated is used to signal methods that are deprecated.
See Object>>#deprecated: for suggested use.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
"
Class {
	#name : 'Deprecated',
	#superclass : 'Notification',
	#gs_reservedoop : '151041',
	#category : nil
}

{ #category : 'signaledException' }
Deprecated class >> deprecatedAction [

  "returns one of #ignore, #log, #logstack #error"

  ^ DeprecationEnabled ifNil:[ #ignore ]

]

{ #category : 'signaledException' }
Deprecated class >> doErrorOnDeprecated [
  "signal an error to the application when deprecated: is sent."

  DeprecationEnabled := #error

]

{ #category : 'signaledException' }
Deprecated class >> doLogOnDeprecated [
  "When deprecated: is sent, log the argument to a file."

  DeprecationEnabled := #log

]

{ #category : 'signaledException' }
Deprecated class >> doLogStackOnDeprecated [
  "When deprecated: is sent, log the argument and the call stack to a file."

  DeprecationEnabled := #logstack

]

{ #category : 'signaledException' }
Deprecated class >> doNothingOnDeprecated [
  "Sends of deprecated: will do nothing"

  DeprecationEnabled := nil

]

{ #category : 'signaledException' }
Deprecated class >> logFile [
  | key tmps |
  ((tmps := SessionTemps current) at: (key := #Deprecated_logFile) otherwise: nil) ifNotNil:[:f |
     f == #nil ifTrue:[ ^ nil ] ifFalse:[ ^ f ]
  ].
  self logFilePath ifNotNil:[:path|
    (GsFile openAppendOnServer: path) ifNotNil:[:f |
      tmps at: key put: f .
      ^ f
    ].
  ].
  tmps at: key put: #nil .
  ^ nil

]

{ #category : 'signaledException' }
Deprecated class >> logFilePath [
  | path key tmps |
  (path := (tmps := SessionTemps current) at: (key := #Deprecated_logFilePath) otherwise: nil) ifNotNil:[
    ^ path
  ].
 ^ [
    path := System gemLogPath .
    path size > 0 ifTrue:[ path add: $/ . ] .
    path add: 'Deprecated';  add: System gemProcessId asString; add: '.log' .
    tmps at: key put: path . "cache the path "
    path.
  ] onException: Error do:[:ex |
    ex return: nil
  ]

]

{ #category : 'signaledException' }
Deprecated >> defaultAction [

  DeprecationEnabled ifNil:[ "ignore" ]
    ifNotNil:[ :action |
       action == #'error' ifTrue: [ self _signalToDebugger ]
                    ifFalse:[ self recordStackToLog: action ]
    ]

]

{ #category : 'signaledException' }
Deprecated >> recordStackToLog: action [

 [ | eol string |
   action == #logstack ifTrue:[
     eol := '
    ' .
     (string := 'Deprecated method call at ' , DateAndTime now printStringWithRoundedSeconds)
       add: eol;
       add: self description ; add: eol .
       string add: (GsProcess stackReportToLevel: 20) ; lf .
   ] ifFalse:[
     string := self description . string lf
   ].
   self class logFile ifNotNil:[ :f|
     f nextPutAll: string; flush .
   ] ifNil:[
     GsFile gciLogServer: string
   ]
 ] onSynchronous: AbstractException do:[:ex |
    ex return: nil  "ignore the exception"
 ]

]
