Extension { #name : 'SimpleTestResource' }

{ #category : 'Private' }
SimpleTestResource class >> _preventAvailability [
		"Because we can run multiple sessions, we can get conflicts on a class instance variable.
		Use SessionTemps instead"

	^SessionTemps current
		at: self preventAvailabilityName
		otherwise: nil.

]

{ #category : 'Private' }
SimpleTestResource class >> _preventAvailability: anObject [

	SessionTemps current at: self preventAvailabilityName put: anObject

]

{ #category : 'accessing' }
SimpleTestResource class >> allowAvailability [
	^self _preventAvailability == nil

]

{ #category : 'utility' }
SimpleTestResource class >> preventAvailabilityDuring: aBlock [

	self _preventAvailability: false.
	^aBlock ensure: [self _preventAvailability: nil]

]

{ #category : 'Private' }
SimpleTestResource class >> preventAvailabilityName [

	^(self thisClass name , '_preventAvailability') asSymbol "in SessionTemps"

]

{ #category : 'accessing' }
SimpleTestResource class >> rawCurrentForTest [
	^self _current

]

{ #category : 'testing' }
SimpleTestResource >> hasRun [
	^hasRun

]

{ #category : 'testing' }
SimpleTestResource >> hasSetup [
	^hasSetup

]

{ #category : 'testing' }
SimpleTestResource >> isAvailable [
	^self class allowAvailability and:
		[self runningState == self startedStateSymbol]

]

{ #category : 'accessing' }
SimpleTestResource >> runningState [

	^runningState

]

{ #category : 'accessing' }
SimpleTestResource >> runningState: aSymbol [

	runningState := aSymbol

]

{ #category : 'running' }
SimpleTestResource >> setRun [
	hasRun := true

]

{ #category : 'running' }
SimpleTestResource >> setUp [

	self runningState: self startedStateSymbol.
	hasSetup := true

]

{ #category : 'running' }
SimpleTestResource >> startedStateSymbol [

	^#started

]

{ #category : 'running' }
SimpleTestResource >> stoppedStateSymbol [

	^#stopped

]

{ #category : 'running' }
SimpleTestResource >> tearDown [

	self runningState: self stoppedStateSymbol

]
