Extension { #name : 'Stream' }

{ #category : 'Private' }
Stream class >> _copyMethodsTo: destinationClass [

"copy instance methods, class methods , and class comment to the destination class"

"Copy class and instance methods"
 | status |
 status := String new .
 1 to: 2 do: [ :i | | srccls targcls cats |
   i == 1 ifTrue: [
     srccls := self.  targcls := destinationClass .
     status add:' source ' , self name,' ', self asOop asString,
            '  dest ', self asOop asString, ' ', destinationClass name.
   ] ifFalse: [
     srccls := self class.  targcls := destinationClass class
   ].
   srccls == targcls ifTrue:[Error signal:'sourceClass identical to targetClass'].
   targcls removeAllMethods .
   cats := srccls _unifiedCategorys: 0.
   cats keysAndValuesDo: [ :cat :sels |
     sels do: [ :sel |
        targcls compileMethod: (srccls sourceCodeAt: sel)
                dictionaries: GsCurrentSession currentSession symbolList
                category: cat
                environmentId: 0
     ]
   ]
 ].
 destinationClass comment: self commentForFileout.
 ^ status
]

{ #category : 'Private' }
Stream class >> _initializeStreamClassVars [
"set up classVars for methods in stream2.gs"
(self classVarAt: #Cr otherwise: nil) ifNil:[ | arr |
  arr := {
    #Lf . Character codePoint: 10 .
    #Tab . Character codePoint: 9 . }.
  1 to: arr size by: 2 do:[:j |
    self _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
  ].
  ^ 'added'
].
^ 'no change'

]

{ #category : 'Private' }
Stream class >> _initializeWriteStreamClassVars: aClass [
  "method used in filein of various WriteStream classes.
   Those classes inherit Lf and Tab classVars from Stream.
  "
  (aClass classVarAt: #Cr otherwise: nil) ifNil:[ | arr |
    arr := {
      #Cr . Character codePoint: 13 .
      #CrLf .  (String new add:(Character codePoint: 13);
                   add: (Character codePoint: 10); immediateInvariant
                  ; yourself ) .
      #CrTab .  (String new add:(Character codePoint: 13);
                   add: (Character codePoint: 9); immediateInvariant
                  ; yourself )   } .
    1 to: arr size by: 2 do:[:j |
      aClass _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
    ].
    ^ 'added'
  ].
  ^ 'no change'

]

{ #category : 'Portable Methods' }
Stream class >> installLegacyStreamImplementation [

(Globals at: #PositionableStream) isLegacyStreamImplementation
  ifTrue: [ ^ false ].
self installStreamImplementationFrom: (Globals at: #GemStone_Legacy_Streams).
^true

]

{ #category : 'Portable Methods' }
Stream class >> installPortableStreamImplementation [

(Globals at: #PositionableStream) isPortableStreamImplementation
  ifTrue: [ ^false ].
self installStreamImplementationFrom: (Globals at: #GemStone_Portable_Streams).
^true

]

{ #category : 'Portable Methods' }
Stream class >> installStreamImplementationFrom: aSymbolDictionary [
  "not used by filein nor image upgrade." 
  #( #PositionableStream #ReadStream #WriteStream #ReadByteStream ) do:[:key |
     Globals at: key put: (aSymbolDictionary at: key )
  ].
  "ReadWriteStream and FileStream defined in Portable implementation, but not in
   Legacy implementation"
  #( #ReadWriteStream #FileStream ) do:[:key |
     (aSymbolDictionary at: key otherwise: nil)
       ifNil: [ Globals removeKey: key otherwise:nil  ]
       ifNotNil: [:aClass | Globals at: key put: aClass  ].
  ].
  "recompile implementations of #readStream that reference ReadByteStream "
  { ByteArray . String . MultiByteString } do:[:cls |
    cls recompileMethodAt: #readStream  
  ].
]

{ #category : 'Portable Methods' }
Stream class >> isLegacyStreamImplementation [

self subclassResponsibility: #isLegacyStreamImplementation

]

{ #category : 'Portable Methods' }
Stream class >> isPortableStreamImplementation [

self subclassResponsibility: #isPortableStreamImplementation

]

{ #category : 'Fileout' }
Stream >> _fileOutAll: aString [

  ^ self nextPutAll: aString

]

{ #category : 'Private' }
Stream >> _nextPutAllBytes: aCharacterCollection [

^ self nextPutAllBytes: aCharacterCollection

]

{ #category : 'PetitParser-Core-Converting' }
Stream >> asPetitStream [
	^ self contents asPetitStream

]

{ #category : 'Testing' }
Stream >> atEnd [

"(Subclass responsibility.)  Returns true if the receiver cannot access any more
 objects, false if it can."

Stream subclassResponsibility: #atEnd

]

{ #category : 'ANSI' }
Stream >> close [
	"5.9.1.1

	If the receiver is a write-back stream update its stream backing store as if the message #flush was
	sent to the receiver. Then eliminate any association between the receiver and its stream backing
	store. Any system resources associated with the association should be released. The effect of
	sending any message to the receiver subsequent to this message is undefined."

]

{ #category : 'Adding' }
Stream >> cr [
"Adds a newline to the output stream. (NOT a carriage return)"
  self nextPut: Lf

]

{ #category : 'Enumerating' }
Stream >> do: aBlock [

"Evaluates the one-argument block aBlock for each of the remaining objects that
 the receiver can access."

[self atEnd]
  whileFalse: [aBlock value: self next]

]

{ #category : 'Testing' }
Stream >> isExternal [

"Returns true if the source of the receiver's information
 is external to the image, and false otherwise."

^false

]

{ #category : 'Testing' }
Stream >> isFull [

"Returns true if there is no more room in this stream.

 By default, always return false. "

^ false

]

{ #category : 'Adding' }
Stream >> lf [
  "Adds a newline to the output stream."
  self nextPut: Lf

]

{ #category : 'Accessing' }
Stream >> maxSize [

"Returns the maximum number of objects/bytes
 that this stream can hold.

 By default, return a large value."

^ 1000000000000

]

{ #category : 'Accessing' }
Stream >> next [

"(Subclass responsibility, ReadStream only.)  Returns the next object that the
 receiver can access for reading.  Generates an error if an attempt is made to
 read beyond the end of the stream."

Stream subclassResponsibility: #next

]

{ #category : 'Adding' }
Stream >> nextPut: anObject [

"(Subclass responsibility, WriteStream only.)  Inserts anObject as the next
 element that the receiver can access for writing.  Returns anObject."

Stream subclassResponsibility: #nextPut

]

{ #category : 'Adding' }
Stream >> nextPutAll: aCollection [

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection.  (WriteStream only.)"

aCollection accompaniedBy: self do: [:me :each | me nextPut: each].
^ aCollection

]

{ #category : 'Adding' }
Stream >> nextPutAllBytes: aCharacterCollection [

"(Subclass responsibility, WriteStream only.)  Inserts the byte contents of
 aCharacterCollection as the next elements that the receiver can
 access.  Returns aCharacterCollection."

Stream subclassResponsibility: #nextPutAllBytes:

]

{ #category : 'Adding' }
Stream >> space [

"Adds a space to the output stream."

self nextPut:  $    .


]

{ #category : 'Adding' }
Stream >> tab [
  "Adds a tab to the output stream."
  self nextPut: Tab

]
