Extension { #name : 'Class' }

{ #category : 'Traits' }
Class >> addClassTrait: aClassSideTrait [
	| traits |
	aClassSideTrait isClassTrait
		ifFalse: [ self error: 'addClassTrait: requires a class side trait argument'  ].
	traits := self _extraDictAt: #'classTraits'.
	traits
		ifNil: [ self _extraDictAt: #'classTraits' put: (traits := IdentitySet new) ].
	(traits includes: aClassSideTrait)
		ifFalse: [ 
			traits size = 1
				ifTrue: [ self error: 'Only one class side trait allowed per class' ].
			aClassSideTrait addDependent: self.
			traits add: aClassSideTrait ]
]

{ #category : 'Traits' }
Class >> addTrait: anInstanceSideTrait [
	| traits |
	anInstanceSideTrait isInstanceTrait
		ifFalse: [ self error: 'addTrait: requires an instance side trait argument'  ].
	traits := self _extraDictAt: #'traits'.
	traits ifNil: [ self _extraDictAt: #'traits' put: (traits := IdentitySet new) ].
	(traits includes: anInstanceSideTrait)
		ifFalse: [ 
			traits size = 1
				ifTrue: [ self error: 'Only one instance side trait allowed per class' ].
			anInstanceSideTrait addDependent: self.
			traits add: anInstanceSideTrait ]
]

{ #category : 'Traits' }
Class >> addInstanceAndClassTrait: anInstanceSideTrait [
	"Convenience for adding both instance-side and class-side of a Trait to a Class"
	self addTrait: anInstanceSideTrait.
	self addClassTrait: anInstanceSideTrait classTrait. 
]

{ #category : 'Traits' }
Class >> classTraits [
	^ (self _extraDictAt: #'classTraits') ifNil: [ #() ]
]

{ #category : 'Traits' }
Class >> classTraits: aString [
	| trait |
	trait := aString asString evaluate.
	trait isClassTrait
		ifFalse: [ 
			self
				error:
					'The expression ' , aString printString , ' must evaluate to a single class side Trait' ].
	self addClassTrait: trait
]

{ #category : 'Traits' }
Class >> removeClassTrait: aClassSideTrait [
	| traits |
	traits := self _extraDictAt: #'classTraits'.
	(traits isNil or: [ (traits includes: aClassSideTrait) not ])
		ifTrue: [ 
			self
				error:
					'The trait ' , aClassSideTrait printString , ' is not used by the receiver.' ].
	aClassSideTrait removeDependent: self.
	traits remove: aClassSideTrait
]

{ #category : 'Traits' }
Class >> removeTrait: anInstanceSideTrait [
	| traits |
	traits := self _extraDictAt: #'traits'.
	(traits isNil or: [ (traits includes: anInstanceSideTrait) not ])
		ifTrue: [ 
			self
				error:
					'The trait ' , anInstanceSideTrait printString , ' is not used by the receiver.' ].
	anInstanceSideTrait removeDependent: self.
	traits remove: anInstanceSideTrait
]

{ #category : 'Traits' }
Class >> traits [
	^ (self _extraDictAt: #'traits') ifNil: [ #() ]
]

{ #category : 'Traits' }
Class >> traits: aString [
	|  trait |
	trait := aString asString evaluate.
	trait isInstanceTrait
		ifFalse: [ 
			self
				error:
					'The expression ' , aString printString , ' must evaluate to a single instance side Trait' ].
	self addTrait: trait
]
