"
A ClassTrait provides the class-side trait behavior of a Trait. Once a Trait is 
created, you can get the associated ClassTrait using Trait >> classTrait.

See the class comment for Trait for more information.
"
Class {
	#name : 'ClassTrait',
	#superclass : 'AbstractTrait',
	#instVars : [
		'instanceTrait'
	],
	#category : nil
}

{ #category : 'instance creation' }
ClassTrait class >> trait: aTraitImpl instance: instanceTrait [
	^ self new
		traitImpl: aTraitImpl;
		instanceTrait: instanceTrait;
		yourself
]

{ #category : 'browser methods' }
ClassTrait >> _categoryOfSelector: selector [
	"Returns the category of the given selector, or 'unknown' if it isn't found."

	^ self traitImpl _categoryOfSelectorForClassTrait: selector
]

{ #category : 'browser methods' }
ClassTrait >> _selectorsReport: envId matching: aString primitivesOnly: primsBoolean includeDeprecated: inclDeprecBool [
	"Used by topaz (and GBS?).
  Result is a sorted SequenceableCollection  of Symbols, plus an optional string 'Omitted .. deprecated methods'.
  aString if not nil restricts the result to only include those selectors containing
  the case-insensitive substring aString .
  primsBoolean if true further restricts the result to only include only
  selectors of methods which are primitives."

	^ self traitImpl
		_selectorsReportForClassSide: true
		selectors: self localSelectors
		matching: aString
		primitivesOnly: primsBoolean
		includeDeprecated: inclDeprecBool
]

{ #category : 'browser methods' }
ClassTrait >> _topazMethodAt: aString [
	"Returns a GsNMethod, or signals an Error."

	^ self traitImpl _classTopazMethodAt: aString
]

{ #category : 'accessing' }
ClassTrait >> addDependent: aClass [
	self traitImpl addClassDependent: aClass
]

{ #category : 'Formatting' }
ClassTrait >> asString [

^ self name asString, ' classTrait'
]

{ #category : 'browser methods' }
ClassTrait >> categoriesDo: aBlock [
	self traitImpl _classCategoriesDo: aBlock
]

{ #category : 'browser methods' }
ClassTrait >> categoryOfSelector: selector [
	"Returns the category of the given selector, or nil if it isn't found."

	^ self traitImpl categoryOfSelectorForClassTrait: selector
]

{ #category : 'compiling' }
ClassTrait >> compile: sourceString [
	^self traitImpl compileClassMethod: sourceString
]

{ #category : 'compiling' }
ClassTrait >> compile: sourceString category: aCategoryString [
	^ self traitImpl compileClassMethod: sourceString category: aCategoryString
]

{ #category : 'browser methods' }
ClassTrait >> includesSelector: aString [
	^ self traitImpl _includesSelectorForClassTrait: aString
]

{ #category : 'accessing' }
ClassTrait >> instanceTrait [
	^instanceTrait
]

{ #category : 'accessing' }
ClassTrait >> instanceTrait: object [
	instanceTrait := object
]

{ #category : 'accessing' }
ClassTrait >> instVarNames [
	^ self traitImpl classInstVarNames
]

{ #category : 'testing' }
ClassTrait >> isClassTrait [
	"Answer true if the receiver is a Class Trait instance"
	^ true
]

{ #category : 'testing' }
ClassTrait >> isInstanceTrait [
	"Answer true if the receiver is an instance side Trait"
	^ false
]

{ #category : 'accessing' }
ClassTrait >> localSelectors [
	^ self traitImpl classSelectors
]

{ #category : 'updating' }
ClassTrait >> objectSecurityPolicy: anObjectSecurityPolicy [
	"Assigns the receiver and subcomponents to the given security policy."

	super objectSecurityPolicy: anObjectSecurityPolicy.
]

{ #category : 'updating' }
ClassTrait >> removeAllMethods [
	self traitImpl removeAllClassSelectors
]

{ #category : 'updating' }
ClassTrait >> removeDependent: aClass [

	self traitImpl removeClassDependent: aClass
]

{ #category : 'updating' }
ClassTrait >> removeDependentOnly: aClass [
	"remove the dependent, but leave the trait methods in aClass"

	self traitImpl removeClassDependentOnly: aClass
]

{ #category : 'updating' }
ClassTrait >> removeSelector: aString [
	self traitImpl removeClassSelector: aString
]

{ #category : 'accessing' }
ClassTrait >> sourceCodeAt: selectorSymbol [
	^ self traitImpl classSourceCodeAt: selectorSymbol
]
