"
GsEventLogEntry represents a single entry in a GsEventLog. Instances of GsEventLogEntry are user 
or application-specific events. 
By default, GsEventLogEntries are modifiable.  They can be made invariant in which case they are 
not deleted by default protocol.
It is supported to create custom subclasses with additional fields or different behavior.

GsEventLogEntries have the following fields:

 pid - SmallInteger, the processId of the session that created this entry
 timestamp - DateAndTime, the timestamp that this event was created.
 label - String, a string describing this entry
 priority - SmallInteger (required), the priority, see Class methods errorPrioity, warningPriority, etc.
 object - any object
 tag - any symbol
"
Class {
	#name : 'GsEventLogEntry',
	#superclass : 'Object',
	#instVars : [
		'pid',
		'timestamp',
		'label',
		'priority',
		'object',
		'tag'
	],
	#category : nil
}
