"
GsSingleRefPathFinderForObject holds the state of a reference path search for one
search object.  It has the following instance variables:

completed - A Boolean indicating if the search for searchOop has finished.
True if the reference path was found or if the object was
determined to be dead.

isDead - A Boolean indicating if the object is unreachable and eligible for
garbage collection.

refPathFinder - Reference to the instance of GsSingleRefPathFinder that created
this object.

limitOopsFound - a GsBitmap containing the objects in the limit set which can
be traversed to reach searchOop.

searchOopsUnion - a GsBitmap containing all objects already searched for in
this reference path scan.

searchOop - the object for which the reference path is to be found.

resultObject - an instance of GsSingleRefPathResult which contains the
reference path to searchOop.

parentBitmaps - an Array of GsBitmaps which contain ancestors of searchOop.

"
Class {
	#name : 'GsSingleRefPathFinderForObject',
	#superclass : 'Object',
	#instVars : [
		'completed',
		'isDead',
		'refPathFinder',
		'limitOopsFound',
		'searchOopsUnion',
		'searchOop',
		'resultObject',
		'parentBitmaps'
	],
	#category : nil
}
