Extension { #name : 'BtreeComparisonForUnicodeSort' }

{ #category : 'initialization' }
BtreeComparisonForUnicodeSort >> collator: anIcuCollator [
  collator := anIcuCollator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeSort >> compareKey: aKey equalTo: aValue [
  ^ aKey _idxForSortEqualTo: aValue collator: collator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeSort >> compareKey: aKey greaterThan: aValue [
  ^ aKey _idxForSortGreaterThan: aValue collator: collator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeSort >> compareKey: aKey greaterThanOrEqualTo: aValue [
  ^ aKey _idxForSortGreaterThanOrEqualTo: aValue collator: collator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeSort >> compareKey: aKey lessThan: aValue [
  ^ aKey _idxForSortLessThan: aValue collator: collator

]

{ #category : 'Comparison Operators' }
BtreeComparisonForUnicodeSort >> compareKey: aKey lessThanOrEqualTo: aValue [
  ^ aKey _idxForSortLessThanOrEqualTo: aValue collator: collator

]

{ #category : 'Testing' }
BtreeComparisonForUnicodeSort >> satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2 [
  ^ ((val1 _idxForCompareGreaterThan: val2 collator: collator)
    or: [
      (val1 _idxForSortEqualTo: val2 collator: collator)
        and: [ (bool1 and: [ bool2 ]) not ] ])
    not

]
