Extension { #name : 'BtreeComparisonQuerySpec' }

{ #category : 'Instance Creation' }
BtreeComparisonQuerySpec class >> key: aKey selector: aSelector [

^self new key: aKey selector: aSelector

]

{ #category : 'Querying' }
BtreeComparisonQuerySpec >> _addRootObjectsFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection [
  | sel |
  sel := self performSelector: opCode.
  startIndex to: endIndex by: entrySize do: [ :i |
    (self compare: (aLeafNode keyAt: i) using: sel)
      ifTrue: [ collection add: (aLeafNode rootObjectAt: i) ] ]

]

{ #category : 'Querying' }
BtreeComparisonQuerySpec >> _addValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection [
  | sel |
  sel := self performSelector: opCode.
  startIndex to: endIndex by: entrySize do: [ :i |
    (self compare: (aLeafNode _basicAt: i + 1) using: sel)
      ifTrue: [ collection add: (aLeafNode _basicAt: i) ] ]

]

{ #category : 'Querying' }
BtreeComparisonQuerySpec >> _traverseValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex previous: previousValue into: collection [
  | val prevVal aKey sel |
  sel := self performSelector: opCode.
  prevVal := previousValue.
  startIndex to: endIndex by: entrySize do: [ :i |
    aKey := aLeafNode _basicAt: i + 1.
    val := aLeafNode _basicAt: i.
    ((self compare: aKey using: sel) and: [ val ~~ prevVal ])
      ifTrue: [
        rangeIndex
          _addAllFor: val
          into: collection
          offset: offset
          pathTerm: pathTerm ].
    prevVal := val ].
  ^ prevVal

]

{ #category : 'Accessing' }
BtreeComparisonQuerySpec >> collator [
  ^ nil

]

{ #category : 'Accessing' }
BtreeComparisonQuerySpec >> collator: ignored [
  "ignored"



]

{ #category : 'Comparing' }
BtreeComparisonQuerySpec >> compare: entry using: selector [
  ^ entry perform: selector with: key

]

{ #category : 'Comparing' }
BtreeComparisonQuerySpec >> compareKey: entry [
  ^ entry perform: (self performSelector: opCode) with: key

]

{ #category : 'Updating' }
BtreeComparisonQuerySpec >> key: aKey selector: aSelector [

key := aKey.
opCode := self operationSelectors indexOf: aSelector.

]

{ #category : 'Accessing' }
BtreeComparisonQuerySpec >> operationSelectors [

"Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation integer for each predicate entry in the receiver."

^ #( #< #> #= #== #<= #>= #~= #~~)

]

{ #category : 'Accessing' }
BtreeComparisonQuerySpec >> performSelector: anOpCode [

^self performSelectors at: anOpCode

]

{ #category : 'Accessing' }
BtreeComparisonQuerySpec >> performSelectors [

"Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

^ #( #_idxForCompareLessThan:
    #_idxForCompareGreaterThan:
    #_idxForCompareEqualTo:
    #==
    #_idxForCompareLessThanOrEqualTo:
    #_idxForCompareGreaterThanOrEqualTo:
    #_idxForCompareNotEqualTo:
    #~~
  )

]
