Extension { #name : 'BtreePlusComparisonQuerySpec' }

{ #category : 'Instance Creation' }
BtreePlusComparisonQuerySpec class >> key: aKey selector: aSelector [

^self new key: aKey selector: aSelector

]

{ #category : 'Querying' }
BtreePlusComparisonQuerySpec >> _addRootObjectsFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection [
  (self optimizingComparison and: [ self canUseOptimizedComparison ])
    ifTrue: [ startIndex to: endIndex by: entrySize do: [ :i | collection add: (aLeafNode rootObjectAt: i) ] ]
    ifFalse: [ startIndex to: endIndex by: entrySize do: [ :i | (self compare: (aLeafNode keyAt: i) using: selector)
          ifTrue: [ collection add: (aLeafNode rootObjectAt: i) ] ] ]

]

{ #category : 'Querying' }
BtreePlusComparisonQuerySpec >> _addValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection [
  self shouldNotImplement: #'_addValuesFrom:entrySize:start:end:into:'

]

{ #category : 'Querying' }
BtreePlusComparisonQuerySpec >> _traverseValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex previous: previousValue into: collection [
  self shouldNotImplement: #'_traverseValuesFrom:entrySize:start:end:previous:into:'

]

{ #category : 'Testing' }
BtreePlusComparisonQuerySpec >> canUseOptimizedComparison [

  ^ #( #< #> #= #<= #>= ) includes: selector

]

{ #category : 'Accessing' }
BtreePlusComparisonQuerySpec >> collator [
  ^ nil

]

{ #category : 'Accessing' }
BtreePlusComparisonQuerySpec >> collator: ignored [
  "ignored"



]

{ #category : 'Comparing' }
BtreePlusComparisonQuerySpec >> compare: entry using: sel [
  ^ entry perform: sel with: key

]

{ #category : 'Comparing' }
BtreePlusComparisonQuerySpec >> compareKey: entry [
  ^ entry perform: selector with: key

]

{ #category : 'Updating' }
BtreePlusComparisonQuerySpec >> key: aKey selector: aSelector [
  key := aKey.
  self optimizingComparison
    ifTrue: [ selector := aSelector ]
    ifFalse: [ opCode := self operationSelectors indexOf: aSelector.
      selector := self performSelector: opCode ]

]

{ #category : 'Accessing' }
BtreePlusComparisonQuerySpec >> operationSelectors [

"Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation integer for each predicate entry in the receiver."

^ #( #< #> #= #== #<= #>= #~= #~~)

]

{ #category : 'Accessing' }
BtreePlusComparisonQuerySpec >> optimizedUnicodeStringPerformSelectors [
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the optimized operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'_idxForCompareEqualTo:collator:' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'_idxForCompareNotEqualTo:collator:' #'~~')

]

{ #category : 'Accessing' }
BtreePlusComparisonQuerySpec >> optimizedUnicodeSymbolPerformSelectors [
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the optimized operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'==' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'~~' #'~~')

]

{ #category : 'Testing' }
BtreePlusComparisonQuerySpec >> optimizingComparison [
  "Answer true if the receiver is optimizing comparisons"

  rangeIndex ifNil: [ ^ false ].
  ^ optimizingComparison

]

{ #category : 'Accessing' }
BtreePlusComparisonQuerySpec >> performSelector: anOpCode [

^self performSelectors at: anOpCode

]

{ #category : 'Accessing' }
BtreePlusComparisonQuerySpec >> performSelectors [

"Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

^ #( #_idxForCompareLessThan:
    #_idxForCompareGreaterThan:
    #_idxForCompareEqualTo:
    #==
    #_idxForCompareLessThanOrEqualTo:
    #_idxForCompareGreaterThanOrEqualTo:
    #_idxForCompareNotEqualTo:
    #~~
  )

]

{ #category : 'Updating' }
BtreePlusComparisonQuerySpec >> rangeIndex: aGsRangeOrIdenityIndex [
  "needed to know whether or not to optimize comparisons"

  rangeIndex := aGsRangeOrIdenityIndex.
  optimizingComparison := rangeIndex optimizingComparison

]

{ #category : 'Accessing' }
BtreePlusComparisonQuerySpec >> unicodePerformSelector: anOpCode [
  ^ rangeIndex constraintType == #'symbol'
      ifTrue: [ self optimizedUnicodeSymbolPerformSelectors at: anOpCode ]
      ifFalse: [
        rangeIndex constraintType == #'string'
          ifTrue: [ self optimizedUnicodeStringPerformSelectors at: anOpCode ]
          ifFalse: [
            "rangeIndex constraintType == #unicodeString or nil"
            self performSelector: anOpCode ] ]

]
