Extension { #name : 'BtreePlusInteriorKeyValueNode' }

{ #category : 'Constants' }
BtreePlusInteriorKeyValueNode class >> entrySize [
  "Returns the size of an entry."

  "in-lined on instance-side for performance"

  ^ 2

]

{ #category : 'Constants' }
BtreePlusInteriorKeyValueNode class >> maxNumberOfElements [
  "Returns the number of entries that are allowed in an interior node."

  ^ 1014

]

{ #category : 'Updating' }
BtreePlusInteriorKeyValueNode >> _insertKey: aKey value: newPredecessorNode atIndex: insertionIndex [
  "Insert the key/value pair in the receiver.  The sender of this message must
verify that the entry will fit in the receiver and provide the insertion
index."

  | endIndex entrySize |
  entrySize := self entrySize.
  endIndex := numElements * entrySize.

  " newPredecessorNode node is being inserted in front of node at insertionIndex, update the previous/next leaf values for both nodes"
  (self at: insertionIndex)
    ifNil: [
      insertionIndex > 1
        ifTrue: [
          | previousNode |
          previousNode := self at: insertionIndex - entrySize.
          newPredecessorNode
            _updateLeafNodeLinksForNewPreviousLeaf:  previousNode
            newNextLeaf: previousNode nextLeaf ] ]
    ifNotNil: [:formerPredecessorNode |
      formerPredecessorNode
        _updateLeafNodeLinksForNewPreviousLeaf: newPredecessorNode
        newNextLeaf: formerPredecessorNode nextLeaf ].

  self _insertAt: insertionIndex
       value: newPredecessorNode value: aKey
       numToMoveDown: endIndex - insertionIndex + 1 .

  numElements := numElements + 1



]

{ #category : 'Updating' }
BtreePlusInteriorKeyValueNode >> _insertKey: aKey value: newPredecessorNode atIndex: insertionIndex  selectiveAbortSet: selectiveAbortSetOrNil [
  "Insert the key/value pair in the receiver.  The sender of this message must
verify that the entry will fit in the receiver and provide the insertion
index."

  | endIndex entrySize |
  entrySize := self entrySize.
  endIndex := numElements * entrySize.

  " newPredecessorNode node is being inserted in front of node at insertionIndex, update the previous/next leaf values for both nodes"
  (self at: insertionIndex)
    ifNil: [
      insertionIndex > 1
        ifTrue: [
          | previousNode |
          previousNode := self at: insertionIndex - entrySize.
          self _selectiveAbort: previousNode ifNotIn: selectiveAbortSetOrNil.
          newPredecessorNode
            _updateLeafNodeLinksForNewPreviousLeaf:  previousNode
            newNextLeaf: previousNode nextLeaf
            selectiveAbortSet: selectiveAbortSetOrNil ] ]
    ifNotNil: [:formerPredecessorNode |
      self _selectiveAbort: formerPredecessorNode ifNotIn: selectiveAbortSetOrNil.
      formerPredecessorNode
        _updateLeafNodeLinksForNewPreviousLeaf: newPredecessorNode
        newNextLeaf: formerPredecessorNode nextLeaf
        selectiveAbortSet: selectiveAbortSetOrNil ].

  self _insertAt: insertionIndex
       value: newPredecessorNode value: aKey
       numToMoveDown: endIndex - insertionIndex + 1 .

  numElements := numElements + 1



]

{ #category : 'Updating' }
BtreePlusInteriorKeyValueNode >> _insertKey: aKey value: aValue root: ignored atIndex: insertionIndex [

"Insert the key/value pair in the receiver.  The sender of this message must
verify that the entry will fit in the receiver and provide the insertion
index."

self _insertKey: aKey value: aValue atIndex: insertionIndex

]

{ #category : 'Updating' }
BtreePlusInteriorKeyValueNode >> _insertKey: aKey value: aValue root: ignored atIndex: insertionIndex selectiveAbortSet: selectiveAbortSetOrNil [

"Insert the key/value pair in the receiver.  The sender of this message must
verify that the entry will fit in the receiver and provide the insertion
index."

self _insertKey: aKey value: aValue atIndex: insertionIndex selectiveAbortSet: selectiveAbortSetOrNil

]

{ #category : 'Updating' }
BtreePlusInteriorKeyValueNode >> at: aKey put: aValue root: ignored [
  "Adds the key/value/root tuple to one of the leaf nodes.  If a split occurs, returns
   the new sibling, otherwise returns the receiver."

  ^ super at: aKey put: aValue root: nil

]

{ #category : 'Rc Updating' }
BtreePlusInteriorKeyValueNode >> at: aKey put: aValue root: ignored selectiveAbortSet: selectiveAbortSetOrNil [
  "Adds the key/value/root pair to the node.  If the node is full, performs a 'split'
 on the parent.  Returns the new sibling if a split is performed, otherwise
 returns the receiver."

  ^ super at: aKey put: aValue root: nil selectiveAbortSet: selectiveAbortSetOrNil

]

{ #category : 'Searching' }
BtreePlusInteriorKeyValueNode >> binarySearchCoveringKey: aKey value: aValue root: ignored [
  "Returns the index for the entry in which aKey/aValue would be inserted.  This
 is the first entry which has its key >= aKey.  If multiple entries have the
 same key (key = aKey), then aValue is used (since entries with duplicate keys
 are inserted by the value's OOP ordering).  If multiple entries have the same value
 (value = aValue), then rootObject is used (since entries with duplicate values are
 inserted by the rootObject's OOP ordering). If the receiver is empty, returns
 1.  Uses a binary search."

  ^ self binarySearchCoveringKey: aKey value: aValue

]

{ #category : 'Comparison Operators' }
BtreePlusInteriorKeyValueNode >> compareValueOop: aValue greaterThanEntryValueOopAt: keyIndex root: ignored [
  "Perform a > comparison between the oop of aValue and oop of the entry whose value is
   at the given index."

  ^ self compareValueOop: aValue greaterThanEntryValueOopAt: keyIndex

]

{ #category : 'Comparison Operators' }
BtreePlusInteriorKeyValueNode >> compareValueOop: aValue greaterThanEntryValueOopAt: keyIndex root: ignored selectiveAbortSet: selectiveAbortSetOrNil [
  "Perform a > comparison between the oop of aValue and oop of the entry whose value is
   at the given index."

  ^ self compareValueOop: aValue greaterThanEntryValueOopAt: keyIndex selectiveAbortSet: selectiveAbortSetOrNil

]

{ #category : 'Comparison Operators' }
BtreePlusInteriorKeyValueNode >> compareValueOop: aValue lessThanOrEqualToEntryValueOopAt: keyIndex root: ignored [
  "Perform a <= comparison between the oop of aValue and oop of the entry whose value is
   at the given index."

  ^ self compareValueOop: aValue lessThanOrEqualToEntryValueOopAt: keyIndex

]

{ #category : 'Comparison Operators' }
BtreePlusInteriorKeyValueNode >> compareValueOop: aValue lessThanOrEqualToEntryValueOopAt: keyIndex root: ignored selectiveAbortSet: selectiveAbortSetOrNil [
  "Perform a <= comparison between the oop of aValue and oop of the entry whose value is
   at the given index."

  ^ self compareValueOop: aValue lessThanOrEqualToEntryValueOopAt: keyIndex selectiveAbortSet: selectiveAbortSetOrNil

]

{ #category : 'Constants' }
BtreePlusInteriorKeyValueNode >> entrySize [
  "Returns the size of an entry."

  "in-line of `self class entrySize` for performance"

  ^ 2

]

{ #category : 'Accessing' }
BtreePlusInteriorKeyValueNode >> rootIndexOffset [
  "Answer the offset from entry index for the root object. Typical order is value/key/root.
   The key and root object is the same for the receiver. The root object is not updated."

  ^ 1

]

{ #category : 'Updating' }
BtreePlusInteriorKeyValueNode >> updateLastChildRoot: lastChildRoot at: index [

  " Update the root object for receiver, if last child root has changed "

  "the root object is not updated ... as it is not recorded in the receiver "

]
