Extension { #name : 'BtreePlusInteriorKeyValueRootObjectNode' }

{ #category : 'Constants' }
BtreePlusInteriorKeyValueRootObjectNode class >> entrySize [
  "Returns the size of an entry."

  "in-lined on instance-side for performance"

  ^ 3

]

{ #category : 'Constants' }
BtreePlusInteriorKeyValueRootObjectNode class >> maxNumberOfElements [
  "Returns the number of entries that are allowed in an interior node."

  ^ 676

]

{ #category : 'Updating' }
BtreePlusInteriorKeyValueRootObjectNode >> _insertKey: aKey value: newPredecessorNode root: rootObject atIndex: insertionIndex [
  "Insert the key/value pair in the receiver.  The sender of this message must
verify that the entry will fit in the receiver and provide the insertion
index."

  | endIndex entrySize |
  entrySize := self entrySize.
  endIndex := numElements * entrySize.

  " newPredecessorNode node is being inserted in front of node at insertionIndex,
    update the previous/next leaf values for both nodes --- only applies to leaf nodes"
  newPredecessorNode isLeaf
    ifTrue: [
      (self at: insertionIndex )
        ifNil: [
          insertionIndex > 1
            ifTrue: [
              | previousNode |
              previousNode := self at: insertionIndex - entrySize.
              newPredecessorNode
                _updateLeafNodeLinksForNewPreviousLeaf:   previousNode
                newNextLeaf: previousNode nextLeaf ] ]
        ifNotNil: [:formerPredecessorNode |
          formerPredecessorNode
            _updateLeafNodeLinksForNewPreviousLeaf: newPredecessorNode
            newNextLeaf: formerPredecessorNode nextLeaf ] ].

  self _insertAt: insertionIndex
       value: newPredecessorNode value: aKey value: rootObject
       numToMoveDown: endIndex - insertionIndex + 1.

  numElements := numElements + 1


]

{ #category : 'Updating' }
BtreePlusInteriorKeyValueRootObjectNode >> _insertKey: aKey value: newPredecessorNode root: rootObject atIndex: insertionIndex selectiveAbortSet: selectiveAbortSetOrNil [
  "Insert the key/value pair in the receiver.  The sender of this message must
verify that the entry will fit in the receiver and provide the insertion
index."

  | endIndex entrySize |
  entrySize := self entrySize.
  endIndex := numElements * entrySize.

  " newPredecessorNode node is being inserted in front of node at insertionIndex, update the previous/next leaf values for both nodes"
  (self at: insertionIndex)
    ifNil: [
      insertionIndex > 1
        ifTrue: [
          | previousNode |
          previousNode := self at: insertionIndex - entrySize.
          self _selectiveAbort: previousNode ifNotIn: selectiveAbortSetOrNil.
          newPredecessorNode
            _updateLeafNodeLinksForNewPreviousLeaf: previousNode
            newNextLeaf: previousNode nextLeaf
            selectiveAbortSet: selectiveAbortSetOrNil ] ]
    ifNotNil: [:formerPredecessorNode |
      self _selectiveAbort: formerPredecessorNode ifNotIn: selectiveAbortSetOrNil.
      formerPredecessorNode
        _updateLeafNodeLinksForNewPreviousLeaf: newPredecessorNode
        newNextLeaf: formerPredecessorNode nextLeaf
        selectiveAbortSet: selectiveAbortSetOrNil ].

  self _insertAt: insertionIndex
       value: newPredecessorNode value: aKey value: rootObject
       numToMoveDown: endIndex - insertionIndex + 1.

  numElements := numElements + 1


]

{ #category : 'Comparison Operators' }
BtreePlusInteriorKeyValueRootObjectNode >> compareValueOop: aValue greaterThanEntryValueOopAt: keyIndex root: aRootObject [
  "Perform a > comparison between the oop of aValue and oop of the entry whose value is
   at the given index. If the value oops are equal, compare the oop of aRootObject and the
   oop of the root object at the given index."

  | entryValue entryValueLastValue |
  entryValue := self at: keyIndex - self keyIndexOffset.
  entryValueLastValue := entryValue lastValue.
  "aValue asOop = entryValueLastValue asOop"
  aValue == entryValueLastValue
    ifTrue: [ ^ aRootObject asOop > entryValue lastRoot asOop ].
  ^ aValue asOop > entryValueLastValue asOop

]

{ #category : 'Comparison Operators' }
BtreePlusInteriorKeyValueRootObjectNode >> compareValueOop: aValue greaterThanEntryValueOopAt: keyIndex root: aRootObject selectiveAbortSet: selectiveAbortSetOrNil [
  "Perform a > comparison between the oop of aValue and oop of the entry whose value is
   at the given index. If the value oops are equal, compare the oop of aRootObject and the
   oop of the root object at the given index."

  | entryValue entryValueLastValue |
  entryValue := self at: keyIndex - self keyIndexOffset.
  self _selectiveAbort: entryValue ifNotIn: selectiveAbortSetOrNil.
  entryValueLastValue := entryValue lastValue.
  "aValue asOop = entryValueLastValue asOop"
  aValue == entryValueLastValue
    ifTrue: [ ^ aRootObject asOop > entryValue lastRoot asOop ].
  ^ aValue asOop > entryValueLastValue asOop

]

{ #category : 'Comparison Operators' }
BtreePlusInteriorKeyValueRootObjectNode >> compareValueOop: aValue lessThanOrEqualToEntryValueOopAt: keyIndex root: aRootObject [
  "Perform a <= comparison between the oop of aValue and oop of the entry whose value is
   at the given index. If the value oops are equal, compare the oop of aRootObject and the
   oop of the root object at the given index."

  | entryValue entryValueLastValue |
  entryValue := self at: keyIndex - self keyIndexOffset.
  entryValueLastValue := entryValue lastValue.
  "aValue asOop = entryValueLastValue asOop"
  aValue == entryValueLastValue
    ifTrue: [ ^ aRootObject asOop <= entryValue lastRoot asOop ].
  ^ aValue asOop < entryValueLastValue asOop

]

{ #category : 'Comparison Operators' }
BtreePlusInteriorKeyValueRootObjectNode >> compareValueOop: aValue lessThanOrEqualToEntryValueOopAt: keyIndex root: aRootObject selectiveAbortSet: selectiveAbortSetOrNil [
  "Perform a <= comparison between the oop of aValue and oop of the entry whose value is
   at the given index. If the value oops are equal, compare the oop of aRootObject and the
   oop of the root object at the given index."

  | entryValue entryValueLastValue |
  entryValue := self at: keyIndex - self keyIndexOffset.
  self _selectiveAbort: entryValue ifNotIn: selectiveAbortSetOrNil.
  entryValueLastValue := entryValue lastValue.
  "aValue asOop = entryValueLastValue asOop"
  aValue == entryValueLastValue
    ifTrue: [ ^ aRootObject asOop <= entryValue lastRoot asOop ].
  ^ aValue asOop < entryValueLastValue asOop

]

{ #category : 'Constants' }
BtreePlusInteriorKeyValueRootObjectNode >> entrySize [
  "Returns the size of an entry."

  "in-line of `self class entrySize` for performance"

  ^ 3

]
